# Volatility
# Copyright (c) 2008-2013 Volatility Foundation
#
# This file is part of Volatility.
#
# Volatility is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Volatility is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Volatility.  If not, see <http://www.gnu.org/licenses/>.
#

"""
@author:       MHL
@license:      GNU General Public License 2.0
@contact:      michael.ligh@mnin.org

This file provides support for Windows 7 SP0 and SP1 x64.
"""

syscalls = [
    [
    'NtMapUserPhysicalPagesScatter', # 0x0
    'NtWaitForSingleObject', # 0x1
    'NtCallbackReturn', # 0x2
    'NtReadFile', # 0x3
    'NtDeviceIoControlFile', # 0x4
    'NtWriteFile', # 0x5
    'NtRemoveIoCompletion', # 0x6
    'NtReleaseSemaphore', # 0x7
    'NtReplyWaitReceivePort', # 0x8
    'NtReplyPort', # 0x9
    'NtSetInformationThread', # 0xa
    'NtSetEvent', # 0xb
    'NtClose', # 0xc
    'NtQueryObject', # 0xd
    'NtQueryInformationFile', # 0xe
    'NtOpenKey', # 0xf
    'NtEnumerateValueKey', # 0x10
    'NtFindAtom', # 0x11
    'NtQueryDefaultLocale', # 0x12
    'NtQueryKey', # 0x13
    'NtQueryValueKey', # 0x14
    'NtAllocateVirtualMemory', # 0x15
    'NtQueryInformationProcess', # 0x16
    'NtWaitForMultipleObjects32', # 0x17
    'NtWriteFileGather', # 0x18
    'NtSetInformationProcess', # 0x19
    'NtCreateKey', # 0x1a
    'NtFreeVirtualMemory', # 0x1b
    'NtImpersonateClientOfPort', # 0x1c
    'NtReleaseMutant', # 0x1d
    'NtQueryInformationToken', # 0x1e
    'NtRequestWaitReplyPort', # 0x1f
    'NtQueryVirtualMemory', # 0x20
    'NtOpenThreadToken', # 0x21
    'NtQueryInformationThread', # 0x22
    'NtOpenProcess', # 0x23
    'NtSetInformationFile', # 0x24
    'NtMapViewOfSection', # 0x25
    'NtAccessCheckAndAuditAlarm', # 0x26
    'NtUnmapViewOfSection', # 0x27
    'NtReplyWaitReceivePortEx', # 0x28
    'NtTerminateProcess', # 0x29
    'NtSetEventBoostPriority', # 0x2a
    'NtReadFileScatter', # 0x2b
    'NtOpenThreadTokenEx', # 0x2c
    'NtOpenProcessTokenEx', # 0x2d
    'NtQueryPerformanceCounter', # 0x2e
    'NtEnumerateKey', # 0x2f
    'NtOpenFile', # 0x30
    'NtDelayExecution', # 0x31
    'NtQueryDirectoryFile', # 0x32
    'NtQuerySystemInformation', # 0x33
    'NtOpenSection', # 0x34
    'NtQueryTimer', # 0x35
    'NtFsControlFile', # 0x36
    'NtWriteVirtualMemory', # 0x37
    'NtCloseObjectAuditAlarm', # 0x38
    'NtDuplicateObject', # 0x39
    'NtQueryAttributesFile', # 0x3a
    'NtClearEvent', # 0x3b
    'NtReadVirtualMemory', # 0x3c
    'NtOpenEvent', # 0x3d
    'NtAdjustPrivilegesToken', # 0x3e
    'NtDuplicateToken', # 0x3f
    'NtContinue', # 0x40
    'NtQueryDefaultUILanguage', # 0x41
    'NtQueueApcThread', # 0x42
    'NtYieldExecution', # 0x43
    'NtAddAtom', # 0x44
    'NtCreateEvent', # 0x45
    'NtQueryVolumeInformationFile', # 0x46
    'NtCreateSection', # 0x47
    'NtFlushBuffersFile', # 0x48
    'NtApphelpCacheControl', # 0x49
    'NtCreateProcessEx', # 0x4a
    'NtCreateThread', # 0x4b
    'NtIsProcessInJob', # 0x4c
    'NtProtectVirtualMemory', # 0x4d
    'NtQuerySection', # 0x4e
    'NtResumeThread', # 0x4f
    'NtTerminateThread', # 0x50
    'NtReadRequestData', # 0x51
    'NtCreateFile', # 0x52
    'NtQueryEvent', # 0x53
    'NtWriteRequestData', # 0x54
    'NtOpenDirectoryObject', # 0x55
    'NtAccessCheckByTypeAndAuditAlarm', # 0x56
    'NtQuerySystemTime', # 0x57
    'NtWaitForMultipleObjects', # 0x58
    'NtSetInformationObject', # 0x59
    'NtCancelIoFile', # 0x5a
    'NtTraceEvent', # 0x5b
    'NtPowerInformation', # 0x5c
    'NtSetValueKey', # 0x5d
    'NtCancelTimer', # 0x5e
    'NtSetTimer', # 0x5f
    'NtAcceptConnectPort', # 0x60
    'NtAccessCheck', # 0x61
    'NtAccessCheckByType', # 0x62
    'NtAccessCheckByTypeResultList', # 0x63
    'NtAccessCheckByTypeResultListAndAuditAlarm', # 0x64
    'NtAccessCheckByTypeResultListAndAuditAlarmByHandle', # 0x65
    'NtAddBootEntry', # 0x66
    'NtAddDriverEntry', # 0x67
    'NtAdjustGroupsToken', # 0x68
    'NtAlertResumeThread', # 0x69
    'NtAlertThread', # 0x6a
    'NtAllocateLocallyUniqueId', # 0x6b
    'NtAllocateReserveObject', # 0x6c
    'NtAllocateUserPhysicalPages', # 0x6d
    'NtAllocateUuids', # 0x6e
    'NtAlpcAcceptConnectPort', # 0x6f
    'NtAlpcCancelMessage', # 0x70
    'NtAlpcConnectPort', # 0x71
    'NtAlpcCreatePort', # 0x72
    'NtAlpcCreatePortSection', # 0x73
    'NtAlpcCreateResourceReserve', # 0x74
    'NtAlpcCreateSectionView', # 0x75
    'NtAlpcCreateSecurityContext', # 0x76
    'NtAlpcDeletePortSection', # 0x77
    'NtAlpcDeleteResourceReserve', # 0x78
    'NtAlpcDeleteSectionView', # 0x79
    'NtAlpcDeleteSecurityContext', # 0x7a
    'NtAlpcDisconnectPort', # 0x7b
    'NtAlpcImpersonateClientOfPort', # 0x7c
    'NtAlpcOpenSenderProcess', # 0x7d
    'NtAlpcOpenSenderThread', # 0x7e
    'NtAlpcQueryInformation', # 0x7f
    'NtAlpcQueryInformationMessage', # 0x80
    'NtAlpcRevokeSecurityContext', # 0x81
    'NtAlpcSendWaitReceivePort', # 0x82
    'NtAlpcSetInformation', # 0x83
    'NtAreMappedFilesTheSame', # 0x84
    'NtAssignProcessToJobObject', # 0x85
    'NtCancelIoFileEx', # 0x86
    'NtCancelSynchronousIoFile', # 0x87
    'NtCommitComplete', # 0x88
    'NtCommitEnlistment', # 0x89
    'NtCommitTransaction', # 0x8a
    'NtCompactKeys', # 0x8b
    'NtCompareTokens', # 0x8c
    'NtCompleteConnectPort', # 0x8d
    'NtCompressKey', # 0x8e
    'NtConnectPort', # 0x8f
    'NtCreateDebugObject', # 0x90
    'NtCreateDirectoryObject', # 0x91
    'NtCreateEnlistment', # 0x92
    'NtCreateEventPair', # 0x93
    'NtCreateIoCompletion', # 0x94
    'NtCreateJobObject', # 0x95
    'NtCreateJobSet', # 0x96
    'NtCreateKeyTransacted', # 0x97
    'NtCreateKeyedEvent', # 0x98
    'NtCreateMailslotFile', # 0x99
    'NtCreateMutant', # 0x9a
    'NtCreateNamedPipeFile', # 0x9b
    'NtCreatePagingFile', # 0x9c
    'NtCreatePort', # 0x9d
    'NtCreatePrivateNamespace', # 0x9e
    'NtCreateProcess', # 0x9f
    'NtCreateProfile', # 0xa0
    'NtCreateProfileEx', # 0xa1
    'NtCreateResourceManager', # 0xa2
    'NtCreateSemaphore', # 0xa3
    'NtCreateSymbolicLinkObject', # 0xa4
    'NtCreateThreadEx', # 0xa5
    'NtCreateTimer', # 0xa6
    'NtCreateToken', # 0xa7
    'NtCreateTransaction', # 0xa8
    'NtCreateTransactionManager', # 0xa9
    'NtCreateUserProcess', # 0xaa
    'NtCreateWaitablePort', # 0xab
    'NtCreateWorkerFactory', # 0xac
    'NtDebugActiveProcess', # 0xad
    'NtDebugContinue', # 0xae
    'NtDeleteAtom', # 0xaf
    'NtDeleteBootEntry', # 0xb0
    'NtDeleteDriverEntry', # 0xb1
    'NtDeleteFile', # 0xb2
    'NtDeleteKey', # 0xb3
    'NtDeleteObjectAuditAlarm', # 0xb4
    'NtDeletePrivateNamespace', # 0xb5
    'NtDeleteValueKey', # 0xb6
    'NtDisableLastKnownGood', # 0xb7
    'NtDisplayString', # 0xb8
    'NtDrawText', # 0xb9
    'NtEnableLastKnownGood', # 0xba
    'NtEnumerateBootEntries', # 0xbb
    'NtEnumerateDriverEntries', # 0xbc
    'NtEnumerateSystemEnvironmentValuesEx', # 0xbd
    'NtEnumerateTransactionObject', # 0xbe
    'NtExtendSection', # 0xbf
    'NtFilterToken', # 0xc0
    'NtFlushInstallUILanguage', # 0xc1
    'NtFlushInstructionCache', # 0xc2
    'NtFlushKey', # 0xc3
    'NtFlushProcessWriteBuffers', # 0xc4
    'NtFlushVirtualMemory', # 0xc5
    'NtFlushWriteBuffer', # 0xc6
    'NtFreeUserPhysicalPages', # 0xc7
    'NtFreezeRegistry', # 0xc8
    'NtFreezeTransactions', # 0xc9
    'NtGetContextThread', # 0xca
    'NtGetCurrentProcessorNumber', # 0xcb
    'NtGetDevicePowerState', # 0xcc
    'NtGetMUIRegistryInfo', # 0xcd
    'NtGetNextProcess', # 0xce
    'NtGetNextThread', # 0xcf
    'NtGetNlsSectionPtr', # 0xd0
    'NtGetNotificationResourceManager', # 0xd1
    'NtGetPlugPlayEvent', # 0xd2
    'NtGetWriteWatch', # 0xd3
    'NtImpersonateAnonymousToken', # 0xd4
    'NtImpersonateThread', # 0xd5
    'NtInitializeNlsFiles', # 0xd6
    'NtInitializeRegistry', # 0xd7
    'NtInitiatePowerAction', # 0xd8
    'NtIsSystemResumeAutomatic', # 0xd9
    'NtIsUILanguageComitted', # 0xda
    'NtListenPort', # 0xdb
    'NtLoadDriver', # 0xdc
    'NtLoadKey', # 0xdd
    'NtLoadKey2', # 0xde
    'NtLoadKeyEx', # 0xdf
    'NtLockFile', # 0xe0
    'NtLockProductActivationKeys', # 0xe1
    'NtLockRegistryKey', # 0xe2
    'NtLockVirtualMemory', # 0xe3
    'NtMakePermanentObject', # 0xe4
    'NtMakeTemporaryObject', # 0xe5
    'NtMapCMFModule', # 0xe6
    'NtMapUserPhysicalPages', # 0xe7
    'NtModifyBootEntry', # 0xe8
    'NtModifyDriverEntry', # 0xe9
    'NtNotifyChangeDirectoryFile', # 0xea
    'NtNotifyChangeKey', # 0xeb
    'NtNotifyChangeMultipleKeys', # 0xec
    'NtNotifyChangeSession', # 0xed
    'NtOpenEnlistment', # 0xee
    'NtOpenEventPair', # 0xef
    'NtOpenIoCompletion', # 0xf0
    'NtOpenJobObject', # 0xf1
    'NtOpenKeyEx', # 0xf2
    'NtOpenKeyTransacted', # 0xf3
    'NtOpenKeyTransactedEx', # 0xf4
    'NtOpenKeyedEvent', # 0xf5
    'NtOpenMutant', # 0xf6
    'NtOpenObjectAuditAlarm', # 0xf7
    'NtOpenPrivateNamespace', # 0xf8
    'NtOpenProcessToken', # 0xf9
    'NtOpenResourceManager', # 0xfa
    'NtOpenSemaphore', # 0xfb
    'NtOpenSession', # 0xfc
    'NtOpenSymbolicLinkObject', # 0xfd
    'NtOpenThread', # 0xfe
    'NtOpenTimer', # 0xff
    'NtOpenTransaction', # 0x100
    'NtOpenTransactionManager', # 0x101
    'NtPlugPlayControl', # 0x102
    'NtPrePrepareComplete', # 0x103
    'NtPrePrepareEnlistment', # 0x104
    'NtPrepareComplete', # 0x105
    'NtPrepareEnlistment', # 0x106
    'NtPrivilegeCheck', # 0x107
    'NtPrivilegeObjectAuditAlarm', # 0x108
    'NtPrivilegedServiceAuditAlarm', # 0x109
    'NtPropagationComplete', # 0x10a
    'NtPropagationFailed', # 0x10b
    'NtPulseEvent', # 0x10c
    'NtQueryBootEntryOrder', # 0x10d
    'NtQueryBootOptions', # 0x10e
    'NtQueryDebugFilterState', # 0x10f
    'NtQueryDirectoryObject', # 0x110
    'NtQueryDriverEntryOrder', # 0x111
    'NtQueryEaFile', # 0x112
    'NtQueryFullAttributesFile', # 0x113
    'NtQueryInformationAtom', # 0x114
    'NtQueryInformationEnlistment', # 0x115
    'NtQueryInformationJobObject', # 0x116
    'NtQueryInformationPort', # 0x117
    'NtQueryInformationResourceManager', # 0x118
    'NtQueryInformationTransaction', # 0x119
    'NtQueryInformationTransactionManager', # 0x11a
    'NtQueryInformationWorkerFactory', # 0x11b
    'NtQueryInstallUILanguage', # 0x11c
    'NtQueryIntervalProfile', # 0x11d
    'NtQueryIoCompletion', # 0x11e
    'NtQueryLicenseValue', # 0x11f
    'NtQueryMultipleValueKey', # 0x120
    'NtQueryMutant', # 0x121
    'NtQueryOpenSubKeys', # 0x122
    'NtQueryOpenSubKeysEx', # 0x123
    'NtQueryPortInformationProcess', # 0x124
    'NtQueryQuotaInformationFile', # 0x125
    'NtQuerySecurityAttributesToken', # 0x126
    'NtQuerySecurityObject', # 0x127
    'NtQuerySemaphore', # 0x128
    'NtQuerySymbolicLinkObject', # 0x129
    'NtQuerySystemEnvironmentValue', # 0x12a
    'NtQuerySystemEnvironmentValueEx', # 0x12b
    'NtQuerySystemInformationEx', # 0x12c
    'NtQueryTimerResolution', # 0x12d
    'NtQueueApcThreadEx', # 0x12e
    'NtRaiseException', # 0x12f
    'NtRaiseHardError', # 0x130
    'NtReadOnlyEnlistment', # 0x131
    'NtRecoverEnlistment', # 0x132
    'NtRecoverResourceManager', # 0x133
    'NtRecoverTransactionManager', # 0x134
    'NtRegisterProtocolAddressInformation', # 0x135
    'NtRegisterThreadTerminatePort', # 0x136
    'NtReleaseKeyedEvent', # 0x137
    'NtReleaseWorkerFactoryWorker', # 0x138
    'NtRemoveIoCompletionEx', # 0x139
    'NtRemoveProcessDebug', # 0x13a
    'NtRenameKey', # 0x13b
    'NtRenameTransactionManager', # 0x13c
    'NtReplaceKey', # 0x13d
    'NtReplacePartitionUnit', # 0x13e
    'NtReplyWaitReplyPort', # 0x13f
    'NtRequestPort', # 0x140
    'NtResetEvent', # 0x141
    'NtResetWriteWatch', # 0x142
    'NtRestoreKey', # 0x143
    'NtResumeProcess', # 0x144
    'NtRollbackComplete', # 0x145
    'NtRollbackEnlistment', # 0x146
    'NtRollbackTransaction', # 0x147
    'NtRollforwardTransactionManager', # 0x148
    'NtSaveKey', # 0x149
    'NtSaveKeyEx', # 0x14a
    'NtSaveMergedKeys', # 0x14b
    'NtSecureConnectPort', # 0x14c
    'NtSerializeBoot', # 0x14d
    'NtSetBootEntryOrder', # 0x14e
    'NtSetBootOptions', # 0x14f
    'NtSetContextThread', # 0x150
    'NtSetDebugFilterState', # 0x151
    'NtSetDefaultHardErrorPort', # 0x152
    'NtSetDefaultLocale', # 0x153
    'NtSetDefaultUILanguage', # 0x154
    'NtSetDriverEntryOrder', # 0x155
    'NtSetEaFile', # 0x156
    'NtSetHighEventPair', # 0x157
    'NtSetHighWaitLowEventPair', # 0x158
    'NtSetInformationDebugObject', # 0x159
    'NtSetInformationEnlistment', # 0x15a
    'NtSetInformationJobObject', # 0x15b
    'NtSetInformationKey', # 0x15c
    'NtSetInformationResourceManager', # 0x15d
    'NtSetInformationToken', # 0x15e
    'NtSetInformationTransaction', # 0x15f
    'NtSetInformationTransactionManager', # 0x160
    'NtSetInformationWorkerFactory', # 0x161
    'NtSetIntervalProfile', # 0x162
    'NtSetIoCompletion', # 0x163
    'NtSetIoCompletionEx', # 0x164
    'NtSetLdtEntries', # 0x165
    'NtSetLowEventPair', # 0x166
    'NtSetLowWaitHighEventPair', # 0x167
    'NtSetQuotaInformationFile', # 0x168
    'NtSetSecurityObject', # 0x169
    'NtSetSystemEnvironmentValue', # 0x16a
    'NtSetSystemEnvironmentValueEx', # 0x16b
    'NtSetSystemInformation', # 0x16c
    'NtSetSystemPowerState', # 0x16d
    'NtSetSystemTime', # 0x16e
    'NtSetThreadExecutionState', # 0x16f
    'NtSetTimerEx', # 0x170
    'NtSetTimerResolution', # 0x171
    'NtSetUuidSeed', # 0x172
    'NtSetVolumeInformationFile', # 0x173
    'NtShutdownSystem', # 0x174
    'NtShutdownWorkerFactory', # 0x175
    'NtSignalAndWaitForSingleObject', # 0x176
    'NtSinglePhaseReject', # 0x177
    'NtStartProfile', # 0x178
    'NtStopProfile', # 0x179
    'NtSuspendProcess', # 0x17a
    'NtSuspendThread', # 0x17b
    'NtSystemDebugControl', # 0x17c
    'NtTerminateJobObject', # 0x17d
    'NtTestAlert', # 0x17e
    'NtThawRegistry', # 0x17f
    'NtThawTransactions', # 0x180
    'NtTraceControl', # 0x181
    'NtTranslateFilePath', # 0x182
    'NtUmsThreadYield', # 0x183
    'NtUnloadDriver', # 0x184
    'NtUnloadKey', # 0x185
    'NtUnloadKey2', # 0x186
    'NtUnloadKeyEx', # 0x187
    'NtUnlockFile', # 0x188
    'NtUnlockVirtualMemory', # 0x189
    'NtVdmControl', # 0x18a
    'NtWaitForDebugEvent', # 0x18b
    'NtWaitForKeyedEvent', # 0x18c
    'NtWaitForWorkViaWorkerFactory', # 0x18d
    'NtWaitHighEventPair', # 0x18e
    'NtWaitLowEventPair', # 0x18f
    'NtWorkerFactoryWorkerReady', # 0x190
    ],
    [
    'NtUserGetThreadState', # 0x0
    'NtUserPeekMessage', # 0x1
    'NtUserCallOneParam', # 0x2
    'NtUserGetKeyState', # 0x3
    'NtUserInvalidateRect', # 0x4
    'NtUserCallNoParam', # 0x5
    'NtUserGetMessage', # 0x6
    'NtUserMessageCall', # 0x7
    'NtGdiBitBlt', # 0x8
    'NtGdiGetCharSet', # 0x9
    'NtUserGetDC', # 0xa
    'NtGdiSelectBitmap', # 0xb
    'NtUserWaitMessage', # 0xc
    'NtUserTranslateMessage', # 0xd
    'NtUserGetProp', # 0xe
    'NtUserPostMessage', # 0xf
    'NtUserQueryWindow', # 0x10
    'NtUserTranslateAccelerator', # 0x11
    'NtGdiFlush', # 0x12
    'NtUserRedrawWindow', # 0x13
    'NtUserWindowFromPoint', # 0x14
    'NtUserCallMsgFilter', # 0x15
    'NtUserValidateTimerCallback', # 0x16
    'NtUserBeginPaint', # 0x17
    'NtUserSetTimer', # 0x18
    'NtUserEndPaint', # 0x19
    'NtUserSetCursor', # 0x1a
    'NtUserKillTimer', # 0x1b
    'NtUserBuildHwndList', # 0x1c
    'NtUserSelectPalette', # 0x1d
    'NtUserCallNextHookEx', # 0x1e
    'NtUserHideCaret', # 0x1f
    'NtGdiIntersectClipRect', # 0x20
    'NtUserCallHwndLock', # 0x21
    'NtUserGetProcessWindowStation', # 0x22
    'NtGdiDeleteObjectApp', # 0x23
    'NtUserSetWindowPos', # 0x24
    'NtUserShowCaret', # 0x25
    'NtUserEndDeferWindowPosEx', # 0x26
    'NtUserCallHwndParamLock', # 0x27
    'NtUserVkKeyScanEx', # 0x28
    'NtGdiSetDIBitsToDeviceInternal', # 0x29
    'NtUserCallTwoParam', # 0x2a
    'NtGdiGetRandomRgn', # 0x2b
    'NtUserCopyAcceleratorTable', # 0x2c
    'NtUserNotifyWinEvent', # 0x2d
    'NtGdiExtSelectClipRgn', # 0x2e
    'NtUserIsClipboardFormatAvailable', # 0x2f
    'NtUserSetScrollInfo', # 0x30
    'NtGdiStretchBlt', # 0x31
    'NtUserCreateCaret', # 0x32
    'NtGdiRectVisible', # 0x33
    'NtGdiCombineRgn', # 0x34
    'NtGdiGetDCObject', # 0x35
    'NtUserDispatchMessage', # 0x36
    'NtUserRegisterWindowMessage', # 0x37
    'NtGdiExtTextOutW', # 0x38
    'NtGdiSelectFont', # 0x39
    'NtGdiRestoreDC', # 0x3a
    'NtGdiSaveDC', # 0x3b
    'NtUserGetForegroundWindow', # 0x3c
    'NtUserShowScrollBar', # 0x3d
    'NtUserFindExistingCursorIcon', # 0x3e
    'NtGdiGetDCDword', # 0x3f
    'NtGdiGetRegionData', # 0x40
    'NtGdiLineTo', # 0x41
    'NtUserSystemParametersInfo', # 0x42
    'NtGdiGetAppClipBox', # 0x43
    'NtUserGetAsyncKeyState', # 0x44
    'NtUserGetCPD', # 0x45
    'NtUserRemoveProp', # 0x46
    'NtGdiDoPalette', # 0x47
    'NtGdiPolyPolyDraw', # 0x48
    'NtUserSetCapture', # 0x49
    'NtUserEnumDisplayMonitors', # 0x4a
    'NtGdiCreateCompatibleBitmap', # 0x4b
    'NtUserSetProp', # 0x4c
    'NtGdiGetTextCharsetInfo', # 0x4d
    'NtUserSBGetParms', # 0x4e
    'NtUserGetIconInfo', # 0x4f
    'NtUserExcludeUpdateRgn', # 0x50
    'NtUserSetFocus', # 0x51
    'NtGdiExtGetObjectW', # 0x52
    'NtUserDeferWindowPos', # 0x53
    'NtUserGetUpdateRect', # 0x54
    'NtGdiCreateCompatibleDC', # 0x55
    'NtUserGetClipboardSequenceNumber', # 0x56
    'NtGdiCreatePen', # 0x57
    'NtUserShowWindow', # 0x58
    'NtUserGetKeyboardLayoutList', # 0x59
    'NtGdiPatBlt', # 0x5a
    'NtUserMapVirtualKeyEx', # 0x5b
    'NtUserSetWindowLong', # 0x5c
    'NtGdiHfontCreate', # 0x5d
    'NtUserMoveWindow', # 0x5e
    'NtUserPostThreadMessage', # 0x5f
    'NtUserDrawIconEx', # 0x60
    'NtUserGetSystemMenu', # 0x61
    'NtGdiDrawStream', # 0x62
    'NtUserInternalGetWindowText', # 0x63
    'NtUserGetWindowDC', # 0x64
    'NtGdiD3dDrawPrimitives2', # 0x65
    'NtGdiInvertRgn', # 0x66
    'NtGdiGetRgnBox', # 0x67
    'NtGdiGetAndSetDCDword', # 0x68
    'NtGdiMaskBlt', # 0x69
    'NtGdiGetWidthTable', # 0x6a
    'NtUserScrollDC', # 0x6b
    'NtUserGetObjectInformation', # 0x6c
    'NtGdiCreateBitmap', # 0x6d
    'NtUserFindWindowEx', # 0x6e
    'NtGdiPolyPatBlt', # 0x6f
    'NtUserUnhookWindowsHookEx', # 0x70
    'NtGdiGetNearestColor', # 0x71
    'NtGdiTransformPoints', # 0x72
    'NtGdiGetDCPoint', # 0x73
    'NtGdiCreateDIBBrush', # 0x74
    'NtGdiGetTextMetricsW', # 0x75
    'NtUserCreateWindowEx', # 0x76
    'NtUserSetParent', # 0x77
    'NtUserGetKeyboardState', # 0x78
    'NtUserToUnicodeEx', # 0x79
    'NtUserGetControlBrush', # 0x7a
    'NtUserGetClassName', # 0x7b
    'NtGdiAlphaBlend', # 0x7c
    'NtGdiDdBlt', # 0x7d
    'NtGdiOffsetRgn', # 0x7e
    'NtUserDefSetText', # 0x7f
    'NtGdiGetTextFaceW', # 0x80
    'NtGdiStretchDIBitsInternal', # 0x81
    'NtUserSendInput', # 0x82
    'NtUserGetThreadDesktop', # 0x83
    'NtGdiCreateRectRgn', # 0x84
    'NtGdiGetDIBitsInternal', # 0x85
    'NtUserGetUpdateRgn', # 0x86
    'NtGdiDeleteClientObj', # 0x87
    'NtUserGetIconSize', # 0x88
    'NtUserFillWindow', # 0x89
    'NtGdiExtCreateRegion', # 0x8a
    'NtGdiComputeXformCoefficients', # 0x8b
    'NtUserSetWindowsHookEx', # 0x8c
    'NtUserNotifyProcessCreate', # 0x8d
    'NtGdiUnrealizeObject', # 0x8e
    'NtUserGetTitleBarInfo', # 0x8f
    'NtGdiRectangle', # 0x90
    'NtUserSetThreadDesktop', # 0x91
    'NtUserGetDCEx', # 0x92
    'NtUserGetScrollBarInfo', # 0x93
    'NtGdiGetTextExtent', # 0x94
    'NtUserSetWindowFNID', # 0x95
    'NtGdiSetLayout', # 0x96
    'NtUserCalcMenuBar', # 0x97
    'NtUserThunkedMenuItemInfo', # 0x98
    'NtGdiExcludeClipRect', # 0x99
    'NtGdiCreateDIBSection', # 0x9a
    'NtGdiGetDCforBitmap', # 0x9b
    'NtUserDestroyCursor', # 0x9c
    'NtUserDestroyWindow', # 0x9d
    'NtUserCallHwndParam', # 0x9e
    'NtGdiCreateDIBitmapInternal', # 0x9f
    'NtUserOpenWindowStation', # 0xa0
    'NtGdiDdDeleteSurfaceObject', # 0xa1
    'NtGdiDdCanCreateSurface', # 0xa2
    'NtGdiDdCreateSurface', # 0xa3
    'NtUserSetCursorIconData', # 0xa4
    'NtGdiDdDestroySurface', # 0xa5
    'NtUserCloseDesktop', # 0xa6
    'NtUserOpenDesktop', # 0xa7
    'NtUserSetProcessWindowStation', # 0xa8
    'NtUserGetAtomName', # 0xa9
    'NtGdiDdResetVisrgn', # 0xaa
    'NtGdiExtCreatePen', # 0xab
    'NtGdiCreatePaletteInternal', # 0xac
    'NtGdiSetBrushOrg', # 0xad
    'NtUserBuildNameList', # 0xae
    'NtGdiSetPixel', # 0xaf
    'NtUserRegisterClassExWOW', # 0xb0
    'NtGdiCreatePatternBrushInternal', # 0xb1
    'NtUserGetAncestor', # 0xb2
    'NtGdiGetOutlineTextMetricsInternalW', # 0xb3
    'NtGdiSetBitmapBits', # 0xb4
    'NtUserCloseWindowStation', # 0xb5
    'NtUserGetDoubleClickTime', # 0xb6
    'NtUserEnableScrollBar', # 0xb7
    'NtGdiCreateSolidBrush', # 0xb8
    'NtUserGetClassInfoEx', # 0xb9
    'NtGdiCreateClientObj', # 0xba
    'NtUserUnregisterClass', # 0xbb
    'NtUserDeleteMenu', # 0xbc
    'NtGdiRectInRegion', # 0xbd
    'NtUserScrollWindowEx', # 0xbe
    'NtGdiGetPixel', # 0xbf
    'NtUserSetClassLong', # 0xc0
    'NtUserGetMenuBarInfo', # 0xc1
    'NtGdiDdCreateSurfaceEx', # 0xc2
    'NtGdiDdCreateSurfaceObject', # 0xc3
    'NtGdiGetNearestPaletteIndex', # 0xc4
    'NtGdiDdLockD3D', # 0xc5
    'NtGdiDdUnlockD3D', # 0xc6
    'NtGdiGetCharWidthW', # 0xc7
    'NtUserInvalidateRgn', # 0xc8
    'NtUserGetClipboardOwner', # 0xc9
    'NtUserSetWindowRgn', # 0xca
    'NtUserBitBltSysBmp', # 0xcb
    'NtGdiGetCharWidthInfo', # 0xcc
    'NtUserValidateRect', # 0xcd
    'NtUserCloseClipboard', # 0xce
    'NtUserOpenClipboard', # 0xcf
    'NtGdiGetStockObject', # 0xd0
    'NtUserSetClipboardData', # 0xd1
    'NtUserEnableMenuItem', # 0xd2
    'NtUserAlterWindowStyle', # 0xd3
    'NtGdiFillRgn', # 0xd4
    'NtUserGetWindowPlacement', # 0xd5
    'NtGdiModifyWorldTransform', # 0xd6
    'NtGdiGetFontData', # 0xd7
    'NtUserGetOpenClipboardWindow', # 0xd8
    'NtUserSetThreadState', # 0xd9
    'NtGdiOpenDCW', # 0xda
    'NtUserTrackMouseEvent', # 0xdb
    'NtGdiGetTransform', # 0xdc
    'NtUserDestroyMenu', # 0xdd
    'NtGdiGetBitmapBits', # 0xde
    'NtUserConsoleControl', # 0xdf
    'NtUserSetActiveWindow', # 0xe0
    'NtUserSetInformationThread', # 0xe1
    'NtUserSetWindowPlacement', # 0xe2
    'NtUserGetControlColor', # 0xe3
    'NtGdiSetMetaRgn', # 0xe4
    'NtGdiSetMiterLimit', # 0xe5
    'NtGdiSetVirtualResolution', # 0xe6
    'NtGdiGetRasterizerCaps', # 0xe7
    'NtUserSetWindowWord', # 0xe8
    'NtUserGetClipboardFormatName', # 0xe9
    'NtUserRealInternalGetMessage', # 0xea
    'NtUserCreateLocalMemHandle', # 0xeb
    'NtUserAttachThreadInput', # 0xec
    'NtGdiCreateHalftonePalette', # 0xed
    'NtUserPaintMenuBar', # 0xee
    'NtUserSetKeyboardState', # 0xef
    'NtGdiCombineTransform', # 0xf0
    'NtUserCreateAcceleratorTable', # 0xf1
    'NtUserGetCursorFrameInfo', # 0xf2
    'NtUserGetAltTabInfo', # 0xf3
    'NtUserGetCaretBlinkTime', # 0xf4
    'NtGdiQueryFontAssocInfo', # 0xf5
    'NtUserProcessConnect', # 0xf6
    'NtUserEnumDisplayDevices', # 0xf7
    'NtUserEmptyClipboard', # 0xf8
    'NtUserGetClipboardData', # 0xf9
    'NtUserRemoveMenu', # 0xfa
    'NtGdiSetBoundsRect', # 0xfb
    'NtGdiGetBitmapDimension', # 0xfc
    'NtUserConvertMemHandle', # 0xfd
    'NtUserDestroyAcceleratorTable', # 0xfe
    'NtUserGetGUIThreadInfo', # 0xff
    'NtGdiCloseFigure', # 0x100
    'NtUserSetWindowsHookAW', # 0x101
    'NtUserSetMenuDefaultItem', # 0x102
    'NtUserCheckMenuItem', # 0x103
    'NtUserSetWinEventHook', # 0x104
    'NtUserUnhookWinEvent', # 0x105
    'NtUserLockWindowUpdate', # 0x106
    'NtUserSetSystemMenu', # 0x107
    'NtUserThunkedMenuInfo', # 0x108
    'NtGdiBeginPath', # 0x109
    'NtGdiEndPath', # 0x10a
    'NtGdiFillPath', # 0x10b
    'NtUserCallHwnd', # 0x10c
    'NtUserDdeInitialize', # 0x10d
    'NtUserModifyUserStartupInfoFlags', # 0x10e
    'NtUserCountClipboardFormats', # 0x10f
    'NtGdiAddFontMemResourceEx', # 0x110
    'NtGdiEqualRgn', # 0x111
    'NtGdiGetSystemPaletteUse', # 0x112
    'NtGdiRemoveFontMemResourceEx', # 0x113
    'NtUserEnumDisplaySettings', # 0x114
    'NtUserPaintDesktop', # 0x115
    'NtGdiExtEscape', # 0x116
    'NtGdiSetBitmapDimension', # 0x117
    'NtGdiSetFontEnumeration', # 0x118
    'NtUserChangeClipboardChain', # 0x119
    'NtUserSetClipboardViewer', # 0x11a
    'NtUserShowWindowAsync', # 0x11b
    'NtGdiCreateColorSpace', # 0x11c
    'NtGdiDeleteColorSpace', # 0x11d
    'NtUserActivateKeyboardLayout', # 0x11e
    'NtGdiAbortDoc', # 0x11f
    'NtGdiAbortPath', # 0x120
    'NtGdiAddEmbFontToDC', # 0x121
    'NtGdiAddFontResourceW', # 0x122
    'NtGdiAddRemoteFontToDC', # 0x123
    'NtGdiAddRemoteMMInstanceToDC', # 0x124
    'NtGdiAngleArc', # 0x125
    'NtGdiAnyLinkedFonts', # 0x126
    'NtGdiArcInternal', # 0x127
    'NtGdiBRUSHOBJ_DeleteRbrush', # 0x128
    'NtGdiBRUSHOBJ_hGetColorTransform', # 0x129
    'NtGdiBRUSHOBJ_pvAllocRbrush', # 0x12a
    'NtGdiBRUSHOBJ_pvGetRbrush', # 0x12b
    'NtGdiBRUSHOBJ_ulGetBrushColor', # 0x12c
    'NtGdiBeginGdiRendering', # 0x12d
    'NtGdiCLIPOBJ_bEnum', # 0x12e
    'NtGdiCLIPOBJ_cEnumStart', # 0x12f
    'NtGdiCLIPOBJ_ppoGetPath', # 0x130
    'NtGdiCancelDC', # 0x131
    'NtGdiChangeGhostFont', # 0x132
    'NtGdiCheckBitmapBits', # 0x133
    'NtGdiClearBitmapAttributes', # 0x134
    'NtGdiClearBrushAttributes', # 0x135
    'NtGdiColorCorrectPalette', # 0x136
    'NtGdiConfigureOPMProtectedOutput', # 0x137
    'NtGdiConvertMetafileRect', # 0x138
    'NtGdiCreateBitmapFromDxSurface', # 0x139
    'NtGdiCreateColorTransform', # 0x13a
    'NtGdiCreateEllipticRgn', # 0x13b
    'NtGdiCreateHatchBrushInternal', # 0x13c
    'NtGdiCreateMetafileDC', # 0x13d
    'NtGdiCreateOPMProtectedOutputs', # 0x13e
    'NtGdiCreateRoundRectRgn', # 0x13f
    'NtGdiCreateServerMetaFile', # 0x140
    'NtGdiD3dContextCreate', # 0x141
    'NtGdiD3dContextDestroy', # 0x142
    'NtGdiD3dContextDestroyAll', # 0x143
    'NtGdiD3dValidateTextureStageState', # 0x144
    'NtGdiDDCCIGetCapabilitiesString', # 0x145
    'NtGdiDDCCIGetCapabilitiesStringLength', # 0x146
    'NtGdiDDCCIGetTimingReport', # 0x147
    'NtGdiDDCCIGetVCPFeature', # 0x148
    'NtGdiDDCCISaveCurrentSettings', # 0x149
    'NtGdiDDCCISetVCPFeature', # 0x14a
    'NtGdiDdAddAttachedSurface', # 0x14b
    'NtGdiDdAlphaBlt', # 0x14c
    'NtGdiDdAttachSurface', # 0x14d
    'NtGdiDdBeginMoCompFrame', # 0x14e
    'NtGdiDdCanCreateD3DBuffer', # 0x14f
    'NtGdiDdColorControl', # 0x150
    'NtGdiDdCreateD3DBuffer', # 0x151
    'NtGdiDdCreateDirectDrawObject', # 0x152
    'NtGdiDdCreateFullscreenSprite', # 0x153
    'NtGdiDdCreateMoComp', # 0x154
    'NtGdiDdDDIAcquireKeyedMutex', # 0x155
    'NtGdiDdDDICheckExclusiveOwnership', # 0x156
    'NtGdiDdDDICheckMonitorPowerState', # 0x157
    'NtGdiDdDDICheckOcclusion', # 0x158
    'NtGdiDdDDICheckSharedResourceAccess', # 0x159
    'NtGdiDdDDICheckVidPnExclusiveOwnership', # 0x15a
    'NtGdiDdDDICloseAdapter', # 0x15b
    'NtGdiDdDDIConfigureSharedResource', # 0x15c
    'NtGdiDdDDICreateAllocation', # 0x15d
    'NtGdiDdDDICreateContext', # 0x15e
    'NtGdiDdDDICreateDCFromMemory', # 0x15f
    'NtGdiDdDDICreateDevice', # 0x160
    'NtGdiDdDDICreateKeyedMutex', # 0x161
    'NtGdiDdDDICreateOverlay', # 0x162
    'NtGdiDdDDICreateSynchronizationObject', # 0x163
    'NtGdiDdDDIDestroyAllocation', # 0x164
    'NtGdiDdDDIDestroyContext', # 0x165
    'NtGdiDdDDIDestroyDCFromMemory', # 0x166
    'NtGdiDdDDIDestroyDevice', # 0x167
    'NtGdiDdDDIDestroyKeyedMutex', # 0x168
    'NtGdiDdDDIDestroyOverlay', # 0x169
    'NtGdiDdDDIDestroySynchronizationObject', # 0x16a
    'NtGdiDdDDIEscape', # 0x16b
    'NtGdiDdDDIFlipOverlay', # 0x16c
    'NtGdiDdDDIGetContextSchedulingPriority', # 0x16d
    'NtGdiDdDDIGetDeviceState', # 0x16e
    'NtGdiDdDDIGetDisplayModeList', # 0x16f
    'NtGdiDdDDIGetMultisampleMethodList', # 0x170
    'NtGdiDdDDIGetOverlayState', # 0x171
    'NtGdiDdDDIGetPresentHistory', # 0x172
    'NtGdiDdDDIGetPresentQueueEvent', # 0x173
    'NtGdiDdDDIGetProcessSchedulingPriorityClass', # 0x174
    'NtGdiDdDDIGetRuntimeData', # 0x175
    'NtGdiDdDDIGetScanLine', # 0x176
    'NtGdiDdDDIGetSharedPrimaryHandle', # 0x177
    'NtGdiDdDDIInvalidateActiveVidPn', # 0x178
    'NtGdiDdDDILock', # 0x179
    'NtGdiDdDDIOpenAdapterFromDeviceName', # 0x17a
    'NtGdiDdDDIOpenAdapterFromHdc', # 0x17b
    'NtGdiDdDDIOpenKeyedMutex', # 0x17c
    'NtGdiDdDDIOpenResource', # 0x17d
    'NtGdiDdDDIOpenSynchronizationObject', # 0x17e
    'NtGdiDdDDIPollDisplayChildren', # 0x17f
    'NtGdiDdDDIPresent', # 0x180
    'NtGdiDdDDIQueryAdapterInfo', # 0x181
    'NtGdiDdDDIQueryAllocationResidency', # 0x182
    'NtGdiDdDDIQueryResourceInfo', # 0x183
    'NtGdiDdDDIQueryStatistics', # 0x184
    'NtGdiDdDDIReleaseKeyedMutex', # 0x185
    'NtGdiDdDDIReleaseProcessVidPnSourceOwners', # 0x186
    'NtGdiDdDDIRender', # 0x187
    'NtGdiDdDDISetAllocationPriority', # 0x188
    'NtGdiDdDDISetContextSchedulingPriority', # 0x189
    'NtGdiDdDDISetDisplayMode', # 0x18a
    'NtGdiDdDDISetDisplayPrivateDriverFormat', # 0x18b
    'NtGdiDdDDISetGammaRamp', # 0x18c
    'NtGdiDdDDISetProcessSchedulingPriorityClass', # 0x18d
    'NtGdiDdDDISetQueuedLimit', # 0x18e
    'NtGdiDdDDISetVidPnSourceOwner', # 0x18f
    'NtGdiDdDDISharedPrimaryLockNotification', # 0x190
    'NtGdiDdDDISharedPrimaryUnLockNotification', # 0x191
    'NtGdiDdDDISignalSynchronizationObject', # 0x192
    'NtGdiDdDDIUnlock', # 0x193
    'NtGdiDdDDIUpdateOverlay', # 0x194
    'NtGdiDdDDIWaitForIdle', # 0x195
    'NtGdiDdDDIWaitForSynchronizationObject', # 0x196
    'NtGdiDdDDIWaitForVerticalBlankEvent', # 0x197
    'NtGdiDdDeleteDirectDrawObject', # 0x198
    'NtGdiDdDestroyD3DBuffer', # 0x199
    'NtGdiDdDestroyFullscreenSprite', # 0x19a
    'NtGdiDdDestroyMoComp', # 0x19b
    'NtGdiDdEndMoCompFrame', # 0x19c
    'NtGdiDdFlip', # 0x19d
    'NtGdiDdFlipToGDISurface', # 0x19e
    'NtGdiDdGetAvailDriverMemory', # 0x19f
    'NtGdiDdGetBltStatus', # 0x1a0
    'NtGdiDdGetDC', # 0x1a1
    'NtGdiDdGetDriverInfo', # 0x1a2
    'NtGdiDdGetDriverState', # 0x1a3
    'NtGdiDdGetDxHandle', # 0x1a4
    'NtGdiDdGetFlipStatus', # 0x1a5
    'NtGdiDdGetInternalMoCompInfo', # 0x1a6
    'NtGdiDdGetMoCompBuffInfo', # 0x1a7
    'NtGdiDdGetMoCompFormats', # 0x1a8
    'NtGdiDdGetMoCompGuids', # 0x1a9
    'NtGdiDdGetScanLine', # 0x1aa
    'NtGdiDdLock', # 0x1ab
    'NtGdiDdNotifyFullscreenSpriteUpdate', # 0x1ac
    'NtGdiDdQueryDirectDrawObject', # 0x1ad
    'NtGdiDdQueryMoCompStatus', # 0x1ae
    'NtGdiDdQueryVisRgnUniqueness', # 0x1af
    'NtGdiDdReenableDirectDrawObject', # 0x1b0
    'NtGdiDdReleaseDC', # 0x1b1
    'NtGdiDdRenderMoComp', # 0x1b2
    'NtGdiDdSetColorKey', # 0x1b3
    'NtGdiDdSetExclusiveMode', # 0x1b4
    'NtGdiDdSetGammaRamp', # 0x1b5
    'NtGdiDdSetOverlayPosition', # 0x1b6
    'NtGdiDdUnattachSurface', # 0x1b7
    'NtGdiDdUnlock', # 0x1b8
    'NtGdiDdUpdateOverlay', # 0x1b9
    'NtGdiDdWaitForVerticalBlank', # 0x1ba
    'NtGdiDeleteColorTransform', # 0x1bb
    'NtGdiDescribePixelFormat', # 0x1bc
    'NtGdiDestroyOPMProtectedOutput', # 0x1bd
    'NtGdiDestroyPhysicalMonitor', # 0x1be
    'NtGdiDoBanding', # 0x1bf
    'NtGdiDrawEscape', # 0x1c0
    'NtGdiDvpAcquireNotification', # 0x1c1
    'NtGdiDvpCanCreateVideoPort', # 0x1c2
    'NtGdiDvpColorControl', # 0x1c3
    'NtGdiDvpCreateVideoPort', # 0x1c4
    'NtGdiDvpDestroyVideoPort', # 0x1c5
    'NtGdiDvpFlipVideoPort', # 0x1c6
    'NtGdiDvpGetVideoPortBandwidth', # 0x1c7
    'NtGdiDvpGetVideoPortConnectInfo', # 0x1c8
    'NtGdiDvpGetVideoPortField', # 0x1c9
    'NtGdiDvpGetVideoPortFlipStatus', # 0x1ca
    'NtGdiDvpGetVideoPortInputFormats', # 0x1cb
    'NtGdiDvpGetVideoPortLine', # 0x1cc
    'NtGdiDvpGetVideoPortOutputFormats', # 0x1cd
    'NtGdiDvpGetVideoSignalStatus', # 0x1ce
    'NtGdiDvpReleaseNotification', # 0x1cf
    'NtGdiDvpUpdateVideoPort', # 0x1d0
    'NtGdiDvpWaitForVideoPortSync', # 0x1d1
    'NtGdiDxgGenericThunk', # 0x1d2
    'NtGdiEllipse', # 0x1d3
    'NtGdiEnableEudc', # 0x1d4
    'NtGdiEndDoc', # 0x1d5
    'NtGdiEndGdiRendering', # 0x1d6
    'NtGdiEndPage', # 0x1d7
    'NtGdiEngAlphaBlend', # 0x1d8
    'NtGdiEngAssociateSurface', # 0x1d9
    'NtGdiEngBitBlt', # 0x1da
    'NtGdiEngCheckAbort', # 0x1db
    'NtGdiEngComputeGlyphSet', # 0x1dc
    'NtGdiEngCopyBits', # 0x1dd
    'NtGdiEngCreateBitmap', # 0x1de
    'NtGdiEngCreateClip', # 0x1df
    'NtGdiEngCreateDeviceBitmap', # 0x1e0
    'NtGdiEngCreateDeviceSurface', # 0x1e1
    'NtGdiEngCreatePalette', # 0x1e2
    'NtGdiEngDeleteClip', # 0x1e3
    'NtGdiEngDeletePalette', # 0x1e4
    'NtGdiEngDeletePath', # 0x1e5
    'NtGdiEngDeleteSurface', # 0x1e6
    'NtGdiEngEraseSurface', # 0x1e7
    'NtGdiEngFillPath', # 0x1e8
    'NtGdiEngGradientFill', # 0x1e9
    'NtGdiEngLineTo', # 0x1ea
    'NtGdiEngLockSurface', # 0x1eb
    'NtGdiEngMarkBandingSurface', # 0x1ec
    'NtGdiEngPaint', # 0x1ed
    'NtGdiEngPlgBlt', # 0x1ee
    'NtGdiEngStretchBlt', # 0x1ef
    'NtGdiEngStretchBltROP', # 0x1f0
    'NtGdiEngStrokeAndFillPath', # 0x1f1
    'NtGdiEngStrokePath', # 0x1f2
    'NtGdiEngTextOut', # 0x1f3
    'NtGdiEngTransparentBlt', # 0x1f4
    'NtGdiEngUnlockSurface', # 0x1f5
    'NtGdiEnumFonts', # 0x1f6
    'NtGdiEnumObjects', # 0x1f7
    'NtGdiEudcLoadUnloadLink', # 0x1f8
    'NtGdiExtFloodFill', # 0x1f9
    'NtGdiFONTOBJ_cGetAllGlyphHandles', # 0x1fa
    'NtGdiFONTOBJ_cGetGlyphs', # 0x1fb
    'NtGdiFONTOBJ_pQueryGlyphAttrs', # 0x1fc
    'NtGdiFONTOBJ_pfdg', # 0x1fd
    'NtGdiFONTOBJ_pifi', # 0x1fe
    'NtGdiFONTOBJ_pvTrueTypeFontFile', # 0x1ff
    'NtGdiFONTOBJ_pxoGetXform', # 0x200
    'NtGdiFONTOBJ_vGetInfo', # 0x201
    'NtGdiFlattenPath', # 0x202
    'NtGdiFontIsLinked', # 0x203
    'NtGdiForceUFIMapping', # 0x204
    'NtGdiFrameRgn', # 0x205
    'NtGdiFullscreenControl', # 0x206
    'NtGdiGetBoundsRect', # 0x207
    'NtGdiGetCOPPCompatibleOPMInformation', # 0x208
    'NtGdiGetCertificate', # 0x209
    'NtGdiGetCertificateSize', # 0x20a
    'NtGdiGetCharABCWidthsW', # 0x20b
    'NtGdiGetCharacterPlacementW', # 0x20c
    'NtGdiGetColorAdjustment', # 0x20d
    'NtGdiGetColorSpaceforBitmap', # 0x20e
    'NtGdiGetDeviceCaps', # 0x20f
    'NtGdiGetDeviceCapsAll', # 0x210
    'NtGdiGetDeviceGammaRamp', # 0x211
    'NtGdiGetDeviceWidth', # 0x212
    'NtGdiGetDhpdev', # 0x213
    'NtGdiGetETM', # 0x214
    'NtGdiGetEmbUFI', # 0x215
    'NtGdiGetEmbedFonts', # 0x216
    'NtGdiGetEudcTimeStampEx', # 0x217
    'NtGdiGetFontFileData', # 0x218
    'NtGdiGetFontFileInfo', # 0x219
    'NtGdiGetFontResourceInfoInternalW', # 0x21a
    'NtGdiGetFontUnicodeRanges', # 0x21b
    'NtGdiGetGlyphIndicesW', # 0x21c
    'NtGdiGetGlyphIndicesWInternal', # 0x21d
    'NtGdiGetGlyphOutline', # 0x21e
    'NtGdiGetKerningPairs', # 0x21f
    'NtGdiGetLinkedUFIs', # 0x220
    'NtGdiGetMiterLimit', # 0x221
    'NtGdiGetMonitorID', # 0x222
    'NtGdiGetNumberOfPhysicalMonitors', # 0x223
    'NtGdiGetOPMInformation', # 0x224
    'NtGdiGetOPMRandomNumber', # 0x225
    'NtGdiGetObjectBitmapHandle', # 0x226
    'NtGdiGetPath', # 0x227
    'NtGdiGetPerBandInfo', # 0x228
    'NtGdiGetPhysicalMonitorDescription', # 0x229
    'NtGdiGetPhysicalMonitors', # 0x22a
    'NtGdiGetRealizationInfo', # 0x22b
    'NtGdiGetServerMetaFileBits', # 0x22c
    'NtGdiGetSpoolMessage', # 0x22d
    'NtGdiGetStats', # 0x22e
    'NtGdiGetStringBitmapW', # 0x22f
    'NtGdiGetSuggestedOPMProtectedOutputArraySize', # 0x230
    'NtGdiGetTextExtentExW', # 0x231
    'NtGdiGetUFI', # 0x232
    'NtGdiGetUFIPathname', # 0x233
    'NtGdiGradientFill', # 0x234
    'NtGdiHLSurfGetInformation', # 0x235
    'NtGdiHLSurfSetInformation', # 0x236
    'NtGdiHT_Get8BPPFormatPalette', # 0x237
    'NtGdiHT_Get8BPPMaskPalette', # 0x238
    'NtGdiIcmBrushInfo', # 0x239
    'NtGdiInit', # 0x23a
    'NtGdiInitSpool', # 0x23b
    'NtGdiMakeFontDir', # 0x23c
    'NtGdiMakeInfoDC', # 0x23d
    'NtGdiMakeObjectUnXferable', # 0x23e
    'NtGdiMakeObjectXferable', # 0x23f
    'NtGdiMirrorWindowOrg', # 0x240
    'NtGdiMonoBitmap', # 0x241
    'NtGdiMoveTo', # 0x242
    'NtGdiOffsetClipRgn', # 0x243
    'NtGdiPATHOBJ_bEnum', # 0x244
    'NtGdiPATHOBJ_bEnumClipLines', # 0x245
    'NtGdiPATHOBJ_vEnumStart', # 0x246
    'NtGdiPATHOBJ_vEnumStartClipLines', # 0x247
    'NtGdiPATHOBJ_vGetBounds', # 0x248
    'NtGdiPathToRegion', # 0x249
    'NtGdiPlgBlt', # 0x24a
    'NtGdiPolyDraw', # 0x24b
    'NtGdiPolyTextOutW', # 0x24c
    'NtGdiPtInRegion', # 0x24d
    'NtGdiPtVisible', # 0x24e
    'NtGdiQueryFonts', # 0x24f
    'NtGdiRemoveFontResourceW', # 0x250
    'NtGdiRemoveMergeFont', # 0x251
    'NtGdiResetDC', # 0x252
    'NtGdiResizePalette', # 0x253
    'NtGdiRoundRect', # 0x254
    'NtGdiSTROBJ_bEnum', # 0x255
    'NtGdiSTROBJ_bEnumPositionsOnly', # 0x256
    'NtGdiSTROBJ_bGetAdvanceWidths', # 0x257
    'NtGdiSTROBJ_dwGetCodePage', # 0x258
    'NtGdiSTROBJ_vEnumStart', # 0x259
    'NtGdiScaleViewportExtEx', # 0x25a
    'NtGdiScaleWindowExtEx', # 0x25b
    'NtGdiSelectBrush', # 0x25c
    'NtGdiSelectClipPath', # 0x25d
    'NtGdiSelectPen', # 0x25e
    'NtGdiSetBitmapAttributes', # 0x25f
    'NtGdiSetBrushAttributes', # 0x260
    'NtGdiSetColorAdjustment', # 0x261
    'NtGdiSetColorSpace', # 0x262
    'NtGdiSetDeviceGammaRamp', # 0x263
    'NtGdiSetFontXform', # 0x264
    'NtGdiSetIcmMode', # 0x265
    'NtGdiSetLinkedUFIs', # 0x266
    'NtGdiSetMagicColors', # 0x267
    'NtGdiSetOPMSigningKeyAndSequenceNumbers', # 0x268
    'NtGdiSetPUMPDOBJ', # 0x269
    'NtGdiSetPixelFormat', # 0x26a
    'NtGdiSetRectRgn', # 0x26b
    'NtGdiSetSizeDevice', # 0x26c
    'NtGdiSetSystemPaletteUse', # 0x26d
    'NtGdiSetTextJustification', # 0x26e
    'NtGdiSfmGetNotificationTokens', # 0x26f
    'NtGdiStartDoc', # 0x270
    'NtGdiStartPage', # 0x271
    'NtGdiStrokeAndFillPath', # 0x272
    'NtGdiStrokePath', # 0x273
    'NtGdiSwapBuffers', # 0x274
    'NtGdiTransparentBlt', # 0x275
    'NtGdiUMPDEngFreeUserMem', # 0x276
    'NtGdiUnloadPrinterDriver', # 0x277
    'NtGdiUnmapMemFont', # 0x278
    'NtGdiUpdateColors', # 0x279
    'NtGdiUpdateTransform', # 0x27a
    'NtGdiWidenPath', # 0x27b
    'NtGdiXFORMOBJ_bApplyXform', # 0x27c
    'NtGdiXFORMOBJ_iGetXform', # 0x27d
    'NtGdiXLATEOBJ_cGetPalette', # 0x27e
    'NtGdiXLATEOBJ_hGetColorTransform', # 0x27f
    'NtGdiXLATEOBJ_iXlate', # 0x280
    'NtUserAddClipboardFormatListener', # 0x281
    'NtUserAssociateInputContext', # 0x282
    'NtUserBlockInput', # 0x283
    'NtUserBuildHimcList', # 0x284
    'NtUserBuildPropList', # 0x285
    'NtUserCalculatePopupWindowPosition', # 0x286
    'NtUserCallHwndOpt', # 0x287
    'NtUserChangeDisplaySettings', # 0x288
    'NtUserChangeWindowMessageFilterEx', # 0x289
    'NtUserCheckAccessForIntegrityLevel', # 0x28a
    'NtUserCheckDesktopByThreadId', # 0x28b
    'NtUserCheckWindowThreadDesktop', # 0x28c
    'NtUserChildWindowFromPointEx', # 0x28d
    'NtUserClipCursor', # 0x28e
    'NtUserCreateDesktopEx', # 0x28f
    'NtUserCreateInputContext', # 0x290
    'NtUserCreateWindowStation', # 0x291
    'NtUserCtxDisplayIOCtl', # 0x292
    'NtUserDestroyInputContext', # 0x293
    'NtUserDisableThreadIme', # 0x294
    'NtUserDisplayConfigGetDeviceInfo', # 0x295
    'NtUserDisplayConfigSetDeviceInfo', # 0x296
    'NtUserDoSoundConnect', # 0x297
    'NtUserDoSoundDisconnect', # 0x298
    'NtUserDragDetect', # 0x299
    'NtUserDragObject', # 0x29a
    'NtUserDrawAnimatedRects', # 0x29b
    'NtUserDrawCaption', # 0x29c
    'NtUserDrawCaptionTemp', # 0x29d
    'NtUserDrawMenuBarTemp', # 0x29e
    'NtUserDwmStartRedirection', # 0x29f
    'NtUserDwmStopRedirection', # 0x2a0
    'NtUserEndMenu', # 0x2a1
    'NtUserEndTouchOperation', # 0x2a2
    'NtUserEvent', # 0x2a3
    'NtUserFlashWindowEx', # 0x2a4
    'NtUserFrostCrashedWindow', # 0x2a5
    'NtUserGetAppImeLevel', # 0x2a6
    'NtUserGetCaretPos', # 0x2a7
    'NtUserGetClipCursor', # 0x2a8
    'NtUserGetClipboardViewer', # 0x2a9
    'NtUserGetComboBoxInfo', # 0x2aa
    'NtUserGetCursorInfo', # 0x2ab
    'NtUserGetDisplayConfigBufferSizes', # 0x2ac
    'NtUserGetGestureConfig', # 0x2ad
    'NtUserGetGestureExtArgs', # 0x2ae
    'NtUserGetGestureInfo', # 0x2af
    'NtUserGetGuiResources', # 0x2b0
    'NtUserGetImeHotKey', # 0x2b1
    'NtUserGetImeInfoEx', # 0x2b2
    'NtUserGetInputLocaleInfo', # 0x2b3
    'NtUserGetInternalWindowPos', # 0x2b4
    'NtUserGetKeyNameText', # 0x2b5
    'NtUserGetKeyboardLayoutName', # 0x2b6
    'NtUserGetLayeredWindowAttributes', # 0x2b7
    'NtUserGetListBoxInfo', # 0x2b8
    'NtUserGetMenuIndex', # 0x2b9
    'NtUserGetMenuItemRect', # 0x2ba
    'NtUserGetMouseMovePointsEx', # 0x2bb
    'NtUserGetPriorityClipboardFormat', # 0x2bc
    'NtUserGetRawInputBuffer', # 0x2bd
    'NtUserGetRawInputData', # 0x2be
    'NtUserGetRawInputDeviceInfo', # 0x2bf
    'NtUserGetRawInputDeviceList', # 0x2c0
    'NtUserGetRegisteredRawInputDevices', # 0x2c1
    'NtUserGetTopLevelWindow', # 0x2c2
    'NtUserGetTouchInputInfo', # 0x2c3
    'NtUserGetUpdatedClipboardFormats', # 0x2c4
    'NtUserGetWOWClass', # 0x2c5
    'NtUserGetWindowCompositionAttribute', # 0x2c6
    'NtUserGetWindowCompositionInfo', # 0x2c7
    'NtUserGetWindowDisplayAffinity', # 0x2c8
    'NtUserGetWindowMinimizeRect', # 0x2c9
    'NtUserGetWindowRgnEx', # 0x2ca
    'NtUserGhostWindowFromHungWindow', # 0x2cb
    'NtUserHardErrorControl', # 0x2cc
    'NtUserHiliteMenuItem', # 0x2cd
    'NtUserHungWindowFromGhostWindow', # 0x2ce
    'NtUserHwndQueryRedirectionInfo', # 0x2cf
    'NtUserHwndSetRedirectionInfo', # 0x2d0
    'NtUserImpersonateDdeClientWindow', # 0x2d1
    'NtUserInitTask', # 0x2d2
    'NtUserInitialize', # 0x2d3
    'NtUserInitializeClientPfnArrays', # 0x2d4
    'NtUserInjectGesture', # 0x2d5
    'NtUserInternalGetWindowIcon', # 0x2d6
    'NtUserIsTopLevelWindow', # 0x2d7
    'NtUserIsTouchWindow', # 0x2d8
    'NtUserLoadKeyboardLayoutEx', # 0x2d9
    'NtUserLockWindowStation', # 0x2da
    'NtUserLockWorkStation', # 0x2db
    'NtUserLogicalToPhysicalPoint', # 0x2dc
    'NtUserMNDragLeave', # 0x2dd
    'NtUserMNDragOver', # 0x2de
    'NtUserMagControl', # 0x2df
    'NtUserMagGetContextInformation', # 0x2e0
    'NtUserMagSetContextInformation', # 0x2e1
    'NtUserManageGestureHandlerWindow', # 0x2e2
    'NtUserMenuItemFromPoint', # 0x2e3
    'NtUserMinMaximize', # 0x2e4
    'NtUserModifyWindowTouchCapability', # 0x2e5
    'NtUserNotifyIMEStatus', # 0x2e6
    'NtUserOpenInputDesktop', # 0x2e7
    'NtUserOpenThreadDesktop', # 0x2e8
    'NtUserPaintMonitor', # 0x2e9
    'NtUserPhysicalToLogicalPoint', # 0x2ea
    'NtUserPrintWindow', # 0x2eb
    'NtUserQueryDisplayConfig', # 0x2ec
    'NtUserQueryInformationThread', # 0x2ed
    'NtUserQueryInputContext', # 0x2ee
    'NtUserQuerySendMessage', # 0x2ef
    'NtUserRealChildWindowFromPoint', # 0x2f0
    'NtUserRealWaitMessageEx', # 0x2f1
    'NtUserRegisterErrorReportingDialog', # 0x2f2
    'NtUserRegisterHotKey', # 0x2f3
    'NtUserRegisterRawInputDevices', # 0x2f4
    'NtUserRegisterServicesProcess', # 0x2f5
    'NtUserRegisterSessionPort', # 0x2f6
    'NtUserRegisterTasklist', # 0x2f7
    'NtUserRegisterUserApiHook', # 0x2f8
    'NtUserRemoteConnect', # 0x2f9
    'NtUserRemoteRedrawRectangle', # 0x2fa
    'NtUserRemoteRedrawScreen', # 0x2fb
    'NtUserRemoteStopScreenUpdates', # 0x2fc
    'NtUserRemoveClipboardFormatListener', # 0x2fd
    'NtUserResolveDesktopForWOW', # 0x2fe
    'NtUserSendTouchInput', # 0x2ff
    'NtUserSetAppImeLevel', # 0x300
    'NtUserSetChildWindowNoActivate', # 0x301
    'NtUserSetClassWord', # 0x302
    'NtUserSetCursorContents', # 0x303
    'NtUserSetDisplayConfig', # 0x304
    'NtUserSetGestureConfig', # 0x305
    'NtUserSetImeHotKey', # 0x306
    'NtUserSetImeInfoEx', # 0x307
    'NtUserSetImeOwnerWindow', # 0x308
    'NtUserSetInternalWindowPos', # 0x309
    'NtUserSetLayeredWindowAttributes', # 0x30a
    'NtUserSetMenu', # 0x30b
    'NtUserSetMenuContextHelpId', # 0x30c
    'NtUserSetMenuFlagRtoL', # 0x30d
    'NtUserSetMirrorRendering', # 0x30e
    'NtUserSetObjectInformation', # 0x30f
    'NtUserSetProcessDPIAware', # 0x310
    'NtUserSetShellWindowEx', # 0x311
    'NtUserSetSysColors', # 0x312
    'NtUserSetSystemCursor', # 0x313
    'NtUserSetSystemTimer', # 0x314
    'NtUserSetThreadLayoutHandles', # 0x315
    'NtUserSetWindowCompositionAttribute', # 0x316
    'NtUserSetWindowDisplayAffinity', # 0x317
    'NtUserSetWindowRgnEx', # 0x318
    'NtUserSetWindowStationUser', # 0x319
    'NtUserSfmDestroyLogicalSurfaceBinding', # 0x31a
    'NtUserSfmDxBindSwapChain', # 0x31b
    'NtUserSfmDxGetSwapChainStats', # 0x31c
    'NtUserSfmDxOpenSwapChain', # 0x31d
    'NtUserSfmDxQuerySwapChainBindingStatus', # 0x31e
    'NtUserSfmDxReleaseSwapChain', # 0x31f
    'NtUserSfmDxReportPendingBindingsToDwm', # 0x320
    'NtUserSfmDxSetSwapChainBindingStatus', # 0x321
    'NtUserSfmDxSetSwapChainStats', # 0x322
    'NtUserSfmGetLogicalSurfaceBinding', # 0x323
    'NtUserShowSystemCursor', # 0x324
    'NtUserSoundSentry', # 0x325
    'NtUserSwitchDesktop', # 0x326
    'NtUserTestForInteractiveUser', # 0x327
    'NtUserTrackPopupMenuEx', # 0x328
    'NtUserUnloadKeyboardLayout', # 0x329
    'NtUserUnlockWindowStation', # 0x32a
    'NtUserUnregisterHotKey', # 0x32b
    'NtUserUnregisterSessionPort', # 0x32c
    'NtUserUnregisterUserApiHook', # 0x32d
    'NtUserUpdateInputContext', # 0x32e
    'NtUserUpdateInstance', # 0x32f
    'NtUserUpdateLayeredWindow', # 0x330
    'NtUserUpdatePerUserSystemParameters', # 0x331
    'NtUserUpdateWindowTransform', # 0x332
    'NtUserUserHandleGrantAccess', # 0x333
    'NtUserValidateHandleSecure', # 0x334
    'NtUserWaitForInputIdle', # 0x335
    'NtUserWaitForMsgAndEvent', # 0x336
    'NtUserWindowFromPhysicalPoint', # 0x337
    'NtUserYieldTask', # 0x338
    'NtUserSetClassLongPtr', # 0x339
    'NtUserSetWindowLongPtr', # 0x33a
    ],
]
