# AutoGraph reference

This reference document describes the semantics of AutoGraph transformations.

In `@tf.function`, AutoGraph allows running Eager-style code as a TensorFlow
graph.

*   [Introduction](intro.md)
*   [Interacting with the generated code](generated_code.md)
*   [Debugging AutoGraph code](debugging.md)
*   [Control flow](control_flow.md)
*   [Functions and function calls](functions.md)
*   [Error handling](error_handling.md)
*   [Limitations](limitations.md)
*   [Common errors](common_errors.md)

For more information on AutoGraph, see the following articles:

*   [AutoGraph tutorial](https://www.tensorflow.org/alpha/beta/autograph)
*   [Eager tutorial](https://www.tensorflow.org/alpha/guide/eager)
*   [TensorFlow 2.0 Alpha](https://www.tensorflow.org/alpha)
*   [AutoGraph blog post](https://medium.com/tensorflow/autograph-converts-python-into-tensorflow-graphs-b2a871f87ec7)
