# Copyright (C) 2006-2011 Ola Skavhaug and Simula Research Laboratory
#
# This file is part of Viper.
#
# Viper is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Viper is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with Viper. If not, see <http://www.gnu.org/licenses/>.

__cite__      = """Ola Skavhaug, Viper Visualization Software,
http://www.fenics.org/wiki/viper/"""
__version__ = "1.0.0"

__doc__ = r"""
Viper

A simple mesh plotter and run--time visualization module for plotting and
saving simulation data. The class C{Viper} can visualize solutions given as
numpy arrays, and meshes that provide the two methods C{cells()} and
C{coordinates()}. These methods should return numpy arrays specifying the
node-element ordering and coordinates of the nodes, respectively.

Citation: %s

""" % __cite__


from viper import *
