/**
 * This file is a part of VideoCut package.
 * ---------------------------------------------------------------------- 
 * Copyright (C) 2007-2008 troorl
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ---------------------------------------------------------------------- 
 *
 * @author troorl <troorl@gmail.com>
 */

#include "TColorChoser.h"

TColorChoser::TColorChoser(QWidget *parent)
	:QWidget(parent)
{
	colorLabel = new QLabel(this);
	colorSelect = new QPushButton(this);
	colorSelect->setMaximumWidth(30);
	tmp_color = QColor(0, 0, 0, 255);
	
	hLayout = new QHBoxLayout;
	hLayout->addWidget(colorLabel);
	hLayout->addWidget(colorSelect);
	
	connect(colorSelect, SIGNAL(clicked()), this, SLOT(S_SelectColor()));
}

void TColorChoser::setText(QString text)
{
	colorLabel->setText(text);
}

void TColorChoser::setColor(QColor color)
{
	tmp_color = color;
	colorSelect->setStyleSheet(this->toStyle(tmp_color.name()));
}

QColor TColorChoser::getColor()
{
	return tmp_color;
}

QHBoxLayout *TColorChoser::getLayout()
{
	return hLayout;
}

void TColorChoser::S_SelectColor()
{
	bool ok;
	tmp_color.setRgba(QColorDialog::getRgba(tmp_color.rgba(), &ok, this));
	
	if(ok)
	{
		colorSelect->setStyleSheet(this->toStyle(tmp_color.name()));
		
		emit colorChanged(tmp_color);
	} 
	else 
	{
		//
	}
	
}

QString TColorChoser::toStyle(QString color_name)
{
	return "QPushButton { background-color: " + color_name + "; border-color: black; border-width: 1px; border-style: solid; }";
}
