
# API Docs

This Document documents the types introduced by the VictoriaMetrics to be consumed by users.

> Note this document is generated from code comments. When contributing a change to this document please do so by changing the code comments.

## Table of Contents
* [VMAlertmanager](#vmalertmanager)
* [VMAlertmanagerList](#vmalertmanagerlist)
* [VMAlertmanagerSpec](#vmalertmanagerspec)
* [VMAlertmanagerStatus](#vmalertmanagerstatus)
* [EmailConfig](#emailconfig)
* [HTTPConfig](#httpconfig)
* [InhibitRule](#inhibitrule)
* [MuteTimeInterval](#mutetimeinterval)
* [OpsGenieConfig](#opsgenieconfig)
* [OpsGenieConfigResponder](#opsgenieconfigresponder)
* [PagerDutyConfig](#pagerdutyconfig)
* [PushoverConfig](#pushoverconfig)
* [Receiver](#receiver)
* [Route](#route)
* [SlackAction](#slackaction)
* [SlackConfig](#slackconfig)
* [SlackConfirmationField](#slackconfirmationfield)
* [SlackField](#slackfield)
* [TimeInterval](#timeinterval)
* [TimeRange](#timerange)
* [VMAlertmanagerConfig](#vmalertmanagerconfig)
* [VMAlertmanagerConfigList](#vmalertmanagerconfiglist)
* [VMAlertmanagerConfigSpec](#vmalertmanagerconfigspec)
* [VMAlertmanagerConfigStatus](#vmalertmanagerconfigstatus)
* [VictorOpsConfig](#victoropsconfig)
* [WeChatConfig](#wechatconfig)
* [WebhookConfig](#webhookconfig)
* [VMAgent](#vmagent)
* [VMAgentList](#vmagentlist)
* [VMAgentRemoteWriteSettings](#vmagentremotewritesettings)
* [VMAgentRemoteWriteSpec](#vmagentremotewritespec)
* [VMAgentSpec](#vmagentspec)
* [VMAgentStatus](#vmagentstatus)
* [BasicAuth](#basicauth)
* [DiscoverySelector](#discoveryselector)
* [EmbeddedHPA](#embeddedhpa)
* [EmbeddedObjectMetadata](#embeddedobjectmetadata)
* [EmbeddedPersistentVolumeClaim](#embeddedpersistentvolumeclaim)
* [EmbeddedPodDisruptionBudgetSpec](#embeddedpoddisruptionbudgetspec)
* [EmbeddedProbes](#embeddedprobes)
* [ServiceSpec](#servicespec)
* [StorageSpec](#storagespec)
* [VMAlert](#vmalert)
* [VMAlertDatasourceSpec](#vmalertdatasourcespec)
* [VMAlertList](#vmalertlist)
* [VMAlertNotifierSpec](#vmalertnotifierspec)
* [VMAlertRemoteReadSpec](#vmalertremotereadspec)
* [VMAlertRemoteWriteSpec](#vmalertremotewritespec)
* [VMAlertSpec](#vmalertspec)
* [VMAlertStatus](#vmalertstatus)
* [VMSingle](#vmsingle)
* [VMSingleList](#vmsinglelist)
* [VMSingleSpec](#vmsinglespec)
* [VMSingleStatus](#vmsinglestatus)
* [Rule](#rule)
* [RuleGroup](#rulegroup)
* [VMRule](#vmrule)
* [VMRuleList](#vmrulelist)
* [VMRuleSpec](#vmrulespec)
* [APIServerConfig](#apiserverconfig)
* [Endpoint](#endpoint)
* [NamespaceSelector](#namespaceselector)
* [OAuth2](#oauth2)
* [ProxyAuth](#proxyauth)
* [QueueConfig](#queueconfig)
* [RelabelConfig](#relabelconfig)
* [SecretOrConfigMap](#secretorconfigmap)
* [TLSConfig](#tlsconfig)
* [VMScrapeParams](#vmscrapeparams)
* [VMServiceScrape](#vmservicescrape)
* [VMServiceScrapeList](#vmservicescrapelist)
* [VMServiceScrapeSpec](#vmservicescrapespec)
* [ArbitraryFSAccessThroughSMsConfig](#arbitraryfsaccessthroughsmsconfig)
* [PodMetricsEndpoint](#podmetricsendpoint)
* [VMPodScrape](#vmpodscrape)
* [VMPodScrapeList](#vmpodscrapelist)
* [VMPodScrapeSpec](#vmpodscrapespec)
* [Image](#image)
* [InsertPorts](#insertports)
* [VMBackup](#vmbackup)
* [VMCluster](#vmcluster)
* [VMClusterList](#vmclusterlist)
* [VMClusterSpec](#vmclusterspec)
* [VMClusterStatus](#vmclusterstatus)
* [VMInsert](#vminsert)
* [VMSelect](#vmselect)
* [VMStorage](#vmstorage)
* [VMNodeScrape](#vmnodescrape)
* [VMNodeScrapeList](#vmnodescrapelist)
* [VMNodeScrapeSpec](#vmnodescrapespec)
* [CRDRef](#crdref)
* [StaticRef](#staticref)
* [TargetRef](#targetref)
* [VMUser](#vmuser)
* [VMUserList](#vmuserlist)
* [VMUserSpec](#vmuserspec)
* [EmbeddedIngress](#embeddedingress)
* [VMAuth](#vmauth)
* [VMAuthList](#vmauthlist)
* [VMAuthSpec](#vmauthspec)
* [TargetEndpoint](#targetendpoint)
* [VMStaticScrape](#vmstaticscrape)
* [VMStaticScrapeList](#vmstaticscrapelist)
* [VMStaticScrapeSpec](#vmstaticscrapespec)
* [ProbeTargetIngress](#probetargetingress)
* [VMProbe](#vmprobe)
* [VMProbeList](#vmprobelist)
* [VMProbeSpec](#vmprobespec)
* [VMProbeTargetStaticConfig](#vmprobetargetstaticconfig)
* [VMProbeTargets](#vmprobetargets)
* [VMProberSpec](#vmproberspec)

## VMAlertmanager

VMAlertmanager represents Victoria-Metrics deployment for Alertmanager.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ObjectMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#objectmeta-v1-meta) | false |
| spec | Specification of the desired behavior of the VMAlertmanager cluster. More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#spec-and-status | [VMAlertmanagerSpec](#vmalertmanagerspec) | true |
| status | Most recent observed status of the VMAlertmanager cluster. Operator API itself. More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#spec-and-status | *[VMAlertmanagerStatus](#vmalertmanagerstatus) | false |

[Back to TOC](#table-of-contents)

## VMAlertmanagerList

VMAlertmanagerList is a list of Alertmanagers.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata | Standard list metadata More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#metadata | [metav1.ListMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#listmeta-v1-meta) | false |
| items | List of Alertmanagers | [][VMAlertmanager](#vmalertmanager) | true |

[Back to TOC](#table-of-contents)

## VMAlertmanagerSpec

VMAlertmanagerSpec is a specification of the desired behavior of the VMAlertmanager cluster. More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| podMetadata | PodMetadata configures Labels and Annotations which are propagated to the alertmanager pods. | *[EmbeddedObjectMetadata](#embeddedobjectmetadata) | false |
| image | Image - docker image settings for VMAlertmanager if no specified operator uses default config version | [Image](#image) | false |
| imagePullSecrets | ImagePullSecrets An optional list of references to secrets in the same namespace to use for pulling images from registries see http://kubernetes.io/docs/user-guide/images#specifying-imagepullsecrets-on-a-pod | [][v1.LocalObjectReference](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#localobjectreference-v1-core) | false |
| secrets | Secrets is a list of Secrets in the same namespace as the VMAlertmanager object, which shall be mounted into the VMAlertmanager Pods. The Secrets are mounted into /etc/vm/secrets/&lt;secret-name&gt; | []string | false |
| configMaps | ConfigMaps is a list of ConfigMaps in the same namespace as the VMAlertmanager object, which shall be mounted into the VMAlertmanager Pods. The ConfigMaps are mounted into /etc/vm/configs/&lt;configmap-name&gt;. | []string | false |
| configRawYaml | ConfigRawYaml - raw configuration for alertmanager, it helps it to start without secret. priority -&gt; hardcoded ConfigRaw -&gt; ConfigRaw, provided by user -&gt; ConfigSecret. | string | false |
| configSecret | ConfigSecret is the name of a Kubernetes Secret in the same namespace as the VMAlertmanager object, which contains configuration for this VMAlertmanager, configuration must be inside secret key: alertmanager.yaml. It must be created by user. instance. Defaults to &#39;vmalertmanager-&lt;alertmanager-name&gt;&#39; The secret is mounted into /etc/alertmanager/config. | string | false |
| logLevel | Log level for VMAlertmanager to be configured with. | string | false |
| logFormat | LogFormat for VMAlertmanager to be configured with. | string | false |
| replicaCount | ReplicaCount Size is the expected size of the alertmanager cluster. The controller will eventually make the size of the running cluster equal to the expected | *int32 | false |
| retention | Retention Time duration VMAlertmanager shall retain data for. Default is &#39;120h&#39;, and must match the regular expression `[0-9]+(ms\|s\|m\|h)` (milliseconds seconds minutes hours). | string | false |
| storage | Storage is the definition of how storage will be used by the VMAlertmanager instances. | *[StorageSpec](#storagespec) | false |
| volumes | Volumes allows configuration of additional volumes on the output StatefulSet definition. Volumes specified will be appended to other volumes that are generated as a result of StorageSpec objects. | [][v1.Volume](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#volume-v1-core) | false |
| volumeMounts | VolumeMounts allows configuration of additional VolumeMounts on the output StatefulSet definition. VolumeMounts specified will be appended to other VolumeMounts in the alertmanager container, that are generated as a result of StorageSpec objects. | [][v1.VolumeMount](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#volumemount-v1-core) | false |
| externalURL | ExternalURL the VMAlertmanager instances will be available under. This is necessary to generate correct URLs. This is necessary if VMAlertmanager is not served from root of a DNS name. | string | false |
| routePrefix | RoutePrefix VMAlertmanager registers HTTP handlers for. This is useful, if using ExternalURL and a proxy is rewriting HTTP routes of a request, and the actual ExternalURL is still true, but the server serves requests under a different route prefix. For example for use with `kubectl proxy`. | string | false |
| paused | Paused If set to true all actions on the underlaying managed objects are not goint to be performed, except for delete actions. | bool | false |
| nodeSelector | NodeSelector Define which Nodes the Pods are scheduled on. | map[string]string | false |
| resources | Resources container resource request and limits, https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/ | [v1.ResourceRequirements](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#resourcerequirements-v1-core) | false |
| affinity | Affinity If specified, the pod&#39;s scheduling constraints. | *[v1.Affinity](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#affinity-v1-core) | false |
| tolerations | Tolerations If specified, the pod&#39;s tolerations. | [][v1.Toleration](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#toleration-v1-core) | false |
| securityContext | SecurityContext holds pod-level security attributes and common container settings. This defaults to the default PodSecurityContext. | *[v1.PodSecurityContext](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#podsecuritycontext-v1-core) | false |
| serviceAccountName | ServiceAccountName is the name of the ServiceAccount to use | string | false |
| schedulerName | SchedulerName - defines kubernetes scheduler name | string | false |
| runtimeClassName | RuntimeClassName - defines runtime class for kubernetes pod. https://kubernetes.io/docs/concepts/containers/runtime-class/ | *string | false |
| podSecurityPolicyName | PodSecurityPolicyName - defines name for podSecurityPolicy in case of empty value, prefixedName will be used. | string | false |
| listenLocal | ListenLocal makes the VMAlertmanager server listen on loopback, so that it does not bind against the Pod IP. Note this is only for the VMAlertmanager UI, not the gossip communication. | bool | false |
| containers | Containers allows injecting additional containers or patching existing containers. This is meant to allow adding an authentication proxy to an VMAlertmanager pod. | [][v1.Container](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#container-v1-core) | false |
| initContainers | InitContainers allows adding initContainers to the pod definition. Those can be used to e.g. fetch secrets for injection into the VMAlertmanager configuration from external sources. Any errors during the execution of an initContainer will lead to a restart of the Pod. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/ Using initContainers for any use case other then secret fetching is entirely outside the scope of what the maintainers will support and by doing so, you accept that this behaviour may break at any time without notice. | [][v1.Container](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#container-v1-core) | false |
| priorityClassName | PriorityClassName class assigned to the Pods | string | false |
| hostNetwork | HostNetwork controls whether the pod may use the node network namespace | bool | false |
| dnsPolicy | DNSPolicy sets DNS policy for the pod | [v1.DNSPolicy](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#pod-v1-core) | false |
| topologySpreadConstraints | TopologySpreadConstraints embedded kubernetes pod configuration option, controls how pods are spread across your cluster among failure-domains such as regions, zones, nodes, and other user-defined topology domains https://kubernetes.io/docs/concepts/workloads/pods/pod-topology-spread-constraints/ | [][v1.TopologySpreadConstraint](https://kubernetes.io/docs/concepts/workloads/pods/pod-topology-spread-constraints/) | false |
| additionalPeers | AdditionalPeers allows injecting a set of additional Alertmanagers to peer with to form a highly available cluster. | []string | false |
| clusterAdvertiseAddress | ClusterAdvertiseAddress is the explicit address to advertise in cluster. Needs to be provided for non RFC1918 [1] (public) addresses. [1] RFC1918: https://tools.ietf.org/html/rfc1918 | string | false |
| portName | PortName used for the pods and governing service. This defaults to web | string | false |
| serviceSpec | ServiceSpec that will be added to vmalertmanager service spec | *[ServiceSpec](#servicespec) | false |
| podDisruptionBudget | PodDisruptionBudget created by operator | *[EmbeddedPodDisruptionBudgetSpec](#embeddedpoddisruptionbudgetspec) | false |
| selectAllByDefault | SelectAllByDefault changes default behavior for empty CRD selectors, such ConfigSelector. with selectAllScrapes: true and undefined ConfigSelector and ConfigNamespaceSelector Operator selects all exist alertManagerConfigs with selectAllScrapes: false - selects nothing | bool | false |
| configSelector | ConfigSelector defines selector for VMAlertmanagerConfig, result config will be merged with with Raw or Secret config. Works in combination with NamespaceSelector. NamespaceSelector nil - only objects at VMAlertmanager namespace. Selector nil - only objects at NamespaceSelector namespaces. If both nil - behaviour controlled by selectAllByDefault | *[metav1.LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#labelselector-v1-meta) | false |
| configNamespaceSelector | \n ConfigNamespaceSelector defines namespace selector for VMAlertmanagerConfig.\nWorks in combination with Selector. NamespaceSelector nil - only objects at VMAlertmanager namespace. Selector nil - only objects at NamespaceSelector namespaces. If both nil - behaviour controlled by selectAllByDefault | *[metav1.LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#labelselector-v1-meta) | false |
| extraArgs | ExtraArgs that will be passed to  VMAuth pod for example remoteWrite.tmpDataPath: /tmp | map[string]string | false |
| extraEnvs | ExtraEnvs that will be added to VMAuth pod | [][v1.EnvVar](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#envvar-v1-core) | false |
| disableNamespaceMatcher | DisableNamespaceMatcher disables namespace label matcher for VMAlertmanagerConfig It may be useful if alert doesn&#39;t have namespace label for some reason | bool | false |
| rollingUpdateStrategy | RollingUpdateStrategy defines strategy for application updates Default is OnDelete, in this case operator handles update process Can be changed for RollingUpdate | [appsv1.StatefulSetUpdateStrategyType](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#statefulsetupdatestrategy-v1-apps) | false |

[Back to TOC](#table-of-contents)

## VMAlertmanagerStatus

VMAlertmanagerStatus is the most recent observed status of the VMAlertmanager cluster Operator API itself. More info: https://github.com/kubernetes/community/blob/master/contributors/devel/sig-architecture/api-conventions.md#spec-and-status

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| paused | Paused Represents whether any actions on the underlaying managed objects are being performed. Only delete actions will be performed. | bool | true |
| replicas | ReplicaCount Total number of non-terminated pods targeted by this VMAlertmanager cluster (their labels match the selector). | int32 | true |
| updatedReplicas | UpdatedReplicas Total number of non-terminated pods targeted by this VMAlertmanager cluster that have the desired version spec. | int32 | true |
| availableReplicas | AvailableReplicas Total number of available pods (ready for at least minReadySeconds) targeted by this VMAlertmanager cluster. | int32 | true |
| unavailableReplicas | UnavailableReplicas Total number of unavailable pods targeted by this VMAlertmanager cluster. | int32 | true |

[Back to TOC](#table-of-contents)

## EmailConfig

EmailConfig configures notifications via Email.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| send_resolved | SendResolved controls notify about resolved alerts. | *bool | false |
| to | The email address to send notifications to. | string | false |
| from | The sender address. | string | false |
| hello | The hostname to identify to the SMTP server. | string | false |
| smarthost | The SMTP host through which emails are sent. | string | false |
| auth_username | The username to use for authentication. | string | false |
| auth_password | AuthPassword defines secret name and key at CRD namespace. | *[v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| auth_secret | AuthSecret defines secrent name and key at CRD namespace. It must contain the CRAM-MD5 secret. | *[v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| auth_identity | The identity to use for authentication. | string | false |
| headers | Further headers email header key/value pairs. Overrides any headers previously set by the notification implementation. | map[string]string | false |
| html | The HTML body of the email notification. | string | false |
| text | The text body of the email notification. | string | false |
| require_tls | The SMTP TLS requirement. Note that Go does not support unencrypted connections to remote SMTP endpoints. | *bool | false |
| tls_config | TLS configuration | *[TLSConfig](#tlsconfig) | false |

[Back to TOC](#table-of-contents)

## HTTPConfig

HTTPConfig defines a client HTTP configuration. See https://prometheus.io/docs/alerting/latest/configuration/#http_config

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| basic_auth | BasicAuth for the client. | *[BasicAuth](#basicauth) | false |
| bearer_token_secret | The secret&#39;s key that contains the bearer token It must be at them same namespace as CRD | *[v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| bearer_token_file | BearerTokenFile defines filename for bearer token, it must be mounted to pod. | string | false |
| tls_config | TLS configuration for the client. | *[TLSConfig](#tlsconfig) | false |
| proxyURL | Optional proxy URL. | string | false |

[Back to TOC](#table-of-contents)

## InhibitRule

InhibitRule defines an inhibition rule that allows to mute alerts when other alerts are already firing. Note, it doesn't support deprecated alertmanager config options. See https://prometheus.io/docs/alerting/latest/configuration/#inhibit_rule

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| target_matchers | TargetMatchers defines a list of matchers that have to be fulfilled by the target alerts to be muted. | []string | false |
| source_matchers | SourceMatchers defines a list of matchers for which one or more alerts have to exist for the inhibition to take effect. | []string | false |
| equal | Labels that must have an equal value in the source and target alert for the inhibition to take effect. | []string | false |

[Back to TOC](#table-of-contents)

## MuteTimeInterval

MuteTimeInterval for alerts

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| name | Name of interval | string | false |
| time_intervals | TimeIntervals interval configuration | [][TimeInterval](#timeinterval) | true |

[Back to TOC](#table-of-contents)

## OpsGenieConfig

OpsGenieConfig configures notifications via OpsGenie. See https://prometheus.io/docs/alerting/latest/configuration/#opsgenie_config

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| send_resolved | SendResolved controls notify about resolved alerts. | *bool | false |
| api_key | The secret&#39;s key that contains the OpsGenie API key. It must be at them same namespace as CRD | *[v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| apiURL | The URL to send OpsGenie API requests to. | string | false |
| message | Alert text limited to 130 characters. | string | false |
| description | Description of the incident. | string | false |
| source | Backlink to the sender of the notification. | string | false |
| tags | Comma separated list of tags attached to the notifications. | string | false |
| note | Additional alert note. | string | false |
| priority | Priority level of alert. Possible values are P1, P2, P3, P4, and P5. | string | false |
| details | A set of arbitrary key/value pairs that provide further detail about the incident. | map[string]string | false |
| responders | List of responders responsible for notifications. | [][OpsGenieConfigResponder](#opsgenieconfigresponder) | false |
| httpConfig | HTTP client configuration. | *[HTTPConfig](#httpconfig) | false |

[Back to TOC](#table-of-contents)

## OpsGenieConfigResponder

OpsGenieConfigResponder defines a responder to an incident. One of `id`, `name` or `username` has to be defined.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| id | ID of the responder. | string | false |
| name | Name of the responder. | string | false |
| username | Username of the responder. | string | false |
| type | Type of responder. | string | true |

[Back to TOC](#table-of-contents)

## PagerDutyConfig

PagerDutyConfig configures notifications via PagerDuty. See https://prometheus.io/docs/alerting/latest/configuration/#pagerduty_config

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| send_resolved | SendResolved controls notify about resolved alerts. | *bool | false |
| routing_key | The secret&#39;s key that contains the PagerDuty integration key (when using Events API v2). Either this field or `serviceKey` needs to be defined. It must be at them same namespace as CRD | *[v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| service_key | The secret&#39;s key that contains the PagerDuty service key (when using integration type \&#34;Prometheus\&#34;). Either this field or `routingKey` needs to be defined. It must be at them same namespace as CRD | *[v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| url | The URL to send requests to. | string | false |
| client | Client identification. | string | false |
| client_url | Backlink to the sender of notification. | string | false |
| description | Description of the incident. | string | false |
| severity | Severity of the incident. | string | false |
| class | The class/type of the event. | string | false |
| group | A cluster or grouping of sources. | string | false |
| component | The part or component of the affected system that is broken. | string | false |
| details | Arbitrary key/value pairs that provide further detail about the incident. | map[string]string | false |
| http_config | HTTP client configuration. | *[HTTPConfig](#httpconfig) | false |

[Back to TOC](#table-of-contents)

## PushoverConfig

PushoverConfig configures notifications via Pushover. See https://prometheus.io/docs/alerting/latest/configuration/#pushover_config

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| send_resolved | SendResolved controls notify about resolved alerts. | *bool | false |
| user_key | The secret&#39;s key that contains the recipient user’s user key. It must be at them same namespace as CRD | *[v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| token | The secret&#39;s key that contains the registered application’s API token, see https://pushover.net/apps. It must be at them same namespace as CRD | *[v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| title | Notification title. | string | false |
| message | Notification message. | string | false |
| url | A supplementary URL shown alongside the message. | string | false |
| url_title | A title for supplementary URL, otherwise just the URL is shown | string | false |
| sound | The name of one of the sounds supported by device clients to override the user&#39;s default sound choice | string | false |
| priority | Priority, see https://pushover.net/api#priority | string | false |
| retry | How often the Pushover servers will send the same notification to the user. Must be at least 30 seconds. | string | false |
| expire | How long your notification will continue to be retried for, unless the user acknowledges the notification. | string | false |
| html | Whether notification message is HTML or plain text. | bool | false |
| http_config | HTTP client configuration. | *[HTTPConfig](#httpconfig) | false |

[Back to TOC](#table-of-contents)

## Receiver

Receiver defines one or more notification integrations.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| name | Name of the receiver. Must be unique across all items from the list. | string | true |
| email_configs | EmailConfigs defines email notification configurations. | [][EmailConfig](#emailconfig) | false |
| pagerduty_configs | PagerDutyConfigs defines pager duty notification configurations. | [][PagerDutyConfig](#pagerdutyconfig) | false |
| pushover_configs | PushoverConfigs defines push over notification configurations. | [][PushoverConfig](#pushoverconfig) | false |
| slack_configs | SlackConfigs defines slack notification configurations. | [][SlackConfig](#slackconfig) | false |
| opsgenie_configs | OpsGenieConfigs defines ops genie notification configurations. | [][OpsGenieConfig](#opsgenieconfig) | false |
| webhook_configs | WebhookConfigs defines webhook notification configurations. | [][WebhookConfig](#webhookconfig) | false |
| victorops_configs | VictorOpsConfigs defines victor ops notification configurations. | [][VictorOpsConfig](#victoropsconfig) | false |
| wechat_configs | WeChatConfigs defines wechat notification configurations. | [][WeChatConfig](#wechatconfig) | false |

[Back to TOC](#table-of-contents)

## Route

Route defines a node in the routing tree.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| receiver | Name of the receiver for this route. | string | true |
| group_by | List of labels to group by. | []string | false |
| group_wait | How long to wait before sending the initial notification. | string | false |
| group_interval | How long to wait before sending an updated notification. | string | false |
| repeat_interval | How long to wait before repeating the last notification. | string | false |
| matchers | List of matchers that the alert’s labels should match. For the first level route, the operator adds a namespace: \&#34;CRD_NS\&#34; matcher. https://prometheus.io/docs/alerting/latest/configuration/#matcher | []string | false |
| continue | Continue indicating whether an alert should continue matching subsequent sibling nodes. It will always be true for the first-level route. | bool | false |
| routes | Child routes. | []*[Route](#route) | false |
| mute_time_intervals | MuteTimeIntervals for alerts | []string | false |

[Back to TOC](#table-of-contents)

## SlackAction

SlackAction configures a single Slack action that is sent with each notification. See https://api.slack.com/docs/message-attachments#action_fields and https://api.slack.com/docs/message-buttons for more information.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| type |  | string | true |
| text |  | string | true |
| url |  | string | false |
| style |  | string | false |
| name |  | string | false |
| value |  | string | false |
| confirm |  | *[SlackConfirmationField](#slackconfirmationfield) | false |

[Back to TOC](#table-of-contents)

## SlackConfig

SlackConfig configures notifications via Slack. See https://prometheus.io/docs/alerting/latest/configuration/#slack_config

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| send_resolved | SendResolved controls notify about resolved alerts. | *bool | false |
| api_url | The secret&#39;s key that contains the Slack webhook URL. It must be at them same namespace as CRD | *[v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| channel | The channel or user to send notifications to. | string | false |
| username |  | string | false |
| color |  | string | false |
| title |  | string | false |
| title_link |  | string | false |
| pretext |  | string | false |
| text |  | string | false |
| fields | A list of Slack fields that are sent with each notification. | [][SlackField](#slackfield) | false |
| short_fields |  | bool | false |
| footer |  | string | false |
| fallback |  | string | false |
| callback_id |  | string | false |
| icon_emoji |  | string | false |
| icon_url |  | string | false |
| image_url |  | string | false |
| thumb_url |  | string | false |
| link_names |  | bool | false |
| mrkdwn_in |  | []string | false |
| actions | A list of Slack actions that are sent with each notification. | [][SlackAction](#slackaction) | false |
| http_config | HTTP client configuration. | *[HTTPConfig](#httpconfig) | false |

[Back to TOC](#table-of-contents)

## SlackConfirmationField

SlackConfirmationField protect users from destructive actions or particularly distinguished decisions by asking them to confirm their button click one more time. See https://api.slack.com/docs/interactive-message-field-guide#confirmation_fields for more information.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| text |  | string | true |
| title |  | string | false |
| ok_text |  | string | false |
| dismiss_text |  | string | false |

[Back to TOC](#table-of-contents)

## SlackField

See https://api.slack.com/docs/message-attachments#fields for more information.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| title |  | string | true |
| value |  | string | true |
| short |  | *bool | false |

[Back to TOC](#table-of-contents)

## TimeInterval

TimeInterval defines intervals of time

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| times | Times defines time range for mute | [][TimeRange](#timerange) | false |
| weekdays | Weekdays defines list of days of the week, where the week begins on Sunday and ends on Saturday. | []string | false |
| days_of_month | DayOfMonth defines list of numerical days in the month. Days begin at 1. Negative values are also accepted. for example, [&#39;1:5&#39;, &#39;-3:-1&#39;] | []string | false |
| months | Months  defines list of calendar months identified by a case-insentive name (e.g. ‘January’) or numeric 1. For example, [&#39;1:3&#39;, &#39;may:august&#39;, &#39;december&#39;] | []string | false |
| years | Years defines numerical list of years, ranges are accepted. For example, [&#39;2020:2022&#39;, &#39;2030&#39;] | []string | false |

[Back to TOC](#table-of-contents)

## TimeRange

TimeRange  ranges inclusive of the starting time and exclusive of the end time

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| start_time | StartTime for example  HH:MM | string | true |
| end_time | EndTime for example HH:MM | string | true |

[Back to TOC](#table-of-contents)

## VMAlertmanagerConfig

VMAlertmanagerConfig is the Schema for the vmalertmanagerconfigs API

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ObjectMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#objectmeta-v1-meta) | false |
| spec |  | [VMAlertmanagerConfigSpec](#vmalertmanagerconfigspec) | false |
| status |  | [VMAlertmanagerConfigStatus](#vmalertmanagerconfigstatus) | false |

[Back to TOC](#table-of-contents)

## VMAlertmanagerConfigList

VMAlertmanagerConfigList contains a list of VMAlertmanagerConfig

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ListMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#listmeta-v1-meta) | false |
| items |  | [][VMAlertmanagerConfig](#vmalertmanagerconfig) | true |

[Back to TOC](#table-of-contents)

## VMAlertmanagerConfigSpec

VMAlertmanagerConfigSpec defines configuration for VMAlertmanagerConfig

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| route | Route definition for alertmanager, may include nested routes. | *[Route](#route) | true |
| receivers | Receivers defines alert receivers. without defined Route, receivers will be skipped. | [][Receiver](#receiver) | true |
| inhibit_rules | InhibitRules will only apply for alerts matching the resource&#39;s namespace. | [][InhibitRule](#inhibitrule) | false |
| mute_time_intervals | MuteTimeInterval - global mute time See https://prometheus.io/docs/alerting/latest/configuration/#mute_time_interval | [][MuteTimeInterval](#mutetimeinterval) | false |

[Back to TOC](#table-of-contents)

## VMAlertmanagerConfigStatus

VMAlertmanagerConfigStatus defines the observed state of VMAlertmanagerConfig

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| reason | ErrorReason describes validation or any other errors. | string | false |

[Back to TOC](#table-of-contents)

## VictorOpsConfig

VictorOpsConfig configures notifications via VictorOps. See https://prometheus.io/docs/alerting/latest/configuration/#victorops_config

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| send_resolved | SendResolved controls notify about resolved alerts. | *bool | false |
| api_key | The secret&#39;s key that contains the API key to use when talking to the VictorOps API. It must be at them same namespace as CRD | *[v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| api_url | The VictorOps API URL. | string | false |
| routing_key | A key used to map the alert to a team. | string | true |
| message_type | Describes the behavior of the alert (CRITICAL, WARNING, INFO). | string | false |
| entity_display_name | Contains summary of the alerted problem. | string | false |
| state_message | Contains long explanation of the alerted problem. | string | false |
| monitoring_tool | The monitoring tool the state message is from. | string | false |
| custom_fields | Additional custom fields for notification. | map[string]string | false |
| http_config | The HTTP client&#39;s configuration. | *[HTTPConfig](#httpconfig) | false |

[Back to TOC](#table-of-contents)

## WeChatConfig

WeChatConfig configures notifications via WeChat. See https://prometheus.io/docs/alerting/latest/configuration/#wechat_config

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| send_resolved | SendResolved controls notify about resolved alerts. | *bool | false |
| api_secret | The secret&#39;s key that contains the WeChat API key. The secret needs to be in the same namespace as the AlertmanagerConfig object and accessible by the Prometheus Operator. | *[v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| api_url | The WeChat API URL. | string | false |
| corp_id | The corp id for authentication. | string | false |
| agent_id |  | string | false |
| to_user |  | string | false |
| to_party |  | string | false |
| to_tag |  | string | false |
| message | API request data as defined by the WeChat API. | string | false |
| message_type |  | string | false |
| http_config | HTTP client configuration. | *[HTTPConfig](#httpconfig) | false |

[Back to TOC](#table-of-contents)

## WebhookConfig

WebhookConfig configures notifications via a generic receiver supporting the webhook payload. See https://prometheus.io/docs/alerting/latest/configuration/#webhook_config

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| send_resolved | SendResolved controls notify about resolved alerts. | *bool | false |
| url | URL to send requests to, one of `urlSecret` and `url` must be defined. | *string | false |
| url_secret | URLSecret defines secret name and key at the CRD namespace. It must contain the webhook URL. one of `urlSecret` and `url` must be defined. | *[v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| http_config | HTTP client configuration. | *[HTTPConfig](#httpconfig) | false |
| max_alerts | Maximum number of alerts to be sent per webhook message. When 0, all alerts are included. | int32 | false |

[Back to TOC](#table-of-contents)

## VMAgent

VMAgent - is a tiny but brave agent, which helps you collect metrics from various sources and stores them in VictoriaMetrics or any other Prometheus-compatible storage system that supports the remote_write protocol.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ObjectMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#objectmeta-v1-meta) | false |
| spec |  | [VMAgentSpec](#vmagentspec) | false |
| status |  | [VMAgentStatus](#vmagentstatus) | false |

[Back to TOC](#table-of-contents)

## VMAgentList

VMAgentList contains a list of VMAgent

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ListMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#listmeta-v1-meta) | false |
| items |  | [][VMAgent](#vmagent) | true |

[Back to TOC](#table-of-contents)

## VMAgentRemoteWriteSettings

VMAgentRemoteWriteSettings - defines global settings for all remoteWrite urls.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| maxBlockSize | The maximum size in bytes of unpacked request to send to remote storage | *int32 | false |
| maxDiskUsagePerURL | The maximum file-based buffer size in bytes at -remoteWrite.tmpDataPath | *int32 | false |
| queues | The number of concurrent queues | *int32 | false |
| showURL | Whether to show -remoteWrite.url in the exported metrics. It is hidden by default, since it can contain sensitive auth info | *bool | false |
| tmpDataPath | Path to directory where temporary data for remote write component is stored (default vmagent-remotewrite-data) | *string | false |
| flushInterval | Interval for flushing the data to remote storage. (default 1s) | *string | false |
| label | Optional labels in the form &#39;name=value&#39; to add to all the metrics before sending them | map[string]string | false |

[Back to TOC](#table-of-contents)

## VMAgentRemoteWriteSpec

VMAgentRemoteWriteSpec defines the remote storage configuration for VmAgent

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| url | URL of the endpoint to send samples to. | string | true |
| basicAuth | BasicAuth allow an endpoint to authenticate over basic authentication | *[BasicAuth](#basicauth) | false |
| bearerTokenSecret | Optional bearer auth token to use for -remoteWrite.url | *[v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| urlRelabelConfig | ConfigMap with relabeling config which is applied to metrics before sending them to the corresponding -remoteWrite.url | *v1.ConfigMapKeySelector | false |
| oauth2 | OAuth2 defines auth configuration | *[OAuth2](#oauth2) | false |
| tlsConfig | TLSConfig describes tls configuration for remote write target | *[TLSConfig](#tlsconfig) | false |
| sendTimeout | Timeout for sending a single block of data to -remoteWrite.url (default 1m0s) | *string | false |

[Back to TOC](#table-of-contents)

## VMAgentSpec

VMAgentSpec defines the desired state of VMAgent

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| podMetadata | PodMetadata configures Labels and Annotations which are propagated to the vmagent pods. | *[EmbeddedObjectMetadata](#embeddedobjectmetadata) | false |
| image | Image - docker image settings for VMAgent if no specified operator uses default config version | [Image](#image) | false |
| imagePullSecrets | ImagePullSecrets An optional list of references to secrets in the same namespace to use for pulling images from registries see http://kubernetes.io/docs/user-guide/images#specifying-imagepullsecrets-on-a-pod | [][v1.LocalObjectReference](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#localobjectreference-v1-core) | false |
| secrets | Secrets is a list of Secrets in the same namespace as the vmagent object, which shall be mounted into the vmagent Pods. will be mounted at path /etc/vm/secrets | []string | false |
| configMaps | ConfigMaps is a list of ConfigMaps in the same namespace as the vmagent object, which shall be mounted into the vmagent Pods. will be mounted at path  /etc/vm/configs | []string | false |
| logLevel | LogLevel for VMAgent to be configured with. INFO, WARN, ERROR, FATAL, PANIC | string | false |
| logFormat | LogFormat for VMAgent to be configured with. | string | false |
| replicaCount | ReplicaCount is the expected size of the VMAgent cluster. The controller will eventually make the size of the running cluster equal to the expected size. NOTE enable VMSingle deduplication for replica usage | *int32 | false |
| volumes | Volumes allows configuration of additional volumes on the output deploy definition. Volumes specified will be appended to other volumes that are generated as a result of StorageSpec objects. | [][v1.Volume](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#volume-v1-core) | false |
| volumeMounts | VolumeMounts allows configuration of additional VolumeMounts on the output deploy definition. VolumeMounts specified will be appended to other VolumeMounts in the vmagent container, that are generated as a result of StorageSpec objects. | [][v1.VolumeMount](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#volumemount-v1-core) | false |
| resources | Resources container resource request and limits, https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/ if not specified - default setting will be used | [v1.ResourceRequirements](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#resourcerequirements-v1-core) | false |
| affinity | Affinity If specified, the pod&#39;s scheduling constraints. | *[v1.Affinity](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#affinity-v1-core) | false |
| tolerations | Tolerations If specified, the pod&#39;s tolerations. | [][v1.Toleration](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#toleration-v1-core) | false |
| securityContext | SecurityContext holds pod-level security attributes and common container settings. This defaults to the default PodSecurityContext. | *[v1.PodSecurityContext](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#podsecuritycontext-v1-core) | false |
| serviceAccountName | ServiceAccountName is the name of the ServiceAccount to use to run the VMAgent Pods. | string | false |
| schedulerName | SchedulerName - defines kubernetes scheduler name | string | false |
| runtimeClassName | RuntimeClassName - defines runtime class for kubernetes pod. https://kubernetes.io/docs/concepts/containers/runtime-class/ | *string | false |
| host_aliases | HostAliases provides mapping between ip and hostnames, that would be propagated to pod, cannot be used with HostNetwork. | []v1.HostAlias | false |
| podSecurityPolicyName | PodSecurityPolicyName - defines name for podSecurityPolicy in case of empty value, prefixedName will be used. | string | false |
| containers | Containers property allows to inject additions sidecars or to patch existing containers. It can be useful for proxies, backup, etc. | [][v1.Container](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#container-v1-core) | false |
| initContainers | InitContainers allows adding initContainers to the pod definition. Those can be used to e.g. fetch secrets for injection into the vmagent configuration from external sources. Any errors during the execution of an initContainer will lead to a restart of the Pod. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/ Using initContainers for any use case other then secret fetching is entirely outside the scope of what the maintainers will support and by doing so, you accept that this behaviour may break at any time without notice. | [][v1.Container](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#container-v1-core) | false |
| priorityClassName | PriorityClassName assigned to the Pods | string | false |
| hostNetwork | HostNetwork controls whether the pod may use the node network namespace | bool | false |
| dnsPolicy | DNSPolicy set DNS policy for the pod | [v1.DNSPolicy](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#pod-v1-core) | false |
| topologySpreadConstraints | TopologySpreadConstraints embedded kubernetes pod configuration option, controls how pods are spread across your cluster among failure-domains such as regions, zones, nodes, and other user-defined topology domains https://kubernetes.io/docs/concepts/workloads/pods/pod-topology-spread-constraints/ | [][v1.TopologySpreadConstraint](https://kubernetes.io/docs/concepts/workloads/pods/pod-topology-spread-constraints/) | false |
| scrapeInterval | ScrapeInterval defines how often scrape targets by default | string | false |
| aPIServerConfig | APIServerConfig allows specifying a host and auth methods to access apiserver. If left empty, VMAgent is assumed to run inside of the cluster and will discover API servers automatically and use the pod&#39;s CA certificate and bearer token file at /var/run/secrets/kubernetes.io/serviceaccount/. | *[APIServerConfig](#apiserverconfig) | false |
| overrideHonorLabels | OverrideHonorLabels if set to true overrides all user configured honor_labels. If HonorLabels is set in ServiceScrape or PodScrape to true, this overrides honor_labels to false. | bool | false |
| overrideHonorTimestamps | OverrideHonorTimestamps allows to globally enforce honoring timestamps in all scrape configs. | bool | false |
| ignoreNamespaceSelectors | IgnoreNamespaceSelectors if set to true will ignore NamespaceSelector settings from the podscrape and vmservicescrape configs, and they will only discover endpoints within their current namespace.  Defaults to false. | bool | false |
| enforcedNamespaceLabel | EnforcedNamespaceLabel enforces adding a namespace label of origin for each alert and metric that is user created. The label value will always be the namespace of the object that is being created. | string | false |
| vmAgentExternalLabelName | VMAgentExternalLabelName Name of vmAgent external label used to denote vmAgent instance name. Defaults to the value of `prometheus`. External label will _not_ be added when value is set to empty string (`\&#34;\&#34;`). | *string | false |
| externalLabels | ExternalLabels The labels to add to any time series scraped by vmagent. it doesn&#39;t affect metrics ingested directly by push API&#39;s | map[string]string | false |
| remoteWrite | RemoteWrite list of victoria metrics /some other remote write system for vm it must looks like: http://victoria-metrics-single:8429/api/v1/write or for cluster different url https://github.com/VictoriaMetrics/VictoriaMetrics/tree/master/app/vmagent#splitting-data-streams-among-multiple-systems | [][VMAgentRemoteWriteSpec](#vmagentremotewritespec) | true |
| remoteWriteSettings | RemoteWriteSettings defines global settings for all remoteWrite urls. | *[VMAgentRemoteWriteSettings](#vmagentremotewritesettings) | false |
| relabelConfig | RelabelConfig ConfigMap with global relabel config -remoteWrite.relabelConfig This relabeling is applied to all the collected metrics before sending them to remote storage. | *v1.ConfigMapKeySelector | false |
| selectAllByDefault | SelectAllByDefault changes default behavior for empty CRD selectors, such ServiceScrapeSelector. with selectAllScrapes: true and empty serviceScrapeSelector and ServiceScrapeNamespaceSelector Operator selects all exist serviceScrapes with selectAllScrapes: false - selects nothing | bool | false |
| serviceScrapeSelector | ServiceScrapeSelector defines ServiceScrapes to be selected for target discovery. Works in combination with NamespaceSelector. NamespaceSelector nil - only objects at VMAgent namespace. Selector nil - only objects at NamespaceSelector namespaces. If both nil - behaviour controlled by selectAllByDefault | *[metav1.LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#labelselector-v1-meta) | false |
| serviceScrapeNamespaceSelector | ServiceScrapeNamespaceSelector Namespaces to be selected for VMServiceScrape discovery. Works in combination with Selector. NamespaceSelector nil - only objects at VMAgent namespace. Selector nil - only objects at NamespaceSelector namespaces. If both nil - behaviour controlled by selectAllByDefault | *[metav1.LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#labelselector-v1-meta) | false |
| podScrapeSelector | PodScrapeSelector defines PodScrapes to be selected for target discovery. Works in combination with NamespaceSelector. NamespaceSelector nil - only objects at VMAgent namespace. Selector nil - only objects at NamespaceSelector namespaces. If both nil - behaviour controlled by selectAllByDefault | *[metav1.LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#labelselector-v1-meta) | false |
| podScrapeNamespaceSelector | PodScrapeNamespaceSelector defines Namespaces to be selected for VMPodScrape discovery. Works in combination with Selector. NamespaceSelector nil - only objects at VMAgent namespace. Selector nil - only objects at NamespaceSelector namespaces. If both nil - behaviour controlled by selectAllByDefault | *[metav1.LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#labelselector-v1-meta) | false |
| probeSelector | ProbeSelector defines VMProbe to be selected for target probing. Works in combination with NamespaceSelector. NamespaceSelector nil - only objects at VMAgent namespace. Selector nil - only objects at NamespaceSelector namespaces. If both nil - behaviour controlled by selectAllByDefault | *[metav1.LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#labelselector-v1-meta) | false |
| probeNamespaceSelector | ProbeNamespaceSelector defines Namespaces to be selected for VMProbe discovery. Works in combination with Selector. NamespaceSelector nil - only objects at VMAgent namespace. Selector nil - only objects at NamespaceSelector namespaces. If both nil - behaviour controlled by selectAllByDefault | *[metav1.LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#labelselector-v1-meta) | false |
| nodeScrapeSelector | NodeScrapeSelector defines VMNodeScrape to be selected for scraping. Works in combination with NamespaceSelector. NamespaceSelector nil - only objects at VMAgent namespace. Selector nil - only objects at NamespaceSelector namespaces. If both nil - behaviour controlled by selectAllByDefault | *[metav1.LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#labelselector-v1-meta) | false |
| nodeScrapeNamespaceSelector | NodeScrapeNamespaceSelector defines Namespaces to be selected for VMNodeScrape discovery. Works in combination with Selector. NamespaceSelector nil - only objects at VMAgent namespace. Selector nil - only objects at NamespaceSelector namespaces. If both nil - behaviour controlled by selectAllByDefault | *[metav1.LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#labelselector-v1-meta) | false |
| staticScrapeSelector | StaticScrapeSelector defines PodScrapes to be selected for target discovery. Works in combination with NamespaceSelector. If both nil - match everything. NamespaceSelector nil - only objects at VMAgent namespace. Selector nil - only objects at NamespaceSelector namespaces. | *[metav1.LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#labelselector-v1-meta) | false |
| staticScrapeNamespaceSelector | StaticScrapeNamespaceSelector defines Namespaces to be selected for VMStaticScrape discovery. Works in combination with NamespaceSelector. NamespaceSelector nil - only objects at VMAgent namespace. Selector nil - only objects at NamespaceSelector namespaces. If both nil - behaviour controlled by selectAllByDefault | *[metav1.LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#labelselector-v1-meta) | false |
| inlineScrapeConfig | InlineScrapeConfig allows for an array of scrape jobs to be passed as a YAML formatted string (it is recommended to use the literal block style indicator "\|"). As scrape configs are appended, the user is responsible to make sure it is valid. Note that using this feature may expose the possibility to break upgrades of VMAgent. It is advised to review VMAgent release notes to ensure that no incompatible scrape configs are going to break VMAgent after the upgrade. | string | false |
| additionalScrapeConfigs | AdditionalScrapeConfigs As scrape configs are appended, the user is responsible to make sure it is valid. Note that using this feature may expose the possibility to break upgrades of VMAgent. It is advised to review VMAgent release notes to ensure that no incompatible scrape configs are going to break VMAgent after the upgrade. | *[v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| arbitraryFSAccessThroughSMs | ArbitraryFSAccessThroughSMs configures whether configuration based on a service scrape can access arbitrary files on the file system of the VMAgent container e.g. bearer token files. | [ArbitraryFSAccessThroughSMsConfig](#arbitraryfsaccessthroughsmsconfig) | false |
| insertPorts | InsertPorts - additional listen ports for data ingestion. | *[InsertPorts](#insertports) | false |
| port | Port listen address | string | false |
| extraArgs | ExtraArgs that will be passed to  VMAgent pod for example remoteWrite.tmpDataPath: /tmp it would be converted to flag --remoteWrite.tmpDataPath=/tmp | map[string]string | false |
| extraEnvs | ExtraEnvs that will be added to VMAgent pod | [][v1.EnvVar](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#envvar-v1-core) | false |
| serviceSpec | ServiceSpec that will be added to vmagent service spec | *[ServiceSpec](#servicespec) | false |
| shardCount | ShardCount - numbers of shards of VMAgent in this case operator will use 1 deployment/sts per shard with replicas count according to spec.replicas https://victoriametrics.github.io/vmagent.html#scraping-big-number-of-targets | *int | false |
| updateStrategy | UpdateStrategy - overrides default update strategy. works only for deployments, statefulset always use OnDelete. | *[appsv1.DeploymentStrategyType](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#deploymentstrategy-v1-apps) | false |
| rollingUpdate | RollingUpdate - overrides deployment update params. | *[appsv1.RollingUpdateDeployment](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#rollingupdatedeployment-v1-apps) | false |
| podDisruptionBudget | PodDisruptionBudget created by operator | *[EmbeddedPodDisruptionBudgetSpec](#embeddedpoddisruptionbudgetspec) | false |
| nodeSelector | NodeSelector Define which Nodes the Pods are scheduled on. | map[string]string | false |
| serviceScrapeRelabelTemplate | ServiceScrapeRelabelTemplate defines relabel config, that will be added to each VMServiceScrape. it&#39;s useful for adding specific labels to all targets | []*[RelabelConfig](#relabelconfig) | false |
| podScrapeRelabelTemplate | PodScrapeRelabelTemplate defines relabel config, that will be added to each VMPodScrape. it&#39;s useful for adding specific labels to all targets | []*[RelabelConfig](#relabelconfig) | false |
| nodeScrapeRelabelTemplate | NodeScrapeRelabelTemplate defines relabel config, that will be added to each VMNodeScrape. it&#39;s useful for adding specific labels to all targets | []*[RelabelConfig](#relabelconfig) | false |
| staticScrapeRelabelTemplate | StaticScrapeRelabelTemplate defines relabel config, that will be added to each VMStaticScrape. it&#39;s useful for adding specific labels to all targets | []*[RelabelConfig](#relabelconfig) | false |
| probeScrapeRelabelTemplate | ProbeScrapeRelabelTemplate defines relabel config, that will be added to each VMProbeScrape. it&#39;s useful for adding specific labels to all targets | []*[RelabelConfig](#relabelconfig) | false |

[Back to TOC](#table-of-contents)

## VMAgentStatus

VmAgentStatus defines the observed state of VmAgent

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| replicas | ReplicaCount Total number of non-terminated pods targeted by this VMAgent cluster (their labels match the selector). | int32 | true |
| updatedReplicas | UpdatedReplicas Total number of non-terminated pods targeted by this VMAgent cluster that have the desired version spec. | int32 | true |
| availableReplicas | AvailableReplicas Total number of available pods (ready for at least minReadySeconds) targeted by this VMAgent cluster. | int32 | true |
| unavailableReplicas | UnavailableReplicas Total number of unavailable pods targeted by this VMAgent cluster. | int32 | true |

[Back to TOC](#table-of-contents)

## BasicAuth

BasicAuth allow an endpoint to authenticate over basic authentication More info: https://prometheus.io/docs/operating/configuration/#endpoints

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| username | The secret in the service scrape namespace that contains the username for authentication. It must be at them same namespace as CRD | [v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| password | The secret in the service scrape namespace that contains the password for authentication. It must be at them same namespace as CRD | [v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| password_file | PasswordFile defines path to password file at disk | string | false |

[Back to TOC](#table-of-contents)

## DiscoverySelector

DiscoverySelector can be used at CRD components discovery

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| namespaceSelector |  | *[NamespaceSelector](#namespaceselector) | false |
| labelSelector |  | *[metav1.LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#labelselector-v1-meta) | false |

[Back to TOC](#table-of-contents)

## EmbeddedHPA

EmbeddedHPA embeds HorizontalPodAutoScaler spec v2. https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/horizontal-pod-autoscaler-v2beta2/

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| minReplicas |  | *int32 | false |
| maxReplicas |  | int32 | false |
| metrics |  | [][v2beta2.MetricSpec](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#metricspec-v2beta2-autoscaling) | false |
| behaviour |  | *[v2beta2.HorizontalPodAutoscalerBehavior](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#horizontalpodautoscalerbehavior-v2beta2-autoscaling) | false |

[Back to TOC](#table-of-contents)

## EmbeddedObjectMetadata

EmbeddedObjectMetadata contains a subset of the fields included in k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta Only fields which are relevant to embedded resources are included.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| name | Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names | string | false |
| labels | Labels Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels | map[string]string | false |
| annotations | Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations | map[string]string | false |

[Back to TOC](#table-of-contents)

## EmbeddedPersistentVolumeClaim

EmbeddedPersistentVolumeClaim is an embedded version of k8s.io/api/core/v1.PersistentVolumeClaim. It contains TypeMeta and a reduced ObjectMeta.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata | EmbeddedMetadata contains metadata relevant to an EmbeddedResource. | [EmbeddedObjectMetadata](#embeddedobjectmetadata) | false |
| spec | Spec defines the desired characteristics of a volume requested by a pod author. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims | [v1.PersistentVolumeClaimSpec](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#persistentvolumeclaimspec-v1-core) | false |
| status | Status represents the current information/status of a persistent volume claim. Read-only. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims | [v1.PersistentVolumeClaimStatus](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#persistentvolumeclaimstatus-v1-core) | false |

[Back to TOC](#table-of-contents)

## EmbeddedPodDisruptionBudgetSpec



| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| minAvailable | An eviction is allowed if at least \&#34;minAvailable\&#34; pods selected by \&#34;selector\&#34; will still be available after the eviction, i.e. even in the absence of the evicted pod.  So for example you can prevent all voluntary evictions by specifying \&#34;100%\&#34;. | *intstr.IntOrString | false |
| maxUnavailable | An eviction is allowed if at most \&#34;maxUnavailable\&#34; pods selected by \&#34;selector\&#34; are unavailable after the eviction, i.e. even in absence of the evicted pod. For example, one can prevent all voluntary evictions by specifying 0. This is a mutually exclusive setting with \&#34;minAvailable\&#34;. | *intstr.IntOrString | false |

[Back to TOC](#table-of-contents)

## EmbeddedProbes

EmbeddedProbes - it allows to override some probe params. its not necessary to specify all options, operator will replace missing spec with default values.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| livenessProbe | LivenessProbe that will be added CRD pod | *v1.Probe | false |
| readinessProbe | ReadinessProbe that will be added CRD pod | *v1.Probe | false |
| startupProbe | StartupProbe that will be added to CRD pod | *v1.Probe | false |

[Back to TOC](#table-of-contents)

## ServiceSpec

ServiceSpec defines additional service for CRD with user-defined params. by default, some of fields can be inherited from default service definition for the CRD: labels,selector, ports. if metadata.name is not defined, service will have format {{CRD_TYPE}}-{{CRD_NAME}}-additional-service.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata | EmbeddedObjectMetadata defines objectMeta for additional service. | [EmbeddedObjectMetadata](#embeddedobjectmetadata) | false |
| spec | ServiceSpec describes the attributes that a user creates on a service. More info: https://kubernetes.io/docs/concepts/services-networking/service/ | v1.ServiceSpec | true |

[Back to TOC](#table-of-contents)

## StorageSpec

StorageSpec defines the configured storage for a group Prometheus servers. If neither `emptyDir` nor `volumeClaimTemplate` is specified, then by default an [EmptyDir](https://kubernetes.io/docs/concepts/storage/volumes/#emptydir) will be used.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| disableMountSubPath | Deprecated: subPath usage will be disabled by default in a future release, this option will become unnecessary. DisableMountSubPath allows to remove any subPath usage in volume mounts. | bool | false |
| emptyDir | EmptyDirVolumeSource to be used by the Prometheus StatefulSets. If specified, used in place of any volumeClaimTemplate. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir | *[v1.EmptyDirVolumeSource](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#emptydirvolumesource-v1-core) | false |
| volumeClaimTemplate | A PVC spec to be used by the VMAlertManager StatefulSets. | [EmbeddedPersistentVolumeClaim](#embeddedpersistentvolumeclaim) | false |

[Back to TOC](#table-of-contents)

## VMAlert

VMAlert  executes a list of given alerting or recording rules against configured address.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ObjectMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#objectmeta-v1-meta) | false |
| spec |  | [VMAlertSpec](#vmalertspec) | false |
| status |  | [VMAlertStatus](#vmalertstatus) | false |

[Back to TOC](#table-of-contents)

## VMAlertDatasourceSpec

VMAgentRemoteReadSpec defines the remote storage configuration for VmAlert to read alerts from

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| url | Victoria Metrics or VMSelect url. Required parameter. E.g. http://127.0.0.1:8428 | string | true |
| basicAuth | BasicAuth allow datasource to authenticate over basic authentication | *[BasicAuth](#basicauth) | false |
| tlsConfig | TLSConfig describes tls configuration for datasource target | *[TLSConfig](#tlsconfig) | false |

[Back to TOC](#table-of-contents)

## VMAlertList

VMAlertList contains a list of VMAlert

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ListMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#listmeta-v1-meta) | false |
| items |  | [][VMAlert](#vmalert) | true |

[Back to TOC](#table-of-contents)

## VMAlertNotifierSpec

VMAlertNotifierSpec defines the notifier url for sending information about alerts

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| url | AlertManager url.  E.g. http://127.0.0.1:9093 | string | false |
| selector | Selector allows service discovery for alertmanager in this case all matched vmalertmanager replicas will be added into vmalert notifier.url as statefulset pod.fqdn | *[DiscoverySelector](#discoveryselector) | false |
| basicAuth | BasicAuth allow notifier to authenticate over basic authentication | *[BasicAuth](#basicauth) | false |
| tlsConfig | TLSConfig describes tls configuration for notifier | *[TLSConfig](#tlsconfig) | false |

[Back to TOC](#table-of-contents)

## VMAlertRemoteReadSpec

VMAgentRemoteReadSpec defines the remote storage configuration for VmAlert to read alerts from

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| url | URL of the endpoint to send samples to. | string | true |
| basicAuth | BasicAuth allow an endpoint to authenticate over basic authentication | *[BasicAuth](#basicauth) | false |
| lookback | Lookback defines how far to look into past for alerts timeseries. For example, if lookback=1h then range from now() to now()-1h will be scanned. (default 1h0m0s) Applied only to RemoteReadSpec | *string | false |
| tlsConfig | TLSConfig describes tls configuration for remote read target | *[TLSConfig](#tlsconfig) | false |

[Back to TOC](#table-of-contents)

## VMAlertRemoteWriteSpec

VMAgentRemoteWriteSpec defines the remote storage configuration for VmAlert

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| url | URL of the endpoint to send samples to. | string | true |
| basicAuth | BasicAuth allow an endpoint to authenticate over basic authentication | *[BasicAuth](#basicauth) | false |
| concurrency | Defines number of readers that concurrently write into remote storage (default 1) | *int32 | false |
| flushInterval | Defines interval of flushes to remote write endpoint (default 5s) | *string | false |
| maxBatchSize | Defines defines max number of timeseries to be flushed at once (default 1000) | *int32 | false |
| maxQueueSize | Defines the max number of pending datapoints to remote write endpoint (default 100000) | *int32 | false |
| tlsConfig | TLSConfig describes tls configuration for remote write target | *[TLSConfig](#tlsconfig) | false |

[Back to TOC](#table-of-contents)

## VMAlertSpec

VMAlertSpec defines the desired state of VMAlert

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| podMetadata | PodMetadata configures Labels and Annotations which are propagated to the VMAlert pods. | *[EmbeddedObjectMetadata](#embeddedobjectmetadata) | false |
| image | Image - docker image settings for VMAlert if no specified operator uses default config version | [Image](#image) | false |
| imagePullSecrets | ImagePullSecrets An optional list of references to secrets in the same namespace to use for pulling images from registries see http://kubernetes.io/docs/user-guide/images#specifying-imagepullsecrets-on-a-pod | [][v1.LocalObjectReference](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#localobjectreference-v1-core) | false |
| secrets | Secrets is a list of Secrets in the same namespace as the VMAlert object, which shall be mounted into the VMAlert Pods. The Secrets are mounted into /etc/vm/secrets/&lt;secret-name&gt;. | []string | false |
| configMaps | ConfigMaps is a list of ConfigMaps in the same namespace as the VMAlert object, which shall be mounted into the VMAlert Pods. The ConfigMaps are mounted into /etc/vm/configs/&lt;configmap-name&gt;. | []string | false |
| logFormat | LogFormat for VMAlert to be configured with. default or json | string | false |
| logLevel | LogLevel for VMAlert to be configured with. | string | false |
| replicaCount | ReplicaCount is the expected size of the VMAlert cluster. The controller will eventually make the size of the running cluster equal to the expected size. | *int32 | false |
| volumes | Volumes allows configuration of additional volumes on the output Deployment definition. Volumes specified will be appended to other volumes that are generated as a result of StorageSpec objects. | [][v1.Volume](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#volume-v1-core) | false |
| volumeMounts | VolumeMounts allows configuration of additional VolumeMounts on the output Deployment definition. VolumeMounts specified will be appended to other VolumeMounts in the VMAlert container, that are generated as a result of StorageSpec objects. | [][v1.VolumeMount](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#volumemount-v1-core) | false |
| resources | Resources container resource request and limits, https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/ | [v1.ResourceRequirements](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#resourcerequirements-v1-core) | false |
| affinity | Affinity If specified, the pod&#39;s scheduling constraints. | *[v1.Affinity](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#affinity-v1-core) | false |
| tolerations | Tolerations If specified, the pod&#39;s tolerations. | [][v1.Toleration](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#toleration-v1-core) | false |
| securityContext | SecurityContext holds pod-level security attributes and common container settings. This defaults to the default PodSecurityContext. | *[v1.PodSecurityContext](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#podsecuritycontext-v1-core) | false |
| serviceAccountName | ServiceAccountName is the name of the ServiceAccount to use to run the VMAlert Pods. | string | false |
| schedulerName | SchedulerName - defines kubernetes scheduler name | string | false |
| runtimeClassName | RuntimeClassName - defines runtime class for kubernetes pod. https://kubernetes.io/docs/concepts/containers/runtime-class/ | *string | false |
| podSecurityPolicyName | PodSecurityPolicyName - defines name for podSecurityPolicy in case of empty value, prefixedName will be used. | string | false |
| containers | Containers property allows to inject additions sidecars or to patch existing containers. It can be useful for proxies, backup, etc. | [][v1.Container](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#container-v1-core) | false |
| initContainers | InitContainers allows adding initContainers to the pod definition. Those can be used to e.g. fetch secrets for injection into the VMAlert configuration from external sources. Any errors during the execution of an initContainer will lead to a restart of the Pod. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/ Using initContainers for any use case other then secret fetching is entirely outside the scope of what the maintainers will support and by doing so, you accept that this behaviour may break at any time without notice. | [][v1.Container](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#container-v1-core) | false |
| priorityClassName | Priority class assigned to the Pods | string | false |
| hostNetwork | HostNetwork controls whether the pod may use the node network namespace | bool | false |
| dnsPolicy | DNSPolicy sets DNS policy for the pod | [v1.DNSPolicy](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#pod-v1-core) | false |
| topologySpreadConstraints | TopologySpreadConstraints embedded kubernetes pod configuration option, controls how pods are spread across your cluster among failure-domains such as regions, zones, nodes, and other user-defined topology domains https://kubernetes.io/docs/concepts/workloads/pods/pod-topology-spread-constraints/ | [][v1.TopologySpreadConstraint](https://kubernetes.io/docs/concepts/workloads/pods/pod-topology-spread-constraints/) | false |
| evaluationInterval | EvaluationInterval how often evalute rules by default | string | false |
| enforcedNamespaceLabel | EnforcedNamespaceLabel enforces adding a namespace label of origin for each alert and metric that is user created. The label value will always be the namespace of the object that is being created. | string | false |
| selectAllByDefault | SelectAllByDefault changes default behavior for empty CRD selectors, such RuleSelector. with selectAllByDefault: true and empty serviceScrapeSelector and RuleNamespaceSelector Operator selects all exist serviceScrapes with selectAllByDefault: false - selects nothing | bool | false |
| ruleSelector | RuleSelector selector to select which VMRules to mount for loading alerting rules from. Works in combination with NamespaceSelector. If both nil - behaviour controlled by selectAllByDefault NamespaceSelector nil - only objects at VMAlert namespace. | *[metav1.LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#labelselector-v1-meta) | false |
| ruleNamespaceSelector | RuleNamespaceSelector to be selected for VMRules discovery. Works in combination with Selector. If both nil - behaviour controlled by selectAllByDefault NamespaceSelector nil - only objects at VMAlert namespace. | *[metav1.LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#labelselector-v1-meta) | false |
| port | Port for listen | string | false |
| notifier | Notifier prometheus alertmanager endpoint spec. Required at least one of  notifier or notifiers. e.g. http://127.0.0.1:9093 If specified both notifier and notifiers, notifier will be added as last element to notifiers. | *[VMAlertNotifierSpec](#vmalertnotifierspec) | false |
| notifiers | Notifiers prometheus alertmanager endpoints. Required at least one of  notifier or notifiers. e.g. http://127.0.0.1:9093 If specified both notifier and notifiers, notifier will be added as last element to notifiers. | [][VMAlertNotifierSpec](#vmalertnotifierspec) | false |
| remoteWrite | RemoteWrite Optional URL to remote-write compatible storage to persist vmalert state and rule results to. Rule results will be persisted according to each rule. Alerts state will be persisted in the form of time series named ALERTS and ALERTS_FOR_STATE see -remoteWrite.url docs in vmalerts for details. E.g. http://127.0.0.1:8428 | *[VMAlertRemoteWriteSpec](#vmalertremotewritespec) | false |
| remoteRead | RemoteRead Optional URL to read vmalert state (persisted via RemoteWrite) This configuration only makes sense if alerts state has been successfully persisted (via RemoteWrite) before. see -remoteRead.url docs in vmalerts for details. E.g. http://127.0.0.1:8428 | *[VMAlertRemoteReadSpec](#vmalertremotereadspec) | false |
| rulePath | RulePath to the file with alert rules. Supports patterns. Flag can be specified multiple times. Examples: -rule /path/to/file. Path to a single file with alerting rules -rule dir/*.yaml -rule /*.yaml. Relative path to all .yaml files in folder, absolute path to all .yaml files in root. by default operator adds /etc/vmalert/configs/base/vmalert.yaml | []string | false |
| datasource | Datasource Victoria Metrics or VMSelect url. Required parameter. e.g. http://127.0.0.1:8428 | [VMAlertDatasourceSpec](#vmalertdatasourcespec) | true |
| extraArgs | ExtraArgs that will be passed to  VMAlert pod for example -remoteWrite.tmpDataPath=/tmp | map[string]string | false |
| extraEnvs | ExtraEnvs that will be added to VMAlert pod | [][v1.EnvVar](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#envvar-v1-core) | false |
| externalLabels | ExternalLabels in the form &#39;name: value&#39; to add to all generated recording rules and alerts. | map[string]string | false |
| serviceSpec | ServiceSpec that will be added to vmalert service spec | *[ServiceSpec](#servicespec) | false |
| updateStrategy | UpdateStrategy - overrides default update strategy. | *[appsv1.DeploymentStrategyType](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#deploymentstrategy-v1-apps) | false |
| rollingUpdate | RollingUpdate - overrides deployment update params. | *[appsv1.RollingUpdateDeployment](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#rollingupdatedeployment-v1-apps) | false |
| podDisruptionBudget | PodDisruptionBudget created by operator | *[EmbeddedPodDisruptionBudgetSpec](#embeddedpoddisruptionbudgetspec) | false |
| nodeSelector | NodeSelector Define which Nodes the Pods are scheduled on. | map[string]string | false |

[Back to TOC](#table-of-contents)

## VMAlertStatus

VmAlertStatus defines the observed state of VmAlert

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| replicas | ReplicaCount Total number of non-terminated pods targeted by this VMAlert cluster (their labels match the selector). | int32 | true |
| updatedReplicas | UpdatedReplicas Total number of non-terminated pods targeted by this VMAlert cluster that have the desired version spec. | int32 | true |
| availableReplicas | AvailableReplicas Total number of available pods (ready for at least minReadySeconds) targeted by this VMAlert cluster. | int32 | true |
| unavailableReplicas | UnavailableReplicas Total number of unavailable pods targeted by this VMAlert cluster. | int32 | true |

[Back to TOC](#table-of-contents)

## VMSingle

VMSingle  is fast, cost-effective and scalable time-series database.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ObjectMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#objectmeta-v1-meta) | false |
| spec |  | [VMSingleSpec](#vmsinglespec) | false |
| status |  | [VMSingleStatus](#vmsinglestatus) | false |

[Back to TOC](#table-of-contents)

## VMSingleList

VMSingleList contains a list of VMSingle

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ListMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#listmeta-v1-meta) | false |
| items |  | [][VMSingle](#vmsingle) | true |

[Back to TOC](#table-of-contents)

## VMSingleSpec

VMSingleSpec defines the desired state of VMSingle

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| podMetadata | PodMetadata configures Labels and Annotations which are propagated to the VMSingle pods. | *[EmbeddedObjectMetadata](#embeddedobjectmetadata) | false |
| image | Image - docker image settings for VMSingle if no specified operator uses default config version | [Image](#image) | false |
| imagePullSecrets | ImagePullSecrets An optional list of references to secrets in the same namespace to use for pulling images from registries see http://kubernetes.io/docs/user-guide/images#specifying-imagepullsecrets-on-a-pod | [][v1.LocalObjectReference](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#localobjectreference-v1-core) | false |
| secrets | Secrets is a list of Secrets in the same namespace as the VMSingle object, which shall be mounted into the VMSingle Pods. | []string | false |
| configMaps | ConfigMaps is a list of ConfigMaps in the same namespace as the VMSingle object, which shall be mounted into the VMSingle Pods. | []string | false |
| logLevel | LogLevel for victoria metrics single to be configured with. | string | false |
| logFormat | LogFormat for VMSingle to be configured with. | string | false |
| replicaCount | ReplicaCount is the expected size of the VMSingle it can be 0 or 1 if you need more - use vm cluster | *int32 | false |
| storageDataPath | StorageDataPath disables spec.storage option and overrides arg for victoria-metrics binary --storageDataPath, its users responsibility to mount proper device into given path. | string | false |
| storage | Storage is the definition of how storage will be used by the VMSingle by default it`s empty dir | *[v1.PersistentVolumeClaimSpec](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#persistentvolumeclaimspec-v1-core) | false |
| volumes | Volumes allows configuration of additional volumes on the output deploy definition. Volumes specified will be appended to other volumes that are generated as a result of StorageSpec objects. | [][v1.Volume](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#volume-v1-core) | false |
| volumeMounts | VolumeMounts allows configuration of additional VolumeMounts on the output Deployment definition. VolumeMounts specified will be appended to other VolumeMounts in the VMSingle container, that are generated as a result of StorageSpec objects. | [][v1.VolumeMount](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#volumemount-v1-core) | false |
| resources | Resources container resource request and limits, https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/ if not defined default resources from operator config will be used | [v1.ResourceRequirements](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#resourcerequirements-v1-core) | false |
| affinity | Affinity If specified, the pod&#39;s scheduling constraints. | *[v1.Affinity](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#affinity-v1-core) | false |
| tolerations | Tolerations If specified, the pod&#39;s tolerations. | [][v1.Toleration](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#toleration-v1-core) | false |
| securityContext | SecurityContext holds pod-level security attributes and common container settings. This defaults to the default PodSecurityContext. | *[v1.PodSecurityContext](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#podsecuritycontext-v1-core) | false |
| serviceAccountName | ServiceAccountName is the name of the ServiceAccount to use to run the VMSingle Pods. | string | false |
| schedulerName | SchedulerName - defines kubernetes scheduler name | string | false |
| runtimeClassName | RuntimeClassName - defines runtime class for kubernetes pod. https://kubernetes.io/docs/concepts/containers/runtime-class/ | *string | false |
| podSecurityPolicyName | PodSecurityPolicyName - defines name for podSecurityPolicy in case of empty value, prefixedName will be used. | string | false |
| hostAliases | HostAliases provides mapping for ip and hostname, that would be propagated to pod, cannot be used with HostNetwork. | []v1.HostAlias | false |
| containers | Containers property allows to inject additions sidecars or to patch existing containers. It can be useful for proxies, backup, etc. | [][v1.Container](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#container-v1-core) | false |
| initContainers | InitContainers allows adding initContainers to the pod definition. Those can be used to e.g. fetch secrets for injection into the vmSingle configuration from external sources. Any errors during the execution of an initContainer will lead to a restart of the Pod. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/ Using initContainers for any use case other then secret fetching is entirely outside the scope of what the maintainers will support and by doing so, you accept that this behaviour may break at any time without notice. | [][v1.Container](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#container-v1-core) | false |
| priorityClassName | PriorityClassName assigned to the Pods | string | false |
| hostNetwork | HostNetwork controls whether the pod may use the node network namespace | bool | false |
| dnsPolicy | DNSPolicy sets DNS policy for the pod | [v1.DNSPolicy](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#pod-v1-core) | false |
| topologySpreadConstraints | TopologySpreadConstraints embedded kubernetes pod configuration option, controls how pods are spread across your cluster among failure-domains such as regions, zones, nodes, and other user-defined topology domains https://kubernetes.io/docs/concepts/workloads/pods/pod-topology-spread-constraints/ | [][v1.TopologySpreadConstraint](https://kubernetes.io/docs/concepts/workloads/pods/pod-topology-spread-constraints/) | false |
| insertPorts | InsertPorts - additional listen ports for data ingestion. | *[InsertPorts](#insertports) | false |
| port | Port listen port | string | false |
| removePvcAfterDelete | RemovePvcAfterDelete - if true, controller adds ownership to pvc and after VMSingle objest deletion - pvc will be garbage collected by controller manager | bool | false |
| retentionPeriod | RetentionPeriod in months | string | true |
| vmBackup | VMBackup configuration for backup | *[VMBackup](#vmbackup) | false |
| extraArgs | ExtraArgs that will be passed to  VMSingle pod for example remoteWrite.tmpDataPath: /tmp | map[string]string | false |
| extraEnvs | ExtraEnvs that will be added to VMSingle pod | [][v1.EnvVar](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#envvar-v1-core) | false |
| serviceSpec | ServiceSpec that will be added to vmsingle service spec | *[ServiceSpec](#servicespec) | false |
| nodeSelector | NodeSelector Define which Nodes the Pods are scheduled on. | map[string]string | false |

[Back to TOC](#table-of-contents)

## VMSingleStatus

VMSingleStatus defines the observed state of VMSingle

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| replicas | ReplicaCount Total number of non-terminated pods targeted by this VMAlert cluster (their labels match the selector). | int32 | true |
| updatedReplicas | UpdatedReplicas Total number of non-terminated pods targeted by this VMAlert cluster that have the desired version spec. | int32 | true |
| availableReplicas | AvailableReplicas Total number of available pods (ready for at least minReadySeconds) targeted by this VMAlert cluster. | int32 | true |
| unavailableReplicas | UnavailableReplicas Total number of unavailable pods targeted by this VMAlert cluster. | int32 | true |

[Back to TOC](#table-of-contents)

## Rule

Rule describes an alerting or recording rule.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| record | Record represents a query, that will be recorded to dataSource | string | false |
| alert | Alert is a name for alert | string | false |
| expr | Expr is query, that will be evaluated at dataSource | intstr.IntOrString | true |
| for | For evaluation interval in time.Duration format 30s, 1m, 1h  or nanoseconds | string | false |
| labels | Labels will be added to rule configuration | map[string]string | false |
| annotations | Annotations will be added to rule configuration | map[string]string | false |

[Back to TOC](#table-of-contents)

## RuleGroup

RuleGroup is a list of sequentially evaluated recording and alerting rules.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| name | Name of group | string | true |
| interval | evaluation interval for group | string | false |
| rules | Rules list of alert rules | [][Rule](#rule) | true |
| concurrency | Concurrency defines how many rules execute at once. | int | false |
| labels | Labels optional list of labels added to every rule within a group. It has priority over the external labels. Labels are commonly used for adding environment or tenant-specific tag. | map[string]string | false |
| extra_filter_labels | ExtraFilterLabels optional list of label filters applied to every rule&#39;s request withing a group. Is compatible only with VM datasource. See more details at https://docs.victoriametrics.com#prometheus-querying-api-enhancements | map[string]string | false |
| tenant | Tenant id for group, can be used only with enterprise version of vmalert See more details at https://docs.victoriametrics.com/vmalert.html#multitenancy | string | false |

[Back to TOC](#table-of-contents)

## VMRule

VMRule defines rule records for vmalert application

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ObjectMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#objectmeta-v1-meta) | false |
| spec |  | [VMRuleSpec](#vmrulespec) | true |
| status |  | [VMRuleStatus](#vmrulestatus) | false |

[Back to TOC](#table-of-contents)

## VMRuleList

VMRuleList contains a list of VMRule

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ListMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#listmeta-v1-meta) | false |
| items | Items list of VMRule | []*[VMRule](#vmrule) | true |

[Back to TOC](#table-of-contents)

## VMRuleSpec

VMRuleSpec defines the desired state of VMRule

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| groups | Groups list of group rules | [][RuleGroup](#rulegroup) | true |

[Back to TOC](#table-of-contents)

## APIServerConfig

APIServerConfig defines a host and auth methods to access apiserver. More info: https://prometheus.io/docs/prometheus/latest/configuration/configuration/#kubernetes_sd_config

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| host | Host of apiserver. A valid string consisting of a hostname or IP followed by an optional port number | string | true |
| basicAuth | BasicAuth allow an endpoint to authenticate over basic authentication | *[BasicAuth](#basicauth) | false |
| bearerToken | Bearer token for accessing apiserver. | string | false |
| bearerTokenFile | File to read bearer token for accessing apiserver. | string | false |
| tlsConfig | TLSConfig Config to use for accessing apiserver. | *[TLSConfig](#tlsconfig) | false |

[Back to TOC](#table-of-contents)

## Endpoint

Endpoint defines a scrapeable endpoint serving Prometheus metrics.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| port | Name of the service port this endpoint refers to. Mutually exclusive with targetPort. | string | false |
| targetPort | Name or number of the pod port this endpoint refers to. Mutually exclusive with port. | *intstr.IntOrString | false |
| path | HTTP path to scrape for metrics. | string | false |
| scheme | HTTP scheme to use for scraping. | string | false |
| params | Optional HTTP URL parameters | map[string][]string | false |
| follow_redirects | FollowRedirects controls redirects for scraping. | *bool | false |
| interval | Interval at which metrics should be scraped | string | false |
| scrape_interval | ScrapeInterval is the same as Interval and has priority over it. one of scrape_interval or interval can be used | string | false |
| scrapeTimeout | Timeout after which the scrape is ended | string | false |
| sampleLimit | SampleLimit defines per-endpoint limit on number of scraped samples that will be accepted. | uint64 | false |
| oauth2 | OAuth2 defines auth configuration | *[OAuth2](#oauth2) | false |
| tlsConfig | TLSConfig configuration to use when scraping the endpoint | *[TLSConfig](#tlsconfig) | false |
| bearerTokenFile | File to read bearer token for scraping targets. | string | false |
| bearerTokenSecret | Secret to mount to read bearer token for scraping targets. The secret needs to be in the same namespace as the service scrape and accessible by the victoria-metrics operator. | *[v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| honorLabels | HonorLabels chooses the metric&#39;s labels on collisions with target labels. | bool | false |
| honorTimestamps | HonorTimestamps controls whether vmagent respects the timestamps present in scraped data. | *bool | false |
| basicAuth | BasicAuth allow an endpoint to authenticate over basic authentication More info: https://prometheus.io/docs/operating/configuration/#endpoints | *[BasicAuth](#basicauth) | false |
| metricRelabelConfigs | MetricRelabelConfigs to apply to samples before ingestion. | []*[RelabelConfig](#relabelconfig) | false |
| relabelConfigs | RelabelConfigs to apply to samples before scraping. More info: https://prometheus.io/docs/prometheus/latest/configuration/configuration/#relabel_config | []*[RelabelConfig](#relabelconfig) | false |
| proxyURL | ProxyURL eg http://proxyserver:2195 Directs scrapes to proxy through this endpoint. | *string | false |
| vm_scrape_params | VMScrapeParams defines VictoriaMetrics specific scrape parametrs | *[VMScrapeParams](#vmscrapeparams) | false |

[Back to TOC](#table-of-contents)

## NamespaceSelector

NamespaceSelector is a selector for selecting either all namespaces or a list of namespaces.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| any | Boolean describing whether all namespaces are selected in contrast to a list restricting them. | bool | false |
| matchNames | List of namespace names. | []string | false |

[Back to TOC](#table-of-contents)

## OAuth2

OAuth2 defines OAuth2 configuration

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| client_id | The secret or configmap containing the OAuth2 client id | [SecretOrConfigMap](#secretorconfigmap) | true |
| client_secret | The secret containing the OAuth2 client secret | *[v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| client_secret_file | ClientSecretFile defines path for client secret file. | string | false |
| token_url | The URL to fetch the token from | string | true |
| scopes | OAuth2 scopes used for the token request | []string | false |
| endpoint_params | Parameters to append to the token URL | map[string]string | false |

[Back to TOC](#table-of-contents)

## ProxyAuth

ProxyAuth represent proxy auth config Only VictoriaMetrics scrapers supports it. See https://github.com/VictoriaMetrics/VictoriaMetrics/commit/a6a71ef861444eb11fe8ec6d2387f0fc0c4aea87

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| basic_auth |  | *[BasicAuth](#basicauth) | false |
| bearer_token |  | *[v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| bearer_token_file |  | string | false |
| tls_config |  | *[TLSConfig](#tlsconfig) | false |

[Back to TOC](#table-of-contents)

## QueueConfig

QueueConfig allows the tuning of remote_write queue_config parameters. This object is referenced in the RemoteWriteSpec object.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| capacity | Capacity is the number of samples to buffer per shard before we start dropping them. | int | false |
| minShards | MinShards is the minimum number of shards, i.e. amount of concurrency. | int | false |
| maxShards | MaxShards is the maximum number of shards, i.e. amount of concurrency. | int | false |
| maxSamplesPerSend | MaxSamplesPerSend is the maximum number of samples per send. | int | false |
| batchSendDeadline | BatchSendDeadline is the maximum time a sample will wait in buffer. | string | false |
| maxRetries | MaxRetries is the maximum number of times to retry a batch on recoverable errors. | int | false |
| minBackoff | MinBackoff is the initial retry delay. Gets doubled for every retry. | string | false |
| maxBackoff | MaxBackoff is the maximum retry delay. | string | false |

[Back to TOC](#table-of-contents)

## RelabelConfig

RelabelConfig allows dynamic rewriting of the label set, being applied to samples before ingestion. It defines `<metric_relabel_configs>`-section of configuration. More info: https://prometheus.io/docs/prometheus/latest/configuration/configuration/#metric_relabel_configs

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| source_labels | UnderScoreSourceLabels - additional form of source labels source_labels for compatibility with original relabel config. if set  both sourceLabels and source_labels, sourceLabels has priority. for details https://github.com/VictoriaMetrics/operator/issues/131 | []string | false |
| target_label | UnderScoreTargetLabel - additional form of target label - target_label for compatibility with original relabel config. if set  both targetLabel and target_label, targetLabel has priority. for details https://github.com/VictoriaMetrics/operator/issues/131 | string | false |
| sourceLabels | The source labels select values from existing labels. Their content is concatenated using the configured separator and matched against the configured regular expression for the replace, keep, and drop actions. | []string | false |
| separator | Separator placed between concatenated source label values. default is &#39;;&#39;. | string | false |
| targetLabel | Label to which the resulting value is written in a replace action. It is mandatory for replace actions. Regex capture groups are available. | string | false |
| regex | Regular expression against which the extracted value is matched. Default is &#39;(.*)&#39; | string | false |
| modulus | Modulus to take of the hash of the source label values. | uint64 | false |
| replacement | Replacement value against which a regex replace is performed if the regular expression matches. Regex capture groups are available. Default is &#39;$1&#39; | string | false |
| action | Action to perform based on regex matching. Default is &#39;replace&#39; | string | false |

[Back to TOC](#table-of-contents)

## SecretOrConfigMap

SecretOrConfigMap allows to specify data as a Secret or ConfigMap. Fields are mutually exclusive.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| secret | Secret containing data to use for the targets. | *[v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| configMap | ConfigMap containing data to use for the targets. | *v1.ConfigMapKeySelector | false |

[Back to TOC](#table-of-contents)

## TLSConfig

TLSConfig specifies TLSConfig configuration parameters.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| caFile | Path to the CA cert in the container to use for the targets. | string | false |
| ca | Stuct containing the CA cert to use for the targets. | [SecretOrConfigMap](#secretorconfigmap) | false |
| certFile | Path to the client cert file in the container for the targets. | string | false |
| cert | Struct containing the client cert file for the targets. | [SecretOrConfigMap](#secretorconfigmap) | false |
| keyFile | Path to the client key file in the container for the targets. | string | false |
| keySecret | Secret containing the client key file for the targets. | *[v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| serverName | Used to verify the hostname for the targets. | string | false |
| insecureSkipVerify | Disable target certificate validation. | bool | false |

[Back to TOC](#table-of-contents)

## VMScrapeParams

VMScrapeParams defines scrape target configuration that compatible only with VictoriaMetrics scrapers VMAgent and VMSingle

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| relabel_debug |  | *bool | false |
| metric_relabel_debug |  | *bool | false |
| disable_compression |  | *bool | false |
| disable_keep_alive |  | *bool | false |
| stream_parse |  | *bool | false |
| scrape_align_interval |  | *string | false |
| scrape_offset |  | *string | false |
| proxy_client_config | ProxyClientConfig configures proxy auth settings for scraping See feature description https://docs.victoriametrics.com/vmagent.html#scraping-targets-via-a-proxy | *[ProxyAuth](#proxyauth) | false |

[Back to TOC](#table-of-contents)

## VMServiceScrape

VMServiceScrape is scrape configuration for endpoints associated with kubernetes service, it generates scrape configuration for vmagent based on selectors. result config will scrape service endpoints

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ObjectMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#objectmeta-v1-meta) | false |
| spec |  | [VMServiceScrapeSpec](#vmservicescrapespec) | true |
| status |  | [VMServiceScrapeStatus](#vmservicescrapestatus) | false |

[Back to TOC](#table-of-contents)

## VMServiceScrapeList

VMServiceScrapeList contains a list of VMServiceScrape

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ListMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#listmeta-v1-meta) | false |
| items |  | [][VMServiceScrape](#vmservicescrape) | true |

[Back to TOC](#table-of-contents)

## VMServiceScrapeSpec

VMServiceScrapeSpec defines the desired state of VMServiceScrape

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| discoveryRole | DiscoveryRole - defines kubernetes_sd role for objects discovery. by default, its endpoints. can be changed to service or endpointslices. note, that with service setting, you have to use port: \&#34;name\&#34; and cannot use targetPort for endpoints. | string | false |
| jobLabel | The label to use to retrieve the job name from. | string | false |
| targetLabels | TargetLabels transfers labels on the Kubernetes Service onto the target. | []string | false |
| podTargetLabels | PodTargetLabels transfers labels on the Kubernetes Pod onto the target. | []string | false |
| endpoints | A list of endpoints allowed as part of this ServiceScrape. | [][Endpoint](#endpoint) | true |
| selector | Selector to select Endpoints objects by corresponding Service labels. | [metav1.LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#labelselector-v1-meta) | false |
| namespaceSelector | Selector to select which namespaces the Endpoints objects are discovered from. | [NamespaceSelector](#namespaceselector) | false |
| sampleLimit | SampleLimit defines per-scrape limit on number of scraped samples that will be accepted. | uint64 | false |

[Back to TOC](#table-of-contents)

## ArbitraryFSAccessThroughSMsConfig

ArbitraryFSAccessThroughSMsConfig enables users to configure, whether a service scrape selected by the vmagent instance is allowed to use arbitrary files on the file system of the vmagent container. This is the case when e.g. a service scrape specifies a BearerTokenFile in an endpoint. A malicious user could create a service scrape selecting arbitrary secret files in the vmagent container. Those secrets would then be sent with a scrape request by vmagent to a malicious target. Denying the above would prevent the attack, users can instead use the BearerTokenSecret field.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| deny |  | bool | false |

[Back to TOC](#table-of-contents)

## PodMetricsEndpoint

PodMetricsEndpoint defines a scrapeable endpoint of a Kubernetes Pod serving Prometheus metrics.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| port | Name of the pod port this endpoint refers to. Mutually exclusive with targetPort. | string | false |
| targetPort | Deprecated: Use &#39;port&#39; instead. | *intstr.IntOrString | false |
| path | HTTP path to scrape for metrics. | string | false |
| scheme | HTTP scheme to use for scraping. | string | false |
| params | Optional HTTP URL parameters | map[string][]string | false |
| follow_redirects | FollowRedirects controls redirects for scraping. | *bool | false |
| interval | Interval at which metrics should be scraped | string | false |
| scrape_interval | ScrapeInterval is the same as Interval and has priority over it. one of scrape_interval or interval can be used | string | false |
| scrapeTimeout | Timeout after which the scrape is ended | string | false |
| sampleLimit | SampleLimit defines per-podEndpoint limit on number of scraped samples that will be accepted. | uint64 | false |
| honorLabels | HonorLabels chooses the metric&#39;s labels on collisions with target labels. | bool | false |
| honorTimestamps | HonorTimestamps controls whether vmagent respects the timestamps present in scraped data. | *bool | false |
| metricRelabelConfigs | MetricRelabelConfigs to apply to samples before ingestion. | []*[RelabelConfig](#relabelconfig) | false |
| relabelConfigs | RelabelConfigs to apply to samples before ingestion. More info: https://prometheus.io/docs/prometheus/latest/configuration/configuration/#relabel_config | []*[RelabelConfig](#relabelconfig) | false |
| proxyURL | ProxyURL eg http://proxyserver:2195 Directs scrapes to proxy through this endpoint. | *string | false |
| basicAuth | BasicAuth allow an endpoint to authenticate over basic authentication More info: https://prometheus.io/docs/operating/configuration/#endpoints | *[BasicAuth](#basicauth) | false |
| bearerTokenFile | File to read bearer token for scraping targets. | string | false |
| bearerTokenSecret | Secret to mount to read bearer token for scraping targets. The secret needs to be in the same namespace as the service scrape and accessible by the victoria-metrics operator. | *[v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| tlsConfig | TLSConfig configuration to use when scraping the endpoint | *[TLSConfig](#tlsconfig) | false |
| oauth2 | OAuth2 defines auth configuration | *[OAuth2](#oauth2) | false |
| vm_scrape_params | VMScrapeParams defines VictoriaMetrics specific scrape parametrs | *[VMScrapeParams](#vmscrapeparams) | false |

[Back to TOC](#table-of-contents)

## VMPodScrape

VMPodScrape is scrape configuration for pods, it generates vmagent's config for scraping pod targets based on selectors.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ObjectMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#objectmeta-v1-meta) | false |
| spec |  | [VMPodScrapeSpec](#vmpodscrapespec) | false |
| status |  | [VMPodScrapeStatus](#vmpodscrapestatus) | true |

[Back to TOC](#table-of-contents)

## VMPodScrapeList

VMPodScrapeList contains a list of VMPodScrape

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ListMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#listmeta-v1-meta) | false |
| items |  | [][VMPodScrape](#vmpodscrape) | true |

[Back to TOC](#table-of-contents)

## VMPodScrapeSpec

VMPodScrapeSpec defines the desired state of VMPodScrape

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| jobLabel | The label to use to retrieve the job name from. | string | false |
| podTargetLabels | PodTargetLabels transfers labels on the Kubernetes Pod onto the target. | []string | false |
| podMetricsEndpoints | A list of endpoints allowed as part of this PodMonitor. | [][PodMetricsEndpoint](#podmetricsendpoint) | true |
| selector | Selector to select Pod objects. | [metav1.LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#labelselector-v1-meta) | false |
| namespaceSelector | Selector to select which namespaces the Endpoints objects are discovered from. | [NamespaceSelector](#namespaceselector) | false |
| sampleLimit | SampleLimit defines per-scrape limit on number of scraped samples that will be accepted. | uint64 | false |

[Back to TOC](#table-of-contents)

## Image

Image defines docker image settings

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| repository | Repository contains name of docker image + it&#39;s repository if needed | string | false |
| tag | Tag contains desired docker image version | string | false |
| pullPolicy | PullPolicy describes how to pull docker image | [v1.PullPolicy](https://kubernetes.io/docs/concepts/containers/images#updating-images) | false |

[Back to TOC](#table-of-contents)

## InsertPorts



| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| graphitePort | GraphitePort listen port | string | false |
| influxPort | InfluxPort listen port | string | false |
| openTSDBHTTPPort | OpenTSDBHTTPPort for http connections. | string | false |
| openTSDBPort | OpenTSDBPort for tcp and udp listen | string | false |

[Back to TOC](#table-of-contents)

## VMBackup



| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| acceptEULA | AcceptEULA accepts enterprise feature usage, must be set to true. otherwise backupmanager cannot be added to single/cluster version. https://victoriametrics.com/legal/eula/ | bool | true |
| snapshotCreateURL | SnapshotCreateURL overwrites url for snapshot create | string | false |
| snapshotDeleteURL | SnapShotDeleteURL overwrites url for snapshot delete | string | false |
| concurrency | Defines number of concurrent workers. Higher concurrency may reduce backup duration (default 10) | *int32 | false |
| destination | Defines destination for backup | string | false |
| destinationDisableSuffixAdd | DestinationDisableSuffixAdd - disables suffix adding for cluster version backups each vmstorage backup must have unique backup folder so operator adds POD_NAME as suffix for backup destination folder. | bool | false |
| customS3Endpoint | Custom S3 endpoint for use with S3-compatible storages (e.g. MinIO). S3 is used if not set | *string | false |
| credentialsSecret | CredentialsSecret is secret in the same namespace for access to remote storage The secret is mounted into /etc/vm/creds. | *[v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| disableHourly | Defines if hourly backups disabled (default false) | *bool | false |
| disableDaily | Defines if daily backups disabled (default false) | *bool | false |
| disableWeekly | Defines if weekly backups disabled (default false) | *bool | false |
| disableMonthly | Defines if monthly backups disabled (default false) | *bool | false |
| image | Image - docker image settings for VMBackuper | [Image](#image) | false |
| port | Port for health check connections | string | false |
| logFormat | LogFormat for VMSelect to be configured with. default or json | *string | false |
| logLevel | LogLevel for VMSelect to be configured with. | *string | false |
| resources | Resources container resource request and limits, https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/ if not defined default resources from operator config will be used | [v1.ResourceRequirements](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#resourcerequirements-v1-core) | false |
| extraArgs | extra args like maxBytesPerSecond default 0 | map[string]string | false |
| extraEnvs |  | [][v1.EnvVar](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#envvar-v1-core) | false |
| volumeMounts | VolumeMounts allows configuration of additional VolumeMounts on the output Deployment definition. VolumeMounts specified will be appended to other VolumeMounts in the vmbackupmanager container, that are generated as a result of StorageSpec objects. | [][v1.VolumeMount](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#volumemount-v1-core) | false |

[Back to TOC](#table-of-contents)

## VMCluster

VMCluster is fast, cost-effective and scalable time-series database. Cluster version with

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ObjectMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#objectmeta-v1-meta) | false |
| spec |  | [VMClusterSpec](#vmclusterspec) | true |
| status |  | [VMClusterStatus](#vmclusterstatus) | false |

[Back to TOC](#table-of-contents)

## VMClusterList

VMClusterList contains a list of VMCluster

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ListMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#listmeta-v1-meta) | false |
| items |  | [][VMCluster](#vmcluster) | true |

[Back to TOC](#table-of-contents)

## VMClusterSpec

VMClusterSpec defines the desired state of VMCluster

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| retentionPeriod | RetentionPeriod in months | string | true |
| replicationFactor | ReplicationFactor defines how many copies of data make among distinct storage nodes | *int32 | false |
| podSecurityPolicyName | PodSecurityPolicyName - defines name for podSecurityPolicy in case of empty value, prefixedName will be used. | string | false |
| serviceAccountName | ServiceAccountName is the name of the ServiceAccount to use to run the VMSelect Pods. | string | false |
| clusterVersion | ClusterVersion defines default images tag for all components. it can be overwritten with component specific image.tag value. | string | false |
| imagePullSecrets | ImagePullSecrets An optional list of references to secrets in the same namespace to use for pulling images from registries see http://kubernetes.io/docs/user-guide/images#specifying-imagepullsecrets-on-a-pod | [][v1.LocalObjectReference](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#localobjectreference-v1-core) | false |
| vmselect |  | *[VMSelect](#vmselect) | false |
| vminsert |  | *[VMInsert](#vminsert) | false |
| vmstorage |  | *[VMStorage](#vmstorage) | false |

[Back to TOC](#table-of-contents)

## VMClusterStatus

VMClusterStatus defines the observed state of VMCluster

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| updateFailCount | Deprecated. | int | true |
| lastSync | Deprecated. | string | false |
| clusterStatus |  | string | true |
| reason |  | string | false |

[Back to TOC](#table-of-contents)

## VMInsert



| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| name | Name is deprecated and will be removed at 0.22.0 release | string | false |
| podMetadata | PodMetadata configures Labels and Annotations which are propagated to the VMSelect pods. | *[EmbeddedObjectMetadata](#embeddedobjectmetadata) | false |
| image | Image - docker image settings for VMInsert | [Image](#image) | false |
| secrets | Secrets is a list of Secrets in the same namespace as the VMSelect object, which shall be mounted into the VMSelect Pods. The Secrets are mounted into /etc/vm/secrets/&lt;secret-name&gt;. | []string | false |
| configMaps | ConfigMaps is a list of ConfigMaps in the same namespace as the VMSelect object, which shall be mounted into the VMSelect Pods. The ConfigMaps are mounted into /etc/vm/configs/&lt;configmap-name&gt;. | []string | false |
| logFormat | LogFormat for VMSelect to be configured with. default or json | string | false |
| logLevel | LogLevel for VMSelect to be configured with. | string | false |
| replicaCount | ReplicaCount is the expected size of the VMInsert cluster. The controller will eventually make the size of the running cluster equal to the expected size. | *int32 | true |
| volumes | Volumes allows configuration of additional volumes on the output Deployment definition. Volumes specified will be appended to other volumes that are generated as a result of StorageSpec objects. | [][v1.Volume](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#volume-v1-core) | false |
| volumeMounts | VolumeMounts allows configuration of additional VolumeMounts on the output Deployment definition. VolumeMounts specified will be appended to other VolumeMounts in the VMSelect container, that are generated as a result of StorageSpec objects. | [][v1.VolumeMount](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#volumemount-v1-core) | false |
| resources | Resources container resource request and limits, https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/ | [v1.ResourceRequirements](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#resourcerequirements-v1-core) | false |
| affinity | Affinity If specified, the pod&#39;s scheduling constraints. | *[v1.Affinity](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#affinity-v1-core) | false |
| tolerations | Tolerations If specified, the pod&#39;s tolerations. | [][v1.Toleration](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#toleration-v1-core) | false |
| securityContext | SecurityContext holds pod-level security attributes and common container settings. This defaults to the default PodSecurityContext. | *[v1.PodSecurityContext](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#podsecuritycontext-v1-core) | false |
| containers | Containers property allows to inject additions sidecars or to patch existing containers. It can be useful for proxies, backup, etc. | [][v1.Container](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#container-v1-core) | false |
| initContainers | InitContainers allows adding initContainers to the pod definition. Those can be used to e.g. fetch secrets for injection into the VMSelect configuration from external sources. Any errors during the execution of an initContainer will lead to a restart of the Pod. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/ Using initContainers for any use case other then secret fetching is entirely outside the scope of what the maintainers will support and by doing so, you accept that this behaviour may break at any time without notice. | [][v1.Container](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#container-v1-core) | false |
| priorityClassName | Priority class assigned to the Pods | string | false |
| hostNetwork | HostNetwork controls whether the pod may use the node network namespace | bool | false |
| dnsPolicy | DNSPolicy sets DNS policy for the pod | [v1.DNSPolicy](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#pod-v1-core) | false |
| topologySpreadConstraints | TopologySpreadConstraints embedded kubernetes pod configuration option, controls how pods are spread across your cluster among failure-domains such as regions, zones, nodes, and other user-defined topology domains https://kubernetes.io/docs/concepts/workloads/pods/pod-topology-spread-constraints/ | [][v1.TopologySpreadConstraint](https://kubernetes.io/docs/concepts/workloads/pods/pod-topology-spread-constraints/) | false |
| extraArgs |  | map[string]string | false |
| insertPorts | InsertPorts - additional listen ports for data ingestion. | *[InsertPorts](#insertports) | false |
| port | Port listen port | string | false |
| schedulerName | SchedulerName - defines kubernetes scheduler name | string | false |
| runtimeClassName | RuntimeClassName - defines runtime class for kubernetes pod. https://kubernetes.io/docs/concepts/containers/runtime-class/ | *string | false |
| extraEnvs | ExtraEnvs that will be added to VMSelect pod | [][v1.EnvVar](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#envvar-v1-core) | false |
| serviceSpec | ServiceSpec that will be added to vminsert service spec | *[ServiceSpec](#servicespec) | false |
| updateStrategy | UpdateStrategy - overrides default update strategy. | *[appsv1.DeploymentStrategyType](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#deploymentstrategy-v1-apps) | false |
| rollingUpdate | RollingUpdate - overrides deployment update params. | *[appsv1.RollingUpdateDeployment](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#rollingupdatedeployment-v1-apps) | false |
| podDisruptionBudget | PodDisruptionBudget created by operator | *[EmbeddedPodDisruptionBudgetSpec](#embeddedpoddisruptionbudgetspec) | false |
| hpa | HPA defines kubernetes PodAutoScaling configuration version 2. | *[EmbeddedHPA](#embeddedhpa) | false |
| nodeSelector | NodeSelector Define which Nodes the Pods are scheduled on. | map[string]string | false |

[Back to TOC](#table-of-contents)

## VMSelect



| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| name | Name is deprecated and will be removed at 0.22.0 release | string | false |
| podMetadata | PodMetadata configures Labels and Annotations which are propagated to the VMSelect pods. | *[EmbeddedObjectMetadata](#embeddedobjectmetadata) | false |
| image | Image - docker image settings for VMSelect | [Image](#image) | false |
| secrets | Secrets is a list of Secrets in the same namespace as the VMSelect object, which shall be mounted into the VMSelect Pods. The Secrets are mounted into /etc/vm/secrets/&lt;secret-name&gt;. | []string | false |
| configMaps | ConfigMaps is a list of ConfigMaps in the same namespace as the VMSelect object, which shall be mounted into the VMSelect Pods. The ConfigMaps are mounted into /etc/vm/configs/&lt;configmap-name&gt;. | []string | false |
| logFormat | LogFormat for VMSelect to be configured with. default or json | string | false |
| logLevel | LogLevel for VMSelect to be configured with. | string | false |
| replicaCount | ReplicaCount is the expected size of the VMSelect cluster. The controller will eventually make the size of the running cluster equal to the expected size. | *int32 | true |
| volumes | Volumes allows configuration of additional volumes on the output Deployment definition. Volumes specified will be appended to other volumes that are generated as a result of StorageSpec objects. | [][v1.Volume](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#volume-v1-core) | false |
| volumeMounts | VolumeMounts allows configuration of additional VolumeMounts on the output Deployment definition. VolumeMounts specified will be appended to other VolumeMounts in the VMSelect container, that are generated as a result of StorageSpec objects. | [][v1.VolumeMount](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#volumemount-v1-core) | false |
| resources | Resources container resource request and limits, https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/ | [v1.ResourceRequirements](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#resourcerequirements-v1-core) | false |
| affinity | Affinity If specified, the pod&#39;s scheduling constraints. | *[v1.Affinity](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#affinity-v1-core) | false |
| tolerations | Tolerations If specified, the pod&#39;s tolerations. | [][v1.Toleration](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#toleration-v1-core) | false |
| securityContext | SecurityContext holds pod-level security attributes and common container settings. This defaults to the default PodSecurityContext. | *[v1.PodSecurityContext](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#podsecuritycontext-v1-core) | false |
| containers | Containers property allows to inject additions sidecars or to patch existing containers. It can be useful for proxies, backup, etc. | [][v1.Container](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#container-v1-core) | false |
| initContainers | InitContainers allows adding initContainers to the pod definition. Those can be used to e.g. fetch secrets for injection into the VMSelect configuration from external sources. Any errors during the execution of an initContainer will lead to a restart of the Pod. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/ Using initContainers for any use case other then secret fetching is entirely outside the scope of what the maintainers will support and by doing so, you accept that this behaviour may break at any time without notice. | [][v1.Container](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#container-v1-core) | false |
| priorityClassName | Priority class assigned to the Pods | string | false |
| hostNetwork | HostNetwork controls whether the pod may use the node network namespace | bool | false |
| dnsPolicy | DNSPolicy sets DNS policy for the pod | [v1.DNSPolicy](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#pod-v1-core) | false |
| topologySpreadConstraints | TopologySpreadConstraints embedded kubernetes pod configuration option, controls how pods are spread across your cluster among failure-domains such as regions, zones, nodes, and other user-defined topology domains https://kubernetes.io/docs/concepts/workloads/pods/pod-topology-spread-constraints/ | [][v1.TopologySpreadConstraint](https://kubernetes.io/docs/concepts/workloads/pods/pod-topology-spread-constraints/) | false |
| cacheMountPath | CacheMountPath allows to add cache persistent for VMSelect | string | false |
| persistentVolume | Storage - add persistent volume for cacheMounthPath its useful for persistent cache use storage instead of persistentVolume. | *[StorageSpec](#storagespec) | false |
| storage | StorageSpec - add persistent volume claim for cacheMounthPath its needed for persistent cache | *[StorageSpec](#storagespec) | false |
| extraEnvs | ExtraEnvs that will be added to VMSelect pod | [][v1.EnvVar](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#envvar-v1-core) | false |
| extraArgs |  | map[string]string | false |
| port | Port listen port | string | false |
| schedulerName | SchedulerName - defines kubernetes scheduler name | string | false |
| runtimeClassName | RuntimeClassName - defines runtime class for kubernetes pod. https://kubernetes.io/docs/concepts/containers/runtime-class/ | *string | false |
| serviceSpec | ServiceSpec that will be added to vmselect service spec | *[ServiceSpec](#servicespec) | false |
| podDisruptionBudget | PodDisruptionBudget created by operator | *[EmbeddedPodDisruptionBudgetSpec](#embeddedpoddisruptionbudgetspec) | false |
| hpa |  | *[EmbeddedHPA](#embeddedhpa) | false |
| nodeSelector | NodeSelector Define which Nodes the Pods are scheduled on. | map[string]string | false |
| rollingUpdateStrategy | RollingUpdateStrategy defines strategy for application updates Default is OnDelete, in this case operator handles update process Can be changed for RollingUpdate | [appsv1.StatefulSetUpdateStrategyType](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#statefulsetupdatestrategy-v1-apps) | false |

[Back to TOC](#table-of-contents)

## VMStorage



| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| name | Name is deprecated and will be removed at 0.22.0 release | string | false |
| podMetadata | PodMetadata configures Labels and Annotations which are propagated to the VMSelect pods. | *[EmbeddedObjectMetadata](#embeddedobjectmetadata) | false |
| image | Image - docker image settings for VMStorage | [Image](#image) | false |
| secrets | Secrets is a list of Secrets in the same namespace as the VMSelect object, which shall be mounted into the VMSelect Pods. The Secrets are mounted into /etc/vm/secrets/&lt;secret-name&gt;. | []string | false |
| configMaps | ConfigMaps is a list of ConfigMaps in the same namespace as the VMSelect object, which shall be mounted into the VMSelect Pods. The ConfigMaps are mounted into /etc/vm/configs/&lt;configmap-name&gt;. | []string | false |
| logFormat | LogFormat for VMSelect to be configured with. default or json | string | false |
| logLevel | LogLevel for VMSelect to be configured with. | string | false |
| replicaCount | ReplicaCount is the expected size of the VMStorage cluster. The controller will eventually make the size of the running cluster equal to the expected size. | *int32 | true |
| volumes | Volumes allows configuration of additional volumes on the output Deployment definition. Volumes specified will be appended to other volumes that are generated as a result of StorageSpec objects. | [][v1.Volume](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#volume-v1-core) | false |
| volumeMounts | VolumeMounts allows configuration of additional VolumeMounts on the output Deployment definition. VolumeMounts specified will be appended to other VolumeMounts in the VMSelect container, that are generated as a result of StorageSpec objects. | [][v1.VolumeMount](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#volumemount-v1-core) | false |
| resources | Resources container resource request and limits, https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/ | [v1.ResourceRequirements](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#resourcerequirements-v1-core) | false |
| affinity | Affinity If specified, the pod&#39;s scheduling constraints. | *[v1.Affinity](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#affinity-v1-core) | false |
| tolerations | Tolerations If specified, the pod&#39;s tolerations. | [][v1.Toleration](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#toleration-v1-core) | false |
| securityContext | SecurityContext holds pod-level security attributes and common container settings. This defaults to the default PodSecurityContext. | *[v1.PodSecurityContext](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#podsecuritycontext-v1-core) | false |
| containers | Containers property allows to inject additions sidecars or to patch existing containers. It can be useful for proxies, backup, etc. | [][v1.Container](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#container-v1-core) | false |
| initContainers | InitContainers allows adding initContainers to the pod definition. Those can be used to e.g. fetch secrets for injection into the VMSelect configuration from external sources. Any errors during the execution of an initContainer will lead to a restart of the Pod. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/ Using initContainers for any use case other then secret fetching is entirely outside the scope of what the maintainers will support and by doing so, you accept that this behaviour may break at any time without notice. | [][v1.Container](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#container-v1-core) | false |
| priorityClassName | Priority class assigned to the Pods | string | false |
| hostNetwork | HostNetwork controls whether the pod may use the node network namespace | bool | false |
| dnsPolicy | DNSPolicy sets DNS policy for the pod | [v1.DNSPolicy](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#pod-v1-core) | false |
| topologySpreadConstraints | TopologySpreadConstraints embedded kubernetes pod configuration option, controls how pods are spread across your cluster among failure-domains such as regions, zones, nodes, and other user-defined topology domains https://kubernetes.io/docs/concepts/workloads/pods/pod-topology-spread-constraints/ | [][v1.TopologySpreadConstraint](https://kubernetes.io/docs/concepts/workloads/pods/pod-topology-spread-constraints/) | false |
| storageDataPath | StorageDataPath - path to storage data | string | false |
| storage | Storage - add persistent volume for StorageDataPath its useful for persistent cache | *[StorageSpec](#storagespec) | false |
| terminationGracePeriodSeconds |  | int64 | false |
| schedulerName | SchedulerName - defines kubernetes scheduler name | string | false |
| runtimeClassName | RuntimeClassName - defines runtime class for kubernetes pod. https://kubernetes.io/docs/concepts/containers/runtime-class/ | *string | false |
| port | Port for health check connetions | string | false |
| vmInsertPort | VMInsertPort for VMInsert connections | string | false |
| vmSelectPort | VMSelectPort for VMSelect connections | string | false |
| vmBackup | VMBackup configuration for backup | *[VMBackup](#vmbackup) | false |
| extraArgs |  | map[string]string | false |
| extraEnvs | ExtraEnvs that will be added to VMSelect pod | [][v1.EnvVar](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#envvar-v1-core) | false |
| serviceSpec | ServiceSpec that will be create additional service for vmstorage | *[ServiceSpec](#servicespec) | false |
| podDisruptionBudget | PodDisruptionBudget created by operator | *[EmbeddedPodDisruptionBudgetSpec](#embeddedpoddisruptionbudgetspec) | false |
| maintenanceInsertNodeIDs | MaintenanceInsertNodeIDs - excludes given node ids from insert requests routing, must contain pod suffixes - for pod-0, id will be 0 and etc. lets say, you have pod-0, pod-1, pod-2, pod-3. to exclude pod-0 and pod-3 from insert routing, define nodeIDs: [0,3]. Useful at storage expanding, when you want to rebalance some data at cluster. | []int32 | false |
| maintenanceSelectNodeIDs | MaintenanceInsertNodeIDs - excludes given node ids from select requests routing, must contain pod suffixes - for pod-0, id will be 0 and etc. | []int32 | false |
| nodeSelector | NodeSelector Define which Nodes the Pods are scheduled on. | map[string]string | false |
| rollingUpdateStrategy | RollingUpdateStrategy defines strategy for application updates Default is OnDelete, in this case operator handles update process Can be changed for RollingUpdate | [appsv1.StatefulSetUpdateStrategyType](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#statefulsetupdatestrategy-v1-apps) | false |

[Back to TOC](#table-of-contents)

## VMNodeScrape

VMNodeScrape defines discovery for targets placed on kubernetes nodes, usually its node-exporters and other host services. InternalIP is used as __address__ for scraping.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ObjectMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#objectmeta-v1-meta) | false |
| spec |  | [VMNodeScrapeSpec](#vmnodescrapespec) | false |
| status |  | [VMNodeScrapeStatus](#vmnodescrapestatus) | false |

[Back to TOC](#table-of-contents)

## VMNodeScrapeList

VMNodeScrapeList contains a list of VMNodeScrape

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ListMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#listmeta-v1-meta) | false |
| items |  | [][VMNodeScrape](#vmnodescrape) | true |

[Back to TOC](#table-of-contents)

## VMNodeScrapeSpec

VMNodeScrapeSpec defines specification for VMNodeScrape.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| jobLabel | The label to use to retrieve the job name from. | string | false |
| targetLabels | TargetLabels transfers labels on the Kubernetes Node onto the target. | []string | false |
| port | Name of the port exposed at Node. | string | false |
| path | HTTP path to scrape for metrics. | string | false |
| scheme | HTTP scheme to use for scraping. | string | false |
| params | Optional HTTP URL parameters | map[string][]string | false |
| follow_redirects | FollowRedirects controls redirects for scraping. | *bool | false |
| interval | Interval at which metrics should be scraped | string | false |
| scrape_interval | ScrapeInterval is the same as Interval and has priority over it. one of scrape_interval or interval can be used | string | false |
| scrapeTimeout | Timeout after which the scrape is ended | string | false |
| oauth2 | OAuth2 defines auth configuration | *[OAuth2](#oauth2) | false |
| tlsConfig | TLSConfig configuration to use when scraping the node | *[TLSConfig](#tlsconfig) | false |
| bearerTokenFile | File to read bearer token for scraping targets. | string | false |
| bearerTokenSecret | Secret to mount to read bearer token for scraping targets. The secret needs to be  accessible by the victoria-metrics operator. | *[v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| honorLabels | HonorLabels chooses the metric&#39;s labels on collisions with target labels. | bool | false |
| honorTimestamps | HonorTimestamps controls whether vmagent respects the timestamps present in scraped data. | *bool | false |
| basicAuth | BasicAuth allow an endpoint to authenticate over basic authentication More info: https://prometheus.io/docs/operating/configuration/#endpoints | *[BasicAuth](#basicauth) | false |
| metricRelabelConfigs | MetricRelabelConfigs to apply to samples before ingestion. | []*[RelabelConfig](#relabelconfig) | false |
| relabelConfigs | RelabelConfigs to apply to samples before scraping. More info: https://prometheus.io/docs/prometheus/latest/configuration/configuration/#relabel_config | []*[RelabelConfig](#relabelconfig) | false |
| proxyURL | ProxyURL eg http://proxyserver:2195 Directs scrapes to proxy through this endpoint. | *string | false |
| selector | Selector to select kubernetes Nodes. | [metav1.LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#labelselector-v1-meta) | false |
| sampleLimit | SampleLimit defines per-scrape limit on number of scraped samples that will be accepted. | uint64 | false |
| vm_scrape_params | VMScrapeParams defines VictoriaMetrics specific scrape parametrs | *[VMScrapeParams](#vmscrapeparams) | false |

[Back to TOC](#table-of-contents)

## CRDRef

CRDRef describe CRD target reference.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| kind | Kind one of: VMAgent VMAlert VMCluster VMSingle or VMAlertManager | string | true |
| name | Name target CRD object name | string | true |
| namespace | Namespace target CRD object namespace. | string | true |

[Back to TOC](#table-of-contents)

## StaticRef

StaticRef - user-defined routing host address.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| url | URL http url for given staticRef. | string | true |

[Back to TOC](#table-of-contents)

## TargetRef

TargetRef describes target for user traffic forwarding. one of target types can be chosen: crd or static per targetRef. user can define multiple targetRefs with different ref Types.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| crd | CRD describes exist operator&#39;s CRD object, operator generates access url based on CRD params. | *[CRDRef](#crdref) | false |
| static | Static - user defined url for traffic forward, for instance http://vmsingle:8429 | *[StaticRef](#staticref) | false |
| paths | Paths - matched path to route. | []string | false |
| target_path_suffix | QueryParams []string `json:\&#34;queryParams,omitempty\&#34;` TargetPathSuffix allows to add some suffix to the target path It allows to hide tenant configuration from user with crd as ref. it also may contain any url encoded params. | string | false |
| headers | Headers represent additional http headers, that vmauth uses in form of [\&#34;header_key: header_value\&#34;] multiple values for header key: [\&#34;header_key: value1,value2\&#34;] it&#39;s available since 1.68.0 version of vmauth | []string | false |

[Back to TOC](#table-of-contents)

## VMUser

VMUser is the Schema for the vmusers API

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ObjectMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#objectmeta-v1-meta) | false |
| spec |  | [VMUserSpec](#vmuserspec) | false |
| status |  | [VMUserStatus](#vmuserstatus) | false |

[Back to TOC](#table-of-contents)

## VMUserList

VMUserList contains a list of VMUser

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ListMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#listmeta-v1-meta) | false |
| items |  | [][VMUser](#vmuser) | true |

[Back to TOC](#table-of-contents)

## VMUserSpec

VMUserSpec defines the desired state of VMUser

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| username | UserName basic auth user name for accessing protected endpoint, will be replaced with metadata.name of VMUser if omitted. | *string | false |
| password | Password basic auth password for accessing protected endpoint. | *string | false |
| passwordRef | PasswordRef allows to fetch password from user-create secret by its name and key. | *[v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| generatePassword | GeneratePassword instructs operator to generate password for user if spec.password if empty. | bool | false |
| bearerToken | BearerToken Authorization header value for accessing protected endpoint. | *string | false |
| targetRefs | TargetRefs - reference to endpoints, which user may access. | [][TargetRef](#targetref) | true |

[Back to TOC](#table-of-contents)

## EmbeddedIngress

EmbeddedIngress describes ingress configuration options.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| class_name | ClassName defines ingress class name for VMAuth | *string | false |
| tlsHosts | TlsHosts configures TLS access for ingress, tlsSecretName must be defined for it. | []string | false |
| tlsSecretName | TlsSecretName defines secretname at the VMAuth namespace with cert and key https://kubernetes.io/docs/concepts/services-networking/ingress/#tls | string | false |
| extraRules | ExtraRules - additional rules for ingress, must be checked for correctness by user. | [][v12.IngressRule](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#ingressrule-v1-networking-k8s-io) | false |
| extraTls | ExtraTLS - additional TLS configuration for ingress must be checked for correctness by user. | [][v12.IngressTLS](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#ingresstls-v1-networking-k8s-io) | false |

[Back to TOC](#table-of-contents)

## VMAuth

VMAuth is the Schema for the vmauths API

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ObjectMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#objectmeta-v1-meta) | false |
| spec |  | [VMAuthSpec](#vmauthspec) | false |
| status |  | [VMAuthStatus](#vmauthstatus) | false |

[Back to TOC](#table-of-contents)

## VMAuthList

VMAuthList contains a list of VMAuth

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ListMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#listmeta-v1-meta) | false |
| items |  | [][VMAuth](#vmauth) | true |

[Back to TOC](#table-of-contents)

## VMAuthSpec

VMAuthSpec defines the desired state of VMAuth

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| podMetadata | PodMetadata configures Labels and Annotations which are propagated to the VMAuth pods. | *[EmbeddedObjectMetadata](#embeddedobjectmetadata) | false |
| image | Image - docker image settings for VMAuth if no specified operator uses default config version | [Image](#image) | false |
| imagePullSecrets | ImagePullSecrets An optional list of references to secrets in the same namespace to use for pulling images from registries see http://kubernetes.io/docs/user-guide/images#specifying-imagepullsecrets-on-a-pod | [][v1.LocalObjectReference](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#localobjectreference-v1-core) | false |
| secrets | Secrets is a list of Secrets in the same namespace as the VMAuth object, which shall be mounted into the VMAuth Pods. | []string | false |
| configMaps | ConfigMaps is a list of ConfigMaps in the same namespace as the VMAuth object, which shall be mounted into the VMAuth Pods. | []string | false |
| logLevel | LogLevel for victoria metrics single to be configured with. | string | false |
| logFormat | LogFormat for VMAuth to be configured with. | string | false |
| replicaCount | ReplicaCount is the expected size of the VMAuth | *int32 | false |
| volumes | Volumes allows configuration of additional volumes on the output deploy definition. Volumes specified will be appended to other volumes that are generated as a result of StorageSpec objects. | [][v1.Volume](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#volume-v1-core) | false |
| volumeMounts | VolumeMounts allows configuration of additional VolumeMounts on the output Deployment definition. VolumeMounts specified will be appended to other VolumeMounts in the VMAuth container, that are generated as a result of StorageSpec objects. | [][v1.VolumeMount](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#volumemount-v1-core) | false |
| resources | Resources container resource request and limits, https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/ if not defined default resources from operator config will be used | [v1.ResourceRequirements](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#resourcerequirements-v1-core) | false |
| affinity | Affinity If specified, the pod&#39;s scheduling constraints. | *[v1.Affinity](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#affinity-v1-core) | false |
| tolerations | Tolerations If specified, the pod&#39;s tolerations. | [][v1.Toleration](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#toleration-v1-core) | false |
| securityContext | SecurityContext holds pod-level security attributes and common container settings. This defaults to the default PodSecurityContext. | *[v1.PodSecurityContext](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#podsecuritycontext-v1-core) | false |
| serviceAccountName | ServiceAccountName is the name of the ServiceAccount to use to run the VMAuth Pods. | string | false |
| schedulerName | SchedulerName - defines kubernetes scheduler name | string | false |
| runtimeClassName | RuntimeClassName - defines runtime class for kubernetes pod. https://kubernetes.io/docs/concepts/containers/runtime-class/ | *string | false |
| podSecurityPolicyName | PodSecurityPolicyName - defines name for podSecurityPolicy in case of empty value, prefixedName will be used. | string | false |
| hostAliases | HostAliases provides mapping for ip and hostname, that would be propagated to pod, cannot be used with HostNetwork. | []v1.HostAlias | false |
| containers | Containers property allows to inject additions sidecars or to patch existing containers. It can be useful for proxies, backup, etc. | [][v1.Container](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#container-v1-core) | false |
| initContainers | InitContainers allows adding initContainers to the pod definition. Those can be used to e.g. fetch secrets for injection into the vmSingle configuration from external sources. Any errors during the execution of an initContainer will lead to a restart of the Pod. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/ Using initContainers for any use case other then secret fetching is entirely outside the scope of what the maintainers will support and by doing so, you accept that this behaviour may break at any time without notice. | [][v1.Container](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#container-v1-core) | false |
| priorityClassName | PriorityClassName assigned to the Pods | string | false |
| hostNetwork | HostNetwork controls whether the pod may use the node network namespace | bool | false |
| dnsPolicy | DNSPolicy sets DNS policy for the pod | [v1.DNSPolicy](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#pod-v1-core) | false |
| topologySpreadConstraints | TopologySpreadConstraints embedded kubernetes pod configuration option, controls how pods are spread across your cluster among failure-domains such as regions, zones, nodes, and other user-defined topology domains https://kubernetes.io/docs/concepts/workloads/pods/pod-topology-spread-constraints/ | [][v1.TopologySpreadConstraint](https://kubernetes.io/docs/concepts/workloads/pods/pod-topology-spread-constraints/) | false |
| port | Port listen port | string | false |
| selectAllByDefault | SelectAllByDefault changes default behavior for empty CRD selectors, such userSelector. with selectAllByDefault: true and empty userSelector and userNamespaceSelector Operator selects all exist users with selectAllByDefault: false - selects nothing | bool | false |
| userSelector | UserSelector defines VMUser to be selected for config file generation. Works in combination with NamespaceSelector. NamespaceSelector nil - only objects at VMAuth namespace. If both nil - behaviour controlled by selectAllByDefault | *[metav1.LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#labelselector-v1-meta) | false |
| userNamespaceSelector | UserNamespaceSelector Namespaces to be selected for  VMAuth discovery. Works in combination with Selector. NamespaceSelector nil - only objects at VMAuth namespace. Selector nil - only objects at NamespaceSelector namespaces. If both nil - behaviour controlled by selectAllByDefault | *[metav1.LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#labelselector-v1-meta) | false |
| extraArgs | ExtraArgs that will be passed to  VMAuth pod for example remoteWrite.tmpDataPath: /tmp | map[string]string | false |
| extraEnvs | ExtraEnvs that will be added to VMAuth pod | [][v1.EnvVar](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#envvar-v1-core) | false |
| serviceSpec | ServiceSpec that will be added to vmsingle service spec | *[ServiceSpec](#servicespec) | false |
| podDisruptionBudget | PodDisruptionBudget created by operator | *[EmbeddedPodDisruptionBudgetSpec](#embeddedpoddisruptionbudgetspec) | false |
| ingress | Ingress enables ingress configuration for VMAuth. | *[EmbeddedIngress](#embeddedingress) | false |
| nodeSelector | NodeSelector Define which Nodes the Pods are scheduled on. | map[string]string | false |

[Back to TOC](#table-of-contents)

## TargetEndpoint

TargetEndpoint defines single static target endpoint.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| targets | Targets static targets addresses in form of [\&#34;192.122.55.55:9100\&#34;,\&#34;some-name:9100\&#34;]. | []string | true |
| labels | Labels static labels for targets. | map[string]string | false |
| port | Default port for target. | string | false |
| path | HTTP path to scrape for metrics. | string | false |
| scheme | HTTP scheme to use for scraping. | string | false |
| params | Optional HTTP URL parameters | map[string][]string | false |
| follow_redirects | FollowRedirects controls redirects for scraping. | *bool | false |
| sampleLimit | SampleLimit defines per-scrape limit on number of scraped samples that will be accepted. | uint64 | false |
| interval | Interval at which metrics should be scraped | string | false |
| scrape_interval | ScrapeInterval is the same as Interval and has priority over it. one of scrape_interval or interval can be used | string | false |
| scrapeTimeout | Timeout after which the scrape is ended | string | false |
| oauth2 | OAuth2 defines auth configuration | *[OAuth2](#oauth2) | false |
| tlsConfig | TLSConfig configuration to use when scraping the endpoint | *[TLSConfig](#tlsconfig) | false |
| bearerTokenFile | File to read bearer token for scraping targets. | string | false |
| bearerTokenSecret | Secret to mount to read bearer token for scraping targets. The secret needs to be in the same namespace as the service scrape and accessible by the victoria-metrics operator. | *[v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| basicAuth | BasicAuth allow an endpoint to authenticate over basic authentication More info: https://prometheus.io/docs/operating/configuration/#endpoints | *[BasicAuth](#basicauth) | false |
| metricRelabelConfigs | MetricRelabelConfigs to apply to samples before ingestion. | []*[RelabelConfig](#relabelconfig) | false |
| relabelConfigs | RelabelConfigs to apply to samples before scraping. More info: https://prometheus.io/docs/prometheus/latest/configuration/configuration/#relabel_config | []*[RelabelConfig](#relabelconfig) | false |
| proxyURL | ProxyURL eg http://proxyserver:2195 Directs scrapes to proxy through this endpoint. | *string | false |
| honorLabels | HonorLabels chooses the metric&#39;s labels on collisions with target labels. | bool | false |
| honorTimestamps | HonorTimestamps controls whether vmagent respects the timestamps present in scraped data. | *bool | false |
| vm_scrape_params | VMScrapeParams defines VictoriaMetrics specific scrape parametrs | *[VMScrapeParams](#vmscrapeparams) | false |

[Back to TOC](#table-of-contents)

## VMStaticScrape

VMStaticScrape  defines static targets configuration for scraping.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ObjectMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#objectmeta-v1-meta) | false |
| spec |  | [VMStaticScrapeSpec](#vmstaticscrapespec) | false |
| status |  | [VMStaticScrapeStatus](#vmstaticscrapestatus) | false |

[Back to TOC](#table-of-contents)

## VMStaticScrapeList

VMStaticScrapeList contains a list of VMStaticScrape

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ListMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#listmeta-v1-meta) | false |
| items |  | [][VMStaticScrape](#vmstaticscrape) | true |

[Back to TOC](#table-of-contents)

## VMStaticScrapeSpec

VMStaticScrapeSpec defines the desired state of VMStaticScrape.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| jobName | JobName name of job. | string | false |
| targetEndpoints | A list of target endpoints to scrape metrics from. | []*[TargetEndpoint](#targetendpoint) | true |
| sampleLimit | SampleLimit defines per-scrape limit on number of scraped samples that will be accepted. | uint64 | false |

[Back to TOC](#table-of-contents)

## ProbeTargetIngress

ProbeTargetIngress defines the set of Ingress objects considered for probing.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| selector | Select Ingress objects by labels. | [metav1.LabelSelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#labelselector-v1-meta) | false |
| namespaceSelector | Select Ingress objects by namespace. | [NamespaceSelector](#namespaceselector) | false |
| relabelingConfigs | RelabelConfigs to apply to samples before ingestion. More info: https://prometheus.io/docs/prometheus/latest/configuration/configuration/#relabel_config | []*[RelabelConfig](#relabelconfig) | false |

[Back to TOC](#table-of-contents)

## VMProbe

\n VMProbe defines a probe for targets, that will be executed with prober,\n like blackbox exporter.\nIt helps to monitor reachability of target with various checks.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ObjectMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#objectmeta-v1-meta) | false |
| spec |  | [VMProbeSpec](#vmprobespec) | true |
| status |  | [VMProbeStatus](#vmprobestatus) | false |

[Back to TOC](#table-of-contents)

## VMProbeList

VMProbeList contains a list of VMProbe

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| metadata |  | [metav1.ListMeta](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#listmeta-v1-meta) | false |
| items |  | [][VMProbe](#vmprobe) | true |

[Back to TOC](#table-of-contents)

## VMProbeSpec

VMProbeSpec contains specification parameters for a Probe.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| jobName | The job name assigned to scraped metrics by default. | string | false |
| vmProberSpec | Specification for the prober to use for probing targets. The prober.URL parameter is required. Targets cannot be probed if left empty. | [VMProberSpec](#vmproberspec) | true |
| module | The module to use for probing specifying how to probe the target. Example module configuring in the blackbox exporter: https://github.com/prometheus/blackbox_exporter/blob/master/example.yml | string | false |
| targets | Targets defines a set of static and/or dynamically discovered targets to be probed using the prober. | [VMProbeTargets](#vmprobetargets) | false |
| interval | Interval at which targets are probed using the configured prober. If not specified Prometheus&#39; global scrape interval is used. | string | false |
| scrape_interval | ScrapeInterval is the same as Interval and has priority over it. one of scrape_interval or interval can be used | string | false |
| scrapeTimeout | Timeout for scraping metrics from the Prometheus exporter. | string | false |
| params | Optional HTTP URL parameters | map[string][]string | false |
| follow_redirects | FollowRedirects controls redirects for scraping. | *bool | false |
| sampleLimit | SampleLimit defines per-scrape limit on number of scraped samples that will be accepted. | uint64 | false |
| bearerTokenFile | File to read bearer token for scraping targets. | string | false |
| bearerTokenSecret | Secret to mount to read bearer token for scraping targets. The secret needs to be in the same namespace as the service scrape and accessible by the victoria-metrics operator. | *[v1.SecretKeySelector](https://kubernetes.io/docs/reference/generated/kubernetes-api/v1.22/#secretkeyselector-v1-core) | false |
| basicAuth | BasicAuth allow an endpoint to authenticate over basic authentication More info: https://prometheus.io/docs/operating/configuration/#endpoints | *[BasicAuth](#basicauth) | false |
| oauth2 | OAuth2 defines auth configuration | *[OAuth2](#oauth2) | false |
| tlsConfig | TLSConfig configuration to use when scraping the endpoint | *[TLSConfig](#tlsconfig) | false |
| vm_scrape_params | VMScrapeParams defines VictoriaMetrics specific scrape parametrs | *[VMScrapeParams](#vmscrapeparams) | false |

[Back to TOC](#table-of-contents)

## VMProbeTargetStaticConfig

VMProbeTargetStaticConfig defines the set of static targets considered for probing.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| targets | Targets is a list of URLs to probe using the configured prober. | []string | true |
| labels | Labels assigned to all metrics scraped from the targets. | map[string]string | false |
| relabelingConfigs | More info: https://prometheus.io/docs/prometheus/latest/configuration/configuration/#relabel_config | []*[RelabelConfig](#relabelconfig) | false |

[Back to TOC](#table-of-contents)

## VMProbeTargets

VMProbeTargets defines a set of static and dynamically discovered targets for the prober.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| staticConfig | StaticConfig defines static targets which are considers for probing. More info: https://prometheus.io/docs/prometheus/latest/configuration/configuration/#static_config. | *[VMProbeTargetStaticConfig](#vmprobetargetstaticconfig) | false |
| ingress | Ingress defines the set of dynamically discovered ingress objects which hosts are considered for probing. | *[ProbeTargetIngress](#probetargetingress) | false |

[Back to TOC](#table-of-contents)

## VMProberSpec

VMProberSpec contains specification parameters for the Prober used for probing.

| Field | Description | Scheme | Required |
| ----- | ----------- | ------ | -------- |
| url | Mandatory URL of the prober. | string | true |
| scheme | HTTP scheme to use for scraping. Defaults to `http`. | string | false |
| path | Path to collect metrics from. Defaults to `/probe`. | string | false |

[Back to TOC](#table-of-contents)
