/***************************************************************************
                publichubsmodel.h - Public Hub List Model header
                             -------------------
    begin                : Mon Nov 5 2007
    copyright            : (C) 2007 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PUBLICHUBSMODEL_H
#define PUBLICHUBSMODEL_H

#include <QAbstractItemModel>
#include <QString>
#include <QList>

#include <dclib/dcos.h>

/**
 * @author Edward Sheldrake
 * 
 * This now doesn't really do anything since anything interesting
 * is done by PublicHubsProxy and probably QStandardItemModel
 * would be better, except you would need several QStandardItems
 * for each row (one for each column)?
 */

class PublicHubItem {

public:
	/** Constructor */
	PublicHubItem( const QString name,
		       const QString server,
		       const QString description,
		       const ulonglong users,
		       const QString country,
		       const ulonglong shared,
		       const ulonglong minshare,
		       const QString extra );
	/** Destructor */
	~PublicHubItem();

	/** Hub name */
	QString name;
	/** Hub address */
	QString server;
	/** Hub description */
	QString description;
	/** Hub geographic location */
	QString country;
	/** Any extra fields from the XML hublist */
	QString extra;
	/** Hub user count */
	ulonglong users;
	/** Total shared on the hub */
	ulonglong shared;
	/** Minimum shared needed to join the hub */
	ulonglong minshare;
};

/* it is the same for sorting and filtering */
#define PublicHubsProxyRole Qt::UserRole+6

class PublicHubsModel : public QAbstractItemModel {
Q_OBJECT

public:
	/** Constructor */
	PublicHubsModel( QObject * parent = 0 );
	/** Destructor */
	virtual ~PublicHubsModel();
	
	/** number of rows */
	virtual int rowCount( const QModelIndex & index = QModelIndex() ) const;
	/** number of columns */
	virtual int columnCount( const QModelIndex & index = QModelIndex() ) const;
	/** gets data */
	virtual QVariant data( const QModelIndex & index, int role = Qt::DisplayRole ) const;
	/** gets headings */
	virtual QVariant headerData( int section, Qt::Orientation orientation, int role = Qt::DisplayRole ) const;
	/** */
	virtual QModelIndex index( int row, int column, const QModelIndex & parent = QModelIndex() ) const;
	/** */
	virtual QModelIndex parent( const QModelIndex & parent ) const;
	
	/** adds hub */
	void addHub( const QString name,
		     const QString address,
		     const QString desc = "",
		     const ulonglong users = 0,
		     const QString country = "",
		     const ulonglong shared = 0,
		     const ulonglong minshare = 0,
		     const QString extra = "" );
	/** delete all data */
	void clear();
	/**
	 * Delete the hub - the pointer given in the parameter will no longer be
	 * valid after this is called.
	 */
	bool deleteHub( PublicHubItem * hub );
	/** get all hubs */
	QList<PublicHubItem*> getAll();
	/** get a hub */
	PublicHubItem * getItem( const QModelIndex & index );

private:
	/** list of all items */
	QList<PublicHubItem*> itemList;
};

#endif // PUBLICHUBSMODEL_H
