/***************************************************************************
                          dcdebug.h  -  description
                             -------------------
    begin                : Don Sep 25 2003
    copyright            : (C) 2003 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCDEBUG_H
#define DCDEBUG_H

#include <qprocess.h>

#include <dclib/core/cstring.h>

#include "DCDialogDebug.h"

/**
  *@author Mathias Küster
  */

class DCDebug : public QDialog, private Ui::DCDialogDebug  {
Q_OBJECT

public: 
	/** construtor */
	DCDebug( QWidget * parent = 0 );
	/** destructor */
	virtual ~DCDebug();

	/** */
	bool Init( QString configpath, QString debugopt );

	/** */
	static CString arg_0;
	/** */
	static CString startup_dir;


private slots:
	/** */
	void slotSaveBacktrace();
	/** */
	void slotDebuggerFinished( int exitCode, QProcess::ExitStatus exitStatus );

private:
	/** process that runs gdb */
	QProcess * m_pDebug;
};

#ifndef WIN32
	/** */
	void crash_install_handlers( void );
	/** */
	bool can_we_handle_signal( const int signum );
	/** */
	void print_signal_name( const int signum );
#endif

#endif
