/*

Copyright (C) 2008-2022 Michele Martone

This file is part of librsb.

librsb is free software; you can redistribute it and/or modify it
under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

librsb is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public
License along with librsb; see the file COPYING.
If not, see <http://www.gnu.org/licenses/>.

*/
/* @cond INNERDOC */
/* This file was generated by the Makefile */
#include "rsb.h"
#include "rsb_common.h"
#include "rsb_do.h"
rsb_err_t rsb__do_get_matrix_info_from_string(const struct rsb_mtx_t *matrix, const rsb_char_t *mis, void* info, size_t buflen)
{ rsb_err_t errval=RSB_ERR_BADARGS; if(!matrix || !mis || !info)goto err;
if(0 == strcmp(mis,"RSB_MIF_INDEX_STORAGE_IN_BYTES__TO__SIZE_T")){ errval = rsb__do_get_matrix_info(matrix,RSB_MIF_INDEX_STORAGE_IN_BYTES__TO__SIZE_T,info,buflen); goto done;}
if(0 == strcmp(mis,"RSB_MIF_INDEX_STORAGE_IN_BYTES_PER_NNZ__TO__RSB_REAL_T")){ errval = rsb__do_get_matrix_info(matrix,RSB_MIF_INDEX_STORAGE_IN_BYTES_PER_NNZ__TO__RSB_REAL_T,info,buflen); goto done;}
if(0 == strcmp(mis,"RSB_MIF_MATRIX_ROWS__TO__RSB_COO_INDEX_T")){ errval = rsb__do_get_matrix_info(matrix,RSB_MIF_MATRIX_ROWS__TO__RSB_COO_INDEX_T,info,buflen); goto done;}
if(0 == strcmp(mis,"RSB_MIF_MATRIX_COLS__TO__RSB_COO_INDEX_T")){ errval = rsb__do_get_matrix_info(matrix,RSB_MIF_MATRIX_COLS__TO__RSB_COO_INDEX_T,info,buflen); goto done;}
if(0 == strcmp(mis,"RSB_MIF_MATRIX_NNZ__TO__RSB_NNZ_INDEX_T")){ errval = rsb__do_get_matrix_info(matrix,RSB_MIF_MATRIX_NNZ__TO__RSB_NNZ_INDEX_T,info,buflen); goto done;}
if(0 == strcmp(mis,"RSB_MIF_TOTAL_SIZE__TO__SIZE_T")){ errval = rsb__do_get_matrix_info(matrix,RSB_MIF_TOTAL_SIZE__TO__SIZE_T,info,buflen); goto done;}
if(0 == strcmp(mis,"RSB_MIF_MATRIX_FLAGS__TO__RSB_FLAGS_T")){ errval = rsb__do_get_matrix_info(matrix,RSB_MIF_MATRIX_FLAGS__TO__RSB_FLAGS_T,info,buflen); goto done;}
if(0 == strcmp(mis,"RSB_MIF_MATRIX_TYPECODE__TO__RSB_TYPE_T")){ errval = rsb__do_get_matrix_info(matrix,RSB_MIF_MATRIX_TYPECODE__TO__RSB_TYPE_T,info,buflen); goto done;}
if(0 == strcmp(mis,"RSB_MIF_MATRIX_INFO__TO__CHAR_P")){ errval = rsb__do_get_matrix_info(matrix,RSB_MIF_MATRIX_INFO__TO__CHAR_P,info,buflen); goto done;}
if(0 == strcmp(mis,"RSB_MIF_LEAVES_COUNT__TO__RSB_BLK_INDEX_T")){ errval = rsb__do_get_matrix_info(matrix,RSB_MIF_LEAVES_COUNT__TO__RSB_BLK_INDEX_T,info,buflen); goto done;}
done:
return errval;
err: return RSB_ERR_GENERIC_ERROR;
}

rsb_err_t rsb__dump_flags(const rsb_flags_t cflags, const rsb_char_t *pre, const rsb_char_t *intra, const rsb_char_t *post)
{ rsb_err_t errval=RSB_ERR_BADARGS; int ef=0; rsb_flags_t flags=cflags;
if(RSB_FLAG_NOFLAGS&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_NOFLAGS)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_NOFLAGS");RSB_DO_FLAG_DEL(flags,RSB_FLAG_NOFLAGS);}
if(RSB_FLAG_FORTRAN_INDICES_INTERFACE&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_FORTRAN_INDICES_INTERFACE)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_FORTRAN_INDICES_INTERFACE");RSB_DO_FLAG_DEL(flags,RSB_FLAG_FORTRAN_INDICES_INTERFACE);}
if(RSB_FLAG_C_INDICES_INTERFACE&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_C_INDICES_INTERFACE)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_C_INDICES_INTERFACE");RSB_DO_FLAG_DEL(flags,RSB_FLAG_C_INDICES_INTERFACE);}
if(RSB_FLAG_USE_HALFWORD_INDICES&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_USE_HALFWORD_INDICES)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_USE_HALFWORD_INDICES");RSB_DO_FLAG_DEL(flags,RSB_FLAG_USE_HALFWORD_INDICES);}
if(RSB_FLAG_WANT_ROW_MAJOR_ORDER&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_WANT_ROW_MAJOR_ORDER)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_WANT_ROW_MAJOR_ORDER");RSB_DO_FLAG_DEL(flags,RSB_FLAG_WANT_ROW_MAJOR_ORDER);}
if(RSB_FLAG_WANT_COLUMN_MAJOR_ORDER&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_WANT_COLUMN_MAJOR_ORDER)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_WANT_COLUMN_MAJOR_ORDER");RSB_DO_FLAG_DEL(flags,RSB_FLAG_WANT_COLUMN_MAJOR_ORDER);}
if(RSB_FLAG_SORTED_INPUT&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_SORTED_INPUT)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_SORTED_INPUT");RSB_DO_FLAG_DEL(flags,RSB_FLAG_SORTED_INPUT);}
if(RSB_FLAG_TRIANGULAR&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_TRIANGULAR)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_TRIANGULAR");RSB_DO_FLAG_DEL(flags,RSB_FLAG_TRIANGULAR);}
if(RSB_FLAG_LOWER&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_LOWER)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_LOWER");RSB_DO_FLAG_DEL(flags,RSB_FLAG_LOWER);}
if(RSB_FLAG_UPPER&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_UPPER)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_UPPER");RSB_DO_FLAG_DEL(flags,RSB_FLAG_UPPER);}
if(RSB_FLAG_UNIT_DIAG_IMPLICIT&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_UNIT_DIAG_IMPLICIT)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_UNIT_DIAG_IMPLICIT");RSB_DO_FLAG_DEL(flags,RSB_FLAG_UNIT_DIAG_IMPLICIT);}
if(RSB_FLAG_WANT_COO_STORAGE&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_WANT_COO_STORAGE)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_WANT_COO_STORAGE");RSB_DO_FLAG_DEL(flags,RSB_FLAG_WANT_COO_STORAGE);}
if(RSB_FLAG_DUPLICATES_KEEP_LAST&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_DUPLICATES_KEEP_LAST)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_DUPLICATES_KEEP_LAST");RSB_DO_FLAG_DEL(flags,RSB_FLAG_DUPLICATES_KEEP_LAST);}
if(RSB_FLAG_DUPLICATES_DEFAULT_HANDLE&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_DUPLICATES_DEFAULT_HANDLE)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_DUPLICATES_DEFAULT_HANDLE");RSB_DO_FLAG_DEL(flags,RSB_FLAG_DUPLICATES_DEFAULT_HANDLE);}
if(RSB_FLAG_DUPLICATES_SUM&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_DUPLICATES_SUM)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_DUPLICATES_SUM");RSB_DO_FLAG_DEL(flags,RSB_FLAG_DUPLICATES_SUM);}
if(RSB_FLAG_DISCARD_ZEROS&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_DISCARD_ZEROS)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_DISCARD_ZEROS");RSB_DO_FLAG_DEL(flags,RSB_FLAG_DISCARD_ZEROS);}
if(RSB_FLAG_QUAD_PARTITIONING&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_QUAD_PARTITIONING)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_QUAD_PARTITIONING");RSB_DO_FLAG_DEL(flags,RSB_FLAG_QUAD_PARTITIONING);}
if(RSB_FLAG_WANT_BCSS_STORAGE&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_WANT_BCSS_STORAGE)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_WANT_BCSS_STORAGE");RSB_DO_FLAG_DEL(flags,RSB_FLAG_WANT_BCSS_STORAGE);}
if(RSB_FLAG_ASSEMBLED_IN_COO_ARRAYS&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_ASSEMBLED_IN_COO_ARRAYS)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_ASSEMBLED_IN_COO_ARRAYS");RSB_DO_FLAG_DEL(flags,RSB_FLAG_ASSEMBLED_IN_COO_ARRAYS);}
if(RSB_FLAG_EXPERIMENTAL_IN_PLACE_PERMUTATION_SORT&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_EXPERIMENTAL_IN_PLACE_PERMUTATION_SORT)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_EXPERIMENTAL_IN_PLACE_PERMUTATION_SORT");RSB_DO_FLAG_DEL(flags,RSB_FLAG_EXPERIMENTAL_IN_PLACE_PERMUTATION_SORT);}
if(RSB_FLAG_SYMMETRIC&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_SYMMETRIC)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_SYMMETRIC");RSB_DO_FLAG_DEL(flags,RSB_FLAG_SYMMETRIC);}
if(RSB_FLAG_HERMITIAN&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_HERMITIAN)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_HERMITIAN");RSB_DO_FLAG_DEL(flags,RSB_FLAG_HERMITIAN);}
if(RSB_FLAG_RECURSIVE_MORE_LEAVES_THAN_THREADS&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_RECURSIVE_MORE_LEAVES_THAN_THREADS)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_RECURSIVE_MORE_LEAVES_THAN_THREADS");RSB_DO_FLAG_DEL(flags,RSB_FLAG_RECURSIVE_MORE_LEAVES_THAN_THREADS);}
if(RSB_FLAG_RECURSIVE_SUBDIVIDE_MORE_ON_DIAG&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_RECURSIVE_SUBDIVIDE_MORE_ON_DIAG)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_RECURSIVE_SUBDIVIDE_MORE_ON_DIAG");RSB_DO_FLAG_DEL(flags,RSB_FLAG_RECURSIVE_SUBDIVIDE_MORE_ON_DIAG);}
if(RSB_FLAG_EXTERNALLY_ALLOCATED_ARRAYS&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_EXTERNALLY_ALLOCATED_ARRAYS)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_EXTERNALLY_ALLOCATED_ARRAYS");RSB_DO_FLAG_DEL(flags,RSB_FLAG_EXTERNALLY_ALLOCATED_ARRAYS);}
if(RSB_FLAG_USE_CSR_RESERVED&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_USE_CSR_RESERVED)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_USE_CSR_RESERVED");RSB_DO_FLAG_DEL(flags,RSB_FLAG_USE_CSR_RESERVED);}
if(RSB_FLAG_OBSOLETE_BLOCK_ASYMMETRIC_Z_SORTING&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_OBSOLETE_BLOCK_ASYMMETRIC_Z_SORTING)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_OBSOLETE_BLOCK_ASYMMETRIC_Z_SORTING");RSB_DO_FLAG_DEL(flags,RSB_FLAG_OBSOLETE_BLOCK_ASYMMETRIC_Z_SORTING);}
if(RSB_FLAG_FIX_FOR_BINARY_LOADED_MATRIX&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_FIX_FOR_BINARY_LOADED_MATRIX)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_FIX_FOR_BINARY_LOADED_MATRIX");RSB_DO_FLAG_DEL(flags,RSB_FLAG_FIX_FOR_BINARY_LOADED_MATRIX);}
if(RSB_FLAG_EXPERIMENTAL_IN_PLACE_CSR&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_EXPERIMENTAL_IN_PLACE_CSR)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_EXPERIMENTAL_IN_PLACE_CSR");RSB_DO_FLAG_DEL(flags,RSB_FLAG_EXPERIMENTAL_IN_PLACE_CSR);}
if(RSB_FLAG_AUTO_BLOCKING&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_AUTO_BLOCKING)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_AUTO_BLOCKING");RSB_DO_FLAG_DEL(flags,RSB_FLAG_AUTO_BLOCKING);}
if(RSB_FLAG_OWN_PARTITIONING_ARRAYS&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_OWN_PARTITIONING_ARRAYS)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_OWN_PARTITIONING_ARRAYS");RSB_DO_FLAG_DEL(flags,RSB_FLAG_OWN_PARTITIONING_ARRAYS);}
if(RSB_FLAG_SHOULD_DEBUG&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_SHOULD_DEBUG)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_SHOULD_DEBUG");RSB_DO_FLAG_DEL(flags,RSB_FLAG_SHOULD_DEBUG);}
if(RSB_FLAG_WANT_FIXED_BLOCKING_VBR&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_WANT_FIXED_BLOCKING_VBR)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_WANT_FIXED_BLOCKING_VBR");RSB_DO_FLAG_DEL(flags,RSB_FLAG_WANT_FIXED_BLOCKING_VBR);}
if(RSB_FLAG_NON_ROOT_MATRIX&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_NON_ROOT_MATRIX)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_NON_ROOT_MATRIX");RSB_DO_FLAG_DEL(flags,RSB_FLAG_NON_ROOT_MATRIX);}
if(RSB_FLAG_SORT_INPUT&&RSB_DO_FLAG_HAS(flags,RSB_FLAG_SORT_INPUT)){RSB_STDOUT("%s%s",ef++?intra:pre,"RSB_FLAG_SORT_INPUT");RSB_DO_FLAG_DEL(flags,RSB_FLAG_SORT_INPUT);}
if(flags){RSB_STDOUT("%s0x%x",ef++?intra:pre,flags);}
if(ef)RSB_STDOUT("%s",post);
return errval;
}
/* @endcond */
