#include <odsstream/odsdocreader.h>
#include <odsstream/odsdocwriter.h>
#include <odsstream/odstablecellstyle.h>
#include <QDebug>

using namespace std;

class CustomHandler: public OdsDocHandlerInterface
{
public:
    /**
     * callback that indicates the begining of a data sheet. Override it in
     * order to retrieve information about the current data sheet.
     *
     */
    virtual void startSheet(const QString & sheet_name)  {} ;

    /**
    * callback that indicates the end of the current data sheet. Override it if
    * needed
    */
    virtual void endSheet()  {
        qDebug() << "endSheet";
    } ;

    /**
     * callback that indicates a new line start. Override it if needed.
     */

    virtual void startLine() {} ;

    /**
     * callback that indicates a line ending. Override it if needed.
     */

    virtual void endLine()  {} ;

    /**
     * callback that report the content of the current cell in a dedicated Cell
     * object. Override it if you need to retrieve cell content.
     */
    virtual void setCell(const OdsCell & cell)  {
        qDebug() << "CustomHandler::setCell " << cell.toString();
    } ;

    /**
     * callback that report the end of the ODS document. Override it if you need
     * to know that reading is finished.
     */
    virtual void endDocument() {} ;

};

int main(int argc, char **argv) {

    QFile file("test.ods");
    //file.open(QIODevice::WriteOnly);
    OdsDocWriter writer(&file);

    QColor red("red");
    OdsTableCellStyle style;
    style.setBackgroundColor(QColor("yellow"));
    style.setTextColor(red);

    OdsTableCellStyleRef ref = writer.getTableCellStyleRef(style);

    QString test("truc");

    writer.writeSheet("classeur");

    writer.writeCell(test);
    //writer.clearTableCellStyleRef();
    writer.setTableCellStyleRef(ref);
    writer.writeLine();
    writer.writeEmptyCell();
    writer.setCellAnnotation("ceci est un commentaire n1");
    writer.writeCell("coucou");
    bool vf(0);
    writer.writeCell(vf);
    
    
    writer.writeSheet("classeur2");

    writer.writeCell(test);
    //writer.clearTableCellStyleRef();
    writer.setTableCellStyleRef(ref);
    writer.writeLine();
    writer.writeEmptyCell();
    writer.setCellAnnotation("ceci est un commentaire n1");
    writer.writeCell("coucou");

    QDateTime currentdate (QDateTime::currentDateTime());

    writer.setCellAnnotation("ceci est un commentaire sur une date");
    writer.writeCell(currentdate);

    writer.clearTableCellStyleRef();
    writer.writeLine();
    writer.writeEmptyCell();
    writer.setCellAnnotation("ceci est un commentaire");
    writer.writeCell("coucou");
    writer.writeCell(vf);
    writer.writeCell(currentdate);
    
    writer.writeCellPercentage(0.2);

    QUrl urltest("http://pappso.inra.fr/");
    writer.writeCell(urltest,"ceci est un lien");
    writer.close();

    file.close();

    //qDebug() << "coucou";

    //file.open();
    CustomHandler handler;
    OdsDocReader reader(handler);
    reader.parse(&file);
    file.close();

    QFile file2("test2.ods");
    OdsDocReader reader2(handler);
    reader2.parse(&file2);

    file2.close();

    //SUCCESS

    OdsDocWriter writerb("testbis.ods");
    writerb.writeCell("coucou");

    return 0;
}
