# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20220601185318;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[0568]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[2-6]\\d{10}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[2-6]\\d{10}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          15[0-25-9]\\d{8}|
          1(?:
            6[023]|
            7\\d
          )\\d{7,8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"498468", "Altmannstein\-Pondorf",
"492941", "Lippstadt",
"496122", "Hofheim\-Wallau",
"495456", "Westerkappeln\-Velpe",
"492582", "Everswinkel",
"493475", "Lutherstadt\ Eisleben",
"4938720", "Grebbin",
"492672", "Treis\-Karden",
"497448", "Seewald",
"494194", "Sievershütten",
"4938379", "Benz\ Usedom",
"4935694", "Gosda\ bei\ Klinge",
"494361", "Oldenburg\ in\ Holstein",
"4939222", "Möser",
"4933395", "Zerpenschleuse",
"4937320", "Mulda\ Sachsen",
"492454", "Gangelt",
"4933476", "Neuhardenberg",
"4933978", "Segeletz",
"494503", "Timmendorfer\ Strand",
"499748", "Motten",
"4939722", "Sarnow\ bei\ Anklam",
"4938352", "Kemnitz\ bei\ Greifswald",
"493901", "Salzwedel",
"4935895", "Klitten",
"498369", "Rückholz",
"4936458", "Bad\ Berka",
"494644", "Karby",
"4936739", "Rottenbach",
"494154", "Trittau",
"498306", "Ronsberg",
"496444", "Bischoffen",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"497255", "Graben\-Neudorf",
"4934385", "Mutzschen",
"494884", "Schwabstedt",
"4938220", "Wustrow\ Ostseebad",
"493425", "Wurzen",
"4937752", "Eibenstock",
"492622", "Bendorf\ am\ Rhein",
"4938858", "Lassahn",
"492332", "Gevelsberg",
"495650", "Cornberg",
"499746", "Zeitlofs",
"4934721", "Nienburg\ Saale",
"499536", "Kirchlauter",
"496754", "Martinstein",
"499359", "Karlstadt\-Wiesenfeld",
"494772", "Oberndorf\ Oste",
"493737", "Rochlitz",
"4939748", "Viereck",
"497446", "Lossburg",
"492384", "Welver",
"494975", "Westerholt\ Ostfriesland",
"494832", "Meldorf",
"493877", "Wittenberge",
"4939294", "Gross\ Rosenburg",
"4939487", "Friedrichsbrunn",
"499498", "Laaber",
"495458", "Hopsten",
"493691", "Eisenach\ Thüringen",
"4933205", "Michendorf",
"498466", "Denkendorf\ Oberbayern",
"499245", "Obertrubach",
"4939056", "Klüden",
"4939248", "Dobritz",
"4936941", "Wasungen",
"495245", "Herzebrock\-Clarholz",
"494925", "Hinte",
"497066", "Bad\ Rappenau\-Bonfeld",
"492507", "Havixbeck",
"492534", "Münster\-Roxel",
"498046", "Bad\ Heilbrunn",
"492744", "Herdorf",
"495536", "Holzminden\-Neuhaus",
"4934221", "Schildau\ Gneisenaustadt",
"497150", "Korntal\-Münchingen",
"492861", "Borken\ Westfalen",
"495746", "Rödinghausen",
"494401", "Brake\ Unterweser",
"499386", "Prosselsheim",
"494722", "Cuxhaven\-Altenbruch",
"496771", "St\ Goarshausen",
"4935793", "Elstra",
"496183", "Erlensee",
"496564", "Neuerburg\ Eifel",
"4933931", "Rheinsberg\ Mark",
"496155", "Griesheim\ Hessen",
"494445", "Visbek\ Kreis\ Vechta",
"496853", "Marpingen",
"4936963", "Dorndorf\ Rhön",
"497272", "Rülzheim",
"4938429", "Glasin",
"492695", "Insul",
"492523", "Wadersloh",
"497976", "Sulzbach\-Laufen",
"494298", "Lilienthal",
"496645", "Ulrichstein",
"495201", "Halle\ Westfalen",
"4939832", "Wesenberg",
"496831", "Saarlouis",
"4939421", "Osterwieck",
"496357", "Standenbühl",
"493624", "Ohrdruf",
"493334", "Eberswalde",
"493307", "Zehdenick",
"4935826", "Königshain\ bei\ Görlitz",
"4939952", "Grammentin",
"496397", "Leimen\ Pfalz",
"499201", "Gesees",
"494967", "Rhauderfehn\-Burlage",
"4933870", "Zollchow\ bei\ Rathenow",
"494602", "Freienwill",
"4939083", "Messdorf",
"492843", "Rheinberg",
"493865", "Holthusen",
"492655", "Weibern",
"496721", "Bingen\ am\ Rhein",
"494258", "Schwarme",
"4934903", "Coswig\ Anhalt",
"496402", "Hungen",
"496893", "Saarbrücken\-Ensheim",
"498548", "Vilshofen\-Sandbach",
"496195", "Kelkheim\ Taunus",
"497222", "Rastatt",
"4934494", "Ehrenhain",
"492683", "Asbach\ Westerwald",
"497568", "Bad\ Wurzach\-Hauerz",
"492573", "Nordwalde",
"498179", "Eurasburg\ an\ der\ Loisach",
"49781", "Offenburg",
"494343", "Laboe",
"494121", "Elmshorn",
"494795", "Garlstedt",
"494296", "Schwanewede\-Aschwarden",
"494847", "Oster\-Ohrstedt",
"492963", "Brilon\-Messinghausen",
"496362", "Alsenz",
"494289", "Kirchtimke",
"492471", "Roetgen\ Eifel",
"4936207", "Plaue\ Thüringen",
"498281", "Thannhausen\ Schwaben",
"497566", "Argenbühl",
"498546", "Windorf\-Otterskirchen",
"494952", "Rhauderfehn",
"494256", "Hilgermissen",
"492421", "Düren",
"493382", "Lehnin",
"494755", "Ihlienworth",
"494527", "Bosau",
"495036", "Neustadt\-Schneeren",
"492905", "Bestwig\-Ramsbeck",
"4933846", "Dippmannsdorf",
"494171", "Winsen\ Luhe",
"4934422", "Osterfeld",
"497427", "Schömberg\ bei\ Balingen",
"498772", "Mallersdorf\-Pfaffenberg",
"495351", "Helmstedt",
"499391", "Marktheidenfeld",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"495837", "Sprakensehl",
"4934955", "Gossa",
"496234", "Mutterstadt",
"496207", "Wald\-Michelbach",
"494409", "Westerstede\-Ocholt",
"4938824", "Mallentin",
"496666", "Freiensteinau",
"499727", "Schonungen\-Marktsteinach",
"493968", "Schönbeck",
"494466", "Wittmund\-Ardorf",
"495072", "Neustadt\-Mandelsloh",
"499555", "Schlüsselfeld\-Aschbach",
"495623", "Edertal",
"495333", "Dettum",
"499673", "Tiefenbach\ Oberpfalz",
"499164", "Langenfeld\ Mittelfranken",
"4936424", "Kahla\ Thüringen",
"4938208", "Kavelstorf",
"495777", "Diepenau\-Essern",
"499777", "Ostheim\ von\ der\ Rhön",
"4933673", "Weichensdorf",
"493686", "Eisfeld",
"4935389", "Holzdorf\ Elster",
"495583", "Braunlage\-Hohegeiss",
"494308", "Schwedeneck",
"495022", "Wietzen",
"493576", "Weisswasser",
"495164", "Hodenhagen",
"495673", "Immenhausen\ Hessen",
"495555", "Moringen\-Fredelsloh",
"499333", "Sommerhausen",
"499072", "Lauingen\ Donau",
"498722", "Gangkofen",
"497477", "Jungingen\ bei\ Hechingen",
"4934296", "Groitzsch\ bei\ Pegau",
"4934327", "Waldheim\ Sachsen",
"492166", "Mönchengladbach\-Rheydt",
"499837", "Haundorf",
"499804", "Aurach",
"499351", "Gemünden\ am\ Main",
"498027", "Dietramszell",
"498194", "Vilgertshofen",
"495481", "Lengerich\ Westfalen",
"493528", "Radeberg",
"493966", "Cölpin",
"4934343", "Regis\-Breitingen",
"494468", "Friedeburg\-Reepsholt",
"496668", "Birstein\-Lichenroth",
"498503", "Neuhaus\ am\ Inn",
"4933654", "Fünfeichen",
"493909", "Klötze\ Altmark",
"4939425", "Dingelstedt\ am\ Huy",
"4933923", "Flecken\ Zechlin",
"495435", "Berge\ bei\ Quakenbrück",
"497825", "Kippenheim",
"498361", "Nesselwang",
"497123", "Metzingen\ Württemberg",
"49395", "Neubrandenburg",
"499435", "Schwarzenfeld",
"496282", "Walldürn",
"4939777", "Borkenfriede",
"497236", "Keltern",
"497664", "Freiburg\-Tiengen",
"497173", "Heubach",
"497932", "Niederstetten\ Württemberg",
"4939009", "Badel",
"498565", "Dietersburg\-Baumgarten",
"497735", "Öhningen",
"4933766", "Teupitz",
"493578", "Kamenz",
"4937298", "Oelsnitz\ Erzgebirge",
"497545", "Immenstaad\ am\ Bodensee",
"499481", "Pfatter",
"492378", "Fröndenberg\-Langschede",
"4939888", "Lychen",
"497363", "Lauchheim",
"495842", "Schnega",
"498121", "Markt\ Schwaben",
"494826", "Hohenlockstedt",
"496138", "Mommenheim",
"498343", "Aitrang",
"4938234", "Born\ Darss",
"494179", "Winsen\-Tönnhausen",
"498687", "Taching\-Tengling",
"495682", "Borken\ Hessen",
"495572", "Bodenfelde",
"492590", "Dülmen\-Buldern",
"492429", "Hürtgenwald",
"499268", "Teuschnitz",
"498847", "Obersöchering",
"499522", "Eltmann",
"499083", "Möttingen",
"4939382", "Kamern",
"498296", "Villenbach",
"4936374", "Weissensee",
"4933201", "Gross\ Glienicke",
"495083", "Hohne\ bei\ Celle",
"4936945", "Henneberg",
"49341", "Leipzig",
"497305", "Erbach\ Donau",
"495522", "Osterode\ am\ Harz",
"494546", "Mustin\ Lauenburg",
"4934361", "Dahlen\ Sachsen",
"495055", "Fassberg",
"494281", "Zeven",
"499572", "Burgkunstadt",
"4935434", "Altdöbern",
"4933701", "Grossbeeren",
"499682", "Erbendorf",
"494736", "Butjadingen\-Tossens",
"4939037", "Pretzier",
"494235", "Langwedel\-Etelsen",
"492638", "Waldbreitbach",
"498171", "Wolfratshausen",
"494876", "Reher\ Holstein",
"497134", "Weinsberg",
"498783", "Rohr\ in\ Niederbayern",
"495957", "Lindern\ Oldenburg",
"499842", "Uffenheim",
"494129", "Haseldorf",
"499607", "Luhe\-Wildenau",
"499634", "Wiesau",
"499324", "Dettelbach",
"4939362", "Grieben\ bei\ Tangerhütte",
"4937606", "Lengenfeld\ Vogtland",
"499962", "Schwarzach\ Niederbayern",
"499266", "Mitwitz",
"498445", "Gerolsbach",
"495703", "Hille",
"497465", "Emmingen\-Liptingen",
"495374", "Isenbüttel",
"497852", "Willstätt",
"4939998", "Loitz\ bei\ Demmin",
"496136", "Nieder\-Olm",
"499765", "Trappstadt",
"497182", "Welzheim",
"494828", "Lägerdorf",
"499209", "Emtmannsberg",
"495209", "Gütersloh\-Friedrichsdorf",
"496223", "Neckargemünd",
"4935891", "Rothenburg\ OL",
"495765", "Raddestorf",
"497403", "Dunningen",
"4938457", "Krakow\ am\ See",
"492264", "Marienheide",
"497947", "Forchtenberg",
"492636", "Burgbrohl",
"499374", "Eschau",
"498065", "Tuntenhausen\-Schönau",
"495266", "Lemgo\-Kirchheide",
"49491", "Leer\ Ostfriesland",
"4934381", "Colditz",
"495962", "Herzlake",
"497045", "Oberderdingen",
"498258", "Sielenbach",
"495607", "Fuldatal",
"495634", "Waldeck\-Sachsenhausen",
"495324", "Vienenburg",
"495185", "Duingen",
"497447", "Baiersbronn\-Schwarzenberg",
"496020", "Heigenbrücken",
"495883", "Lemgow",
"497903", "Mainhardt",
"493876", "Perleberg",
"495855", "Nahrendorf",
"49661", "Fulda",
"499193", "Höchstadt\ an\ der\ Aisch",
"495153", "Salzhemmendorf",
"498382", "Lindau\ Bodensee",
"498467", "Kinding",
"495462", "Ankum",
"499747", "Geroda\ Bayern",
"493546", "Lübben\ Spreewald",
"4933202", "Töplitz",
"495643", "Borgentreich",
"49441", "Oldenburg",
"495131", "Garbsen",
"499504", "Stadelhofen",
"497965", "Ellwangen\-Röhlingen",
"4933702", "Wünsdorf",
"495042", "Bad\ Münder\ am\ Deister",
"499131", "Erlangen",
"495504", "Friedland\ Kreis\ Göttingen",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"4934362", "Mügeln\ bei\ Oschatz",
"499462", "Falkenstein\ Oberpfalz",
"498742", "Velden\ Vils",
"4934496", "Nöbdenitz",
"4933637", "Beerfelde",
"4935053", "Glashütte\ Sachsen",
"49211", "Düsseldorf",
"496261", "Mosbach\ Baden",
"492506", "Münster\-Wolbeck",
"499153", "Schnaittach",
"495193", "Schneverdingen",
"499855", "Dentlein\ am\ Forst",
"498532", "Griesbach\ im\ Rottal",
"4935208", "Radeburg",
"499185", "Mühlhausen\ Oberpfalz",
"497762", "Wehr\ Baden",
"499302", "Rottendorf\ Unterfranken",
"497653", "Lenzkirch",
"49391", "Magdeburg",
"497685", "Gutach\-Bleibach",
"4939361", "Lüderitz",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"498452", "Geisenfeld",
"497575", "Messkirch",
"496039", "Karben",
"497631", "Müllheim\ Baden",
"497321", "Heidenheim\ an\ der\ Brenz",
"495457", "Hopsten\-Schale",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"498584", "Breitenberg\ Niederbayern",
"4939225", "Altengrabow",
"497143", "Besigheim",
"497371", "Riedlingen\ Württemberg",
"498334", "Bad\ Grönenbach",
"498624", "Obing",
"4939608", "Staven",
"492508", "Drensteinfurt",
"4938355", "Züssow",
"4935892", "Horka\ OL",
"497052", "Bad\ Liebenzell",
"4933844", "Brück\ Brandenburg",
"4934382", "Nerchau",
"498105", "Gilching",
"498803", "Peissenberg",
"4937755", "Schönheide\ Erzgebirge",
"4935975", "Hohnstein",
"495302", "Vechelde",
"497525", "Aulendorf",
"499280", "Selbitz\ Oberfranken",
"494297", "Ottersberg\-Posthausen",
"497432", "Albstadt\-Tailfingen",
"498141", "Fürstenfeldbruck",
"495822", "Ebstorf",
"4935696", "Briesnig",
"494846", "Hattstedt",
"492850", "Rees\-Haldern",
"499935", "Stephansposching",
"49345", "Halle\ Saale",
"498633", "Tüssling",
"498323", "Immenstadt\ im\ Allgäu",
"497161", "Göppingen",
"499872", "Heilsbronn",
"496486", "Katzenelnbogen",
"499732", "Hammelburg",
"496358", "Kriegsfeld",
"497394", "Schelklingen",
"492449", "Blankenheim\ Ahr",
"498651", "Bad\ Reichenhall",
"499542", "Schesslitz",
"4933474", "Neutrebbin",
"4939343", "Jerichow",
"493466", "Artern\ Unstrut",
"494968", "Neulehe",
"4936623", "Berga\ Elster",
"495542", "Witzenhausen",
"495037", "Bad\ Rehburg",
"494526", "Ascheberg\ Holstein",
"497354", "Erolzheim",
"494480", "Ovelgönne\-Strückhausen",
"496398", "Vorderweidenthal",
"495732", "Löhne",
"498704", "Altdorf\-Pfettrach",
"497567", "Leutkirch\-Friesenhofen",
"4934425", "Droyssig",
"495872", "Stoetze",
"49208", "Oberhausen\ Rheinland",
"495935", "Twist\-Schöninghsdorf",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"499822", "Bechhofen\ an\ der\ Heide",
"498373", "Altusried",
"498547", "Osterhofen\-Gergweis",
"494149", "Fredenbeck",
"494257", "Schweringen",
"499344", "Gerchsheim",
"49921", "Bayreuth",
"495661", "Melsungen",
"492253", "Bad\ Münstereifel",
"4939000", "Beetzendorf",
"496356", "Carlsberg\ Pfalz",
"493306", "Gransee",
"4939823", "Rechlin",
"4939054", "Flechtingen",
"498084", "Taufkirchen\ Vils",
"4938757", "Neustadt\-Glewe",
"4936647", "Saalburg\ Thüringen",
"494848", "Rantrum",
"4939327", "Klietz",
"497977", "Oberrot\ bei\ Gaildorf",
"4939296", "Welsleben",
"496243", "Monsheim",
"492759", "Bad\ Berleburg\-Aue",
"4939955", "Jürgenstorf",
"497484", "Simmersfeld",
"4933609", "Brieskow\-Finkenheerd",
"497552", "Pfullendorf",
"496396", "Hinterweidenthal",
"494528", "Schönwalde\ am\ Bungsberg",
"492293", "Nümbrecht",
"494262", "Visselhövede",
"497025", "Neuffen",
"499661", "Sulzbach\-Rosenberg",
"49521", "Bielefeld",
"495344", "Lengede",
"494966", "Neubörger",
"496474", "Villmar\-Aumenau",
"4933932", "Fehrbellin",
"492921", "Soest",
"494452", "Zetel\-Neuenburg",
"496142", "Rüsselsheim",
"495838", "Gross\ Oesingen",
"4939267", "Schneidlingen",
"492043", "Gladbeck",
"497428", "Rosenfeld",
"4939422", "Badersleben",
"496093", "Laufach",
"4936376", "Straussfurt",
"496652", "Hünfeld",
"492405", "Würselen",
"4939831", "Feldberg",
"499120", "Leinburg",
"494865", "Osterhever",
"494674", "Ockholm",
"494163", "Horneburg\ Niederelbe",
"492192", "Hückeswagen",
"499728", "Wülfershausen\ Unterfranken",
"493967", "Oertzenhof\ bei\ Strasburg",
"496085", "Waldsolms",
"492152", "Kempen",
"497329", "Steinheim\ am\ Albuch",
"4935436", "Laasow\ bei\ Calau",
"496692", "Neustadt\ Hessen",
"4936258", "Friemar",
"4939951", "Faulenrost",
"4935938", "Grosspostwitz\ OL",
"496053", "Wächtersbach",
"499170", "Schwanstetten",
"494307", "Raisdorf",
"494624", "Kropp",
"494334", "Bredenbek\ bei\ Rendsburg",
"499778", "Fladungen",
"496424", "Ebsdorfergrund",
"492971", "Schmallenberg\-Dorlar",
"498028", "Fischbachau",
"4938736", "Goldberg",
"497237", "Neulingen\ Enzkreis",
"497204", "Malsch\-Völkersbach",
"496031", "Friedberg\ Hessen",
"494492", "Saterland",
"492463", "Titz",
"493445", "Naumburg\ Saale",
"492642", "Remagen",
"494803", "Pahlen",
"494105", "Seevetal",
"497478", "Hirrlingen",
"494467", "Wittmund\-Funnix",
"496269", "Gundelsheim\ Württemberg",
"494382", "Wangels",
"499726", "Euerbach",
"492834", "Straelen",
"4937604", "Mosel",
"495776", "Preussisch\ Ströhen",
"497426", "Gosheim",
"495275", "Höxter\-Ottbergen",
"495836", "Wittingen\-Radenbeck",
"492303", "Unna",
"49841", "Ingolstadt\ Donau",
"498076", "Pfaffing",
"492561", "Ahaus",
"496206", "Lampertheim",
"496667", "Steinau\-Ulmbach",
"499225", "Stadtsteinach",
"492774", "Dietzhölztal",
"497476", "Bisingen",
"495225", "Spenge",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"494945", "Grossefehn\-Timmel",
"496763", "Kirchberg\ Hunsrück",
"493847", "Sternberg",
"498026", "Hausham",
"4933093", "Fürstenberg\ Havel",
"499836", "Gunzenhausen\-Cronheim",
"497620", "Schopfheim\-Gersbach",
"499275", "Speichersdorf",
"492724", "Finnentrop\-Serkenrode",
"495139", "Burgwedel",
"499776", "Mellrichstadt",
"492365", "Marl",
"494532", "Bargteheide",
"495726", "Wiedensahl",
"494742", "Dorum",
"4938826", "Dassow",
"492733", "Hilchenbach",
"496104", "Heusenstamm",
"494425", "Wangerland\-Hooksiel",
"4939365", "Bellingen\ bei\ Stendal",
"496381", "Kusel",
"4938229", "Bad\ Sülze",
"492377", "Wickede\ Ruhr",
"492543", "Billerbeck\ Westfalen",
"4938293", "Kühlungsborn\ Ostseebad",
"4934636", "Schafstädt",
"499606", "Pfreimd",
"492751", "Bad\ Berleburg",
"4936426", "Ottendorf\ bei\ Stadtroda",
"496625", "Niederaula",
"499267", "Nordhalben",
"496335", "Trulben",
"496593", "Hillesheim\ Eifel",
"4936730", "Sitzendorf",
"4936928", "Neuenhof\ Thüringen",
"4939221", "Möckern\ bei\ Magdeburg",
"492175", "Leichlingen\ Rheinland",
"493644", "Apolda",
"492873", "Isselburg\-Werth",
"496585", "Ralingen",
"493361", "Fürstenwalde\ Spree",
"4938793", "Dergenthin",
"496864", "Mettlach",
"496675", "Breitenbach\ am\ Herzberg",
"4937329", "Grosshartmannsdorf",
"4938351", "Mesekenhagen",
"4939721", "Liepen\ bei\ Anklam",
"496553", "Schönecken",
"495606", "Zierenberg",
"492823", "Goch",
"496741", "St\ Goar",
"498262", "Mittelneufnach",
"496531", "Bernkastel\-Kues",
"4938370", "Kröslin",
"494475", "Molbergen",
"4935971", "Sebnitz",
"4934294", "Rackwitz",
"497242", "Rheinstetten",
"4938729", "Marnitz",
"492327", "Bochum\-Wattenscheid",
"492637", "Weissenthurm",
"492604", "Nassau\ Lahn",
"497946", "Bretzfeld",
"494323", "Bornhöved",
"494633", "Satrup",
"499360", "Thüngen",
"492994", "Marsberg\-Westheim",
"498846", "Uffing\ am\ Staffelsee",
"496451", "Frankenberg\ Eder",
"494141", "Stade",
"493722", "Limbach\-Oberfrohna",
"4934722", "Preusslitz",
"499608", "Kohlberg\ Oberpfalz",
"495292", "Lichtenau\-Atteln",
"499252", "Helmbrechts",
"494827", "Wacken",
"499956", "Eichendorf\-Aufhausen",
"493925", "Stassfurt",
"496433", "Hadamar",
"498686", "Petting",
"4933656", "Bahro",
"4938303", "Sellin\ Ostseebad",
"49751", "Ravensburg",
"497948", "Öhringen\-Ohrnberg",
"494877", "Hennstedt\ bei\ Itzehoe",
"4934467", "Eckartsberga",
"495956", "Rastdorf",
"499292", "Konradsreuth",
"495252", "Bad\ Lippspringe",
"492441", "Kall",
"495608", "Söhrewald",
"498257", "Inchenhofen",
"494547", "Gudow\ Lauenburg",
"4937203", "Gersdorf\ bei\ Chemnitz",
"492954", "Rüthen\-Oestereiden",
"493772", "Schneeberg\ Erzgebirge",
"494737", "Stadland\-Schwei",
"494704", "Drangstedt",
"4934222", "Arzberg\ bei\ Torgau",
"4933764", "Mittenwalde\ Mark",
"496432", "Diez",
"4934607", "Wettin",
"497520", "Bodnegg",
"499285", "Kirchenlamitz",
"499253", "Weissenstadt",
"4939887", "Gerswalde",
"495293", "Paderborn\-Dahl",
"496161", "Brensbach",
"497486", "Horb\-Altheim",
"49221", "Cologne",
"498708", "Weihmichl\-Unterneuhausen",
"493723", "Hohenstein\-Ernstthal",
"497358", "Eberhardzell\-Füramoos",
"496394", "Bundenthal",
"4938305", "Gingst",
"499231", "Marktredwitz",
"494632", "Steinbergkirche",
"494322", "Bordesholm",
"493677", "Ilmenau\ Thüringen",
"4939383", "Sandau\ Elbe",
"495346", "Liebenburg",
"494964", "Rhede\ Ems",
"499346", "Grünsfeld",
"493773", "Johanngeorgenstadt",
"495231", "Detmold",
"493337", "Biesenthal\ Brandenburg",
"494372", "Westfehmarn",
"493304", "Velten",
"498860", "Bernbeuren",
"497570", "Sigmaringen\-Gutenstein",
"492661", "Bad\ Marienberg\ Westerwald",
"4934976", "Gröbzig",
"499293", "Berg\ Oberfranken",
"495253", "Bad\ Driburg",
"498086", "Buchbach\ Oberbayern",
"496567", "Oberkail",
"4939038", "Henningen",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"497459", "Nagold\-Hochdorf",
"4939363", "Angern",
"493464", "Sangerhausen",
"499180", "Pyrbaum",
"4936379", "Holzengel",
"492935", "Sundern\-Hachen",
"4935820", "Zodel",
"492872", "Rhede\ Westfalen",
"494524", "Scharbeutz\-Pönitz",
"4933876", "Buschow",
"497356", "Schemmerhofen",
"498205", "Dasing",
"496592", "Daun",
"498706", "Vilsheim",
"492542", "Gescher",
"4939997", "Jarmen",
"4938295", "Satow\ bei\ Bad\ Doberan",
"492981", "Winterberg\ Westfalen",
"495069", "Nordstemmen",
"492732", "Kreuztal",
"497243", "Ettlingen",
"4938458", "Zehna",
"494844", "Pellworm",
"498263", "Breitenbrunn\ Schwaben",
"496484", "Beselich",
"494761", "Bremervörde",
"494684", "Langeness\ Hallig",
"496552", "Olzheim",
"495850", "Neetze",
"4935439", "Zinnitz",
"492822", "Emmerich",
"497389", "Heroldstatt",
"499348", "Werbach\-Gamburg",
"494249", "Bassum\-Nordwohlde",
"498336", "Erkheim",
"496447", "Langgöns\-Niederkleen",
"49761", "Freiburg\ im\ Breisgau",
"492302", "Witten",
"493931", "Stendal",
"494355", "Rieseby",
"4938207", "Stäbelow",
"495508", "Gleichen\-Rittmarshausen",
"494383", "Grebin",
"4933672", "Pfaffendorfb\ Beeskow",
"4935364", "Lebusa",
"494743", "Langen\ bei\ Bremerhaven",
"4939004", "Köckte\ bei\ Gardelegen",
"4936621", "Elsterberg\ bei\ Plauen",
"4939341", "Redekin",
"4937464", "Schöneck\ Vogtland",
"494533", "Reinfeld\ Holstein",
"493342", "Neuenhagen\ bei\ Berlin",
"497261", "Sinsheim",
"498586", "Hauzenberg",
"499929", "Ruhmannsfelden",
"498241", "Buchloe",
"4939050", "Bartensleben",
"494551", "Bad\ Segeberg",
"4934328", "Hartha\ bei\ Döbeln",
"496762", "Kastellaun",
"49511", "Hannover",
"4934639", "Wallendorf\ Luppe",
"496653", "Burghaun",
"493603", "Bad\ Langensalza",
"4939821", "Carpin",
"494162", "Jork",
"492193", "Dabringhausen",
"495506", "Adelebsen",
"496092", "Heimbuchenthal",
"4934342", "Neukieritzsch",
"496575", "Landscheid",
"494431", "Wildeshausen",
"496631", "Alsfeld",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"492504", "Telgte",
"494485", "Elsfleth\-Huntorf",
"4933922", "Karwesee",
"494453", "Zetel",
"492747", "Molzhain",
"4938226", "Dierhagen\ Ostseebad",
"498628", "Kienberg\ Oberbayern",
"498338", "Böhen",
"492387", "Drensteinfurt\-Walstedde",
"499569", "Sesslach",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"494493", "Friesoythe\-Gehlenberg",
"492462", "Linnich",
"4933451", "Heckelberg",
"496371", "Landstuhl",
"494802", "Wrohm",
"493874", "Ludwigslust",
"492643", "Altenahr",
"492131", "Neuss",
"498678", "Marktl",
"4938726", "Spornitz",
"4937297", "Thum\ Sachsen",
"4933470", "Lietzen",
"496052", "Bad\ Orb",
"493544", "Luckau\ Brandenburg",
"4937326", "Frauenstein\ Sachsen",
"492153", "Nettetal\-Lobberich",
"496757", "Becherbach\ bei\ Kirn",
"4935384", "Steinsdorf\ bei\ Jessen",
"492855", "Voerde\ Niederrhein",
"49911", "Nuremberg",
"496693", "Neuental",
"496525", "Irrel",
"492608", "Welschneudorf",
"4935792", "Ossling",
"494205", "Ottersberg",
"494769", "Bremervörde\-Iselersheim",
"4939825", "Wokuhl",
"4936962", "Vacha",
"495954", "Lorup",
"492360", "Haltern\-Lippramsdorf",
"4934691", "Könnern",
"497381", "Münsingen",
"499270", "Creussen",
"4939833", "Mirow\ Kreis\ Neustrelitz",
"497335", "Wiesensteig",
"497625", "Zell\ im\ Wiesental",
"496868", "Mettlach\-Tünsdorf",
"495441", "Diepholz",
"494706", "Schiffdorf",
"492252", "Zülpich",
"4933744", "Hohenseefeld",
"499220", "Kasendorf\-Azendorf",
"4939953", "Schwinkendorf",
"499441", "Kelheim",
"497585", "Ostrach",
"494263", "Scheessel",
"492292", "Windeck\ Sieg",
"4937600", "Neumark\ Sachsen",
"497675", "Bernau\ Baden",
"497553", "Salem\ Baden",
"4936074", "Worbis",
"4939082", "Mieste",
"497741", "Tiengen\ Hochrhein",
"499954", "Simbach\ Niederbayern",
"498574", "Wittibreut",
"496242", "Osthofen",
"497531", "Konstanz",
"496108", "Mühlheim\ am\ Main",
"498684", "Fridolfing",
"498761", "Moosburg\ an\ der\ Isar",
"494708", "Ringstedt",
"499377", "Freudenberg\-Boxtal",
"499543", "Hirschaid",
"4935724", "Lohsa",
"496866", "Perl\-Nennig",
"492958", "Büren\-Harth",
"497451", "Horb\ am\ Neckar",
"499733", "Münnerstadt",
"498091", "Kirchseeon",
"495327", "Bad\ Grund\ Harz",
"495604", "Grossalmerode",
"499175", "Spalt",
"498322", "Oberstdorf",
"499873", "Abenberg\-Wassermungenau",
"4936208", "Ermstedt",
"4938424", "Bobitz",
"492267", "Wipperfürth",
"497433", "Balingen",
"496809", "Grossrosseln",
"495823", "Bienenbüttel",
"492606", "Winningen\ Mosel",
"497944", "Kupferzell",
"49651", "Trier",
"498033", "Oberaudorf",
"499823", "Leutershausen",
"498372", "Obergünzburg",
"495751", "Rinteln",
"496106", "Rodgau",
"4939345", "Parchen",
"493886", "Gadebusch",
"4936625", "Langenwetzendorf",
"495873", "Eimke",
"495175", "Lehrte\-Arpke",
"498051", "Prien\ am\ Chiemsee",
"499637", "Falkenberg\ Oberpfalz",
"499604", "Wernberg\-Köblitz",
"4939062", "Bebertal",
"495733", "Vlotho",
"495377", "Ehra\-Lessien",
"495543", "Staufenberg\ Niedersachsen",
"4934423", "Heuckewalde",
"498431", "Neuburg\ an\ der\ Donau",
"497474", "Haigerloch",
"495365", "Wolfsburg\-Neindorf",
"497142", "Bietigheim\-Bissingen",
"498024", "Holzkirchen",
"499834", "Theilenhofen",
"496428", "Stadtallendorf",
"4939223", "Theessen",
"494338", "Alt\ Duvenstedt",
"492225", "Meckenheim\ Rheinland",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"499774", "Oberelsbach",
"498453", "Reichertshofen\ Oberbayern",
"4933977", "Gumtow",
"495167", "Walsrode\-Westenholz",
"499561", "Coburg",
"499303", "Eibelstadt",
"497652", "Hinterzarten",
"495724", "Obernkirchen",
"492275", "Kerpen\-Buir",
"4939723", "Krien",
"4933606", "Müllrose",
"497085", "Enzklösterle",
"499724", "Stadtlauringen",
"4938353", "Gützkow\ bei\ Greifswald",
"495303", "Wendeburg",
"496639", "Ottrau",
"496329", "Weidenthal\ Pfalz",
"492836", "Wachtendonk",
"497053", "Bad\ Teinach\-Zavelstein",
"499167", "Oberscheinfeld",
"4938791", "Bad\ Wilsnack",
"495561", "Einbeck",
"498802", "Huglfing",
"495774", "Wagenfeld\-Ströhen",
"4935973", "Stolpen",
"497424", "Spaichingen",
"495834", "Wittingen\-Knesebeck",
"495807", "Altenmedingen",
"498074", "Schnaitsee",
"499365", "Rimpar",
"496204", "Viernheim",
"496237", "Maxdorf",
"497031", "Böblingen",
"496478", "Greifenstein\-Ulm",
"492776", "Bad\ Endbach\-Hartenrod",
"497269", "Sulzfeld\ Baden",
"495971", "Rheine",
"4933334", "Greiffenberg",
"497705", "Wolterdingen\ Schwarzw",
"4935954", "Grossharthau",
"494559", "Wensin",
"494626", "Treia",
"498157", "Feldafing",
"494336", "Owschlag",
"498591", "Obernzell",
"499921", "Regen",
"495642", "Warburg\-Scherfede",
"498249", "Ettringen\ Wertach",
"496426", "Fronhausen",
"499192", "Gräfenberg",
"495152", "Hessisch\ Oldendorf",
"498383", "Grünenbach\ Allgäu",
"4938301", "Putbus",
"4938374", "Lassan\ bei\ Wolgast",
"499405", "Bad\ Abbach",
"496670", "Ludwigsau\ Hessen",
"495882", "Gorleben",
"4939747", "Züsedom",
"4939488", "Güntersberge",
"496580", "Zemmer",
"497667", "Breisach\ am\ Rhein",
"498533", "Rotthalmünster",
"498395", "Tannheim\ Württemberg",
"496476", "Mengerskirchen",
"492778", "Siegbach",
"497763", "Murg",
"498743", "Geisenhausen",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"496620", "Philippsthal\ Werra",
"49202", "Wuppertal",
"4939247", "Güterglück",
"499152", "Hartenstein\ Mittelfranken",
"495192", "Munster",
"499642", "Kemnath\ Stadt",
"495921", "Nordhorn",
"498551", "Freyung",
"4936734", "Leutenberg",
"494241", "Bassum",
"499463", "Wald\ Oberpfalz",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"492838", "Sonsbeck",
"495043", "Lauenau",
"499971", "Cham",
"498707", "Adlkofen",
"498734", "Reisbach\ Niederbayern",
"497183", "Rudersberg\ Württemberg",
"497771", "Stockach",
"495905", "Beesten",
"497564", "Bad\ Wurzach",
"498544", "Eging\ am\ See",
"497853", "Kehl\-Bodersweier",
"496272", "Hirschhorn\ Neckar",
"494254", "Eystrup",
"4936927", "Unterellen",
"499471", "Burglengenfeld",
"4938292", "Kröpelin",
"495034", "Neustadt\-Hagen",
"497645", "Freiamt",
"493588", "Niesky",
"494920", "Wirdum",
"498665", "Inzell",
"497357", "Attenweiler",
"499963", "Konzell",
"497831", "Hausach",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"495702", "Petershagen\-Lahde",
"4938792", "Lenzen\ \(Elbe\)",
"4939006", "Miesterhorst",
"493628", "Arnstadt",
"499421", "Straubing",
"493338", "Bernau\ Brandenburg",
"495963", "Bawinkel",
"4933769", "Töpchin",
"498824", "Oberau\ Loisach",
"495471", "Bohmte",
"497402", "Fluorn\-Winzeln",
"494294", "Riede\ Kreis\ Verden",
"497721", "Villingen\ im\ Schwarzwald",
"497195", "Winnenden",
"496222", "Wiesloch",
"496568", "Wolsfeld",
"499905", "Bernried\ Niederbayern",
"49681", "Saarbrücken",
"499523", "Hofheim\ in\ Unterfranken",
"495655", "Wanfried",
"499082", "Oettingen\ in\ Bayern",
"495683", "Wabern\ Hessen",
"497250", "Kraichtal",
"493586", "Neugersdorf\ Sachsen",
"495347", "Burgdorf\ bei\ Salzgitter",
"495573", "Uslar\-Volpriehausen",
"498342", "Marktoberdorf",
"494939", "Baltrum",
"4938224", "Gresenhorst",
"497362", "Bopfingen",
"495843", "Wustrow\ Wendland",
"4938302", "Sagard",
"495145", "Beedenbostel",
"499145", "Solnhofen",
"4934299", "Gaschwitz",
"499843", "Burgbernheim",
"496566", "Körperich",
"4938724", "Siggelkow",
"4936943", "Bettenhausen\ Thüringen",
"497974", "Bühlerzell",
"498782", "Pfeffenhausen",
"499573", "Staffelstein\ Oberfranken",
"499347", "Wittighausen",
"4935386", "Prettin",
"4937202", "Claussnitz\ bei\ Chemnitz",
"499683", "Friedenfels",
"495082", "Langlingen",
"4937324", "Reinsberg\ Sachsen",
"4934223", "Dommitzsch",
"499655", "Tännesberg",
"496509", "Büdlich",
"495695", "Twistetal",
"495523", "Bad\ Sachsa",
"4936961", "Bad\ Liebenstein",
"4939268", "Egeln",
"492359", "Kierspe",
"4933933", "Lindow\ Mark",
"498230", "Gablingen",
"4934345", "Bad\ Lausick",
"4934692", "Alsleben\ Saale",
"497122", "St\ Johann\ Württemberg",
"492536", "Münster\-Albachten",
"495861", "Dannenberg\ Elbe",
"496295", "Rosenberg\ Baden",
"498502", "Fürstenzell",
"494158", "Roseburg",
"492245", "Much",
"4939423", "Wegeleben",
"4933925", "Wustrau\-Altfriesack",
"4937609", "Wolkenburg\ Mulde",
"495507", "Ebergötzen",
"495534", "Eschershausen\ an\ der\ Lenne",
"499101", "Langenzenn",
"496789", "Heimbach\ Nahe",
"495744", "Hüllhorst",
"499384", "Schwanfeld",
"495384", "Seesen\-Gross\ Rhüden",
"499744", "Zeitlofs\-Detter",
"4935937", "Prischwitz",
"4936257", "Luisenthal\ Thüringen",
"497951", "Crailsheim",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"496349", "Billigheim\-Ingenheim",
"499534", "Burgpreppach",
"496756", "Winterbach\ Soonwald",
"495101", "Pattensen",
"497444", "Alpirsbach",
"496255", "Lindenfels",
"497172", "Lorch\ Württemberg",
"499861", "Rothenburg\ ob\ der\ Tauber",
"497933", "Creglingen",
"496068", "Beerfelden",
"4934901", "Rosslau\ Elbe",
"498464", "Dietfurt\ an\ der\ Altmühl",
"496283", "Hardheim\ Odenwald",
"499672", "Neunburg\ vorm\ Wald",
"498135", "Sulzemoos",
"4933874", "Stechow\ Brandenburg",
"494271", "Sulingen",
"497754", "Görwihl",
"496190", "Hattersheim\ am\ Main",
"495073", "Neustadt\-Esperke",
"494646", "Mohrkirch",
"499941", "Kötzting",
"495622", "Fritzlar",
"4934953", "Gräfenhainichen",
"495332", "Schöppenstedt",
"498337", "Altenstadt\ Iller",
"496446", "Hohenahr",
"498304", "Wildpoldsried",
"494156", "Talkau",
"498851", "Kochel\ am\ See",
"493860", "Raben\ Steinfeld",
"498773", "Neufahrn\ in\ Niederbayern",
"495494", "Holdorf\ Niedersachsen",
"499454", "Aufhausen\ Oberpfalz",
"492538", "Drensteinfurt\-Rinkerode",
"498677", "Burghausen\ Salzach",
"494189", "Undeloh",
"496066", "Michelstadt\-Vielbrunn",
"495454", "Hörstel\-Riesenbeck",
"498723", "Arnstorf",
"4933675", "Tauche",
"494859", "Windbergen",
"492388", "Hamm\-Uentrop",
"499622", "Hirschau\ Oberpfalz",
"499332", "Marktbreit",
"495941", "Neuenhaus\ Dinkel",
"499073", "Gundelfingen\ an\ der\ Donau",
"492456", "Selfkant",
"496150", "Weiterstadt",
"494221", "Delmenhorst",
"496758", "Waldböckelheim",
"4939061", "Weferlingen",
"495582", "Sankt\ Andreasberg",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"495672", "Bad\ Karlshafen",
"496363", "Niederkirchen",
"497138", "Schwaigern",
"496501", "Konz",
"492266", "Lindlar",
"4939059", "Wegenstedt",
"492634", "Rengsdorf",
"492324", "Hattingen\ Ruhr",
"492607", "Kobern\-Gondorf",
"492962", "Olsberg",
"499376", "Collenberg",
"496867", "Perl",
"495264", "Kalletal",
"493395", "Pritzwalk",
"494342", "Preetz\ Kreis\ Plön",
"493533", "Elsterwerda",
"495326", "Langelsheim",
"495636", "Lichtenfels\-Goddelsheim",
"4939342", "Gladau",
"499636", "Plössberg",
"499326", "Markt\ Einersheim",
"4936084", "Heuthen",
"4936622", "Triebes",
"494931", "Norden",
"499264", "Küps",
"496305", "Hochspeyer",
"4933604", "Lebus",
"4933671", "Lieberose",
"493647", "Pössneck",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"494953", "Bunde",
"493591", "Bautzen",
"496107", "Kelsterbach",
"496134", "Mainz\-Kastel",
"492374", "Iserlohn\-Letmathe",
"498254", "Altomünster",
"495328", "Altenau\ Harz",
"4936965", "Stadtlengsfeld",
"497729", "Tennenbronn",
"4933479", "Küstrin\-Kietz",
"494544", "Berkenthin",
"4934341", "Geithain",
"4935795", "Königsbrück",
"492957", "Wünnenberg\-Haaren",
"496465", "Breidenbach\ bei\ Biedenkopf",
"499378", "Eichenbühl\-Riedern",
"4933336", "Passow\ Kreis\ Uckermark",
"494734", "Stadland\-Seefeld",
"4939822", "Kratzeburg",
"494707", "Langen\-Neuenwalde",
"4939328", "Rochau",
"493493", "Bitterfeld",
"4933921", "Zechlinerhütte",
"496852", "Nohfelden",
"4936648", "Dittersdorf\ bei\ Schleiz",
"497273", "Hagenbach\ Pfalz",
"4938758", "Dömitz",
"499429", "Rain\ Niederbayern",
"497136", "Bad\ Friedrichshall",
"494874", "Todenbüttel",
"494665", "Emmelsbüll\-Horsbüll",
"492522", "Oelde",
"492268", "Kürten",
"496182", "Seligenstadt",
"4938376", "Zirchow",
"497223", "Bühl\ Baden",
"492682", "Hamm\ Sieg",
"4936694", "Schkölen\ Thüringen",
"4939085", "Zichtau",
"494824", "Krempe",
"492572", "Emsdetten",
"4933452", "Neulewin",
"495429", "Melle\-Wellingholzhausen",
"496403", "Linden\ Hessen",
"497839", "Schapbach",
"495378", "Sassenburg\-Platendorf",
"494603", "Havetoft",
"492842", "Kamp\-Lintfort",
"4934905", "Wörlitz",
"4936736", "Arnsgereuth",
"499638", "Neualbenreuth",
"498294", "Horgau",
"493431", "Döbeln",
"496045", "Gedern",
"496427", "Cölbe\-Schönstadt",
"498271", "Meitingen",
"497234", "Tiefenbronn",
"497666", "Denzlingen",
"494135", "Kirchgellersen",
"494833", "Wesselburen",
"4933203", "Kleinmachnow",
"494181", "Buchholz\ in\ der\ Nordheide",
"4933746", "Werbig\ bei\ Jüterbog",
"494773", "Lamstedt",
"495168", "Walsrode\-Stellichte",
"494851", "Marne",
"494337", "Jevenstedt",
"494627", "Dörpstedt",
"493372", "Jüterbog",
"498196", "Pürgen",
"4936076", "Niederorschel",
"4933703", "Sperenberg",
"494723", "Cuxhaven\-Altenwalde",
"4933849", "Wiesenburg\ Mark",
"492435", "Erkelenz\-Lövenich",
"493964", "Bredenfelde\ bei\ Strasburg",
"4934363", "Cavertitz",
"493632", "Sondershausen",
"493322", "Falkensee",
"4935052", "Kipsdorf\ Kurort",
"496477", "Greifenstein\-Nenderoth",
"496238", "Dirmstein",
"4935207", "Moritzburg",
"498221", "Günzburg",
"4933638", "Rüdersdorf\ bei\ Berlin",
"495808", "Gerdau",
"4933967", "Freyenstein",
"499869", "Wettringen\ Mittelfranken",
"493761", "Werdau\ Sachsen",
"498158", "Tutzing",
"494502", "Lübeck\-Travemünde",
"493574", "Lauchhammer",
"495166", "Walsrode\-Kirchboitzen",
"492391", "Plettenberg",
"494230", "Verden\-Walle",
"4935726", "Gross\ Särchen",
"492583", "Sassenberg",
"497668", "Ihringen",
"497959", "Frankenhardt",
"496341", "Landau\ in\ der\ Pfalz",
"499090", "Rain\ Lech",
"493844", "Schwaan",
"492673", "Ellenz\-Poltersdorf",
"492164", "Jüchen\-Otzenrath",
"497300", "Roggenburg",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"492555", "Schöppingen",
"496123", "Eltville\ am\ Rhein",
"4939976", "Gross\ Bützin",
"495109", "Ronnenberg",
"496825", "Illingen\ Saar",
"4938426", "Neuburg\-Steinhausen",
"492595", "Olfen",
"492623", "Ransbach\-Baumbach",
"492333", "Ennepetal",
"495806", "Barum\ bei\ Bad\ Bevensen",
"496236", "Neuhofen\ Pfalz",
"496173", "Kronberg\ im\ Taunus",
"492777", "Breitscheid\ Hessen",
"4939607", "Kotelow",
"4935893", "Mücka",
"496664", "Sinntal\-Sterbfritz",
"496875", "Nonnweiler\-Primstal",
"496781", "Idar\-Oberstein",
"4934383", "Trebsen\ Mulde",
"494464", "Wittmund\-Carolinensiel",
"4935829", "Gersdorf\ bei\ Görlitz",
"4936370", "Grossenehrich",
"492804", "Xanten\-Marienbaum",
"492837", "Weeze",
"496735", "Eppelsheim",
"4934658", "Hayn\ Harz",
"492351", "Lüdenscheid",
"499166", "Münchsteinach",
"496545", "Blankenrath",
"496353", "Freinsheim",
"493303", "Birkenwerder",
"498550", "Philippsreut",
"493561", "Guben",
"492952", "Rüthen",
"496385", "Reichenbach\-Steegen",
"4937430", "Eichigt",
"494240", "Syke\-Heiligenfelde",
"494702", "Sandstedt",
"4934242", "Hohenpriessnitz",
"493774", "Schwarzenberg",
"492256", "Mechernich\-Satzvey",
"494421", "Wilhelmshaven",
"496857", "Namborn",
"4933971", "Kyritz\ Brandenburg",
"492755", "Bad\ Berleburg\-Schwarzenau",
"496621", "Bad\ Hersfeld",
"496331", "Pirmasens",
"493834", "Greifswald",
"492527", "Lippetal\-Lippborg",
"4938297", "Moitin",
"496187", "Schöneck",
"4938484", "Ventschow",
"4936922", "Gerstungen",
"4939995", "Nossendorf",
"492171", "Leverkusen\-Opladen",
"498328", "Balderschwang",
"499294", "Regnitzlosau",
"498638", "Waldkraiburg",
"495254", "Paderborn\-Schloss\ Neuhaus",
"4938326", "Grimmen",
"495294", "Hövelhof\-Espeln",
"499254", "Gefrees",
"492687", "Horhausen\ Westerwald",
"4939859", "Fürstenwerder",
"4936451", "Buttelstedt",
"496581", "Saarburg",
"496246", "Eich\ Rheinhessen",
"4938797", "Karstädt\ Kreis\ Prignitz",
"498378", "Buchenberg\ bei\ Kempten",
"496897", "Sulzbach\ Saar",
"492296", "Reichshof\-Brüchermühle",
"499920", "Bischofsmais",
"4933830", "Ziesar",
"496745", "Gondershausen",
"492992", "Marsberg",
"494963", "Dörpen",
"4938851", "Zarrentin",
"4934742", "Sylda",
"493724", "Burgstädt",
"496535", "Osann\-Monzel",
"496393", "Fischbach\ bei\ Dahn",
"494471", "Cloppenburg",
"498636", "Ampfing",
"498326", "Fischen\ im\ Allgäu",
"4934605", "Gröbers",
"4938464", "Bernitt",
"495939", "Sustrum",
"496483", "Selters\ Taunus",
"49731", "Ulm\ Donau",
"4939885", "Jakobshagen",
"497244", "Weingarten\ Baden",
"496455", "Frankenau\ Hessen",
"494843", "Viöl",
"492602", "Montabaur",
"493921", "Burg\ bei\ Magdeburg",
"4938307", "Poseritz",
"4937349", "Scheibenberg",
"494683", "Oldsum",
"4939741", "Jatznick",
"492065", "Duisburg\-Rheinhausen",
"494347", "Flintbek",
"493971", "Anklam",
"4935264", "Strehla",
"492445", "Schleiden\ Eifel",
"4936948", "Römhild",
"4939241", "Leitzkau",
"4934463", "Bad\ Kösen",
"499560", "Grub\ am\ Forst",
"494523", "Malente",
"498376", "Sulzberg\ Allgäu",
"496102", "Neu\-Isenburg",
"4937207", "Hainichen\ Sachsen",
"4939263", "Unseburg",
"495648", "Brakel\-Gehrden",
"492925", "Warstein\-Allagen",
"494534", "Steinburg\ Kreis\ Storman",
"4934441", "Hohenmölsen",
"497656", "Schluchsee",
"497529", "Waldburg\ Württemberg",
"4933436", "Prötzel",
"494744", "Loxstedt",
"4939428", "Pabstorf",
"493994", "Malchin",
"497146", "Remseck\ am\ Neckar",
"498166", "Allershausen\ Oberbayern",
"494861", "Tönning",
"492401", "Baesweiler",
"4939926", "Grabowhöfe",
"492722", "Attendorn",
"495158", "Hemeringen",
"499198", "Heiligenstadt\ in\ Oberfranken",
"499158", "Offenhausen\ Mittelfranken",
"495198", "Schneverdingen\-Wintermoor",
"498869", "Kinsau",
"496081", "Usingen",
"4935932", "Guttau",
"4936252", "Tambach\-Dietharz",
"492772", "Herborn\ Hessen",
"494384", "Selent",
"4937295", "Lugau\ Erzgebirge",
"492975", "Schmallenberg\-Oberkirchen",
"492832", "Kevelaer",
"494101", "Pinneberg",
"498806", "Utting\ am\ Ammersee",
"493441", "Zeitz",
"499648", "Neustadt\ am\ Kulm",
"497579", "Schwenningen\ Baden",
"496035", "Reichelsheim\ Wetterau",
"496422", "Kirchhain",
"499196", "Wiesenttal",
"495156", "Coppenbrügge",
"496701", "Sprendlingen\ Rheinhessen",
"498168", "Attenkirchen",
"497202", "Karlsbad",
"494494", "Bösel\ Oldenburg",
"497148", "Grossbottwar",
"497906", "Braunsbach",
"492644", "Linz\ am\ Rhein",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"492154", "Willich",
"495060", "Bodenburg",
"493733", "Annaberg\-Buchholz",
"495271", "Höxter",
"4938205", "Tessin\ bei\ Rostock",
"496694", "Neukirchen\ Knüll",
"499221", "Kulmbach",
"494622", "Taarstedt",
"493377", "Zossen\ Brandenburg",
"494332", "Hamdorf\ bei\ Rendsburg",
"492565", "Gronau\-Epe",
"495646", "Willebadessen",
"4936840", "Trusetal",
"499646", "Freihung",
"494941", "Aurich",
"495221", "Herford",
"498808", "Pähl",
"4936026", "Struth\ bei\ Mühlhausen",
"496654", "Gersfeld\ Rhön",
"499271", "Thurnau\-Alladorf",
"4935240", "Tauscha\ bei\ Grossenhain",
"494672", "Langenhorn",
"493327", "Werder\ Havel",
"496472", "Weilmünster",
"492361", "Recklinghausen",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"494454", "Jade",
"495859", "Thomasburg",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"495196", "Wietzendorf",
"497554", "Heiligenberg\ Baden",
"498145", "Mammendorf",
"4939209", "Wanzleben",
"4936334", "Wolkramshausen",
"4933234", "Wustermark",
"499087", "Marktoffingen",
"494264", "Sottrum\ Kreis\ Rotenburg",
"494326", "Wankendorf",
"497165", "Göppingen\-Hohenstaufen",
"494636", "Langballig",
"4934773", "Schwittersdorf",
"499931", "Plattling",
"496436", "Dornburg\ Hessen",
"498573", "Ering",
"498347", "Friesenried",
"492738", "Netphen",
"4938201", "Gelbensande",
"498683", "Tittmoning",
"49291", "Meschede",
"492548", "Dülmen\-Rorup",
"499953", "Pilsting",
"497482", "Horb\-Dettingen",
"497367", "Aalen\-Ebnat",
"495953", "Börger",
"498082", "Schwindegg",
"496630", "Schwalmtal\-Storndorf",
"49203", "Duisburg",
"4939347", "Kade",
"497805", "Appenweier",
"499342", "Wertheim",
"495931", "Meppen",
"4935474", "Schönwalde\ bei\ Lübben",
"4933734", "Felgentreu",
"492828", "Emmerich\-Elten",
"496558", "Büdesheim\ Eifel",
"498421", "Eichstätt\ Bayern",
"4935453", "Drahnsdorf",
"498702", "Wörth\ an\ der\ Isar",
"4934445", "Stössen",
"4939827", "Schwarz\ bei\ Neustrelitz",
"495874", "Soltendieck",
"495665", "Guxhagen",
"494550", "Bühnsdorf",
"492546", "Coesfeld\-Lette",
"494479", "Molbergen\-Peheim",
"498034", "Brannenburg",
"499824", "Dietenhofen",
"497071", "Tübingen",
"497260", "Sinsheim\-Hilsbach",
"496438", "Hünfelden",
"4939399", "Kleinau",
"492736", "Burbach\ Siegerl",
"492235", "Erftstadt",
"494638", "Tarp",
"496589", "Kell\ am\ See",
"4939323", "Schönhausen\ Elbe",
"494328", "Rickling",
"4938753", "Wöbbelin",
"4936643", "Thimmendorf",
"495544", "Reinhardshagen",
"4938391", "Altenkirchen\ Rügen",
"4935609", "Drachhausen",
"497352", "Ochsenhausen",
"499603", "Floss",
"495734", "Bergkirchen\ Westfalen",
"495707", "Petershagen\ Weser",
"492129", "Haan\ Rheinland",
"496596", "Üdersdorf",
"499734", "Burkardroth",
"496556", "Pronsfeld",
"4933457", "Altreetz",
"4936606", "Kraftsdorf",
"497392", "Laupheim",
"496629", "Schenklengsfeld",
"495603", "Gudensberg",
"496339", "Grosssteinhausen",
"492826", "Kranenburg\ Niederrhein",
"499544", "Baunach",
"4933086", "Grieben\ Kreis\ Oberhavel",
"4937291", "Augustusburg",
"497434", "Winterlingen",
"495824", "Bad\ Bodenteich",
"497943", "Schöntal\ Jagst",
"497021", "Kirchheim\ unter\ Teck",
"499665", "Königstein\ Oberpfalz",
"499874", "Neuendettelsau",
"496227", "Walldorf\ Baden",
"4934601", "Teutschenthal",
"497054", "Wildberg\ Württemberg",
"499677", "Oberviechtach\-Pullenried",
"495773", "Stemwede\-Wehdem",
"492369", "Dorsten\-Wulfen",
"495181", "Alfeld\ Leine",
"4939881", "Ringenwalde\ bei\ Templin",
"494168", "Neu\ Wulmstorf\-Elstorf",
"499723", "Röthlein",
"495337", "Kissenbrück",
"495304", "Meine",
"495851", "Dahlenburg",
"498073", "Gars\ am\ Inn",
"496203", "Ladenburg",
"498622", "Tacherting\-Peterskirchen",
"498332", "Ottobeuren",
"4933208", "Fahrland",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"4939745", "Hetzdorf\ bei\ Strasburg",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"497423", "Oberndorf\ am\ Neckar",
"499279", "Mistelgau",
"495833", "Brome",
"495135", "Burgwedel\-Fuhrberg",
"492306", "Lünen",
"498023", "Bayrischzell",
"499135", "Hessdorf\ Mittelfranken",
"497961", "Ellwangen\ Jagst",
"499833", "Heidenheim\ Mittelfranken",
"4933708", "Rangsdorf",
"498582", "Röhrnbach",
"4939454", "Elbingerode\ Harz",
"4939245", "Loburg",
"497473", "Mössingen",
"499229", "Mainleus",
"496766", "Kisselbach",
"499851", "Dinkelsbühl",
"4989", "Munich",
"499627", "Freudenberg\ Oberpfalz",
"496265", "Billigheim\ Baden",
"499337", "Gaukönigshofen",
"4935324", "Crinitz",
"4939400", "Wefensleben",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"495723", "Bad\ Nenndorf",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"499773", "Unsleben",
"4933633", "Spreenhagen",
"4935057", "Hermsdorf\ Erzgebirge",
"498454", "Karlshuld",
"495677", "Calden\-Westuffeln",
"496058", "Gründau",
"4935202", "Klingenberg\ Sachsen",
"493346", "Seelow",
"498744", "Gerzen",
"492308", "Unna\-Hemmerde",
"497127", "Neckartenzlingen",
"498507", "Neuburg\ am\ Inn",
"498534", "Tettenweis",
"497571", "Sigmaringen",
"4933962", "Heiligengrabe",
"494109", "Tangstedt\ Bz\ Hamburg",
"497681", "Waldkirch\ Breisgau",
"497764", "Herrischried",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"498861", "Schongau",
"495044", "Springe\-Eldagsen",
"4939861", "Gramzow\ bei\ Prenzlau",
"497325", "Sontheim\ an\ der\ Brenz",
"497635", "Schliengen",
"494166", "Ahlerstedt",
"495502", "Dransfeld",
"4939991", "Daberkow",
"4933398", "Werneuchen",
"497841", "Achern",
"4935844", "Oybin\ Kurort",
"496096", "Wiesen\ Unterfranken",
"4936744", "Remda",
"499464", "Walderbach",
"495464", "Alfhausen",
"496056", "Bad\ Soden\-Salmünster",
"4937366", "Rübenau",
"4939602", "Kleeth",
"497375", "Obermarchtal",
"499502", "Frensdorf",
"492409", "Stolberg\-Gressenich",
"4938855", "Lübtheen",
"494806", "Sarzbüttel",
"4934653", "Rottleberode",
"4934924", "Zahna",
"498384", "Röthenbach\ Allgäu",
"498823", "Mittenwald",
"499372", "Klingenberg\ am\ Main",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"4939409", "Eilsleben",
"4939882", "Gollin",
"4935774", "Boxberg\ Sachsen",
"4933434", "Herzfelde\ bei\ Strausberg",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"494346", "Gettorf",
"495964", "Lähden",
"495632", "Willingen\ Upland",
"495322", "Bad\ Harzburg",
"498239", "Langenneufnach",
"497505", "Fronreute",
"498637", "Lohkirchen",
"498327", "Rettenberg",
"4939924", "Stuer",
"496188", "Kahl\ am\ Main",
"492528", "Ennigerloh\-Enniger",
"494293", "Ottersberg\-Fischerhude",
"492262", "Wiehl",
"4939388", "Goldbeck\ Altm",
"4933981", "Putlitz",
"496858", "Ottweiler\-Fürth",
"498543", "Aidenbach",
"496898", "Völklingen",
"498377", "Unterthingau",
"497854", "Kehl\-Goldscheuer",
"494253", "Asendorf\ Kreis\ Diepholz",
"493949", "Oschersleben\ Bode",
"498733", "Mengkofen",
"497184", "Kaisersbach",
"496340", "Wörth\-Schaidt",
"499091", "Monheim\ Schwaben",
"492688", "Kroppach",
"495051", "Bergen\ Kreis\ Celle",
"494285", "Rhade\ bei\ Zeven",
"497563", "Kisslegg",
"499632", "Waldsassen",
"499964", "Stallwang",
"4935201", "Langebrück",
"494231", "Verden\ Aller",
"4939033", "Wallstawe",
"498751", "Mainburg",
"495033", "Wunstorf\-Grossenheidorn",
"495372", "Meinersen",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"496856", "St\ Wendel\-Niederkirchen",
"492526", "Sendenhorst",
"497132", "Neckarsulm",
"497973", "Obersontheim",
"496186", "Grosskrotzenburg",
"499844", "Obernzenn",
"497461", "Tuttlingen",
"494348", "Schönkirchen",
"4939992", "Görmin",
"4936925", "Marksuhl",
"495524", "Bad\ Lauterberg\ im\ Harz",
"499574", "Marktzeuln",
"493869", "Dümmer",
"492257", "Reckerscheid",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"4939862", "Schmölln\ bei\ Prenzlau",
"492297", "Wildbergerhütte",
"495761", "Stolzenau",
"495684", "Frielendorf",
"4938453", "Mistorf",
"495574", "Oberweser",
"499524", "Zeil\ am\ Main",
"4939601", "Friedland",
"4936024", "Diedorf\ bei\ Mühlhausen",
"494180", "Königsmoor",
"4935753", "Grossräschen",
"492686", "Weyerbusch",
"498061", "Bad\ Aibling",
"4934745", "Winningen\ Sachsen\-Anhalt",
"495844", "Clenze",
"496159", "Messel",
"496247", "Worms\-Pfeddersheim",
"497041", "Mühlacker",
"499533", "Untermerzbach",
"499395", "Triefenstein",
"495355", "Frellstedt",
"494508", "Krummesse",
"495383", "Lutter\ am\ Barenberge",
"495647", "Lichtenau\-Kleinenberg",
"498152", "Herrsching\ am\ Ammersee",
"499197", "Egloffstein",
"495157", "Emmerthal\-Börry",
"499551", "Burgwindheim",
"498642", "Übersee",
"4938486", "Gustävel",
"498463", "Greding",
"494929", "Ihlow\ Kreis\ Aurich",
"4938324", "Velgast",
"496284", "Mudau",
"4939754", "Löcknitz\ Vorpom",
"497443", "Dornstetten",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"497934", "Weikersheim",
"4938202", "Volkenshagen",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"498043", "Jachenau",
"49671", "Bad\ Kreuznach",
"4933677", "Glienicke\ bei\ Beeskow",
"495197", "Soltau\-Frielingen",
"499157", "Alfeld\ Mittelfranken",
"497063", "Bad\ Wimpfen",
"495551", "Northeim",
"498192", "Schondorf\ am\ Ammersee",
"499647", "Kirchenthumbach",
"4939200", "Gommern",
"495743", "Espelkamp\-Gestringen",
"498405", "Stammham\ bei\ Ingolstadt",
"499383", "Wiesentheid",
"499355", "Frammersbach",
"495533", "Bodenwerder",
"493636", "Greussen",
"498724", "Massing",
"495485", "Ladbergen",
"497147", "Sachsenheim\ Württemberg",
"4934347", "Oelzschau\ bei\ Borna",
"497259", "Östringen\-Odenheim",
"499802", "Ansbach\-Katterbach",
"498167", "Zolling",
"495453", "Recke",
"499493", "Beratzhausen",
"4938466", "Jürgenshagen",
"4933927", "Linum",
"4938392", "Sassnitz",
"493378", "Ludwigsfelde",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"494506", "Stockelsdorf\-Krumbeck",
"495162", "Fallingbostel",
"4933369", "Oderberg",
"497345", "Langenau\ Württemberg",
"498365", "Wertach",
"497657", "Eisenbach\ Hochschwarzwald",
"497821", "Lahr\ Schwarzwald",
"499074", "Höchstädt\ an\ der\ Donau",
"495431", "Quakenbrück",
"497753", "Albbruck",
"4936255", "Goldbach\ bei\ Gotha",
"4935935", "Kleinwelka",
"4939773", "Altwarp",
"499431", "Schwandorf",
"493328", "Teltow",
"495074", "Rodewald",
"498807", "Diessen\ am\ Ammersee",
"499162", "Scheinfeld",
"4935600", "Döbern\ NL",
"4935266", "Heyda\ bei\ Riesa",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"496500", "Waldrach",
"499453", "Thalmassing",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"497731", "Singen\ Hohentwiel",
"498561", "Pfarrkirchen\ Niederbayern",
"495802", "Wrestedt",
"49241", "Aachen",
"498303", "Waltenhofen",
"496232", "Speyer",
"4939390", "Iden",
"497541", "Friedrichshafen",
"4938844", "Gülze",
"4937292", "Oederan",
"4934783", "Gerbstedt",
"4936967", "Geisa",
"496881", "Lebach",
"496775", "Strüth\ Taunus",
"492691", "Adenau",
"499088", "Mönchsdeggingen",
"4935797", "Schwepnitz",
"496597", "Jünkerath",
"499263", "Ludwigsstadt",
"496151", "Darmstadt",
"494441", "Vechta",
"495706", "Porta\ Westfalica",
"495205", "Bielefeld\-Sennestadt",
"496641", "Lauterbach\ Hessen",
"492373", "Menden\ Sauerland",
"492547", "Rosendahl\-Osterwick",
"495769", "Steyerberg\-Voigtei",
"494954", "Moormerland",
"496276", "Hesseneck",
"496133", "Oppenheim",
"492737", "Netphen\-Deuz",
"498348", "Bidingen",
"496835", "Beckingen",
"4935931", "Königswartha",
"4939087", "Jerchel\ Altmark",
"492633", "Brohl\-Lützing",
"492323", "Herne",
"493861", "Plate",
"496226", "Meckesheim",
"4938784", "Kleinow\ Kreis\ Prignitz",
"4939456", "Altenbrak",
"499205", "Vorbach",
"496364", "Nussbach\ Pfalz",
"495263", "Barntrup",
"496557", "Hallschlag",
"4937384", "Wechselburg",
"492827", "Goch\-Hassum",
"492651", "Mayen",
"496725", "Gau\-Algesheim",
"4934907", "Jeber\-Bergfrieden",
"493744", "Auerbach\ Vogtland",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"494239", "Dörverden\-Westen",
"498346", "Pforzen",
"496404", "Lich\ Hessen",
"494791", "Osterholz\-Scharmbeck",
"497224", "Gernsbach",
"497366", "Abtsgmünd",
"494125", "Seestermühe",
"494823", "Wilster",
"493941", "Halberstadt",
"497309", "Weissenhorn",
"499086", "Fremdingen",
"498293", "Welden\ bei\ Augsburg",
"4936203", "Vieselbach",
"499099", "Kaisheim",
"4935249", "Basslitz",
"497950", "Schnelldorf",
"494604", "Grossenwiehe",
"494637", "Sterup",
"494327", "Grossenaspe",
"493672", "Rudolstadt",
"498285", "Burtenbach",
"4936703", "Gräfenthal",
"494733", "Butjadingen\-Burhave",
"492425", "Nideggen\-Embken",
"4936849", "Kleinschmalkalden",
"4935020", "Struppen",
"495086", "Celle\-Scheuen",
"498253", "Pöttmes",
"4937364", "Reitzenhain\ Erzgebirge",
"4934263", "Hohburg",
"499708", "Bad\ Bocklet",
"493622", "Waltershausen\ Thüringen",
"494543", "Nusse",
"493332", "Schwedt\/Oder",
"4934926", "Pretzsch\ Elbe",
"496228", "Schönau\ Odenwald",
"494751", "Otterndorf",
"496562", "Speicher",
"498231", "Königsbrunn\ bei\ Augsburg",
"493494", "Wolfen",
"497274", "Germersheim",
"494175", "Egestorf\ Nordheide",
"494873", "Aukrug",
"4933839", "Wusterwitz",
"4933965", "Herzsprung\ bei\ Wittstock",
"492945", "Lippstadt\-Benninghausen",
"497739", "Hilzingen",
"493963", "Woldegk",
"494167", "Apensen",
"4934241", "Jesewitz",
"493471", "Bernburg\ Saale",
"4936336", "Klettenberg",
"494724", "Cuxhaven\-Lüdingworth",
"4936921", "Wutha\-Farnroda",
"499439", "Neunburg\-Kemnath",
"492532", "Ostbevern",
"497126", "Burladingen\-Melchingen",
"494365", "Heringsdorf\ Holstein",
"4933972", "Breddin",
"498506", "Bad\ Höhenstadt",
"49811", "Hallbergmoos",
"492742", "Wissen",
"4939728", "Medow\ bei\ Anklam",
"492382", "Ahlen\ Westfalen",
"497233", "Niefern\-Öschelbronn",
"497176", "Spraitbach",
"494834", "Büsum",
"4936452", "Berlstedt",
"495439", "Bersenbrück",
"4939605", "Gross\ Nemerow",
"497251", "Bruchsal",
"496057", "Flörsbachtal",
"4934741", "Frose",
"494303", "Schlesen",
"494561", "Neustadt\ in\ Holstein",
"496752", "Kirn\ Nahe",
"499628", "Ursensollen",
"499338", "Röttingen\ Unterfranken",
"4937439", "Jocketa",
"4938852", "Wittenburg",
"493421", "Torgau",
"4935476", "Wittmannsdorf\-Bückchen",
"494774", "Hechthausen",
"494152", "Geesthacht",
"496442", "Braunfels",
"496174", "Königstein\ im\ Taunus",
"496663", "Steinau\ an\ der\ Strasse",
"494882", "Lunden",
"497720", "Schwenningen\ am\ Neckar",
"497128", "Sonnenbühl",
"492307", "Kamen",
"492624", "Höhr\-Grenzhausen",
"492334", "Hagen\-Hohenlimburg",
"499676", "Winklarn",
"4939742", "Brüssow\ bei\ Pasewalk",
"494971", "Esens",
"499420", "Feldkirchen\ Niederbayern",
"494463", "Wangerland",
"499241", "Pegnitz",
"494642", "Kappeln\ Schlei",
"4939483", "Ballenstedt",
"492803", "Wesel\-Büderich",
"493695", "Bad\ Salzungen",
"493523", "Coswig\ bei\ Dresden",
"495626", "Bad\ Zwesten",
"495336", "Semmenstedt",
"4933084", "Gutengermendorf",
"499336", "Bütthard",
"499626", "Hohenburg",
"4939242", "Prödel",
"494921", "Emden\ Stadt",
"492452", "Heinsberg\ Rheinland",
"495241", "Gütersloh",
"4936604", "Münchenbernsdorf",
"493683", "Schmalkalden",
"495586", "Wieda",
"493573", "Senftenberg",
"495676", "Liebenau\ Hessen",
"496062", "Erbach\ Odenwald",
"496124", "Bad\ Schwalbach",
"4935205", "Ottendorf\-Okrilla",
"492584", "Warendorf\-Milte",
"494405", "Edewecht",
"493843", "Güstrow",
"492674", "Bad\ Bertrich",
"492865", "Raesfeld",
"494192", "Bad\ Bramstedt",
"492163", "Schwalmtal\ Niederrhein",
"494462", "Wittmund",
"4936020", "Ebeleben",
"49541", "Osnabrück",
"492802", "Alpen",
"494643", "Gelting\ Angeln",
"493522", "Grossenhain\ Sachsen",
"494131", "Lüneburg",
"4936464", "Wormstedt",
"4935246", "Ziegenhain\ Sachsen",
"494883", "Süderstapel",
"494185", "Marxen\ Auetal",
"4939485", "Gernrode\ Harz",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"496443", "Ehringshausen\ Dill",
"494153", "Lauenburg\ Elbe",
"4933052", "Leegebruch",
"494855", "Eddelak",
"4933207", "Gross\ Kreutz",
"4934929", "Straach",
"498726", "Schönau\ Niederbayern",
"497938", "Mulfingen\ Jagst",
"492162", "Viersen",
"494193", "Henstedt\-Ulzburg",
"49771", "Donaueschingen",
"496063", "Bad\ König",
"492431", "Erkelenz",
"4939031", "Dähre",
"493682", "Zella\-Mehlis",
"4935058", "Pretzschendorf",
"498139", "Röhrmoos",
"495026", "Steimbke",
"494537", "Sülfeld\ Holstein",
"494504", "Ratekau",
"492485", "Schleiden\-Dreiborn",
"49941", "Regensburg",
"4936846", "Suhl\-Dietzhausen",
"499076", "Wittislingen",
"4933632", "Hangelsberg",
"492453", "Heinsberg\-Randerath",
"494747", "Beverstedt",
"498225", "Jettingen\-Scheppach",
"4935203", "Tharandt",
"493765", "Reichenbach\ Vogtland",
"496147", "Trebur",
"492743", "Daaden",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"498170", "Strasslach\-Dingharting",
"492533", "Münster\-Nienberge",
"492395", "Finnentrop\-Rönkhausen",
"4936484", "Knau\ bei\ Pössneck",
"4933397", "Wandlitz",
"496345", "Albersweiler",
"496821", "Neunkirchen\ Saar",
"496657", "Hofbieber",
"493962", "Penzlin\ bei\ Waren",
"492551", "Steinfurt\-Burgsteinfurt",
"493634", "Sömmerda",
"492591", "Lüdinghausen",
"496753", "Meisenheim",
"492157", "Nettetal\-Kaldenkirchen",
"496697", "Willingshausen",
"4939603", "Burg\ Stargard",
"499078", "Mertingen",
"4938451", "Hoppenrade\ bei\ Güstrow",
"495028", "Pennigsehl",
"496871", "Wadern",
"496785", "Herrstein",
"4936870", "Masserberg",
"4935329", "Dollenchen",
"494302", "Kirchbarkau",
"496731", "Alzey",
"492355", "Schalksmühle",
"496286", "Walldürn\-Rippberg",
"4934652", "Allstedt",
"496541", "Traben\-Trarbach",
"494497", "Barssel\-Harkebrügge",
"4935751", "Welzow",
"497232", "Königsbach\-Stein",
"492383", "Bönen",
"498728", "Geratskirchen",
"492647", "Kesseling",
"4939459", "Hasselfelde",
"497936", "Schrozberg\-Bartenstein",
"495686", "Schwarzenborn\ Knüll",
"493583", "Zittau",
"4935604", "Krieschow",
"492844", "Rheinberg\-Orsoy",
"499480", "Sünching",
"499526", "Riedbach",
"498292", "Dinkelscherben",
"496505", "Kordel",
"499659", "Leuchtenberg",
"493727", "Mittweida",
"4934772", "Helbra",
"499149", "Weissenburg\-Suffersheim",
"492684", "Puderbach\ Westerwald",
"492761", "Olpe\ Biggesee",
"499257", "Zell\ Oberfranken",
"495846", "Gartow\ Niedersachsen",
"4939394", "Hohenberg\-Krusemark",
"494822", "Kellinghusen",
"492574", "Saerbeck",
"493391", "Neuruppin",
"496894", "St\ Ingbert",
"4936205", "Gräfenroda",
"496301", "Otterbach\ Pfalz",
"4939348", "Klitsche",
"496854", "Oberthal\ Saar",
"4936628", "Zeulenroda",
"494935", "Juist",
"494872", "Hanerau\-Hademarschen",
"492524", "Ennigerloh",
"499846", "Ipsheim",
"497340", "Neenstetten",
"496184", "Langenselbold",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"495257", "Hövelhof",
"496563", "Kyllburg",
"495149", "Wienhausen",
"498252", "Schrobenhausen",
"495659", "Ringgau",
"494542", "Mölln\ Lauenburg",
"4934321", "Leisnig",
"493623", "Friedrichroda",
"499576", "Lichtenfels\-Isling",
"494732", "Stadland\-Rodenkirchen",
"499350", "Eussenheim\-Hundsbach",
"4938876", "Roggendorf",
"4935452", "Golssen",
"496132", "Ingelheim\ am\ Rhein",
"4934785", "Sandersleben",
"495848", "Trebel",
"492372", "Hemer",
"496461", "Biedenkopf",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"494661", "Niebüll",
"4939322", "Tangermünde",
"499966", "Wiesenfelden",
"4933836", "Butzow\ bei\ Brandenburg",
"4938752", "Zierzow\ bei\ Ludwigslust",
"4936642", "Harra",
"499262", "Wallenfels",
"499528", "Donnersdorf",
"4939204", "Niederndodeleben",
"492051", "Velbert",
"4933239", "Gross\ Behnitz",
"495262", "Extertal",
"495528", "Gieboldehausen",
"498669", "Traunreut",
"4933458", "Falkenberg\ Mark",
"4939771", "Ueckermünde",
"494344", "Schönberg\ Holstein",
"495966", "Meppen\-Apeldorn",
"4937436", "Weischlitz",
"49421", "Bremen",
"495909", "Wettrup",
"498267", "Dirlewang",
"499848", "Simmershofen",
"497247", "Linkenheim\-Hochstetten",
"496041", "Glauburg",
"493435", "Oschatz",
"497159", "Renningen",
"4938320", "Tribsees",
"492632", "Andernach",
"492964", "Brilon\-Alme",
"4939262", "Güsten\ Anh",
"499624", "Ensdorf\ Oberpfalz",
"499334", "Giebelstadt",
"499307", "Altertheim",
"4937360", "Olbernhau",
"494778", "Wingst",
"4935024", "Stadt\ Wehlen",
"498457", "Vohburg\ an\ der\ Donau",
"495584", "Hattorf\ am\ Harz",
"4934781", "Greifenhagen",
"496291", "Adelsheim",
"495163", "Fallingbostel\-Dorfmark",
"495865", "Gusborn",
"495674", "Grebenstein",
"499803", "Colmberg",
"499105", "Grosshabersdorf",
"492599", "Ascheberg\-Herbern",
"496126", "Idstein",
"492241", "Siegburg",
"499492", "Parsberg",
"495452", "Mettingen\ Westfalen",
"492586", "Beelen",
"494838", "Tellingstedt",
"4939427", "Ströbeck",
"492676", "Ulmen",
"498302", "Görisried",
"496233", "Frankenthal\ Pfalz",
"497955", "Wallhausen\ Württemberg",
"499452", "Langquaid",
"4935933", "Neschwitz",
"495492", "Steinfeld\ Oldenburg",
"4936253", "Georgenthal\ Thüringer\ Wald",
"4939775", "Ahlbeck\ bei\ Torgelow",
"492336", "Schwelm",
"492626", "Selters\ Westferwald",
"495105", "Barsinghausen",
"495803", "Rosche",
"499865", "Adelshofen\ Mittelfranken",
"499674", "Schönsee",
"494120", "Ellerhoop",
"496251", "Bensheim",
"499163", "Dachsbach",
"495307", "Braunschweig\-Wenden",
"495624", "Bad\ Emstal",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"494275", "Ehrenburg",
"492678", "Büchel\ bei\ Cochem",
"497442", "Baiersbronn",
"498131", "Dachau",
"492588", "Harsewinkel\-Greffen",
"497663", "Eichstetten",
"497174", "Mögglingen",
"494836", "Hennstedt\ Dithmarschen",
"4938780", "Lanz\ Brandenburg",
"496128", "Taunusstein",
"499945", "Arnbruck",
"4938334", "Grammendorf",
"498462", "Berching",
"498387", "Weiler\-Simmerberg",
"495382", "Bad\ Gandersheim",
"4939406", "Harbke",
"499742", "Kalbach\ Rhön",
"495467", "Voltlage",
"498153", "Wessling",
"499532", "Maroldsweisach",
"4936201", "Walschleben",
"494776", "Osten\-Altendorf",
"495532", "Stadtoldendorf",
"4934261", "Kühren\ bei\ Wurzen",
"4935874", "Bernstadt\ an\ der\ Eigen",
"498193", "Geltendorf",
"499467", "Michelsneukirchen",
"495742", "Preussisch\ Oldendorf",
"499382", "Gerolzhofen",
"4936701", "Lichte",
"492338", "Breckerfeld",
"492628", "Rhens",
"4934325", "Mochau\-Lüttewitz",
"497062", "Beilstein\ Württemberg",
"497124", "Trochtelfingen\ Hohenz",
"495945", "Wilsum",
"498042", "Lenggries",
"498537", "Bad\ Füssing\-Aigen",
"498504", "Tittling",
"494139", "Hohnstorf\ Elbe",
"495901", "Fürstenau\ bei\ Bramsche",
"497775", "Mühlingen",
"4933366", "Chorin",
"495084", "Hambühren",
"4937344", "Crottendorf\ Sachsen",
"4934243", "Bad\ Düben",
"497151", "Waiblingen",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"496049", "Kefenrod",
"497641", "Emmendingen",
"493496", "Köthen\ Anhalt",
"495425", "Borgholzhausen",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"4936923", "Treffurt",
"497835", "Zell\ am\ Harmersbach",
"497133", "Lauffen\ am\ Neckar",
"498661", "Grabenstätt\ Chiemsee",
"498784", "Hohenthann",
"497972", "Gschwend\ bei\ Gaildorf",
"49821", "Augsburg",
"496406", "Lollar",
"498344", "Westendorf\ bei\ Kaufbeuren",
"494958", "Jemgum",
"497226", "Bühl\-Sand",
"495475", "Bohmte\-Hunteburg",
"4938455", "Plaaz",
"497364", "Oberkochen",
"497557", "Herdwangen\-Schönach",
"497191", "Backnang",
"4936766", "Schalkau",
"499084", "Bissingen\ Schwaben",
"497725", "Königsfeld\ im\ Schwarzwald",
"494267", "Lauenbrück",
"4935755", "Ortrand",
"4934743", "Ermsleben",
"499901", "Hengersberg\ Bayern",
"4934206", "Rötha",
"494606", "Wanderup",
"497404", "Epfendorf",
"49234", "Bochum",
"494292", "Ritterhude",
"492263", "Engelskirchen",
"495651", "Eschwege",
"495827", "Unterlüss",
"496224", "Sandhausen\ Baden",
"4939934", "Gross\ Plasten",
"499737", "Wartmannsroth",
"499704", "Euerdorf",
"4939481", "Hedersleben\ bei\ Aschersleben",
"495633", "Diemelsee",
"495323", "Clausthal\-Zellerfeld",
"495141", "Celle",
"498822", "Oberammergau",
"499547", "Zapfendorf",
"499373", "Amorbach",
"4938308", "Göhren\ Rügen",
"493386", "Premnitz",
"4936947", "Jüchsen",
"494608", "Handewitt",
"492205", "Rösrath",
"495032", "Neustadt\ am\ Rübenberge",
"499141", "Weissenburg\ in\ Bayern",
"495373", "Hillerse\ Kreis\ Gifhorn",
"499323", "Iphofen",
"499633", "Mitterteich",
"4934462", "Laucha\ Unstrut",
"495704", "Petershagen\-Friedewalde",
"498732", "Frontenhausen",
"4939035", "Kuhfelde",
"497228", "Forbach",
"497562", "Isny\ im\ Allgäu",
"4937208", "Auerswalde",
"4939854", "Kleptow",
"498542", "Ortenburg",
"499827", "Lichtenau\ Mittelfranken",
"496274", "Waldbrunn\ Odenwald",
"494956", "Uplengen",
"499651", "Vohenstrauss",
"495691", "Bad\ Arolsen",
"494252", "Bruchhausen\-Vilsen",
"496408", "Buseck",
"499644", "Pressath",
"495361", "Wolfsburg",
"498435", "Ehekirchen",
"496656", "Ebersburg",
"4935606", "Briesen\ bei\ Cottbus",
"492859", "Wesel\-Bislich",
"493606", "Heiligenstadt\ Heilbad",
"492196", "Wermelskirchen",
"495503", "Nörten\-Hardenberg",
"499565", "Untersiemau",
"496146", "Hochheim\ am\ Main",
"494456", "Varel\-Altjührden",
"492440", "Nettersheim\-Tondorf",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"495194", "Bispingen",
"499154", "Pommelsbrunn",
"4939396", "Neukirchen\ Altmark",
"499194", "Ebermannstadt",
"495154", "Aerzen",
"497081", "Bad\ Wildbad",
"496287", "Limbach\ Baden",
"492271", "Bergheim\ Erft",
"494489", "Apen",
"493998", "Demmin",
"4936453", "Mellingen",
"494496", "Friesoythe\-Markhausen",
"4939727", "Spantekow",
"497904", "Ilshofen",
"497937", "Dörzbach",
"492646", "Königsfeld\ Eifel",
"495565", "Einbeck\-Wenzen",
"496849", "Kirkel",
"4937757", "Rittersgrün",
"492156", "Willich\-Anrath",
"499503", "Oberhaid\ Oberfranken",
"494140", "Estorf\ Kreis\ Stade",
"494748", "Stubben\ bei\ Bremerhaven",
"496696", "Gilserberg",
"4933089", "Himmelpfort",
"4938853", "Drönnewitz\ bei\ Hagenow",
"495644", "Willebadessen\-Peckelsheim",
"497422", "Schramberg",
"495832", "Hankensbüttel",
"495975", "Rheine\-Mesum",
"499925", "Bayerisch\ Eisenstein",
"494458", "Wiefelstede\-Spohle",
"4938874", "Lützow",
"498072", "Haag\ in\ Oberbayern",
"496202", "Schwetzingen",
"498623", "Kirchweidach",
"498333", "Babenhausen\ Schwaben",
"4939206", "Eichenbarleben",
"499401", "Neutraubling",
"4939743", "Zerrenthin",
"4933055", "Kremmen",
"499722", "Werneck",
"496658", "Poppenhausen\ Wasserkuppe",
"4933834", "Pritzerbe",
"4939482", "Gatersleben",
"495772", "Espelkamp",
"4939243", "Nedlitz\ bei\ Zerbst",
"499772", "Bischofsheim\ an\ der\ Rhön",
"4937434", "Bobenneukirchen",
"4934461", "Nebra\ Unstrut",
"495027", "Linsburg",
"494536", "Steinhorst\ Lauenburg",
"499077", "Bachhagel",
"496698", "Schrecksbach",
"497654", "Löffingen",
"492158", "Grefrath\ bei\ Krefeld",
"495722", "Bückeburg",
"492750", "Diedenshausen",
"494746", "Hagen\ bei\ Bremerhaven",
"495401", "Georgsmarienhütte",
"494245", "Neuenkirchen\ bei\ Bassum",
"497472", "Rottenburg\ am\ Neckar",
"498727", "Falkenberg\ Niederbayern",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"493996", "Teterow",
"498555", "Perlesreut",
"494498", "Saterland\-Ramsloh",
"497144", "Marbach\ am\ Neckar",
"495925", "Wietmarschen",
"498022", "Tegernsee",
"499975", "Waldmünchen\-Geigant",
"499832", "Wassertrüdingen",
"498583", "Neureichenau",
"4934782", "Mansfeld\ Südharz",
"497353", "Schwendi",
"499602", "Neustadt\ an\ der\ Waldnaab",
"4935244", "Krögis",
"497385", "Gomadingen",
"4935455", "Walddrehna",
"4936968", "Rossdorf\ Rhön",
"4934443", "Teuchern",
"496029", "Mömbris",
"497621", "Lörrach",
"497331", "Geislingen\ an\ der\ Steige",
"498374", "Dietmannsried",
"4939325", "Vinzelberg",
"495445", "Drebber",
"498703", "Essenbach",
"4938755", "Eldena",
"4936645", "Mühltroff",
"497671", "Todtnau",
"498634", "Garching\ an\ der\ Alz",
"498324", "Hindelang",
"495258", "Salzkotten",
"498266", "Kirchheim\ in\ Schwaben",
"499445", "Neustadt\ an\ der\ Donau",
"497581", "Saulgau",
"4939957", "Gielow",
"493838", "Bergen\ auf\ Rügen",
"497246", "Malsch\ Kreis\ Karlsruhe",
"4939088", "Letzlingen",
"495065", "Sibbesse",
"497942", "Neuenstein\ Württemberg",
"4936844", "Rohr\ Thüringen",
"497745", "Jestetten",
"4937369", "Wolkenstein",
"498765", "Bruckberg\ Niederbayern",
"497393", "Munderkingen",
"495602", "Hessisch\ Lichtenau",
"499256", "Stammbach",
"499952", "Eichendorf",
"497483", "Horb\-Mühringen",
"4934775", "Wippra",
"498572", "Tann\ Niederbayern",
"496244", "Westhofen\ Rheinhessenen",
"498095", "Aying",
"49631", "Kaiserslautern",
"498682", "Laufen\ Salzach",
"497455", "Dornhan",
"492294", "Morsbach\ Sieg",
"4936202", "Neudietendorf",
"499171", "Roth\ Mittelfranken",
"499527", "Knetzgau",
"495121", "Hildesheim",
"493726", "Flöha",
"495755", "Kalletal\-Varenholz",
"4936702", "Lauscha",
"495527", "Duderstadt",
"495171", "Peine",
"499343", "Lauda\-Königshofen",
"4934262", "Falkenhain\ bei\ Wurzen",
"492254", "Weilerswist",
"4938789", "Wolfshagen\ bei\ Perleberg",
"499289", "Schwarzenbach\ am\ Wald",
"498055", "Halfing",
"493836", "Wolgast",
"497248", "Marxzell",
"498268", "Tussenhausen",
"499847", "Ergersheim",
"495952", "Sögel",
"498083", "Isen",
"495466", "Merzen",
"496054", "Birstein",
"494333", "Erfde",
"494623", "Böklund",
"493542", "Lübbenau\ Spreewald",
"4934771", "Querfurt",
"4937346", "Geyer",
"498458", "Gaimersheim",
"494777", "Cadenberge",
"493981", "Neustrelitz",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"497203", "Walzbachtal",
"492464", "Aldenhoven\ bei\ Jülich",
"494804", "Nordhastedt",
"494837", "Neuenkirchen\ Dithmarschen",
"493935", "Tangerhütte",
"494351", "Eckernförde",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"496423", "Wetter\ Hessen",
"498386", "Oberstaufen",
"4938203", "Bad\ Doberan",
"4933678", "Storkow\ Mark",
"492502", "Nottuln",
"499409", "Pielenhofen",
"496473", "Leun",
"498536", "Kösslarn",
"497265", "Angelbachtal",
"495308", "Lehre",
"494673", "Joldelund",
"494164", "Harsefeld",
"497709", "Wutach",
"4934204", "Schkeuditz",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"496094", "Weibersbrunn",
"4934322", "Rosswein",
"4936764", "Neuhaus\-Schierschnitz",
"498245", "Türkheim\ Wertach",
"499466", "Stamsried",
"498388", "Hergensweiler",
"496127", "Niedernhausen\ Taunus",
"492723", "Kirchhundem",
"496571", "Wittlich",
"4939265", "Löderburg",
"494435", "Grossenkneten",
"4935451", "Dahme\ Brandenburg",
"499369", "Uettingen",
"492587", "Ennigerloh\-Westkirchen",
"4934348", "Frohburg",
"496764", "Rheinböllen",
"496681", "Hilders",
"492677", "Lutzerath",
"494481", "Hatten\-Sandkrug",
"499306", "Kist",
"4938393", "Binz\ Ostseebad",
"496635", "Kirtorf",
"496325", "Lambrecht\ Pfalz",
"4938751", "Picher",
"496841", "Homburg\ Saar",
"4939321", "Arneburg",
"4933928", "Wildberg\ Brandenburg",
"498456", "Lenting",
"495468", "Bramsche\-Engter",
"493344", "Bad\ Freienwalde",
"497056", "Gechingen",
"4936784", "Stützerbach",
"4939772", "Rothemühl",
"499468", "Zell\ Oberpfalz",
"498650", "Marktschellenberg",
"493661", "Greiz",
"496375", "Wallhalben",
"4933230", "Börnicke\ Kreis\ Havelland",
"4936330", "Grossberndten",
"495306", "Cremlingen",
"492833", "Kerken",
"4939856", "Beenz\ bei\ Prenzlau",
"492181", "Grevenbroich",
"498538", "Pocking\-Hartkirchen",
"492773", "Haiger",
"4937293", "Eppendorf\ Sachsen",
"492851", "Rees",
"492337", "Hagen\-Dahl",
"492627", "Braubach",
"492304", "Schwerte",
"494682", "Amrum",
"499736", "Oberthulba",
"4939883", "Gross\ Dölln",
"496554", "Waxweiler",
"499281", "Hof\ Saale",
"492824", "Kalkar",
"493504", "Dippoldiswalde",
"493537", "Jessen\ Elster",
"499546", "Burgebrach",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"496165", "Breuberg",
"4933051", "Nassenheide",
"499129", "Wendelstein",
"497436", "Messstetten\-Oberdigisheim",
"495826", "Suderburg",
"494842", "Nordstrand",
"492603", "Bad\ Ems",
"4939387", "Havelberg",
"4934920", "Kropstädt",
"499876", "Rohr\ Mittelfranken",
"499235", "Thierstein",
"496482", "Runkel",
"499179", "Freystadt",
"493883", "Hagenow",
"495235", "Blomberg\ Lippe",
"4934465", "Bad\ Bibra",
"498036", "Stephanskirchen\ Simssee",
"494957", "Detern",
"499826", "Weidenbach\ Mittelfranken",
"496805", "Kleinblittersdorf",
"496103", "Langen\ Hessen",
"495129", "Söhlde",
"492734", "Freudenberg\ Westfalen",
"4933631", "Bad\ Saarow\-Pieskow",
"493462", "Bad\ Dürrenberg",
"495546", "Scheden",
"4936029", "Menteroda",
"494522", "Plön",
"492874", "Isselburg",
"493643", "Weimar\ Thüringen",
"494268", "Bötersen",
"495281", "Bad\ Pyrmont",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"496594", "Birresborn",
"497558", "Illmensee",
"492931", "Arnsberg",
"495828", "Himbergen",
"497277", "Wörth\-Büchelberg",
"496071", "Dieburg",
"4939929", "Jabel\ bei\ Waren",
"492953", "Wünnenberg",
"4939993", "Hohenmocker",
"494703", "Loxstedt\-Donnern",
"499548", "Mühlhausen\ Mittelfranken",
"49991", "Deggendorf",
"496352", "Kirchheimbolanden",
"4939404", "Ausleben",
"492985", "Winterberg\-Niedersfeld",
"493302", "Hennigsdorf",
"4939863", "Seehausen\ bei\ Prenzlau",
"499738", "Rottershausen",
"4933439", "Fredersdorf\-Vogelsdorf",
"497556", "Uhldingen\-Mühlhofen",
"4935876", "Weissenberg\ Sachsen",
"495130", "Wedemark",
"4938452", "Lalendorf",
"496392", "Hauenstein\ Pfalz",
"497629", "Tegernau\ Baden",
"49591", "Lingen\ \(Ems\)",
"494266", "Brockel",
"494324", "Brokstedt",
"494634", "Husby",
"494607", "Janneby",
"494962", "Papenburg\-Aschendorf",
"492993", "Marsberg\-Canstein",
"496434", "Bad\ Camberg",
"496407", "Rabenau\ Hessen",
"494209", "Schwanewede",
"4935752", "Ruhland",
"494765", "Ebersdorf\ bei\ Bremervörde",
"498038", "Vogtareuth",
"499828", "Rügland",
"496021", "Aschaffenburg",
"497227", "Lichtenau\ Baden",
"4934651", "Rossla",
"4938854", "Redefin",
"499927", "Kirchberg\ Wald",
"494856", "Kronprinzenkoog",
"499484", "Brennberg",
"498151", "Starnberg",
"494186", "Buchholz\-Trelde",
"4934925", "Bad\ Schmiedeberg",
"495977", "Spelle",
"498133", "Haimhausen\ Oberbayern",
"497661", "Kirchzarten",
"496348", "Offenbach\ an\ der\ Queich",
"4936454", "Magdala",
"492680", "Mündersbach",
"498276", "Baar\ Schwaben",
"499552", "Burghaslach",
"495592", "Gleichen\-Bremke",
"498641", "Grassau\ Kreis\ Traunstein",
"492520", "Wadersloh\-Diestedde",
"499075", "Glött",
"498364", "Seeg",
"495552", "Katlenburg",
"498226", "Bibertal",
"4933974", "Dessow",
"492486", "Nettersheim",
"497344", "Blaubeuren",
"4938481", "Witzin",
"495025", "Estorf\ Weser",
"49721", "Karlsruhe",
"496788", "Sien",
"499977", "Arnschwang",
"4935698", "Hornow",
"492358", "Meinerzhagen\-Valbert",
"4939489", "Strassberg\ Harz",
"494247", "Affinghausen",
"494159", "Basthorst",
"496449", "Ehringshausen\-Katzenfurt",
"498725", "Wurmannsquick",
"498557", "Mauth",
"498191", "Landsberg\ am\ Lech",
"495484", "Lienen\-Kattenvenne",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"4936737", "Drognitz",
"492243", "Eitorf",
"499354", "Rieneck",
"496008", "Echzell",
"498404", "Oberdolling",
"496346", "Annweiler\ am\ Trifels",
"495432", "Löningen",
"4939455", "Schierke",
"4936602", "Ronneburg\ Thüringen",
"494188", "Welle\ Nordheide",
"497822", "Ettenheim",
"4937433", "Gutenfürst",
"499567", "Sesslach\-Gemünda",
"496293", "Schefflenz",
"495161", "Walsrode",
"492389", "Werne",
"4939244", "Steutz",
"4933082", "Menz\ Kreis\ Oberhavel",
"494858", "Sankt\ Margarethen\ Holstein",
"4938377", "Zinnowitz",
"4933833", "Wollin\ bei\ Brandenburg",
"497935", "Schrozberg",
"496253", "Fürth\ Odenwald",
"499161", "Neustadt\ an\ der\ Aisch",
"494340", "Achterwehr",
"4939298", "Barby\ Elbe",
"496285", "Walldürn\-Altheim",
"4939744", "Rothenklempenow",
"4933337", "Altkünkendorf",
"4938461", "Bützow",
"496786", "Kempfeld",
"4938873", "Carlow",
"496231", "Hochdorf\-Assenheim",
"49375", "Zwickau",
"497542", "Tettnang",
"499394", "Esselbach",
"495354", "Jerxheim",
"498562", "Triftern",
"497732", "Radolfzell\ am\ Bodensee",
"495631", "Korbach",
"495321", "Goslar",
"4934498", "Rositz",
"497457", "Rottenburg\-Ergenzingen",
"4935206", "Kreischa\ bei\ Dresden",
"495143", "Winsen\ Aller",
"4937382", "Geringswalde",
"499371", "Miltenberg",
"4936843", "Benshausen",
"495845", "Bergen\ Dumme",
"496569", "Bickendorf",
"49611", "Wiesbaden",
"495653", "Sontra",
"499525", "Königsberg\ in\ Bayern",
"4938782", "Reetz\ bei\ Perleberg",
"493629", "Stadtilm",
"492261", "Gummersbach",
"496506", "Welschbillig",
"4936077", "Grossbodungen",
"49212", "Solingen",
"495685", "Knüllwald",
"499575", "Weismain",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"495052", "Hermannsburg",
"499092", "Wemding",
"493679", "Neuhaus\ am\ Rennweg",
"4933747", "Marzahna",
"49261", "Koblenz\ am\ Rhein",
"493596", "Neustadt\ in\ Sachsen",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"499653", "Eslarn",
"495693", "Volkmarsen",
"495525", "Walkenried",
"4934444", "Lützen",
"4936209", "Klettbach",
"499845", "Oberdachstetten",
"499143", "Pappenheim\ Mittelfranken",
"495371", "Gifhorn",
"498752", "Au\ in\ der\ Hallertau",
"4935243", "Weinböhla",
"494232", "Langwedel\ Kreis\ Verden",
"499321", "Kitzingen",
"499631", "Tirschenreuth",
"498057", "Aschau\-Sachrang",
"494936", "Grossheide",
"497387", "Hohenstein\ Württemberg",
"4935475", "Straupitz",
"497462", "Immendingen",
"497643", "Herbolzheim\ Breisgau",
"499965", "Sankt\ Englmar",
"497131", "Heilbronn\ Neckar",
"498663", "Ruhpolding",
"496508", "Hetzerath\ Mosel",
"498442", "Wolnzach",
"4939606", "Glienke",
"4937362", "Seiffen\ Erzgebirge",
"499762", "Saal\ an\ der\ Saale",
"495447", "Lembruch",
"494284", "Selsingen",
"495903", "Emsbüren",
"497153", "Plochingen",
"4939977", "Jördenstorf",
"494938", "Hagermarsch",
"4938427", "Blowatz",
"497193", "Sulzbach\ an\ der\ Murr",
"495067", "Bockenem",
"499903", "Schöllnach",
"49471", "Bremerhaven",
"499447", "Essing",
"4935727", "Burghammer",
"4936335", "Grosswechsungen",
"4933235", "Friesack",
"497504", "Horgenzell",
"495965", "Klein\ Berssen",
"497042", "Vaihingen\ an\ der\ Enz",
"498062", "Bruckmühl\ Mangfall",
"498124", "Forstern\ Oberbayern",
"4933966", "Dranse",
"497747", "Berau",
"4935471", "Birkenhainchen",
"494404", "Elsfleth",
"4933731", "Trebbin",
"4938750", "Malliss",
"4936640", "Remptendorf",
"492585", "Warendorf\-Hoetmar",
"4939320", "Schinne",
"496239", "Bobenheim\-Roxheim",
"492864", "Reken",
"492675", "Ediger\-Eller",
"4939779", "Eggesin",
"492553", "Ochtrup",
"499106", "Markt\ Erlbach",
"4934746", "Giersleben",
"4934203", "Zwenkau",
"49951", "Bamberg",
"499948", "Eschlkam",
"498858", "Kochel\-Walchensee",
"492741", "Betzdorf",
"4937467", "Klingenthal\ Sachsen",
"496637", "Feldatal",
"496327", "Neustadt\-Lachen",
"4939007", "Tangeln",
"4938204", "Broderstorf",
"4936428", "Stadtroda",
"492104", "Mettmann",
"496733", "Gau\-Odernheim",
"492137", "Neuss\-Norf",
"498340", "Baisweil",
"4934638", "Zöschen",
"4938322", "Richtenberg",
"4939752", "Blumenhagen\ bei\ Strasburg",
"496543", "Büchenbeuren",
"4936926", "Creuzburg",
"492381", "Hamm\ Westfalen",
"49551", "Göttingen",
"4936331", "Ilfeld",
"495948", "Itterbeck",
"4933231", "Pausin",
"499080", "Harburg\ Schwaben",
"4933363", "Altenhof\ Kreis\ Barnim",
"492593", "Ascheberg\ Westfalen",
"492335", "Wetter\ Ruhr",
"492625", "Ochtendung",
"494562", "Grömitz",
"4938828", "Schönberg",
"496751", "Bad\ Sobernheim",
"497252", "Bretten",
"496873", "Nonnweiler",
"496175", "Friedrichsdorf\ Taunus",
"494775", "Grossenwörden",
"494881", "Friedrichstadt",
"4937294", "Grünhainichen",
"4938842", "Lüttenmark",
"494151", "Schwarzenbek",
"496441", "Wetzlar",
"4935387", "Seyda",
"498856", "Penzberg",
"496220", "Wilhelmsfeld",
"494641", "Süderbrarup",
"499946", "Hohenwarth\ bei\ Kötzing",
"499242", "Gössweinstein",
"494276", "Borstel\ bei\ Sulingen",
"494835", "Albersdorf\ Holstein",
"4936783", "Gehren\ Thüringen",
"493904", "Haldensleben",
"493937", "Osterburg\ Altmark",
"494972", "Langeoog",
"494133", "Wittorf\ Kreis\ Lüneburg",
"4935032", "Langenhennersdorf",
"497958", "Rot\ Am\ See\-Brettheim",
"497669", "St\ Märgen",
"498649", "Schleching",
"492451", "Geilenkirchen",
"495242", "Rheda\-Wiedenbrück",
"495108", "Gehrden\ Han",
"495946", "Georgsdorf",
"494364", "Dahme\ Kreis\ Ostholstein",
"494922", "Borkum",
"494191", "Kaltenkirchen\ Holstein",
"494557", "Blunk",
"494725", "Helgoland",
"499868", "Schillingsfürst",
"498247", "Bad\ Wörishofen",
"496061", "Michelstadt",
"497267", "Gemmingen",
"492433", "Hückelhoven",
"492944", "Rietberg\-Mastholte",
"495426", "Glandorf",
"497275", "Kandel",
"4938738", "Karow\ bei\ Lübz",
"494442", "Lohne\ Oldenburg",
"496152", "Gross\-Gerau",
"492692", "Kelberg",
"494663", "Süderlügum",
"4938459", "Laage",
"497836", "Schiltach",
"494174", "Stelle\ Kreis\ Harburg",
"492053", "Velbert\-Neviges",
"4937421", "Oelsnitz\ Vogtland",
"4939451", "Wasserleben",
"4935265", "Glaubitz",
"492424", "Vettweiss",
"498284", "Ziemetshausen",
"496642", "Schlitz",
"4936256", "Wechmar",
"4935936", "Sohland\ Spree",
"4936378", "Ostramondra",
"492474", "Nideggen\-Schmidt",
"49871", "Landshut",
"494605", "Medelby",
"492208", "Niederkassel",
"4939922", "Dambeck\ bei\ Röbel",
"496043", "Nidda",
"497726", "Bad\ Dürrheim",
"495476", "Ostercappeln\-Venne",
"497225", "Gaggenau",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"494124", "Glückstadt",
"4934604", "Niemberg",
"496405", "Laubach\ Hessen",
"4935772", "Rietschen",
"492652", "Mendig",
"4933432", "Müncheberg",
"497139", "Neuenstadt\ am\ Kocher",
"496192", "Hofheim\ am\ Taunus",
"494767", "Bremervörde\-Bevern",
"4939884", "Hassleben\ bei\ Prenzlau",
"499426", "Oberschneiding",
"495379", "Sassenburg\-Grussendorf",
"496167", "Modautal",
"492763", "Drolshagen\-Bleche",
"494792", "Worpswede",
"493745", "Falkenstein\ Vogtland",
"499639", "Mähring",
"496724", "Stromberg\ Hunsrück",
"4934921", "Kemberg",
"493535", "Herzberg\ Elster",
"4936022", "Grossengottern",
"493671", "Saalfeld\ Saale",
"499204", "Plankenfels",
"493581", "Görlitz",
"497838", "Nordrach",
"495428", "Melle\-Neuenkirchen",
"4939039", "Bonese",
"492269", "Kierspe\-Rönsahl",
"493621", "Gotha\ Thüringen",
"499428", "Kirchroth",
"493331", "Angermünde",
"494955", "Westoverledingen",
"496834", "Bous",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"4936741", "Bad\ Blankenburg",
"495237", "Augustdorf",
"495204", "Steinhagen\ Westfalen",
"4935841", "Grossschönau\ Sachsen",
"4938485", "Dabel",
"4939994", "Metschow",
"497728", "Niedereschach",
"496303", "Enkenbach\-Alsenborn",
"495329", "Schulenberg\ im\ Oberharz",
"498232", "Schwabmünchen",
"494752", "Neuhaus\ Oste",
"496561", "Bitburg",
"492206", "Overath",
"493385", "Rathenow",
"49228", "Bonn",
"496774", "Kaub",
"492902", "Warstein",
"492667", "Stein\-Neukirch",
"4937422", "Markneukirchen",
"495978", "Hörstel\-Dreierwalde",
"4935204", "Wilsdruff",
"494483", "Ovelgönne\-Grossenmeer",
"4935322", "Doberlug\-Kirchhain",
"499566", "Meeder",
"496843", "Gersheim",
"499928", "Kirchdorf\ im\ Wald",
"494455", "Jade\-Schweiburg",
"496145", "Flörsheim\ am\ Main",
"492402", "Stolberg\ Rheinland",
"49581", "Uelzen",
"492721", "Lennestadt",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"496655", "Neuhof\ Kreis\ Fulda",
"4933085", "Seilershof",
"492195", "Radevormwald",
"498370", "Wiggensbach",
"4935828", "Reichenbach\ OL",
"493605", "Leinefelde",
"494862", "Garding",
"496683", "Ehrenberg\ Rhön",
"4939452", "Ilsenburg",
"496573", "Gillenfeld",
"496347", "Hochstadt\ Pfalz",
"4936605", "Bad\ Köstritz",
"496787", "Niederbrombach",
"492183", "Rommerskirchen",
"492771", "Dillenburg",
"4939921", "Ankershagen",
"498320", "Missen\-Wilhams",
"498630", "Oberneukirchen",
"492564", "Vreden",
"492853", "Schermbeck",
"496082", "Niederreifenberg",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"495509", "Rosdorf\ Kreis\ Göttingen",
"496695", "Jesberg",
"496523", "Holsthum",
"49981", "Ansbach",
"4935771", "Bad\ Muskau",
"494495", "Friesoythe\-Thüle",
"4938450", "Tarnow\ bei\ Bützow",
"4936463", "Gebstedt",
"498558", "Hohenau\ Niederbayern",
"494102", "Ahrensburg",
"4936871", "Bad\ Colberg\-Heldburg",
"494248", "Bassum\-Neubruchhausen",
"493663", "Schleiz",
"492645", "Vettelschoss",
"492357", "Herscheid\ Westfalen",
"4934446", "Grosskorbetha",
"492831", "Geldern",
"499978", "Schönthal\ Oberpfalz",
"4934672", "Rossleben",
"494353", "Ascheffel",
"4934922", "Mühlanger",
"496034", "Wöllstadt",
"496007", "Rosbach\-Rodheim",
"494385", "Hohenfelde\ bei\ Kiel",
"4933848", "Raben",
"496421", "Marburg",
"492974", "Schmallenberg\-Fredeburg",
"494621", "Schleswig",
"494331", "Rendsburg",
"499926", "Frauenau",
"494857", "Barlt",
"499222", "Presseck",
"499568", "Neustadt\ bei\ Coburg",
"498679", "Burgkirchen\ an\ der\ Alz",
"495272", "Brakel\ Westfalen",
"4939604", "Wildberg\ bei\ Altentreptow",
"4936021", "Schlotheim",
"494187", "Holm\-Seppensen",
"495976", "Salzbergen",
"494671", "Bredstedt",
"499976", "Rötz",
"4936742", "Uhlstädt",
"4935842", "Oderwitz",
"499272", "Fichtelberg",
"4939030", "Brunau",
"495222", "Bad\ Salzuflen",
"498629", "Palling",
"494246", "Twistringen\-Heiligenloh",
"495926", "Engden",
"494942", "Südbrookmerland",
"4936483", "Ziegenrück",
"498556", "Haidmühle",
"494745", "Bad\ Bederkesa",
"4933964", "Fretzdorf",
"496471", "Weilburg",
"494393", "Boostedt",
"492362", "Dorsten",
"494535", "Nahe",
"492924", "Möhnesee",
"495446", "Rehden",
"494422", "Sande\ Kreis\ Friesl",
"493562", "Forst\ Lausitz",
"492951", "Büren",
"497458", "Ebhausen",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"4938856", "Pritzier\ bei\ Hagenow",
"4935472", "Schlepzig",
"497386", "Hayingen",
"492444", "Schleiden\-Gemünd",
"492933", "Sundern\ Sauerland",
"4936087", "Wüstheuterode",
"4937365", "Sayda",
"495190", "Soltau\-Emmingen",
"496073", "Babenhausen\ Hessen",
"4933607", "Briesen\ Mark",
"498203", "Grossaitingen",
"496622", "Bebra",
"496332", "Zweibrücken",
"4939751", "Penkun",
"4933478", "Gross\ Neuendorf",
"498766", "Gammelsdorf",
"4938321", "Martensdorf\ bei\ Stralsund",
"499190", "Heroldsbach",
"492064", "Dinslaken",
"496582", "Freudenburg",
"4939393", "Werben\ Elbe",
"496023", "Alzenau\ in\ Unterfranken",
"496672", "Eiterfeld",
"497746", "Wutöschingen",
"4933976", "Wutike",
"497245", "Durmersheim",
"493437", "Grimma",
"494472", "Lastrup",
"495066", "Sarstedt",
"4939329", "Möringen",
"4936649", "Gefell\ bei\ Schleiz",
"4938759", "Tewswoos",
"496454", "Lichtenfels\-Sachsenberg",
"494144", "Himmelpforten",
"498709", "Eching\ Niederbayern",
"4933232", "Brieselang",
"492991", "Marsberg\-Bredelar",
"4936332", "Ellrich",
"4969", "Frankfurt\ am\ Main",
"499446", "Altmannstein",
"498265", "Pfaffenhausen\ Schwaben",
"4935603", "Burg\ Spreewald",
"492601", "Nauort",
"496534", "Mülheim\ Mosel",
"496507", "Neumagen\-Dhron",
"493725", "Zschopau",
"499349", "Werbach\-Wenkheim",
"496744", "Oberwesel",
"4938841", "Neuhaus\ Elbe",
"497388", "Pfronstetten",
"499283", "Rehau",
"497456", "Haiterbach",
"4939246", "Lindau\ Anh",
"496861", "Merzig",
"499255", "Marktleugast",
"495295", "Lichtenau\ Westfalen",
"495448", "Barver",
"4938785", "Berge\ bei\ Perleberg",
"493364", "Eisenhüttenstadt",
"493641", "Jena",
"499448", "Hausen\ Niederbayern",
"499295", "Töpen",
"495255", "Altenbeken",
"4939203", "Barleben",
"4939746", "Krackow",
"492754", "Bad\ Laasphe\-Feudingen",
"495068", "Elze\ Leine",
"4939058", "Uthmöden",
"4934779", "Abberode",
"498056", "Eggstätt",
"495283", "Lügde\-Rischenau",
"496384", "Konken",
"497748", "Grafenhausen\ Hochschwarzwald",
"493881", "Grevesmühlen",
"496101", "Bad\ Vilbel",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"495852", "Bleckede",
"496550", "Irrhausen",
"499403", "Donaustauf",
"498385", "Hergatz",
"4937381", "Penig",
"4936200", "Elxleben\ bei\ Arnstadt",
"494277", "Schwaförden",
"496479", "Waldbrunn\ Westerwald",
"495182", "Gronau\ Leine",
"4934977", "Quellendorf",
"4938845", "Kaarssen",
"496328", "Elmstein",
"496638", "Schwalmtal\-Renzendorf",
"497703", "Bonndorf\ im\ Schwarzwald",
"4936254", "Friedrichswerth",
"4935934", "Grossdubrau",
"495465", "Neuenkirchen\ bei\ Bramsche",
"497374", "Uttenweiler",
"498857", "Benediktbeuern",
"4938781", "Mellen",
"498331", "Memmingen",
"498621", "Trostberg",
"494556", "Ahrensbök\-Gnissau",
"498246", "Waal",
"499465", "Neukirchen\-Balbini",
"494339", "Christiansholm",
"497266", "Kirchardt",
"498581", "Waldkirchen\ Niederbayern",
"497634", "Sulzburg",
"497324", "Herbrechtingen",
"497962", "Fichtenau",
"498671", "Altötting",
"495045", "Springe\-Bennigsen",
"498535", "Haarbach",
"498393", "Holzgünz",
"4939886", "Milmersdorf",
"497765", "Rickenbach\ Hotzenwald",
"499182", "Velburg",
"498745", "Bodenkirchen",
"4935023", "Bad\ Gottleuba",
"496429", "Schweinsberg\ Hessen",
"495403", "Bad\ Iburg",
"499852", "Feuchtwangen",
"4934606", "Teicha\ Sachsen\-Anhalt",
"495947", "Laar\ Vechte",
"492223", "Königswinter",
"497682", "Elzach",
"497572", "Mengen\ Württemberg",
"499305", "Estenfeld",
"496264", "Neudenau",
"492839", "Straelen\-Herongen",
"496326", "Deidesheim",
"496636", "Romrod",
"4935873", "Herrnhut",
"492779", "Greifenstein\-Beilstein",
"495363", "Wolfsburg\-Vorsfelde",
"497842", "Kappelrodeck",
"498862", "Steingaden\ Oberbayern",
"49371", "Chemnitz\ Sachsen",
"499107", "Trautskirchen",
"499134", "Neunkirchen\ am\ Brand",
"4937361", "Neuhausen\ Erzgebirge",
"4938325", "Rolofshagen",
"4939996", "Törpin",
"499363", "Arnstein\ Unterfranken",
"497957", "Kressberg",
"494320", "Heidmühlen",
"494630", "Barderup",
"497083", "Bad\ Herrenalb",
"4938333", "Horst\ bei\ Grimmen",
"492273", "Kerpen\-Horrem",
"4933877", "Nitzahn",
"497268", "Bad\ Rappenau\-Obergimpern",
"495305", "Sickte",
"496430", "Hahnstätten",
"4937608", "Waldenburg\ Sachsen",
"497522", "Wangen\ im\ Allgäu",
"499867", "Geslau",
"498248", "Lamerdingen",
"497055", "Neuweiler\ Kreis\ Calw",
"498102", "Höhenkirchen\-Siegertsbrunn",
"494558", "Todesfelde",
"499875", "Wolframs\-Eschenbach",
"499664", "Hahnbach",
"499173", "Thalmässing",
"495341", "Salzgitter",
"499932", "Osterhofen",
"496050", "Biebergemünd",
"4934298", "Taucha\ bei\ Leipzig",
"499236", "Nagel",
"497435", "Albstadt\-Laufen",
"496109", "Frankfurt\-Bergen\-Enkheim",
"495123", "Schellerten",
"495825", "Wieren",
"499545", "Buttenheim",
"496166", "Fischbachtal",
"499735", "Massbach",
"49214", "Leverkusen",
"4936025", "Körner",
"4938482", "Warin",
"4936924", "Mihla",
"4938206", "Graal\-Müritz\ Seeheilbad",
"4936653", "Lehesten\ Thüringer\ Wald",
"498081", "Dorfen\ Stadt",
"492234", "Frechen",
"492207", "Kürten\-Dürscheid",
"492666", "Freilingen\ Westerwald",
"496869", "Merzig\-Silwingen",
"495545", "Hedemünden",
"499825", "Herrieden",
"4937343", "Jöhstadt",
"4934244", "Mockrehna",
"494768", "Hipstedt",
"499123", "Lauf\ an\ der\ Pegnitz",
"498035", "Raubling",
"496806", "Heusweiler",
"495236", "Blomberg\-Grossenmarpe",
"495173", "Uetze",
"499341", "Tauberbischofsheim",
"495932", "Haren\ Ems",
"495664", "Morschen",
"495875", "Emmendorf",
"4933768", "Prieros",
"4939853", "Holzendorf\ bei\ Prenzlau",
"497623", "Rheinfelden\ Baden",
"497333", "Laichingen",
"497072", "Gomaringen",
"4937327", "Rechenberg\-Bienenmühle",
"4937296", "Stollberg\ Erzgebirge",
"498422", "Dollnstein",
"497777", "Sauldorf",
"494203", "Weyhe\ bei\ Bremen",
"495427", "Melle\-Buer",
"4938727", "Mestlin",
"497837", "Oberharmersbach",
"497804", "Oppenau",
"497351", "Biberach\ an\ der\ Riss",
"499238", "Röslau",
"4936601", "Hermsdorf\ Thüringen",
"4939925", "Wredenhagen",
"4938227", "Lüdershagen\ bei\ Barth",
"498654", "Freilassing",
"495238", "Nieheim\-Himmighausen",
"497391", "Ehingen\ Donau",
"499427", "Leiblfing",
"494766", "Basdahl",
"4939933", "Vollrathsruhe",
"497583", "Bad\ Schussenried",
"494265", "Fintel",
"4933435", "Rehfelde",
"4935775", "Pechern",
"497673", "Schönau\ im\ Schwarzwald",
"4936875", "Straufhain\-Streufdorf",
"497022", "Nürtingen",
"497164", "Boll\ Kreis\ Göppingen",
"4938462", "Baumgarten",
"498144", "Grafrath",
"497555", "Deggenhausertal",
"497727", "Vöhrenbach",
"4939034", "Fleetmark",
"494740", "Loxstedt\-Dedesdorf",
"494202", "Achim\ bei\ Bremen",
"496458", "Rosenthal\ Hessen",
"494148", "Drochtersen\-Assel",
"4938737", "Ganzlin",
"4939855", "Parmen\-Weggun",
"498054", "Breitbrunn\ am\ Chiemsee",
"496386", "Altenkirchen\ Pfalz",
"498423", "Titting",
"49335", "Frankfurt\ \(Oder\)",
"492255", "Euskirchen\-Flamersheim",
"495754", "Extertal\-Bremke",
"497332", "Lauterstein",
"497622", "Schopfheim",
"497073", "Ammerbuch",
"496359", "Grünstadt",
"497941", "Öhringen",
"496536", "Kleinich",
"4939923", "Priborn",
"492295", "Ruppichteroth",
"497582", "Bad\ Buchau",
"4936377", "Rastenberg",
"496746", "Pfalzfeld",
"497672", "St\ Blasien",
"497023", "Weilheim\ an\ der\ Teck",
"492448", "Hellenthal\-Rescheid",
"498094", "Steinhöring",
"495601", "Schauenburg",
"496245", "Biblis",
"4939600", "Zwiedorf",
"497454", "Sulz\ am\ Neckar",
"4939266", "Förderstedt",
"4939999", "Tutow",
"4936461", "Bad\ Sulza",
"4933433", "Buckow\ Märkische\ Schweiz",
"4935773", "Schleife",
"4936873", "Themar",
"493366", "Beeskow",
"498764", "Mauern\ Kreis\ Freising",
"498681", "Waging\ am\ See",
"498571", "Simbach\ am\ Inn",
"497534", "Reichenau\ Baden",
"492066", "Duisburg\-Homberg",
"499951", "Landau\ an\ der\ Isar",
"494529", "Süsel\-Bujendorf",
"497744", "Stühlingen",
"4935754", "Klettwitz",
"4936023", "Horsmar",
"49209", "Gelsenkirchen",
"495064", "Gross\ Düngen",
"492758", "Bad\ Berleburg\-Girkhausen",
"498841", "Murnau\ am\ Staffelsee",
"492150", "Meerbusch\-Lank",
"494146", "Stade\-Bützfleth",
"496456", "Haina\ Kloster",
"498635", "Pleiskirchen",
"498325", "Oberstaufen\-Thalkirchdorf",
"499172", "Georgensgmünd",
"499933", "Wallersdorf",
"499444", "Siegenburg",
"4938454", "Kritzkow",
"495444", "Wagenfeld",
"495172", "Ilsede",
"495933", "Lathen",
"4936481", "Neustadt\ an\ der\ Orla",
"494287", "Heeslingen\-Boitzen",
"4939402", "Völpke",
"4939889", "Boitzenburg",
"498375", "Weitnau",
"499122", "Schwabach",
"494849", "Hooge",
"4935200", "Arnsdorf\ bei\ Dresden",
"4934609", "Salzmünde",
"496650", "Hosenfeld",
"497384", "Schelklingen\-Hütten",
"492446", "Heimbach\ Eifel",
"495951", "Werlte",
"498177", "Münsing\ Starnberger\ See",
"4934324", "Ostrau\ Sachsen",
"499974", "Traitsching",
"4936762", "Steinach\ Thüringen",
"498165", "Neufahrn\ bei\ Freising",
"49431", "Kiel",
"4934202", "Delitzsch",
"494244", "Harpstedt",
"497145", "Markgröningen",
"495924", "Bad\ Bentheim\-Gildehaus",
"495362", "Wolfsburg\-Fallersleben",
"498554", "Schönberg\ Niederbayern",
"497843", "Renchen",
"4937468", "Treuen\ Vogtland",
"497655", "Feldberg\-Altglashütten",
"498367", "Rosshaupten\ Forggensee",
"4939008", "Kunrau",
"495250", "Delbrück\ Westfalen",
"492568", "Heek",
"497683", "Simonswald",
"492222", "Bornheim\ Rheinland",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"497573", "Stetten\ am\ kalten\ Markt",
"497347", "Dietenheim",
"4939391", "Lückstedt",
"498805", "Hohenpeissenberg",
"496036", "Wölfersheim",
"497082", "Neuenbürg\ Württemberg",
"4936427", "Dornburg\ Saale",
"4938323", "Prohn",
"492272", "Bedburg\ Erft",
"4939753", "Strasburg",
"4934637", "Frankleben",
"499924", "Bodenmais",
"4933362", "Liepe\ Kreis\ Barnim",
"4935601", "Peitz",
"4938827", "Kalkhorst",
"492928", "Soest\-Ostönnen",
"4935388", "Klöden",
"495645", "Borgentreich\-Borgholz",
"498071", "Wasserburg\ am\ Inn",
"4938843", "Bennin",
"496201", "Weinheim\ Bergstr",
"492566", "Legden",
"497034", "Ehningen",
"495831", "Wittingen",
"499397", "Wertheim\-Dertingen",
"495357", "Grasleben",
"497240", "Pfinztal",
"497702", "Blumberg\ Baden",
"495771", "Rahden\ Westfalen",
"495183", "Lamspringe",
"495564", "Dassel",
"497905", "Langenburg",
"499195", "Adelsdorf\ Mittelfranken",
"495155", "Emmerthal",
"4934466", "Janisroda",
"495853", "Neu\ Darchau",
"499402", "Regenstauf",
"4939774", "Mönkebude",
"492509", "Nottuln\-Appelhülsen",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"499721", "Schweinfurt",
"495721", "Stadthagen",
"49281", "Wesel",
"4933657", "Steinsdorf\ Brandenburg",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"499853", "Wilburgstetten",
"499155", "Simmelsdorf",
"495195", "Neuenkirchen\ bei\ Soltau",
"498392", "Markt\ Rettenbach",
"499564", "Bad\ Rodach",
"4939201", "Wolmirstedt",
"499183", "Burgthann",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"4935025", "Liebstadt",
"498021", "Waakirchen",
"499357", "Gräfendorf\ Bayern",
"497963", "Adelmannsfelden",
"499831", "Gunzenhausen",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"4938209", "Sanitz\ bei\ Rostock",
"498434", "Rennertshofen",
"498407", "Grossmehring",
"497471", "Hechingen",
"493923", "Zerbst",
"498656", "Anger",
"494127", "Westerhorn",
"499282", "Naila",
"495300", "Salzgitter\-Üfingen",
"496435", "Wallmerod",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"4934497", "Langenleuba\-Niederhain",
"4937383", "Lunzenau",
"4936842", "Oberhof\ Thüringen",
"494681", "Wyk\ auf\ Föhr",
"494764", "Gnarrenburg\-Klenkendorf",
"4938783", "Dallmin",
"4930", "Berlin",
"492238", "Pulheim",
"497166", "Adelberg",
"494635", "Sörup",
"498146", "Moorenweis",
"494841", "Husum\ Nordsee",
"492427", "Nideggen",
"492984", "Hallenberg",
"4933748", "Treuenbrietzen",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"4939205", "Langenweddingen",
"4935021", "Königstein\ Sächsische\ Schweiz",
"497806", "Bad\ Peterstal\-Griesbach",
"494177", "Drage\ Elbe",
"493973", "Pasewalk",
"495282", "Schieder\-Schwalenberg",
"4935242", "Nossen",
"494521", "Eutin",
"498450", "Ingolstadt\-Zuchering",
"493461", "Merseburg\ Saale",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"498202", "Althegnenberg",
"496623", "Rotenburg\ an\ der\ Fulda",
"496595", "Dockweiler",
"496333", "Waldfischbach\-Burgalben",
"495609", "Ahnatal",
"492236", "Wesseling\ Rheinland",
"492664", "Rennerod",
"492932", "Neheim\-Hüsten",
"492173", "Langenfeld\ Rheinland",
"4937363", "Zöblitz",
"493301", "Oranienburg",
"496351", "Eisenberg\ Pfalz",
"497949", "Pfedelbach\-Untersteinbach",
"492735", "Neunkirchen\ Siegerl",
"496804", "Mandelbachtal",
"496837", "Wallerfangen",
"4936704", "Steinheid",
"495234", "Horn\-Bad\ Meinberg",
"495207", "Schloss\ Holte\-Stukenbrock",
"494423", "Fedderwarden",
"493563", "Spremberg",
"492545", "Rosendahl\-Darfeld",
"499666", "Illschwang",
"4939395", "Wanzer",
"494961", "Papenburg",
"499234", "Neusorg",
"499207", "Königsfeld\ Oberfranken",
"497808", "Hohberg\ bei\ Offenburg",
"4938428", "Hohenkirchen\ bei\ Wismar",
"4936204", "Stotternheim",
"496391", "Dahn",
"494473", "Emstek",
"4939978", "Gross\ Roge",
"496583", "Palzem",
"496022", "Obernburg\ am\ Main",
"496164", "Reichelsheim\ Odenwald",
"496673", "Haunetal",
"4935605", "Komptendorf",
"4935728", "Uhyst\ Spree",
"496555", "Bleialf",
"498380", "Achberg",
"4938331", "Rakow\ Vorpom",
"4935930", "Seitschen",
"492825", "Uedem",
"496727", "Gensingen",
"493731", "Freiberg\ Sachsen",
"495273", "Beverungen",
"498029", "Kreuth\ bei\ Tegernsee",
"495136", "Burgdorf\ Kreis\ Hannover",
"492305", "Castrop\-Rauxel",
"493541", "Calau",
"494260", "Visselhövede\-Wittorf",
"499223", "Rugendorf",
"497328", "Königsbronn",
"496703", "Wöllstein\ Rheinhessen",
"499779", "Nordheim\ von\ der\ Rhön",
"493871", "Parchim",
"494352", "Damp",
"496374", "Weilerbach",
"4936651", "Lobenstein",
"492363", "Datteln",
"494392", "Nortorf\ bei\ Neumünster",
"493821", "Ribnitz\-Damgarten",
"496266", "Hassmersheim",
"492501", "Münster\-Hiltrup",
"499729", "Grettstadt",
"496634", "Gemünden\ Felda",
"496324", "Hassloch",
"496209", "Mörlenbach",
"495223", "Bünde",
"494434", "Colnrade",
"494407", "Wardenburg",
"4939749", "Grambow\ bei\ Pasewalk",
"492867", "Heiden\ Kreis\ Borken",
"494943", "Grossefehn",
"496765", "Gemünden\ Hunsrück",
"497429", "Egesheim",
"4934776", "Rothenschirmbach",
"4935697", "Bagenz",
"4937341", "Ehrenfriedersdorf",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"495839", "Wittingen\-Ohrdorf",
"494554", "Wahlstedt",
"496682", "Tann\ Rhön",
"496572", "Manderscheid\ Eifel",
"496095", "Bessenbach",
"49831", "Kempten\ Allgäu",
"492403", "Eschweiler\ Rheinland",
"4936920", "Grossenlupnitz",
"4936738", "Königsee",
"497264", "Bad\ Rappenau",
"499820", "Lehrberg",
"494165", "Hollenstedt\ Nordheide",
"497636", "Münstertal\ Schwarzwald",
"497326", "Neresheim",
"4936459", "Blankenhain\ Thüringen",
"492947", "Anröchte",
"494863", "Sankt\ Peter\-Ording",
"4939851", "Göritz\ bei\ Prenzlau",
"4936603", "Weida",
"496842", "Blieskastel",
"495138", "Sehnde",
"4937432", "Pausa\ Vogtland",
"4938859", "Alt\ Zachun",
"492045", "Bottrop\-Kirchhellen",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"494482", "Hatten",
"494367", "Grossenbrode",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"4939484", "Harzgerode",
"4936646", "Tanna\ bei\ Schleiz",
"4933832", "Rogäsen",
"4938756", "Grabow",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"492465", "Inden",
"4938378", "Heringsdorf\ Seebad",
"494103", "Wedel",
"493907", "Gardelegen",
"494805", "Schafstedt",
"492852", "Hamminkeln",
"496083", "Weilrod",
"495820", "Suhlendorf",
"496268", "Hüffenhardt",
"4938872", "Rehna",
"4935456", "Terpt",
"496522", "Mettendorf",
"492182", "Grevenbroich\-Kapellen",
"496055", "Freigericht",
"4936465", "Oberndorf\ bei\ Apolda",
"4933338", "Stolpe\/Oder",
"4939931", "Röbel\ Müritz",
"4933979", "Wusterhausen\ Dosse",
"497376", "Langenenslingen",
"498291", "Zusmarshausen",
"498549", "Vilshofen\-Pleinting",
"4939740", "Nechlin",
"496457", "Burgwald\ Eder",
"493943", "Wernigerode",
"4934297", "Liebertwolkwitz",
"497569", "Isny\-Eisenbach",
"49711", "Stuttgart",
"497506", "Wangen\-Leupolz",
"497930", "Boxberg\ Baden",
"494821", "Itzehoe",
"494793", "Hambergen",
"492762", "Wenden\ Südsauerland",
"494753", "Balje",
"492447", "Dahlem\ bei\ Kall",
"492903", "Meschede\-Freienohl",
"4938483", "Brüel",
"498176", "Egling\ bei\ Wolfratshausen",
"4936652", "Wurzbach",
"494871", "Hohenwestedt",
"496302", "Winnweiler",
"498233", "Kissing",
"4939405", "Hötensleben",
"4937342", "Cranzahl",
"494731", "Nordenham",
"494286", "Gyhum",
"494541", "Ratzeburg",
"498251", "Aichach",
"492371", "Iserlohn",
"4937328", "Grossschirma",
"496462", "Gladenbach",
"496387", "Sankt\ Julian",
"4939852", "Schönermark\ bei\ Prenzlau",
"496643", "Herbstein",
"496131", "Mainz",
"4933767", "Friedersdorf\ bei\ Berlin",
"4933970", "Neustadt\ Dosse",
"493594", "Bischofswerda",
"4934464", "Freyburg\ Unstrut",
"492052", "Velbert\-Langenberg",
"496185", "Hammersbach\ Hessen",
"4937431", "Mehltheuer\ Vogtland",
"4939776", "Hintersee",
"496855", "Freisen",
"4938728", "Domsühl",
"4935263", "Gröditz\ bei\ Riesa",
"49561", "Kassel",
"499261", "Kronach",
"494443", "Dinklage",
"492693", "Antweiler",
"494662", "Leck",
"492525", "Beckum\-Neubeckum",
"499070", "Tapfheim",
"494934", "Marienhafe",
"492653", "Kaisersesch",
"49961", "Weiden\ in\ der\ Oberpfalz",
"495261", "Lemgo",
"4938228", "Dettmannsdorf\-Kölzow",
"492685", "Flammersfeld",
"494288", "Horstedt\ Kreis\ Rotenburg",
"492575", "Greven\-Reckenfeld",
"4938850", "Gammelin",
"4933831", "Weseram",
"4939932", "Malchow\ bei\ Waren",
"492631", "Neuwied",
"498178", "Icking",
"496042", "Büdingen\ Hessen",
"496504", "Thalfang",
"4936450", "Kranichfeld",
"493863", "Crivitz",
"492845", "Neukirchen\-Vluyn",
"4936929", "Ruhla",
"4938871", "Mühlen\ Eichsen",
"496747", "Emmelshausen",
"4934978", "Radegast\ Kreis\ Köthen",
"494973", "Wittmund\-Burhafe",
"4936841", "Schleusingen",
"494132", "Amelinghausen",
"493521", "Meissen",
"492801", "Xanten",
"492354", "Meinerzhagen",
"4939036", "Binde",
"494461", "Jever",
"499243", "Pottenstein",
"497348", "Beimerstetten",
"496784", "Weierbach",
"496661", "Schlüchtern",
"492567", "Ahaus\-Alstätte",
"493375", "Königs\ Wusterhausen",
"4936785", "Gräfinau\-Angstedt",
"499396", "Urspringen\ bei\ Lohr",
"495356", "Helmstedt\-Barmke",
"498368", "Halblech",
"492432", "Wassenberg",
"493635", "Kölleda",
"4940", "Hamburg",
"499356", "Burgsinn",
"499749", "Oberbach\ Unterfranken",
"493841", "Wismar",
"492161", "Mönchengladbach",
"49621", "Mannheim",
"496344", "Schwegenheim",
"498406", "Böhmfeld",
"4935241", "Lommatzsch",
"492394", "Neuenrade\-Affeln",
"494923", "Krummhörn\-Pewsum",
"498469", "Freystadt\-Burggriesbach",
"497449", "Baiersbronn\-Obertal",
"493571", "Hoyerswerda",
"4935022", "Bad\ Schandau",
"4939264", "Kroppenstedt",
"493764", "Meerane",
"493681", "Suhl",
"498366", "Oy\-Mittelberg",
"4934205", "Markranstädt",
"499398", "Birkenfeld\ bei\ Würzburg",
"498224", "Offingen\ Donau",
"4935756", "Hosena",
"495358", "Bahrdorf\-Mackendorf",
"492927", "Neuengeseke",
"492484", "Mechernich\-Eiserfey",
"4935939", "Hochkirch",
"4936259", "Tabarz\ Thüringer\ Wald",
"497346", "Illerkirchberg",
"494505", "Stockelsdorf\-Curau",
"493961", "Altentreptow",
"492552", "Steinfurt\-Borghorst",
"495520", "Braunlage",
"4938456", "Langhagen\ bei\ Güstrow",
"4935872", "Neusalza\-Spremberg",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"494854", "Friedrichskoog",
"497253", "Bad\ Schönborn",
"496872", "Losheim\ am\ See",
"494184", "Hanstedt\ Nordheide",
"493423", "Eilenburg",
"499499", "Painten",
"495459", "Hörstel",
"494563", "Scharbeutz\-Haffkrug",
"492592", "Selm",
"4938332", "Gross\ Bisdorf",
"495840", "Schnackenburg",
"496542", "Bullay",
"498274", "Buttenwiesen",
"496004", "Lich\-Eberstadt",
"497231", "Pforzheim",
"499358", "Gössenheim",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"496732", "Wörrstadt",
"4937607", "Ebersbrunn\ Sachsen",
"492977", "Schmallenberg\-Bödefeld",
"4933878", "Nennhausen",
"497152", "Leonberg\ Württemberg",
"496275", "Rothenberg\ Odenwald",
"496836", "Überherrn",
"492639", "Anhausen\ Kreis\ Neuwied",
"4936761", "Heubisch",
"495206", "Bielefeld\-Jöllenbeck",
"494128", "Kollmar",
"4935473", "Neu\ Lübbenau",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"4933733", "Stülpe",
"495902", "Freren",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"497971", "Gaildorf",
"498443", "Hohenwart\ Paar",
"4933608", "Jacobsdorf\ Mark",
"495705", "Petershagen\-Windheim",
"492204", "Bensberg",
"492237", "Kerpen\ Rheinland\-Türnich",
"497463", "Mühlheim\ an\ der\ Donau",
"496776", "Dachsenhausen",
"497642", "Endingen\ Kaiserstuhl",
"498063", "Feldkirchen\-Westerham",
"494830", "Süderhastedt",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"4933477", "Trebnitz\ bei\ Müncheberg",
"499269", "Tettau\ Kreis\ Kronach",
"496726", "Lorch\ Rheingau",
"492428", "Niederzier",
"497043", "Maulbronn",
"4934774", "Röblingen\ am\ See",
"499206", "Mistelgau\-Obernsees",
"495763", "Uchte",
"492379", "Menden\-Asbeck",
"4933361", "Joachimsthal",
"494770", "Wischhafen",
"4936333", "Heringen\ Helme",
"4933233", "Ketzin",
"494178", "Radbruch",
"49331", "Potsdam",
"496139", "Budenheim",
"4935602", "Drebkau",
"497192", "Murrhardt",
"49201", "Essen",
"4936845", "Gehlberg",
"498259", "Schiltberg",
"495652", "Bad\ Sooden\-Allendorf",
"492620", "Neuhäusel\ Westerwald",
"492330", "Herdecke",
"499085", "Alerheim",
"497724", "St\ Georgen\ im\ Schwarzwald",
"495474", "Stemwede\-Dielingen",
"498821", "Garmisch\-Partenkirchen",
"495142", "Eschede",
"4936781", "Grossbreitenbach",
"494126", "Horst\ Holstein",
"498657", "Ramsau\ bei\ Berchtesgaden",
"497365", "Essingen\ Württemberg",
"495208", "Leopoldshöhe",
"498345", "Stöttwang",
"496838", "Saarwellingen",
"499424", "Strasskirchen",
"495424", "Bad\ Rothenfelde",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"494233", "Blender",
"498785", "Rottenburg\-Oberroning",
"494176", "Marschacht",
"497834", "Wolfach",
"497807", "Neuried\ Ortenaukreis",
"4939202", "Gross\ Ammensleben",
"499208", "Bindlach",
"495031", "Wunstorf",
"499142", "Treuchtlingen",
"4939324", "Kläden\ bei\ Stendal",
"494829", "Wewelsfleth",
"499474", "Schmidmühlen",
"4938754", "Leussow\ bei\ Ludwigslust",
"498753", "Elsendorf\ Niederbayern",
"4936644", "Hirschberg\ Saale",
"495085", "Burgdorf\-Ehlershausen",
"494251", "Hoya",
"496728", "Ober\-Hilbersheim",
"4935245", "Burkhardswalde\-Munzig",
"492426", "Nörvenich",
"496120", "Aarbergen",
"498541", "Vilshofen\ Niederbayern",
"497303", "Illertissen",
"499652", "Waidhaus",
"495692", "Wolfhagen",
"499093", "Polsingen",
"495053", "Fassberg\-Müden",
"497561", "Leutkirch\ im\ Allgäu",
"498731", "Dingolfing",
"497774", "Eigeltingen",
"4935454", "Uckro",
"496292", "Seckach",
"4937423", "Adorf\ Vogtland",
"498505", "Hutthurm",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"4935323", "Sonnewalde",
"495433", "Badbergen",
"494224", "Gross\ Ippener",
"497125", "Bad\ Urach",
"494366", "Grömitz\-Cismar",
"495944", "Hoogstede",
"497823", "Seelbach\ Schutter",
"4937435", "Reuth\ bei\ Plauen",
"492242", "Hennef\ Sieg",
"499491", "Hemau",
"4939453", "Derenburg",
"495451", "Ibbenbüren",
"4935827", "Nieder\-Seifersdorf",
"494950", "Holtland",
"497327", "Dischingen",
"498563", "Bad\ Birnbach\ Rottal",
"499451", "Schierling",
"495491", "Damme\ Dümmer",
"497733", "Engen\ Hegau",
"4933054", "Liebenwalde",
"493969", "Siedenbollentin",
"4933835", "Golzow\ bei\ Brandenburg",
"497543", "Kressbronn\ am\ Bodensee",
"4933969", "Stepenitz",
"4936462", "Ossmannstedt",
"499944", "Miltach",
"497751", "Waldshut",
"499433", "Nabburg",
"494274", "Varrel\ bei\ Sulingen",
"497175", "Leinzell",
"494408", "Hude\ Oldenburg",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"4934673", "Heldrungen",
"496252", "Heppenheim\ Bergstrasse",
"498461", "Beilngries",
"492948", "Lippstadt\-Rebbeke",
"49251", "Münster",
"499553", "Ebrach\ Oberfranken",
"495593", "Bovenden\-Lenglern",
"496400", "Mücke",
"495625", "Naumburg\ Hessen",
"4934923", "Cobbelsdorf",
"495335", "Schladen",
"4933847", "Görzke",
"499675", "Altendorf\ am\ Nabburg",
"4934654", "Stolberg\ Harz",
"497220", "Forbach\-Hundsbach",
"497441", "Freudenstadt",
"499531", "Ebern",
"495137", "Seelze",
"497954", "Kirchberg\ an\ der\ Jagst",
"4934600", "Ostrau\ Saalkreis",
"4935209", "Mohorn",
"495381", "Seesen",
"499741", "Bad\ Brückenau",
"495741", "Lübbecke",
"494406", "Berne",
"4936743", "Teichel",
"499381", "Volkach",
"4936206", "Grossfahner",
"496669", "Neuhof\-Hauswurz",
"4935843", "Hirschfelde\ bei\ Zittau",
"492866", "Dorsten\-Rhade",
"495531", "Holzminden",
"499104", "Emskirchen",
"4939401", "Neuwegersleben",
"4936482", "Triptis",
"495585", "Herzberg\-Sieber",
"4933989", "Sadenbeck",
"495864", "Jameln",
"495675", "Trendelburg",
"498041", "Bad\ Tölz",
"494469", "Wangerooge",
"499625", "Kastl\ bei\ Amberg",
"495553", "Kalefeld",
"499335", "Aub\ Kreis\ Würzburg",
"496267", "Fahrenbach\ Baden",
"493529", "Heidenau\ Sachsen",
"492938", "Ense",
"495345", "Baddeckenstedt",
"497024", "Wendlingen\ am\ Neckar",
"4934292", "Brandis\ bei\ Wurzen",
"497162", "Süssen",
"499871", "Windsbach",
"495821", "Bad\ Bevensen",
"498142", "Olching",
"496078", "Gross\-Umstadt",
"498208", "Eurasburg\ bei\ Augsburg",
"495657", "Meissner",
"49271", "Siegen",
"497431", "Albstadt\-Ebingen",
"4937209", "Einsiedel\ bei\ Chemnitz",
"495259", "Bad\ Driburg\-Neuenheerse",
"498652", "Berchtesgaden",
"495147", "Uetze\-Hänigsen",
"497485", "Empfingen",
"499286", "Oberkotzau",
"498093", "Glonn\ Kreis\ Ebersberg",
"497453", "Altensteig\ Württemberg",
"495731", "Bad\ Oeynhausen",
"497802", "Oberkirch\ Baden",
"4938488", "Demen",
"498053", "Bad\ Endorf",
"495286", "Ottenstein\ Niedersachsen",
"495541", "Hann\.\ Münden",
"499147", "Nennslingen",
"498085", "Sankt\ Wolfgang",
"495753", "Auetal\-Bernsen",
"499657", "Waldthurn",
"498031", "Rosenheim\ Oberbayern",
"496028", "Sulzbach\ am\ Main",
"4935691", "Bärenklau\ NL",
"4938309", "Trent",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"499345", "Külsheim\ Baden",
"498424", "Nassenfels",
"4937323", "Lichtenberg\ Erzgebirge",
"4934224", "Belgern\ Sachsen",
"497249", "Stutensee",
"497157", "Waldenbuch",
"4933762", "Zeuthen",
"499288", "Bad\ Steben",
"495443", "Lemförde",
"498705", "Altfraunhofen",
"49461", "Flensburg",
"4938735", "Plau\ am\ See",
"495907", "Geeste",
"495934", "Haren\-Rütenbrock",
"498269", "Unteregg\ bei\ Mindelheim",
"4939857", "Drense",
"495662", "Felsberg\ Hessen",
"497355", "Hochdorf\ Riss",
"498667", "Seeon\-Seebruck",
"49641", "Giessen",
"498206", "Egling\ an\ der\ Paar",
"4936944", "Rentwertshausen",
"4935435", "Gollmitz\ bei\ Calau",
"4938723", "Kladrum",
"4935268", "Stauchitz",
"497383", "Münsingen\-Buttenhausen",
"492232", "Brühl\ Rheinland",
"4939291", "Calbe\ Saale",
"496026", "Grossostheim",
"497743", "Ühlingen\-Birkendorf",
"4938223", "Saal\ Vorpom",
"4936375", "Kindelbrück",
"497533", "Allensbach",
"497395", "Ehingen\-Dächingen",
"499662", "Vilseck",
"499907", "Zenting",
"499443", "Abensberg",
"494261", "Rotenburg\ Wümme",
"495063", "Bad\ Salzdetfurth",
"497551", "Überlingen\ Bodensee",
"498381", "Lindenberg\ im\ Allgäu",
"494749", "Schiffdorf\-Geestenseth",
"4934973", "Osternienburg",
"497524", "Bad\ Waldsee",
"496578", "Salmtal",
"498137", "Petershausen",
"494356", "Gross\ Wittensee",
"498104", "Sauerlach",
"494539", "Westerau",
"4934491", "Schmölln\ Thüringen",
"494488", "Westerstede",
"495132", "Lehrte",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"498593", "Untergriesbach",
"498335", "Fellheim",
"496848", "Homburg\-Einöd",
"499923", "Teisnach",
"495461", "Bramsche\ Hase",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"494243", "Twistringen",
"499461", "Roding",
"495923", "Schüttorf",
"497844", "Rheinau",
"498553", "Spiegelau",
"495041", "Springe\ Deister",
"499132", "Herzogenaurach",
"499973", "Furth\ im\ Wald",
"4939386", "Seehausen\ Altmark",
"498585", "Grainet",
"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"4935027", "Weesenstein",
"497761", "Bad\ Säckingen",
"497684", "Glottertal",
"498531", "Pocking",
"497574", "Gammertingen",
"496262", "Aglasterhausen",
"498741", "Vilsbiburg",
"492858", "Hünxe",
"494499", "Barssel",
"499563", "Rödental",
"496297", "Ravenstein\ Baden",
"499184", "Deining\ Oberpfalz",
"494486", "Edewecht\-Friedrichsfehn",
"499854", "Wittelshofen",
"498433", "Königsmoos",
"49365", "Gera",
"494358", "Loose\ bei\ Eckernförde",
"492247", "Neunkirchen\-Seelscheid",
"492159", "Meerbusch\-Osterath",
"497632", "Badenweiler",
"497322", "Giengen\ an\ der\ Brenz",
"495505", "Hardegsen",
"4935877", "Cunewalde",
"497964", "Stödtlen",
"492856", "Hamminkeln\-Brünen",
"496659", "Eichenzell",
"499505", "Litzendorf",
"496526", "Bollendorf",
"4936425", "Isserstedt",
"4934635", "Bad\ Lauchstädt",
"497033", "Weil\ Der\ Stadt",
"495301", "Lehre\-Essenrode",
"495854", "Bleckede\-Barskamp",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"4937602", "Kirchberg\ Sachsen",
"4939366", "Kehnert",
"495184", "Freden\ Leine",
"497051", "Calw",
"4939080", "Kalbe\ Milde",
"495563", "Kreiensen",
"496257", "Seeheim\-Jugenheim",
"4938825", "Klütz",
"4933873", "Grosswudicke",
"496382", "Lauterecken",
"494269", "Ahausen\-Kirchwalsede",
"496467", "Hatzfeld\ Eder",
"492955", "Büren\-Wewelsburg",
"494705", "Wremen",
"49861", "Traunstein",
"4933920", "Walsleben\ bei\ Neuruppin",
"492983", "Winterberg\-Siedlinghausen",
"4935478", "Goyatz",
"4937756", "Breitenbrunn\ Erzgebirge",
"497336", "Lonsee",
"497626", "Kandern",
"498020", "Weyarn",
"4933603", "Falkenhagen\ bei\ Seelow",
"4938356", "Behrenhoff",
"499178", "Abenberg\ Mittelfranken",
"4939726", "Ducherow",
"492752", "Bad\ Laasphe",
"494206", "Stuhr\-Heiligenrode",
"495128", "Hohenhameln",
"4936083", "Uder",
"494902", "Jemgum\-Ditzum",
"494667", "Dagebüll",
"4933472", "Golzow\ bei\ Seelow",
"4939397", "Geestgottberg",
"499720", "Üchtelhausen",
"4939226", "Hohenziatz",
"494763", "Gnarrenburg",
"499128", "Feucht",
"4936421", "Camburg",
"4939829", "Blankenförde",
"493362", "Erkner",
"496532", "Zeltingen\-Rachtig",
"497420", "Deisslingen",
"4935607", "Jänschwalde",
"496047", "Altenstadt\ Hessen",
"498261", "Mindelheim",
"497586", "Herbertingen",
"4933238", "Senzke",
"4936338", "Bleicherode",
"497676", "Feldberg\ Schwarzwald",
"496742", "Boppard",
"4938821", "Lüdersdorf",
"499829", "Flachslanden",
"493721", "Meinersdorf",
"498039", "Rott\ am\ Inn",
"494474", "Garrel",
"4939349", "Parey\ Elbe",
"492605", "Löf",
"494208", "Grasberg",
"495126", "Algermissen",
"494142", "Steinkirchen\ Kreis\ Stade",
"496452", "Battenberg\ Eder",
"499176", "Allersberg",
"4934495", "Dobitschen",
"499233", "Arzberg\ Oberfranken",
"497628", "Efringen\-Kirchen",
"4936693", "Crossen\ an\ der\ Elster",
"496584", "Wellen\ Mosel",
"499251", "Münchberg",
"496163", "Höchst\ im\ Odenwald",
"496674", "Friedewald\ Hessen",
"496865", "Mettlach\-Orscholz",
"499549", "Lisberg",
"495251", "Paderborn",
"492663", "Westerburg\ Westerwald",
"492174", "Burscheid\ Rheinland",
"493831", "Stralsund",
"4939052", "Erxleben\ bei\ Haldensleben",
"4939207", "Colbitz",
"496307", "Schopp",
"496624", "Heringen\ Werra",
"496334", "Thaleischweiler\-Fröschen",
"493771", "Aue\ Sachsen",
"495233", "Steinheim\ Westfalen",
"495176", "Edemissen",
"493564", "Schwarze\ Pumpe",
"499126", "Eckental",
"496105", "Mörfelden\-Walldorf",
"496803", "Mandelbachtal\-Ommersheim",
"495829", "Wriedel",
"497708", "Geisingen\-Leipferdingen",
"495309", "Lehre\-Wendhausen",
"496633", "Homberg\ Ohm",
"496323", "Edenkoben",
"494451", "Varel\ Jadebusen",
"4938731", "Lübz",
"492226", "Rheinbach",
"492364", "Haltern\ Westfalen",
"492922", "Werl",
"4934364", "Wermsdorf",
"493601", "Mühlhausen\ Thüringen",
"499408", "Altenthann",
"492191", "Remscheid",
"492557", "Wettringen\ Kreis\ Steinfurt",
"4939956", "Neukalen",
"492725", "Lennestadt\-Oedingen",
"496651", "Rasdorf",
"4935822", "Hagenwerder",
"496827", "Eppelborn",
"499274", "Hollfeld",
"495224", "Enger\ Westfalen",
"4933704", "Baruth\ Mark",
"4939458", "Heudeber",
"494433", "Dötlingen",
"494944", "Wiesmoor",
"495366", "Jembke",
"499366", "Geroldshausen\ Unterfranken",
"4939295", "Zuchau",
"492775", "Driedorf",
"4933204", "Beelitz\ Mark",
"495274", "Nieheim",
"4936041", "Bad\ Tennstedt",
"4936371", "Schlossvippach",
"496691", "Schwalmstadt",
"492151", "Krefeld",
"492597", "Senden\ Westfalen",
"498459", "Manching",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"496032", "Bad\ Nauheim",
"494491", "Friesoythe",
"496373", "Schönenberg\-Kübelberg",
"4938231", "Barth",
"492835", "Issum",
"492972", "Schmallenberg",
"496704", "Langenlonsheim",
"496737", "Köngernheim",
"492133", "Dormagen",
"495368", "Parsau",
"494137", "Barendorf",
"494104", "Aumühle\ bei\ Hamburg",
"493933", "Genthin",
"4934928", "Seegrehna",
"4934426", "Kayna",
"496425", "Rauschenberg\ Hessen",
"4934384", "Grossbothen",
"499406", "Mintraching",
"494381", "Lütjenburg",
"4935894", "Hähnichen",
"499469", "Roding\-Neubäu",
"492562", "Gronau\ Westfalen",
"494625", "Jübek",
"494335", "Hohn\ bei\ Rendsburg",
"492228", "Remagen\-Rolandseck",
"497940", "Künzelsau",
"496084", "Schmitten\ Taunus",
"497706", "Oberbaldingen",
"492404", "Alsdorf\ Rheinland",
"497263", "Waibstadt",
"4933394", "Blumberg\ Kreis\ Barnim",
"494864", "Oldenswort",
"493991", "Waren\ Müritz",
"494553", "Geschendorf",
"498243", "Fuchstal",
"494741", "Nordholz\ bei\ Bremerhaven",
"495406", "Belm",
"498389", "Weissensberg",
"4935342", "Mühlberg\ Elbe",
"496475", "Weilmünster\-Wolfenhausen",
"4935695", "Simmersdorf",
"494531", "Bad\ Oldesloe",
"4938732", "Gallin\ bei\ Lübz",
"498666", "Teisendorf",
"498207", "Affing",
"498234", "Bobingen",
"495658", "Wehretal",
"493491", "Lutherstadt\ Wittenberg",
"497271", "Wörth\ am\ Rhein",
"494754", "Bülkau",
"4933765", "Märkisch\ Buchholz",
"497646", "Weisweil\ Breisgau",
"496772", "Nastätten",
"492904", "Bestwig",
"492937", "Arnsberg\-Oeventrop",
"497156", "Ditzingen",
"496832", "Beckingen\-Reimsbach",
"495148", "Steinhorst\ Niedersachsen",
"495202", "Oerlinghausen",
"495906", "Lünne",
"4936372", "Kleinneuhausen",
"499906", "Mariaposching",
"4936042", "Tonna",
"4939384", "Arendsee\ Altmark",
"499202", "Waischenfeld",
"499148", "Ettenstatt",
"4939426", "Hessen",
"4939928", "Möllenhagen",
"493433", "Borna\ Stadt",
"493944", "Blankenburg\ Harz",
"4938232", "Zingst\ Ostseebad",
"497440", "Bad\ Rippoldsau",
"494794", "Worpswede\-Ostersode",
"497221", "Baden\-Baden",
"496027", "Stockstadt\ am\ Main",
"499658", "Georgenberg",
"498460", "Berching\-Holnstein",
"4933438", "Altlandsberg",
"496722", "Rüdesheim\ am\ Rhein",
"4936878", "Oberland",
"496401", "Grünberg\ Hessen",
"493741", "Plauen",
"495908", "Wietmarschen\-Lohne",
"495146", "Wietze",
"494122", "Uetersen",
"4933841", "Belzig",
"493531", "Finsterwalde",
"492654", "Polch",
"499287", "Selb",
"497158", "Neuhausen\ auf\ den\ Fildern",
"4934295", "Krensitz",
"493585", "Löbau",
"4936028", "Kammerforst\ Thüringen",
"496361", "Rockenhausen",
"492472", "Monschau",
"493675", "Sonneberg\ Thüringen",
"495656", "Waldkappel",
"495529", "Rhumspringe",
"496503", "Hermeskeil",
"499529", "Oberaurach",
"492422", "Kreuzau",
"493335", "Finowfurt",
"494951", "Weener",
"499656", "Moosbach\ bei\ Vohenstrauss",
"495696", "Bad\ Arolsen\-Landau",
"498282", "Krumbach\ Schwaben",
"4939407", "Seehausen\ Börde",
"496644", "Grebenhain",
"496154", "Ober\-Ramstadt",
"4935341", "Bad\ Liebenwerda",
"494444", "Goldenstedt",
"492694", "Wershofen",
"494933", "Dornum\ Ostfriesland",
"494172", "Salzhausen",
"4934956", "Zörbig",
"499146", "Markt\ Berolzheim",
"499908", "Schöfweg",
"493381", "Brandenburg\ an\ der\ Havel",
"4939364", "Dolle",
"496565", "Dudeldorf",
"495849", "Waddeweitz",
"492671", "Cochem",
"4934207", "Zwochau",
"492581", "Warendorf",
"498138", "Schwabhausen\ bei\ Dachau",
"496343", "Bad\ Bergzabern",
"492246", "Lohmar\ Rheinland",
"492942", "Geseke",
"496296", "Ahorn\ Baden",
"4937463", "Bergen\ Vogtland",
"4939003", "Jübar",
"492745", "Brachbach\ Sieg",
"497939", "Schrozberg\-Spielbach",
"493763", "Glauchau",
"4935363", "Fermerswalde",
"495244", "Rietberg",
"49531", "Braunschweig",
"4939820", "Triepkendorf",
"492393", "Sundern\-Allendorf",
"492535", "Sendenhorst\-Albersloh",
"494362", "Heiligenhafen",
"494924", "Moormerland\-Oldersum",
"494487", "Grossenkneten\-Huntlosen",
"4936422", "Reinstädt\ Thüringen",
"492353", "Halver",
"4934632", "Mücheln\ Geiseltal",
"49931", "Würzburg",
"499244", "Betzenstein",
"4938328", "Miltzow",
"492385", "Hamm\-Rhynern",
"494974", "Neuharlingersiel",
"496256", "Lampertheim\-Hüttenfeld",
"493902", "Diesdorf\ Altm",
"492331", "Hagen\ Westfalen",
"492621", "Lahnstein",
"496755", "Odernheim\ am\ Glan",
"492857", "Rees\-Mehr",
"496527", "Oberweis",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"496171", "Oberursel\ Taunus",
"4933367", "Friedrichswalde\ Brandenburg",
"496783", "Baumholder",
"4933929", "Gühlen\-Glienicke",
"4937605", "Hartenstein\ Sachsen",
"494183", "Jesteburg",
"493987", "Templin",
"494885", "Bergenhusen",
"494771", "Hemmoor",
"4935383", "Elster\ Elbe",
"4933679", "Wendisch\ Rietz",
"4938848", "Vellahn",
"494564", "Schashagen",
"494853", "Sankt\ Michaelisdonn",
"496445", "Schöffengrund",
"494155", "Büchen",
"496298", "Möckmühl",
"497254", "Waghäusel",
"492102", "Ratingen",
"492248", "Hennef\-Uckerath",
"494357", "Sehestedt\ Eider",
"498136", "Markt\ Indersdorf",
"4936946", "Erbenhausen\ Thüringen",
"498273", "Nordendorf",
"496003", "Rosbach\ von\ der\ Höhe",
"4939051", "Calvörde",
"4933652", "Neuzelle",
"498223", "Ichenhausen",
"492455", "Waldfeucht",
"494402", "Rastede",
"496258", "Gernsheim",
"494721", "Cuxhaven",
"494195", "Hartenholm",
"494893", "Hohenaspe",
"492862", "Südlohn",
"495325", "Goslar\-Hahnenklee",
"495635", "Vöhl",
"497502", "Wolpertswende",
"4936847", "Steinbach\-Hallenberg",
"497044", "Mönsheim",
"4934492", "Lucka",
"498064", "Au\ bei\ Bad\ Aibling",
"498122", "Erding",
"495841", "Lüchow\ Wendland",
"499375", "Freudenberg\ Baden",
"496468", "Dautphetal\-Mornshausen",
"494668", "Klanxbüll",
"492265", "Reichshof\-Eckenhagen",
"494959", "Dollart",
"4938788", "Gross\ Warnow",
"495127", "Harsum",
"499521", "Hassfurt",
"495571", "Uslar",
"499177", "Heideck",
"495681", "Homberg\ Efze",
"495764", "Steyerberg",
"492058", "Wülfrath",
"4939954", "Stavenhagen\ Reuterstadt",
"4939055", "Hörsingen",
"4933206", "Fichtenwalde",
"499764", "Höchheim",
"4933743", "Blönsdorf",
"499681", "Windischeschenbach",
"494282", "Sittensen",
"499571", "Lichtenfels\ Bayern",
"495177", "Edemissen\-Abbensen",
"499127", "Rosstal\ Mittelfranken",
"495521", "Herzberg\ am\ Harz",
"492203", "Cologne\-Porz",
"4935247", "Zehren\ Sachsen",
"497464", "Talheim\ Kreis\ Tuttlingen",
"495375", "Müden\ Aller",
"499841", "Bad\ Windsheim",
"496048", "Büdingen\-Eckartshausen",
"499635", "Bärnau",
"499325", "Kleinlangheim",
"496306", "Trippstadt",
"498444", "Schweitenkirchen",
"497229", "Iffezheim",
"4934424", "Reuden\ bei\ Zeitz",
"492056", "Heiligenhaus",
"499473", "Kallmünz",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"498754", "Volkenschwand",
"495423", "Versmold",
"496409", "Biebertal",
"494207", "Oyten",
"494234", "Dörverden",
"4939089", "Bismark\ Altmark",
"494666", "Ladelund",
"497135", "Brackenheim",
"499961", "Mitterfels",
"497833", "Hornberg\ Schwarzwaldbahn",
"4937368", "Deutschneudorf",
"496466", "Dautphetal\-Friedensdorf",
"495054", "Bergen\-Sülze",
"499094", "Tagmersheim",
"494609", "Eggebek",
"497181", "Schorndorf\ Württemberg",
"497773", "Bodman\-Ludwigshafen",
"4934909", "Aken\ Elbe",
"497851", "Kehl",
"497304", "Blaustein\ Württemberg",
"497627", "Steinen\ Kreis\ Lörrach",
"497337", "Nellingen\ Alb",
"496308", "Olsbrücken",
"49465", "Sylt",
"496046", "Ortenberg\ Hessen",
"497723", "Furtwangen\ im\ Schwarzwald",
"4933475", "Letschin",
"4938423", "Bad\ Kleinen",
"496660", "Steinau\-Marjoss",
"497587", "Hosskirch",
"4939973", "Altkalen",
"4936969", "Merkers",
"4933396", "Klosterfelde",
"495961", "Haselünne",
"499423", "Geiselhöring",
"4935723", "Bernsdorf\ OL",
"495473", "Ostercappeln",
"4937601", "Mülsen\ Skt\ Jacob",
"49340", "Dessau\ Anh",
"4933845", "Borkheide",
"4937754", "Zwönitz",
"497544", "Markdorf",
"499392", "Faulbach\ Unterfranken",
"495352", "Schöningen",
"498564", "Johanniskirchen",
"492630", "Mülheim\-Kärlich",
"498771", "Ergoldsbach",
"4934291", "Borsdorf",
"4938300", "Insel\ Hiddensee",
"497707", "Bräunlingen",
"497734", "Gailingen",
"4935974", "Hinterhermsdorf",
"494273", "Kirchdorf\ bei\ Sulingen",
"494136", "Scharnebeck",
"497665", "March\ Breisgau",
"495071", "Schwarmstedt",
"499943", "Lam\ Oberpfalz",
"492558", "Horstmar",
"4939724", "Klein\ Bünzow",
"499434", "Bodenwöhr",
"499407", "Wenzenbach",
"4938354", "Wusterhusen",
"499260", "Wilhelmsthal\ Oberfranken",
"495434", "Essen\ Oldenburg",
"495407", "Wallenhorst",
"492598", "Senden\-Ottmarsbocholt",
"494223", "Ganderkesee\-Bookholzberg",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"495943", "Emlichheim",
"497824", "Schwanau",
"499071", "Dillingen\ an\ der\ Donau",
"495021", "Nienburg\ Weser",
"4939224", "Büden",
"494839", "Wöhrden\ Dithmarschen",
"496130", "Schwabenheim\ an\ der\ Selz",
"4935692", "Kerkwitz",
"492436", "Wegberg\-Rödgen",
"494779", "Freiburg\ Elbe",
"499352", "Lohr\ am\ Main",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"498721", "Eggenfelden",
"498402", "Münchsmünster",
"492556", "Metelen",
"499103", "Cadolzburg",
"499805", "Burgoberbach",
"496826", "Bexbach",
"498250", "Hilgertshausen\-Tandern",
"492339", "Sprockhövel\-Hasslinghausen",
"4936733", "Kaulsdorf",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"495367", "Rühen",
"495482", "Tecklenburg",
"4937437", "Bad\ Elster",
"498362", "Füssen",
"495554", "Moringen",
"4936608", "Seelingstädt\ bei\ Gera",
"492227", "Bornheim\-Merten",
"4933088", "Falkenthal",
"495863", "Zernien",
"4935825", "Kodersdorf",
"495165", "Rethem\ Aller",
"499165", "Sugenheim",
"497931", "Bad\ Mergentheim",
"496281", "Buchen\ Odenwald",
"4938373", "Katzow",
"4939292", "Biederitz",
"496736", "Bechenheim",
"499554", "Untersteinbach\ Unterfranken",
"495594", "Bovenden\-Reyershausen",
"4933837", "Brielow",
"497953", "Blaufelden",
"499482", "Wörth\ an\ der\ Donau",
"496235", "Schifferstadt",
"499367", "Unterpleichfeld",
"496876", "Weiskirchen\ Saar",
"49361", "Erfurt",
"4935953", "Burkau",
"4933333", "Tantow",
"495805", "Oetzen",
"492596", "Nordkirchen",
"495103", "Wennigsen\ Deister",
"496129", "Schlangenbad",
"4936735", "Probstzella",
"4935327", "Priessen",
"49481", "Heide\ Holstein",
"495862", "Hitzacker\ Elbe",
"497577", "Veringenstadt",
"497343", "Buch\ bei\ Illertissen",
"4934906", "Raguhn",
"498501", "Thyrnau",
"498363", "Pfronten",
"497121", "Reutlingen",
"4935054", "Lauenstein\ Sachsen",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"4939457", "Benneckenstein\ Harz",
"4935823", "Ostritz",
"495483", "Lienen",
"4939086", "Jävenitz",
"499102", "Wilhermsdorf",
"498867", "Rottenbuch\ Oberbayern",
"495455", "Tecklenburg\-Brochterbeck",
"499495", "Breitenbrunn\ Oberpfalz",
"4938375", "Koserow",
"494928", "Ihlow\-Riepe",
"495495", "Vörden\ Kreis\ Vechta",
"495248", "Langenberg\ Kreis\ Gütersloh",
"495102", "Laatzen",
"497952", "Gerabronn",
"497256", "Philippsburg",
"4933335", "Pinnow\ Kreis\ Uckermark",
"497755", "Weilheim\ Kreis\ Waldshut",
"4935955", "Pulsnitz",
"4935796", "Panschwitz\-Kuckau",
"497527", "Wolfegg",
"498134", "Odelzhausen",
"497171", "Schwäbisch\ Gmünd",
"4936966", "Kaltennordheim",
"494509", "Gross\ Grönau",
"495857", "Bleckede\-Brackede",
"495621", "Bad\ Wildungen",
"499942", "Viechtach",
"495331", "Wolfenbüttel",
"499246", "Pegnitz\-Trockau",
"498465", "Kipfenberg",
"495187", "Delligsen",
"497445", "Pfalzgrafenweiler",
"494272", "Siedenburg",
"4933843", "Niemegk",
"499671", "Oberviechtach",
"494976", "Spiekeroog",
"496254", "Lautertal\ Odenwald",
"4934927", "Globig\-Bleddin",
"499535", "Pfarrweisach",
"495353", "Königslutter\ am\ Elm",
"499393", "Rothenfels\ Unterfranken",
"493329", "Stahnsdorf",
"499745", "Wildflecken",
"499385", "Kolitzheim",
"493379", "Mahlow",
"495745", "Stemwede\-Levern",
"498403", "Pförring",
"49231", "Dortmund",
"492244", "Königswinter\-Oberpleis",
"497967", "Jagstzell",
"495535", "Polle",
"499353", "Karlstadt",
"497258", "Oberderdingen\-Flehingen",
"496294", "Krautheim\ Jagst",
"4933209", "Caputh",
"495671", "Hofgeismar",
"498045", "Lenggries\-Fall",
"499187", "Altdorf\ bei\ Nürnberg",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"495246", "Verl",
"494222", "Ganderkesee",
"499331", "Ochsenfurt",
"499621", "Amberg\ Oberpfalz",
"495942", "Uelsen",
"494926", "Krummhörn\-Greetsiel",
"499857", "Schopfloch\ Mittelfranken",
"4935477", "Rietzneuendorf\-Friedrichshof",
"496271", "Eberbach\ Baden",
"495694", "Diemelstadt",
"499654", "Pleystein",
"498427", "Wellheim",
"496646", "Grebenau",
"49351", "Dresden",
"495422", "Melle",
"494446", "Bakum\ Kreis\ Vechta",
"4935361", "Schlieben",
"492696", "Nohn\ Eifel",
"4933602", "Alt\ Zeschdorf",
"497975", "Untergröningen",
"497832", "Haslach\ im\ Kinzigtal",
"492689", "Dierdorf",
"499144", "Pleinfeld",
"49385", "Schwerin",
"4936082", "Ershausen",
"4939344", "Güsen",
"499472", "Hohenfels\ Oberpfalz",
"4939001", "Apenburg",
"4936624", "Teichwolframsdorf",
"4933473", "Zechin",
"495472", "Bad\ Essen",
"4938425", "Kirchdorf\ Poel",
"4939975", "Thürkow",
"495144", "Wathlingen",
"492656", "Virneburg",
"4939398", "Gross\ Garz",
"492529", "Oelde\-Stromberg",
"496196", "Bad\ Soden\ am\ Taunus",
"499701", "Sandberg\ Unterfranken",
"499422", "Bogen\ Niederbayern",
"4933237", "Paulinenaue",
"4935725", "Wittichenau",
"4936337", "Schiedungen",
"496221", "Heidelberg",
"493866", "Cambs",
"494758", "Nordleda",
"496440", "Kölschhausen",
"498238", "Gessertshausen",
"495654", "Herleshausen",
"497722", "Triberg\ im\ Schwarzwald",
"4935608", "Gross\ Ossnig",
"499904", "Lalling",
"499937", "Oberpöring",
"496888", "Lebach\-Steinbach",
"499081", "Nördlingen",
"494295", "Emtinghausen",
"493946", "Quedlinburg",
"496158", "Riedstadt",
"497194", "Spiegelberg",
"497361", "Aalen",
"498123", "Moosinning",
"498825", "Krün",
"496648", "Bad\ Salzschlirf",
"4933454", "Wölsickendorf\/Wollenberg",
"494796", "Teufelsmoor",
"4936692", "Bürgel",
"4936075", "Dingelstädt\ Eichsfeld",
"497503", "Wilhelmsdorf\ Württemberg",
"498341", "Kaufbeuren",
"498664", "Chieming",
"498781", "Rottenburg\ an\ der\ Laaber",
"498236", "Fischach",
"4939208", "Loitsche",
"494349", "Dänischenhagen",
"493868", "Rastow",
"4939053", "Süplingen",
"494756", "Odisheim",
"492202", "Bergisch\ Gladbach",
"4933745", "Petkus",
"497644", "Kenzingen",
"495035", "Gross\ Munzel",
"497154", "Kornwestheim",
"496198", "Eppstein",
"4939824", "Hohenzieritz",
"498545", "Hofkirchen\ Bayern",
"494255", "Martfeld",
"498735", "Gangkofen\-Kollbach",
"494283", "Tarmstedt",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"495937", "Geeste\-Gross\ Hesepe",
"495904", "Lengerich\ Emsl",
"496544", "Rhaunen",
"498272", "Wertingen",
"496002", "Ober\-Mörlen",
"494465", "Friedeburg\ Ostfriesland",
"499339", "Ippesheim",
"496707", "Windesheim",
"496734", "Flonheim",
"4935385", "Annaburg",
"492103", "Hilden",
"499556", "Geiselwind",
"493693", "Meiningen",
"493525", "Riesa",
"494852", "Brunsbüttel",
"493371", "Luckenwalde",
"496665", "Sinntal\-Altengronau",
"499227", "Neuenmarkt",
"496874", "Wadern\-Nunkirchen",
"494182", "Tostedt",
"4936071", "Teistungen",
"495277", "Höxter\-Fürstenau",
"495438", "Bakum\-Lüsche",
"492594", "Dülmen",
"492554", "Laer\ Kreis\ Steinfurt",
"493631", "Nordhausen\ Thüringen",
"499438", "Fensterbach",
"493321", "Nauen\ Brandenburg",
"499277", "Warmensteinach",
"496824", "Ottweiler",
"4933741", "Niedergörsdorf",
"494403", "Bad\ Zwischenahn",
"492165", "Jüchen",
"494947", "Aurich\-Ogenbargen",
"494892", "Schenefeld\ Mittelholstein",
"492863", "Velen",
"497130", "Löwenstein\ Württemberg",
"497738", "Steisslingen",
"495556", "Lindau\ Harz",
"498222", "Burgau\ Schwaben",
"495339", "Gielde",
"49791", "Schwäbisch\ Hall",
"4935028", "Krippen",
"493685", "Hildburghausen",
"492482", "Hellenthal",
"492367", "Henrichenburg",
"495436", "Nortrup",
"492392", "Werdohl",
"494363", "Lensahn",
"497826", "Schuttertal",
"494501", "Kastorf\ Holstein",
"49881", "Weilheim\ in\ Oberbayern",
"493762", "Crimmitschau",
"4935365", "Falkenberg\ Elster",
"492407", "Herzogenrath\-Kohlscheid",
"492434", "Wegberg",
"492943", "Erwitte",
"4933094", "Löwenberg",
"493965", "Burow\ bei\ Altentreptow",
"4937465", "Tannenbergsthal\ Vogtland",
"4939005", "Kusey",
"496342", "Schweigen\-Rechtenbach",
"4939971", "Gnoien",
"496782", "Birkenfeld\ Nahe",
"494305", "Westensee",
"497546", "Oberteuringen",
"496087", "Waldems",
"497736", "Tengen",
"498509", "Ruderting",
"497235", "Unterreichenbach\ Kreis\ Calw",
"493447", "Altenburg\ Thüringen",
"494134", "Embsen\ Kreis\ Lüneburg",
"4937603", "Wildenfels",
"494107", "Siek\ Kreis\ Stormarn",
"495320", "Torfhaus",
"492352", "Altena\ Westfalen",
"497129", "Lichtenstein\ Württemberg",
"499436", "Nittenau",
"4933872", "Hohennauen",
"492961", "Brilon",
"496044", "Schotten\ Hessen",
"498295", "Altenmünster\ Schwaben",
"496502", "Schweich",
"4934293", "Naunhof\ bei\ Grimma",
"492473", "Simmerath",
"4936949", "Obermassfeld\-Grimmenthal",
"4933676", "Friedland\ bei\ Beeskow",
"494825", "Burg\ Dithmarschen",
"494123", "Barmstedt",
"4938794", "Cumlosen",
"495768", "Petershagen\-Heimsen",
"492054", "Essen\-Kettwig",
"49906", "Donauwörth",
"498756", "Nandlstadt",
"498349", "Stötten\ am\ Auerberg",
"494236", "Kirchlinteln",
"494875", "Stafstedt",
"494664", "Neukirchen\ bei\ Niebüll",
"494932", "Norderney",
"4938294", "Neubukow",
"494173", "Wulfsen",
"4937348", "Oberwiesenthal\ Kurort",
"496464", "Angelburg",
"498283", "Neuburg\ an\ der\ Kammel",
"495056", "Winsen\-Meissendorf",
"494735", "Butjadingen\-Stollhamm",
"492423", "Langerwehe",
"493592", "Kirschau",
"494545", "Seedorf\ Lauenburg",
"497306", "Vöhringen\ Iller",
"499089", "Bissingen\-Unterringingen",
"4936731", "Unterloquitz",
"4937322", "Brand\-Erbisdorf",
"495203", "Werther\ Westfalen",
"496229", "Neckarsteinach",
"499766", "Grosswenkheim",
"4933763", "Bestensee",
"4939858", "Bietikow",
"492375", "Balve",
"4937204", "Lichtenstein\ Sachsen",
"496833", "Rehlingen\-Siersburg",
"496135", "Bodenheim\ Rhein",
"497466", "Beuron",
"4935267", "Diesbar\-Seusslitz",
"496773", "Kamp\-Bornhofen",
"496181", "Hanau",
"4938722", "Raduhn",
"492521", "Beckum",
"499265", "Pressig",
"496304", "Wolfstein\ Pfalz",
"498446", "Pörnbach",
"496627", "Nentershausen\ Hessen",
"496337", "Grossbundenbach",
"496851", "St\ Wendel",
"4938371", "Karlshagen",
"497308", "Nersingen",
"495265", "Dörentrup",
"4938304", "Garz\ Rügen",
"498640", "Reit\ Im\ Winkl",
"496723", "Oestrich\-Winkel",
"493394", "Wittstock\ Dosse",
"497046", "Zaberfeld",
"498066", "Bad\ Feilnbach",
"496587", "Zerf",
"4938222", "Semlow",
"492571", "Greven\ Westfalen",
"497660", "St\ Peter\ Schwarzwald",
"4933926", "Herzberg\ Mark",
"496677", "Neuenstein\ Hessen",
"492764", "Welschen\ Ennest",
"492681", "Altenkirchen\ Westerwald",
"4935951", "Neukirch\ Lausitz",
"4933331", "Casekow",
"494477", "Lastrup\-Hemmelte",
"494238", "Neddenaverbergen",
"492325", "Wanne\-Eickel",
"492635", "Rheinbrohl",
"4934346", "Narsdorf",
"492841", "Moers",
"499203", "Neudrossenfeld",
"495766", "Rehburg\-Loccum",
"492301", "Holzwickede",
"496524", "Rodershausen",
"493735", "Marienberg\ Sachsen",
"497578", "Wald\ Hohenz",
"492563", "Stadtlohn",
"498868", "Schwabsoien",
"4936626", "Auma",
"4939346", "Tucheim",
"495199", "Schneverdingen\-Heber",
"495186", "Salzhemmendorf\-Wallensen",
"494977", "Blomberg\ Ostfriesland",
"493341", "Strausberg",
"496844", "Blieskastel\-Altheim",
"499186", "Lauterhofen\ Oberpfalz",
"499199", "Kunreuth",
"495159", "Coppenbrügge\-Bisperode",
"495247", "Harsewinkel",
"494484", "Hude\-Wüsting",
"499856", "Dürrwangen",
"494927", "Krummhörn\-Loquard",
"492505", "Altenberge\ Westfalen",
"494552", "Leezen",
"496761", "Simmern\ Hunsrück",
"496684", "Hofbieber\-Schwarzbach",
"4935693", "Lauschütz",
"496574", "Hasborn",
"4936940", "Oepfershausen",
"497262", "Eppingen",
"497528", "Neukirch\ bei\ Tettnang",
"497966", "Unterschneidheim",
"494432", "Dötlingen\-Brettorf",
"499340", "Königheim\-Brehmen",
"494161", "Buxtehude",
"4937321", "Frankenstein\ Sachsen",
"4936732", "Könitz",
"495858", "Hitzacker\-Wietzetze",
"498809", "Wessobrunn",
"49760", "Oberried\ Breisgau",
"4938721", "Ziegendorf",
"494394", "Bokhorst",
"497576", "Krauchenwies",
"4933087", "Bredereiche",
"492923", "Lippetal\-Herzfeld",
"4937438", "Bad\ Brambach",
"492041", "Bottrop",
"496322", "Bad\ Dürkheim",
"4933456", "Wriezen",
"4936607", "Niederpöllnitz",
"4938221", "Marlow",
"4933838", "Päwesin",
"492973", "Eslohe\ Sauerland",
"492132", "Meerbusch\-Büderich",
"4939293", "Dreileben",
"494354", "Fleckeby",
"498106", "Vaterstetten",
"4938372", "Usedom",
"49851", "Passau",
"496033", "Butzbach",
"492461", "Jülich",
"496372", "Bruchmühlbach\-Miesau",
"493984", "Prenzlau",
"4939826", "Blankensee\ bei\ Neustrelitz",
"499188", "Postbauer\-Heng",
"4933332", "Gartz\ Oder",
"4935952", "Grossröhrsdorf\ OL",
"496051", "Gelnhausen",
"497257", "Bruchsal\-Untergrombach",
"496024", "Schöllkrippen",
"496162", "Reinheim\ Odenwald",
"4934493", "Gössnitz\ Thüringen",
"4935056", "Altenberg\ Sachsen",
"496431", "Limburg\ an\ der\ Lahn",
"4936848", "Wernshausen",
"4934904", "Oranienbaum",
"494321", "Neumünster",
"4936695", "Söllmnitz",
"494631", "Glücksburg\ Ostsee",
"4939084", "Lindstedt",
"499936", "Wallerfing",
"4936072", "Weissenborn\-Lüderode",
"496485", "Nentershausen\ Westerwald",
"499232", "Wunsiedel",
"498379", "Waltenhofen\-Oberdorf",
"494845", "Ostenfeld\ Husum",
"493947", "Thale",
"496453", "Gemünden\ Wohra",
"4938787", "Glöwen",
"494143", "Drochtersen",
"494371", "Burg\ auf\ Fehmarn",
"4933742", "Oehna\ Brandenburg",
"496802", "Völklingen\-Lauterbach",
"498639", "Neumarkt\-Sankt\ Veit",
"495232", "Lage\ Lippe",
"495936", "Twist",
"496074", "Rödermark",
"498204", "Mickhausen",
"498237", "Aindling",
"4936964", "Dermbach\ Rhön",
"4935248", "Schönfeld\ bei\ Grossenhain",
"494757", "Wanna",
"492443", "Mechernich",
"494525", "Ahrensbök",
"492662", "Hachenburg",
"492934", "Sundern\-Altenhellefeld",
"494447", "Vechta\-Langförden",
"496157", "Pfungstadt",
"492753", "Erndtebrück",
"496591", "Gerolstein",
"496249", "Guntersblum",
"494903", "Wymeer",
"49971", "Bad\ Kissingen",
"495284", "Schwalenberg",
"4939959", "Dargun",
"492697", "Blankenheim\-Ahrhütte",
"496887", "Schmelz\ Saar",
"492871", "Bocholt",
"499938", "Moos\ Niederbayern",
"492982", "Medebach",
"496355", "Albisheim\ Pfrimm",
"498670", "Reischach\ Kreis\ Altötting",
"4936085", "Reinholterode",
"49741", "Rottweil",
"496383", "Glan\-Münchweiler",
"4937367", "Lengefeld\ Erzgebirge",
"492541", "Coesfeld",
"4933605", "Boossen",
"498426", "Walting\ Kreis\ Eichstätt",
"496647", "Herbstein\-Stockhausen",
"496743", "Bacharach",
"494965", "Surwold",
"498330", "Legau",
"497026", "Lenningen",
"493867", "Lübstorf",
"4938422", "Neukloster",
"4939972", "Walkendorf",
"496533", "Morbach\ Hunsrück",
"496395", "Münchweiler\ an\ der\ Rodalb",
"49571", "Minden\ Westfalen",
"499284", "Schwarzenbach\ an\ der\ Saale",
"492657", "Uersfeld",
"4935722", "Lauta\ bei\ Hoyerswerda",
"493501", "Pirna",
"492821", "Kleve\ Niederrhein",
"494762", "Kutenholz",
"496551", "Prüm",
"492406", "Herzogenrath",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"497323", "Gerstetten",
"497633", "Staufen\ im\ Breisgau",
"498161", "Freising",
"496059", "Jossgrund",
"497141", "Ludwigsburg\ Württemberg",
"4934208", "Löbnitz\ bei\ Delitzsch",
"498432", "Burgheim",
"4937462", "Rothenkirchen\ Vogtland",
"495437", "Menslage",
"495404", "Westerkappeln",
"495278", "Höxter\-Ovenhausen",
"4939002", "Oebisfelde",
"4938796", "Viesecke",
"4936081", "Arenshausen",
"497651", "Titisee\-Neustadt",
"4935362", "Schönewalde\ bei\ Herzberg",
"498394", "Lautrach",
"499228", "Thurnau",
"499562", "Sonnefeld",
"4933674", "Trebatsch",
"4933601", "Podelzig",
"494948", "Wiesmoor\-Marcardsmoor",
"4936423", "Orlamünde",
"4938327", "Elmenhorst\ Vorpom",
"49451", "Lübeck",
"494106", "Quickborn\ Kreis\ Pinneberg",
"495228", "Vlotho\-Exter",
"4938296", "Rerik\ Ostseebad",
"4934633", "Braunsbedra",
"495562", "Dassel\-Markoldendorf",
"498801", "Seeshaupt",
"499278", "Weidenberg",
"499404", "Nittendorf",
"492368", "Oer\-Erkenschwick",
"4933368", "Hohensaaten",
"497373", "Zwiefalten",
"4938823", "Selmsdorf",
"497032", "Herrenberg",
"4933875", "Rhinow",
"496086", "Grävenwiesbach",
"494169", "Sauensiek",
"497704", "Geisingen\ Baden",
"496205", "Hockenheim",
"499364", "Zellingen",
"498592", "Wegscheid\ Niederbayern",
"4937206", "Frankenberg\ Sachsen",
"495641", "Warburg",
"499922", "Zwiesel",
"498075", "Amerang",
"495276", "Marienmünster",
"497425", "Trossingen",
"4938847", "Boizenburg\ Elbe",
"4934975", "Görzig\ Kreis\ Köthen",
"495835", "Wahrenholz",
"4936691", "Eisenberg\ Thüringen",
"495775", "Diepenau",
"497084", "Schömberg\ bei\ Neuenbürg",
"499725", "Poppenhausen\ Unterfranken",
"492274", "Elsdorf\ Rheinland",
"492408", "Aachen\-Kornelimünster",
"496706", "Wallhausen\ Nahe",
"499191", "Forchheim\ Oberfranken",
"495151", "Hameln",
"496263", "Neckargerach",
"495191", "Soltau",
"499151", "Hersbruck",
"4933924", "Rägelin",
"495725", "Lindhorst\ bei\ Stadthagen",
"499775", "Schönau\ an\ der\ Brend",
"4933653", "Ziltendorf",
"4938306", "Samtens",
"492224", "Bad\ Honnef",
"492366", "Herten\ Westfalen",
"4934344", "Kohren\-Sahlis",
"499835", "Ehingen\ Mittelfranken",
"498025", "Miesbach",
"499133", "Baiersdorf\ Mittelfranken",
"499972", "Waldmünchen",
"492309", "Waltrop",
"499276", "Bischofsgrün",
"494108", "Rosengarten\ Kreis\ Harburg",
"497475", "Burladingen",
"495226", "Bruchmühlen\ Westfalen",
"494242", "Syke",
"499641", "Grafenwöhr",
"495922", "Bad\ Bentheim",
"493448", "Meuselwitz\ Thüringen",
"495364", "Velpke",
"494946", "Grossefehn\-Bagband",
"498552", "Grafenau\ Niederbayern",
"497467", "Neuhausen\ ob\ Eck",
"4938733", "Karbow\-Vietlübbe",
"492233", "Hürth\ Rheinland",
"497382", "Römerstein",
"4937325", "Niederbobritzsch",
"496559", "Leidenborn",
"499605", "Weiherhammer",
"496626", "Wildeck\-Obersuhl",
"496336", "Dellfeld",
"493928", "Schönebeck\ Elbe",
"495442", "Barnstorf\ Kreis\ Diepholz",
"4935433", "Vetschau",
"492251", "Euskirchen",
"4938725", "Gross\ Godems",
"494426", "Wangerland\-Horumersiel",
"495174", "Lahstedt",
"495663", "Spangenberg",
"4938225", "Trinwillershagen",
"4936043", "Kirchheilingen",
"4936373", "Buttstädt",
"4939927", "Nossentiner\ Hütte",
"495062", "Holle\ bei\ Hildesheim",
"492739", "Wilnsdorf",
"497945", "Wüstenrot",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"499174", "Hilpoltstein",
"494330", "Emkendorf",
"495767", "Warmsen",
"499442", "Riedenburg",
"492291", "Waldbröl",
"4938233", "Prerow\ Ostseebad",
"49381", "Rostock",
"498762", "Wartenberg\ Oberbayern",
"4933437", "Reichenberg\ bei\ Strausberg",
"496241", "Worms",
"497532", "Meersburg",
"496599", "Weidenbach\ bei\ Gerolstein",
"495605", "Kaufungen\ Hessen",
"496420", "Lahntal",
"498067", "Tuntenhausen",
"496586", "Beuren\ Hochwald",
"49355", "Cottbus",
"496676", "Hohenroda\ Hessen",
"497742", "Klettgau",
"498092", "Grafing\ bei\ München",
"497452", "Nagold",
"4933200", "Bergholz\-Rehbrücke",
"498685", "Kirchanschöring",
"499955", "Mamming",
"498143", "Inning\ am\ Ammersee",
"496628", "Oberaula",
"498845", "Bad\ Kohlgrub",
"496338", "Hornbach\ Pfalz",
"492770", "Eschenburg",
"497584", "Altshausen",
"4936027", "Lengenfeld\ Unterm\ Stein",
"497674", "Todtmoos",
"498631", "Mühldorf\ am\ Inn",
"498321", "Sonthofen",
"497163", "Ebersbach\ an\ der\ Fils",
"499097", "Marxheim",
"496678", "Wildeck\-Hönebach",
"496588", "Pluwig",
"494329", "Langwedel\ Holstein",
"4939408", "Hadmersleben",
"494639", "Schafflund",
"495752", "Auetal\-Hattendorf",
"497334", "Deggingen",
"497624", "Grenzach\-Wyhlen",
"497307", "Senden\ Iller",
"495955", "Esterwegen",
"4939389", "Schollene",
"494204", "Thedinghausen",
"494237", "Bendingbostel",
"496439", "Holzappel",
"497803", "Gengenbach",
"493976", "Torgelow\ bei\ Ueckermünde",
"498052", "Aschau\ im\ Chiemgau",
"494478", "Cappeln\ Oldenburg",};
$areanames{de} = {"4935726", "Groß\ Särchen",
"4939976", "Groß\ Bützin",
"499636", "Plößberg",
"493647", "Pößneck",
"495384", "Seesen\-Groß\ Rhüden",
"4934901", "Roßlau\ Elbe",
"496321", "Neustadt\ an\ der\ Weinstraße",
"49911", "Nürnberg",
"49221", "Köln",
"494684", "Langeneß\ Hallig",
"4935938", "Großpostwitz\ OL",
"498633", "Tüßling",
"4938234", "Born\ Darß",
"4939883", "Groß\ Dölln",
"498536", "Kößlarn",
"495827", "Unterlüß",
"4939934", "Groß\ Plasten",
"499141", "Weißenburg\ in\ Bayern",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"498170", "Straßlach\-Dingharting",
"4936484", "Knau\ bei\ Pößneck",
"494497", "Barßel\-Harkebrügge",
"496663", "Steinau\ an\ der\ Straße",
"496364", "Nußbach\ Pfalz",
"498807", "Dießen\ am\ Ammersee",
"4935753", "Großräschen",
"4989", "München",
"4934445", "Stößen",
"4935240", "Tauscha\ bei\ Großenhain",
"496252", "Heppenheim\ Bergstraße",
"495053", "Faßberg\-Müden",
"498367", "Roßhaupten\ Forggensee",
"495064", "Groß\ Düngen",
"497351", "Biberach\ an\ der\ Riß",
"494483", "Ovelgönne\-Großenmeer",
"4935841", "Großschönau\ Sachsen",
"499242", "Gößweinstein",
"499567", "Seßlach\-Gemünda",
"4934493", "Gößnitz\ Thüringen",
"4936072", "Weißenborn\-Lüderode",
"4935248", "Schönfeld\ bei\ Großenhain",
"4935952", "Großröhrsdorf\ OL",
"4936949", "Obermaßfeld\-Grimmenthal",
"494509", "Groß\ Grönau",
"492339", "Sprockhövel\-Haßlinghausen",
"492203", "Köln\-Porz",
"499656", "Moosbach\ bei\ Vohenstrauß",
"497162", "Süßen",
"497355", "Hochdorf\ Riß",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;