/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import java.io.IOException;
import sun.io.Markable;

public class MarkableReader {
    private byte[] markedBytes;
    private int marker = -1;
    private int markedLimit = -1;
    private int markedRead = 0;
    private Markable is;

    public MarkableReader(Markable markable) {
        this.is = markable;
    }

    private void clearPosition() {
        this.marker = -1;
        this.markedLimit = -1;
        this.markedBytes = null;
        this.markedRead = 0;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 == 0) {
            return 0;
        }
        if (this.markedLimit == 0 || this.markedRead == this.markedLimit && this.marker == this.markedLimit) {
            this.clearPosition();
        }
        if (this.markedLimit <= 0) {
            n3 = this.is.readNative(byArray, n, n2);
        } else if (this.marker >= 0 && this.marker < this.markedRead) {
            n3 = this.marker + n2 > this.markedRead ? this.markedRead - this.marker : n2;
            System.arraycopy(this.markedBytes, this.marker, byArray, n, n3);
        } else {
            n3 = this.markedRead + n2 > this.markedLimit ? this.markedLimit - this.markedRead : n2;
            n3 = this.is.readNative(byArray, n, n3);
            System.arraycopy(byArray, n, this.markedBytes, this.markedRead, n3);
            this.markedRead += n3;
        }
        if (this.marker >= 0) {
            this.marker += n3;
        }
        return n3;
    }

    public synchronized void mark(int n) {
        if (n <= 0) {
            return;
        }
        int n2 = 0;
        byte[] byArray = this.markedBytes;
        this.markedBytes = new byte[n];
        if (this.marker >= 0) {
            if (this.marker + n < this.markedRead) {
                n = this.markedRead - this.marker;
            }
            n2 = this.markedRead - this.marker;
            System.arraycopy(byArray, this.marker, this.markedBytes, 0, n2);
            this.marker = 0;
        }
        this.markedRead = n2;
        this.markedLimit = n;
    }

    public synchronized void reset() throws IOException {
        if (this.markedLimit < 0) {
            throw new IOException("Position was not marked");
        }
        this.marker = 0;
    }

    public boolean markSupported() {
        return true;
    }
}

