/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.logging.Level;

class SQLServerConnectionPoolProxy
implements Connection,
Serializable {
    private SQLServerConnection wrappedConnection;
    private boolean bIsOpen;
    private static int baseConnectionID = 0;
    private int proxyConnectionID = SQLServerConnectionPoolProxy.nextConnectionID();

    private static synchronized int nextConnectionID() {
        return ++baseConnectionID;
    }

    String toLogString() {
        String string = " ProxyConnectionID:" + this.proxyConnectionID;
        return string;
    }

    SQLServerConnectionPoolProxy(SQLServerConnection sQLServerConnection) {
        this.wrappedConnection = sQLServerConnection;
        sQLServerConnection.setAssociatedProxy(this);
        this.bIsOpen = true;
    }

    void checkClosed() throws SQLServerException {
        if (!this.bIsOpen) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_connectionIsClosed"), null, false);
        }
    }

    public Statement createStatement() throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.createStatement();
    }

    public PreparedStatement prepareStatement(String string) throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.prepareStatement(string);
    }

    public CallableStatement prepareCall(String string) throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.prepareCall(string);
    }

    public String nativeSQL(String string) throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.nativeSQL(string);
    }

    public void setAutoCommit(boolean bl) throws SQLServerException {
        this.checkClosed();
        this.wrappedConnection.setAutoCommit(bl);
    }

    public boolean getAutoCommit() throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.getAutoCommit();
    }

    public void commit() throws SQLServerException {
        this.checkClosed();
        this.wrappedConnection.commit();
    }

    public void rollback() throws SQLServerException {
        this.checkClosed();
        this.wrappedConnection.rollback();
    }

    public void close() throws SQLServerException {
        if (this.bIsOpen && null != this.wrappedConnection) {
            if (this.wrappedConnection.getConnectionLogger().isLoggable(Level.FINE)) {
                this.wrappedConnection.getConnectionLogger().fine(this.toLogString() + " Connection proxy closed ");
            }
            this.wrappedConnection.poolCloseEventNotify();
            this.wrappedConnection = null;
        }
        this.bIsOpen = false;
    }

    void internalClose() {
        this.bIsOpen = false;
        this.wrappedConnection = null;
    }

    public boolean isClosed() throws SQLServerException {
        return !this.bIsOpen;
    }

    public DatabaseMetaData getMetaData() throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.getMetaData();
    }

    public void setReadOnly(boolean bl) throws SQLServerException {
        this.checkClosed();
        this.wrappedConnection.setReadOnly(bl);
    }

    public boolean isReadOnly() throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.isReadOnly();
    }

    public void setCatalog(String string) throws SQLServerException {
        this.checkClosed();
        this.wrappedConnection.setCatalog(string);
    }

    public String getCatalog() throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.getCatalog();
    }

    public void setTransactionIsolation(int n) throws SQLServerException {
        this.checkClosed();
        this.wrappedConnection.setTransactionIsolation(n);
    }

    public int getTransactionIsolation() throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.getWarnings();
    }

    public void clearWarnings() throws SQLServerException {
        this.checkClosed();
        this.wrappedConnection.clearWarnings();
    }

    public Statement createStatement(int n, int n2) throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.createStatement(n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.prepareStatement(string, n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.prepareCall(string, n, n2);
    }

    public void setTypeMap(Map map) throws SQLServerException {
        this.checkClosed();
        this.wrappedConnection.setTypeMap(map);
    }

    public Map getTypeMap() throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.getTypeMap();
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.createStatement(n, n2, n3);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.prepareStatement(string, n, n2, n3);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.prepareCall(string, n, n2, n3);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.prepareStatement(string, n);
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.prepareStatement(string, nArray);
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.prepareStatement(string, stringArray);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLServerException {
        this.checkClosed();
        this.wrappedConnection.releaseSavepoint(savepoint);
    }

    public Savepoint setSavepoint(String string) throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.setSavepoint(string);
    }

    public Savepoint setSavepoint() throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.setSavepoint();
    }

    public void rollback(Savepoint savepoint) throws SQLServerException {
        this.checkClosed();
        this.wrappedConnection.rollback(savepoint);
    }

    public int getHoldability() throws SQLServerException {
        this.checkClosed();
        return this.wrappedConnection.getHoldability();
    }

    public void setHoldability(int n) throws SQLServerException {
        this.checkClosed();
        this.wrappedConnection.setHoldability(n);
    }
}

