/*
* JBoss, Home of Professional Open Source
* Copyright 2007, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.managed.factory.support.amof;

import java.io.Serializable;

import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ManagementRuntimeRef;

/**
 * A ManagementObject with a ManagementRuntimeRef
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 1.1 $
 */
@ManagementObject
public class ManagementObjectWithRuntimeRef implements Serializable
{
   /** The serialVersionUID */
   private static final long serialVersionUID = -1L;
   private CustomName refName;

   @ManagementRuntimeRef(transformer=CustomRuntimeComponentNameTransformer.class)
   @ManagementProperty(description="A property referencing a runtime object")
   public CustomName getRefName()
   {
      return refName;
   }
   public void setRefName(CustomName refName)
   {
      this.refName = refName;
   }
}
