/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.lock;

import java.util.concurrent.locks.Lock;

/**
 * Interface to specify lock strategy, e.g., for different isolation levels.
 *
 * @author Ben Wang
 */
public interface LockStrategy
{
   /**
    * Return a read lock object.
    */
   Lock readLock();


   /**
    * Return a write lock object.
    */
   Lock writeLock();

   /**
    * Attempt to upgrade the current read lock to write lock with
    * <code>msecs</code> timeout.
    *
    * @param msecs Timeout in milliseconds.
    * @return Lock object. Will return null if timeout or failed.
    */
   Lock upgradeLockAttempt(long msecs) throws UpgradeException;
}
