package org.jboss.cache.commands.tx;

import org.jboss.cache.InvocationContext;
import org.jboss.cache.commands.Visitor;
import org.jboss.cache.transaction.GlobalTransaction;

/**
 * The rollback phase of a 2-phase commit.
 *
 * @author Mircea.Markus@jboss.com
 * @since 2.2
 */
public class RollbackCommand extends AbstractTransactionCommand
{
   public static final int METHOD_ID = 12;

   public RollbackCommand(GlobalTransaction globalTransaction)
   {
      this.globalTransaction = globalTransaction;
   }

   public RollbackCommand()
   {
   }

   public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable
   {
      return visitor.visitRollbackCommand(ctx, this);
   }

   public int getCommandId()
   {
      return METHOD_ID;
   }
}
