#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.19';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CNTH',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoG5XII',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoR6',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData10',
	'Image::ExifTool::Canon::ColorData11',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::LogInfo',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::RawBurstInfo',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::Canon::WBInfo',
	'Image::ExifTool::Canon::uuid',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::ColorSpec',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type5',
	'Image::ExifTool::Kodak::Type6',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Microsoft::Xtra',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFInfo2V0400',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::AutoCaptureInfo',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::BracketingInfoD500',
	'Image::ExifTool::Nikon::BracketingInfoD810',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::ColorBalanceUnknown2',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::FlashInfo0300',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::HDRInfo2',
	'Image::ExifTool::Nikon::ISOAutoInfoD810',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::IntervalInfoD6',
	'Image::ExifTool::Nikon::IntervalInfoZ7II',
	'Image::ExifTool::Nikon::JPGInfoD500',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MakerNotes0x51',
	'Image::ExifTool::Nikon::MakerNotes0x56',
	'Image::ExifTool::Nikon::MenuSettingsD850',
	'Image::ExifTool::Nikon::MenuSettingsZ7II',
	'Image::ExifTool::Nikon::MenuSettingsZ8',
	'Image::ExifTool::Nikon::MenuSettingsZ9',
	'Image::ExifTool::Nikon::MenuSettingsZ9v3',
	'Image::ExifTool::Nikon::MenuSettingsZ9v4',
	'Image::ExifTool::Nikon::MoreSettingsD850',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::MultiExposure2',
	'Image::ExifTool::Nikon::Offset13InfoZ9',
	'Image::ExifTool::Nikon::OrientationInfo',
	'Image::ExifTool::Nikon::OtherInfoD500',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PortraitInfoZ7II',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::RotationInfoD500',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::SeqInfoD6',
	'Image::ExifTool::Nikon::SeqInfoZ9',
	'Image::ExifTool::Nikon::SettingsInfoD810',
	'Image::ExifTool::Nikon::ShootingMenuD500',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::NikonCustom::SettingsZ8',
	'Image::ExifTool::NikonCustom::SettingsZ9',
	'Image::ExifTool::NikonCustom::SettingsZ9v4',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::ItemList',
	'Image::ExifTool::QuickTime::ItemPropCont',
	'Image::ExifTool::QuickTime::Keys',
	'Image::ExifTool::QuickTime::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::QuickTime::UserData',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Reconyx::Type3',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sigma::WBSettings',
	'Image::ExifTool::Sigma::WBSettings2',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::SR2SubIFD',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9050c',
	'Image::ExifTool::Sony::Tag9050d',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag9406b',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Device',
	'Image::ExifTool::XMP::ExifTool',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GCamera',
	'Image::ExifTool::XMP::GCreations',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crd',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::hdr',
	'Image::ExifTool::XMP::hdrgm',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::panorama',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 112 => 0x69 },
	'about' => { 528 => 'about' },
	'aboutcvterm' => { 519 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 519 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 519 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 519 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 519 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 119 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 534 => 'absPeakAudioFilePath' },
	'academicfield' => { 524 => 'academicField' },
	'acceleration' => { 122 => 0x9404, 512 => 'Acceleration' },
	'accelerationtracking' => { 87 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 414 => 0x3 },
	'accelerometerdata' => { 404 => 'vrot' },
	'accelerometerx' => { 344 => 0x8d },
	'accelerometery' => { 344 => 0x8e },
	'accelerometerz' => { 344 => 0x8c },
	'accessoryserialnumber' => { 344 => 0x54 },
	'accessorytype' => { 344 => 0x53 },
	'actionadvised' => { 134 => 0x2a },
	'activearea' => { 122 => 0xc68d },
	'actived-lighting' => { 238 => 0x22, 292 => 0x24 },
	'actived-lightingmode' => { 292 => 0x25 },
	'adaptervoltage' => { 141 => 0x407 },
	'addaspectratioinfo' => { 87 => 0x80e },
	'addiptcinformation' => { 87 => 0x815 },
	'additionalmodelinformation' => { 519 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 87 => 0x80f, 88 => 0x11, 89 => 0x13, 92 => 0x14 },
	'address' => { 164 => 'Address' },
	'adjustmentmode' => { 421 => 0x15 },
	'adlbracketingstep' => { 201 => 0x17 },
	'adlbracketingtype' => { 201 => 0x18 },
	'adobe' => { 123 => 'Adobe' },
	'adultcontentwarning' => { 331 => 'AdultContentWarning', 527 => 'adultContentWarning' },
	'advancedfilter' => { 130 => 0x1201 },
	'advancedraw' => { 294 => 0x76a43203 },
	'advancedscenetype' => { 344 => 0x3d },
	'advisory' => { 532 => 'Advisory' },
	'ae_iso' => { 352 => 0x2, 353 => 0x4, 354 => 0x12 },
	'aeaperture' => { 352 => 0x1, 353 => 0x3, 354 => 0x11 },
	'aeaperturesteps' => { 352 => 0x8, 353 => 0xb },
	'aeaverage' => { 1 => 0x6 },
	'aebautocancel' => { 87 => 0x104 },
	'aebbracketvalue' => { 79 => 0x11 },
	'aebracketingsteps' => { 201 => 0xf, 202 => 0xf, 275 => 0x174c },
	'aebsequence' => { 87 => 0x105 },
	'aebsequenceautocancel' => { 85 => 0x9, 86 => 0x9, 88 => 0x8, 89 => 0x9, 92 => 0x9, 93 => 0x7 },
	'aebshotcount' => { 87 => 0x106 },
	'aebxv' => { 352 => 0x4, 353 => 0x6 },
	'aeerror' => { 353 => 0x8 },
	'aeexposuretime' => { 352 => 0x0, 353 => 0x2, 354 => 0x10 },
	'aelbutton' => { 187 => 0x45 },
	'aelexposureindicator' => { 187 => 0x51 },
	'aelock' => { 187 => 0x5b, 303 => '4.2', 312 => '4.2', 321 => 0x201, 379 => 0x48, 431 => 0x40, 432 => 0x40, 433 => [0x86,0x286] },
	'aelockbutton' => { 301 => '16.1', 303 => '4.1', 306 => '15.1', 307 => '16.1', 308 => '16.1', 310 => '30.1', 311 => '16.1', 312 => '4.1', 314 => '17.1', 316 => '17.1' },
	'aelockbuttonplusdials' => { 301 => '16.2', 310 => '32.1', 314 => '44.1' },
	'aelockformb-d80' => { 316 => '3.1' },
	'aelockmetermodeafterfocus' => { 87 => 0x114 },
	'aematrix' => { 1 => 0x2 },
	'aemaxaperture' => { 352 => 0x9, 353 => 0x10, 354 => 0x1c },
	'aemaxaperture2' => { 352 => 0xa, 353 => 0x11, 354 => 0x1d },
	'aemeteringmode' => { 352 => 0xc },
	'aemeteringmode2' => { 352 => '13.1' },
	'aemeteringsegments' => { 190 => 0x628, 379 => 0x209 },
	'aemicroadjustment' => { 87 => 0x110 },
	'aeminaperture' => { 352 => 0xb, 353 => 0x12, 354 => 0x1e },
	'aeminexposuretime' => { 352 => 0x5, 353 => 0x13, 354 => 0x1f },
	'aeprogrammode' => { 352 => 0x6 },
	'aeprojectlink' => { 506 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 506 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 506 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 506 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 506 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 506 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 36 => 0x21 },
	'aestable' => { 1 => 0x4 },
	'aetarget' => { 1 => 0x5 },
	'aewhitebalance' => { 352 => 0xd },
	'aexv' => { 352 => 0x3, 353 => 0x5 },
	'af-assistilluminator' => { 317 => 0x19, 318 => 0x19, 319 => 0x19 },
	'af-cfocusdisplay' => { 317 => 0x234, 318 => 0x234, 319 => 0x24c },
	'af-cpriority' => { 131 => '0.2' },
	'af-cpriorityselection' => { 301 => '1.1', 302 => '1.1', 304 => '1.1', 305 => '1.1', 307 => '0.1', 308 => '0.1', 309 => '0.1', 310 => '1.1', 311 => '0.1', 314 => '1.1', 315 => '1.1', 317 => 0x3, 318 => 0x3, 319 => 0x3 },
	'af-csetting' => { 127 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 127 => '0.2' },
	'af-ctrackingsensitivity' => { 127 => '0.1' },
	'af-czoneareaswitching' => { 127 => '0.3' },
	'af-onbutton' => { 304 => '70.1', 305 => '70.1', 315 => '70.1' },
	'af-onformb-d10' => { 301 => '3.3', 310 => '3.2' },
	'af-onformb-d11' => { 311 => '2.2' },
	'af-onformb-d12' => { 314 => '50.1' },
	'af-onoutoffocusrelease' => { 317 => 0x10, 318 => 0x10, 319 => 0x10 },
	'af-spriority' => { 131 => '0.1' },
	'af-spriorityselection' => { 301 => '1.2', 302 => '1.2', 304 => '1.2', 305 => '1.2', 309 => '0.2', 310 => '1.2', 311 => '0.2', 314 => '1.2', 315 => '1.2', 317 => 0x5, 318 => 0x5, 319 => 0x5 },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 301 => '2.1', 302 => '2.1', 304 => '78.3', 305 => '78.3', 310 => '2.1', 314 => '2.1', 315 => '78.3', 317 => 0xf, 318 => 0xf, 319 => 0xf },
	'afadjustment' => { 379 => 0x72, 388 => 0x267 },
	'afandmeteringbuttons' => { 87 => 0x701 },
	'afaperture' => { 231 => 0x5, 232 => 0x5, 236 => 0x5 },
	'afareaheight' => { 196 => [0x1a,0x34,0x50], 197 => 0x48 },
	'afareaillumination' => { 187 => 0x4b, 312 => '15.3' },
	'afareainitialheight' => { 250 => 0xbeb },
	'afareainitialwidth' => { 250 => 0xbea },
	'afareainitialxposition' => { 250 => 0xbe8 },
	'afareainitialyposition' => { 250 => 0xbe9 },
	'afareamode' => { 129 => '0.3', 183 => 0x33, 187 => 0xe, 195 => 0x0, 196 => 0x5, 197 => 0x5, 243 => 0x224, 244 => 0x210, 245 => 0x224, 246 => 0x224, 344 => 0xf, 411 => 0x1205, 424 => [0xa,0x3a], 431 => 0x11, 432 => 0x10, 433 => 0x24, 444 => 0xb043, 470 => 0x17 },
	'afareamodesetting' => { 303 => '11.1', 306 => '0.1', 312 => '16.1', 316 => '2.1', 444 => 0x201c },
	'afareapointsize' => { 129 => '0.4' },
	'afareas' => { 321 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 87 => 0x51b },
	'afareawidth' => { 196 => [0x18,0x32,0x4e], 197 => 0x46 },
	'afareaxposition' => { 196 => [0x14,0x2e,0x4a], 197 => 0x42, 411 => 0x1203 },
	'afareaxposition1' => { 411 => 0x1201 },
	'afareayposition' => { 196 => [0x16,0x30,0x4c], 197 => 0x44, 411 => 0x1204 },
	'afareayposition1' => { 411 => 0x1202 },
	'afareazonesize' => { 129 => '0.5' },
	'afassist' => { 85 => 0x5, 93 => 0x5, 187 => 0x48, 301 => '2.5', 303 => '0.2', 306 => '0.2', 307 => '1.1', 308 => '1.1', 309 => '1.3', 310 => '2.4', 311 => '1.3', 312 => '0.2', 314 => '2.4', 316 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 87 => 0x50e, 88 => 0x4, 89 => 0x5, 90 => 0x4, 91 => 0x4, 92 => 0x5 },
	'afassistlamp' => { 344 => 0x31 },
	'afbuttonpressed' => { 433 => [0x83,0x283] },
	'afconfidence' => { 1 => 0x3d },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 355 => 0x6 },
	'afduringliveview' => { 87 => 0x511 },
	'affinea' => { 499 => 'AffineA' },
	'affineb' => { 499 => 'AffineB' },
	'affinec' => { 499 => 'AffineC' },
	'affined' => { 499 => 'AffineD' },
	'affinetune' => { 198 => 0x0, 243 => 0x6b0, 244 => 0x5b0, 245 => 0x5e0, 246 => 0x5f8, 321 => 0x306 },
	'affinetuneadj' => { 198 => 0x2, 268 => 0x2d1, 269 => 0x2dc, 321 => 0x307 },
	'affinetuneadjtele' => { 198 => 0x3 },
	'affinetuneindex' => { 198 => 0x1 },
	'affinex' => { 499 => 'AffineX' },
	'affiney' => { 499 => 'AffineY' },
	'afhold' => { 355 => 0x1fd },
	'afilluminator' => { 431 => 0x29, 444 => 0xb044 },
	'afimageheight' => { 196 => [0x12,0x2c,0x48], 197 => 0x40 },
	'afimagewidth' => { 196 => [0x10,0x2a,0x46], 197 => 0x3e },
	'afintegrationtime' => { 355 => 0x7 },
	'afmeasureddepth' => { 1 => 0x38 },
	'afmicroadj' => { 424 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 428 => 0x131 },
	'afmicroadjregisteredlenses' => { 428 => '305.1' },
	'afmicroadjustment' => { 87 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 428 => 0x130 },
	'afmode' => { 116 => 0x3009, 130 => 0x1022, 183 => 0x16, 421 => 0x5 },
	'afmoderestrictions' => { 302 => '50.3', 304 => '48.3', 305 => '48.3', 314 => '48.3', 315 => '48.3' },
	'afonaelockbuttonswitch' => { 87 => 0x702 },
	'afonbutton' => { 301 => '3.1', 302 => '47.1', 317 => 0x83, 318 => 0x83, 319 => 0x83 },
	'afpoint' => { 36 => 0x13, 115 => 0x18, 183 => 0x15, 195 => 0x1, 324 => 0x308, 421 => 0x1f, 424 => [0x37,0x7], 428 => 0x19, 429 => 0x18, 430 => [0x18,0x20] },
	'afpointactivationarea' => { 86 => 0x11, 92 => 0x11 },
	'afpointareaexpansion' => { 87 => 0x508 },
	'afpointatshutterrelease' => { 424 => [0x39,0x9] },
	'afpointautoselection' => { 87 => 0x50b },
	'afpointbrightness' => { 87 => 0x50d, 301 => '2.4', 302 => '46.5', 304 => '2.2', 305 => '2.2', 314 => '2.3', 315 => '2.2' },
	'afpointdetails' => { 324 => 0x31b },
	'afpointdisplayduringfocus' => { 2 => 0x10, 87 => 0x50c },
	'afpointillumination' => { 86 => 0xa, 301 => '2.3', 302 => '46.2', 304 => '47.2', 305 => '47.2', 309 => '1.2', 310 => '2.3', 311 => '1.2', 314 => '47.2', 315 => '47.2', 316 => '2.4' },
	'afpointinfocus' => { 424 => [0x38,0x8] },
	'afpointmode' => { 360 => 0x3 },
	'afpointposition' => { 116 => 0x2021, 344 => 0x4d },
	'afpointregistration' => { 85 => 0x7 },
	'afpoints' => { 186 => 0x10 },
	'afpointsel' => { 317 => 0xb, 318 => 0xb, 319 => 0xb },
	'afpointselected' => { 187 => 0xd, 321 => 0x305, 379 => 0xe, 428 => 0x15, 429 => 0x14, 430 => [0x14,0x1c], 444 => 0x201e },
	'afpointselected2' => { 360 => 0x4 },
	'afpointselection' => { 86 => 0xb, 301 => '1.3', 302 => '1.3', 310 => '1.3', 314 => '1.3', 315 => '1.3' },
	'afpointselectionmethod' => { 87 => 0x50f, 88 => 0xc, 89 => 0xd, 92 => 0xd },
	'afpointsetting' => { 431 => 0x12, 432 => 0x11 },
	'afpointsinfocus' => { 79 => 0xe, 195 => 0x2, 196 => 0x30, 355 => 0xb, 356 => 0x4, 379 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 19 => 0x38 },
	'afpointspotmetering' => { 86 => 0xd },
	'afpointsselected' => { 196 => 0x1c, 356 => '4.1', 479 => 0x4 },
	'afpointsspecial' => { 356 => '4.2' },
	'afpointsunknown1' => { 355 => 0x0 },
	'afpointsunknown2' => { 355 => 0x2 },
	'afpointsused' => { 196 => [0xa,0x8], 197 => 0xa, 424 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 355 => 0x4 },
	'afresponse' => { 238 => 0xad },
	'afresult' => { 326 => 0x1038 },
	'afsearch' => { 321 => 0x303 },
	'afsensoractive' => { 183 => 0x1 },
	'afstable' => { 1 => 0x7 },
	'afstatus' => { 411 => 0x1200 },
	'afstatus_00_b4' => { 427 => 0x0 },
	'afstatus_01_c4' => { 427 => 0x2 },
	'afstatus_02_d4' => { 427 => 0x4 },
	'afstatus_03_e4' => { 427 => 0x6 },
	'afstatus_04_f4' => { 427 => 0x8 },
	'afstatus_05_g4' => { 427 => 0xa },
	'afstatus_06_h4' => { 427 => 0xc },
	'afstatus_07_b3' => { 427 => 0xe },
	'afstatus_08_c3' => { 427 => 0x10 },
	'afstatus_09_d3' => { 427 => 0x12 },
	'afstatus_10_e3' => { 427 => 0x14 },
	'afstatus_11_f3' => { 427 => 0x16 },
	'afstatus_12_g3' => { 427 => 0x18 },
	'afstatus_13_h3' => { 427 => 0x1a },
	'afstatus_14_b2' => { 427 => 0x1c },
	'afstatus_15_c2' => { 427 => 0x1e },
	'afstatus_16_d2' => { 427 => 0x20 },
	'afstatus_17_e2' => { 427 => 0x22 },
	'afstatus_18_f2' => { 427 => 0x24 },
	'afstatus_19_g2' => { 427 => 0x26 },
	'afstatus_20_h2' => { 427 => 0x28 },
	'afstatus_21_c1' => { 427 => 0x2a },
	'afstatus_22_d1' => { 427 => 0x2c },
	'afstatus_23_e1' => { 427 => 0x2e },
	'afstatus_24_f1' => { 427 => 0x30 },
	'afstatus_25_g1' => { 427 => 0x32 },
	'afstatus_26_a7_vertical' => { 427 => 0x34 },
	'afstatus_27_a6_vertical' => { 427 => 0x36 },
	'afstatus_28_a5_vertical' => { 427 => 0x38 },
	'afstatus_29_c7_vertical' => { 427 => 0x3a },
	'afstatus_30_c6_vertical' => { 427 => 0x3c },
	'afstatus_31_c5_vertical' => { 427 => 0x3e },
	'afstatus_32_e7_vertical' => { 427 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 427 => 0x42 },
	'afstatus_34_e5_vertical' => { 427 => 0x44 },
	'afstatus_35_g7_vertical' => { 427 => 0x46 },
	'afstatus_36_g6_vertical' => { 427 => 0x48 },
	'afstatus_37_g5_vertical' => { 427 => 0x4a },
	'afstatus_38_i7_vertical' => { 427 => 0x4c },
	'afstatus_39_i6_vertical' => { 427 => 0x4e },
	'afstatus_40_i5_vertical' => { 427 => 0x50 },
	'afstatus_41_a7' => { 427 => 0x52 },
	'afstatus_42_b7' => { 427 => 0x54 },
	'afstatus_43_c7' => { 427 => 0x56 },
	'afstatus_44_d7' => { 427 => 0x58 },
	'afstatus_45_e7' => { 427 => 0x5a },
	'afstatus_46_f7' => { 427 => 0x5c },
	'afstatus_47_g7' => { 427 => 0x5e },
	'afstatus_48_h7' => { 427 => 0x60 },
	'afstatus_49_i7' => { 427 => 0x62 },
	'afstatus_50_a6' => { 427 => 0x64 },
	'afstatus_51_b6' => { 427 => 0x66 },
	'afstatus_52_c6' => { 427 => 0x68 },
	'afstatus_53_d6' => { 427 => 0x6a },
	'afstatus_54_e6_center' => { 427 => 0x6c },
	'afstatus_55_f6' => { 427 => 0x6e },
	'afstatus_56_g6' => { 427 => 0x70 },
	'afstatus_57_h6' => { 427 => 0x72 },
	'afstatus_58_i6' => { 427 => 0x74 },
	'afstatus_59_a5' => { 427 => 0x76 },
	'afstatus_60_b5' => { 427 => 0x78 },
	'afstatus_61_c5' => { 427 => 0x7a },
	'afstatus_62_d5' => { 427 => 0x7c },
	'afstatus_63_e5' => { 427 => 0x7e },
	'afstatus_64_f5' => { 427 => 0x80 },
	'afstatus_65_g5' => { 427 => 0x82 },
	'afstatus_66_h5' => { 427 => 0x84 },
	'afstatus_67_i5' => { 427 => 0x86 },
	'afstatus_68_c11' => { 427 => 0x88 },
	'afstatus_69_d11' => { 427 => 0x8a },
	'afstatus_70_e11' => { 427 => 0x8c },
	'afstatus_71_f11' => { 427 => 0x8e },
	'afstatus_72_g11' => { 427 => 0x90 },
	'afstatus_73_b10' => { 427 => 0x92 },
	'afstatus_74_c10' => { 427 => 0x94 },
	'afstatus_75_d10' => { 427 => 0x96 },
	'afstatus_76_e10' => { 427 => 0x98 },
	'afstatus_77_f10' => { 427 => 0x9a },
	'afstatus_78_g10' => { 427 => 0x9c },
	'afstatus_79_h10' => { 427 => 0x9e },
	'afstatus_80_b9' => { 427 => 0xa0 },
	'afstatus_81_c9' => { 427 => 0xa2 },
	'afstatus_82_d9' => { 427 => 0xa4 },
	'afstatus_83_e9' => { 427 => 0xa6 },
	'afstatus_84_f9' => { 427 => 0xa8 },
	'afstatus_85_g9' => { 427 => 0xaa },
	'afstatus_86_h9' => { 427 => 0xac },
	'afstatus_87_b8' => { 427 => 0xae },
	'afstatus_88_c8' => { 427 => 0xb0 },
	'afstatus_89_d8' => { 427 => 0xb2 },
	'afstatus_90_e8' => { 427 => 0xb4 },
	'afstatus_91_f8' => { 427 => 0xb6 },
	'afstatus_92_g8' => { 427 => 0xb8 },
	'afstatus_93_h8' => { 427 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 427 => 0xbc },
	'afstatusactivesensor' => { 183 => 0x2, 424 => [0x4,0x3b], 428 => 0x1e, 429 => 0x1b, 430 => [0x1b,0x21] },
	'afstatusbottom' => { 183 => 0x8, 428 => 0x2a, 429 => 0x21, 430 => 0x21 },
	'afstatusbottom-left' => { 183 => 0x12, 429 => 0x2b, 430 => 0x2b },
	'afstatusbottom-right' => { 183 => 0x6, 429 => 0x1f, 430 => 0x1f },
	'afstatusbottomassist-left' => { 428 => 0x28 },
	'afstatusbottomassist-right' => { 428 => 0x2c },
	'afstatusbottomhorizontal' => { 425 => 0x10, 426 => 0x1c },
	'afstatusbottomvertical' => { 425 => 0x16, 426 => 0x26 },
	'afstatuscenter-10' => { 428 => 0x34 },
	'afstatuscenter-11' => { 428 => 0x36 },
	'afstatuscenter-12' => { 428 => 0x38 },
	'afstatuscenter-14' => { 428 => 0x3c },
	'afstatuscenter-7' => { 428 => 0x2e },
	'afstatuscenter-9' => { 428 => 0x32 },
	'afstatuscenter-horizontal' => { 428 => 0x30 },
	'afstatuscenter-vertical' => { 428 => 0x3a },
	'afstatuscenterf2-8' => { 428 => 0x4c },
	'afstatuscenterhorizontal' => { 183 => 0x2f, 425 => 0xc, 426 => 0x18, 429 => 0x2f, 430 => 0x2f },
	'afstatuscentervertical' => { 183 => 0xc, 425 => 0x14, 426 => 0x22, 429 => 0x25, 430 => 0x25 },
	'afstatusfarleft' => { 425 => 0x6, 428 => 0x26 },
	'afstatusfarlefthorizontal' => { 426 => 0x4 },
	'afstatusfarleftvertical' => { 426 => 0x12 },
	'afstatusfarright' => { 425 => 0x18, 428 => 0x44 },
	'afstatusfarrighthorizontal' => { 426 => 0x2c },
	'afstatusfarrightvertical' => { 426 => 0x34 },
	'afstatusleft' => { 183 => 0x2d, 425 => 0x2, 428 => 0x22, 429 => 0x2d, 430 => 0x2d },
	'afstatuslefthorizontal' => { 426 => 0x6 },
	'afstatusleftvertical' => { 426 => 0xe },
	'afstatuslower-left' => { 425 => 0x4, 428 => 0x24 },
	'afstatuslower-lefthorizontal' => { 426 => 0xa },
	'afstatuslower-leftvertical' => { 426 => 0x10 },
	'afstatuslower-middle' => { 425 => 0x22, 426 => 0x24 },
	'afstatuslower-right' => { 425 => 0x1e, 428 => 0x4a },
	'afstatuslower-righthorizontal' => { 426 => 0x32 },
	'afstatuslower-rightvertical' => { 426 => 0x3a },
	'afstatuslowerfarleft' => { 426 => 0x8 },
	'afstatuslowerfarright' => { 426 => 0x30 },
	'afstatusmiddlehorizontal' => { 183 => 0xa, 429 => 0x23, 430 => 0x23 },
	'afstatusnearleft' => { 425 => 0xe, 426 => 0x1a },
	'afstatusnearright' => { 425 => 0xa, 426 => 0x16 },
	'afstatusright' => { 183 => 0x31, 425 => 0x1c, 428 => 0x48, 429 => 0x31, 430 => 0x31 },
	'afstatusrighthorizontal' => { 426 => 0x2e },
	'afstatusrightvertical' => { 426 => 0x38 },
	'afstatustop' => { 183 => 0xe, 428 => 0x40, 429 => 0x27, 430 => 0x27 },
	'afstatustop-left' => { 183 => 0x10, 429 => 0x29, 430 => 0x29 },
	'afstatustop-right' => { 183 => 0x4, 429 => 0x1d, 430 => 0x1d },
	'afstatustopassist-left' => { 428 => 0x3e },
	'afstatustopassist-right' => { 428 => 0x42 },
	'afstatustophorizontal' => { 425 => 0x8, 426 => 0x14 },
	'afstatustopvertical' => { 425 => 0x12, 426 => 0x1e },
	'afstatusupper-left' => { 425 => 0x0, 428 => 0x20 },
	'afstatusupper-lefthorizontal' => { 426 => 0x2 },
	'afstatusupper-leftvertical' => { 426 => 0xc },
	'afstatusupper-middle' => { 425 => 0x20, 426 => 0x20 },
	'afstatusupper-right' => { 425 => 0x1a, 428 => 0x46 },
	'afstatusupper-righthorizontal' => { 426 => 0x2a },
	'afstatusupper-rightvertical' => { 426 => 0x36 },
	'afstatusupperfarleft' => { 426 => 0x0 },
	'afstatusupperfarright' => { 426 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 444 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 424 => 0x2 },
	'afwithshutter' => { 431 => 0x2a },
	'aggregateissuenumber' => { 524 => 'aggregateIssueNumber' },
	'aggregationtype' => { 524 => 'aggregationType' },
	'agreement' => { 527 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 141 => 0xe4e },
	'airplanemode' => { 243 => 0x722, 244 => 0x624, 245 => 0x654, 246 => 0x6bc },
	'aiservocontinuousshooting' => { 86 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 87 => 0x519 },
	'aiservoimagepriority' => { 87 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 87 => 0x51a },
	'aiservotrackingmethod' => { 87 => 0x504 },
	'aiservotrackingsensitivity' => { 86 => 0x14, 87 => 0x502 },
	'aisubjecttrackingmode' => { 321 => 0x309 },
	'album' => { 396 => ['albm',"\xa9alb"], 398 => 'album', 404 => ['albm',"\xa9alb"], 534 => 'album' },
	'albumartist' => { 182 => 'WM/AlbumArtist', 396 => 'aART', 404 => 'albr' },
	'albumcoverurl' => { 182 => 'WM/AlbumCoverURL' },
	'albumid' => { 396 => 'plID' },
	'albumtitle' => { 182 => 'WM/AlbumTitle' },
	'alreadyapplied' => { 505 => 'AlreadyApplied', 507 => 'AlreadyApplied' },
	'alternatetitle' => { 524 => 'alternateTitle' },
	'alternatetitlea-lang' => { 524 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 524 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 524 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 200 => 0x6 },
	'alttapename' => { 534 => 'altTapeName' },
	'alttextaccessibility' => { 518 => 'AltTextAccessibility' },
	'alttimecode' => { 534 => 'altTimecode' },
	'alttimecodetimeformat' => { 534 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 534 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 534 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 407 => 0x5c },
	'ambientlight' => { 407 => 0x5e },
	'ambienttemperature' => { 122 => 0x9400, 405 => 0x14, 406 => 0x46, 407 => 0x50, 470 => 0x4, 512 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 405 => 0x13, 406 => 0x44, 407 => 0x4e },
	'analogbalance' => { 122 => 0xc627 },
	'analogcaptureiso' => { 141 => 0x89e },
	'analogisotable' => { 141 => 0x89d },
	'androidversion' => { 398 => 'com.android.version' },
	'angleadj' => { 106 => 0x10003, 112 => 0x8b },
	'angleinforoll' => { 501 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 501 => 'AngleInfoYaw' },
	'anti-blur' => { 444 => 0xb04b },
	'antialiasstrength' => { 122 => 0xc632 },
	'aperturelock' => { 302 => '38.2', 304 => '38.2', 305 => '38.2', 314 => '38.2', 315 => '38.2', 317 => 0xb8, 318 => 0xb8, 319 => 0xb8 },
	'aperturemode' => { 404 => 'apmd' },
	'aperturerange' => { 87 => 0x10d },
	'apertureringuse' => { 360 => '1.4' },
	'aperturesetting' => { 187 => 0x7, 431 => 0x30, 432 => 0x29, 433 => 0x1 },
	'aperturevalue' => { 96 => 0x2, 122 => 0x9202, 326 => 0x1002, 388 => 0x401, 511 => 'ApertureValue' },
	'appinfo' => { 484 => 'AppInfo' },
	'appinfoapplication' => { 484 => [\'AppInfo','AppInfoApplication'] },
	'appinfoitemuri' => { 484 => [\'AppInfo','AppInfoItemURI'] },
	'appinfoversion' => { 484 => [\'AppInfo','AppInfoVersion'] },
	'applekeywords' => { 330 => 'AAPL:Keywords' },
	'applephotosvariationidentifier' => { 398 => 'apple.photos.variation-identifier' },
	'applestoreaccount' => { 396 => 'apID' },
	'applestoreaccounttype' => { 396 => 'akID' },
	'applestorecatalogid' => { 396 => 'cnID' },
	'applestorecountry' => { 396 => 'sfID' },
	'applicationkeystring' => { 141 => 0x400 },
	'applicationnotes' => { 122 => 0x2bc, 349 => 0x2bc },
	'applicationrecordversion' => { 134 => 0x0 },
	'applyshootingmeteringmode' => { 87 => 0x10e },
	'approved' => { 513 => 'Approved' },
	'approvedby' => { 513 => 'ApprovedBy' },
	'approximatefnumber' => { 339 => 0x313, 346 => 0x3406 },
	'approximatefocusdistance' => { 502 => 'ApproximateFocusDistance' },
	'appversion' => { 517 => 'AppVersion' },
	'aps-csizecapture' => { 463 => 0x114, 464 => [0x114,0x1eb,0x1ee,0x21a,0x21c] },
	'aquahsl' => { 106 => 0x20914 },
	'armidentifier' => { 135 => 0x78 },
	'armversion' => { 135 => 0x7a },
	'arranger' => { 396 => "\xa9arg", 404 => "\xa9arg" },
	'arrangerkeywords' => { 404 => "\xa9ark" },
	'artdirector' => { 396 => "\xa9ard" },
	'artfilter' => { 321 => 0x529 },
	'artfiltereffect' => { 321 => 0x52f },
	'artist' => { 122 => 0x13b, 334 => 'Artist', 349 => 0x13b, 379 => 0x22e, 396 => "\xa9ART", 398 => 'artist', 404 => "\xa9ART", 530 => 'Artist', 534 => 'artist' },
	'artistid' => { 396 => 'atID' },
	'artmode' => { 116 => 0x301b },
	'artmodeparameters' => { 116 => 0x310b },
	'artwork' => { 398 => 'artwork' },
	'artworkcircadatecreated' => { 519 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 519 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 519 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 519 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 519 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 519 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 519 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 519 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 519 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 519 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 519 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 519 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 519 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 519 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 519 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 519 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 519 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 519 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 325 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 325 => 0x1112, 379 => 0x80, 431 => 0x55, 432 => 0x55, 433 => 0xa, 457 => [0x192c,0x1a88], 458 => 0x192c, 459 => 0x1958, 460 => 0x192c, 461 => 0x188c },
	'assetid' => { 495 => 'AssetID' },
	'asshoticcprofile' => { 122 => 0xc68f },
	'asshotneutral' => { 122 => 0xc628 },
	'asshotpreprofilematrix' => { 122 => 0xc690 },
	'asshotprofilename' => { 122 => 0xc6f6 },
	'asshotwhitexy' => { 122 => 0xc629 },
	'assignbktbutton' => { 301 => '4.2', 302 => '16.1', 304 => '16.1', 305 => '16.1', 314 => '16.1', 315 => '16.1' },
	'assignfuncbutton' => { 87 => 0x70b },
	'assignmb-d17af-onbutton' => { 305 => '79.1' },
	'assignmb-d17funcbutton' => { 305 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 305 => '68.1' },
	'assignmb-d18af-onbutton' => { 315 => '79.1' },
	'assignmb-d18funcbutton' => { 315 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 315 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 304 => '75.1', 305 => '75.1', 315 => '75.1' },
	'assignmoviefunc2button' => { 304 => '82.1', 305 => '82.1', 315 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 304 => '75.2', 305 => '75.2', 315 => '75.2' },
	'assignmovierecordbutton' => { 302 => '43.2', 314 => '45.1', 317 => 0x9b, 318 => 0x9b, 319 => 0x9b },
	'assignmovierecordbuttonplusdials' => { 304 => '45.1', 305 => '45.1', 315 => '45.1' },
	'assignmoviesubselector' => { 304 => '74.1', 305 => '74.1', 315 => '74.1' },
	'assignmoviesubselectorplusdials' => { 304 => '76.1', 305 => '76.1', 315 => '76.1' },
	'assignremotefnbutton' => { 302 => '54.1', 314 => '51.1' },
	'assistbuttonfunction' => { 85 => 0xd },
	'atcaptureusercrop' => { 141 => 0x943 },
	'attributionname' => { 503 => 'attributionName' },
	'attributionurl' => { 503 => 'attributionURL' },
	'audio' => { 344 => 0x20 },
	'audiobitrate' => { 69 => 0x6c, 519 => 'audioBitRate' },
	'audiobitratemode' => { 519 => 'audioBitRateMode' },
	'audiobitspersample' => { 519 => 'audioBitsPerSample' },
	'audiobutton' => { 318 => 0x17b, 319 => 0x193 },
	'audiobuttonplaybackmode' => { 318 => 0x1b9, 319 => 0x1d1 },
	'audiochannelcount' => { 519 => 'audioChannelCount' },
	'audiochannels' => { 69 => 0x70 },
	'audiochanneltype' => { 534 => 'audioChannelType' },
	'audiocompression' => { 87 => 0x816, 158 => 'Compression' },
	'audiocompressor' => { 534 => 'audioCompressor' },
	'audiodata' => { 487 => 'Data' },
	'audioduration' => { 134 => 0x99 },
	'audiogain' => { 398 => 'player.movie.audio.gain' },
	'audiomimetype' => { 487 => 'Mime' },
	'audiomoddate' => { 534 => 'audioModDate' },
	'audiooutcue' => { 134 => 0x9a },
	'audiosamplerate' => { 69 => 0x6e, 534 => 'audioSampleRate' },
	'audiosampletype' => { 534 => 'audioSampleType' },
	'audiosamplingrate' => { 134 => 0x97 },
	'audiosamplingresolution' => { 134 => 0x98 },
	'audiotype' => { 134 => 0x96 },
	'author' => { 160 => 'Author', 330 => 'Author', 334 => 'Author', 395 => 'Author', 396 => ['auth',"\xa9aut"], 398 => 'author', 404 => 'auth', 500 => 'author', 521 => 'Author', 532 => 'Author' },
	'authorsposition' => { 522 => 'AuthorsPosition' },
	'authorurl' => { 182 => 'WM/AuthorURL' },
	'autoafpointcolortracking' => { 87 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 370 => '0.1' },
	'autobracket' => { 421 => 0x19 },
	'autobracketing' => { 130 => 0x1100, 379 => 0x18, 411 => 0x1007 },
	'autobracketingmode' => { 313 => '12.3' },
	'autobracketingset' => { 313 => '12.1' },
	'autobracketmodem' => { 301 => '21.2', 302 => '13.3', 304 => '13.2', 305 => '13.2', 310 => '26.2', 314 => '13.3', 315 => '13.2', 317 => 0x5f, 318 => 0x5f, 319 => 0x5f },
	'autobracketorder' => { 187 => 0x43, 301 => '21.3', 302 => '13.2', 304 => '13.1', 305 => '13.1', 310 => '26.3', 311 => '12.2', 312 => '2.2', 313 => '12.2', 314 => '13.2', 315 => '13.1', 316 => '13.2', 317 => 0x61, 318 => 0x61, 319 => 0x61 },
	'autobracketset' => { 301 => '21.1', 302 => '13.1', 306 => '11.1', 307 => '12.1', 308 => '12.1', 310 => '26.1', 311 => '12.1', 312 => '2.1', 314 => '13.1', 316 => '13.1' },
	'autobrightness' => { 505 => 'AutoBrightness', 507 => 'AutoBrightness' },
	'autocapturecriteria' => { 199 => 0x1 },
	'autocapturecriteriamotiondirection' => { 199 => 0x5f },
	'autocapturecriteriamotionsize' => { 199 => 0x64 },
	'autocapturecriteriamotionspeed' => { 199 => 0x63 },
	'autocapturecriteriasubjectsize' => { 199 => 0x69 },
	'autocapturecriteriasubjecttype' => { 199 => 0x6a },
	'autocapturedframe' => { 199 => 0x0 },
	'autocapturedistancefar' => { 199 => 0x4a },
	'autocapturedistancenear' => { 199 => 0x4e },
	'autocapturepreset' => { 246 => 0x746 },
	'autocapturerecordingtime' => { 199 => 0x37 },
	'autocapturewaittime' => { 199 => 0x38 },
	'autocontrast' => { 505 => 'AutoContrast', 507 => 'AutoContrast' },
	'autodistortioncontrol' => { 213 => 0x4, 242 => 0x143 },
	'autodynamicrange' => { 130 => 0x140b },
	'autoexposure' => { 505 => 'AutoExposure', 507 => 'AutoExposure' },
	'autoexposurebracketing' => { 79 => 0x10 },
	'autoflashisosensitivity' => { 304 => '38.5', 305 => '38.5', 315 => '38.5', 317 => 0x5b, 318 => 0x5b, 319 => 0x5b },
	'autofocus' => { 324 => 0x209 },
	'autofocusmoderestrictions' => { 317 => 0x107, 318 => 0x107, 319 => 0x11d },
	'autofp' => { 312 => '7.3', 316 => '31.4' },
	'autoiso' => { 79 => 0x1, 116 => 0x3008, 243 => 0x152, 244 => 0x142, 245 => 0x156, 246 => 0x156, 303 => '1.1', 312 => '1.1' },
	'autoisomax' => { 303 => '1.2', 312 => '1.2' },
	'autoisominshutterspeed' => { 303 => '1.3', 312 => '1.3' },
	'autolateralca' => { 505 => 'AutoLateralCA', 507 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 16 => 0xbe, 17 => 0xbf, 20 => 0xbf, 64 => 0x2, 87 => 0x204, 106 => 0x20500, 112 => 0x6f },
	'autolightingoptimizeron' => { 106 => '0x20500.0', 112 => 0x6e },
	'autoportraitframed' => { 444 => 0x2016 },
	'autoredeye' => { 294 => 0xfe28a44f },
	'autorotate' => { 79 => 0x1b },
	'autoshadows' => { 505 => 'AutoShadows', 507 => 'AutoShadows' },
	'autotone' => { 505 => 'AutoTone', 507 => 'AutoTone' },
	'autotonedigest' => { 505 => 'AutoToneDigest', 507 => 'AutoToneDigest' },
	'autotonedigestnosat' => { 505 => 'AutoToneDigestNoSat', 507 => 'AutoToneDigestNoSat' },
	'autowhiteversion' => { 505 => 'AutoWhiteVersion', 507 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 238 => 0x82 },
	'avaperturesetting' => { 360 => 0x13 },
	'averageblacklevel' => { 47 => 0xe7, 49 => 0xfb, 50 => 0x114, 51 => 0x146 },
	'averagelv' => { 190 => 0x38 },
	'avsettingwithoutlens' => { 87 => 0x707 },
	'azimuth' => { 168 => 'Azimuth' },
	'babyage' => { 344 => [0x8010,0x33] },
	'babyname' => { 344 => 0x66 },
	'backgroundalpha' => { 529 => 'bgalpha' },
	'balance' => { 398 => 'player.movie.audio.balance' },
	'baseexposurecompensation' => { 360 => 0x15 },
	'baseiso' => { 79 => 0x2, 100 => 0x101c, 141 => 0x903, 346 => 0x312a, 476 => 0x6 },
	'baseisodaylight' => { 141 => 0x910 },
	'baseisoflash' => { 141 => 0x913 },
	'baseisofluorescent' => { 141 => 0x912 },
	'baseisotungsten' => { 141 => 0x911 },
	'baselineexposure' => { 122 => 0xc62a },
	'baselineexposureoffset' => { 122 => 0xc7a5 },
	'baselinenoise' => { 122 => 0xc62b },
	'baselinesharpness' => { 122 => 0xc62c },
	'baserenditionishdr' => { 516 => 'BaseRenditionIsHDR' },
	'baseurl' => { 532 => 'BaseURL' },
	'bass' => { 398 => 'player.movie.audio.bass' },
	'batterylevel' => { 344 => 0x38, 431 => 0x51, 435 => 0xc, 436 => 0x4, 437 => 0x4, 477 => 0x7, 478 => 0x5 },
	'batterylevel2' => { 478 => 0x7 },
	'batterylevelgrip1' => { 477 => 0x6 },
	'batterylevelgrip2' => { 477 => 0x8 },
	'batteryorder' => { 301 => '12.5', 310 => '13.2', 311 => '2.1', 314 => '3.1' },
	'batterystate' => { 187 => 0x60, 431 => 0x50, 437 => 0x14 },
	'batterytemperature' => { 435 => 0x1, 437 => 0x2, 477 => 0x5 },
	'batterytype' => { 66 => 0x38, 407 => 0x66 },
	'batteryunknown' => { 435 => 0x2, 437 => 0x0 },
	'batteryvoltage' => { 141 => 0x408, 405 => 0x2a, 406 => 0x49, 407 => 0x62, 435 => 0x8 },
	'batteryvoltage1' => { 437 => 0x6 },
	'batteryvoltage2' => { 437 => 0x8 },
	'batteryvoltageavg' => { 407 => 0x64 },
	'bayergreensplit' => { 122 => 0xc62d },
	'bayerpattern' => { 140 => 0xf902, 191 => 0x17 },
	'beatsperminute' => { 396 => 'tmpo' },
	'beatspliceparams' => { 534 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 534 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 534 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 534 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 534 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 534 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 301 => '13.1', 302 => '5.4', 303 => '0.1', 306 => '2.1', 307 => '3.1', 308 => '3.1', 310 => '10.1', 312 => '0.1', 314 => '5.5', 316 => '4.1' },
	'beeppitch' => { 311 => '3.1' },
	'beepvolume' => { 311 => '4.5' },
	'bestqualityscale' => { 122 => 0xc65c },
	'bestshotmode' => { 116 => 0x3007 },
	'bitdepth' => { 165 => 'BitDepth', 191 => 0x11, 261 => 0x41 },
	'bitspercomponent' => { 136 => 0x87 },
	'bitspersample' => { 122 => 0x102, 349 => 0xa, 530 => 'BitsPerSample' },
	'blackacquirerows' => { 141 => 0x18ba },
	'blacklevel' => { 122 => [0x7310,0xc61a], 210 => 0x20, 238 => 0x3d, 326 => [0x401,0x1012], 388 => 0x21d, 451 => [0x7300,0x7310] },
	'blacklevel2' => { 325 => 0x600, 329 => 0x600 },
	'blacklevelblue' => { 349 => 0x1e },
	'blacklevelbottom' => { 141 => 0x3f0 },
	'blackleveldata' => { 388 => 0x223 },
	'blackleveldeltah' => { 122 => 0xc61b },
	'blackleveldeltav' => { 122 => 0xc61c },
	'blacklevelgreen' => { 349 => 0x1d },
	'blacklevelred' => { 349 => 0x1c },
	'blacklevelrepeatdim' => { 122 => 0xc619 },
	'blacklevelrough' => { 141 => 0x40e },
	'blacklevelroughafter' => { 141 => 0x416 },
	'blacklevels' => { 37 => 0x1d },
	'blackleveltop' => { 141 => 0x3ef },
	'blackpoint' => { 379 => 0x200 },
	'blacks2012' => { 505 => 'Blacks2012', 507 => 'Blacks2012' },
	'blacksadj' => { 481 => 0x9018 },
	'bleachbypasstoning' => { 379 => 0x7f },
	'blockshotafresponse' => { 304 => '1.5', 305 => '1.5', 315 => '1.5', 317 => 0x7, 318 => 0x7, 319 => 0x7 },
	'blogtitle' => { 524 => 'blogTitle' },
	'blogurl' => { 524 => 'blogURL' },
	'bluebalance' => { 326 => 0x1018, 349 => 0x12, 379 => 0x1b },
	'bluecurvelimits' => { 111 => 0x1fe },
	'bluecurvepoints' => { 110 => 0x79, 111 => 0x1d4 },
	'bluehsl' => { 106 => 0x20915 },
	'bluehue' => { 505 => 'BlueHue', 507 => 'BlueHue' },
	'bluesaturation' => { 505 => 'BlueSaturation', 507 => 'BlueSaturation' },
	'bluratinfinity' => { 491 => 'BlurAtInfinity' },
	'blurcontrol' => { 379 => 0x82 },
	'blurwarning' => { 130 => 0x1300 },
	'bodybatteryadload' => { 358 => 0x3 },
	'bodybatteryadnoload' => { 358 => 0x2 },
	'bodybatterystate' => { 358 => '1.1' },
	'bodybatteryvoltage1' => { 358 => 0x2 },
	'bodybatteryvoltage2' => { 358 => 0x4 },
	'bodybatteryvoltage3' => { 358 => 0x6 },
	'bodybatteryvoltage4' => { 358 => 0x8 },
	'bodyfirmware' => { 412 => 0x0 },
	'bodyfirmwareversion' => { 322 => 0x104, 323 => 0x100, 326 => 0x104 },
	'bodyserialnumber' => { 412 => 0x10 },
	'bookedition' => { 524 => 'bookEdition' },
	'bootloaderversion' => { 406 => 0x26 },
	'bracketbutton' => { 246 => 0x80c },
	'bracketbuttonplaybackmode' => { 246 => 0x816 },
	'bracketincrement' => { 243 => 0x22e, 244 => 0x21a, 245 => 0x22e, 246 => 0x22e },
	'bracketmode' => { 59 => 0x3 },
	'bracketprogram' => { 243 => 0x22c, 244 => 0x218, 245 => 0x22c, 246 => 0x22c },
	'bracketsequence' => { 116 => 0x301d },
	'bracketset' => { 243 => 0x22a, 244 => 0x216, 245 => 0x22a, 246 => 0x22a },
	'bracketsettings' => { 344 => 0x45 },
	'bracketshotnumber' => { 59 => 0x5, 360 => 0x9, 442 => 0x2b },
	'bracketshotnumber2' => { 442 => 0x2d },
	'bracketstep' => { 184 => 0xe },
	'bracketvalue' => { 59 => 0x4 },
	'brightness' => { 122 => 0xfe53, 159 => 'Brightness', 179 => 'Brightness', 184 => 0x2c, 253 => 0x34, 254 => 0x39, 255 => 0x41, 398 => 'player.movie.visual.brightness', 405 => 0x25, 407 => 0x54, 431 => 0x22, 444 => 0x2007, 505 => 'Brightness', 507 => 'Brightness' },
	'brightnessadj' => { 111 => 0x114, 287 => 0x0, 297 => 0x2d, 481 => 0x8018 },
	'brightnessvalue' => { 122 => 0x9203, 190 => [0x691,0x49c3], 326 => 0x1003, 449 => 0x1e, 453 => 0x1140, 454 => 0x1140, 455 => 0x111c, 456 => 0x1198, 457 => 0x1174, 458 => 0x102c, 459 => 0x224, 460 => 0x224, 461 => 0x219, 511 => 'BrightnessValue' },
	'buildnumber' => { 194 => 0x5500 },
	'bulbduration' => { 79 => 0x18 },
	'burstcount' => { 141 => 0x40d },
	'burstgroupid' => { 240 => 0x4 },
	'burstid' => { 488 => 'BurstID' },
	'burstmode' => { 143 => 0xa, 344 => 0x2a },
	'burstmode2' => { 143 => 0x18 },
	'burstprimary' => { 488 => 'BurstPrimary' },
	'burstshot' => { 421 => 0x34 },
	'burstspeed' => { 344 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 87 => 0x70a },
	'bwadjustment' => { 130 => 0x1049 },
	'bwfilter' => { 184 => 0x2a, 192 => 0x39 },
	'bwmagentagreen' => { 130 => 0x104b },
	'bwmode' => { 326 => 0x203 },
	'by-line' => { 134 => 0x50 },
	'by-linetitle' => { 134 => 0x55 },
	'bytecount' => { 524 => 'byteCount' },
	'c14configuration' => { 141 => 0x1964 },
	'cacheversion' => { 122 => 0xc7aa },
	'calibratedfocallength' => { 119 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 119 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 119 => 'CalibratedOpticalCenterY' },
	'calibration' => { 421 => [0x24,0x30] },
	'calibrationhistory' => { 141 => 0x9c9 },
	'calibrationilluminant1' => { 122 => 0xc65a },
	'calibrationilluminant2' => { 122 => 0xc65b },
	'calibrationilluminant3' => { 122 => 0xcd31 },
	'calibrationversion' => { 141 => 0x9c6 },
	'callforimage' => { 495 => 'CallForImage' },
	'camera' => { 484 => [\'Cameras','CamerasCamera'] },
	'cameraangle' => { 404 => 'angl', 534 => 'cameraAngle' },
	'cameraappinfo' => { 484 => [\'Cameras','CamerasCameraAppInfo'] },
	'cameraappinfoapplication' => { 484 => [\'Cameras','CamerasCameraAppInfoApplication'] },
	'cameraappinfoitemuri' => { 484 => [\'Cameras','CamerasCameraAppInfoItemURI'] },
	'cameraappinfoversion' => { 484 => [\'Cameras','CamerasCameraAppInfoVersion'] },
	'cameraburstid' => { 489 => 'CameraBurstID' },
	'cameracalibration' => { 421 => 0x11f },
	'cameracalibration1' => { 122 => 0xc623 },
	'cameracalibration2' => { 122 => 0xc624 },
	'cameracalibration3' => { 122 => 0xcd32 },
	'cameracalibrationsig' => { 122 => 0xc6f3 },
	'cameracolorcalibration01' => { 38 => 0x0, 39 => 0x0 },
	'cameracolorcalibration02' => { 38 => 0x4, 39 => 0x5 },
	'cameracolorcalibration03' => { 38 => 0x8, 39 => 0xa },
	'cameracolorcalibration04' => { 38 => 0xc, 39 => 0xf },
	'cameracolorcalibration05' => { 38 => 0x10, 39 => 0x14 },
	'cameracolorcalibration06' => { 38 => 0x14, 39 => 0x19 },
	'cameracolorcalibration07' => { 38 => 0x18, 39 => 0x1e },
	'cameracolorcalibration08' => { 38 => 0x1c, 39 => 0x23 },
	'cameracolorcalibration09' => { 38 => 0x20, 39 => 0x28 },
	'cameracolorcalibration10' => { 38 => 0x24, 39 => 0x2d },
	'cameracolorcalibration11' => { 38 => 0x28, 39 => 0x32 },
	'cameracolorcalibration12' => { 38 => 0x2c, 39 => 0x37 },
	'cameracolorcalibration13' => { 38 => 0x30, 39 => 0x3c },
	'cameracolorcalibration14' => { 38 => 0x34, 39 => 0x41 },
	'cameracolorcalibration15' => { 38 => 0x38, 39 => 0x46 },
	'cameradepthmap' => { 484 => [\'Cameras','CamerasCameraDepthMap'] },
	'cameradepthmapconfidenceuri' => { 484 => [\'Cameras','CamerasCameraDepthMapConfidenceURI'] },
	'cameradepthmapdepthuri' => { 484 => [\'Cameras','CamerasCameraDepthMapDepthURI'] },
	'cameradepthmapfar' => { 484 => [\'Cameras','CamerasCameraDepthMapFar'] },
	'cameradepthmapfocaltable' => { 484 => [\'Cameras','CamerasCameraDepthMapFocalTable'] },
	'cameradepthmapfocaltableentrycount' => { 484 => [\'Cameras','CamerasCameraDepthMapFocalTableEntryCount'] },
	'cameradepthmapformat' => { 484 => [\'Cameras','CamerasCameraDepthMapFormat'] },
	'cameradepthmapitemsemantic' => { 484 => [\'Cameras','CamerasCameraDepthMapItemSemantic'] },
	'cameradepthmapmeasuretype' => { 484 => [\'Cameras','CamerasCameraDepthMapMeasureType'] },
	'cameradepthmapnear' => { 484 => [\'Cameras','CamerasCameraDepthMapNear'] },
	'cameradepthmapsoftware' => { 484 => [\'Cameras','CamerasCameraDepthMapSoftware'] },
	'cameradepthmapunits' => { 484 => [\'Cameras','CamerasCameraDepthMapUnits'] },
	'cameradirection' => { 398 => 'direction.facing' },
	'camerae-mountversion' => { 480 => 0xb },
	'cameraelevationangle' => { 122 => 0x9405, 512 => 'CameraElevationAngle' },
	'camerafilename' => { 495 => 'CameraFilename' },
	'camerafirmware' => { 122 => 0xa439 },
	'cameraid' => { 326 => 0x209, 404 => 'cmid', 420 => 0x209 },
	'cameraidentifier' => { 398 => 'camera.identifier' },
	'cameraimage' => { 484 => [\'Cameras','CamerasCameraImage'] },
	'cameraimageitemsemantic' => { 484 => [\'Cameras','CamerasCameraImageItemSemantic'] },
	'cameraimageitemuri' => { 484 => [\'Cameras','CamerasCameraImageItemURI'] },
	'cameraimagingmodel' => { 484 => [\'Cameras','CamerasCameraImagingModel'] },
	'cameraimagingmodeldistortion' => { 484 => [\'Cameras','CamerasCameraImagingModelDistortion'] },
	'cameraimagingmodeldistortioncount' => { 484 => [\'Cameras','CamerasCameraImagingModelDistortionCount'] },
	'cameraimagingmodelfocallengthx' => { 484 => [\'Cameras','CamerasCameraImagingModelFocalLengthX'] },
	'cameraimagingmodelfocallengthy' => { 484 => [\'Cameras','CamerasCameraImagingModelFocalLengthY'] },
	'cameraimagingmodelimageheight' => { 484 => [\'Cameras','CamerasCameraImagingModelImageHeight'] },
	'cameraimagingmodelimagewidth' => { 484 => [\'Cameras','CamerasCameraImagingModelImageWidth'] },
	'cameraimagingmodelpixelaspectratio' => { 484 => [\'Cameras','CamerasCameraImagingModelPixelAspectRatio'] },
	'cameraimagingmodelprincipalpointx' => { 484 => [\'Cameras','CamerasCameraImagingModelPrincipalPointX'] },
	'cameraimagingmodelprincipalpointy' => { 484 => [\'Cameras','CamerasCameraImagingModelPrincipalPointY'] },
	'cameraimagingmodelskew' => { 484 => [\'Cameras','CamerasCameraImagingModelSkew'] },
	'cameraiso' => { 36 => 0x10 },
	'cameralabel' => { 122 => 0xc7a1, 534 => 'cameraLabel' },
	'cameralightestimate' => { 484 => [\'Cameras','CamerasCameraLightEstimate'] },
	'cameralightestimatecolorcorrectionb' => { 484 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionB'] },
	'cameralightestimatecolorcorrectiong' => { 484 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionG'] },
	'cameralightestimatecolorcorrectionr' => { 484 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionR'] },
	'cameralightestimatepixelintensity' => { 484 => [\'Cameras','CamerasCameraLightEstimatePixelIntensity'] },
	'cameramakemodel' => { 495 => 'CameraMakeModel' },
	'cameramodel' => { 388 => 0x410, 534 => 'cameraModel' },
	'cameramodelid' => { 179 => 'CameraModelID' },
	'cameramodelrestriction' => { 505 => 'CameraModelRestriction', 507 => 'CameraModelRestriction' },
	'cameramotion' => { 398 => 'direction.motion' },
	'cameramove' => { 534 => 'cameraMove' },
	'cameraorientation' => { 7 => 0x30, 9 => 0x7d, 11 => 0x30, 13 => 0x35, 14 => 0x30, 15 => 0x30, 16 => 0x31, 17 => 0x31, 18 => 0x35, 19 => 0x27, 20 => 0x31, 21 => 0x7d, 22 => 0x38, 23 => [0x36,0x3a], 24 => 0x7d, 25 => 0x83, 26 => 0x84, 27 => 0x96, 28 => 0x35, 29 => 0x96, 344 => 0x8f, 383 => 0x1, 388 => 0x100, 437 => [0x16,0x18], 467 => 0x28, 468 => 0x24, 469 => 0x29 },
	'cameraowner' => { 144 => 0xc353 },
	'cameraparameters' => { 326 => 0x2050 },
	'camerapicturestyle' => { 28 => 0xaf },
	'camerapitch' => { 118 => 0x9, 404 => "\xa9gpt" },
	'camerapointcloud' => { 484 => [\'Cameras','CamerasCameraPointCloud'] },
	'camerapointcloudmetric' => { 484 => [\'Cameras','CamerasCameraPointCloudMetric'] },
	'camerapointcloudpointcloud' => { 484 => [\'Cameras','CamerasCameraPointCloudPointCloud'] },
	'camerapointcloudpoints' => { 484 => [\'Cameras','CamerasCameraPointCloudPoints'] },
	'camerapose' => { 484 => [\'Cameras','CamerasCameraPose'] },
	'cameraposepositionx' => { 484 => [\'Cameras','CamerasCameraPosePositionX'] },
	'cameraposepositiony' => { 484 => [\'Cameras','CamerasCameraPosePositionY'] },
	'cameraposepositionz' => { 484 => [\'Cameras','CamerasCameraPosePositionZ'] },
	'cameraposerotationw' => { 484 => [\'Cameras','CamerasCameraPoseRotationW'] },
	'cameraposerotationx' => { 484 => [\'Cameras','CamerasCameraPoseRotationX'] },
	'cameraposerotationy' => { 484 => [\'Cameras','CamerasCameraPoseRotationY'] },
	'cameraposerotationz' => { 484 => [\'Cameras','CamerasCameraPoseRotationZ'] },
	'cameraposetimestamp' => { 484 => [\'Cameras','CamerasCameraPoseTimestamp'] },
	'cameraprofile' => { 505 => 'CameraProfile', 507 => 'CameraProfile' },
	'cameraprofiledigest' => { 505 => 'CameraProfileDigest', 507 => 'CameraProfileDigest' },
	'cameraprofiles' => { 522 => 'CameraProfiles' },
	'cameraprofilesaperturevalue' => { 522 => [\'CameraProfiles','CameraProfilesApertureValue'] },
	'cameraprofilesauthor' => { 522 => [\'CameraProfiles','CameraProfilesAuthor'] },
	'cameraprofilesautoscale' => { 522 => [\'CameraProfiles','CameraProfilesAutoScale'] },
	'cameraprofilescameraprettyname' => { 522 => [\'CameraProfiles','CameraProfilesCameraPrettyName'] },
	'cameraprofilescamerarawprofile' => { 522 => [\'CameraProfiles','CameraProfilesCameraRawProfile'] },
	'cameraprofilesfocallength' => { 522 => [\'CameraProfiles','CameraProfilesFocalLength'] },
	'cameraprofilesfocusdistance' => { 522 => [\'CameraProfiles','CameraProfilesFocusDistance'] },
	'cameraprofileslens' => { 522 => [\'CameraProfiles','CameraProfilesLens'] },
	'cameraprofileslensprettyname' => { 522 => [\'CameraProfiles','CameraProfilesLensPrettyName'] },
	'cameraprofilesmake' => { 522 => [\'CameraProfiles','CameraProfilesMake'] },
	'cameraprofilesmodel' => { 522 => [\'CameraProfiles','CameraProfilesModel'] },
	'cameraprofilesperspectivemodel' => { 522 => [\'CameraProfiles','CameraProfilesPerspectiveModel'] },
	'cameraprofilesperspectivemodelimagexcenter' => { 522 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageXCenter'] },
	'cameraprofilesperspectivemodelimageycenter' => { 522 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageYCenter'] },
	'cameraprofilesperspectivemodelradialdistortparam1' => { 522 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam1'] },
	'cameraprofilesperspectivemodelradialdistortparam2' => { 522 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam2'] },
	'cameraprofilesperspectivemodelradialdistortparam3' => { 522 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam3'] },
	'cameraprofilesperspectivemodelscalefactor' => { 522 => [\'CameraProfiles','CameraProfilesPerspectiveModelScaleFactor'] },
	'cameraprofilesperspectivemodelversion' => { 522 => [\'CameraProfiles','CameraProfilesPerspectiveModelVersion'] },
	'cameraprofilesprofilename' => { 522 => [\'CameraProfiles','CameraProfilesProfileName'] },
	'cameraprofilessensorformatfactor' => { 522 => [\'CameraProfiles','CameraProfilesSensorFormatFactor'] },
	'cameraprofilesuniquecameramodel' => { 522 => [\'CameraProfiles','CameraProfilesUniqueCameraModel'] },
	'camerarawcolortone' => { 112 => 0xe1 },
	'camerarawcontrast' => { 112 => 0xe3 },
	'camerarawhighlightpoint' => { 112 => 0xe6 },
	'camerarawlinear' => { 112 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 112 => 0xe8 },
	'camerarawoutputshadowpoint' => { 112 => 0xe9 },
	'camerarawsaturation' => { 112 => 0xe2 },
	'camerarawshadowpoint' => { 112 => 0xe7 },
	'camerarawsharpness' => { 112 => 0xe5 },
	'cameraroll' => { 118 => 0xb, 404 => "\xa9grl" },
	'cameras' => { 484 => 'Cameras' },
	'cameraserialnumber' => { 122 => 0xc62f, 181 => 'CameraSerialNumber', 495 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 321 => 0x0 },
	'cameratemperature' => { 7 => 0x18, 9 => 0x1b, 11 => 0x18, 13 => 0x19, 14 => 0x18, 15 => 0x18, 16 => 0x19, 17 => 0x19, 18 => 0x19, 19 => 0x17, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => 0x19, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x1b, 28 => 0x19, 29 => 0x1b, 31 => [0x87,0x91], 32 => [0x99,0x9f,0xa4,0xa8,0x105], 35 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 79 => 0xc, 141 => 0x406, 325 => 0x1306, 339 => 0x320, 346 => 0x3402, 379 => 0x47, 418 => 0x43, 471 => 0x5 },
	'cameratemperature4' => { 384 => 0x14 },
	'cameratemperature5' => { 384 => 0x16 },
	'cameratemperaturerangemax' => { 124 => 0x5 },
	'cameratemperaturerangemin' => { 124 => 0x6 },
	'cameratrait' => { 484 => [\'Cameras','CamerasCameraTrait'] },
	'cameratype' => { 79 => 0x1a, 326 => 0x207 },
	'cameratype2' => { 322 => 0x100 },
	'cameravendorinfo' => { 484 => [\'Cameras','CamerasCameraVendorInfo'] },
	'cameravendorinfomanufacturer' => { 484 => [\'Cameras','CamerasCameraVendorInfoManufacturer'] },
	'cameravendorinfomodel' => { 484 => [\'Cameras','CamerasCameraVendorInfoModel'] },
	'cameravendorinfonotes' => { 484 => [\'Cameras','CamerasCameraVendorInfoNotes'] },
	'camerayaw' => { 118 => 0xa, 404 => "\xa9gyw" },
	'camreverse' => { 119 => 'CamReverse' },
	'canondr4' => { 123 => 'CanonDR4' },
	'canonexposuremode' => { 36 => 0x14 },
	'canonfiledescription' => { 100 => 0x805 },
	'canonfilelength' => { 66 => 0xe },
	'canonfirmwareversion' => { 66 => 0x7, 100 => 0x80b },
	'canonflashinfo' => { 100 => 0x1028 },
	'canonflashmode' => { 36 => 0x4 },
	'canonimagesize' => { 10 => 0x39, 36 => 0xa },
	'canonimagetype' => { 66 => 0x6, 100 => 0x815 },
	'canonlogversion' => { 65 => 0xb },
	'canonmodelid' => { 66 => 0x10, 100 => 0x1834 },
	'canonvrd' => { 123 => 'CanonVRD' },
	'caption' => { 500 => 'caption' },
	'caption-abstract' => { 134 => 0x78 },
	'captionsauthornames' => { 510 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 510 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 522 => 'CaptionWriter' },
	'captureframerate' => { 116 => 0x4001 },
	'captureheightnormal' => { 141 => 0x1839 },
	'capturelook' => { 141 => 0xc48 },
	'capturemode' => { 398 => 'com.apple.photos.captureMode' },
	'capturesoftware' => { 493 => 'CaptureSoftware' },
	'capturewidthnormal' => { 141 => 0x1838 },
	'capturewidthtest' => { 141 => 0x1842 },
	'cardshutterlock' => { 187 => 0x49 },
	'casioimagesize' => { 116 => 0x9 },
	'catalogsets' => { 134 => 0xff, 486 => 'CatalogSets', 498 => 'CatalogSets' },
	'categories' => { 66 => 0x23, 500 => 'categories' },
	'category' => { 134 => 0xf, 182 => 'WM/Category', 320 => 0x30, 396 => 'catg', 522 => 'Category' },
	'cbcrgain' => { 418 => 0xa036 },
	'cbcrgaindefault' => { 418 => 0xa035 },
	'cbcrmatrix' => { 418 => 0xa034 },
	'cbcrmatrixdefault' => { 418 => 0xa033 },
	'ccdboardversion' => { 339 => 0x331 },
	'ccdscanmode' => { 326 => 0x1039 },
	'ccdsensitivity' => { 284 => 0x6 },
	'ccdversion' => { 339 => 0x330 },
	'ccvavgluminancenits' => { 515 => 'ccv_avg_luminance_nits' },
	'ccvmaxluminancenits' => { 515 => 'ccv_max_luminance_nits' },
	'ccvminluminancenits' => { 515 => 'ccv_min_luminance_nits' },
	'ccvprimariesxy' => { 515 => 'ccv_primaries_xy' },
	'ccvwhitexy' => { 515 => 'ccv_white_xy' },
	'cellglobalid' => { 504 => 'cgi' },
	'celllength' => { 122 => 0x109 },
	'cellr' => { 504 => 'r' },
	'celltowerid' => { 504 => 'cellid' },
	'cellwidth' => { 122 => 0x108 },
	'centerafarea' => { 312 => '15.1' },
	'centerfocuspoint' => { 316 => '2.2' },
	'centerpixel' => { 141 => 0x40c },
	'centerweightedareasize' => { 301 => '7.1', 302 => '8.1', 304 => '8.1', 305 => '8.1', 309 => '7.1', 310 => '5.1', 311 => '7.1', 312 => '6.3', 314 => '8.1', 315 => '8.1', 316 => '8.1', 317 => 0x1f, 318 => 0x1f, 319 => 0x1f },
	'certificate' => { 538 => 'Certificate' },
	'cfainterpolationalgorithm' => { 141 => 0xe60 },
	'cfainterpolationmetric' => { 141 => 0xe61 },
	'cfaoffsetcols' => { 141 => 0xc71 },
	'cfaoffsetrows' => { 141 => 0xc6f },
	'cfapattern' => { 122 => 0xa302, 349 => 0x9, 511 => 'CFAPattern' },
	'cfapattern2' => { 122 => 0x828e },
	'cfapatterncolumns' => { 511 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 511 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 511 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 122 => 0x828d },
	'cfazipperfixthreshold' => { 141 => 0xe62 },
	'channel' => { 524 => 'channel' },
	'channela-lang' => { 524 => [\'channel','channelA-lang'] },
	'channelchannel' => { 524 => [\'channel','channelChannel'] },
	'channels' => { 158 => 'Channels' },
	'channelsubchannel1' => { 524 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 524 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 524 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 524 => [\'channel','channelSubchannel4'] },
	'chapterlist' => { 404 => 'chpl' },
	'checkmark' => { 106 => 0x10101, 111 => 0x26a },
	'checkmark2' => { 112 => 0x8e },
	'childfontfiles' => { 539 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 301 => '10.3', 302 => '11.2', 317 => 0x10b, 318 => 0x10b, 319 => 0x121 },
	'chromablurradius' => { 122 => 0xc631 },
	'chromanoisecolorspace' => { 141 => 0xe6d },
	'chromanoiseedgemapthresh' => { 141 => 0xe6c },
	'chromanoisehighfthresh' => { 141 => 0xe6a },
	'chromanoiselowfthresh' => { 141 => 0xe6b },
	'chromaticaberration' => { 106 => 0x20703, 112 => 0x66, 418 => 0xa051 },
	'chromaticaberrationb' => { 505 => 'ChromaticAberrationB', 507 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 106 => 0x20708, 112 => 0x6b },
	'chromaticaberrationcorr' => { 81 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 122 => 0x7034, 369 => 0x1, 481 => 0x900d },
	'chromaticaberrationcorrparams' => { 122 => 0x7035, 475 => 0x66a, 476 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 106 => '0x20703.0', 112 => 0x62 },
	'chromaticaberrationr' => { 505 => 'ChromaticAberrationR', 507 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 106 => 0x20707, 112 => 0x6a },
	'chromaticaberrationsetting' => { 82 => 0x6 },
	'chrominancenoisereduction' => { 106 => 0x20601, 112 => 0x5e, 421 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 112 => 0x60 },
	'circadatecreated' => { 519 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrblacks2012' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'] },
	'circgradbasedcorrbrightness' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrcorrectionname' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'] },
	'circgradbasedcorrcorrectionsyncid' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'] },
	'circgradbasedcorrdefringe' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrdehaze' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'] },
	'circgradbasedcorrexposure' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'] },
	'circgradbasedcorrluminancenoise' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskinputdigest' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'circgradbasedcorrmaskleft' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmaskactive' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'circgradbasedcorrmaskmaskblendmode' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmaskdigest' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'circgradbasedcorrmaskmaskinverted' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'circgradbasedcorrmaskmaskname' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'] },
	'circgradbasedcorrmaskmasks' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'] },
	'circgradbasedcorrmaskmasksalpha' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'circgradbasedcorrmaskmasksangle' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'circgradbasedcorrmaskmasksbottom' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'circgradbasedcorrmaskmaskscentervalue' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'circgradbasedcorrmaskmaskscenterweight' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'circgradbasedcorrmaskmasksdabs' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'circgradbasedcorrmaskmasksfeather' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'circgradbasedcorrmaskmasksflipped' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'circgradbasedcorrmaskmasksflow' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'circgradbasedcorrmaskmasksfullx' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'circgradbasedcorrmaskmasksfully' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'circgradbasedcorrmaskmasksinputdigest' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'circgradbasedcorrmaskmasksleft' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'circgradbasedcorrmaskmasksmaskactive' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'circgradbasedcorrmaskmasksmaskblendmode' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmasksmaskdigest' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'circgradbasedcorrmaskmasksmaskinverted' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'circgradbasedcorrmaskmasksmaskname' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'circgradbasedcorrmaskmasksmasksubtype' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksmasksyncid' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'circgradbasedcorrmaskmasksmaskversion' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'circgradbasedcorrmaskmasksmidpoint' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'circgradbasedcorrmaskmasksorigin' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'circgradbasedcorrmaskmasksperimetervalue' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'circgradbasedcorrmaskmasksradius' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'circgradbasedcorrmaskmasksreferencepoint' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'circgradbasedcorrmaskmasksright' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'circgradbasedcorrmaskmasksroundness' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'circgradbasedcorrmaskmaskssizex' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'circgradbasedcorrmaskmaskssizey' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'circgradbasedcorrmaskmaskstop' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'circgradbasedcorrmaskmasksubtype' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksvalue' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'circgradbasedcorrmaskmasksversion' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'circgradbasedcorrmaskmaskswhat' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'circgradbasedcorrmaskmaskswholeimagearea' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'circgradbasedcorrmaskmasksx' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'] },
	'circgradbasedcorrmaskmasksy' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'] },
	'circgradbasedcorrmaskmasksyncid' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'circgradbasedcorrmaskmaskszerox' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'circgradbasedcorrmaskmaskszeroy' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'circgradbasedcorrmaskmaskversion' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'circgradbasedcorrmaskmidpoint' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskorigin' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'] },
	'circgradbasedcorrmaskperimetervalue' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskrange' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'circgradbasedcorrmaskrangeareamodels' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrmaskrangeareamodelscolorsampleinfo' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrmaskrangeareamodelscomponents' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrmaskrangecoloramount' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrmaskrangedepthfeather' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrmaskrangedepthmax' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrmaskrangedepthmin' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrmaskrangeinvert' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'circgradbasedcorrmaskrangelumfeather' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrmaskrangeluminancedepthsampleinfo' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrmaskrangelummax' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrmaskrangelummin' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrmaskrangelumrange' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrmaskrangesampletype' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrmaskrangetype' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'circgradbasedcorrmaskrangeversion' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'circgradbasedcorrmaskreferencepoint' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'circgradbasedcorrmaskright' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskwholeimagearea' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'circgradbasedcorrmaskx' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrrangemask' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'] },
	'circgradbasedcorrrangemaskareamodels' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrrangemaskareamodelscolorsampleinfo' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrrangemaskareamodelscomponents' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrrangemaskcoloramount' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrrangemaskdepthfeather' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrrangemaskdepthmax' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrrangemaskdepthmin' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrrangemaskinvert' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'circgradbasedcorrrangemasklumfeather' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrrangemaskluminancedepthsampleinfo' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrrangemasklummax' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrrangemasklummin' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrrangemasklumrange' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrrangemasksampletype' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrrangemasktype' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'] },
	'circgradbasedcorrrangemaskversion' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'circgradbasedcorrsaturation' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'] },
	'circgradbasedcorrshadows2012' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtexture' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'] },
	'circgradbasedcorrtint' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrtoninghue' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrtoningsaturation' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrwhat' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circgradbasedcorrwhites2012' => { 505 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'], 507 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'] },
	'circulargradientbasedcorrections' => { 505 => 'CircularGradientBasedCorrections', 507 => 'CircularGradientBasedCorrections' },
	'city' => { 134 => 0x5a, 164 => 'City', 344 => 0x6d, 522 => 'City' },
	'city2' => { 344 => 0x80 },
	'clarity' => { 130 => 0x100f, 254 => 0x35, 255 => 0x3d, 444 => 0x2036, 505 => 'Clarity', 507 => 'Clarity' },
	'clarity2012' => { 505 => 'Clarity2012', 507 => 'Clarity2012' },
	'claritycontrol' => { 379 => 0x96 },
	'classification' => { 404 => 'clsf' },
	'classifystate' => { 134 => 0xe1 },
	'clearretouch' => { 344 => 0x7c },
	'clearretouchvalue' => { 344 => 0xa3 },
	'client' => { 534 => 'client' },
	'clientname' => { 513 => 'ClientName' },
	'clipboardaspectratio' => { 505 => 'ClipboardAspectRatio', 507 => 'ClipboardAspectRatio' },
	'clipboardorientation' => { 505 => 'ClipboardOrientation', 507 => 'ClipboardOrientation' },
	'clipfilename' => { 404 => 'clfn' },
	'clipid' => { 404 => 'clid' },
	'clmodeshootingspeed' => { 301 => '10.2', 302 => '11.3', 304 => '11.2', 305 => '11.2', 310 => '11.2', 311 => '10.2', 314 => '11.2', 315 => '11.2', 316 => '11.1', 317 => 0x3b, 318 => 0x3b, 319 => 0x3b },
	'cluster' => { 505 => 'Cluster', 507 => 'Cluster' },
	'cmcontrast' => { 329 => 0x2022 },
	'cmddialsreverserotation' => { 317 => 0xba, 318 => 0xba, 319 => 0xba },
	'cmexposurecompensation' => { 329 => 0x2000 },
	'cmhue' => { 329 => 0x2021 },
	'cmsaturation' => { 329 => 0x2020 },
	'cmsharpness' => { 329 => 0x2023 },
	'cmwhitebalance' => { 329 => 0x2001 },
	'cmwhitebalancecomp' => { 329 => 0x2002 },
	'cmwhitebalancegraypoint' => { 329 => 0x2010 },
	'codec' => { 172 => 'Codec' },
	'codedcharacterset' => { 135 => 0x5a },
	'codeversion' => { 404 => 'cver' },
	'collection' => { 334 => 'Collection' },
	'collectionname' => { 173 => [\'Collections','CollectionsCollectionName'], 404 => 'coll' },
	'collections' => { 173 => 'Collections', 500 => 'collections' },
	'collectionuri' => { 173 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 398 => 'player.movie.visual.color', 523 => 'color' },
	'coloraberrationcontrol' => { 294 => 0xc89224b },
	'coloradjustment' => { 421 => 0x14 },
	'coloradjustmentmode' => { 420 => 0x210 },
	'coloranta' => { 539 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 539 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 539 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 539 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 539 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 539 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 539 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 539 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 539 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 539 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 539 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 539 => 'Colorants' },
	'colorantswatchname' => { 539 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 539 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 539 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 539 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 159 => 'ColorBalance' },
	'colorbalanceadj' => { 294 => 0x76a43202 },
	'colorbalanceblue' => { 184 => 0x1e },
	'colorbalancegreen' => { 184 => 0x1d },
	'colorbalancered' => { 184 => 0x1c },
	'colorbalanceversion' => { 209 => 0x4, 210 => 0x4, 211 => 0x0, 212 => 0x0 },
	'colorblur' => { 112 => 0x65 },
	'colorbluron' => { 106 => 0x20704 },
	'colorbooster' => { 294 => 0x5f0e7d23 },
	'colorboostlevel' => { 288 => 0x1 },
	'colorboosttype' => { 288 => 0x0 },
	'colorchromeeffect' => { 130 => 0x1048 },
	'colorchromefxblue' => { 130 => 0x104e },
	'colorclass' => { 390 => 0xde, 391 => 'ColorClass' },
	'colorcompensationfilter' => { 187 => [0x3a,0x5f], 189 => 0x111, 444 => 0xb022 },
	'colorcompensationfiltercustom' => { 431 => 0xd, 432 => 0xc },
	'colorcompensationfilterset' => { 431 => 0x8, 432 => 0x7, 433 => 0x18, 449 => 0xf },
	'colorcontrol' => { 326 => 0x102b },
	'colorcorrection' => { 481 => 0x8015 },
	'colorcorrectionmatrix' => { 1 => 0x3e },
	'colorcreatoreffect' => { 321 => 0x532 },
	'colordataversion' => { 43 => 0x0, 44 => 0x0, 46 => 0x0, 47 => 0x0, 48 => 0x0, 49 => 0x0, 50 => 0x0, 51 => 0x0, 52 => 0x0 },
	'coloreffect' => { 344 => 0x28 },
	'colorfilter' => { 115 => 0x17, 116 => 0x3017, 184 => 0x29, 192 => [0x38,0x4d,0x4f], 386 => 0x17 },
	'colorgain' => { 261 => 0x51 },
	'colorgradeblending' => { 505 => 'ColorGradeBlending', 507 => 'ColorGradeBlending' },
	'colorgradeglobalhue' => { 505 => 'ColorGradeGlobalHue', 507 => 'ColorGradeGlobalHue' },
	'colorgradegloballum' => { 505 => 'ColorGradeGlobalLum', 507 => 'ColorGradeGlobalLum' },
	'colorgradeglobalsat' => { 505 => 'ColorGradeGlobalSat', 507 => 'ColorGradeGlobalSat' },
	'colorgradehighlightlum' => { 505 => 'ColorGradeHighlightLum', 507 => 'ColorGradeHighlightLum' },
	'colorgrademidtonehue' => { 505 => 'ColorGradeMidtoneHue', 507 => 'ColorGradeMidtoneHue' },
	'colorgrademidtonelum' => { 505 => 'ColorGradeMidtoneLum', 507 => 'ColorGradeMidtoneLum' },
	'colorgrademidtonesat' => { 505 => 'ColorGradeMidtoneSat', 507 => 'ColorGradeMidtoneSat' },
	'colorgradeshadowlum' => { 505 => 'ColorGradeShadowLum', 507 => 'ColorGradeShadowLum' },
	'colorhue' => { 106 => 0x20900, 238 => 0x8d },
	'colorimetricreference' => { 122 => 0xc6bf },
	'colorlabel' => { 510 => 'ColorLabel' },
	'colormatrix' => { 65 => 0xa, 325 => 0x200, 326 => 0x1011, 418 => 0xa030 },
	'colormatrix1' => { 122 => 0xc621, 388 => 0x106 },
	'colormatrix2' => { 122 => 0xc622, 329 => 0x200, 388 => 0x226 },
	'colormatrix3' => { 122 => 0xcd33 },
	'colormatrixa' => { 379 => 0x203 },
	'colormatrixa2' => { 379 => 0x21c },
	'colormatrixadobergb' => { 418 => 0xa032 },
	'colormatrixb' => { 379 => 0x204 },
	'colormatrixb2' => { 379 => 0x21d },
	'colormatrixnumber' => { 326 => 0x1019 },
	'colormatrixsrgb' => { 418 => 0xa031 },
	'colormode' => { 116 => 0x3015, 130 => 0x1210, 143 => 0x66, 184 => 0x28, 187 => 0x16, 189 => 0x101, 190 => 0x36, 192 => 0x7, 238 => 0x3, 284 => 0x4, 344 => 0x32, 421 => 0x2c, 444 => 0xb029, 522 => 'ColorMode' },
	'colormoirereduction' => { 106 => 0x20670, 295 => 0x15 },
	'colormoirereductionmode' => { 295 => 0x5 },
	'colormoirereductionon' => { 106 => '0x20670.0' },
	'colornoisereduction' => { 481 => 0x8029, 505 => 'ColorNoiseReduction', 507 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 505 => 'ColorNoiseReductionDetail', 507 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 295 => 0x18 },
	'colornoisereductionsharpness' => { 295 => 0x1c },
	'colornoisereductionsmoothness' => { 505 => 'ColorNoiseReductionSmoothness', 507 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 126 => 0x2 },
	'colorprofile' => { 184 => 0x33 },
	'colorprofilesettings' => { 321 => 0x539 },
	'colorrepresentation' => { 136 => 0x3c },
	'colorsaturationadj' => { 106 => 0x20305 },
	'colorsequence' => { 136 => 0x41 },
	'colorspace' => { 53 => 0x3, 66 => 0xb4, 100 => 0x10b4, 122 => 0xa001, 138 => 0x3, 165 => 'ColorSpace', 185 => 0x2f, 186 => 0x25, 187 => 0x17, 238 => 0x1e, 321 => 0x507, 379 => 0x37, 418 => 0xa011, 421 => 0xb, 431 => 0x1b, 432 => 0x83, 433 => 0xe, 449 => 0x6, 511 => 'ColorSpace' },
	'colorspace2' => { 65 => 0x9 },
	'colorspecapproximation' => { 138 => 0x2 },
	'colorspecdata' => { 138 => 0x3 },
	'colorspecmethod' => { 138 => 0x0 },
	'colorspecprecedence' => { 138 => 0x1 },
	'colortempasshot' => { 40 => 0x4, 41 => 0x7, 42 => 0x1d, 43 => 0x59, 44 => 0x6d, 45 => 0x26, 46 => 0x43, 49 => 0x43, 50 => 0x43, 51 => 0x43, 52 => 0x4b },
	'colortempauto' => { 40 => 0x9, 41 => 0xf, 42 => 0x22, 43 => 0x5e, 44 => 0x72, 45 => 0x1c, 46 => 0x48, 49 => 0x48, 50 => 0x48, 51 => 0x48, 52 => 0x50 },
	'colortempcloudy' => { 40 => 0x22, 41 => 0x37, 42 => 0x31, 43 => 0xa4, 44 => 0xdb, 45 => 0x35, 46 => 0x5c, 49 => 0x75, 50 => 0x8e, 51 => 0x93, 52 => 0x96, 379 => 0x55 },
	'colortempcustom' => { 46 => 0x84 },
	'colortempcustom1' => { 42 => 0x45 },
	'colortempcustom2' => { 42 => 0x4a },
	'colortempdaylight' => { 40 => 0x18, 41 => 0x27, 42 => 0x27, 43 => 0x9a, 44 => 0xd1, 45 => 0x2b, 46 => 0x52, 49 => 0x6b, 50 => 0x84, 51 => 0x89, 52 => 0x8c, 379 => 0x53 },
	'colortemperature' => { 7 => 0x73, 8 => [0x48,0x4e], 9 => 0xc0, 10 => 0x37, 11 => 0x62, 12 => 0x37, 13 => 0x7c, 14 => 0x73, 15 => 0x73, 16 => 0x77, 17 => 0x73, 18 => 0x7c, 19 => 0x58, 20 => 0x73, 21 => 0xc0, 22 => 0x7f, 23 => 0x7d, 24 => 0xc0, 25 => 0xc6, 26 => 0xc7, 27 => 0x135, 28 => 0x7b, 29 => 0x13a, 66 => 0xae, 76 => 0x9, 100 => 0x10ae, 130 => 0x1005, 141 => 0x846, 159 => 'ColorTemperature', 185 => [0x6e,0x49], 186 => 0x3f, 187 => [0x39,0x5e], 189 => 0x10b, 192 => [0x3c,0x4c,0x4e], 339 => 0x321, 379 => 0x50, 411 => 0x1308, 444 => 0xb021, 505 => 'Temperature', 507 => 'Temperature' },
	'colortemperatureadj' => { 481 => 0x8013 },
	'colortemperatureauto' => { 238 => 0x4f },
	'colortemperaturebg' => { 326 => 0x1013 },
	'colortemperaturecustom' => { 431 => 0xc, 432 => 0xb },
	'colortemperaturerg' => { 326 => 0x1014 },
	'colortemperatureset' => { 431 => 0x7, 432 => 0x6 },
	'colortemperaturesetting' => { 187 => 0x25, 433 => 0x17, 449 => 0xe },
	'colortempflash' => { 40 => 0x36, 41 => 0x57, 42 => 0x40, 43 => 0xb8, 44 => 0xef, 45 => 0x49, 46 => 0x70, 49 => 0x89, 50 => 0xa2, 51 => 0xa7, 52 => 0xaa, 379 => 0x5a },
	'colortempflashdata' => { 46 => 0x24a },
	'colortempfluorescent' => { 40 => 0x2c, 41 => 0x47, 42 => 0x3b, 43 => 0xae, 44 => 0xe5, 45 => 0x3f, 46 => 0x66, 49 => 0x7f, 50 => 0x98, 51 => 0x9d, 52 => 0xa0 },
	'colortempfluorescentd' => { 379 => 0x57 },
	'colortempfluorescentn' => { 379 => 0x58 },
	'colortempfluorescentw' => { 379 => 0x59 },
	'colortempkelvin' => { 40 => 0x31, 41 => 0x4f, 43 => 0xb3, 44 => 0xea, 45 => 0x44, 46 => 0x6b, 49 => 0x84, 50 => 0x9d, 51 => 0xa2, 52 => 0xa5, 344 => 0x44, 411 => 0x1307 },
	'colortempmeasured' => { 40 => 0xe, 41 => 0x17, 43 => 0x63, 44 => 0x77, 46 => 0x4d, 49 => 0x4d, 50 => 0x4d, 51 => 0x4d, 52 => 0x55 },
	'colortemppc1' => { 45 => 0x94, 46 => 0x75 },
	'colortemppc2' => { 45 => 0x99, 46 => 0x7a },
	'colortemppc3' => { 45 => 0x9e, 46 => 0x7f },
	'colortempshade' => { 40 => 0x1d, 41 => 0x2f, 42 => 0x2c, 43 => 0x9f, 44 => 0xd6, 45 => 0x30, 46 => 0x57, 49 => 0x70, 50 => 0x89, 51 => 0x8e, 52 => 0x91, 379 => 0x54 },
	'colortemptungsten' => { 40 => 0x27, 41 => 0x3f, 42 => 0x36, 43 => 0xa9, 44 => 0xe0, 45 => 0x3a, 46 => 0x61, 49 => 0x7a, 50 => 0x93, 51 => 0x98, 52 => 0x9b, 379 => 0x56 },
	'colortempunknown' => { 40 => 0x13, 41 => 0x1f, 43 => 0x68, 44 => 0x7c, 45 => 0x21, 49 => 0x52, 50 => 0x52, 51 => 0x52, 52 => 0x5a },
	'colortempunknown10' => { 40 => 0x63, 41 => 0x9f, 43 => 0x95, 44 => 0xa9, 45 => 0x76, 49 => 0xa2, 50 => 0x7f, 51 => 0x7f, 52 => 0x87 },
	'colortempunknown11' => { 40 => 0x68, 41 => 0xa7, 43 => 0xbd, 44 => [0xae,0xb3], 45 => 0x7b, 49 => 0xa7, 50 => 0xa7, 51 => 0x84, 52 => 0xaf },
	'colortempunknown12' => { 40 => 0x6d, 41 => 0xaf, 43 => 0xc2, 44 => 0xb8, 45 => 0x80, 49 => 0xac, 50 => 0xac, 51 => 0xac, 52 => 0xb4 },
	'colortempunknown13' => { 40 => 0x72, 41 => 0xb7, 43 => 0xc7, 44 => 0xbd, 45 => 0x85, 49 => 0xb1, 50 => 0xb1, 51 => 0xb1, 52 => 0xb9 },
	'colortempunknown14' => { 43 => 0xcc, 44 => 0xc2, 45 => 0x8a, 49 => 0xb6, 50 => 0xb6, 51 => 0xb6, 52 => 0xbe },
	'colortempunknown15' => { 43 => 0xd1, 44 => 0xc7, 45 => 0x8f, 49 => 0xbb, 50 => 0xbb, 51 => 0xbb, 52 => 0xc3 },
	'colortempunknown16' => { 43 => 0xd6, 44 => 0xcc, 45 => 0xa3, 50 => 0xc0, 51 => 0xc0, 52 => 0xc8 },
	'colortempunknown17' => { 43 => 0xdb, 44 => 0xf4, 50 => 0xc5, 51 => 0xc5, 52 => 0xcd },
	'colortempunknown18' => { 43 => 0xe0, 44 => 0xf9, 50 => 0xca, 51 => 0xca, 52 => 0xd2 },
	'colortempunknown19' => { 43 => 0xe5, 44 => 0xfe, 50 => 0xcf, 51 => 0xcf, 52 => 0xd7 },
	'colortempunknown2' => { 40 => 0x3b, 41 => 0x5f, 43 => 0x6d, 44 => 0x81, 45 => 0x4e, 49 => 0x57, 50 => 0x57, 51 => 0x57, 52 => 0x5f },
	'colortempunknown20' => { 43 => 0xea, 44 => 0x103, 50 => 0xd4, 51 => 0xd4, 52 => 0xdc },
	'colortempunknown21' => { 43 => 0xef, 44 => 0x108, 51 => 0xd9, 52 => 0xe1 },
	'colortempunknown22' => { 43 => 0xf4, 44 => 0x10d, 51 => 0xde, 52 => 0xe6 },
	'colortempunknown23' => { 43 => 0xf9, 44 => 0x112, 51 => 0xe3, 52 => 0xeb },
	'colortempunknown24' => { 43 => 0xfe, 44 => 0x117, 51 => 0xe8, 52 => 0xf0 },
	'colortempunknown25' => { 43 => 0x103, 44 => 0x11c, 51 => 0xed, 52 => 0xf5 },
	'colortempunknown26' => { 43 => 0x108, 44 => 0x121, 51 => 0xf2, 52 => 0xfa },
	'colortempunknown27' => { 43 => 0x10d, 44 => 0x126, 51 => 0xf7, 52 => 0xff },
	'colortempunknown28' => { 43 => 0x112, 51 => 0xfc, 52 => 0x104 },
	'colortempunknown29' => { 43 => 0x117, 51 => 0x101, 52 => 0x109 },
	'colortempunknown3' => { 40 => 0x40, 41 => 0x67, 43 => 0x72, 44 => 0x86, 45 => 0x53, 49 => 0x5c, 50 => 0x5c, 51 => 0x5c, 52 => 0x64 },
	'colortempunknown30' => { 51 => 0x106 },
	'colortempunknown4' => { 40 => 0x45, 41 => 0x6f, 43 => 0x77, 44 => 0x8b, 45 => 0x58, 49 => 0x61, 50 => 0x61, 51 => 0x61, 52 => 0x69 },
	'colortempunknown5' => { 40 => 0x4a, 41 => 0x77, 43 => 0x7c, 44 => 0x90, 45 => 0x5d, 49 => 0x66, 50 => 0x66, 51 => 0x66, 52 => 0x6e },
	'colortempunknown6' => { 40 => 0x4f, 41 => 0x7f, 43 => 0x81, 44 => 0x95, 45 => 0x62, 49 => 0x8e, 50 => 0x6b, 51 => 0x6b, 52 => 0x73 },
	'colortempunknown7' => { 40 => 0x54, 41 => 0x87, 43 => 0x86, 44 => 0x9a, 45 => 0x67, 49 => 0x93, 50 => 0x70, 51 => 0x70, 52 => 0x78 },
	'colortempunknown8' => { 40 => 0x59, 41 => 0x8f, 43 => 0x8b, 44 => 0x9f, 45 => 0x6c, 49 => 0x98, 50 => 0x75, 51 => 0x75, 52 => 0x7d },
	'colortempunknown9' => { 40 => 0x5e, 41 => 0x97, 43 => 0x90, 44 => 0xa4, 45 => 0x71, 49 => 0x9d, 50 => 0x7a, 51 => 0x7a, 52 => 0x82 },
	'colortint' => { 343 => 0x35c },
	'colortone' => { 10 => 0x6f, 12 => 0x77, 36 => 0x2a, 53 => 0x2, 65 => 0x8 },
	'colortoneadj' => { 106 => 0x20304, 111 => 0x11e },
	'colortoneauto' => { 73 => 0x9c },
	'colortonefaithful' => { 19 => 0x107, 72 => 0x6c, 73 => 0x6c },
	'colortonelandscape' => { 19 => 0x105, 72 => 0x3c, 73 => 0x3c },
	'colortonemonochrome' => { 72 => 0x84, 73 => 0x84 },
	'colortoneneutral' => { 19 => 0x106, 72 => 0x54, 73 => 0x54 },
	'colortoneportrait' => { 19 => 0x104, 72 => 0x24, 73 => 0x24 },
	'colortonestandard' => { 19 => 0x103, 72 => 0xc, 73 => 0xc },
	'colortoneuserdef1' => { 19 => 0x109, 72 => 0x9c, 73 => 0xb4 },
	'colortoneuserdef2' => { 19 => 0x10a, 72 => 0xb4, 73 => 0xcc },
	'colortoneuserdef3' => { 19 => 0x10b, 72 => 0xcc, 73 => 0xe4 },
	'columninterleavefactor' => { 122 => 0xcd43 },
	'comlenblksize' => { 141 => 0xfde8 },
	'commanddialplaybackmode' => { 317 => 0x1cb, 318 => 0x1cb, 319 => 0x1e3 },
	'commanddials' => { 312 => '5.1' },
	'commanddialsaperturesetting' => { 301 => '17.3', 302 => '18.3', 304 => '18.3', 305 => '18.3', 310 => '33.3', 311 => '17.3', 314 => '18.3', 315 => '18.3' },
	'commanddialschangemainsub' => { 301 => '17.2', 302 => '18.1', 304 => '18.1', 305 => '18.1', 310 => '33.2', 311 => '17.2', 314 => '18.1', 315 => '18.1' },
	'commanddialsmenuandplayback' => { 301 => '17.4', 302 => '18.2', 304 => '18.2', 305 => '18.2', 310 => '33.4', 311 => '17.4', 314 => '18.2', 315 => '18.2' },
	'commanddialsreverserotation' => { 301 => '17.1', 302 => '6.4', 304 => '6.2', 305 => '6.2', 306 => '16.2', 307 => '17.2', 310 => '33.1', 311 => '17.1', 314 => '6.2', 315 => '6.2', 316 => '18.1' },
	'commanderchannel' => { 312 => '10.2', 313 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 312 => '13.1', 313 => '31.1' },
	'commandergroupa_ttlcomp' => { 316 => '32.1' },
	'commandergroupamanualoutput' => { 312 => '13.2', 313 => '28.2' },
	'commandergroupamode' => { 312 => '11.2', 313 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 312 => '14.1', 313 => '32.1' },
	'commandergroupb_ttlcomp' => { 316 => '33.1' },
	'commandergroupbmanualoutput' => { 312 => '14.2', 313 => '29.2' },
	'commandergroupbmode' => { 312 => '11.3', 313 => '29.1' },
	'commanderinternalflash' => { 312 => '11.1', 313 => '27.1' },
	'commanderinternalmanualoutput' => { 312 => '12.2', 313 => '27.2' },
	'commanderinternalttlchannel' => { 310 => '18.2' },
	'commanderinternalttlcomp' => { 312 => '12.1', 313 => '30.2', 316 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 310 => '20.1', 311 => '26.1' },
	'commanderinternalttlcompgroupa' => { 310 => '21.1', 311 => '27.1' },
	'commanderinternalttlcompgroupb' => { 310 => '22.1', 311 => '28.1' },
	'comment' => { 0 => 0x2, 123 => 'Comment', 160 => 'Comment', 334 => 'Comment', 396 => "\xa9cmt", 398 => 'comment', 404 => "\xa9cmt" },
	'compass' => { 414 => 0x4 },
	'compatibleversion' => { 505 => 'CompatibleVersion', 507 => 'CompatibleVersion' },
	'compilation' => { 396 => 'cpil' },
	'compimageimagespersequence' => { 512 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfImagesInSequences'] },
	'compimagemaxexposureall' => { 512 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfAll'] },
	'compimagemaxexposureused' => { 512 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfUsed'] },
	'compimageminexposureall' => { 512 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfAll'] },
	'compimageminexposureused' => { 512 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfUsed'] },
	'compimagenumsequences' => { 512 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfSequences'] },
	'compimagesumexposureall' => { 512 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfAll'] },
	'compimagesumexposureused' => { 512 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfUsed'] },
	'compimagetotalexposureperiod' => { 512 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesTotalExposurePeriod'] },
	'compimagevalues' => { 512 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesValues'] },
	'complianceprofile' => { 524 => 'complianceProfile' },
	'componentsconfiguration' => { 122 => 0x9101, 165 => 'Components', 511 => 'ComponentsConfiguration' },
	'componentversion' => { 100 => 0x80c },
	'composer' => { 182 => 'WM/Composer', 396 => ["\xa9com","\xa9wrt"], 404 => ["\xa9com","\xa9wrt"], 534 => 'composer' },
	'composerid' => { 396 => 'cmID' },
	'composerkeywords' => { 404 => "\xa9cok" },
	'compositeimage' => { 122 => 0xa460, 512 => 'CompositeImage' },
	'compositeimagecount' => { 122 => 0xa461, 512 => 'CompositeImageCount' },
	'compositeimageexposuretimes' => { 122 => 0xa462, 512 => 'CompositeImageExposureTimes' },
	'composition' => { 495 => 'Composition' },
	'compositionadjust' => { 378 => '0.1' },
	'compositionadjustrotation' => { 378 => 0x7 },
	'compositionadjustx' => { 378 => 0x5 },
	'compositionadjusty' => { 378 => 0x6 },
	'compressedbitsperpixel' => { 122 => 0x9102, 511 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 189 => 0x40, 326 => 0x40 },
	'compression' => { 122 => 0x103, 349 => 0xb, 530 => 'Compression' },
	'compressionfactor' => { 321 => 0x50d },
	'compressionformat' => { 65 => 0x4 },
	'compressionratio' => { 165 => 'Compression', 326 => 0x1034 },
	'compressorversion' => { 404 => 'CNCV' },
	'condadobvfactor' => { 141 => 0xf3e },
	'condadodaybvthresh' => { 141 => 0xf3c },
	'condadodayoffsets' => { 141 => 0xf42 },
	'condadofluoffsets' => { 141 => 0xf44 },
	'condadofluthresh' => { 141 => 0xf41 },
	'condadoillfactor' => { 141 => 0xf3f },
	'condadoneurange' => { 141 => 0xf3d },
	'condadotunoffsets' => { 141 => 0xf43 },
	'condadotunthresh' => { 141 => 0xf40 },
	'conductor' => { 182 => 'WM/Conductor', 396 => "\xa9con" },
	'confidence' => { 490 => 'Confidence' },
	'confidencelevel' => { 501 => 'ConfidenceLevel' },
	'confidencemime' => { 490 => 'ConfidenceMime' },
	'constrainedcropheight' => { 111 => 0x266, 390 => 0xd6 },
	'constrainedcropwidth' => { 111 => 0x262, 390 => 0xd5 },
	'contact' => { 134 => 0x76 },
	'contactinfo' => { 505 => 'ContactInfo', 507 => 'ContactInfo', 523 => 'contactInfo' },
	'container' => { 484 => 'Container' },
	'containerdirectory' => { 484 => [\'Container','ContainerDirectory'] },
	'containerdirectoryitem' => { 484 => [\'Container','ContainerDirectoryItem'] },
	'containerdirectoryitemdatauri' => { 484 => [\'Container','ContainerDirectoryItemDataURI'] },
	'containerdirectoryitemlength' => { 484 => [\'Container','ContainerDirectoryItemLength'] },
	'containerdirectoryitemmime' => { 484 => [\'Container','ContainerDirectoryItemMime'] },
	'containerdirectoryitempadding' => { 484 => [\'Container','ContainerDirectoryItemPadding'] },
	'containerformat' => { 519 => 'ContainerFormat' },
	'containerformatidentifier' => { 519 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 519 => [\'ContainerFormat','ContainerFormatName'] },
	'contentcreatedate' => { 396 => "\xa9day", 404 => ['@day',"\xa9day"] },
	'contentdistributor' => { 182 => 'WM/ContentDistributor' },
	'contentdistributorid' => { 404 => 'cdis' },
	'contentid' => { 404 => 'ccid' },
	'contentidentifier' => { 1 => 0x11, 398 => 'content.identifier' },
	'contentlocationcode' => { 134 => 0x1a },
	'contentlocationname' => { 134 => 0x1b },
	'contenttype' => { 524 => 'contentType' },
	'continuousbracketing' => { 187 => 0x20 },
	'continuousdrive' => { 36 => 0x5 },
	'continuousmodedisplay' => { 317 => 0x51, 318 => 0x51, 319 => 0x51 },
	'continuousmodeliveview' => { 315 => '77.2' },
	'continuousshootingspeed' => { 87 => 0x610 },
	'continuousshotlimit' => { 87 => 0x611 },
	'contrast' => { 10 => 0x73, 12 => 0x75, 36 => 0xd, 115 => 0xc, 116 => [0x3012,0x20], 122 => [0xa408,0xfe54], 130 => [0x1004,0x1006], 159 => 'Contrast', 179 => 'Contrast', 184 => 0x20, 185 => 0x31, 186 => 0x27, 187 => 0x19, 192 => 0x2, 253 => 0x33, 254 => 0x37, 255 => 0x3f, 326 => 0x1029, 344 => 0x39, 346 => 0x300a, 379 => 0x20, 386 => 0xc, 398 => 'player.movie.visual.contrast', 405 => 0x24, 407 => 0x52, 411 => 0x1012, 421 => 0xd, 431 => 0x1d, 432 => 0x1a, 444 => 0x2004, 505 => 'Contrast', 507 => 'Contrast', 511 => 'Contrast' },
	'contrast2012' => { 505 => 'Contrast2012', 507 => 'Contrast2012' },
	'contrastadj' => { 106 => 0x20303, 111 => 0x115, 297 => 0x2c, 481 => 0x8017 },
	'contrastauto' => { 73 => 0x90 },
	'contrastcurve' => { 238 => 0x8c },
	'contrastdetectaf' => { 196 => 0x4 },
	'contrastdetectafarea' => { 379 => 0x231 },
	'contrastdetectafinfocus' => { 196 => [0x1c,0x52] },
	'contrastfaithful' => { 19 => 0xec, 72 => 0x60, 73 => 0x60 },
	'contrasthighlight' => { 379 => 0x6d },
	'contrasthighlightshadowadj' => { 379 => 0x6f },
	'contrastlandscape' => { 19 => 0xea, 72 => 0x30, 73 => 0x30 },
	'contrastmode' => { 344 => 0x2c },
	'contrastmonochrome' => { 19 => 0xed, 72 => 0x78, 73 => 0x78 },
	'contrastneutral' => { 19 => 0xeb, 72 => 0x48, 73 => 0x48 },
	'contrastportrait' => { 19 => 0xe9, 72 => 0x18, 73 => 0x18 },
	'contrastsetting' => { 321 => 0x505, 329 => 0x1012, 433 => 0x10, 449 => 0x8 },
	'contrastshadow' => { 379 => 0x6e },
	'contraststandard' => { 19 => 0xe8, 72 => 0x0, 73 => 0x0 },
	'contrastuserdef1' => { 19 => 0xee, 72 => 0x90, 73 => 0xa8 },
	'contrastuserdef2' => { 19 => 0xef, 72 => 0xa8, 73 => 0xc0 },
	'contrastuserdef3' => { 19 => 0xf0, 72 => 0xc0, 73 => 0xd8 },
	'contributedmedia' => { 534 => 'contributedMedia' },
	'contributedmediaduration' => { 534 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 534 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 534 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 534 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 534 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 534 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 534 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 534 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 534 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 534 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 508 => 'contributor', 519 => 'Contributor' },
	'contributoridentifier' => { 519 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 519 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 519 => [\'Contributor','ContributorRole'] },
	'contributors' => { 160 => 'Contributors' },
	'controldialset' => { 187 => 0x46 },
	'controlledvocabularyterm' => { 519 => 'CVterm' },
	'controllerboardversion' => { 339 => 0x332 },
	'controlmode' => { 79 => 0x12 },
	'controlringresponse' => { 317 => 0x1d5, 318 => 0x1d5, 319 => 0x1ed },
	'controlringrotation' => { 87 => 0x712 },
	'conversionlens' => { 322 => 0x403, 344 => 0x35 },
	'converter' => { 122 => 0xfe4d, 284 => 0xb, 505 => 'Converter', 507 => 'Converter' },
	'converttograyscale' => { 505 => 'ConvertToGrayscale', 507 => 'ConvertToGrayscale' },
	'cookingequipment' => { 526 => 'cookingEquipment' },
	'cookingmethod' => { 526 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 122 => 0x8298, 160 => 'Copyright', 334 => 'Copyright', 349 => 0x8298, 379 => 0x22f, 395 => 'Copyright', 396 => ['cprt',"\xa9cpy"], 398 => 'copyright', 404 => ['cprt',"\xa9cpy"], 505 => 'Copyright', 507 => 'Copyright', 521 => 'Copyright', 527 => 'copyright', 530 => 'Copyright', 534 => 'copyright' },
	'copyrightflag' => { 393 => 0x40a },
	'copyrightnotice' => { 134 => 0x74 },
	'copyrightowner' => { 331 => 'CopyrightOwner' },
	'copyrightownerid' => { 331 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 331 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 331 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 331 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 331 => 'CopyrightStatus' },
	'copyrightyear' => { 519 => 'CopyrightYear', 524 => 'copyrightYear' },
	'coringfilter' => { 325 => 0x310, 326 => 0x102d, 329 => 0x310 },
	'coringvalues' => { 325 => 0x311, 329 => 0x311 },
	'corporateentity' => { 524 => 'corporateEntity' },
	'correlatedcolortemp' => { 343 => 0x35b },
	'country' => { 164 => 'Country', 344 => 0x69, 522 => 'Country' },
	'country-primarylocationcode' => { 134 => 0x64 },
	'country-primarylocationname' => { 134 => 0x65 },
	'countrycode' => { 237 => 0x5, 391 => 'CountryCode', 518 => 'CountryCode' },
	'course' => { 526 => 'course' },
	'coverage' => { 508 => 'coverage' },
	'coverart' => { 396 => 'covr' },
	'coverdate' => { 524 => 'coverDate' },
	'coverdisplaydate' => { 524 => 'coverDisplayDate' },
	'coveruri' => { 404 => 'cvru' },
	'cpufirmwareversion' => { 379 => 0x28 },
	'crc32' => { 509 => 'crc32' },
	'createdate' => { 122 => 0x9004, 160 => 'CreateDate', 330 => 'CreationDate', 334 => 'create-date', 395 => 'CreationDate', 401 => 0x1, 532 => 'CreateDate' },
	'creationdate' => { 398 => 'creationdate', 521 => 'CreationDate', 524 => 'creationDate' },
	'creationtime' => { 334 => 'Creation Time' },
	'creativestyle' => { 431 => 0x1a, 432 => 0x18, 442 => 0x41, 444 => 0xb020, 476 => 0x4a },
	'creativestylesetting' => { 433 => 0xf, 449 => 0x7 },
	'creativestylewaschanged' => { 481 => 0x8001 },
	'creator' => { 330 => 'Creator', 395 => 'Creator', 508 => 'creator', 519 => 'Creator', 521 => 'Creator' },
	'creatoraddress' => { 518 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 181 => 'CreatorAppId' },
	'creatorcity' => { 518 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 518 => 'CreatorContactInfo' },
	'creatorcountry' => { 518 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 519 => [\'Creator','CreatorIdentifier'] },
	'creatoridentity' => { 391 => 'CreatorIdentity' },
	'creatorname' => { 519 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 181 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 518 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 518 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 519 => [\'Creator','CreatorRole'] },
	'creatortool' => { 532 => 'CreatorTool' },
	'creatorworkemail' => { 518 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 518 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 518 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 134 => 0x6e, 522 => 'Credit' },
	'creditline' => { 527 => 'creditLine' },
	'creditlinereq' => { 537 => 'CreditLineReq' },
	'creditlinerequired' => { 331 => 'CreditLineRequired' },
	'cropactive' => { 104 => 0x0, 111 => 0x244 },
	'cropangle' => { 505 => 'CropAngle', 507 => 'CropAngle' },
	'croparea' => { 238 => 0x45, 481 => 0x9011 },
	'cropaspectratio' => { 106 => 0x30101, 111 => 0x260 },
	'cropaspectratiocustom' => { 106 => 0x30102 },
	'cropbottom' => { 126 => 0x9, 289 => 0x36, 349 => 0x31, 390 => 0xdc, 505 => 'CropBottom', 507 => 'CropBottom' },
	'cropbottommargin' => { 55 => 0x3 },
	'cropcircleactive' => { 112 => 0xd6 },
	'cropcircleradius' => { 112 => 0xd9 },
	'cropcirclex' => { 112 => 0xd7 },
	'cropcircley' => { 112 => 0xd8 },
	'cropconstraintowarp' => { 505 => 'CropConstrainToWarp', 507 => 'CropConstrainToWarp' },
	'croph' => { 499 => 'CropH' },
	'cropheight' => { 104 => 0x6, 111 => 0x24c, 325 => 0x615, 329 => 0x615, 505 => 'CropHeight', 507 => 'CropHeight' },
	'crophispeed' => { 238 => 0x1b },
	'cropleft' => { 111 => 0x246, 126 => 0x6, 289 => 0x1e, 325 => 0x612, 329 => 0x612, 349 => 0x30, 390 => 0xd9, 505 => 'CropLeft', 507 => 'CropLeft' },
	'cropleftmargin' => { 55 => 0x0 },
	'cropmode' => { 130 => 0x104d, 411 => 0x1018 },
	'croporiginalheight' => { 104 => 0xb },
	'croporiginalwidth' => { 104 => 0xa },
	'cropoutputheight' => { 289 => 0xce },
	'cropoutputheightinches' => { 289 => 0x96 },
	'cropoutputpixels' => { 289 => 0xd6 },
	'cropoutputresolution' => { 289 => 0xb6 },
	'cropoutputscale' => { 289 => 0xbe },
	'cropoutputwidth' => { 289 => 0xc6 },
	'cropoutputwidthinches' => { 289 => 0x8e },
	'croppedareaimageheightpixels' => { 493 => 'CroppedAreaImageHeightPixels', 494 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 493 => 'CroppedAreaImageWidthPixels', 494 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 493 => 'CroppedAreaLeftPixels', 494 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 493 => 'CroppedAreaTopPixels', 494 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 411 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 411 => 0x1603 },
	'cropping' => { 481 => 0x9010 },
	'cropright' => { 126 => 0x8, 289 => 0x2e, 349 => 0x32, 390 => 0xdb, 505 => 'CropRight', 507 => 'CropRight' },
	'croprightmargin' => { 55 => 0x1 },
	'croprotatedoriginalheight' => { 104 => 0x2 },
	'croprotatedoriginalwidth' => { 104 => 0x1 },
	'croprotation' => { 104 => 0x8, 126 => 0xb },
	'cropscaledresolution' => { 289 => 0x9e },
	'cropsourceresolution' => { 289 => 0xae },
	'croptop' => { 111 => 0x248, 126 => 0x7, 289 => 0x26, 325 => 0x613, 329 => 0x613, 349 => 0x2f, 390 => 0xda, 505 => 'CropTop', 507 => 'CropTop' },
	'croptopmargin' => { 55 => 0x2 },
	'cropunit' => { 505 => 'CropUnit', 507 => 'CropUnit' },
	'cropunits' => { 505 => 'CropUnits', 507 => 'CropUnits' },
	'cropw' => { 499 => 'CropW' },
	'cropwidth' => { 104 => 0x5, 111 => 0x24a, 325 => 0x614, 329 => 0x614, 505 => 'CropWidth', 507 => 'CropWidth' },
	'cropx' => { 104 => 0x3, 499 => 'CropX' },
	'cropy' => { 104 => 0x4, 499 => 'CropY' },
	'crossprocess' => { 379 => 0x7b },
	'crossprocessparams' => { 379 => 0x235 },
	'cuisine' => { 526 => 'cuisine' },
	'currenticcprofile' => { 122 => 0xc691 },
	'currentpreprofilematrix' => { 122 => 0xc692 },
	'currentversion' => { 481 => 0xd000 },
	'curve0x' => { 499 => 'Curve0x' },
	'curve0y' => { 499 => 'Curve0y' },
	'curve1x' => { 499 => 'Curve1x' },
	'curve1y' => { 499 => 'Curve1y' },
	'curve2x' => { 499 => 'Curve2x' },
	'curve2y' => { 499 => 'Curve2y' },
	'curve3x' => { 499 => 'Curve3x' },
	'curve3y' => { 499 => 'Curve3y' },
	'curve4x' => { 499 => 'Curve4x' },
	'curve4y' => { 499 => 'Curve4y' },
	'curves' => { 294 => 0x76a43201 },
	'custom1' => { 331 => 'Custom1' },
	'custom10' => { 331 => 'Custom10' },
	'custom2' => { 331 => 'Custom2' },
	'custom3' => { 331 => 'Custom3' },
	'custom4' => { 331 => 'Custom4' },
	'custom5' => { 331 => 'Custom5' },
	'custom6' => { 331 => 'Custom6' },
	'custom7' => { 331 => 'Custom7' },
	'custom8' => { 331 => 'Custom8' },
	'custom9' => { 331 => 'Custom9' },
	'customcolortone' => { 112 => 0x4c },
	'customcontrast' => { 112 => 0x4e },
	'customcontrols' => { 87 => 0x70c },
	'customdefaultunsharpfineness' => { 112 => 0xbe },
	'customdefaultunsharpstrength' => { 112 => 0xbc },
	'customdefaultunsharpthreshold' => { 112 => 0xc0 },
	'customilluminant' => { 141 => 0x405 },
	'customizedials' => { 87 => 0x715 },
	'customlinear' => { 112 => 0x4f },
	'customoutputhighlightpoint' => { 112 => 0x53 },
	'customoutputshadowpoint' => { 112 => 0x54 },
	'custompicturestyle' => { 106 => 0x10021 },
	'custompicturestyledata' => { 106 => 0xf0500 },
	'custompicturestylefilename' => { 66 => 0x4010 },
	'customrawhighlight' => { 112 => 0x7c },
	'customrawhighlightpoint' => { 112 => 0x51 },
	'customrawshadow' => { 112 => 0x85 },
	'customrawshadowpoint' => { 112 => 0x52 },
	'customrendered' => { 122 => 0xa401, 194 => 0x6420, 511 => 'CustomRendered' },
	'customsaturation' => { 112 => 0x4d, 321 => 0x503 },
	'customsettingsalldefault' => { 301 => '0.2', 310 => '0.2' },
	'customsettingsbank' => { 301 => '0.1', 302 => '0.1', 304 => '0.1', 305 => '0.1', 310 => '0.1', 314 => '0.2', 315 => '0.2', 317 => 0x1, 318 => 0x1, 319 => 0x1 },
	'customsharpness' => { 112 => 0x50 },
	'customunsharpmaskfineness' => { 112 => 0xb8 },
	'customunsharpmaskstrength' => { 112 => 0xb6 },
	'customunsharpmaskthreshold' => { 112 => 0xba },
	'customwb_rblevels' => { 449 => 0x1a },
	'customwb_rgblevels' => { 432 => 0x8, 433 => 0x19 },
	'customwbbluelevel' => { 187 => 0x36 },
	'customwberror' => { 187 => 0x37 },
	'customwbgreenlevel' => { 187 => 0x35 },
	'customwbredlevel' => { 187 => 0x34 },
	'customwbsetting' => { 187 => 0x26 },
	'cx' => { 404 => '_cx_' },
	'cy' => { 404 => '_cy_' },
	'd-lightinghq' => { 294 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 290 => 0x2 },
	'd-lightinghqhighlight' => { 290 => 0x1 },
	'd-lightinghqselected' => { 294 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 290 => 0x0 },
	'd-lightinghs' => { 294 => 0xce5554aa },
	'd-lightinghsadjustment' => { 291 => 0x0 },
	'd-lightinghscolorboost' => { 291 => 0x1 },
	'd-rangeoptimizerhighlight' => { 481 => 0x8024 },
	'd-rangeoptimizermode' => { 481 => 0x8022 },
	'd-rangeoptimizershadow' => { 481 => 0x802d },
	'd-rangeoptimizervalue' => { 481 => 0x8023 },
	'darkblacksegrows' => { 141 => 0x18d8 },
	'darkfocusenvironment' => { 344 => 0x8003 },
	'darkframecountfactor' => { 141 => 0xc85 },
	'darkframelongexposure' => { 141 => 0xc84 },
	'darkframeshortexposure' => { 141 => 0xc83 },
	'darkpedestal' => { 141 => 0xc7f },
	'datacompressionmethod' => { 136 => 0x6e },
	'dataimprint' => { 184 => 0x34 },
	'datamining' => { 331 => 'DataMining' },
	'dataonscreen' => { 519 => 'DataOnScreen' },
	'dataonscreenregion' => { 519 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 519 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 519 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 519 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 519 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 519 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 519 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 519 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 379 => 0x3d },
	'date' => { 379 => 0x6, 508 => 'date' },
	'dateacquired' => { 181 => 'DateAcquired', 182 => '{2CBAA8F5-D81F-47CA-B17A-F8D822300131} 100' },
	'datecreated' => { 134 => 0x37, 522 => 'DateCreated' },
	'datedisplayformat' => { 286 => 0x3 },
	'dateidentified' => { 121 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 306 => '4.2' },
	'daterecieved' => { 524 => 'dateRecieved' },
	'datesent' => { 135 => 0x46 },
	'datestampmode' => { 66 => 0x1c, 238 => 0x9d },
	'datetime' => { 500 => 'datetime', 530 => 'DateTime' },
	'datetimedigitized' => { 511 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 103 => 0x0, 122 => 0x9003, 157 => 0x14, 160 => 'OriginalDate', 399 => 'IDIT', 404 => 'date', 405 => 0xb, 406 => 0x3b, 407 => 0x3e, 511 => 'DateTimeOriginal' },
	'datetimestamp' => { 143 => 0x64 },
	'datetimeutc' => { 321 => 0x908 },
	'daylightsavings' => { 80 => 0x3, 286 => 0x2 },
	'dayofweek' => { 406 => 0x42, 407 => 0x4a },
	'dccontinent' => { 121 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 121 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 121 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 121 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 121 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 121 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 121 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 121 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 121 => 'Event' },
	'dcfootprintspatialfit' => { 121 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 121 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 121 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 121 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 121 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 121 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 121 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 121 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 121 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 121 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 121 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 121 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 121 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 121 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 121 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 121 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 121 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 121 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 121 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 121 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 121 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 121 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 121 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 121 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 121 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 121 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 121 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 121 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 121 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 121 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 121 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 121 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 121 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 121 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 121 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 121 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcverticaldatum' => { 121 => [\'dctermsLocation','dctermsLocationVerticalDatum'] },
	'dcwaterbody' => { 121 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 168 => 'Declination' },
	'decposition' => { 184 => 0x32 },
	'defaultautogray' => { 505 => 'DefaultAutoGray', 507 => 'DefaultAutoGray' },
	'defaultautotone' => { 505 => 'DefaultAutoTone', 507 => 'DefaultAutoTone' },
	'defaultblackrender' => { 122 => 0xc7a6 },
	'defaultcroporigin' => { 122 => 0xc61f },
	'defaultcropsize' => { 122 => 0xc620 },
	'defaulteraseoption' => { 87 => 0x813 },
	'defaultscale' => { 122 => 0xc61e },
	'defaultsspecifictoiso' => { 505 => 'DefaultsSpecificToISO', 507 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 505 => 'DefaultsSpecificToSerial', 507 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 122 => 0xc7b5 },
	'defectisocode' => { 141 => 0x90f },
	'defringe' => { 505 => 'Defringe', 507 => 'Defringe' },
	'defringegreenamount' => { 505 => 'DefringeGreenAmount', 507 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 505 => 'DefringeGreenHueHi', 507 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 505 => 'DefringeGreenHueLo', 507 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 505 => 'DefringePurpleAmount', 507 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 505 => 'DefringePurpleHueHi', 507 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 505 => 'DefringePurpleHueLo', 507 => 'DefringePurpleHueLo' },
	'dehaze' => { 505 => 'Dehaze', 507 => 'Dehaze' },
	'deletedimagecount' => { 238 => 0xa6, 266 => 0x6e },
	'deprecatedon' => { 503 => 'deprecatedOn' },
	'depthbasedcorrcorrectionactive' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionActive'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionActive'] },
	'depthbasedcorrcorrectionamount' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionAmount'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionAmount'] },
	'depthbasedcorrcorrectionsyncid' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionSyncID'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionSyncID'] },
	'depthbasedcorrections' => { 505 => 'DepthBasedCorrections', 507 => 'DepthBasedCorrections' },
	'depthbasedcorrlocalcorrecteddepth' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCorrectedDepth'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCorrectedDepth'] },
	'depthbasedcorrlocalcurverefinesaturation' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCurveRefineSaturation'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCurveRefineSaturation'] },
	'depthbasedcorrmask' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasks'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasks'] },
	'depthbasedcorrmaskalpha' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAlpha'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAlpha'] },
	'depthbasedcorrmaskangle' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAngle'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAngle'] },
	'depthbasedcorrmaskbottom' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksBottom'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksBottom'] },
	'depthbasedcorrmaskcentervalue' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterValue'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterValue'] },
	'depthbasedcorrmaskcenterweight' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterWeight'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterWeight'] },
	'depthbasedcorrmaskdabs' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksDabs'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksDabs'] },
	'depthbasedcorrmaskfeather' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFeather'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFeather'] },
	'depthbasedcorrmaskflipped' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlipped'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlipped'] },
	'depthbasedcorrmaskflow' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlow'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlow'] },
	'depthbasedcorrmaskfullx' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullX'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullX'] },
	'depthbasedcorrmaskfully' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullY'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullY'] },
	'depthbasedcorrmaskinputdigest' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksInputDigest'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksInputDigest'] },
	'depthbasedcorrmaskleft' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksLeft'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksLeft'] },
	'depthbasedcorrmaskmaskactive' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskActive'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskActive'] },
	'depthbasedcorrmaskmaskblendmode' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskBlendMode'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'depthbasedcorrmaskmaskdigest' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskDigest'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskDigest'] },
	'depthbasedcorrmaskmaskinverted' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskInverted'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskInverted'] },
	'depthbasedcorrmaskmaskname' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskName'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskName'] },
	'depthbasedcorrmaskmasks' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasks'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasks'] },
	'depthbasedcorrmaskmasksalpha' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAlpha'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'depthbasedcorrmaskmasksangle' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAngle'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAngle'] },
	'depthbasedcorrmaskmasksbottom' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksBottom'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksBottom'] },
	'depthbasedcorrmaskmaskscentervalue' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterValue'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'depthbasedcorrmaskmaskscenterweight' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterWeight'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'depthbasedcorrmaskmasksdabs' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksDabs'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksDabs'] },
	'depthbasedcorrmaskmasksfeather' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFeather'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFeather'] },
	'depthbasedcorrmaskmasksflipped' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlipped'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'depthbasedcorrmaskmasksflow' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlow'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlow'] },
	'depthbasedcorrmaskmasksfullx' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullX'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullX'] },
	'depthbasedcorrmaskmasksfully' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullY'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullY'] },
	'depthbasedcorrmaskmasksinputdigest' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksInputDigest'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'depthbasedcorrmaskmasksleft' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksLeft'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksLeft'] },
	'depthbasedcorrmaskmasksmaskactive' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskActive'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'depthbasedcorrmaskmasksmaskblendmode' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'depthbasedcorrmaskmasksmaskdigest' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskDigest'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'depthbasedcorrmaskmasksmaskinverted' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskInverted'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'depthbasedcorrmaskmasksmaskname' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskName'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'depthbasedcorrmaskmasksmasksubtype' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSubType'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'depthbasedcorrmaskmasksmasksyncid' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'depthbasedcorrmaskmasksmaskversion' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskVersion'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'depthbasedcorrmaskmasksmidpoint' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMidpoint'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'depthbasedcorrmaskmasksorigin' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksOrigin'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'depthbasedcorrmaskmasksperimetervalue' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'depthbasedcorrmaskmasksradius' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRadius'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRadius'] },
	'depthbasedcorrmaskmasksreferencepoint' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksReferencePoint'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'depthbasedcorrmaskmasksright' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRight'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRight'] },
	'depthbasedcorrmaskmasksroundness' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRoundness'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'depthbasedcorrmaskmaskssizex' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeX'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'depthbasedcorrmaskmaskssizey' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeY'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'depthbasedcorrmaskmaskstop' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksTop'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksTop'] },
	'depthbasedcorrmaskmasksubtype' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSubType'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSubType'] },
	'depthbasedcorrmaskmasksvalue' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskValue'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'depthbasedcorrmaskmasksversion' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksVersion'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksVersion'] },
	'depthbasedcorrmaskmaskswhat' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWhat'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWhat'] },
	'depthbasedcorrmaskmaskswholeimagearea' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'depthbasedcorrmaskmasksx' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksX'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksX'] },
	'depthbasedcorrmaskmasksy' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksY'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksY'] },
	'depthbasedcorrmaskmasksyncid' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSyncID'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'depthbasedcorrmaskmaskszerox' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroX'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'depthbasedcorrmaskmaskszeroy' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroY'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'depthbasedcorrmaskmaskversion' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskVersion'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskVersion'] },
	'depthbasedcorrmaskmidpoint' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMidpoint'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMidpoint'] },
	'depthbasedcorrmaskorigin' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksOrigin'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksOrigin'] },
	'depthbasedcorrmaskperimetervalue' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksPerimeterValue'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'depthbasedcorrmaskradius' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRadius'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRadius'] },
	'depthbasedcorrmaskrange' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'depthbasedcorrmaskrangeareamodels' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'depthbasedcorrmaskrangeareamodelscolorsampleinfo' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'depthbasedcorrmaskrangeareamodelscomponents' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'depthbasedcorrmaskrangecoloramount' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'depthbasedcorrmaskrangedepthfeather' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'depthbasedcorrmaskrangedepthmax' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'depthbasedcorrmaskrangedepthmin' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'depthbasedcorrmaskrangeinvert' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'depthbasedcorrmaskrangelumfeather' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'depthbasedcorrmaskrangeluminancedepthsampleinfo' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'depthbasedcorrmaskrangelummax' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'depthbasedcorrmaskrangelummin' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'depthbasedcorrmaskrangelumrange' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'depthbasedcorrmaskrangesampletype' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'depthbasedcorrmaskrangetype' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'depthbasedcorrmaskrangeversion' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'depthbasedcorrmaskreferencepoint' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksReferencePoint'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksReferencePoint'] },
	'depthbasedcorrmaskright' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRight'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRight'] },
	'depthbasedcorrmaskroundness' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRoundness'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRoundness'] },
	'depthbasedcorrmasksizex' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeX'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeX'] },
	'depthbasedcorrmasksizey' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeY'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeY'] },
	'depthbasedcorrmasktop' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksTop'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksTop'] },
	'depthbasedcorrmaskvalue' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskValue'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskValue'] },
	'depthbasedcorrmaskversion' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksVersion'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksVersion'] },
	'depthbasedcorrmaskwhat' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWhat'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWhat'] },
	'depthbasedcorrmaskwholeimagearea' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWholeImageArea'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'depthbasedcorrmaskx' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksX'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksX'] },
	'depthbasedcorrmasky' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksY'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksY'] },
	'depthbasedcorrmaskzerox' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroX'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroX'] },
	'depthbasedcorrmaskzeroy' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroY'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroY'] },
	'depthbasedcorrwhat' => { 505 => [\'DepthBasedCorrections','DepthBasedCorrectionsWhat'], 507 => [\'DepthBasedCorrections','DepthBasedCorrectionsWhat'] },
	'depthfar' => { 122 => 0xc7eb },
	'depthformat' => { 122 => 0xc7e9 },
	'depthimage' => { 490 => 'Data' },
	'depthmapinfo' => { 505 => 'DepthMapInfo', 507 => 'DepthMapInfo' },
	'depthmapinfobasehighlightguideinputdigest' => { 505 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideInputDigest'], 507 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideInputDigest'] },
	'depthmapinfobasehighlightguidetable' => { 505 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideTable'], 507 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideTable'] },
	'depthmapinfobasehighlightguideversion' => { 505 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideVersion'], 507 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideVersion'] },
	'depthmapinfobaselayereddepthinputdigest' => { 505 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthInputDigest'], 507 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthInputDigest'] },
	'depthmapinfobaselayereddepthtable' => { 505 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthTable'], 507 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthTable'] },
	'depthmapinfobaselayereddepthversion' => { 505 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthVersion'], 507 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthVersion'] },
	'depthmapinfobaserawdepthinputdigest' => { 505 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthInputDigest'], 507 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthInputDigest'] },
	'depthmapinfobaserawdepthtable' => { 505 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthTable'], 507 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthTable'] },
	'depthmapinfobaserawdepthversion' => { 505 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthVersion'], 507 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthVersion'] },
	'depthmapinfodepthsource' => { 505 => [\'DepthMapInfo','DepthMapInfoDepthSource'], 507 => [\'DepthMapInfo','DepthMapInfoDepthSource'] },
	'depthmeasuretype' => { 122 => 0xc7ed },
	'depthnear' => { 122 => 0xc7ea },
	'depthunits' => { 122 => 0xc7ec },
	'derivedfrom' => { 535 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 535 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 535 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 535 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 535 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 535 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 535 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 535 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 535 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 535 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 535 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 535 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 535 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 535 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 535 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 535 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 535 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 535 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 535 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 535 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 535 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 535 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 535 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 535 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 334 => 'Description', 396 => ['desc','dscp',"\xa9des"], 398 => 'description', 404 => 'dscp', 505 => 'Description', 507 => 'Description', 508 => 'description', 532 => 'Description' },
	'destination' => { 135 => 0x5 },
	'destinationcity' => { 379 => 0x24, 385 => 0x3 },
	'destinationcitycode' => { 386 => 0x1001 },
	'destinationdst' => { 379 => 0x26, 385 => '0.3' },
	'developmentdynamicrange' => { 130 => 0x1403 },
	'deviantmatrixcustom' => { 141 => 0x7de },
	'deviantmatrixdaylight' => { 141 => 0x7da },
	'deviantmatrixflash' => { 141 => 0x7dd },
	'deviantmatrixfluorescent' => { 141 => 0x7dc },
	'deviantmatrixtungsten' => { 141 => 0x7db },
	'deviantwhitecustom' => { 141 => 0x842 },
	'deviantwhitedaylight' => { 141 => 0x83e },
	'deviantwhiteflash' => { 141 => 0x841 },
	'deviantwhitefluorescent' => { 141 => 0x840 },
	'deviantwhitetungsten' => { 141 => 0x83f },
	'device' => { 524 => 'device' },
	'devicesettingdescription' => { 511 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 511 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 511 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 511 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 418 => 0x2 },
	'dewarpdata' => { 119 => 'DewarpData' },
	'dewarpflag' => { 119 => 'DewarpFlag' },
	'dialdirectiontvav' => { 87 => 0x706 },
	'dietaryneeds' => { 526 => 'dietaryNeeds' },
	'diffractioncompensation' => { 227 => 0x20e, 242 => 0x142, 243 => 0x1b2, 244 => 0x1a2, 245 => 0x1b6, 246 => 0x1b6 },
	'diffractioncorrection' => { 344 => 0xbc, 369 => 0x3 },
	'diffractioncorrectionon' => { 106 => 0x2070b },
	'digitalcreationdate' => { 134 => 0x3e },
	'digitalcreationtime' => { 134 => 0x3f },
	'digitaldeehighlightadj' => { 261 => 0x202 },
	'digitaldeeshadowadj' => { 261 => 0x200 },
	'digitaldeethreshold' => { 261 => 0x201 },
	'digitalfilter' => { 421 => 0x59 },
	'digitalfilter01' => { 366 => 0x5 },
	'digitalfilter02' => { 366 => 0x16 },
	'digitalfilter03' => { 366 => 0x27 },
	'digitalfilter04' => { 366 => 0x38 },
	'digitalfilter05' => { 366 => 0x49 },
	'digitalfilter06' => { 366 => 0x5a },
	'digitalfilter07' => { 366 => 0x6b },
	'digitalfilter08' => { 366 => 0x7c },
	'digitalfilter09' => { 366 => 0x8d },
	'digitalfilter10' => { 366 => 0x9e },
	'digitalfilter11' => { 366 => 0xaf },
	'digitalfilter12' => { 366 => 0xc0 },
	'digitalfilter13' => { 366 => 0xd1 },
	'digitalfilter14' => { 366 => 0xe2 },
	'digitalfilter15' => { 366 => 0xf3 },
	'digitalfilter16' => { 366 => 0x104 },
	'digitalfilter17' => { 366 => 0x115 },
	'digitalfilter18' => { 366 => 0x126 },
	'digitalfilter19' => { 366 => 0x137 },
	'digitalfilter20' => { 366 => 0x148 },
	'digitalgain' => { 76 => 0xb },
	'digitalgem' => { 222 => 0x0 },
	'digitalice' => { 261 => 0x100 },
	'digitalimageguid' => { 519 => 'DigImageGUID' },
	'digitallensoptimizer' => { 64 => 0xa },
	'digitallensoptimizersetting' => { 82 => 0x9 },
	'digitalroc' => { 258 => 0x0 },
	'digitalsourcefiletype' => { 519 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 519 => 'DigitalSourceType' },
	'digitalzoom' => { 36 => 0xc, 115 => 0xa, 130 => 0x1044, 143 => 0x68, 154 => 0x22, 155 => 0x1e, 159 => 'DigitalZoom', 184 => 0xc, 238 => 0x86, 284 => 0xa, 326 => 0x204, 379 => 0x1e, 386 => 0xa, 420 => 0x204, 467 => 0x12, 468 => 0x12 },
	'digitalzoomon' => { 420 => 0x21b },
	'digitalzoomratio' => { 122 => 0xa404, 455 => 0x200, 457 => 0x21c, 511 => 'DigitalZoomRatio' },
	'director' => { 182 => 'WM/Director', 396 => "\xa9dir", 398 => 'director', 404 => "\xa9dir", 534 => 'director' },
	'directorphotography' => { 534 => 'directorPhotography' },
	'directory' => { 123 => 'Directory' },
	'directoryindex' => { 7 => 0x137, 9 => 0x2dc, 11 => 0x17e, 13 => 0x238, 14 => 0x13f, 15 => 0x133, 16 => 0x1df, 17 => 0x1a7, 18 => 0x1f0, 19 => 0xcc, 20 => 0x1c7, 21 => 0x298, 22 => 0x1e7, 23 => 0x1e5, 24 => [0x27c,0x280], 25 => 0x2b6, 26 => 0x2bf, 28 => 0x1f7, 29 => 0x4ba, 30 => 0xb21 },
	'directoryindex2' => { 21 => 0x29c },
	'directorynumber' => { 215 => 0x3, 407 => 0x12 },
	'disableautocreation' => { 488 => 'DisableAutoCreation' },
	'disclaimer' => { 334 => 'Disclaimer' },
	'discnumber' => { 534 => 'discNumber' },
	'dishtype' => { 526 => 'dishType' },
	'disknumber' => { 396 => 'disk' },
	'dispbutton' => { 246 => 0x7d4, 317 => 0x2ab },
	'displayallafpoints' => { 87 => 0x514 },
	'displayaperture' => { 36 => 0x23 },
	'displayedunitsx' => { 394 => 0x2 },
	'displayedunitsy' => { 394 => 0x6 },
	'displayname' => { 398 => 'displayname', 523 => 'displayName' },
	'distance1' => { 143 => 0x28 },
	'distance2' => { 143 => 0x2c },
	'distance3' => { 143 => 0x30 },
	'distance4' => { 143 => 0x34 },
	'distortion' => { 418 => 0xa050 },
	'distortioncompensation' => { 481 => 0x8040 },
	'distortioncontrol' => { 266 => 0x10 },
	'distortioncorrection' => { 81 => 0x3, 106 => 0x20705, 112 => 0x67, 122 => 0x7036, 321 => 0x50b, 348 => '7.1', 369 => 0x0, 475 => 0x601, 476 => 0x5b },
	'distortioncorrection2' => { 325 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 502 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 106 => '0x20705.0', 112 => 0x63 },
	'distortioncorrectionsetting' => { 82 => 0x7, 444 => 0x2013 },
	'distortioncorrectionvalue' => { 81 => 0x9 },
	'distortioncorrparams' => { 122 => 0x7037, 454 => 0x1a23, 457 => 0x1870, 459 => 0x189c, 460 => 0x18cc, 461 => 0x17d0, 475 => 0x6ca, 476 => 0x64 },
	'distortioncorrparamsnumber' => { 457 => 0x1899, 459 => 0x18c5, 460 => 0x18f5, 461 => 0x17f9 },
	'distortioncorrparamspresent' => { 457 => 0x1898, 459 => 0x18c4, 460 => 0x18f4, 461 => 0x17f8, 463 => 0x10b, 464 => 0x10b, 475 => 0x600, 476 => 0x5a },
	'distortioneffect' => { 106 => 0x20709 },
	'distortionn' => { 348 => 0xc },
	'distortionparam02' => { 348 => 0x2 },
	'distortionparam04' => { 348 => 0x4 },
	'distortionparam08' => { 348 => 0x8 },
	'distortionparam09' => { 348 => 0x9 },
	'distortionparam11' => { 348 => 0xb },
	'distortionscale' => { 348 => 0x5 },
	'distributor' => { 524 => 'distributor' },
	'distributorproductid' => { 523 => 'distributorProductID' },
	'dloon' => { 106 => '0x20706.0', 112 => 0xdc },
	'dlosetting' => { 106 => 0x20706, 112 => 0xdd },
	'dlosettingapplied' => { 105 => 0x4 },
	'dloshootingdistance' => { 112 => 0xde },
	'dloversion' => { 105 => 0x5 },
	'dmcomment' => { 534 => 'comment' },
	'dmdithermatrix' => { 141 => 0xc7a },
	'dmdithermatrixheight' => { 141 => 0xc7c },
	'dmdithermatrixwidth' => { 141 => 0xc7b },
	'dngadobedata' => { 122 => 0xc634 },
	'dngbackwardversion' => { 122 => 0xc613 },
	'dngignoresidecars' => { 505 => 'DNGIgnoreSidecars', 507 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 122 => 0xc630 },
	'dngprivatedata' => { 122 => 0xc634 },
	'dngversion' => { 122 => 0xc612 },
	'document' => { 334 => 'Document' },
	'documentancestors' => { 522 => 'DocumentAncestors' },
	'documenthistory' => { 134 => 0xe7 },
	'documentid' => { 535 => 'DocumentID' },
	'documentname' => { 122 => 0x10d },
	'documentnotes' => { 134 => 0xe6 },
	'doi' => { 524 => 'doi' },
	'dopesheet' => { 519 => 'Dopesheet' },
	'dopesheetlink' => { 519 => 'DopesheetLink' },
	'dopesheetlinklink' => { 519 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 519 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 141 => 0xc82 },
	'dpp' => { 500 => 'dpp' },
	'dr4cameramodel' => { 107 => 0x3 },
	'drangepriority' => { 130 => 0x1443 },
	'drangepriorityauto' => { 130 => 0x1444 },
	'drangepriorityfixed' => { 130 => 0x1445 },
	'drivemode' => { 116 => 0x3103, 128 => '0.1', 184 => 0x6, 187 => 0x1e, 190 => 0xe, 194 => 0x64d0, 321 => 0x600, 379 => 0x34, 411 => 0x1002, 421 => 0x3, 431 => 0x4, 432 => 0x7e, 433 => 0x34 },
	'drivemode2' => { 187 => 0xa, 360 => 0x7, 442 => 0xe, 449 => 0x1 },
	'drivemodesetting' => { 433 => 0x4 },
	'drivespeed' => { 128 => '0.2' },
	'dspfirmwareversion' => { 379 => 0x27 },
	'duration' => { 69 => 0x6a, 158 => 'Duration', 172 => 'Duration', 526 => 'duration', 534 => 'duration' },
	'durationscale' => { 534 => [\'duration','durationScale'] },
	'durationvalue' => { 534 => [\'duration','durationValue'] },
	'dustremovaldata' => { 66 => 0x97 },
	'dxcropalert' => { 243 => 0x250, 244 => 0x23c, 245 => 0x250, 246 => 0x250 },
	'dynamicafarea' => { 301 => '1.4', 310 => '1.4' },
	'dynamicafareasize' => { 243 => 0x254, 244 => 0x240, 245 => 0x254, 246 => 0x254 },
	'dynamicareaafassist' => { 317 => 0x18, 318 => 0x18, 319 => 0x18 },
	'dynamicareaafdisplay' => { 302 => '46.1', 304 => '47.1', 305 => '47.1', 314 => '47.1', 315 => '47.1' },
	'dynamicrange' => { 130 => 0x1400 },
	'dynamicrangeboost' => { 344 => 0xee },
	'dynamicrangeexpansion' => { 379 => 0x69, 411 => 0x100e },
	'dynamicrangemax' => { 111 => 0x7c },
	'dynamicrangemin' => { 111 => 0x7a },
	'dynamicrangeoptimizer' => { 187 => 0x15, 444 => [0xb025,0xb04f], 453 => 0x1144, 454 => [0x1144,0x324], 455 => [0x1120,0x300], 456 => [0x119c,0x37c], 457 => [0x1178,0x328], 458 => [0x1030,0x50], 459 => [0x228,0x50], 460 => [0x228,0x50], 461 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 442 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 431 => 0x19, 432 => 0x17, 433 => 0xd, 442 => 0x79, 449 => 0x5 },
	'dynamicrangeoptimizermode' => { 190 => 0x15, 431 => 0x18, 432 => 0x16, 442 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 187 => 0x27, 433 => 0xc, 449 => 0x4 },
	'dynamicrangesetting' => { 130 => 0x1402 },
	'e-dialinprogram' => { 360 => '1.3' },
	'earliestageorloweststage' => { 121 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 121 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 121 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 121 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 121 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'earthpos' => { 484 => 'EarthPos' },
	'earthposaltitude' => { 484 => [\'EarthPos','EarthPosAltitude'] },
	'earthposlatitude' => { 484 => [\'EarthPos','EarthPosLatitude'] },
	'earthposlongitude' => { 484 => [\'EarthPos','EarthPosLongitude'] },
	'earthposrotationw' => { 484 => [\'EarthPos','EarthPosRotationW'] },
	'earthposrotationx' => { 484 => [\'EarthPos','EarthPosRotationX'] },
	'earthposrotationy' => { 484 => [\'EarthPos','EarthPosRotationY'] },
	'earthposrotationz' => { 484 => [\'EarthPos','EarthPosRotationZ'] },
	'earthpostimestamp' => { 484 => [\'EarthPos','EarthPosTimestamp'] },
	'easyexposurecomp' => { 316 => '6.1' },
	'easyexposurecompensation' => { 301 => '6.4', 302 => '6.5', 304 => '6.3', 305 => '6.3', 309 => '5.1', 310 => '4.4', 311 => '5.2', 314 => '6.3', 315 => '6.3', 317 => 0x1d, 318 => 0x1d, 319 => 0x1d },
	'easymode' => { 36 => 0xb },
	'edgemapslope' => { 141 => 0x930 },
	'edgemapx1' => { 141 => 0x931 },
	'edgemapx2' => { 141 => 0x932 },
	'edgemapx3' => { 141 => 0x934 },
	'edgemapx4' => { 141 => 0x935 },
	'edgenoisereduction' => { 295 => 0x4, 481 => 0x8028 },
	'edit1' => { 404 => "\xa9ed1" },
	'edit2' => { 404 => "\xa9ed2" },
	'edit3' => { 404 => "\xa9ed3" },
	'edit4' => { 404 => "\xa9ed4" },
	'edit5' => { 404 => "\xa9ed5" },
	'edit6' => { 404 => "\xa9ed6" },
	'edit7' => { 404 => "\xa9ed7" },
	'edit8' => { 404 => "\xa9ed8" },
	'edit9' => { 404 => "\xa9ed9" },
	'edition' => { 524 => 'edition' },
	'editorialupdate' => { 134 => 0x8 },
	'editstatus' => { 134 => 0x7, 391 => 'EditStatus', 500 => 'EditStatus' },
	'editversionname' => { 294 => 0x3d136244 },
	'effectivelv' => { 379 => 0x2d },
	'effectivemaxaperture' => { 231 => 0x12, 232 => 0x13, 236 => 0x14 },
	'eissn' => { 524 => 'eIssn' },
	'electricalblackcolumns' => { 141 => 0x1810 },
	'electronicfront-curtainshutter' => { 304 => '5.2', 305 => '5.2', 314 => '5.3', 315 => '5.2' },
	'electronicfrontcurtainshutter' => { 444 => 0x201a },
	'elevation' => { 168 => 'Elevation' },
	'email' => { 160 => 'EMail' },
	'embargodate' => { 527 => 'embargoDate' },
	'embdencrightsexpr' => { 519 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 519 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 519 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 519 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 522 => 'EmbeddedXMPDigest' },
	'emissivity' => { 124 => 0x3 },
	'emptyslotrelease' => { 243 => 0x723, 244 => 0x625, 245 => 0x655, 246 => 0x6bd },
	'enablechromanoisereduction' => { 141 => 0xe6e },
	'enablesharpening' => { 141 => 0x92e },
	'encodedby' => { 182 => 'WM/EncodedBy', 396 => "\xa9enc" },
	'encodedwith' => { 398 => 'Encoded_With' },
	'encoder' => { 396 => "\xa9too", 404 => "\xa9too" },
	'encoderid' => { 404 => "\xa9enc" },
	'encodingtime' => { 182 => 'WM/EncodingTime' },
	'encryptionkey' => { 418 => 0xa020 },
	'endingpage' => { 524 => 'endingPage' },
	'enduser' => { 331 => 'EndUser' },
	'enduserid' => { 331 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 331 => [\'EndUser','EndUserEndUserName'] },
	'energysavingmode' => { 243 => 0x746, 244 => 0x648, 245 => 0x678, 246 => 0x6e0 },
	'engineer' => { 534 => 'engineer' },
	'enhancedarktones' => { 287 => 0x8 },
	'enhancedenoisealreadyapplied' => { 502 => 'EnhanceDenoiseAlreadyApplied' },
	'enhancedenoiselumaamount' => { 502 => 'EnhanceDenoiseLumaAmount' },
	'enhancedenoiseversion' => { 502 => 'EnhanceDenoiseVersion' },
	'enhancedetailsalreadyapplied' => { 502 => 'EnhanceDetailsAlreadyApplied' },
	'enhancedetailsversion' => { 502 => 'EnhanceDetailsVersion' },
	'enhancement' => { 115 => 0x16, 116 => 0x3016 },
	'enhanceparams' => { 122 => 0xc7ee },
	'enhancer' => { 325 => 0x300 },
	'enhancervalues' => { 325 => 0x301 },
	'enhancesuperresolutionalreadyapplied' => { 502 => 'EnhanceSuperResolutionAlreadyApplied' },
	'enhancesuperresolutionscale' => { 502 => 'EnhanceSuperResolutionScale' },
	'enhancesuperresolutionversion' => { 502 => 'EnhanceSuperResolutionVersion' },
	'envelopenumber' => { 135 => 0x28 },
	'envelopepriority' => { 135 => 0x3c },
	'enveloperecordversion' => { 135 => 0x0 },
	'episode' => { 519 => 'Episode' },
	'episodeglobaluniqueid' => { 396 => 'egid' },
	'episodeidentifier' => { 519 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 519 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 519 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 326 => 0x20c },
	'epsonimagewidth' => { 326 => 0x20b },
	'epsonsoftware' => { 326 => 0x20d },
	'equipmentinstitution' => { 483 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 483 => 'EquipmentManufacturer' },
	'equipmentversion' => { 322 => 0x0 },
	'ettlii' => { 87 => 0x304, 88 => 0xd, 89 => 0xe, 90 => 0x7, 91 => 0x7, 92 => 0xe },
	'event' => { 486 => 'Event', 498 => 'Event', 519 => 'Event', 524 => 'event' },
	'eventalias' => { 523 => 'eventAlias' },
	'eventdate' => { 121 => [\'Event','EventEventDate'] },
	'eventday' => { 121 => [\'Event','EventDay'] },
	'eventearliestdate' => { 121 => [\'Event','EventEarliestDate'] },
	'eventend' => { 523 => 'eventEnd' },
	'eventenddayofyear' => { 121 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 121 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 121 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 121 => [\'Event','EventHabitat'] },
	'eventid' => { 121 => [\'Event','EventEventID'], 519 => 'EventId' },
	'eventlatestdate' => { 121 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 121 => [\'Event','EventMonth'] },
	'eventnumber' => { 405 => 0x9, 406 => 0x37, 407 => 0x3a },
	'eventparenteventid' => { 121 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 121 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 121 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 121 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 121 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 121 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 523 => 'eventStart' },
	'eventstartdayofyear' => { 121 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 523 => 'eventSubtype' },
	'eventtime' => { 121 => [\'Event','EventEventTime'] },
	'eventtype' => { 523 => 'eventType' },
	'eventverbatimeventdate' => { 121 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 121 => [\'Event','EventYear'] },
	'evfgrid' => { 317 => 0x165, 318 => 0x165, 319 => 0x17d },
	'evfimageframe' => { 317 => 0x164, 318 => 0x164, 319 => 0x17c },
	'evfreleaseindicator' => { 317 => 0x24f, 318 => 0x24f, 319 => 0x267 },
	'evfwarmdisplaybrightness' => { 317 => 0x24d, 318 => 0x24d, 319 => 0x265 },
	'evfwarmdisplaymode' => { 317 => 0x24b, 318 => 0x24b, 319 => 0x263 },
	'evsteps' => { 360 => '1.2', 362 => 0x0 },
	'evstepsize' => { 306 => '5.1', 307 => '6.1', 308 => '6.1', 312 => '0.7' },
	'exclusivecoverage' => { 495 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 527 => 'exclusivityEndDate' },
	'excursiontolerance' => { 136 => 0x82 },
	'executiveproducer' => { 396 => "\xa9xpd" },
	'exif' => { 123 => 'EXIF' },
	'exifbyteorder' => { 123 => 'ExifByteOrder' },
	'exifcamerainfo' => { 134 => 0xe8 },
	'exifimageheight' => { 122 => 0xa003, 511 => 'PixelYDimension' },
	'exifimagewidth' => { 122 => 0xa002, 511 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 123 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 122 => 0x9000, 511 => 'ExifVersion' },
	'exitpupilposition' => { 231 => 0x4, 232 => 0x4, 236 => 0x4 },
	'expirationdate' => { 134 => 0x25, 527 => 'expirationDate' },
	'expirationtime' => { 134 => 0x26 },
	'exposure' => { 122 => 0xfe51, 505 => 'Exposure', 507 => 'Exposure' },
	'exposure2012' => { 505 => 'Exposure2012', 507 => 'Exposure2012' },
	'exposureadj' => { 292 => 0x0 },
	'exposureadj2' => { 292 => 0x12 },
	'exposureadjust' => { 421 => 0xc },
	'exposurebracketingindicatorlast' => { 187 => 0x52 },
	'exposurebracketshotnumber' => { 190 => 0x2d, 442 => 0x2f },
	'exposurebracketstepsize' => { 360 => 0x8 },
	'exposurebracketvalue' => { 238 => 0x19 },
	'exposurecompautocancel' => { 87 => 0x113 },
	'exposurecompensation' => { 79 => 0x6, 96 => 0x0, 122 => 0x9204, 143 => 0x24, 159 => 'ExposureComp', 179 => 'ExposureCompensation', 184 => 0xd, 185 => 0x53, 186 => 0x1e, 190 => 0x49c0, 326 => 0x1006, 379 => 0x16, 388 => 0x402, 418 => 0xa013, 421 => [0xc,0x35,0x4d], 453 => 0x114c, 454 => 0x114c, 455 => 0x1128, 457 => 0x1180, 458 => 0x1038, 459 => 0x230, 460 => 0x230, 461 => 0x223, 511 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 449 => [0x24,0x26,0x2a] },
	'exposurecompensationbutton' => { 246 => 0x794 },
	'exposurecompensationmode' => { 187 => 0x47, 190 => 0x2a },
	'exposurecompensationset' => { 431 => 0x3, 432 => 0x3, 433 => 0x3, 449 => 0x1e },
	'exposurecompensationsetting' => { 187 => 0x1 },
	'exposurecompstepsize' => { 301 => '6.3', 302 => '7.3', 304 => '7.3', 305 => '7.3', 310 => '4.3', 314 => '7.3', 315 => '7.3' },
	'exposurecontrolstep' => { 309 => '6.1', 311 => '6.1' },
	'exposurecontrolstepsize' => { 301 => '6.2', 302 => '7.1', 304 => '7.1', 305 => '7.1', 310 => '4.2', 314 => '7.1', 315 => '7.1', 316 => '7.1', 317 => 0x1b, 318 => 0x1b, 319 => 0x1b },
	'exposurecount' => { 130 => 0x1032 },
	'exposuredelay' => { 246 => 0x800 },
	'exposuredelaymode' => { 301 => '10.1', 302 => '11.1', 304 => '11.1', 305 => '11.1', 306 => '9.1', 307 => '10.1', 308 => '10.1', 310 => '10.4', 311 => '10.1', 312 => '6.4', 314 => '11.1', 315 => '11.1', 316 => '11.2' },
	'exposuredifference' => { 238 => 0xe },
	'exposuregaincustom' => { 141 => 0x89c },
	'exposuregaindaylight' => { 141 => 0x898 },
	'exposuregainflash' => { 141 => 0x89b },
	'exposuregainfluorescent' => { 141 => 0x89a },
	'exposuregaintungsten' => { 141 => 0x899 },
	'exposureindex' => { 122 => 0xa215, 511 => 'ExposureIndex' },
	'exposureindicator' => { 187 => 0x50 },
	'exposurelevelincrements' => { 85 => 0x6, 86 => 0x6, 87 => 0x101, 88 => 0x5, 89 => 0x6, 90 => 0x5, 91 => 0x5, 92 => 0x6, 93 => 0x4, 431 => 0x58, 432 => 0x58 },
	'exposurelockused' => { 493 => 'ExposureLockUsed' },
	'exposuremode' => { 122 => 0xa402, 159 => 'ExposureMode', 184 => 0x1, 185 => 0xa, 186 => 0x0, 187 => 0x0, 190 => 0x34, 321 => 0x200, 341 => 0x40d, 421 => 0x8, 444 => 0xb041, 511 => 'ExposureMode' },
	'exposuremodeinmanual' => { 87 => 0x10b },
	'exposureprogram' => { 122 => 0x8822, 411 => 0x1001, 424 => [0x17e,0x43], 431 => 0x3c, 432 => 0x3c, 433 => 0x5, 437 => 0x14, 442 => 0x3f, 449 => 0x2, 453 => 0x1175, 454 => 0x1179, 455 => 0x1155, 456 => 0x11d1, 457 => 0x11ad, 458 => 0x1065, 459 => 0x25d, 460 => 0x25d, 461 => 0x24c, 472 => 0xb, 473 => 0xc, 474 => 0xb, 476 => 0x48, 511 => 'ExposureProgram' },
	'exposureshift' => { 321 => 0x203 },
	'exposurestandardadjustment' => { 444 => 0x202d },
	'exposuretime' => { 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x4, 31 => 0x6, 32 => 0x7, 79 => 0x16, 122 => 0x829a, 140 => 0xfd05, 143 => 0x20, 145 => 0xfa24, 147 => 0xf104, 150 => 0x12, 152 => 0x38, 154 => 0x14, 155 => 0x10, 157 => 0x10, 159 => 'ExposureTime', 184 => 0x9, 185 => 0x35, 186 => 0x48, 187 => 0x8, 190 => 0x49b8, 379 => 0x12, 418 => 0xa018, 421 => [0x32,0x4a], 431 => 0x0, 432 => 0x0, 449 => [0x21,0x23,0x27], 476 => 0x10, 511 => 'ExposureTime' },
	'exposuretime2' => { 421 => [0x33,0x4b] },
	'exposuretuning' => { 238 => 0x1c },
	'exposurevalue' => { 141 => 0x3 },
	'exposurewarning' => { 130 => 0x1302 },
	'exrauto' => { 130 => 0x1033 },
	'exrmode' => { 130 => 0x1034 },
	'extdescraccessibility' => { 518 => 'ExtDescrAccessibility' },
	'extendedmenubanks' => { 243 => 0x120, 244 => 0x114, 245 => 0x124, 246 => 0x124 },
	'extendedshutterspeeds' => { 317 => 0x102, 318 => 0x102, 319 => 0x118 },
	'extendedwbdetect' => { 321 => 0x902 },
	'extender' => { 322 => 0x301 },
	'extenderfirmwareversion' => { 322 => 0x304 },
	'extendermagnification' => { 161 => 'Magnification' },
	'extendermake' => { 161 => 'Make' },
	'extendermodel' => { 161 => 'Model', 322 => 0x303 },
	'extenderserialnumber' => { 161 => 'SerialNumber', 322 => 0x302 },
	'extenderstatus' => { 377 => 0x3 },
	'externalflash' => { 324 => 0x1201 },
	'externalflashae1' => { 326 => 0x101f },
	'externalflashae1_0' => { 326 => 0x101b },
	'externalflashae2' => { 326 => 0x1020 },
	'externalflashae2_0' => { 326 => 0x101c },
	'externalflashbounce' => { 324 => 0x1204, 326 => 0x1026, 367 => 0x1a },
	'externalflashcompensation' => { 218 => 0x1b },
	'externalflashexposurecomp' => { 238 => 0x17, 367 => 0x19 },
	'externalflashfirmware' => { 216 => 0x6, 217 => 0x6, 218 => 0x6, 219 => 0x6, 220 => 0x6, 221 => 0x6 },
	'externalflashflags' => { 216 => 0x8, 217 => 0x8, 218 => 0x8, 219 => 0x8, 221 => 0x8 },
	'externalflashguidenumber' => { 324 => 0x1203, 367 => '24.1' },
	'externalflashgvalue' => { 326 => 0x1025 },
	'externalflashmode' => { 326 => 0x1028, 367 => 0x2 },
	'externalflashreadystate' => { 220 => '9.1' },
	'externalflashstatus' => { 220 => '8.2' },
	'externalflashzoom' => { 324 => 0x1205, 326 => 0x1027 },
	'externalflashzoomoverride' => { 220 => '8.1' },
	'externalmetadatalink' => { 519 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 339 => 0x311, 342 => 0x311, 343 => 0x311, 346 => 0x3408 },
	'extrainfoversion' => { 435 => 0x1a },
	'eyestartaf' => { 187 => 0x40 },
	'fac100per' => { 141 => 0xe94 },
	'fac170per' => { 141 => 0xe93 },
	'fac18per' => { 141 => 0xe92 },
	'face10position' => { 113 => 0x3f4, 114 => 0x1ec, 214 => 0x28, 364 => 0x12 },
	'face10size' => { 365 => 0x12 },
	'face11position' => { 214 => 0x2c, 364 => 0x14 },
	'face11size' => { 365 => 0x14 },
	'face12position' => { 214 => 0x30, 364 => 0x16 },
	'face12size' => { 365 => 0x16 },
	'face13position' => { 364 => 0x18 },
	'face13size' => { 365 => 0x18 },
	'face14position' => { 364 => 0x1a },
	'face14size' => { 365 => 0x1a },
	'face15position' => { 364 => 0x1c },
	'face15size' => { 365 => 0x1c },
	'face16position' => { 364 => 0x1e },
	'face16size' => { 365 => 0x1e },
	'face17position' => { 364 => 0x20 },
	'face17size' => { 365 => 0x20 },
	'face18position' => { 364 => 0x22 },
	'face18size' => { 365 => 0x22 },
	'face19position' => { 364 => 0x24 },
	'face19size' => { 365 => 0x24 },
	'face1position' => { 56 => 0x8, 113 => 0xd, 114 => 0x18, 214 => 0x4, 336 => 0x1, 364 => 0x0, 408 => 0xbc, 438 => 0x1, 439 => 0x0, 440 => 0x0, 441 => 0x5b },
	'face1size' => { 365 => 0x0 },
	'face20position' => { 364 => 0x26 },
	'face20size' => { 365 => 0x26 },
	'face21position' => { 364 => 0x28 },
	'face21size' => { 365 => 0x28 },
	'face22position' => { 364 => 0x2a },
	'face22size' => { 365 => 0x2a },
	'face23position' => { 364 => 0x2c },
	'face23size' => { 365 => 0x2c },
	'face24position' => { 364 => 0x2e },
	'face24size' => { 365 => 0x2e },
	'face25position' => { 364 => 0x30 },
	'face25size' => { 365 => 0x30 },
	'face26position' => { 364 => 0x32 },
	'face26size' => { 365 => 0x32 },
	'face27position' => { 364 => 0x34 },
	'face27size' => { 365 => 0x34 },
	'face28position' => { 364 => 0x36 },
	'face28size' => { 365 => 0x36 },
	'face29position' => { 364 => 0x38 },
	'face29size' => { 365 => 0x38 },
	'face2position' => { 56 => 0xa, 113 => 0x7c, 114 => 0x4c, 214 => 0x8, 336 => 0x5, 364 => 0x2, 408 => 0xc8, 438 => 0x6, 439 => 0x20, 440 => 0x25, 441 => 0x65 },
	'face2size' => { 365 => 0x2 },
	'face30position' => { 364 => 0x3a },
	'face30size' => { 365 => 0x3a },
	'face31position' => { 364 => 0x3c },
	'face31size' => { 365 => 0x3c },
	'face32position' => { 364 => 0x3e },
	'face32size' => { 365 => 0x3e },
	'face3position' => { 56 => 0xc, 113 => 0xeb, 114 => 0x80, 214 => 0xc, 336 => 0x9, 364 => 0x4, 408 => 0xd4, 438 => 0xb, 439 => 0x40, 440 => 0x4a, 441 => 0x6f },
	'face3size' => { 365 => 0x4 },
	'face4position' => { 56 => 0xe, 113 => 0x15a, 114 => 0xb4, 214 => 0x10, 336 => 0xd, 364 => 0x6, 408 => 0xe0, 438 => 0x10, 439 => 0x60, 440 => 0x6f, 441 => 0x79 },
	'face4size' => { 365 => 0x6 },
	'face5position' => { 56 => 0x10, 113 => 0x1c9, 114 => 0xe8, 214 => 0x14, 336 => 0x11, 364 => 0x8, 408 => 0xec, 438 => 0x15, 439 => 0x80, 440 => 0x94 },
	'face5size' => { 365 => 0x8 },
	'face6position' => { 56 => 0x12, 113 => 0x238, 114 => 0x11c, 214 => 0x18, 364 => 0xa, 408 => 0xf8, 438 => 0x1a, 439 => 0xa0, 440 => 0xb9 },
	'face6size' => { 365 => 0xa },
	'face7position' => { 56 => 0x14, 113 => 0x2a7, 114 => 0x150, 214 => 0x1c, 364 => 0xc, 408 => 0x104, 438 => 0x1f, 439 => 0xc0, 440 => 0xde },
	'face7size' => { 365 => 0xc },
	'face8position' => { 56 => 0x16, 113 => 0x316, 114 => 0x184, 214 => 0x20, 364 => 0xe, 408 => 0x110, 438 => 0x24, 439 => 0xe0, 440 => 0x103 },
	'face8size' => { 365 => 0xe },
	'face9position' => { 56 => 0x18, 113 => 0x385, 114 => 0x1b8, 214 => 0x24, 364 => 0x10 },
	'face9size' => { 365 => 0x10 },
	'facebalanceorigi' => { 499 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 499 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 499 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 499 => 'FaceBalanceWarmth' },
	'facedetect' => { 379 => 0x76, 418 => 0x100 },
	'facedetectarea' => { 325 => 0x1201 },
	'facedetectframecrop' => { 325 => 0x1207 },
	'facedetectframesize' => { 56 => 0x3, 113 => 0x1, 114 => 0x4, 214 => 0x1, 325 => 0x1203, 379 => 0x77, 408 => 0xb6 },
	'facedetection' => { 433 => 0x30, 449 => 0x19 },
	'faceelementpositions' => { 130 => 0x4203 },
	'faceelementselected' => { 130 => 0x4005 },
	'faceelementtypes' => { 130 => 0x4201 },
	'faceid' => { 501 => 'FaceID' },
	'faceinfounknown' => { 116 => 0x2089 },
	'facename' => { 418 => 0x123 },
	'faceorientation' => { 114 => 0x8 },
	'faceposition' => { 363 => 0x2, 419 => 0x4 },
	'facepositions' => { 130 => 0x4103 },
	'facerecognition' => { 418 => 0x120 },
	'facesdetected' => { 56 => 0x2, 57 => 0x2, 58 => 0x3, 113 => 0x0, 114 => 0x2, 116 => 0x211c, 130 => 0x4100, 214 => 0x3, 325 => 0x1200, 344 => 0x3f, 363 => 0x0, 408 => 0xb5, 419 => 0x0, 438 => 0x0, 441 => 0x3, 452 => 0x30 },
	'facesrecognized' => { 337 => 0x0 },
	'facewidth' => { 57 => 0x1 },
	'fade' => { 444 => 0x2034 },
	'faithfuloutputhighlightpoint' => { 112 => 0x38 },
	'faithfuloutputshadowpoint' => { 112 => 0x39 },
	'faithfulrawcolortone' => { 112 => 0x31 },
	'faithfulrawcontrast' => { 112 => 0x33 },
	'faithfulrawhighlight' => { 112 => 0x79 },
	'faithfulrawhighlightpoint' => { 112 => 0x36 },
	'faithfulrawlinear' => { 112 => 0x34 },
	'faithfulrawsaturation' => { 112 => 0x32 },
	'faithfulrawshadow' => { 112 => 0x82 },
	'faithfulrawshadowpoint' => { 112 => 0x37 },
	'faithfulrawsharpness' => { 112 => 0x35 },
	'faithfulunsharpmaskfineness' => { 112 => 0xac },
	'faithfulunsharpmaskstrength' => { 112 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 112 => 0xae },
	'far' => { 490 => 'Far' },
	'fastresetlinetime' => { 141 => 0x1860 },
	'feedidentifier' => { 519 => 'FeedIdentifier' },
	'femicroadjustment' => { 87 => 0x111 },
	'ffid' => { 509 => 'ffid' },
	'field' => { 523 => 'field' },
	'fieldcount' => { 326 => 0x103f },
	'fieldofview' => { 404 => "FOV\x00" },
	'fifoenonepixeldelay' => { 141 => 0x1901 },
	'filecreatedate' => { 123 => 'FileCreateDate' },
	'filedatarate' => { 534 => 'fileDataRate' },
	'fileformat' => { 98 => 0x0, 135 => 0x14, 421 => [0x22,0x26], 444 => 0xb000 },
	'filegroupid' => { 123 => 'FileGroupID' },
	'fileindex' => { 7 => 0x143, 9 => 0x2d0, 11 => 0x172, 13 => 0x22c, 14 => 0x133, 15 => 0x13f, 16 => 0x1d3, 17 => 0x19b, 18 => 0x1e4, 19 => 0xd0, 20 => 0x1bb, 21 => 0x28c, 22 => 0x1db, 23 => 0x1d9, 24 => [0x270,0x274], 25 => 0x2aa, 26 => 0x2b3, 28 => 0x1eb, 29 => 0x4ae, 30 => 0xb2d, 345 => 0x0 },
	'fileindex2' => { 21 => 0x290 },
	'filemodifydate' => { 123 => 'FileModifyDate' },
	'filename' => { 123 => 'FileName' },
	'filenameasdelivered' => { 331 => 'FileNameAsDelivered' },
	'filenumber' => { 59 => 0x1, 66 => 0x8, 100 => 0x1817, 117 => 'Canon-FileNumber', 215 => 0x4, 407 => 0x10 },
	'filenumbermemory' => { 184 => 0x1a },
	'filenumbersequence' => { 301 => '12.2', 306 => '3.1', 307 => '4.1', 308 => '4.1', 310 => '11.1', 311 => '4.3', 316 => '5.2', 317 => 0x48, 318 => 0x48, 319 => 0x48 },
	'filepermissions' => { 123 => 'FilePermissions' },
	'filesource' => { 122 => 0xa300, 130 => 0x8000, 511 => 'FileSource' },
	'fileuserid' => { 123 => 'FileUserID' },
	'fileversion' => { 135 => 0x16 },
	'fillflashautoreduction' => { 85 => 0xe, 86 => 0xe, 93 => 0xa },
	'filllight' => { 505 => 'FillLight', 507 => 'FillLight' },
	'fillorder' => { 122 => 0x10a },
	'filmgraineffect' => { 321 => 0x538 },
	'filmmode' => { 130 => 0x1401, 341 => 0x412, 344 => 0x42 },
	'filmtype' => { 261 => 0x2 },
	'filtereffect' => { 59 => 0xe, 253 => 0x37, 254 => 0x3f, 255 => 0x47, 344 => 0xa1 },
	'filtereffectauto' => { 73 => 0xa0 },
	'filtereffectfaithful' => { 72 => 0x70, 73 => 0x70 },
	'filtereffectlandscape' => { 72 => 0x40, 73 => 0x40 },
	'filtereffectmonochrome' => { 19 => 0xff, 72 => 0x88, 73 => 0x88 },
	'filtereffectneutral' => { 72 => 0x58, 73 => 0x58 },
	'filtereffectportrait' => { 72 => 0x28, 73 => 0x28 },
	'filtereffectstandard' => { 72 => 0x10, 73 => 0x10 },
	'filtereffectuserdef1' => { 72 => 0xa0, 73 => 0xb8 },
	'filtereffectuserdef2' => { 72 => 0xb8, 73 => 0xd0 },
	'filtereffectuserdef3' => { 72 => 0xd0, 73 => 0xe8 },
	'finderdisplayduringexposure' => { 86 => 0x1 },
	'finesharpness' => { 379 => 0x70 },
	'finetuneoptcenterweighted' => { 301 => '7.2', 302 => '9.1', 304 => '9.1', 305 => '9.1', 309 => '8.1', 314 => '9.1', 315 => '9.1', 316 => '9.1', 317 => 0x23, 318 => 0x23, 319 => 0x23 },
	'finetuneopthighlightweighted' => { 304 => '46.1', 305 => '46.1', 314 => '46.1', 315 => '46.1', 317 => 0x27, 318 => 0x27, 319 => 0x27 },
	'finetuneoptmatrixmetering' => { 301 => '8.1', 302 => '8.2', 304 => '8.2', 305 => '8.2', 309 => '7.2', 310 => '6.1', 314 => '8.2', 315 => '8.2', 316 => '8.2', 317 => 0x21, 318 => 0x21, 319 => 0x21 },
	'finetuneoptspotmetering' => { 301 => '8.2', 302 => '9.2', 304 => '9.2', 305 => '9.2', 309 => '8.2', 310 => '6.2', 314 => '9.2', 315 => '9.2', 316 => '9.2', 317 => 0x25, 318 => 0x25, 319 => 0x25 },
	'finishexposure' => { 141 => 0xdbd },
	'finishfiletype' => { 141 => 0xdb8 },
	'finishlook' => { 141 => 0xdbc },
	'finishnoise' => { 141 => 0xdba },
	'finishresolution' => { 141 => 0xdb9 },
	'finishsharpening' => { 141 => 0xdbb },
	'firmware' => { 326 => 0x405, 421 => [0x8c,0x17,0x3b], 502 => 'Firmware' },
	'firmware2' => { 421 => 0x57 },
	'firmwaredate' => { 115 => 0x15, 116 => 0x2001, 405 => 0x4, 407 => 0x30 },
	'firmwareid' => { 191 => 0x0 },
	'firmwarename' => { 418 => 0xa001 },
	'firmwarerevision' => { 19 => 0xa4, 66 => 0x1e, 409 => 0x0 },
	'firmwarerevision2' => { 409 => 0xc },
	'firmwareversion' => { 7 => 0x10b, 11 => 0x136, 14 => 0xff, 15 => 0x107, 141 => [0x415,0xce5], 157 => 0x57, 159 => 'FirmwareVersion', 342 => 0x320, 344 => 0x2, 346 => 0x3109, 379 => 0x230, 404 => ['CNFV','FIRM'], 406 => 0x18, 407 => 0x2a, 411 => 0x2 },
	'firmwareversions' => { 388 => 0x301 },
	'firstphotodate' => { 493 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 331 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 134 => 0x16, 500 => 'FixtureIdentifier' },
	'flash' => { 117 => 'XMP-Flash', 122 => 0x9209, 155 => 0x22, 185 => 0x1f, 186 => 0x15, 407 => 0x5a, 511 => 'Flash' },
	'flashaction' => { 431 => 0x3e, 432 => 0x3e, 444 => 0x2017, 449 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 431 => 0x4c, 432 => 0x4c, 449 => 0x77 },
	'flashactionexternal' => { 449 => [0x78,0x7c] },
	'flashactivity' => { 36 => 0x1c },
	'flashbatterylevel' => { 46 => 0x249 },
	'flashbias' => { 344 => 0x24 },
	'flashbits' => { 36 => 0x1d },
	'flashburstpriority' => { 317 => 0x111, 318 => 0x111, 319 => 0x129 },
	'flashbuttonfunction' => { 87 => 0x70e },
	'flashchargelevel' => { 326 => 0x1010 },
	'flashcolorfilter' => { 218 => 0x10, 219 => 0x10, 221 => 0x10 },
	'flashcommandermode' => { 216 => '9.1', 217 => '9.1', 218 => '9.1', 219 => '9.1', 221 => '9.1' },
	'flashcompensation' => { 141 => 0x3f3, 216 => 0xa, 217 => 0xa, 218 => 0xa, 219 => 0x27, 220 => 0xa, 221 => 0xa, 502 => 'FlashCompensation' },
	'flashcontrol' => { 431 => 0x23, 432 => 0x1f, 433 => 0x21 },
	'flashcontrolbuilt-in' => { 310 => '16.1', 311 => '23.1', 313 => '23.1', 314 => '24.1' },
	'flashcontrolmode' => { 216 => '9.2', 217 => '9.2', 218 => '9.2', 219 => '9.2', 221 => '9.2', 227 => 0x214, 242 => 0x148, 243 => 0x1b8, 244 => 0x1a8, 245 => 0x1bc, 246 => 0x1bc, 321 => 0x404 },
	'flashcurtain' => { 344 => 0x48 },
	'flashdefault' => { 187 => 0x42 },
	'flashdevice' => { 326 => 0x1005 },
	'flashdistance' => { 116 => 0x2034 },
	'flashenergy' => { 122 => 0xa20b, 511 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 238 => 0x18 },
	'flashexposurecomp' => { 79 => 0xf, 130 => 0x1011, 162 => 'ExposureComp', 184 => 0x23, 189 => 0x104, 190 => 0x49c1, 238 => 0x12, 321 => 0x401, 326 => 0x1023, 379 => 0x4d, 411 => 0x100b, 421 => [0x3a,0x56], 444 => 0x104 },
	'flashexposurecomp2' => { 282 => 0x4d2 },
	'flashexposurecomp3' => { 218 => 0x1d },
	'flashexposurecomp4' => { 218 => 0x27 },
	'flashexposurecomparea' => { 302 => '38.4', 304 => '38.4', 305 => '38.4', 314 => '38.4', 315 => '38.4', 317 => 0x59, 318 => 0x59, 319 => 0x59 },
	'flashexposurecompset' => { 187 => 0x10, 352 => 0xe, 431 => 0x14, 432 => 0x12, 433 => 0x23, 449 => 0x1f },
	'flashexposurecompset2' => { 449 => [0x26,0x2c] },
	'flashexposureindicator' => { 187 => 0x54 },
	'flashexposureindicatorlast' => { 187 => 0x56 },
	'flashexposureindicatornext' => { 187 => 0x55 },
	'flashexposurelock' => { 59 => 0x19 },
	'flashfired' => { 143 => 0x5d, 162 => 'Fired', 184 => 0x14, 281 => '590.3', 511 => [\'Flash','FlashFired'] },
	'flashfiring' => { 87 => 0x306, 88 => 0x6, 89 => 0x7, 92 => 0x7 },
	'flashfirmwareversion' => { 322 => 0x1002 },
	'flashfocallength' => { 216 => 0xb, 217 => 0xc, 218 => 0xc, 219 => 0xc, 220 => 0xc, 221 => 0x26 },
	'flashfunction' => { 190 => 0x31, 511 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 216 => 0xe, 217 => 0xf, 218 => 0xf, 219 => 0xf, 220 => 0xf, 221 => 0xf, 227 => 0x21a, 242 => 0x14e, 244 => 0x1ae, 245 => 0x1c2, 246 => 0x1c2 },
	'flashgroupacompensation' => { 216 => 0x11, 217 => 0x12, 218 => 0x13, 219 => 0x28, 220 => 0x28, 221 => 0x28 },
	'flashgroupacontrolmode' => { 216 => 0xf, 217 => '16.1', 218 => '17.1', 219 => '17.1', 220 => '17.1', 221 => '17.1' },
	'flashgroupaoutput' => { 216 => 0x11, 217 => 0x12, 218 => 0x13, 219 => 0x28, 220 => 0x28, 221 => 0x28 },
	'flashgroupbcompensation' => { 216 => 0x12, 217 => 0x13, 218 => 0x14, 219 => 0x29, 220 => 0x29, 221 => 0x29 },
	'flashgroupbcontrolmode' => { 216 => 0x10, 217 => '17.1', 218 => '18.1', 219 => '18.1', 220 => '18.1', 221 => '18.1' },
	'flashgroupboutput' => { 216 => 0x12, 217 => 0x13, 218 => 0x14, 219 => 0x29, 220 => 0x29, 221 => 0x29 },
	'flashgroupccompensation' => { 217 => 0x14, 218 => 0x15, 219 => 0x2a, 220 => 0x2a, 221 => 0x2a },
	'flashgroupccontrolmode' => { 217 => '17.2', 218 => '18.2', 219 => '18.2', 220 => '18.2', 221 => '18.2' },
	'flashgroupcoutput' => { 217 => 0x14, 218 => 0x15, 219 => 0x2a, 220 => 0x2a, 221 => 0x2a },
	'flashguidenumber' => { 79 => 0xd, 97 => 0x0, 162 => 'GuideNumber' },
	'flashilluminationpattern' => { 221 => 0x25 },
	'flashintensity' => { 115 => [0x19,0x5], 321 => 0x405 },
	'flashlevel' => { 303 => 0x9, 444 => 0xb048 },
	'flashmake' => { 162 => 'Make' },
	'flashmanufacturer' => { 181 => 'FlashManufacturer' },
	'flashmastercompensation' => { 227 => 0x22e, 242 => 0x162, 244 => 0x1aa, 245 => 0x1be, 246 => 0x1be },
	'flashmastercontrolmode' => { 227 => 0x22c, 242 => 0x160 },
	'flashmasteroutput' => { 227 => 0x232, 242 => 0x166 },
	'flashmetering' => { 184 => 0x3f, 187 => 0x1c },
	'flashmeteringmode' => { 7 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 18 => 0x15, 20 => 0x15, 22 => 0x15, 28 => 0x15 },
	'flashmeteringsegments' => { 379 => 0x20a },
	'flashmode' => { 115 => 0x4, 141 => 0x3f2, 143 => 0x5c, 154 => 0x27, 162 => 'Mode', 184 => 0x2, 185 => 0x20, 186 => 0x16, 187 => 0xf, 238 => 0x87, 321 => 0x400, 326 => 0x1004, 379 => 0xc, 386 => 0x4, 410 => 0x20, 411 => 0x100a, 420 => 0x225, 431 => 0x13, 432 => 0x7f, 433 => 0x20, 449 => 0x10, 453 => 0x1138, 454 => 0x1138, 455 => 0x1114, 456 => 0x1190, 457 => 0x116c, 458 => 0x1024, 459 => 0x21c, 460 => 0x21c, 461 => 0x211, 511 => [\'Flash','FlashMode'] },
	'flashmodebutton' => { 246 => 0x80e },
	'flashmodebuttonplaybackmode' => { 246 => 0x818 },
	'flashmodel' => { 162 => 'Model', 181 => 'FlashModel', 322 => 0x1001 },
	'flashoptions' => { 360 => 0x2 },
	'flashoptions2' => { 360 => 0x10 },
	'flashoutput' => { 46 => 0x248, 79 => 0x21, 216 => 0xa, 217 => 0xa, 218 => 0xa, 219 => 0x27, 221 => 0x21, 227 => 0x21e, 242 => 0x152, 244 => 0x1b2, 245 => 0x1c6, 246 => 0x1c6 },
	'flashpixversion' => { 122 => 0xa000, 511 => 'FlashpixVersion' },
	'flashredeyemode' => { 511 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 227 => 0x228, 242 => 0x15c, 244 => 0x1bc, 321 => 0x403 },
	'flashreturn' => { 511 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 162 => 'SerialNumber', 322 => 0x1003 },
	'flashsetting' => { 238 => 0x8 },
	'flashshutterspeed' => { 301 => '20.2', 302 => '23.2', 304 => '23.2', 305 => '23.2', 310 => '15.2', 311 => '22.2', 312 => '7.2', 313 => '22.2', 314 => '23.2', 315 => '23.2', 316 => '23.1', 317 => 0x57, 318 => 0x57, 319 => 0x57 },
	'flashsource' => { 216 => 0x4, 217 => 0x4, 218 => 0x4, 219 => 0x4, 220 => 0x4, 221 => 0x4 },
	'flashstatus' => { 367 => 0x0, 449 => [0x82,0x86], 463 => 0x31, 464 => 0x39, 465 => 0x39 },
	'flashstatusbuilt-in' => { 433 => [0x87,0x287] },
	'flashstatusexternal' => { 433 => [0x88,0x288] },
	'flashsyncspeed' => { 301 => '20.1', 302 => '23.1', 304 => '23.1', 305 => '23.1', 310 => '15.1', 311 => '22.1', 313 => '22.1', 314 => '23.1', 315 => '23.1', 317 => 0x53, 318 => 0x53, 319 => 0x53 },
	'flashsyncspeedav' => { 85 => 0x3, 87 => 0x10f, 88 => 0x2, 89 => 0x3, 90 => 0x2, 91 => 0x2, 92 => 0x3, 93 => 0x6 },
	'flashthreshold' => { 97 => 0x1 },
	'flashtype' => { 162 => 'Type', 187 => 0x59, 238 => 0x9, 322 => 0x1000 },
	'flashwarning' => { 311 => '30.1', 312 => '7.1', 316 => '31.1', 344 => 0x62 },
	'flashwirelessoption' => { 227 => 0x234, 242 => 0x15a, 244 => 0x1c8 },
	'flexiblespotposition' => { 444 => 0x201d },
	'flickadvancedirection' => { 317 => 0x25f, 318 => 0x25f, 319 => 0x277 },
	'flickerreduce' => { 420 => 0x218 },
	'flickerreduction' => { 130 => 0x1446, 265 => 0x7 },
	'flickerreductionindicator' => { 260 => 0x532 },
	'flickerreductionshooting' => { 243 => 0x1b4, 244 => 0x1a4, 245 => 0x1b8, 246 => 0x1b8 },
	'flightpitchdegree' => { 119 => 'FlightPitchDegree' },
	'flightrolldegree' => { 119 => 'FlightRollDegree' },
	'flightxspeed' => { 119 => 'FlightXSpeed' },
	'flightyawdegree' => { 119 => 'FlightYawDegree' },
	'flightyspeed' => { 119 => 'FlightYSpeed' },
	'flightzspeed' => { 119 => 'FlightZSpeed' },
	'fliphorizontal' => { 294 => 0x76a43206 },
	'fnumber' => { 7 => 0x3, 9 => 0x3, 11 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x3, 31 => 0x5, 32 => 0x6, 79 => 0x15, 122 => 0x829d, 140 => 0xfd04, 143 => 0x1e, 145 => 0xfa23, 147 => 0xf103, 150 => 0x13, 152 => 0x3c, 154 => 0x1c, 155 => 0x18, 157 => 0xc, 166 => 'FNumber', 184 => 0xa, 185 => 0x36, 186 => 0x47, 187 => 0x9, 190 => 0x49c7, 236 => 0x38, 343 => 0x35a, 379 => 0x13, 418 => 0xa019, 421 => [0x31,0x49], 431 => 0x1, 432 => 0x1, 449 => [0x20,0x22,0x26], 511 => 'FNumber' },
	'focaldistance' => { 491 => 'FocalDistance' },
	'focallength' => { 7 => 0x1d, 8 => 0xa, 9 => 0x23, 10 => 0x9, 11 => 0x1d, 12 => 0x9, 13 => 0x1e, 14 => 0x1d, 15 => 0x1d, 16 => 0x1e, 17 => 0x1e, 18 => 0x1e, 19 => 0x28, 20 => 0x1e, 21 => 0x23, 22 => 0x1e, 23 => 0x1e, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x23, 28 => 0x1e, 29 => 0x23, 61 => 0x1, 116 => 0x1d, 122 => 0x920a, 150 => 0x1d, 166 => 'FocalLength', 184 => 0x12, 231 => 0xa, 232 => 0xb, 236 => [0xc,0x3c], 338 => 0x1, 379 => 0x1d, 388 => 0x403, 411 => 0x1500, 430 => 0xe, 457 => 0x1278, 458 => 0x1134, 459 => 0x32c, 460 => 0x32c, 461 => 0x30a, 511 => 'FocalLength' },
	'focallength2' => { 449 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 122 => 0xa405, 418 => 0xa01a, 511 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 430 => 0x10 },
	'focalplaneafpointarea' => { 462 => 0x2 },
	'focalplaneafpointlocation1' => { 462 => 0x6 },
	'focalplaneafpointlocation10' => { 462 => 0x2a },
	'focalplaneafpointlocation11' => { 462 => 0x2e },
	'focalplaneafpointlocation12' => { 462 => 0x32 },
	'focalplaneafpointlocation13' => { 462 => 0x36 },
	'focalplaneafpointlocation14' => { 462 => 0x3a },
	'focalplaneafpointlocation15' => { 462 => 0x3e },
	'focalplaneafpointlocation2' => { 462 => 0xa },
	'focalplaneafpointlocation3' => { 462 => 0xe },
	'focalplaneafpointlocation4' => { 462 => 0x12 },
	'focalplaneafpointlocation5' => { 462 => 0x16 },
	'focalplaneafpointlocation6' => { 462 => 0x1a },
	'focalplaneafpointlocation7' => { 462 => 0x1e },
	'focalplaneafpointlocation8' => { 462 => 0x22 },
	'focalplaneafpointlocation9' => { 462 => 0x26 },
	'focalplaneafpointsused' => { 462 => 0x1 },
	'focalplanediagonal' => { 322 => 0x103, 326 => 0x205 },
	'focalplaneresolutionunit' => { 122 => 0xa210, 511 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 122 => 0xa20e, 511 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 61 => 0x2 },
	'focalplanexunknown' => { 61 => 0x2 },
	'focalplaneyresolution' => { 122 => 0xa20f, 511 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 61 => 0x3 },
	'focalplaneyunknown' => { 61 => 0x3 },
	'focalpointx' => { 491 => 'FocalPointX' },
	'focalpointy' => { 491 => 'FocalPointY' },
	'focaltype' => { 10 => 0x2d, 61 => 0x0 },
	'focalunits' => { 36 => 0x19 },
	'focus' => { 284 => 0x8 },
	'focusarea' => { 184 => 0x31 },
	'focusareaselection' => { 312 => '15.2' },
	'focusbracket' => { 344 => 0xbd },
	'focusbracketstepsize' => { 321 => 0x308 },
	'focuscontinuous' => { 36 => 0x20 },
	'focusdisplayaiservoandmf' => { 87 => 0x515 },
	'focusdistance' => { 166 => 'FocusDistance', 184 => 0x13, 190 => 0x49bb, 231 => 0x9, 232 => 0xa, 236 => [0xb,0x4e], 324 => 0x305, 338 => 0x0, 342 => 0x304, 343 => 0x304 },
	'focusdistancelower' => { 7 => 0x45, 9 => 0x8e, 11 => 0x45, 13 => 0x56, 14 => 0x45, 15 => 0x45, 16 => 0x52, 17 => 0x52, 18 => 0x56, 20 => 0x52, 21 => 0x8e, 22 => 0x59, 23 => 0x57, 24 => 0x8e, 25 => 0x94, 26 => 0x95, 27 => 0xa7, 28 => 0x56, 29 => 0xa7, 59 => 0x15, 79 => 0x14 },
	'focusdistancerange' => { 1 => 0xc },
	'focusdistancerangewidth' => { 236 => 0x4c },
	'focusdistanceupper' => { 7 => 0x43, 9 => 0x8c, 11 => 0x43, 13 => 0x54, 14 => 0x43, 15 => 0x43, 16 => 0x50, 17 => 0x50, 18 => 0x54, 20 => 0x50, 21 => 0x8c, 22 => 0x57, 23 => 0x55, 24 => 0x8c, 25 => 0x92, 26 => 0x93, 27 => 0xa5, 28 => 0x54, 29 => 0xa5, 59 => 0x14, 79 => 0x13 },
	'focusholdbutton' => { 187 => 0x44 },
	'focusinfoversion' => { 324 => 0x0 },
	'focusingscreen' => { 86 => 0x0, 87 => 0x80b, 92 => 0x0 },
	'focuslocation' => { 444 => 0x2027 },
	'focuslocation2' => { 444 => 0x204a },
	'focuslocked' => { 183 => 0x14 },
	'focusmode' => { 36 => 0x7, 115 => 0x3, 116 => [0x3003,0xd], 130 => 0x1021, 141 => 0x3f5, 143 => 0x38, 159 => 'FocusMode', 184 => 0x30, 186 => 0xe, 187 => 0xc, 238 => 0x7, 321 => 0x301, 326 => 0x100b, 344 => 0x7, 379 => 0xd, 386 => 0x3, 411 => 0x1006, 424 => [0xb,0x5], 430 => [0x15,0x1d], 431 => 0x4d, 432 => 0x4d, 444 => [0xb042,0xb04e,0x201b], 449 => 0x13, 470 => 0x16 },
	'focusmode2' => { 129 => '0.1', 360 => '3.1', 449 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 303 => '10.1', 428 => 0x14, 429 => 0x15, 431 => 0x10, 432 => 0xf, 433 => 0x6 },
	'focusmodeswitch' => { 187 => 0x58, 431 => 0x2e },
	'focuspeakingdisplay' => { 317 => 0x235, 318 => 0x235, 319 => 0x24d },
	'focuspeakinghighlightcolor' => { 317 => 0x4b, 318 => 0x4b, 319 => 0x4b },
	'focuspeakinglevel' => { 317 => 0x49, 318 => 0x49, 319 => 0x49 },
	'focuspixel' => { 130 => 0x1023 },
	'focuspointlock' => { 317 => 0x1d3, 318 => 0x1d3, 319 => 0x1eb },
	'focuspointpersistence' => { 317 => 0x105, 318 => 0x105, 319 => 0x11b },
	'focuspointwrap' => { 301 => '2.2', 302 => '2.2', 304 => '2.1', 305 => '2.1', 309 => '1.1', 310 => '2.2', 311 => '1.1', 314 => '2.2', 315 => '2.1', 316 => '2.5', 317 => 0x16, 318 => 0x16, 319 => 0x16 },
	'focusposition' => { 1 => 0x2f, 231 => 0x8, 232 => 0x8, 379 => 0x10, 442 => 0x9bb },
	'focusposition2' => { 449 => [0x29,0x2b,0x2f], 470 => 0x2d, 473 => 0x20 },
	'focuspositionhorizontal' => { 196 => 0x2f, 197 => 0x43 },
	'focuspositionvertical' => { 196 => 0x31, 197 => 0x45 },
	'focusprocess' => { 321 => 0x302 },
	'focusrange' => { 36 => 0x12, 326 => 0x100a },
	'focusrangeindex' => { 370 => '3.1' },
	'focusresult' => { 197 => 0x4a },
	'focusringrotation' => { 87 => 0x713 },
	'focussetting' => { 421 => 0x6 },
	'focusshiftautoreset' => { 245 => 0x6da, 246 => 0x748 },
	'focusshiftexposurelock' => { 227 => 0x1b4, 242 => 0xe8, 243 => 0x100, 244 => 0xf4, 245 => 0x104, 246 => 0x104 },
	'focusshiftinterval' => { 227 => 0x1b0, 242 => 0xe4, 243 => 0xfc, 244 => 0xf0, 245 => 0x100, 246 => 0x100 },
	'focusshiftnumbershots' => { 227 => 0x1a8, 242 => 0xdc, 243 => 0xf4, 244 => 0xe8, 245 => 0xf8, 246 => 0xf8 },
	'focusshiftshooting' => { 263 => 0x20 },
	'focusshiftstepwidth' => { 227 => 0x1ac, 242 => 0xe0, 243 => 0xf8, 244 => 0xec, 245 => 0xfc, 246 => 0xfc },
	'focusstatus' => { 430 => 0x19, 431 => 0x53, 432 => 0x53 },
	'focusstepcount' => { 324 => 0x301, 326 => 0x100e },
	'focusstepinfinity' => { 324 => 0x303, 326 => 0x103b },
	'focusstepnear' => { 324 => 0x304, 326 => 0x103c },
	'focusstepsfrominfinity' => { 236 => 0x58 },
	'focustrackinglockon' => { 301 => ['1.5','4.1'], 302 => '1.4', 309 => '0.4', 310 => '3.1', 311 => '0.4', 314 => '1.4' },
	'focuswarning' => { 130 => 0x1301 },
	'foldername' => { 184 => 0x27 },
	'foldernumber' => { 431 => 0x9a, 433 => [0x402,0x114,0x316] },
	'fontcomposite' => { 539 => [\'Fonts','FontsComposite'] },
	'fontface' => { 539 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 539 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 539 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 539 => [\'Fonts','FontsFontName'] },
	'fonts' => { 539 => 'Fonts' },
	'fonttype' => { 539 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 539 => [\'Fonts','FontsVersionString'] },
	'for' => { 395 => 'For' },
	'forcewrite' => { 123 => 'ForceWrite' },
	'format' => { 404 => "\xa9fmt", 490 => 'Format', 508 => 'format', 532 => 'Format' },
	'forwardlock' => { 529 => 'forwardlock' },
	'forwardmatrix1' => { 122 => 0xc714 },
	'forwardmatrix2' => { 122 => 0xc715 },
	'forwardmatrix3' => { 122 => 0xcd34 },
	'fossilspecimen' => { 121 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 121 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 69 => [0x2,0x4] },
	'frameheight' => { 130 => 0x3822 },
	'framenum' => { 390 => 0xd7 },
	'framenumber' => { 130 => 0x8003, 190 => 0x3c, 379 => 0x29 },
	'framerate' => { 69 => [0x1,0x6], 122 => 0xc764, 130 => 0x3820 },
	'framereadouttime' => { 398 => 'camera.framereadouttimeinmicroseconds' },
	'framewidth' => { 130 => 0x3821 },
	'framing' => { 523 => 'framing' },
	'freebytes' => { 100 => 0x1 },
	'freememorycardimages' => { 185 => [0x37,0x54], 186 => [0x2d,0x4a], 187 => 0x32 },
	'frontfacingcamera' => { 1 => 0x45 },
	'fujiflashmode' => { 130 => 0x1010 },
	'fujimodel' => { 130 => 0x1447 },
	'fujimodel2' => { 130 => 0x1448 },
	'fullhdhighspeedrec' => { 130 => 0x3824 },
	'fullimagesize' => { 444 => 0xb02b },
	'fullpanoheightpixels' => { 493 => 'FullPanoHeightPixels', 494 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 493 => 'FullPanoWidthPixels', 494 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 411 => 0x100d },
	'fullsizeimage' => { 165 => 'data' },
	'fullsizeimagename' => { 165 => '1Name' },
	'fullsizeimagetype' => { 165 => '0Type' },
	'func1button' => { 304 => '14.1', 305 => '14.1', 315 => '14.1', 317 => 0x63, 318 => 0x63, 319 => 0x63 },
	'func1buttonplaybackmode' => { 317 => 0x1a5, 318 => 0x1a5, 319 => 0x1bd },
	'func1buttonplusdials' => { 304 => '42.1', 305 => '42.1', 315 => '42.1' },
	'func2button' => { 304 => '80.1', 305 => '80.1', 315 => '80.1', 317 => 0x73, 318 => 0x73, 319 => 0x73 },
	'func2buttonplaybackmode' => { 317 => 0x1a7, 318 => 0x1a7, 319 => 0x1bf },
	'func2buttonplusdials' => { 304 => '81.1' },
	'func3button' => { 304 => '83.1', 318 => 0x119, 319 => 0x131 },
	'func3buttonplaybackmode' => { 318 => 0x1a9, 319 => 0x1c1 },
	'func4button' => { 318 => 0x175, 319 => 0x18d },
	'func4buttonplaybackmode' => { 318 => 0x1af, 319 => 0x1c7 },
	'funcbutton' => { 301 => ['14.1','15.1'], 302 => '14.1', 310 => '28.1', 311 => '13.1', 314 => '14.1', 316 => '14.1' },
	'funcbuttonplusdials' => { 301 => ['14.2','15.2'], 302 => '14.2', 310 => '31.1', 314 => '42.1' },
	'functionbutton' => { 308 => '13.1', 312 => '5.2' },
	'gainbase' => { 325 => 0x610 },
	'gaincontrol' => { 122 => 0xa407, 511 => 'GainControl' },
	'gainmapmax' => { 516 => 'GainMapMax' },
	'gainmapmin' => { 516 => 'GainMapMin' },
	'gamma' => { 122 => 0xa500, 141 => 0x8fe, 332 => 'gAMA', 349 => 0x11c, 512 => 'Gamma', 516 => 'Gamma' },
	'gammablackpoint' => { 108 => 0xc },
	'gammacolortone' => { 108 => 0x3 },
	'gammacompensatedvalue' => { 136 => 0x91 },
	'gammacontrast' => { 108 => 0x2 },
	'gammacurveoutputrange' => { 108 => 0xf },
	'gammahighlight' => { 108 => 0xa },
	'gammalinear' => { 106 => 0x20200 },
	'gammamidpoint' => { 108 => 0xe },
	'gammasaturation' => { 108 => 0x4 },
	'gammashadow' => { 108 => 0x9 },
	'gammasharpnessstrength' => { 108 => 0x8 },
	'gammaunsharpmaskfineness' => { 108 => 0x6 },
	'gammaunsharpmaskstrength' => { 108 => 0x5 },
	'gammaunsharpmaskthreshold' => { 108 => 0x7 },
	'gammawhitepoint' => { 108 => 0xd },
	'garminsettings' => { 404 => 'pmcc' },
	'garminsoftware' => { 404 => 'uuid' },
	'gdalmetadata' => { 122 => 0xa480 },
	'gdalnodata' => { 122 => 0xa481 },
	'geimagesize' => { 130 => 0x1304 },
	'gemake' => { 132 => 0x300 },
	'gemodel' => { 132 => 0x207 },
	'genre' => { 396 => ['gnre',"\xa9gen"], 398 => 'genre', 404 => ['gnre',"\xa9gen"], 519 => 'Genre', 524 => 'genre', 534 => 'genre' },
	'genrecvid' => { 519 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 519 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 519 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 519 => [\'Genre','GenreCvTermRefinedAbout'] },
	'genreid' => { 396 => 'geID' },
	'geography' => { 525 => 'geography' },
	'geologicalcontext' => { 121 => 'GeologicalContext' },
	'geologicalcontextbed' => { 121 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 121 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 121 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 121 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 121 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 123 => 'Geosync' },
	'geotag' => { 123 => 'Geotag' },
	'geotiffasciiparams' => { 122 => 0x87b1 },
	'geotiffdirectory' => { 122 => 0x87af },
	'geotiffdoubleparams' => { 122 => 0x87b0 },
	'geotime' => { 123 => 'Geotime' },
	'giftftppriority' => { 495 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 119 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 119 => 'GimbalReverse' },
	'gimbalrolldegree' => { 119 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 119 => 'GimbalYawDegree' },
	'globalaltitude' => { 393 => 0x419 },
	'globalangle' => { 393 => 0x40d },
	'good' => { 534 => 'good' },
	'googlehostheader' => { 396 => 'gshh' },
	'googlepingmessage' => { 396 => 'gspm' },
	'googlepingurl' => { 396 => 'gspu' },
	'googleplusuploadcode' => { 122 => 0x9009 },
	'googlesourcedata' => { 396 => 'gssd' },
	'googlestarttime' => { 396 => 'gsst' },
	'googletrackduration' => { 396 => 'gstd' },
	'goprotype' => { 404 => 'GoPr' },
	'gpsaltitude' => { 133 => 0x6, 163 => 'Altitude', 511 => 'GPSAltitude' },
	'gpsaltituderef' => { 133 => 0x5, 511 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 133 => 0x1c, 511 => 'GPSAreaInformation' },
	'gpscoordinates' => { 396 => "\xa9xyz", 398 => 'location.ISO6709', 404 => ['@xyz',"\xa9xyz"] },
	'gpsdatestamp' => { 133 => 0x1d },
	'gpsdatetime' => { 163 => 'DateTime', 511 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 133 => 0x18, 163 => 'Bearing', 511 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 133 => 0x17, 511 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 133 => 0x1a, 163 => 'Distance', 511 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 133 => 0x19, 511 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 133 => 0x14, 511 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 133 => 0x13 },
	'gpsdestlongitude' => { 133 => 0x16, 511 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 133 => 0x15 },
	'gpsdifferential' => { 133 => 0x1e, 163 => 'Differential', 511 => 'GPSDifferential' },
	'gpsdop' => { 133 => 0xb, 511 => 'GPSDOP' },
	'gpshpositioningerror' => { 133 => 0x1f, 511 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 133 => 0x11, 511 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 133 => 0x10, 511 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 117 => 'GPS-GPSLatitude', 119 => 'GpsLatitude', 133 => 0x2, 163 => 'Latitude', 511 => 'GPSLatitude' },
	'gpslatituderef' => { 133 => 0x1 },
	'gpslongitude' => { 117 => 'GPS-GPSLongitude', 119 => 'GpsLongitude', 133 => 0x4, 163 => 'Longitude', 511 => 'GPSLongitude' },
	'gpslongituderef' => { 133 => 0x3 },
	'gpslongtitude' => { 119 => 'GpsLongtitude' },
	'gpsmapdatum' => { 133 => 0x12, 163 => 'Datum', 511 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 133 => 0xa, 163 => 'MeasureMode', 511 => 'GPSMeasureMode' },
	'gpsposition' => { 117 => 'Exif-GPSPosition' },
	'gpsprocessingmethod' => { 133 => 0x1b, 511 => 'GPSProcessingMethod' },
	'gpssatellites' => { 133 => 0x8, 163 => 'Satellites', 511 => 'GPSSatellites' },
	'gpsspeed' => { 133 => 0xd, 163 => 'Speed', 511 => 'GPSSpeed' },
	'gpsspeedref' => { 133 => 0xc, 511 => 'GPSSpeedRef' },
	'gpsstatus' => { 133 => 0x9, 511 => 'GPSStatus' },
	'gpsstring' => { 141 => 0x402 },
	'gpstimestamp' => { 133 => 0x7 },
	'gpstrack' => { 133 => 0xf, 163 => 'Heading', 511 => 'GPSTrack' },
	'gpstrackref' => { 133 => 0xe, 511 => 'GPSTrackRef' },
	'gpsversionid' => { 133 => 0x0, 511 => 'GPSVersionID' },
	'gradation' => { 321 => 0x50f },
	'gradientbasedcorractive' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrblacks2012' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'] },
	'gradientbasedcorrbrightness' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrcorrectionname' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'] },
	'gradientbasedcorrcorrectionsyncid' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'] },
	'gradientbasedcorrdefringe' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrdehaze' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'] },
	'gradientbasedcorrections' => { 505 => 'GradientBasedCorrections', 507 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'] },
	'gradientbasedcorrluminancenoise' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskinputdigest' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'gradientbasedcorrmaskleft' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmaskactive' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'gradientbasedcorrmaskmaskblendmode' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmaskdigest' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'gradientbasedcorrmaskmaskinverted' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'gradientbasedcorrmaskmaskname' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'] },
	'gradientbasedcorrmaskmasks' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'] },
	'gradientbasedcorrmaskmasksalpha' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'gradientbasedcorrmaskmasksangle' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'gradientbasedcorrmaskmasksbottom' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'gradientbasedcorrmaskmaskscentervalue' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'gradientbasedcorrmaskmaskscenterweight' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'gradientbasedcorrmaskmasksdabs' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'gradientbasedcorrmaskmasksfeather' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'gradientbasedcorrmaskmasksflipped' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'gradientbasedcorrmaskmasksflow' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'gradientbasedcorrmaskmasksfullx' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'gradientbasedcorrmaskmasksfully' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'gradientbasedcorrmaskmasksinputdigest' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'gradientbasedcorrmaskmasksleft' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'gradientbasedcorrmaskmasksmaskactive' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'gradientbasedcorrmaskmasksmaskblendmode' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmasksmaskdigest' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'gradientbasedcorrmaskmasksmaskinverted' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'gradientbasedcorrmaskmasksmaskname' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'gradientbasedcorrmaskmasksmasksubtype' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksmasksyncid' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'gradientbasedcorrmaskmasksmaskversion' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'gradientbasedcorrmaskmasksmidpoint' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'gradientbasedcorrmaskmasksorigin' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'gradientbasedcorrmaskmasksperimetervalue' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'gradientbasedcorrmaskmasksradius' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'gradientbasedcorrmaskmasksreferencepoint' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'gradientbasedcorrmaskmasksright' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'gradientbasedcorrmaskmasksroundness' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'gradientbasedcorrmaskmaskssizex' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'gradientbasedcorrmaskmaskssizey' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'gradientbasedcorrmaskmaskstop' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'gradientbasedcorrmaskmasksubtype' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksvalue' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'gradientbasedcorrmaskmasksversion' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'gradientbasedcorrmaskmaskswhat' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'gradientbasedcorrmaskmaskswholeimagearea' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'gradientbasedcorrmaskmasksx' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'] },
	'gradientbasedcorrmaskmasksy' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'] },
	'gradientbasedcorrmaskmasksyncid' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'gradientbasedcorrmaskmaskszerox' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'gradientbasedcorrmaskmaskszeroy' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'gradientbasedcorrmaskmaskversion' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'gradientbasedcorrmaskmidpoint' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskorigin' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'] },
	'gradientbasedcorrmaskperimetervalue' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskrange' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'gradientbasedcorrmaskrangeareamodels' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrmaskrangeareamodelscolorsampleinfo' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrmaskrangeareamodelscomponents' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrmaskrangecoloramount' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrmaskrangedepthfeather' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrmaskrangedepthmax' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrmaskrangedepthmin' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrmaskrangeinvert' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'gradientbasedcorrmaskrangelumfeather' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrmaskrangeluminancedepthsampleinfo' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrmaskrangelummax' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrmaskrangelummin' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrmaskrangelumrange' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrmaskrangesampletype' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrmaskrangetype' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'gradientbasedcorrmaskrangeversion' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'gradientbasedcorrmaskreferencepoint' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'gradientbasedcorrmaskright' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskwholeimagearea' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'gradientbasedcorrmaskx' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrrangemask' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'] },
	'gradientbasedcorrrangemaskareamodels' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrrangemaskareamodelscolorsampleinfo' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrrangemaskareamodelscomponents' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrrangemaskcoloramount' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrrangemaskdepthfeather' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrrangemaskdepthmax' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrrangemaskdepthmin' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrrangemaskinvert' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'gradientbasedcorrrangemasklumfeather' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrrangemaskluminancedepthsampleinfo' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrrangemasklummax' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrrangemasklummin' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrrangemasklumrange' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrrangemasksampletype' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrrangemasktype' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'] },
	'gradientbasedcorrrangemaskversion' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'gradientbasedcorrsaturation' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'] },
	'gradientbasedcorrshadows2012' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtexture' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'] },
	'gradientbasedcorrtint' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrtoninghue' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrtoningsaturation' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrwhat' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'gradientbasedcorrwhites2012' => { 505 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'], 507 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'] },
	'grainamount' => { 505 => 'GrainAmount', 507 => 'GrainAmount' },
	'graineffectroughness' => { 130 => 0x1047 },
	'graineffectsize' => { 130 => 0x104c },
	'grainfrequency' => { 505 => 'GrainFrequency', 507 => 'GrainFrequency' },
	'grainseed' => { 505 => 'GrainSeed', 507 => 'GrainSeed' },
	'grainsize' => { 505 => 'GrainSize', 507 => 'GrainSize' },
	'graymixeraqua' => { 505 => 'GrayMixerAqua', 507 => 'GrayMixerAqua' },
	'graymixerblue' => { 505 => 'GrayMixerBlue', 507 => 'GrayMixerBlue' },
	'graymixergreen' => { 505 => 'GrayMixerGreen', 507 => 'GrayMixerGreen' },
	'graymixermagenta' => { 505 => 'GrayMixerMagenta', 507 => 'GrayMixerMagenta' },
	'graymixerorange' => { 505 => 'GrayMixerOrange', 507 => 'GrayMixerOrange' },
	'graymixerpurple' => { 505 => 'GrayMixerPurple', 507 => 'GrayMixerPurple' },
	'graymixerred' => { 505 => 'GrayMixerRed', 507 => 'GrayMixerRed' },
	'graymixeryellow' => { 505 => 'GrayMixerYellow', 507 => 'GrayMixerYellow' },
	'graypoint' => { 481 => 0x8021 },
	'grayresponseunit' => { 122 => 0x122 },
	'greencurvelimits' => { 111 => 0x1c4 },
	'greencurvepoints' => { 110 => 0x53, 111 => 0x19a },
	'greenghostmitigationstatus' => { 1 => 0x3f },
	'greenhsl' => { 106 => 0x20913 },
	'greenhue' => { 505 => 'GreenHue', 507 => 'GreenHue' },
	'greensaturation' => { 505 => 'GreenSaturation', 507 => 'GreenSaturation' },
	'griddisplay' => { 301 => '13.3', 302 => '4.3', 304 => '4.2', 305 => '4.2', 306 => '2.2', 310 => '10.5', 311 => '3.4', 312 => '6.1', 314 => '4.4', 315 => '4.2', 316 => '4.2' },
	'gripbatteryadload' => { 358 => 0x5 },
	'gripbatteryadnoload' => { 358 => 0x4 },
	'gripbatterystate' => { 358 => '1.2' },
	'group' => { 505 => 'Group', 507 => 'Group' },
	'groupareaafillumination' => { 302 => '46.4', 305 => '47.4', 314 => '47.4' },
	'grouping' => { 396 => ['grup',"\xa9grp"], 404 => "\xa9grp" },
	'guid' => { 396 => 'GUID' },
	'h2resetblackpixels' => { 141 => 0x18a6 },
	'h3resetblackcolumns' => { 141 => 0x18ce },
	'h3resetblackpixels' => { 141 => 0x18b0 },
	'halftonehints' => { 122 => 0x141 },
	'hardlink' => { 123 => 'HardLink' },
	'hasalternative' => { 524 => 'hasAlternative' },
	'hascorrection' => { 524 => 'hasCorrection' },
	'hascorrectiona-lang' => { 524 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 524 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 524 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 505 => 'HasCrop', 507 => 'HasCrop' },
	'hasextendedxmp' => { 536 => 'HasExtendedXMP' },
	'hassettings' => { 505 => 'HasSettings', 507 => 'HasSettings' },
	'hastranslation' => { 524 => 'hasTranslation' },
	'hasvisibleoverprint' => { 539 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 539 => 'HasVisibleTransparency' },
	'hdmioutputn-log' => { 242 => 0x35a },
	'hdmioutputresolution' => { 243 => 0x710, 244 => 0x610, 245 => 0x640, 246 => 0x6a8 },
	'hdmiviewassist' => { 318 => 0x20f, 319 => 0x227 },
	'hdr' => { 62 => 0x1, 223 => 0x4, 224 => 0x4, 243 => 0x23a, 246 => 0x23a, 344 => 0x9e, 379 => 0x85, 444 => 0x200a },
	'hdrcapacitymax' => { 516 => 'HDRCapacityMax' },
	'hdrcapacitymin' => { 516 => 'HDRCapacityMin' },
	'hdreditmode' => { 505 => 'HDREditMode', 507 => 'HDREditMode' },
	'hdreffect' => { 62 => 0x2 },
	'hdrgain' => { 1 => 0x30 },
	'hdrheadroom' => { 1 => 0x21 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrlevel' => { 223 => 0x5, 224 => 0x5, 243 => 0x246, 246 => 0x246, 433 => 0x2e, 449 => 0x17 },
	'hdrlevel2' => { 223 => 0x7 },
	'hdrplusmakernote' => { 488 => 'HdrPlusMakernote' },
	'hdrpmakernote' => { 488 => 'hdrp_makernote' },
	'hdrsetting' => { 433 => 0x2d, 449 => 0x16, 453 => 0x1148, 454 => 0x1148, 455 => 0x1124, 456 => 0x11a0, 457 => 0x117c, 458 => 0x1034, 459 => 0x22c, 460 => 0x22c, 461 => 0x21f },
	'hdrsmoothing' => { 223 => 0x6 },
	'hdvideo' => { 396 => 'hdvd' },
	'headline' => { 134 => 0x69, 519 => 'Headline', 522 => 'Headline' },
	'hierarchicalkeywords' => { 174 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 174 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 174 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 174 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 174 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 174 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 174 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 497 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 121 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highframerate' => { 243 => 0x48, 245 => 0x48, 246 => 0x48 },
	'highfrequencyflickerreductionshooting' => { 243 => 0x27c, 245 => 0x27c, 246 => 0x27c },
	'highisomultiplierblue' => { 349 => 0x1a },
	'highisomultipliergreen' => { 349 => 0x19 },
	'highisomultiplierred' => { 349 => 0x18 },
	'highisonoisereduction' => { 16 => 0xbc, 17 => 0xbd, 20 => 0xbd, 28 => 0xc9, 64 => 0x5, 87 => 0x202, 238 => 0xb1, 379 => 0x71, 431 => 0x2c, 432 => 0x26, 433 => 0x26, 444 => 0x2009, 449 => 0x12, 476 => 0x42 },
	'highisonoisereduction2' => { 444 => 0xb050 },
	'highlight' => { 421 => 0xf },
	'highlight2012' => { 505 => 'Highlight2012', 507 => 'Highlight2012' },
	'highlightadj' => { 106 => 0x2030c },
	'highlightcolordistortreduct' => { 481 => 0x8026 },
	'highlightlinearitylimit' => { 418 => 0xa025 },
	'highlightprotection' => { 293 => 0x6 },
	'highlightrecovery' => { 505 => 'HighlightRecovery', 507 => 'HighlightRecovery' },
	'highlights' => { 444 => 0x2033, 499 => 'Highlights' },
	'highlights2012' => { 505 => 'Highlights2012', 507 => 'Highlights2012' },
	'highlightsadj' => { 481 => 0x9019 },
	'highlightshadow' => { 344 => 0xad },
	'highlighttone' => { 130 => 0x1041 },
	'highlighttonepriority' => { 13 => 0x7, 16 => 0x7, 17 => 0x7, 18 => 0x7, 20 => 0x7, 22 => 0x7, 28 => 0x7, 64 => 0x3, 87 => 0x203 },
	'highlightwarning' => { 344 => 0x8002 },
	'highlowkeyadj' => { 379 => 0x6c },
	'highspeedsync' => { 187 => 0x5, 317 => 0x55, 318 => 0x55, 319 => 0x55, 431 => 0x2, 432 => 0x2 },
	'hintversion' => { 404 => 'hinv' },
	'histogramxml' => { 294 => 0x83a1a25 },
	'history' => { 522 => 'History', 535 => 'History' },
	'historyaction' => { 535 => [\'History','HistoryAction'] },
	'historychanged' => { 535 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 535 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 535 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 535 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 535 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 141 => 0xc88 },
	'holefilldeltathreshold' => { 141 => 0xc7e },
	'hometowncity' => { 116 => 0x3006, 379 => 0x23, 385 => 0x2 },
	'hometowncitycode' => { 386 => 0x1000 },
	'hometowndst' => { 379 => 0x25, 385 => '0.2' },
	'hostcomputer' => { 122 => 0x13c },
	'hostsoftwarerendering' => { 141 => 0xce7 },
	'hue' => { 192 => 0x3b, 254 => 0x3d, 255 => 0x45, 379 => 0x67 },
	'hueadj' => { 297 => 0x2f, 481 => 0x8019 },
	'hueadjust' => { 411 => 0x1016 },
	'hueadjustment' => { 185 => 0x4a, 186 => 0x40, 238 => 0x92, 253 => 0x36 },
	'hueadjustmentaqua' => { 505 => 'HueAdjustmentAqua', 507 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 505 => 'HueAdjustmentBlue', 507 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 505 => 'HueAdjustmentGreen', 507 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 505 => 'HueAdjustmentMagenta', 507 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 505 => 'HueAdjustmentOrange', 507 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 505 => 'HueAdjustmentPurple', 507 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 505 => 'HueAdjustmentRed', 507 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 505 => 'HueAdjustmentYellow', 507 => 'HueAdjustmentYellow' },
	'huesetting' => { 329 => 0x1011 },
	'humanobservation' => { 121 => 'HumanObservation' },
	'humanobservationday' => { 121 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 121 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 121 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 121 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 121 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 121 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 121 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationfieldnotes' => { 121 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 121 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 121 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 121 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 121 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 121 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 121 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 121 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 121 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 121 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 121 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 121 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 121 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 122 => 0x9401, 512 => 'Humidity' },
	'icc_profile' => { 123 => 'ICC_Profile' },
	'iccprofilename' => { 522 => 'ICCProfile' },
	'iconuri' => { 404 => 'icnu' },
	'idccreativestyle' => { 481 => 0x8000 },
	'idcpreviewlength' => { 481 => 0x202 },
	'idcpreviewstart' => { 481 => 0x201 },
	'identification' => { 121 => 'Identification' },
	'identificationid' => { 121 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 121 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 121 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 121 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 121 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 121 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifiedbyid' => { 121 => [\'Identification','IdentificationIdentifiedByID'] },
	'identifier' => { 508 => 'identifier', 532 => 'Identifier' },
	'ifcameramodel' => { 141 => 0x9c8 },
	'illuminantdata1' => { 122 => 0xcd35 },
	'illuminantdata2' => { 122 => 0xcd36 },
	'illuminantdata3' => { 122 => 0xcd37 },
	'illumination' => { 312 => '0.5', 406 => 0x48 },
	'imageabsolutex' => { 141 => 0x3fe },
	'imageabsolutey' => { 141 => 0x3ff },
	'imageadjustment' => { 238 => 0x80, 284 => 0x5 },
	'imagealterationconstraints' => { 331 => 'ImageAlterationConstraints' },
	'imagearea' => { 270 => 0x10, 273 => 0x10 },
	'imageareaoffset' => { 379 => 0x38 },
	'imageauthentication' => { 238 => 0x20 },
	'imageboundary' => { 238 => 0x16 },
	'imagecapturerequestid' => { 1 => 0x20 },
	'imagecapturetype' => { 1 => 0x14 },
	'imagecount' => { 130 => 0x1438, 238 => 0xa5, 447 => 0x11b },
	'imagecreator' => { 331 => 'ImageCreator' },
	'imagecreatorid' => { 331 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 331 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 331 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 141 => 0x41f },
	'imagecropy' => { 141 => 0x420 },
	'imagedata' => { 492 => 'Data' },
	'imagedatasize' => { 238 => 0xa2 },
	'imagedescription' => { 122 => 0x10e, 530 => 'ImageDescription' },
	'imageduplicationconstraints' => { 331 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 294 => 0xfe443a45 },
	'imageeditcount' => { 379 => 0x41 },
	'imageediting' => { 379 => 0x32 },
	'imageeditingsoftware' => { 122 => 0xa43b },
	'imageeditor' => { 122 => 0xa438 },
	'imageeffects' => { 411 => 0x1010 },
	'imagefileconstraints' => { 331 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 331 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 331 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 130 => 0x1436 },
	'imageheight' => { 122 => 0x101, 191 => 0xc, 388 => 0x10d, 490 => 'ImageHeight', 530 => 'ImageLength' },
	'imagehistory' => { 122 => 0x9213, 510 => 'ImageHistory' },
	'imageidnumber' => { 339 => 0x340 },
	'imagemimetype' => { 492 => 'Mime' },
	'imagenumber' => { 122 => 0x9211, 159 => 'ImageNumber', 185 => 0xae, 186 => 0x5e, 388 => 0x113, 431 => 0x9b, 433 => [0x400,'276.1',0x314], 502 => 'ImageNumber' },
	'imagenumber2' => { 186 => 0x62 },
	'imageoptimization' => { 238 => 0xa9 },
	'imageorientation' => { 134 => 0x83 },
	'imageprocessing' => { 238 => 0x1a },
	'imageprocessingfiledatecreated' => { 141 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 141 => 0xc80 },
	'imageprocessingflags' => { 1 => 0x19 },
	'imageprocessingversion' => { 325 => 0x0 },
	'imagequality' => { 159 => 'ImageQuality', 272 => '723.2', 273 => '732.2', 281 => '708.1', 344 => 0x1 },
	'imagequality2' => { 321 => 0x603 },
	'imagerank' => { 495 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 141 => 0x600 },
	'imagerboardversion' => { 141 => 0x439 },
	'imagercols' => { 141 => 0x17d4 },
	'imageref' => { 517 => 'ImageRef' },
	'imageregion' => { 519 => 'ImageRegion' },
	'imageregionboundary' => { 519 => [\'ImageRegion','ImageRegionRegionBoundary'] },
	'imageregionboundaryh' => { 519 => [\'ImageRegion','ImageRegionRegionBoundaryRbH'] },
	'imageregionboundaryrx' => { 519 => [\'ImageRegion','ImageRegionRegionBoundaryRbRx'] },
	'imageregionboundaryshape' => { 519 => [\'ImageRegion','ImageRegionRegionBoundaryRbShape'] },
	'imageregionboundaryunit' => { 519 => [\'ImageRegion','ImageRegionRegionBoundaryRbUnit'] },
	'imageregionboundaryvertices' => { 519 => [\'ImageRegion','ImageRegionRegionBoundaryRbVertices'] },
	'imageregionboundaryverticesx' => { 519 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbX'] },
	'imageregionboundaryverticesy' => { 519 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbY'] },
	'imageregionboundaryw' => { 519 => [\'ImageRegion','ImageRegionRegionBoundaryRbW'] },
	'imageregionboundaryx' => { 519 => [\'ImageRegion','ImageRegionRegionBoundaryRbX'] },
	'imageregionboundaryy' => { 519 => [\'ImageRegion','ImageRegionRegionBoundaryRbY'] },
	'imageregionctype' => { 519 => [\'ImageRegion','ImageRegionRCtype'] },
	'imageregionctypeidentifier' => { 519 => [\'ImageRegion','ImageRegionRCtypeIdentifier'] },
	'imageregionctypename' => { 519 => [\'ImageRegion','ImageRegionRCtypeName'] },
	'imageregionid' => { 519 => [\'ImageRegion','ImageRegionRId'] },
	'imageregionname' => { 519 => [\'ImageRegion','ImageRegionName'] },
	'imageregionrole' => { 519 => [\'ImageRegion','ImageRegionRRole'] },
	'imageregionroleidentifier' => { 519 => [\'ImageRegion','ImageRegionRRoleIdentifier'] },
	'imageregionrolename' => { 519 => [\'ImageRegion','ImageRegionRRoleName'] },
	'imageresolution' => { 141 => 0x944 },
	'imageresolutionjpg' => { 141 => 0x945 },
	'imagereview' => { 303 => '0.4', 312 => '0.4' },
	'imagereviewmonitorofftime' => { 302 => '21.1', 304 => '21.1', 305 => '21.1', 309 => '20.1', 314 => '21.1', 315 => '21.1', 317 => 0x39, 318 => 0x39, 319 => 0x39 },
	'imagereviewtime' => { 301 => '25.1', 303 => '2.1', 306 => '19.1', 307 => '20.1', 308 => '20.1', 310 => '9.2', 311 => '20.1', 316 => '21.2' },
	'imagerfiledatecreated' => { 141 => 0x9c5 },
	'imagerfileproductionlevel' => { 141 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 141 => 0x9c7 },
	'imagerotated' => { 154 => 0x2a },
	'imagerpowerondelaymsec' => { 141 => 0x5fd },
	'imagerrows' => { 141 => 0x17de },
	'imagesegmentlines' => { 141 => 0x184d },
	'imagesegmentstartline' => { 141 => 0x184c },
	'imagesequenceinfo' => { 122 => 0xcd44 },
	'imagesize' => { 165 => 'ImageSize' },
	'imagesizeraw' => { 238 => 0x3e },
	'imagesizerestriction' => { 527 => 'imageSizeRestriction' },
	'imagesourcedata' => { 122 => 0x935c },
	'imagespace' => { 141 => 0x909 },
	'imagestabilization' => { 36 => 0x22, 116 => 0x3020, 130 => 0x1422, 159 => 'ImageStabilization', 185 => 0xbd, 186 => 0x71, 187 => 0x57, 188 => 0x0, 189 => [0x18,0x107,0x113], 190 => 0x49c2, 238 => 0xac, 321 => 0x604, 324 => 0x1600, 344 => 0x1a, 436 => 0x12, 437 => 0x11, 444 => 0xb026 },
	'imagestabilization2' => { 435 => 0xa },
	'imagestabilizationsetting' => { 190 => 0x14, 431 => 0x3d, 432 => 0x3d, 442 => 0x14 },
	'imagestats' => { 122 => 0xcd46 },
	'imagestyle' => { 431 => 0x2d, 432 => 0x27 },
	'imagesupplier' => { 331 => 'ImageSupplier' },
	'imagesupplierid' => { 331 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 331 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 331 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 124 => 0x1 },
	'imagetemperaturemin' => { 124 => 0x2 },
	'imagetone' => { 379 => 0x4f },
	'imagetype' => { 134 => 0x82, 331 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 66 => 0x28, 122 => 0xa420, 510 => 'ImageUniqueID', 511 => 'ImageUniqueID' },
	'imagewidth' => { 122 => 0x100, 191 => 0xe, 388 => 0x10c, 490 => 'ImageWidth', 530 => 'ImageWidth' },
	'inclinationangle' => { 481 => 0x900f },
	'inclinationcorrection' => { 481 => 0x900e },
	'incrementaltemperature' => { 505 => 'IncrementalTemperature', 507 => 'IncrementalTemperature' },
	'incrementaltint' => { 505 => 'IncrementalTint', 507 => 'IncrementalTint' },
	'industry' => { 524 => 'industry', 525 => 'industry' },
	'infobuttonwhenshooting' => { 87 => 0x409 },
	'information' => { 398 => 'information', 404 => "\xa9inf" },
	'infourl' => { 404 => 'infu' },
	'infraredilluminator' => { 405 => 0x28 },
	'ingredientexclusion' => { 526 => 'ingredientExclusion' },
	'ingredients' => { 535 => 'Ingredients' },
	'ingredientsalternatepaths' => { 535 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 535 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 535 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 535 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 535 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 535 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 535 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 535 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 535 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 535 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 535 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 535 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 535 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 535 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 535 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 535 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 535 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 535 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 535 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 535 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 535 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 535 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 535 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 87 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 493 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 493 => 'InitialHorizontalFOVDegrees' },
	'initialkey' => { 182 => 'WM/InitialKey' },
	'initialverticalfovdegrees' => { 493 => 'InitialVerticalFOVDegrees' },
	'initialviewheadingdegrees' => { 493 => 'InitialViewHeadingDegrees', 494 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 493 => 'InitialViewPitchDegrees', 494 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 493 => 'InitialViewRollDegrees', 494 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 301 => '4.4' },
	'initialzoomsetting' => { 301 => '9.3', 310 => '27.3' },
	'inkset' => { 122 => 0x14c },
	'inputprofile' => { 141 => 0x1389 },
	'instanceid' => { 535 => 'InstanceID' },
	'instantplaybacksetup' => { 187 => 0x3e },
	'instantplaybacktime' => { 187 => 0x3d },
	'instructions' => { 522 => 'Instructions' },
	'instrument' => { 534 => 'instrument' },
	'integrationtime' => { 141 => 0x423 },
	'intellectualgenre' => { 518 => 'IntellectualGenre' },
	'intelligentauto' => { 444 => 0xb052, 472 => 0xd, 473 => 0xe, 474 => 0xd },
	'intelligentcontrast' => { 54 => 0x4 },
	'intelligentd-range' => { 344 => 0x79 },
	'intelligentexposure' => { 344 => 0x5d },
	'intelligentresolution' => { 344 => 0x70 },
	'interchangecolorspace' => { 136 => 0x40 },
	'intergraphmatrix' => { 122 => 0x8480 },
	'internalflash' => { 184 => 0x2b, 301 => '23.1', 303 => '8.1', 306 => '22.1', 308 => '23.1', 312 => '8.1', 316 => '24.1', 324 => 0x1208 },
	'internalflashae1' => { 326 => 0x1021 },
	'internalflashae1_0' => { 326 => 0x101d },
	'internalflashae2' => { 326 => 0x1022 },
	'internalflashae2_0' => { 326 => 0x101e },
	'internalflashmode' => { 367 => 0x1 },
	'internalflashstrength' => { 367 => 0x3 },
	'internalflashtable' => { 326 => 0x1024 },
	'internallensserialnumber' => { 418 => 0xa005 },
	'internalndfilter' => { 344 => 0x9d },
	'internalserialnumber' => { 66 => 0x96, 78 => 0x9, 130 => 0x10, 190 => 0x49dc, 320 => 0x18, 322 => 0x102, 341 => 0x500, 344 => 0x25, 359 => 0x4, 411 => 0x5, 463 => [0x7c,0xf0], 464 => 0x88, 465 => [0x88,0x8a], 466 => 0x38 },
	'interopindex' => { 122 => 0x1, 512 => 'InteroperabilityIndex' },
	'interopversion' => { 122 => 0x2 },
	'interval' => { 260 => 0x20 },
	'intervaldurationhours' => { 242 => 0xa0, 243 => 0xb8 },
	'intervaldurationminutes' => { 242 => 0xa4, 243 => 0xbc },
	'intervaldurationseconds' => { 242 => 0xa8, 243 => 0xc0 },
	'intervalexposuresmoothing' => { 227 => 0x184, 242 => 0xb8, 243 => 0xd0 },
	'intervalframe' => { 260 => 0x24 },
	'intervallength' => { 184 => 0x10 },
	'intervalmode' => { 184 => 0x26 },
	'intervalnumber' => { 184 => 0x11 },
	'intervalpriority' => { 227 => 0x186, 242 => 0xba, 243 => 0xd2 },
	'intervals' => { 227 => 0x17c, 242 => 0xb0, 243 => 0xc8, 244 => 0xbc, 245 => 0xcc, 246 => 0xcc },
	'intervalshooting' => { 228 => 0x24, 262 => 0x24, 263 => 0x28, 379 => 0x92 },
	'introtime' => { 534 => 'introTime' },
	'introtimescale' => { 534 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 534 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 141 => 0xdae },
	'ipfcameramodel' => { 141 => 0xe4d },
	'iptc' => { 123 => 'IPTC' },
	'iptc-naa' => { 122 => 0x83bb, 349 => 0x83bb },
	'iptcbitspersample' => { 136 => 0x56 },
	'iptcdigest' => { 393 => 0x425 },
	'iptcimageheight' => { 136 => 0x1e },
	'iptcimagerotation' => { 136 => 0x66 },
	'iptcimagewidth' => { 136 => 0x14 },
	'iptclastedited' => { 519 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 136 => 0xa },
	'iptcpixelheight' => { 136 => 0x32 },
	'iptcpixelwidth' => { 136 => 0x28 },
	'isalternativeof' => { 524 => 'isAlternativeOf' },
	'isbn' => { 524 => 'isbn' },
	'iscorrectionof' => { 524 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 112 => 0x3 },
	'ismergedhdr' => { 502 => 'IsMergedHDR' },
	'ismergedpanorama' => { 502 => 'IsMergedPanorama' },
	'iso' => { 7 => 0x6, 9 => 0x6, 10 => 0x75, 11 => 0x6, 12 => 0x79, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x6, 31 => 0x0, 32 => 0x1, 115 => 0x14, 116 => [0x3014,0x14], 122 => 0x8827, 140 => 0xfd06, 141 => 0x1784, 143 => 0x60, 145 => [0xfa2e,0xfa46], 146 => [0x27,0x28], 147 => 0xf105, 150 => 0x14, 152 => 0x4e, 154 => 0x1e, 155 => 0x1a, 157 => 0x34, 159 => 'ISO', 184 => 0x8, 190 => 0x49ba, 226 => 0x0, 238 => 0x2, 344 => 0xd1, 349 => 0x17, 379 => [0x8b,0x14], 386 => 0x14, 388 => 0x105, 418 => 0xa014, 421 => 0x86, 442 => 0x6f, 449 => [0x1f,0x21,0x25], 511 => 'ISOSpeedRatings' },
	'iso2' => { 226 => 0x6, 267 => 0x265, 268 => 0x25c, 269 => 0x265, 270 => 0x221, 271 => 0x25d, 272 => 0x256, 273 => 0x25d, 276 => 0x2b5, 279 => 0x265, 283 => 0x2b5 },
	'isoauto' => { 360 => '14.4' },
	'isoautoflashlimit' => { 243 => 0x156, 244 => 0x146, 245 => 0x15a, 246 => 0x15a },
	'isoautohilimit' => { 225 => 0x5, 243 => 0x154, 244 => 0x144, 245 => 0x158, 246 => 0x158, 265 => 0x5, 275 => 0x18eb },
	'isoautomax' => { 443 => 0x4 },
	'isoautomin' => { 443 => 0x2 },
	'isoautoparameters' => { 379 => 0x7a },
	'isoautoshuttertime' => { 225 => 0x4, 243 => 0x15e, 244 => 0x14e, 245 => 0x162, 246 => 0x162, 265 => 0x4, 275 => 0x18ea },
	'isobutton' => { 246 => 0x796 },
	'isocalibrationgain' => { 141 => 0x89f },
	'isodisplay' => { 304 => '4.1', 305 => '4.1', 306 => '2.3', 307 => '3.3', 308 => '3.3', 311 => '3.3', 314 => '4.3', 315 => '4.1', 316 => '4.3' },
	'isoexpansion' => { 87 => 0x103, 88 => 0x7, 89 => 0x8, 92 => 0x8, 226 => 0x4 },
	'isoexpansion2' => { 226 => 0xa },
	'isofloor' => { 360 => 0x6 },
	'isoselected' => { 343 => 0x359 },
	'isoselection' => { 238 => 0xf },
	'isosensitivitystep' => { 309 => '6.2', 311 => '6.2' },
	'isosetting' => { 143 => 0x5e, 155 => 0x14, 159 => 'ISOSetting', 184 => 0x24, 185 => 0x26, 186 => 0x1c, 187 => 0x13, 192 => 0x6, 238 => 0x13, 360 => '17.3', 410 => 0x27, 431 => 0x16, 432 => 0x14, 433 => 0x2, 442 => 0x6d, 443 => 0x0 },
	'isospeed' => { 122 => 0x8833, 512 => 'ISOSpeed' },
	'isospeedexpansion' => { 86 => 0x3 },
	'isospeedincrements' => { 87 => 0x102 },
	'isospeedlatitudeyyy' => { 122 => 0x8834, 512 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 122 => 0x8835, 512 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 87 => 0x103 },
	'isostepsize' => { 301 => '6.1', 302 => '7.2', 304 => '7.2', 305 => '7.2', 310 => '4.1', 314 => '7.2', 315 => '7.2', 317 => 0x15d, 318 => 0x15d, 319 => 0x175 },
	'isovalue' => { 326 => 0x1001 },
	'isrc' => { 396 => 'xid ' },
	'isrccode' => { 404 => "\xa9isr" },
	'issn' => { 524 => 'issn' },
	'issueidentifier' => { 524 => 'issueIdentifier' },
	'issuename' => { 524 => 'issueName' },
	'issueteaser' => { 524 => 'issueTeaser' },
	'issuetype' => { 524 => 'issueType' },
	'istranslationof' => { 524 => 'isTranslationOf' },
	'itemsubtype' => { 181 => 'ItemSubType' },
	'itunesu' => { 396 => 'itnu' },
	'jobid' => { 134 => 0xb8 },
	'jobname' => { 513 => 'JobName' },
	'jobref' => { 533 => 'JobRef' },
	'jobrefid' => { 533 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 533 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 533 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 513 => 'JobStatus' },
	'jpeg-heifswitch' => { 444 => 0x2039 },
	'jpeghandling' => { 505 => 'JPEGHandling', 507 => 'JPEGHandling' },
	'jpegquality' => { 10 => 0x66, 344 => 0x43, 346 => 0x3034, 444 => 0xb047 },
	'jpegsize' => { 346 => 0x303a },
	'jpgcompression' => { 229 => 0x24, 238 => 0x44, 270 => '671.1' },
	'jpgfromraw' => { 100 => 0x2007, 117 => 'Exif-JpgFromRaw', 349 => 0x2e },
	'jpgfromrawlength' => { 122 => [0x117,0x202] },
	'jpgfromrawstart' => { 122 => [0x111,0x201] },
	'jpgrecordedpixels' => { 360 => '14.1' },
	'jurisdiction' => { 503 => 'jurisdiction' },
	'keepexposure' => { 317 => 0x237, 318 => 0x237, 319 => 0x24f },
	'kelvinwb_01' => { 368 => 0x5 },
	'kelvinwb_02' => { 368 => 0x9 },
	'kelvinwb_03' => { 368 => 0xd },
	'kelvinwb_04' => { 368 => 0x11 },
	'kelvinwb_05' => { 368 => 0x15 },
	'kelvinwb_06' => { 368 => 0x19 },
	'kelvinwb_07' => { 368 => 0x1d },
	'kelvinwb_08' => { 368 => 0x21 },
	'kelvinwb_09' => { 368 => 0x25 },
	'kelvinwb_10' => { 368 => 0x29 },
	'kelvinwb_11' => { 368 => 0x2d },
	'kelvinwb_12' => { 368 => 0x31 },
	'kelvinwb_13' => { 368 => 0x35 },
	'kelvinwb_14' => { 368 => 0x39 },
	'kelvinwb_15' => { 368 => 0x3d },
	'kelvinwb_16' => { 368 => 0x41 },
	'kelvinwb_daylight' => { 368 => 0x1 },
	'kerneldenominators' => { 141 => 0x933 },
	'key' => { 534 => 'key' },
	'keystonecompensation' => { 325 => 0x1900 },
	'keystonedirection' => { 325 => 0x1901 },
	'keystonevalue' => { 325 => 0x1906 },
	'keyword' => { 396 => 'keyw', 524 => 'keyword' },
	'keywordinfo' => { 174 => 'Keywords' },
	'keywords' => { 134 => 0x19, 160 => 'Keywords', 330 => 'Keywords', 395 => 'Keywords', 398 => 'keywords', 500 => 'keywords', 521 => 'Keywords', 532 => 'Keywords' },
	'killdate' => { 524 => 'killDate' },
	'killdatea-platform' => { 524 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 524 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 140 => 0xf908, 143 => 0xe, 145 => [0xfa1e,0xfa52], 151 => 0x70 },
	'kodakimagewidth' => { 140 => 0xf907, 143 => 0xc, 145 => [0xfa1d,0xfa51], 151 => 0x6c },
	'kodakinfotype' => { 140 => 0xfa00 },
	'kodaklook' => { 141 => 0xe4c },
	'kodaklookprofile' => { 141 => 0x138a },
	'kodakmaker' => { 151 => 0x8 },
	'kodakmodel' => { 143 => 0x0, 151 => 0x28 },
	'kodaktag' => { 141 => 0x3ea },
	'kodakversion' => { 141 => 0x0 },
	'label' => { 334 => 'Label', 532 => 'Label' },
	'labelname1' => { 517 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 517 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 517 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 517 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 517 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 517 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 344 => 0x6f },
	'landscapeoutputhighlightpoint' => { 112 => 0x26 },
	'landscapeoutputshadowpoint' => { 112 => 0x27 },
	'landscaperawcolortone' => { 112 => 0x1f },
	'landscaperawcontrast' => { 112 => 0x21 },
	'landscaperawhighlight' => { 112 => 0x77 },
	'landscaperawhighlightpoint' => { 112 => 0x24 },
	'landscaperawlinear' => { 112 => 0x22 },
	'landscaperawsaturation' => { 112 => 0x20 },
	'landscaperawshadow' => { 112 => 0x80 },
	'landscaperawshadowpoint' => { 112 => 0x25 },
	'landscaperawsharpness' => { 112 => 0x23 },
	'landscapeunsharpmaskfineness' => { 112 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 112 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 112 => 0xa2 },
	'language' => { 243 => 0x692, 244 => 0x592, 245 => 0x5c2, 246 => 0x5da, 508 => 'language' },
	'languageidentifier' => { 134 => 0x87 },
	'largestvalidinteriorrectheight' => { 493 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 493 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 493 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 493 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 184 => 0x1b },
	'lastkeywordiptc' => { 181 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 181 => 'LastKeywordXMP' },
	'lastphotodate' => { 493 => 'LastPhotoDate' },
	'lasturl' => { 535 => 'LastURL' },
	'lateralchromaticaberration' => { 444 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 502 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 121 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 121 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 121 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 121 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 121 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 119 => 'Latitude' },
	'lc1' => { 370 => 0x2 },
	'lc10' => { 370 => 0xb },
	'lc11' => { 370 => 0xc },
	'lc12' => { 370 => 0xd },
	'lc14' => { 370 => 0xf },
	'lc15' => { 370 => 0x10 },
	'lc3' => { 370 => 0x4 },
	'lc4' => { 370 => 0x5 },
	'lc5' => { 370 => 0x6 },
	'lc6' => { 370 => 0x7 },
	'lc7' => { 370 => 0x8 },
	'lc8' => { 370 => 0x9 },
	'lcddisplayatpoweron' => { 87 => 0x811, 91 => 0xa },
	'lcddisplayreturntoshoot' => { 92 => 0x12 },
	'lcdillumination' => { 301 => '17.5', 302 => '5.2', 304 => '5.1', 305 => '5.1', 310 => '10.3', 311 => '4.2', 314 => '5.2', 315 => '5.1', 316 => '5.4', 317 => 0x101, 318 => 0x101, 319 => 0x117 },
	'lcdilluminationduringbulb' => { 87 => 0x408 },
	'lcdmatrix' => { 141 => 0xe74 },
	'lcdmatrixchickfix' => { 141 => 0xe75 },
	'lcdmatrixmarvin' => { 141 => 0xe76 },
	'lcdpanels' => { 86 => 0x8 },
	'lcheditor' => { 294 => 0x8ae85e },
	'legacyiptcdigest' => { 522 => 'LegacyIPTCDigest' },
	'legalcode' => { 503 => 'legalcode' },
	'lens' => { 122 => 0xfdea, 238 => 0x84, 502 => 'Lens' },
	'lensafstopbutton' => { 85 => 0x11, 86 => 0x13, 87 => 0x506, 88 => 0x10, 89 => 0x12, 92 => 0x13, 93 => 0x9 },
	'lensaperturerange' => { 421 => [0x30,0x48] },
	'lensblur' => { 505 => 'LensBlur', 507 => 'LensBlur' },
	'lensbluractive' => { 505 => [\'LensBlur','LensBlurActive'], 507 => [\'LensBlur','LensBlurActive'] },
	'lensbluramount' => { 505 => [\'LensBlur','LensBlurBlurAmount'], 507 => [\'LensBlur','LensBlurBlurAmount'] },
	'lensblurbokehaspect' => { 505 => [\'LensBlur','LensBlurBokehAspect'], 507 => [\'LensBlur','LensBlurBokehAspect'] },
	'lensblurbokehrotation' => { 505 => [\'LensBlur','LensBlurBokehRotation'], 507 => [\'LensBlur','LensBlurBokehRotation'] },
	'lensblurbokehshape' => { 505 => [\'LensBlur','LensBlurBokehShape'], 507 => [\'LensBlur','LensBlurBokehShape'] },
	'lensblurbokehshapedetail' => { 505 => [\'LensBlur','LensBlurBokehShapeDetail'], 507 => [\'LensBlur','LensBlurBokehShapeDetail'] },
	'lensblurcateyeamount' => { 505 => [\'LensBlur','LensBlurCatEyeAmount'], 507 => [\'LensBlur','LensBlurCatEyeAmount'] },
	'lensblurcateyescale' => { 505 => [\'LensBlur','LensBlurCatEyeScale'], 507 => [\'LensBlur','LensBlurCatEyeScale'] },
	'lensblurfocalrange' => { 505 => [\'LensBlur','LensBlurFocalRange'], 507 => [\'LensBlur','LensBlurFocalRange'] },
	'lensblurfocalrangesource' => { 505 => [\'LensBlur','LensBlurFocalRangeSource'], 507 => [\'LensBlur','LensBlurFocalRangeSource'] },
	'lensblurhighlightsboost' => { 505 => [\'LensBlur','LensBlurHighlightsBoost'], 507 => [\'LensBlur','LensBlurHighlightsBoost'] },
	'lensblurhighlightsthreshold' => { 505 => [\'LensBlur','LensBlurHighlightsThreshold'], 507 => [\'LensBlur','LensBlurHighlightsThreshold'] },
	'lensblursampledarea' => { 505 => [\'LensBlur','LensBlurSampledArea'], 507 => [\'LensBlur','LensBlurSampledArea'] },
	'lensblursampledrange' => { 505 => [\'LensBlur','LensBlurSampledRange'], 507 => [\'LensBlur','LensBlurSampledRange'] },
	'lensblursphericalaberration' => { 505 => [\'LensBlur','LensBlurSphericalAberration'], 507 => [\'LensBlur','LensBlurSphericalAberration'] },
	'lensblursubjectrange' => { 505 => [\'LensBlur','LensBlurSubjectRange'], 507 => [\'LensBlur','LensBlurSubjectRange'] },
	'lensblurversion' => { 505 => [\'LensBlur','LensBlurVersion'], 507 => [\'LensBlur','LensBlurVersion'] },
	'lenscontrolring' => { 317 => 0xad, 318 => 0xad, 319 => 0xad },
	'lenscorrectionsettings' => { 510 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 502 => 'LensDistortInfo' },
	'lensdistortionparams' => { 326 => 0x206 },
	'lensdriveend' => { 236 => 0x56 },
	'lensdrivenoaf' => { 87 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 433 => 0x3f0, 480 => 0xd },
	'lensfirmware' => { 412 => 0x20, 418 => 0xa004 },
	'lensfirmwareversion' => { 322 => 0x204, 344 => 0x60, 433 => 0x3f3, 480 => 0x14 },
	'lensfocallength' => { 106 => 0xf0512, 370 => 0x9 },
	'lensfocalrange' => { 421 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 302 => '55.1', 304 => '52.1', 305 => '52.1', 314 => '52.1', 315 => '52.1' },
	'lensformat' => { 457 => 0x1891, 459 => 0x18bd, 460 => 0x18ed, 461 => 0x17f1, 463 => 0x106, 464 => 0x106, 475 => 0x603, 476 => 0x5d },
	'lensfstops' => { 230 => 0x7, 231 => 0xc, 232 => 0xd, 236 => 0xe, 238 => 0x8b, 370 => '0.3' },
	'lensfunc1button' => { 317 => 0x9f, 318 => 0x9f, 319 => 0x9f },
	'lensfunc1buttonplaybackmode' => { 246 => 0x810 },
	'lensfunc2button' => { 317 => 0xa7, 318 => 0xa7, 319 => 0xa7 },
	'lensfunc2buttonplaybackmode' => { 246 => 0x812 },
	'lensid' => { 236 => 0x30, 502 => 'LensID' },
	'lensidnumber' => { 230 => 0x6, 231 => 0xb, 232 => 0xc, 236 => 0xd },
	'lensinfo' => { 122 => 0xa432, 376 => 0x2a, 502 => 'LensInfo', 512 => 'LensSpecification' },
	'lenskind' => { 370 => 0x1 },
	'lensmake' => { 122 => 0xa433, 166 => 'Make', 512 => 'LensMake' },
	'lensmanualdistortionamount' => { 505 => 'LensManualDistortionAmount', 507 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 181 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 421 => 0x2b },
	'lensmodel' => { 7 => 0x937, 14 => 0x92b, 15 => 0x933, 66 => 0x95, 122 => 0xa434, 166 => 'Model', 181 => 'LensModel', 233 => 0x18a, 234 => 0x18b, 235 => 0x2ac, 322 => 0x203, 376 => 0xc, 388 => 0x412, 512 => 'LensModel' },
	'lensmodulationoptimizer' => { 130 => 0x1045 },
	'lensmount' => { 433 => 0x99, 457 => 0x1892, 459 => 0x18be, 460 => 0x18ee, 461 => 0x17f2, 463 => 0x105, 464 => 0x105, 475 => 0x604, 476 => 0x5e },
	'lensmount2' => { 480 => 0x8 },
	'lensmounttype' => { 236 => 0x35 },
	'lenspositionabsolute' => { 236 => 0x5a },
	'lensprofilechromaticaberrationscale' => { 505 => 'LensProfileChromaticAberrationScale', 507 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 505 => 'LensProfileDigest', 507 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 505 => 'LensProfileDistortionScale', 507 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 505 => 'LensProfileEnable', 507 => 'LensProfileEnable' },
	'lensprofilefilename' => { 505 => 'LensProfileFilename', 507 => 'LensProfileFilename' },
	'lensprofileisembedded' => { 505 => 'LensProfileIsEmbedded', 507 => 'LensProfileIsEmbedded' },
	'lensprofilematchkeycameramodelname' => { 505 => 'LensProfileMatchKeyCameraModelName', 507 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 505 => 'LensProfileMatchKeyExifMake', 507 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 505 => 'LensProfileMatchKeyExifModel', 507 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 505 => 'LensProfileMatchKeyIsRaw', 507 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 505 => 'LensProfileMatchKeyLensID', 507 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 505 => 'LensProfileMatchKeyLensInfo', 507 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 505 => 'LensProfileMatchKeyLensName', 507 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 505 => 'LensProfileMatchKeySensorFormatFactor', 507 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 505 => 'LensProfileName', 507 => 'LensProfileName' },
	'lensprofilesetup' => { 505 => 'LensProfileSetup', 507 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 505 => 'LensProfileVignettingScale', 507 => 'LensProfileVignettingScale' },
	'lensproperties' => { 322 => 0x20b },
	'lensserialnumber' => { 21 => 0x164, 34 => 0x16b, 63 => 0x0, 122 => 0xa435, 166 => 'SerialNumber', 322 => 0x202, 342 => 0x321, 344 => 0x52, 404 => 'LENS', 412 => 0x30, 502 => 'LensSerialNumber', 512 => 'LensSerialNumber' },
	'lensshutterlock' => { 187 => 0x4a },
	'lensspec' => { 428 => 0x0, 429 => 0x0, 430 => 0x0, 444 => 0xb02a },
	'lensspecfeatures' => { 463 => [0x115,0x116], 464 => [0x116,0x1ed,0x1f0,0x21c,0x21e] },
	'lenstemperature' => { 326 => 0x1008 },
	'lenstype' => { 7 => 0xe2, 8 => 0xd, 9 => 0x1a7, 10 => 0xc, 11 => 0x111, 12 => 0xc, 13 => 0x14f, 14 => 0xd6, 15 => 0xde, 16 => 0xf6, 17 => 0xea, 18 => 0xff, 19 => [0xc,0x97], 20 => 0xe6, 21 => 0x153, 22 => 0xea, 23 => 0xe8, 24 => 0x127, 25 => 0x161, 26 => 0x166, 27 => 0x184, 28 => 0x112, 29 => 0x189, 36 => 0x16, 189 => 0x10c, 190 => 0x49bd, 238 => 0x83, 322 => 0x201, 335 => 0x16, 339 => 0x310, 341 => 0x303, 342 => 0x303, 344 => 0x51, 346 => 0x3405, 371 => 0x0, 372 => 0x0, 373 => 0x1, 374 => 0x1, 375 => 0x1, 377 => 0x0, 418 => 0xa003, 421 => 0x27, 444 => 0xb027, 457 => 0x1896, 459 => 0x18c2, 460 => 0x18f2, 461 => 0x17f6, 463 => 0x109, 464 => 0x109, 475 => 0x608, 476 => 0x62 },
	'lenstype2' => { 433 => 0x3f7, 457 => 0x1893, 459 => 0x18bf, 460 => 0x18ef, 461 => 0x17f3, 463 => 0x107, 464 => 0x107, 475 => 0x605, 476 => 0x60 },
	'lenstype3' => { 480 => 0x9 },
	'lenstypemake' => { 344 => 0xc4 },
	'lenstypemodel' => { 344 => [0xc5,0xe4] },
	'lenszoomposition' => { 472 => 0x19, 473 => 0x1e, 476 => [0x342,0x34e,0x35a] },
	'levelindicator' => { 352 => 0x15 },
	'levelmeter' => { 404 => ['Lvlm','lvlm'] },
	'levelorientation' => { 378 => 0x0 },
	'license' => { 503 => 'license' },
	'licensee' => { 331 => 'Licensee' },
	'licenseeid' => { 331 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 331 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 331 => 'LicenseeImageNotes' },
	'licenseename' => { 331 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 331 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 331 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 331 => 'LicenseeTransactionID' },
	'licenseid' => { 331 => 'LicenseID' },
	'licensestartdate' => { 331 => 'LicenseStartDate' },
	'licensetransactiondate' => { 331 => 'LicenseTransactionDate' },
	'licensetype' => { 509 => 'licensetype' },
	'licensor' => { 331 => 'Licensor' },
	'licensorcity' => { 331 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 331 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 331 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 331 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 331 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 331 => 'LicensorImageID' },
	'licensorname' => { 331 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 331 => 'LicensorNotes' },
	'licensorpostalcode' => { 331 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 331 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 331 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 331 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 331 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 331 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 331 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 331 => 'LicensorTransactionID' },
	'licensorurl' => { 331 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 326 => 0x1009 },
	'lightingmode' => { 116 => 0x302a },
	'lightreading' => { 379 => 0x15 },
	'lightsource' => { 122 => 0x9208, 238 => 0x90, 329 => 0x1000, 511 => 'LightSource' },
	'lightsourcespecial' => { 420 => 0x21d },
	'lightswitch' => { 314 => '0.1', 316 => '0.1' },
	'lightvaluecenter' => { 326 => 0x103d },
	'lightvalueperiphery' => { 326 => 0x103e },
	'limitaf-areamodesel3dtracking' => { 317 => 0x153, 318 => 0x153, 319 => 0x16b },
	'limitaf-areamodeseldynamic_l' => { 317 => 0x151, 318 => 0x151, 319 => 0x169 },
	'limitaf-areamodeseldynamic_m' => { 317 => 0x150, 318 => 0x150, 319 => 0x168 },
	'limitaf-areamodeseldynamic_s' => { 317 => 0x14f, 318 => 0x14f, 319 => 0x167 },
	'limitaf-areamodeselpinpoint' => { 317 => 0x11, 318 => 0x11, 319 => 0x11 },
	'limitaf-areamodeselwideaf_l' => { 317 => 0x14, 318 => 0x14, 319 => 0x14 },
	'limitaf-areamodeselwideaf_s' => { 317 => 0x13, 318 => 0x13, 319 => 0x13 },
	'limitafareamodeselauto' => { 317 => 0x15, 318 => 0x15, 319 => 0x15 },
	'limitafareamodeselection' => { 302 => '51.1', 304 => '49.1', 305 => '49.1', 314 => '49.1', 315 => '49.1' },
	'limitreleasemodeselc120' => { 318 => '269.4', 319 => '293.4' },
	'limitreleasemodeselc30' => { 318 => '269.3', 319 => '293.3' },
	'limitreleasemodeselch' => { 318 => '269.2', 319 => '293.2' },
	'limitreleasemodeselcl' => { 318 => '269.1', 319 => '293.1' },
	'limitreleasemodeselself' => { 318 => '269.5', 319 => '293.5' },
	'limitselectableimagearea16to9' => { 317 => 0x47, 318 => 0x47, 319 => 0x47 },
	'limitselectableimagearea1to1' => { 317 => 0x46, 318 => 0x46, 319 => 0x46 },
	'limitselectableimageareadx' => { 317 => 0x45, 318 => 0x45, 319 => 0x45 },
	'linearitylimitblue' => { 349 => 0x10 },
	'linearitylimitgreen' => { 349 => 0xf },
	'linearitylimitred' => { 349 => 0xe },
	'linearityuppermargin' => { 43 => 0x32c, 44 => 0x282, 47 => [0x2ba,0x2d1,0x2d5], 49 => 0x1e5, 50 => [0x1fe,0x2de], 51 => [0x232,0x310], 52 => 0x31e },
	'linearizationtable' => { 122 => 0xc618 },
	'linearresponselimit' => { 122 => 0xc62e },
	'link' => { 524 => 'link' },
	'linkaetoafpoint' => { 360 => '14.2' },
	'linkedencodedrightsexpr' => { 519 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 519 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 519 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 519 => 'LinkedEncRightsExpr' },
	'linlogcoring' => { 141 => 0x904 },
	'lithostratigraphicterms' => { 121 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'livephotoauto' => { 398 => 'live-photo.auto' },
	'livephotovideoindex' => { 1 => 0x17 },
	'livephotovitalityscore' => { 398 => 'live-photo.vitality-score' },
	'livephotovitalityscoringversion' => { 398 => 'live-photo.vitality-scoring-version' },
	'liveviewaf' => { 306 => '32.1', 316 => '34.1' },
	'liveviewafareamode' => { 311 => '34.1' },
	'liveviewafmethod' => { 449 => 0x20 },
	'liveviewafmode' => { 311 => '34.2' },
	'liveviewafsetting' => { 433 => 0x36 },
	'liveviewbuttonoptions' => { 302 => '50.2', 304 => '48.2', 305 => '48.2', 314 => '48.2', 315 => '48.2' },
	'liveviewexposuresimulation' => { 87 => 0x810 },
	'liveviewfocusmode' => { 433 => [0x8b,0x28b] },
	'liveviewmetering' => { 433 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 302 => '21.2', 304 => '21.2', 305 => '21.2', 307 => '20.2', 308 => '20.2', 309 => '20.2', 311 => '20.2', 314 => '21.2', 315 => '21.2' },
	'liveviewshooting' => { 59 => 0x13 },
	'livingspecimen' => { 121 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 121 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 134 => 0x79 },
	'localizedcameramodel' => { 122 => 0xc615 },
	'locallocationname' => { 418 => 0x30 },
	'location' => { 237 => 0x9, 344 => 0x67, 498 => 'Location', 518 => 'Location', 523 => 'location', 524 => 'location' },
	'locationaccuracyhorizontal' => { 398 => 'location.accuracy.horizontal' },
	'locationareacode' => { 504 => 'lac' },
	'locationbody' => { 398 => 'location.body' },
	'locationcreated' => { 519 => 'LocationCreated' },
	'locationcreatedcity' => { 519 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 519 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 519 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 519 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpslatitude' => { 519 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 519 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 519 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 519 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 519 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 519 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 519 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 519 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationdate' => { 398 => 'location.date' },
	'locationinformation' => { 404 => 'loci' },
	'locationinfoversion' => { 237 => 0x0 },
	'locationname' => { 398 => 'location.name', 418 => 0x31 },
	'locationnote' => { 398 => 'location.note' },
	'locationrole' => { 398 => 'location.role' },
	'locationshown' => { 519 => 'LocationShown' },
	'locationshowncity' => { 519 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 519 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 519 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 519 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpslatitude' => { 519 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 519 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 519 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 519 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 519 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 519 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 519 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 519 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 87 => 0x709 },
	'logcomment' => { 534 => 'logComment' },
	'logscale' => { 141 => 0x902 },
	'longdescription' => { 396 => 'ldes' },
	'longexposurenoisereduction' => { 64 => 0x4, 87 => 0x201, 88 => 0x1, 89 => 0x2, 90 => 0x1, 91 => 0x1, 92 => 0x2, 93 => 0x1, 344 => 0x49, 431 => 0x2b, 432 => 0x25, 433 => 0x25, 444 => 0x2008, 449 => 0x11, 476 => 0x44 },
	'longexposurenoisereduction2' => { 59 => 0x8 },
	'longexposurenrused' => { 344 => 0xbe },
	'longitude' => { 119 => 'Longitude' },
	'look' => { 505 => 'Look', 507 => 'Look' },
	'lookamount' => { 505 => [\'Look','LookAmount'], 507 => [\'Look','LookAmount'] },
	'lookcluster' => { 505 => [\'Look','LookCluster'], 507 => [\'Look','LookCluster'] },
	'lookcopyright' => { 505 => [\'Look','LookCopyright'], 507 => [\'Look','LookCopyright'] },
	'lookgroup' => { 505 => [\'Look','LookGroup'], 507 => [\'Look','LookGroup'] },
	'lookname' => { 505 => 'LookName', 507 => 'LookName' },
	'lookparameters' => { 505 => [\'Look','LookParameters'], 507 => [\'Look','LookParameters'] },
	'lookparameterscameraprofile' => { 505 => [\'Look','LookParametersCameraProfile'], 507 => [\'Look','LookParametersCameraProfile'] },
	'lookparametersclarity2012' => { 505 => [\'Look','LookParametersClarity2012'], 507 => [\'Look','LookParametersClarity2012'] },
	'lookparametersconverttograyscale' => { 505 => [\'Look','LookParametersConvertToGrayscale'], 507 => [\'Look','LookParametersConvertToGrayscale'] },
	'lookparametershighlights2012' => { 505 => [\'Look','LookParametersHighlights2012'], 507 => [\'Look','LookParametersHighlights2012'] },
	'lookparameterslooktable' => { 505 => [\'Look','LookParametersLookTable'], 507 => [\'Look','LookParametersLookTable'] },
	'lookparametersprocessversion' => { 505 => [\'Look','LookParametersProcessVersion'], 507 => [\'Look','LookParametersProcessVersion'] },
	'lookparametersshadows2012' => { 505 => [\'Look','LookParametersShadows2012'], 507 => [\'Look','LookParametersShadows2012'] },
	'lookparameterstonecurvepv2012' => { 505 => [\'Look','LookParametersToneCurvePV2012'], 507 => [\'Look','LookParametersToneCurvePV2012'] },
	'lookparameterstonecurvepv2012blue' => { 505 => [\'Look','LookParametersToneCurvePV2012Blue'], 507 => [\'Look','LookParametersToneCurvePV2012Blue'] },
	'lookparameterstonecurvepv2012green' => { 505 => [\'Look','LookParametersToneCurvePV2012Green'], 507 => [\'Look','LookParametersToneCurvePV2012Green'] },
	'lookparameterstonecurvepv2012red' => { 505 => [\'Look','LookParametersToneCurvePV2012Red'], 507 => [\'Look','LookParametersToneCurvePV2012Red'] },
	'lookparametersversion' => { 505 => [\'Look','LookParametersVersion'], 507 => [\'Look','LookParametersVersion'] },
	'looksupportsamount' => { 505 => [\'Look','LookSupportsAmount'], 507 => [\'Look','LookSupportsAmount'] },
	'looksupportsmonochrome' => { 505 => [\'Look','LookSupportsMonochrome'], 507 => [\'Look','LookSupportsMonochrome'] },
	'looksupportsoutputreferred' => { 505 => [\'Look','LookSupportsOutputReferred'], 507 => [\'Look','LookSupportsOutputReferred'] },
	'lookuuid' => { 505 => [\'Look','LookUUID'], 507 => [\'Look','LookUUID'] },
	'loop' => { 534 => 'loop' },
	'loopstyle' => { 404 => 'LOOP' },
	'lowestbiostratigraphiczone' => { 121 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 505 => 'LuminanceAdjustmentAqua', 507 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 505 => 'LuminanceAdjustmentBlue', 507 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 505 => 'LuminanceAdjustmentGreen', 507 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 505 => 'LuminanceAdjustmentMagenta', 507 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 505 => 'LuminanceAdjustmentOrange', 507 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 505 => 'LuminanceAdjustmentPurple', 507 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 505 => 'LuminanceAdjustmentRed', 507 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 505 => 'LuminanceAdjustmentYellow', 507 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 111 => 0x150 },
	'luminancecurvepoints' => { 111 => 0x126 },
	'luminancenoiseamplitude' => { 1 => 0x1d },
	'luminancenoisereduction' => { 106 => 0x20600, 112 => 0x5f, 421 => 0x1b },
	'luminancenoisereductioncontrast' => { 505 => 'LuminanceNoiseReductionContrast', 507 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 505 => 'LuminanceNoiseReductionDetail', 507 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 112 => 0x6d },
	'luminancesmoothing' => { 505 => 'LuminanceSmoothing', 507 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 87 => [0x40b,0x40c] },
	'lyrics' => { 396 => "\xa9lyr", 404 => "\xa9lyr", 534 => 'lyrics' },
	'lyricsuri' => { 404 => 'lrcu' },
	'm16cversion' => { 339 => 0x333 },
	'macatom' => { 506 => 'macAtom' },
	'macatomapplicationcode' => { 506 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 506 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 506 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 121 => 'MachineObservation' },
	'machineobservationday' => { 121 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 121 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 121 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 121 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 121 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 121 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 121 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationfieldnotes' => { 121 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 121 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 121 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 121 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 121 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 121 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 121 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 121 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 121 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 121 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 121 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 121 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 121 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 130 => 0x1020, 132 => 0x202, 154 => 0x2b, 326 => 0x202, 410 => 0x21, 420 => 0x202, 444 => 0xb040 },
	'macroled' => { 324 => 0x120a },
	'macromagnification' => { 7 => 0x1b, 11 => 0x1b, 14 => 0x1b, 15 => 0x1b, 19 => 0x1b, 20 => 0x1b, 59 => 0x10 },
	'macromode' => { 36 => 0x1, 184 => 0xb, 321 => 0x300, 344 => 0x1c, 411 => 0x1009 },
	'magentahsl' => { 106 => 0x20917 },
	'magicfilter' => { 321 => 0x52c },
	'magnifiedview' => { 89 => 0x11, 91 => 0x9 },
	'mainboardversion' => { 141 => 0x438 },
	'maindialexposurecomp' => { 312 => '0.6' },
	'mainingredient' => { 526 => 'mainIngredient' },
	'majorversion' => { 496 => 'MajorVersion' },
	'make' => { 101 => 0x0, 118 => 0x1, 122 => 0x10f, 159 => 'Make', 334 => 'Make', 349 => 0x10f, 398 => 'make', 404 => ['@mak',"\xa9mak"], 523 => 'make', 530 => 'Make' },
	'makernote' => { 511 => 'MakerNote' },
	'makernoteapple' => { 120 => 'MakN', 122 => 0x927c },
	'makernotecanon' => { 84 => 'CMT3', 120 => 'MakN', 122 => 0x927c },
	'makernotecasio' => { 120 => 'MakN', 122 => 0x927c },
	'makernotecasio2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotedji' => { 120 => 'MakN', 122 => 0x927c },
	'makernotedjiinfo' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteflir' => { 120 => 'MakN', 122 => 0x927c },
	'makernotefujifilm' => { 120 => 'MakN', 122 => 0x927c },
	'makernotege' => { 120 => 'MakN', 122 => 0x927c },
	'makernotege2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotehasselblad' => { 120 => 'MakN', 122 => 0x927c },
	'makernotehp' => { 120 => 'MakN', 122 => 0x927c },
	'makernotehp2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotehp4' => { 120 => 'MakN', 122 => 0x927c },
	'makernotehp6' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteisl' => { 120 => 'MakN', 122 => 0x927c },
	'makernotejvc' => { 120 => 'MakN', 122 => 0x927c },
	'makernotejvctext' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak10' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak11' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak12' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak1a' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak1b' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak3' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak4' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak5' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak6a' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak6b' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak7' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak8a' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak8b' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak8c' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodak9' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekodakunknown' => { 120 => 'MakN', 122 => 0x927c },
	'makernotekyocera' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica10' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica2' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica3' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica4' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica5' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica6' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica7' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica8' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteleica9' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteminolta' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteminolta2' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteminolta3' => { 120 => 'MakN', 122 => 0x927c },
	'makernotemotorola' => { 120 => 'MakN', 122 => 0x927c },
	'makernotenikon' => { 120 => 'MakN', 122 => 0x927c },
	'makernotenikon2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotenikon3' => { 120 => 'MakN', 122 => 0x927c },
	'makernotenintendo' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteoffset' => { 420 => 0xff },
	'makernoteolympus' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteolympus2' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteolympus3' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepanasonic' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepanasonic2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepanasonic3' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepentax' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepentax2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepentax3' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepentax4' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepentax5' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepentax6' => { 120 => 'MakN', 122 => 0x927c },
	'makernotepentaxunknown' => { 404 => 'PXMN' },
	'makernotephaseone' => { 120 => 'MakN', 122 => 0x927c },
	'makernotereconyx' => { 120 => 'MakN', 122 => 0x927c },
	'makernotereconyx2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotereconyx3' => { 120 => 'MakN', 122 => 0x927c },
	'makernotericoh' => { 120 => 'MakN', 122 => 0x927c },
	'makernotericoh2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotericohpentax' => { 120 => 'MakN', 122 => 0x927c },
	'makernotericohtext' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesafety' => { 122 => 0xc635 },
	'makernotesamsung1a' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesamsung1b' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesamsung2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesanyo' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesanyoc4' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesanyopatch' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesigma' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesony' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesony2' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesony3' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesony4' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesony5' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesonyericsson' => { 120 => 'MakN', 122 => 0x927c },
	'makernotesonysrf' => { 120 => 'MakN', 122 => 0x927c },
	'makernotetype' => { 411 => 0x1 },
	'makernoteunknown' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteunknownbinary' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteunknowntext' => { 120 => 'MakN', 122 => 0x927c },
	'makernoteversion' => { 1 => 0x1, 189 => 0x0, 238 => 0x1, 326 => 0x0, 344 => 0x8000, 415 => 0x0, 418 => 0x1, 421 => [0x1d,0x1f], 434 => 0x2000 },
	'makerurl' => { 404 => "\xa9mal" },
	'managedfrom' => { 535 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 535 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 535 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 535 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 535 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 535 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 535 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 535 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 535 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 535 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 535 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 535 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 535 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 535 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 535 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 535 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 535 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 535 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 535 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 535 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 535 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 535 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 535 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 535 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 535 => 'Manager' },
	'managervariant' => { 535 => 'ManagerVariant' },
	'manageto' => { 535 => 'ManageTo' },
	'manageui' => { 535 => 'ManageUI' },
	'manifest' => { 535 => 'Manifest' },
	'manifestlinkform' => { 535 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 535 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 535 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 535 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 535 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 535 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 535 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 535 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 535 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 535 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 535 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 535 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 535 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 535 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 535 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 535 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 535 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 535 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 535 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 535 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 535 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 535 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 535 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 535 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 535 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 535 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 535 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 535 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 321 => 0x900, 344 => 0x86 },
	'manometerreading' => { 321 => 0x901 },
	'manualafpointselectpattern' => { 87 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 324 => 0x1209 },
	'manualflashoutput' => { 36 => 0x29, 303 => '8.2', 306 => '22.2', 307 => '23.1', 308 => '23.2', 310 => '16.2', 311 => '23.2', 312 => '8.2', 313 => '23.2', 316 => '24.2', 411 => 0x100c },
	'manualflashstrength' => { 321 => 0x406 },
	'manualfocusdistance' => { 238 => 0x85, 326 => 0x100c, 420 => 0x223 },
	'manualfocuspointillumination' => { 317 => 0x17, 318 => 0x17, 319 => 0x17 },
	'manualfocusringinafmode' => { 317 => 0x1a, 318 => 0x1a, 319 => 0x1a },
	'manualtv' => { 86 => 0x5, 87 => 0x705 },
	'manufacturedate' => { 194 => 0x6705, 359 => 0x1 },
	'manufacturedate1' => { 413 => 0x4 },
	'manufacturedate2' => { 413 => 0x5 },
	'manufacturer' => { 490 => 'Manufacturer', 523 => 'manufacturer' },
	'mariahchromablursize' => { 141 => 0xf0d },
	'mariahmaphithreshold' => { 141 => 0xf0c },
	'mariahmaplothreshold' => { 141 => 0xf0b },
	'mariahsigmathreshold' => { 141 => 0xf0e },
	'mariahtexturethreshold' => { 141 => 0xf0a },
	'marked' => { 521 => 'Marked', 538 => 'Marked' },
	'markers' => { 534 => 'markers' },
	'markerscomment' => { 534 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 534 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 534 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 534 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 534 => [\'markers','markersCuePointType'] },
	'markersduration' => { 534 => [\'markers','markersDuration'] },
	'markerslocation' => { 534 => [\'markers','markersLocation'] },
	'markersname' => { 534 => [\'markers','markersName'] },
	'markersprobability' => { 534 => [\'markers','markersProbability'] },
	'markersspeaker' => { 534 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 534 => [\'markers','markersStartTime'] },
	'markerstarget' => { 534 => [\'markers','markersTarget'] },
	'markerstype' => { 534 => [\'markers','markersType'] },
	'maskedareas' => { 122 => 0xc68e },
	'maskgroupbasedcorractive' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'] },
	'maskgroupbasedcorramount' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'] },
	'maskgroupbasedcorrblacks2012' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'] },
	'maskgroupbasedcorrbrightness' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'] },
	'maskgroupbasedcorrclarity' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'] },
	'maskgroupbasedcorrclarity2012' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'] },
	'maskgroupbasedcorrcontrast' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'] },
	'maskgroupbasedcorrcontrast2012' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'] },
	'maskgroupbasedcorrcorrectionname' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'] },
	'maskgroupbasedcorrcorrectionsyncid' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'] },
	'maskgroupbasedcorrdefringe' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'] },
	'maskgroupbasedcorrdehaze' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'] },
	'maskgroupbasedcorrections' => { 505 => 'MaskGroupBasedCorrections', 507 => 'MaskGroupBasedCorrections' },
	'maskgroupbasedcorrexposure' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'] },
	'maskgroupbasedcorrexposure2012' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'] },
	'maskgroupbasedcorrhighlights2012' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'] },
	'maskgroupbasedcorrhue' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'] },
	'maskgroupbasedcorrluminancenoise' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'] },
	'maskgroupbasedcorrmask' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'] },
	'maskgroupbasedcorrmaskalpha' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'] },
	'maskgroupbasedcorrmaskangle' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'] },
	'maskgroupbasedcorrmaskbottom' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'] },
	'maskgroupbasedcorrmaskcentervalue' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'] },
	'maskgroupbasedcorrmaskcenterweight' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'] },
	'maskgroupbasedcorrmaskdabs' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'] },
	'maskgroupbasedcorrmaskfeather' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'] },
	'maskgroupbasedcorrmaskflipped' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'] },
	'maskgroupbasedcorrmaskflow' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'] },
	'maskgroupbasedcorrmaskfullx' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'] },
	'maskgroupbasedcorrmaskfully' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'] },
	'maskgroupbasedcorrmaskinputdigest' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'] },
	'maskgroupbasedcorrmaskleft' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'] },
	'maskgroupbasedcorrmaskmaskactive' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'] },
	'maskgroupbasedcorrmaskmaskblendmode' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmaskdigest' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmaskinverted' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmaskname' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'] },
	'maskgroupbasedcorrmaskmasks' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'] },
	'maskgroupbasedcorrmaskmasksalpha' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'maskgroupbasedcorrmaskmasksangle' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'] },
	'maskgroupbasedcorrmaskmasksbottom' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'] },
	'maskgroupbasedcorrmaskmaskscentervalue' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'maskgroupbasedcorrmaskmaskscenterweight' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'maskgroupbasedcorrmaskmasksdabs' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'] },
	'maskgroupbasedcorrmaskmasksfeather' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'] },
	'maskgroupbasedcorrmaskmasksflipped' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'maskgroupbasedcorrmaskmasksflow' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'] },
	'maskgroupbasedcorrmaskmasksfullx' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'] },
	'maskgroupbasedcorrmaskmasksfully' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'] },
	'maskgroupbasedcorrmaskmasksinputdigest' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'maskgroupbasedcorrmaskmasksleft' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'] },
	'maskgroupbasedcorrmaskmasksmaskactive' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'maskgroupbasedcorrmaskmasksmaskblendmode' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmasksmaskdigest' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmasksmaskinverted' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmasksmaskname' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'maskgroupbasedcorrmaskmasksmasksubtype' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksmasksyncid' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmasksmaskversion' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmasksmidpoint' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'maskgroupbasedcorrmaskmasksorigin' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'maskgroupbasedcorrmaskmasksperimetervalue' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskmasksradius' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'] },
	'maskgroupbasedcorrmaskmasksreferencepoint' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'maskgroupbasedcorrmaskmasksright' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'] },
	'maskgroupbasedcorrmaskmasksroundness' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'maskgroupbasedcorrmaskmaskssizex' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'maskgroupbasedcorrmaskmaskssizey' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'maskgroupbasedcorrmaskmaskstop' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'] },
	'maskgroupbasedcorrmaskmasksubtype' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksvalue' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'maskgroupbasedcorrmaskmasksversion' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'] },
	'maskgroupbasedcorrmaskmaskswhat' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'] },
	'maskgroupbasedcorrmaskmaskswholeimagearea' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskmasksx' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'] },
	'maskgroupbasedcorrmaskmasksy' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'] },
	'maskgroupbasedcorrmaskmasksyncid' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmaskszerox' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'maskgroupbasedcorrmaskmaskszeroy' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'maskgroupbasedcorrmaskmaskversion' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmidpoint' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'] },
	'maskgroupbasedcorrmaskorigin' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'] },
	'maskgroupbasedcorrmaskperimetervalue' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskradius' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'] },
	'maskgroupbasedcorrmaskrange' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'maskgroupbasedcorrmaskrangeareamodels' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrmaskrangeareamodelscolorsampleinfo' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrmaskrangeareamodelscomponents' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrmaskrangecoloramount' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrmaskrangedepthfeather' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrmaskrangedepthmax' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrmaskrangedepthmin' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrmaskrangeinvert' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrmaskrangelumfeather' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrmaskrangeluminancedepthsampleinfo' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrmaskrangelummax' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrmaskrangelummin' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrmaskrangelumrange' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrmaskrangesampletype' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrmaskrangetype' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'maskgroupbasedcorrmaskrangeversion' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrmaskreferencepoint' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'] },
	'maskgroupbasedcorrmaskright' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'] },
	'maskgroupbasedcorrmaskroundness' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'] },
	'maskgroupbasedcorrmasksizex' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'] },
	'maskgroupbasedcorrmasksizey' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'] },
	'maskgroupbasedcorrmasktop' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'] },
	'maskgroupbasedcorrmaskvalue' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'] },
	'maskgroupbasedcorrmaskversion' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'] },
	'maskgroupbasedcorrmaskwhat' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'] },
	'maskgroupbasedcorrmaskwholeimagearea' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskx' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'] },
	'maskgroupbasedcorrmasky' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'] },
	'maskgroupbasedcorrmaskzerox' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'] },
	'maskgroupbasedcorrmaskzeroy' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'] },
	'maskgroupbasedcorrmoire' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'] },
	'maskgroupbasedcorrrangemask' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'] },
	'maskgroupbasedcorrrangemaskareamodels' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrrangemaskareamodelscolorsampleinfo' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrrangemaskareamodelscomponents' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrrangemaskcoloramount' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrrangemaskdepthfeather' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrrangemaskdepthmax' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrrangemaskdepthmin' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrrangemaskinvert' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrrangemasklumfeather' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrrangemaskluminancedepthsampleinfo' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrrangemasklummax' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrrangemasklummin' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrrangemasklumrange' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrrangemasksampletype' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrrangemasktype' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'] },
	'maskgroupbasedcorrrangemaskversion' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrsaturation' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'] },
	'maskgroupbasedcorrshadows2012' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'] },
	'maskgroupbasedcorrsharpness' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'] },
	'maskgroupbasedcorrtemperature' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'] },
	'maskgroupbasedcorrtexture' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'] },
	'maskgroupbasedcorrtint' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'] },
	'maskgroupbasedcorrtoninghue' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'] },
	'maskgroupbasedcorrtoningsaturation' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'] },
	'maskgroupbasedcorrwhat' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'] },
	'maskgroupbasedcorrwhites2012' => { 505 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'], 507 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'] },
	'masterdocumentid' => { 134 => 0xb9 },
	'mastergain' => { 261 => 0x50 },
	'materialsample' => { 121 => 'MaterialSample' },
	'materialsampleid' => { 121 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 302 => '50.1', 304 => '48.1', 305 => '48.1', 314 => '48.1', 315 => '48.1', 317 => 0x233, 318 => 0x233, 319 => 0x24b },
	'matrixselectk' => { 141 => 0x91b },
	'matrixselectthreshold' => { 141 => 0x91a },
	'matrixselectthreshold1' => { 141 => 0x91e },
	'matrixselectthreshold2' => { 141 => 0x91f },
	'matrixstructure' => { 403 => 0xa },
	'maxaperture' => { 36 => 0x1a, 141 => 0x3f9, 147 => 0x6103, 166 => 'MaxAperture', 184 => 0x17, 190 => 0x49c5, 236 => 0x36, 322 => 0x20a, 370 => '14.1' },
	'maxapertureatmaxfocal' => { 130 => 0x1407, 166 => 'MaxApertureAtMaxFocal', 230 => 0xb, 231 => 0x10, 232 => 0x11, 236 => 0x12, 322 => 0x206 },
	'maxapertureatminfocal' => { 130 => 0x1406, 230 => 0xa, 231 => 0xf, 232 => 0x10, 236 => 0x11, 322 => 0x205 },
	'maxaperturevalue' => { 122 => 0x9205, 388 => 0x414, 511 => 'MaxApertureValue' },
	'maxavailheight' => { 519 => 'MaxAvailHeight' },
	'maxavailwidth' => { 519 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 301 => 0xb, 302 => 0xc, 304 => '12.1', 305 => '12.1', 310 => 0xc, 311 => 0xb, 314 => '12.1', 315 => '12.1', 317 => 0x3d, 318 => 0x3d, 319 => 0x3d },
	'maxfaces' => { 325 => 0x1202 },
	'maxfocallength' => { 7 => 0xe6, 8 => 0x10, 9 => 0x1ab, 10 => 0x13, 11 => 0x115, 12 => 0x13, 13 => 0x153, 14 => 0xda, 16 => 0xfa, 17 => 0xee, 18 => 0x103, 19 => 0x95, 20 => 0xea, 21 => 0x157, 22 => 0xee, 23 => 0xec, 24 => 0x12b, 25 => 0x165, 26 => 0x16a, 27 => 0x188, 28 => 0x116, 29 => 0x18d, 36 => 0x17, 130 => 0x1405, 166 => 'MaxFocalLength', 230 => 0x9, 231 => 0xe, 232 => 0xf, 236 => 0x10, 322 => 0x208, 457 => 0x127c, 458 => 0x1138, 459 => 0x330, 460 => 0x330, 461 => 0x30e },
	'maximumdensityrange' => { 136 => 0x8c },
	'maxpagesize' => { 539 => 'MaxPageSize' },
	'maxpagesizeh' => { 539 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 539 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 539 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 141 => 0xc7d },
	'maxsamplevalue' => { 122 => 0x119 },
	'maxstorage' => { 529 => 'maxstorage' },
	'mb-d10batteries' => { 301 => '12.6' },
	'mb-d10batterytype' => { 310 => '13.3' },
	'mb-d11batterytype' => { 311 => '2.3' },
	'mb-d12batterytype' => { 314 => '3.2' },
	'mb-d80batteries' => { 312 => '6.5' },
	'mb-d80batterytype' => { 316 => '3.2' },
	'mcuversion' => { 230 => 0xc, 231 => 0x11, 232 => 0x12, 236 => 0x13 },
	'md5digest' => { 167 => 'zmd5' },
	'mditemfindercomment' => { 176 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 176 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 176 => 'MDItemFSLabel' },
	'mditemusertags' => { 176 => 'MDItemUserTags' },
	'meal' => { 526 => 'meal' },
	'measuredev' => { 28 => 0x9, 79 => 0x3, 100 => 0x1814, 159 => 'MeasuredEV' },
	'measuredev2' => { 13 => 0x8, 28 => 0x8, 79 => 0x17 },
	'measuredev3' => { 13 => 0x9 },
	'measuredlv' => { 190 => 0x690, 339 => 0x312, 342 => 0x312, 343 => 0x312, 346 => 0x3407 },
	'measuredrggb' => { 67 => 0x1 },
	'measuredrggbdata' => { 46 => 0x287 },
	'measurementaccuracy' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 121 => 'MeasurementOrFact' },
	'measurementremarks' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 121 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 490 => 'MeasureType' },
	'mechanicalshuttercount' => { 238 => 0x37 },
	'mediaclassprimaryid' => { 182 => 'WM/MediaClassPrimaryID' },
	'mediaclasssecondaryid' => { 182 => 'WM/MediaClassSecondaryID' },
	'mediaconstraints' => { 331 => 'MediaConstraints' },
	'mediacreatedate' => { 400 => 0x1 },
	'mediaeventiddate' => { 495 => 'MediaEventIdDate' },
	'mediamodifydate' => { 400 => 0x2 },
	'mediasummarycode' => { 331 => 'MediaSummaryCode' },
	'mediatype' => { 396 => 'stik' },
	'memoaudioquality' => { 87 => 0x812 },
	'memorycardconfiguration' => { 437 => 0x16 },
	'memorycardnumber' => { 215 => 0x2 },
	'menubuttondisplayposition' => { 85 => 0xb, 88 => 0xa, 89 => 0xb, 92 => 0xb },
	'menubuttonreturn' => { 93 => 0xb },
	'menumonitorofftime' => { 301 => '26.1', 302 => '22.1', 304 => '22.1', 305 => '22.1', 309 => '21.1', 310 => '8.2', 311 => '21.1', 314 => '22.1', 315 => '22.1', 316 => '22.1', 317 => 0x35, 318 => 0x35, 319 => 0x35 },
	'mergedimages' => { 344 => 0x76 },
	'metadataauthority' => { 519 => 'metadataAuthority' },
	'metadataauthorityidentifier' => { 519 => [\'metadataAuthority','metadataAuthorityIdentifier'] },
	'metadataauthorityname' => { 519 => [\'metadataAuthority','metadataAuthorityName'] },
	'metadatadate' => { 532 => 'MetadataDate' },
	'metadataeditingsoftware' => { 122 => 0xa43c },
	'metadatalastedited' => { 519 => 'metadataLastEdited' },
	'metadatalasteditor' => { 519 => 'metadataLastEditor' },
	'metadatalasteditoridentifier' => { 519 => [\'metadataLastEditor','metadataLastEditorIdentifier'] },
	'metadatalasteditorname' => { 519 => [\'metadataLastEditor','metadataLastEditorName'] },
	'metadatamoddate' => { 534 => 'metadataModDate' },
	'metaversion' => { 452 => 0x34 },
	'meterinfo1row1' => { 445 => 0x0, 446 => 0x0 },
	'meterinfo1row2' => { 445 => 0x6c, 446 => 0x5a },
	'meterinfo1row3' => { 445 => 0xd8, 446 => 0xb4 },
	'meterinfo1row4' => { 445 => 0x144, 446 => 0x10e },
	'meterinfo1row5' => { 445 => 0x1b0, 446 => 0x168 },
	'meterinfo1row6' => { 445 => 0x21c, 446 => 0x1c2 },
	'meterinfo1row7' => { 445 => 0x288, 446 => 0x21c },
	'meterinfo2row1' => { 445 => 0x2f4, 446 => 0x276 },
	'meterinfo2row2' => { 445 => 0x378, 446 => 0x2e4 },
	'meterinfo2row3' => { 445 => 0x3fc, 446 => 0x352 },
	'meterinfo2row4' => { 445 => 0x480, 446 => 0x3c0 },
	'meterinfo2row5' => { 445 => 0x504, 446 => 0x42e },
	'meterinfo2row6' => { 445 => 0x588, 446 => 0x49c },
	'meterinfo2row7' => { 445 => 0x60c, 446 => 0x50a },
	'meterinfo2row8' => { 445 => 0x690, 446 => 0x578 },
	'meterinfo2row9' => { 445 => 0x714, 446 => 0x5e6 },
	'metering' => { 303 => '6.1' },
	'meteringmode' => { 36 => 0x11, 122 => 0x9207, 143 => 0x1c, 184 => 0x7, 185 => 0x25, 187 => 0x12, 321 => 0x202, 379 => 0x17, 421 => 0x9, 431 => 0x15, 432 => 0x13, 433 => 0x7, 449 => 0x3, 453 => 0x1174, 454 => 0x1178, 455 => 0x1154, 456 => 0x11d0, 457 => 0x11ac, 458 => 0x1064, 459 => 0x25c, 460 => 0x25c, 461 => 0x24b, 511 => 'MeteringMode' },
	'meteringmode2' => { 360 => '2.1', 444 => 0x202c },
	'meteringmode3' => { 360 => '16.1' },
	'meteringoffscaleindicator' => { 187 => 0x53 },
	'meteringtime' => { 301 => '22.2', 303 => '3.2', 306 => '17.1', 307 => '18.1', 310 => '7.3', 311 => '18.1', 312 => '3.2', 316 => '19.1' },
	'micro1version' => { 406 => 0x1f },
	'micro2version' => { 406 => 0x2d },
	'microphoneattenuator' => { 243 => 0x34e, 244 => 0x2d2, 245 => 0x2fa, 246 => 0x2fa },
	'microphonefrequencyresponse' => { 243 => 0x350, 244 => 0x2d4, 245 => 0x2fc, 246 => 0x2fc },
	'microphonejackpower' => { 243 => 0x376, 244 => 0x2fa, 245 => 0x322, 246 => 0x322 },
	'microphonesensitivity' => { 243 => 0x34c, 244 => 0x2d0, 245 => 0x2f8, 246 => 0x2f8 },
	'microvideo' => { 488 => 'MicroVideo' },
	'microvideooffset' => { 488 => 'MicroVideoOffset' },
	'microvideopresentationtimestampus' => { 488 => 'MicroVideoPresentationTimestampUs' },
	'microvideoversion' => { 488 => 'MicroVideoVersion' },
	'midrangesharpness' => { 255 => 0x3b },
	'mieversion' => { 167 => '0Vers' },
	'mime' => { 490 => 'Mime' },
	'minaperture' => { 36 => 0x1b, 141 => 0x3f8, 166 => 'MinAperture', 370 => '0.2' },
	'minaperturevalue' => { 388 => 0x415 },
	'minfocallength' => { 7 => 0xe4, 8 => 0xe, 9 => 0x1a9, 10 => 0x11, 11 => 0x113, 12 => 0x11, 13 => 0x151, 14 => 0xd8, 16 => 0xf8, 17 => 0xec, 18 => 0x101, 19 => 0x93, 20 => 0xe8, 21 => 0x155, 22 => 0xec, 23 => 0xea, 24 => 0x129, 25 => 0x163, 26 => 0x168, 27 => 0x186, 28 => 0x114, 29 => 0x18b, 36 => 0x18, 130 => 0x1404, 166 => 'MinFocalLength', 230 => 0x8, 231 => 0xd, 232 => 0xe, 236 => 0xf, 322 => 0x207, 457 => 0x127a, 458 => 0x1136, 459 => 0x32e, 460 => 0x32e, 461 => 0x30c },
	'minfocusdistance' => { 370 => 0x3 },
	'minimumiso' => { 344 => 0xe8 },
	'minintegrationrows' => { 141 => 0x1874 },
	'minoltadate' => { 184 => 0x15 },
	'minoltaimagesize' => { 184 => 0x4, 185 => 0xc, 186 => 0x2, 189 => 0x103 },
	'minoltamodelid' => { 184 => 0x25 },
	'minoltaquality' => { 184 => 0x5, 185 => 0xd, 186 => 0x3, 189 => [0x102,0x103] },
	'minoltatime' => { 184 => 0x16 },
	'minormodelagedisclosure' => { 331 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 496 => 'MinorVersion' },
	'minsamplevalue' => { 122 => 0x118 },
	'mirrorlockup' => { 85 => 0xc, 86 => 0xc, 87 => 0x60f, 88 => 0xb, 89 => 0xc, 90 => 0x6, 91 => 0x6, 92 => 0xc, 93 => 0x3 },
	'mobilecountrycode' => { 504 => 'mcc' },
	'mobilenetworkcode' => { 504 => 'mnc' },
	'moddate' => { 334 => 'modify-date', 521 => 'ModDate' },
	'modedialposition' => { 437 => 0x14 },
	'model' => { 101 => 0x6, 122 => 0x110, 159 => 'Model', 334 => 'Model', 349 => 0x110, 379 => 0x23f, 398 => 'model', 404 => ['@mod','CNMN','cmnm',"\xa9mdl","\xa9mod"], 421 => 0x84, 490 => 'Model', 523 => 'model', 530 => 'Model' },
	'modelage' => { 519 => 'ModelAge' },
	'modelid' => { 320 => 0x0 },
	'modelingflash' => { 301 => '21.4', 302 => '31.1', 304 => '31.1', 305 => '31.1', 310 => '26.4', 311 => '30.2', 312 => '7.4', 313 => '30.1', 314 => '31.1', 315 => '31.1', 316 => '31.3', 317 => 0x5d, 318 => 0x5d, 319 => 0x5d },
	'modelreleaseid' => { 331 => 'ModelReleaseID' },
	'modelreleasestatus' => { 331 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 467 => 0x52, 468 => 0x46, 469 => 0x53 },
	'modeltiepoint' => { 122 => 0x8482 },
	'modeltransform' => { 122 => 0x85d8 },
	'modelyear' => { 523 => 'modelYear' },
	'modificationdate' => { 524 => 'modificationDate' },
	'modifiedcolortemp' => { 68 => 0x9 },
	'modifieddigitalgain' => { 68 => 0xb },
	'modifiedparamflag' => { 60 => 0x1 },
	'modifiedpicturestyle' => { 68 => 0xa },
	'modifiedsaturation' => { 321 => 0x504 },
	'modifiedsensorbluelevel' => { 68 => 0x5 },
	'modifiedsensorredlevel' => { 68 => 0x4 },
	'modifiedsharpness' => { 68 => 0x2 },
	'modifiedsharpnessfreq' => { 68 => 0x3 },
	'modifiedtonecurve' => { 68 => 0x1 },
	'modifiedwhitebalance' => { 68 => 0x8 },
	'modifiedwhitebalanceblue' => { 68 => 0x7 },
	'modifiedwhitebalancered' => { 68 => 0x6 },
	'modifydate' => { 122 => 0x132, 160 => 'ModifyDate', 330 => 'ModDate', 332 => 'tIME', 395 => 'ModDate', 401 => 0x2, 532 => 'ModifyDate' },
	'moirefilter' => { 122 => 0xfe58, 505 => 'MoireFilter', 507 => 'MoireFilter' },
	'monitorbrightness' => { 243 => 0x69a, 244 => 0x59a, 245 => 0x5ca, 246 => 0x5e2 },
	'monitordisplayoff' => { 187 => 0x4c },
	'monitormatrix' => { 141 => 0x8fc },
	'monitorofftime' => { 301 => '18.2', 303 => '3.1', 312 => '3.1' },
	'monochromecolor' => { 321 => 0x53b },
	'monochromecontrast' => { 112 => 0x3c },
	'monochromefiltereffect' => { 106 => 0x20307, 112 => 0x3a, 344 => 0xac, 379 => 0x73 },
	'monochromegraineffect' => { 344 => 0xd2 },
	'monochromelinear' => { 112 => 0x3d },
	'monochromeoutputhighlightpoint' => { 112 => 0x41 },
	'monochromeoutputshadowpoint' => { 112 => 0x42 },
	'monochromeprofilesettings' => { 321 => 0x537 },
	'monochromerawhighlight' => { 112 => 0x7a },
	'monochromerawhighlightpoint' => { 112 => 0x3f },
	'monochromerawshadow' => { 112 => 0x83 },
	'monochromerawshadowpoint' => { 112 => 0x40 },
	'monochromesharpness' => { 112 => 0x3e },
	'monochrometoning' => { 379 => 0x74 },
	'monochrometoningeffect' => { 106 => 0x20306, 112 => 0x3b },
	'monochromeunsharpmaskfineness' => { 112 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 112 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 112 => 0xb4 },
	'monochromevignetting' => { 321 => 0x53a },
	'monthdaycreated' => { 143 => 0x12, 152 => 0xe },
	'mood' => { 182 => 'WM/Mood' },
	'moonphase' => { 405 => 0x12, 406 => 0x43, 407 => 0x4c },
	'morepermissions' => { 503 => 'morePermissions' },
	'motionphotovideo' => { 399 => 'mpvd' },
	'motionsensitivity' => { 405 => 0x29, 407 => 0x60 },
	'movementcount' => { 396 => "\xa9mvc" },
	'movementname' => { 396 => "\xa9mvn" },
	'movementnumber' => { 396 => "\xa9mvi" },
	'movieactived-lighting' => { 242 => 0x238, 243 => 0x334, 244 => 0x2b8, 245 => 0x2e0, 246 => 0x2e0 },
	'movieaelockbuttonassignment' => { 314 => '40.1' },
	'movieaf-onbutton' => { 317 => 0xcb, 318 => 0xcb, 319 => 0xcb },
	'movieafareamode' => { 243 => 0x342, 244 => 0x2c6, 245 => 0x2ee, 246 => 0x2ee, 317 => 0x203, 318 => 0x203, 319 => 0x21b },
	'movieafspeed' => { 317 => 0xdd, 318 => 0xdd, 319 => 0xdd },
	'movieafspeedapply' => { 317 => 0xdf, 318 => 0xdf, 319 => 0xdf },
	'movieaftrackingsensitivity' => { 317 => 0xe1, 318 => 0xe1, 319 => 0xe1 },
	'movieaperturelock' => { 317 => 0x259, 318 => 0x259, 319 => 0x271 },
	'movieautodistortioncontrol' => { 242 => 0x242 },
	'moviediffractioncompensation' => { 242 => 0x241 },
	'moviedxcropalert' => { 243 => 0x377, 244 => 0x2fb, 245 => 0x323, 246 => 0x323 },
	'movieelectronicvr' => { 243 => 0x348, 244 => 0x2cc, 245 => 0x2f4, 246 => 0x2f4 },
	'movieevfgrid' => { 317 => 0x21d, 318 => 0x21d, 319 => 0x235 },
	'movieflickerreduction' => { 243 => 0x33c, 244 => 0x2c0, 245 => 0x2e8, 246 => 0x2e8 },
	'moviefocusmode' => { 242 => 0x248, 243 => 0x340, 244 => 0x2c4, 245 => 0x2ec, 246 => 0x2ec },
	'moviefocuspointlock' => { 317 => 0x226, 318 => 0x226, 319 => 0x23e },
	'movieframerate' => { 242 => 0x1f8, 243 => 0x374, 244 => 0x2f4, 245 => 0x31c, 246 => 0x31c },
	'movieframesize' => { 242 => 0x1f6, 243 => 0x372, 244 => 0x2f2, 245 => 0x31a, 246 => 0x31a },
	'moviefunc1button' => { 304 => '41.1', 305 => '41.1', 315 => '41.1', 317 => 0xc3, 318 => 0xc3, 319 => 0xc3 },
	'moviefunc2button' => { 317 => 0xc7, 318 => 0xc7, 319 => 0xc7 },
	'moviefunc3button' => { 318 => 0x127, 319 => 0x13f },
	'moviefunctionbutton' => { 302 => '41.1', 314 => '41.1' },
	'moviefunctionbuttonplusdials' => { 302 => '52.1' },
	'moviehighisonoisereduction' => { 242 => 0x23c, 243 => 0x336, 244 => 0x2ba, 245 => 0x2e2, 246 => 0x2e2 },
	'moviehighlightdisplaythreshold' => { 317 => 0x215, 318 => 0x215, 319 => 0x22d },
	'moviehighreszoom' => { 243 => 0x380, 245 => 0x32c, 246 => 0x32c },
	'movieimagearea' => { 243 => 0x2da, 244 => 0x25c, 245 => 0x286, 246 => 0x286 },
	'movieisoautocontrolmanualmode' => { 243 => 0x2e8, 244 => 0x26a, 245 => 0x294, 246 => 0x294 },
	'movieisoautohilimit' => { 243 => 0x2e6, 244 => 0x268, 245 => 0x292, 246 => 0x292 },
	'movieisoautomanualmode' => { 242 => 0x204, 243 => 0x2ea, 244 => 0x26c, 245 => 0x296, 246 => 0x296 },
	'movielenscontrolring' => { 317 => 0xd7, 318 => 0xd7, 319 => 0xd7 },
	'moviemeteringmode' => { 243 => 0x33e, 244 => 0x2c2, 245 => 0x2ea, 246 => 0x2ea },
	'moviemidtonedisplayrange' => { 317 => 0x219, 318 => 0x219, 319 => 0x231 },
	'moviemidtonedisplayvalue' => { 317 => 0x217, 318 => 0x217, 319 => 0x22f },
	'moviemultiselector' => { 317 => 0xd9, 318 => 0xcf, 319 => 0xcf },
	'moviepreviewbutton' => { 302 => '41.2', 304 => '41.2', 305 => '41.2', 314 => '41.2', 315 => '41.2' },
	'moviepreviewbuttonplusdials' => { 302 => '52.2' },
	'movierecordbuttonplaybackmode' => { 317 => 0x1b5, 318 => 0x1b5, 319 => 0x1cd },
	'movieshutterbutton' => { 302 => '38.3', 304 => '38.3', 305 => '38.3', 314 => '38.3', 315 => '38.3' },
	'movieshutterspeedlock' => { 317 => 0x225, 318 => 0x225, 319 => 0x23d },
	'movieslowmotion' => { 242 => 0x1fa },
	'moviesoundrecording' => { 243 => 0x34a, 244 => 0x2ce, 245 => 0x2f6, 246 => 0x2f6 },
	'moviesubjectdetection' => { 243 => 0x378, 244 => 0x2fc, 245 => 0x324, 246 => 0x324 },
	'moviesubselectorassignment' => { 302 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 302 => '53.1' },
	'movietonemap' => { 244 => 0x2ec, 245 => 0x314, 246 => 0x314 },
	'movietype' => { 227 => 0x2ca, 242 => 0x1fe, 243 => 0x2e4, 244 => 0x266, 245 => 0x290, 246 => 0x290 },
	'movievibrationreduction' => { 242 => 0x24e },
	'movievibrationreductionsameasphoto' => { 242 => 0x24f },
	'movievignettecontrol' => { 242 => 0x23e, 243 => 0x1b0, 244 => 0x1a0, 245 => 0x1b4, 246 => 0x1b4 },
	'movievignettecontrolsameasphoto' => { 242 => 0x240 },
	'movievrmode' => { 243 => 0x344, 244 => 0x2c8, 245 => 0x2f0, 246 => 0x2f0 },
	'moviezebrapattern' => { 317 => 0x213, 318 => 0x213, 319 => 0x22b },
	'multiburstimageheight' => { 444 => 0x1002 },
	'multiburstimagewidth' => { 444 => 0x1001 },
	'multiburstmode' => { 444 => 0x1000 },
	'multicontrollerwhilemetering' => { 87 => 0x517 },
	'multiexposure' => { 70 => 0x1, 344 => 0xb4 },
	'multiexposureautogain' => { 248 => 0x3 },
	'multiexposurecontrol' => { 70 => 0x2 },
	'multiexposuremode' => { 248 => 0x1, 249 => 0x1 },
	'multiexposureoverlaymode' => { 249 => 0x3 },
	'multiexposureshots' => { 70 => 0x3, 243 => 0x9a, 244 => 0x8e, 245 => 0x9c, 246 => 0x9c, 248 => 0x2, 249 => 0x2 },
	'multiframenoisereduction' => { 433 => 0x35, 444 => 0x200b, 449 => 0x15 },
	'multiframenreffect' => { 444 => 0x2023 },
	'multifunctionlock' => { 87 => 0x70f },
	'multipleexposuremode' => { 243 => 0x98, 244 => 0x8c, 245 => 0x9a, 246 => 0x9a, 325 => 0x101c },
	'multipleexposureset' => { 360 => '10.1' },
	'multisample' => { 261 => 0x40 },
	'multiselector' => { 301 => '9.4', 302 => '10.3', 304 => '10.3', 305 => '10.3', 310 => '27.4', 314 => '10.3', 315 => '10.3' },
	'multiselectorliveview' => { 301 => '4.3', 304 => '37.1', 305 => '37.1', 314 => '37.1', 315 => '37.1' },
	'multiselectorliveviewmode' => { 275 => 0x18c2 },
	'multiselectorplaybackmode' => { 301 => ['13.5','9.2'], 302 => '10.2', 305 => '10.2', 310 => '27.2', 314 => '10.2', 315 => '10.2', 317 => 0xb3, 318 => 0xb3, 319 => 0xb3 },
	'multiselectorshootmode' => { 301 => '9.1', 302 => '10.1', 304 => '10.1', 305 => '10.1', 310 => '27.1', 314 => '10.1', 315 => '10.1', 317 => 0xaf, 318 => 0xaf, 319 => 0xaf },
	'multishot' => { 349 => 0x121 },
	'mute' => { 398 => 'player.movie.audio.mute' },
	'mycolormode' => { 71 => 0x2 },
	'name' => { 404 => 'name', 505 => 'Name', 507 => 'Name' },
	'narrator' => { 396 => "\xa9nrt" },
	'nationalcatalognumber' => { 524 => 'nationalCatalogNumber' },
	'nativedigest' => { 511 => 'NativeDigest', 530 => 'NativeDigest' },
	'ndfilter' => { 79 => 0x1c, 321 => 0x204, 411 => 0x1019 },
	'near' => { 490 => 'Near' },
	'nefbitdepth' => { 238 => 0xe22 },
	'nefcompression' => { 238 => 0x93, 239 => 0xa },
	'neflinearizationtable' => { 238 => 0x96 },
	'negativecachelargepreviewsize' => { 505 => 'NegativeCacheLargePreviewSize', 507 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 505 => 'NegativeCacheMaximumSize', 507 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 505 => 'NegativeCachePath', 507 => 'NegativeCachePath' },
	'neutraldensityfactor' => { 502 => 'NeutralDensityFactor' },
	'neutraldensityfilter' => { 379 => 0x88 },
	'neutraloutputhighlightpoint' => { 112 => 0x2f },
	'neutraloutputshadowpoint' => { 112 => 0x30 },
	'neutralrawcolortone' => { 112 => 0x28 },
	'neutralrawcontrast' => { 112 => 0x2a },
	'neutralrawhighlight' => { 112 => 0x78 },
	'neutralrawhighlightpoint' => { 112 => 0x2d },
	'neutralrawlinear' => { 112 => 0x2b },
	'neutralrawsaturation' => { 112 => 0x29 },
	'neutralrawshadow' => { 112 => 0x81 },
	'neutralrawshadowpoint' => { 112 => 0x2e },
	'neutralrawsharpness' => { 112 => 0x2c },
	'neutralunsharpmaskfineness' => { 112 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 112 => 0xa8 },
	'neutraunsharpmaskstrength' => { 112 => 0xa4 },
	'newlensdata' => { 236 => 0x2f },
	'newrawimagedigest' => { 122 => 0xc7a7 },
	'newsphotoversion' => { 136 => 0x0 },
	'nickname' => { 532 => 'Nickname' },
	'nikoncapturedata' => { 238 => 0xe01 },
	'nikoncaptureeditversions' => { 238 => 0xe13 },
	'nikoncaptureoffsets' => { 238 => 0xe0e },
	'nikoncaptureoutput' => { 238 => 0xe1e },
	'nikoncaptureversion' => { 238 => 0xe09 },
	'nikoniccprofile' => { 238 => 0xe1d },
	'nikonimagesize' => { 272 => '723.1', 273 => '732.1', 281 => 0x2c4 },
	'nikonmeteringmode' => { 202 => 0x17, 242 => 0x146, 252 => 0x214 },
	'nikonsettings' => { 238 => 0x4e },
	'noisefilter' => { 321 => 0x527 },
	'noiseprofile' => { 122 => 0xc761 },
	'noisereduction' => { 130 => [0x100b,0x100e], 185 => 0xb0, 186 => 0x60, 187 => 0x3f, 238 => 0x95, 294 => 0x753dcbc0, 295 => 0x17, 321 => 0x50a, 326 => 0x103a, 344 => 0x2d, 379 => 0x49, 411 => 0x100f, 413 => 0x2a },
	'noisereduction2' => { 325 => 0x1010 },
	'noisereductionapplied' => { 122 => 0xc6f7 },
	'noisereductionintensity' => { 295 => 0x9 },
	'noisereductionmethod' => { 295 => 0x11 },
	'noisereductionmode' => { 481 => 0x801e },
	'noisereductionparametersatcapture' => { 141 => 0xe73 },
	'noisereductionparameterscamera' => { 141 => 0xe72 },
	'noisereductionparametershost3mp' => { 141 => 0xe71 },
	'noisereductionparametershost6mp' => { 141 => 0xe70 },
	'noisereductionparametershostrgb' => { 141 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 141 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 141 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 141 => 0xe63 },
	'noisereductionparams' => { 349 => 0x1b },
	'noisereductionsharpness' => { 295 => 0xd },
	'noisereductionstrength' => { 344 => 0xd6 },
	'noisereductionvalue' => { 481 => 0x8027 },
	'nomemorycard' => { 301 => '22.1', 302 => '4.2', 303 => '0.3', 306 => '2.4', 307 => '3.2', 308 => '3.2', 310 => '33.7', 311 => '3.2', 312 => '0.3', 314 => '4.2', 316 => '4.5' },
	'nominalmaxaperture' => { 370 => 0xa },
	'nominalminaperture' => { 370 => '10.1' },
	'noncpulens10focallength' => { 243 => 0x6c6, 246 => 0x620 },
	'noncpulens10maxaperture' => { 243 => 0x6ee, 246 => 0x670 },
	'noncpulens11focallength' => { 243 => 0x6c8, 246 => 0x624 },
	'noncpulens11maxaperture' => { 243 => 0x6f0, 246 => 0x674 },
	'noncpulens12focallength' => { 243 => 0x6ca, 246 => 0x628 },
	'noncpulens12maxaperture' => { 243 => 0x6f2, 246 => 0x678 },
	'noncpulens13focallength' => { 243 => 0x6cc, 246 => 0x62c },
	'noncpulens13maxaperture' => { 243 => 0x6f4, 246 => 0x67c },
	'noncpulens14focallength' => { 243 => 0x6ce, 246 => 0x630 },
	'noncpulens14maxaperture' => { 243 => 0x6f6, 246 => 0x680 },
	'noncpulens15focallength' => { 243 => 0x6d0, 246 => 0x634 },
	'noncpulens15maxaperture' => { 243 => 0x6f8, 246 => 0x684 },
	'noncpulens16focallength' => { 243 => 0x6d2, 246 => 0x638 },
	'noncpulens16maxaperture' => { 243 => 0x6fa, 246 => 0x688 },
	'noncpulens17focallength' => { 243 => 0x6d4, 246 => 0x63c },
	'noncpulens17maxaperture' => { 243 => 0x6fc, 246 => 0x68c },
	'noncpulens18focallength' => { 243 => 0x6d6, 246 => 0x640 },
	'noncpulens18maxaperture' => { 243 => 0x6fe, 246 => 0x690 },
	'noncpulens19focallength' => { 243 => 0x6d8, 246 => 0x644 },
	'noncpulens19maxaperture' => { 243 => 0x700, 246 => 0x694 },
	'noncpulens1focallength' => { 243 => 0x6b4, 246 => 0x5fc },
	'noncpulens1maxaperture' => { 243 => 0x6dc, 246 => 0x64c },
	'noncpulens20focallength' => { 243 => 0x6da, 246 => 0x648 },
	'noncpulens20maxaperture' => { 243 => 0x702, 246 => 0x698 },
	'noncpulens2focallength' => { 243 => 0x6b6, 246 => 0x600 },
	'noncpulens2maxaperture' => { 243 => 0x6de, 246 => 0x650 },
	'noncpulens3focallength' => { 243 => 0x6b8, 246 => 0x604 },
	'noncpulens3maxaperture' => { 243 => 0x6e0, 246 => 0x654 },
	'noncpulens4focallength' => { 243 => 0x6ba, 246 => 0x608 },
	'noncpulens4maxaperture' => { 243 => 0x6e2, 246 => 0x658 },
	'noncpulens5focallength' => { 243 => 0x6bc, 246 => 0x60c },
	'noncpulens5maxaperture' => { 243 => 0x6e4, 246 => 0x65c },
	'noncpulens6focallength' => { 243 => 0x6be, 246 => 0x610 },
	'noncpulens6maxaperture' => { 243 => 0x6e6, 246 => 0x660 },
	'noncpulens7focallength' => { 243 => 0x6c0, 246 => 0x614 },
	'noncpulens7maxaperture' => { 243 => 0x6e8, 246 => 0x664 },
	'noncpulens8focallength' => { 243 => 0x6c2, 246 => 0x618 },
	'noncpulens8maxaperture' => { 243 => 0x6ea, 246 => 0x668 },
	'noncpulens9focallength' => { 243 => 0x6c4, 246 => 0x61c },
	'noncpulens9maxaperture' => { 243 => 0x6ec, 246 => 0x66c },
	'normallinetime' => { 141 => 0x186a },
	'normalwhitelevel' => { 43 => 0x32a, 44 => 0x280, 47 => [0x2b8,0x2cf,0x2d3], 48 => 0x569, 49 => 0x1e3, 50 => [0x1fc,0x2dc], 51 => [0x230,0x30e], 52 => 0x31c },
	'notes' => { 482 => 'Notes', 500 => 'notes' },
	'npages' => { 539 => 'NPages' },
	'nullrecord' => { 100 => 0x0 },
	'numafpoints' => { 356 => 0x2 },
	'number' => { 524 => 'number' },
	'numberofbeats' => { 534 => 'numberOfBeats' },
	'numberoffocuspoints' => { 304 => '1.3', 305 => '1.3', 308 => '0.2', 309 => '0.3', 311 => '0.3' },
	'numfaceelements' => { 130 => 0x4200 },
	'numfacepositions' => { 336 => 0x0 },
	'numindexentries' => { 136 => 0x54 },
	'numwbentries' => { 350 => 0x0, 351 => 0x0 },
	'object' => { 524 => 'object' },
	'objectattributereference' => { 134 => 0x4 },
	'objectcycle' => { 134 => 0x4b, 500 => 'ObjectCycle' },
	'objectdescription' => { 523 => 'objectDescription' },
	'objectdistance' => { 115 => 0x6, 116 => 0x2022 },
	'objectname' => { 134 => 0x5 },
	'objectpreviewdata' => { 134 => 0xca },
	'objectpreviewfileformat' => { 134 => 0xc8 },
	'objectpreviewfileversion' => { 134 => 0xc9 },
	'objectsubtype' => { 523 => 'objectSubtype' },
	'objecttype' => { 523 => 'objectType' },
	'objecttypereference' => { 134 => 0x3 },
	'occurrence' => { 121 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 121 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 121 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 121 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 121 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 121 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 121 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 121 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedegreeofestablishment' => { 121 => [\'Occurrence','OccurrenceDegreeOfEstablishment'] },
	'occurrencedetails' => { 121 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 121 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 121 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrencegeoreferenceverificationstatus' => { 121 => [\'Occurrence','OccurrenceGeoreferenceVerificationStatus'] },
	'occurrenceid' => { 121 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 121 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 121 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 121 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 121 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 121 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 121 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepathway' => { 121 => [\'Occurrence','OccurrencePathway'] },
	'occurrencepreparations' => { 121 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 121 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 121 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordedbyid' => { 121 => [\'Occurrence','OccurrenceRecordedByID'] },
	'occurrencerecordnumber' => { 121 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 121 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 121 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 121 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 121 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 511 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 511 => [\'OECF','OECFNames'] },
	'oecfrows' => { 511 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 511 => [\'OECF','OECFValues'] },
	'offsaledate' => { 524 => 'offSaleDate' },
	'offsaledatea-platform' => { 524 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 524 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 141 => 0x190a },
	'offsethdr' => { 516 => 'OffsetHDR' },
	'offsetschema' => { 122 => 0xea1d },
	'offsetsdr' => { 516 => 'OffsetSDR' },
	'offsettime' => { 122 => 0x9010 },
	'offsettimedigitized' => { 122 => 0x9012 },
	'offsettimeoriginal' => { 122 => 0x9011 },
	'oismode' => { 1 => 0xf },
	'okbutton' => { 311 => '15.1', 316 => '16.1' },
	'oldsubfiletype' => { 122 => 0xff },
	'olympusimageheight' => { 326 => 0x102f },
	'olympusimagewidth' => { 326 => 0x102e },
	'omenatcapturestrength' => { 141 => 0xa60 },
	'omenautostrength' => { 141 => 0xa5f },
	'omenearlystrength' => { 141 => 0xa5e },
	'omenfocallengthlimit' => { 141 => 0xa62 },
	'omeninitialipfstrength' => { 141 => 0xa5d },
	'omensurfaceindex' => { 141 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 326 => 0x302 },
	'onsaledate' => { 524 => 'onSaleDate' },
	'onsaledatea-platform' => { 524 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 524 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 524 => 'onSaleDay' },
	'onsaledaya-platform' => { 524 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 524 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 122 => 0xc740 },
	'opcodelist2' => { 122 => 0xc741 },
	'opcodelist3' => { 122 => 0xc74e },
	'opticalzoom' => { 145 => 0xfa3d, 147 => [0x6006,0xf006], 148 => 0x1000, 149 => 0xf, 152 => 0x1e, 154 => 0x20, 155 => 0x1c, 166 => 'OpticalZoom' },
	'opticalzoomcode' => { 79 => 0xa },
	'opticalzoommode' => { 344 => 0x34 },
	'opticalzoomon' => { 420 => 0x219 },
	'optionenddate' => { 527 => 'optionEndDate' },
	'opto-electricconvfactor' => { 511 => 'OECF' },
	'orangehsl' => { 106 => 0x20911 },
	'ordernumber' => { 130 => 0x8002 },
	'organisationinimagecode' => { 519 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 519 => 'OrganisationInImageName' },
	'organism' => { 121 => 'Organism' },
	'organismassociatedoccurrences' => { 121 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 121 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 121 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 121 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 121 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 121 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 121 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 524 => 'organization' },
	'orientation' => { 122 => 0x112, 349 => 0x112, 523 => 'orientation', 530 => 'Orientation' },
	'orientation2' => { 449 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 87 => 0x516 },
	'originalalbumtitle' => { 182 => 'WM/OriginalAlbumTitle' },
	'originalartist' => { 182 => 'WM/OriginalArtist', 396 => "\xa9ope" },
	'originalbestqualitysize' => { 122 => 0xc792 },
	'originalcreatedatetime' => { 495 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 117 => 'Canon-OriginalDecisionData' },
	'originaldecisiondataoffset' => { 66 => 0x83 },
	'originaldefaultcropsize' => { 122 => 0xc793 },
	'originaldefaultfinalsize' => { 122 => 0xc791 },
	'originaldirectory' => { 341 => 0x408 },
	'originaldocumentid' => { 535 => 'OriginalDocumentID' },
	'originalfilename' => { 100 => 0x816, 141 => 0x3e9, 153 => 0x20, 341 => 0x407, 495 => 'OriginalFilename' },
	'originalimagehash' => { 485 => 'OriginalImageHash' },
	'originalimagehashtype' => { 485 => 'OriginalImageHashType' },
	'originalimageheight' => { 81 => 0xc, 126 => 0x1 },
	'originalimagemd5' => { 485 => 'OriginalImageMD5' },
	'originalimagesize' => { 165 => 'OriginalImageSize' },
	'originalimagewidth' => { 81 => 0xb, 126 => 0x0 },
	'originallyricist' => { 182 => 'WM/OriginalLyricist' },
	'originalrawfiledata' => { 122 => 0xc68c },
	'originalrawfiledigest' => { 122 => 0xc71d },
	'originalrawfilename' => { 122 => 0xc68b },
	'originaltransmissionreference' => { 134 => 0x67 },
	'originatingprogram' => { 134 => 0x41, 500 => 'OriginatingProgram' },
	'originplatform' => { 524 => 'originPlatform' },
	'os' => { 509 => 'os' },
	'otherconditions' => { 331 => 'OtherConditions' },
	'otherconstraints' => { 331 => 'OtherConstraints' },
	'otherimage' => { 117 => 'Exif-OtherImage' },
	'otherimageinfo' => { 331 => 'OtherImageInfo' },
	'otherimagelength' => { 122 => 0x202 },
	'otherimagestart' => { 122 => 0x201 },
	'otherlicensedocuments' => { 331 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 331 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 331 => 'OtherLicenseRequirements' },
	'outcue' => { 534 => 'outCue' },
	'outcuescale' => { 534 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 534 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 203 => 0x3 },
	'outputimagewidth' => { 203 => 0x2 },
	'outputlut' => { 344 => 0xa7 },
	'outputprofile' => { 141 => 0x138b },
	'outputresolution' => { 203 => 0x4 },
	'overclockcols' => { 141 => 0x189c },
	'overclockrows' => { 141 => 0x18c4 },
	'overridelookvignette' => { 505 => 'OverrideLookVignette', 507 => 'OverrideLookVignette' },
	'owner' => { 396 => 'ownr', 538 => 'Owner' },
	'ownerid' => { 134 => 0xbc },
	'ownername' => { 15 => 0x10f, 66 => 0x9, 100 => 0x810, 122 => [0xa430,0xfde8], 159 => 'OwnerName', 502 => 'OwnerName', 512 => 'CameraOwnerName' },
	'padding' => { 122 => 0xea1c },
	'pagecount' => { 524 => 'pageCount' },
	'pageimage' => { 532 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 532 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 532 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 532 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 532 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 532 => 'PageInfo' },
	'pagename' => { 122 => 0x11d },
	'pagenumber' => { 122 => 0x129 },
	'pageprogressiondirection' => { 524 => 'pageProgressionDirection' },
	'pagerange' => { 524 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 505 => 'PaintBasedCorrections', 507 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionblacks2012' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'] },
	'paintcorrectionbrightness' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectioncorrectionname' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'] },
	'paintcorrectioncorrectionsyncid' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'] },
	'paintcorrectiondefringe' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectiondehaze' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'] },
	'paintcorrectionexposure' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'] },
	'paintcorrectionluminancenoise' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskinputdigest' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'] },
	'paintcorrectionmaskleft' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmaskactive' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'] },
	'paintcorrectionmaskmaskblendmode' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'paintcorrectionmaskmaskdigest' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'] },
	'paintcorrectionmaskmaskinverted' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'] },
	'paintcorrectionmaskmaskname' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'] },
	'paintcorrectionmaskmasks' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'] },
	'paintcorrectionmaskmasksalpha' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'paintcorrectionmaskmasksangle' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'] },
	'paintcorrectionmaskmasksbottom' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'] },
	'paintcorrectionmaskmaskscentervalue' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'paintcorrectionmaskmaskscenterweight' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'paintcorrectionmaskmasksdabs' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'] },
	'paintcorrectionmaskmasksfeather' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'] },
	'paintcorrectionmaskmasksflipped' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'paintcorrectionmaskmasksflow' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'] },
	'paintcorrectionmaskmasksfullx' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'] },
	'paintcorrectionmaskmasksfully' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'] },
	'paintcorrectionmaskmasksinputdigest' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'paintcorrectionmaskmasksleft' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'] },
	'paintcorrectionmaskmasksmaskactive' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'paintcorrectionmaskmasksmaskblendmode' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'paintcorrectionmaskmasksmaskdigest' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'paintcorrectionmaskmasksmaskinverted' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'paintcorrectionmaskmasksmaskname' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'paintcorrectionmaskmasksmasksubtype' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'paintcorrectionmaskmasksmasksyncid' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'paintcorrectionmaskmasksmaskversion' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'paintcorrectionmaskmasksmidpoint' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'paintcorrectionmaskmasksorigin' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'paintcorrectionmaskmasksperimetervalue' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'paintcorrectionmaskmasksradius' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'] },
	'paintcorrectionmaskmasksreferencepoint' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'paintcorrectionmaskmasksright' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'] },
	'paintcorrectionmaskmasksroundness' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'paintcorrectionmaskmaskssizex' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'paintcorrectionmaskmaskssizey' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'paintcorrectionmaskmaskstop' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'] },
	'paintcorrectionmaskmasksubtype' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'] },
	'paintcorrectionmaskmasksvalue' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'paintcorrectionmaskmasksversion' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'] },
	'paintcorrectionmaskmaskswhat' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'] },
	'paintcorrectionmaskmaskswholeimagearea' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'paintcorrectionmaskmasksx' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'] },
	'paintcorrectionmaskmasksy' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'] },
	'paintcorrectionmaskmasksyncid' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'paintcorrectionmaskmaskszerox' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'paintcorrectionmaskmaskszeroy' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'paintcorrectionmaskmaskversion' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'] },
	'paintcorrectionmaskmidpoint' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskorigin' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'] },
	'paintcorrectionmaskperimetervalue' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskrange' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'paintcorrectionmaskrangeareamodels' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'paintcorrectionmaskrangeareamodelscolorsampleinfo' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionmaskrangeareamodelscomponents' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionmaskrangecoloramount' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'paintcorrectionmaskrangedepthfeather' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionmaskrangedepthmax' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'paintcorrectionmaskrangedepthmin' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'paintcorrectionmaskrangeinvert' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'paintcorrectionmaskrangelumfeather' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'paintcorrectionmaskrangeluminancedepthsampleinfo' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionmaskrangelummax' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'paintcorrectionmaskrangelummin' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'paintcorrectionmaskrangelumrange' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'paintcorrectionmaskrangesampletype' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'paintcorrectionmaskrangetype' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'paintcorrectionmaskrangeversion' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'paintcorrectionmaskreferencepoint' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'] },
	'paintcorrectionmaskright' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskwholeimagearea' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'paintcorrectionmaskx' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionrangemask' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'] },
	'paintcorrectionrangemaskareamodels' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'paintcorrectionrangemaskareamodelscolorsampleinfo' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionrangemaskareamodelscomponents' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionrangemaskcoloramount' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'paintcorrectionrangemaskdepthfeather' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionrangemaskdepthmax' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'paintcorrectionrangemaskdepthmin' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'paintcorrectionrangemaskinvert' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'] },
	'paintcorrectionrangemasklumfeather' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'paintcorrectionrangemaskluminancedepthsampleinfo' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionrangemasklummax' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'paintcorrectionrangemasklummin' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'paintcorrectionrangemasklumrange' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'paintcorrectionrangemasksampletype' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'paintcorrectionrangemasktype' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'] },
	'paintcorrectionrangemaskversion' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'] },
	'paintcorrectionsaturation' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'] },
	'paintcorrectionshadows2012' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontexture' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'] },
	'paintcorrectiontint' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectiontoninghue' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectiontoningsaturation' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionwhat' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'paintcorrectionwhites2012' => { 505 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'], 507 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'] },
	'panasonicdatetime' => { 347 => 0x0 },
	'panasonicexifversion' => { 344 => 0x26 },
	'panasonicimageheight' => { 344 => 0x4c },
	'panasonicimagewidth' => { 344 => 0x4b },
	'panasonicrawversion' => { 349 => 0x1 },
	'panasonictitle' => { 122 => 0xc6d2 },
	'panasonictitle2' => { 122 => 0xc6d3 },
	'panoramaangle' => { 130 => 0x1153 },
	'panoramacropbottom' => { 450 => 0x7 },
	'panoramacropleft' => { 450 => 0x4 },
	'panoramacropright' => { 450 => 0x6 },
	'panoramacroptop' => { 450 => 0x5 },
	'panoramadirection' => { 74 => 0x5, 130 => 0x1154, 450 => 0x3 },
	'panoramaframeheight' => { 450 => 0x9 },
	'panoramaframenumber' => { 74 => 0x2 },
	'panoramaframewidth' => { 450 => 0x8 },
	'panoramafullheight' => { 450 => 0x2 },
	'panoramafullwidth' => { 450 => 0x1 },
	'panoramamode' => { 143 => 0x3c, 321 => 0x601 },
	'panoramasize3d' => { 433 => 0x38 },
	'panoramasourceheight' => { 450 => 0xb },
	'panoramasourcewidth' => { 450 => 0xa },
	'panoramicstitchcameramotion' => { 179 => 'PanoramicStitchCameraMotion', 180 => 0x1 },
	'panoramicstitchmaptype' => { 179 => 'PanoramicStitchMapType', 180 => 0x2 },
	'panoramicstitchphi0' => { 179 => 'PanoramicStitchPhi0', 180 => 0x5 },
	'panoramicstitchphi1' => { 179 => 'PanoramicStitchPhi1', 180 => 0x6 },
	'panoramicstitchtheta0' => { 179 => 'PanoramicStitchTheta0', 180 => 0x3 },
	'panoramicstitchtheta1' => { 179 => 'PanoramicStitchTheta1', 180 => 0x4 },
	'panoramicstitchversion' => { 180 => 0x0 },
	'pantry' => { 535 => 'Pantry' },
	'pantryinstanceid' => { 535 => [\'Pantry','PantryInstanceID'] },
	'parallax' => { 130 => 0xb211, 320 => 0x28 },
	'parametricdarks' => { 505 => 'ParametricDarks', 507 => 'ParametricDarks' },
	'parametrichighlights' => { 505 => 'ParametricHighlights', 507 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 505 => 'ParametricHighlightSplit', 507 => 'ParametricHighlightSplit' },
	'parametriclights' => { 505 => 'ParametricLights', 507 => 'ParametricLights' },
	'parametricmidtonesplit' => { 505 => 'ParametricMidtoneSplit', 507 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 505 => 'ParametricShadows', 507 => 'ParametricShadows' },
	'parametricshadowsplit' => { 505 => 'ParametricShadowSplit', 507 => 'ParametricShadowSplit' },
	'parentalrating' => { 182 => 'WM/ParentalRating' },
	'parentid' => { 519 => 'parentId' },
	'parentmediaeventid' => { 495 => 'ParentMediaEventID' },
	'parentmeid' => { 495 => 'ParentMEID' },
	'parentproductid' => { 396 => '@ppi' },
	'parentreference1' => { 517 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 517 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 517 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 517 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 517 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 517 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentshorttitle' => { 396 => '@PST' },
	'parenttitle' => { 396 => '@pti' },
	'partialactivecols1' => { 141 => 0x17e8 },
	'partialactivecols2' => { 141 => 0x17f2 },
	'partialactiverows1' => { 141 => 0x17fc },
	'partialactiverows2' => { 141 => 0x1806 },
	'partofcompilation' => { 534 => 'partOfCompilation' },
	'patientbirthdate' => { 483 => 'PatientDOB' },
	'patientid' => { 483 => 'PatientID' },
	'patientname' => { 483 => 'PatientName' },
	'patientsex' => { 483 => 'PatientSex' },
	'patternareaheight' => { 141 => 0x963 },
	'patternareawidth' => { 141 => 0x962 },
	'patterncorrectionfactorscale' => { 141 => 0x969 },
	'patterncropcols1' => { 141 => 0x96c },
	'patterncropcols2' => { 141 => 0x96d },
	'patterncroprows1' => { 141 => 0x96a },
	'patterncroprows2' => { 141 => 0x96b },
	'patternimagerheight' => { 141 => 0x961 },
	'patternimagerwidth' => { 141 => 0x960 },
	'patternx' => { 141 => 0x966 },
	'patterny' => { 141 => 0x967 },
	'pdfversion' => { 521 => 'PDFVersion' },
	'pentaximagesize' => { 379 => 0x9 },
	'pentaxmodelid' => { 359 => 0x0, 379 => 0x5 },
	'pentaxmodeltype' => { 379 => 0x1 },
	'pentaxversion' => { 379 => 0x0 },
	'people' => { 486 => 'People', 498 => 'People' },
	'perchannelblacklevel' => { 43 => 0x157, 44 => 0x16b, 46 => 0xc4, 47 => [0x2b4,0x2cb,0x2cf], 48 => [0x108,0x14d], 49 => 0x1df, 50 => [0x1f8,0x2d8], 51 => [0x22c,0x30a], 52 => 0x149 },
	'performer' => { 396 => 'perf', 404 => 'perf' },
	'performerkeywords' => { 404 => "\xa9prk" },
	'performers' => { 404 => "\xa9prf" },
	'performerurl' => { 404 => "\xa9prl" },
	'period' => { 182 => 'WM/Period' },
	'peripheralillumcentralradius' => { 481 => 0x8030 },
	'peripheralillumcentralvalue' => { 481 => 0x8031 },
	'peripheralillumination' => { 106 => 0x20702, 112 => 0x68 },
	'peripheralilluminationcorr' => { 64 => 0x1, 369 => 0x2 },
	'peripheralilluminationon' => { 106 => '0x20702.0', 112 => 0x64 },
	'peripheralillumperiphvalue' => { 481 => 0x8032 },
	'peripherallighting' => { 81 => 0x2, 130 => 0x3804 },
	'peripherallightingsetting' => { 82 => 0x5 },
	'peripherallightingvalue' => { 81 => 0x6 },
	'permissions' => { 527 => 'permissions' },
	'permits' => { 503 => 'permits' },
	'person' => { 524 => 'person' },
	'personality' => { 495 => 'Personality' },
	'personheard' => { 519 => 'PersonHeard' },
	'personheardidentifier' => { 519 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 519 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 519 => 'PersonInImage' },
	'personinimagecharacteristic' => { 519 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 519 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 519 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 519 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 519 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 519 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 519 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 519 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 519 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 505 => 'PerspectiveAspect', 507 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 505 => 'PerspectiveHorizontal', 507 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 505 => 'PerspectiveRotate', 507 => 'PerspectiveRotate' },
	'perspectivescale' => { 505 => 'PerspectiveScale', 507 => 'PerspectiveScale' },
	'perspectiveupright' => { 505 => 'PerspectiveUpright', 507 => 'PerspectiveUpright' },
	'perspectivevertical' => { 505 => 'PerspectiveVertical', 507 => 'PerspectiveVertical' },
	'perspectivex' => { 505 => 'PerspectiveX', 507 => 'PerspectiveX' },
	'perspectivey' => { 505 => 'PerspectiveY', 507 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 95 => 0x1 },
	'pf10retainprogramshift' => { 95 => 0xb },
	'pf13drivepriority' => { 95 => 0xe },
	'pf14disablefocussearch' => { 95 => 0xf },
	'pf15disableafassistbeam' => { 95 => 0x10 },
	'pf16autofocuspointshoot' => { 95 => 0x11 },
	'pf17disableafpointsel' => { 95 => 0x12 },
	'pf18enableautoafpointsel' => { 95 => 0x13 },
	'pf19continuousshootspeed' => { 95 => 0x14 },
	'pf19shootingspeedhigh' => { 94 => 0xa },
	'pf19shootingspeedlow' => { 94 => 0x9 },
	'pf1disableshootingmodes' => { 95 => 0x2 },
	'pf1value' => { 94 => 0x1 },
	'pf20limitcontinousshots' => { 95 => 0x15 },
	'pf20maxcontinousshots' => { 94 => 0xb },
	'pf21enablequietoperation' => { 95 => 0x16 },
	'pf23felocktime' => { 94 => 0xd },
	'pf23postreleasetime' => { 94 => 0xe },
	'pf23settimerlengths' => { 95 => 0x18 },
	'pf23shutterbuttontime' => { 94 => 0xc },
	'pf24lightlcdduringbulb' => { 95 => 0x19 },
	'pf25aemode' => { 94 => 0xf },
	'pf25afmode' => { 94 => 0x12 },
	'pf25afpointsel' => { 94 => 0x13 },
	'pf25colormatrix' => { 94 => 0x17 },
	'pf25defaultclearsettings' => { 95 => 0x1a },
	'pf25drivemode' => { 94 => 0x11 },
	'pf25imagesize' => { 94 => 0x14 },
	'pf25meteringmode' => { 94 => 0x10 },
	'pf25parameters' => { 94 => 0x16 },
	'pf25wbmode' => { 94 => 0x15 },
	'pf26shortenreleaselag' => { 95 => 0x1b },
	'pf27reversedialrotation' => { 95 => 0x1c },
	'pf27value' => { 94 => 0x18 },
	'pf28noquickdialexpcomp' => { 95 => 0x1d },
	'pf29quickdialswitchoff' => { 95 => 0x1e },
	'pf2disablemeteringmodes' => { 95 => 0x3 },
	'pf2value' => { 94 => 0x2 },
	'pf30enlargementmode' => { 95 => 0x1f },
	'pf31originaldecisiondata' => { 95 => 0x20 },
	'pf3manualexposuremetering' => { 95 => 0x4 },
	'pf3value' => { 94 => 0x3 },
	'pf4exposuretimelimits' => { 95 => 0x5 },
	'pf4exposuretimemax' => { 94 => 0x5 },
	'pf4exposuretimemin' => { 94 => 0x4 },
	'pf5aperturelimits' => { 95 => 0x6 },
	'pf5aperturemax' => { 94 => 0x7 },
	'pf5aperturemin' => { 94 => 0x6 },
	'pf6presetshootingmodes' => { 95 => 0x7 },
	'pf7bracketcontinuousshoot' => { 95 => 0x8 },
	'pf8bracketshots' => { 94 => 0x8 },
	'pf8setbracketshots' => { 95 => 0x9 },
	'pf9changebracketsequence' => { 95 => 0xa },
	'phasedetectaf' => { 196 => 0x6 },
	'phonenumber' => { 160 => 'Phone' },
	'photoeffect' => { 36 => 0x28 },
	'photoeffecthistoryxml' => { 294 => 0xe9651831 },
	'photoeffects' => { 294 => 0xab5eca5e },
	'photoeffectsblue' => { 296 => 0x8 },
	'photoeffectsgreen' => { 296 => 0x6 },
	'photoeffectsred' => { 296 => 0x4 },
	'photoeffectstype' => { 296 => 0x0 },
	'photographer' => { 122 => 0xa437 },
	'photographicsensitivity' => { 512 => 'PhotographicSensitivity' },
	'photoidentifier' => { 1 => 0x2b },
	'photoinfoplayback' => { 301 => '17.6', 310 => '33.6' },
	'photometricinterpretation' => { 122 => 0x106, 530 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 243 => 0x11e, 244 => 0x112, 245 => 0x122, 246 => 0x122, 247 => 0x24, 265 => 0x0 },
	'photoshootingmenubankimagearea' => { 241 => 0x6dd, 243 => 0x144, 244 => 0x134, 245 => 0x148, 246 => 0x148, 265 => '7.1' },
	'photoshopbgrthumbnail' => { 393 => 0x409 },
	'photoshopquality' => { 392 => 0x0 },
	'photoshopthumbnail' => { 393 => 0x40c },
	'photostyle' => { 344 => 0x89 },
	'picasawebgphotoid' => { 510 => 'picasawebGPhotoId' },
	'picklabel' => { 510 => 'PickLabel' },
	'pictinfo' => { 420 => 0x208 },
	'picturecontrol' => { 294 => 0xe2173c47 },
	'picturecontrolactive' => { 297 => 0x0 },
	'picturecontroladjust' => { 253 => 0x30, 254 => 0x30, 255 => 0x36 },
	'picturecontrolbase' => { 253 => 0x18, 254 => 0x18, 255 => 0x1c },
	'picturecontroldata' => { 238 => [0xbd,0x23] },
	'picturecontrolmode' => { 297 => 0x13 },
	'picturecontrolname' => { 253 => 0x4, 254 => 0x4, 255 => 0x8 },
	'picturecontrolquickadjust' => { 253 => 0x31, 254 => 0x31, 255 => 0x37 },
	'pictureeffect' => { 444 => 0x200e },
	'pictureeffect2' => { 453 => 0x1163, 454 => 0x1167, 455 => 0x1143, 456 => 0x11bf, 457 => 0x119b, 458 => 0x1053, 459 => 0x24b, 460 => 0x24b, 461 => 0x23c, 476 => 0x46 },
	'picturefinish' => { 185 => 0x71 },
	'picturemode' => { 130 => 0x1031, 321 => 0x520, 379 => [0xb,0x33], 421 => 0x3d },
	'picturemode2' => { 360 => 0x0 },
	'picturemodebwfilter' => { 321 => 0x525 },
	'picturemodecontrast' => { 321 => 0x523 },
	'picturemodeeffect' => { 321 => 0x52d },
	'picturemodehue' => { 321 => 0x522 },
	'picturemodesaturation' => { 321 => 0x521 },
	'picturemodesharpness' => { 321 => 0x524 },
	'picturemodetone' => { 321 => 0x526 },
	'pictureprofile' => { 453 => [0x115e,0x115f], 454 => [0x1162,0x1163], 455 => [0x113e,0x113f], 456 => [0x11ba,0x11bb], 457 => [0x1196,0x1197], 458 => [0x104e,0x104f], 459 => [0x246,0x247], 460 => [0x246,0x247], 461 => [0x237,0x238] },
	'picturestyle' => { 8 => [0x4b,0x51], 9 => 0xf4, 10 => 0x6c, 11 => 0x86, 12 => 0x73, 16 => 0xab, 17 => 0xa7, 18 => 0xb0, 19 => 0x6c, 20 => 0xa7, 21 => 0xf4, 22 => 0xb3, 24 => 0xf4, 25 => 0xfa, 27 => 0x169, 76 => 0xa, 106 => 0x20301, 112 => 0x2 },
	'picturestylepc' => { 66 => 0x4009 },
	'picturestyleuserdef' => { 66 => 0x4008 },
	'picturewizard' => { 418 => 0x21 },
	'picturewizardcolor' => { 417 => 0x1 },
	'picturewizardcontrast' => { 417 => 0x4 },
	'picturewizardmode' => { 417 => 0x0 },
	'picturewizardsaturation' => { 417 => 0x2 },
	'picturewizardsharpness' => { 417 => 0x3 },
	'pipelineversion' => { 179 => 'PipelineVersion' },
	'pitch' => { 118 => 0x6, 302 => '4.1', 314 => '4.1', 404 => ['ptch',"\xa9fpt"] },
	'pitchangle' => { 251 => 0x4, 321 => 0x904, 344 => 0x91, 378 => 0x2, 416 => 0x1 },
	'pitchshift' => { 398 => 'player.movie.audio.pitchshift' },
	'pixelaspectratio' => { 397 => 'pasp' },
	'pixelclockfrequency' => { 141 => 0x40b },
	'pixelcorrectionoffset' => { 141 => 0x972 },
	'pixelcorrectionscale' => { 141 => 0x971 },
	'pixelscale' => { 122 => 0x830e },
	'pixelshiftinfo' => { 444 => 0x202f },
	'pixelshiftoffset' => { 130 => 0x1106 },
	'pixelshiftresolution' => { 380 => 0x0 },
	'pixelshiftshots' => { 130 => 0x1105 },
	'pixelsperunitx' => { 333 => 0x0 },
	'pixelsperunity' => { 333 => 0x4 },
	'pixelunits' => { 333 => 0x8 },
	'planarconfiguration' => { 122 => 0x11c, 530 => 'PlanarConfiguration' },
	'plane' => { 484 => [\'Planes','PlanesPlane'] },
	'planeboundary' => { 484 => [\'Planes','PlanesPlaneBoundary'] },
	'planeboundaryvertexcount' => { 484 => [\'Planes','PlanesPlaneBoundaryVertexCount'] },
	'planeextentx' => { 484 => [\'Planes','PlanesPlaneExtentX'] },
	'planeextentz' => { 484 => [\'Planes','PlanesPlaneExtentZ'] },
	'planepose' => { 484 => [\'Planes','PlanesPlanePose'] },
	'planeposepositionx' => { 484 => [\'Planes','PlanesPlanePosePositionX'] },
	'planeposepositiony' => { 484 => [\'Planes','PlanesPlanePosePositionY'] },
	'planeposepositionz' => { 484 => [\'Planes','PlanesPlanePosePositionZ'] },
	'planeposerotationw' => { 484 => [\'Planes','PlanesPlanePoseRotationW'] },
	'planeposerotationx' => { 484 => [\'Planes','PlanesPlanePoseRotationX'] },
	'planeposerotationy' => { 484 => [\'Planes','PlanesPlanePoseRotationY'] },
	'planeposerotationz' => { 484 => [\'Planes','PlanesPlanePoseRotationZ'] },
	'planeposetimestamp' => { 484 => [\'Planes','PlanesPlanePoseTimestamp'] },
	'planes' => { 484 => 'Planes' },
	'planningref' => { 519 => 'PlanningRef' },
	'planningrefidentifier' => { 519 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 519 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 519 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 539 => 'PlateNames' },
	'platform' => { 524 => 'platform' },
	'playallframes' => { 404 => 'AllF' },
	'playbackbutton' => { 246 => 0x808 },
	'playbackbuttonplaybackmode' => { 246 => 0x814 },
	'playbackflickdown' => { 317 => 0x159, 318 => 0x159, 319 => 0x171 },
	'playbackflickup' => { 317 => 0x155, 318 => 0x155, 319 => 0x16d },
	'playbackmenustime' => { 306 => '20.1', 307 => '21.1', 308 => '21.1' },
	'playbackmonitorofftime' => { 301 => '25.2', 302 => '36.1', 304 => '36.1', 305 => '36.1', 309 => '35.1', 310 => '8.1', 311 => '35.1', 314 => '36.1', 315 => '36.1', 316 => '21.1', 317 => 0x33, 318 => 0x33, 319 => 0x33 },
	'playbackzoom' => { 302 => '37.1' },
	'playdisplay' => { 187 => 0x4e },
	'playerversion' => { 398 => 'player.version' },
	'playgap' => { 396 => 'pgap' },
	'playmode' => { 404 => 'SDLN' },
	'playselection' => { 404 => 'SelO' },
	'plusversion' => { 331 => 'Version' },
	'pmversion' => { 391 => 'PMVersion' },
	'pngwarning' => { 334 => 'Warning' },
	'podcast' => { 396 => 'pcst' },
	'podcasturl' => { 396 => 'purl' },
	'poilevel' => { 237 => 0x8 },
	'portraitimpressionbalance' => { 243 => 0x26e, 256 => 0xa0 },
	'portraitnote' => { 488 => 'PortraitNote' },
	'portraitoutputhighlightpoint' => { 112 => 0x1d },
	'portraitoutputshadowpoint' => { 112 => 0x1e },
	'portraitrawcolortone' => { 112 => 0x16 },
	'portraitrawcontrast' => { 112 => 0x18 },
	'portraitrawhighlight' => { 112 => 0x76 },
	'portraitrawhighlightpoint' => { 112 => 0x1b },
	'portraitrawlinear' => { 112 => 0x19 },
	'portraitrawsaturation' => { 112 => 0x17 },
	'portraitrawshadow' => { 112 => 0x7f },
	'portraitrawshadowpoint' => { 112 => 0x1c },
	'portraitrawsharpness' => { 112 => 0x1a },
	'portraitrefiner' => { 116 => 0x302b },
	'portraitrequest' => { 488 => 'PortraitRequest' },
	'portraitunsharpmaskfineness' => { 112 => 0x9a },
	'portraitunsharpmaskstrength' => { 112 => 0x98 },
	'portraitunsharpmaskthreshold' => { 112 => 0x9c },
	'portraitversion' => { 488 => 'PortraitVersion' },
	'pose' => { 484 => 'Pose' },
	'poseheadingdegrees' => { 493 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 493 => 'PosePitchDegrees' },
	'posepositionx' => { 484 => [\'Pose','PosePositionX'] },
	'posepositiony' => { 484 => [\'Pose','PosePositionY'] },
	'posepositionz' => { 484 => [\'Pose','PosePositionZ'] },
	'poserolldegrees' => { 493 => 'PoseRollDegrees' },
	'poserotationw' => { 484 => [\'Pose','PoseRotationW'] },
	'poserotationx' => { 484 => [\'Pose','PoseRotationX'] },
	'poserotationy' => { 484 => [\'Pose','PoseRotationY'] },
	'poserotationz' => { 484 => [\'Pose','PoseRotationZ'] },
	'posetimestamp' => { 484 => [\'Pose','PoseTimestamp'] },
	'positiondescriptor' => { 523 => 'positionDescriptor' },
	'postalcode' => { 164 => 'PostalCode' },
	'postcropvignetteamount' => { 505 => 'PostCropVignetteAmount', 507 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 505 => 'PostCropVignetteFeather', 507 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 505 => 'PostCropVignetteHighlightContrast', 507 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 505 => 'PostCropVignetteMidpoint', 507 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 505 => 'PostCropVignetteRoundness', 507 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 505 => 'PostCropVignetteStyle', 507 => 'PostCropVignetteStyle' },
	'postfocusmerging' => { 344 => 0xbf },
	'postreleaseburstlength' => { 245 => 0x714, 246 => 0x784, 317 => 0x289 },
	'potentialface1position' => { 441 => 0xb },
	'potentialface2position' => { 441 => 0x15 },
	'potentialface3position' => { 441 => 0x1f },
	'potentialface4position' => { 441 => 0x29 },
	'potentialface5position' => { 441 => 0x33 },
	'potentialface6position' => { 441 => 0x3d },
	'potentialface7position' => { 441 => 0x47 },
	'potentialface8position' => { 441 => 0x51 },
	'powersource' => { 358 => '0.1' },
	'poweruptime' => { 238 => 0xb6 },
	'preaf' => { 129 => '0.2' },
	'precaptureframes' => { 326 => 0x300 },
	'predictor' => { 122 => 0x13d },
	'preflashreturnstrength' => { 273 => 0x28a },
	'prefs' => { 134 => 0xdd, 391 => 'Prefs' },
	'prereadfastresetcount' => { 141 => 0x187e },
	'prereleaseburstlength' => { 245 => 0x712, 246 => 0x782, 317 => 0x287 },
	'preservedfilename' => { 535 => 'PreservedFileName' },
	'preservedspecimen' => { 121 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 121 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presettype' => { 505 => 'PresetType', 507 => 'PresetType' },
	'presetwhitebalance' => { 187 => 0x24, 481 => 0x8002 },
	'presetwhitebalanceadj' => { 481 => 0x8014 },
	'pressure' => { 122 => 0x9402, 512 => 'Pressure' },
	'previewapplicationname' => { 122 => 0xc716 },
	'previewapplicationversion' => { 122 => 0xc717 },
	'previewbutton' => { 301 => ['14.1','15.1'], 302 => '15.1', 304 => '15.1', 305 => '15.1', 310 => '29.1', 311 => '14.1', 314 => '15.1', 315 => '15.1' },
	'previewbuttonplusdials' => { 301 => ['14.2','15.2'], 302 => '15.2', 304 => '43.1', 305 => '43.1', 310 => '31.2', 314 => '43.1', 315 => '43.1' },
	'previewcolorspace' => { 122 => 0xc71a },
	'previewcropbottom' => { 390 => 0xef },
	'previewcropleft' => { 390 => 0xec },
	'previewcropright' => { 390 => 0xee },
	'previewcroptop' => { 390 => 0xed },
	'previewdate' => { 402 => 0x0 },
	'previewdatetime' => { 122 => 0xc71b },
	'previewimage' => { 116 => 0x2000, 117 => 'Exif-PreviewImage', 123 => 'PreviewImage', 125 => 0x4, 169 => 'data', 189 => 0x81, 326 => 0x280, 342 => 0x300, 404 => 'mcvr', 444 => 0x2001 },
	'previewimageborders' => { 379 => 0x3e },
	'previewimageheight' => { 75 => 0x4, 145 => 0xfa58 },
	'previewimagelength' => { 75 => 0x2, 116 => 0x3, 122 => [0x117,0x202], 189 => 0x89, 257 => 0x202, 321 => 0x102, 326 => 0x1037, 379 => 0x3, 410 => 0x1e, 415 => 0x3, 421 => [0x1b,0x1d], 434 => 0x202 },
	'previewimagename' => { 169 => '1Name' },
	'previewimagesize' => { 116 => 0x2, 150 => 0x2, 169 => 'ImageSize', 379 => 0x2, 421 => [0x1c,0x1e], 444 => 0xb02c, 481 => 0x9012 },
	'previewimagestart' => { 75 => 0x5, 116 => 0x4, 122 => [0x111,0x201], 189 => 0x88, 257 => 0x201, 321 => 0x101, 326 => 0x1036, 379 => 0x4, 410 => 0x1c, 415 => 0x2, 421 => [0x1a,0x1c], 434 => 0x201 },
	'previewimagetype' => { 169 => '0Type' },
	'previewimagevalid' => { 321 => 0x100, 326 => 0x1035 },
	'previewimagewidth' => { 75 => 0x3, 145 => 0xfa57 },
	'previewquality' => { 75 => 0x1 },
	'previewsettingsdigest' => { 122 => 0xc719 },
	'previewsettingsname' => { 122 => 0xc718 },
	'primaryafpoint' => { 196 => [0x38,0x44,0x7,0x8] },
	'primarychromaticities' => { 122 => 0x13f, 530 => 'PrimaryChromaticities' },
	'primaryftp' => { 495 => 'PrimaryFTP' },
	'primaryslot' => { 247 => 0x25, 265 => 0x2 },
	'printim' => { 122 => 0xc4a5 },
	'prioritysetinawb' => { 444 => 0x202b },
	'prioritysetupshutterrelease' => { 187 => 0x1d, 431 => 0x28 },
	'privatertkinfo' => { 497 => 'privateRTKInfo' },
	'processbordercolsleft' => { 141 => 0xc61 },
	'processbordercolsright' => { 141 => 0xc62 },
	'processborderrowsbottom' => { 141 => 0xc64 },
	'processborderrowstop' => { 141 => 0xc63 },
	'processingsoftware' => { 122 => 0xb },
	'processversion' => { 505 => 'ProcessVersion', 507 => 'ProcessVersion' },
	'producer' => { 182 => 'WM/Producer', 330 => 'Producer', 396 => "\xa9prd", 398 => 'producer', 404 => "\xa9prd", 521 => 'Producer' },
	'producerkeywords' => { 404 => "\xa9pdk" },
	'productcode' => { 524 => 'productCode' },
	'productid' => { 135 => 0x32, 396 => 'prID', 523 => 'productID' },
	'productidtype' => { 523 => 'productIDType' },
	'productinimage' => { 519 => 'ProductInImage' },
	'productinimagedescription' => { 519 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 519 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 519 => [\'ProductInImage','ProductInImageProductName'] },
	'productinimageproductid' => { 519 => [\'ProductInImage','ProductInImageProductId'] },
	'productioncode' => { 359 => 0x2 },
	'productorserviceconstraints' => { 331 => 'ProductOrServiceConstraints' },
	'productversion' => { 396 => 'VERS' },
	'profession' => { 524 => 'profession' },
	'profile' => { 484 => [\'Profiles','ProfilesProfile'] },
	'profilecalibrationsig' => { 122 => 0xc6f4 },
	'profilecameraindices' => { 484 => [\'Profiles','ProfilesProfileCameraIndices'] },
	'profilecopyright' => { 122 => 0xc6fe },
	'profiledynamicrange' => { 122 => 0xcd47 },
	'profileembedpolicy' => { 122 => 0xc6fd },
	'profilegaintablemap' => { 122 => 0xcd2d },
	'profilegaintablemap2' => { 122 => 0xcd40 },
	'profilegroupname' => { 122 => 0xcd48 },
	'profilehuesatmapdata1' => { 122 => 0xc6fa },
	'profilehuesatmapdata2' => { 122 => 0xc6fb },
	'profilehuesatmapdata3' => { 122 => 0xcd39 },
	'profilehuesatmapdims' => { 122 => 0xc6f9 },
	'profilehuesatmapencoding' => { 122 => 0xc7a3 },
	'profilelooktabledata' => { 122 => 0xc726 },
	'profilelooktabledims' => { 122 => 0xc725 },
	'profilelooktableencoding' => { 122 => 0xc7a4 },
	'profilename' => { 122 => 0xc6f8, 332 => 'iCCP-name' },
	'profiles' => { 484 => 'Profiles' },
	'profiletonecurve' => { 122 => 0xc6fc },
	'profiletype' => { 484 => [\'Profiles','ProfilesProfileType'] },
	'programiso' => { 344 => 0x3c },
	'programline' => { 360 => '1.1' },
	'programmode' => { 192 => 0x5 },
	'programshift' => { 238 => 0xd },
	'programversion' => { 134 => 0x46 },
	'prohibits' => { 503 => 'prohibits' },
	'projectiontype' => { 493 => 'ProjectionType', 494 => 'ProjectionType' },
	'projectname' => { 534 => 'projectName' },
	'projectref' => { 534 => 'projectRef' },
	'projectrefpath' => { 534 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 534 => [\'projectRef','projectRefType'] },
	'promotionurl' => { 182 => 'WM/PromotionURL' },
	'propertyreleaseid' => { 331 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 331 => 'PropertyReleaseStatus' },
	'provider' => { 182 => 'WM/Provider' },
	'province-state' => { 134 => 0x5f },
	'publicationdate' => { 524 => 'publicationDate' },
	'publicationdatea-platform' => { 524 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 524 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 524 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 524 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 524 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 519 => 'PublicationEvent' },
	'publicationeventdate' => { 519 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 519 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 519 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 524 => 'publicationName' },
	'publisher' => { 182 => 'WM/Publisher', 396 => "\xa9pub", 398 => 'publisher', 508 => 'publisher' },
	'publishingfrequency' => { 524 => 'publishingFrequency' },
	'pulldown' => { 534 => 'pullDown' },
	'purchasedate' => { 396 => 'purd' },
	'purplehsl' => { 106 => 0x20916 },
	'pxshiftperiphedgenr' => { 481 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 481 => 0x9014 },
	'quality' => { 0 => 0x1, 36 => 0x3, 115 => 0x2, 116 => 0x3002, 130 => 0x1000, 143 => 0x9, 238 => 0x4, 284 => 0x3, 326 => 0x201, 339 => 0x300, 379 => 0x8, 386 => 0x2, 421 => 0x16, 431 => 0x56, 432 => 0x56, 433 => 0xb, 444 => [0x102,0x202e] },
	'quality2' => { 453 => 0x1170, 454 => 0x1174, 455 => 0x1150, 457 => 0x11a8, 458 => 0x1060, 459 => 0x258, 460 => 0x258, 461 => 0x247, 467 => 0x29, 468 => 0x25, 469 => 0x2a },
	'qualitybutton' => { 318 => 0x17d, 319 => 0x195 },
	'qualitybuttonplaybackmode' => { 318 => 0x1bf, 319 => 0x1d7 },
	'qualityhint' => { 1 => 0x1a },
	'qualitymode' => { 116 => 0x8 },
	'quantizationmethod' => { 136 => 0x78 },
	'quickadjust' => { 297 => 0x2a },
	'quickcontroldialinmeter' => { 87 => 0x703 },
	'quickfix' => { 294 => 0x416391c6 },
	'quickshot' => { 420 => 0x213 },
	'quiettime' => { 141 => 0x188a },
	'rads' => { 404 => 'rads' },
	'rangefinder' => { 306 => '4.1', 307 => '5.1', 308 => '5.1' },
	'rangemask' => { 505 => 'RangeMaskMapInfo', 507 => 'RangeMaskMapInfo' },
	'rangemaskmapinfo' => { 505 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'], 507 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'] },
	'rangemaskmapinfolabmax' => { 505 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'], 507 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'] },
	'rangemaskmapinfolabmin' => { 505 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'], 507 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'] },
	'rangemaskmapinfolumeq' => { 505 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'], 507 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'] },
	'rangemaskmapinforgbmax' => { 505 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'], 507 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'] },
	'rangemaskmapinforgbmin' => { 505 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'], 507 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'] },
	'rasterizedcaption' => { 134 => 0x7d },
	'rating' => { 122 => 0x4746, 130 => 0x1431, 390 => 0xdf, 396 => 'rtng', 404 => 'rtng', 444 => 0x2002, 500 => 'rating', 509 => 'rating', 519 => 'Rating', 524 => 'rating', 532 => 'Rating' },
	'ratingpercent' => { 122 => 0x4749, 181 => 'Rating', 396 => 'rate', 532 => 'RatingPercent' },
	'ratingregion' => { 519 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 519 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 519 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 519 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 519 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpslatitude' => { 519 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 519 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 519 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 519 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 519 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 519 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 519 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 519 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 519 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 519 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 519 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 519 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 519 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 85 => 0x8, 189 => 0x109, 360 => 0xd },
	'rawbrightnessadj' => { 106 => 0x20001, 111 => 0x38 },
	'rawburstimagecount' => { 77 => 0x2 },
	'rawburstimagenum' => { 77 => 0x1 },
	'rawcoloradj' => { 111 => 0x2e },
	'rawcropbottom' => { 390 => 0xd4 },
	'rawcropleft' => { 390 => 0xd1 },
	'rawcropright' => { 390 => 0xd3 },
	'rawcroptop' => { 390 => 0xd2 },
	'rawcustomsaturation' => { 111 => 0x30 },
	'rawcustomtone' => { 111 => 0x34 },
	'rawdata' => { 418 => 0xa048 },
	'rawdatabyteorder' => { 418 => 0x40 },
	'rawdatacfapattern' => { 418 => 0x50 },
	'rawdatauniqueid' => { 122 => 0xc65d },
	'rawdepth' => { 191 => 0x10 },
	'rawdevartfilter' => { 328 => 0x121 },
	'rawdevautogradation' => { 328 => 0x119 },
	'rawdevcolorspace' => { 327 => 0x108, 328 => 0x109 },
	'rawdevcontrastvalue' => { 327 => 0x106, 328 => 0x105 },
	'rawdeveditstatus' => { 327 => 0x10b },
	'rawdevelopingsoftware' => { 122 => 0xa43a },
	'rawdevelopmentprocess' => { 379 => 0x62 },
	'rawdevengine' => { 327 => 0x109, 328 => 0x10b },
	'rawdevexposurebiasvalue' => { 327 => 0x100, 328 => 0x100 },
	'rawdevgradation' => { 328 => 0x112 },
	'rawdevgraypoint' => { 327 => 0x103, 328 => 0x104 },
	'rawdevmemorycoloremphasis' => { 327 => 0x105, 328 => 0x108 },
	'rawdevnoisereduction' => { 327 => 0x10a, 328 => 0x10a },
	'rawdevpicturemode' => { 328 => 0x10c },
	'rawdevpm_bwfilter' => { 328 => 0x110 },
	'rawdevpmcontrast' => { 328 => 0x10e },
	'rawdevpmnoisefilter' => { 328 => 0x120 },
	'rawdevpmpicturetone' => { 328 => 0x111 },
	'rawdevpmsaturation' => { 328 => 0x10d },
	'rawdevpmsharpness' => { 328 => 0x10f },
	'rawdevsaturation3' => { 328 => 0x113 },
	'rawdevsaturationemphasis' => { 327 => 0x104, 328 => 0x107 },
	'rawdevsettings' => { 327 => 0x10c },
	'rawdevsharpnessvalue' => { 327 => 0x107, 328 => 0x106 },
	'rawdevversion' => { 327 => 0x0, 328 => 0x0 },
	'rawdevwbfineadjustment' => { 327 => 0x102, 328 => 0x103 },
	'rawdevwhitebalance' => { 328 => 0x101 },
	'rawdevwhitebalancevalue' => { 327 => 0x101, 328 => 0x102 },
	'rawfile' => { 122 => 0xfe4c },
	'rawfilename' => { 505 => 'RawFileName', 507 => 'RawFileName' },
	'rawfiletype' => { 444 => 0x2029 },
	'rawformat' => { 349 => 0x2d, 388 => 0x10e },
	'rawimagecenter' => { 238 => 0x99 },
	'rawimagedigest' => { 122 => 0xc71c },
	'rawimagesize' => { 379 => 0x39 },
	'rawinfoversion' => { 329 => 0x0 },
	'rawjpgheight' => { 102 => 0x4 },
	'rawjpgquality' => { 59 => 0x6, 102 => 0x1 },
	'rawjpgsize' => { 59 => 0x7, 102 => 0x2 },
	'rawjpgwidth' => { 102 => 0x3 },
	'rawmeasuredrggb' => { 45 => 0x26a, 47 => 0x280, 49 => 0x194, 50 => [0x1ad,0x26b] },
	'rawrppused' => { 500 => 'rawrppused' },
	'rawtopreviewgain' => { 122 => 0xc7a8 },
	'readouttypeactual' => { 141 => 0x1903 },
	'readouttyperequested' => { 141 => 0x1902 },
	'reardisplay' => { 301 => '12.3', 302 => '6.2' },
	'recdevice' => { 519 => 'RecDevice' },
	'recdeviceattlensdescription' => { 519 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 519 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 519 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 519 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 519 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 526 => 'recipeEndingPage' },
	'recipepagerange' => { 526 => 'recipePageRange' },
	'recipesource' => { 526 => 'recipeSource' },
	'recipestartingpage' => { 526 => 'recipeStartingPage' },
	'recipetitle' => { 526 => 'recipeTitle' },
	'recognizedface1age' => { 337 => 0x20 },
	'recognizedface1name' => { 337 => 0x4 },
	'recognizedface1position' => { 337 => 0x18 },
	'recognizedface2age' => { 337 => 0x50 },
	'recognizedface2name' => { 337 => 0x34 },
	'recognizedface2position' => { 337 => 0x48 },
	'recognizedface3age' => { 337 => 0x80 },
	'recognizedface3name' => { 337 => 0x64 },
	'recognizedface3position' => { 337 => 0x78 },
	'recognizedfaceflags' => { 344 => 0x63 },
	'recommendedexposureindex' => { 122 => 0x8832, 512 => 'RecommendedExposureIndex' },
	'record' => { 121 => 'Record' },
	'recordbasisofrecord' => { 121 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 121 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 121 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 121 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 121 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 121 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 187 => 0x4d },
	'recorddynamicproperties' => { 121 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 100 => 0x1804 },
	'recordinformationwithheld' => { 121 => [\'Record','RecordInformationWithheld'] },
	'recordingcopyright' => { 404 => "\xa9phg" },
	'recordingformat' => { 411 => 0x1000 },
	'recordingmode' => { 115 => 0x1, 386 => 0x1 },
	'recordinstitutioncode' => { 121 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 121 => [\'Record','RecordInstitutionID'] },
	'recordlabelname' => { 404 => "\xa9lab" },
	'recordlabelurl' => { 404 => "\xa9lal" },
	'recordlocationdata' => { 244 => 0x660, 245 => 0x690, 246 => 0x6f8 },
	'recordmode' => { 36 => 0x9, 116 => 0x3000 },
	'recordownerinstitutioncode' => { 121 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 420 => 0x217 },
	'redbalance' => { 326 => 0x1017, 349 => 0x11, 379 => 0x1c },
	'redcurvelimits' => { 111 => 0x18a },
	'redcurvepoints' => { 110 => 0x2d, 111 => 0x160 },
	'redeyecorrection' => { 298 => 0x0 },
	'redeyeinfo' => { 505 => 'RedEyeInfo', 507 => 'RedEyeInfo' },
	'redeyereduction' => { 187 => 0x41, 431 => 0x6a, 433 => 0x28 },
	'redeyeremoval' => { 344 => 0xb9 },
	'redhsl' => { 106 => 0x20910 },
	'redhue' => { 505 => 'RedHue', 507 => 'RedHue' },
	'redsaturation' => { 505 => 'RedSaturation', 507 => 'RedSaturation' },
	'reductionmatrix1' => { 122 => 0xc625 },
	'reductionmatrix2' => { 122 => 0xc626 },
	'reductionmatrix3' => { 122 => 0xcd3a },
	'reelname' => { 122 => 0xc789, 404 => 'reel' },
	'reference1' => { 517 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 517 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 517 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 517 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 517 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 517 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 122 => 0x214, 530 => 'ReferenceBlackWhite' },
	'referencedate' => { 134 => 0x2f },
	'referencenumber' => { 134 => 0x32 },
	'references' => { 160 => 'References' },
	'referenceservice' => { 134 => 0x2d },
	'regionappliedtodimensions' => { 175 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 175 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 175 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 175 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 175 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 175 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 175 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 175 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 175 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 175 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 175 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 175 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 331 => 'RegionConstraints' },
	'regiondescription' => { 175 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 175 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 175 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 175 => 'Regions' },
	'regioninfodateregionsvalid' => { 178 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 178 => 'RegionInfo' },
	'regioninforegions' => { 178 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 175 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 175 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 178 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 178 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 178 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 178 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 178 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 175 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 175 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 175 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 519 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 519 => 'RegistryId' },
	'registryitemid' => { 519 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 519 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 158 => 'data' },
	'relatedaudiofilename' => { 158 => '1Name' },
	'relatedaudiofiletype' => { 158 => '0Type' },
	'relatedimagefileformat' => { 122 => 0x1000 },
	'relatedimageheight' => { 122 => 0x1002 },
	'relatedimagewidth' => { 122 => 0x1001 },
	'relatedresourceid' => { 121 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 122 => 0xa004, 511 => 'RelatedSoundFile' },
	'relatedvideofile' => { 172 => 'data' },
	'relatedvideofilename' => { 172 => '1Name' },
	'relatedvideofiletype' => { 172 => '0Type' },
	'relation' => { 508 => 'relation' },
	'relationshipaccordingto' => { 121 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 121 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 121 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipofresourceid' => { 121 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResourceID'] },
	'relationshipremarks' => { 121 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 119 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 534 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 534 => 'relativeTimestamp' },
	'relativetimestampscale' => { 534 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 534 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 301 => '17.8', 302 => '18.5', 304 => '18.4', 305 => '18.4', 310 => '33.8', 311 => '17.6', 314 => '18.5', 315 => '18.4' },
	'releasedate' => { 134 => 0x1e, 396 => 'rldt', 500 => 'ReleaseDate', 534 => 'releaseDate' },
	'releasemode' => { 116 => 0x3001, 242 => 0x5c, 275 => 0x184d, 444 => 0xb049 },
	'releasemode2' => { 453 => 0x112c, 454 => [0x112c,0x8], 455 => [0x1108,0x8], 456 => [0x1184,0x8], 457 => [0x1160,0x8], 458 => [0x4,0x1018], 459 => [0x4,0x210], 460 => [0x4,0x210], 461 => [0x4,0x208], 463 => [0x67,0x3f], 464 => [0x6b,0x6d,0x73,0x4b], 465 => [0x6b,0x4b], 466 => 0x1f, 467 => 0x10, 468 => 0x10, 469 => 0x9, 476 => 0x34 },
	'releasemode3' => { 453 => 0x1128, 454 => 0x1128, 455 => 0x1104, 456 => 0x1180, 457 => 0x115c, 458 => 0x1014, 459 => 0x20c, 460 => 0x20c, 461 => 0x204 },
	'releaseready' => { 519 => 'ReleaseReady' },
	'releasesetting' => { 100 => 0x1016 },
	'releasetime' => { 134 => 0x23, 500 => 'ReleaseTime' },
	'remoteonduration' => { 303 => '3.4', 306 => '17.2', 307 => '18.2', 308 => '18.2', 309 => '18.2', 311 => '18.2', 312 => '4.3', 316 => '19.2' },
	'renditionclass' => { 535 => 'RenditionClass' },
	'renditionof' => { 535 => 'RenditionOf' },
	'renditionofalternatepaths' => { 535 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 535 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 535 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 535 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 535 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 535 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 535 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 535 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 535 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 535 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 535 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 535 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 535 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 535 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 535 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 535 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 535 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 535 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 535 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 535 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 535 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 535 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 535 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 535 => 'RenditionParams' },
	'repeatingflashcount' => { 216 => 0xd, 217 => 0xe, 218 => 0xe, 219 => 0xe, 220 => 0xe, 221 => 0xe, 310 => '17.2', 311 => '24.2', 312 => '9.2', 313 => '24.2', 316 => '25.2' },
	'repeatingflashcountbuilt-in' => { 282 => 0x4db },
	'repeatingflashcountexternal' => { 282 => 0x4c3 },
	'repeatingflashoutput' => { 310 => '17.1', 311 => '24.1', 312 => '9.1', 313 => '24.1', 316 => '25.1' },
	'repeatingflashoutputexternal' => { 282 => 0x4c0 },
	'repeatingflashrate' => { 216 => 0xc, 217 => 0xd, 218 => 0xd, 219 => 0xd, 220 => 0xd, 221 => 0xd, 310 => '18.1', 311 => '25.1', 312 => '10.1', 313 => '25.1', 316 => '26.1' },
	'repeatingflashratebuilt-in' => { 282 => 0x4da },
	'repeatingflashrateexternal' => { 282 => 0x4c2 },
	'requirements' => { 404 => "\xa9req" },
	'requires' => { 503 => 'requires' },
	'resampleparams' => { 534 => 'resampleParams' },
	'resampleparamsquality' => { 534 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 141 => 0xe50 },
	'resamplingkerneldenominators067' => { 141 => 0xe4f },
	'resamplingkerneldenominators100' => { 141 => 0xe51 },
	'resaved' => { 420 => 0x21e },
	'resetblacksegrows' => { 141 => 0x181a },
	'resolution' => { 165 => 'Resolution' },
	'resolutionmode' => { 421 => [0x87,0x4] },
	'resolutionunit' => { 122 => 0x128, 137 => 0x2, 530 => 'ResolutionUnit' },
	'resourceid' => { 121 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 121 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 121 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 87 => 0x612 },
	'restrictions' => { 527 => 'restrictions' },
	'retouchareafeather' => { 505 => [\'RetouchAreas','RetouchAreasFeather'], 507 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 505 => [\'RetouchAreas','RetouchAreasMasksAlpha'], 507 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 505 => [\'RetouchAreas','RetouchAreasMasksAngle'], 507 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 505 => [\'RetouchAreas','RetouchAreasMasksBottom'], 507 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 505 => [\'RetouchAreas','RetouchAreasMasksCenterValue'], 507 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 505 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'], 507 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 505 => [\'RetouchAreas','RetouchAreasMasksDabs'], 507 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 505 => [\'RetouchAreas','RetouchAreasMasksFeather'], 507 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 505 => [\'RetouchAreas','RetouchAreasMasksFlipped'], 507 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 505 => [\'RetouchAreas','RetouchAreasMasksFlow'], 507 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 505 => [\'RetouchAreas','RetouchAreasMasksFullX'], 507 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 505 => [\'RetouchAreas','RetouchAreasMasksFullY'], 507 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskinputdigest' => { 505 => [\'RetouchAreas','RetouchAreasMasksInputDigest'], 507 => [\'RetouchAreas','RetouchAreasMasksInputDigest'] },
	'retouchareamaskleft' => { 505 => [\'RetouchAreas','RetouchAreasMasksLeft'], 507 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmaskactive' => { 505 => [\'RetouchAreas','RetouchAreasMasksMaskActive'], 507 => [\'RetouchAreas','RetouchAreasMasksMaskActive'] },
	'retouchareamaskmaskblendmode' => { 505 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'], 507 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'] },
	'retouchareamaskmaskdigest' => { 505 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'], 507 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'] },
	'retouchareamaskmaskinverted' => { 505 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'], 507 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'] },
	'retouchareamaskmaskname' => { 505 => [\'RetouchAreas','RetouchAreasMasksMaskName'], 507 => [\'RetouchAreas','RetouchAreasMasksMaskName'] },
	'retouchareamaskmasks' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasks'], 507 => [\'RetouchAreas','RetouchAreasMasksMasks'] },
	'retouchareamaskmasksalpha' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'] },
	'retouchareamaskmasksangle' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'] },
	'retouchareamaskmasksbottom' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'] },
	'retouchareamaskmaskscentervalue' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'] },
	'retouchareamaskmaskscenterweight' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'] },
	'retouchareamaskmasksdabs' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'] },
	'retouchareamaskmasksfeather' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'] },
	'retouchareamaskmasksflipped' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'] },
	'retouchareamaskmasksflow' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'] },
	'retouchareamaskmasksfullx' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'] },
	'retouchareamaskmasksfully' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'] },
	'retouchareamaskmasksinputdigest' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'] },
	'retouchareamaskmasksleft' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'] },
	'retouchareamaskmasksmaskactive' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'] },
	'retouchareamaskmasksmaskblendmode' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'] },
	'retouchareamaskmasksmaskdigest' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'] },
	'retouchareamaskmasksmaskinverted' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'] },
	'retouchareamaskmasksmaskname' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'] },
	'retouchareamaskmasksmasksubtype' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'] },
	'retouchareamaskmasksmasksyncid' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'] },
	'retouchareamaskmasksmaskversion' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'] },
	'retouchareamaskmasksmidpoint' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'] },
	'retouchareamaskmasksorigin' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'] },
	'retouchareamaskmasksperimetervalue' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'] },
	'retouchareamaskmasksradius' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'] },
	'retouchareamaskmasksreferencepoint' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'] },
	'retouchareamaskmasksright' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksRight'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksRight'] },
	'retouchareamaskmasksroundness' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'] },
	'retouchareamaskmaskssizex' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'] },
	'retouchareamaskmaskssizey' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'] },
	'retouchareamaskmaskstop' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksTop'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksTop'] },
	'retouchareamaskmasksubtype' => { 505 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'], 507 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'] },
	'retouchareamaskmasksvalue' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'] },
	'retouchareamaskmasksversion' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'] },
	'retouchareamaskmaskswhat' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'] },
	'retouchareamaskmaskswholeimagearea' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'] },
	'retouchareamaskmasksx' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksX'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksX'] },
	'retouchareamaskmasksy' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksY'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksY'] },
	'retouchareamaskmasksyncid' => { 505 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'], 507 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'] },
	'retouchareamaskmaskszerox' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'] },
	'retouchareamaskmaskszeroy' => { 505 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'], 507 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'] },
	'retouchareamaskmaskversion' => { 505 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'], 507 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'] },
	'retouchareamaskmidpoint' => { 505 => [\'RetouchAreas','RetouchAreasMasksMidpoint'], 507 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskorigin' => { 505 => [\'RetouchAreas','RetouchAreasMasksOrigin'], 507 => [\'RetouchAreas','RetouchAreasMasksOrigin'] },
	'retouchareamaskperimetervalue' => { 505 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'], 507 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 505 => [\'RetouchAreas','RetouchAreasMasksRadius'], 507 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskrange' => { 505 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'], 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'] },
	'retouchareamaskrangeareamodels' => { 505 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'], 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'] },
	'retouchareamaskrangeareamodelscolorsampleinfo' => { 505 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'retouchareamaskrangeareamodelscomponents' => { 505 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'], 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'retouchareamaskrangecoloramount' => { 505 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'], 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'] },
	'retouchareamaskrangedepthfeather' => { 505 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'], 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'] },
	'retouchareamaskrangedepthmax' => { 505 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'], 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'] },
	'retouchareamaskrangedepthmin' => { 505 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'], 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'] },
	'retouchareamaskrangeinvert' => { 505 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'], 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'] },
	'retouchareamaskrangelumfeather' => { 505 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'], 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'] },
	'retouchareamaskrangeluminancedepthsampleinfo' => { 505 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'retouchareamaskrangelummax' => { 505 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'], 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'] },
	'retouchareamaskrangelummin' => { 505 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'], 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'] },
	'retouchareamaskrangelumrange' => { 505 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'], 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'] },
	'retouchareamaskrangesampletype' => { 505 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'], 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'] },
	'retouchareamaskrangetype' => { 505 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'], 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'] },
	'retouchareamaskrangeversion' => { 505 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'], 507 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'] },
	'retouchareamaskreferencepoint' => { 505 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'], 507 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'] },
	'retouchareamaskright' => { 505 => [\'RetouchAreas','RetouchAreasMasksRight'], 507 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 505 => [\'RetouchAreas','RetouchAreasMasksRoundness'], 507 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 505 => [\'RetouchAreas','RetouchAreasMasks'], 507 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 505 => [\'RetouchAreas','RetouchAreasMasksSizeX'], 507 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 505 => [\'RetouchAreas','RetouchAreasMasksSizeY'], 507 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 505 => [\'RetouchAreas','RetouchAreasMasksTop'], 507 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 505 => [\'RetouchAreas','RetouchAreasMasksMaskValue'], 507 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 505 => [\'RetouchAreas','RetouchAreasMasksVersion'], 507 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 505 => [\'RetouchAreas','RetouchAreasMasksWhat'], 507 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskwholeimagearea' => { 505 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'], 507 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'] },
	'retouchareamaskx' => { 505 => [\'RetouchAreas','RetouchAreasMasksX'], 507 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 505 => [\'RetouchAreas','RetouchAreasMasksY'], 507 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 505 => [\'RetouchAreas','RetouchAreasMasksZeroX'], 507 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 505 => [\'RetouchAreas','RetouchAreasMasksZeroY'], 507 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 505 => [\'RetouchAreas','RetouchAreasMethod'], 507 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 505 => [\'RetouchAreas','RetouchAreasOffsetY'], 507 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 505 => [\'RetouchAreas','RetouchAreasOpacity'], 507 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 505 => 'RetouchAreas', 507 => 'RetouchAreas' },
	'retouchareaseed' => { 505 => [\'RetouchAreas','RetouchAreasSeed'], 507 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 505 => [\'RetouchAreas','RetouchAreasSourceState'], 507 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 505 => [\'RetouchAreas','RetouchAreasSourceX'], 507 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 505 => [\'RetouchAreas','RetouchAreasSpotType'], 507 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 238 => 0x9e },
	'retouchinfo' => { 505 => 'RetouchInfo', 507 => 'RetouchInfo' },
	'retouchnefprocessing' => { 259 => 0x5 },
	'retractlensonpoweroff' => { 87 => 0x814 },
	'reuse' => { 331 => 'Reuse' },
	'reuseallowed' => { 537 => 'ReuseAllowed' },
	'reuseprohibited' => { 527 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 308 => '5.2' },
	'reversefocusring' => { 317 => 0x163, 318 => 0x163, 319 => 0x17b },
	'reverseindicators' => { 301 => '12.1', 302 => '6.1', 304 => '6.1', 305 => '6.1', 306 => '4.3', 307 => '5.2', 308 => '5.4', 310 => '33.5', 311 => '5.1', 314 => '6.1', 315 => '6.1', 316 => '6.2', 317 => 0xc1, 318 => 0xc1, 319 => 0xc1 },
	'reverseshutterspeedaperture' => { 308 => '5.3' },
	'revision' => { 509 => 'revision' },
	'rflensmffocusringsensitivity' => { 87 => 0x714 },
	'rflenstype' => { 59 => 0x3d },
	'rgbcurvelimits' => { 111 => 0x238 },
	'rgbcurvepoints' => { 110 => 0x7, 111 => 0x20e },
	'rgbtables' => { 122 => 0xcd3b },
	'richtextcomment' => { 514 => 'RichTextComment' },
	'ricohdate' => { 410 => 0x6 },
	'ricohimageheight' => { 410 => 0x2 },
	'ricohimagewidth' => { 410 => 0x0 },
	'rightalbedo' => { 496 => 'RightAlbedo' },
	'rightascension' => { 168 => 'RightAscension' },
	'rights' => { 508 => 'rights' },
	'rightsagent' => { 527 => 'rightsAgent' },
	'rightsowner' => { 527 => 'rightsOwner' },
	'roll' => { 118 => 0x8, 404 => ['roll',"\xa9frl"] },
	'rollangle' => { 130 => 0x144d, 251 => 0x0, 321 => 0x903, 344 => 0x90, 378 => 0x1, 416 => 0x2 },
	'romoperationmode' => { 100 => 0x80d },
	'rotation' => { 31 => 0x17, 32 => 0x18, 99 => 0x3, 106 => 0x10002, 111 => 0x26e, 117 => 'QuickTime-Rotation', 126 => 0x4, 168 => 'Rotation', 185 => [0x65,0x50], 186 => 0x46, 187 => 0x5a, 190 => 0x10, 260 => 0x1a, 275 => 0x3693, 281 => '590.1', 294 => 0x76a43207, 344 => 0x30, 360 => '17.2', 390 => 0xd8, 397 => 'irot', 431 => 0x3f, 432 => 0x3f, 442 => 0x10 },
	'routedto' => { 513 => 'RoutedTo' },
	'routing' => { 395 => 'Routing' },
	'routingdestinations' => { 495 => 'RoutingDestinations' },
	'routingexclusions' => { 495 => 'RoutingExclusions' },
	'routingnotes' => { 513 => 'RoutingNotes' },
	'rowsperstrip' => { 122 => 0x116 },
	'rpp' => { 500 => 'rpp' },
	'rtkflag' => { 119 => 'RtkFlag' },
	'rtkstdhgt' => { 119 => 'RtkStdHgt' },
	'rtkstdlat' => { 119 => 'RtkStdLat' },
	'rtkstdlon' => { 119 => 'RtkStdLon' },
	'safetyshift' => { 87 => 0x108 },
	'safetyshiftinavortv' => { 85 => 0x10, 86 => 0x10, 88 => 0xf, 89 => 0x10, 92 => 0x10 },
	'sameexposurefornewaperture' => { 87 => 0x112 },
	'samplebits' => { 158 => 'SampleBits' },
	'samplepagerange' => { 524 => 'samplePageRange' },
	'samplerate' => { 158 => 'SampleRate' },
	'samplesperpixel' => { 122 => 0x115, 349 => 0x8, 530 => 'SamplesPerPixel' },
	'samplestructure' => { 136 => 0x5a },
	'samsungmodelid' => { 418 => 0x3 },
	'sanyoquality' => { 420 => 0x201 },
	'sanyothumbnail' => { 420 => 0x100 },
	'saturation' => { 10 => 0x6e, 12 => 0x76, 36 => 0xe, 53 => 0x1, 65 => 0x7, 115 => 0xd, 116 => [0x3013,0x1f], 122 => [0xa409,0xfe55], 130 => 0x1003, 159 => 'Saturation', 184 => 0x1f, 185 => 0x32, 186 => 0x28, 187 => 0x1a, 192 => 0x1, 238 => 0xaa, 253 => 0x35, 254 => 0x3b, 255 => 0x43, 344 => 0x40, 346 => 0x300d, 379 => 0x1f, 386 => 0xd, 405 => 0x27, 407 => 0x58, 410 => 0x28, 411 => 0x1013, 421 => 0x10, 431 => 0x1e, 432 => 0x1b, 444 => 0x2005, 505 => 'Saturation', 507 => 'Saturation', 511 => 'Saturation' },
	'saturationadj' => { 106 => 0x20901, 111 => 0x116, 238 => 0x94, 293 => 0x1, 297 => 0x2e, 481 => 0x8016 },
	'saturationadjustmentaqua' => { 505 => 'SaturationAdjustmentAqua', 507 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 505 => 'SaturationAdjustmentBlue', 507 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 505 => 'SaturationAdjustmentGreen', 507 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 505 => 'SaturationAdjustmentMagenta', 507 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 505 => 'SaturationAdjustmentOrange', 507 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 505 => 'SaturationAdjustmentPurple', 507 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 505 => 'SaturationAdjustmentRed', 507 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 505 => 'SaturationAdjustmentYellow', 507 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 73 => 0x98 },
	'saturationfaithful' => { 19 => 0xfe, 72 => 0x68, 73 => 0x68 },
	'saturationlandscape' => { 19 => 0xfc, 72 => 0x38, 73 => 0x38 },
	'saturationmonochrome' => { 72 => 0x80, 73 => 0x80 },
	'saturationneutral' => { 19 => 0xfd, 72 => 0x50, 73 => 0x50 },
	'saturationportrait' => { 19 => 0xfb, 72 => 0x20, 73 => 0x20 },
	'saturationsetting' => { 329 => 0x1010, 433 => 0x11, 449 => 0x9 },
	'saturationstandard' => { 19 => 0xfa, 72 => 0x8, 73 => 0x8 },
	'saturationuserdef1' => { 19 => 0x100, 72 => 0x98, 73 => 0xb0 },
	'saturationuserdef2' => { 19 => 0x101, 72 => 0xb0, 73 => 0xc8 },
	'saturationuserdef3' => { 19 => 0x102, 72 => 0xc8, 73 => 0xe0 },
	'saveid' => { 535 => 'SaveID' },
	'sbaanalysiscomplete' => { 141 => 0xc35 },
	'sbablack' => { 141 => 0xc25 },
	'sbagmoffset' => { 141 => 0xc4a },
	'sbagray' => { 141 => 0xc26 },
	'sbagreenmagentabal' => { 141 => 0xc33 },
	'sbahighgray' => { 141 => 0xc46 },
	'sbailloffset' => { 141 => 0xc49 },
	'sbailluminantbal' => { 141 => 0xc34 },
	'sbalowgray' => { 141 => 0xc47 },
	'sbaneutralbal' => { 141 => 0xc32 },
	'sbawhite' => { 141 => 0xc27 },
	'scaletype' => { 534 => 'scaleType' },
	'scanimageenhancer' => { 261 => 0x60 },
	'scanningdirection' => { 136 => 0x64 },
	'scene' => { 404 => 'scen', 518 => 'Scene', 534 => 'scene' },
	'scenearea' => { 324 => 0x211, 326 => 0x1031 },
	'sceneassist' => { 238 => 0x9c },
	'scenecapturetype' => { 122 => 0xa406, 511 => 'SceneCaptureType' },
	'scenedetect' => { 324 => 0x210, 326 => 0x1030 },
	'scenedetectdata' => { 324 => 0x212, 326 => 0x1033 },
	'sceneflags' => { 1 => 0x25 },
	'scenemode' => { 145 => 0xfa02, 189 => 0x100, 238 => 0x8f, 321 => 0x509, 326 => 0x403, 344 => 0x8001, 353 => 0xf, 444 => 0xb023 },
	'scenemodeused' => { 147 => [0x6002,0xf002] },
	'scenerecognition' => { 130 => 0x1425 },
	'scenereferred' => { 515 => 'scene_referred' },
	'sceneselect' => { 420 => 0x21f },
	'scenetype' => { 122 => 0xa301, 511 => 'SceneType' },
	'screentips' => { 301 => '12.7', 302 => '5.3', 310 => '13.1', 311 => '4.4', 314 => '5.4', 316 => '5.1' },
	'scriptversion' => { 141 => 0x1770 },
	'sdrblend' => { 505 => 'SDRBlend', 507 => 'SDRBlend' },
	'sdrbrightness' => { 505 => 'SDRBrightness', 507 => 'SDRBrightness' },
	'sdrcontrast' => { 505 => 'SDRContrast', 507 => 'SDRContrast' },
	'sdrhighlights' => { 505 => 'SDRHighlights', 507 => 'SDRHighlights' },
	'sdrshadows' => { 505 => 'SDRShadows', 507 => 'SDRShadows' },
	'sdrwhites' => { 505 => 'SDRWhites', 507 => 'SDRWhites' },
	'season' => { 519 => 'Season', 523 => 'season' },
	'seasonidentifier' => { 519 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 519 => [\'Season','SeasonName'] },
	'seasonnumber' => { 519 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 495 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 243 => 0x240, 244 => 0x22c, 245 => 0x240, 246 => 0x240, 264 => 0x13c, 275 => 0x1d0 },
	'section' => { 524 => 'section' },
	'securityclassification' => { 122 => 0x9212 },
	'selectableafpoint' => { 87 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 87 => 0x512 },
	'selfdata' => { 119 => 'SelfData' },
	'selftimer' => { 36 => 0x2, 344 => 0x2e, 420 => 0x214, 453 => 0x1134, 454 => 0x1134, 455 => 0x1110, 456 => 0x118c, 457 => 0x1168, 458 => 0x1020, 459 => 0x218, 460 => 0x218, 461 => 0x210 },
	'selftimer2' => { 79 => 0x1d },
	'selftimerinterval' => { 311 => '19.2' },
	'selftimermode' => { 122 => 0x882b },
	'selftimershotcount' => { 302 => '20.2', 304 => '20.3', 305 => '20.3', 306 => '18.2', 307 => '19.2', 308 => '19.2', 309 => '19.3', 311 => '19.3', 314 => '20.3', 315 => '20.3', 316 => '20.2', 317 => 0x2d, 318 => 0x2d, 319 => 0x2d },
	'selftimershotinterval' => { 302 => '20.3', 304 => '20.2', 305 => '20.2', 309 => '19.2', 314 => '20.2', 315 => '20.2', 317 => 0x31, 318 => 0x31, 319 => 0x31 },
	'selftimertime' => { 100 => 0x1806, 187 => 0x1f, 301 => '18.1', 302 => '20.1', 303 => '3.3', 304 => '20.1', 305 => '20.1', 306 => '18.1', 307 => '19.1', 308 => '19.1', 309 => '19.1', 310 => '7.2', 311 => '19.1', 312 => '3.3', 314 => '20.1', 315 => '20.1', 316 => '20.1', 317 => 0x2b, 318 => 0x2b, 319 => 0x2b },
	'sellingagency' => { 524 => 'sellingAgency' },
	'semanticstyle' => { 1 => 0x40 },
	'semanticstylepreset' => { 1 => 0x42 },
	'semanticstylerenderingver' => { 1 => 0x41 },
	'seminfo' => { 122 => 0x8546 },
	'sensingmethod' => { 122 => 0xa217, 511 => 'SensingMethod' },
	'sensitivityadjust' => { 379 => 0x40 },
	'sensitivitysteps' => { 360 => ['14.3','17.4'], 362 => 0x1 },
	'sensitivitytype' => { 122 => 0x8830, 512 => 'SensitivityType' },
	'sensor' => { 194 => 0x665e },
	'sensorarea' => { 326 => 0x400 },
	'sensorareas' => { 418 => 0xa010 },
	'sensorbitdepth' => { 346 => 0x312d },
	'sensorbluelevel' => { 76 => 0x5 },
	'sensorcalibration' => { 325 => 0x805 },
	'sensorcleaning' => { 93 => 0xd },
	'sensorfullheight' => { 140 => 0xf904 },
	'sensorfullwidth' => { 140 => 0xf903 },
	'sensorheight' => { 140 => 0xf901, 145 => 0xfa21, 191 => 0x8, 346 => 0x312c, 388 => 0x109, 411 => 0x1602 },
	'sensorimageheight' => { 141 => 0x3ee },
	'sensorimagewidth' => { 141 => 0x3ed },
	'sensorleftborder' => { 141 => 0x3eb },
	'sensorleftmargin' => { 388 => 0x10a },
	'sensorpixelsize' => { 238 => 0x9a },
	'sensorredlevel' => { 76 => 0x4 },
	'sensorserialnumber' => { 141 => 0x9ce },
	'sensorshield' => { 243 => 0x76b, 244 => 0x66d, 245 => 0x69d, 246 => 0x705 },
	'sensorsize' => { 159 => 'SensorSize', 379 => 0x35 },
	'sensortemperature' => { 324 => 0x1500, 326 => 0x1007, 384 => 0xc, 388 => 0x210, 421 => [0x39,0x55] },
	'sensortemperature2' => { 384 => 0xe, 388 => 0x211 },
	'sensortopborder' => { 141 => 0x3ec },
	'sensortopmargin' => { 388 => 0x10b },
	'sensortype' => { 344 => 0xca },
	'sensorwidth' => { 140 => 0xf900, 145 => 0xfa20, 191 => 0xa, 346 => 0x312b, 388 => 0x108, 411 => 0x1601 },
	'sequence' => { 405 => 0x7, 406 => 0x35, 407 => 0x36 },
	'sequencefilenumber' => { 454 => 0x4, 455 => 0x4, 456 => 0x4, 457 => 0x4, 467 => 0xc, 468 => 0xc, 469 => 0x1a },
	'sequenceimagenumber' => { 454 => 0x0, 455 => 0x0, 456 => 0x0, 457 => 0x0, 467 => 0x8, 468 => 0x8, 469 => 0x12, 476 => 0x24 },
	'sequencelength' => { 467 => 0x22, 468 => 0x1e, 469 => [0x16,0x1e] },
	'sequencename' => { 523 => 'sequenceName' },
	'sequencenumber' => { 79 => 0x9, 116 => 0x301c, 130 => 0x1101, 143 => 0x1d, 282 => 0x51c, 344 => 0x2b, 433 => [0x10c,0x30c], 444 => 0xb04a, 523 => 'sequenceNumber' },
	'sequenceshotinterval' => { 420 => 0x224 },
	'sequencetotalnumber' => { 523 => 'sequenceTotalNumber' },
	'sequentialshot' => { 420 => 0x20e },
	'serialnumber' => { 66 => 0xc, 100 => 0x180b, 122 => [0xa431,0xfde9], 140 => 0xfa04, 142 => 0xfa00, 144 => 0xc354, 145 => 0xfa19, 156 => 0x0, 159 => 'SerialNumber', 194 => 0x5501, 238 => [0xa0,0x1d], 322 => 0x101, 326 => [0x404,0x101a], 339 => 0x303, 341 => 0x305, 346 => 0x3103, 379 => 0x229, 388 => 0x102, 389 => 0x407, 404 => ['SNum','slno'], 405 => 0x15, 406 => 0x4b, 407 => 0x7e, 411 => 0x5, 418 => 0xa002, 421 => 0x2, 444 => 0x2031, 502 => 'SerialNumber', 512 => 'BodySerialNumber' },
	'serialnumberformat' => { 66 => 0x15, 100 => 0x183b },
	'serialnumberhash' => { 404 => 'CAME' },
	'series' => { 519 => 'Series' },
	'seriesdatetime' => { 483 => 'SeriesDateTime' },
	'seriesdescription' => { 483 => 'SeriesDescription' },
	'seriesidentifier' => { 519 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 483 => 'SeriesModality' },
	'seriesname' => { 519 => [\'Series','SeriesName'] },
	'seriesnumber' => { 483 => 'SeriesNumber', 524 => 'seriesNumber' },
	'seriestitle' => { 524 => 'seriesTitle' },
	'serviceidentifier' => { 135 => 0x1e },
	'servingsize' => { 526 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 90 => 0x0, 91 => 0x0 },
	'setbuttonwhenshooting' => { 85 => 0x1, 87 => 0x704, 93 => 0xc },
	'setclockfromlocationdata' => { 244 => 0x61d, 245 => 0x64d, 246 => 0x6b5 },
	'setfunctionwhenshooting' => { 88 => 0x0, 89 => 0x1, 92 => 0x1 },
	'setting' => { 523 => 'setting' },
	'shadingcompensation' => { 321 => 0x50c, 344 => 0x8a },
	'shadingcompensation2' => { 325 => 0x1012 },
	'shadow' => { 421 => 0xe },
	'shadowadj' => { 106 => 0x2030b },
	'shadowcorrection' => { 379 => 0x79 },
	'shadowprotection' => { 293 => 0x0 },
	'shadows' => { 122 => 0xfe52, 444 => 0x2032, 499 => 'Shadows', 505 => 'Shadows', 507 => 'Shadows' },
	'shadows2012' => { 505 => 'Shadows2012', 507 => 'Shadows2012' },
	'shadowsadj' => { 481 => 0x901a },
	'shadowscale' => { 122 => 0xc633 },
	'shadowtint' => { 505 => 'ShadowTint', 507 => 'ShadowTint' },
	'shadowtone' => { 130 => 0x1040 },
	'shakereduction' => { 381 => 0x1, 382 => 0x1 },
	'shareduserrating' => { 182 => 'WM/SharedUserRating' },
	'sharpendetail' => { 505 => 'SharpenDetail', 507 => 'SharpenDetail' },
	'sharpenedgemasking' => { 505 => 'SharpenEdgeMasking', 507 => 'SharpenEdgeMasking' },
	'sharpening' => { 346 => 0x300b },
	'sharpeningadj' => { 297 => 0x2b },
	'sharpeningkernel' => { 141 => 0x92f },
	'sharpenradius' => { 505 => 'SharpenRadius', 507 => 'SharpenRadius' },
	'sharpness' => { 8 => [0x42,0x48], 10 => 0x72, 12 => 0x74, 36 => 0xf, 65 => 0x6, 76 => 0x2, 115 => 0xb, 116 => [0x3011,0x21], 122 => [0xa40a,0xfe56], 130 => 0x1001, 143 => 0x6b, 152 => 0x37, 159 => 'Sharpness', 184 => 0x21, 185 => 0x30, 186 => 0x26, 187 => 0x18, 192 => 0x3, 238 => 0x6, 253 => 0x32, 254 => 0x33, 255 => 0x39, 326 => 0x100f, 344 => 0x41, 379 => 0x21, 386 => 0xb, 405 => 0x26, 407 => 0x56, 410 => 0x22, 411 => [0x1003,0x1014], 421 => 0x11, 431 => 0x1c, 432 => 0x19, 444 => 0x2006, 476 => 0x52, 505 => 'Sharpness', 507 => 'Sharpness', 511 => 'Sharpness' },
	'sharpnessadj' => { 106 => 0x20310, 111 => 0x25a, 481 => 0x801a },
	'sharpnessadjon' => { 106 => '0x20310.0' },
	'sharpnessauto' => { 73 => 0x94 },
	'sharpnessfactor' => { 326 => 0x102a },
	'sharpnessfaithful' => { 19 => 0xf5, 72 => 0x64, 73 => 0x64 },
	'sharpnessfrequency' => { 8 => [0x41,0x47], 76 => 0x3 },
	'sharpnesslandscape' => { 19 => 0xf3, 72 => 0x34, 73 => 0x34 },
	'sharpnessmonochrome' => { 19 => 0xf6, 72 => 0x7c, 73 => 0x7c },
	'sharpnessneutral' => { 19 => 0xf4, 72 => 0x4c, 73 => 0x4c },
	'sharpnessovershoot' => { 481 => 0x801b },
	'sharpnessportrait' => { 19 => 0xf2, 72 => 0x1c, 73 => 0x1c },
	'sharpnessrange' => { 444 => 0x2035 },
	'sharpnesssetting' => { 321 => 0x506, 329 => 0x1013, 433 => 0x12, 449 => 0xa },
	'sharpnessstandard' => { 19 => 0xf1, 72 => 0x4, 73 => 0x4 },
	'sharpnessstrength' => { 106 => 0x20311 },
	'sharpnessthreshold' => { 481 => 0x801d },
	'sharpnessundershoot' => { 481 => 0x801c },
	'sharpnessuserdef1' => { 19 => 0xf7, 72 => 0x94, 73 => 0xac },
	'sharpnessuserdef2' => { 19 => 0xf8, 72 => 0xac, 73 => 0xc4 },
	'sharpnessuserdef3' => { 19 => 0xf9, 72 => 0xc4, 73 => 0xdc },
	'shiftcols' => { 141 => 0xc70 },
	'shootid' => { 523 => 'shootID' },
	'shootingdistance' => { 106 => 0x20701 },
	'shootinginfodisplay' => { 301 => '13.2', 302 => '5.1', 310 => '10.2', 311 => '4.1', 314 => '5.1', 316 => '5.3' },
	'shootinginfomonitorofftime' => { 301 => '26.2', 302 => '22.2', 304 => '22.2', 305 => '22.2', 309 => '21.2', 310 => '9.1', 311 => '21.2', 314 => '22.2', 315 => '22.2', 316 => '22.2', 317 => 0x37, 318 => 0x37, 319 => 0x37 },
	'shootingmode' => { 159 => 'ShootingMode', 238 => 0x89, 344 => 0x1f },
	'shootingmodesetting' => { 303 => '5.1' },
	'shortdescription' => { 509 => 'shortdescription' },
	'shortdocumentid' => { 134 => 0xba },
	'shortname' => { 505 => 'ShortName', 507 => 'ShortName' },
	'shortownername' => { 19 => 0xac },
	'shortreleasetimelag' => { 87 => 0x80d },
	'shorttitle' => { 396 => '@sti' },
	'shotdate' => { 534 => 'shotDate' },
	'shotday' => { 534 => 'shotDay' },
	'shotlocation' => { 534 => 'shotLocation' },
	'shotlogdata' => { 488 => 'shot_log_data' },
	'shotname' => { 404 => 'shot', 534 => 'shotName' },
	'shotnumber' => { 534 => 'shotNumber' },
	'shotnumbersincepowerup' => { 448 => 0x44e, 467 => 0x1a, 468 => 0x16, 469 => 0xa },
	'shotnumbersincepowerup2' => { 433 => 0x200 },
	'shotsize' => { 534 => 'shotSize' },
	'shotsperinterval' => { 227 => 0x180, 242 => 0xb4, 243 => 0xcc, 244 => 0xc0, 245 => 0xd0, 246 => 0xd0 },
	'showmovement' => { 396 => 'shwm' },
	'shownevent' => { 519 => 'EventExt' },
	'showneventidentifier' => { 519 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 519 => [\'EventExt','EventExtName'] },
	'shutter' => { 463 => 0x20, 464 => 0x26, 465 => 0x26 },
	'shutter-aelock' => { 85 => 0x4, 87 => 0x701, 88 => 0x3, 89 => 0x4, 90 => 0x3, 91 => 0x3, 92 => 0x4, 93 => 0x2 },
	'shutteraelbutton' => { 86 => 0x4 },
	'shutterbuttonafonbutton' => { 87 => 0x701 },
	'shuttercount' => { 11 => 0x176, 30 => 0x293, 33 => 0xaf1, 59 => 0x1, 238 => 0xa7, 266 => [0x6a,0x157,0x24d], 267 => 0x286, 268 => 0x279, 269 => 0x284, 270 => 0x242, 271 => 0x280, 272 => 0x276, 273 => [0x27d,0x27f], 274 => 0x246, 276 => 0x2d6, 277 => 0x321, 278 => 0xbd8, 279 => 0x287, 280 => 0x320, 281 => 0x24a, 282 => 0x5fb, 283 => 0x2d5, 379 => 0x5d, 442 => 0x846, 447 => [0x125,0x14a], 463 => 0x32, 464 => 0x3a, 465 => 0x3a, 466 => 0xa },
	'shuttercount2' => { 463 => 0x4c, 464 => [0x50,0x52,0x58], 465 => 0x50 },
	'shuttercount3' => { 463 => [0x1a0,0x1aa,0x1bd], 464 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 85 => 0xf, 86 => 0xf, 87 => 0x305, 88 => 0xe, 89 => 0xf, 90 => 0x8, 91 => 0x8, 92 => 0xf, 93 => 0x8 },
	'shuttermode' => { 59 => 0x17, 143 => 0x1b, 238 => 0x34 },
	'shutterreleasebuttonae-l' => { 301 => '17.7', 302 => '18.4', 304 => '78.4', 305 => '78.4', 306 => '16.1', 307 => '17.1', 308 => '17.1', 309 => '17.1', 310 => '7.1', 311 => '17.5', 314 => '18.4', 315 => '78.4', 316 => '18.2', 317 => 0x29, 318 => 0x29, 319 => 0x29 },
	'shutterreleasemethod' => { 100 => 0x1010 },
	'shutterreleasenocfcard' => { 85 => 0x2, 86 => 0x2, 93 => 0xf },
	'shutterreleasetiming' => { 100 => 0x1011 },
	'shutterreleasewithoutlens' => { 87 => 0x711 },
	'shutterspeedlock' => { 302 => '38.1', 304 => '38.1', 305 => '38.1', 314 => '38.1', 315 => '38.1', 317 => 0xb7, 318 => 0xb7, 319 => 0xb7 },
	'shutterspeedrange' => { 87 => 0x10c },
	'shutterspeedsetting' => { 187 => 0x6, 431 => 0x2f, 432 => 0x28, 433 => 0x0 },
	'shutterspeedvalue' => { 96 => 0x1, 122 => 0x9201, 326 => 0x1000, 388 => 0x400, 511 => 'ShutterSpeedValue' },
	'shuttertype' => { 130 => 0x1050, 344 => 0x9f, 379 => 0x87, 469 => [0x133,0x139,0x13f] },
	'sidecarforextension' => { 522 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 141 => 0xe0d },
	'sigmascalingfactorcamera' => { 141 => 0xe0c },
	'sigmascalingfactorlowres' => { 141 => 0xe0b },
	'sigmasizetable' => { 141 => 0xe0f },
	'signaltonoiseratio' => { 1 => 0x27 },
	'signaltonoiseratiotype' => { 1 => 0x26 },
	'silentphotography' => { 238 => 0xbf },
	'similarityindex' => { 134 => 0xe4 },
	'singleframebracketing' => { 187 => 0x21 },
	'skilllevel' => { 526 => 'skillLevel' },
	'skintonecorrection' => { 379 => 0x95 },
	'skiplinetime' => { 141 => 0x184e },
	'slaveflashmeteringsegments' => { 379 => 0x20b },
	'slideshowname' => { 523 => 'slideshowName' },
	'slideshownumber' => { 523 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 523 => 'slideshowTotalNumber' },
	'slot2jpgsize' => { 243 => 0x24a, 246 => 0x24a },
	'slowshutter' => { 79 => 0x8 },
	'slowsync' => { 130 => 0x1030 },
	'smartalbumcolor' => { 418 => 0x20 },
	'smartrange' => { 418 => 0xa012 },
	'smileshutter' => { 433 => 0x31 },
	'smileshuttermode' => { 433 => 0x27 },
	'smoothness' => { 122 => 0xfe57, 505 => 'Smoothness', 507 => 'Smoothness' },
	'snapshot' => { 519 => 'SnapshotLink' },
	'snapshotformat' => { 519 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 519 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 519 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 519 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 519 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 500 => 'Snapshots' },
	'snapshotusedvideoframe' => { 519 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 519 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 519 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 519 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 519 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 444 => 0x200f },
	'software' => { 122 => 0x131, 160 => 'Software', 334 => 'Software', 388 => 0x203, 398 => 'software', 421 => 0x18, 490 => 'Software', 530 => 'Software' },
	'softwareversion' => { 404 => ['@swr',"\xa9swr"], 420 => 0x207 },
	'soloist' => { 396 => "\xa9sol" },
	'songwriter' => { 404 => "\xa9swf" },
	'songwriterkeywords' => { 404 => "\xa9swk" },
	'sonycropsize' => { 122 => 0x74c8 },
	'sonycroptopleft' => { 122 => 0x74c7 },
	'sonydatetime' => { 452 => 0x6, 454 => 0x1b6, 455 => 0x210, 456 => 0x1fe, 457 => 0x22c },
	'sonydatetime2' => { 463 => 0x51 },
	'sonyexposuretime' => { 463 => 0x3a, 464 => 0x46, 465 => [0x66,0x46], 466 => 0x1a },
	'sonyexposuretime2' => { 476 => 0xe },
	'sonyfnumber' => { 463 => 0x3c, 464 => 0x48, 465 => [0x68,0x48], 466 => 0x1c, 476 => 0x14 },
	'sonyimageheight' => { 452 => 0x1a, 467 => 0x44, 468 => 0x3f },
	'sonyimageheightmax' => { 476 => 0x40 },
	'sonyimagesize' => { 187 => 0x3b, 431 => 0x54, 432 => 0x54, 433 => 0x9 },
	'sonyimagewidth' => { 452 => 0x1c },
	'sonyimagewidthmax' => { 476 => 0x3e },
	'sonyiso' => { 454 => 0x1218, 455 => 0x11f4, 456 => 0x1270, 457 => [0x1254,0x1258,0x1280], 458 => 0x113c, 459 => 0x344, 460 => 0x346, 461 => 0x320, 476 => 0x4 },
	'sonymaxaperture' => { 463 => 0x0, 464 => 0x0 },
	'sonymaxaperturevalue' => { 476 => 0x16 },
	'sonyminaperture' => { 463 => 0x1, 464 => 0x1 },
	'sonymodelid' => { 444 => 0xb001 },
	'sonyquality' => { 187 => 0x3c },
	'sonyrawimagesize' => { 122 => 0x7038 },
	'sonytimeminsec' => { 464 => 0x61 },
	'sortalbum' => { 396 => 'soal' },
	'sortalbumartist' => { 396 => 'soaa' },
	'sortartist' => { 396 => 'soar' },
	'sortcomposer' => { 396 => 'soco' },
	'sortname' => { 396 => 'sonm', 505 => 'SortName', 507 => 'SortName' },
	'sortshow' => { 396 => 'sosn' },
	'soundengineer' => { 396 => "\xa9sne" },
	'source' => { 134 => 0x73, 334 => 'Source', 508 => 'source', 509 => 'source', 522 => 'Source' },
	'sourcecount' => { 494 => 'SourceCount' },
	'sourcecredits' => { 404 => "\xa9src" },
	'sourcedirectoryindex' => { 366 => 0x0 },
	'sourcefileindex' => { 366 => 0x2 },
	'sourcephotoscount' => { 493 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 141 => 0x1390 },
	'spatialfrequencyresponse' => { 511 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 511 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 511 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 511 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 511 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 534 => 'speakerPlacement' },
	'specialeffectlevel' => { 116 => 0x3030 },
	'specialeffectmode' => { 116 => 0x2076 },
	'specialeffectsetting' => { 116 => 0x3031 },
	'specialinstructions' => { 134 => 0x28 },
	'specialmode' => { 326 => 0x200, 420 => 0x200 },
	'specialoccasion' => { 526 => 'specialOccasion' },
	'specialtypeid' => { 488 => 'SpecialTypeID' },
	'spectralsensitivity' => { 122 => 0x8824, 511 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 43 => 0x32b, 44 => 0x281, 47 => [0x2b9,0x2d0,0x2d4], 48 => 0x56a, 49 => 0x1e4, 50 => [0x1fd,0x2dd], 51 => [0x231,0x30f], 52 => 0x31d },
	'speedx' => { 118 => 0x3, 404 => "\xa9xsp" },
	'speedy' => { 118 => 0x4, 404 => "\xa9ysp" },
	'speedz' => { 118 => 0x5, 404 => "\xa9zsp" },
	'spherical' => { 494 => 'Spherical' },
	'sphericalvideoxml' => { 123 => 'SphericalVideoXML' },
	'splitcolumn' => { 388 => 0x222 },
	'splittoningbalance' => { 505 => 'SplitToningBalance', 507 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 505 => 'SplitToningHighlightHue', 507 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 505 => 'SplitToningHighlightSaturation', 507 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 505 => 'SplitToningShadowHue', 507 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 505 => 'SplitToningShadowSaturation', 507 => 'SplitToningShadowSaturation' },
	'sport' => { 524 => 'sport' },
	'spotfocuspointx' => { 184 => 0x2d },
	'spotfocuspointy' => { 184 => 0x2e },
	'spotmeteringmode' => { 36 => 0x27 },
	'spotmeterlinktoafpoint' => { 87 => 0x107 },
	'sractive' => { 360 => '17.1' },
	'srawquality' => { 36 => 0x2e },
	'srfocallength' => { 381 => 0x3 },
	'srgbrendering' => { 332 => 'sRGB' },
	'srhalfpresstime' => { 381 => 0x2 },
	'srresult' => { 381 => 0x0, 382 => 0x0 },
	'stackedimage' => { 321 => 0x804 },
	'standardmatrixcustom' => { 141 => 0x7d4 },
	'standardmatrixdaylight' => { 141 => 0x7d0 },
	'standardmatrixflash' => { 141 => 0x7d3 },
	'standardmatrixfluorescent' => { 141 => 0x7d2 },
	'standardmatrixtungsten' => { 141 => 0x7d1 },
	'standardoutputhighlightpoint' => { 112 => 0x14 },
	'standardoutputsensitivity' => { 122 => 0x8831, 512 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 112 => 0x15 },
	'standardrawcolortone' => { 112 => 0xd },
	'standardrawcontrast' => { 112 => 0xf },
	'standardrawhighlight' => { 112 => 0x75 },
	'standardrawhighlightpoint' => { 112 => 0x12 },
	'standardrawlinear' => { 112 => 0x10 },
	'standardrawsaturation' => { 112 => 0xe },
	'standardrawshadow' => { 112 => 0x7e },
	'standardrawshadowpoint' => { 112 => 0x13 },
	'standardrawsharpness' => { 112 => 0x11 },
	'standardunsharpmaskfineness' => { 112 => 0x94 },
	'standardunsharpmaskstrength' => { 112 => 0x92 },
	'standardunsharpmaskthreshold' => { 112 => 0x96 },
	'standardwhitecustom' => { 141 => 0x838 },
	'standardwhitedaylight' => { 141 => 0x834 },
	'standardwhiteflash' => { 141 => 0x837 },
	'standardwhitefluorescent' => { 141 => 0x836 },
	'standardwhitetungsten' => { 141 => 0x835 },
	'standbytimer' => { 302 => '19.1', 304 => '19.1', 305 => '19.1', 308 => '18.1', 309 => '18.1', 314 => '19.1', 315 => '19.1' },
	'starlightview' => { 317 => 0x249, 318 => 0x249, 319 => 0x261 },
	'startingpage' => { 524 => 'startingPage' },
	'startmovieshooting' => { 87 => 0x70d },
	'starttimecode' => { 404 => "\xa9TIM", 534 => 'startTimecode' },
	'starttimecodetimeformat' => { 534 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 534 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 534 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 404 => "\xa9TSZ", 534 => 'startTimeSampleSize' },
	'starttimescale' => { 404 => "\xa9TSC", 534 => 'startTimeScale' },
	'state' => { 164 => 'State', 344 => 0x6b, 522 => 'State' },
	'status' => { 486 => 'Status', 498 => 'Status' },
	'stereomode' => { 494 => 'StereoMode' },
	'stitched' => { 494 => 'Stitched' },
	'stitchingsoftware' => { 493 => 'StitchingSoftware', 494 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 453 => 0x113e, 454 => 0x113e, 455 => 0x111a, 456 => 0x1196, 457 => 0x1172, 458 => 0x102a, 459 => 0x222, 460 => 0x222, 461 => 0x217, 476 => 0xa },
	'storagemethod' => { 191 => 0x12 },
	'storebyorientation' => { 302 => '46.3', 304 => '47.3', 305 => '47.3', 314 => '47.3', 315 => '47.3', 317 => 0xd, 318 => 0xd, 319 => 0xd },
	'storedescription' => { 396 => 'sdes' },
	'storylineidentifier' => { 519 => 'StorylineIdentifier' },
	'straightenangle' => { 294 => 0x2fc08431 },
	'streamready' => { 519 => 'StreamReady' },
	'streamtype' => { 179 => 'StreamType' },
	'stretchmode' => { 534 => 'stretchMode' },
	'studydatetime' => { 483 => 'StudyDateTime' },
	'studydescription' => { 483 => 'StudyDescription' },
	'studyid' => { 483 => 'StudyID' },
	'studyphysician' => { 483 => 'StudyPhysician' },
	'styleperiod' => { 519 => 'StylePeriod' },
	'sub-location' => { 134 => 0x5c },
	'subcommanddialplaybackmode' => { 317 => 0x1cf, 318 => 0x1cf, 319 => 0x1e7 },
	'subfiledata' => { 167 => 'data' },
	'subfiledirectory' => { 167 => '1Directory' },
	'subfilemimetype' => { 167 => '2MIME' },
	'subfilename' => { 167 => '1Name' },
	'subfileresource' => { 167 => 'rsrc' },
	'subfiletype' => { 122 => 0xfe, 167 => '0Type' },
	'subject' => { 330 => 'Subject', 395 => 'Subject', 508 => 'subject', 521 => 'Subject', 535 => 'subject' },
	'subjectarea' => { 122 => 0x9214, 511 => 'SubjectArea' },
	'subjectcode' => { 518 => 'SubjectCode' },
	'subjectdetection' => { 243 => 0x252, 244 => 0x23e, 245 => 0x252, 246 => 0x252 },
	'subjectdistance' => { 122 => 0x9206, 143 => 0x3e, 511 => 'SubjectDistance' },
	'subjectdistancerange' => { 122 => 0xa40c, 511 => 'SubjectDistanceRange' },
	'subjectlocation' => { 122 => 0xa214, 511 => 'SubjectLocation' },
	'subjectmotion' => { 304 => '78.2', 305 => '78.2', 315 => '78.2', 317 => 0x103, 318 => 0x103, 319 => 0x119 },
	'subjectprogram' => { 184 => 0x22 },
	'subjectreference' => { 134 => 0xc },
	'sublabels1' => { 517 => [\'TagStructure','TagStructureSubLabels'] },
	'sublabels2' => { 517 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublabels3' => { 517 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'sublabels4' => { 517 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 517 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 117 => 'Exif-SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 117 => 'Exif-SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 117 => 'Exif-SubSecModifyDate' },
	'subsectime' => { 122 => 0x9290 },
	'subsectimedigitized' => { 122 => 0x9292 },
	'subsectimeoriginal' => { 122 => 0x9291 },
	'subsection1' => { 524 => 'subsection1' },
	'subsection2' => { 524 => 'subsection2' },
	'subsection3' => { 524 => 'subsection3' },
	'subsection4' => { 524 => 'subsection4' },
	'subselector' => { 302 => '49.1', 304 => '71.1', 305 => '71.1', 315 => '71.1', 317 => 0x8f, 318 => 0x8f, 319 => 0x8f },
	'subselectorassignment' => { 302 => '48.1' },
	'subselectorcenter' => { 304 => '72.1', 305 => '72.1', 315 => '72.1' },
	'subselectorplusdials' => { 302 => '49.2', 304 => '73.1', 305 => '73.1', 315 => '73.1' },
	'subtitle' => { 182 => 'WM/SubTitle', 396 => "\xa9st3", 404 => "\xa9snm", 524 => 'subtitle' },
	'subtitlekeywords' => { 404 => "\xa9snk" },
	'subversionfilename' => { 517 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 517 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 517 => 'SubVersions' },
	'superimposeddisplay' => { 85 => 0xa, 87 => 0x510, 88 => 0x9, 89 => 0xa, 92 => 0xa, 93 => 0xe },
	'supermacro' => { 66 => 0x1a },
	'supplementalcategories' => { 134 => 0x14, 522 => 'SupplementalCategories' },
	'supplementaltype' => { 136 => 0x37 },
	'supplementdisplayid' => { 524 => 'supplementDisplayID' },
	'supplementstartingpage' => { 524 => 'supplementStartingPage' },
	'supplementtitle' => { 524 => 'supplementTitle' },
	'supplychainsource' => { 519 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 519 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 519 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'supportsamount' => { 505 => 'SupportsAmount', 507 => 'SupportsAmount' },
	'supportscolor' => { 505 => 'SupportsColor', 507 => 'SupportsColor' },
	'supportshighdynamicrange' => { 505 => 'SupportsHighDynamicRange', 507 => 'SupportsHighDynamicRange' },
	'supportsmonochrome' => { 505 => 'SupportsMonochrome', 507 => 'SupportsMonochrome' },
	'supportsnormaldynamicrange' => { 505 => 'SupportsNormalDynamicRange', 507 => 'SupportsNormalDynamicRange' },
	'supportsoutputreferred' => { 505 => 'SupportsOutputReferred', 507 => 'SupportsOutputReferred' },
	'supportsscenereferred' => { 505 => 'SupportsSceneReferred', 507 => 'SupportsSceneReferred' },
	'svisosetting' => { 360 => 0x14 },
	'swatchcoloranta' => { 539 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 539 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 539 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 539 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 539 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 539 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 539 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 539 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 539 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 539 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 539 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 539 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 539 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 539 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 539 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 539 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 539 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 539 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 539 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 344 => 0x93, 433 => 0x33 },
	'sweeppanoramafieldofview' => { 344 => 0x94 },
	'sweeppanoramasize' => { 433 => 0x32 },
	'switchtoregisteredafpoint' => { 86 => 0x12, 87 => 0x50a },
	'symlink' => { 123 => 'SymLink' },
	'syncreleasemode' => { 304 => '77.1', 305 => '77.1', 315 => '77.1', 317 => 0x41, 318 => 0x41, 319 => 0x41 },
	'system' => { 388 => 0x204 },
	'tagged' => { 390 => 0xdd, 391 => 'Tagged', 500 => 'tagged' },
	'tagslist' => { 510 => 'TagsList' },
	'tagstructure' => { 517 => 'TagStructure' },
	'takenumber' => { 534 => 'takeNumber' },
	'tapename' => { 534 => 'tapeName' },
	'targetaperture' => { 79 => 0x4 },
	'targetcompressionratio' => { 98 => 0x1 },
	'targetdistancesetting' => { 100 => 0x1807 },
	'targetexposuretime' => { 79 => 0x5 },
	'targetimagetype' => { 100 => 0x100a },
	'targetprinter' => { 122 => 0x151 },
	'taxon' => { 121 => 'Taxon' },
	'taxonacceptednameusage' => { 121 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 121 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 121 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 121 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxoncultivarepithet' => { 121 => [\'Taxon','TaxonCultivarEpithet'] },
	'taxonfamily' => { 121 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 121 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 121 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 121 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 121 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 121 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 121 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 121 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 121 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 121 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 121 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 121 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 121 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 121 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 121 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 121 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 121 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 121 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 121 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 121 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 121 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 121 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 121 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 121 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 121 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 121 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 121 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 121 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 121 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 141 => 0x196f },
	'tda1edgepolarity' => { 141 => 0x1971 },
	'tda1gain' => { 141 => 0x1970 },
	'tda1offset' => { 141 => 0x196e },
	'tda2bandwidth' => { 141 => 0x1979 },
	'tda2edgepolarity' => { 141 => 0x197b },
	'tda2gain' => { 141 => 0x197a },
	'tda2offset' => { 141 => 0x1978 },
	'tda3bandwidth' => { 141 => 0x1983 },
	'tda3edgepolarity' => { 141 => 0x1985 },
	'tda3gain' => { 141 => 0x1984 },
	'tda3offset' => { 141 => 0x1982 },
	'tda4bandwidth' => { 141 => 0x198d },
	'tda4edgepolarity' => { 141 => 0x198f },
	'tda4gain' => { 141 => 0x198e },
	'tda4offset' => { 141 => 0x198c },
	'teaser' => { 524 => 'teaser' },
	'teleconverter' => { 189 => 0x105, 444 => 0x105 },
	'tempampgainx100' => { 141 => 0x1914 },
	'tempo' => { 534 => 'tempo' },
	'temporalcoverage' => { 519 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 519 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 519 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 331 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 331 => 'TermsAndConditionsURL' },
	'testname' => { 123 => 'TestName' },
	'textencoding' => { 237 => 0x4 },
	'textlayername' => { 522 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 522 => 'TextLayers' },
	'textlayertext' => { 522 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 344 => [0x8008,0x8009,0x3b,0x3e] },
	'texture' => { 505 => 'Texture', 507 => 'Texture' },
	'three-dtrackingfacedetection' => { 304 => '1.4', 305 => '1.4', 315 => '1.4' },
	'three-dtrackingwatcharea' => { 304 => '78.1', 305 => '78.1', 315 => '78.1' },
	'thresholding' => { 122 => 0x107 },
	'thumbnailfilename' => { 100 => 0x817 },
	'thumbnailformat' => { 532 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 145 => 0xfa55, 532 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 6 => 'CNDA', 100 => 0x2008, 117 => 'Exif-ThumbnailImage', 125 => 0x3, 170 => 'data', 326 => 0x100, 404 => 'thmb', 532 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 170 => '1Name' },
	'thumbnailimagesize' => { 170 => 'ImageSize' },
	'thumbnailimagetype' => { 170 => '0Type' },
	'thumbnailimagevalidarea' => { 66 => 0x13 },
	'thumbnaillength' => { 122 => 0x202 },
	'thumbnailoffset' => { 122 => 0x201 },
	'thumbnailpng' => { 404 => 'thmb' },
	'thumbnails' => { 532 => 'Thumbnails' },
	'thumbnailwidth' => { 145 => 0xfa54, 532 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 524 => 'ticker' },
	'tiffhandling' => { 505 => 'TIFFHandling', 507 => 'TIFFHandling' },
	'tiffmeteringimage' => { 190 => 0x104c, 442 => 0x1110 },
	'tilelength' => { 122 => 0x143 },
	'tilewidth' => { 122 => 0x142 },
	'time' => { 141 => 0x401, 379 => 0x7 },
	'timecodes' => { 122 => 0xc763 },
	'timecreated' => { 134 => 0x3c, 143 => 0x14, 152 => 0x10, 391 => 'TimeCreated' },
	'timelapseshotnumber' => { 347 => 0x10 },
	'timeperiod' => { 524 => 'timePeriod' },
	'timerfunctionbutton' => { 303 => '5.2', 306 => '12.1', 307 => '13.1' },
	'timerlength' => { 87 => 0x80c },
	'timerrecording' => { 344 => 0x96 },
	'timescaleparams' => { 534 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 534 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 534 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 534 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 135 => 0x50 },
	'timeshot' => { 495 => 'TimeShot' },
	'timesignature' => { 534 => 'timeSignature' },
	'timesincepoweron' => { 344 => 0x29 },
	'timestamp' => { 11 => 0x45e, 19 => 0x11c, 320 => 0x8, 334 => 'TimeStamp', 344 => 0xaf, 494 => 'Timestamp', 501 => 'Timestamp', 517 => 'TimeStamp' },
	'timestamp1' => { 11 => 0x45a },
	'timezone' => { 80 => 0x1, 243 => 0x694, 244 => 0x594, 245 => 0x5c4, 246 => 0x5dc, 286 => 0x0, 414 => 0xa },
	'timezonecity' => { 80 => 0x2 },
	'timezonecode' => { 103 => 0x1 },
	'timezoneinfo' => { 103 => 0x2 },
	'timezoneoffset' => { 122 => 0x882a },
	'tint' => { 398 => 'player.movie.visual.tint', 505 => 'Tint', 507 => 'Tint' },
	'title' => { 122 => 0xa436, 160 => 'Title', 330 => 'Title', 334 => 'Title', 344 => 0x65, 395 => 'Title', 396 => ['titl',"\xa9nam"], 398 => 'title', 404 => ['titl',"\xa9nam"], 508 => 'title', 521 => 'Title', 532 => 'Title' },
	'togglestyleamount' => { 505 => 'ToggleStyleAmount', 507 => 'ToggleStyleAmount' },
	'togglestyledigest' => { 505 => 'ToggleStyleDigest', 507 => 'ToggleStyleDigest' },
	'tonecomp' => { 238 => 0x81 },
	'tonecurve' => { 76 => 0x1, 379 => 0x402, 505 => 'ToneCurve', 507 => 'ToneCurve' },
	'tonecurveactive' => { 111 => 0x110 },
	'tonecurveadobergb' => { 418 => 0xa043 },
	'tonecurveadobergbdefault' => { 418 => 0xa041 },
	'tonecurveblue' => { 505 => 'ToneCurveBlue', 507 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 481 => 0x9003 },
	'tonecurvebluey' => { 481 => 0x9007 },
	'tonecurvebrightness' => { 106 => 0x20410 },
	'tonecurvebrightnessx' => { 481 => 0x9000 },
	'tonecurvebrightnessy' => { 481 => 0x9004 },
	'tonecurvecolorspace' => { 110 => 0x0 },
	'tonecurvecontrast' => { 106 => 0x20411 },
	'tonecurvegreen' => { 505 => 'ToneCurveGreen', 507 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 481 => 0x9002 },
	'tonecurvegreeny' => { 481 => 0x9006 },
	'tonecurveinputrange' => { 110 => 0x3 },
	'tonecurveinterpolation' => { 111 => 0x159 },
	'tonecurvemode' => { 111 => 0x113 },
	'tonecurvename' => { 505 => 'ToneCurveName', 507 => 'ToneCurveName' },
	'tonecurvename2012' => { 505 => 'ToneCurveName2012', 507 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 106 => '0x20400.1' },
	'tonecurveoutputrange' => { 110 => 0x5 },
	'tonecurveprofilename' => { 141 => 0x1391 },
	'tonecurveproperty' => { 111 => 0x3c },
	'tonecurvepv2012' => { 505 => 'ToneCurvePV2012', 507 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 505 => 'ToneCurvePV2012Blue', 507 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 505 => 'ToneCurvePV2012Green', 507 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 505 => 'ToneCurvePV2012Red', 507 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 505 => 'ToneCurveRed', 507 => 'ToneCurveRed' },
	'tonecurveredx' => { 481 => 0x9001 },
	'tonecurveredy' => { 481 => 0x9005 },
	'tonecurves' => { 379 => 0x403 },
	'tonecurveshape' => { 110 => 0x1 },
	'tonecurvesrgb' => { 418 => 0xa042 },
	'tonecurvesrgbdefault' => { 418 => 0xa040 },
	'tonecurvex' => { 110 => 0xa },
	'tonecurvey' => { 110 => 0xb },
	'tonelevel' => { 321 => 0x52e },
	'tonemap' => { 243 => 0x26a },
	'tonemapstrength' => { 505 => 'ToneMapStrength', 507 => 'ToneMapStrength' },
	'toningeffect' => { 59 => 0xf, 238 => 0xb3, 253 => 0x38, 254 => 0x40, 255 => 0x48, 411 => 0x1015 },
	'toningeffectauto' => { 73 => 0xa4 },
	'toningeffectfaithful' => { 72 => 0x74, 73 => 0x74 },
	'toningeffectlandscape' => { 72 => 0x44, 73 => 0x44 },
	'toningeffectmonochrome' => { 19 => 0x108, 72 => 0x8c, 73 => 0x8c },
	'toningeffectneutral' => { 72 => 0x5c, 73 => 0x5c },
	'toningeffectportrait' => { 72 => 0x2c, 73 => 0x2c },
	'toningeffectstandard' => { 72 => 0x14, 73 => 0x14 },
	'toningeffectuserdef1' => { 72 => 0xa4, 73 => 0xbc },
	'toningeffectuserdef2' => { 72 => 0xbc, 73 => 0xd4 },
	'toningeffectuserdef3' => { 72 => 0xd4, 73 => 0xec },
	'toningsaturation' => { 253 => 0x39, 254 => 0x41, 255 => 0x49 },
	'totalzoom' => { 143 => 0x62 },
	'touchae' => { 344 => 0xab },
	'track' => { 396 => "\xa9trk", 404 => "\xa9trk" },
	'trackcreatedate' => { 403 => 0x1 },
	'trackmodifydate' => { 403 => 0x2 },
	'tracknumber' => { 396 => 'trkn', 534 => 'trackNumber' },
	'tracks' => { 534 => 'Tracks' },
	'tracksframerate' => { 534 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 534 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 534 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 534 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 534 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 534 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 534 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 534 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 534 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 534 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 534 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 534 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 534 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 534 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 534 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 534 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 534 => [\'Tracks','TracksTrackType'] },
	'tracktype' => { 404 => 'kgtt' },
	'trailer' => { 123 => 'Trailer' },
	'trailersignature' => { 167 => 'zmie' },
	'transcript' => { 519 => 'Transcript' },
	'transcriptlink' => { 519 => 'TranscriptLink' },
	'transcriptlinklink' => { 519 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 519 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 122 => 0x12d, 530 => 'TransferFunction' },
	'transfertimenormal' => { 141 => 0x1888 },
	'transfertimetest' => { 141 => 0x1889 },
	'transform' => { 344 => [0x8012,0x59] },
	'transformation' => { 520 => 'Transformation' },
	'transmissionreference' => { 522 => 'TransmissionReference' },
	'trapped' => { 330 => 'Trapped', 521 => 'Trapped' },
	'trashbuttonfunction' => { 87 => 0x710 },
	'travelday' => { 344 => 0x36 },
	'treble' => { 398 => 'player.movie.audio.treble' },
	'triggermode' => { 405 => 0x6, 406 => 0x34, 407 => 0x34 },
	'tstop' => { 122 => 0xc772 },
	'ttl_da_adown' => { 367 => 0x5 },
	'ttl_da_aup' => { 367 => 0x4 },
	'ttl_da_bdown' => { 367 => 0x7 },
	'ttl_da_bup' => { 367 => 0x6 },
	'tungstenawb' => { 357 => 0x1 },
	'tvepisode' => { 396 => 'tves' },
	'tvepisodeid' => { 396 => 'tven' },
	'tvexposuretimesetting' => { 360 => 0x12 },
	'tvnetworkname' => { 396 => 'tvnn' },
	'tvseason' => { 396 => 'tvsn' },
	'tvshow' => { 396 => 'tvsh' },
	'type' => { 489 => 'Type', 508 => 'type', 529 => 'type' },
	'typestatus' => { 121 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 122 => 0xc614 },
	'uniquedocumentid' => { 134 => 0xbb },
	'uniquematrixauto' => { 141 => 0x7e9 },
	'uniquematrixcustom' => { 141 => 0x7e8 },
	'uniquematrixdaylight' => { 141 => 0x7e4 },
	'uniquematrixflash' => { 141 => 0x7e7 },
	'uniquematrixfluorescent' => { 141 => 0x7e6 },
	'uniquematrixtungsten' => { 141 => 0x7e5 },
	'uniqueobjectname' => { 135 => 0x64 },
	'units' => { 490 => 'Units' },
	'unknown_aacr' => { 396 => 'AACR' },
	'unknown_cdek' => { 396 => 'CDEK' },
	'unknown_cdet' => { 396 => 'CDET' },
	'unknownblock' => { 379 => 0x405 },
	'unknownblock1' => { 325 => 0x635 },
	'unknownblock2' => { 325 => 0x636 },
	'unknownblock3' => { 325 => 0x1103 },
	'unknownblock4' => { 325 => 0x1104 },
	'unknowncontrast' => { 112 => 0x45 },
	'unknowndate' => { 388 => 0x212 },
	'unknownev' => { 141 => 0x1 },
	'unknownlinear' => { 112 => 0x46 },
	'unknownnumber' => { 100 => 0x180b },
	'unknownoutputhighlightpoint' => { 112 => 0x4a },
	'unknownoutputshadowpoint' => { 112 => 0x4b },
	'unknownrawhighlight' => { 112 => 0x7b },
	'unknownrawhighlightpoint' => { 112 => 0x48 },
	'unknownrawshadow' => { 112 => 0x84 },
	'unknownrawshadowpoint' => { 112 => 0x49 },
	'unknownsharpness' => { 112 => 0x47 },
	'unknowntags' => { 404 => 'TAGS' },
	'unknowntemperature' => { 124 => 0x4 },
	'unknownthumbnail' => { 404 => 'thmb' },
	'unsharp1color' => { 299 => 0x13 },
	'unsharp1halowidth' => { 299 => 0x19 },
	'unsharp1intensity' => { 299 => 0x17 },
	'unsharp1threshold' => { 299 => 0x1b },
	'unsharp2color' => { 299 => 0x2e },
	'unsharp2halowidth' => { 299 => 0x34 },
	'unsharp2intensity' => { 299 => 0x32 },
	'unsharp2threshold' => { 299 => 0x36 },
	'unsharp3color' => { 299 => 0x49 },
	'unsharp3halowidth' => { 299 => 0x4f },
	'unsharp3intensity' => { 299 => 0x4d },
	'unsharp3threshold' => { 299 => 0x51 },
	'unsharp4color' => { 299 => 0x64 },
	'unsharp4halowidth' => { 299 => 0x6a },
	'unsharp4intensity' => { 299 => 0x68 },
	'unsharp4threshold' => { 299 => 0x6c },
	'unsharpcount' => { 299 => 0x0 },
	'unsharpmask' => { 112 => 0x90, 294 => 0x76a43200 },
	'unsharpmaskfineness' => { 106 => 0x20309 },
	'unsharpmaskstrength' => { 106 => 0x20308 },
	'unsharpmaskthreshold' => { 106 => 0x2030a },
	'uprightcentermode' => { 505 => 'UprightCenterMode', 507 => 'UprightCenterMode' },
	'uprightcenternormx' => { 505 => 'UprightCenterNormX', 507 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 505 => 'UprightCenterNormY', 507 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 505 => 'UprightDependentDigest', 507 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 505 => 'UprightFocalLength35mm', 507 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 505 => 'UprightFocalMode', 507 => 'UprightFocalMode' },
	'uprightfoursegments_0' => { 505 => 'UprightFourSegments_0', 507 => 'UprightFourSegments_0' },
	'uprightfoursegments_1' => { 505 => 'UprightFourSegments_1', 507 => 'UprightFourSegments_1' },
	'uprightfoursegments_2' => { 505 => 'UprightFourSegments_2', 507 => 'UprightFourSegments_2' },
	'uprightfoursegments_3' => { 505 => 'UprightFourSegments_3', 507 => 'UprightFourSegments_3' },
	'uprightfoursegmentscount' => { 505 => 'UprightFourSegmentsCount', 507 => 'UprightFourSegmentsCount' },
	'uprightguideddependentdigest' => { 505 => 'UprightGuidedDependentDigest', 507 => 'UprightGuidedDependentDigest' },
	'uprightpreview' => { 505 => 'UprightPreview', 507 => 'UprightPreview' },
	'uprighttransform_0' => { 505 => 'UprightTransform_0', 507 => 'UprightTransform_0' },
	'uprighttransform_1' => { 505 => 'UprightTransform_1', 507 => 'UprightTransform_1' },
	'uprighttransform_2' => { 505 => 'UprightTransform_2', 507 => 'UprightTransform_2' },
	'uprighttransform_3' => { 505 => 'UprightTransform_3', 507 => 'UprightTransform_3' },
	'uprighttransform_4' => { 505 => 'UprightTransform_4', 507 => 'UprightTransform_4' },
	'uprighttransform_5' => { 505 => 'UprightTransform_5', 507 => 'UprightTransform_5' },
	'uprighttransformcount' => { 505 => 'UprightTransformCount', 507 => 'UprightTransformCount' },
	'uprightversion' => { 505 => 'UprightVersion', 507 => 'UprightVersion' },
	'urgency' => { 134 => 0xa, 522 => 'Urgency' },
	'url' => { 160 => 'URL', 334 => 'URL', 393 => 0x40b, 524 => 'url' },
	'url_list' => { 393 => 0x41e },
	'urla-platform' => { 524 => [\'url','urlA-platform'] },
	'urlurl' => { 524 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 87 => 0x10a },
	'usableshootingmodes' => { 87 => 0x109 },
	'usage' => { 525 => 'usage' },
	'usageterms' => { 538 => 'UsageTerms' },
	'usbpowerdelivery' => { 243 => 0x762, 244 => 0x664, 245 => 0x694, 246 => 0x6fc },
	'usedialwithouthold' => { 317 => 0xbf, 318 => 0xbf, 319 => 0xbf },
	'useguidelines' => { 503 => 'useGuidelines' },
	'usepanoramaviewer' => { 493 => 'UsePanoramaViewer' },
	'usercollection' => { 398 => 'collection.user' },
	'usercomment' => { 100 => 0x805, 122 => 0x9286, 511 => 'UserComment' },
	'userdef1picturestyle' => { 19 => 0x10c, 72 => 0xd8, 73 => 0xf0 },
	'userdef2picturestyle' => { 19 => 0x10e, 72 => 0xda, 73 => 0xf2 },
	'userdef3picturestyle' => { 19 => 0x110, 72 => 0xdc, 73 => 0xf4 },
	'userfields' => { 498 => 'UserFields' },
	'userlabel' => { 405 => 0x2b, 406 => 0x5a, 407 => 0x68 },
	'userprofile' => { 339 => 0x302, 343 => 0x34c, 346 => 0x3038 },
	'userrating' => { 398 => 'rating.user', 404 => 'urat' },
	'usmlenselectronicmf' => { 2 => 0x7, 86 => 0x7, 87 => 0x501 },
	'uspsnumber' => { 524 => 'uspsNumber' },
	'utmeasting' => { 171 => 'Easting' },
	'utmmapdatum' => { 171 => 'Datum' },
	'utmnorthing' => { 171 => 'Northing' },
	'utmzone' => { 171 => 'Zone' },
	'uuid' => { 505 => 'UUID', 507 => 'UUID' },
	'uv-irfiltercorrection' => { 339 => 0x325 },
	'validbits' => { 325 => 0x611, 326 => 0x102c },
	'validpixeldepth' => { 329 => 0x611 },
	'variablelowpassfilter' => { 444 => 0x2028 },
	'variousmodes' => { 143 => 0x26 },
	'variousmodes2' => { 143 => 0x3a },
	'variprogram' => { 238 => 0xab },
	'varraydacnominalvalues' => { 141 => 0x191e },
	'vendor' => { 404 => 'vndr' },
	'vendorinfo' => { 484 => 'VendorInfo' },
	'vendorinfomanufacturer' => { 484 => [\'VendorInfo','VendorInfoManufacturer'] },
	'vendorinfomodel' => { 484 => [\'VendorInfo','VendorInfoModel'] },
	'vendorinfonotes' => { 484 => [\'VendorInfo','VendorInfoNotes'] },
	'verbatimidentification' => { 121 => [\'Identification','IdentificationVerbatimIdentification'] },
	'version' => { 130 => 0x0, 395 => 'Version', 398 => 'version', 505 => 'Version', 507 => 'Version', 516 => 'Version' },
	'versioncreatedate' => { 481 => 0xd100 },
	'versionid' => { 535 => 'VersionID' },
	'versionidentifier' => { 524 => 'versionIdentifier' },
	'versionmodifydate' => { 481 => 0xd101 },
	'versions' => { 535 => 'Versions' },
	'versionscomments' => { 535 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 535 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 535 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 535 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 535 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 535 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 535 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 535 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 535 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 535 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 535 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 301 => '3.2', 302 => '47.2', 304 => '79.1', 318 => 0x11d, 319 => 0x135 },
	'verticalclockoverlaps' => { 141 => 0x412 },
	'verticalfuncbutton' => { 302 => '42.2', 304 => '67.1', 318 => 0x115, 319 => 0x12d },
	'verticalfuncbuttonplaybackmode' => { 318 => 0x1b7, 319 => 0x1cf },
	'verticalfuncbuttonplusdials' => { 302 => '43.1' },
	'verticalfuncplusdials' => { 304 => '68.1' },
	'verticalisobutton' => { 246 => 0x792 },
	'verticalmovieafonbutton' => { 318 => 0x1f9, 319 => 0x211 },
	'verticalmoviefuncbutton' => { 318 => 0x1e1, 319 => 0x1f9 },
	'verticalmultiselector' => { 302 => '42.1', 304 => '66.1', 305 => '66.1', 315 => '66.1', 318 => 0x18f, 319 => 0x1a7 },
	'verticalmultiselectorplaybackmode' => { 318 => 0x125, 319 => 0x13d },
	'vfdisplayillumination' => { 2 => 0x11, 87 => [0x510,0x51d] },
	'vibrance' => { 499 => 'Vibrance', 505 => 'Vibrance', 507 => 'Vibrance' },
	'vibrationreduction' => { 266 => [0x75,0x82,0x1ae], 274 => '586.1', 281 => '590.2', 285 => 0x4 },
	'videoalphamode' => { 534 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 534 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 534 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 534 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 534 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 534 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 534 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 534 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 534 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 534 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 534 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 534 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 534 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 534 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 534 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 534 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 534 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 534 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 519 => 'videoBitRate' },
	'videobitratemode' => { 519 => 'videoBitRateMode' },
	'videoburstmode' => { 344 => 0xbb },
	'videoburstresolution' => { 344 => 0xb3 },
	'videocodec' => { 69 => 0x74 },
	'videocolorspace' => { 534 => 'videoColorSpace' },
	'videocompression' => { 130 => 0x3806 },
	'videocompressor' => { 534 => 'videoCompressor' },
	'videodisplayaspectratio' => { 519 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 519 => 'videoEncodingProfile' },
	'videofieldorder' => { 534 => 'videoFieldOrder' },
	'videoframerate' => { 344 => 0x27, 534 => 'videoFrameRate' },
	'videoframesize' => { 534 => 'videoFrameSize' },
	'videoframesizeh' => { 534 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 534 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 534 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 534 => 'videoModDate' },
	'videopixelaspectratio' => { 534 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 534 => 'videoPixelDepth' },
	'videopreburst' => { 344 => 0xc1 },
	'videoquality' => { 116 => 0x4003 },
	'videorecordingmode' => { 130 => 0x3803 },
	'videoshottype' => { 519 => 'VideoShotType' },
	'videoshottypeidentifier' => { 519 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 519 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 519 => 'videoStreamsCount' },
	'viewfinder' => { 388 => 0x455 },
	'viewfinderdisplay' => { 301 => '12.4', 302 => '6.3' },
	'viewfinderwarning' => { 301 => '13.4', 311 => '3.5', 312 => '6.2', 316 => '4.4' },
	'viewfinderwarnings' => { 87 => 0x40a },
	'viewinfoduringexposure' => { 87 => 0x407 },
	'viewingmode' => { 433 => 0x2f, 449 => 0x18 },
	'viewingmode2' => { 433 => [0x85,0x285] },
	'viewmodeshoweffectsofsettings' => { 246 => 0x7d2, 317 => 0x2a9 },
	'viewpoint' => { 523 => 'viewpoint' },
	'vignetteamount' => { 505 => 'VignetteAmount', 507 => 'VignetteAmount' },
	'vignettecontrol' => { 238 => 0x2a, 294 => 0x76a43205 },
	'vignettecontrolintensity' => { 294 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 502 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 505 => 'VignetteMidpoint', 507 => 'VignetteMidpoint' },
	'vignetting' => { 411 => 0x1011, 418 => 0xa052 },
	'vignettingcorrection' => { 122 => 0x7031, 418 => 0xa053, 444 => 0x2011 },
	'vignettingcorrparams' => { 122 => 0x7032, 475 => 0x64a, 476 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 418 => 0xa054 },
	'virtualfocallength' => { 520 => 'VirtualFocalLength' },
	'virtualhorizonstyle' => { 317 => 0x167, 318 => 0x167, 319 => 0x17f },
	'virtualimagexcenter' => { 520 => 'VirtualImageXCenter' },
	'virtualimageycenter' => { 520 => 'VirtualImageYCenter' },
	'visualcolor' => { 519 => 'VisualColour' },
	'visualtechnique' => { 523 => 'visualTechnique' },
	'voicememo' => { 420 => 0x216 },
	'volume' => { 524 => 'volume' },
	'vr_0x66' => { 266 => 0x66 },
	'vrdoffset' => { 66 => 0xd0 },
	'vrmode' => { 243 => 0x226, 244 => 0x212, 245 => 0x226, 246 => 0x226, 285 => 0x6 },
	'vrtype' => { 285 => 0x8 },
	'waterdepth' => { 122 => 0x9403, 512 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 190 => 0x19a },
	'wb_bluelevel6500k' => { 190 => 0x18a },
	'wb_bluelevelcustom' => { 190 => 0x18e },
	'wb_bluelevelscloudy' => { 190 => 0x106 },
	'wb_bluelevelsdaylight' => { 190 => 0xea },
	'wb_bluelevelsflash' => { 190 => 0x122 },
	'wb_bluelevelsfluorescent' => { 190 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 190 => 0x254 },
	'wb_bluelevelsshade' => { 190 => 0x176 },
	'wb_bluelevelstungsten' => { 190 => 0xce },
	'wb_gbrglevels' => { 190 => 0xae, 193 => 0x4 },
	'wb_glevel' => { 325 => 0x11f },
	'wb_glevel3000k' => { 325 => 0x113 },
	'wb_glevel3300k' => { 325 => 0x114 },
	'wb_glevel3600k' => { 325 => 0x115 },
	'wb_glevel3900k' => { 325 => 0x116 },
	'wb_glevel4000k' => { 325 => 0x117 },
	'wb_glevel4300k' => { 325 => 0x118 },
	'wb_glevel4500k' => { 325 => 0x119 },
	'wb_glevel4800k' => { 325 => 0x11a },
	'wb_glevel5300k' => { 325 => 0x11b },
	'wb_glevel6000k' => { 325 => 0x11c },
	'wb_glevel6600k' => { 325 => 0x11d },
	'wb_glevel7500k' => { 325 => 0x11e },
	'wb_grbglevels' => { 207 => 0x0, 451 => 0x7303 },
	'wb_grbglevelsauto' => { 83 => 0x2, 451 => 0x7302 },
	'wb_grbglevelscloudy' => { 83 => 0x12 },
	'wb_grbglevelscustom1' => { 83 => 0x42 },
	'wb_grbglevelscustom2' => { 83 => 0x4a },
	'wb_grbglevelsdaylight' => { 83 => 0xa },
	'wb_grbglevelsflash' => { 83 => 0x32 },
	'wb_grbglevelsfluorescent' => { 83 => 0x22 },
	'wb_grbglevelsfluorhigh' => { 83 => 0x2a },
	'wb_grbglevelstungsten' => { 83 => 0x1a },
	'wb_grbglevelsunderwater' => { 83 => 0x3a },
	'wb_rbgglevels' => { 204 => 0x0 },
	'wb_rblevels' => { 208 => 0x270, 238 => 0xc, 325 => 0x100 },
	'wb_rblevels1' => { 350 => 0x2 },
	'wb_rblevels2' => { 350 => 0x5 },
	'wb_rblevels3' => { 350 => 0x8 },
	'wb_rblevels3000k' => { 325 => 0x102 },
	'wb_rblevels3300k' => { 325 => 0x103 },
	'wb_rblevels3500k' => { 190 => 0x430 },
	'wb_rblevels3600k' => { 325 => 0x104 },
	'wb_rblevels3900k' => { 325 => 0x105 },
	'wb_rblevels4' => { 350 => 0xb },
	'wb_rblevels4000k' => { 325 => 0x106 },
	'wb_rblevels4300k' => { 325 => 0x107 },
	'wb_rblevels4500k' => { 325 => 0x108 },
	'wb_rblevels4800k' => { 325 => 0x109 },
	'wb_rblevels5' => { 350 => 0xe },
	'wb_rblevels5300k' => { 325 => 0x10a },
	'wb_rblevels6' => { 350 => 0x11 },
	'wb_rblevels6000k' => { 325 => 0x10b },
	'wb_rblevels6500k' => { 190 => 0x420 },
	'wb_rblevels6600k' => { 325 => 0x10c },
	'wb_rblevels7' => { 350 => 0x14 },
	'wb_rblevels7500k' => { 325 => 0x10d },
	'wb_rblevelsauto' => { 208 => 0x272, 329 => 0x110 },
	'wb_rblevelscloudy' => { 190 => 0x3f0, 192 => 0x10, 208 => 0x296, 329 => 0x121 },
	'wb_rblevelscoolwhitef' => { 190 => 0x308, 192 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 329 => 0x132 },
	'wb_rblevelscustom' => { 190 => 0x424, 192 => 0x1c },
	'wb_rblevelscwb1' => { 325 => 0x10e },
	'wb_rblevelscwb2' => { 325 => 0x10f },
	'wb_rblevelscwb3' => { 325 => 0x110 },
	'wb_rblevelscwb4' => { 325 => 0x111 },
	'wb_rblevelsdaylight' => { 190 => [0x3ec,0x528], 192 => 0xc, 208 => 0x274 },
	'wb_rblevelsdaylightf' => { 192 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 329 => 0x130 },
	'wb_rblevelsdaywhitef' => { 192 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 329 => 0x131 },
	'wb_rblevelseveningsunlight' => { 329 => 0x124 },
	'wb_rblevelsfineweather' => { 329 => 0x122 },
	'wb_rblevelsflash' => { 190 => [0x3f4,0x304], 192 => 0x18, 208 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 208 => 0x290 },
	'wb_rblevelsincandescent' => { 208 => 0x282 },
	'wb_rblevelsshade' => { 190 => 0x418, 192 => 0x20, 208 => 0x2b2, 329 => 0x120 },
	'wb_rblevelstungsten' => { 190 => 0x3e8, 192 => 0x8, 329 => 0x123 },
	'wb_rblevelsused' => { 329 => 0x100 },
	'wb_rblevelswhitef' => { 192 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 329 => 0x133 },
	'wb_redlevel3500k' => { 190 => 0x198 },
	'wb_redlevel6500k' => { 190 => 0x188 },
	'wb_redlevelcustom' => { 190 => 0x18c },
	'wb_redlevelscloudy' => { 190 => 0xf8 },
	'wb_redlevelsdaylight' => { 190 => 0xdc },
	'wb_redlevelsflash' => { 190 => 0x114 },
	'wb_redlevelsfluorescent' => { 190 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 190 => 0x1be },
	'wb_redlevelsshade' => { 190 => 0x168 },
	'wb_redlevelstungsten' => { 190 => 0xc0 },
	'wb_rgbglevels' => { 206 => 0x0 },
	'wb_rgblevels' => { 190 => [0x546,0x96], 340 => 0xd, 341 => 0x413, 346 => 0x3036, 388 => 0x107, 453 => 0x117c, 454 => 0x1180, 455 => 0x115c, 456 => 0x11d8, 457 => 0x11b4, 458 => 0x106c, 459 => 0x264, 460 => 0x264, 461 => 0x252 },
	'wb_rgblevels1' => { 351 => 0x2 },
	'wb_rgblevels2' => { 351 => 0x6 },
	'wb_rgblevels2500k' => { 451 => 0x782d },
	'wb_rgblevels3' => { 351 => 0xa },
	'wb_rgblevels3200k' => { 451 => 0x782c },
	'wb_rgblevels4' => { 351 => 0xe },
	'wb_rgblevels4500k' => { 451 => [0x7484,0x7824] },
	'wb_rgblevels5' => { 351 => 0x12 },
	'wb_rgblevels6' => { 351 => 0x16 },
	'wb_rgblevels6000k' => { 451 => 0x782b },
	'wb_rgblevels7' => { 351 => 0x1a },
	'wb_rgblevels8500k' => { 451 => 0x782a },
	'wb_rgblevelsauto' => { 422 => 0x0 },
	'wb_rgblevelscloudy' => { 451 => [0x7481,0x7821] },
	'wb_rgblevelscustom1' => { 422 => 0x15 },
	'wb_rgblevelscustom2' => { 422 => 0x18 },
	'wb_rgblevelscustom3' => { 422 => 0x1b },
	'wb_rgblevelsdaylight' => { 422 => 0x3, 451 => [0x7480,0x7820] },
	'wb_rgblevelsflash' => { 422 => 0x12, 451 => [0x7483,0x7823] },
	'wb_rgblevelsfluorescent' => { 422 => 0xf, 451 => [0x7486,0x7826] },
	'wb_rgblevelsfluorescentm1' => { 451 => 0x7829 },
	'wb_rgblevelsfluorescentp1' => { 451 => 0x7827 },
	'wb_rgblevelsfluorescentp2' => { 451 => 0x7828 },
	'wb_rgblevelsincandescent' => { 422 => 0xc },
	'wb_rgblevelsovercast' => { 422 => 0x9 },
	'wb_rgblevelsshade' => { 422 => 0x6, 451 => 0x7825 },
	'wb_rgblevelstungsten' => { 451 => [0x7482,0x7822] },
	'wb_rgblevelsunknown0' => { 423 => 0x0 },
	'wb_rgblevelsunknown1' => { 423 => 0x3 },
	'wb_rgblevelsunknown2' => { 423 => 0x6 },
	'wb_rgblevelsunknown3' => { 423 => 0x9 },
	'wb_rgblevelsunknown4' => { 423 => 0xc },
	'wb_rgblevelsunknown5' => { 423 => 0xf },
	'wb_rgblevelsunknown6' => { 423 => 0x12 },
	'wb_rgblevelsunknown7' => { 423 => 0x15 },
	'wb_rgblevelsunknown8' => { 423 => 0x18 },
	'wb_rgblevelsunknown9' => { 423 => 0x1b },
	'wb_rgbmuldaylight' => { 141 => 0x852 },
	'wb_rgbmulflash' => { 141 => 0x855 },
	'wb_rgbmulfluorescent' => { 141 => 0x854 },
	'wb_rgbmultungsten' => { 141 => 0x853 },
	'wb_rggbblacklevels' => { 37 => 0x25 },
	'wb_rggblevels' => { 122 => 0x7313, 193 => 0x4, 205 => 0x0, 209 => 0x13e8, 210 => 0x38, 451 => 0x7313 },
	'wb_rggblevelsasshot' => { 40 => 0x0, 41 => 0x0, 42 => 0x19, 43 => 0x55, 44 => 0x69, 45 => 0x22, 46 => 0x3f, 49 => 0x3f, 50 => 0x3f, 51 => 0x3f, 52 => 0x47 },
	'wb_rggblevelsauto' => { 37 => 0x1, 40 => 0x5, 41 => 0x8, 42 => 0x1e, 43 => 0x5a, 44 => 0x6e, 45 => 0x18, 46 => 0x44, 49 => 0x44, 50 => 0x44, 51 => 0x44, 52 => 0x4c, 209 => 0x1478, 210 => 0x114, 418 => 0xa022, 451 => 0x7312 },
	'wb_rggblevelsblack' => { 418 => 0xa028 },
	'wb_rggblevelscloudy' => { 37 => 0xd, 40 => 0x1e, 41 => 0x30, 42 => 0x2d, 43 => 0xa0, 44 => 0xd7, 45 => 0x31, 46 => 0x58, 49 => 0x71, 50 => 0x8a, 51 => 0x8f, 52 => 0x92, 209 => 0x1408, 210 => 0x60, 379 => 0x20f, 387 => 0x14 },
	'wb_rggblevelscustom' => { 37 => 0x1d, 46 => 0x80, 209 => 0x1468, 210 => 0x100 },
	'wb_rggblevelscustom1' => { 42 => 0x41 },
	'wb_rggblevelscustom2' => { 42 => 0x46 },
	'wb_rggblevelsdaylight' => { 37 => 0x5, 40 => 0x14, 41 => 0x20, 42 => 0x23, 43 => 0x96, 44 => 0xcd, 45 => 0x27, 46 => 0x4e, 49 => 0x67, 50 => 0x80, 51 => 0x85, 52 => 0x88, 209 => 0x13f8, 210 => 0x4c, 379 => 0x20d, 387 => 0x2 },
	'wb_rggblevelsflash' => { 37 => 0x19, 40 => 0x32, 41 => 0x50, 42 => 0x3c, 43 => 0xb4, 44 => 0xeb, 45 => 0x45, 46 => 0x6c, 49 => 0x85, 50 => 0x9e, 51 => 0xa3, 52 => 0xa6, 209 => 0x1448, 379 => 0x214, 387 => 0x41 },
	'wb_rggblevelsfluorescent' => { 37 => 0x15, 40 => 0x28, 41 => 0x40, 42 => 0x37, 43 => 0xaa, 44 => 0xe1, 45 => 0x3b, 46 => 0x62, 49 => 0x7b, 50 => 0x94, 51 => 0x99, 52 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 210 => 0xc4, 379 => 0x211, 387 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 387 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 210 => 0xb0, 379 => 0x212, 387 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 209 => 0x1438, 210 => 0x9c, 379 => 0x213, 387 => 0x38 },
	'wb_rggblevelshtmercury' => { 210 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 418 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 418 => 0xa024 },
	'wb_rggblevelskelvin' => { 37 => 0x21, 40 => 0x2d, 41 => 0x48, 43 => 0xaf, 44 => 0xe6, 45 => 0x40, 46 => 0x67, 49 => 0x80, 50 => 0x99, 51 => 0x9e, 52 => 0xa1 },
	'wb_rggblevelsmeasured' => { 40 => 0xa, 41 => 0x10, 43 => 0x5f, 44 => 0x73, 46 => 0x49, 49 => 0x49, 50 => 0x49, 51 => 0x49, 52 => 0x51 },
	'wb_rggblevelspc1' => { 45 => 0x90, 46 => 0x71 },
	'wb_rggblevelspc2' => { 45 => 0x95, 46 => 0x76 },
	'wb_rggblevelspc3' => { 45 => 0x9a, 46 => 0x7b },
	'wb_rggblevelsshade' => { 37 => 0x9, 40 => 0x19, 41 => 0x28, 42 => 0x28, 43 => 0x9b, 44 => 0xd2, 45 => 0x2c, 46 => 0x53, 49 => 0x6c, 50 => 0x85, 51 => 0x8a, 52 => 0x8d, 210 => 0x74, 379 => 0x20e, 387 => 0xb },
	'wb_rggblevelstungsten' => { 37 => 0x11, 40 => 0x23, 41 => 0x38, 42 => 0x32, 43 => 0xa5, 44 => 0xdc, 45 => 0x36, 46 => 0x5d, 49 => 0x76, 50 => 0x8f, 51 => 0x94, 52 => 0x97, 209 => 0x1428, 210 => 0x88, 379 => 0x210, 387 => 0x1d },
	'wb_rggblevelsuncorrected' => { 418 => 0xa021 },
	'wb_rggblevelsunknown' => { 40 => 0xf, 41 => 0x18, 43 => 0x64, 44 => 0x78, 45 => 0x1d, 49 => 0x4e, 50 => 0x4e, 51 => 0x4e, 52 => 0x56, 387 => 0x53 },
	'wb_rggblevelsunknown10' => { 40 => 0x5f, 41 => 0x98, 43 => 0x91, 44 => 0xa5, 45 => 0x72, 49 => 0x9e, 50 => 0x7b, 51 => 0x7b, 52 => 0x83 },
	'wb_rggblevelsunknown11' => { 40 => 0x64, 41 => 0xa0, 43 => 0xb9, 44 => [0xaa,0xaf], 45 => 0x77, 49 => 0xa3, 50 => 0xa3, 51 => 0x80, 52 => 0xab },
	'wb_rggblevelsunknown12' => { 40 => 0x69, 41 => 0xa8, 43 => 0xbe, 44 => 0xb4, 45 => 0x7c, 49 => 0xa8, 50 => 0xa8, 51 => 0xa8, 52 => 0xb0 },
	'wb_rggblevelsunknown13' => { 40 => 0x6e, 41 => 0xb0, 43 => 0xc3, 44 => 0xb9, 45 => 0x81, 49 => 0xad, 50 => 0xad, 51 => 0xad, 52 => 0xb5 },
	'wb_rggblevelsunknown14' => { 43 => 0xc8, 44 => 0xbe, 45 => 0x86, 49 => 0xb2, 50 => 0xb2, 51 => 0xb2, 52 => 0xba },
	'wb_rggblevelsunknown15' => { 43 => 0xcd, 44 => 0xc3, 45 => 0x8b, 49 => 0xb7, 50 => 0xb7, 51 => 0xb7, 52 => 0xbf },
	'wb_rggblevelsunknown16' => { 43 => 0xd2, 44 => 0xc8, 45 => 0x9f, 50 => 0xbc, 51 => 0xbc, 52 => 0xc4 },
	'wb_rggblevelsunknown17' => { 43 => 0xd7, 44 => 0xf0, 50 => 0xc1, 51 => 0xc1, 52 => 0xc9 },
	'wb_rggblevelsunknown18' => { 43 => 0xdc, 44 => 0xf5, 50 => 0xc6, 51 => 0xc6, 52 => 0xce },
	'wb_rggblevelsunknown19' => { 43 => 0xe1, 44 => 0xfa, 50 => 0xcb, 51 => 0xcb, 52 => 0xd3 },
	'wb_rggblevelsunknown2' => { 40 => 0x37, 41 => 0x58, 43 => 0x69, 44 => 0x7d, 45 => 0x4a, 49 => 0x53, 50 => 0x53, 51 => 0x53, 52 => 0x5b },
	'wb_rggblevelsunknown20' => { 43 => 0xe6, 44 => 0xff, 50 => 0xd0, 51 => 0xd0, 52 => 0xd8 },
	'wb_rggblevelsunknown21' => { 43 => 0xeb, 44 => 0x104, 51 => 0xd5, 52 => 0xdd },
	'wb_rggblevelsunknown22' => { 43 => 0xf0, 44 => 0x109, 51 => 0xda, 52 => 0xe2 },
	'wb_rggblevelsunknown23' => { 43 => 0xf5, 44 => 0x10e, 51 => 0xdf, 52 => 0xe7 },
	'wb_rggblevelsunknown24' => { 43 => 0xfa, 44 => 0x113, 51 => 0xe4, 52 => 0xec },
	'wb_rggblevelsunknown25' => { 43 => 0xff, 44 => 0x118, 51 => 0xe9, 52 => 0xf1 },
	'wb_rggblevelsunknown26' => { 43 => 0x104, 44 => 0x11d, 51 => 0xee, 52 => 0xf6 },
	'wb_rggblevelsunknown27' => { 43 => 0x109, 44 => 0x122, 51 => 0xf3, 52 => 0xfb },
	'wb_rggblevelsunknown28' => { 43 => 0x10e, 51 => 0xf8, 52 => 0x100 },
	'wb_rggblevelsunknown29' => { 43 => 0x113, 51 => 0xfd, 52 => 0x105 },
	'wb_rggblevelsunknown3' => { 40 => 0x3c, 41 => 0x60, 43 => 0x6e, 44 => 0x82, 45 => 0x4f, 49 => 0x58, 50 => 0x58, 51 => 0x58, 52 => 0x60 },
	'wb_rggblevelsunknown30' => { 51 => 0x102 },
	'wb_rggblevelsunknown4' => { 40 => 0x41, 41 => 0x68, 43 => 0x73, 44 => 0x87, 45 => 0x54, 49 => 0x5d, 50 => 0x5d, 51 => 0x5d, 52 => 0x65 },
	'wb_rggblevelsunknown5' => { 40 => 0x46, 41 => 0x70, 43 => 0x78, 44 => 0x8c, 45 => 0x59, 49 => 0x62, 50 => 0x62, 51 => 0x62, 52 => 0x6a },
	'wb_rggblevelsunknown6' => { 40 => 0x4b, 41 => 0x78, 43 => 0x7d, 44 => 0x91, 45 => 0x5e, 49 => 0x8a, 50 => 0x67, 51 => 0x67, 52 => 0x6f },
	'wb_rggblevelsunknown7' => { 40 => 0x50, 41 => 0x80, 43 => 0x82, 44 => 0x96, 45 => 0x63, 49 => 0x8f, 50 => 0x6c, 51 => 0x6c, 52 => 0x74 },
	'wb_rggblevelsunknown8' => { 40 => 0x55, 41 => 0x88, 43 => 0x87, 44 => 0x9b, 45 => 0x68, 49 => 0x94, 50 => 0x71, 51 => 0x71, 52 => 0x79 },
	'wb_rggblevelsunknown9' => { 40 => 0x5a, 41 => 0x90, 43 => 0x8c, 44 => 0xa0, 45 => 0x6d, 49 => 0x99, 50 => 0x76, 51 => 0x76, 52 => 0x7e },
	'wb_rggblevelsuserselected' => { 387 => 0x5c },
	'wbadjblueamber' => { 106 => 0x20106 },
	'wbadjbluebalance' => { 300 => 0x8 },
	'wbadjcolortemp' => { 106 => 0x20102, 111 => 0x1a },
	'wbadjlighting' => { 300 => 0x14 },
	'wbadjmagentagreen' => { 106 => 0x20105 },
	'wbadjmode' => { 300 => 0x10 },
	'wbadjredbalance' => { 300 => 0x0 },
	'wbadjrggblevels' => { 106 => 0x20125, 111 => 0x6 },
	'wbadjtemperature' => { 300 => 0x18 },
	'wbadjtint' => { 300 => 0x25 },
	'wbbluelevel' => { 339 => 0x324, 344 => 0x8006, 349 => 0x26 },
	'wbbracketingsteps' => { 201 => 0x10, 202 => 0x10, 275 => 0x174d },
	'wbbracketmode' => { 59 => 0x9 },
	'wbbracketshotnumber' => { 190 => 0x2b, 411 => 0x101a },
	'wbbracketvalueab' => { 59 => 0xc },
	'wbbracketvaluegm' => { 59 => 0xd },
	'wbbutton' => { 246 => 0x80a },
	'wbfinetuneactive' => { 111 => 0x24 },
	'wbfinetunesaturation' => { 111 => 0x28 },
	'wbfinetunetone' => { 111 => 0x2c },
	'wbgreenlevel' => { 339 => 0x323, 344 => 0x8005, 349 => 0x25 },
	'wbmediaimagesizesetting' => { 87 => 0x708 },
	'wbmode' => { 192 => 0x4, 326 => 0x1015 },
	'wbredlevel' => { 339 => 0x322, 344 => 0x8004, 349 => 0x24 },
	'wbscale' => { 193 => 0x0 },
	'wbshiftab' => { 76 => 0xc, 344 => 0x46, 361 => 0x10 },
	'wbshiftab_gm' => { 444 => 0x2014 },
	'wbshiftab_gm_precise' => { 444 => 0x2026 },
	'wbshiftcreativecontrol' => { 344 => 0x92 },
	'wbshiftgm' => { 76 => 0xd, 344 => 0x47, 361 => 0x11 },
	'wbshiftintelligentauto' => { 344 => 0x8b },
	'wbtype1' => { 350 => 0x1, 351 => 0x1 },
	'wbtype2' => { 350 => 0x4, 351 => 0x5 },
	'wbtype3' => { 350 => 0x7, 351 => 0x9 },
	'wbtype4' => { 350 => 0xa, 351 => 0xd },
	'wbtype5' => { 350 => 0xd, 351 => 0x11 },
	'wbtype6' => { 350 => 0x10, 351 => 0x15 },
	'wbtype7' => { 350 => 0x13, 351 => 0x19 },
	'webstatement' => { 538 => 'WebStatement' },
	'weightedflatsubject' => { 497 => 'weightedFlatSubject' },
	'what' => { 505 => 'What', 507 => 'What' },
	'whitebalance' => { 7 => 0x6f, 8 => [0x44,0x4a], 9 => 0xbc, 10 => 0x36, 11 => 0x5e, 12 => 0x36, 13 => 0x78, 14 => 0x6f, 15 => 0x6f, 16 => 0x73, 17 => 0x6f, 18 => 0x78, 19 => 0x54, 20 => 0x6f, 21 => 0xbc, 22 => 0x7b, 24 => 0xbc, 25 => 0xc2, 27 => 0x131, 28 => 0x77, 76 => 0x8, 79 => 0x7, 115 => 0x7, 116 => [0x19,0x2012], 122 => [0xa403,0xfe4e], 130 => 0x1002, 141 => 0x3fc, 142 => 0xfa0d, 143 => 0x40, 154 => 0x1a, 184 => 0x3, 185 => 0xe, 186 => 0x4, 187 => 0xb, 189 => 0x115, 238 => 0x5, 284 => 0x7, 339 => 0x304, 344 => 0x3, 346 => 0x3033, 379 => 0x19, 386 => 0x7, 410 => 0x26, 411 => 0x1003, 421 => [0x88,0x3c,0x7,0x58], 431 => 0xf, 432 => 0xe, 444 => [0x115,0xb054], 505 => 'WhiteBalance', 507 => 'WhiteBalance', 511 => 'WhiteBalance' },
	'whitebalance0' => { 179 => 'WhiteBalance0' },
	'whitebalance1' => { 179 => 'WhiteBalance1' },
	'whitebalance2' => { 179 => 'WhiteBalance2', 321 => 0x500 },
	'whitebalanceadj' => { 106 => 0x20101, 111 => 0x18, 294 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 357 => 0x0 },
	'whitebalancebias' => { 116 => 0x2011, 326 => 0x304, 344 => 0x23 },
	'whitebalanceblue' => { 76 => 0x7 },
	'whitebalancebracket' => { 321 => 0x502, 326 => 0x303 },
	'whitebalancebracketing' => { 187 => 0x22, 190 => 0x2c, 442 => 0x2c },
	'whitebalancebuttonplaybackmode' => { 318 => 0x1c5, 319 => 0x1dd },
	'whitebalancecomp' => { 329 => 0x1001 },
	'whitebalancedetected' => { 141 => 0x3fb },
	'whitebalancefinetune' => { 130 => 0x100a, 187 => 0x38, 189 => 0x112, 238 => [0xb,0x3f], 411 => 0x1004, 431 => 0x6, 432 => 0x5, 444 => 0x112 },
	'whitebalancemode' => { 141 => 0x3fa, 379 => 0x1a },
	'whitebalancered' => { 76 => 0x6 },
	'whitebalanceset' => { 360 => 0xa },
	'whitebalancesetting' => { 187 => 0x23, 431 => 0x5, 432 => 0x4, 433 => 0x16, 449 => 0xd },
	'whitebalancesetup' => { 418 => 0x41 },
	'whitebalancetemperature' => { 321 => 0x501 },
	'whiteboard' => { 326 => 0x301 },
	'whitelevel' => { 122 => 0xc61d, 379 => 0x7e, 451 => 0x787f },
	'whitepoint' => { 122 => 0x13e, 343 => 0x35d, 379 => 0x201, 530 => 'WhitePoint' },
	'whites2012' => { 505 => 'Whites2012', 507 => 'Whites2012' },
	'whitesadj' => { 481 => 0x9017 },
	'wideadapter' => { 411 => 0x1017 },
	'widefocuszone' => { 184 => 0x2f },
	'widerange' => { 420 => 0x20f },
	'windmode' => { 141 => 0x3f4 },
	'windnoisereduction' => { 243 => 0x352, 244 => 0x2d6, 245 => 0x2fe, 246 => 0x2fe },
	'windowlocation' => { 404 => 'WLOC' },
	'windowsatom' => { 506 => 'windowsAtom' },
	'windowsatomextension' => { 506 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 506 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 506 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 524 => 'wordCount' },
	'work' => { 396 => "\xa9wrk" },
	'workcolorspace' => { 106 => 0x10200, 111 => 0x270 },
	'workflowtag' => { 519 => 'WorkflowTag' },
	'workflowtagcvid' => { 519 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 519 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 519 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 519 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 513 => 'WorkToDo' },
	'worldtimelocation' => { 344 => 0x3a, 379 => 0x22, 385 => '0.1' },
	'writer' => { 182 => 'WM/Writer' },
	'writer-editor' => { 134 => 0x7a },
	'x3filllight' => { 421 => 0x12 },
	'xattrquarantine' => { 177 => 'com.apple.quarantine' },
	'xilinxversion' => { 141 => 0x414 },
	'xml' => { 139 => 'xml ' },
	'xmp' => { 109 => 0xffff00f6, 123 => 'XMP' },
	'xmptoolkit' => { 531 => 'xmptk' },
	'xpauthor' => { 122 => 0x9c9d },
	'xpcomment' => { 122 => 0x9c9c },
	'xpkeywords' => { 122 => 0x9c9e },
	'xposition' => { 122 => 0x11e },
	'xpsubject' => { 122 => 0x9c9f },
	'xptitle' => { 122 => 0x9c9b },
	'xresolution' => { 122 => 0x11a, 137 => 0x3, 394 => 0x0, 530 => 'XResolution' },
	'xyresolution' => { 126 => 0x3 },
	'yaw' => { 118 => 0x7, 404 => ['_yaw',"\xa9fyw"] },
	'yawangle' => { 251 => 0x8, 416 => 0x0 },
	'ycbcrcoefficients' => { 122 => 0x211, 530 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 122 => 0x213, 530 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 122 => 0x212, 530 => 'YCbCrSubSampling' },
	'year' => { 396 => 'yrrc', 398 => 'year', 404 => 'yrrc' },
	'yearcreated' => { 143 => 0x10, 152 => 0xc },
	'yellowhsl' => { 106 => 0x20912 },
	'yield' => { 526 => 'yield' },
	'yposition' => { 122 => 0x11f },
	'yresolution' => { 122 => 0x11b, 137 => 0x5, 394 => 0x4, 530 => 'YResolution' },
	'zebrapatterntonerange' => { 317 => 0x211, 318 => 0x211, 319 => 0x229 },
	'zoneidentifier' => { 123 => 'ZoneIdentifier' },
	'zonematching' => { 189 => 0x10a, 192 => [0x3a,0x4a], 444 => 0xb024 },
	'zonematchingmode' => { 187 => 0x14 },
	'zonematchingon' => { 186 => 0x75 },
	'zonematchingvalue' => { 431 => 0x1f },
	'zoomedpreviewlength' => { 326 => 0xf05 },
	'zoomedpreviewsize' => { 326 => 0xf06 },
	'zoomedpreviewstart' => { 326 => 0xf04 },
	'zoomsourcewidth' => { 36 => 0x24 },
	'zoomstepcount' => { 324 => 0x300, 326 => 0x100d },
	'zoomtargetwidth' => { 36 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_misb' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accel360fly' => 1,
	'acceldata' => 1,
	'accelerometermatrix' => 1,
	'accelerometertime' => 1,
	'accelerometerunknown' => 1,
	'accelmode' => 1,
	'accelypr' => 1,
	'accessdate' => 1,
	'accessrights' => 1,
	'accompaniment' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acidizer' => 1,
	'acidizerflags' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'additionalinfo' => 1,
	'adjdebuginfo' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aedebuginfo' => 1,
	'aeflags' => 1,
	'aehistograminfo' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'aeliveviewhistograminfo' => 1,
	'aeliveviewlocalhistogram' => 1,
	'aelocalhistogram' => 1,
	'af-cprioritysel' => 1,
	'af-sprioritysel' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'afdebuginfo' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airfieldbarometricpressure' => 1,
	'airfieldelevation' => 1,
	'airspeed' => 1,
	'airtemperature' => 1,
	'airulerunits' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartistsortorder' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternatealtitude' => 1,
	'alternateduotonecolors' => 1,
	'alternateellipsoidheight' => 1,
	'alternateellipsoidheightextended' => 1,
	'alternateheading' => 1,
	'alternatelatitude' => 1,
	'alternatelongitude' => 1,
	'alternatename' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'altitudefromtakeoff' => 1,
	'ambienceinfo' => 1,
	'ambisonicchannelmap' => 1,
	'ambisonicchannelordering' => 1,
	'ambisonicchannels' => 1,
	'ambisonicnormalization' => 1,
	'ambisonicorder' => 1,
	'ambisonictype' => 1,
	'amendlocalset' => 1,
	'angleaxis' => 1,
	'angleofattack' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'appledataoffsets' => 1,
	'applemaildatereceived' => 1,
	'applemaildatesent' => 1,
	'applemailflagged' => 1,
	'applemailisremoteattachment' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'application' => 1,
	'application_riff' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationunknown' => 1,
	'applicationversion' => 1,
	'applysettingstoliveview' => 1,
	'appname' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arcoreaccel' => 1,
	'arcorecustom' => 1,
	'arcoregyro' => 1,
	'arcorevideo' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artists' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantdirector' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'associateddatalist' => 1,
	'associatedimagefile' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'ast' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atob3' => 1,
	'atom0' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attr' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoridentifier' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorname' => 1,
	'authors' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'autoareaafstartingpoint' => 1,
	'autocaptureoffset' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'automationanimation' => 1,
	'automationflags' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimageref' => 1,
	'auxiliaryimagetype' => 1,
	'av1configuration' => 1,
	'av1configurationversion' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averageframerate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbdebuginfo' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'axml' => 1,
	'b1' => 1,
	'b2' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barcodes' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'basename' => 1,
	'baseviewpointnum' => 1,
	'basicfileinfo' => 1,
	'basisobject' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats' => 1,
	'beats-per-minute' => 1,
	'beautycolorlevel' => 1,
	'beautyretouchlevel' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bibliographicreferences' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binarydata' => 1,
	'binarydatatype' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'binning' => 1,
	'birthday' => 1,
	'bitdepthchroma' => 1,
	'bitdepthluma' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'blurstrength' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'body' => 1,
	'bokehshape' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bpm' => 1,
	'bps' => 1,
	'bracketingburstoptions' => 1,
	'bracketingcounter' => 1,
	'bracketingmode' => 1,
	'bracketingoffset' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'brdfatob0' => 1,
	'brdfatob1' => 1,
	'brdfatob2' => 1,
	'brdfatob3' => 1,
	'brdfbtoa0' => 1,
	'brdfbtoa1' => 1,
	'brdfbtoa2' => 1,
	'brdfbtoa3' => 1,
	'brdfbtod0' => 1,
	'brdfbtod1' => 1,
	'brdfbtod2' => 1,
	'brdfbtod3' => 1,
	'brdfcolorimetricparam0' => 1,
	'brdfcolorimetricparam1' => 1,
	'brdfcolorimetricparam2' => 1,
	'brdfcolorimetricparam3' => 1,
	'brdfdtob0' => 1,
	'brdfdtob1' => 1,
	'brdfdtob2' => 1,
	'brdfdtob3' => 1,
	'brdfmtob0' => 1,
	'brdfmtob1' => 1,
	'brdfmtob2' => 1,
	'brdfmtob3' => 1,
	'brdfmtos0' => 1,
	'brdfmtos1' => 1,
	'brdfmtos2' => 1,
	'brdfmtos3' => 1,
	'brdfspectralparam0' => 1,
	'brdfspectralparam1' => 1,
	'brdfspectralparam2' => 1,
	'brdfspectralparam3' => 1,
	'breakchar' => 1,
	'briefdescription' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'brotliexif' => 1,
	'brotlijumb' => 1,
	'brotlixmp' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btoa3' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwf_umid' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'byteordermark' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'c2pasalthash' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'callsign' => 1,
	'camcore' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapan' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'cameratilt' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfog5xii' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfor6' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'car' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'catalognumber' => 1,
	'caveats' => 1,
	'cbor' => 1,
	'cbordata' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'character' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'checksum' => 1,
	'children' => 1,
	'chmversion' => 1,
	'choregrapher' => 1,
	'chromaformat' => 1,
	'chromasampleposition' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chrominancetable' => 1,
	'chunkcount' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'churchillnav' => 1,
	'cicodepoints' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classificationandmarkingsystem' => 1,
	'classificationcomments' => 1,
	'classificationreason' => 1,
	'classifiedby' => 1,
	'classifyingcountry' => 1,
	'classifyingcountrycodemethod' => 1,
	'classifyingcountrycodingmethoddate' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmddialsaperturesetting' => 1,
	'cmddialschangemainsub' => 1,
	'cmddialschangemainsubexposure' => 1,
	'cmddialsmenuandplayback' => 1,
	'cmddialsreverserotexposurecomp' => 1,
	'cmmflags' => 1,
	'cmp1' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantinfoout' => 1,
	'colorantorder' => 1,
	'colorantorderout' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalance0219' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown1' => 1,
	'colorbalanceunknown2' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata10' => 1,
	'colordata11' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorencodingparams' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetricspecification' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorpopstrength' => 1,
	'colorprimaries' => 1,
	'colorprofiles' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspacename' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransferfunction' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columncount' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composernationality' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositeimaginglocalset' => 1,
	'compositinglayerheader' => 1,
	'compositionlocation' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressioncodecs' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'constantframerate' => 1,
	'constraintindicatorflags' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentlightlevel' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstatus' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'coproducer' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'cornerlatitude1' => 1,
	'cornerlatitude2' => 1,
	'cornerlatitude3' => 1,
	'cornerlatitude4' => 1,
	'cornerlongitude1' => 1,
	'cornerlongitude2' => 1,
	'cornerlongitude3' => 1,
	'cornerlongitude4' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crc' => 1,
	'crcdevelparams' => 1,
	'crd' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapp' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatormodule' => 1,
	'creatoros' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs0' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepointlabel' => 1,
	'cuepointnote' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'customsettingsz8' => 1,
	'customsettingsz9' => 1,
	'customsettingsz9v4' => 1,
	'customtostandardpcc' => 1,
	'cxf' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'd2' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateencoded' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datepurchased' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetagged' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'datewritten' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'db' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'declassificationdate' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultcmyk' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delimiter' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'densityaltitude' => 1,
	'densityaltitudeextended' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthhwheight' => 1,
	'depthhwwidth' => 1,
	'depthmapdata' => 1,
	'depthmapdata2' => 1,
	'depthmapheight' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'depthswheight' => 1,
	'depthswwidth' => 1,
	'derivedimageref' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'deviceorientation' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'differentialpressure' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directionalatob0' => 1,
	'directionalatob1' => 1,
	'directionalatob2' => 1,
	'directionalatob3' => 1,
	'directionalbtoa0' => 1,
	'directionalbtoa1' => 1,
	'directionalbtoa2' => 1,
	'directionalbtoa3' => 1,
	'directionalbtod0' => 1,
	'directionalbtod1' => 1,
	'directionalbtod2' => 1,
	'directionalbtod3' => 1,
	'directionaldtob0' => 1,
	'directionaldtob1' => 1,
	'directionaldtob2' => 1,
	'directionaldtob3' => 1,
	'directorofphotography' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distance' => 1,
	'distancefromhome' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'dji-dbg' => 1,
	'dji_dtat' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'docversion' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dronepitch' => 1,
	'dronequaternion' => 1,
	'droneroll' => 1,
	'droneyaw' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualshotextra' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'dynamicranger128' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit4data' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectstrength' => 1,
	'effectsvisible' => 1,
	'effecttype' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electricalextendermagnification' => 1,
	'electronicimagestabilization' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimage2' => 1,
	'embeddedimageclass' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagerectangle' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideo' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endianness' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'et' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'eventstarttime' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedalbumname' => 1,
	'extendedartistname' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedtracktitle' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'fax' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileguid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterparametersbinary' => 1,
	'filterparameterscustomcustomdata' => 1,
	'filterparametersexportexportdata' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finetune' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firmwareversion51' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfo0300' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flightdegree' => 1,
	'flightspeed' => 1,
	'flipstatus' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'flirdata' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'flyingstate' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusframesize' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspointbrightness' => 1,
	'focuspointselectionspeed' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'follow-meanimation' => 1,
	'follow-memode' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fps' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framebaseview' => 1,
	'framecenterelevation' => 1,
	'framecenterheightaboveellipsoid' => 1,
	'framecenterlatitude' => 1,
	'framecenterlongitude' => 1,
	'framedelay' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'frameview' => 1,
	'framinggriddisplay' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fuelremaining' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullangleofattack' => 1,
	'fullname' => 1,
	'fullpitchangle' => 1,
	'fullrollangle' => 1,
	'fullscreen' => 1,
	'fullsideslipangle' => 1,
	'fusion360fly' => 1,
	'fusionmode' => 1,
	'fusionypr' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gainmapimage' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gamutboundarydescription0' => 1,
	'gamutboundarydescription1' => 1,
	'gamutboundarydescription2' => 1,
	'gamutboundarydescription3' => 1,
	'gapless' => 1,
	'garmingps' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gcamera' => 1,
	'gcreations' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generalencapsulatedobject' => 1,
	'generallevelidc' => 1,
	'generalprofileidc' => 1,
	'generalprofilespace' => 1,
	'generaltierflag' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genericflagdata01' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genprofilecompatibilityflags' => 1,
	'genr' => 1,
	'geo' => 1,
	'geob-data' => 1,
	'geob-desc' => 1,
	'geob-file' => 1,
	'geob-mime' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geometricdistortionparams' => 1,
	'georegistrationlocalset' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbaldegree' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalpalette' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'gpano' => 1,
	'gpmd_fmas' => 1,
	'gpmd_gopro' => 1,
	'gpmd_kingslim' => 1,
	'gpmd_rove' => 1,
	'gps' => 1,
	'gps360fly' => 1,
	'gpsaltituderaw' => 1,
	'gpsdatalist' => 1,
	'gpsdatalist2' => 1,
	'gpsdatetimeraw' => 1,
	'gpsdestaltitude' => 1,
	'gpsframingaltitude' => 1,
	'gpsframinglatitude' => 1,
	'gpsframinglongitude' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongituderaw' => 1,
	'gpsmode' => 1,
	'gpspos' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpstargetaltitude' => 1,
	'gpstargetlatitude' => 1,
	'gpstargetlongitude' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocitydown' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'gridsize' => 1,
	'groundrange' => 1,
	'groupareac1' => 1,
	'groupcaption' => 1,
	'groupmutualexclusion' => 1,
	'groups' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guano' => 1,
	'gyro360fly' => 1,
	'gyromode' => 1,
	'gyroscope' => 1,
	'gyroscopeunknown' => 1,
	'gyroypr' => 1,
	'halftonedegree' => 1,
	'halftonelpi' => 1,
	'halftonelpiunit' => 1,
	'halftonemisc' => 1,
	'halftonescreen' => 1,
	'halftoneshape' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasselbladexif' => 1,
	'hasselbladrawimage' => 1,
	'hasselbladxml' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdmibitdepth' => 1,
	'hdmiexternalrecorder' => 1,
	'hdmioutputhdr' => 1,
	'hdmioutputrange' => 1,
	'hdrgm' => 1,
	'hdrinfo' => 1,
	'hdrinfo2' => 1,
	'hdrinfoversion' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hevcconfigurationversion' => 1,
	'hiddenslides' => 1,
	'highbitdepth' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'highnote' => 1,
	'highvelocity' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintmaxoutputvalue' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalfieldofview' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'hotspotx' => 1,
	'hotspoty' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huawei' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlapsdebuginfo' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'iad1' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iccprofilelocation' => 1,
	'icingdetected' => 1,
	'icondir' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'idstring' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagecoordinatesystem' => 1,
	'imagedatadiscard' => 1,
	'imagedatahash' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imagegeometry' => 1,
	'imageheader' => 1,
	'imageheightinches' => 1,
	'imagehorizonpixelpack' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagelocation' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imagepixeloffset' => 1,
	'imagepixelstorage' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesampleformat' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imagewidthinches' => 1,
	'imageworkstationmake' => 1,
	'imagingdata' => 1,
	'imdb' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexbackground' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'indextransparent' => 1,
	'indicatedairspeed' => 1,
	'indications' => 1,
	'infirayfactory' => 1,
	'infirayisothermal' => 1,
	'infiraymixmode' => 1,
	'infirayopmode' => 1,
	'infiraypicture' => 1,
	'infiraysensor' => 1,
	'infirayversion' => 1,
	'info' => 1,
	'ingrreserved' => 1,
	'initialdelaysamples' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputheight' => 1,
	'inputorientation' => 1,
	'inputuniformity' => 1,
	'inputwidth' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'insta360' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'instruments' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'intervaloffset' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isartbokeh' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoautooffset' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemdesignatorid' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'ixml' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpegimagelength' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jpgfromraw2' => 1,
	'jpginfooffset' => 1,
	'jplcartoifd' => 1,
	'jps' => 1,
	'jpscomment' => 1,
	'jpsflags' => 1,
	'jpslayout' => 1,
	'jpsseparation' => 1,
	'jpstype' => 1,
	'jsondata' => 1,
	'jsonmetadata' => 1,
	'jumbf' => 1,
	'jumbfbox' => 1,
	'jumbfdescr' => 1,
	'jumdid' => 1,
	'jumdlabel' => 1,
	'jumdsignature' => 1,
	'jumdtoggles' => 1,
	'jumdtype' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'jxlcodestream' => 1,
	'k1' => 1,
	'k2' => 1,
	'k3' => 1,
	'k4' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepexposurewithteleconverter' => 1,
	'keepuntil' => 1,
	'kelvinwb' => 1,
	'kenwooddata' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kilocalories' => 1,
	'kinds' => 1,
	'kj' => 1,
	'kk' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelcode' => 1,
	'labeledtext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'languages' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'laserprfcode' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'lawrating' => 1,
	'layerblendmodes' => 1,
	'layercolors' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layersections' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layervisible' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lccn' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfacing' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'limage' => 1,
	'limitaf-areamodeselautoanimals' => 1,
	'limitaf-areamodeselautopeople' => 1,
	'limitaf-areamodeseldynamic' => 1,
	'limitaf-areamodeselwidelanimals' => 1,
	'limitaf-areamodeselwidelpeople' => 1,
	'limitafareamodesel3d' => 1,
	'limitafareamodeseld105' => 1,
	'limitafareamodeseld25' => 1,
	'limitafareamodeseld49' => 1,
	'limitafareamodeseld9' => 1,
	'limitafareamodeselgroup' => 1,
	'limitafareamodeselgroupc1' => 1,
	'limitafareamodeselgroupc2' => 1,
	'limitreleasemodeselmirror-up' => 1,
	'limitreleasemodeselq' => 1,
	'limitreleasemodeseltimer' => 1,
	'limitselectableimagearea5to4' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'linecount' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkgoodput' => 1,
	'linkinfo' => 1,
	'linkquality' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'listtype' => 1,
	'lit' => 1,
	'livephotoinfo' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationinfo' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loginfo' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopcount' => 1,
	'lotus' => 1,
	'lowlightaf' => 1,
	'lownote' => 1,
	'lowvelocity' => 1,
	'lr' => 1,
	'lslv' => 1,
	'lucasjunk' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'luminancetable' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'mag360fly' => 1,
	'magmode' => 1,
	'magneticfield' => 1,
	'magneticheading' => 1,
	'magnetometer' => 1,
	'magnetometerxyz' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'marl' => 1,
	'masksubarea' => 1,
	'masteredby' => 1,
	'mastergainadjustment' => 1,
	'matrixcoefficients' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxcontentlightlevel' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumshutterangle' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxpicaveragelightlevel' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mccdata' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemaudiobitrate' => 1,
	'mditemaudiochannelcount' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcodecs' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentcreationdateranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemdurationseconds' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditeminterestingdateranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlastuseddate_ranking' => 1,
	'mditemlatitude' => 1,
	'mditemlensmodel' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemmediatypes' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemstreamable' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemtotalbitrate' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemuserdownloadeddate' => 1,
	'mditemuserdownloadeduserhandle' => 1,
	'mditemusersharedreceiveddate' => 1,
	'mditemusersharedreceivedrecipient' => 1,
	'mditemusersharedreceivedrecipienthandle' => 1,
	'mditemusersharedreceivedsender' => 1,
	'mditemusersharedreceivedsenderhandle' => 1,
	'mditemusersharedreceivedtransport' => 1,
	'mditemversion' => 1,
	'mditemvideobitrate' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measure' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementinputinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediadataoffset' => 1,
	'mediadatasize' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediauniqueid' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'menuoffset' => 1,
	'menusettingsoffset' => 1,
	'menusettingsoffsetz7ii' => 1,
	'menusettingsoffsetz8' => 1,
	'menusettingsoffsetz9' => 1,
	'menusettingsoffsetz9v3' => 1,
	'menusettingsoffsetz9v4' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metadataversion' => 1,
	'metaformat' => 1,
	'metaimagesize' => 1,
	'metarelation' => 1,
	'metasampledesc' => 1,
	'metatype' => 1,
	'metdata' => 1,
	'meter' => 1,
	'meterinfo' => 1,
	'meteringbutton' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'mett' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midipitchfraction' => 1,
	'midisong' => 1,
	'midiunitynote' => 1,
	'mie' => 1,
	'miiscoreidentifier' => 1,
	'mileage' => 1,
	'mimeencoding' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'minspatialsegmentationidc' => 1,
	'mintransmissiontime' => 1,
	'missionid' => 1,
	'mixedby' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monostrength' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'moresettingsoffset' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviefragment' => 1,
	'moviefragmentheader' => 1,
	'moviefragmentsequence' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'moviehighlightdisplaypattern' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'moviewhitebalancesameasphoto' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'mtoa0' => 1,
	'mtob0' => 1,
	'mtob1' => 1,
	'mtob2' => 1,
	'mtob3' => 1,
	'mtos0' => 1,
	'mtos1' => 1,
	'mtos2' => 1,
	'mtos3' => 1,
	'multiexp' => 1,
	'multiexposure2' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiplexdefaultvalues' => 1,
	'multiplextypearray' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'newlines' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikonapp' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'nine' => 1,
	'nineedits' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'normallinetransfertiming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numplanes' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numsampleloops' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'numtemporallayers' => 1,
	'objectcountrycodes' => 1,
	'objectcountrycodingmethod' => 1,
	'objectcountrycodingmethoddate' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectorientation' => 1,
	'objectsizeannounced' => 1,
	'observationdate' => 1,
	'observationdateend' => 1,
	'observationtime' => 1,
	'observationtimeend' => 1,
	'observer' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offset13' => 1,
	'offsetcornerlatitude1' => 1,
	'offsetcornerlatitude2' => 1,
	'offsetcornerlatitude3' => 1,
	'offsetcornerlatitude4' => 1,
	'offsetcornerlongitude1' => 1,
	'offsetcornerlongitude2' => 1,
	'offsetcornerlongitude3' => 1,
	'offsetcornerlongitude4' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'on1_settingsdata' => 1,
	'on1_settingsmetadatacreated' => 1,
	'on1_settingsmetadatamodified' => 1,
	'on1_settingsmetadataname' => 1,
	'on1_settingsmetadatapluginid' => 1,
	'on1_settingsmetadatatimestamp' => 1,
	'on1_settingsmetadatausage' => 1,
	'on1_settingsmetadatavisibletouser' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationalmode' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'opticalvr' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'orientationoffset' => 1,
	'orientoffset' => 1,
	'original' => 1,
	'originalalbum' => 1,
	'originaldate' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originalmedia' => 1,
	'originalmediatype' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originalyear' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'othermeta' => 1,
	'othername' => 1,
	'otheroffset' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputheight' => 1,
	'outputorientation' => 1,
	'outputresponse' => 1,
	'outputwidth' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parallelismtype' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parameters' => 1,
	'parasites' => 1,
	'parentalratingreason' => 1,
	'parrotautomation' => 1,
	'parrotfollowme' => 1,
	'parrottimestamp' => 1,
	'parrotv1' => 1,
	'parrotv2' => 1,
	'parrotv3' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialjxlcodestream' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partoffset' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'pdrversion' => 1,
	'peakbitrate' => 1,
	'peaklevelr128' => 1,
	'peaklevelsample' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'perfmode' => 1,
	'performersortorder' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'phone' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pilotingmode' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchrollyaw' => 1,
	'pittasoft' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'playbackflickdownrating' => 1,
	'playbackflickuprating' => 1,
	'playbackframerate' => 1,
	'playcounter' => 1,
	'playlist' => 1,
	'playlistdelay' => 1,
	'playlistindex' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraitoffset' => 1,
	'portraittonescaletable' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'prefersubselectorcenter' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryfileguid' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsbleedwidth' => 1,
	'printflagsbleedwidthscale' => 1,
	'printflagscrop' => 1,
	'printflagsinfo' => 1,
	'printflagsversion' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productioncopyright' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversionnumber' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesequenceinfo' => 1,
	'profilesize' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projectidcode' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protune' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'ptrh' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasecurrency' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purchaseitem' => 1,
	'purchaseowner' => 1,
	'purchaseprice' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'quietshuttershootingspeed' => 1,
	'quoting' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rangeimagelocalset' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawburstmoderoll' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimageaspectratio' => 1,
	'rawimagecroppedsize' => 1,
	'rawimagecroptopleft' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagenumber' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawvaluerangemax' => 1,
	'rawvaluerangemin' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'rearcontropaneldisplay' => 1,
	'recallshootfuncaf-on' => 1,
	'recallshootfuncafareamode' => 1,
	'recallshootfuncaperture' => 1,
	'recallshootfuncexposurecomp' => 1,
	'recallshootfuncexposuremode' => 1,
	'recallshootfuncfocustracking' => 1,
	'recallshootfunciso' => 1,
	'recallshootfuncmeteringmode' => 1,
	'recallshootfuncshutterspeed' => 1,
	'recallshootfuncwhitebalance' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordinglocation' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'records' => 1,
	'recordsv2' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencename' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectedtemperature' => 1,
	'reflection' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relatedresources' => 1,
	'relationship' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'releasinginstructions' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'remixedby' => 1,
	'remotefuncbutton' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaingain' => 1,
	'replaygainpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replaytrackgain' => 1,
	'replaytrackpeak' => 1,
	'replayvolumelevel' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resolutionxlengthunit' => 1,
	'resolutionxunit' => 1,
	'resolutionylengthunit' => 1,
	'resolutionyunit' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rootnote' => 1,
	'rot360fly' => 1,
	'rotationangle' => 1,
	'rotationinfooffset' => 1,
	'rotationxyz' => 1,
	'rotmode' => 1,
	'roundtripversion' => 1,
	'rowcount' => 1,
	'rowinterleavefactor' => 1,
	'rsrc' => 1,
	'rtmd' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	'rvtlocalset' => 1,
	's2n' => 1,
	'sample' => 1,
	'sampleblacksequence' => 1,
	'sampledatetime' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'sampleperiod' => 1,
	'sampler' => 1,
	'samplerate2' => 1,
	'samplerdata' => 1,
	'samplerdatalen' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsungtrailer' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'sarmotionimagerydata' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'savefocus' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenplayby' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'script' => 1,
	'scriptcommand' => 1,
	'sdc' => 1,
	'sdcc-flp' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'securitylocalmetadataset' => 1,
	'securitysci-shiinformation' => 1,
	'securityversion' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'segheight' => 1,
	'segmentlocalset' => 1,
	'segwidth' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'semanticinstanceid' => 1,
	'semanticname' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensitivityvalue' => 1,
	'sensorbottomborder' => 1,
	'sensordata' => 1,
	'sensordefects' => 1,
	'sensorellipsoidheight' => 1,
	'sensorellipsoidheightextended' => 1,
	'sensorfieldofviewname' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorname' => 1,
	'sensorreadouttime' => 1,
	'sensorrelativeazimuthangle' => 1,
	'sensorrelativeelevationangle' => 1,
	'sensorrelativerollangle' => 1,
	'sensorrightborder' => 1,
	'sensorvelocityeast' => 1,
	'sensorvelocitynorth' => 1,
	'seqcount' => 1,
	'seqfinal' => 1,
	'seqframeinfo' => 1,
	'seqid' => 1,
	'seqindex' => 1,
	'seqlevelidx0' => 1,
	'seqprofile' => 1,
	'seqtier0' => 1,
	'seqtype' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'sequenceoffset' => 1,
	'serialinfo' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'settingsoffset' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod6' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod7500' => 1,
	'shotinfod780' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'shotinfoz7ii' => 1,
	'shotinfoz8' => 1,
	'shotinfoz9' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutterangle' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sidelightstrength' => 1,
	'sideslipangle' => 1,
	'sigma' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'singleshotdepthmap' => 1,
	'singleshotdepthmaptiff' => 1,
	'singleshotmeta' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'skipinfo' => 1,
	'slantrange' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'smpteformat' => 1,
	'smpteoffset' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sony_0x9416' => 1,
	'sonyfnumber2' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'sortwith' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialaudio' => 1,
	'spatialaudioversion' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'spectralviewingconditions' => 1,
	'spectralwhitepoint' => 1,
	'speed' => 1,
	'sphericalvideo' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spinstrength' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'standardtocustompcc' => 1,
	'standbymonitorofftime' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'staticpressure' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stillimagetime' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streamid' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdialframeadvance' => 1,
	'subdialframeadvancerating0' => 1,
	'subdialframeadvancerating1' => 1,
	'subdialframeadvancerating2' => 1,
	'subdialframeadvancerating3' => 1,
	'subdialframeadvancerating4' => 1,
	'subdialframeadvancerating5' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surfacemap' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'synopsis' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9050c' => 1,
	'tag9050d' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag9406b' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'tag9416_0000' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tailnumber' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targeterrorestimatece90' => 1,
	'targeterrorestimatele90' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetlocationcovariancematrix' => 1,
	'targetlocationelevation' => 1,
	'targetlocationlatitude' => 1,
	'targetlocationlongitude' => 1,
	'targettrackgateheight' => 1,
	'targettrackgatewidth' => 1,
	'targetwidth' => 1,
	'targetwidthextended' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telescope' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporalidnested' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'thanksto' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thermalcalibration' => 1,
	'thermaldata' => 1,
	'thermalparams' => 1,
	'thermalparams2' => 1,
	'thermalparams3' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailartist' => 1,
	'thumbnailbitspersample' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcolordepth' => 1,
	'thumbnailcompressedsize' => 1,
	'thumbnailcompression' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailcopyright' => 1,
	'thumbnaildata' => 1,
	'thumbnaildatetime' => 1,
	'thumbnaildescription' => 1,
	'thumbnailequipmake' => 1,
	'thumbnailequipmodel' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailhash' => 1,
	'thumbnailimageheight' => 1,
	'thumbnailimagewidth' => 1,
	'thumbnailorientation' => 1,
	'thumbnailphotometricinterp' => 1,
	'thumbnailplanarconfig' => 1,
	'thumbnailplanes' => 1,
	'thumbnailprimarychromaticities' => 1,
	'thumbnailrawbytes' => 1,
	'thumbnailref' => 1,
	'thumbnailrefblackwhite' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailresolutionunit' => 1,
	'thumbnailresolutionx' => 1,
	'thumbnailresolutiony' => 1,
	'thumbnailrowsperstrip' => 1,
	'thumbnailsamplesperpixel' => 1,
	'thumbnailsoftware' => 1,
	'thumbnailstripbytecounts' => 1,
	'thumbnailstripoffsets' => 1,
	'thumbnailtiff' => 1,
	'thumbnailtransferfunction' => 1,
	'thumbnailurl' => 1,
	'thumbnailwhitepoint' => 1,
	'thumbnailycbcrcoefficients' => 1,
	'thumbnailycbcrpositioning' => 1,
	'thumbnailycbcrsubsampling' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamplist' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'tmdb' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalparts' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transfercharacteristic' => 1,
	'transfercharacteristics' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentcolor' => 1,
	'transparentindex' => 1,
	'transportstreamid' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'trim' => 1,
	'trueairspeed' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'tuning' => 1,
	'tvdb' => 1,
	'twelvebit' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'uas_lsversionnumber' => 1,
	'uasdatalink' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'umid' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknownexif' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unsharpdata' => 1,
	'unshiftednote' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'usertext' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-c2paclaimsignature' => 1,
	'uuid-canon' => 1,
	'uuid-canon2' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-signature' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalaf-onbutton' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalfieldofview' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalspeed' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videofullrangeflag' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotimestamp' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'vintagestrength' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmtidataset' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumelevelr128' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelscustom' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wbsettings' => 1,
	'wbsettings2' => 1,
	'wcsprofiles' => 1,
	'weaponfired' => 1,
	'weaponload' => 1,
	'webp_flags' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'wifirssi' => 1,
	'winddirection' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'windspeed' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wpgversion' => 1,
	'wrapmodes' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrapplemaildatereceived' => 1,
	'xattrapplemaildatesent' => 1,
	'xattrapplemailisremoteattachment' => 1,
	'xattrfinderinfo' => 1,
	'xattrlastuseddate' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmditemwherefroms' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xidiri' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmlpackets' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilecomment' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zisrawversion' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zoomstrength' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'gpslatitude' => 'Image::ExifTool::GPS',
	'gpslongitude' => 'Image::ExifTool::GPS',
	'gpsposition' => 'Image::ExifTool::Exif',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names to lookup corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level structure
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                my $lcFlat = $$newInfo{FlatName} ? lc($$newInfo{FlatName}) : $lcTag;
                AddFields($tagTablePtr, $tagID, $lcFlat, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        no strict 'refs';
                        $reload = 1 if &$writeProc();
                    }
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2023, Phil Harvey (philharvey66 at gmail.com)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
