--  DO NOT EDIT THIS FILE.
--  It is generated automatically, by program c-posix.c
------------------------------------------------------------------------------
--                                                                          --
--            FLORIST (FSU Implementation of POSIX.5) COMPONENTS            --
--                                                                          --
--                               P O S I X . C                              --
--                                                                          --
--                                   S p e c                                --
--                                                                          --
--                                                                          --
--  Copyright (c) 1996, 1997   Florida State University (FSU),              --
--  All Rights Reserved.                                                    --
--                                                                          --
--  This  file  is a component of  FLORIST,  an  Ada  application  program  --
--  interface for operating system services for use with the GNAT compiler  --
--  and the  Gnu  Ada  Runtime  Library (GNARL).   FLORIST  is intended to  --
--  conform to the IEEE POSIX Ada standards, 1003.5-1992 and 1003.5b-1993.  --
--  It also includes support for Draft 1 of IEEE Project 1003.5c.           --
--                                                                          --
--  This is free software;  you can redistribute it and/or modify it under  --
--  terms of the  GNU  General  Public  License as  published by the  Free  --
--  Software Foundation;  either version  2, or (at your option) any later  --
--  version.  This software is distributed  in  the hope  that  it will be  --
--  useful, but WITHOUT ANY WARRANTY;  without  even the implied  warranty  --
--  of MERCHANTABILITY or FITNESS FOR A PARTICULAR  PURPOSE.  See  the GNU  --
--  General Public License for more details.  You  should have  received a  --
--  copy of the GNU General Public License  distributed  with  GNARL;  see  --
--  file  COPYING.  If not,  write to  the  Free  Software  Foundation, 59  --
--  Temple Place - Suite 330, Boston, MA 02111-1307, USA.                   --
--                                                                          --
--  As a special exception, if other files instantiate generics from  this  --
--  unit, or you link this unit with other files to produce an  executable, --
--  this  unit does not by itself cause the  resulting  executable  to  be  --
--  covered  by the  GNU  General  Public License. This exception does not  --
--  however invalidate any other  reasons why the executable file might be  --
--  covered by the GNU Public License.                                      --
--                                                                          --
------------------------------------------------------------------------------
with System; use System;
with Unchecked_Conversion;
package POSIX.C is
   pragma Elaborate_Body;
   --  =========  --
   --   WARNING   --
   --  =========  --

   --  This package should NOT be used directly by an application.
   --  It is internal to the FLORIST implementation of the POSIX.5 API,
   --  and may be changed or replaced in future versions of FLORIST.

   ALIGNMENT : constant := Natural'Min (Standard'Maximum_Alignment, 8);
   --  worst-case alignment requirement

   ---------------------
   --  basic C types  --
   ---------------------
   type short is range -2**15 .. (2**15) - 1;
   for short'Size use 16;
   type int is range -2**31 .. (2**31) - 1;
   for int'Size use 32;
   type int_ptr is access constant int;
   pragma Convention (C, int_ptr);
   type int_var_ptr is access all int;
   pragma Convention (C, int_var_ptr);
   type unsigned is mod 2**32;
   for unsigned'Size use 32;
   type long is range -2**31 .. (2**31) - 1;
   for long'Size use 32;
   type unsigned_long is mod 2**32;
   for unsigned_long'Size use 32;
   type unsigned_int is mod 2**32;
   for unsigned_int'Size use 32;
   type unsigned_short is mod 2**16;
   for unsigned_short'Size use 16;
   type caddr_t is mod 2**32;
   for caddr_t'Size use 32;
   type size_t is range -2**31 .. (2**31) - 1;
   for size_t'Size use 32;
   type size_t_ptr is access constant size_t;
   pragma Convention (C, size_t_ptr);
   type size_t_var_ptr is access all size_t;
   pragma Convention (C, size_t_var_ptr);
   type time_t is range -2**31 .. (2**31) - 1;
   for time_t'Size use 32;
   type time_t_ptr is access constant time_t;
   pragma Convention (C, time_t_ptr);
   type time_t_var_ptr is access all time_t;
   pragma Convention (C, time_t_var_ptr);
   type clock_t is mod 2**32;
   for clock_t'Size use 32;
   type clock_t_ptr is access constant clock_t;
   pragma Convention (C, clock_t_ptr);
   type clock_t_var_ptr is access all clock_t;
   pragma Convention (C, clock_t_var_ptr);
   type ptr_as_int is range -2**31 .. (2**31) - 1;
   for ptr_as_int'Size use 32;
   subtype char is POSIX_Character;
   type char_ptr is access constant char;
   pragma Convention (C, char_ptr);
   type char_var_ptr is access all char;
   pragma Convention (C, char_var_ptr);
   function To_Ptr is new Unchecked_Conversion (Address, char_ptr);
   function To_char_ptr (Addr : Address) return char_ptr renames To_Ptr;
   function To_Address is new Unchecked_Conversion (char_ptr, Address);
   type char_ptr_ptr is access constant char_ptr;
   pragma Convention (C, char_ptr_ptr);
   type char_ptr_var_ptr is access all char_ptr;
   pragma Convention (C, char_ptr_var_ptr);
   function To_Ptr is new Unchecked_Conversion (Address, char_ptr_ptr);
   function To_Address is new Unchecked_Conversion (char_ptr_ptr, Address);
   type char_ptr_array is
     array (Positive range <>) of aliased char_ptr;
   function malloc (size : size_t) return char_ptr;
   function malloc (size : size_t) return char_ptr_ptr;
      pragma Import (C, malloc, "malloc");
   procedure free (object : char_ptr);
   procedure free (object : char_ptr_ptr);
      pragma Import (C, free, "free");
   procedure Advance (Ptr : in out char_ptr);
   procedure Advance (Ptr : in out char_ptr_ptr);
   --  advance Ptr to next location
   --  pragma Inline (Advance);
   function Form_POSIX_String (Str : char_ptr)
      return POSIX_String;
   --  makes new copy of string, without null terminator

   -----------------
   --  constants  --
   -----------------
   AIO_ALLDONE : constant := 2;
   AIO_CANCELED : constant := 0;
   AIO_NOTCANCELED : constant := 1;
   B0 : constant := 0;
   B110 : constant := 3;
   B115200 : constant := 17;
   B1200 : constant := 9;
   B134 : constant := 4;
   B150 : constant := 5;
   B1800 : constant := 10;
   B19200 : constant := 14;
   B200 : constant := 6;
   B230400 : constant := 18;
   B2400 : constant := 11;
   B300 : constant := 7;
   B38400 : constant := 15;
   B460800 : constant := 19;
   B4800 : constant := 12;
   B50 : constant := 1;
   B57600 : constant := 16;
   B600 : constant := 8;
   B75 : constant := 2;
   B9600 : constant := 13;
   BRKINT : constant := 2;
   --  *** MISSING: CLK_TCK ***  --
   CLK_TCK : constant := 0;
   CLOCAL : constant := 32768;
   CLOCK_REALTIME : constant := 0;
   CREAD : constant := 2048;
   CSIZE : constant := 768;
   CSTOPB : constant := 1024;
   CS5 : constant := 0;
   CS6 : constant := 256;
   CS7 : constant := 512;
   CS8 : constant := 768;
   --   error code constants are in posix.ads
   ECHO : constant := 8;
   ECHOE : constant := 2;
   ECHOK : constant := 4;
   ECHONL : constant := 16;
   FD_CLOEXEC : constant := 1;
   F_DUPFD : constant := 0;
   F_GETFD : constant := 1;
   F_GETFL : constant := 3;
   F_GETLK : constant := 12;
   F_OK : constant := 0;
   F_RDLCK : constant := 0;
   F_SETFD : constant := 2;
   F_SETFL : constant := 4;
   F_SETLK : constant := 13;
   F_SETLKW : constant := 14;
   F_UNLCK : constant := 2;
   F_WRLCK : constant := 1;
   HUPCL : constant := 16384;
   ICANON : constant := 256;
   ICRNL : constant := 256;
   IEXTEN : constant := 1024;
   IGNBRK : constant := 1;
   IGNCR : constant := 128;
   IGNPAR : constant := 4;
   INLCR : constant := 64;
   INPCK : constant := 16;
   ISIG : constant := 128;
   ISTRIP : constant := 32;
   IXOFF : constant := 1024;
   IXON : constant := 512;
   L_ctermid : constant := 9;
   LIO_NOP : constant := 2;
   LIO_NOWAIT : constant := 1;
   LIO_READ : constant := 0;
   LIO_WAIT : constant := 0;
   LIO_WRITE : constant := 1;
   MAP_FAILED : constant := -1;
   MAP_FILE : constant := 0;
   MAP_FIXED : constant := 16;
   --  *** MISSING: MAP_VARIABLE ***  --
   MAP_VARIABLE : constant := 0;
   MAP_PRIVATE : constant := 2;
   MAP_SHARED : constant := 1;
   MAX_CANON : constant := 255;
   MAX_INPUT : constant := 255;
   MCL_CURRENT : constant := 8192;
   MCL_FUTURE : constant := 16384;
   MS_ASYNC : constant := 1;
   MS_INVALIDATE : constant := 2;
   MS_SYNC : constant := 4;
   --  *** MISSING: MS_EINTR ***  --
   MS_EINTR : constant := 0;
   NCCS : constant := 32;
   NOFLSH : constant := 2147483648;
   OPOST : constant := 1;
   O_ACCMODE : constant := 3;
   O_APPEND : constant := 1024;
   O_CREAT : constant := 64;
   O_DSYNC : constant := 4096;
   O_EXCL : constant := 128;
   O_NOCTTY : constant := 256;
   O_NONBLOCK : constant := 2048;
   O_RDONLY : constant := 0;
   O_RDWR : constant := 2;
   O_RSYNC : constant := 4096;
   O_SYNC : constant := 4096;
   O_TRUNC : constant := 512;
   O_WRONLY : constant := 1;
   --  *** MISSING: PAGESIZE ***  --
   PAGESIZE : constant := 0;
   PARENB : constant := 4096;
   PARMRK : constant := 8;
   PARODD : constant := 8192;
   PROT_EXEC : constant := 4;
   PROT_NONE : constant := 0;
   PROT_READ : constant := 1;
   PROT_WRITE : constant := 2;
   PTHREAD_DESTRUCTOR_ITERATIONS : constant := 4;
   PTHREAD_EXPLICIT_SCHED : constant := 1;
   PTHREAD_INHERIT_SCHED : constant := 0;
   --  *** MISSING: PTHREAD_PRIO_INHERIT ***  --
   PTHREAD_PRIO_INHERIT : constant := 0;
   --  *** MISSING: PTHREAD_PRIO_NONE ***  --
   PTHREAD_PRIO_NONE : constant := 0;
   --  *** MISSING: PTHREAD_PRIO_PROTECT ***  --
   PTHREAD_PRIO_PROTECT : constant := 0;
   PTHREAD_PROCESS_SHARED : constant := 1;
   PTHREAD_PROCESS_PRIVATE : constant := 0;
   PTHREAD_SCOPE_PROCESS : constant := 1;
   PTHREAD_SCOPE_SYSTEM : constant := 0;
   R_OK : constant := 4;
   SA_NOCLDSTOP : constant := 1;
   SA_SIGINFO : constant := 4;
   SCHED_FIFO : constant := 1;
   SCHED_OTHER : constant := 0;
   SCHED_RR : constant := 2;
   SEEK_CUR : constant := 1;
   SEEK_END : constant := 2;
   SEEK_SET : constant := 0;
   SIGABRT : constant := 6;
   SIGALRM : constant := 14;
   SIGBUS : constant := 7;
   SIGCHLD : constant := 17;
   SIGCONT : constant := 18;
   SIGEV_NONE : constant := 1;
   SIGEV_SIGNAL : constant := 0;
   SIGEV_THREAD : constant := 2;
   SIGFPE : constant := 8;
   SIGHUP : constant := 1;
   SIGILL : constant := 4;
   SIGINT : constant := 2;
   SIGIO : constant := 29;
   SIGKILL : constant := 9;
   SIGPIPE : constant := 13;
   SIGQUIT : constant := 3;
   SIGRTMAX : constant := 64;
   SIGRTMIN : constant := 34;
   NSIGS : constant := 64;
   SIGSEGV : constant := 11;
   SIGSTOP : constant := 19;
   SIGTERM : constant := 15;
   SIGTRAP : constant := 5;
   SIGTSTP : constant := 20;
   SIGTTIN : constant := 21;
   SIGTTOU : constant := 22;
   SIGURG : constant := 23;
   SIGUSR1 : constant := 10;
   SIGUSR2 : constant := 12;
   SIG_BLOCK : constant := 0;
   SIG_DFL : constant := 0;
   SIG_IGN : constant := 1;
   SIG_SETMASK : constant := 2;
   SIG_UNBLOCK : constant := 1;
   SI_ASYNCIO : constant := -4;
   SI_MESGQ : constant := -3;
   SI_QUEUE : constant := -1;
   SI_TIMER : constant := -2;
   SI_USER : constant := 0;
   S_IFSOCK : constant := 49152;
   S_IRGRP : constant := 32;
   S_IROTH : constant := 4;
   S_IRUSR : constant := 256;
   S_IRWXG : constant := 56;
   S_IRWXO : constant := 7;
   S_IRWXU : constant := 448;
   S_ISGID : constant := 1024;
   S_ISUID : constant := 2048;
   S_IWGRP : constant := 16;
   S_IWOTH : constant := 2;
   S_IWUSR : constant := 128;
   S_IXGRP : constant := 8;
   S_IXOTH : constant := 1;
   S_IXUSR : constant := 64;
   TCIFLUSH : constant := 0;
   TCIOFF : constant := 2;
   TCIOFLUSH : constant := 2;
   TCION : constant := 3;
   TCOFLUSH : constant := 1;
   TCOOFF : constant := 0;
   TCOON : constant := 1;
   TCSADRAIN : constant := 1;
   TCSAFLUSH : constant := 2;
   TCSANOW : constant := 0;
   TIMER_ABSTIME : constant := 1;
   --  *** MISSING: TIMER_RELTIME ***  --
   TIMER_RELTIME : constant := 0;
   TOSTOP : constant := 4194304;
   VEOF : constant := 4;
   VEOL : constant := 6;
   VERASE : constant := 2;
   VINTR : constant := 0;
   VKILL : constant := 3;
   VMIN : constant := 5;
   VQUIT : constant := 1;
   VSTART : constant := 13;
   VSTOP : constant := 14;
   VSUSP : constant := 12;
   VTIME : constant := 7;
   WNOHANG : constant := 1;
   WUNTRACED : constant := 2;
   W_OK : constant := 2;
   X_OK : constant := 1;
   PC_ASYNC_IO : constant := 10;
   PC_CHOWN_RESTRICTED : constant := 6;
   PC_LINK_MAX : constant := 0;
   PC_MAX_CANON : constant := 1;
   PC_MAX_INPUT : constant := 2;
   PC_NAME_MAX : constant := 3;
   PC_NO_TRUNC : constant := 7;
   PC_PATH_MAX : constant := 4;
   PC_PIPE_BUF : constant := 5;
   PC_PRIO_IO : constant := 11;
   PC_SYNC_IO : constant := 9;
   PC_SOCK_MAXBUF : constant := 12;
   SC_AIO_LISTIO_MAX : constant := 23;
   SC_AIO_MAX : constant := 24;
   SC_AIO_PRIO_DELTA_MAX : constant := 25;
   SC_ARG_MAX : constant := 0;
   SC_ASYNCHRONOUS_IO : constant := 12;
   SC_CHILD_MAX : constant := 1;
   SC_CLK_TCK : constant := 2;
   SC_DELAYTIMER_MAX : constant := 26;
   SC_FSYNC : constant := 15;
   SC_JOB_CONTROL : constant := 7;
   SC_MAPPED_FILES : constant := 16;
   SC_MEMLOCK : constant := 17;
   SC_MEMLOCK_RANGE : constant := 18;
   SC_MEMORY_PROTECTION : constant := 19;
   SC_MESSAGE_PASSING : constant := 20;
   SC_MQ_OPEN_MAX : constant := 27;
   SC_MQ_PRIO_MAX : constant := 28;
   SC_NGROUPS_MAX : constant := 3;
   SC_OPEN_MAX : constant := 4;
   SC_PAGESIZE : constant := 30;
   SC_PII : constant := 53;
   SC_PII_XTI : constant := 54;
   SC_PII_SOCKET : constant := 55;
   SC_PII_INTERNET : constant := 56;
   SC_PII_INTERNET_STREAM : constant := 61;
   SC_PII_INTERNET_DGRAM : constant := 62;
   SC_PII_OSI : constant := 57;
   SC_PII_OSI_M : constant := 65;
   SC_PII_OSI_COTS : constant := 63;
   SC_PII_OSI_CLTS : constant := 64;
   --  *** MISSING: SC_PII_NET_SUPPORT ***  --
   SC_PII_NET_SUPPORT : constant := 0;
   SC_POLL : constant := 58;
   --  *** MISSING: SC_POSIX_PII_NET_SUPPORT ***  --
   SC_POSIX_PII_NET_SUPPORT : constant := 0;
   SC_PRIORITIZED_IO : constant := 13;
   SC_PRIORITY_SCHEDULING : constant := 10;
   SC_SELECT : constant := 59;
   SC_THREAD_PROCESS_SHARED : constant := 82;
   SC_REALTIME_SIGNALS : constant := 9;
   SC_RTSIG_MAX : constant := 31;
   SC_SAVED_IDS : constant := 8;
   SC_SEMAPHORES : constant := 21;
   SC_SEM_NSEMS_MAX : constant := 32;
   SC_SEM_VALUE_MAX : constant := 33;
   SC_SHARED_MEMORY_OBJECTS : constant := 22;
   SC_SIGQUEUE_MAX : constant := 34;
   SC_STREAM_MAX : constant := 5;
   SC_SYNCHRONIZED_IO : constant := 14;
   SC_THREAD_PRIORITY_SCHEDULING : constant := 79;
   SC_THREAD_PRIO_INHERIT : constant := 80;
   SC_THREAD_PRIO_PROTECT : constant := 81;
   SC_TIMERS : constant := 11;
   SC_TIMER_MAX : constant := 35;
   SC_TZNAME_MAX : constant := 6;
   SC_T_IOV_MAX : constant := 66;
   SC_UIO_MAXIOV : constant := 60;
   SC_VERSION : constant := 29;

   ------------------------
   --  type definitions  --
   ------------------------
   type off_t is range -2**63 .. (2**63) - 1;
   for off_t'Size use 64;
   type pid_t is range -2**31 .. (2**31) - 1;
   for pid_t'Size use 32;
   type gid_t is mod 2**32;
   for gid_t'Size use 32;
   type uid_t is mod 2**32;
   for uid_t'Size use 32;
   type mode_t is mod 2**32;
   for mode_t'Size use 32;
   type suseconds_t is range -2**31 .. (2**31) - 1;
   for suseconds_t'Size use 32;
   type ssize_t is range -2**31 .. (2**31) - 1;
   for ssize_t'Size use 32;
   type DIR is
     array (1 .. 1) of int;
   for DIR'Alignment use ALIGNMENT;
   for DIR'Size use 32;
   type DIR_ptr is access constant DIR;
   pragma Convention (C, DIR_ptr);
   type DIR_var_ptr is access all DIR;
   pragma Convention (C, DIR_var_ptr);
   type ino_t is mod 2**64;
   for ino_t'Size use 64;
   type dev_t is mod 2**64;
   for dev_t'Size use 64;
   type cc_t is mod 2**8;
   for cc_t'Size use 8;
   type nlink_t is mod 2**32;
   for nlink_t'Size use 32;
   --  *** MISSING: blksize_t ***  --
   type blksize_t is mod 2**32;
   for blksize_t'Size use 32;
   --  *** MISSING: blkcnt_t ***  --
   type blkcnt_t is mod 2**32;
   for blkcnt_t'Size use 32;
   type tcflag_t is mod 2**32;
   for tcflag_t'Size use 32;
   type clockid_t is range -2**31 .. (2**31) - 1;
   for clockid_t'Size use 32;
   type mqd_t is range -2**31 .. (2**31) - 1;
   for mqd_t'Size use 32;
   type pthread_attr_t is
     array (1 .. 9) of int;
   for pthread_attr_t'Alignment use ALIGNMENT;
   for pthread_attr_t'Size use 288;
   type pthread_attr_t_ptr is access constant pthread_attr_t;
   pragma Convention (C, pthread_attr_t_ptr);
   type pthread_attr_t_var_ptr is access all pthread_attr_t;
   pragma Convention (C, pthread_attr_t_var_ptr);
   type pthread_cond_t is
     array (1 .. 12) of int;
   for pthread_cond_t'Alignment use ALIGNMENT;
   for pthread_cond_t'Size use 384;
   type pthread_cond_t_ptr is access constant pthread_cond_t;
   pragma Convention (C, pthread_cond_t_ptr);
   type pthread_cond_t_var_ptr is access all pthread_cond_t;
   pragma Convention (C, pthread_cond_t_var_ptr);
   type pthread_condattr_t is
     array (1 .. 1) of int;
   for pthread_condattr_t'Alignment use ALIGNMENT;
   for pthread_condattr_t'Size use 32;
   type pthread_condattr_t_ptr is access constant pthread_condattr_t;
   pragma Convention (C, pthread_condattr_t_ptr);
   type pthread_condattr_t_var_ptr is access all pthread_condattr_t;
   pragma Convention (C, pthread_condattr_t_var_ptr);
   type pthread_key_t is
     array (1 .. 1) of int;
   for pthread_key_t'Alignment use ALIGNMENT;
   for pthread_key_t'Size use 32;
   type pthread_key_t_ptr is access constant pthread_key_t;
   pragma Convention (C, pthread_key_t_ptr);
   type pthread_key_t_var_ptr is access all pthread_key_t;
   pragma Convention (C, pthread_key_t_var_ptr);
   type pthread_mutex_t is
     array (1 .. 6) of int;
   for pthread_mutex_t'Alignment use ALIGNMENT;
   for pthread_mutex_t'Size use 192;
   type pthread_mutex_t_ptr is access constant pthread_mutex_t;
   pragma Convention (C, pthread_mutex_t_ptr);
   type pthread_mutex_t_var_ptr is access all pthread_mutex_t;
   pragma Convention (C, pthread_mutex_t_var_ptr);
   type pthread_mutexattr_t is
     array (1 .. 1) of int;
   for pthread_mutexattr_t'Alignment use ALIGNMENT;
   for pthread_mutexattr_t'Size use 32;
   type pthread_mutexattr_t_ptr is access constant pthread_mutexattr_t;
   pragma Convention (C, pthread_mutexattr_t_ptr);
   type pthread_mutexattr_t_var_ptr is access all pthread_mutexattr_t;
   pragma Convention (C, pthread_mutexattr_t_var_ptr);
   type pthread_once_t is
     array (1 .. 1) of int;
   for pthread_once_t'Alignment use ALIGNMENT;
   for pthread_once_t'Size use 32;
   type pthread_once_t_ptr is access constant pthread_once_t;
   pragma Convention (C, pthread_once_t_ptr);
   type pthread_once_t_var_ptr is access all pthread_once_t;
   pragma Convention (C, pthread_once_t_var_ptr);
   type pthread_t is
     array (1 .. 1) of int;
   for pthread_t'Alignment use ALIGNMENT;
   for pthread_t'Size use 32;
   type pthread_t_ptr is access constant pthread_t;
   pragma Convention (C, pthread_t_ptr);
   type pthread_t_var_ptr is access all pthread_t;
   pragma Convention (C, pthread_t_var_ptr);
   type sem_t is
     array (1 .. 4) of int;
   for sem_t'Alignment use ALIGNMENT;
   for sem_t'Size use 128;
   type sem_t_ptr is access constant sem_t;
   pragma Convention (C, sem_t_ptr);
   type sem_t_var_ptr is access all sem_t;
   pragma Convention (C, sem_t_var_ptr);
   type sigset_t is
     array (1 .. 32) of int;
   for sigset_t'Alignment use ALIGNMENT;
   for sigset_t'Size use 1024;
   type sigset_t_ptr is access constant sigset_t;
   pragma Convention (C, sigset_t_ptr);
   type sigset_t_var_ptr is access all sigset_t;
   pragma Convention (C, sigset_t_var_ptr);
   type speed_t is mod 2**32;
   for speed_t'Size use 32;
   type socklen_t is mod 2**32;
   for socklen_t'Size use 32;
   type timer_t is mod 2**32;
   for timer_t'Size use 32;
   type sigval (Dummy : Boolean := True) is record
      case Dummy is
         when True  => sival_int : int;
         when False => sival_ptr : System.Address;
      end case;
   end record;
   pragma Unchecked_Union (sigval);
   null_sigval : constant sigval :=
      (Dummy => False, sival_ptr => System.Null_Address);
   sigval_byte_size : constant := 4;
   sigval_alignment : constant := ALIGNMENT;
   type siginfo_t is record
      si_signo : int;
      si_code : int;
      si_value : sigval;
   end record;
   for siginfo_t use record
      si_signo at 0 range 0 .. 31;
      si_code at 8 range 0 .. 31;
      si_value at 20 range 0 .. 31;
   end record;
   pragma Convention (C_Pass_By_Copy, siginfo_t);
   for siginfo_t'Alignment use ALIGNMENT;
   pragma Warnings (Off);
   --  There may be holes in the record, due to
   --  components not defined by POSIX standard.
   for siginfo_t'Size use 1024;
   pragma Warnings (On);
   type siginfo_t_ptr is access constant siginfo_t;
   pragma Convention (C, siginfo_t_ptr);
   type siginfo_t_var_ptr is access all siginfo_t;
   pragma Convention (C, siginfo_t_var_ptr);

   -----------------------
   --  structure types  --
   -----------------------
   type struct_sigevent is record
      sigev_notify : int;
      sigev_signo : int;
      sigev_value : sigval;
      sigev_notify_function : System.Address;
      sigev_notify_attributes : System.Address;
   end record;
   for struct_sigevent use record
      sigev_notify at 8 range 0 .. 31;
      sigev_signo at 4 range 0 .. 31;
      sigev_value at 0 range 0 .. 31;
      sigev_notify_function at 12 range 0 .. 31;
      sigev_notify_attributes at 16 range 0 .. 31;
   end record;
   pragma Convention (C_Pass_By_Copy, struct_sigevent);
   for struct_sigevent'Alignment use ALIGNMENT;
   pragma Warnings (Off);
   --  There may be holes in the record, due to
   --  components not defined by POSIX standard.
   for struct_sigevent'Size use 512;
   pragma Warnings (On);
   type sigevent_ptr is access constant struct_sigevent;
   pragma Convention (C, sigevent_ptr);
   type sigevent_var_ptr is access all struct_sigevent;
   pragma Convention (C, sigevent_var_ptr);
   type struct_aiocb is record
      aio_fildes : int;
      aio_offset : off_t;
      aio_buf : System.Address;
      pragma Volatile (aio_buf);
      aio_nbytes : size_t;
      aio_reqprio : int;
      aio_sigevent : struct_sigevent;
      aio_lio_opcode : int;
   end record;
   for struct_aiocb use record
      aio_fildes at 0 range 0 .. 31;
      aio_offset at 104 range 0 .. 63;
      aio_buf at 12 range 0 .. 31;
      aio_nbytes at 16 range 0 .. 31;
      aio_reqprio at 8 range 0 .. 31;
      aio_sigevent at 20 range 0 .. 511;
      aio_lio_opcode at 4 range 0 .. 31;
   end record;
   pragma Convention (C_Pass_By_Copy, struct_aiocb);
   for struct_aiocb'Alignment use ALIGNMENT;
   pragma Warnings (Off);
   --  There may be holes in the record, due to
   --  components not defined by POSIX standard.
   for struct_aiocb'Size use 1152;
   pragma Warnings (On);
   type aiocb_ptr is access constant struct_aiocb;
   pragma Convention (C, aiocb_ptr);
   type aiocb_var_ptr is access all struct_aiocb;
   pragma Convention (C, aiocb_var_ptr);
   type struct_dirent is record
      d_name : POSIX_String (1 .. 1);
   end record;
   for struct_dirent use record
      d_name at 19 range 0 .. 7;
   end record;
   pragma Convention (C_Pass_By_Copy, struct_dirent);
   for struct_dirent'Alignment use ALIGNMENT;
   pragma Warnings (Off);
   --  There may be holes in the record, due to
   --  components not defined by POSIX standard.
   for struct_dirent'Size use 2240;
   pragma Warnings (On);
   type dirent_ptr is access constant struct_dirent;
   pragma Convention (C, dirent_ptr);
   type dirent_var_ptr is access all struct_dirent;
   pragma Convention (C, dirent_var_ptr);
   type struct_flock is record
      l_type : short;
      l_whence : short;
      l_start : off_t;
      l_len : off_t;
      l_pid : pid_t;
   end record;
   for struct_flock use record
      l_type at 0 range 0 .. 15;
      l_whence at 2 range 0 .. 15;
      l_start at 8 range 0 .. 63;
      l_len at 16 range 0 .. 63;
      l_pid at 24 range 0 .. 31;
   end record;
   pragma Convention (C_Pass_By_Copy, struct_flock);
   for struct_flock'Alignment use ALIGNMENT;
   pragma Warnings (Off);
   --  There may be holes in the record, due to
   --  components not defined by POSIX standard.
   for struct_flock'Size use 256;
   pragma Warnings (On);
   type flock_ptr is access constant struct_flock;
   pragma Convention (C, flock_ptr);
   type flock_var_ptr is access all struct_flock;
   pragma Convention (C, flock_var_ptr);
   type struct_group is record
      gr_name : char_ptr;
      gr_gid : gid_t;
      gr_mem : char_ptr_ptr;
   end record;
   for struct_group use record
      gr_name at 0 range 0 .. 31;
      gr_gid at 8 range 0 .. 31;
      gr_mem at 12 range 0 .. 31;
   end record;
   pragma Convention (C_Pass_By_Copy, struct_group);
   for struct_group'Alignment use ALIGNMENT;
   pragma Warnings (Off);
   --  There may be holes in the record, due to
   --  components not defined by POSIX standard.
   for struct_group'Size use 128;
   pragma Warnings (On);
   type group_ptr is access constant struct_group;
   pragma Convention (C, group_ptr);
   type group_var_ptr is access all struct_group;
   pragma Convention (C, group_var_ptr);
   type struct_mq_attr is record
      mq_flags : long;
      mq_maxmsg : long;
      mq_msgsize : long;
      mq_curmsgs : long;
   end record;
   for struct_mq_attr use record
      mq_flags at 0 range 0 .. 31;
      mq_maxmsg at 4 range 0 .. 31;
      mq_msgsize at 8 range 0 .. 31;
      mq_curmsgs at 12 range 0 .. 31;
   end record;
   pragma Convention (C_Pass_By_Copy, struct_mq_attr);
   for struct_mq_attr'Alignment use ALIGNMENT;
   pragma Warnings (Off);
   --  There may be holes in the record, due to
   --  components not defined by POSIX standard.
   for struct_mq_attr'Size use 256;
   pragma Warnings (On);
   type mq_attr_ptr is access constant struct_mq_attr;
   pragma Convention (C, mq_attr_ptr);
   type mq_attr_var_ptr is access all struct_mq_attr;
   pragma Convention (C, mq_attr_var_ptr);
   type struct_passwd is record
      pw_name : char_ptr;
      pw_uid : uid_t;
      pw_gid : gid_t;
      pw_dir : char_ptr;
      pw_shell : char_ptr;
   end record;
   for struct_passwd use record
      pw_name at 0 range 0 .. 31;
      pw_uid at 8 range 0 .. 31;
      pw_gid at 12 range 0 .. 31;
      pw_dir at 20 range 0 .. 31;
      pw_shell at 24 range 0 .. 31;
   end record;
   pragma Convention (C_Pass_By_Copy, struct_passwd);
   for struct_passwd'Alignment use ALIGNMENT;
   pragma Warnings (Off);
   --  There may be holes in the record, due to
   --  components not defined by POSIX standard.
   for struct_passwd'Size use 224;
   pragma Warnings (On);
   type passwd_ptr is access constant struct_passwd;
   pragma Convention (C, passwd_ptr);
   type passwd_var_ptr is access all struct_passwd;
   pragma Convention (C, passwd_var_ptr);
   type struct_sigaction is record
      sa_handler : System.Address;
      sa_mask : sigset_t;
      sa_flags : int;
   end record;
   for struct_sigaction use record
      sa_handler at 0 range 0 .. 31;
      sa_mask at 4 range 0 .. 1023;
      sa_flags at 132 range 0 .. 31;
   end record;
   pragma Convention (C_Pass_By_Copy, struct_sigaction);
   for struct_sigaction'Alignment use ALIGNMENT;
   pragma Warnings (Off);
   --  There may be holes in the record, due to
   --  components not defined by POSIX standard.
   for struct_sigaction'Size use 1120;
   pragma Warnings (On);
   type sigaction_ptr is access constant struct_sigaction;
   pragma Convention (C, sigaction_ptr);
   type sigaction_var_ptr is access all struct_sigaction;
   pragma Convention (C, sigaction_var_ptr);
   type struct_sched_param is record
      sched_priority : int;
   end record;
   for struct_sched_param use record
      sched_priority at 0 range 0 .. 31;
   end record;
   pragma Convention (C_Pass_By_Copy, struct_sched_param);
   for struct_sched_param'Alignment use ALIGNMENT;
   pragma Warnings (Off);
   --  There may be holes in the record, due to
   --  components not defined by POSIX standard.
   for struct_sched_param'Size use 32;
   pragma Warnings (On);
   type sched_param_ptr is access constant struct_sched_param;
   pragma Convention (C, sched_param_ptr);
   type sched_param_var_ptr is access all struct_sched_param;
   pragma Convention (C, sched_param_var_ptr);
   type cc_t_array is array (0 .. NCCS - 1) of cc_t;
   type struct_stat is record
      st_mode : mode_t;
      st_ino : ino_t;
      st_dev : dev_t;
      st_nlink : nlink_t;
      st_uid : uid_t;
      st_gid : gid_t;
      st_size : off_t;
      st_blksize : blksize_t;
      st_blocks : blkcnt_t;
      st_atime : time_t;
      st_mtime : time_t;
      st_ctime : time_t;
   end record;
   for struct_stat use record
      st_mode at 16 range 0 .. 31;
      st_ino at 8 range 0 .. 63;
      st_dev at 0 range 0 .. 63;
      st_nlink at 20 range 0 .. 31;
      st_uid at 24 range 0 .. 31;
      st_gid at 28 range 0 .. 31;
      st_size at 48 range 0 .. 63;
      st_blksize at 56 range 0 .. 31;
      st_blocks at 64 range 0 .. 63;
      st_atime at 72 range 0 .. 31;
      st_mtime at 80 range 0 .. 31;
      st_ctime at 88 range 0 .. 31;
   end record;
   pragma Convention (C_Pass_By_Copy, struct_stat);
   for struct_stat'Alignment use ALIGNMENT;
   pragma Warnings (Off);
   --  There may be holes in the record, due to
   --  components not defined by POSIX standard.
   for struct_stat'Size use 832;
   pragma Warnings (On);
   type stat_ptr is access constant struct_stat;
   pragma Convention (C, stat_ptr);
   type stat_var_ptr is access all struct_stat;
   pragma Convention (C, stat_var_ptr);
   function To_Stat_Ptr is new Unchecked_Conversion (Address, stat_ptr);
   type struct_termios is record
      c_iflag : tcflag_t;
      c_oflag : tcflag_t;
      c_cflag : tcflag_t;
      c_lflag : tcflag_t;
      c_cc : cc_t_array;
   end record;
   for struct_termios use record
      c_iflag at 0 range 0 .. 31;
      c_oflag at 4 range 0 .. 31;
      c_cflag at 8 range 0 .. 31;
      c_lflag at 12 range 0 .. 31;
      c_cc at 17 range 0 .. 255;
   end record;
   pragma Convention (C_Pass_By_Copy, struct_termios);
   for struct_termios'Alignment use ALIGNMENT;
   pragma Warnings (Off);
   --  There may be holes in the record, due to
   --  components not defined by POSIX standard.
   for struct_termios'Size use 480;
   pragma Warnings (On);
   type termios_ptr is access constant struct_termios;
   pragma Convention (C, termios_ptr);
   type termios_var_ptr is access all struct_termios;
   pragma Convention (C, termios_var_ptr);

   --  timeval structure  --
   type struct_timeval is record
      tv_sec : time_t;
      tv_usec : suseconds_t;
   end record;
   for struct_timeval use record
      tv_sec at 0 range 0 .. 31;
      tv_usec at 4 range 0 .. 31;
   end record;
   pragma Convention (C_Pass_By_Copy, struct_timeval);
   for struct_timeval'Alignment use ALIGNMENT;
   pragma Warnings (Off);
   --  There may be holes in the record, due to
   --  components not defined by POSIX standard.
   for struct_timeval'Size use 64;
   pragma Warnings (On);
   type timeval_ptr is access constant struct_timeval;
   pragma Convention (C, timeval_ptr);
   type timeval_var_ptr is access all struct_timeval;
   pragma Convention (C, timeval_var_ptr);
   type struct_timespec is record
      tv_sec : time_t;
      tv_nsec : long;
   end record;
   for struct_timespec use record
      tv_sec at 0 range 0 .. 31;
      tv_nsec at 4 range 0 .. 31;
   end record;
   pragma Convention (C_Pass_By_Copy, struct_timespec);
   for struct_timespec'Alignment use ALIGNMENT;
   pragma Warnings (Off);
   --  There may be holes in the record, due to
   --  components not defined by POSIX standard.
   for struct_timespec'Size use 64;
   pragma Warnings (On);
   type timespec_ptr is access constant struct_timespec;
   pragma Convention (C, timespec_ptr);
   type timespec_var_ptr is access all struct_timespec;
   pragma Convention (C, timespec_var_ptr);
   type struct_itimerspec is record
      it_interval : struct_timespec;
      it_value : struct_timespec;
   end record;
   for struct_itimerspec use record
      it_interval at 0 range 0 .. 63;
      it_value at 8 range 0 .. 63;
   end record;
   pragma Convention (C_Pass_By_Copy, struct_itimerspec);
   for struct_itimerspec'Alignment use ALIGNMENT;
   pragma Warnings (Off);
   --  There may be holes in the record, due to
   --  components not defined by POSIX standard.
   for struct_itimerspec'Size use 128;
   pragma Warnings (On);
   type itimerspec_ptr is access constant struct_itimerspec;
   pragma Convention (C, itimerspec_ptr);
   type itimerspec_var_ptr is access all struct_itimerspec;
   pragma Convention (C, itimerspec_var_ptr);
   type struct_tm is record
      tm_sec : int;
      tm_min : int;
      tm_hour : int;
      tm_mday : int;
      tm_mon : int;
      tm_year : int;
      tm_wday : int;
      tm_yday : int;
      tm_isdst : int;
   end record;
   for struct_tm use record
      tm_sec at 0 range 0 .. 31;
      tm_min at 4 range 0 .. 31;
      tm_hour at 8 range 0 .. 31;
      tm_mday at 12 range 0 .. 31;
      tm_mon at 16 range 0 .. 31;
      tm_year at 20 range 0 .. 31;
      tm_wday at 24 range 0 .. 31;
      tm_yday at 28 range 0 .. 31;
      tm_isdst at 32 range 0 .. 31;
   end record;
   pragma Convention (C_Pass_By_Copy, struct_tm);
   for struct_tm'Alignment use ALIGNMENT;
   pragma Warnings (Off);
   --  There may be holes in the record, due to
   --  components not defined by POSIX standard.
   for struct_tm'Size use 352;
   pragma Warnings (On);
   type tm_ptr is access constant struct_tm;
   pragma Convention (C, tm_ptr);
   type tm_var_ptr is access all struct_tm;
   pragma Convention (C, tm_var_ptr);
   type struct_tms is record
      tms_utime : clock_t;
      tms_stime : clock_t;
      tms_cutime : clock_t;
      tms_cstime : clock_t;
   end record;
   for struct_tms use record
      tms_utime at 0 range 0 .. 31;
      tms_stime at 4 range 0 .. 31;
      tms_cutime at 8 range 0 .. 31;
      tms_cstime at 12 range 0 .. 31;
   end record;
   pragma Convention (C_Pass_By_Copy, struct_tms);
   for struct_tms'Alignment use ALIGNMENT;
   pragma Warnings (Off);
   --  There may be holes in the record, due to
   --  components not defined by POSIX standard.
   for struct_tms'Size use 128;
   pragma Warnings (On);
   type tms_ptr is access constant struct_tms;
   pragma Convention (C, tms_ptr);
   type tms_var_ptr is access all struct_tms;
   pragma Convention (C, tms_var_ptr);
   type struct_utimbuf is record
      modtime : time_t;
      actime : time_t;
   end record;
   for struct_utimbuf use record
      modtime at 4 range 0 .. 31;
      actime at 0 range 0 .. 31;
   end record;
   pragma Convention (C_Pass_By_Copy, struct_utimbuf);
   for struct_utimbuf'Alignment use ALIGNMENT;
   pragma Warnings (Off);
   --  There may be holes in the record, due to
   --  components not defined by POSIX standard.
   for struct_utimbuf'Size use 64;
   pragma Warnings (On);
   type utimbuf_ptr is access constant struct_utimbuf;
   pragma Convention (C, utimbuf_ptr);
   type utimbuf_var_ptr is access all struct_utimbuf;
   pragma Convention (C, utimbuf_var_ptr);
   subtype utsname_sysname_string is
      POSIX_String (1 .. 65);
   subtype utsname_nodename_string is
      POSIX_String (1 .. 65);
   subtype utsname_release_string is
      POSIX_String (1 .. 65);
   subtype utsname_version_string is
      POSIX_String (1 .. 65);
   subtype utsname_machine_string is
      POSIX_String (1 .. 65);
   type struct_utsname is record
      sysname : utsname_sysname_string;
      nodename : utsname_nodename_string;
      release : utsname_release_string;
      version : utsname_version_string;
      machine : utsname_machine_string;
   end record;
   for struct_utsname use record
      sysname at 0 range 0 .. 519;
      nodename at 65 range 0 .. 519;
      release at 130 range 0 .. 519;
      version at 195 range 0 .. 519;
      machine at 260 range 0 .. 519;
   end record;
   pragma Convention (C_Pass_By_Copy, struct_utsname);
   for struct_utsname'Alignment use ALIGNMENT;
   pragma Warnings (Off);
   --  There may be holes in the record, due to
   --  components not defined by POSIX standard.
   for struct_utsname'Size use 3120;
   pragma Warnings (On);
   type utsname_ptr is access constant struct_utsname;
   pragma Convention (C, utsname_ptr);
   type utsname_var_ptr is access all struct_utsname;
   pragma Convention (C, utsname_var_ptr);

   ----------------------------------
   --  link names for C functions  --
   ----------------------------------
   HAVE_access : constant Boolean := True;
   access_LINKNAME : constant String := "access";
   HAVE_aio_cancel : constant Boolean := True;
   aio_cancel_LINKNAME : constant String := "aio_cancel";
   HAVE_aio_error : constant Boolean := True;
   aio_error_LINKNAME : constant String := "aio_error";
   HAVE_aio_fsync : constant Boolean := True;
   aio_fsync_LINKNAME : constant String := "aio_fsync";
   HAVE_aio_read : constant Boolean := True;
   aio_read_LINKNAME : constant String := "aio_read";
   HAVE_aio_return : constant Boolean := True;
   aio_return_LINKNAME : constant String := "aio_return";
   HAVE_aio_suspend : constant Boolean := True;
   aio_suspend_LINKNAME : constant String := "aio_suspend";
   HAVE_aio_write : constant Boolean := True;
   aio_write_LINKNAME : constant String := "aio_write";
   HAVE_cfgetispeed : constant Boolean := True;
   cfgetispeed_LINKNAME : constant String := "cfgetispeed";
   HAVE_cfgetospeed : constant Boolean := True;
   cfgetospeed_LINKNAME : constant String := "cfgetospeed";
   HAVE_cfsetispeed : constant Boolean := True;
   cfsetispeed_LINKNAME : constant String := "cfsetispeed";
   HAVE_cfsetospeed : constant Boolean := True;
   cfsetospeed_LINKNAME : constant String := "cfsetospeed";
   HAVE_chdir : constant Boolean := True;
   chdir_LINKNAME : constant String := "chdir";
   HAVE_chmod : constant Boolean := True;
   chmod_LINKNAME : constant String := "chmod";
   HAVE_chown : constant Boolean := True;
   chown_LINKNAME : constant String := "chown";
   HAVE_clock_getres : constant Boolean := True;
   clock_getres_LINKNAME : constant String := "clock_getres";
   HAVE_clock_gettime : constant Boolean := True;
   clock_gettime_LINKNAME : constant String := "clock_gettime";
   HAVE_clock_settime : constant Boolean := True;
   clock_settime_LINKNAME : constant String := "clock_settime";
   HAVE_close : constant Boolean := True;
   close_LINKNAME : constant String := "close";
   HAVE_closedir : constant Boolean := True;
   closedir_LINKNAME : constant String := "closedir";
   HAVE_ctermid : constant Boolean := True;
   ctermid_LINKNAME : constant String := "ctermid";
   HAVE_ctime : constant Boolean := True;
   ctime_LINKNAME : constant String := "ctime";
   HAVE_ctime_r : constant Boolean := True;
   ctime_r_LINKNAME : constant String := "ctime_r";
   HAVE_dup : constant Boolean := True;
   dup_LINKNAME : constant String := "dup";
   HAVE_dup2 : constant Boolean := True;
   dup2_LINKNAME : constant String := "dup2";
   HAVE_execv : constant Boolean := True;
   execv_LINKNAME : constant String := "execv";
   HAVE_execve : constant Boolean := True;
   execve_LINKNAME : constant String := "execve";
   HAVE_execvp : constant Boolean := True;
   execvp_LINKNAME : constant String := "execvp";
   HAVE_fchmod : constant Boolean := True;
   fchmod_LINKNAME : constant String := "fchmod";
   HAVE_fcntl : constant Boolean := True;
   fcntl_LINKNAME : constant String := "fcntl";
   HAVE_fdatasync : constant Boolean := True;
   fdatasync_LINKNAME : constant String := "fdatasync";
   HAVE_fork : constant Boolean := True;
   fork_LINKNAME : constant String := "fork";
   HAVE_fpathconf : constant Boolean := True;
   fpathconf_LINKNAME : constant String := "fpathconf";
   HAVE_fstat : constant Boolean := True;
   fstat_LINKNAME : constant String := "__gnat_florist_fstat";
   HAVE_fsync : constant Boolean := True;
   fsync_LINKNAME : constant String := "fsync";
   HAVE_ftruncate : constant Boolean := True;
   ftruncate_LINKNAME : constant String := "ftruncate64";
   HAVE_getcwd : constant Boolean := True;
   getcwd_LINKNAME : constant String := "getcwd";
   HAVE_getegid : constant Boolean := True;
   getegid_LINKNAME : constant String := "getegid";
   HAVE_getenv : constant Boolean := True;
   getenv_LINKNAME : constant String := "getenv";
   HAVE_geteuid : constant Boolean := True;
   geteuid_LINKNAME : constant String := "geteuid";
   HAVE_getgid : constant Boolean := True;
   getgid_LINKNAME : constant String := "getgid";
   HAVE_getgrgid : constant Boolean := True;
   getgrgid_LINKNAME : constant String := "getgrgid";
   HAVE_getgrnam : constant Boolean := True;
   getgrnam_LINKNAME : constant String := "getgrnam";
   HAVE_getgroups : constant Boolean := True;
   getgroups_LINKNAME : constant String := "getgroups";
   HAVE_getlogin : constant Boolean := True;
   getlogin_LINKNAME : constant String := "getlogin";
   HAVE_getpgrp : constant Boolean := True;
   getpgrp_LINKNAME : constant String := "getpgrp";
   HAVE_getpid : constant Boolean := True;
   getpid_LINKNAME : constant String := "getpid";
   HAVE_getppid : constant Boolean := True;
   getppid_LINKNAME : constant String := "getppid";
   HAVE_getpwnam : constant Boolean := True;
   getpwnam_LINKNAME : constant String := "getpwnam";
   HAVE_getpwuid : constant Boolean := True;
   getpwuid_LINKNAME : constant String := "getpwuid";
   HAVE_gettimeofday : constant Boolean := True;
   gettimeofday_LINKNAME : constant String := "gettimeofday";
   HAVE_getuid : constant Boolean := True;
   getuid_LINKNAME : constant String := "getuid";
   HAVE_gmtime_r : constant Boolean := True;
   gmtime_r_LINKNAME : constant String := "gmtime_r";
   HAVE_isatty : constant Boolean := True;
   isatty_LINKNAME : constant String := "isatty";
   HAVE_kill : constant Boolean := True;
   kill_LINKNAME : constant String := "kill";
   HAVE_link : constant Boolean := True;
   link_LINKNAME : constant String := "link";
   HAVE_lio_listio : constant Boolean := True;
   lio_listio_LINKNAME : constant String := "lio_listio";
   HAVE_lstat : constant Boolean := True;
   lstat_LINKNAME : constant String := "__gnat_florist_lstat";
   HAVE_lseek : constant Boolean := True;
   lseek_LINKNAME : constant String := "lseek64";
   HAVE_mkdir : constant Boolean := True;
   mkdir_LINKNAME : constant String := "mkdir";
   HAVE_mkfifo : constant Boolean := True;
   mkfifo_LINKNAME : constant String := "mkfifo";
   HAVE_mlock : constant Boolean := True;
   mlock_LINKNAME : constant String := "mlock";
   HAVE_mlockall : constant Boolean := True;
   mlockall_LINKNAME : constant String := "mlockall";
   HAVE_mmap : constant Boolean := True;
   mmap_LINKNAME : constant String := "mmap";
   HAVE_mprotect : constant Boolean := True;
   mprotect_LINKNAME : constant String := "mprotect";
   HAVE_mq_close : constant Boolean := True;
   mq_close_LINKNAME : constant String := "mq_close";
   HAVE_mq_getattr : constant Boolean := True;
   mq_getattr_LINKNAME : constant String := "mq_getattr";
   HAVE_mq_notify : constant Boolean := True;
   mq_notify_LINKNAME : constant String := "mq_notify";
   HAVE_mq_open : constant Boolean := True;
   mq_open_LINKNAME : constant String := "mq_open";
   HAVE_mq_receive : constant Boolean := True;
   mq_receive_LINKNAME : constant String := "mq_receive";
   HAVE_mq_send : constant Boolean := True;
   mq_send_LINKNAME : constant String := "mq_send";
   HAVE_mq_setattr : constant Boolean := True;
   mq_setattr_LINKNAME : constant String := "mq_setattr";
   HAVE_mq_unlink : constant Boolean := True;
   mq_unlink_LINKNAME : constant String := "mq_unlink";
   HAVE_msync : constant Boolean := True;
   msync_LINKNAME : constant String := "msync";
   HAVE_munlock : constant Boolean := True;
   munlock_LINKNAME : constant String := "munlock";
   HAVE_munlockall : constant Boolean := True;
   munlockall_LINKNAME : constant String := "munlockall";
   HAVE_munmap : constant Boolean := True;
   munmap_LINKNAME : constant String := "munmap";
   HAVE_open : constant Boolean := True;
   open_LINKNAME : constant String := "__gnat_florist_open";
   HAVE_opendir : constant Boolean := True;
   opendir_LINKNAME : constant String := "opendir";
   HAVE_pathconf : constant Boolean := True;
   pathconf_LINKNAME : constant String := "pathconf";
   HAVE_pipe : constant Boolean := True;
   pipe_LINKNAME : constant String := "pipe";
   pthread_cond_broadcast_LINKNAME : constant String :=
      "pthread_cond_broadcast";
   pthread_cond_destroy_LINKNAME : constant String := "pthread_cond_destroy";
   pthread_cond_init_LINKNAME : constant String := "pthread_cond_init";
   pthread_cond_signal_LINKNAME : constant String := "pthread_cond_signal";
   pthread_cond_timedwait_LINKNAME : constant String :=
      "pthread_cond_timedwait";
   pthread_cond_wait_LINKNAME : constant String := "pthread_cond_wait";
   pthread_condattr_destroy_LINKNAME : constant String :=
      "pthread_condattr_destroy";
   --  *** MISSING: function pthread_condattr_getpshared ***  --
   pthread_condattr_getpshared_LINKNAME : constant String :=
      "nosys_direct";
   pthread_condattr_init_LINKNAME : constant String :=
      "pthread_condattr_init";
   --  *** MISSING: function pthread_condattr_setpshared ***  --
   pthread_condattr_setpshared_LINKNAME : constant String :=
      "nosys_direct";
   pthread_mutex_destroy_LINKNAME : constant String :=
      "pthread_mutex_destroy";
   --  *** MISSING: function pthread_mutex_getprioceiling ***  --
   pthread_mutex_getprioceiling_LINKNAME : constant String :=
      "nosys_direct";
   pthread_mutex_init_LINKNAME : constant String := "pthread_mutex_init";
   pthread_mutex_lock_LINKNAME : constant String := "pthread_mutex_lock";
   --  *** MISSING: function pthread_mutex_setprioceiling ***  --
   pthread_mutex_setprioceiling_LINKNAME : constant String :=
      "nosys_direct";
   --  *** MISSING: function pthread_mutex_trylock ***  --
   pthread_mutex_trylock_LINKNAME : constant String :=
      "nosys_direct";
   pthread_mutex_unlock_LINKNAME : constant String := "pthread_mutex_unlock";
   --  *** MISSING: function pthread_mutexattr_destroy ***  --
   pthread_mutexattr_destroy_LINKNAME : constant String :=
      "nosys_direct";
   --  *** MISSING: function pthread_mutexattr_getprioceiling ***  --
   pthread_mutexattr_getprioceiling_LINKNAME : constant String :=
      "nosys_direct";
   --  *** MISSING: function pthread_mutexattr_getprotocol ***  --
   pthread_mutexattr_getprotocol_LINKNAME : constant String :=
      "nosys_direct";
   --  *** MISSING: function pthread_mutexattr_getpshared ***  --
   pthread_mutexattr_getpshared_LINKNAME : constant String :=
      "nosys_direct";
   --  *** MISSING: function pthread_mutexattr_init ***  --
   pthread_mutexattr_init_LINKNAME : constant String :=
      "nosys_direct";
   --  *** MISSING: function pthread_mutexattr_setprioceiling ***  --
   pthread_mutexattr_setprioceiling_LINKNAME : constant String :=
      "nosys_direct";
   --  *** MISSING: function pthread_mutexattr_setprotocol ***  --
   pthread_mutexattr_setprotocol_LINKNAME : constant String :=
      "nosys_direct";
   --  *** MISSING: function pthread_mutexattr_setpshared ***  --
   pthread_mutexattr_setpshared_LINKNAME : constant String :=
      "nosys_direct";
   --  *** MISSING: function pthread_sigmask ***  --
   pthread_sigmask_LINKNAME : constant String := "nosys_direct";
   HAVE_putenv : constant Boolean := True;
   putenv_LINKNAME : constant String := "putenv";
   HAVE_read : constant Boolean := True;
   read_LINKNAME : constant String := "read";
   HAVE_readdir : constant Boolean := True;
   readdir_LINKNAME : constant String := "readdir64";
   HAVE_readdir_r : constant Boolean := True;
   readdir_r_LINKNAME : constant String := "readdir64_r";
   HAVE_rename : constant Boolean := True;
   rename_LINKNAME : constant String := "rename";
   HAVE_rmdir : constant Boolean := True;
   rmdir_LINKNAME : constant String := "rmdir";
   HAVE_sched_get_priority_max : constant Boolean := True;
   sched_get_priority_max_LINKNAME : constant String :=
       "sched_get_priority_max";
   HAVE_sched_get_priority_min : constant Boolean := True;
   sched_get_priority_min_LINKNAME : constant String :=
       "sched_get_priority_min";
   HAVE_sched_rr_get_interval : constant Boolean := True;
   sched_rr_get_interval_LINKNAME : constant String :=
       "sched_rr_get_interval";
   HAVE_sched_getparam : constant Boolean := True;
   sched_getparam_LINKNAME : constant String := "sched_getparam";
   HAVE_sched_getscheduler : constant Boolean := True;
   sched_getscheduler_LINKNAME : constant String := "sched_getscheduler";
   HAVE_sched_setparam : constant Boolean := True;
   sched_setparam_LINKNAME : constant String := "sched_setparam";
   HAVE_sched_setscheduler : constant Boolean := True;
   sched_setscheduler_LINKNAME : constant String := "sched_setscheduler";
   HAVE_sched_yield : constant Boolean := True;
   sched_yield_LINKNAME : constant String := "sched_yield";
   --  *** MISSING: function sem_close ***  --
   HAVE_sem_close : constant Boolean := False;
   sem_close_LINKNAME : constant String := "nosys_neg_one";
   --  *** MISSING: function sem_destroy ***  --
   HAVE_sem_destroy : constant Boolean := False;
   sem_destroy_LINKNAME : constant String := "nosys_neg_one";
   --  *** MISSING: function sem_getvalue ***  --
   HAVE_sem_getvalue : constant Boolean := False;
   sem_getvalue_LINKNAME : constant String := "nosys_neg_one";
   --  *** MISSING: function sem_init ***  --
   HAVE_sem_init : constant Boolean := False;
   sem_init_LINKNAME : constant String := "nosys_neg_one";
   --  *** MISSING: function sem_open ***  --
   HAVE_sem_open : constant Boolean := False;
   sem_open_LINKNAME : constant String := "nosys_neg_one";
   --  *** MISSING: function sem_post ***  --
   HAVE_sem_post : constant Boolean := False;
   sem_post_LINKNAME : constant String := "nosys_neg_one";
   --  *** MISSING: function sem_trywait ***  --
   HAVE_sem_trywait : constant Boolean := False;
   sem_trywait_LINKNAME : constant String := "nosys_neg_one";
   --  *** MISSING: function sem_unlink ***  --
   HAVE_sem_unlink : constant Boolean := False;
   sem_unlink_LINKNAME : constant String := "nosys_neg_one";
   --  *** MISSING: function sem_wait ***  --
   HAVE_sem_wait : constant Boolean := False;
   sem_wait_LINKNAME : constant String := "nosys_neg_one";
   HAVE_setenv : constant Boolean := True;
   setenv_LINKNAME : constant String := "setenv";
   HAVE_setgid : constant Boolean := True;
   setgid_LINKNAME : constant String := "setgid";
   HAVE_setpgid : constant Boolean := True;
   setpgid_LINKNAME : constant String := "setpgid";
   HAVE_setsid : constant Boolean := True;
   setsid_LINKNAME : constant String := "setsid";
   HAVE_setuid : constant Boolean := True;
   setuid_LINKNAME : constant String := "setuid";
   HAVE_shm_open : constant Boolean := True;
   shm_open_LINKNAME : constant String := "shm_open";
   HAVE_shm_unlink : constant Boolean := True;
   shm_unlink_LINKNAME : constant String := "shm_unlink";
   HAVE_sigaction : constant Boolean := True;
   sigaction_LINKNAME : constant String := "sigaction";
   HAVE_sigaddset : constant Boolean := True;
   sigaddset_LINKNAME : constant String := "sigaddset";
   HAVE_sigdelset : constant Boolean := True;
   sigdelset_LINKNAME : constant String := "sigdelset";
   HAVE_sigemptyset : constant Boolean := True;
   sigemptyset_LINKNAME : constant String := "sigemptyset";
   HAVE_sigfillset : constant Boolean := True;
   sigfillset_LINKNAME : constant String := "sigfillset";
   HAVE_sigismember : constant Boolean := True;
   sigismember_LINKNAME : constant String := "sigismember";
   HAVE_sigpending : constant Boolean := True;
   sigpending_LINKNAME : constant String := "sigpending";
   HAVE_sigprocmask : constant Boolean := True;
   sigprocmask_LINKNAME : constant String := "sigprocmask";
   HAVE_sigqueue : constant Boolean := True;
   sigqueue_LINKNAME : constant String := "sigqueue";
   HAVE_sigtimedwait : constant Boolean := True;
   sigtimedwait_LINKNAME : constant String := "sigtimedwait";
   HAVE_sigwait : constant Boolean := True;
   sigwait_LINKNAME : constant String := "sigwait";
   HAVE_sigwaitinfo : constant Boolean := True;
   sigwaitinfo_LINKNAME : constant String := "sigwaitinfo";
   HAVE_stat : constant Boolean := True;
   stat_LINKNAME : constant String := "__gnat_florist_stat";
   HAVE_sysconf : constant Boolean := True;
   sysconf_LINKNAME : constant String := "sysconf";
   HAVE_tcdrain : constant Boolean := True;
   tcdrain_LINKNAME : constant String := "tcdrain";
   HAVE_tcflow : constant Boolean := True;
   tcflow_LINKNAME : constant String := "tcflow";
   HAVE_tcflush : constant Boolean := True;
   tcflush_LINKNAME : constant String := "tcflush";
   HAVE_tcgetattr : constant Boolean := True;
   tcgetattr_LINKNAME : constant String := "tcgetattr";
   HAVE_tcgetpgrp : constant Boolean := True;
   tcgetpgrp_LINKNAME : constant String := "tcgetpgrp";
   HAVE_tcsendbreak : constant Boolean := True;
   tcsendbreak_LINKNAME : constant String := "tcsendbreak";
   HAVE_tcsetattr : constant Boolean := True;
   tcsetattr_LINKNAME : constant String := "tcsetattr";
   HAVE_tcsetpgrp : constant Boolean := True;
   tcsetpgrp_LINKNAME : constant String := "tcsetpgrp";
   HAVE_time : constant Boolean := True;
   time_LINKNAME : constant String := "time";
   HAVE_timer_create : constant Boolean := True;
   timer_create_LINKNAME : constant String := "timer_create";
   HAVE_timer_delete : constant Boolean := True;
   timer_delete_LINKNAME : constant String := "timer_delete";
   HAVE_timer_getoverrun : constant Boolean := True;
   timer_getoverrun_LINKNAME : constant String := "timer_getoverrun";
   HAVE_timer_gettime : constant Boolean := True;
   timer_gettime_LINKNAME : constant String := "timer_gettime";
   HAVE_timer_settime : constant Boolean := True;
   timer_settime_LINKNAME : constant String := "timer_settime";
   HAVE_times : constant Boolean := True;
   times_LINKNAME : constant String := "times";
   HAVE_ttyname : constant Boolean := True;
   ttyname_LINKNAME : constant String := "ttyname";
   HAVE_umask : constant Boolean := True;
   umask_LINKNAME : constant String := "umask";
   HAVE_uname : constant Boolean := True;
   uname_LINKNAME : constant String := "__gnat_florist_uname";
   HAVE_unlink : constant Boolean := True;
   unlink_LINKNAME : constant String := "unlink";
   HAVE_unsetenv : constant Boolean := True;
   unsetenv_LINKNAME : constant String := "unsetenv";
   HAVE_utime : constant Boolean := True;
   utime_LINKNAME : constant String := "utime";
   HAVE_waitpid : constant Boolean := True;
   waitpid_LINKNAME : constant String := "waitpid";
   HAVE_write : constant Boolean := True;
   write_LINKNAME : constant String := "write";

   ------------------------------
   --  C functions for macros  --
   ------------------------------
   function s_isdir (mode : mode_t) return int;
   pragma Import (C, s_isdir, "s_isdir");
   function s_ischr (mode : mode_t) return int;
   pragma Import (C, s_ischr, "s_ischr");
   function s_isblk (mode : mode_t) return int;
   pragma Import (C, s_isblk, "s_isblk");
   function s_islnk (mode : mode_t) return int;
   pragma Import (C, s_islnk, "s_islnk");
   function s_isreg (mode : mode_t) return int;
   pragma Import (C, s_isreg, "s_isreg");
   function s_isfifo (mode : mode_t) return int;
   pragma Import (C, s_isfifo, "s_isfifo");
   function s_ismsg (mode : mode_t) return int;
   pragma Import (C, s_ismsg, "s_ismsg");
   function s_issem (mode : mode_t) return int;
   pragma Import (C, s_issem, "s_issem");
   function s_isshm (mode : mode_t) return int;
   pragma Import (C, s_isshm, "s_isshm");
   function s_issock (mode : mode_t) return int;
   pragma Import (C, s_issock, "s_issock");
   function s_typeismq (stat : stat_ptr) return int;
   pragma Import (C, s_typeismq, "s_typeismq");
   function s_typeissem (stat : stat_ptr) return int;
   pragma Import (C, s_typeissem, "s_typeissem");
   function s_typeisshm (stat : stat_ptr) return int;
   pragma Import (C, s_typeisshm, "s_typeisshm");
   function wifexited (stat_val : int) return int;
   pragma Import (C, wifexited, "wifexited");
   function wifexitstatus (stat_val : int) return int;
   pragma Import (C, wifexitstatus, "wifexitstatus");
   function wifsignaled (stat_val : int) return int;
   pragma Import (C, wifsignaled, "wifsignaled");
   function wiftermsig (stat_val : int) return int;
   pragma Import (C, wiftermsig, "wiftermsig");
   function wifstopped (stat_val : int) return int;
   pragma Import (C, wifstopped, "wifstopped");
   function wifstopsig (stat_val : int) return int;
   pragma Import (C, wifstopsig, "wifstopsig");
   package Sockets is

      ----------------
      --  socket.h  --
      ----------------
      type sa_family_t is mod 2**16;
      for sa_family_t'Size use 16;
      type in_port_t is mod 2**16;
      for in_port_t'Size use 16;

      -----------------
      --  constants  --
      -----------------
      HOST_NOT_FOUND : constant := 1;
      NO_DATA : constant := 4;
      NO_RECOVERY : constant := 3;
      TRY_AGAIN : constant := 2;
      --  *** MISSING: MAX_SOCKADDR_EXT ***  --
      MAX_SOCKADDR_EXT : constant := 108;

      --  sockets protocol level  --
      SOL_SOCKET : constant := 1;

      --  socket types  --
      SOCK_STREAM : constant := 1;
      SOCK_DGRAM : constant := 2;
      SOCK_RAW : constant := 3;
      SOCK_SEQPACKET : constant := 5;

      --  address families  --
      AF_MAX : constant := 37;
      AF_UNSPEC : constant := 0;
      AF_UNIX : constant := 1;
      AF_LOCAL : constant := 1;
      AF_INET : constant := 2;
      --  *** MISSING: AF_OSI ***  --
      AF_OSI : constant := 0;
      --  *** MISSING: AF_ISO ***  --
      AF_ISO : constant := 0;

      --  protocol families  --
      PF_MAX : constant := 37;
      PF_UNSPEC : constant := 0;
      PF_LOCAL : constant := 1;
      PF_UNIX : constant := 1;
      PF_INET : constant := 2;
      --  *** MISSING: PF_OSI ***  --
      PF_OSI : constant := 0;
      --  *** MISSING: PF_ISO ***  --
      PF_ISO : constant := 0;

      --  socket options  --
      SO_BROADCAST : constant := 6;
      SO_DEBUG : constant := 1;
      SO_DONTROUTE : constant := 5;
      SO_ERROR : constant := 4;
      SO_KEEPALIVE : constant := 9;
      SO_LINGER : constant := 13;
      SO_OOBINLINE : constant := 10;
      SO_RCVBUF : constant := 8;
      SO_RCVLOWAT : constant := 16;
      SO_RCVTIMEO : constant := 18;
      SO_REUSEADDR : constant := 2;
      SO_SNDBUF : constant := 7;
      SO_SNDLOWAT : constant := 17;
      SO_SNDTIMEO : constant := 19;
      SO_TYPE : constant := 3;

      --  max queued connections  --
      SOMAXCONN : constant := 128;

      --  send & receive option flag bits  --
      MSG_OOB : constant := 1;
      MSG_PEEK : constant := 2;
      MSG_DONTROUTE : constant := 4;
      MSG_EOR : constant := 128;
      MSG_TRUNC : constant := 32;
      MSG_CTRUNC : constant := 8;
      MSG_WAITALL : constant := 256;
      --  *** MISSING: MSG_MAXIOVLEN ***  --
      MSG_MAXIOVLEN : constant := 0;

      --  socket address information option flag bits  --
      AI_PASSIVE : constant := 1;
      AI_CANONNAME : constant := 2;

      --  scoket shutdown mode flag bits  --
      SHUT_RD : constant := 0;
      SHUT_WR : constant := 1;
      SHUT_RDWR : constant := 2;

      ------------------
      --  structures  --
      ------------------

      --  generic socket address  --
      type struct_sockaddr is record
         sa_family : sa_family_t;
         sa_data : POSIX_String (1 .. 14);
      end record;
      for struct_sockaddr use record
         sa_family at 0 range 0 .. 15;
         sa_data at 2 range 0 .. 111;
      end record;
      pragma Convention (C_Pass_By_Copy, struct_sockaddr);
      for struct_sockaddr'Alignment use ALIGNMENT;
      pragma Warnings (Off);
      --  There may be holes in the record, due to
      --  components not defined by POSIX standard.
      for struct_sockaddr'Size use 128;
      pragma Warnings (On);
      type sockaddr_ptr is access constant struct_sockaddr;
      pragma Convention (C, sockaddr_ptr);
      type sockaddr_var_ptr is access all struct_sockaddr;
      pragma Convention (C, sockaddr_var_ptr);

      --  struct addrinfo...  --
      type struct_addrinfo;
      type addrinfo_ptr is access constant struct_addrinfo;
      pragma Convention (C, addrinfo_ptr);
      type addrinfo_var_ptr is access all struct_addrinfo;
      pragma Convention (C, addrinfo_var_ptr);
      type struct_addrinfo is record
         ai_flags : int;
         ai_family : int;
         ai_socktype : int;
         ai_protocol : int;
         ai_addrlen : size_t;
         ai_addr : sockaddr_ptr;
         ai_canonname : char_ptr;
         ai_next : addrinfo_ptr;
      end record;
      for struct_addrinfo use record
         ai_flags at 0 range 0 .. 31;
         ai_family at 4 range 0 .. 31;
         ai_socktype at 8 range 0 .. 31;
         ai_protocol at 12 range 0 .. 31;
         ai_addrlen at 16 range 0 .. 31;
         ai_addr at 20 range 0 .. 31;
         ai_canonname at 24 range 0 .. 31;
         ai_next at 28 range 0 .. 31;
      end record;
      pragma Convention (C_Pass_By_Copy, struct_addrinfo);
      for struct_addrinfo'Alignment use ALIGNMENT;
      pragma Warnings (Off);
      --  There may be holes in the record, due to
      --  components not defined by POSIX standard.
      for struct_addrinfo'Size use 256;
      pragma Warnings (On);

      --  message option header  --
      type struct_cmsghdr is record
         cmsg_level : int;
         cmsg_type : int;
         cmsg_len : socklen_t;
      end record;
      for struct_cmsghdr use record
         cmsg_level at 4 range 0 .. 31;
         cmsg_type at 8 range 0 .. 31;
         cmsg_len at 0 range 0 .. 31;
      end record;
      pragma Convention (C_Pass_By_Copy, struct_cmsghdr);
      for struct_cmsghdr'Alignment use ALIGNMENT;
      pragma Warnings (Off);
      --  There may be holes in the record, due to
      --  components not defined by POSIX standard.
      for struct_cmsghdr'Size use 96;
      pragma Warnings (On);
      type cmsghdr_ptr is access constant struct_cmsghdr;
      pragma Convention (C, cmsghdr_ptr);
      type cmsghdr_var_ptr is access all struct_cmsghdr;
      pragma Convention (C, cmsghdr_var_ptr);

      --  host database entry  --
      type struct_hostent is record
         h_name : char_ptr;
         h_aliases : char_ptr_ptr;
         h_addrtype : int;
         h_length : int;
         h_addr_list : char_ptr_ptr;
      end record;
      for struct_hostent use record
         h_name at 0 range 0 .. 31;
         h_aliases at 4 range 0 .. 31;
         h_addrtype at 8 range 0 .. 31;
         h_length at 12 range 0 .. 31;
         h_addr_list at 16 range 0 .. 31;
      end record;
      pragma Convention (C_Pass_By_Copy, struct_hostent);
      for struct_hostent'Alignment use ALIGNMENT;
      pragma Warnings (Off);
      --  There may be holes in the record, due to
      --  components not defined by POSIX standard.
      for struct_hostent'Size use 160;
      pragma Warnings (On);
      type hostent_ptr is access constant struct_hostent;
      pragma Convention (C, hostent_ptr);
      type hostent_var_ptr is access all struct_hostent;
      pragma Convention (C, hostent_var_ptr);

      --  internet address  --
      type in_addr_t is mod 2**32;
      for in_addr_t'Size use 32;
      type struct_in_addr is record
         s_addr : in_addr_t;
      end record;
      for struct_in_addr use record
         s_addr at 0 range 0 .. 31;
      end record;
      pragma Convention (C_Pass_By_Copy, struct_in_addr);
      for struct_in_addr'Alignment use ALIGNMENT;
      pragma Warnings (Off);
      --  There may be holes in the record, due to
      --  components not defined by POSIX standard.
      for struct_in_addr'Size use 32;
      pragma Warnings (On);
      type in_addr_ptr is access constant struct_in_addr;
      pragma Convention (C, in_addr_ptr);
      type in_addr_var_ptr is access all struct_in_addr;
      pragma Convention (C, in_addr_var_ptr);

      --  linger option structure  --
      type struct_linger is record
         l_onoff : int;
         l_linger : int;
      end record;
      for struct_linger use record
         l_onoff at 0 range 0 .. 31;
         l_linger at 4 range 0 .. 31;
      end record;
      pragma Convention (C_Pass_By_Copy, struct_linger);
      for struct_linger'Alignment use ALIGNMENT;
      pragma Warnings (Off);
      --  There may be holes in the record, due to
      --  components not defined by POSIX standard.
      for struct_linger'Size use 64;
      pragma Warnings (On);
      type linger_ptr is access constant struct_linger;
      pragma Convention (C, linger_ptr);
      type linger_var_ptr is access all struct_linger;
      pragma Convention (C, linger_var_ptr);

      --  I/O vector  --
      type struct_iovec is record
         iov_base : char_ptr;
         iov_len : size_t;
      end record;
      for struct_iovec use record
         iov_base at 0 range 0 .. 31;
         iov_len at 4 range 0 .. 31;
      end record;
      pragma Convention (C_Pass_By_Copy, struct_iovec);
      for struct_iovec'Alignment use ALIGNMENT;
      pragma Warnings (Off);
      --  There may be holes in the record, due to
      --  components not defined by POSIX standard.
      for struct_iovec'Size use 64;
      pragma Warnings (On);
      type iovec_ptr is access constant struct_iovec;
      pragma Convention (C, iovec_ptr);
      type iovec_var_ptr is access all struct_iovec;
      pragma Convention (C, iovec_var_ptr);

      --  message header  --
      type struct_msghdr is record
         msg_name : sockaddr_ptr;
         msg_namelen : size_t;
         msg_iov : iovec_ptr;
         msg_iovlen : size_t;
         msg_control : char_ptr;
         msg_controllen : socklen_t;
         msg_flags : int;
      end record;
      for struct_msghdr use record
         msg_name at 0 range 0 .. 31;
         msg_namelen at 4 range 0 .. 31;
         msg_iov at 8 range 0 .. 31;
         msg_iovlen at 12 range 0 .. 31;
         msg_control at 16 range 0 .. 31;
         msg_controllen at 20 range 0 .. 31;
         msg_flags at 24 range 0 .. 31;
      end record;
      pragma Convention (C_Pass_By_Copy, struct_msghdr);
      for struct_msghdr'Alignment use ALIGNMENT;
      pragma Warnings (Off);
      --  There may be holes in the record, due to
      --  components not defined by POSIX standard.
      for struct_msghdr'Size use 224;
      pragma Warnings (On);
      type msghdr_ptr is access constant struct_msghdr;
      pragma Convention (C, msghdr_ptr);
      type msghdr_var_ptr is access all struct_msghdr;
      pragma Convention (C, msghdr_var_ptr);

      --  local socket address  --
      subtype sun_path_string is POSIX_String (1 .. 108);
      type struct_sockaddr_un is record
         sun_family : sa_family_t;
         sun_path : sun_path_string;
      end record;
      for struct_sockaddr_un use record
         sun_family at 0 range 0 .. 15;
         sun_path at 2 range 0 .. 863;
      end record;
      pragma Convention (C_Pass_By_Copy, struct_sockaddr_un);
      for struct_sockaddr_un'Alignment use ALIGNMENT;
      pragma Warnings (Off);
      --  There may be holes in the record, due to
      --  components not defined by POSIX standard.
      for struct_sockaddr_un'Size use 880;
      pragma Warnings (On);
      type sockaddr_un_ptr is access constant struct_sockaddr_un;
      pragma Convention (C, sockaddr_un_ptr);
      type sockaddr_un_var_ptr is access all struct_sockaddr_un;
      pragma Convention (C, sockaddr_un_var_ptr);

      --  internet socket address  --
      type struct_sockaddr_in is record
         sin_family : sa_family_t;
         sin_port : in_port_t;
         sin_addr : struct_in_addr;
         sin_zero : POSIX_String (1 .. 8);
      end record;
      for struct_sockaddr_in use record
         sin_family at 0 range 0 .. 15;
         sin_port at 2 range 0 .. 15;
         sin_addr at 4 range 0 .. 31;
         sin_zero at 8 range 0 .. 63;
      end record;
      pragma Convention (C_Pass_By_Copy, struct_sockaddr_in);
      for struct_sockaddr_in'Alignment use ALIGNMENT;
      pragma Warnings (Off);
      --  There may be holes in the record, due to
      --  components not defined by POSIX standard.
      for struct_sockaddr_in'Size use 128;
      pragma Warnings (On);
      type sockaddr_in_ptr is access constant struct_sockaddr_in;
      pragma Convention (C, sockaddr_in_ptr);
      type sockaddr_in_var_ptr is access all struct_sockaddr_in;
      pragma Convention (C, sockaddr_in_var_ptr);

      --  IP Level ip_opts structure  --
      type struct_ip_opts is record
         ip_dst : struct_in_addr;
         ip_opts : POSIX.Octet_Array (1 .. 40);
      end record;
      for struct_ip_opts use record
         ip_dst at 0 range 0 .. 31;
         ip_opts at 4 range 0 .. 319;
      end record;
      pragma Convention (C_Pass_By_Copy, struct_ip_opts);
      for struct_ip_opts'Alignment use ALIGNMENT;
      pragma Warnings (Off);
      --  There may be holes in the record, due to
      --  components not defined by POSIX standard.
      for struct_ip_opts'Size use 352;
      pragma Warnings (On);
      type ip_opts_ptr is access constant struct_ip_opts;
      pragma Convention (C, ip_opts_ptr);
      type ip_opts_var_ptr is access all struct_ip_opts;
      pragma Convention (C, ip_opts_var_ptr);

      --------------------------------
      --  link names for functions  --
      --------------------------------
      HAVE_accept : constant Boolean := True;
      accept_LINKNAME : constant String := "accept";
      HAVE_bind : constant Boolean := True;
      bind_LINKNAME : constant String := "bind";
      HAVE_connect : constant Boolean := True;
      connect_LINKNAME : constant String := "connect";
      HAVE_getsockname : constant Boolean := True;
      getsockname_LINKNAME : constant String := "getsockname";
      HAVE_getsockopt : constant Boolean := True;
      getsockopt_LINKNAME : constant String := "getsockopt";
      HAVE_isfdtype : constant Boolean := True;
      isfdtype_LINKNAME : constant String := "isfdtype";
      HAVE_listen : constant Boolean := True;
      listen_LINKNAME : constant String := "listen";
      HAVE_recv : constant Boolean := True;
      recv_LINKNAME : constant String := "recv";
      HAVE_recvfrom : constant Boolean := True;
      recvfrom_LINKNAME : constant String := "recvfrom";
      HAVE_recvmsg : constant Boolean := True;
      recvmsg_LINKNAME : constant String := "recvmsg";
      HAVE_send : constant Boolean := True;
      send_LINKNAME : constant String := "send";
      HAVE_sendto : constant Boolean := True;
      sendto_LINKNAME : constant String := "sendto";
      HAVE_sendmsg : constant Boolean := True;
      sendmsg_LINKNAME : constant String := "sendmsg";
      HAVE_setsockopt : constant Boolean := True;
      setsockopt_LINKNAME : constant String := "setsockopt";
      HAVE_shutdown : constant Boolean := True;
      shutdown_LINKNAME : constant String := "shutdown";
      HAVE_socket : constant Boolean := True;
      socket_LINKNAME : constant String := "socket";
      HAVE_sockatmark : constant Boolean := True;
      sockatmark_LINKNAME : constant String := "sockatmark";
      HAVE_socketpair : constant Boolean := True;
      socketpair_LINKNAME : constant String := "socketpair";

   end Sockets;

   package XTI is

      ----------------------
      --  XTI structures  --
      ----------------------

      --  netbuf structure  --
      --  *** MISSING: netbuf ***  --
      type struct_netbuf is record
         maxlen : unsigned_int;
         len : unsigned_int;
         buf : char_ptr;
      end record;
      for struct_netbuf use record
         maxlen at 0 range 0 .. 31;
         len at 4 range 0 .. 31;
         buf at 8 range 0 .. 31;
      end record;
      pragma Convention (C_Pass_By_Copy, struct_netbuf);
      for struct_netbuf'Alignment use ALIGNMENT;
      pragma Warnings (Off);
      --  There may be holes in the record, due to
      --  components not defined by POSIX standard.
      for struct_netbuf'Size use 96;
      pragma Warnings (On);
      type netbuf_ptr is access constant struct_netbuf;
      pragma Convention (C, netbuf_ptr);
      type netbuf_var_ptr is access all struct_netbuf;
      pragma Convention (C, netbuf_var_ptr);

      --  t_info structure  --
      --  *** MISSING: t_info ***  --
      type struct_t_info is record
         addr : long;
         options : long;
         tsdu : long;
         etsdu : long;
         connect : long;
         discon : long;
         servtype : long;
         flags : long;
      end record;
      for struct_t_info use record
         addr at 0 range 0 .. 31;
         options at 4 range 0 .. 31;
         tsdu at 8 range 0 .. 31;
         etsdu at 12 range 0 .. 31;
         connect at 16 range 0 .. 31;
         discon at 20 range 0 .. 31;
         servtype at 24 range 0 .. 31;
         flags at 28 range 0 .. 31;
      end record;
      pragma Convention (C_Pass_By_Copy, struct_t_info);
      for struct_t_info'Alignment use ALIGNMENT;
      pragma Warnings (Off);
      --  There may be holes in the record, due to
      --  components not defined by POSIX standard.
      for struct_t_info'Size use 256;
      pragma Warnings (On);
      type t_info_ptr is access constant struct_t_info;
      pragma Convention (C, t_info_ptr);
      type t_info_var_ptr is access all struct_t_info;
      pragma Convention (C, t_info_var_ptr);

      --  t_opthdr structure  --
      --  *** MISSING: t_opthdr ***  --
      type struct_t_opthdr is record
         len : unsigned_long;
         level : unsigned_long;
         name : unsigned_long;
         status : unsigned_long;
      end record;
      for struct_t_opthdr use record
         len at 0 range 0 .. 31;
         level at 4 range 0 .. 31;
         name at 8 range 0 .. 31;
         status at 12 range 0 .. 31;
      end record;
      pragma Convention (C_Pass_By_Copy, struct_t_opthdr);
      for struct_t_opthdr'Alignment use ALIGNMENT;
      pragma Warnings (Off);
      --  There may be holes in the record, due to
      --  components not defined by POSIX standard.
      for struct_t_opthdr'Size use 128;
      pragma Warnings (On);
      type t_opthdr_ptr is access constant struct_t_opthdr;
      pragma Convention (C, t_opthdr_ptr);
      type t_opthdr_var_ptr is access all struct_t_opthdr;
      pragma Convention (C, t_opthdr_var_ptr);

      --  t_bind structure  --
      --  *** MISSING: t_bind ***  --
      type struct_t_bind is record
         addr : struct_netbuf;
         qlen : unsigned;
      end record;
      for struct_t_bind use record
         addr at 0 range 0 .. 95;
         qlen at 12 range 0 .. 31;
      end record;
      pragma Convention (C_Pass_By_Copy, struct_t_bind);
      for struct_t_bind'Alignment use ALIGNMENT;
      pragma Warnings (Off);
      --  There may be holes in the record, due to
      --  components not defined by POSIX standard.
      for struct_t_bind'Size use 128;
      pragma Warnings (On);
      type t_bind_ptr is access constant struct_t_bind;
      pragma Convention (C, t_bind_ptr);
      type t_bind_var_ptr is access all struct_t_bind;
      pragma Convention (C, t_bind_var_ptr);

      --  t_optmgmt structure  --
      --  *** MISSING: t_optmgmt ***  --
      type struct_t_optmgmt is record
         opt : struct_netbuf;
         flags : long;
      end record;
      for struct_t_optmgmt use record
         opt at 0 range 0 .. 95;
         flags at 12 range 0 .. 31;
      end record;
      pragma Convention (C_Pass_By_Copy, struct_t_optmgmt);
      for struct_t_optmgmt'Alignment use ALIGNMENT;
      pragma Warnings (Off);
      --  There may be holes in the record, due to
      --  components not defined by POSIX standard.
      for struct_t_optmgmt'Size use 128;
      pragma Warnings (On);
      type t_optmgmt_ptr is access constant struct_t_optmgmt;
      pragma Convention (C, t_optmgmt_ptr);
      type t_optmgmt_var_ptr is access all struct_t_optmgmt;
      pragma Convention (C, t_optmgmt_var_ptr);

      --  t_discon structure  --
      --  *** MISSING: t_discon ***  --
      type struct_t_discon is record
         udata : struct_netbuf;
         reason : int;
         sequence : int;
      end record;
      for struct_t_discon use record
         udata at 0 range 0 .. 95;
         reason at 12 range 0 .. 31;
         sequence at 16 range 0 .. 31;
      end record;
      pragma Convention (C_Pass_By_Copy, struct_t_discon);
      for struct_t_discon'Alignment use ALIGNMENT;
      pragma Warnings (Off);
      --  There may be holes in the record, due to
      --  components not defined by POSIX standard.
      for struct_t_discon'Size use 160;
      pragma Warnings (On);
      type t_discon_ptr is access constant struct_t_discon;
      pragma Convention (C, t_discon_ptr);
      type t_discon_var_ptr is access all struct_t_discon;
      pragma Convention (C, t_discon_var_ptr);

      --  t_call structure  --
      --  *** MISSING: t_call ***  --
      type struct_t_call is record
         addr : struct_netbuf;
         opt : struct_netbuf;
         udata : struct_netbuf;
         sequence : int;
      end record;
      for struct_t_call use record
         addr at 0 range 0 .. 95;
         opt at 12 range 0 .. 95;
         udata at 24 range 0 .. 95;
         sequence at 36 range 0 .. 31;
      end record;
      pragma Convention (C_Pass_By_Copy, struct_t_call);
      for struct_t_call'Alignment use ALIGNMENT;
      pragma Warnings (Off);
      --  There may be holes in the record, due to
      --  components not defined by POSIX standard.
      for struct_t_call'Size use 320;
      pragma Warnings (On);
      type t_call_ptr is access constant struct_t_call;
      pragma Convention (C, t_call_ptr);
      type t_call_var_ptr is access all struct_t_call;
      pragma Convention (C, t_call_var_ptr);

      --  t_unitdata structure  --
      --  *** MISSING: t_unitdata ***  --
      type struct_t_unitdata is record
         addr : struct_netbuf;
         opt : struct_netbuf;
         udata : struct_netbuf;
      end record;
      for struct_t_unitdata use record
         addr at 0 range 0 .. 95;
         opt at 12 range 0 .. 95;
         udata at 24 range 0 .. 95;
      end record;
      pragma Convention (C_Pass_By_Copy, struct_t_unitdata);
      for struct_t_unitdata'Alignment use ALIGNMENT;
      pragma Warnings (Off);
      --  There may be holes in the record, due to
      --  components not defined by POSIX standard.
      for struct_t_unitdata'Size use 288;
      pragma Warnings (On);
      type t_unitdata_ptr is access constant struct_t_unitdata;
      pragma Convention (C, t_unitdata_ptr);
      type t_unitdata_var_ptr is access all struct_t_unitdata;
      pragma Convention (C, t_unitdata_var_ptr);

      --  t_uderr structure  --
      --  *** MISSING: t_uderr ***  --
      type struct_t_uderr is record
         addr : struct_netbuf;
         opt : struct_netbuf;
         error : long;
      end record;
      for struct_t_uderr use record
         addr at 0 range 0 .. 95;
         opt at 12 range 0 .. 95;
         error at 24 range 0 .. 31;
      end record;
      pragma Convention (C_Pass_By_Copy, struct_t_uderr);
      for struct_t_uderr'Alignment use ALIGNMENT;
      pragma Warnings (Off);
      --  There may be holes in the record, due to
      --  components not defined by POSIX standard.
      for struct_t_uderr'Size use 224;
      pragma Warnings (On);
      type t_uderr_ptr is access constant struct_t_uderr;
      pragma Convention (C, t_uderr_ptr);
      type t_uderr_var_ptr is access all struct_t_uderr;
      pragma Convention (C, t_uderr_var_ptr);

      --  t_iovec structure  --
      --  *** MISSING: t_iovec ***  --
      type struct_t_iovec is record
         iov_base : char_ptr;
         iov_len : unsigned_int;
      end record;
      for struct_t_iovec use record
         iov_base at 0 range 0 .. 31;
         iov_len at 4 range 0 .. 31;
      end record;
      pragma Convention (C_Pass_By_Copy, struct_t_iovec);
      for struct_t_iovec'Alignment use ALIGNMENT;
      pragma Warnings (Off);
      --  There may be holes in the record, due to
      --  components not defined by POSIX standard.
      for struct_t_iovec'Size use 64;
      pragma Warnings (On);
      type t_iovec_ptr is access constant struct_t_iovec;
      pragma Convention (C, t_iovec_ptr);
      type t_iovec_var_ptr is access all struct_t_iovec;
      pragma Convention (C, t_iovec_var_ptr);

      --  t_kpalive structure  --
      --  *** MISSING: t_kpalive ***  --
      type struct_t_kpalive is record
         kp_onoff : long;
         kp_timeout : long;
      end record;
      for struct_t_kpalive use record
         kp_onoff at 0 range 0 .. 31;
         kp_timeout at 4 range 0 .. 31;
      end record;
      pragma Convention (C_Pass_By_Copy, struct_t_kpalive);
      for struct_t_kpalive'Alignment use ALIGNMENT;
      pragma Warnings (Off);
      --  There may be holes in the record, due to
      --  components not defined by POSIX standard.
      for struct_t_kpalive'Size use 64;
      pragma Warnings (On);
      type t_kpalive_ptr is access constant struct_t_kpalive;
      pragma Convention (C, t_kpalive_ptr);
      type t_kpalive_var_ptr is access all struct_t_kpalive;
      pragma Convention (C, t_kpalive_var_ptr);

      --  The following are the events returned from t_look()  --
      --  *** MISSING: T_LISTEN ***  --
      T_LISTEN : constant := 0;
      --  *** MISSING: T_CONNECT ***  --
      T_CONNECT : constant := 0;
      --  *** MISSING: T_DATA ***  --
      T_DATA : constant := 0;
      --  *** MISSING: T_EXDATA ***  --
      T_EXDATA : constant := 0;
      --  *** MISSING: T_DISCONNECT ***  --
      T_DISCONNECT : constant := 0;
      --  *** MISSING: T_UDERR ***  --
      T_UDERR : constant := 0;
      --  *** MISSING: T_ORDREL ***  --
      T_ORDREL : constant := 0;
      --  *** MISSING: T_GODATA ***  --
      T_GODATA : constant := 0;
      --  *** MISSING: T_GOEXDATA ***  --
      T_GOEXDATA : constant := 0;
      --  *** MISSING: T_EVENTS ***  --
      T_EVENTS : constant := 0;
      --  *** MISSING: T_MORE ***  --
      T_MORE : constant := 0;
      --  *** MISSING: T_EXPEDITED ***  --
      T_EXPEDITED : constant := 0;
      --  *** MISSING: T_PUSH ***  --
      T_PUSH : constant := 0;
      --  *** MISSING: T_NEGOTIATE ***  --
      T_NEGOTIATE : constant := 0;
      --  *** MISSING: T_CHECK ***  --
      T_CHECK : constant := 0;
      --  *** MISSING: T_DEFAULT ***  --
      T_DEFAULT : constant := 0;
      --  *** MISSING: T_SUCCESS ***  --
      T_SUCCESS : constant := 0;
      --  *** MISSING: T_FAILURE ***  --
      T_FAILURE : constant := 0;
      --  *** MISSING: T_CURRENT ***  --
      T_CURRENT : constant := 0;
      --  *** MISSING: T_PARTSUCCESS ***  --
      T_PARTSUCCESS : constant := 0;
      --  *** MISSING: T_READONLY ***  --
      T_READONLY : constant := 0;
      --  *** MISSING: T_NOTSUPPORT ***  --
      T_NOTSUPPORT : constant := 0;
      --  *** MISSING: T_RAW ***  --
      T_RAW : constant := 0;

      --  Service types defines  --
      --  *** MISSING: T_COTS ***  --
      T_COTS : constant := 0;
      --  *** MISSING: T_COTS_ORD ***  --
      T_COTS_ORD : constant := 0;
      --  *** MISSING: T_CLTS ***  --
      T_CLTS : constant := 0;
      --  *** MISSING: T_SENDZERO ***  --
      T_SENDZERO : constant := 0;
      --  *** MISSING: SENDZERO ***  --
      SENDZERO : constant := 0;
      --  *** MISSING: T_XPG4_1 ***  --
      T_XPG4_1 : constant := 0;
      --  *** MISSING: XPG4_1 ***  --
      XPG4_1 : constant := 0;
      --  *** MISSING: T_BIND ***  --
      T_BIND : constant := 0;
      --  *** MISSING: T_OPTMGMT ***  --
      T_OPTMGMT : constant := 0;
      --  *** MISSING: T_CALL ***  --
      T_CALL : constant := 0;
      --  *** MISSING: T_DIS ***  --
      T_DIS : constant := 0;
      --  *** MISSING: T_UNITDATA ***  --
      T_UNITDATA : constant := 0;
      --  *** MISSING: T_UDERROR ***  --
      T_UDERROR : constant := 0;
      --  *** MISSING: T_INFO ***  --
      T_INFO : constant := 0;
      --  *** MISSING: T_KUNITDATA ***  --
      T_KUNITDATA : constant := 0;
      --  *** MISSING: T_ADDR ***  --
      T_ADDR : constant := 0;
      --  *** MISSING: T_OPT ***  --
      T_OPT : constant := 0;
      --  *** MISSING: T_UDATA ***  --
      T_UDATA : constant := 0;
      --  *** MISSING: T_ALL ***  --
      T_ALL : constant := 0;
      --  *** MISSING: T_UNINIT ***  --
      T_UNINIT : constant := 0;
      --  *** MISSING: T_UNBND ***  --
      T_UNBND : constant := 0;
      --  *** MISSING: T_IDLE ***  --
      T_IDLE : constant := 0;
      --  *** MISSING: T_OUTCON ***  --
      T_OUTCON : constant := 0;
      --  *** MISSING: T_INCON ***  --
      T_INCON : constant := 0;
      --  *** MISSING: T_DATAXFER ***  --
      T_DATAXFER : constant := 0;
      --  *** MISSING: T_OUTREL ***  --
      T_OUTREL : constant := 0;
      --  *** MISSING: T_INREL ***  --
      T_INREL : constant := 0;
      --  *** MISSING: T_YES ***  --
      T_YES : constant := 0;
      --  *** MISSING: T_NO ***  --
      T_NO : constant := 0;
      --  *** MISSING: T_UNUSED ***  --
      T_UNUSED : constant := 0;
      --  *** MISSING: T_NULL ***  --
      T_NULL : constant := 0;
      --  *** MISSING: T_ABSREQ ***  --
      T_ABSREQ : constant := 0;
      --  *** MISSING: T_INFINITE ***  --
      T_INFINITE : constant := 0;
      --  *** MISSING: T_INVALID ***  --
      T_INVALID : constant := 0;

      --  XTI-level Options  --
      --  *** MISSING: XTI_GENERIC ***  --
      XTI_GENERIC : constant := 0;
      --  *** MISSING: XTI_DEBUG ***  --
      XTI_DEBUG : constant := 0;
      --  *** MISSING: XTI_LINGER ***  --
      XTI_LINGER : constant := 0;
      --  *** MISSING: XTI_RCVBUF ***  --
      XTI_RCVBUF : constant := 0;
      --  *** MISSING: XTI_RCVLOWAT ***  --
      XTI_RCVLOWAT : constant := 0;
      --  *** MISSING: XTI_SNDBUF ***  --
      XTI_SNDBUF : constant := 0;
      --  *** MISSING: XTI_SNDLOWAT ***  --
      XTI_SNDLOWAT : constant := 0;

      --  t_linger structure  --
      --  *** MISSING: t_linger ***  --
      type struct_t_linger is record
         l_onoff : long;
         l_linger : long;
      end record;
      for struct_t_linger use record
         l_onoff at 0 range 0 .. 31;
         l_linger at 4 range 0 .. 31;
      end record;
      pragma Convention (C_Pass_By_Copy, struct_t_linger);
      for struct_t_linger'Alignment use ALIGNMENT;
      pragma Warnings (Off);
      --  There may be holes in the record, due to
      --  components not defined by POSIX standard.
      for struct_t_linger'Size use 64;
      pragma Warnings (On);
      type t_linger_ptr is access constant struct_t_linger;
      pragma Convention (C, t_linger_ptr);
      type t_linger_var_ptr is access all struct_t_linger;
      pragma Convention (C, t_linger_var_ptr);

      --  General definitions for option management  --
      --  *** MISSING: T_UNSPEC ***  --
      T_UNSPEC : constant := 0;
      --  *** MISSING: T_ALLOPT ***  --
      T_ALLOPT : constant := 0;
      function c_T_ALIGN (p : char_ptr) return int;
      pragma Import (C, c_T_ALIGN, "c_T_ALIGN");

      --  TCP Level and Options  --
      --  *** MISSING: INET_TCP ***  --
      INET_TCP : constant := 0;
      TCP_NODELAY : constant := 1;
      TCP_MAXSEG : constant := 2;
      --  *** MISSING: TCP_KEEPALIVE ***  --
      TCP_KEEPALIVE : constant := 0;
      --  *** MISSING: T_GARBAGE ***  --
      T_GARBAGE : constant := 0;

      --  UDP Level and Options  --
      --  *** MISSING: INET_UDP ***  --
      INET_UDP : constant := 0;
      --  *** MISSING: UDP_CHECKSUM ***  --
      UDP_CHECKSUM : constant := 0;

      --  IP Level and Options  --
      --  *** MISSING: INET_IP ***  --
      INET_IP : constant := 0;
      IP_OPTIONS : constant := 4;
      IP_TOS : constant := 1;
      IP_TTL : constant := 2;
      --  *** MISSING: IP_REUSEADDR ***  --
      IP_REUSEADDR : constant := 0;
      --  *** MISSING: IP_DONTROUTE ***  --
      IP_DONTROUTE : constant := 0;
      --  *** MISSING: IP_BROADCAST ***  --
      IP_BROADCAST : constant := 0;

      --  IP_TOS precedence levels  --
      --  *** MISSING: T_ROUTINE ***  --
      T_ROUTINE : constant := 0;
      --  *** MISSING: T_PRIORITY ***  --
      T_PRIORITY : constant := 0;
      --  *** MISSING: T_IMMEDIATE ***  --
      T_IMMEDIATE : constant := 0;
      --  *** MISSING: T_FLASH ***  --
      T_FLASH : constant := 0;
      --  *** MISSING: T_OVERRIDEFLASH ***  --
      T_OVERRIDEFLASH : constant := 0;
      --  *** MISSING: T_CRITIC_ECP ***  --
      T_CRITIC_ECP : constant := 0;
      --  *** MISSING: T_INETCONTROL ***  --
      T_INETCONTROL : constant := 0;
      --  *** MISSING: T_NETCONTROL ***  --
      T_NETCONTROL : constant := 0;

      --  IP_TOS type of service  --
      --  *** MISSING: T_NOTOS ***  --
      T_NOTOS : constant := 0;
      --  *** MISSING: T_LDELAY ***  --
      T_LDELAY : constant := 0;
      --  *** MISSING: T_HITHRPT ***  --
      T_HITHRPT : constant := 0;
      --  *** MISSING: T_HIREL ***  --
      T_HIREL : constant := 0;

      --------------------------------
      --  link names for functions  --
      --------------------------------
      --  *** MISSING: function t_accept ***  --
      HAVE_t_accept : constant Boolean := False;
      t_accept_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_alloc ***  --
      HAVE_t_alloc : constant Boolean := False;
      t_alloc_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_bind ***  --
      HAVE_t_bind : constant Boolean := False;
      t_bind_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_blocking ***  --
      HAVE_t_blocking : constant Boolean := False;
      t_blocking_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_close ***  --
      HAVE_t_close : constant Boolean := False;
      t_close_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_connect ***  --
      HAVE_t_connect : constant Boolean := False;
      t_connect_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_error ***  --
      HAVE_t_error : constant Boolean := False;
      t_error_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_free ***  --
      HAVE_t_free : constant Boolean := False;
      t_free_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_getinfo ***  --
      HAVE_t_getinfo : constant Boolean := False;
      t_getinfo_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_getprotaddr ***  --
      HAVE_t_getprotaddr : constant Boolean := False;
      t_getprotaddr_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_getstate ***  --
      HAVE_t_getstate : constant Boolean := False;
      t_getstate_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_listen ***  --
      HAVE_t_listen : constant Boolean := False;
      t_listen_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_look ***  --
      HAVE_t_look : constant Boolean := False;
      t_look_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_nonblocking ***  --
      HAVE_t_nonblocking : constant Boolean := False;
      t_nonblocking_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_open ***  --
      HAVE_t_open : constant Boolean := False;
      t_open_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_optmgmt ***  --
      HAVE_t_optmgmt : constant Boolean := False;
      t_optmgmt_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_rcv ***  --
      HAVE_t_rcv : constant Boolean := False;
      t_rcv_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_rcvconnect ***  --
      HAVE_t_rcvconnect : constant Boolean := False;
      t_rcvconnect_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_rcvdis ***  --
      HAVE_t_rcvdis : constant Boolean := False;
      t_rcvdis_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_rcvrel ***  --
      HAVE_t_rcvrel : constant Boolean := False;
      t_rcvrel_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_rcvreldata ***  --
      HAVE_t_rcvreldata : constant Boolean := False;
      t_rcvreldata_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_rcvudata ***  --
      HAVE_t_rcvudata : constant Boolean := False;
      t_rcvudata_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_rcvuderr ***  --
      HAVE_t_rcvuderr : constant Boolean := False;
      t_rcvuderr_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_rcvv ***  --
      HAVE_t_rcvv : constant Boolean := False;
      t_rcvv_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_rcvvudata ***  --
      HAVE_t_rcvvudata : constant Boolean := False;
      t_rcvvudata_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_snd ***  --
      HAVE_t_snd : constant Boolean := False;
      t_snd_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_snddis ***  --
      HAVE_t_snddis : constant Boolean := False;
      t_snddis_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_sndudata ***  --
      HAVE_t_sndudata : constant Boolean := False;
      t_sndudata_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_sndrel ***  --
      HAVE_t_sndrel : constant Boolean := False;
      t_sndrel_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_sndreldata ***  --
      HAVE_t_sndreldata : constant Boolean := False;
      t_sndreldata_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_sndv ***  --
      HAVE_t_sndv : constant Boolean := False;
      t_sndv_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_sndvudata ***  --
      HAVE_t_sndvudata : constant Boolean := False;
      t_sndvudata_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_strerror ***  --
      HAVE_t_strerror : constant Boolean := False;
      t_strerror_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_sync ***  --
      HAVE_t_sync : constant Boolean := False;
      t_sync_LINKNAME : constant String := "nosys_neg_one";
      --  *** MISSING: function t_unbind ***  --
      HAVE_t_unbind : constant Boolean := False;
      t_unbind_LINKNAME : constant String := "nosys_neg_one";

   end XTI;
   package Netinet is

      -------------------------
      --  From netinet/in.h  --
      -------------------------
      IPPROTO_IP : constant := 0;
      IPPROTO_ICMP : constant := 1;
      IPPROTO_TCP : constant := 6;
      IPPROTO_UDP : constant := 17;
      IPPROTO_RAW : constant := 255;
      IP_OPTIONS : constant := 4;
      IP_HDRINCL : constant := 3;
      IP_TOS : constant := 1;
      IP_TTL : constant := 2;
      --  *** MISSING: IP_RECVDSTADDR ***  --
      IP_RECVDSTADDR : constant := 0;
      INADDR_NONE : constant := 4294967295;
      INADDR_ANY : constant := 0;
      INADDR_BROADCAST : constant := 4294967295;
      INADDR_LOOPBACK : constant := 2130706433;
      INADDR_UNSPEC_GROUP : constant := 3758096384;
      INADDR_ALLHOSTS_GROUP : constant := 3758096385;
      INADDR_MAX_LOCAL_GROUP : constant := 3758096639;
      HAVE_inet_addr : constant Boolean := True;
      inet_addr_LINKNAME : constant String := "inet_addr";
      HAVE_inet_makeaddr : constant Boolean := True;
      inet_makeaddr_LINKNAME : constant String := "inet_makeaddr";
      HAVE_inet_network : constant Boolean := True;
      inet_network_LINKNAME : constant String := "inet_network";
      HAVE_inet_lnaof : constant Boolean := True;
      inet_lnaof_LINKNAME : constant String := "inet_lnaof";
      HAVE_inet_netof : constant Boolean := True;
      inet_netof_LINKNAME : constant String := "inet_netof";
      HAVE_inet_ntoa : constant Boolean := True;
      inet_ntoa_LINKNAME : constant String := "inet_ntoa";

      --------------------------
      --  From netinet/tcp.h  --
      --------------------------
      TCP_NODELAY : constant := 1;
      TCP_MAXSEG : constant := 2;
      --  *** MISSING: TCP_KEEPALIVE ***  --
      TCP_KEEPALIVE : constant := 0;
      --  *** MISSING: TCP_MAXRXT ***  --
      TCP_MAXRXT : constant := 0;
      --  *** MISSING: TCP_STDURG ***  --
      TCP_STDURG : constant := 0;

      -------------------------
      --  From netinet/ip.h  --
      -------------------------
      IPTOS_LOWDELAY : constant := 16;
      IPTOS_THROUGHPUT : constant := 8;
      IPTOS_RELIABILITY : constant := 4;

   end Netinet;
   package NetDB is
      use Sockets;
      type struct_netent is record
         n_name : char_ptr;
         n_aliases : char_ptr_ptr;
         n_addrtype : int;
         n_net : in_addr_t;
      end record;
      for struct_netent use record
         n_name at 0 range 0 .. 31;
         n_aliases at 4 range 0 .. 31;
         n_addrtype at 8 range 0 .. 31;
         n_net at 12 range 0 .. 31;
      end record;
      pragma Convention (C_Pass_By_Copy, struct_netent);
      for struct_netent'Alignment use ALIGNMENT;
      pragma Warnings (Off);
      --  There may be holes in the record, due to
      --  components not defined by POSIX standard.
      for struct_netent'Size use 128;
      pragma Warnings (On);
      type netent_ptr is access constant struct_netent;
      pragma Convention (C, netent_ptr);
      type netent_var_ptr is access all struct_netent;
      pragma Convention (C, netent_var_ptr);

      --  protocol database entry  --
      type struct_protoent is record
         p_name : char_ptr;
         p_aliases : char_ptr_ptr;
         p_proto : int;
      end record;
      for struct_protoent use record
         p_name at 0 range 0 .. 31;
         p_aliases at 4 range 0 .. 31;
         p_proto at 8 range 0 .. 31;
      end record;
      pragma Convention (C_Pass_By_Copy, struct_protoent);
      for struct_protoent'Alignment use ALIGNMENT;
      pragma Warnings (Off);
      --  There may be holes in the record, due to
      --  components not defined by POSIX standard.
      for struct_protoent'Size use 96;
      pragma Warnings (On);
      type protoent_ptr is access constant struct_protoent;
      pragma Convention (C, protoent_ptr);
      type protoent_var_ptr is access all struct_protoent;
      pragma Convention (C, protoent_var_ptr);

      --  local socket address  --
      HAVE_endhostent : constant Boolean := True;
      endhostent_LINKNAME : constant String := "endhostent";
      HAVE_endnetent : constant Boolean := True;
      endnetent_LINKNAME : constant String := "endnetent";
      HAVE_endprotoent : constant Boolean := True;
      endprotoent_LINKNAME : constant String := "endprotoent";
      HAVE_endservent : constant Boolean := True;
      endservent_LINKNAME : constant String := "endservent";
      HAVE_getaddrinfo : constant Boolean := True;
      getaddrinfo_LINKNAME : constant String := "getaddrinfo";
      HAVE_freeaddrinfo : constant Boolean := True;
      freeaddrinfo_LINKNAME : constant String := "freeaddrinfo";
      HAVE_getnameinfo : constant Boolean := True;
      getnameinfo_LINKNAME : constant String := "getnameinfo";
      HAVE_gethostbyaddr : constant Boolean := True;
      gethostbyaddr_LINKNAME : constant String := "gethostbyaddr";
      HAVE_gethostbyaddr_r : constant Boolean := True;
      gethostbyaddr_r_LINKNAME : constant String := "gethostbyaddr_r";
      HAVE_gethostbyname : constant Boolean := True;
      gethostbyname_LINKNAME : constant String := "gethostbyname";
      HAVE_gethostbyname_r : constant Boolean := True;
      gethostbyname_r_LINKNAME : constant String := "gethostbyname_r";
      HAVE_gethostname : constant Boolean := True;
      gethostname_LINKNAME : constant String := "gethostname";
      HAVE_getnetbyaddr : constant Boolean := True;
      getnetbyaddr_LINKNAME : constant String := "getnetbyaddr";
      HAVE_getnetbyaddr_r : constant Boolean := True;
      getnetbyaddr_r_LINKNAME : constant String := "getnetbyaddr_r";
      HAVE_getnetbyname : constant Boolean := True;
      getnetbyname_LINKNAME : constant String := "getnetbyname";
      HAVE_getnetbyname_r : constant Boolean := True;
      getnetbyname_r_LINKNAME : constant String := "getnetbyname_r";
      HAVE_getpeername : constant Boolean := True;
      getpeername_LINKNAME : constant String := "getpeername";
      HAVE_getprotobyname : constant Boolean := True;
      getprotobyname_LINKNAME : constant String := "getprotobyname";
      HAVE_getprotobyname_r : constant Boolean := True;
      getprotobyname_r_LINKNAME : constant String := "getprotobyname_r";
      HAVE_getprotobynumber : constant Boolean := True;
      getprotobynumber_LINKNAME : constant String := "getprotobynumber";
      HAVE_getprotobynumber_r : constant Boolean := True;
      getprotobynumber_r_LINKNAME : constant String := "getprotobynumber_r";
      HAVE_getservbyname : constant Boolean := True;
      getservbyname_LINKNAME : constant String := "getservbyname";
      HAVE_getservbyname_r : constant Boolean := True;
      getservbyname_r_LINKNAME : constant String := "getservbyname_r";
      HAVE_getservbyport : constant Boolean := True;
      getservbyport_LINKNAME : constant String := "getservbyport";
      HAVE_getservbyport_r : constant Boolean := True;
      getservbyport_r_LINKNAME : constant String := "getservbyport_r";
      HAVE_sethostent : constant Boolean := True;
      sethostent_LINKNAME : constant String := "sethostent";
      HAVE_setnetent : constant Boolean := True;
      setnetent_LINKNAME : constant String := "setnetent";
      HAVE_setprotoent : constant Boolean := True;
      setprotoent_LINKNAME : constant String := "setprotoent";
      HAVE_setservent : constant Boolean := True;
      setservent_LINKNAME : constant String := "setservent";

   end NetDB;

   --  pollfd structure  --
   type struct_pollfd is record
      fd : int;
      events : short;
      revents : short;
   end record;
   for struct_pollfd use record
      fd at 0 range 0 .. 31;
      events at 4 range 0 .. 15;
      revents at 6 range 0 .. 15;
   end record;
   pragma Convention (C_Pass_By_Copy, struct_pollfd);
   for struct_pollfd'Alignment use ALIGNMENT;
   pragma Warnings (Off);
   --  There may be holes in the record, due to
   --  components not defined by POSIX standard.
   for struct_pollfd'Size use 64;
   pragma Warnings (On);
   type pollfd_ptr is access constant struct_pollfd;
   pragma Convention (C, pollfd_ptr);
   type pollfd_var_ptr is access all struct_pollfd;
   pragma Convention (C, pollfd_var_ptr);
   type fd_mask_array is array (Integer range <>) of unsigned_int;

   --  fd_set structure  --
   type fd_set is
     array (1 .. 32) of int;
   for fd_set'Alignment use ALIGNMENT;
   for fd_set'Size use 1024;
   type fd_set_ptr is access constant fd_set;
   pragma Convention (C, fd_set_ptr);
   type fd_set_var_ptr is access all fd_set;
   pragma Convention (C, fd_set_var_ptr);
   FD_SETSIZE : constant := 1024;
   --  *** MISSING: INFTIM ***  --
   INFTIM : constant := 0;
   POLLIN : constant := 1;
   POLLRDNORM : constant := 64;
   POLLRDBAND : constant := 128;
   POLLPRI : constant := 2;
   POLLWRNORM : constant := 256;
   POLLWRBAND : constant := 512;
   POLLERR : constant := 8;
   POLLNVAL : constant := 32;
   HAVE_poll : constant Boolean := True;
   poll_LINKNAME : constant String := "poll";
   HAVE_select : constant Boolean := True;
   select_LINKNAME : constant String := "select";

end POSIX.C;
