/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;

/**
 * Stores characters and character data sections.
 * There may be many instances of this object per Element.
 * It uses a <code>XmlCharArrayWriter</code> to hold character data.  The
 * <code>XmlReader</code> parse methods take <code>java.io.Writer</code>
 * instances as parameters.
 *
 * @see XmlCharArrayWriter
 * @version 1.0
 * @author Elias Ross
 */
public class CharacterData 
	implements Node
{
	private XmlCharArrayWriter writer;

	/**
	 * Constructs an empty character data string.
	 */
	public CharacterData()
	{
		writer = new XmlCharArrayWriter();
	}

	/**
	 * Returns the underlying <code>XmlCharArrayWriter</code> object.
	 */
	public XmlCharArrayWriter getWriter() {
		return writer;
	}

	/**
	 * Returns the value <code>TEXT_NODE</code>.
	 */
	public short getNodeType() {
		return TEXT_NODE;
	}

	/**
	 * Returns the data as a newly constructed <code>String</code>.  
	 * Does not escape punctuation, such as the &amp; or &lt; symbols.
	 *
	 * @see #toString
	 */
	public String getData() {
		return writer.toString();
	}

	/**
	 * Returns a string representation of this Object.  Also,
	 * escapes characters not allowed in <code>CharData</code>.
	 * @return this object's data as a escaped XML string
	 */
	public String toString() {
		StringBuffer sb = new StringBuffer(writer.size() + 8);
		getWriter().writeEscapedTo(sb);
		return sb.toString();
	}
}

