#include "vtkKWMenu.h"
#include "vtkKWMenuButton.h"
#include "vtkKWMenuButtonWithSpinButtons.h"
#include "vtkKWMenuButtonWithLabel.h"
#include "vtkKWApplication.h"
#include "vtkKWWindow.h"

#include "vtkKWWidgetsTourExample.h"
#include <vtksys/stl/string>

class vtkKWMenuButtonItem : public KWWidgetsTourItem
{
public:
  virtual int GetType();
  virtual void Create(vtkKWWidget *parent, vtkKWWindow *);
};

void vtkKWMenuButtonItem::Create(vtkKWWidget *parent, vtkKWWindow *)
{
  vtkKWApplication *app = parent->GetApplication();

  size_t i;
  const char* days[] = 
    {"Monday", "Tuesday", "Wednesday", "Thursday", "Friday"};
  const char* days_fr[] = 
    {"Lundi", "Mardi", "Mercredi", "Jeudi", "Vendredi"};

  // -----------------------------------------------------------------------

  // Create a menu button
  // Add some entries

  vtkKWMenuButton *menubutton1 = vtkKWMenuButton::New();
  menubutton1->SetParent(parent);
  menubutton1->Create();
  menubutton1->SetBalloonHelpString("A simple menu button");

  for (i = 0; i < sizeof(days) / sizeof(days[0]); i++)
    {
    menubutton1->GetMenu()->AddRadioButton(days[i]);
    }

  app->Script(
    "pack %s -side top -anchor nw -expand n -padx 2 -pady 2", 
    menubutton1->GetWidgetName());

  // -----------------------------------------------------------------------

  // Create a menu button with spin buttons

  vtkKWMenuButtonWithSpinButtons *menubutton1b = vtkKWMenuButtonWithSpinButtons::New();
  menubutton1b->SetParent(parent);
  menubutton1b->Create();
  menubutton1b->GetWidget()->SetWidth(30);
  menubutton1b->GetWidget()->SetAdjustLabelWidthToWidgetSize(1);
  menubutton1b->SetBalloonHelpString(
    "This is a vtkKWMenuButtonWithSpinButtons, i.e. a menu button associated "
    "to a set of spin buttons (vtkKWSpinButtons) that can be used to "
    "increment and decrement the value");

  for (i = 0; i < sizeof(days) / sizeof(days[0]); i++)
    {
    vtksys_stl::string label(days[i]);
    label = label + " (" + days_fr[i] + ")";
    vtksys_stl::string command("SetValue {");
    command = command + label + "}";
    menubutton1b->GetWidget()->GetMenu()->AddCommand(
      label.c_str(), menubutton1b->GetWidget(), command.c_str());
    }

  app->Script(
    "pack %s -side top -anchor nw -expand n -padx 2 -pady 6", 
    menubutton1b->GetWidgetName());

  // -----------------------------------------------------------------------

  // Create another menu button, this time with a label

  vtkKWMenuButtonWithLabel *menubutton2 = vtkKWMenuButtonWithLabel::New();
  menubutton2->SetParent(parent);
  menubutton2->Create();
  menubutton2->SetBorderWidth(2);
  menubutton2->SetReliefToGroove();
  menubutton2->SetLabelText("Days:");
  menubutton2->SetPadX(2);
  menubutton2->SetPadY(2);
  menubutton2->GetWidget()->IndicatorVisibilityOff();
  menubutton2->GetWidget()->SetWidth(20);
  menubutton2->SetBalloonHelpString(
    "This is a vtkKWMenuButtonWithLabel, i.e. a menu button associated to a "
    "label that can be positioned around the menu button. The indicator is "
    "hidden, and the width is set explicitly");

  for (i = 0; i < sizeof(days) / sizeof(days[0]); i++)
    {
    menubutton2->GetWidget()->GetMenu()->AddRadioButton(days[i]);
    }

  menubutton2->GetWidget()->SetValue(days[0]);

  app->Script(
    "pack %s -side top -anchor nw -expand n -padx 2 -pady 6", 
    menubutton2->GetWidgetName());

  menubutton1->Delete();
  menubutton1b->Delete();
  menubutton2->Delete();

  // TODO: use callbacks
}

int vtkKWMenuButtonItem::GetType()
{
  return KWWidgetsTourItem::TypeCore;
}

KWWidgetsTourItem* vtkKWMenuButtonEntryPoint()
{
  return new vtkKWMenuButtonItem();
}
