/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "auth.h"

#include "user_policy.h"

using namespace Form;

bool UserPolicy::fieldEditable( State state, const QString &fieldName ) const
{
  if ( state == Delete )
    return false;

  if ( state == Modify ) {
    if ( fieldName == "kolabHomeServer" )
      return false;
    else if ( fieldName == "mail" )
      return false;

    if ( Auth::self()->group() == Auth::Users ) {
      if ( fieldName == "givenName" )
        return false;
      else if ( fieldName == "sn" )
        return false;
      else if ( fieldName == "uid" )
        return false;
      else if ( fieldName == "accttype" )
        return false;
      else if ( fieldName == "alias" )
        return false;
    }
  }

  return true;
}

bool UserPolicy::fieldVisible( State state, const QString &fieldName ) const
{
  if ( state == Modify ) {
    if ( Auth::self()->group() == Auth::Users ) {
      if ( fieldName == "cyrus-userquota" )
        return false;
    }
  }

  return true;
}

bool UserPolicy::containerEditable( State, const QString& ) const
{
  return true;
}
