/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "addressbook_description.h"

using namespace Form;

Description::Entry::List AddressBookDescription::entries() const
{
  Entry::List entries;

  {
    Entry entry;
    entry.setName( "givenName" );
    entry.setType( "non-empty-string" );
    entry.setLabel( QObject::tr( "First Name" ) );
    entry.setComment( QObject::tr( "Required" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "sn" );
    entry.setType( "non-empty-string" );
    entry.setLabel( QObject::tr( "Last Name" ) );
    entry.setComment( QObject::tr( "Required" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "title" );
    entry.setType( "string" );
    entry.setLabel( QObject::tr( "Title" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "mail" );
    entry.setType( "non-empty-string" );
    entry.setLabel( QObject::tr( "Primary Email Address" ) );
    entry.setComment( QObject::tr( "Required, non volatile" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "alias" );
    entry.setType( "alias" );
    entry.setLabel( QObject::tr( "Email Aliases" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "o" );
    entry.setType( "string" );
    entry.setLabel( QObject::tr( "Organisation" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "ou" );
    entry.setType( "string" );
    entry.setLabel( QObject::tr( "Organisational Unit" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "roomNumber" );
    entry.setType( "string" );
    entry.setLabel( QObject::tr( "Room Number" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "street" );
    entry.setType( "string" );
    entry.setLabel( QObject::tr( "Street Address" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "postOfficeBox" );
    entry.setType( "string" );
    entry.setLabel( QObject::tr( "Postbox" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "postalCode" );
    entry.setType( "string" );
    entry.setLabel( QObject::tr( "Postal Code" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "l" );
    entry.setType( "string" );
    entry.setLabel( QObject::tr( "City" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "c" );
    entry.setType( "string" );
    entry.setLabel( QObject::tr( "Country" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "telephoneNumber" );
    entry.setType( "string" );
    entry.setLabel( QObject::tr( "Telephone Number" ) );
    entries.append( entry );
  }

  {
    Entry entry;
    entry.setName( "facsimileTelephoneNumber" );
    entry.setType( "string" );
    entry.setLabel( QObject::tr( "Fax Number" ) );
    entries.append( entry );
  }

  return entries;
}
