
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2019 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQRectF.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QRectF>
#include <QMarginsF>
#include <QPointF>
#include <QRect>
#include <QSizeF>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include "gsiDeclQtCoreTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QRectF

//  Constructor QRectF::QRectF()


static void _init_ctor_QRectF_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QRectF> ();
}

static void _call_ctor_QRectF_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRectF *> (new QRectF ());
}


//  Constructor QRectF::QRectF(const QPointF &topleft, const QSizeF &size)


static void _init_ctor_QRectF_3753 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("topleft");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("size");
  decl->add_arg<const QSizeF & > (argspec_1);
  decl->set_return_new<QRectF> ();
}

static void _call_ctor_QRectF_3753 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  const QSizeF &arg2 = gsi::arg_reader<const QSizeF & >() (args, heap);
  ret.write<QRectF *> (new QRectF (arg1, arg2));
}


//  Constructor QRectF::QRectF(const QPointF &topleft, const QPointF &bottomRight)


static void _init_ctor_QRectF_3864 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("topleft");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("bottomRight");
  decl->add_arg<const QPointF & > (argspec_1);
  decl->set_return_new<QRectF> ();
}

static void _call_ctor_QRectF_3864 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  const QPointF &arg2 = gsi::arg_reader<const QPointF & >() (args, heap);
  ret.write<QRectF *> (new QRectF (arg1, arg2));
}


//  Constructor QRectF::QRectF(double left, double top, double width, double height)


static void _init_ctor_QRectF_3960 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("width");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("height");
  decl->add_arg<double > (argspec_3);
  decl->set_return_new<QRectF> ();
}

static void _call_ctor_QRectF_3960 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  ret.write<QRectF *> (new QRectF (arg1, arg2, arg3, arg4));
}


//  Constructor QRectF::QRectF(const QRect &rect)


static void _init_ctor_QRectF_1792 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return_new<QRectF> ();
}

static void _call_ctor_QRectF_1792 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  ret.write<QRectF *> (new QRectF (arg1));
}


// void QRectF::adjust(double x1, double y1, double x2, double y2)


static void _init_f_adjust_3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x1");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y1");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("x2");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("y2");
  decl->add_arg<double > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_adjust_3960 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->adjust (arg1, arg2, arg3, arg4);
}


// QRectF QRectF::adjusted(double x1, double y1, double x2, double y2)


static void _init_f_adjusted_c3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x1");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y1");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("x2");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("y2");
  decl->add_arg<double > (argspec_3);
  decl->set_return<QRectF > ();
}

static void _call_f_adjusted_c3960 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  ret.write<QRectF > ((QRectF)((QRectF *)cls)->adjusted (arg1, arg2, arg3, arg4));
}


// double QRectF::bottom()


static void _init_f_bottom_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_bottom_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QRectF *)cls)->bottom ());
}


// QPointF QRectF::bottomLeft()


static void _init_f_bottomLeft_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_bottomLeft_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPointF > ((QPointF)((QRectF *)cls)->bottomLeft ());
}


// QPointF QRectF::bottomRight()


static void _init_f_bottomRight_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_bottomRight_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPointF > ((QPointF)((QRectF *)cls)->bottomRight ());
}


// QPointF QRectF::center()


static void _init_f_center_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_center_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPointF > ((QPointF)((QRectF *)cls)->center ());
}


// bool QRectF::contains(const QRectF &r)


static void _init_f_contains_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_contains_c1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  ret.write<bool > ((bool)((QRectF *)cls)->contains (arg1));
}


// bool QRectF::contains(const QPointF &p)


static void _init_f_contains_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_contains_c1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  ret.write<bool > ((bool)((QRectF *)cls)->contains (arg1));
}


// bool QRectF::contains(double x, double y)


static void _init_f_contains_c2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_contains_c2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  ret.write<bool > ((bool)((QRectF *)cls)->contains (arg1, arg2));
}


// void QRectF::getCoords(double *x1, double *y1, double *x2, double *y2)


static void _init_f_getCoords_c4704 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x1");
  decl->add_arg<double * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y1");
  decl->add_arg<double * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("x2");
  decl->add_arg<double * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("y2");
  decl->add_arg<double * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_getCoords_c4704 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double *arg1 = gsi::arg_reader<double * >() (args, heap);
  double *arg2 = gsi::arg_reader<double * >() (args, heap);
  double *arg3 = gsi::arg_reader<double * >() (args, heap);
  double *arg4 = gsi::arg_reader<double * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->getCoords (arg1, arg2, arg3, arg4);
}


// void QRectF::getRect(double *x, double *y, double *w, double *h)


static void _init_f_getRect_c4704 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_getRect_c4704 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double *arg1 = gsi::arg_reader<double * >() (args, heap);
  double *arg2 = gsi::arg_reader<double * >() (args, heap);
  double *arg3 = gsi::arg_reader<double * >() (args, heap);
  double *arg4 = gsi::arg_reader<double * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->getRect (arg1, arg2, arg3, arg4);
}


// double QRectF::height()


static void _init_f_height_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_height_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QRectF *)cls)->height ());
}


// QRectF QRectF::intersected(const QRectF &other)


static void _init_f_intersected_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_intersected_c1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  ret.write<QRectF > ((QRectF)((QRectF *)cls)->intersected (arg1));
}


// bool QRectF::intersects(const QRectF &r)


static void _init_f_intersects_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_intersects_c1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  ret.write<bool > ((bool)((QRectF *)cls)->intersects (arg1));
}


// bool QRectF::isEmpty()


static void _init_f_isEmpty_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEmpty_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRectF *)cls)->isEmpty ());
}


// bool QRectF::isNull()


static void _init_f_isNull_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNull_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRectF *)cls)->isNull ());
}


// bool QRectF::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRectF *)cls)->isValid ());
}


// double QRectF::left()


static void _init_f_left_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_left_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QRectF *)cls)->left ());
}


// QRectF QRectF::marginsAdded(const QMarginsF &margins)


static void _init_f_marginsAdded_c2185 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMarginsF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_marginsAdded_c2185 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMarginsF &arg1 = gsi::arg_reader<const QMarginsF & >() (args, heap);
  ret.write<QRectF > ((QRectF)((QRectF *)cls)->marginsAdded (arg1));
}


// QRectF QRectF::marginsRemoved(const QMarginsF &margins)


static void _init_f_marginsRemoved_c2185 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMarginsF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_marginsRemoved_c2185 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMarginsF &arg1 = gsi::arg_reader<const QMarginsF & >() (args, heap);
  ret.write<QRectF > ((QRectF)((QRectF *)cls)->marginsRemoved (arg1));
}


// void QRectF::moveBottom(double pos)


static void _init_f_moveBottom_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_moveBottom_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->moveBottom (arg1);
}


// void QRectF::moveBottomLeft(const QPointF &p)


static void _init_f_moveBottomLeft_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_moveBottomLeft_1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->moveBottomLeft (arg1);
}


// void QRectF::moveBottomRight(const QPointF &p)


static void _init_f_moveBottomRight_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_moveBottomRight_1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->moveBottomRight (arg1);
}


// void QRectF::moveCenter(const QPointF &p)


static void _init_f_moveCenter_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_moveCenter_1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->moveCenter (arg1);
}


// void QRectF::moveLeft(double pos)


static void _init_f_moveLeft_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_moveLeft_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->moveLeft (arg1);
}


// void QRectF::moveRight(double pos)


static void _init_f_moveRight_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_moveRight_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->moveRight (arg1);
}


// void QRectF::moveTo(double x, double y)


static void _init_f_moveTo_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_moveTo_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->moveTo (arg1, arg2);
}


// void QRectF::moveTo(const QPointF &p)


static void _init_f_moveTo_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_moveTo_1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->moveTo (arg1);
}


// void QRectF::moveTop(double pos)


static void _init_f_moveTop_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_moveTop_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->moveTop (arg1);
}


// void QRectF::moveTopLeft(const QPointF &p)


static void _init_f_moveTopLeft_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_moveTopLeft_1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->moveTopLeft (arg1);
}


// void QRectF::moveTopRight(const QPointF &p)


static void _init_f_moveTopRight_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_moveTopRight_1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->moveTopRight (arg1);
}


// QRectF QRectF::normalized()


static void _init_f_normalized_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_normalized_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRectF > ((QRectF)((QRectF *)cls)->normalized ());
}


// QRectF QRectF::operator&(const QRectF &r)


static void _init_f_operator_amp__c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_operator_amp__c1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  ret.write<QRectF > ((QRectF)((QRectF *)cls)->operator& (arg1));
}


// QRectF &QRectF::operator&=(const QRectF &r)


static void _init_f_operator_amp__eq__1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF & > ();
}

static void _call_f_operator_amp__eq__1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  ret.write<QRectF & > ((QRectF &)((QRectF *)cls)->operator&= (arg1));
}


// QRectF &QRectF::operator+=(const QMarginsF &margins)


static void _init_f_operator_plus__eq__2185 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMarginsF & > (argspec_0);
  decl->set_return<QRectF & > ();
}

static void _call_f_operator_plus__eq__2185 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMarginsF &arg1 = gsi::arg_reader<const QMarginsF & >() (args, heap);
  ret.write<QRectF & > ((QRectF &)((QRectF *)cls)->operator+= (arg1));
}


// QRectF &QRectF::operator-=(const QMarginsF &margins)


static void _init_f_operator_minus__eq__2185 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMarginsF & > (argspec_0);
  decl->set_return<QRectF & > ();
}

static void _call_f_operator_minus__eq__2185 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMarginsF &arg1 = gsi::arg_reader<const QMarginsF & >() (args, heap);
  ret.write<QRectF & > ((QRectF &)((QRectF *)cls)->operator-= (arg1));
}


// QRectF QRectF::operator|(const QRectF &r)


static void _init_f_operator_pipe__c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_operator_pipe__c1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  ret.write<QRectF > ((QRectF)((QRectF *)cls)->operator| (arg1));
}


// QRectF &QRectF::operator|=(const QRectF &r)


static void _init_f_operator_pipe__eq__1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF & > ();
}

static void _call_f_operator_pipe__eq__1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  ret.write<QRectF & > ((QRectF &)((QRectF *)cls)->operator|= (arg1));
}


// double QRectF::right()


static void _init_f_right_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_right_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QRectF *)cls)->right ());
}


// void QRectF::setBottom(double pos)


static void _init_f_setBottom_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBottom_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->setBottom (arg1);
}


// void QRectF::setBottomLeft(const QPointF &p)


static void _init_f_setBottomLeft_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBottomLeft_1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->setBottomLeft (arg1);
}


// void QRectF::setBottomRight(const QPointF &p)


static void _init_f_setBottomRight_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBottomRight_1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->setBottomRight (arg1);
}


// void QRectF::setCoords(double x1, double y1, double x2, double y2)


static void _init_f_setCoords_3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x1");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y1");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("x2");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("y2");
  decl->add_arg<double > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setCoords_3960 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->setCoords (arg1, arg2, arg3, arg4);
}


// void QRectF::setHeight(double h)


static void _init_f_setHeight_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHeight_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->setHeight (arg1);
}


// void QRectF::setLeft(double pos)


static void _init_f_setLeft_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLeft_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->setLeft (arg1);
}


// void QRectF::setRect(double x, double y, double w, double h)


static void _init_f_setRect_3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setRect_3960 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  double arg3 = gsi::arg_reader<double >() (args, heap);
  double arg4 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->setRect (arg1, arg2, arg3, arg4);
}


// void QRectF::setRight(double pos)


static void _init_f_setRight_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRight_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->setRight (arg1);
}


// void QRectF::setSize(const QSizeF &s)


static void _init_f_setSize_1875 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QSizeF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSize_1875 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSizeF &arg1 = gsi::arg_reader<const QSizeF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->setSize (arg1);
}


// void QRectF::setTop(double pos)


static void _init_f_setTop_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTop_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->setTop (arg1);
}


// void QRectF::setTopLeft(const QPointF &p)


static void _init_f_setTopLeft_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTopLeft_1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->setTopLeft (arg1);
}


// void QRectF::setTopRight(const QPointF &p)


static void _init_f_setTopRight_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTopRight_1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->setTopRight (arg1);
}


// void QRectF::setWidth(double w)


static void _init_f_setWidth_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWidth_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->setWidth (arg1);
}


// void QRectF::setX(double pos)


static void _init_f_setX_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setX_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->setX (arg1);
}


// void QRectF::setY(double pos)


static void _init_f_setY_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setY_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->setY (arg1);
}


// QSizeF QRectF::size()


static void _init_f_size_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSizeF > ();
}

static void _call_f_size_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSizeF > ((QSizeF)((QRectF *)cls)->size ());
}


// QRect QRectF::toAlignedRect()


static void _init_f_toAlignedRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_toAlignedRect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QRectF *)cls)->toAlignedRect ());
}


// QRect QRectF::toRect()


static void _init_f_toRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_toRect_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QRectF *)cls)->toRect ());
}


// double QRectF::top()


static void _init_f_top_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_top_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QRectF *)cls)->top ());
}


// QPointF QRectF::topLeft()


static void _init_f_topLeft_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_topLeft_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPointF > ((QPointF)((QRectF *)cls)->topLeft ());
}


// QPointF QRectF::topRight()


static void _init_f_topRight_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_topRight_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPointF > ((QPointF)((QRectF *)cls)->topRight ());
}


// void QRectF::translate(double dx, double dy)


static void _init_f_translate_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_translate_2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->translate (arg1, arg2);
}


// void QRectF::translate(const QPointF &p)


static void _init_f_translate_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_translate_1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRectF *)cls)->translate (arg1);
}


// QRectF QRectF::translated(double dx, double dy)


static void _init_f_translated_c2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<QRectF > ();
}

static void _call_f_translated_c2034 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  double arg2 = gsi::arg_reader<double >() (args, heap);
  ret.write<QRectF > ((QRectF)((QRectF *)cls)->translated (arg1, arg2));
}


// QRectF QRectF::translated(const QPointF &p)


static void _init_f_translated_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_translated_c1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = gsi::arg_reader<const QPointF & >() (args, heap);
  ret.write<QRectF > ((QRectF)((QRectF *)cls)->translated (arg1));
}


// QRectF QRectF::united(const QRectF &other)


static void _init_f_united_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_united_c1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = gsi::arg_reader<const QRectF & >() (args, heap);
  ret.write<QRectF > ((QRectF)((QRectF *)cls)->united (arg1));
}


// double QRectF::width()


static void _init_f_width_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_width_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QRectF *)cls)->width ());
}


// double QRectF::x()


static void _init_f_x_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_x_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QRectF *)cls)->x ());
}


// double QRectF::y()


static void _init_f_y_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_y_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QRectF *)cls)->y ());
}


//  bool ::operator==(const QRectF &, const QRectF &)
static bool op_QRectF_operator_eq__eq__3616(const QRectF *_self, const QRectF &arg2) {
  return ::operator==(*_self, arg2);
}

//  bool ::operator!=(const QRectF &, const QRectF &)
static bool op_QRectF_operator_excl__eq__3616(const QRectF *_self, const QRectF &arg2) {
  return ::operator!=(*_self, arg2);
}

//  QRectF ::operator+(const QRectF &lhs, const QMarginsF &rhs)
static QRectF op_QRectF_operator_plus__3939u1(const QRectF *_self, const QMarginsF &rhs) {
  return ::operator+(*_self, rhs);
}

//  QRectF ::operator-(const QRectF &lhs, const QMarginsF &rhs)
static QRectF op_QRectF_operator_minus__3939(const QRectF *_self, const QMarginsF &rhs) {
  return ::operator-(*_self, rhs);
}


namespace gsi
{

static gsi::Methods methods_QRectF () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QRectF::QRectF()\nThis method creates an object of class QRectF.", &_init_ctor_QRectF_0, &_call_ctor_QRectF_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QRectF::QRectF(const QPointF &topleft, const QSizeF &size)\nThis method creates an object of class QRectF.", &_init_ctor_QRectF_3753, &_call_ctor_QRectF_3753);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QRectF::QRectF(const QPointF &topleft, const QPointF &bottomRight)\nThis method creates an object of class QRectF.", &_init_ctor_QRectF_3864, &_call_ctor_QRectF_3864);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QRectF::QRectF(double left, double top, double width, double height)\nThis method creates an object of class QRectF.", &_init_ctor_QRectF_3960, &_call_ctor_QRectF_3960);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QRectF::QRectF(const QRect &rect)\nThis method creates an object of class QRectF.", &_init_ctor_QRectF_1792, &_call_ctor_QRectF_1792);
  methods += new qt_gsi::GenericMethod ("adjust", "@brief Method void QRectF::adjust(double x1, double y1, double x2, double y2)\n", false, &_init_f_adjust_3960, &_call_f_adjust_3960);
  methods += new qt_gsi::GenericMethod ("adjusted", "@brief Method QRectF QRectF::adjusted(double x1, double y1, double x2, double y2)\n", true, &_init_f_adjusted_c3960, &_call_f_adjusted_c3960);
  methods += new qt_gsi::GenericMethod (":bottom", "@brief Method double QRectF::bottom()\n", true, &_init_f_bottom_c0, &_call_f_bottom_c0);
  methods += new qt_gsi::GenericMethod (":bottomLeft", "@brief Method QPointF QRectF::bottomLeft()\n", true, &_init_f_bottomLeft_c0, &_call_f_bottomLeft_c0);
  methods += new qt_gsi::GenericMethod (":bottomRight", "@brief Method QPointF QRectF::bottomRight()\n", true, &_init_f_bottomRight_c0, &_call_f_bottomRight_c0);
  methods += new qt_gsi::GenericMethod ("center", "@brief Method QPointF QRectF::center()\n", true, &_init_f_center_c0, &_call_f_center_c0);
  methods += new qt_gsi::GenericMethod ("contains", "@brief Method bool QRectF::contains(const QRectF &r)\n", true, &_init_f_contains_c1862, &_call_f_contains_c1862);
  methods += new qt_gsi::GenericMethod ("contains", "@brief Method bool QRectF::contains(const QPointF &p)\n", true, &_init_f_contains_c1986, &_call_f_contains_c1986);
  methods += new qt_gsi::GenericMethod ("contains", "@brief Method bool QRectF::contains(double x, double y)\n", true, &_init_f_contains_c2034, &_call_f_contains_c2034);
  methods += new qt_gsi::GenericMethod ("getCoords", "@brief Method void QRectF::getCoords(double *x1, double *y1, double *x2, double *y2)\n", true, &_init_f_getCoords_c4704, &_call_f_getCoords_c4704);
  methods += new qt_gsi::GenericMethod ("getRect", "@brief Method void QRectF::getRect(double *x, double *y, double *w, double *h)\n", true, &_init_f_getRect_c4704, &_call_f_getRect_c4704);
  methods += new qt_gsi::GenericMethod (":height", "@brief Method double QRectF::height()\n", true, &_init_f_height_c0, &_call_f_height_c0);
  methods += new qt_gsi::GenericMethod ("intersected", "@brief Method QRectF QRectF::intersected(const QRectF &other)\n", true, &_init_f_intersected_c1862, &_call_f_intersected_c1862);
  methods += new qt_gsi::GenericMethod ("intersects", "@brief Method bool QRectF::intersects(const QRectF &r)\n", true, &_init_f_intersects_c1862, &_call_f_intersects_c1862);
  methods += new qt_gsi::GenericMethod ("isEmpty?", "@brief Method bool QRectF::isEmpty()\n", true, &_init_f_isEmpty_c0, &_call_f_isEmpty_c0);
  methods += new qt_gsi::GenericMethod ("isNull?", "@brief Method bool QRectF::isNull()\n", true, &_init_f_isNull_c0, &_call_f_isNull_c0);
  methods += new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QRectF::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
  methods += new qt_gsi::GenericMethod (":left", "@brief Method double QRectF::left()\n", true, &_init_f_left_c0, &_call_f_left_c0);
  methods += new qt_gsi::GenericMethod ("marginsAdded", "@brief Method QRectF QRectF::marginsAdded(const QMarginsF &margins)\n", true, &_init_f_marginsAdded_c2185, &_call_f_marginsAdded_c2185);
  methods += new qt_gsi::GenericMethod ("marginsRemoved", "@brief Method QRectF QRectF::marginsRemoved(const QMarginsF &margins)\n", true, &_init_f_marginsRemoved_c2185, &_call_f_marginsRemoved_c2185);
  methods += new qt_gsi::GenericMethod ("moveBottom", "@brief Method void QRectF::moveBottom(double pos)\n", false, &_init_f_moveBottom_1071, &_call_f_moveBottom_1071);
  methods += new qt_gsi::GenericMethod ("moveBottomLeft", "@brief Method void QRectF::moveBottomLeft(const QPointF &p)\n", false, &_init_f_moveBottomLeft_1986, &_call_f_moveBottomLeft_1986);
  methods += new qt_gsi::GenericMethod ("moveBottomRight", "@brief Method void QRectF::moveBottomRight(const QPointF &p)\n", false, &_init_f_moveBottomRight_1986, &_call_f_moveBottomRight_1986);
  methods += new qt_gsi::GenericMethod ("moveCenter", "@brief Method void QRectF::moveCenter(const QPointF &p)\n", false, &_init_f_moveCenter_1986, &_call_f_moveCenter_1986);
  methods += new qt_gsi::GenericMethod ("moveLeft", "@brief Method void QRectF::moveLeft(double pos)\n", false, &_init_f_moveLeft_1071, &_call_f_moveLeft_1071);
  methods += new qt_gsi::GenericMethod ("moveRight", "@brief Method void QRectF::moveRight(double pos)\n", false, &_init_f_moveRight_1071, &_call_f_moveRight_1071);
  methods += new qt_gsi::GenericMethod ("moveTo", "@brief Method void QRectF::moveTo(double x, double y)\n", false, &_init_f_moveTo_2034, &_call_f_moveTo_2034);
  methods += new qt_gsi::GenericMethod ("moveTo", "@brief Method void QRectF::moveTo(const QPointF &p)\n", false, &_init_f_moveTo_1986, &_call_f_moveTo_1986);
  methods += new qt_gsi::GenericMethod ("moveTop", "@brief Method void QRectF::moveTop(double pos)\n", false, &_init_f_moveTop_1071, &_call_f_moveTop_1071);
  methods += new qt_gsi::GenericMethod ("moveTopLeft", "@brief Method void QRectF::moveTopLeft(const QPointF &p)\n", false, &_init_f_moveTopLeft_1986, &_call_f_moveTopLeft_1986);
  methods += new qt_gsi::GenericMethod ("moveTopRight", "@brief Method void QRectF::moveTopRight(const QPointF &p)\n", false, &_init_f_moveTopRight_1986, &_call_f_moveTopRight_1986);
  methods += new qt_gsi::GenericMethod ("normalized", "@brief Method QRectF QRectF::normalized()\n", true, &_init_f_normalized_c0, &_call_f_normalized_c0);
  methods += new qt_gsi::GenericMethod ("&", "@brief Method QRectF QRectF::operator&(const QRectF &r)\n", true, &_init_f_operator_amp__c1862, &_call_f_operator_amp__c1862);
  methods += new qt_gsi::GenericMethod ("&=", "@brief Method QRectF &QRectF::operator&=(const QRectF &r)\n", false, &_init_f_operator_amp__eq__1862, &_call_f_operator_amp__eq__1862);
  methods += new qt_gsi::GenericMethod ("+=", "@brief Method QRectF &QRectF::operator+=(const QMarginsF &margins)\n", false, &_init_f_operator_plus__eq__2185, &_call_f_operator_plus__eq__2185);
  methods += new qt_gsi::GenericMethod ("-=", "@brief Method QRectF &QRectF::operator-=(const QMarginsF &margins)\n", false, &_init_f_operator_minus__eq__2185, &_call_f_operator_minus__eq__2185);
  methods += new qt_gsi::GenericMethod ("|", "@brief Method QRectF QRectF::operator|(const QRectF &r)\n", true, &_init_f_operator_pipe__c1862, &_call_f_operator_pipe__c1862);
  methods += new qt_gsi::GenericMethod ("|=", "@brief Method QRectF &QRectF::operator|=(const QRectF &r)\n", false, &_init_f_operator_pipe__eq__1862, &_call_f_operator_pipe__eq__1862);
  methods += new qt_gsi::GenericMethod (":right", "@brief Method double QRectF::right()\n", true, &_init_f_right_c0, &_call_f_right_c0);
  methods += new qt_gsi::GenericMethod ("setBottom|bottom=", "@brief Method void QRectF::setBottom(double pos)\n", false, &_init_f_setBottom_1071, &_call_f_setBottom_1071);
  methods += new qt_gsi::GenericMethod ("setBottomLeft|bottomLeft=", "@brief Method void QRectF::setBottomLeft(const QPointF &p)\n", false, &_init_f_setBottomLeft_1986, &_call_f_setBottomLeft_1986);
  methods += new qt_gsi::GenericMethod ("setBottomRight|bottomRight=", "@brief Method void QRectF::setBottomRight(const QPointF &p)\n", false, &_init_f_setBottomRight_1986, &_call_f_setBottomRight_1986);
  methods += new qt_gsi::GenericMethod ("setCoords", "@brief Method void QRectF::setCoords(double x1, double y1, double x2, double y2)\n", false, &_init_f_setCoords_3960, &_call_f_setCoords_3960);
  methods += new qt_gsi::GenericMethod ("setHeight|height=", "@brief Method void QRectF::setHeight(double h)\n", false, &_init_f_setHeight_1071, &_call_f_setHeight_1071);
  methods += new qt_gsi::GenericMethod ("setLeft|left=", "@brief Method void QRectF::setLeft(double pos)\n", false, &_init_f_setLeft_1071, &_call_f_setLeft_1071);
  methods += new qt_gsi::GenericMethod ("setRect", "@brief Method void QRectF::setRect(double x, double y, double w, double h)\n", false, &_init_f_setRect_3960, &_call_f_setRect_3960);
  methods += new qt_gsi::GenericMethod ("setRight|right=", "@brief Method void QRectF::setRight(double pos)\n", false, &_init_f_setRight_1071, &_call_f_setRight_1071);
  methods += new qt_gsi::GenericMethod ("setSize|size=", "@brief Method void QRectF::setSize(const QSizeF &s)\n", false, &_init_f_setSize_1875, &_call_f_setSize_1875);
  methods += new qt_gsi::GenericMethod ("setTop|top=", "@brief Method void QRectF::setTop(double pos)\n", false, &_init_f_setTop_1071, &_call_f_setTop_1071);
  methods += new qt_gsi::GenericMethod ("setTopLeft|topLeft=", "@brief Method void QRectF::setTopLeft(const QPointF &p)\n", false, &_init_f_setTopLeft_1986, &_call_f_setTopLeft_1986);
  methods += new qt_gsi::GenericMethod ("setTopRight|topRight=", "@brief Method void QRectF::setTopRight(const QPointF &p)\n", false, &_init_f_setTopRight_1986, &_call_f_setTopRight_1986);
  methods += new qt_gsi::GenericMethod ("setWidth|width=", "@brief Method void QRectF::setWidth(double w)\n", false, &_init_f_setWidth_1071, &_call_f_setWidth_1071);
  methods += new qt_gsi::GenericMethod ("setX|x=", "@brief Method void QRectF::setX(double pos)\n", false, &_init_f_setX_1071, &_call_f_setX_1071);
  methods += new qt_gsi::GenericMethod ("setY|y=", "@brief Method void QRectF::setY(double pos)\n", false, &_init_f_setY_1071, &_call_f_setY_1071);
  methods += new qt_gsi::GenericMethod (":size", "@brief Method QSizeF QRectF::size()\n", true, &_init_f_size_c0, &_call_f_size_c0);
  methods += new qt_gsi::GenericMethod ("toAlignedRect", "@brief Method QRect QRectF::toAlignedRect()\n", true, &_init_f_toAlignedRect_c0, &_call_f_toAlignedRect_c0);
  methods += new qt_gsi::GenericMethod ("toRect", "@brief Method QRect QRectF::toRect()\n", true, &_init_f_toRect_c0, &_call_f_toRect_c0);
  methods += new qt_gsi::GenericMethod (":top", "@brief Method double QRectF::top()\n", true, &_init_f_top_c0, &_call_f_top_c0);
  methods += new qt_gsi::GenericMethod (":topLeft", "@brief Method QPointF QRectF::topLeft()\n", true, &_init_f_topLeft_c0, &_call_f_topLeft_c0);
  methods += new qt_gsi::GenericMethod (":topRight", "@brief Method QPointF QRectF::topRight()\n", true, &_init_f_topRight_c0, &_call_f_topRight_c0);
  methods += new qt_gsi::GenericMethod ("translate", "@brief Method void QRectF::translate(double dx, double dy)\n", false, &_init_f_translate_2034, &_call_f_translate_2034);
  methods += new qt_gsi::GenericMethod ("translate", "@brief Method void QRectF::translate(const QPointF &p)\n", false, &_init_f_translate_1986, &_call_f_translate_1986);
  methods += new qt_gsi::GenericMethod ("translated", "@brief Method QRectF QRectF::translated(double dx, double dy)\n", true, &_init_f_translated_c2034, &_call_f_translated_c2034);
  methods += new qt_gsi::GenericMethod ("translated", "@brief Method QRectF QRectF::translated(const QPointF &p)\n", true, &_init_f_translated_c1986, &_call_f_translated_c1986);
  methods += new qt_gsi::GenericMethod ("united", "@brief Method QRectF QRectF::united(const QRectF &other)\n", true, &_init_f_united_c1862, &_call_f_united_c1862);
  methods += new qt_gsi::GenericMethod (":width", "@brief Method double QRectF::width()\n", true, &_init_f_width_c0, &_call_f_width_c0);
  methods += new qt_gsi::GenericMethod (":x", "@brief Method double QRectF::x()\n", true, &_init_f_x_c0, &_call_f_x_c0);
  methods += new qt_gsi::GenericMethod (":y", "@brief Method double QRectF::y()\n", true, &_init_f_y_c0, &_call_f_y_c0);
  methods += gsi::method_ext("==", &::op_QRectF_operator_eq__eq__3616, gsi::arg ("arg2"), "@brief Operator bool ::operator==(const QRectF &, const QRectF &)\nThis is the mapping of the global operator to the instance method.");
  methods += gsi::method_ext("!=", &::op_QRectF_operator_excl__eq__3616, gsi::arg ("arg2"), "@brief Operator bool ::operator!=(const QRectF &, const QRectF &)\nThis is the mapping of the global operator to the instance method.");
  methods += gsi::method_ext("+", &::op_QRectF_operator_plus__3939u1, gsi::arg ("rhs"), "@brief Operator QRectF ::operator+(const QRectF &lhs, const QMarginsF &rhs)\nThis is the mapping of the global operator to the instance method.");
  methods += gsi::method_ext("-", &::op_QRectF_operator_minus__3939, gsi::arg ("rhs"), "@brief Operator QRectF ::operator-(const QRectF &lhs, const QMarginsF &rhs)\nThis is the mapping of the global operator to the instance method.");
  return methods;
}

gsi::Class<QRectF> decl_QRectF ("QtCore", "QRectF",
  methods_QRectF (),
  "@qt\n@brief Binding of QRectF");


GSI_QTCORE_PUBLIC gsi::Class<QRectF> &qtdecl_QRectF () { return decl_QRectF; }

}

