specification:		{ phylumdeclaration | includedeclaration | functiondeclaration |
			  rwdeclaration | unparsedeclaration |
			  rviewdeclaration | uviewdeclaration | storageclassdeclaration } ;

phylumdeclaration:	ID [storage_option] ':' [productionblock] [Ccode] ';' ;

storage_option:		'{' ['!'] ID '}' ;

productionblock:	'list' ID | alternative_list ;

alternative_list:	[alternative_list '|'] ID '(' arguments ')' ;

arguments:		{ID} ; 

Ccode:			'{' [Attributes] [Cbody] '}' ;

Attributes:		[Attributes] ID ID ['=' Cexpression] ';' ;

Cexpression:		/* arbitrary C expression without ';' and ',' with '$0' */

includedeclaration:	'%{' {ID} includes '%}' ; /* the tokens are at the beginning of a line */
			/* ID's in {ID} are at the same line as '%{' */

includes:		/* arbitrary text */ ;

rwdeclaration:		outmostpatterns '->' rwclauses_or_term ';' ;

rwclauses_or_term:	{rewriteclause} | outmostterm ;

rewriteclause:		'<' rviewnames ':' outmostterm '>' ;

rviewnames:		{ID} ;

patternchains:		patternchain [',' patternchains] ;

patternchain:		patternchainitem ['&' patternchain] ;

patternchainitem:	outmostpattern
|			'(' patternchains ')'
|			'$' ID /* this rule is to be used only in 'patternchain' in foreach_statement */
;

outmostpatterns:	outmostpattern [',' outmostpatterns] ;

outmostpattern:		[ID '='] ID ['(' [patterns] ')']  | '*' | 'default' ;

patterns:		pattern [',' patterns] ;

pattern:		ID '=' pattern
|			ID ['(' [patterns] ')']
|			'"' /* any string of characters */ '"'
|			/* a number */
|			'*' | 'default'
;

outmostterm:		ID '(' [terms] ')' ;

term:			ID ['(' [terms] ')'] 
|			'"' /* any string of characters */ '"'
|			/* a number */
;

terms:			term [',' terms] ;

functiondeclaration:	decl_specifiers fn_declarator {declaration} MainCbody ;

decl_specifiers:	[stor_class_specifier] [type_qualifier] ID ;

stor_class_specifier:	'auto' | 'register' | 'static' | 'extern' | 'typedef' ;

type_qualifier:		'const' | 'volatile' ;

fn_declarator:		[pointer] direct_fn_declarator ;

direct_fn_declarator:	ID '(' [fnarguments] ')'
|			ID '(' parameter_type_list ')'
;

fnarguments:		[fnarguments ','] ['$'] ID ;

parameter_type_list:	parameter_list [',' '...'] ;

parameter_list:		[parameter_list ','] parameter_decl ;

parameter_decl:		decl_specifiers declarator
|			decl_specifiers abstract_declarator
;

declarator:		[pointer] direct_declarator ;

pointer:		'*' {type_qualifier} [pointer] ;

direct_declarator:	['$'] ID
|			'(' pointer direct_declarator ')'
|			direct_declarator '[' [Cexpression] ']'
|			direct_declarator '(' param_type_list ')'
|			direct_declarator '(' [fnarguments] ')'
;

abstract_declarator:	pointer
|			[pointer] direct_abstract_declarator
;

direct_abstract_declarator:	'(' abstract_declarator ')'
|			[direct_abstract_declarator] '[' [Cexpression] ']'
|			[direct_abstract_declarator] '(' [parameter_type_list] ')'
;

declaration:		decl_specifiers	[declarator_list] ;

declarator_list:	[declarator_list ','] declarator ;

MainCbody:		Cbody
|			'{' with_clause '}' /* a with_clause if a fn argument has a $ prefix */
;

Cbody:			'{' Ctext '}' ;

Ctext:			/* arbitrary C text, with $0 through $n, 
			   with_statement and foreach_statement */ ;

foreach_statement:	'foreach' '(' patternchain ';' IDCexpressions ')' MainCbody
			[ 'afterforeach' '(' patternchain ')' MainCbodyinC ]
;

IDCexpressions:		ID Cexpression [',' IDCexpressions] ;

with_statement:		'with' '(' Cexpressions ')' '{' with_clause '}' ;

Cexpressions:		Cexpression [',' Cexpressions] ;

with_clause:		patternchains ':' Cbody [with_clause] ;

unparsedeclaration:	outmostpatterns '->' {unparseclause} ';' ;

unparseclause:		'[' uviewnames ':' {unparseitem} ']' ;

uviewnames:		{ID} ;

unparseitem:		'"' /* any string of characters*/ '"'  [':' ID]
|			['(' ID ')']  ID  {'->' ID}  [':' ID]
|			Cbody
|			'${' {unparseitem} '$}'
;

rviewdeclaration:	'%rview' rviewnames ';' ;

uviewdeclaration:	'%uview' uviewnames ';' ;

storageclassdeclaration:	'%storageclass' {ID} ';' ;
