// Code generated by gqlclientgen - DO NOT EDIT

package hgsrht

import (
	"context"
	gqlclient "git.sr.ht/~emersion/gqlclient"
)

type ACL struct {
	Id         int32          `json:"id"`
	Created    gqlclient.Time `json:"created"`
	Repository *Repository    `json:"repository"`
	Entity     *Entity        `json:"entity"`
	Mode       *AccessMode    `json:"mode,omitempty"`
}

// A cursor for enumerating access control list entries
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type ACLCursor struct {
	Results []*ACL  `json:"results"`
	Cursor  *Cursor `json:"cursor,omitempty"`
}

type AccessKind string

const (
	AccessKindRo AccessKind = "RO"
	AccessKindRw AccessKind = "RW"
)

type AccessMode string

const (
	// Read-only
	AccessModeRo AccessMode = "RO"
	// Read/write
	AccessModeRw AccessMode = "RW"
)

type AccessScope string

const (
	AccessScopeProfile      AccessScope = "PROFILE"
	AccessScopeRepositories AccessScope = "REPOSITORIES"
	AccessScopeRevisions    AccessScope = "REVISIONS"
	AccessScopeAcls         AccessScope = "ACLS"
)

type Cursor string

type Entity struct {
	Id      int32          `json:"id"`
	Created gqlclient.Time `json:"created"`
	Updated gqlclient.Time `json:"updated"`
	// The canonical name of this entity. For users, this is their username
	// prefixed with '~'. Additional entity types will be supported in the future.
	CanonicalName string `json:"canonicalName"`
	// Returns a specific repository owned by the entity.
	Repository *Repository `json:"repository,omitempty"`
	// Returns a list of repositories owned by the entity.
	Repositories *RepositoryCursor `json:"repositories"`
}

// Describes the status of optional features
type Features struct {
	Artifacts bool `json:"artifacts"`
}

type NamedRevision struct {
	Name string `json:"name"`
	Id   string `json:"id"`
}

// A cursor for enumerating bookmarks, tags, and branches
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type NamedRevisionCursor struct {
	Results []*NamedRevision `json:"results"`
	Cursor  *Cursor          `json:"cursor,omitempty"`
}

type OAuthClient struct {
	Uuid string `json:"uuid"`
}

type RepoInput struct {
	// Omit these fields to leave them unchanged, or set them to null to clear
	// their value.
	Name        *string     `json:"name,omitempty"`
	Description *string     `json:"description,omitempty"`
	Visibility  *Visibility `json:"visibility,omitempty"`
	// Updates the custom README associated with this repository. Note that the
	// provided HTML will be sanitized when displayed on the web; see
	// https://man.sr.ht/markdown/#post-processing
	Readme *string `json:"readme,omitempty"`
	// Controls whether this repository is a non-publishing repository.
	NonPublishing *bool `json:"nonPublishing,omitempty"`
}

type Repository struct {
	Id          int32          `json:"id"`
	Created     gqlclient.Time `json:"created"`
	Updated     gqlclient.Time `json:"updated"`
	Owner       *Entity        `json:"owner"`
	Name        string         `json:"name"`
	Description *string        `json:"description,omitempty"`
	Visibility  Visibility     `json:"visibility"`
	// The repository's custom README, if set.
	//
	// NOTICE: This returns unsanitized HTML. It is the client's responsibility to
	// sanitize this for display on the web, if so desired.
	Readme *string `json:"readme,omitempty"`
	// Whether or not this repository is a non-publishing repository.
	NonPublishing     bool       `json:"nonPublishing"`
	AccessControlList *ACLCursor `json:"accessControlList"`
	// The tip reference for this repository (latest commit)
	Tip *Revision `json:"tip,omitempty"`
	// Returns the list of open heads in the repository (like `hg heads`)
	// If `rev` is specified, return only open heads on the branch associated with
	// the given revision (like `hg heads REV`)
	Heads *RevisionCursor `json:"heads"`
	// Returns a list of commits (like `hg log`)
	// If `rev` is specified, only show the given commit (like `hg log --rev REV`)
	Log *RevisionCursor `json:"log"`
	// Returns a list of bookmarks
	Bookmarks *NamedRevisionCursor `json:"bookmarks"`
	// Returns a list of branches
	Branches *NamedRevisionCursor `json:"branches"`
	// Returns a list of tags
	Tags *NamedRevisionCursor `json:"tags"`
}

// A cursor for enumerating a list of repositories
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type RepositoryCursor struct {
	Results []*Repository `json:"results"`
	Cursor  *Cursor       `json:"cursor,omitempty"`
}

type RepositoryEvent struct {
	Uuid       string         `json:"uuid"`
	Event      WebhookEvent   `json:"event"`
	Date       gqlclient.Time `json:"date"`
	Repository *Repository    `json:"repository"`
}

type Revision struct {
	Id          string    `json:"id"`
	Branch      string    `json:"branch"`
	Tags        []*string `json:"tags"`
	Author      string    `json:"author"`
	Description string    `json:"description"`
}

// A cursor for enumerating revisions
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type RevisionCursor struct {
	Results []*Revision `json:"results"`
	Cursor  *Cursor     `json:"cursor,omitempty"`
}

// Instance specific settings
type Settings struct {
	SshUser string `json:"sshUser"`
}

type Tag struct {
	Name string `json:"name"`
	Id   string `json:"id"`
}

type User struct {
	Id            int32             `json:"id"`
	Created       gqlclient.Time    `json:"created"`
	Updated       gqlclient.Time    `json:"updated"`
	CanonicalName string            `json:"canonicalName"`
	Username      string            `json:"username"`
	Email         string            `json:"email"`
	Url           *string           `json:"url,omitempty"`
	Location      *string           `json:"location,omitempty"`
	Bio           *string           `json:"bio,omitempty"`
	Repository    *Repository       `json:"repository,omitempty"`
	Repositories  *RepositoryCursor `json:"repositories"`
}

type UserWebhookInput struct {
	Url    string         `json:"url"`
	Events []WebhookEvent `json:"events"`
	Query  string         `json:"query"`
}

type UserWebhookSubscription struct {
	Id         int32                  `json:"id"`
	Events     []WebhookEvent         `json:"events"`
	Query      string                 `json:"query"`
	Url        string                 `json:"url"`
	Client     *OAuthClient           `json:"client,omitempty"`
	Deliveries *WebhookDeliveryCursor `json:"deliveries"`
	Sample     string                 `json:"sample"`
}

type Version struct {
	Major int32 `json:"major"`
	Minor int32 `json:"minor"`
	Patch int32 `json:"patch"`
	// If this API version is scheduled for deprecation, this is the date on which
	// it will stop working; or null if this API version is not scheduled for
	// deprecation.
	DeprecationDate gqlclient.Time `json:"deprecationDate,omitempty"`
	// Optional features
	Features *Features `json:"features"`
	// Config settings
	Settings *Settings `json:"settings"`
}

type Visibility string

const (
	// Visible to everyone, listed on your profile
	VisibilityPublic Visibility = "PUBLIC"
	// Visible to everyone (if they know the URL), not listed on your profile
	VisibilityUnlisted Visibility = "UNLISTED"
	// Not visible to anyone except those explicitly added to the access list
	VisibilityPrivate Visibility = "PRIVATE"
)

type WebhookDelivery struct {
	Uuid         string               `json:"uuid"`
	Date         gqlclient.Time       `json:"date"`
	Event        WebhookEvent         `json:"event"`
	Subscription *WebhookSubscription `json:"subscription"`
	RequestBody  string               `json:"requestBody"`
	// These details are provided only after a response is received from the
	// remote server. If a response is sent whose Content-Type is not text/*, or
	// cannot be decoded as UTF-8, the response body will be null. It will be
	// truncated after 64 KiB.
	ResponseBody    *string `json:"responseBody,omitempty"`
	ResponseHeaders *string `json:"responseHeaders,omitempty"`
	ResponseStatus  *int32  `json:"responseStatus,omitempty"`
}

// A cursor for enumerating a list of webhook deliveries
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type WebhookDeliveryCursor struct {
	Results []WebhookDelivery `json:"results"`
	Cursor  *Cursor           `json:"cursor,omitempty"`
}

type WebhookEvent string

const (
	WebhookEventRepoCreated WebhookEvent = "REPO_CREATED"
	WebhookEventRepoUpdate  WebhookEvent = "REPO_UPDATE"
	WebhookEventRepoDeleted WebhookEvent = "REPO_DELETED"
)

type WebhookPayload struct {
	Uuid  string         `json:"uuid"`
	Event WebhookEvent   `json:"event"`
	Date  gqlclient.Time `json:"date"`
}

type WebhookSubscription struct {
	Id     int32          `json:"id"`
	Events []WebhookEvent `json:"events"`
	Query  string         `json:"query"`
	Url    string         `json:"url"`
	// If this webhook was registered by an authorized OAuth 2.0 client, this
	// field is non-null.
	Client *OAuthClient `json:"client,omitempty"`
	// All deliveries which have been sent to this webhook.
	Deliveries *WebhookDeliveryCursor `json:"deliveries"`
	// Returns a sample payload for this subscription, for testing purposes
	Sample string `json:"sample"`
}

// A cursor for enumerating a list of webhook subscriptions
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type WebhookSubscriptionCursor struct {
	Results []WebhookSubscription `json:"results"`
	Cursor  *Cursor               `json:"cursor,omitempty"`
}

func RepositoryIDByName(client *gqlclient.Client, ctx context.Context, name string) (me *User, err error) {
	op := gqlclient.NewOperation("query repositoryIDByName ($name: String!) {\n\tme {\n\t\trepository(name: $name) {\n\t\t\tid\n\t\t}\n\t}\n}\n")
	op.Var("name", name)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func RepositoryIDByUser(client *gqlclient.Client, ctx context.Context, username string, name string) (user *User, err error) {
	op := gqlclient.NewOperation("query repositoryIDByUser ($username: String!, $name: String!) {\n\tuser(username: $username) {\n\t\trepository(name: $name) {\n\t\t\tid\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func Repositories(client *gqlclient.Client, ctx context.Context, cursor *Cursor) (repositories *RepositoryCursor, err error) {
	op := gqlclient.NewOperation("query repositories ($cursor: Cursor) {\n\trepositories(cursor: $cursor) {\n\t\t... repos\n\t}\n}\nfragment repos on RepositoryCursor {\n\tresults {\n\t\tname\n\t\tdescription\n\t\tvisibility\n\t\towner {\n\t\t\tcanonicalName\n\t\t}\n\t}\n\tcursor\n}\n")
	op.Var("cursor", cursor)
	var respData struct {
		Repositories *RepositoryCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Repositories, err
}

func RepositoriesByUser(client *gqlclient.Client, ctx context.Context, username string, cursor *Cursor) (user *User, err error) {
	op := gqlclient.NewOperation("query repositoriesByUser ($username: String!, $cursor: Cursor) {\n\tuser(username: $username) {\n\t\trepositories(cursor: $cursor) {\n\t\t\t... repos\n\t\t}\n\t}\n}\nfragment repos on RepositoryCursor {\n\tresults {\n\t\tname\n\t\tdescription\n\t\tvisibility\n\t\towner {\n\t\t\tcanonicalName\n\t\t}\n\t}\n\tcursor\n}\n")
	op.Var("username", username)
	op.Var("cursor", cursor)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func UserWebhooks(client *gqlclient.Client, ctx context.Context) (userWebhooks *WebhookSubscriptionCursor, err error) {
	op := gqlclient.NewOperation("query userWebhooks {\n\tuserWebhooks {\n\t\tresults {\n\t\t\tid\n\t\t\turl\n\t\t}\n\t}\n}\n")
	var respData struct {
		UserWebhooks *WebhookSubscriptionCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UserWebhooks, err
}

func CreateRepository(client *gqlclient.Client, ctx context.Context, name string, visibility Visibility, description string) (createRepository *Repository, err error) {
	op := gqlclient.NewOperation("mutation createRepository ($name: String!, $visibility: Visibility!, $description: String!) {\n\tcreateRepository(name: $name, visibility: $visibility, description: $description) {\n\t\tname\n\t}\n}\n")
	op.Var("name", name)
	op.Var("visibility", visibility)
	op.Var("description", description)
	var respData struct {
		CreateRepository *Repository
	}
	err = client.Execute(ctx, op, &respData)
	return respData.CreateRepository, err
}

func DeleteRepository(client *gqlclient.Client, ctx context.Context, id int32) (deleteRepository *Repository, err error) {
	op := gqlclient.NewOperation("mutation deleteRepository ($id: Int!) {\n\tdeleteRepository(id: $id) {\n\t\tname\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		DeleteRepository *Repository
	}
	err = client.Execute(ctx, op, &respData)
	return respData.DeleteRepository, err
}

func CreateUserWebhook(client *gqlclient.Client, ctx context.Context, config UserWebhookInput) (createUserWebhook *WebhookSubscription, err error) {
	op := gqlclient.NewOperation("mutation createUserWebhook ($config: UserWebhookInput!) {\n\tcreateUserWebhook(config: $config) {\n\t\tid\n\t}\n}\n")
	op.Var("config", config)
	var respData struct {
		CreateUserWebhook *WebhookSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.CreateUserWebhook, err
}

func DeleteUserWebhook(client *gqlclient.Client, ctx context.Context, id int32) (deleteUserWebhook *WebhookSubscription, err error) {
	op := gqlclient.NewOperation("mutation deleteUserWebhook ($id: Int!) {\n\tdeleteUserWebhook(id: $id) {\n\t\tid\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		DeleteUserWebhook *WebhookSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.DeleteUserWebhook, err
}
