// Code generated by Wire. DO NOT EDIT.

//go:generate wire
//+build !wireinject

package main

import (
	"context"
	"contrib.go.opencensus.io/exporter/stackdriver/monitoredresource"
	"go.opencensus.io/trace"
	"gocloud.dev/gcp"
	"gocloud.dev/health"
	"gocloud.dev/server"
	"gocloud.dev/server/sdserver"
)

// Injectors from inject.go:

func initialize(ctx context.Context) (*server.Server, func(), error) {
	serveMux := newRouter()
	stackdriverLogger := sdserver.NewRequestLogger()
	v := _wireValue
	credentials, err := gcp.DefaultCredentials(ctx)
	if err != nil {
		return nil, nil, err
	}
	projectID, err := gcp.DefaultProjectID(credentials)
	if err != nil {
		return nil, nil, err
	}
	tokenSource := gcp.CredentialsTokenSource(credentials)
	monitoredresourceInterface := monitoredresource.Autodetect()
	exporter, cleanup, err := sdserver.NewExporter(projectID, tokenSource, monitoredresourceInterface)
	if err != nil {
		return nil, nil, err
	}
	sampler := trace.AlwaysSample()
	defaultDriver := _wireDefaultDriverValue
	options := &server.Options{
		RequestLogger:         stackdriverLogger,
		HealthChecks:          v,
		TraceExporter:         exporter,
		DefaultSamplingPolicy: sampler,
		Driver:                defaultDriver,
	}
	serverServer := server.New(serveMux, options)
	return serverServer, func() {
		cleanup()
	}, nil
}

var (
	_wireValue              = []health.Checker{connection}
	_wireDefaultDriverValue = &server.DefaultDriver{}
)
