//
// Server.h
//
// A class to keep track of server specific information.
//
// $Id: Server.h,v 1.5 2002-01-03 17:31:13 angusgb Exp $
//

#ifndef _Server_h_
#define _Server_h_

#include <Object.h>
#include <htString.h>
#include <Stack.h>
#include <Queue.h>
#include <StringMatch.h>
#include <time.h>
#include "URLRef.h"

class Document;

class Server : public Object
{
public:
	//
	// Construction/Destruction
	//
	Server(const String &host, int port);
	Server(const Server& rhs);
	~Server();

	//
	// This needs to be called with a document containing the
	// robots.txt file for this server
	//
	void			robotstxt(Document &doc);

	//
	// Provide some way of getting at the host and port for this server
	//
	int port() const            {return _port;}
	const String &host() const  {return _host;}
	
	//
	// Add a path to the queue for this server.  This will check to
	// see if the path in the path is allowed.  If it isn't allowed,
	// it simply won't be added.
	//
	void push(String &path, int hopcount, const String &referer);

	//
	// Return the next URL from the queue for this server.
	//
	URLRef			*pop();

	//
	// Delays the server if necessary. If the time between requests
	// is long enough, the request can occur immediately.
	//
	void			delay();

	//
	// Produce statistics for this server.
	//
	void reportStatistics(String &out, const String &name);

        // Methods for managing persistent connections
        void AllowPersistentConnection() { _persistent_connections = 1; }
        void AvoidPersistentConnection() { _persistent_connections = 0; }
        int IsPersistentConnectionAllowed() const
         { return _persistent_connections; }
	
protected:
	String			_host;
	int			_port;
	int			_bad_server;		// TRUE if we shouldn't use this one
	int		        _connection_space;	// Seconds between connections
	time_t			_last_connection;	// Time of last connection to this server
	Queue			_paths;
	StringMatch		_disallow;	// This pattern will be used to test paths
	int		        _documents;	// Number of documents visited
	int                     _max_documents;  // Maximum number of documents from this server
        int                     _persistent_connections; // Are pcs allowed

    Server() {};    // Not accessible anyway!
};

#endif


