{- This module was generated from data in the Kate syntax
   highlighting file noweb.xml, version 1.0, by Scott Collins (scc@scottcollins.net) -}

module Text.Highlighting.Kate.Syntax.Noweb
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Html
import qualified Text.Highlighting.Kate.Syntax.Cpp
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)

-- | Full name of language.
syntaxName :: String
syntaxName = "noweb"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.w;*.nw"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("noweb","RawDocumentation")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("noweb","RawDocumentation") -> return ()
      ("noweb","CodeQuote") -> return ()
      ("noweb","CodeSection") -> return ()
      ("noweb","SectionNames") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)


regex_'3c'3c'2e'2a'3e'3e'3d'24 = compileRegex "<<.*>>=$"
regex_'5c'5d'5c'5d'28'3f'21'5c'5d'29 = compileRegex "\\]\\](?!\\])"
regex_'40'24 = compileRegex "@$"
regex_'40'28'3f'3d'5b'5cs'25'5d'29 = compileRegex "@(?=[\\s%])"
regex_'40'3c'3c = compileRegex "@<<"
regex_'3c'3c'2e'2a'5b'5e'40'5d'3e'3e'28'3f'21'3d'29 = compileRegex "<<.*[^@]>>(?!=)"

parseRules ("noweb","RawDocumentation") =
  (((pColumn 0 >> pRegExpr regex_'3c'3c'2e'2a'3e'3e'3d'24 >>= withAttribute RegionMarkerTok) >>~ pushContext ("noweb","CodeSection"))
   <|>
   ((pDetect2Chars False '@' '[' >>= withAttribute NormalTok))
   <|>
   ((pDetect2Chars False '[' '[' >>= withAttribute RegionMarkerTok) >>~ pushContext ("noweb","CodeQuote"))
   <|>
   ((Text.Highlighting.Kate.Syntax.Html.parseExpression (Just ("HTML",""))))
   <|>
   (currentContext >>= \x -> guard (x == ("noweb","RawDocumentation")) >> pDefault >>= withAttribute NormalTok))

parseRules ("noweb","CodeQuote") =
  (((pDetect2Chars False '@' ']' >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5c'5d'5c'5d'28'3f'21'5c'5d'29 >>= withAttribute RegionMarkerTok) >>~ (popContext))
   <|>
   ((parseRules ("noweb","SectionNames")))
   <|>
   ((Text.Highlighting.Kate.Syntax.Cpp.parseExpression (Just ("C++",""))))
   <|>
   (currentContext >>= \x -> guard (x == ("noweb","CodeQuote")) >> pDefault >>= withAttribute NormalTok))

parseRules ("noweb","CodeSection") =
  (((pColumn 0 >> pRegExpr regex_'40'24 >>= withAttribute RegionMarkerTok) >>~ pushContext ("noweb","RawDocumentation"))
   <|>
   ((pColumn 0 >> pRegExpr regex_'40'28'3f'3d'5b'5cs'25'5d'29 >>= withAttribute RegionMarkerTok) >>~ pushContext ("noweb","RawDocumentation"))
   <|>
   ((pColumn 0 >> lookAhead (pRegExpr regex_'3c'3c'2e'2a'3e'3e'3d'24) >> pushContext ("noweb","RawDocumentation") >> currentContext >>= parseRules))
   <|>
   ((parseRules ("noweb","SectionNames")))
   <|>
   ((Text.Highlighting.Kate.Syntax.Cpp.parseExpression (Just ("C++",""))))
   <|>
   (currentContext >>= \x -> guard (x == ("noweb","CodeSection")) >> pDefault >>= withAttribute NormalTok))

parseRules ("noweb","SectionNames") =
  (((pRegExpr regex_'40'3c'3c >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'3c'3c'2e'2a'5b'5e'40'5d'3e'3e'28'3f'21'3d'29 >>= withAttribute RegionMarkerTok))
   <|>
   (currentContext >>= \x -> guard (x == ("noweb","SectionNames")) >> pDefault >>= withAttribute NormalTok))

parseRules ("HTML", _) = Text.Highlighting.Kate.Syntax.Html.parseExpression Nothing
parseRules ("C++", _) = Text.Highlighting.Kate.Syntax.Cpp.parseExpression Nothing

parseRules x = parseRules ("noweb","RawDocumentation") <|> fail ("Unknown context" ++ show x)
