/* 
 * ### Copyright (C) 2008 Michael Fuchs ###
 * ### All Rights Reserved.             ###
 *
 * Author: Michael Fuchs
 * E-Mail: michael.fuchs@dbdoclet.org
 * URL:    http://www.michael-a-fuchs.de
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.trafo.tag.docbook.DocBookElement;
import org.dbdoclet.trafo.tag.docbook.DocBookTagFactory;
import org.dbdoclet.trafo.tag.docbook.Entry;
import org.dbdoclet.trafo.tag.docbook.Example;
import org.dbdoclet.trafo.tag.docbook.InformalExample;
import org.dbdoclet.trafo.tag.docbook.SectionElement;
import org.dbdoclet.trafo.tag.html.HtmlElement;

public class PreEditor extends Editor {

	@Override
	public EditorInstruction edit(EditorInstruction values)
			throws EditorException {

		setValues(super.edit(values));
		DocBookTagFactory dbfactory = values.getTagFactory();
		HtmlElement pre = values.getHtmlElement();

		DocBookElement candidate;
		DocBookElement parent = getParent();

		if (getParent() instanceof Entry) {

			candidate = dbfactory.createScreen();

		} else if (getParent() instanceof Example
				|| getParent() instanceof InformalExample) {

			candidate = dbfactory.createProgramListing();

		} else {

			candidate = dbfactory.createScreen();
		}

		String attrLang = pre.getAttribute("lang");
		if (attrLang != null) {
			candidate.setAttribute("language", attrLang);
		}

		candidate.setParentNode(parent);

		if (candidate.validate()) {

			setCurrent(candidate);
			parent.appendChild(candidate);

		} else {

			if (parent.isSection()) {

				SectionElement sect = (SectionElement) parent;
				SectionElement firstSectionChild = sect.getFirstSectionChild();

				if (firstSectionChild != null) {

					setCurrent(candidate);
					parent.insertBefore(candidate, firstSectionChild);
				}
			}
		}

		traverse(true);

		return finalizeValues();
	}
}
