memoize
=======

[![Build Status][ci badge]][ci]
[![Docs][haddock badge]][haddock]
[![Hackage][hackage badge]][hackage]
[![License: BSD 3-Clause][license badge]][license]

This library provides a type class `Memoizable` for memoizing
functions, along with instances for a variety of argument types.
It includes a Template Haskell function for deriving
`Memoizable` instances for arbitrary algebraic datatypes.

The library constructs pure memo caches without the use of
`unsafePerformIO`.  This technique relies on implementation
assumptions—namely, *call-by-need*—that, while not guaranteed
by the semantics of Haskell, generally appear to hold.

[ci]:
  <https://github.com/tov/memoize/actions/workflows/ci.yaml>
  
[ci badge]:
  <https://github.com/tov/memoize/actions/workflows/ci.yaml/badge.svg>

[hackage]:
  <https://hackage.haskell.org/package/memoize>

[hackage badge]:
  <https://badgen.net/hackage/v/memoize>
  
[license]:
  <https://hackage.haskell.org/package/memoize/src/LICENSE>
  
[license badge]:
  <https://badgen.net/hackage/license/memoize>

[haddock]:
  <https://hackage.haskell.org/package/memoize/docs/Data-Function-Memoize.html>
  
[haddock badge]:
  <https://img.shields.io/static/v1?label=docs&message=available&color=blue>
