#!/usr/bin/env python
# -*- coding: utf-8 -*-

__author__ = "Peace Lee"
__copyright__ = "Copyright 2015-2021, Guider"
__module__ = "guider"
__credits__ = "Peace Lee"
__license__ = "GPLv2"
__version__ = "3.9.8"
__revision__ = "210326"
__maintainer__ = "Peace Lee"
__email__ = "iipeace5@gmail.com"
__repository__ = "https://github.com/iipeace/guider"





# import essential packages #
try:
    import os
    import re
    import gc
    import sys
    import time
    import errno
    import signal
    import atexit
    import struct
    from copy import deepcopy
    #from ctypes import *
except ImportError:
    err = sys.exc_info()[1]
    print("[ERROR] fail to import essential packages: %s" % err.args[0])
    sys.exit(0)

# to convert an unsupported type #
try:
    long
except:
    long = int

# to prevent MemoryError in python2 #
try:
    xrange
except:
    xrange = range





class ConfigMgr(object):
    """ Manager for config """

    # Define logo #
    # made by http://www.figlet.org, consider also jp2a #
    logo = '''
   _____       _     _
  / ____|     (_)   | |
 | |  __ _   _ _  __| | ___ _ __
 | | |_ | | | | |/ _` |/ _ \ '__|
 | |__| | |_| | | (_| |  __/ |
  \_____|\__,_|_|\__,_|\___|_|  ver.%s_%s on python_%s.%s
''' % (__version__, __revision__, sys.version_info[0], sys.version_info[1])

    # Define color #
    if (sys.platform.startswith('linux') or \
        sys.platform.startswith('freebsd')) and \
        not 'REMOTERUN' in os.environ:
        WARNING = '\033[95m'
        OKBLUE = '\033[94m'
        OKGREEN = '\033[92m'
        SPECIAL = '\033[93m'
        FAIL = '\033[91m'
        ENDC = '\033[0m'
        BOLD = '\033[1m'
        UNDERLINE = '\033[4m'
    else:
        WARNING = ''
        OKBLUE = ''
        OKGREEN = ''
        SPECIAL = ''
        FAIL = ''
        ENDC = ''
        BOLD = ''
        UNDERLINE = ''

    # Define config info #
    confData = {}

    # Define support architecture #
    supportArch = [
        'arm',
        'aarch64',
        'x86',
        'x64'
    ]

    # Define ANSI color #
    COLOR_LIST = {
        'DEFAULT': '\033[0m',
        'BOLD': '\033[1m',
        'ITALIC': '\033[3m',
        'UNDERLINE': '\033[4m',
        'LIGHT': '\033[5m',
        'BLINK': '\033[6m',
        'REVERSE': '\033[7m',
        'SCRATCH': '\033[9m',
        'BLACK': '\033[30m',
        'RED': '\033[31m',
        'GREEN': '\033[32m',
        'YELLOW': '\033[33m',
        'BLUE': '\033[34m',
        'PINK': '\033[35m',
        'CYAN': '\033[36m',
        'WHITE': '\033[37m',
        'DEFCOLOR': '\033[39m',
        'BGBLACK': '\033[40m',
        'BGRED': '\033[41m',
        'BGGREEN': '\033[42m',
        'BGYELLOW': '\033[43m',
        'BGBLUE': '\033[44m',
        'BGPINK': '\033[45m',
        'BGCYAN': '\033[46m',
        'BGWHITE': '\033[47m',
        'OKGREEN': '\033[92m',
        'SPECIAL': '\033[93m',
        'OKBLUE': '\033[94m',
        'WARNING': '\033[95m',
    }

    # Define cgroup entity #
    CGROUP_VALUE = [
        'tasks', 'cgroup.procs',
        'cpu.shares', 'cpuset.cpus',
        'memory.limit_in_bytes',
        'memory.memsw.limit_in_bytes',
        'blkio.weight', 'blkio.weight_device',
    ]

    # Define cgroup stat #
    CGROUP_STAT = [
        'cpuacct.usage',
        'memory.usage_in_bytes',
        'tasks',
        'cgroup.procs',
    ]

    # Define state of process #
    PROC_STAT_TYPE = {
        'R': 'running',
        'S': 'sleep',
        'D': 'disk',
        'T': 'stopped',
        't': 'traced',
        'X': 'dead',
        'x': 'dead',
        'Z': 'zombie',
        'K': 'wakekill',
        'W': 'waking',
        'P': 'parked',
        'I': 'idle',
    }

    # Define diskstat statistics #
    DISKSTAT = [
        'major', 'minor', 'name', 'readComplete', 'readMerge', 'sectorRead',
        'readTime', 'writeComplete', 'writeMerge', 'sectorWrite',
        'writeTime', 'currentIO', 'ioTime', 'ioWTime',
        'discComplete', 'discMerged', 'sectorDisc', 'discTime', # 4.18+
        'flushComplete', 'flushTime', # 5.5+
    ]

    # Define socketcall attributes #
    SOCKETCALL = {
        1: "socket",
        2: "bind",
        3: "connect",
        4: "listen",
        5: "accept",
        6: "getsockname",
        7: "getpeername",
        8: "socketpair",
        9: "send",
        10: "recv",
        11: "sendto",
        12: "recvfrom",
        13: "shutdown",
        14: "setsockopt",
        15: "getsockopt",
        16: "sendmsg",
        17: "recvmsg",
    }

    # Define socket family #
    SOCKET_FAMILY = {
        0: "AF_UNSPEC",
        1: "AF_FILE",
        2: "AF_INET",
        3: "AF_AX25",
        4: "AF_IPX",
        5: "AF_APPLETALK",
        6: "AF_NETROM",
        7: "AF_BRIDGE",
        8: "AF_ATMPVC",
        9: "AF_X25",
        10: "AF_INET6",
        11: "AF_ROSE",
        12: "AF_DECnet",
        13: "AF_NETBEUI",
        14: "AF_SECURITY",
        15: "AF_KEY",
        16: "AF_NETLINK",
        17: "AF_PACKET",
        18: "AF_ASH",
        19: "AF_ECONET",
        20: "AF_ATMSVC",
        22: "AF_SNA",
        23: "AF_IRDA",
        24: "AF_PPPOX",
        25: "AF_WANPIPE",
        31: "AF_BLUETOOTH",
    }

    # Define DLOPEN type #
    DLOPEN_TYPE = {
        1: "RTLD_LAZY",
        2: "RTLD_NOW",
        3: "RTLD_BINDING_MASK",
        4: "RTLD_NOLOAD",
        8: "RTLD_DEEPBIND",
    }

    # Define socket type #
    SOCKET_TYPE = {
        1: "SOCK_STREAM",
        2: "SOCK_DGRAM",
        3: "SOCK_RAW",
        4: "SOCK_RDM",
        5: "SOCK_SEQPACKET",
        10: "SOCK_PACKET",
    }

    # Define log level #
    LOG_LEVEL = {
        0: "EMERG",
        1: "ALERT",
        2: "CRIT",
        3: "ERR",
        4: "WARNING",
        5: "NOTICE",
        6: "INFO",
        7: "DEBUG",
    }

    # Define MSG type #
    MSG_TYPE = {
        0x1: "MSG_OOB",
        0x2: "MSG_PEEK",
        0x4: "MSG_DONTROUTE|MSG_TRYHARD",
        0x8: "MSG_CTRUNC",
        0x10: "MSG_PROBE",
        0x20: "MSG_TRUNC",
        0x40: "MSG_DONTWAIT",
        0x80: "MSG_EOR",
        0x100: "MSG_WAITALL",
        0x200: "MSG_FIN",
        0x400: "MSG_SYN",
        0x800: "MSG_CONFIRM",
        0x1000: "MSG_RST",
        0x2000: "MSG_ERRQUEUE",
        0x4000: "MSG_NOSIGNAL",
        0x8000: "MSG_MORE",
        0x40000000: "MSG_CMSG_CLOEXEC",
        0x80000000: "MSG_CMSG_COMPAT",
    }

    # Define control message type #
    CMSG_TYPE = {
        0x01: "SCM_RIGHTS",  # rw: access rights (array of int)
        0x02: "SCM_CREDENTIALS", # rw: struct ucred
        0x03: "SCM_SECURITY"
    }

    # Define mmap prot type #
    MAP_TYPE = {
        0x0000: "MAP_FILE",
        0x0001: "MAP_SHARED",
        0x0002: "MAP_PRIVATE",
        #0x0003: "MAP_SHARED_VALIDATE",
        #0x000f: "MAP_TYPE",
        0x0010: "MAP_FIXED",
        0x0020: "MAP_ANONYMOUS",
        0x0100: "MAP_GROWSDOWN",
        0x0800: "MAP_DENYWRITE",
        0x1000: "MAP_EXECUTABLE",
        0x2000: "MAP_LOCKED",
        0x4000: "MAP_NORESERVE",
        0x8000: "MAP_POPULATE",
        0x10000: "MAP_NONBLOCK",
        0x20000: "MAP_STACK",
        0x40000: "MAP_HUGETLB",
        0x80000: "MAP_SYNC",
    }

    # Define mmap prot type #
    PROT_TYPE = {
        0x0: "PROT_NONE",  # Page can not be accessed
        0x1: "PROT_READ",  # Page can be read
        0x2: "PROT_WRITE", # Page can be written
        0x4: "PROT_EXEC",  # Page can be executed
    }

    # Define perm type #
    PERM_TYPE = {
        0x0: "F_OK",
        0x1: "X_OK",
        0x2: "W_OK",
        0x4: "R_OK",
    }

    # Define seek type #
    SEEK_TYPE = {
        0x0: "SEEK_SET",
        0x1: "SEEK_CUR",
        0x2: "SEEK_END",
    }

    # Define prctl flags type #
    PRCTL_TYPE = {
        1: "PR_SET_PDEATHSIG",
        2: "PR_GET_PDEATHSIG",
        3: "PR_GET_DUMPABLE",
        4: "PR_SET_DUMPABLE",
        5: "PR_GET_UNALIGN",
        6: "PR_SET_UNALIGN",
        7: "PR_GET_KEEPCAPS",
        8: "PR_SET_KEEPCAPS",
        9: "PR_GET_FPEMU",
        10: "PR_SET_FPEMU",
        11: "PR_GET_FPEXC",
        12: "PR_SET_FPEXC",
        13: "PR_GET_TIMING",
        14: "PR_SET_TIMING",
        15: "PR_SET_NAME",
        16: "PR_GET_NAME",
        19: "PR_GET_ENDIAN",
        20: "PR_SET_ENDIAN",
        21: "PR_GET_SECCOMP",
        22: "PR_SET_SECCOMP",
        23: "PR_CAPBSET_READ",
        24: "PR_CAPBSET_DROP",
        25: "PR_GET_TSC 25",
        26: "PR_SET_TSC 26",
        27: "PR_GET_SECUREBITS",
        28: "PR_SET_SECUREBITS",
        29: "PR_SET_TIMERSLACK",
        30: "PR_GET_TIMERSLACK",
        31: "PR_TASK_PERF_EVENTS_DISABLE",
        32: "PR_TASK_PERF_EVENTS_ENABLE",
        33: "PR_MCE_KILL",
    }

    # Define clone flags type #
    CLONE_TYPE = {
        0x000000ff: "CSIGNAL",
        0x00000100: "CLONE_VM",
        0x00000200: "CLONE_FS",
        0x00000400: "CLONE_FILES",
        0x00000800: "CLONE_SIGHAND",
        0x00002000: "CLONE_PTRACE",
        0x00004000: "CLONE_VFORK",
        0x00008000: "CLONE_PARENT",
        0x00010000: "CLONE_THREAD",
        0x00020000: "CLONE_NEWNS",
        0x00040000: "CLONE_SYSVSEM",
        0x00080000: "CLONE_SETTLS",
        0x00100000: "CLONE_PARENT_SETTID",
        0x00200000: "CLONE_CHILD_CLEARTID",
        0x00400000: "CLONE_DETACHED",
        0x00800000: "CLONE_UNTRACED",
        0x01000000: "CLONE_CHILD_SETTID",
        0x02000000: "CLONE_STOPPED",
        0x04000000: "CLONE_NEWUTS",
        0x08000000: "CLONE_NEWIPC",
        0x10000000: "CLONE_NEWUSER",
        0x20000000: "CLONE_NEWPID",
        0x40000000: "CLONE_NEWNET",
        0x80000000: "CLONE_IO",
    }

    # Define open flags type #
    OPEN_TYPE = {
        0o0: "O_RDONLY",
        0o1: "O_WRONLY",
        0o2: "O_RDWR",
        0o100: "O_CREAT",
        0o200: "O_EXCL",
        0o400: "O_NOCTTY",
        0o1000: "O_TRUNC",
        0o2000: "O_APPEND",
        0o4000: "O_NONBLOCK",
        0o10000: "O_SYNC",
        0o20000: "O_ASYNC",
        0o40000: "O_DIRECT",
        0o100000: "O_LARGEFILE",
        0o200000: "O_DIRECTORY",
        0o400000: "O_NOFOLLOW",
        0o1000000: "O_NOATIME",
        0o2000000: "O_CLOEXEC",
        0o10000000: "O_PATH",
        0o20200000: "O_TMPFILE",
    }

    # Define madvise type #
    MADV_TYPE = {
        0: "MADV_NORMAL",       # No further special treatment
        1: "MADV_RANDOM",       # Expect random page references
        2: "MADV_SEQUENTIAL",   # Expect sequential page references
        3: "MADV_WILLNEED",     # Will need these pages
        4: "MADV_DONTNEED",     # Don't need these pages
        8: "MADV_FREE",         # Free pages only if memory pressure
        9: "MADV_REMOVE",       # Remove these pages and resources
        10: "MADV_DONTFORK",    # Do not inherit across fork
        11: "MADV_DOFORK",      # Do inherit across fork
        12: "MADV_MERGEABLE",   # KSM may merge identical pages
        13: "MADV_UNMERGEABLE", # KSM may not merge identical pages
        14: "MADV_HUGEPAGE",    # Worth backing with hugepages
        15: "MADV_NOHUGEPAGE",  # Not worth backing with hugepages
        16: "MADV_DONTDUMP",    # Explicity exclude from the core dump,
        17: "MADV_DODUMP",      # Clear the MADV_DONTDUMP flag
        18: "MADV_WIPEONFORK",  # Zero memory on fork, child only
        19: "MADV_KEEPONFORK",  # Undo MADV_WIPEONFORK
        100: "MADV_HWPOISON",   # Poison a page for testing
    }

    # Define netlink type #
    NETLINK_TYPE = {
        "NETLINK_ROUTE": 0,
        "NETLINK_UNUSED": 1,
        "NETLINK_USERSOCK": 2,
        "NETLINK_FIREWALL": 3,
        "NETLINK_SOCK_DIAG": 4,
        "NETLINK_NFLOG": 5,
        "NETLINK_XFRM": 6,
        "NETLINK_SELINUX": 7,
        "NETLINK_ISCSI": 8,
        "NETLINK_AUDIT": 9,
        "NETLINK_FIB_LOOKUP": 10,
        "NETLINK_CONNECTOR": 11,
        "NETLINK_NETFILTER": 12,
        "NETLINK_IP6_FW": 13,
        "NETLINK_DNRTMSG": 14,
        "NETLINK_KOBJECT_UEVENT": 15,
        "NETLINK_GENERIC": 16,
        "NETLINK_SCSITRANSPORT": 18,
        "NETLINK_ECRYPTFS": 19,
        "NETLINK_RDMA": 20,
        "NETLINK_CRYPTO": 21,
     }

    # Define entry type #
    INOTIFY_TYPE = {
        "IN_ACCESS": 0x00000001, # File was accessed */
        "IN_MODIFY": 0x00000002, # File was modified */
        "IN_ATTRIB": 0x00000004, # Metadata changed */
        "IN_CLOSE_WRITE": 0x00000008, # Writtable file was closed */
        "IN_CLOSE_NOWRITE": 0x00000010, # Unwrittable file closed */
        "IN_CLOSE": 0x00000008|0x00000010, # file closed */
        "IN_OPEN": 0x00000020, # File was opened */
        "IN_MOVED_FROM": 0x00000040, # File was moved from X */
        "IN_MOVED_TO": 0x00000080, # File was moved to Y */
        "IN_MOVED": 0x00000040|0x00000080, # File was moved */
        "IN_CREATE": 0x00000100, # Subfile was created */
        "IN_DELETE": 0x00000200, # Subfile was deleted */
        "IN_DELETE_SELF": 0x00000400, # Self was deleted */
        "IN_MOVE_SELF": 0x00000800, # Self was moved */
        "IN_UNMOUNT": 0x00002000, # Backing fs was unmounted */
        "IN_Q_OVERFLOW": 0x00004000, # Event queued overflowed */
        "IN_IGNORED": 0x00008000, # File was ignored */
        "IN_ONLYDIR": 0x01000000, # only watch the path if it is a directory */
        "IN_DONT_FOLLOW": 0x02000000, # don't follow a sym link */
        "IN_EXCL_UNLINK": 0x04000000, # exclude events on unlinked objects */
        "IN_MASK_CREATE": 0x10000000, # only create watches */
        "IN_MASK_ADD": 0x20000000, # add to the mask of an already existing watch */
        "IN_ISDIR": 0x40000000, # event occurred against dir */
        "IN_ONESHOT": 0x80000000, # only send event once */
    }

    # Define entry type #
    AT_TYPE = {
        "AT_IGNORE": 1, # Entry should be ignored
        "AT_EXECFD": 2, # File descriptor of program
        "AT_PHDR": 3, # Program headers for program
        "AT_PHENT": 4, # Size of program header entry
        "AT_PHNUM": 5, # Number of program headers
        "AT_PAGESZ": 6, # System page size
        "AT_BASE": 7, # Base address of interpreter
        "AT_FLAGS": 8, # Flags
        "AT_ENTRY": 9, # Entry point of program
        "AT_NOTELF": 10, # Program is not ELF
        "AT_UID": 11, # Real uid
        "AT_EUID": 12, # Effective uid
        "AT_GID": 13, # Real gid
        "AT_EGID": 14, # Effective gid
        "AT_CLKTCK": 17, # Frequency of times()
        "AT_PLATFORM": 15, # String identifying platform
        "AT_HWCAP": 16, # Machine-dependent hints about
        "AT_FPUCW": 18, # Used FPU control word
        "AT_DCACHEBSIZE": 19, # Data cache block size
        "AT_ICACHEBSIZE": 20, # Instruction cache block size
        "AT_UCACHEBSIZE": 21, # Unified cache block size
        "AT_IGNOREPPC": 22, # Entry should be ignored
        "AT_SECURE": 23, # Boolean, was exec setuid-like?
        "AT_BASE_PLATFORM": 24, # String identifying real platforms
        "AT_RANDOM": 25, # Address of 16 random bytes
        "AT_HWCAP2": 26, # More machine-dependent hints about
        "AT_EXECFN": 31, # Filename of executable
        "AT_SYSINFO": 32,
        "AT_SYSINFO_EHDR": 33,
        "AT_L1I_CACHESHAPE": 34,
        "AT_L1D_CACHESHAPE": 35,
        "AT_L2_CACHESHAPE": 36,
        "AT_L3_CACHESHAPE": 37,
        "AT_L1I_CACHESIZE": 40,
        "AT_L1I_CACHEGEOMETRY": 41,
        "AT_L1D_CACHESIZE": 42,
        "AT_L1D_CACHEGEOMETRY": 43,
        "AT_L2_CACHESIZE": 44,
        "AT_L2_CACHEGEOMETRY": 45,
        "AT_L3_CACHESIZE": 46,
        "AT_L3_CACHEGEOMETRY": 47,
        "AT_MINSIGSTKSZ": 51, # Stack needed for signal delivery
    }

    # Define syscall prototypes #
    SYSCALL_PROTOTYPES = {
        "accept": ("long", (
            ("int", "sockfd"),
            ("struct sockaddr *", "addr"),
            ("int *", "addrlen"),
        )),
        "accept4": ("long", (
            ("int", "sockfd"),
            ("struct sockaddr *", "addr"),
            ("int *", "addrlen"),
            ("int", "flags"),
        )),
        "access": ("long", (
            ("const char *", "filename"),
            ("int", "mode"),
        )),
        "acct": ("long", (
            ("const char *", "name"),
        )),
        "add_key": ("long", (
            ("const char *", "_type"),
            ("const char *", "_description"),
            ("const void *", "_payload"),
            ("size_t", "plen"),
            ("key_serial_t", "destringid"),
        )),
        "adjtimex": ("long", (
            ("struct timex *", "txc_p"),
        )),
        "alarm": ("long", (
            ("unsigned int", "seconds"),
        )),
        "bdflush": ("long", (
            ("int", "func"),
            ("long", "data"),
        )),
        "bind": ("long", (
            ("int", "sockfd"),
            ("struct sockaddr *", "addr"),
            ("int", "addrlen"),
        )),
        "bpf": ("long", (
            ("int", "cmd"),
            ("union bpf_attr *", "attr"),
            ("unsigned int", "size"),
        )),
        "brk": ("long", (
            ("unsigned long", "brk"),
        )),
        "capget": ("long", (
            ("cap_user_header_t", "header"),
            ("cap_user_data_t", "dataptr"),
        )),
        "capset": ("long", (
            ("cap_user_header_t", "header"),
            ("const cap_user_data_t", "data"),
        )),
        "chdir": ("long", (
            ("const char *", "filename"),
        )),
        "chmod": ("long", (
            ("const char *", "filename"),
            ("umode_t", "mode"),
        )),
        "chown": ("long", (
            ("const char *", "filename"),
            ("uid_t", "user"),
            ("gid_t", "group"),
        )),
        "chown16": ("long", (
            ("const char *", "filename"),
            ("old_uid_t", "user"),
            ("old_gid_t", "group"),
        )),
        "chroot": ("long", (
            ("const char *", "filename"),
        )),
        "clock_adjtime": ("long", (
            ("clockid_t", "which_clock"),
            ("struct timex *", "tx"),
        )),
        "clock_adjtime32": ("long", (
            ("clockid_t", "which_clock"),
            ("struct old_timex32 *", "tx"),
        )),
        "clock_getres": ("long", (
            ("clockid_t", "which_clock"),
            ("struct timespec *", "tp"),
        )),
        "clock_getres_time32": ("long", (
            ("clockid_t", "which_clock"),
            ("struct old_timespec32 *", "tp"),
        )),
        "clock_gettime": ("long", (
            ("clockid_t", "which_clock"),
            ("struct timespec *", "tp"),
        )),
        "clock_gettime32": ("long", (
            ("clockid_t", "which_clock"),
            ("struct old_timespec32 *", "tp"),
        )),
        "clock_nanosleep": ("long", (
            ("clockid_t", "which_clock"),
            ("int", "flags"),
            ("const struct timespec *", "rqtp"),
            ("struct timespec *", "rmtp"),
        )),
        "clock_nanosleep_time32": ("long", (
            ("clockid_t", "which_clock"),
            ("int", "flags"),
            ("struct old_timespec32 *", "rqtp"),
            ("struct old_timespec32 *", "rmtp"),
        )),
        "clock_settime": ("long", (
            ("clockid_t", "which_clock"),
            ("const struct timespec *", "tp"),
        )),
        "clock_settime32": ("long", (
            ("clockid_t", "which_clock"),
            ("struct old_timespec32 *", "tp"),
        )),
        "clone": ("long", (
            ("unsigned long", "child_stack"),
            ("unsigned long", "flags"),
            ("int *", "ptid"),
            ("int *", "ctid"),
            ("unsigned long", "regs"),
        )),
        "clone3": ("long", (
            ("struct clone_args *", "uargs"),
            ("size_t", "size"),
        )),
        "close": ("long", (
            ("unsigned int", "fd"),
        )),
        "connect": ("long", (
            ("int", "sockfd"),
            ("struct sockaddr *", "addr"),
            ("int", "addrlen"),
        )),
        "copy_file_range": ("long", (
            ("int", "fd_in"),
            ("loff_t *", "off_in"),
            ("int", "fd_out"),
            ("loff_t *", "off_out"),
            ("size_t", "len"),
            ("unsigned int", "flags"),
        )),
        "creat": ("long", (
            ("const char *", "pathname"),
            ("umode_t", "mode"),
        )),
        "delete_module": ("long", (
            ("const char *", "name_user"),
            ("unsigned int", "flags"),
        )),
        "dup": ("long", (
            ("unsigned int", "fildes"),
        )),
        "dup2": ("long", (
            ("unsigned int", "oldfd"),
            ("unsigned int", "newfd"),
        )),
        "dup3": ("long", (
            ("unsigned int", "oldfd"),
            ("unsigned int", "newfd"),
            ("int", "flags"),
        )),
        "epoll_create": ("long", (
            ("int", "size"),
        )),
        "epoll_create1": ("long", (
            ("int", "flags"),
        )),
        "epoll_ctl": ("long", (
            ("int", "epfd"),
            ("int", "op"),
            ("int", "fd"),
            ("struct epoll_event *", "event"),
        )),
        "epoll_pwait": ("long", (
            ("int", "epfd"),
            ("struct epoll_event *", "events"),
            ("int", "maxevents"),
            ("int", "timeout"),
            ("const sigset_t *", "sigmask"),
            ("size_t", "sigsetsize"),
        )),
        "epoll_wait": ("long", (
            ("int", "epfd"),
            ("struct epoll_event *", "events"),
            ("int", "maxevents"),
            ("int", "timeout"),
        )),
        "eventfd": ("long", (
            ("unsigned int", "count"),
        )),
        "eventfd2": ("long", (
            ("unsigned int", "count"),
            ("int", "flags"),
        )),
        "execve": ("long", (
            ("const char *", "filename"),
            ("const char *const *", "argv"),
            ("const char *const *", "envp"),
        )),
        "execveat": ("long", (
            ("int", "dfd"),
            ("const char *", "filename"),
            ("const char *const *", "argv"),
            ("const char *const *", "envp"),
            ("int", "flags"),
        )),
        "exit": ("long", (
            ("int", "error_code"),
        )),
        "exit_group": ("long", (
            ("int", "error_code"),
        )),
        "faccessat": ("long", (
            ("int", "dfd"),
            ("const char *", "filename"),
            ("int", "mode"),
        )),
        "faccessat2": ("long", (
            ("int", "dfd"),
            ("const char *", "filename"),
            ("int", "mode"),
            ("int", "flags"),
        )),
        "fadvise64": ("long", (
            ("int", "fd"),
            ("loff_t", "offset"),
            ("size_t", "len"),
            ("int", "advice"),
        )),
        "fadvise64_64": ("long", (
            ("int", "fd"),
            ("loff_t", "offset"),
            ("loff_t", "len"),
            ("int", "advice"),
        )),
        "fallocate": ("long", (
            ("int", "fd"),
            ("int", "mode"),
            ("loff_t", "offset"),
            ("loff_t", "len"),
        )),
        "fanotify_init": ("long", (
            ("unsigned int", "flags"),
            ("unsigned int", "event_f_flags"),
        )),
        "fanotify_mark": ("long", (
            ("int", "fanotify_fd"),
            ("unsigned int", "flags"),
            ("u64", "mask"),
            ("int", "fd"),
            ("const char *", "pathname"),
        )),
        "fchdir": ("long", (
            ("unsigned int", "fd"),
        )),
        "fchmod": ("long", (
            ("unsigned int", "fd"),
            ("umode_t", "mode"),
        )),
        "fchmodat": ("long", (
            ("int", "dfd"),
            ("const char *", "filename"),
            ("umode_t", "mode"),
        )),
        "fchown": ("long", (
            ("unsigned int", "fd"),
            ("uid_t", "user"),
            ("gid_t", "group"),
        )),
        "fchown16": ("long", (
            ("unsigned int", "fd"),
            ("old_uid_t", "user"),
            ("old_gid_t", "group"),
        )),
        "fchownat": ("long", (
            ("int", "dfd"),
            ("const char *", "filename"),
            ("uid_t", "user"),
            ("gid_t", "group"),
            ("int", "flag"),
        )),
        "fcntl": ("long", (
            ("unsigned int", "fd"),
            ("unsigned int", "cmd"),
            ("unsigned long", "arg"),
        )),
        "fcntl64": ("long", (
            ("unsigned int", "fd"),
            ("unsigned int", "cmd"),
            ("unsigned long", "arg"),
        )),
        "fdatasync": ("long", (
            ("unsigned int", "fd"),
        )),
        "fgetxattr": ("long", (
            ("int", "fd"),
            ("const char *", "name"),
            ("void *", "value"),
            ("size_t", "size"),
        )),
        "finit_module": ("long", (
            ("int", "fd"),
            ("const char *", "uargs"),
            ("int", "flags"),
        )),
        "flistxattr": ("long", (
            ("int", "fd"),
            ("char *", "list"),
            ("size_t", "size"),
        )),
        "flock": ("long", (
            ("unsigned int", "fd"),
            ("unsigned int", "cmd"),
        )),
        "fork": ("long", (
        )),
        "fremovexattr": ("long", (
            ("int", "fd"),
            ("const char *", "name"),
        )),
        "fsconfig": ("long", (
            ("int", "fs_fd"),
            ("unsigned int", "cmd"),
            ("const char *", "key"),
            ("const void *", "value"),
            ("int", "aux"),
        )),
        "fsetxattr": ("long", (
            ("int", "fd"),
            ("const char *", "name"),
            ("const void *", "value"),
            ("size_t", "size"),
            ("int", "flags"),
        )),
        "fsmount": ("long", (
            ("int", "fs_fd"),
            ("unsigned int", "flags"),
            ("unsigned int", "ms_flags"),
        )),
        "fsopen": ("long", (
            ("const char *", "fs_name"),
            ("unsigned int", "flags"),
        )),
        "fspick": ("long", (
            ("int", "dfd"),
            ("const char *", "path"),
            ("unsigned int", "flags"),
        )),
        "fstat": ("long", (
            ("unsigned int", "fd"),
            ("struct __old_kernel_stat *", "statbuf"),
        )),
        "fstat64": ("long", (
            ("unsigned long", "fd"),
            ("struct stat64 *", "statbuf"),
        )),
        "fstatat64": ("long", (
            ("int", "dfd"),
            ("const char *", "filename"),
            ("struct stat64 *", "statbuf"),
            ("int", "flag"),
        )),
        "fstatfs": ("long", (
            ("unsigned int", "fd"),
            ("struct statfs *", "buf"),
        )),
        "fstatfs64": ("long", (
            ("unsigned int", "fd"),
            ("size_t", "sz"),
            ("struct statfs64 *", "buf"),
        )),
        "fsync": ("long", (
            ("unsigned int", "fd"),
        )),
        "ftruncate": ("long", (
            ("unsigned int", "fd"),
            ("unsigned long", "length"),
        )),
        "ftruncate64": ("long", (
            ("unsigned int", "fd"),
            ("loff_t", "length"),
        )),
        "futex": ("long", (
            ("u32 *", "uaddr"),
            ("int", "op"),
            ("u32", "val"),
            ("struct timespec *", "utime"),
            ("u32 *", "uaddr2"),
            ("u32", "val3"),
        )),
        "futex_time32": ("long", (
            ("u32 *", "uaddr"),
            ("int", "op"),
            ("u32", "val"),
            ("struct old_timespec32 *", "utime"),
            ("u32 *", "uaddr2"),
            ("u32", "val3"),
        )),
        "futimesat": ("long", (
            ("int", "dfd"),
            ("const char *", "filename"),
            ("struct old_timeval *", "utimes"),
        )),
        "futimesat_time32": ("long", (
            ("unsigned int", "dfd"),
            ("const char *", "filename"),
            ("struct old_timeval32 *", "t"),
        )),
        "get_mempolicy": ("long", (
            ("int *", "policy"),
            ("unsigned long *", "nmask"),
            ("unsigned long", "maxnode"),
            ("unsigned long", "addr"),
            ("unsigned long", "flags"),
        )),
        "get_robust_list": ("long", (
            ("int", "pid"),
            ("struct robust_list_head * *", "head_ptr"),
            ("size_t *", "len_ptr"),
        )),
        "getcpu": ("long", (
            ("unsigned *", "cpu"),
            ("unsigned *", "node"),
            ("struct getcpu_cache *", "cache"),
        )),
        "getcwd": ("long", (
            ("char *", "pathname"),
            ("unsigned long", "size"),
        )),
        "getdents": ("long", (
            ("unsigned int", "fd"),
            ("struct linux_dirent *", "dirent"),
            ("unsigned int", "count"),
        )),
        "getdents64": ("long", (
            ("unsigned int", "fd"),
            ("struct linux_dirent64 *", "dirent"),
            ("unsigned int", "count"),
        )),
        "getegid": ("long", (
        )),
        "getegid16": ("long", (
        )),
        "geteuid": ("long", (
        )),
        "geteuid16": ("long", (
        )),
        "getgid": ("long", (
        )),
        "getgid16": ("long", (
        )),
        "getgroups": ("long", (
            ("int", "gidsetsize"),
            ("gid_t *", "grouplist"),
        )),
        "getgroups16": ("long", (
            ("int", "gidsetsize"),
            ("old_gid_t *", "grouplist"),
        )),
        "gethostname": ("long", (
            ("char *", "name"),
            ("int", "len"),
        )),
        "getitimer": ("long", (
            ("int", "which"),
            ("struct itimerval *", "value"),
        )),
        "getpeername": ("long", (
            ("int", "sockfd"),
            ("struct sockaddr *", "addr"),
            ("int *", "addrlen"),
        )),
        "getpgid": ("long", (
            ("pid_t", "pid"),
        )),
        "getpgrp": ("long", (
        )),
        "getpid": ("long", (
        )),
        "getppid": ("long", (
        )),
        "getpriority": ("long", (
            ("int", "which"),
            ("int", "who"),
        )),
        "getrandom": ("long", (
            ("char *", "buf"),
            ("size_t", "count"),
            ("unsigned int", "flags"),
        )),
        "getresgid": ("long", (
            ("gid_t *", "rgid"),
            ("gid_t *", "egid"),
            ("gid_t *", "sgid"),
        )),
        "getresgid16": ("long", (
            ("old_gid_t *", "rgid"),
            ("old_gid_t *", "egid"),
            ("old_gid_t *", "sgid"),
        )),
        "getresuid": ("long", (
            ("uid_t *", "ruid"),
            ("uid_t *", "euid"),
            ("uid_t *", "suid"),
        )),
        "getresuid16": ("long", (
            ("old_uid_t *", "ruid"),
            ("old_uid_t *", "euid"),
            ("old_uid_t *", "suid"),
        )),
        "getrlimit": ("long", (
            ("unsigned int", "resource"),
            ("struct rlimit *", "rlim"),
        )),
        "ugetrlimit": ("long", (
            ("unsigned int", "resource"),
            ("struct rlimit *", "rlim"),
        )),
        "getrusage": ("long", (
            ("int", "who"),
            ("struct rusage *", "ru"),
        )),
        "getsid": ("long", (
            ("pid_t", "pid"),
        )),
        "getsockname": ("long", (
            ("int", "sockfd"),
            ("struct sockaddr *", "addr"),
            ("int *", "addrlen"),
        )),
        "getsockopt": ("long", (
            ("int", "fd"),
            ("int", "level"),
            ("int", "optname"),
            ("char *", "optval"),
            ("int *", "optlen"),
        )),
        "gettid": ("long", (
        )),
        "gettimeofday": ("long", (
            ("struct timeval *", "tv"),
            ("struct timezone *", "tz"),
        )),
        "getuid": ("long", (
        )),
        "getuid16": ("long", (
        )),
        "getuid32": ("long", (
        )),
        "getxattr": ("long", (
            ("const char *", "path"),
            ("const char *", "name"),
            ("void *", "value"),
            ("size_t", "size"),
        )),
        "init_module": ("long", (
            ("void *", "umod"),
            ("unsigned long", "len"),
            ("const char *", "uargs"),
        )),
        "inotify_add_watch": ("long", (
            ("int", "fd"),
            ("const char *", "path"),
            ("u32", "mask"),
        )),
        "inotify_init": ("long", (
        )),
        "inotify_init1": ("long", (
            ("int", "flags"),
        )),
        "inotify_rm_watch": ("long", (
            ("int", "fd"),
            ("__s32", "wd"),
        )),
        "io_cancel": ("long", (
            ("aio_context_t", "ctx_id"),
            ("struct iocb *", "iocb"),
            ("struct io_event *", "result"),
        )),
        "io_destroy": ("long", (
            ("aio_context_t", "ctx"),
        )),
        "io_getevents": ("long", (
            ("aio_context_t", "ctx_id"),
            ("long", "min_nr"),
            ("long", "nr"),
            ("struct io_event *", "events"),
            ("struct timespec *", "timeout"),
        )),
        "io_getevents_time32": ("long", (
            ("__u32", "ctx_id"),
            ("__s32", "min_nr"),
            ("__s32", "nr"),
            ("struct io_event *", "events"),
            ("struct old_timespec32 *", "timeout"),
        )),
        "io_pgetevents": ("long", (
            ("aio_context_t", "ctx_id"),
            ("long", "min_nr"),
            ("long", "nr"),
            ("struct io_event *", "events"),
            ("struct timespec *", "timeout"),
            ("const struct __aio_sigset *", "sig"),
        )),
        "io_pgetevents_time32": ("long", (
            ("aio_context_t", "ctx_id"),
            ("long", "min_nr"),
            ("long", "nr"),
            ("struct io_event *", "events"),
            ("struct old_timespec32 *", "timeout"),
            ("const struct __aio_sigset *", "sig"),
        )),
        "io_setup": ("long", (
            ("unsigned", "nr_reqs"),
            ("aio_context_t *", "ctx"),
        )),
        "io_submit": ("long", (
            ("aio_context_t", "ctx_id"),
            ("long", "nr"),
            ("struct iocb * *", "iocbpp"),
        )),
        "io_uring_enter": ("long", (
            ("unsigned int", "fd"),
            ("u32", "to_submit"),
            ("u32", "min_complete"),
            ("u32", "flags"),
            ("const sigset_t *", "sig"),
            ("size_t", "sigsz"),
        )),
        "io_uring_register": ("long", (
            ("unsigned int", "fd"),
            ("unsigned int", "op"),
            ("void *", "arg"),
            ("unsigned int", "nr_args"),
        )),
        "io_uring_setup": ("long", (
            ("u32", "entries"),
            ("struct io_uring_params *", "p"),
        )),
        "ioctl": ("long", (
            ("unsigned int", "fd"),
            ("unsigned int", "cmd"),
            ("unsigned long", "arg"),
        )),
        "ioperm": ("long", (
            ("unsigned long", "from"),
            ("unsigned long", "num"),
            ("int", "on"),
        )),
        "ioprio_get": ("long", (
            ("int", "which"),
            ("int", "who"),
        )),
        "ioprio_set": ("long", (
            ("int", "which"),
            ("int", "who"),
            ("int", "ioprio"),
        )),
        "ipc": ("long", (
            ("unsigned int", "call"),
            ("int", "first"),
            ("unsigned long", "second"),
            ("unsigned long", "third"),
            ("void *", "ptr"),
            ("long", "fifth"),
        )),
        "kcmp": ("long", (
            ("pid_t", "pid1"),
            ("pid_t", "pid2"),
            ("int", "type"),
            ("unsigned long", "idx1"),
            ("unsigned long", "idx2"),
        )),
        "kexec_file_load": ("long", (
            ("int", "kernel_fd"),
            ("int", "initrd_fd"),
            ("unsigned long", "cmdline_len"),
            ("const char *", "cmdline_ptr"),
            ("unsigned long", "flags"),
        )),
        "kexec_load": ("long", (
            ("unsigned long", "entry"),
            ("unsigned long", "nr_segments"),
            ("struct kexec_segment *", "segments"),
            ("unsigned long", "flags"),
        )),
        "keyctl": ("long", (
            ("int", "cmd"),
            ("unsigned long", "arg2"),
            ("unsigned long", "arg3"),
            ("unsigned long", "arg4"),
            ("unsigned long", "arg5"),
        )),
        "kill": ("long", (
            ("int", "pid"),
            ("int", "sig"),
        )),
        "lchown": ("long", (
            ("const char *", "filename"),
            ("uid_t", "user"),
            ("gid_t", "group"),
        )),
        "lchown16": ("long", (
            ("const char *", "filename"),
            ("old_uid_t", "user"),
            ("old_gid_t", "group"),
        )),
        "lgetxattr": ("long", (
            ("const char *", "path"),
            ("const char *", "name"),
            ("void *", "value"),
            ("size_t", "size"),
        )),
        "link": ("long", (
            ("const char *", "oldname"),
            ("const char *", "newname"),
        )),
        "linkat": ("long", (
            ("int", "olddfd"),
            ("const char *", "oldname"),
            ("int", "newdfd"),
            ("const char *", "newname"),
            ("int", "flags"),
        )),
        "listen": ("long", (
            ("int", "sockfd"),
            ("int", "backlog"),
        )),
        "listxattr": ("long", (
            ("const char *", "path"),
            ("char *", "list"),
            ("size_t", "size"),
        )),
        "llistxattr": ("long", (
            ("const char *", "path"),
            ("char *", "list"),
            ("size_t", "size"),
        )),
        "llseek": ("long", (
            ("unsigned int", "fd"),
            ("unsigned long", "offset_high"),
            ("unsigned long", "offset_low"),
            ("loff_t *", "result"),
            ("unsigned int", "whence"),
        )),
        "lookup_dcookie": ("long", (
            ("u64", "cookie64"),
            ("char *", "buf"),
            ("size_t", "len"),
        )),
        "lremovexattr": ("long", (
            ("const char *", "path"),
            ("const char *", "name"),
        )),
        "lseek": ("long", (
            ("unsigned int", "fd"),
            ("off_t", "offset"),
            ("unsigned int", "whence"),
        )),
        "lsetxattr": ("long", (
            ("const char *", "path"),
            ("const char *", "name"),
            ("const void *", "value"),
            ("size_t", "size"),
            ("int", "flags"),
        )),
        "lstat": ("long", (
            ("const char *", "filename"),
            ("struct __old_kernel_stat *", "statbuf"),
        )),
        "lstat64": ("long", (
            ("const char *", "filename"),
            ("struct stat64 *", "statbuf"),
        )),
        "madvise": ("long", (
            ("unsigned long", "start"),
            ("size_t", "len"),
            ("int", "behavior"),
        )),
        "mbind": ("long", (
            ("unsigned long", "start"),
            ("unsigned long", "len"),
            ("unsigned long", "mode"),
            ("const unsigned long *", "nmask"),
            ("unsigned long", "maxnode"),
            ("unsigned", "flags"),
        )),
        "membarrier": ("long", (
            ("int", "cmd"),
            ("int", "flags"),
        )),
        "memfd_create": ("long", (
            ("const char *", "uname_ptr"),
            ("unsigned int", "flags"),
        )),
        "migrate_pages": ("long", (
            ("pid_t", "pid"),
            ("unsigned long", "maxnode"),
            ("const unsigned long *", "from"),
            ("const unsigned long *", "to"),
        )),
        "mincore": ("long", (
            ("unsigned long", "start"),
            ("size_t", "len"),
            ("unsigned char *", "vec"),
        )),
        "mkdir": ("long", (
            ("const char *", "pathname"),
            ("umode_t", "mode"),
        )),
        "mkdirat": ("long", (
            ("int", "dfd"),
            ("const char *", "pathname"),
            ("umode_t", "mode"),
        )),
        "mknod": ("long", (
            ("const char *", "filename"),
            ("umode_t", "mode"),
            ("unsigned", "dev"),
        )),
        "mknodat": ("long", (
            ("int", "dfd"),
            ("const char *", "filename"),
            ("umode_t", "mode"),
            ("unsigned", "dev"),
        )),
        "mlock": ("long", (
            ("unsigned long", "start"),
            ("size_t", "len"),
        )),
        "mlock2": ("long", (
            ("unsigned long", "start"),
            ("size_t", "len"),
            ("int", "flags"),
        )),
        "mlockall": ("long", (
            ("int", "flags"),
        )),
        "mmap_pgoff": ("long", (
            ("unsigned long", "addr"),
            ("unsigned long", "len"),
            ("unsigned long", "prot"),
            ("unsigned long", "flags"),
            ("unsigned long", "fd"),
            ("unsigned long", "pgoff"),
        )),
        "mmap": ("long", (
            ("unsigned long", "addr"),
            ("unsigned long", "len"),
            ("unsigned long", "prot"),
            ("unsigned long", "flags"),
            ("unsigned long", "fd"),
            ("unsigned long", "pgoff"),
        )),
        "mmap2": ("long", (
            ("unsigned long", "addr"),
            ("unsigned long", "len"),
            ("unsigned long", "prot"),
            ("unsigned long", "flags"),
            ("unsigned long", "fd"),
            ("unsigned long", "pgoff"),
        )),
        "move_mount": ("long", (
            ("int", "from_dfd"),
            ("const char *", "from_path"),
            ("int", "to_dfd"),
            ("const char *", "to_path"),
            ("unsigned int", "ms_flags"),
        )),
        "arch_prctl": ("int", (
            ("int", "code"),
            ("unsigned long", "addr"),
        )),
        "mount": ("long", (
            ("char *", "dev_name"),
            ("char *", "dir_name"),
            ("char *", "type"),
            ("unsigned long", "flags"),
            ("void *", "data"),
        )),
        "move_pages": ("long", (
            ("pid_t", "pid"),
            ("unsigned long", "nr_pages"),
            ("const void * *", "pages"),
            ("const int *", "nodes"),
            ("int *", "status"),
            ("int", "flags"),
        )),
        "mprotect": ("long", (
            ("unsigned long", "start"),
            ("size_t", "len"),
            ("unsigned long", "prot"),
        )),
        "mq_getsetattr": ("long", (
            ("mqd_t", "mqdes"),
            ("const struct mq_attr *", "mqstat"),
            ("struct mq_attr *", "omqstat"),
        )),
        "mq_notify": ("long", (
            ("mqd_t", "mqdes"),
            ("const struct sigevent *", "notification"),
        )),
        "mq_open": ("long", (
            ("const char *", "name"),
            ("int", "oflag"),
            ("umode_t", "mode"),
            ("struct mq_attr *", "attr"),
        )),
        "mq_timedreceive": ("long", (
            ("mqd_t", "mqdes"),
            ("char *", "msg_ptr"),
            ("size_t", "msg_len"),
            ("unsigned int *", "msg_prio"),
            ("const struct timespec *", "abs_timeout"),
        )),
        "mq_timedreceive_time32": ("long", (
            ("mqd_t", "mqdes"),
            ("char *", "u_msg_ptr"),
            ("unsigned int", "msg_len"),
            ("unsigned int *", "u_msg_prio"),
            ("const struct old_timespec32 *", "u_abs_timeout"),
        )),
        "mq_timedsend": ("long", (
            ("mqd_t", "mqdes"),
            ("const char *", "msg_ptr"),
            ("size_t", "msg_len"),
            ("unsigned int", "msg_prio"),
            ("const struct timespec *", "abs_timeout"),
        )),
        "mq_timedsend_time32": ("long", (
            ("mqd_t", "mqdes"),
            ("const char *", "u_msg_ptr"),
            ("unsigned int", "msg_len"),
            ("unsigned int", "msg_prio"),
            ("const struct old_timespec32 *", "u_abs_timeout"),
        )),
        "mq_unlink": ("long", (
            ("const char *", "name"),
        )),
        "mremap": ("long", (
            ("unsigned long", "addr"),
            ("unsigned long", "old_len"),
            ("unsigned long", "new_len"),
            ("unsigned long", "flags"),
            ("unsigned long", "new_addr"),
        )),
        "msgctl": ("long", (
            ("int", "msqid"),
            ("int", "cmd"),
            ("struct msqid_ds *", "buf"),
        )),
        "msgget": ("long", (
            ("key_t", "key"),
            ("int", "msgflg"),
        )),
        "msgrcv": ("long", (
            ("int", "msqid"),
            ("struct msgbuf *", "msgp"),
            ("size_t", "msgsz"),
            ("long", "msgtyp"),
            ("int", "msgflg"),
        )),
        "msgsnd": ("long", (
            ("int", "msqid"),
            ("struct msgbuf *", "msgp"),
            ("size_t", "msgsz"),
            ("int", "msgflg"),
        )),
        "msync": ("long", (
            ("unsigned long", "start"),
            ("size_t", "len"),
            ("int", "flags"),
        )),
        "munlock": ("long", (
            ("unsigned long", "start"),
            ("size_t", "len"),
        )),
        "munlockall": ("long", (
        )),
        "munmap": ("long", (
            ("unsigned long", "addr"),
            ("size_t", "len"),
        )),
        "name_to_handle_at": ("long", (
            ("int", "dfd"),
            ("const char *", "name"),
            ("struct file_handle *", "handle"),
            ("int *", "mnt_id"),
            ("int", "flag"),
        )),
        "nanosleep": ("long", (
            ("struct timespec *", "rqtp"),
            ("struct timespec *", "rmtp"),
        )),
        "nanosleep_time32": ("long", (
            ("struct old_timespec32 *", "rqtp"),
            ("struct old_timespec32 *", "rmtp"),
        )),
        "newfstat": ("long", (
            ("unsigned int", "fd"),
            ("struct stat *", "statbuf"),
        )),
        "newfstatat": ("long", (
            ("int", "dfd"),
            ("const char *", "filename"),
            ("struct stat *", "statbuf"),
            ("int", "flag"),
        )),
        "newlstat": ("long", (
            ("const char *", "filename"),
            ("struct stat *", "statbuf"),
        )),
        "newstat": ("long", (
            ("const char *", "filename"),
            ("struct stat *", "statbuf"),
        )),
        "newuname": ("long", (
            ("struct new_utsname *", "name"),
        )),
        "ni_syscall": ("long", (
        )),
        "nice": ("long", (
            ("int", "increment"),
        )),
        "old_getrlimit": ("long", (
            ("unsigned int", "resource"),
            ("struct rlimit *", "rlim"),
        )),
        "old_mmap": ("long", (
            ("struct mmap_arg_struct *", "arg"),
        )),
        "old_msgctl": ("long", (
            ("int", "msqid"),
            ("int", "cmd"),
            ("struct msqid_ds *", "buf"),
        )),
        "old_readdir": ("long", (
            ("unsigned int", "fd"),
            ("struct old_linux_dirent *", "dirp"),
            ("unsigned int", "count"),
        )),
        "old_select": ("long", (
            ("struct sel_arg_struct *", "arg"),
        )),
        "old_semctl": ("long", (
            ("int", "semid"),
            ("int", "semnum"),
            ("int", "cmd"),
            ("unsigned long", "arg"),
        )),
        "old_shmctl": ("long", (
            ("int", "shmid"),
            ("int", "cmd"),
            ("struct shmid_ds *", "buf"),
        )),
        "oldumount": ("long", (
            ("char *", "name"),
        )),
        "olduname": ("long", (
            ("struct oldold_utsname *", "buf"),
        )),
        "open": ("long", (
            ("const char *", "filename"),
            ("int", "flags"),
            ("umode_t", "mode"),
        )),
        "open_by_handle_at": ("long", (
            ("int", "mountdirfd"),
            ("struct file_handle *", "handle"),
            ("int", "flags"),
        )),
        "open_tree": ("long", (
            ("int", "dfd"),
            ("const char *", "path"),
            ("unsigned", "flags"),
        )),
        "openat": ("long", (
            ("int", "dfd"),
            ("const char *", "filename"),
            ("int", "flags"),
            ("umode_t", "mode"),
        )),
        "openat2": ("long", (
            ("int", "dfd"),
            ("const char *", "filename"),
            ("struct open_how *", "how"),
            ("size_t", "size"),
        )),
        "pause": ("long", (
        )),
        "pciconfig_iobase": ("long", (
            ("long", "which"),
            ("unsigned long", "bus"),
            ("unsigned long", "devfn"),
        )),
        "pciconfig_read": ("long", (
            ("unsigned long", "bus"),
            ("unsigned long", "dfn"),
            ("unsigned long", "off"),
            ("unsigned long", "len"),
            ("void *", "buf"),
        )),
        "pciconfig_write": ("long", (
            ("unsigned long", "bus"),
            ("unsigned long", "dfn"),
            ("unsigned long", "off"),
            ("unsigned long", "len"),
            ("void *", "buf"),
        )),
        "perf_event_open": ("long", (
            ("struct perf_event_attr *", "attr_uptr"),
            ("pid_t", "pid"),
            ("int", "cpu"),
            ("int", "group_fd"),
            ("unsigned long", "flags"),
        )),
        "personality": ("long", (
            ("unsigned int", "personality"),
        )),
        "pidfd_getfd": ("long", (
            ("int", "pidfd"),
            ("int", "fd"),
            ("unsigned int", "flags"),
        )),
        "pidfd_open": ("long", (
            ("pid_t", "pid"),
            ("unsigned int", "flags"),
        )),
        "pidfd_send_signal": ("long", (
            ("int", "pidfd"),
            ("int", "sig"),
            ("siginfo_t *", "info"),
            ("unsigned int", "flags"),
        )),
        "pipe": ("long", (
            ("int *", "fildes"),
        )),
        "pipe2": ("long", (
            ("int *", "fildes"),
            ("int", "flags"),
        )),
        "pivot_root": ("long", (
            ("const char *", "new_root"),
            ("const char *", "put_old"),
        )),
        "pkey_alloc": ("long", (
            ("unsigned long", "flags"),
            ("unsigned long", "init_val"),
        )),
        "pkey_free": ("long", (
            ("int", "pkey"),
        )),
        "pkey_mprotect": ("long", (
            ("unsigned long", "start"),
            ("size_t", "len"),
            ("unsigned long", "prot"),
            ("int", "pkey"),
        )),
        "poll": ("long", (
            ("struct pollfd *", "ufds"),
            ("unsigned int", "nfds"),
            ("int", "timeout"),
        )),
        "ppoll": ("long", (
            ("struct pollfd *", "fds"),
            ("unsigned int", "nfds"),
            ("struct timespec *", "tmo_p"),
            ("const sigset_t *", "sigmask"),
        )),
        "ppoll_time32": ("long", (
            ("struct pollfd *", "fds"),
            ("unsigned int", "nfds"),
            ("struct old_timespec *", "tmo_p"),
            ("const sigset_t *", "sigmask"),
        )),
        "prctl": ("long", (
            ("int", "option"),
            ("unsigned long", "arg2"),
            ("unsigned long", "arg3"),
            ("unsigned long", "arg4"),
            ("unsigned long", "arg5"),
        )),
        "pread64": ("long", (
            ("unsigned int", "fd"),
            ("char *", "buf"),
            ("size_t", "count"),
            ("loff_t", "pos"),
        )),
        "preadv": ("long", (
            ("unsigned long", "fd"),
            ("const struct iovec *", "vec"),
            ("unsigned long", "vlen"),
            ("unsigned long", "pos_l"),
            ("unsigned long", "pos_h"),
        )),
        "preadv2": ("long", (
            ("unsigned long", "fd"),
            ("const struct iovec *", "vec"),
            ("unsigned long", "vlen"),
            ("unsigned long", "pos_l"),
            ("unsigned long", "pos_h"),
            ("rwf_t", "flags"),
        )),
        "prlimit64": ("long", (
            ("pid_t", "pid"),
            ("unsigned int", "resource"),
            ("const struct rlimit64 *", "new_rlim"),
            ("struct rlimit64 *", "old_rlim"),
        )),
        "process_vm_readv": ("long", (
            ("pid_t", "pid"),
            ("const struct iovec *", "lvec"),
            ("unsigned long", "liovcnt"),
            ("const struct iovec *", "rvec"),
            ("unsigned long", "riovcnt"),
            ("unsigned long", "flags"),
        )),
        "process_vm_writev": ("long", (
            ("pid_t", "pid"),
            ("const struct iovec *", "lvec"),
            ("unsigned long", "liovcnt"),
            ("const struct iovec *", "rvec"),
            ("unsigned long", "riovcnt"),
            ("unsigned long", "flags"),
        )),
        "pselect6": ("long", (
            ("int", "nfds"),
            ("fd_set *", "readfds"),
            ("fd_set *", "writefds"),
            ("fd_set *", "exceptfds"),
            ("struct timespec *", "timeout"),
            ("void *", "sigmask"),
        )),
        "pselect6_time32": ("long", (
            ("int", "nfds"),
            ("fd_set *", "readfds"),
            ("fd_set *", "writefds"),
            ("fd_set *", "exceptfds"),
            ("struct old_timespec32 *", ""),
            ("void *", "sigmask"),
        )),
        "ptrace": ("long", (
            ("long", "request"),
            ("long", "pid"),
            ("unsigned long", "addr"),
            ("unsigned long", "data"),
        )),
        "pwrite64": ("long", (
            ("unsigned int", "fd"),
            ("const char *", "buf"),
            ("size_t", "count"),
            ("loff_t", "pos"),
        )),
        "pwritev": ("long", (
            ("unsigned long", "fd"),
            ("const struct iovec *", "vec"),
            ("unsigned long", "vlen"),
            ("unsigned long", "pos_l"),
            ("unsigned long", "pos_h"),
        )),
        "pwritev2": ("long", (
            ("unsigned long", "fd"),
            ("const struct iovec *", "vec"),
            ("unsigned long", "vlen"),
            ("unsigned long", "pos_l"),
            ("unsigned long", "pos_h"),
            ("rwf_t", "flags"),
        )),
        "quotactl": ("long", (
            ("unsigned int", "cmd"),
            ("const char *", "special"),
            ("qid_t", "id"),
            ("void *", "addr"),
        )),
        "read": ("long", (
            ("unsigned int", "fd"),
            ("char *", "buf"),
            ("size_t", "count"),
        )),
        "readahead": ("long", (
            ("int", "fd"),
            ("loff_t", "offset"),
            ("size_t", "count"),
        )),
        "readlink": ("long", (
            ("const char *", "path"),
            ("char *", "buf"),
            ("int", "bufsiz"),
        )),
        "readlinkat": ("long", (
            ("int", "dfd"),
            ("const char *", "path"),
            ("char *", "buf"),
            ("int", "bufsiz"),
        )),
        "readv": ("long", (
            ("unsigned long", "fd"),
            ("const struct iovec *", "vec"),
            ("unsigned long", "vlen"),
        )),
        "reboot": ("long", (
            ("int", "magic1"),
            ("int", "magic2"),
            ("unsigned int", "cmd"),
            ("void *", "arg"),
        )),
        "recv": ("long", (
            ("int", "sockfd"),
            ("void *", "buf"),
            ("size_t", "len"),
            ("unsigned", "flags"),
        )),
        "recvfrom": ("long", (
            ("int", "sockfd"),
            ("void *", "buf"),
            ("size_t", "len"),
            ("unsigned", "flags"),
            ("struct sockaddr *", "src_addr"),
            ("int *", "addrlen"),
        )),
        "recvmmsg": ("long", (
            ("int", "fd"),
            ("struct mmsghdr *", "msg"),
            ("unsigned int", "vlen"),
            ("unsigned", "flags"),
            ("struct timespec *", "timeout"),
        )),
        "recvmmsg_time32": ("long", (
            ("int", "fd"),
            ("struct mmsghdr *", "msg"),
            ("unsigned int", "vlen"),
            ("unsigned", "flags"),
            ("struct old_timespec32 *", "timeout"),
        )),
        "recvmsg": ("long", (
            ("int", "fd"),
            ("struct user_msghdr *", "msg"),
            ("unsigned", "flags"),
        )),
        "remap_file_pages": ("long", (
            ("unsigned long", "start"),
            ("unsigned long", "size"),
            ("unsigned long", "prot"),
            ("unsigned long", "pgoff"),
            ("unsigned long", "flags"),
        )),
        "removexattr": ("long", (
            ("const char *", "path"),
            ("const char *", "name"),
        )),
        "rename": ("long", (
            ("const char *", "oldname"),
            ("const char *", "newname"),
        )),
        "renameat": ("long", (
            ("int", "olddfd"),
            ("const char *", "oldname"),
            ("int", "newdfd"),
            ("const char *", "newname"),
        )),
        "renameat2": ("long", (
            ("int", "olddfd"),
            ("const char *", "oldname"),
            ("int", "newdfd"),
            ("const char *", "newname"),
            ("unsigned int", "flags"),
        )),
        "request_key": ("long", (
            ("const char *", "_type"),
            ("const char *", "_description"),
            ("const char *", "_callout_info"),
            ("key_serial_t", "destringid"),
        )),
        "restart_syscall": ("long", (
        )),
        "rmdir": ("long", (
            ("const char *", "pathname"),
        )),
        "rseq": ("long", (
            ("struct rseq *", "rseq"),
            ("uint32_t", "rseq_len"),
            ("int", "flags"),
            ("uint32_t", "sig"),
        )),
        "rt_sigaction": ("long", (
            ("int", "signum"),
            ("const struct sigaction *", "act"),
            ("struct sigaction *", "oldact"),
            ("size_t", ""),
        )),
        "rt_sigpending": ("long", (
            ("sigset_t *", "set"),
            ("size_t", "sigsetsize"),
        )),
        "rt_sigreturn": ("long", (
        )),
        "rt_sigprocmask": ("long", (
            ("int", "how"),
            ("sigset_t *", "set"),
            ("sigset_t *", "oset"),
            ("size_t", "sigsetsize"),
        )),
        "rt_sigqueueinfo": ("long", (
            ("int", "pid"),
            ("int", "sig"),
            ("siginfo_t *", "uinfo"),
        )),
        "rt_sigsuspend": ("long", (
            ("sigset_t *", "unewset"),
            ("size_t", "sigsetsize"),
        )),
        "rt_sigtimedwait": ("long", (
            ("const sigset_t *", "uthese"),
            ("siginfo_t *", "uinfo"),
            ("const struct timespec *", "uts"),
            ("size_t", "sigsetsize"),
        )),
        "rt_sigtimedwait_time32": ("long", (
            ("const sigset_t *", "uthese"),
            ("siginfo_t *", "uinfo"),
            ("const struct old_timespec32 *", "uts"),
            ("size_t", "sigsetsize"),
        )),
        "rt_tgsigqueueinfo": ("long", (
            ("pid_t", "tgid"),
            ("pid_t", "pid"),
            ("int", "sig"),
            ("siginfo_t *", "uinfo"),
        )),
        "sched_get_priority_max": ("long", (
            ("int", "policy"),
        )),
        "sched_get_priority_min": ("long", (
            ("int", "policy"),
        )),
        "sched_getaffinity": ("long", (
            ("pid_t", "pid"),
            ("unsigned int", "len"),
            ("unsigned long *", "user_mask_ptr"),
        )),
        "sched_getattr": ("long", (
            ("pid_t", "pid"),
            ("struct sched_attr *", "attr"),
            ("unsigned int", "size"),
            ("unsigned int", "flags"),
        )),
        "sched_getparam": ("long", (
            ("pid_t", "pid"),
            ("struct sched_param *", "param"),
        )),
        "sched_getscheduler": ("long", (
            ("pid_t", "pid"),
        )),
        "sched_rr_get_interval": ("long", (
            ("pid_t", "pid"),
            ("struct timespec *", "interval"),
        )),
        "sched_rr_get_interval_time32": ("long", (
            ("pid_t", "pid"),
            ("struct old_timespec32 *", "interval"),
        )),
        "sched_setaffinity": ("long", (
            ("pid_t", "pid"),
            ("unsigned int", "len"),
            ("unsigned long *", "user_mask_ptr"),
        )),
        "sched_setattr": ("long", (
            ("pid_t", "pid"),
            ("struct sched_attr *", "attr"),
            ("unsigned int", "flags"),
        )),
        "sched_setparam": ("long", (
            ("pid_t", "pid"),
            ("struct sched_param *", "param"),
        )),
        "sched_setscheduler": ("long", (
            ("pid_t", "pid"),
            ("int", "policy"),
            ("struct sched_param *", "param"),
        )),
        "sched_yield": ("long", (
        )),
        "seccomp": ("long", (
            ("unsigned int", "op"),
            ("unsigned int", "flags"),
            ("const char *", "uargs"),
        )),
        "select": ("long", (
            ("int", "n"),
            ("fd_set *", "inp"),
            ("fd_set *", "outp"),
            ("fd_set *", "exp"),
            ("struct timeval *", "tvp"),
        )),
        "newselect": ("long", (
            ("int", "n"),
            ("fd_set *", "inp"),
            ("fd_set *", "outp"),
            ("fd_set *", "exp"),
            ("struct timeval *", "tvp"),
        )),
        "semctl": ("long", (
            ("int", "semid"),
            ("int", "semnum"),
            ("int", "cmd"),
            ("unsigned long", "arg"),
        )),
        "semget": ("long", (
            ("key_t", "key"),
            ("int", "nsems"),
            ("int", "semflg"),
        )),
        "semop": ("long", (
            ("int", "semid"),
            ("struct sembuf *", "sops"),
            ("unsigned", "nsops"),
        )),
        "semtimedop": ("long", (
            ("int", "semid"),
            ("struct sembuf *", "sops"),
            ("unsigned", "nsops"),
            ("const struct timespec *", "timeout"),
        )),
        "semtimedop_time32": ("long", (
            ("int", "semid"),
            ("struct sembuf *", "sops"),
            ("unsigned", "nsops"),
            ("const struct old_timespec32 *", "timeout"),
        )),
        "send": ("long", (
            ("int", "sockfd"),
            ("void *", "buf"),
            ("size_t", "len"),
            ("unsigned", "flags"),
        )),
        "sendfile": ("long", (
            ("int", "out_fd"),
            ("int", "in_fd"),
            ("off_t *", "offset"),
            ("size_t", "count"),
        )),
        "sendfile64": ("long", (
            ("int", "out_fd"),
            ("int", "in_fd"),
            ("loff_t *", "offset"),
            ("size_t", "count"),
        )),
        "sendmmsg": ("long", (
            ("int", "fd"),
            ("struct mmsghdr *", "msg"),
            ("unsigned int", "vlen"),
            ("unsigned", "flags"),
        )),
        "sendmsg": ("long", (
            ("int", "fd"),
            ("struct user_msghdr *", "msg"),
            ("unsigned", "flags"),
        )),
        "sendto": ("long", (
            ("int", "sockfd"),
            ("void *", "buf"),
            ("size_t", "len"),
            ("unsigned", "flags"),
            ("struct sockaddr *", "destAddr"),
            ("int", "addrlen"),
        )),
        "set_mempolicy": ("long", (
            ("int", "mode"),
            ("const unsigned long *", "nmask"),
            ("unsigned long", "maxnode"),
        )),
        "set_robust_list": ("long", (
            ("struct robust_list_head *", "head"),
            ("size_t", "len"),
        )),
        "set_tid_address": ("long", (
            ("int *", "tidptr"),
        )),
        "setdomainname": ("long", (
            ("char *", "name"),
            ("int", "len"),
        )),
        "setfsgid": ("long", (
            ("gid_t", "gid"),
        )),
        "setfsgid16": ("long", (
            ("old_gid_t", "gid"),
        )),
        "setfsuid": ("long", (
            ("uid_t", "uid"),
        )),
        "setfsuid16": ("long", (
            ("old_uid_t", "uid"),
        )),
        "setgid": ("long", (
            ("gid_t", "gid"),
        )),
        "setgid16": ("long", (
            ("old_gid_t", "gid"),
        )),
        "setgroups": ("long", (
            ("int", "gidsetsize"),
            ("gid_t *", "grouplist"),
        )),
        "setgroups16": ("long", (
            ("int", "gidsetsize"),
            ("old_gid_t *", "grouplist"),
        )),
        "sethostname": ("long", (
            ("char *", "name"),
            ("int", "len"),
        )),
        "setitimer": ("long", (
            ("int", "which"),
            ("struct itimerval *", "value"),
            ("struct itimerval *", "ovalue"),
        )),
        "setns": ("long", (
            ("int", "fd"),
            ("int", "nstype"),
        )),
        "setpgid": ("long", (
            ("pid_t", "pid"),
            ("pid_t", "pgid"),
        )),
        "setpriority": ("long", (
            ("int", "which"),
            ("int", "who"),
            ("int", "niceval"),
        )),
        "setregid": ("long", (
            ("gid_t", "rgid"),
            ("gid_t", "egid"),
        )),
        "setregid16": ("long", (
            ("old_gid_t", "rgid"),
            ("old_gid_t", "egid"),
        )),
        "setresgid": ("long", (
            ("gid_t", "rgid"),
            ("gid_t", "egid"),
            ("gid_t", "sgid"),
        )),
        "setresgid16": ("long", (
            ("old_gid_t", "rgid"),
            ("old_gid_t", "egid"),
            ("old_gid_t", "sgid"),
        )),
        "setresuid": ("long", (
            ("uid_t", "ruid"),
            ("uid_t", "euid"),
            ("uid_t", "suid"),
        )),
        "setresuid16": ("long", (
            ("old_uid_t", "ruid"),
            ("old_uid_t", "euid"),
            ("old_uid_t", "suid"),
        )),
        "setreuid": ("long", (
            ("uid_t", "ruid"),
            ("uid_t", "euid"),
        )),
        "setreuid16": ("long", (
            ("old_uid_t", "ruid"),
            ("old_uid_t", "euid"),
        )),
        "setrlimit": ("long", (
            ("unsigned int", "resource"),
            ("struct rlimit *", "rlim"),
        )),
        "setsid": ("long", (
        )),
        "setsockopt": ("long", (
            ("int", "fd"),
            ("int", "level"),
            ("int", "optname"),
            ("char *", "optval"),
            ("int", "optlen"),
        )),
        "settimeofday": ("long", (
            ("struct timeval *", "tv"),
            ("struct timezone *", "tz"),
        )),
        "setuid": ("long", (
            ("uid_t", "uid"),
        )),
        "setuid16": ("long", (
            ("old_uid_t", "uid"),
        )),
        "setxattr": ("long", (
            ("const char *", "path"),
            ("const char *", "name"),
            ("const void *", "value"),
            ("size_t", "size"),
            ("int", "flags"),
        )),
        "sgetmask": ("long", (
        )),
        "shmat": ("long", (
            ("int", "shmid"),
            ("char *", "shmaddr"),
            ("int", "shmflg"),
        )),
        "shmctl": ("long", (
            ("int", "shmid"),
            ("int", "cmd"),
            ("struct shmid_ds *", "buf"),
        )),
        "shmdt": ("long", (
            ("char *", "shmaddr"),
        )),
        "shmget": ("long", (
            ("key_t", "key"),
            ("size_t", "size"),
            ("int", "flag"),
        )),
        "shutdown": ("long", (
            ("int", "sockfd"),
            ("int", "how"),
        )),
        "sigaction": ("long", (
            ("int", "signum"),
            ("const struct old_sigaction *", "act"),
            ("struct old_sigaction *", "oldact"),
        )),
        "sigaltstack": ("long", (
            ("const struct sigaltstack *", "uss"),
            ("struct sigaltstack *", "uoss"),
        )),
        "signal": ("long", (
            ("int", "sig"),
            ("__sighandler_t", "handler"),
        )),
        "signalfd": ("long", (
            ("int", "ufd"),
            ("sigset_t *", "user_mask"),
            ("size_t", "sizemask"),
        )),
        "signalfd4": ("long", (
            ("int", "ufd"),
            ("sigset_t *", "user_mask"),
            ("size_t", "sizemask"),
            ("int", "flags"),
        )),
        "sigpending": ("long", (
            ("old_sigset_t *", "set"),
        )),
        "sigprocmask": ("long", (
            ("int", "how"),
            ("old_sigset_t *", "set"),
            ("old_sigset_t *", "oset"),
        )),
        "sigsuspend": ("long", (
            ("int", "unused1"),
            ("int", "unused2"),
            ("old_sigset_t", "mask"),
        )),
        "socket": ("long", (
            ("int", "domain"),
            ("int", "type"),
            ("int", "protocol"),
        )),
        "socketcall": ("long", (
            ("int", "call"),
            ("unsigned long *", "args"),
        )),
        "socketpair": ("long", (
            ("int", "domain"),
            ("int", "type"),
            ("int", "protocol"),
            ("int *", "sv"),
        )),
        "splice": ("long", (
            ("int", "fd_in"),
            ("loff_t *", "off_in"),
            ("int", "fd_out"),
            ("loff_t *", "off_out"),
            ("size_t", "len"),
            ("unsigned int", "flags"),
        )),
        "spu_create": ("long", (
            ("const char *", "name"),
            ("unsigned int", "flags"),
            ("umode_t", "mode"),
            ("int", "fd"),
        )),
        "spu_run": ("long", (
            ("int", "fd"),
            ("__u32 *", "unpc"),
            ("__u32 *", "ustatus"),
        )),
        "ssetmask": ("long", (
            ("int", "newmask"),
        )),
        "stat": ("long", (
            ("const char *", "filename"),
            ("struct __old_kernel_stat *", "statbuf"),
        )),
        "stat64": ("long", (
            ("const char *", "filename"),
            ("struct stat64 *", "statbuf"),
        )),
        "statx": ("long", (
            ("int", "dfd"),
            ("const char *", "path"),
            ("unsigned", "flags"),
            ("unsigned", "mask"),
            ("struct statx *", "buf"),
        )),
        "statfs": ("long", (
            ("const char *", "path"),
            ("struct statfs *", "buf"),
        )),
        "statfs64": ("long", (
            ("const char *", "path"),
            ("size_t", "sz"),
            ("struct statfs64 *", "buf"),
        )),
        "statx": ("long", (
            ("int", "dfd"),
            ("const char *", "path"),
            ("unsigned", "flags"),
            ("unsigned", "mask"),
            ("struct statx *", "buffer"),
        )),
        "stime": ("long", (
            ("old_time_t *", "tptr"),
        )),
        "stime32": ("long", (
            ("old_time32_t *", "tptr"),
        )),
        "swapoff": ("long", (
            ("const char *", "specialfile"),
        )),
        "swapon": ("long", (
            ("const char *", "specialfile"),
            ("int", "swap_flags"),
        )),
        "symlink": ("long", (
            ("const char *", "old"),
            ("const char *", "new"),
        )),
        "symlinkat": ("long", (
            ("const char *", "oldname"),
            ("int", "newdfd"),
            ("const char *", "newname"),
        )),
        "sync": ("long", (
        )),
        "sync_file_range": ("long", (
            ("int", "fd"),
            ("loff_t", "offset"),
            ("loff_t", "nbytes"),
            ("unsigned int", "flags"),
        )),
        "sync_file_range2": ("long", (
            ("int", "fd"),
            ("unsigned int", "flags"),
            ("loff_t", "offset"),
            ("loff_t", "nbytes"),
        )),
        "syncfs": ("long", (
            ("int", "fd"),
        )),
        "sysctl": ("long", (
            ("struct __sysctl_args *", "args"),
        )),
        "sysfs": ("long", (
            ("int", "option"),
            ("unsigned long", "arg1"),
            ("unsigned long", "arg2"),
        )),
        "sysinfo": ("long", (
            ("struct sysinfo *", "info"),
        )),
        "syslog": ("long", (
            ("int", "type"),
            ("char *", "buf"),
            ("int", "len"),
        )),
        "tee": ("long", (
            ("int", "fdin"),
            ("int", "fdout"),
            ("size_t", "len"),
            ("unsigned int", "flags"),
        )),
        "tgkill": ("long", (
            ("int", "tgid"),
            ("int", "pid"),
            ("int", "sig"),
        )),
        "time": ("long", (
            ("old_time_t *", "tloc"),
        )),
        "time32": ("long", (
            ("old_time32_t *", "tloc"),
        )),
        "timer_create": ("long", (
            ("clockid_t", "which_clock"),
            ("struct sigevent *", "timer_event_spec"),
            ("timer_t *", "created_timer_id"),
        )),
        "timer_delete": ("long", (
            ("timer_t", "timer_id"),
        )),
        "timer_getoverrun": ("long", (
            ("timer_t", "timer_id"),
        )),
        "timer_gettime": ("long", (
            ("timer_t", "timer_id"),
            ("struct itimerspec *", "setting"),
        )),
        "timer_gettime32": ("long", (
            ("timer_t", "timer_id"),
            ("struct old_itimerspec32 *", "setting"),
        )),
        "timer_settime": ("long", (
            ("timer_t", "timer_id"),
            ("int", "flags"),
            ("const struct itimerspec *", "new_setting"),
            ("struct itimerspec *", "old_setting"),
        )),
        "timer_settime32": ("long", (
            ("timer_t", "timer_id"),
            ("int", "flags"),
            ("struct old_itimerspec32 *", "new"),
            ("struct old_itimerspec32 *", "old"),
        )),
        "timerfd_create": ("long", (
            ("int", "clockid"),
            ("int", "flags"),
        )),
        "timerfd_gettime": ("long", (
            ("int", "ufd"),
            ("struct itimerspec *", "otmr"),
        )),
        "timerfd_gettime32": ("long", (
            ("int", "ufd"),
            ("struct old_itimerspec32 *", "otmr"),
        )),
        "timerfd_settime": ("long", (
            ("int", "ufd"),
            ("int", "flags"),
            ("const struct itimerspec *", "utmr"),
            ("struct itimerspec *", "otmr"),
        )),
        "timerfd_settime32": ("long", (
            ("int", "ufd"),
            ("int", "flags"),
            ("const struct old_itimerspec32 *", "utmr"),
            ("struct old_itimerspec32 *", "otmr"),
        )),
        "times": ("long", (
            ("struct tms *", "tbuf"),
        )),
        "tkill": ("long", (
            ("int", "pid"),
            ("int", "sig"),
        )),
        "truncate": ("long", (
            ("const char *", "path"),
            ("long", "length"),
        )),
        "truncate64": ("long", (
            ("const char *", "path"),
            ("loff_t", "length"),
        )),
        "umask": ("long", (
            ("int", "mask"),
        )),
        "umount": ("long", (
            ("char *", "name"),
            ("int", "flags"),
        )),
        "uname": ("long", (
            ("struct old_utsname *", "buf"),
        )),
        "unlink": ("long", (
            ("const char *", "pathname"),
        )),
        "unlinkat": ("long", (
            ("int", "dfd"),
            ("const char *", "pathname"),
            ("int", "flag"),
        )),
        "unshare": ("long", (
            ("unsigned long", "unshare_flags"),
        )),
        "uselib": ("long", (
            ("const char *", "library"),
        )),
        "userfaultfd": ("long", (
            ("int", "flags"),
        )),
        "ustat": ("long", (
            ("unsigned", "dev"),
            ("struct ustat *", "ubuf"),
        )),
        "utime": ("long", (
            ("char *", "filename"),
            ("struct utimbuf *", "times"),
        )),
        "utime32": ("long", (
            ("const char *", "filename"),
            ("struct old_utimbuf32 *", "t"),
        )),
        "utimensat": ("long", (
            ("int", "dfd"),
            ("const char *", "filename"),
            ("struct timespec *", "utimes"),
            ("int", "flags"),
        )),
        "utimensat_time32": ("long", (
            ("unsigned int", "dfd"),
            ("const char *", "filename"),
            ("struct old_timespec32 *", "t"),
            ("int", "flags"),
        )),
        "utimes": ("long", (
            ("char *", "filename"),
            ("struct old_timeval *", "utimes"),
        )),
        "utimes_time32": ("long", (
            ("const char *", "filename"),
            ("struct old_timeval32 *", "t"),
        )),
        "vfork": ("long", (
        )),
        "vhangup": ("long", (
        )),
        "vmsplice": ("long", (
            ("int", "fd"),
            ("const struct iovec *", "iov"),
            ("unsigned long", "nr_segs"),
            ("unsigned int", "flags"),
        )),
        "wait4": ("long", (
            ("pid_t", "pid"),
            ("int *", "stat_addr"),
            ("int", "options"),
            ("struct rusage *", "ru"),
        )),
        "waitid": ("long", (
            ("int", "which"),
            ("pid_t", "pid"),
            ("struct siginfo *", "infop"),
            ("int", "options"),
            ("struct rusage *", "ru"),
        )),
        "waitpid": ("long", (
            ("pid_t", "pid"),
            ("int *", "stat_addr"),
            ("int", "options"),
        )),
        "write": ("long", (
            ("unsigned int", "fd"),
            ("const char *", "buf"),
            ("size_t", "count"),
        )),
        "writev": ("long", (
            ("unsigned long", "fd"),
            ("const struct iovec *", "vec"),
            ("unsigned long", "vlen"),
        )),
    }

    '''
    update syscalls from https://github.com/strace/strace/linux/ARCH/syscallent.h
    1. %s/\[.*= //g
    2. %s/{.*),\s*"/\'sys_/g
    3. %s/".*,/\',/g
    4. paste the processed list
    4. call UtilMgr.printSyscalls(ConfigMgr.SYSCALL_X86)
    '''

    # Define common 32bit syscalls from 403 ~ 423 #
    SYSCALL_COMMON32 = [
        'sys_clock_gettime64',
        'sys_clock_settime64',
        'sys_clock_adjtime64',
        'sys_clock_getres_time64',
        'sys_clock_nanosleep_time64',
        'sys_timer_gettime64',
        'sys_timer_settime64',
        'sys_timerfd_gettime64',
        'sys_timerfd_settime64',
        'sys_utimensat_time64',
        'sys_pselect6_time64',
        'sys_ppoll_time64',
        'sys_unused',
        'sys_io_pgetevents_time64',
        'sys_recvmmsg_time64',
        'sys_mq_timedsend_time64',
        'sys_mq_timedreceive_time64',
        'sys_semtimedop_time64',
        'sys_rt_sigtimedwait_time64',
        'sys_futex_time64',
        'sys_sched_rr_get_interval_time64',
    ]

    # Define common syscalls from 424 ~ 435 #
    SYSCALL_COMMON = [
        'sys_pidfd_send_signal',
        'sys_io_uring_setup',
        'sys_io_uring_enter',
        'sys_io_uring_register',
        'sys_open_tree',
        'sys_move_mount',
        'sys_fsopen',
        'sys_fsconfig',
        'sys_fsmount',
        'sys_fspick',
        'sys_pidfd_open',
        'sys_clone3',
    ]

    # Define syscall for ARM #
    SYSCALL_ARM = [
        'sys_restart_syscall', 'sys_exit', 'sys_fork', 'sys_read',
        'sys_write', 'sys_open', 'sys_close', 'sys_waitpid',
        'sys_creat', 'sys_link', 'sys_unlink', 'sys_execve',
        'sys_chdir', 'sys_time', 'sys_mknod', 'sys_chmod',
        'sys_lchown', 'sys_break', 'sys_oldstat', 'sys_lseek',
        'sys_getpid', 'sys_mount', 'sys_umount', 'sys_setuid',
        'sys_getuid', 'sys_stime', 'sys_ptrace', 'sys_alarm',
        'sys_oldfstat', 'sys_pause', 'sys_utime', 'sys_stty',
        'sys_gtty', 'sys_access', 'sys_nice', 'sys_ftime',
        'sys_sync', 'sys_kill', 'sys_rename', 'sys_mkdir',
        'sys_rmdir', 'sys_dup', 'sys_pipe', 'sys_times',
        'sys_prof', 'sys_brk', 'sys_setgid', 'sys_getgid',
        'sys_signal', 'sys_geteuid', 'sys_getegid', 'sys_acct',
        'sys_umount2', 'sys_lock', 'sys_ioctl', 'sys_fcntl',
        'sys_mpx', 'sys_setpgid', 'sys_ulimit', 'sys_oldolduname',
        'sys_umask', 'sys_chroot', 'sys_ustat', 'sys_dup2',
        'sys_getppid', 'sys_getpgrp', 'sys_setsid', 'sys_sigaction',
        'sys_sgetmask', 'sys_ssetmask', 'sys_setreuid', 'sys_setregid',
        'sys_sigsuspend', 'sys_sigpending', 'sys_sethostname', 'sys_setrlimit',
        'sys_getrlimit', 'sys_getrusage', 'sys_gettimeofday', 'sys_settimeofday',
        'sys_getgroups', 'sys_setgroups', 'sys_select', 'sys_symlink',
        'sys_oldlstat', 'sys_readlink', 'sys_uselib', 'sys_swapon',
        'sys_reboot', 'sys_readdir', 'sys_mmap', 'sys_munmap',
        'sys_truncate', 'sys_ftruncate', 'sys_fchmod', 'sys_fchown',
        'sys_getpriority', 'sys_setpriority', 'sys_profil', 'sys_statfs',
        'sys_fstatfs', 'sys_ioperm', 'sys_socketcall', 'sys_syslog',
        'sys_setitimer', 'sys_getitimer', 'sys_stat', 'sys_lstat',
        'sys_fstat', 'sys_olduname', 'sys_iopl', 'sys_vhangup',
        'sys_idle', 'sys_syscall', 'sys_wait4', 'sys_swapoff',
        'sys_sysinfo', 'sys_ipc', 'sys_fsync', 'sys_sigreturn',
        'sys_clone', 'sys_setdomainname', 'sys_uname', 'sys_modify_ldt',
        'sys_adjtimex', 'sys_mprotect', 'sys_sigprocmask', 'sys_create_module',
        'sys_init_module', 'sys_delete_module', 'sys_get_kernel_syms', 'sys_quotactl',
        'sys_getpgid', 'sys_fchdir', 'sys_bdflush', 'sys_sysfs',
        'sys_personality', 'sys_afs_syscall', 'sys_setfsuid', 'sys_setfsgid',
        'sys_llseek', 'sys_getdents', 'sys_newselect', 'sys_flock',
        'sys_msync', 'sys_readv', 'sys_writev', 'sys_getsid',
        'sys_fdatasync', 'sys_sysctl', 'sys_mlock', 'sys_munlock',
        'sys_mlockall', 'sys_munlockall', 'sys_sched_setparam', 'sys_sched_getparam',
        'sys_sched_setscheduler', 'sys_sched_getscheduler', 'sys_sched_yield',
        'sys_sched_get_priority_max',
        'sys_sched_get_priority_min', 'sys_sched_rr_get_interval', 'sys_nanosleep', 'sys_mremap',
        'sys_setresuid', 'sys_getresuid', 'sys_vm86', 'sys_query_module',
        'sys_poll', 'sys_nfsservctl', 'sys_setresgid', 'sys_getresgid',
        'sys_prctl', 'sys_rt_sigreturn', 'sys_rt_sigaction', 'sys_rt_sigprocmask',
        'sys_rt_sigpending', 'sys_rt_sigtimedwait', 'sys_rt_sigqueueinfo', 'sys_rt_sigsuspend',
        'sys_pread64', 'sys_pwrite64', 'sys_chown', 'sys_getcwd',
        'sys_capget', 'sys_capset', 'sys_sigaltstack', 'sys_sendfile',
        'sys_getpmsg', 'sys_putpmsg', 'sys_vfork', 'sys_ugetrlimit',
        'sys_mmap2', 'sys_truncate64', 'sys_ftruncate64', 'sys_stat64',
        'sys_lstat64', 'sys_fstat64', 'sys_lchown32', 'sys_getuid32',
        'sys_getgid32', 'sys_geteuid32', 'sys_getegid32', 'sys_setreuid32',
        'sys_setregid32', 'sys_getgroups32', 'sys_setgroups32', 'sys_fchown32',
        'sys_setresuid32', 'sys_getresuid32', 'sys_setresgid32', 'sys_getresgid32',
        'sys_chown32', 'sys_setuid32', 'sys_setgid32', 'sys_setfsuid32',
        'sys_setfsgid32', 'sys_getdents64', 'sys_pivot_root', 'sys_mincore',
        'sys_madvise', 'sys_fcntl64', 'sys_tux', 'sys_unused',
        'sys_gettid', 'sys_readahead', 'sys_setxattr', 'sys_lsetxattr',
        'sys_fsetxattr', 'sys_getxattr', 'sys_lgetxattr', 'sys_fgetxattr',
        'sys_listxattr', 'sys_llistxattr', 'sys_flistxattr', 'sys_removexattr',
        'sys_lremovexattr', 'sys_fremovexattr', 'sys_tkill', 'sys_sendfile64',
        'sys_futex', 'sys_sched_setaffinity', 'sys_sched_getaffinity', 'sys_io_setup',
        'sys_io_destroy', 'sys_io_getevents', 'sys_io_submit', 'sys_io_cancel',
        'sys_exit_group', 'sys_lookup_dcookie', 'sys_epoll_create', 'sys_epoll_ctl',
        'sys_epoll_wait', 'sys_remap_file_pages', 'sys_set_thread_area', 'sys_get_thread_area',
        'sys_set_tid_address', 'sys_timer_create', 'sys_timer_settime', 'sys_timer_gettime',
        'sys_timer_getoverrun', 'sys_timer_delete', 'sys_clock_settime', 'sys_clock_gettime',
        'sys_clock_getres', 'sys_clock_nanosleep', 'sys_statfs64', 'sys_fstatfs64',
        'sys_tgkill', 'sys_utimes', 'sys_fadvise64_64', 'sys_pciconfig_iobase',
        'sys_pciconfig_read', 'sys_pciconfig_write', 'sys_mq_open', 'sys_mq_unlink',
        'sys_mq_timedsend', 'sys_mq_timedreceive', 'sys_mq_notify', 'sys_mq_getsetattr',
        'sys_waitid', 'sys_socket', 'sys_bind', 'sys_connect',
        'sys_listen', 'sys_accept', 'sys_getsockname', 'sys_getpeername',
        'sys_socketpair', 'sys_send', 'sys_sendto', 'sys_recv',
        'sys_recvfrom', 'sys_shutdown', 'sys_setsockopt', 'sys_getsockopt',
        'sys_sendmsg', 'sys_recvmsg', 'sys_semop', 'sys_semget',
        'sys_semctl', 'sys_msgsnd', 'sys_msgrcv', 'sys_msgget',
        'sys_msgctl', 'sys_shmat', 'sys_shmdt', 'sys_shmget',
        'sys_shmctl', 'sys_add_key', 'sys_request_key', 'sys_keyctl',
        'sys_semtimedop', 'sys_vserver', 'sys_ioprio_set', 'sys_ioprio_get',
        'sys_inotify_init', 'sys_inotify_add_watch', 'sys_inotify_rm_watch', 'sys_mbind',
        'sys_get_mempolicy', 'sys_set_mempolicy', 'sys_openat', 'sys_mkdirat',
        'sys_mknodat', 'sys_fchownat', 'sys_futimesat', 'sys_fstatat64',
        'sys_unlinkat', 'sys_renameat', 'sys_linkat', 'sys_symlinkat',
        'sys_readlinkat', 'sys_fchmodat', 'sys_faccessat', 'sys_pselect6',
        'sys_ppoll', 'sys_unshare', 'sys_set_robust_list', 'sys_get_robust_list',
        'sys_splice', 'sys_sync_file_range2', 'sys_tee', 'sys_vmsplice',
        'sys_move_pages', 'sys_getcpu', 'sys_epoll_pwait', 'sys_kexec_load',
        'sys_utimensat', 'sys_signalfd', 'sys_timerfd_create', 'sys_eventfd',
        'sys_fallocate', 'sys_timerfd_settime', 'sys_timerfd_gettime', 'sys_signalfd4',
        'sys_eventfd2', 'sys_epoll_create1', 'sys_dup3', 'sys_pipe2',
        'sys_inotify_init1', 'sys_preadv', 'sys_pwritev', 'sys_rt_tgsigqueueinfo',
        'sys_perf_event_open', 'sys_recvmmsg', 'sys_accept4', 'sys_fanotify_init',
        'sys_fanotify_mark', 'sys_prlimit64', 'sys_name_to_handle_at', 'sys_open_by_handle_at',
        'sys_clock_adjtime', 'sys_syncfs', 'sys_sendmmsg', 'sys_setns',
        'sys_process_vm_readv', 'sys_process_vm_writev', 'sys_kcmp', 'sys_finit_module',
        'sys_sched_setattr', 'sys_sched_getattr', 'sys_renameat2', 'sys_seccomp',
        'sys_getrandom', 'sys_memfd_create', 'sys_bpf', 'sys_execveat',
        'sys_userfaultfd', 'sys_membarrier', 'sys_mlock2', 'sys_copy_file_range',
        'sys_preadv2', 'sys_pwritev2', 'sys_pkey_mprotect', 'sys_pkey_alloc',
        'sys_pkey_free', 'sys_statx', 'sys_rseq', 'sys_io_pgetevents',
        'sys_migrate_pages', 'sys_kexec_file_load', 'sys_unused',
    ] + SYSCALL_COMMON32 + SYSCALL_COMMON

    # Define syscall for AARCH64 #
    SYSCALL_AARCH64 = [
        'sys_io_setup', 'sys_io_destroy', 'sys_io_submit', 'sys_io_cancel',
        'sys_io_getevents', 'sys_setxattr', 'sys_lsetxattr', 'sys_fsetxattr',
        'sys_getxattr', 'sys_lgetxattr', 'sys_fgetxattr', 'sys_listxattr',
        'sys_llistxattr', 'sys_flistxattr', 'sys_removexattr', 'sys_lremovexattr',
        'sys_fremovexattr', 'sys_getcwd', 'sys_lookup_dcookie', 'sys_eventfd2',
        'sys_epoll_create1', 'sys_epoll_ctl', 'sys_epoll_pwait', 'sys_dup',
        'sys_dup3', 'sys_fcntl', 'sys_inotify_init1', 'sys_inotify_add_watch',
        'sys_inotify_rm_watch', 'sys_ioctl', 'sys_ioprio_set', 'sys_ioprio_get',
        'sys_flock', 'sys_mknodat', 'sys_mkdirat', 'sys_unlinkat',
        'sys_symlinkat', 'sys_linkat', 'sys_renameat', 'sys_umount2',
        'sys_mount', 'sys_pivot_root', 'sys_nfsservctl', 'sys_statfs',
        'sys_fstatfs', 'sys_truncate', 'sys_ftruncate', 'sys_fallocate',
        'sys_faccessat', 'sys_chdir', 'sys_fchdir', 'sys_chroot',
        'sys_fchmod', 'sys_fchmodat', 'sys_fchownat', 'sys_fchown',
        'sys_openat', 'sys_close', 'sys_vhangup', 'sys_pipe2',
        'sys_quotactl', 'sys_getdents64', 'sys_lseek', 'sys_read',
        'sys_write', 'sys_readv', 'sys_writev', 'sys_pread64',
        'sys_pwrite64', 'sys_preadv', 'sys_pwritev', 'sys_sendfile',
        'sys_pselect6', 'sys_ppoll', 'sys_signalfd4', 'sys_vmsplice',
        'sys_splice', 'sys_tee', 'sys_readlinkat', 'sys_newfstatat',
        'sys_fstat', 'sys_sync', 'sys_fsync', 'sys_fdatasync',
        'sys_sync_file_range', 'sys_timerfd_create', 'sys_timerfd_settime', 'sys_timerfd_gettime',
        'sys_utimensat', 'sys_acct', 'sys_capget', 'sys_capset',
        'sys_personality', 'sys_exit', 'sys_exit_group', 'sys_waitid',
        'sys_set_tid_address', 'sys_unshare', 'sys_futex', 'sys_set_robust_list',
        'sys_get_robust_list', 'sys_nanosleep', 'sys_getitimer', 'sys_setitimer',
        'sys_kexec_load', 'sys_init_module', 'sys_delete_module', 'sys_timer_create',
        'sys_timer_gettime', 'sys_timer_getoverrun', 'sys_timer_settime', 'sys_timer_delete',
        'sys_clock_settime', 'sys_clock_gettime', 'sys_clock_getres', 'sys_clock_nanosleep',
        'sys_syslog', 'sys_ptrace', 'sys_sched_setparam', 'sys_sched_setscheduler',
        'sys_sched_getscheduler', 'sys_sched_getparam', 'sys_sched_setaffinity',
        'sys_sched_getaffinity',
        'sys_sched_yield', 'sys_sched_get_priority_max', 'sys_sched_get_priority_min',
        'sys_sched_rr_get_interval',
        'sys_restart_syscall', 'sys_kill', 'sys_tkill', 'sys_tgkill',
        'sys_sigaltstack', 'sys_rt_sigsuspend', 'sys_rt_sigaction', 'sys_rt_sigprocmask',
        'sys_rt_sigpending', 'sys_rt_sigtimedwait', 'sys_rt_sigqueueinfo', 'sys_rt_sigreturn',
        'sys_setpriority', 'sys_getpriority', 'sys_reboot', 'sys_setregid',
        'sys_setgid', 'sys_setreuid', 'sys_setuid', 'sys_setresuid',
        'sys_getresuid', 'sys_setresgid', 'sys_getresgid', 'sys_setfsuid',
        'sys_setfsgid', 'sys_times', 'sys_setpgid', 'sys_getpgid',
        'sys_getsid', 'sys_setsid', 'sys_getgroups', 'sys_setgroups',
        'sys_uname', 'sys_sethostname', 'sys_setdomainname', 'sys_getrlimit',
        'sys_setrlimit', 'sys_getrusage', 'sys_umask', 'sys_prctl',
        'sys_getcpu', 'sys_gettimeofday', 'sys_settimeofday', 'sys_adjtimex',
        'sys_getpid', 'sys_getppid', 'sys_getuid', 'sys_geteuid',
        'sys_getgid', 'sys_getegid', 'sys_gettid', 'sys_sysinfo',
        'sys_mq_open', 'sys_mq_unlink', 'sys_mq_timedsend', 'sys_mq_timedreceive',
        'sys_mq_notify', 'sys_mq_getsetattr', 'sys_msgget', 'sys_msgctl',
        'sys_msgrcv', 'sys_msgsnd', 'sys_semget', 'sys_semctl',
        'sys_semtimedop', 'sys_semop', 'sys_shmget', 'sys_shmctl',
        'sys_shmat', 'sys_shmdt', 'sys_socket', 'sys_socketpair',
        'sys_bind', 'sys_listen', 'sys_accept', 'sys_connect',
        'sys_getsockname', 'sys_getpeername', 'sys_sendto', 'sys_recvfrom',
        'sys_setsockopt', 'sys_getsockopt', 'sys_shutdown', 'sys_sendmsg',
        'sys_recvmsg', 'sys_readahead', 'sys_brk', 'sys_munmap',
        'sys_mremap', 'sys_add_key', 'sys_request_key', 'sys_keyctl',
        'sys_clone', 'sys_execve', 'sys_mmap', 'sys_fadvise64',
        'sys_swapon', 'sys_swapoff', 'sys_mprotect', 'sys_msync',
        'sys_mlock', 'sys_munlock', 'sys_mlockall', 'sys_munlockall',
        'sys_mincore', 'sys_madvise', 'sys_remap_file_pages', 'sys_mbind',
        'sys_get_mempolicy', 'sys_set_mempolicy', 'sys_migrate_pages', 'sys_move_pages',
        'sys_rt_tgsigqueueinfo', 'sys_perf_event_open', 'sys_accept4', 'sys_recvmmsg',
        'sys_reserved', 'sys_reserved', 'sys_reserved', 'sys_reserved',
        'sys_reserved', 'sys_reserved', 'sys_reserved', 'sys_reserved',
        'sys_reserved', 'sys_reserved', 'sys_reserved', 'sys_reserved',
        'sys_reserved', 'sys_reserved', 'sys_reserved', 'sys_reserved',
        'sys_wait4', 'sys_prlimit64', 'sys_fanotify_init', 'sys_fanotify_mark',
        'sys_name_to_handle_at', 'sys_open_by_handle_at', 'sys_clock_adjtime', 'sys_syncfs',
        'sys_setns', 'sys_sendmmsg', 'sys_process_vm_readv', 'sys_process_vm_writev',
        'sys_kcmp', 'sys_finit_module', 'sys_sched_setattr', 'sys_sched_getattr',
        'sys_renameat2', 'sys_seccomp', 'sys_getrandom', 'sys_memfd_create',
        'sys_bpf', 'sys_execveat', 'sys_userfaultfd', 'sys_membarrier',
        'sys_mlock2', 'sys_copy_file_range', 'sys_preadv2', 'sys_pwritev2',
        'sys_pkey_mprotect', 'sys_pkey_alloc', 'sys_pkey_free', 'sys_statx',
        'sys_io_pgetevents', 'sys_rseq', 'sys_kexec_file_load',
    ] + ['sys_null' for idx in range(295, 423, 1)] + SYSCALL_COMMON + \
        ['close_range', 'openat2', 'pidfd_getfd', 'pidfd_getfd', 'faccessat2']

    # Define syscall for x86 #
    SYSCALL_X86 = [
        'sys_restart_syscall', 'sys_exit', 'sys_fork', 'sys_read',
        'sys_write', 'sys_open', 'sys_close', 'sys_waitpid',
        'sys_creat', 'sys_link', 'sys_unlink', 'sys_execve',
        'sys_chdir', 'sys_time', 'sys_mknod', 'sys_chmod',
        'sys_lchown', 'sys_break', 'sys_oldstat', 'sys_lseek',
        'sys_getpid', 'sys_mount', 'sys_umount', 'sys_setuid',
        'sys_getuid', 'sys_stime', 'sys_ptrace', 'sys_alarm',
        'sys_oldfstat', 'sys_pause', 'sys_utime', 'sys_stty',
        'sys_gtty', 'sys_access', 'sys_nice', 'sys_ftime',
        'sys_sync', 'sys_kill', 'sys_rename', 'sys_mkdir',
        'sys_rmdir', 'sys_dup', 'sys_pipe', 'sys_times',
        'sys_prof', 'sys_brk', 'sys_setgid', 'sys_getgid',
        'sys_signal', 'sys_geteuid', 'sys_getegid', 'sys_acct',
        'sys_umount2', 'sys_lock', 'sys_ioctl', 'sys_fcntl',
        'sys_mpx', 'sys_setpgid', 'sys_ulimit', 'sys_oldolduname',
        'sys_umask', 'sys_chroot', 'sys_ustat', 'sys_dup2',
        'sys_getppid', 'sys_getpgrp', 'sys_setsid', 'sys_sigaction',
        'sys_sgetmask', 'sys_ssetmask', 'sys_setreuid', 'sys_setregid',
        'sys_sigsuspend', 'sys_sigpending', 'sys_sethostname', 'sys_setrlimit',
        'sys_getrlimit', 'sys_getrusage', 'sys_gettimeofday', 'sys_settimeofday',
        'sys_getgroups', 'sys_setgroups', 'sys_select', 'sys_symlink',
        'sys_oldlstat', 'sys_readlink', 'sys_uselib', 'sys_swapon',
        'sys_reboot', 'sys_readdir', 'sys_mmap', 'sys_munmap',
        'sys_truncate', 'sys_ftruncate', 'sys_fchmod', 'sys_fchown',
        'sys_getpriority', 'sys_setpriority', 'sys_profil', 'sys_statfs',
        'sys_fstatfs', 'sys_ioperm', 'sys_socketcall', 'sys_syslog',
        'sys_setitimer', 'sys_getitimer', 'sys_stat', 'sys_lstat',
        'sys_fstat', 'sys_olduname', 'sys_iopl', 'sys_vhangup',
        'sys_idle', 'sys_vm86old', 'sys_wait4', 'sys_swapoff',
        'sys_sysinfo', 'sys_ipc', 'sys_fsync', 'sys_sigreturn',
        'sys_clone', 'sys_setdomainname', 'sys_uname', 'sys_modify_ldt',
        'sys_adjtimex', 'sys_mprotect', 'sys_sigprocmask', 'sys_create_module',
        'sys_init_module', 'sys_delete_module', 'sys_get_kernel_syms', 'sys_quotactl',
        'sys_getpgid', 'sys_fchdir', 'sys_bdflush', 'sys_sysfs',
        'sys_personality', 'sys_afs_syscall', 'sys_setfsuid', 'sys_setfsgid',
        'sys_llseek', 'sys_getdents', 'sys_newselect', 'sys_flock',
        'sys_msync', 'sys_readv', 'sys_writev', 'sys_getsid',
        'sys_fdatasync', 'sys_sysctl', 'sys_mlock', 'sys_munlock',
        'sys_mlockall', 'sys_munlockall', 'sys_sched_setparam', 'sys_sched_getparam',
        'sys_sched_setscheduler', 'sys_sched_getscheduler', 'sys_sched_yield',
        'sys_sched_get_priority_max',
        'sys_sched_get_priority_min', 'sys_sched_rr_get_interval', 'sys_nanosleep', 'sys_mremap',
        'sys_setresuid', 'sys_getresuid', 'sys_vm86', 'sys_query_module',
        'sys_poll', 'sys_nfsservctl', 'sys_setresgid', 'sys_getresgid',
        'sys_prctl', 'sys_rt_sigreturn', 'sys_rt_sigaction', 'sys_rt_sigprocmask',
        'sys_rt_sigpending', 'sys_rt_sigtimedwait', 'sys_rt_sigqueueinfo', 'sys_rt_sigsuspend',
        'sys_pread64', 'sys_pwrite64', 'sys_chown', 'sys_getcwd',
        'sys_capget', 'sys_capset', 'sys_sigaltstack', 'sys_sendfile',
        'sys_getpmsg', 'sys_putpmsg', 'sys_vfork', 'sys_ugetrlimit',
        'sys_mmap2', 'sys_truncate64', 'sys_ftruncate64', 'sys_stat64',
        'sys_lstat64', 'sys_fstat64', 'sys_lchown32', 'sys_getuid32',
        'sys_getgid32', 'sys_geteuid32', 'sys_getegid32', 'sys_setreuid32',
        'sys_setregid32', 'sys_getgroups32', 'sys_setgroups32', 'sys_fchown32',
        'sys_setresuid32', 'sys_getresuid32', 'sys_setresgid32', 'sys_getresgid32',
        'sys_chown32', 'sys_setuid32', 'sys_setgid32', 'sys_setfsuid32',
        'sys_setfsgid32', 'sys_pivot_root', 'sys_mincore', 'sys_madvise',
        'sys_getdents64', 'sys_fcntl64', 'sys_null', 'sys_null',
        'sys_gettid', 'sys_readahead', 'sys_setxattr', 'sys_lsetxattr',
        'sys_fsetxattr', 'sys_getxattr', 'sys_lgetxattr', 'sys_fgetxattr',
        'sys_listxattr', 'sys_llistxattr', 'sys_flistxattr', 'sys_removexattr',
        'sys_lremovexattr', 'sys_fremovexattr', 'sys_tkill', 'sys_sendfile64',
        'sys_futex', 'sys_sched_setaffinity', 'sys_sched_getaffinity', 'sys_set_thread_area',
        'sys_get_thread_area', 'sys_io_setup', 'sys_io_destroy', 'sys_io_getevents',
        'sys_io_submit', 'sys_io_cancel', 'sys_fadvise64', 'sys_set_zone_reclaim',
        'sys_exit_group', 'sys_lookup_dcookie', 'sys_epoll_create', 'sys_epoll_ctl',
        'sys_epoll_wait', 'sys_remap_file_pages', 'sys_set_tid_address', 'sys_timer_create',
        'sys_timer_settime', 'sys_timer_gettime', 'sys_timer_getoverrun', 'sys_timer_delete',
        'sys_clock_settime', 'sys_clock_gettime', 'sys_clock_getres', 'sys_clock_nanosleep',
        'sys_statfs64', 'sys_fstatfs64', 'sys_tgkill', 'sys_utimes',
        'sys_fadvise64_64', 'sys_vserver', 'sys_mbind', 'sys_get_mempolicy',
        'sys_set_mempolicy', 'sys_mq_open', 'sys_mq_unlink', 'sys_mq_timedsend',
        'sys_mq_timedreceive', 'sys_mq_notify', 'sys_mq_getsetattr', 'sys_kexec_load',
        'sys_waitid', 'sys_setaltroot', 'sys_add_key', 'sys_request_key',
        'sys_keyctl', 'sys_ioprio_set', 'sys_ioprio_get', 'sys_inotify_init',
        'sys_inotify_add_watch', 'sys_inotify_rm_watch', 'sys_migrate_pages', 'sys_openat',
        'sys_mkdirat', 'sys_mknodat', 'sys_fchownat', 'sys_futimesat',
        'sys_fstatat64', 'sys_unlinkat', 'sys_renameat', 'sys_linkat',
        'sys_symlinkat', 'sys_readlinkat', 'sys_fchmodat', 'sys_faccessat',
        'sys_pselect6', 'sys_ppoll', 'sys_unshare', 'sys_set_robust_list',
        'sys_get_robust_list', 'sys_splice', 'sys_sync_file_range', 'sys_tee',
        'sys_vmsplice', 'sys_move_pages', 'sys_getcpu', 'sys_epoll_pwait',
        'sys_utimensat', 'sys_signalfd', 'sys_timerfd_create', 'sys_eventfd',
        'sys_fallocate', 'sys_timerfd_settime', 'sys_timerfd_gettime', 'sys_signalfd4',
        'sys_eventfd2', 'sys_epoll_create1', 'sys_dup3', 'sys_pipe2',
        'sys_inotify_init1', 'sys_preadv', 'sys_pwritev', 'sys_rt_tgsigqueueinfo',
        'sys_perf_event_open', 'sys_recvmmsg', 'sys_fanotify_init', 'sys_fanotify_mark',
        'sys_prlimit64', 'sys_name_to_handle_at', 'sys_open_by_handle_at', 'sys_clock_adjtime',
        'sys_syncfs', 'sys_sendmmsg', 'sys_setns', 'sys_process_vm_readv',
        'sys_process_vm_writev', 'sys_kcmp', 'sys_finit_module', 'sys_sched_setattr',
        'sys_sched_getattr', 'sys_renameat2', 'sys_seccomp', 'sys_getrandom',
        'sys_memfd_create', 'sys_bpf', 'sys_execveat', 'sys_socket',
        'sys_socketpair', 'sys_bind', 'sys_connect', 'sys_listen',
        'sys_accept4', 'sys_getsockopt', 'sys_setsockopt', 'sys_getsockname',
        'sys_getpeername', 'sys_sendto', 'sys_sendmsg', 'sys_recvfrom',
        'sys_recvmsg', 'sys_shutdown', 'sys_userfaultfd', 'sys_membarrier',
        'sys_mlock2', 'sys_copy_file_range', 'sys_preadv2', 'sys_pwritev2',
        'sys_pkey_mprotect', 'sys_pkey_alloc', 'sys_pkey_free', 'sys_statx',
        'sys_arch_prctl', 'sys_io_pgetevents', 'sys_rseq', 'sys_reserved',
        'sys_reserved', 'sys_reserved', 'sys_reserved', 'sys_reserved',
        'sys_reserved', 'sys_semget', 'sys_semctl', 'sys_shmget',
        'sys_shmctl', 'sys_shmat', 'sys_shmdt', 'sys_msgget',
        'sys_msgsnd', 'sys_msgrcv', 'sys_msgctl',
    ] + SYSCALL_COMMON32 + SYSCALL_COMMON

    # Define syscall for x86_64 #
    SYSCALL_X64 = [
        'sys_read', 'sys_write', 'sys_open', 'sys_close',
        'sys_stat', 'sys_fstat', 'sys_lstat', 'sys_poll',
        'sys_lseek', 'sys_mmap', 'sys_mprotect', 'sys_munmap',
        'sys_brk', 'sys_rt_sigaction', 'sys_rt_sigprocmask', 'sys_rt_sigreturn',
        'sys_ioctl', 'sys_pread64', 'sys_pwrite64', 'sys_readv',
        'sys_writev', 'sys_access', 'sys_pipe', 'sys_select',
        'sys_sched_yield', 'sys_mremap', 'sys_msync', 'sys_mincore',
        'sys_madvise', 'sys_shmget', 'sys_shmat', 'sys_shmctl',
        'sys_dup', 'sys_dup2', 'sys_pause', 'sys_nanosleep',
        'sys_getitimer', 'sys_alarm', 'sys_setitimer', 'sys_getpid',
        'sys_sendfile', 'sys_socket', 'sys_connect', 'sys_accept',
        'sys_sendto', 'sys_recvfrom', 'sys_sendmsg', 'sys_recvmsg',
        'sys_shutdown', 'sys_bind', 'sys_listen', 'sys_getsockname',
        'sys_getpeername', 'sys_socketpair', 'sys_setsockopt', 'sys_getsockopt',
        'sys_clone', 'sys_fork', 'sys_vfork', 'sys_execve',
        'sys_exit', 'sys_wait4', 'sys_kill', 'sys_uname',
        'sys_semget', 'sys_semop', 'sys_semctl', 'sys_shmdt',
        'sys_msgget', 'sys_msgsnd', 'sys_msgrcv', 'sys_msgctl',
        'sys_fcntl', 'sys_flock', 'sys_fsync', 'sys_fdatasync',
        'sys_truncate', 'sys_ftruncate', 'sys_getdents', 'sys_getcwd',
        'sys_chdir', 'sys_fchdir', 'sys_rename', 'sys_mkdir',
        'sys_rmdir', 'sys_creat', 'sys_link', 'sys_unlink',
        'sys_symlink', 'sys_readlink', 'sys_chmod', 'sys_fchmod',
        'sys_chown', 'sys_fchown', 'sys_lchown', 'sys_umask',
        'sys_gettimeofday', 'sys_getrlimit', 'sys_getrusage', 'sys_sysinfo',
        'sys_times', 'sys_ptrace', 'sys_getuid', 'sys_syslog',
        'sys_getgid', 'sys_setuid', 'sys_setgid', 'sys_geteuid',
        'sys_getegid', 'sys_setpgid', 'sys_getppid', 'sys_getpgrp',
        'sys_setsid', 'sys_setreuid', 'sys_setregid', 'sys_getgroups',
        'sys_setgroups', 'sys_setresuid', 'sys_getresuid', 'sys_setresgid',
        'sys_getresgid', 'sys_getpgid', 'sys_setfsuid', 'sys_setfsgid',
        'sys_getsid', 'sys_capget', 'sys_capset', 'sys_rt_sigpending',
        'sys_rt_sigtimedwait', 'sys_rt_sigqueueinfo', 'sys_rt_sigsuspend', 'sys_sigaltstack',
        'sys_utime', 'sys_mknod', 'sys_uselib', 'sys_personality',
        'sys_ustat', 'sys_statfs', 'sys_fstatfs', 'sys_sysfs',
        'sys_getpriority', 'sys_setpriority', 'sys_sched_setparam', 'sys_sched_getparam',
        'sys_sched_setscheduler', 'sys_sched_getscheduler', 'sys_sched_get_priority_max',
        'sys_sched_get_priority_min',
        'sys_sched_rr_get_interval', 'sys_mlock', 'sys_munlock', 'sys_mlockall',
        'sys_munlockall', 'sys_vhangup', 'sys_modify_ldt', 'sys_pivot_root',
        'sys_sysctl', 'sys_prctl', 'sys_arch_prctl', 'sys_adjtimex',
        'sys_setrlimit', 'sys_chroot', 'sys_sync', 'sys_acct',
        'sys_settimeofday', 'sys_mount', 'sys_umount2', 'sys_swapon',
        'sys_swapoff', 'sys_reboot', 'sys_sethostname', 'sys_setdomainname',
        'sys_iopl', 'sys_ioperm', 'sys_create_module', 'sys_init_module',
        'sys_delete_module', 'sys_get_kernel_syms', 'sys_query_module', 'sys_quotactl',
        'sys_nfsservctl', 'sys_getpmsg', 'sys_putpmsg', 'sys_afs_syscall',
        'sys_tuxcall', 'sys_security', 'sys_gettid', 'sys_readahead',
        'sys_setxattr', 'sys_lsetxattr', 'sys_fsetxattr', 'sys_getxattr',
        'sys_lgetxattr', 'sys_fgetxattr', 'sys_listxattr', 'sys_llistxattr',
        'sys_flistxattr', 'sys_removexattr', 'sys_lremovexattr', 'sys_fremovexattr',
        'sys_tkill', 'sys_time', 'sys_futex', 'sys_sched_setaffinity',
        'sys_sched_getaffinity', 'sys_set_thread_area', 'sys_io_setup', 'sys_io_destroy',
        'sys_io_getevents', 'sys_io_submit', 'sys_io_cancel', 'sys_get_thread_area',
        'sys_lookup_dcookie', 'sys_epoll_create', 'sys_epoll_ctl_old', 'sys_epoll_wait_old',
        'sys_remap_file_pages', 'sys_getdents64', 'sys_set_tid_address', 'sys_restart_syscall',
        'sys_semtimedop', 'sys_fadvise64', 'sys_timer_create', 'sys_timer_settime',
        'sys_timer_gettime', 'sys_timer_getoverrun', 'sys_timer_delete', 'sys_clock_settime',
        'sys_clock_gettime', 'sys_clock_getres', 'sys_clock_nanosleep', 'sys_exit_group',
        'sys_epoll_wait', 'sys_epoll_ctl', 'sys_tgkill', 'sys_utimes',
        'sys_vserver', 'sys_mbind', 'sys_set_mempolicy', 'sys_get_mempolicy',
        'sys_mq_open', 'sys_mq_unlink', 'sys_mq_timedsend', 'sys_mq_timedreceive',
        'sys_mq_notify', 'sys_mq_getsetattr', 'sys_kexec_load', 'sys_waitid',
        'sys_add_key', 'sys_request_key', 'sys_keyctl', 'sys_ioprio_set',
        'sys_ioprio_get', 'sys_inotify_init', 'sys_inotify_add_watch', 'sys_inotify_rm_watch',
        'sys_migrate_pages', 'sys_openat', 'sys_mkdirat', 'sys_mknodat',
        'sys_fchownat', 'sys_futimesat', 'sys_newfstatat', 'sys_unlinkat',
        'sys_renameat', 'sys_linkat', 'sys_symlinkat', 'sys_readlinkat',
        'sys_fchmodat', 'sys_faccessat', 'sys_pselect6', 'sys_ppoll',
        'sys_unshare', 'sys_set_robust_list', 'sys_get_robust_list', 'sys_splice',
        'sys_tee', 'sys_sync_file_range', 'sys_vmsplice', 'sys_move_pages',
        'sys_utimensat', 'sys_epoll_pwait', 'sys_signalfd', 'sys_timerfd_create',
        'sys_eventfd', 'sys_fallocate', 'sys_timerfd_settime', 'sys_timerfd_gettime',
        'sys_accept4', 'sys_signalfd4', 'sys_eventfd2', 'sys_epoll_create1',
        'sys_dup3', 'sys_pipe2', 'sys_inotify_init1', 'sys_preadv',
        'sys_pwritev', 'sys_rt_tgsigqueueinfo', 'sys_perf_event_open', 'sys_recvmmsg',
        'sys_fanotify_init', 'sys_fanotify_mark', 'sys_prlimit64', 'sys_name_to_handle_at',
        'sys_open_by_handle_at', 'sys_clock_adjtime', 'sys_syncfs', 'sys_sendmmsg',
        'sys_setns', 'sys_getcpu', 'sys_process_vm_readv', 'sys_process_vm_writev',
        'sys_kcmp', 'sys_finit_module', 'sys_sched_setattr', 'sys_sched_getattr',
        'sys_renameat2', 'sys_seccomp', 'sys_getrandom', 'sys_memfd_create',
        'sys_kexec_file_load', 'sys_bpf', 'sys_execveat', 'sys_userfaultfd',
        'sys_membarrier', 'sys_mlock2', 'sys_copy_file_range', 'sys_preadv2',
        'sys_pwritev2', 'sys_pkey_mprotect', 'sys_pkey_alloc', 'sys_pkey_free',
        'sys_statx', 'sys_io_pgetevents', 'sys_rseq',
    ] + ['sys_null' for idx in range(335, 423, 1)] + SYSCALL_COMMON

    # Define default syscall list #
    sysList = []

    # Define default register list #
    regList = []

    # Define registers by number sequence #
    REGS_X86 = [
        'eax', 'ecx', 'edx', 'ebx', 'esp', 'ebp', 'esi', 'edi',
        'eip', 'eflags', '<none>', 'st0', 'st1', 'st2', 'st3', 'st4',
        'st5', 'st6', 'st7', '<none>', '<none>', 'xmm0', 'xmm1', 'xmm2',
        'xmm3', 'xmm4', 'xmm5', 'xmm6', 'xmm7', 'mm0', 'mm1', 'mm2',
        'mm3', 'mm4', 'mm5', 'mm6', 'mm7', 'fcw', 'fsw', 'mxcsr',
        'es', 'cs', 'ss', 'ds', 'fs', 'gs', '<none>', '<none>', 'tr', 'ldtr'
    ]

    REGS_X64 = [
        'rax', 'rdx', 'rcx', 'rbx', 'rsi', 'rdi', 'rbp', 'rsp',
        'r8',  'r9',  'r10', 'r11', 'r12', 'r13', 'r14', 'r15',
        'rip', 'xmm0',  'xmm1',  'xmm2',  'xmm3', 'xmm4', 'xmm5', 'xmm6',
        'xmm7', 'xmm8', 'xmm9', 'xmm10', 'xmm11', 'xmm12', 'xmm13', 'xmm14',
        'xmm15', 'st0', 'st1', 'st2', 'st3', 'st4', 'st5', 'st6',
        'st7', 'mm0', 'mm1', 'mm2', 'mm3', 'mm4', 'mm5', 'mm6',
        'mm7', 'rflags', 'es', 'cs', 'ss', 'ds', 'fs', 'gs',
        '<none>', '<none>', 'fs.base', 'gs.base', '<none>', '<none>',
        'tr', 'ldtr', 'mxcsr', 'fcw', 'fsw'
    ]

    REGS_ARM = ['r%d' % idx for idx in range(0, 16, 1)]

    REGS_AARCH64 = \
        ['x%d' % idx for idx in range(0, 31, 1)] + \
        ['sp', 'pc', 'ELP_mode', 'RA_SIGN_STATE', '<none>', '<none>'] + \
        ['reserved' for idx in range(37, 46, 1)] + \
        ['VG', 'FFR'] + ['p%d' % idx for idx in range(0, 16, 1)] + \
        ['v%d' % idx for idx in range(0, 32, 1)] + \
        ['z%d' % idx for idx in range(0, 32, 1)]

    pcRegIndex = {
        'arm': REGS_ARM.index('r14'),
        'aarch64': REGS_AARCH64.index('pc'),
        'x86': REGS_X86.index('eip'),
        'x64': REGS_X64.index('rip'),
    }

    # Define syscall register #
    SYSREG_LIST = {
        "powerpc": "gpr0",
        "arm": "r7",
        "aarch64": "x8",
        "x64": "orig_rax",
        "x86": "orig_eax"
    }

    # Define return register #
    RET_LIST = {
        "powerpc": "result",
        "arm": "r0",
        "aarch64": "x0",
        "x64": "rax",
        "x86": "eax"
    }

    # Define signal #
    SIG_LIST = [
        'ZERO', 'SIGHUP', 'SIGINT', 'SIGQUIT', 'SIGILL', #4#
        'SIGTRAP', 'SIGABRT', 'SIGBUS', 'SIGFPE', #8#
        'SIGKILL', 'SIGUSR1', 'SIGSEGV', 'SIGUSR2', #12#
        'SIGPIPE', 'SIGALRM', 'SIGTERM', 'SIGSTKFLT', #16#
        'SIGCHLD', 'SIGCONT', 'SIGSTOP', 'SIGTSTP', #20#
        'SIGTTIN', 'SIGTTOU', 'SIGURG', 'SIGXCPU', #24#
        'SIGXFSZ', 'SIGVTALRM', 'SIGPROF', 'SIGWINCH', #28#
        'SIGIO', 'SIGPWR', 'SIGSYS', 'NONE', 'NONE'] + \
        ['SIGRT%d' % idx for idx in range(0, 32, 1)]
    SIGKILL = SIG_LIST.index('SIGKILL')

    # stat list from http://linux.die.net/man/5/proc #
    STAT_ATTR = [
        'PID', 'COMM', 'STATE', 'PPID', 'PGRP', 'SESSIONID', #5#
        'NRTTY', 'TPGID', 'FLAGS', 'MINFLT', 'CMINFLT', #10#
        'MAJFLT', 'CMAJFLT', 'UTIME', 'STIME', 'CUTIME', #15#
        'CSTIME', 'PRIORITY', 'NICE', 'NRTHREAD', 'ITERALVAL', #20#
        'STARTTIME', 'VSIZE', 'RSS', 'RSSLIM', 'STARTCODE', #25#
        'ENDCODE', 'STARTSTACK', 'SP', 'PC', 'SIGNAL', #30#
        'BLOCKED', 'SIGIGNORE', 'SIGCATCH', 'WCHEN', 'NSWAP', #35#
        'CNSWAP', 'EXITSIGNAL', 'PROCESSOR', 'RTPRIORITY', #39#
        'POLICY', 'DELAYBLKTICK', 'GUESTTIME', 'CGUESTTIME' #43#
        'STARTDATA', 'ENDDATA', 'STARTBRK', 'ARGSTART', 'ARGEND', #48#
        'ENVSTART', 'ENVEND', 'EXITCODE', #51#
    ]

    SCHED_POLICY = [
        'C', # 0: CFS #
        'F', # 1: FIFO #
        'R', # 2: RR #
        'B', # 3: BATCH #
        'N', # 4: NONE #
        'I', # 5: IDLE #
        'D', # 6: DEADLINE #
    ]

    # Define statm of process #
    STATM_TYPE = [
        'TOTAL',    # 0 #
        'RSS',      # 1 #
        'SHR',      # 2 #
        'TEXT',     # 3 #
        'DATA',     # 4 #
        'LIB',      # 5 #
        'DIRTY',    # 6 #
    ]

    ERR_TYPE = [
        'EPERM',            # Operation not permitted #
        'ENOENT',           # No such file or directory #
        'ESRCH',            # No such process #
        'EINTR',            # Interrupted system call #
        'EIO',              # I/O error #
        'ENXIO',            # No such device or address #
        'E2BIG',            # Argument list too long #
        'ENOEXEC',          # Exec format error #
        'EBADF',            # Bad file number #
        'ECHILD',           # No child processes #
        'EAGAIN',           # Try again #
        'ENOMEM',           # Out of memory #
        'EACCES',           # Permission denied #
        'EFAULT',           # Bad address #
        'ENOTBLK',          # Block device required #
        'EBUSY',            # Device or resource busy #
        'EEXIST',           # File exists #
        'EXDEV',            # Cross-device link #
        'ENODEV',           # No such device #
        'ENOTDIR',          # Not a directory #
        'EISDIR',           # Is a directory #
        'EINVAL',           # Invalid argument #
        'ENFILE',           # File table overflow #
        'EMFILE',           # Too many open files #
        'ENOTTY',           # Not a typewriter #
        'ETXTBSY',          # Text file busy #
        'EFBIG',            # File too large #
        'ENOSPC',           # No space left on device #
        'ESPIPE',           # Illegal seek #
        'EROFS',            # Read-only file system #
        'EMLINK',           # Too many links #
        'EPIPE',            # Broken pipe #
        'EDOM',             # Math argument out of domain of func #
        'ERANGE',           # Math result not representable #
        'EDEADLK',          # Resource deadlock would occur #
        'ENAMETOOLONG',     # File name too long #
        'ENOLCK',           # No record locks available #
        'ENOSYS',           # Function not implemented #
        'ENOTEMPTY',        # Directory not empty #
        'ELOOP',            # Too many symbolic links encountered #
        'EWOULDBLOCK',      # Operation would block #
        'ENOMSG',           # No message of desired type #
        'EIDRM',            # Identifier removed #
        'ECHRNG',           # Channel number out of range #
        'EL2NSYNC',         # Level 2 not synchronized #
        'EL3HLT',           # Level 3 halted #
        'EL3RST',           # Level 3 reset #
        'ELNRNG',           # Link number out of range #
        'EUNATCH',          # Protocol driver not attached #
        'ENOCSI',           # No CSI structure available #
        'EL2HLT',           # Level 2 halted #
        'EBADE',            # Invalid exchange #
        'EBADR',            # Invalid request descriptor #
        'EXFULL',           # Exchange full #
        'ENOANO',           # No anode #
        'EBADRQC',          # Invalid request code #
        'EBADSLT ',         # Invalid slot #
        'EDEADLOCK',
        'EBFONT',           # Bad font file format #
        'ENOSTR',           # Device not a stream #
        'ENODATA',          # No data available #
        'ETIME',            # Timer expired #
        'ENOSR',            # Out of streams resources #
        'ENONET',           # Machine is not on the network #
        'ENOPKG',           # Package not installed #
        'EREMOTE',          # Object is remote #
        'ENOLINK',          # Link has been severed #
        'EADV',             # Advertise error #
        'ESRMNT',           # Srmount error #
        'ECOMM',            # Communication error on send #
        'EPROTO',           # Protocol error #
        'EMULTIHOP',        # Multihop attempted #
        'EDOTDOT',          # RFS specific error #
        'EBADMSG',          # Not a data message #
        'EOVERFLOW',        # Value too large for defined data type #
        'ENOTUNIQ',         # Name not unique on network #
        'EBADFD',           # File descriptor in bad state #
        'EREMCHG',          # Remote address changed #
        'ELIBACC',          # Can not access a needed shared library #
        'ELIBBAD',          # Accessing a corrupted shared library #
        'ELIBSCN',          # .lib section in a.out corrupted #
        'ELIBMAX',          # Attempting to link in too many shared libraries #
        'ELIBEXEC',         # Cannot exec a shared library directly #
        'EILSEQ',           # Illegal byte sequence #
        'ERESTART',         # Interrupted system call should be restarted #
        'ESTRPIPE',         # Streams pipe error #
        'EUSERS',           # Too many users #
        'ENOTSOCK',         # Socket operation on non-socket #
        'EDESTADDRREQ',     # Destination address required #
        'EMSGSIZE',         # Message too long #
        'EPROTOTYPE',       # Protocol wrong type for socket #
        'EPROTOTYPE',       # Protocol wrong type for socket #
        'ENOPROTOOPT',      # Protocol not available #
        'EPROTONOSUPPORT',  # Protocol not supported #
        'ESOCKTNOSUPPORT',  # Socket type not supported #
        'EOPNOTSUPP',       # Operation not supported on transport endpoint #
        'EPFNOSUPPORT',     # Protocol family not supported #
        'EAFNOSUPPORT ',    # Address family not supported by protocol #
        'EADDRINUSE ',      # Address already in use #
        'EADDRNOTAVAIL',    # Cannot assign requested address #
        'ENETDOWN',         # Network is down #
        'ENETUNREACH',      # Network is unreachable #
        'ENETRESET',        # Network dropped connection because of reset #
        'ECONNABORTED',     # Software caused connection abort #
        'ECONNRESET',       # Connection reset by peer #
        'ENOBUFS',          # No buffer space available #
        'EISCONN',          # Transport endpoint is already connected #
        'ENOTCONN',         # Transport endpoint is not connected #
        'ESHUTDOWN',        # Cannot send after transport endpoint shutdown #
        'ETOOMANYREFS',     # Too many references: cannot splice #
        'ETIMEDOUT',        # Connection timed out #
        'ECONNREFUSED',     # Connection refused #
        'EHOSTDOWN',        # Host is down #
        'EHOSTUNREACH',     # No route to host #
        'EALREADY',         # Operation already in progress #
        'EINPROGRESS',      # Operation now in progress #
        'ESTALE',           # Stale NFS file handle #
        'EUCLEAN',          # Structure needs cleaning #
        'ENOTNAM',          # Not a XENIX named type file #
        'ENAVAIL',          # No XENIX semaphores available #
        'EISNAM',           # Is a named type file #
        'EREMOTEIO',        # Remote I/O error #
        'EDQUOT',           # Quota exceeded #
        'ENOMEDIUM',        # No medium found #
        'EMEDIUMTYPE',      # Wrong medium type #
        'ECANCELED',        # Operation Canceled #
        'ENOKEY',           # Required key not available #
        'EKEYEXPIRED',      # Key has expired #
        'EKEYREVOKED',      # Key has been revoked #
        'EKEYREJECTED',     # Key was rejected by service #
        'EOWNERDEAD',       # Owner died #
        'ENOTRECOVERABLE',  # State not recoverable #
        'ERFKILL',          # Operation not possible due to RF-kill #
        'EHWPOISON',        # Memory page has hardware error #
    ]

    # Define rlimit of process #
    RLIMIT_TYPE = [
        'RLIMIT_CPU',
        'RLIMIT_FSIZE',
        'RLIMIT_DATA',
        'RLIMIT_STACK',
        'RLIMIT_CORE',
        'RLIMIT_RSS',
        'RLIMIT_NPROC',
        'RLIMIT_NOFILE',
        'RLIMIT_MEMLOCK',
        'RLIMIT_AS',
        'RLIMIT_LOCKS',
        'RLIMIT_SIGPENDING',
        'RLIMIT_MSGQUEUE',
        'RLIMIT_NICE',
        'RLIMIT_RTPRIO',
        'RLIMIT_RTTIME',
        'RLIMIT_NLIMITS'
    ]

    # Define udp/tcp format of system #
    UDP_ATTR = [
        'sl',
        'local_address',
        'rem_address',
        'st',
        'tx_rx_queue',
        'tr_tm->when',
        'retrnsmt',
        'uid',
        'timeout',
        'inode',
        'ref',
        'pointer',
        'drops'
    ]

    # Define uds format of system #
    UDS_ATTR = [
        'Num',
        'RefCount',
        'Protocol',
        'Flags',
        'Type',
        'St',
        'Inode',
        'Path',
    ]

    TCP_STAT = [
        'N/A',
        'ESTABLISHED',
        'SYN_SENT',
        'SYN_RECV',
        'FIN_WAIT1',
        'FIN_WAIT2',
        'TIME_WAIT',
        'CLOSE',
        'CLOSE_WAIT',
        'LAST_ACK',
        'LISTEN',
        'CLOSING'
    ]

    # Define futex operation flags #
    FUTEX_TYPE = [
        'FUTEX_WAIT',
        'FUTEX_WAKE',
        'FUTEX_FD',
        'FUTEX_REQUEUE',
        'FUTEX_CMP_REQUEUE',
        'FUTEX_WAKE_OP',
        'FUTEX_LOCK_PI',
        'FUTEX_UNLOCK_PI',
        'FUTEX_TRYLOCK_PI',
        'FUTEX_WAIT_BITSET',
        'FUTEX_WAKE_BITSET',
        'FUTEX_WAIT_REQUEUE_PI',
        'FUTEX_CMP_REQUEUE_PI',
    ]

    # Define fcntl command flags #
    FCNTL_TYPE = [
        'F_DUPFD',
        'F_GETFD',
        'F_SETFD',
        'F_GETFL',
        'F_SETFL',
        'F_GETOWN',
        'F_SETOWN',
        'F_GETLK',
        'F_SETLK',
        'F_SETLKW',
    ]

    # Define ipc call flags #
    IPC_TYPE = {
        1: "SEMOP",
        2: "SEMGET",
        3: "SEMCTL",
        4: "SEMTIMEDOP",
        11: "MSGSND",
        12: "MSGRCV",
        13: "MSGGET",
        14: "MSGCTL",
        21: "SHMAT",
        22: "SHMDT",
        23: "SHMGET",
        24: "SHMCTL",
    }

    # Define ptrace request type #
    PTRACE_TYPE = [
        'PTRACE_TRACEME',           #0#
        'PTRACE_PEEKTEXT',
        'PTRACE_PEEKDATA',
        'PTRACE_PEEKUSR',
        'PTRACE_POKETEXT',
        'PTRACE_POKEDATA',
        'PTRACE_POKEUSR',
        'PTRACE_CONT',
        'PTRACE_KILL',
        'PTRACE_SINGLESTEP',        #9#
        '', '',
        'PTRACE_GETREGS',           #12#
        'PTRACE_SETREGS',           #13#
        'PTRACE_GETFPREGS',         #14#
        'PTRACE_SETFPREGS',         #15#
        'PTRACE_ATTACH',            #16#
        'PTRACE_DETACH',            #17#
        'PTRACE_GETFPXREGS',        #18#
        'PTRACE_SETFPXREGS',        #19#
        '', '', '',
        'PTRACE_SET_SYSCALL',       #23#
        'PTRACE_SYSCALL',           #24#
        '', '', '', '', '', '',
        'PTRACE_SYSEMU',            #31#
        'PTRACE_SYSEMU_SINGLESTEP', #32#
    ]

    # Define ptrace event type #
    PTRACE_EVENT_TYPE = [
        'PTRACE_EVENT_NONE',
        'PTRACE_EVENT_FORK',
        'PTRACE_EVENT_VFORK',
        'PTRACE_EVENT_CLONE',
        'PTRACE_EVENT_EXEC',
        'PTRACE_EVENT_VFORK_DONE',
        'PTRACE_EVENT_EXIT',
        'PTRACE_EVENT_SECCOMP',
    ] + ['NONE' for idx in range(0, 120, 1)] + ['PTRACE_EVENT_STOP']

    # Define perf event types #
    PERF_EVENT_TYPE = [
        'PERF_TYPE_HARDWARE',
        'PERF_TYPE_SOFTWARE',
        'PERF_TYPE_TRACEPOINT',
        'PERF_TYPE_HW_CACHE',
        'PERF_TYPE_RAW',
        'PERF_TYPE_BREAKPOINT',
    ]

    PERF_HW_EVENT_TYPE = [
        'PERF_COUNT_HW_CPU_CYCLES',
        'PERF_COUNT_HW_INSTRUCTIONS',
        'PERF_COUNT_HW_CACHE_REFERENCES',
        'PERF_COUNT_HW_CACHE_MISSES',
        'PERF_COUNT_HW_BRANCH_INSTRUCTIONS',
        'PERF_COUNT_HW_BRANCH_MISSES',
        'PERF_COUNT_HW_BUS_CYCLES',
        'PERF_COUNT_HW_STALLED_CYCLES_FRONTEND',
        'PERF_COUNT_HW_STALLED_CYCLES_BACKEND',
        'PERF_COUNT_HW_REF_CPU_CYCLES',
    ]

    PERF_SW_EVENT_TYPE = [
        'PERF_COUNT_SW_CPU_CLOCK',
        'PERF_COUNT_SW_TASK_CLOCK',
        'PERF_COUNT_SW_PAGE_FAULTS',
        'PERF_COUNT_SW_CONTEXT_SWITCHES',
        'PERF_COUNT_SW_CPU_MIGRATIONS',
        'PERF_COUNT_SW_PAGE_FAULTS_MIN',
        'PERF_COUNT_SW_PAGE_FAULTS_MAJ',
        'PERF_COUNT_SW_ALIGNMENT_FAULTS',
        'PERF_COUNT_SW_EMULATION_FAULTS',
        'PERF_COUNT_SW_DUMMY',
        'PERF_COUNT_SW_BPF_OUTPUT',
    ]

    PERF_CACHE_EVENT_TYPE = [
        'PERF_COUNT_HW_CACHE_L1D',
        'PERF_COUNT_HW_CACHE_L1I',
        'PERF_COUNT_HW_CACHE_LL',
        'PERF_COUNT_HW_CACHE_DTLB',
        'PERF_COUNT_HW_CACHE_ITLB',
        'PERF_COUNT_HW_CACHE_BPU',
        'PERF_COUNT_HW_CACHE_NODE',
    ]

    PERF_CACHE_EVENT_OP = [
        'PERF_COUNT_HW_CACHE_OP_READ',
        'PERF_COUNT_HW_CACHE_OP_WRITE',
        'PERF_COUNT_HW_CACHE_OP_PREFETCH',
    ]

    PERF_CACHE_EVENT_OPRES = [
        'PERF_COUNT_HW_CACHE_RESULT_ACCESS',
        'PERF_COUNT_HW_CACHE_RESULT_MISS',
    ]



    @staticmethod
    def getMmapId():
        if SysMgr.arch == 'arm':
            return ConfigMgr.sysList.index('sys_mmap2')
        else:
            return ConfigMgr.sysList.index('sys_mmap')



    @staticmethod
    def openConfFile(path):
        path += '.tc'
        if os.path.isfile(path):
            SysMgr.printWarn(
                "%s already exists so that make new one" % path)

        try:
            fd = open(path, 'w')
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printOpenErr(path)
            return None

        return fd



    @staticmethod
    def writeConfData(fd, line):
        if not fd:
            SysMgr.printErr("fail to get file descriptor")
            return None

        fd.write(line)



    def __init__(self, mode):
        pass



    def __del__(self):
        pass





class UtilMgr(object):
    """ Manager for utilities """

    curTime = 0
    progressCnt = 0
    progressChar = {
        0: '|',
        1: '/',
        2: '-',
        3: '\\',
    }



    @staticmethod
    def setTime():
        UtilMgr.curTime = time.time()



    @staticmethod
    def convHtmlChar(string):
        chars = {
            '<': '&lt;',
            '>': '&gt;',
            '&': '&amp;',
        }

        for key, val in chars.items():
            string = string.replace(key, val)

        return string



    @staticmethod
    def printTime(name=None, update=False):
        # get current time #
        now = time.time()
        diff = now - UtilMgr.curTime

        # update timestamp #
        if update:
            UtilMgr.current = now

        # add name #
        if name:
            prefix = '[%s]' % name
        else:
            prefix = ''

        # print time diff #
        string = '\n%s[Elapsed: %f]' % (prefix, diff)
        print(UtilMgr.convColor(string, 'RED'))



    @staticmethod
    def compareSyscallSuperset():
        # initialize ignore list #
        ignoreList = set([
            'sys_ppoll_time64', 'sys_nfsservctl', 'sys_null',
            'sys_setfsgid32', 'sys_ftime', 'sys_geteuid32',
            'sys_clock_adjtime64', 'sys_timerfd_settime64',
            'sys_epoll_ctl_old', 'sys_setfsuid32', 'sys_getresgid32',
            'sys_iopl', 'sys_chown32', 'sys_rt_sigtimedwait_time64',
            'sys_gtty', 'sys_setresgid32', 'sys_reserved', 'sys_unused',
        ])

        syscallList = \
            ConfigMgr.SYSCALL_COMMON + \
            ConfigMgr.SYSCALL_COMMON32 + \
            ConfigMgr.SYSCALL_X86 + \
            ConfigMgr.SYSCALL_X64 + \
            ConfigMgr.SYSCALL_ARM + \
            ConfigMgr.SYSCALL_AARCH64
        syscallList = set(syscallList)

        protoList = set(\
            ['sys_%s' % name for name in ConfigMgr.SYSCALL_PROTOTYPES.keys()])

        # print final diff list #
        print("--- no prototype ---")
        print(list(syscallList - protoList - ignoreList))

        print("\n--- no define ---")
        print(list(protoList - syscallList))



    @staticmethod
    def isBitEnabled(num, bits):
        if not bits:
            return None

        try:
            num = long(num)
        except:
            num = long(num, 16)

        try:
            bits = long(bits)
        except:
            bits = long(bits, 16)

        if bits & (1 << num-1):
            return True
        else:
            return False



    @staticmethod
    def cleanItem(targetList, union=True):
        targetType = type(targetList)

        if targetType is str:
            targetStr = ''
            for val in targetList:
                if val: targetStr = '%s%s' % (targetStr, val)
            return targetStr
        elif targetType is list:
            # remove redundant values #
            if union:
                targetList = list(set(targetList))

            # remove empty values #
            newList = []
            for val in targetList:
                val = val.strip()
                if val: newList.append(val)

            return newList
        else:
            return targetList



    @staticmethod
    def printHist(table, title, unit):
        if not table:
            return

        convNum = UtilMgr.convNum

        # pop stats #
        statmin = table.pop('min', None)
        statmax = table.pop('max', None)
        statcnt = table.pop('cnt', None)

        SysMgr.printPipe(
            '\n[%s Histogram] (unit:%s)\n%s' % (title, unit, twoLine))
        SysMgr.printPipe('{0:^21}   {1:^17}'.format('Range', 'Count'))
        SysMgr.printPipe(oneLine)

        for digit, cnt in sorted(table.items()):
            srange = long(pow(2, digit-1))

            if srange == 0:
                erange = 1
            else:
                erange = long((srange<<1)-1)

            SysMgr.printPipe(
                '{0:10}-{1:>10}   {2:>10}({3:5.1f}%)'.format(
                    convNum(srange), convNum(erange), convNum(cnt),
                    cnt/float(statcnt)*100))

        SysMgr.printPipe(oneLine)
        SysMgr.printPipe('{0:^21}   {1:>17}'.format('Min', convNum(statmin)))
        SysMgr.printPipe('{0:^21}   {1:>17}'.format('Max', convNum(statmax)))
        SysMgr.printPipe('{0:^21}   {1:>17}'.format('Cnt', convNum(statcnt)))
        SysMgr.printPipe(oneLine)



    @staticmethod
    def convList2Histo(items, dtype='float', mult=1):
        def _getRangeIdx(value):
            if value <= 1:
                return 0

            digit = 0
            while 1:
                digit += 1
                value = value >> 1
                if value == 0:
                    return digit

        if not items:
            return None

        # convert type #
        if dtype == 'float':
            if type(items[0]) != float:
                items = list(map(float, items))
        elif dtype == 'long':
            if type(items[0]) != long:
                items = list(map(long, items))
        else:
            return None

        # convert unit #
        items = list(map(lambda x: long(x * mult), items))

        # get stats #
        histDict = {
            'max': max(items),
            'min': min(items),
            'cnt': len(items)
        }

        for value in items:
            digit = _getRangeIdx(value)
            histDict.setdefault(digit, 0)
            histDict[digit] += 1

        return histDict



    @staticmethod
    def getSigList():
        sigList = dict(
            (k, v) for v, k in reversed(sorted(signal.__dict__.items()))
            if v.startswith('SIG') and not v.startswith('SIG_'))
        return sigList



    @staticmethod
    def convList2Dict(optList, sep=':'):
        newDict = {}
        for item in optList:
            try:
                # get values #
                values = item.split(sep, 1)
                if len(values) == 1:
                    key = values[0]
                    value = 'SET'
                else:
                    key, value = values

                # set values #
                if key in newDict:
                    newDict[key].append(value)
                else:
                    newDict[key] = [value]
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printWarn(
                    "fail to parse %s by seperator %s" % (item, sep))
                continue

        return newDict



    @staticmethod
    def getStdev(data):
        def _variance(data, ddof=0):
            n = len(data)
            mean = sum(data) / n
            return sum((x - mean) ** 2 for x in data) / (n - ddof)

        var = _variance(data)
        math = SysMgr.getPkg('math')
        std_dev = math.sqrt(var)
        return std_dev



    @staticmethod
    def getRealTime():
        return time.asctime(time.gmtime(time.time()))



    @staticmethod
    def splitString(string):
        string = string.replace('\,', '$%')

        clist = string.split(',')

        for idx, item in enumerate(list(clist)):
            clist[idx] = item.replace('$%', ',').strip()

        return clist



    @staticmethod
    def getDrawOutputPath(inputPath, name):
        # set output path #
        if SysMgr.outPath:
            outputPath = SysMgr.outPath

            # check dir #
            if os.path.isdir(outputPath):
                outputFileName = '%s.svg' % \
                    os.path.splitext(os.path.basename(inputPath))[0]
                outputPath = \
                    os.path.join(outputPath, outputFileName)
        else:
            outputPath = UtilMgr.prepareForImageFile(
                inputPath, 'flamegraph')

        return outputPath



    @staticmethod
    def printSyscalls(systable):
        bufstring = ''
        for idx, syscall in enumerate(systable):
            if idx % 4 == 0:
                bufstring += '\n'
            bufstring += "'%s', " % syscall

        print(bufstring)

        print('total: %s' % len(systable))

        sys.exit(0)



    @staticmethod
    def isValidStr(string, key=None, inc=True, ignCap=False):
        if not key:
            key = SysMgr.filterGroup

        if not key:
            return True

        if ignCap:
            string = string.lower()

        for cond in list(key):
            if ignCap:
                cond = cond.lower()

            if inc:
                if cond in string:
                    return True
            else:
                if cond == '*':
                    return True
                elif cond.startswith('*') and \
                    cond.endswith('*') and \
                    cond.strip('*') in string:
                    return True
                elif cond.startswith('*') and \
                    string.endswith(cond[1:]):
                    return True
                elif cond.endswith('*') and \
                    string.startswith(cond[:-1]):
                    return True
                elif cond == string:
                    return True

        return False



    @staticmethod
    def drawGraph(inFile, outFile=None):
        instance = TaskAnalyzer(onlyInstance=True)
        instance.drawStats(inFile, outFile=outFile, onlyGraph=True)



    @staticmethod
    def drawChart(inFile, outFile=None):
        instance = TaskAnalyzer(onlyInstance=True)
        instance.drawStats(inFile, outFile=outFile, onlyChart=True)



    @staticmethod
    def convWord2Str(word):
        try:
            return struct.pack('L', word)
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printErr(
                "fail to convert word %s to string" % word, True)
            return None



    @staticmethod
    def getFiles(path, incFile=True, incDir=False):
        flist = list()

        for r, d, f in os.walk(path):
            if incFile:
                for sfile in f:
                    flist.append(os.path.join(r, sfile))
            if incDir:
                for sdir in d:
                    flist.append(os.path.join(r, sdir))

        return flist



    @staticmethod
    def getFileList(flist, sort=False):
        if not flist or type(flist) is not list:
            return []

        rlist = list()
        for item in flist:
            if item.startswith('-'):
                break

            # apply regular expression for path #
            ilist = UtilMgr.convPath(item)
            if UtilMgr.isString(ilist):
                rlist.append(ilist)
            elif type(ilist) is list:
                rlist += ilist

        # check redundant files #
        if len(rlist) != len(set(rlist)):
            SysMgr.printWarn(
                "detected redundant files in [ %s ]" % \
                    ', '.join(rlist), True)

        # remove redundant files #
        if sort:
            return sorted(rlist)
        else:
            return rlist



    @staticmethod
    def decodeArg(value):
        try:
            text = repr(value.decode())
        except SystemExit:
            sys.exit(0)
        except:
            text = value

        # define start index by encoding type #
        if type(text) is bytes:
            start = 2
        else:
            start = 1

        return text[start:]



    @staticmethod
    def convBin2Str(path, pos=False):
        try:
            if sys.version_info < (3, 0):
                fd = open(path, 'rb')
            else:
                fd = open(path, encoding='latin-1')

            content = fd.read()
            strList = list(re.findall("[^\x00-\x1F\x7F-\xFF]{4,}", content))

            # add position #
            if pos:
                lastPos = 0
                dictList = {}
                for item in strList:
                    dictList.setdefault(item, content.find(item, lastPos))
                    lastPos = dictList[item]
                return dictList

            return strList
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printErr('fail to convert %s to strings' % path, True)
            return False



    @staticmethod
    def bisect_left(a, x, lo=0, hi=None):
        # copied from python standard library bisect.py #
        if lo < 0:
            raise ValueError('lo must be non-negative')
        if not hi:
            hi = len(a)
        while lo < hi:
            mid = (lo+hi)//2
            if a[mid] <= x: lo = mid+1
            else: hi = mid
        return lo



    @staticmethod
    def getFlagBit(vlist, flist):
        num = 0

        for flag in flist:
            try:
                num |= vlist[flag]
            except:
                SysMgr.printErr(
                    "fail to get %s in [%s]" % \
                        (flag, '|'.join(list(vlist.keys()))))
                sys.exit(0)

        return num



    @staticmethod
    def getFlagList(value, flist, num='hex'):
        rlist = []
        numVal = long(value)
        for name, bits in list(flist.items()):
            if numVal & bits:
                rlist.append(name)
        return rlist



    @staticmethod
    def getFlagString(value, flist, num='hex'):
        string = ''
        numVal = long(value)
        for bit in list(flist.keys()):
            try:
                if numVal - bit < 0:
                    break
                elif numVal & bit:
                    string = '%s%s|' % (string, flist[bit])
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printWarn(
                    "fail to get flag info for %s" % value, reason=True)

        # check value for 0 index #
        if 0 in flist:
            if num == 'hex' and numVal & 0xF == 0:
                string = '%s|%s' % (flist[bit], string)
            elif num == 'oct' and numVal & 0o7 == 0:
                string = '%s|%s' % (flist[bit], string)
            elif num == 'bin' and numVal & 0 == 0:
                string = '%s|%s' % (flist[bit], string)

        if len(string) > 0:
            return string[:-1]
        else:
            return value



    @staticmethod
    def encodeBase64(value):
        base64 = SysMgr.getPkg('base64', False)

        try:
            return base64.b64encode(value)
        except SystemExit:
            sys.exit(0)
        except:
            return value



    @staticmethod
    def readLEB128(fd):
        data = None
        while 1:
            char = fd.read(1)
            if ord(char) & 0x80 == 0:
                break
            elif not data:
                data = char
            else:
                data += char
        return data



    @staticmethod
    def decodeSLEB128(obj):
        size = 1
        value = 0
        for b in obj:
            value = (value << 7) + (ord(b) & 0x7F)
            if (ord(b) & 0x80) == 0:
                break
            size += 1
        obj = obj[:size]
        if ord(obj[-1]) & 0x40:
            # negative -> sign extend
            value |= - (1 << (7 * len(obj)))
        return value, size



    @staticmethod
    def decodeULEB128(obj):
        size = 1
        value = 0

        # get size #
        for b in obj:
            if (ord(b) & 0x80) == 0:
                break
            size += 1

        # decode data #
        for b in reversed(obj[:size]):
            value = (value << 7) + (ord(b) & 0x7F)

        return value, size



    @staticmethod
    def isCompressed(fname=None, fd=None):
        if fname:
            try:
                fd = open(fname, 'rb')
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printOpenErr(fname)
                sys.exit(0)

        if fd:
            data = fd.read(2)
            fd.seek(0, 0)
            if struct.unpack('BB', data) == (0x1f, 0x8b):
                return True
            else:
                return False
        else:
            return False



    @staticmethod
    def conv2BitStr(content):
        return bin(content)



    @staticmethod
    def decodeBase64(value):
        base64 = SysMgr.getPkg('base64', False)

        try:
            return base64.b64decode(value)
        except SystemExit:
            sys.exit(0)
        except:
            return value



    @staticmethod
    def encodeStr(value):
        try:
            return value.encode()
        except SystemExit:
            sys.exit(0)
        except:
            try:
                return value.encode('utf8', 'surrogateescape')
            except SystemExit:
                sys.exit(0)
            except:
                return value




    @staticmethod
    def isString(value):
        if isinstance(value, str):
            return True
        elif sys.version_info >= (3, 0, 0):
            if isinstance(value, bytes):
                return True
        else:
            if isinstance(value, unicode): # pylint: disable=undefined-variable
                return True
        return False



    @staticmethod
    def isFloat(value):
        if type(value) is float:
            return True
        elif type(value) is str:
            try:
                float(value)
                return True
            except SystemExit:
                sys.exit(0)
            except:
                return False
        else:
            return False



    @staticmethod
    def isNumber(value):
        if type(value) is int or \
            type(value) is long:
            return True
        elif type(value) is str:
            if value.isdigit():
                return True

            try:
                if value.startswith('0x') and long(value, 16):
                    return True
                else:
                    return False
            except SystemExit:
                sys.exit(0)
            except:
                return False
        else:
            return False



    @staticmethod
    def getTextLines(fname, verbose=False, retfd=False):
        buf = []

        if verbose:
            if retfd:
                SysMgr.printStat(
                    r"start checking '%s'..." % fname)
            else:
                SysMgr.printStat(
                    r"start loading '%s'..." % fname)

        # check gzip #
        try:
            fd = None
            with open(fname, 'rb') as fd:
                data = fd.read(2)
                if struct.unpack('BB', data) != (0x1f, 0x8b):
                    raise Exception()

            compressor = SysMgr.getPkg('gzip', False)
            fd = compressor.open(fname, 'rt')
        except SystemExit:
            sys.exit(0)
        except:
            fd = None

        # open a file #
        try:
            if not fd:
                fd = open(fname, 'r', encoding='utf-8')
        except SystemExit:
            sys.exit(0)
        except:
            fd = open(fname, 'r')

        # just return fd #
        if retfd:
            return fd

        # get total size #
        try:
            totalSize = os.stat(fname).st_size
        except SystemExit:
            sys.exit(0)
        except:
            totalSize = long(0)

        # read data from a file #
        while 1:
            try:
                data = fd.readline()
                curSize = fd.tell()
                if not data:
                    break
                buf.append(data)
            except SystemExit:
                sys.exit(0)
            except:
                break

            if verbose:
                UtilMgr.printProgress(curSize, totalSize)

        if verbose:
            UtilMgr.deleteProgress()

        try:
            fd.close()
        except:
            pass

        return buf



    @staticmethod
    def convPath(value, retStr=False, isExit=False, separator=' '):
        value = value.strip()
        glob = SysMgr.getPkg('glob', False)
        if glob:
            # check recursive path for specific version(>=python 3.5) #
            if '**' in value and sys.version_info >= (3, 5):
                res = glob.glob(value, recursive=True)
            else:
                res = glob.glob(value)

            if not res and isExit:
                SysMgr.printErr(
                    "fail to find a file matching '%s'" % value)
                sys.exit(0)

            # str #
            if retStr:
                return separator.join(res)
            # list #
            else:
                return res
        else:
            # str #
            if retStr:
                return value
            # list #
            else:
                return [value]



    @staticmethod
    def convStr2Word(bstring):
        try:
            return struct.unpack('L', bstring)[0]
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printErr(
                "fail to convert string %s to word" % bstring)
            return None



    @staticmethod
    def convOverlayPath(path, overlayfsList):
        fileList = []
        itemList = ['lowerdir', 'upperdir']

        for pos, info in overlayfsList.items():
            if not pos in path:
                continue

            for target in itemList:
                for item in info[target]:
                    fullpath = item + path
                    if os.path.exists(fullpath):
                        fileList.append(fullpath)

        # return recent path #
        if fileList:
            return fileList[-1]
        else:
            return path



    @staticmethod
    def convStr2Num(string, verb=True):
        try:
            if type(string) is long:
                return string
            elif string.isdigit():
                string = long(string)
            else:
                string = long(string, 16)
        except SystemExit:
            sys.exit(0)
        except:
            if verb:
                SysMgr.printErr(
                    "fail to convert %s to number" % string, True)
            return None

        return string



    @staticmethod
    def convNum(number):
        try:
            return format(long(number), ",")
        except SystemExit:
            sys.exit(0)
        except:
            return number



    @staticmethod
    def getRealLen(string):
        ansi = r'(?:\x1B[@-_]|[\x80-\x9F])[0-?]*[ -/]*[@-~]'
        ansiObj = re.compile(ansi)
        return len(ansiObj.sub('', string))



    @staticmethod
    def convColor(string, color='LIGHT', size=1, align='right'):
        if not SysMgr.colorEnable or not color or \
            SysMgr.outPath or SysMgr.outputFile or \
            not SysMgr.isLinux or SysMgr.remoteRun:
            return string

        if align == 'right':
            string = '{0:>{size}}'.format(str(string), size=size)
        else:
            string = '{0:<{size}}'.format(str(string), size=size)

        try:
            return (ConfigMgr.COLOR_LIST[color] + string + ConfigMgr.ENDC)
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printWarn(
                'fail to convert color for %s' % color, reason=True)



    @staticmethod
    def convSize2Unit(size, isInt=False):
        sizeKB = long(1024)
        sizeMB = sizeKB << 10
        sizeGB = sizeMB << 10
        sizeTB = sizeGB << 10

        # convert to ABS value #
        try:
            sizeAbs = abs(size)
        except SystemExit:
            sys.exit(0)
        except:
            return '?'

        # Int type #
        if isInt:
            try:
                if sizeAbs >= sizeTB:
                    return '%dT' % (size >> 40)
                elif sizeAbs >= sizeGB:
                    return '%dG' % (size >> 30)
                elif sizeAbs >= sizeMB:
                    return '%dM' % (size >> 20)
                elif sizeAbs >= sizeKB:
                    return '%dK' % (size >> 10)
                else:
                    return '%d' % size
            except SystemExit:
                sys.exit(0)
            except:
                return '?'
        # Float type #
        else:
            try:
                if sizeAbs >= sizeTB:
                    return '%.1fT' % ((size >> 30) / 1024.0)
                elif sizeAbs >= sizeGB:
                    return '%.1fG' % ((size >> 20) / 1024.0)
                elif sizeAbs >= sizeMB:
                    return '%.1fM' % ((size >> 10) / 1024.0)
                elif sizeAbs >= sizeKB:
                    return '%.1fK' % (size / 1024.0)
                else:
                    return '%d' % (size)
            except SystemExit:
                sys.exit(0)
            except:
                return '?'



    @staticmethod
    def convTime(time):
        # convert seconds to time #
        try:
            m, s = divmod(time, 60)
            h, m = divmod(m, 60)

            # hour #
            if h >= 24:
                d, h = divmod(h, 24)

                # year #
                if d >= 365:
                    y, d = divmod(d, 365)
                    d = '%dy:%dd:' % (y, d)
                else:
                    d = '%dd:' % d
            else:
                d = ''

            ctime = "%s%02d:%02d:%02d" % (d, h, m, s)
        except SystemExit:
            sys.exit(0)
        except:
            ctime = "%s%02s:%02s:%02s" % ('', '?', '?', '?')

        return ctime.strip()



    @staticmethod
    def prepareForImageFile(logFile, itype='', outFile=None):
        # build output file name #
        if outFile:
            outputFile = outFile
        else:
            if SysMgr.outPath:
                outputFile = os.path.normpath(SysMgr.outPath)
            else:
                outputFile = os.path.normpath(logFile)

            # convert output path #
            if os.path.isdir(outputFile):
                filename = os.path.basename(logFile)
                filename = os.path.splitext(filename)[0]
                name = '%s/%s' % (outputFile, filename)
            else:
                name = os.path.splitext(outputFile)[0]

            outputFile = '%s_%s.%s' % (name, itype, SysMgr.drawFormat)

        try:
            # backup an exist image file #
            if os.path.isfile(outputFile):
                name, ext = os.path.splitext(outputFile)

                oldPath = '%s_old%s' % (name, ext)
                if os.path.isfile(oldPath):
                    os.remove(oldPath)

                os.rename(outputFile, oldPath)

                SysMgr.printInfo(
                    "renamed '%s' to '%s' for backup" % \
                        (outputFile, oldPath))
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printErr(
                "fail to backup '%s' to '%s'" % \
                    (outputFile, oldPath), True)

        return outputFile



    @staticmethod
    def convUnit2Time(data):
        if str(data).isdigit():
            ret = long(data)
        elif data.upper().endswith('S'):
            ret = long(data[:-1])
        elif data.upper().endswith('M'):
            ret = long(data[:-1]) * 60
        elif data.upper().endswith('H'):
            ret = long(data[:-1]) * 60 * 60
        elif data.upper().endswith('D'):
            ret = long(data[:-1]) * 60 * 60 * 24
        elif data.upper().endswith('W'):
            ret = long(data[:-1]) * 60 * 60 * 24 * 7
        else:
            ret = 0
            SysMgr.printErr(
                "fail to convert '%s' to seconds" % data)

        return ret



    @staticmethod
    def convUnit2Size(value):
        sizeKB = long(1024)
        sizeMB = sizeKB << 10
        sizeGB = sizeMB << 10
        sizeTB = sizeGB << 10
        sizePB = sizeTB << 10

        if str(value).isdigit():
            return long(value)

        # convert unit character to capital #
        value = value.upper()

        try:
            if value.endswith('K'):
                return long(float(value[:-1]) * sizeKB)
            if value.endswith('KB'):
                return long(float(value[:-2]) * sizeKB)
            if value.endswith('M'):
                return long(float(value[:-1]) * sizeMB)
            if value.endswith('MB'):
                return long(float(value[:-2]) * sizeMB)
            if value.endswith('G'):
                return long(float(value[:-1]) * sizeGB)
            if value.endswith('GB'):
                return long(float(value[:-2]) * sizeGB)
            if value.endswith('T'):
                return long(float(value[:-1]) * sizeTB)
            if value.endswith('TB'):
                return long(float(value[:-2]) * sizeTB)
            if value.endswith('P'):
                return long(float(value[:-1]) * sizePB)
            if value.endswith('PB'):
                return long(float(value[:-2]) * sizePB)

            SysMgr.printErr(
                "fail to convert %s to size" % value)

            assert False
        except SystemExit:
            sys.exit(0)
        except AssertionError:
            raise Exception('wrong number unit')
        except:
            return value



    @staticmethod
    def writeJsonObject(jsonObj, fd=None, trunc=False, path=None):
        if fd:
            try:
                if trunc:
                    fd.seek(0, 0)
                    fd.truncate()

                fd.write(jsonObj)

                fd.flush()
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printWarn(
                    "fail to write JSON format data", reason=True)
            return

        # check write option #
        if trunc:
            perm = 'w'
        else:
            perm = 'a'

        # open the file #
        try:
            with open(path, perm) as fd:
                fd.write(jsonObj)
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printErr(
                "fail to write JSON format data to %s" % path, True)
            sys.exit(0)



    @staticmethod
    def saveObjectToFile(obj, path):
        if not obj:
            return False

        pickle = SysMgr.getPicklePkg(False)
        if not pickle:
            return False

        # disable compression for performance #
        SysMgr.compressEnable = False

        # compress by gzip #
        if SysMgr.compressEnable:
            compressor = SysMgr.getPkg('gzip', False)
        else:
            compressor = None

        # original object #
        try:
            if compressor:
                with compressor.open(path, 'wb') as fd:
                    pickle.dump(obj, fd, -1)
            else:
                with open(path, 'wb') as fd:
                    pickle.dump(obj, fd, -1)
            return True
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printWarn(
                "fail to save %s object to %s" % \
                    (obj.__class__.__name__, path), reason=True)
            return False



    @staticmethod
    def loadObjectFromFile(path):
        # check object exists #
        if not os.path.isfile(path):
            return None

        pickle = SysMgr.getPicklePkg(False)
        if not pickle:
            return None

        # disable compression for performance #
        SysMgr.compressEnable = False

        # decompress by gzip #
        if SysMgr.compressEnable:
            decompressor = SysMgr.getPkg('gzip')
        else:
            decompressor = None

        try:
            if decompressor:
                with decompressor.open(path, 'rb') as fd:
                    return pickle.load(fd)
            else:
                with open(path, 'rb') as fd:
                    return pickle.load(fd)
        except SystemExit:
            sys.exit(0)
        except:
            return None



    @staticmethod
    def printProgress(current=0, dest=0):
        if not SysMgr.printEnable or \
            dest == sys.maxsize:
            return

        # just output #
        if not current and not dest:
            if UtilMgr.progressCnt >= len(UtilMgr.progressChar)-1:
                UtilMgr.progressCnt = 0
            else:
                UtilMgr.progressCnt += 1

            mod = UtilMgr.progressCnt

            sys.stdout.write('.... %s%s' % \
                (UtilMgr.progressChar[mod], '\b' * 6))
        else:
            try:
                div = round((current / float(dest)) * 100, 1)
            except SystemExit:
                sys.exit(0)
            except:
                div = long(0)

            percent = long(div)

            mod = percent & 3

            sys.stdout.write('%3d%% %s%s' % \
                (percent, UtilMgr.progressChar[mod], '\b' * 6))

        # handle reentrant call exception #
        try:
            sys.stdout.flush()
        except SystemExit:
            sys.exit(0)
        except:
            return



    @staticmethod
    def writeFlamegraph(path, samples, title):
        # flamegraph from https://github.com/rbspy/rbspy/tree/master/src/ui/flamegraph.rs #
        flameCode = '''<?xml version="1.0" standalone="no"?>
<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">
<svg version="1.1" width="1200" height="230" onload="init(evt)" viewBox="0 0 1200 230"
        xmlns="http://www.w3.org/2000/svg"
        xmlns:xlink="http://www.w3.org/1999/xlink">
        <!--Flame graph stack visualization. See https://github.com/brendangregg/FlameGraph for latest version, and http://www.brendangregg.com/flamegraphs.html for examples.-->
        <!--NOTES: -->
        <defs>
                <linearGradient id="background" y1="0" y2="1" x1="0" x2="0">
                        <stop stop-color="#eeeeee" offset="5%"/>
                        <stop stop-color="#eeeeb0" offset="95%"/>
                </linearGradient>
        </defs>
        <style type="text/css">
text { font-family:"Verdana"; font-size:12px; fill:rgb(0,0,0); }
#title { text-anchor:middle; font-size:17px; }
#search { opacity:0.1; cursor:pointer; }
#search:hover, #search.show { opacity:1; }
#subtitle { text-anchor:left; font-color:rgb(160,160,160); }
#unzoom { cursor:pointer; }
#frames > *:hover { stroke:black; stroke-width:0.5; cursor:pointer; }
.hide { display:none; }
.parent { opacity:0.5; }
</style>
        <script type="text/ecmascript">
                <![CDATA[var nametype = 'Function:';
var fontsize = 12;
var fontwidth = 0.59;
var xpad = 10;
var inverted = true;
var searchcolor = 'rgb(230,0,230)';
var fluiddrawing = true;
var truncate_text_right = false;]]>
                <![CDATA["use strict";
var details, searchbtn, unzoombtn, matchedtxt, svg, searching, frames;
function init(evt) {
    details = document.getElementById("details").firstChild;
    searchbtn = document.getElementById("search");
    unzoombtn = document.getElementById("unzoom");
    matchedtxt = document.getElementById("matched");
    svg = document.getElementsByTagName("svg")[0];
    frames = document.getElementById("frames");
    searching = 0;

    // Use GET parameters to restore a flamegraph's state.
    var restore_state = function() {
        var params = get_params();
        if (params.x && params.y)
            zoom(find_group(document.querySelector('[x="' + params.x + '"][y="' + params.y + '"]')));
        if (params.s)
            search(params.s);
    };

    if (fluiddrawing) {
        // Make width dynamic so the SVG fits its parent's width.
        svg.removeAttribute("width");
        // Edge requires us to have a viewBox that gets updated with size changes
        var isEdge = /Edge\/\d./i.test(navigator.userAgent);
        if (!isEdge) {
          svg.removeAttribute("viewBox");
        }
        var update_for_width_change = function() {
            if (isEdge) {
                svg.attributes.viewBox.value = "0 0 " + svg.width.baseVal.value + " " + svg.height.baseVal.value;
            }

            // Keep consistent padding on left and right of frames container.
            frames.attributes.width.value = svg.width.baseVal.value - xpad * 2;

            // Text truncation needs to be adjusted for the current width.
            var el = frames.children;
            for(var i = 0; i < el.length; i++) {
                update_text(el[i]);
            }

            // Keep search elements at a fixed distance from right edge.
            var svgWidth = svg.width.baseVal.value;
            searchbtn.attributes.x.value = svgWidth - xpad - 100;
            matchedtxt.attributes.x.value = svgWidth - xpad - 100;
        };
        window.addEventListener('resize', function() {
            update_for_width_change();
        });
        // This needs to be done asynchronously for Safari to work.
        setTimeout(function() {
            unzoom();
            update_for_width_change();
            restore_state();
        }, 0);
    } else {
        restore_state();
    }
}
// event listeners
window.addEventListener("click", function(e) {
    var target = find_group(e.target);
    if (target) {
        if (target.nodeName == "a") {
            if (e.ctrlKey === false) return;
            e.preventDefault();
        }
        if (target.classList.contains("parent")) unzoom();
        zoom(target);

        // set parameters for zoom state
        var el = target.querySelector("rect");
        if (el && el.attributes && el.attributes.y && el.attributes._orig_x) {
            var params = get_params()
            params.x = el.attributes._orig_x.value;
            params.y = el.attributes.y.value;
            history.replaceState(null, null, parse_params(params));
        }
    }
    else if (e.target.id == "unzoom") {
        unzoom();

        // remove zoom state
        var params = get_params();
        if (params.x) delete params.x;
        if (params.y) delete params.y;
        history.replaceState(null, null, parse_params(params));
    }
    else if (e.target.id == "search") search_prompt();
}, false)
// mouse-over for info
// show
window.addEventListener("mouseover", function(e) {
    var target = find_group(e.target);
    if (target) details.nodeValue = nametype + " " + g_to_text(target);
}, false)
// clear
window.addEventListener("mouseout", function(e) {
    var target = find_group(e.target);
    if (target) details.nodeValue = ' ';
}, false)
// ctrl-F for search
window.addEventListener("keydown",function (e) {
    if (e.keyCode === 114 || (e.ctrlKey && e.keyCode === 70)) {
        e.preventDefault();
        search_prompt();
    }
}, false)
// functions
function get_params() {
    var params = {};
    var paramsarr = window.location.search.substr(1).split('&');
    for (var i = 0; i < paramsarr.length; ++i) {
        var tmp = paramsarr[i].split("=");
        if (!tmp[0] || !tmp[1]) continue;
        params[tmp[0]]  = decodeURIComponent(tmp[1]);
    }
    return params;
}
function parse_params(params) {
    var uri = "?";
    for (var key in params) {
        uri += key + '=' + encodeURIComponent(params[key]) + '&';
    }
    if (uri.slice(-1) == "&")
        uri = uri.substring(0, uri.length - 1);
    if (uri == '?')
        uri = window.location.href.split('?')[0];
    return uri;
}
function find_child(node, selector) {
    var children = node.querySelectorAll(selector);
    if (children.length) return children[0];
    return;
}
function find_group(node) {
    var parent = node.parentElement;
    if (!parent) return;
    if (parent.id == "frames") return node;
    return find_group(parent);
}
function orig_save(e, attr, val) {
    if (e.attributes["_orig_" + attr] != undefined) return;
    if (e.attributes[attr] == undefined) return;
    if (val == undefined) val = e.attributes[attr].value;
    e.setAttribute("_orig_" + attr, val);
}
function orig_load(e, attr) {
    if (e.attributes["_orig_"+attr] == undefined) return;
    e.attributes[attr].value = e.attributes["_orig_" + attr].value;
    e.removeAttribute("_orig_" + attr);
}
function g_to_text(e) {
    var text = find_child(e, "title").firstChild.nodeValue;
    return (text)
}
function g_to_func(e) {
    var func = g_to_text(e);
    // if there's any manipulation we want to do to the function
    // name before it's searched, do it here before returning.
    return (func);
}
function update_text(e) {
    var r = find_child(e, "rect");
    var t = find_child(e, "text");
    var w = parseFloat(r.attributes.width.value) * frames.attributes.width.value / 100 - 3;
    var txt = find_child(e, "title").textContent.replace(/\([^(]*\)$/,"");
    t.attributes.x.value = format_percent((parseFloat(r.attributes.x.value) + (100 * 3 / frames.attributes.width.value)));
    // Smaller than this size won't fit anything
    if (w < 2 * fontsize * fontwidth) {
        t.textContent = "";
        return;
    }
    t.textContent = txt;
    // Fit in full text width
    if (/^ *\$/.test(txt) || t.getComputedTextLength() < w)
        return;
    if (truncate_text_right) {
        // Truncate the right side of the text.
        for (var x = txt.length - 2; x > 0; x--) {
            if (t.getSubStringLength(0, x + 2) <= w) {
                t.textContent = txt.substring(0, x) + "..";
                return;
            }
        }
    } else {
        // Truncate the left side of the text.
        for (var x = 2; x < txt.length; x++) {
            if (t.getSubStringLength(x - 2, txt.length) <= w) {
                t.textContent = ".." + txt.substring(x, txt.length);
                return;
            }
        }
    }
    t.textContent = "";
}
// zoom
function zoom_reset(e) {
    if (e.attributes != undefined) {
        orig_load(e, "x");
        orig_load(e, "width");
    }
    if (e.childNodes == undefined) return;
    for(var i = 0, c = e.childNodes; i < c.length; i++) {
        zoom_reset(c[i]);
    }
}
function zoom_child(e, x, ratio) {
    if (e.attributes != undefined) {
        if (e.attributes.x != undefined) {
            orig_save(e, "x");
            e.attributes.x.value = format_percent((parseFloat(e.attributes.x.value) - x) * ratio);
            if (e.tagName == "text") {
                e.attributes.x.value = format_percent(parseFloat(find_child(e.parentNode, "rect[x]").attributes.x.value) + (100 * 3 / frames.attributes.width.value));
            }
        }
        if (e.attributes.width != undefined) {
            orig_save(e, "width");
            e.attributes.width.value = format_percent(parseFloat(e.attributes.width.value) * ratio);
        }
    }
    if (e.childNodes == undefined) return;
    for(var i = 0, c = e.childNodes; i < c.length; i++) {
        zoom_child(c[i], x, ratio);
    }
}
function zoom_parent(e) {
    if (e.attributes) {
        if (e.attributes.x != undefined) {
            orig_save(e, "x");
            e.attributes.x.value = "0.0%";
        }
        if (e.attributes.width != undefined) {
            orig_save(e, "width");
            e.attributes.width.value = "100.0%";
        }
    }
    if (e.childNodes == undefined) return;
    for(var i = 0, c = e.childNodes; i < c.length; i++) {
        zoom_parent(c[i]);
    }
}
function zoom(node) {
    var attr = find_child(node, "rect").attributes;
    var width = parseFloat(attr.width.value);
    var xmin = parseFloat(attr.x.value);
    var xmax = xmin + width;
    var ymin = parseFloat(attr.y.value);
    var ratio = 100 / width;
    // XXX: Workaround for JavaScript float issues (fix me)
    var fudge = 0.001;
    unzoombtn.classList.remove("hide");
    var el = frames.children;
    for (var i = 0; i < el.length; i++) {
        var e = el[i];
        var a = find_child(e, "rect").attributes;
        var ex = parseFloat(a.x.value);
        var ew = parseFloat(a.width.value);
        // Is it an ancestor
        if (!inverted) {
            var upstack = parseFloat(a.y.value) > ymin;
        } else {
            var upstack = parseFloat(a.y.value) < ymin;
        }
        if (upstack) {
            // Direct ancestor
            if (ex <= xmin && (ex+ew+fudge) >= xmax) {
                e.classList.add("parent");
                zoom_parent(e);
                update_text(e);
            }
            // not in current path
            else
                e.classList.add("hide");
        }
        // Children maybe
        else {
            // no common path
            if (ex < xmin || ex + fudge >= xmax) {
                e.classList.add("hide");
            }
            else {
                zoom_child(e, xmin, ratio);
                update_text(e);
            }
        }
    }
}
function unzoom() {
    unzoombtn.classList.add("hide");
    var el = frames.children;
    for(var i = 0; i < el.length; i++) {
        el[i].classList.remove("parent");
        el[i].classList.remove("hide");
        zoom_reset(el[i]);
        update_text(el[i]);
    }
}
// search
function reset_search() {
    var el = document.querySelectorAll("#frames rect");
    for (var i = 0; i < el.length; i++) {
        orig_load(el[i], "fill")
    }
    var params = get_params();
    delete params.s;
    history.replaceState(null, null, parse_params(params));
}
function search_prompt() {
    if (!searching) {
        var term = prompt("Enter a search term (regexp " +
            "allowed, eg: ^ext4_)", "");
        if (term != null) {
            search(term)
        }
    } else {
        reset_search();
        searching = 0;
        searchbtn.classList.remove("show");
        searchbtn.firstChild.nodeValue = "Search"
        matchedtxt.classList.add("hide");
        matchedtxt.firstChild.nodeValue = ""
    }
}
function search(term) {
    var re = new RegExp(term);
    var el = frames.children;
    var matches = new Object();
    var maxwidth = 0;
    for (var i = 0; i < el.length; i++) {
        var e = el[i];
        var func = g_to_func(e);
        var rect = find_child(e, "rect");
        if (func == null || rect == null)
            continue;
        // Save max width. Only works as we have a root frame
        var w = parseFloat(rect.attributes.width.value);
        if (w > maxwidth)
            maxwidth = w;
        if (func.match(re)) {
            // highlight
            var x = parseFloat(rect.attributes.x.value);
            orig_save(rect, "fill");
            rect.attributes.fill.value = searchcolor;
            // remember matches
            if (matches[x] == undefined) {
                matches[x] = w;
            } else {
                if (w > matches[x]) {
                    // overwrite with parent
                    matches[x] = w;
                }
            }
            searching = 1;
        }
    }
    if (!searching)
        return;
    var params = get_params();
    params.s = term;
    history.replaceState(null, null, parse_params(params));

    searchbtn.classList.add("show");
    searchbtn.firstChild.nodeValue = "Reset Search";
    // calculate percent matched, excluding vertical overlap
    var count = 0;
    var lastx = -1;
    var lastw = 0;
    var keys = Array();
    for (k in matches) {
        if (matches.hasOwnProperty(k))
            keys.push(k);
    }
    // sort the matched frames by their x location
    // ascending, then width descending
    keys.sort(function(a, b){
        return a - b;
    });
    // Step through frames saving only the biggest bottom-up frames
    // thanks to the sort order. This relies on the tree property
    // where children are always smaller than their parents.
    var fudge = 0.0001;    // JavaScript floating point
    for (var k in keys) {
        var x = parseFloat(keys[k]);
        var w = matches[keys[k]];
        if (x >= lastx + lastw - fudge) {
            count += w;
            lastx = x;
            lastw = w;
        }
    }
    // display matched percent
    matchedtxt.classList.remove("hide");
    var pct = 100 * count / maxwidth;
    if (pct != 100) pct = pct.toFixed(1);
    matchedtxt.firstChild.nodeValue = "Matched: " + pct + "%";
}
function format_percent(n) {
    return n.toFixed(4) + "%";
}
]]>
        </script>
'''
        attrCode = '''
    <rect x="0" y="0" width="100%%" height="230" fill="url(#background)"/>
    <text id="title" x="50.0000%%" y="24.00">Guider Flamegraph</text>
    <text id="subtitle" x="0.0000%%" y="50.00">%s</text>
    <text id="details" x="10" y="213.00"></text>
    <text id="unzoom" class="hide" x="10" y="24.00">Reset Zoom</text>
    <text id="search" x="1090" y="24.00">Search</text>
    <text id="matched" x="1090" y="213.00"></text>
    <svg id="frames" x="10" y="20" width="1180">
''' % ('\r\n%s' % title if title else '')

        # complete code for flamegraph #
        finalCode = flameCode + attrCode + samples + '\n</svg></svg>'

        # write flamegraph to file #
        try:
            with open(path, 'w') as fd:
                fd.write(finalCode)

            # get output size #
            fsize = UtilMgr.getFileSize(path)
            if fsize and fsize != '0':
                fsize = ' [%s]' % fsize
            else:
                fsize = ''

            SysMgr.printInfo(
                "saved flamegraph into '%s'%s successfully" % (path, fsize))
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printErr(
                'fail to write flamegraph to %s' % path, True)
            sys.exit(0)



    @staticmethod
    def getFileSize(path, string=True):
        try:
            fsize = long(os.path.getsize(path))
            if string:
                return UtilMgr.convSize2Unit(fsize)
            else:
                return fsize
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printWarn(
                "fail to get file size for '%s'" % path)

            if string:
                return '?'
            else:
                return 0



    @staticmethod
    def printFile(path):
        try:
            with open(path, 'r') as fd:
                for line in fd:
                    print(line)
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printErr(
                "fail to print %s" % path, reason=True)



    @staticmethod
    def deleteProgress():
        if not SysMgr.printEnable:
            return

        sys.stdout.write(' ' * 6)

        # handle reentrant call exception #
        try:
            sys.stdout.flush()
        except SystemExit:
            sys.exit(0)
        except:
            return



    @staticmethod
    def which(file):
        pathList = []
        for path in os.environ["PATH"].split(os.pathsep):
            if os.path.exists(os.path.join(path, file)):
                pathList.append(os.path.join(path, file))
        if not pathList:
            return None
        else:
            return pathList



    @staticmethod
    def convDict2Str(dictObj, pretty=True, indent=2, ignore=False):
        try:
            if ignore:
                jsonStr = SysMgr.getPkg('json').\
                    dumps(dictObj, indent=indent, ensure_ascii=False,
                        default=lambda o: '<not serializable>')
            else:
                jsonStr = SysMgr.getPkg('json').\
                    dumps(dictObj, indent=indent, ensure_ascii=False)

            if pretty:
                return jsonStr
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printWarn(
                "fail to convert %s to string" % [dictObj], reason=True)
            return None

        # when encode flag is disabled, remove whitespace [\t\n\r\f\v] #
        if not SysMgr.encodeEnable:
            jsonStr = re.sub("\s", "", jsonStr) + "\n"

        return jsonStr



    @staticmethod
    def convUlong2Long(retval):
        retval = (retval & 0xffffffffffffffff)
        if retval & 0x8000000000000000:
            retval = retval - 0x10000000000000000
        return retval



    @staticmethod
    def convStr2Dict(strObj, verb=False):
        try:
            return SysMgr.getPkg('json').loads(strObj)
        except SystemExit:
            sys.exit(0)
        except:
            try:
                strObj = strObj.replace("'", '"')
                return SysMgr.getPkg('json').loads(strObj)
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printWarn(
                    "fail to convert %s to dict" % [strObj],
                        always=verb, reason=True)
                return None





class NetworkMgr(object):
    """ Manager for remote communication """

    def __init__(
        self, mode, ip, port, blocking=True, tcp=False,
        anyPort=False, bind=True, netlink=False, reuse=True):

        self.mode = mode
        self.ip = None
        self.port = None
        self.socket = None
        self.request = None
        self.status = None
        self.ignore = long(0)
        self.fileno = -1
        self.time = None
        self.sendSize = 32767
        self.recvSize = 32767
        self.tcp = tcp
        self.netlink = netlink
        self.connected = False

        # get socket object #
        socket = SysMgr.getPkg('socket')

        try:
            from socket import socket, AF_INET, SOCK_DGRAM,\
                SOCK_STREAM, SOL_SOCKET, SO_REUSEADDR, SO_SNDBUF, SO_RCVBUF,\
                SOL_TCP, SO_RCVTIMEO, SO_SNDTIMEO, SOCK_RAW
        except:
            SysMgr.printWarn(
                "fail to import socket", True, reason=True)
            return None

        try:
            # set socket type #
            if tcp:
                self.socket = socket(AF_INET, SOCK_STREAM)
            elif netlink:
                try:
                    from socket import socket, AF_NETLINK
                    self.socket = socket(
                        AF_NETLINK, SOCK_RAW,
                            ConfigMgr.NETLINK_TYPE['NETLINK_GENERIC'])
                except:
                    SysMgr.printWarn(
                        "fail to create NETLINK socket", True, reason=True)
                    return None
            else:
                self.socket = socket(AF_INET, SOCK_DGRAM)

            self.fileno = self.socket.fileno()

            # increate socket buffer size to 1MB #
            self.socket.setsockopt(SOL_SOCKET, SO_SNDBUF, 1<<20)
            self.socket.setsockopt(SOL_SOCKET, SO_RCVBUF, 1<<20)

            # get buffer size #
            self.sendSize = self.socket.getsockopt(SOL_SOCKET, SO_SNDBUF)
            self.recvSize = self.socket.getsockopt(SOL_SOCKET, SO_RCVBUF)

            # set REUSEADDR #
            if reuse:
                self.socket.setsockopt(SOL_SOCKET, SO_REUSEADDR, 1)

            # set REUSEPORT #
            '''
            from socket import SO_REUSEPORT
            self.socket.setsockopt(SOL_SOCKET, SO_REUSEPORT, 0)
            '''

            # set NODELAY #
            '''
            self.setNoDelay()
            '''

            # set SENDTIMEOUT #
            '''
            sec = 1
            usec = long(0)
            timeval = struct.pack('ll', sec, usec)
            self.socket.setsockopt(SOL_SOCKET, SO_SNDTIMEO, timeval)
            '''

            # set IP & PORT #
            self.ip = ip
            self.port = port

            if mode == 'server':
                # IP #
                if ip is None:
                    self.ip = '0.0.0.0'

                # PORT #
                if anyPort:
                    self.port = long(0)
                elif not port:
                    self.port = SysMgr.defaultPort

                # bind #
                if bind:
                    try:
                        self.socket.bind((self.ip, self.port))
                    except OSError as e:
                        if e.errno == errno.EADDRINUSE:
                            self.port = long(0)
                            self.socket.bind((self.ip, self.port))
                        else:
                            raise e
                    except SystemExit:
                        sys.exit(0)
                    except:
                        self.socket.bind((self.ip, self.port))

                    # get bind port #
                    self.port = self.socket.getsockname()[1]

            if not blocking:
                self.socket.setblocking(0)
        except:
            err = SysMgr.getErrMsg()
            if err.startswith('13') and \
                not SysMgr.isRoot() and \
                port < 1024:
                feedback = ', use port bigger than 1024'
            else:
                feedback = ''

            # check mode to print error message #
            if SysMgr.warnEnable or \
                SysMgr.checkMode('server') or \
                SysMgr.checkMode('cli'):
                SysMgr.printErr(
                    "fail to create a socket for %s:%s as server because %s%s" % \
                        (self.ip, self.port, err, feedback))

            '''
            if error "99 Cannot assign requested address" occurs:
                add "net.ipv4.ip_nonlocal_bind = 1" in /etc/sysctl.conf
                execute sysctl -p /etc/sysctl.conf
            '''

            self.ip = None
            self.port = None

            return None



    def listen(self, nrQueue=5):
        return self.socket.listen(nrQueue)



    def accept(self):
        return self.socket.accept()



    def bind(self, ip, port):
        return self.socket.bind((ip, port))



    def write(self, message):
        return self.send(message, write=True)



    def close(self):
        if self.socket:
            ret = self.socket.close()
        else:
            ret = False

        self.socket = None

        return ret



    def flush(self):
        pass



    def timeout(self, time=3):
        if 'TIMEOUT' in SysMgr.environList:
            try:
                time = float(SysMgr.environList['TIMEOUT'][0])
            except:
                SysMgr.printErr(
                    'fail to get TIMEOUT variable', True)
                sys.exit(0)

        self.socket.settimeout(time)



    def connect(self, addr=None):
        if addr is None:
            addr = (self.ip, self.port)

        ret = self.socket.connect(addr)

        self.connected = True

        return ret



    def handleServerRequest(self, req, onlySocket=False):
        def _onDownload(req):
            # parse path #
            plist = req.split('|', 1)[1]
            path = UtilMgr.cleanItem(plist.split('@'), False)
            if len(path) == 2:
                origPath, targetPath = path
                if origPath and not targetPath:
                    origPath = targetPath
            else:
                origPath = targetPath = path[0]

            receiver = self
            targetIp = self.ip
            targetPort = self.port
            addr = '%s:%s' % (targetIp, targetPort)

            # get select object #
            selectObj = SysMgr.getPkg('select')

            # receive file #
            try:
                curSize = long(0)
                totalSize = None
                dirPos = targetPath.rfind('/')
                if dirPos >= 0 and not os.path.isdir(targetPath[:dirPos]):
                    os.makedirs(targetPath[:dirPos])

                # receive file size #
                while 1:
                    size = receiver.recv(receiver.recvSize)
                    if not size:
                        continue
                    else:
                        totalSize = long(size.decode())
                        receiver.send('ACK'.encode())
                        break

                # receive file #
                with open(targetPath, 'wb') as fd:
                    while 1:
                        selectObj.select([receiver.socket], [], [], 3)

                        buf = receiver.recv(receiver.recvSize)
                        if buf:
                            curSize += len(buf)
                            fd.write(buf)
                        else:
                            break

                        # print progress #
                        UtilMgr.printProgress(curSize, totalSize)

                UtilMgr.deleteProgress()

                SysMgr.printInfo(
                    "downloaded %s [%s] from %s:%s:%s successfully\n" % \
                    (targetPath, UtilMgr.getFileSize(targetPath),
                        targetIp, targetPort, origPath))

                res = True
            except:
                SysMgr.printErr(
                    'fail to download %s from %s in %s' % \
                        (origPath, targetPath, addr), True)
                res = False
            finally:
                receiver.close()
                return res

        def _onUpload(req):
            # parse path #
            plist = req.split('|', 1)[1]
            path = UtilMgr.cleanItem(plist.split('@'), False)
            if len(path) == 2:
                origPath, targetPath = path
                if origPath and not targetPath:
                    origPath = targetPath
            else:
                origPath = targetPath = path[0]

            sender = self
            targetIp = self.ip
            targetPort = self.port
            addr = '%s:%s' % (targetIp, targetPort)

            # check file #
            if not os.path.isfile(origPath):
                SysMgr.printErr(
                    'failed to find %s to transfer' % origPath)
                return

            try:
                # receive file size #
                stat = os.stat(origPath)
                st_size = '%s' % stat.st_size
                sender.send(st_size)

                # read for ACK #
                while 1:
                    ret = sender.recv(3)
                    if ret is None:
                        continue
                    elif ret is False:
                        sys.exit(0)
                    else:
                        break

                # transfer file #
                curSize = long(0)
                totalSize = long(st_size)
                with open(origPath, 'rb') as fd:
                    buf = fd.read(sender.sendSize)

                    while buf:
                        # print progress #
                        UtilMgr.printProgress(curSize, totalSize)

                        assert sender.send(buf)

                        curSize = len(buf)

                        buf = fd.read(sender.sendSize)

                UtilMgr.deleteProgress()

                SysMgr.printInfo(
                    "uploaded %s [%s] to %s:%s successfully\n" % \
                        (origPath, UtilMgr.getFileSize(origPath),
                            addr, targetPath))

                res = True
            except:
                SysMgr.printErr(
                    "fail to upload %s to %s in %s" % \
                        (origPath, targetPath, addr), True)
                res = False
            finally:
                sender.close()
                return res

        def _onList(req):
            SysMgr.printInfo(req.lstrip('LIST:'))
            return True

        def _onRun(req, onlySocket):
            # parse command #
            command = req.split('|', 1)[1]

            # parse addr #
            addr = '%s:%s' % (self.ip, self.port)

            if not onlySocket:
                SysMgr.printInfo(
                    "executed '%s' from %s\n" % (command, addr))

            # return just the connected socket #
            if onlySocket:
                return self

            # get select object #
            selectObj = SysMgr.getPkg('select')

            # set print flag #
            printFlag = SysMgr.getPrintFlag()

            if printFlag:
                print(oneLine)

            # run mainloop #
            isPrint = False
            while 1:
                try:
                    [readSock, writeSock, errorSock] = \
                        selectObj.select([self.socket], [], [])

                    # receive packet #
                    output = self.getData()
                    if not output:
                        break

                    if printFlag:
                        print(output[:-1])
                    isPrint = True
                except:
                    break

            # print output from server #
            if not isPrint:
                print('no response')

            if printFlag:
                print(oneLine)

            # close connection #
            try:
                self.close()
            except:
                pass



        # get select object to check reply #
        SysMgr.getPkg('select')

        # unmarshalling #
        if type(req) is tuple:
            try:
                req = req[0].decode()
            except:
                req = req[0]

            # check request #
            if not req:
                return

            # handle request #
            reqUpper = req.upper()

            if reqUpper.startswith('DOWNLOAD'):
                return _onDownload(req)

            elif reqUpper.startswith('UPLOAD'):
                return _onUpload(req)

            elif reqUpper.startswith('RUN'):
                return _onRun(req, onlySocket)

            elif reqUpper.startswith('LIST:'):
                return _onList(req)

            elif reqUpper.startswith('ERROR'):
                err = req.split('|', 1)[1]
                errToken = err.find("':")
                errMsg = "%s' from %s" % (err[:errToken], err[errToken+2:])
                SysMgr.printErr(errMsg)

            else:
                SysMgr.printErr(
                    "fail to recognize '%s' request" % req)

        elif not req:
            SysMgr.printErr(
                "no response from server")

        else:
            SysMgr.printErr(
                "received wrong reply '%s'" % req)



    def send(self, message, write=False):
        if self.ip is None or self.port is None:
            SysMgr.printWarn(
                "fail to use IP address for client because it is not set")
            return False
        elif not self.socket:
            SysMgr.printErr(
                "fail to use socket for client because it is not set")
            return False

        # encode message #
        if UtilMgr.isString(message):
            message = UtilMgr.encodeStr(message)

        try:
            # check protocol #
            if self.tcp or self.netlink:
                ret = self.socket.send(message)
            elif not write and SysMgr.localServObj:
                ret = SysMgr.localServObj.socket.sendto(
                    message, (self.ip, self.port))
            else:
                ret = self.socket.sendto(message, (self.ip, self.port))

            if ret < 0:
                raise Exception('send error')

            if self.status != 'ALWAYS':
                self.status = 'SENT'
            return True
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printErr(
                "fail to send data to %s:%d as server" % \
                (self.ip, self.port), True)
            return False



    def sendto(self, message, ip, port):
        if not ip or not port:
            SysMgr.printWarn(
                "fail to use IP address for client because it is not set")
            return False
        elif not self.socket:
            SysMgr.printErr(
                "fail to use socket for client because it is not set")
            return False

        # encode message #
        if UtilMgr.isString(message):
            message = UtilMgr.encodeStr(message)

        try:
            self.socket.sendto(message, (ip, port))
            return True
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printErr(
                "fail to send data to %s:%d as client" % \
                (self.ip, self.port), True)
            return False



    def recv(self, size=0):
        if self.ip is None or self.port is None:
            SysMgr.printWarn(
                "fail to use IP address for server because it is not set")
            return False
        elif not self.socket:
            SysMgr.printErr(
                "fail to use socket for client because it is not set")
            return False

        # set recv size #
        if size == 0:
            size = self.recvSize

        try:
            return self.socket.recv(size)
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printWarn(
                "fail to receive data from %s:%d as client" % \
                    (self.ip, self.port), reason=True)
            return False



    def getData(self, noTimeout=True):
        try:
            data = b''

            # receive and composite packets #
            while 1:
                output = self.recvfrom(noTimeout=noTimeout)

                # handle error #
                if not output:
                    continue

                # handle timeout #
                if not noTimeout and \
                    (not output[0] and not output[1]):
                    if data:
                        return data
                    else:
                        return None

                # get only data #
                output = output[0]

                # composite packets #
                data = data + output

                if not output:
                    break

                # decode data #
                try:
                    output = output.decode()
                except:
                    pass

                if len(output) < self.recvSize and \
                    output[-1] == '\n':
                    break
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printErr(
                "fail to get data from %s:%d as client" % \
                (self.ip, self.port), True)
            return None

        # decode data #
        try:
            retstr = data.decode()
            return retstr
        except:
            return data



    def setNoDelay(self):
        from socket import socket, SOL_TCP, TCP_NODELAY

        # set NODELAY for NAGLE #
        self.socket.setsockopt(SOL_TCP, TCP_NODELAY, 1)



    def recvfrom(self, size=0, noTimeout=False, verbose=True):
        if self.ip is None or self.port is None:
            SysMgr.printWarn(
                "fail to use IP address for server because it is not set")
            return False
        elif not self.socket:
            SysMgr.printErr(
                "fail to use socket for client because it is not set")
            return False

        # get socket object #
        socket = SysMgr.getPkg('socket', False)
        if not socket:
            return

        # set recv size #
        if size == 0:
            size = self.recvSize

        while 1:
            try:
                message, address = self.socket.recvfrom(size)
                return (message, address)
            except socket.timeout:
                if noTimeout:
                    continue
                SysMgr.printWarn(
                    "fail to receive data from %s:%d as client because of %s" % \
                    (self.ip, self.port, 'timeout'))
                return None
            except KeyboardInterrupt:
                sys.exit(0)
            except SystemExit:
                sys.exit(0)
            except:
                if verbose:
                    SysMgr.printWarn(
                        "fail to receive data from %s:%d as client" % \
                            (self.ip, self.port), reason=True)
                return None



    @staticmethod
    def getDataType(data):
        if not data:
            return 'None'

        data = data.lstrip()

        if data.startswith('{'):
            return 'JSON'
        elif '[INFO' in data[:10] or \
            '[ERROR' in data[:10] or \
            '[WARN' in data[:10] or \
            '[STEP' in data[:10]:
            return 'LOG'
        else:
            return 'CONSOLE'



    @staticmethod
    def requestCmd(connObj, cmd):
        if not connObj:
            return

        # send request to server #
        connObj.send(cmd)

        # receive reply from server #
        reply = connObj.recvfrom()

        # handle reply from server #
        try:
            connObj.handleServerRequest(reply)
        except:
            return



    @staticmethod
    def requestPing(addr=None, verb=True):
        return NetworkMgr.execRemoteCmd("PING:PING", addr=addr, verb=verb)



    @staticmethod
    def getCmdPipe(connObj, cmd):
        if not cmd:
            return None

        # define valid request list #
        requestList = {
            'DOWNLOAD': None,
            'UPLOAD': None,
            'RUN': None,
            'BROADCAST': None,
            'NEW': None,
            'PING': None,
            'LIST': None,
        }

        # add command prefix #
        reqList = cmd.upper().split(':')
        if reqList[0] in requestList:
            pass
        elif not cmd.startswith('run:'):
            cmd = 'run:%s' % cmd

        # send request to server #
        connObj.send(cmd)

        # receive reply from server #
        reply = connObj.recvfrom()
        try:
            if not reply:
                raise Exception()

            msg = reply[0].decode()
            if not msg:
                pass
            elif msg == 'PONG':
                return True
            elif msg == 'NO_SERV_NODE':
                SysMgr.printErr(
                    'no service node to %s:%s' % (connObj.ip, connObj.port))
                return True
            elif msg.startswith('MSG:'):
                # print message in the packet #
                SysMgr.printInfo(msg.strip('MSG:'))

                # send ACK to prevent receiving two packegs at once #
                connObj.send('ACK')

                # wait for a request again #
                reply = connObj.recvfrom()
            elif msg.startswith('LIST:'):
                reply = (msg,)
        except:
            pass

        # handle reply from server #
        try:
            return connObj.handleServerRequest(reply, onlySocket=True)
        except:
            return None



    @staticmethod
    def execRemoteCmd(command, addr=None, verb=True):
        # get new connection #
        connObj = NetworkMgr.getServerConn(addr, verb)
        if not connObj:
            return None

        # launch remote command #
        pipe = NetworkMgr.getCmdPipe(connObj, command)
        return pipe



    @staticmethod
    def getServerConn(addr=None, verb=True):
        def _printErr():
            SysMgr.printErr(
                "no running server or wrong server address")

        # set server address in local #
        if addr:
            # classify IP and PORT #
            service, ip, port = NetworkMgr.parseAddr(addr)
            if service == ip == port == None:
                _printErr()
                return None
            else:
                NetworkMgr.setRemoteServer('%s:%s' % (ip, port), tcp=True)
        elif SysMgr.isLinux and not SysMgr.remoteServObj:
            try:
                addr = SysMgr.getProcNetAddrs(__module__)
            except:
                addr = None

            if not addr:
                return None

            # classify IP and PORT #
            service, ip, port = NetworkMgr.parseAddr(addr)
            if service == ip == port == None:
                _printErr()
                return None
            else:
                NetworkMgr.setRemoteServer(addr, tcp=True)
        # set server address again #
        elif SysMgr.remoteServObj:
            servObj = SysMgr.remoteServObj
            ip = servObj.ip
            port = servObj.port
            NetworkMgr.setRemoteServer('%s:%s' % (ip, port), tcp=True)

        # check server address #
        if not SysMgr.remoteServObj:
            _printErr()
            return None

        # bind local socket for UDP #
        try:
            if not SysMgr.remoteServObj.tcp and SysMgr.localServObj:
                lip = SysMgr.localServObj.ip
                lport = SysMgr.localServObj.port
                SysMgr.remoteServObj.socket.bind((lip, lport))
        except:
            SysMgr.printErr(
                "fail to bind socket to %s:%s for connection" % \
                    (lip, lport), True)

        # do connect to server #
        try:
            connObj = SysMgr.remoteServObj

            if not 'NOTIMEOUT' in SysMgr.environList:
                connObj.timeout()

            # connect with handling CLOSE_WAIT #
            while 1:
                try:
                    connObj.connect()
                    break
                except SystemExit:
                    sys.exit(0)
                except:
                    SysMgr.printWarn(
                        "fail to connect to %s:%s" % (ip, port),
                            reason=True, always=verb)
                    et, err, to = sys.exc_info()
                    if err.args and err.args[0] == 99:
                        time.sleep(0.1)
                        continue
                    else:
                        raise Exception(err.args[0])

            return connObj
        except SystemExit:
            sys.exit(0)
        except:
            if verb:
                SysMgr.printErr(
                    "fail to set socket for connection", True)
            return None



    @staticmethod
    def parseAddr(value):
        service = None
        ip = None
        port = None

        if not UtilMgr.isString(value):
            return (service, ip, port)

        # get request and address #
        cmdList = value.split('@')
        if len(cmdList) >= 2:
            service = cmdList[0]
            addr = cmdList[1]
        else:
            addr = value

        # get IP and PORT #
        addrList = addr.split(':')
        if len(addrList) >= 2:
            try:
                if len(addrList[0]) > 0:
                    ip = addrList[0]
                if len(addrList[1]) > 0:
                    port = long(addrList[1])
            except:
                pass
        else:
            try:
                if '.' in addrList[0]:
                    ip = addrList[0]
                else:
                    port = long(addrList[0])
            except:
                pass

        return (service, ip, port)



    @staticmethod
    def setRemoteServer(value, tcp=False):
        # receive mode #
        if not value:
            SysMgr.remoteServObj = 'NONE'
            return

        # request mode #
        service, ip, port = NetworkMgr.parseAddr(value)

        # set PRINT as default #
        if not service:
            service = 'PRINT'

        if not ip:
            ip = NetworkMgr.getPublicIp()

        if not port:
            port = SysMgr.defaultPort

        # check server addresses #
        if SysMgr.localServObj and \
            SysMgr.localServObj.ip == ip and \
            SysMgr.localServObj.port == port:
            SysMgr.printErr((
                "wrong value for remote connection, "
                "local address and remote address are same "
                "with %s:%s") % (ip, port))
            sys.exit(0)

        if not ip or not port or \
            not SysMgr.isValidRequest(service):
            reqList = ''
            for req in TaskAnalyzer.requestType:
                reqList += req + '|'

            SysMgr.printErr(
                ("wrong input address, "
                 "input [%s]@IP:PORT as remote address") % \
                    reqList[:-1])
            sys.exit(0)

        # create a socket #
        networkObject = NetworkMgr('client', ip, port, tcp=tcp)
        if not networkObject.ip:
            sys.exit(0)
        else:
            networkObject.request = service
            SysMgr.remoteServObj = networkObject

        # set protocol #
        if tcp:
            proto = 'TCP'
        else:
            proto = 'UDP'

        SysMgr.printInfo(
            "use %s:%d(%s) as remote address" % (ip, port, proto))

        return SysMgr.remoteServObj



    @staticmethod
    def setRemoteNetwork(service, ip, port):
        # set default service #
        if not service:
            service = 'PRINT'

        errMsg = ("wrong value for remote server, "
                  "input in the format [%s]@IP:PORT") % \
                    '|'.join(TaskAnalyzer.requestType)

        if not ip or not SysMgr.isValidRequest(service):
            SysMgr.printErr(errMsg)
            sys.exit(0)

        if not port:
            port = SysMgr.defaultPort

        networkObject = NetworkMgr('client', ip, port)
        if not networkObject.ip:
            sys.exit(0)
        else:
            networkObject.status = 'ALWAYS'
            networkObject.request = service
            naddr = '%s:%s' % (ip, str(port))

            if service == 'PRINT':
                SysMgr.addrListForPrint[naddr] = networkObject
            elif service.startswith('REPORT_'):
                SysMgr.reportEnable = True
                SysMgr.addrListForReport[naddr] = networkObject
            else:
                SysMgr.printErr(errMsg)

        SysMgr.printInfo(
            "use %s:%d as remote address to request %s" % \
                (ip, port, service))



    @staticmethod
    def setServerNetwork(
        ip, port, force=False, blocking=False,
        tcp=False, anyPort=False, reuse=True):

        if SysMgr.localServObj and not force:
            SysMgr.printWarn(
                "ignored to set server network because it is already set")
            return

        # get internet available IP first #
        if not ip:
            ip = NetworkMgr.getPublicIp()

        # print available IP list #
        try:
            iplist = sorted(NetworkMgr.getUsingIps())
            if iplist:
                SysMgr.printWarn(
                    'available IP list [ %s ]' % ', '.join(iplist))
        except:
            pass

        # check server setting #
        if SysMgr.localServObj and \
            SysMgr.localServObj.socket and \
            SysMgr.localServObj.ip == ip and \
            SysMgr.localServObj.port == port:
            if blocking:
                SysMgr.localServObj.socket.setblocking(1)
            else:
                SysMgr.localServObj.socket.setblocking(0)
            return

        # create a new server setting #
        networkObject = NetworkMgr(
            'server', ip, port, blocking, tcp, anyPort, reuse=reuse)
        if not networkObject.ip:
            SysMgr.printWarn("fail to set server IP")
            return

        if tcp:
            proto = 'TCP'
        else:
            proto = 'UDP'

        SysMgr.localServObj = networkObject
        SysMgr.printInfo(
            "use %s:%d(%s) as local address" % \
            (SysMgr.localServObj.ip,
                SysMgr.localServObj.port, proto))

        return networkObject



    @staticmethod
    def prepareServerConn(cliAddr, servAddr):
        # set local address #
        if not cliAddr:
            NetworkMgr.setServerNetwork(None, None, anyPort=True)
        else:
            service, ip, port = NetworkMgr.parseAddr(cliAddr)

            NetworkMgr.setServerNetwork(ip, port)

        # set remote address #
        if servAddr:
            NetworkMgr.setRemoteServer(servAddr)

        # set client address #
        if SysMgr.localServObj:
            cliIp = SysMgr.localServObj.ip
            cliPort = SysMgr.localServObj.port
        else:
            cliIp = None
            cliPort = None

        # set server address #
        if SysMgr.remoteServObj.ip:
            servIp = SysMgr.remoteServObj.ip
            servPort = SysMgr.remoteServObj.port
        else:
            servIp = None
            servPort = None

        return (cliIp, cliPort), (servIp, servPort)



    @staticmethod
    def getRepMacAddr():
        dirPath = '/sys/class/net'

        try:
            devices = os.listdir(dirPath)
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printOpenErr(dirPath)
            return

        for dev in devices:
            if dev == 'lo':
                continue

            target = '%s/%s/address' % (dirPath, dev)
            try:
                with open(target, 'r') as fd:
                    addr = fd.readline()[:-1]
                    return (dev, addr)
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printOpenErr(target)

        return ('None', 'None')



    @staticmethod
    def getUsingIps():
        effectiveList = {}
        connPaths = \
            ['%s/net/udp' % SysMgr.procPath,
            '%s/net/tcp' % SysMgr.procPath]

        for path in connPaths:
            try:
                with open(path, 'r') as fd:
                    ipList = fd.readlines()

                # remove title #
                ipList.pop(0)

                for line in ipList:
                    items = line.split()
                    ip = SysMgr.convertCIDR(items[1].split(':')[0])
                    effectiveList[ip] = None
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printOpenWarn(path)

        return list(effectiveList.keys())



    @staticmethod
    def getGateways():
        gateways = {}

        ips = NetworkMgr.getRoutedIps()

        for item in ips:
            try:
                ip = item[1]
                if ip == '0.0.0.0' or \
                    ip == '127.0.0.1' or \
                    not ip.endswith('.1'):
                    continue

                gw = '%s.1' % ip[:ip.rfind('.')]
                gateways[gw] = None
            except SystemExit:
                sys.exit(0)
            except:
                pass

        return list(gateways.keys())



    @staticmethod
    def getMainIp():
        ipList = {}

        ipList = NetworkMgr.getUsingIps()

        # remove invaild ip #
        try:
            ipList.remove('0.0.0.0')
        except:
            pass

        if not ipList or not ipList:
            return None
        elif '127.0.0.1' in ipList:
            return '127.0.0.1'
        else:
            return list(sorted(ipList, reverse=True))[0]



    @staticmethod
    def getRoutedIps():
        effectiveList = []
        routePath = '%s/net/route' % SysMgr.procPath
        try:
            with open(routePath, 'r') as fd:
                ipList = fd.readlines()

            # remove title #
            ipList.pop(0)

            for line in ipList:
                items = line.split()
                effectiveList.append(
                    [items[0], SysMgr.convertCIDR(items[1])])

            return effectiveList
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printOpenWarn(routePath)
            return effectiveList



    @staticmethod
    def getPublicIp():
        # get socket object #
        socket = SysMgr.getPkg('socket', False)
        if not socket:
            return

        from socket import socket, AF_INET, SOCK_DGRAM, SOCK_STREAM

        ret = None

        try:
            s = socket(AF_INET, SOCK_STREAM)
            s.settimeout(0.3)

            # connect to google public IP #
            s.connect(("8.8.8.8", 53))

            ret = s.getsockname()[0]
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printWarn("fail to get public IP address")

        if not ret:
            ret = NetworkMgr.getMainIp()

        return ret



    def __del__(self):
        try:
            self.close()
        except:
            pass





class Timeline(object):
    class Segment(object):
        def __init__(self, group, time_start, time_end, extra):
            self.group = group
            self.time_start = time_start
            self.time_end = time_end
            self.text = None
            self.id = None
            self.color = None
            self.state = None
            self._init_extra(extra)

        def _init_extra(self, extra):
            if "text" in extra:
                self.text = extra["text"]

            if "id" in extra:
                self.id = extra["id"]

            if "color" in extra:
                self.color = extra["color"]

            if "state" in extra:
                self.state = extra["state"]



    class Config(object):
        def _conv_palette(self, palette):
            # get svgwrite object #
            svgwrite = SysMgr.getPkg('svgwrite')

            plist = []
            for palette_entry in palette:
                rgb = [int(rgb_value) for rgb_value in \
                    re.findall("\d+", palette_entry)]
                plist.append(svgwrite.rgb(rgb[0], rgb[1], rgb[2]))
            return plist

        def __init__(self):
            self.WIDTH = 1500
            self.HEIGHT = 770
            self.TIME_AXIS_HEIGHT = 1
            self.TICKS = 100
            self.LABEL_SIZE_MIN = 0

            # set font size #
            if 'FONTSIZE' in SysMgr.environList:
                try:
                    val = SysMgr.environList['FONTSIZE'][0]
                    self.FONT_SIZE = long(val)
                except:
                    SysMgr.printErr(
                        "fail to set font size to '%s'" % val, True)
                    sys.exit(0)
            else:
                self.FONT_SIZE = 3

            palette = [
                "(0,150,136)", "(0,188,212)", "(0,0,128)",
                "(0,0,139)", "(0,0,205)", "(0,0,255)",
                "(0,100,0)", "(0,128,0)", "(0,128,128)",
                "(0,139,139)", "(0,191,255)", "(0,206,209)",
                "(0,250,154)", "(0,255,0)", "(0,255,127)",
                "(0,255,255)", "(100,149,237)", "(102,205,170)",
                "(103,58,183)", "(106,90,205)", "(107,142,35)",
                "(121,85,72)", "(123,104,238)", "(124,252,0)",
                "(127,255,0)", "(127,255,212)", "(128,0,0)",
                "(128,0,128)", "(128,128,0)", "(128,128,128)",
                "(135,206,235)", "(135,206,250)", "(138,43,226)",
                "(139,195,74)", "(139,0,0)", "(139,0,139)",
                "(139,69,19)", "(143,188,143)", "(144,238,144)",
                "(147,112,219)", "(148,0,211)", "(152,251,152)",
                "(153,50,204)", "(154,205,50)", "(156,39,176)",
                "(158,158,158)", "(160,82,45)", "(165,42,42)",
                "(173,216,230)", "(173,255,47)", "(175,238,238)",
                "(176,224,230)", "(178,34,34)", "(184,134,11)",
                "(186,85,211)", "(188,143,143)", "(189,183,107)",
                "(192,192,192)", "(199,21,133)", "(205,133,63)",
                "(205,220,57)", "(205,92,92)", "(210,105,30)",
                "(210,180,140)", "(216,191,216)", "(218,112,214)",
                "(218,165,32)", "(219,112,147)", "(220,20,60)",
                "(221,160,221)", "(222,184,135)", "(224,255,255)",
                "(233,150,122)", "(233,30,99)", "(238,130,238)",
                "(238,232,170)", "(240,128,128)", "(240,230,140)",
                "(244,67,54)", "(244,164,96)", "(245,222,179)",
                "(245,245,220)", "(25,25,112)", "(250,128,114)",
                "(250,235,215)", "(250,250,210)", "(255,0,0)",
                "(255,0,255)", "(255,105,180)", "(255,127,80)",
                "(255,140,0)", "(255,152,0)", "(255,160,122)",
                "(255,165,0)", "(255,182,193)", "(255,192,203)",
                "(255,193,7)", "(255,20,147)", "(255,215,0)",
                "(255,228,196)", "(255,235,205)", "(255,235,59)",
                "(255,248,220)", "(255,250,205)", "(255,255,0)",
                "(255,255,224)", "(255,69,0)", "(255,87,34)",
                "(255,99,71)", "(3,169,244)", "(30,144,255)",
                "(32,178,170)", "(33,150,243)", "(34,139,34)",
                "(46,139,87)", "(47,79,79)", "(50,205,50)",
                "(60,179,113)", "(63,81,181)", "(64,224,208)",
                "(65,105,225)", "(70,130,180)", "(72,209,204)",
                "(72,61,139)", "(75,0,130)", "(76,175,80)",
                "(85,107,47)", "(95,158,160)", "(96,125,139)",
            ]

            self.PALETTE = self._conv_palette(palette)

            # shuffle list #
            random = SysMgr.getPkg('random', False)
            if random:
                random.shuffle(self.PALETTE)

        @staticmethod
        def _load(file_name=None, data=None):
            if file_name:
                with open(file_name) as fd:
                    data = fd.read()
                    data = UtilMgr.convStr2Dict(data)
            elif not data:
                SysMgr.printErr('no path or data for timeline config')
                sys.exit(0)

            config = Timeline.Config()
            config.WIDTH = data.get("width", 20000)
            config.HEIGHT = data.get("height", 4000)
            config.FONT_SIZE = data.get("font_size", 3)
            config.TICKS = data.get("time_ticks", 5)
            config.TIME_AXIS_HEIGHT = data.get("time_axis_height", 5)
            config.LABEL_SIZE_MIN = data.get("label_size_min", 5)
            config.PALETTE = config._conv_palette(data.get("palette", []))
            config.TIMEUNIT = data.get("time_unit", None)
            config.TIMEFACTOR = data.get("time_factor", 1)

            return config



    def __init__(
        self, title, segments, time_unit, fontsize, config, tasks=[]):

        self.title = title
        self.segments = segments
        self.time_unit = time_unit
        self.config = config

        self.time_start = \
            min(segments, key=lambda segment: segment.time_start).time_start
        self.time_end = \
            max(segments, key=lambda segment: segment.time_end).time_end
        self.segment_groups = set(s.group for s in self.segments)
        self.groups = len(self.segment_groups)
        self.group_list = list(self.segment_groups)
        self.scaled_height = self.config.HEIGHT / self.groups

        try:
            self.ratio = \
                self.config.WIDTH / float(self.time_end - self.time_start)
        except:
            SysMgr.printErr(
                'fail to recognize timeline because start and end are same')
            sys.exit(0)

        self.tasks = tasks
        self.last_group_segment = dict()
        self.last_group_time = dict()
        self.height_group_pos = dict()
        self.last_iogroup_segment = dict()
        self.last_iogroup_time = dict()
        self.height_iogroup_pos = dict()

        # time factor #
        if hasattr(self.config, 'TIMEFACTOR'):
            self.time_factor = self.config.TIMEFACTOR
        else:
            self.time_factor = 1

        # task color #
        if self.tasks:
            self.color_map = self._build_task_color_map()
        else:
            self.color_map = self._build_color_map()

        # update font size #
        if fontsize and self.config:
            self.config.FONT_SIZE = fontsize



    def _build_task_color_map(self):
        color_map = {}
        palette = self.config.PALETTE
        for i, group in enumerate(self.tasks):
            color_map[group] = palette[i % len(palette)]
        return color_map



    def _build_color_map(self):
        color_map = {}
        palette = self.config.PALETTE
        segment_groups = self.segment_groups
        for i, group in enumerate(segment_groups):
            color_map[group] = palette[i % len(palette)]
        return color_map



    def _draw_grid(self, dwg):
        for x in range(0, self.config.WIDTH, self.config.TICKS):
            dwg.add(dwg.line(
                (x, 0), (x, self.config.HEIGHT),
                stroke='black', stroke_width=0.1))



    def _draw_group_axis(self, dwg):
        dwg.add(dwg.rect(
            (0, 0),
            (self.config.TIME_AXIS_HEIGHT, self.config.HEIGHT), fill='black'))

        idx = 0
        groupList = list(self.segment_groups)
        for y_tick in range(0, self.config.HEIGHT):
            try:
                name = groupList[idx]
                idx += 1
            except:
                continue

            y_tick *= self.scaled_height

            dwg.add(dwg.line(
                (0, y_tick), (self.config.WIDTH, y_tick),
                stroke='black', stroke_width=0.1))

            dwg.add(dwg.text(
                name, (self.config.FONT_SIZE, y_tick+self.scaled_height),
                font_size=self.scaled_height/2,
                fill='rgb(220,220,220)'))



    def _draw_time_axis(self, dwg):
        dwg.add(dwg.rect(
            (0, self.config.HEIGHT),
            (self.config.WIDTH, self.config.TIME_AXIS_HEIGHT), fill='black'))

        y_time_tick = self.config.HEIGHT + self.config.TIME_AXIS_HEIGHT / 2

        for x_tick_time in range(0, self.config.WIDTH, self.config.TICKS):
            tick_time = "{:10}".format(long(x_tick_time * (1 / self.ratio)))
            dwg.add(dwg.text(
                '%s %s' % (UtilMgr.convNum(tick_time), self.time_unit),
                (x_tick_time, y_time_tick + self.config.FONT_SIZE*5),
                font_size=self.config.FONT_SIZE*5,
                color='rgb(255,255,255)'))



    def _draw_background(self, dwg):
        dwg.add(dwg.rect((0, 0),
            (self.config.WIDTH, self.config.HEIGHT),
            fill='rgb(245,245,245)'))

        # set title #
        if self.title:
            title = self.title
        else:
            title = 'Guider Timeline Chart'

        # set font size for title #
        fontsize = self.config.FONT_SIZE * 10

        dwg.add(dwg.text(title,
            ((self.config.WIDTH/2)-(len(title)*fontsize/4), fontsize),
            font_size=fontsize,
            font_weight='bolder',
            fill='rgb(230,230,230)'))



    def _draw_segments(self, dwg):
        for idx, segment in enumerate(self.segments):
            UtilMgr.printProgress(idx, len(self.segments))
            self._draw_segment(segment, dwg)
        UtilMgr.deleteProgress()



    def _draw_segment(self, segment, dwg):
        x0 = float(segment.time_start - self.time_start) * self.ratio
        x1 = float(segment.time_end - self.time_start) * self.ratio
        group_idx = self.group_list.index(segment.group)
        y0 = self.scaled_height * float(group_idx % self.groups)
        y1 = self.scaled_height * float((group_idx % self.groups)+1)
        scaled_width = (x1 - x0)
        scaled_top_height = y0 + (self.scaled_height / 7)
        scaled_bottom_height = y1 - (self.scaled_height * 0.25)

        # get color id #
        if segment.color:
            color = segment.color
        else:
            if segment.id:
                colorid = segment.id
            else:
                colorid = group_idx

            # get real color via id #
            try:
                color = self.color_map[colorid]
            except:
                color = self.color_map[list(self.color_map.keys())[0]]

        # draw bold line for core off #
        if segment.state == 'OFF':
            dwg.add(dwg.line(
                (x0, y0), (x1, y0),
                stroke='black', stroke_width=1.5))
            return

        # draw circle and text for event #
        if segment.state and segment.state.startswith('EVENT'):
            if segment.state == 'EVENT_MARK':
                font_size = self.config.FONT_SIZE
            elif segment.state == 'EVENT_USER':
                font_size = self.config.FONT_SIZE * 3
            else:
                font_size = self.config.FONT_SIZE

            dwg.add(dwg.circle(
                center=(x0,y0), r=font_size/2,
                stroke='darkgreen', fill='darkgreen'))

            # draw text #
            dwg.add(dwg.text(segment.text,
                (x0+font_size, y0), fill='darkgreen', stroke='none',
                font_size=font_size, font_weight='bolder'))

            return

        # draw line for block_read status #
        if segment.state == 'RD':
            dwg.add(dwg.rect((x0, scaled_bottom_height),
                (scaled_width, self.scaled_height*0.25),
                rx=1, ry=1, fill='purple', fill_opacity=0.5))
        # draw line for block_write status #
        elif segment.state == 'WR':
            dwg.add(dwg.rect((x0, scaled_bottom_height),
                (scaled_width, self.scaled_height*0.25),
                rx=1, ry=1, fill='darkcyan', fill_opacity=0.5))
        # draw line for syscall status #
        elif segment.state == 'SYSCALL':
            dwg.add(dwg.rect((x0, y0),
                (scaled_width, self.scaled_height*0.5),
                rx=1, ry=1, fill=color, fill_opacity=0.5))
        # draw line for sched status #
        else:
            # draw timeslice #
            dwg.add(dwg.rect((x0, y0),
                (scaled_width, self.scaled_height),
                rx=1, ry=1, fill=color, fill_opacity=0.5))

            # draw preempted status #
            if segment.state == 'R':
                dwg.add(dwg.line(
                    (x1, y0), (x1, scaled_top_height),
                    stroke='red', stroke_width=0.3))
            # draw wait status #
            elif segment.state == 'D':
                dwg.add(dwg.line(
                    (x1, y0), (x1, scaled_top_height),
                    stroke='black', stroke_width=0.3))

        # check duration #
        duration = segment.time_end - segment.time_start
        if not SysMgr.showAll and \
            (scaled_width < self.config.LABEL_SIZE_MIN or duration == 0):
            return

        # convert duration to text #
        if duration == 0:
            duration = '~'
        else:
            duration = '~%s' % (UtilMgr.convNum(duration))

        # I/O #
        if segment.state == 'RD' or segment.state == 'WR':
            # initialize group data #
            self.last_iogroup_segment.setdefault(group_idx, None)
            self.last_iogroup_time.setdefault(group_idx, x0)

            # define data #
            last_iogroup_segment = self.last_iogroup_segment[group_idx]
            last_iogroup_time = self.last_iogroup_time[group_idx]

            # set text attributes for block_read #
            if segment.state == 'RD':
                if last_iogroup_segment == segment.text and \
                    x0 - last_iogroup_time < self.config.TICKS:
                    segment_label = duration
                    font_size = self.config.FONT_SIZE - 1
                else:
                    segment_label = "> %s | %s" % (segment.text, duration)
                    font_size = self.config.FONT_SIZE - 0.7
                color = 'rgb(128,0,128)'
            # set text attributes for block_write #
            elif segment.state == 'WR':
                if last_iogroup_segment == segment.text and \
                    x0 - last_iogroup_time < self.config.TICKS:
                    segment_label = duration
                    font_size = self.config.FONT_SIZE - 1
                else:
                    segment_label = "> %s | %s" % (segment.text, duration)
                    font_size = self.config.FONT_SIZE - 0.7
                color = 'rgb(0,139,139)'

            # update group info #
            self.last_iogroup_segment[group_idx] = segment.text
            self.last_iogroup_time[group_idx] = x0
            self.height_iogroup_pos.setdefault(group_idx, 0)

            # set text position #
            scaled_pos = self.scaled_height * 0.75
            self.height_iogroup_pos[group_idx] += self.config.FONT_SIZE
            height_pos = self.height_iogroup_pos[group_idx]
            if height_pos + scaled_pos >= self.scaled_height:
                height_pos = \
                    self.height_iogroup_pos[group_idx] = \
                    self.config.FONT_SIZE
        # CPU #
        else:
            # initialize group data #
            self.last_group_segment.setdefault(group_idx, None)
            self.last_group_time.setdefault(group_idx, x0)

            # set text attributes for same task #
            if self.last_group_segment[group_idx] == segment.text and \
                x0 - self.last_group_time[group_idx] < self.config.TICKS:
                segment_label = duration
                color = 'rgb(50,50,50)'
                font_size = self.config.FONT_SIZE - 1
            # set text attributes for new task #
            else:
                segment_label = "> %s | %s" % (segment.text, duration)
                color = 'rgb(255,0,0)'
                font_size = self.config.FONT_SIZE - 0.5

            # update group info #
            self.last_group_segment[group_idx] = segment.text
            self.last_group_time[group_idx] = x0
            self.height_group_pos.setdefault(group_idx, 0)

            # set text position #
            scaled_pos = self.scaled_height * 0.15
            self.height_group_pos[group_idx] += self.config.FONT_SIZE
            height_pos = self.height_group_pos[group_idx]
            if height_pos + scaled_pos*2.5 >= self.scaled_height:
                height_pos = self.height_group_pos[group_idx] = 0

        xpos = x0
        ypos = y0 + scaled_pos + height_pos

        # draw text #
        dwg.add(dwg.text(segment_label,
            (xpos, ypos),
            fill=color, stroke='none',
            font_size=font_size,
            font_weight='normal',
            transform='rotate(0,%s,%s)' % (xpos, ypos)))



    def draw(self, dwg):
        self._draw_background(dwg)
        self._draw_grid(dwg)
        self._draw_group_axis(dwg)
        self._draw_time_axis(dwg)
        self._draw_segments(dwg)



    @staticmethod
    def load(file_name=None, data=None, config=None, tasks=None):
        if file_name:
            with open(file_name) as json_file:
                # get json object #
                json = SysMgr.getPkg('json')

                data = json.load(json_file)
        elif not data:
            SysMgr.printErr('no path or data for timeline input')
            sys.exit(0)

        # get default timeunit #
        time_unit = ''
        if "time_unit" in data:
            time_unit = data["time_unit"]
            time_unit = time_unit.lower()

        # get title #
        if "title" in data:
            title = data['title']
        else:
            title = ''

        # get title #
        if "font_size" in data:
            fontsize = data['font_size']
        else:
            fontsize = None

        # get configured timeunit #
        time_factor = 1.0
        if hasattr(config, 'TIMEUNIT') and config.TIMEUNIT:
            new_time_unit = config.TIMEUNIT.lower()

            if time_unit == new_time_unit:
                pass
            elif time_unit == 'ns':
                if new_time_unit == 'ms':
                    time_factor = 1/1000.0
                elif new_time_unit == 'sec':
                    time_factor = 1/1000000.0
                else:
                    SysMgr.printErr(
                        "no support '%s' unit for timeline" % new_time_unit)
            elif time_unit == 'ms':
                if new_time_unit == 'ns':
                    time_factor = 1000.0
                elif new_time_unit == 'sec':
                    time_factor = 1/1000.0
                else:
                    SysMgr.printErr(
                        "no support '%s' unit for timeline" % new_time_unit)
            else:
                SysMgr.printErr(
                    "no support '%s' unit for timeline" % new_time_unit)

            time_unit = new_time_unit
            config.TIMEFACTOR = time_factor

        if time_unit:
            SysMgr.printInfo(
                "apply '%s' in timeunit" % time_unit)

        # load segments #
        segments = Timeline._load_segments(data, time_factor)

        return Timeline(title, segments, time_unit, fontsize, config, tasks)



    @staticmethod
    def _load_segments(data, time_factor=1):
        segments = []
        for segment_data in sorted(
            data["segments"], key=lambda e: e['time_start']):
            # apply core filter #
            if SysMgr.perCoreDrawList:
                if not segment_data['group'] in SysMgr.perCoreDrawList:
                    continue

            # verify time #
            if segment_data["time_start"] > segment_data["time_end"]:
                SysMgr.printWarn(
                    "time_start is bigger than time_end for %s" % \
                        segment_data)
                continue

            time_start = long(segment_data["time_start"] * time_factor)
            time_end = long(segment_data["time_end"] * time_factor)

            # add segment #
            segments.append(Timeline.Segment(
                segment_data["group"], time_start, time_end, segment_data))

        return segments





'''
class GlMgr(object):
    """ Manager for GL """

    instance = None

    @staticmethod
    def init():
        SysMgr.importPkgItems('ctypes')

        try:
            # load libglesobj library #
            if not SysMgr.libglesObj:
                SysMgr.libglesObj = SysMgr.loadLib(SysMgr.libglesPath)
        except:
            SysMgr.printErr(
                "fail to load GLES object")
            sys.exit(0)

        gl = GlMgr.instance = SysMgr.libglesObj
        gl.glActiveShaderProgram.argtypes = [c_uint32, c_uint32]
        gl.glActiveShaderProgram.restype = None
        gl.glActiveTexture.argtypes = [c_uint]
        gl.glActiveTexture.restype = None
        gl.glAttachShader.argtypes = [c_uint32, c_uint32]
        gl.glAttachShader.restype = None
        gl.glBeginQuery.argtypes = [c_uint, c_uint32]
        gl.glBeginQuery.restype = None
        gl.glBeginTransformFeedback.argtypes = [c_uint]
        gl.glBeginTransformFeedback.restype = None
        gl.glBindAttribLocation.argtypes = [c_uint32, c_uint32, POINTER(c_char)]
        gl.glBindAttribLocation.restype = None
        gl.glBindBuffer.argtypes = [c_uint, c_uint32]
        gl.glBindBuffer.restype = None
        gl.glBindBufferBase.argtypes = [c_uint, c_uint32, c_uint32]
        gl.glBindBufferBase.restype = None
        gl.glBindBufferRange.argtypes = [c_uint, c_uint32, c_uint32, c_size_t, c_ssize_t]
        gl.glBindBufferRange.restype = None
        gl.glBindFramebuffer.argtypes = [c_uint, c_uint32]
        gl.glBindFramebuffer.restype = None
        gl.glBindImageTexture.argtypes = [c_uint32, c_uint32, c_int32, c_ubyte, c_int32, c_uint, c_uint]
        gl.glBindImageTexture.restype = None
        gl.glBindProgramPipeline.argtypes = [c_uint32]
        gl.glBindProgramPipeline.restype = None
        gl.glBindRenderbuffer.argtypes = [c_uint, c_uint32]
        gl.glBindRenderbuffer.restype = None
        gl.glBindSampler.argtypes = [c_uint32, c_uint32]
        gl.glBindSampler.restype = None
        gl.glBindTexture.argtypes = [c_uint, c_uint]
        gl.glBindTexture.restype = None
        gl.glBindTransformFeedback.argtypes = [c_uint, c_uint32]
        gl.glBindTransformFeedback.restype = None
        gl.glBindVertexArray.argtypes = [c_uint32]
        gl.glBindVertexArray.restype = None
        gl.glBindVertexBuffer.argtypes = [c_uint32, c_uint32, c_size_t, c_size_t]
        gl.glBindVertexBuffer.restype = None
        gl.glBlendColor.argtypes = [c_float, c_float, c_float, c_float]
        gl.glBlendColor.restype = None
        gl.glBlendEquation.argtypes = [c_uint]
        gl.glBlendEquation.restype = None
        gl.glBlendEquationSeparate.argtypes = [c_uint, c_uint]
        gl.glBlendEquationSeparate.restype = None
        gl.glBlendEquationSeparatei.argtypes = [c_uint32, c_uint, c_uint]
        gl.glBlendEquationSeparatei.restype = None
        gl.glBlendEquationi.argtypes = [c_uint32, c_uint]
        gl.glBlendEquationi.restype = None
        gl.glBlendFunc.argtypes = [c_uint, c_uint]
        gl.glBlendFunc.restype = None
        gl.glBlendFuncSeparate.argtypes = [c_uint, c_uint, c_uint, c_uint]
        gl.glBlendFuncSeparate.restype = None
        gl.glBlendFuncSeparatei.argtypes = [c_uint32, c_uint, c_uint, c_uint, c_uint]
        gl.glBlendFuncSeparatei.restype = None
        gl.glBlendFunci.argtypes = [c_uint32, c_uint, c_uint]
        gl.glBlendFunci.restype = None
        gl.glBlitFramebuffer.argtypes = [c_int32, c_int32, c_int32, c_int32, c_int32, c_int32, c_int32, c_int32, c_uint, c_uint]
        gl.glBlitFramebuffer.restype = None
        gl.glBufferData.argtypes = [c_uint, c_ssize_t, c_void_p, c_uint]
        gl.glBufferData.restype = None
        gl.glBufferSubData.argtypes = [c_uint, c_size_t, c_ssize_t, c_void_p]
        gl.glBufferSubData.restype = None
        gl.glCheckFramebufferStatus.argtypes = [c_uint]
        gl.glCheckFramebufferStatus.restype = c_uint
        gl.glClear.argtypes = [c_uint]
        gl.glClear.restype = None
        gl.glClearBufferfi.argtypes = [c_uint, c_int, c_float, c_int32]
        gl.glClearBufferfi.restype = None
        gl.glClearBufferfv.argtypes = [c_uint, c_int, POINTER(c_float)]
        gl.glClearBufferfv.restype = None
        gl.glClearBufferiv.argtypes = [c_uint, c_int, POINTER(c_int32)]
        gl.glClearBufferiv.restype = None
        gl.glClearBufferuiv.argtypes = [c_uint, c_int, POINTER(c_uint32)]
        gl.glClearBufferuiv.restype = None
        gl.glClearColor.argtypes = [c_float, c_float, c_float, c_float]
        gl.glClearColor.restype = None
        gl.glClearDepthf.argtypes = [c_float]
        gl.glClearDepthf.restype = None
        gl.glClearStencil.argtypes = [c_int]
        gl.glClearStencil.restype = None
        gl.glColorMask.argtypes = [c_ubyte, c_ubyte, c_ubyte, c_ubyte]
        gl.glColorMask.restype = None
        gl.glColorMaski.argtypes = [c_uint32, c_ubyte, c_ubyte, c_ubyte, c_ubyte]
        gl.glColorMaski.restype = None
        gl.glCompileShader.argtypes = [c_uint32]
        gl.glCompileShader.restype = None
        gl.glCompressedTexImage2D.argtypes = [c_uint, c_long, c_uint, c_size_t, c_size_t, c_long, c_size_t, c_void_p]
        gl.glCompressedTexImage2D.restype = None
        gl.glCompressedTexImage3D.argtypes = [c_uint, c_long, c_uint, c_size_t, c_size_t, c_size_t, c_long, c_size_t, c_void_p]
        gl.glCompressedTexImage3D.restype = None
        gl.glCompressedTexSubImage2D.argtypes = [c_uint, c_long, c_long, c_long, c_size_t, c_size_t, c_uint, c_size_t, c_void_p]
        gl.glCompressedTexSubImage2D.restype = None
        gl.glCompressedTexSubImage3D.argtypes = [c_uint, c_long, c_long, c_long, c_long, c_size_t, c_size_t, c_size_t, c_uint, c_size_t, c_void_p]
        gl.glCompressedTexSubImage3D.restype = None
        gl.glCopyBufferSubData.argtypes = [c_uint, c_uint, c_size_t, c_size_t, c_ssize_t]
        gl.glCopyBufferSubData.restype = None
        gl.glCopyImageSubData.argtypes = [c_uint32, c_uint, c_int32, c_int32, c_int32, c_int32, c_uint32, c_uint, c_int32, c_int32, c_int32, c_int32, c_size_t, c_size_t, c_size_t]
        gl.glCopyImageSubData.restype = None
        gl.glCopyTexImage2D.argtypes = [c_uint, c_long, c_uint, c_int, c_int, c_size_t, c_size_t, c_long]
        gl.glCopyTexImage2D.restype = None
        gl.glCopyTexSubImage2D.argtypes = [c_uint, c_long, c_long, c_long, c_int, c_int, c_size_t, c_size_t]
        gl.glCopyTexSubImage2D.restype = None
        gl.glCopyTexSubImage3D.argtypes = [c_uint, c_long, c_long, c_long, c_long, c_int, c_int, c_size_t, c_size_t]
        gl.glCopyTexSubImage3D.restype = None
        gl.glCreateProgram.argtypes = None
        gl.glCreateProgram.restype = c_uint32
        gl.glCreateShader.argtypes = [c_uint]
        gl.glCreateShader.restype = c_uint32
        gl.glCreateShaderProgramv.argtypes = [c_uint, c_size_t, POINTER(c_char_p)]
        gl.glCreateShaderProgramv.restype = c_uint32
        gl.glCullFace.argtypes = [c_uint]
        gl.glCullFace.restype = None
        gl.glDebugMessageControl.argtypes = [c_uint, c_uint, c_uint, c_size_t, POINTER(c_uint32), c_ubyte]
        gl.glDebugMessageControl.restype = None
        gl.glDebugMessageInsert.argtypes = [c_uint, c_uint, c_uint32, c_uint, c_size_t, POINTER(c_char)]
        gl.glDebugMessageInsert.restype = None
        gl.glDeleteBuffers.argtypes = [c_size_t, POINTER(c_ulong)]
        gl.glDeleteBuffers.restype = None
        gl.glDeleteFramebuffers.argtypes = [c_size_t, POINTER(c_uint32)]
        gl.glDeleteFramebuffers.restype = None
        gl.glDeleteProgram.argtypes = [c_uint32]
        gl.glDeleteProgram.restype = None
        gl.glDeleteProgramPipelines.argtypes = [c_size_t, POINTER(c_uint32)]
        gl.glDeleteProgramPipelines.restype = None
        gl.glDeleteQueries.argtypes = [c_size_t, POINTER(c_uint32)]
        gl.glDeleteQueries.restype = None
        gl.glDeleteRenderbuffers.argtypes = [c_size_t, POINTER(c_uint32)]
        gl.glDeleteRenderbuffers.restype = None
        gl.glDeleteSamplers.argtypes = [c_size_t, POINTER(c_uint32)]
        gl.glDeleteSamplers.restype = None
        gl.glDeleteShader.argtypes = [c_uint32]
        gl.glDeleteShader.restype = None
        gl.glDeleteTextures.argtypes = [c_size_t, POINTER(c_uint)]
        gl.glDeleteTextures.restype = None
        gl.glDeleteTransformFeedbacks.argtypes = [c_size_t, POINTER(c_uint32)]
        gl.glDeleteTransformFeedbacks.restype = None
        gl.glDeleteVertexArrays.argtypes = [c_size_t, POINTER(c_uint32)]
        gl.glDeleteVertexArrays.restype = None
        gl.glDepthFunc.argtypes = [c_uint]
        gl.glDepthFunc.restype = None
        gl.glDepthMask.argtypes = [c_ubyte]
        gl.glDepthMask.restype = None
        gl.glDepthRangef.argtypes = [c_float, c_float]
        gl.glDepthRangef.restype = None
        gl.glDetachShader.argtypes = [c_uint32, c_uint32]
        gl.glDetachShader.restype = None
        gl.glDisable.argtypes = [c_uint]
        gl.glDisable.restype = None
        gl.glDisableVertexAttribArray.argtypes = [c_uint32]
        gl.glDisableVertexAttribArray.restype = None
        gl.glDisablei.argtypes = [c_uint, c_uint32]
        gl.glDisablei.restype = None
        gl.glDispatchCompute.argtypes = [c_uint32, c_uint32, c_uint32]
        gl.glDispatchCompute.restype = None
        gl.glDispatchComputeIndirect.argtypes = [c_size_t]
        gl.glDispatchComputeIndirect.restype = None
        gl.glDrawArrays.argtypes = [c_uint, c_int32, c_size_t]
        gl.glDrawArrays.restype = None
        gl.glDrawArraysIndirect.argtypes = [c_uint, c_void_p]
        gl.glDrawArraysIndirect.restype = None
        gl.glDrawArraysInstanced.argtypes = [c_uint, c_int32, c_size_t, c_size_t]
        gl.glDrawArraysInstanced.restype = None
        gl.glDrawBuffers.argtypes = [c_size_t, POINTER(c_uint)]
        gl.glDrawBuffers.restype = None
        gl.glDrawElements.argtypes = [c_uint, c_size_t, c_uint, c_void_p]
        gl.glDrawElements.restype = None
        gl.glDrawElementsBaseVertex.argtypes = [c_uint, c_size_t, c_uint, c_void_p, c_int32]
        gl.glDrawElementsBaseVertex.restype = None
        gl.glDrawElementsIndirect.argtypes = [c_uint, c_uint, c_void_p]
        gl.glDrawElementsIndirect.restype = None
        gl.glDrawElementsInstanced.argtypes = [c_uint, c_size_t, c_uint, c_void_p, c_size_t]
        gl.glDrawElementsInstanced.restype = None
        gl.glDrawElementsInstancedBaseVertex.argtypes = [c_uint, c_size_t, c_uint, c_void_p, c_size_t, c_int32]
        gl.glDrawElementsInstancedBaseVertex.restype = None
        gl.glDrawRangeElements.argtypes = [c_uint, c_uint32, c_uint32, c_size_t, c_uint, c_void_p]
        gl.glDrawRangeElements.restype = None
        gl.glDrawRangeElementsBaseVertex.argtypes = [c_uint, c_uint32, c_uint32, c_size_t, c_uint, c_void_p, c_int32]
        gl.glDrawRangeElementsBaseVertex.restype = None
        gl.glEnable.argtypes = [c_uint]
        gl.glEnable.restype = None
        gl.glEnableVertexAttribArray.argtypes = [c_uint32]
        gl.glEnableVertexAttribArray.restype = None
        gl.glEnablei.argtypes = [c_uint, c_uint32]
        gl.glEnablei.restype = None
        gl.glEndQuery.argtypes = [c_uint]
        gl.glEndQuery.restype = None
        gl.glEndTransformFeedback.argtypes = None
        gl.glEndTransformFeedback.restype = None
        gl.glFinish.argtypes = None
        gl.glFinish.restype = None
        gl.glFlush.argtypes = None
        gl.glFlush.restype = None
        gl.glFlushMappedBufferRange.argtypes = [c_uint, c_size_t, c_ssize_t]
        gl.glFlushMappedBufferRange.restype = None
        gl.glFramebufferParameteri.argtypes = [c_uint, c_uint, c_int32]
        gl.glFramebufferParameteri.restype = None
        gl.glFramebufferRenderbuffer.argtypes = [c_uint, c_uint, c_uint, c_uint32]
        gl.glFramebufferRenderbuffer.restype = None
        gl.glFramebufferTexture.argtypes = [c_uint, c_uint, c_uint32, c_int32]
        gl.glFramebufferTexture.restype = None
        gl.glFramebufferTexture2D.argtypes = [c_uint, c_uint, c_uint, c_uint32, c_int32]
        gl.glFramebufferTexture2D.restype = None
        gl.glFramebufferTextureLayer.argtypes = [c_uint, c_uint, c_uint, c_long, c_long]
        gl.glFramebufferTextureLayer.restype = None
        gl.glFrontFace.argtypes = [c_uint]
        gl.glFrontFace.restype = None
        gl.glGenBuffers.argtypes = [c_size_t, POINTER(c_uint32)]
        gl.glGenBuffers.restype = None
        gl.glGenFramebuffers.argtypes = [c_size_t, POINTER(c_uint32)]
        gl.glGenFramebuffers.restype = None
        gl.glGenProgramPipelines.argtypes = [c_size_t, POINTER(c_uint32)]
        gl.glGenProgramPipelines.restype = None
        gl.glGenQueries.argtypes = [c_size_t, POINTER(c_uint32)]
        gl.glGenQueries.restype = None
        gl.glGenRenderbuffers.argtypes = [c_size_t, POINTER(c_uint32)]
        gl.glGenRenderbuffers.restype = None
        gl.glGenSamplers.argtypes = [c_size_t, POINTER(c_uint32)]
        gl.glGenSamplers.restype = None
        gl.glGenTextures.argtypes = [c_size_t, POINTER(c_uint)]
        gl.glGenTextures.restype = None
        gl.glGenTransformFeedbacks.argtypes = [c_size_t, POINTER(c_uint32)]
        gl.glGenTransformFeedbacks.restype = None
        gl.glGenVertexArrays.argtypes = [c_size_t, POINTER(c_uint32)]
        gl.glGenVertexArrays.restype = None
        gl.glGenerateMipmap.argtypes = [c_uint]
        gl.glGenerateMipmap.restype = None
        gl.glGetActiveAttrib.argtypes = [c_uint32, c_uint32, c_size_t, POINTER(c_size_t), POINTER(c_int32), POINTER(c_uint), POINTER(c_char)]
        gl.glGetActiveAttrib.restype = None
        gl.glGetActiveUniform.argtypes = [c_uint32, c_uint32, c_size_t, POINTER(c_size_t), POINTER(c_int32), POINTER(c_uint), POINTER(c_char)]
        gl.glGetActiveUniform.restype = None
        gl.glGetActiveUniformBlockName.argtypes = [c_uint32, c_uint32, c_size_t, POINTER(c_size_t), POINTER(c_char)]
        gl.glGetActiveUniformBlockName.restype = None
        gl.glGetActiveUniformBlockiv.argtypes = [c_uint32, c_uint32, c_uint, POINTER(c_int32)]
        gl.glGetActiveUniformBlockiv.restype = None
        gl.glGetActiveUniformsiv.argtypes = [c_uint32, c_size_t, POINTER(c_uint32), c_uint, POINTER(c_int32)]
        gl.glGetActiveUniformsiv.restype = None
        gl.glGetAttachedShaders.argtypes = [c_uint32, c_size_t, POINTER(c_size_t), POINTER(c_uint32)]
        gl.glGetAttachedShaders.restype = None
        gl.glGetAttribLocation.argtypes = [c_uint32, POINTER(c_char)]
        gl.glGetAttribLocation.restype = c_int32
        gl.glGetBooleanv.argtypes = [c_uint, POINTER(c_ubyte)]
        gl.glGetBooleanv.restype = None
        gl.glGetBufferParameteri64v.argtypes = [c_uint, c_uint, POINTER(c_int64)]
        gl.glGetBufferParameteri64v.restype = None
        gl.glGetBufferParameteriv.argtypes = [c_uint, c_uint, POINTER(c_int32)]
        gl.glGetBufferParameteriv.restype = None
        gl.glGetBufferPointerv.argtypes = [c_uint, c_uint, POINTER(c_void_p)]
        gl.glGetBufferPointerv.restype = None
        gl.glGetDebugMessageLog.argtypes = [c_uint32, c_size_t, POINTER(c_uint), POINTER(c_uint), POINTER(c_uint32), POINTER(c_uint), POINTER(c_size_t), POINTER(c_char)]
        gl.glGetDebugMessageLog.restype = c_uint32
        gl.glGetError.argtypes = None
        gl.glGetError.restype = c_uint
        gl.glGetFloatv.argtypes = [c_uint, POINTER(c_float)]
        gl.glGetFloatv.restype = None
        gl.glGetFragDataLocation.argtypes = [c_uint32, POINTER(c_char)]
        gl.glGetFragDataLocation.restype = c_int32
        gl.glGetFramebufferAttachmentParameteriv.argtypes = [c_uint, c_uint, c_uint, POINTER(c_int32)]
        gl.glGetFramebufferAttachmentParameteriv.restype = None
        gl.glGetFramebufferParameteriv.argtypes = [c_uint, c_uint, POINTER(c_int32)]
        gl.glGetFramebufferParameteriv.restype = None
        gl.glGetInteger64v.argtypes = [c_uint, POINTER(c_int64)]
        gl.glGetInteger64v.restype = None
        gl.glGetIntegerv.argtypes = [c_uint, POINTER(c_int32)]
        gl.glGetIntegerv.restype = None
        gl.glGetInternalformativ.argtypes = [c_uint, c_uint, c_uint, c_size_t, POINTER(c_int32)]
        gl.glGetInternalformativ.restype = None
        gl.glGetMultisamplefv.argtypes = [c_uint, c_uint32, POINTER(c_float)]
        gl.glGetMultisamplefv.restype = None
        gl.glGetObjectLabel.argtypes = [c_uint, c_uint32, c_size_t, POINTER(c_size_t), POINTER(c_char)]
        gl.glGetObjectLabel.restype = None
        gl.glGetObjectPtrLabel.argtypes = [c_void_p, c_size_t, POINTER(c_size_t), POINTER(c_char)]
        gl.glGetObjectPtrLabel.restype = None
        gl.glGetPointerv.argtypes = [c_uint, POINTER(c_void_p)]
        gl.glGetPointerv.restype = None
        gl.glGetProgramBinary.argtypes = [c_uint32, c_size_t, POINTER(c_size_t), POINTER(c_uint), c_void_p]
        gl.glGetProgramBinary.restype = None
        gl.glGetProgramInfoLog.argtypes = [c_uint32, c_size_t, POINTER(c_size_t), POINTER(c_char)]
        gl.glGetProgramInfoLog.restype = None
        gl.glGetProgramInterfaceiv.argtypes = [c_uint32, c_uint, c_uint, POINTER(c_int32)]
        gl.glGetProgramInterfaceiv.restype = None
        gl.glGetProgramPipelineInfoLog.argtypes = [c_uint32, c_size_t, POINTER(c_size_t), POINTER(c_char)]
        gl.glGetProgramPipelineInfoLog.restype = None
        gl.glGetProgramPipelineiv.argtypes = [c_uint32, c_uint, POINTER(c_int32)]
        gl.glGetProgramPipelineiv.restype = None
        gl.glGetProgramResourceIndex.argtypes = [c_uint32, c_uint, POINTER(c_char)]
        gl.glGetProgramResourceIndex.restype = c_uint32
        gl.glGetProgramResourceLocation.argtypes = [c_uint32, c_uint, POINTER(c_char)]
        gl.glGetProgramResourceLocation.restype = c_int32
        gl.glGetProgramResourceName.argtypes = [c_uint32, c_uint, c_uint32, c_size_t, POINTER(c_size_t), POINTER(c_char)]
        gl.glGetProgramResourceName.restype = None
        gl.glGetProgramResourceiv.argtypes = [c_uint32, c_uint, c_uint32, c_size_t, POINTER(c_uint), c_size_t, POINTER(c_size_t), POINTER(c_int32)]
        gl.glGetProgramResourceiv.restype = None
        gl.glGetProgramiv.argtypes = [c_uint32, c_uint, POINTER(c_int32)]
        gl.glGetProgramiv.restype = None
        gl.glGetQueryObjectuiv.argtypes = [c_uint32, c_uint, POINTER(c_uint32)]
        gl.glGetQueryObjectuiv.restype = None
        gl.glGetQueryiv.argtypes = [c_uint, c_uint, POINTER(c_int32)]
        gl.glGetQueryiv.restype = None
        gl.glGetRenderbufferParameteriv.argtypes = [c_uint, c_uint, POINTER(c_int32)]
        gl.glGetRenderbufferParameteriv.restype = None
        gl.glGetSamplerParameterIiv.argtypes = [c_uint32, c_uint, POINTER(c_int32)]
        gl.glGetSamplerParameterIiv.restype = None
        gl.glGetSamplerParameterIuiv.argtypes = [c_uint32, c_uint, POINTER(c_uint32)]
        gl.glGetSamplerParameterIuiv.restype = None
        gl.glGetSamplerParameterfv.argtypes = [c_uint32, c_uint, POINTER(c_float)]
        gl.glGetSamplerParameterfv.restype = None
        gl.glGetSamplerParameteriv.argtypes = [c_uint32, c_uint, POINTER(c_int32)]
        gl.glGetSamplerParameteriv.restype = None
        gl.glGetShaderInfoLog.argtypes = [c_uint32, c_size_t, POINTER(c_size_t), POINTER(c_char)]
        gl.glGetShaderInfoLog.restype = None
        gl.glGetShaderPrecisionFormat.argtypes = [c_uint, c_uint, POINTER(c_int32), POINTER(c_int32)]
        gl.glGetShaderPrecisionFormat.restype = None
        gl.glGetShaderSource.argtypes = [c_uint32, c_size_t, POINTER(c_size_t), POINTER(c_char)]
        gl.glGetShaderSource.restype = None
        gl.glGetShaderiv.argtypes = [c_uint32, c_uint, POINTER(c_int32)]
        gl.glGetShaderiv.restype = None
        gl.glGetString.argtypes = [c_uint]
        gl.glGetString.restype = c_char_p
        gl.glGetStringi.argtypes = [c_uint, c_uint32]
        gl.glGetStringi.restype = c_char_p
        gl.glGetTexLevelParameterfv.argtypes = [c_uint, c_long, c_uint, POINTER(c_float)]
        gl.glGetTexLevelParameterfv.restype = None
        gl.glGetTexLevelParameteriv.argtypes = [c_uint, c_long, c_uint, POINTER(c_int32)]
        gl.glGetTexLevelParameteriv.restype = None
        gl.glGetTexParameterIiv.argtypes = [c_uint, c_uint, POINTER(c_int32)]
        gl.glGetTexParameterIiv.restype = None
        gl.glGetTexParameterIuiv.argtypes = [c_uint, c_uint, POINTER(c_uint32)]
        gl.glGetTexParameterIuiv.restype = None
        gl.glGetTexParameterfv.argtypes = [c_uint, c_uint, POINTER(c_float)]
        gl.glGetTexParameterfv.restype = None
        gl.glGetTexParameteriv.argtypes = [c_uint, c_uint, POINTER(c_int32)]
        gl.glGetTexParameteriv.restype = None
        gl.glGetTransformFeedbackVarying.argtypes = [c_uint32, c_uint32, c_size_t, POINTER(c_size_t), POINTER(c_size_t), POINTER(c_uint), POINTER(c_char)]
        gl.glGetTransformFeedbackVarying.restype = None
        gl.glGetUniformBlockIndex.argtypes = [c_uint32, POINTER(c_char)]
        gl.glGetUniformBlockIndex.restype = c_uint32
        gl.glGetUniformIndices.argtypes = [c_uint32, c_size_t, POINTER(c_char_p), POINTER(c_uint32)]
        gl.glGetUniformIndices.restype = None
        gl.glGetUniformLocation.argtypes = [c_uint32, POINTER(c_char)]
        gl.glGetUniformLocation.restype = c_int32
        gl.glGetUniformfv.argtypes = [c_uint32, c_int32, POINTER(c_float)]
        gl.glGetUniformfv.restype = None
        gl.glGetUniformiv.argtypes = [c_uint32, c_int32, POINTER(c_int32)]
        gl.glGetUniformiv.restype = None
        gl.glGetUniformuiv.argtypes = [c_uint32, c_int32, POINTER(c_uint32)]
        gl.glGetUniformuiv.restype = None
        gl.glGetVertexAttribIiv.argtypes = [c_uint32, c_uint, POINTER(c_int32)]
        gl.glGetVertexAttribIiv.restype = None
        gl.glGetVertexAttribIuiv.argtypes = [c_uint32, c_uint, POINTER(c_uint32)]
        gl.glGetVertexAttribIuiv.restype = None
        gl.glGetVertexAttribPointerv.argtypes = [c_uint32, c_uint, POINTER(c_void_p)]
        gl.glGetVertexAttribPointerv.restype = None
        gl.glGetVertexAttribfv.argtypes = [c_uint32, c_uint, POINTER(c_float)]
        gl.glGetVertexAttribfv.restype = None
        gl.glGetVertexAttribiv.argtypes = [c_uint32, c_uint, POINTER(c_int32)]
        gl.glGetVertexAttribiv.restype = None
        gl.glHint.argtypes = [c_uint, c_uint]
        gl.glHint.restype = None
        gl.glInvalidateFramebuffer.argtypes = [c_uint, c_size_t, POINTER(c_uint)]
        gl.glInvalidateFramebuffer.restype = None
        gl.glInvalidateSubFramebuffer.argtypes = [c_uint, c_size_t, POINTER(c_uint), c_int32, c_int32, c_size_t, c_size_t]
        gl.glInvalidateSubFramebuffer.restype = None
        gl.glIsBuffer.argtypes = [c_uint32]
        gl.glIsBuffer.restype = c_ubyte
        gl.glIsEnabled.argtypes = [c_uint]
        gl.glIsEnabled.restype = c_ubyte
        gl.glIsEnabledi.argtypes = [c_uint, c_uint32]
        gl.glIsEnabledi.restype = c_ubyte
        gl.glIsFramebuffer.argtypes = [c_uint32]
        gl.glIsFramebuffer.restype = c_ubyte
        gl.glIsProgram.argtypes = [c_uint32]
        gl.glIsProgram.restype = c_ubyte
        gl.glIsProgramPipeline.argtypes = [c_uint32]
        gl.glIsProgramPipeline.restype = c_ubyte
        gl.glIsQuery.argtypes = [c_uint32]
        gl.glIsQuery.restype = c_ubyte
        gl.glIsRenderbuffer.argtypes = [c_uint32]
        gl.glIsRenderbuffer.restype = c_ubyte
        gl.glIsSampler.argtypes = [c_uint32]
        gl.glIsSampler.restype = c_ubyte
        gl.glIsShader.argtypes = [c_uint32]
        gl.glIsShader.restype = c_ubyte
        gl.glIsTexture.argtypes = [c_uint]
        gl.glIsTexture.restype = c_ubyte
        gl.glIsTransformFeedback.argtypes = [c_uint32]
        gl.glIsTransformFeedback.restype = c_ubyte
        gl.glIsVertexArray.argtypes = [c_uint32]
        gl.glIsVertexArray.restype = c_ubyte
        gl.glLineWidth.argtypes = [c_float]
        gl.glLineWidth.restype = None
        gl.glLinkProgram.argtypes = [c_uint32]
        gl.glLinkProgram.restype = None
        gl.glMapBufferRange.argtypes = [c_uint, c_size_t, c_ssize_t, c_uint]
        gl.glMapBufferRange.restype = c_void_p
        gl.glMemoryBarrier.argtypes = [c_uint]
        gl.glMemoryBarrier.restype = None
        gl.glMinSampleShading.argtypes = [c_float]
        gl.glMinSampleShading.restype = None
        gl.glObjectLabel.argtypes = [c_uint, c_uint32, c_size_t, POINTER(c_char)]
        gl.glObjectLabel.restype = None
        gl.glObjectPtrLabel.argtypes = [c_void_p, c_size_t, POINTER(c_char)]
        gl.glObjectPtrLabel.restype = None
        gl.glPatchParameteri.argtypes = [c_uint, c_int32]
        gl.glPatchParameteri.restype = None
        gl.glPauseTransformFeedback.argtypes = None
        gl.glPauseTransformFeedback.restype = None
        gl.glPixelStorei.argtypes = [c_uint, c_long]
        gl.glPixelStorei.restype = None
        gl.glPolygonOffset.argtypes = [c_float, c_float]
        gl.glPolygonOffset.restype = None
        gl.glPopDebugGroup.argtypes = None
        gl.glPopDebugGroup.restype = None
        gl.glProgramBinary.argtypes = [c_uint32, c_uint, c_void_p, c_size_t]
        gl.glProgramBinary.restype = None
        gl.glProgramParameteri.argtypes = [c_uint32, c_uint, c_int32]
        gl.glProgramParameteri.restype = None
        gl.glProgramUniform1f.argtypes = [c_uint32, c_int32, c_float]
        gl.glProgramUniform1f.restype = None
        gl.glProgramUniform1fv.argtypes = [c_uint32, c_int32, c_size_t, POINTER(c_float)]
        gl.glProgramUniform1fv.restype = None
        gl.glProgramUniform1i.argtypes = [c_uint32, c_int32, c_int32]
        gl.glProgramUniform1i.restype = None
        gl.glProgramUniform1iv.argtypes = [c_uint32, c_int32, c_size_t, POINTER(c_int32)]
        gl.glProgramUniform1iv.restype = None
        gl.glProgramUniform1ui.argtypes = [c_uint32, c_int32, c_uint32]
        gl.glProgramUniform1ui.restype = None
        gl.glProgramUniform1uiv.argtypes = [c_uint32, c_int32, c_size_t, POINTER(c_uint32)]
        gl.glProgramUniform1uiv.restype = None
        gl.glProgramUniform2f.argtypes = [c_uint32, c_int32, c_float, c_float]
        gl.glProgramUniform2f.restype = None
        gl.glProgramUniform2fv.argtypes = [c_uint32, c_int32, c_size_t, POINTER(c_float)]
        gl.glProgramUniform2fv.restype = None
        gl.glProgramUniform2i.argtypes = [c_uint32, c_int32, c_int32, c_int32]
        gl.glProgramUniform2i.restype = None
        gl.glProgramUniform2iv.argtypes = [c_uint32, c_int32, c_size_t, POINTER(c_int32)]
        gl.glProgramUniform2iv.restype = None
        gl.glProgramUniform2ui.argtypes = [c_uint32, c_int32, c_uint32, c_uint32]
        gl.glProgramUniform2ui.restype = None
        gl.glProgramUniform2uiv.argtypes = [c_uint32, c_int32, c_size_t, POINTER(c_uint32)]
        gl.glProgramUniform2uiv.restype = None
        gl.glProgramUniform3f.argtypes = [c_uint32, c_int32, c_float, c_float, c_float]
        gl.glProgramUniform3f.restype = None
        gl.glProgramUniform3fv.argtypes = [c_uint32, c_int32, c_size_t, POINTER(c_float)]
        gl.glProgramUniform3fv.restype = None
        gl.glProgramUniform3i.argtypes = [c_uint32, c_int32, c_int32, c_int32, c_int32]
        gl.glProgramUniform3i.restype = None
        gl.glProgramUniform3iv.argtypes = [c_uint32, c_int32, c_size_t, POINTER(c_int32)]
        gl.glProgramUniform3iv.restype = None
        gl.glProgramUniform3ui.argtypes = [c_uint32, c_int32, c_uint32, c_uint32, c_uint32]
        gl.glProgramUniform3ui.restype = None
        gl.glProgramUniform3uiv.argtypes = [c_uint32, c_int32, c_size_t, POINTER(c_uint32)]
        gl.glProgramUniform3uiv.restype = None
        gl.glProgramUniform4f.argtypes = [c_uint32, c_int32, c_float, c_float, c_float, c_float]
        gl.glProgramUniform4f.restype = None
        gl.glProgramUniform4fv.argtypes = [c_uint32, c_int32, c_size_t, POINTER(c_float)]
        gl.glProgramUniform4fv.restype = None
        gl.glProgramUniform4i.argtypes = [c_uint32, c_int32, c_int32, c_int32, c_int32, c_int32]
        gl.glProgramUniform4i.restype = None
        gl.glProgramUniform4iv.argtypes = [c_uint32, c_int32, c_size_t, POINTER(c_int32)]
        gl.glProgramUniform4iv.restype = None
        gl.glProgramUniform4ui.argtypes = [c_uint32, c_int32, c_uint32, c_uint32, c_uint32, c_uint32]
        gl.glProgramUniform4ui.restype = None
        gl.glProgramUniform4uiv.argtypes = [c_uint32, c_int32, c_size_t, POINTER(c_uint32)]
        gl.glProgramUniform4uiv.restype = None
        gl.glProgramUniformMatrix2fv.argtypes = [c_uint32, c_int32, c_size_t, c_ubyte, POINTER(c_float)]
        gl.glProgramUniformMatrix2fv.restype = None
        gl.glProgramUniformMatrix2x3fv.argtypes = [c_uint32, c_int32, c_size_t, c_ubyte, POINTER(c_float)]
        gl.glProgramUniformMatrix2x3fv.restype = None
        gl.glProgramUniformMatrix2x4fv.argtypes = [c_uint32, c_int32, c_size_t, c_ubyte, POINTER(c_float)]
        gl.glProgramUniformMatrix2x4fv.restype = None
        gl.glProgramUniformMatrix3fv.argtypes = [c_uint32, c_int32, c_size_t, c_ubyte, POINTER(c_float)]
        gl.glProgramUniformMatrix3fv.restype = None
        gl.glProgramUniformMatrix3x2fv.argtypes = [c_uint32, c_int32, c_size_t, c_ubyte, POINTER(c_float)]
        gl.glProgramUniformMatrix3x2fv.restype = None
        gl.glProgramUniformMatrix3x4fv.argtypes = [c_uint32, c_int32, c_size_t, c_ubyte, POINTER(c_float)]
        gl.glProgramUniformMatrix3x4fv.restype = None
        gl.glProgramUniformMatrix4fv.argtypes = [c_uint32, c_int32, c_size_t, c_ubyte, POINTER(c_float)]
        gl.glProgramUniformMatrix4fv.restype = None
        gl.glProgramUniformMatrix4x2fv.argtypes = [c_uint32, c_int32, c_size_t, c_ubyte, POINTER(c_float)]
        gl.glProgramUniformMatrix4x2fv.restype = None
        gl.glProgramUniformMatrix4x3fv.argtypes = [c_uint32, c_int32, c_size_t, c_ubyte, POINTER(c_float)]
        gl.glProgramUniformMatrix4x3fv.restype = None
        gl.glPushDebugGroup.argtypes = [c_uint, c_uint32, c_size_t, POINTER(c_char)]
        gl.glPushDebugGroup.restype = None
        gl.glReadBuffer.argtypes = [c_uint]
        gl.glReadBuffer.restype = None
        gl.glReadPixels.argtypes = [c_int, c_int, c_size_t, c_size_t, c_uint, c_uint, c_void_p]
        gl.glReadPixels.restype = None
        gl.glReleaseShaderCompiler.argtypes = None
        gl.glReleaseShaderCompiler.restype = None
        gl.glRenderbufferStorage.argtypes = [c_uint, c_uint, c_size_t, c_size_t]
        gl.glRenderbufferStorage.restype = None
        gl.glRenderbufferStorageMultisample.argtypes = [c_uint, c_size_t, c_uint, c_size_t, c_size_t]
        gl.glRenderbufferStorageMultisample.restype = None
        gl.glResumeTransformFeedback.argtypes = None
        gl.glResumeTransformFeedback.restype = None
        gl.glSampleCoverage.argtypes = [c_float, c_ubyte]
        gl.glSampleCoverage.restype = None
        gl.glSampleMaski.argtypes = [c_uint32, c_uint]
        gl.glSampleMaski.restype = None
        gl.glSamplerParameterIiv.argtypes = [c_uint32, c_uint, POINTER(c_int32)]
        gl.glSamplerParameterIiv.restype = None
        gl.glSamplerParameterIuiv.argtypes = [c_uint32, c_uint, POINTER(c_uint32)]
        gl.glSamplerParameterIuiv.restype = None
        gl.glSamplerParameterf.argtypes = [c_uint32, c_uint, c_float]
        gl.glSamplerParameterf.restype = None
        gl.glSamplerParameterfv.argtypes = [c_uint32, c_uint, POINTER(c_float)]
        gl.glSamplerParameterfv.restype = None
        gl.glSamplerParameteri.argtypes = [c_uint32, c_uint, c_int32]
        gl.glSamplerParameteri.restype = None
        gl.glSamplerParameteriv.argtypes = [c_uint32, c_uint, POINTER(c_int32)]
        gl.glSamplerParameteriv.restype = None
        gl.glScissor.argtypes = [c_int, c_int, c_size_t, c_size_t]
        gl.glScissor.restype = None
        gl.glShaderBinary.argtypes = [c_size_t, POINTER(c_uint32), c_uint, c_void_p, c_size_t]
        gl.glShaderBinary.restype = None
        gl.glShaderSource.argtypes = [c_uint32, c_size_t, POINTER(c_char_p), POINTER(c_int32)]
        gl.glShaderSource.restype = None
        gl.glStencilFunc.argtypes = [c_uint, c_int, c_uint]
        gl.glStencilFunc.restype = None
        gl.glStencilFuncSeparate.argtypes = [c_uint, c_uint, c_int, c_uint]
        gl.glStencilFuncSeparate.restype = None
        gl.glStencilMask.argtypes = [c_uint]
        gl.glStencilMask.restype = None
        gl.glStencilMaskSeparate.argtypes = [c_uint, c_uint]
        gl.glStencilMaskSeparate.restype = None
        gl.glStencilOp.argtypes = [c_uint, c_uint, c_uint]
        gl.glStencilOp.restype = None
        gl.glStencilOpSeparate.argtypes = [c_uint, c_uint, c_uint, c_uint]
        gl.glStencilOpSeparate.restype = None
        gl.glTexBuffer.argtypes = [c_uint, c_uint, c_uint32]
        gl.glTexBuffer.restype = None
        gl.glTexBufferRange.argtypes = [c_uint, c_uint, c_uint32, c_size_t, c_ssize_t]
        gl.glTexBufferRange.restype = None
        gl.glTexImage2D.argtypes = [c_uint, c_long, c_int, c_size_t, c_size_t, c_long, c_uint, c_uint, c_void_p]
        gl.glTexImage2D.restype = None
        gl.glTexParameterIiv.argtypes = [c_uint, c_uint, POINTER(c_int32)]
        gl.glTexParameterIiv.restype = None
        gl.glTexParameterIuiv.argtypes = [c_uint, c_uint, POINTER(c_uint32)]
        gl.glTexParameterIuiv.restype = None
        gl.glTexParameterf.argtypes = [c_uint, c_uint, c_float]
        gl.glTexParameterf.restype = None
        gl.glTexParameterfv.argtypes = [c_uint, c_uint, POINTER(c_float)]
        gl.glTexParameterfv.restype = None
        gl.glTexParameteri.argtypes = [c_uint, c_uint, c_long]
        gl.glTexParameteri.restype = None
        gl.glTexParameteriv.argtypes = [c_uint, c_uint, POINTER(c_long)]
        gl.glTexParameteriv.restype = None
        gl.glTexStorage2D.argtypes = [c_uint, c_size_t, c_uint, c_size_t, c_size_t]
        gl.glTexStorage2D.restype = None
        gl.glTexStorage2DMultisample.argtypes = [c_uint, c_size_t, c_uint, c_size_t, c_size_t, c_ubyte]
        gl.glTexStorage2DMultisample.restype = None
        gl.glTexStorage3D.argtypes = [c_uint, c_size_t, c_uint, c_size_t, c_size_t, c_size_t]
        gl.glTexStorage3D.restype = None
        gl.glTexStorage3DMultisample.argtypes = [c_uint, c_size_t, c_uint, c_size_t, c_size_t, c_size_t, c_ubyte]
        gl.glTexStorage3DMultisample.restype = None
        gl.glTexSubImage2D.argtypes = [c_uint, c_long, c_long, c_long, c_size_t, c_size_t, c_uint, c_uint, c_void_p]
        gl.glTexSubImage2D.restype = None
        gl.glTexSubImage3D.argtypes = [c_uint, c_long, c_long, c_long, c_long, c_size_t, c_size_t, c_size_t, c_uint, c_uint, c_void_p]
        gl.glTexSubImage3D.restype = None
        gl.glTransformFeedbackVaryings.argtypes = [c_uint32, c_size_t, POINTER(c_char_p), c_uint]
        gl.glTransformFeedbackVaryings.restype = None
        gl.glUniform1f.argtypes = [c_int32, c_float]
        gl.glUniform1f.restype = None
        gl.glUniform1fv.argtypes = [c_int32, c_size_t, POINTER(c_float)]
        gl.glUniform1fv.restype = None
        gl.glUniform1i.argtypes = [c_int32, c_int32]
        gl.glUniform1i.restype = None
        gl.glUniform1iv.argtypes = [c_int32, c_size_t, POINTER(c_int32)]
        gl.glUniform1iv.restype = None
        gl.glUniform1ui.argtypes = [c_int32, c_uint32]
        gl.glUniform1ui.restype = None
        gl.glUniform1uiv.argtypes = [c_int32, c_size_t, POINTER(c_uint32)]
        gl.glUniform1uiv.restype = None
        gl.glUniform2f.argtypes = [c_int32, c_float, c_float]
        gl.glUniform2f.restype = None
        gl.glUniform2fv.argtypes = [c_int32, c_size_t, POINTER(c_float)]
        gl.glUniform2fv.restype = None
        gl.glUniform2i.argtypes = [c_int32, c_int32, c_int32]
        gl.glUniform2i.restype = None
        gl.glUniform2iv.argtypes = [c_int32, c_size_t, POINTER(c_int32)]
        gl.glUniform2iv.restype = None
        gl.glUniform2ui.argtypes = [c_int32, c_uint32, c_uint32]
        gl.glUniform2ui.restype = None
        gl.glUniform2uiv.argtypes = [c_int32, c_size_t, POINTER(c_uint32)]
        gl.glUniform2uiv.restype = None
        gl.glUniform3f.argtypes = [c_int32, c_float, c_float, c_float]
        gl.glUniform3f.restype = None
        gl.glUniform3fv.argtypes = [c_int32, c_size_t, POINTER(c_float)]
        gl.glUniform3fv.restype = None
        gl.glUniform3i.argtypes = [c_int32, c_int32, c_int32, c_int32]
        gl.glUniform3i.restype = None
        gl.glUniform3iv.argtypes = [c_int32, c_size_t, POINTER(c_int32)]
        gl.glUniform3iv.restype = None
        gl.glUniform3ui.argtypes = [c_int32, c_uint32, c_uint32, c_uint32]
        gl.glUniform3ui.restype = None
        gl.glUniform3uiv.argtypes = [c_int32, c_size_t, POINTER(c_uint32)]
        gl.glUniform3uiv.restype = None
        gl.glUniform4f.argtypes = [c_int32, c_float, c_float, c_float, c_float]
        gl.glUniform4f.restype = None
        gl.glUniform4fv.argtypes = [c_int32, c_size_t, POINTER(c_float)]
        gl.glUniform4fv.restype = None
        gl.glUniform4i.argtypes = [c_int32, c_int32, c_int32, c_int32, c_int32]
        gl.glUniform4i.restype = None
        gl.glUniform4iv.argtypes = [c_int32, c_size_t, POINTER(c_int32)]
        gl.glUniform4iv.restype = None
        gl.glUniform4ui.argtypes = [c_int32, c_uint32, c_uint32, c_uint32, c_uint32]
        gl.glUniform4ui.restype = None
        gl.glUniform4uiv.argtypes = [c_int32, c_size_t, POINTER(c_uint32)]
        gl.glUniform4uiv.restype = None
        gl.glUniformBlockBinding.argtypes = [c_uint32, c_uint32, c_uint32]
        gl.glUniformBlockBinding.restype = None
        gl.glUniformMatrix2fv.argtypes = [c_int32, c_size_t, c_ubyte, POINTER(c_float)]
        gl.glUniformMatrix2fv.restype = None
        gl.glUniformMatrix2x3fv.argtypes = [c_int32, c_size_t, c_ubyte, POINTER(c_float)]
        gl.glUniformMatrix2x3fv.restype = None
        gl.glUniformMatrix2x4fv.argtypes = [c_int32, c_size_t, c_ubyte, POINTER(c_float)]
        gl.glUniformMatrix2x4fv.restype = None
        gl.glUniformMatrix3fv.argtypes = [c_int32, c_size_t, c_ubyte, POINTER(c_float)]
        gl.glUniformMatrix3fv.restype = None
        gl.glUniformMatrix3x2fv.argtypes = [c_int32, c_size_t, c_ubyte, POINTER(c_float)]
        gl.glUniformMatrix3x2fv.restype = None
        gl.glUniformMatrix3x4fv.argtypes = [c_int32, c_size_t, c_ubyte, POINTER(c_float)]
        gl.glUniformMatrix3x4fv.restype = None
        gl.glUniformMatrix4fv.argtypes = [c_int32, c_size_t, c_ubyte, POINTER(c_float)]
        gl.glUniformMatrix4fv.restype = None
        gl.glUniformMatrix4x2fv.argtypes = [c_int32, c_size_t, c_ubyte, POINTER(c_float)]
        gl.glUniformMatrix4x2fv.restype = None
        gl.glUniformMatrix4x3fv.argtypes = [c_int32, c_size_t, c_ubyte, POINTER(c_float)]
        gl.glUniformMatrix4x3fv.restype = None
        gl.glUnmapBuffer.argtypes = [c_uint]
        gl.glUnmapBuffer.restype = c_ubyte
        gl.glUseProgram.argtypes = [c_uint32]
        gl.glUseProgram.restype = None
        gl.glUseProgramStages.argtypes = [c_uint32, c_uint, c_uint32]
        gl.glUseProgramStages.restype = None
        gl.glValidateProgram.argtypes = [c_uint32]
        gl.glValidateProgram.restype = None
        gl.glValidateProgramPipeline.argtypes = [c_uint32]
        gl.glValidateProgramPipeline.restype = None
        gl.glVertexAttribBinding.argtypes = [c_uint32, c_uint32]
        gl.glVertexAttribBinding.restype = None
        gl.glVertexAttribDivisor.argtypes = [c_uint32, c_uint32]
        gl.glVertexAttribDivisor.restype = None
        gl.glVertexAttribFormat.argtypes = [c_uint32, c_int32, c_uint, c_ubyte, c_uint32]
        gl.glVertexAttribFormat.restype = None
        gl.glVertexAttribIFormat.argtypes = [c_uint32, c_int32, c_uint, c_uint32]
        gl.glVertexAttribIFormat.restype = None
        gl.glVertexAttribIPointer.argtypes = [c_uint32, c_int32, c_uint, c_size_t, c_void_p]
        gl.glVertexAttribIPointer.restype = None
        gl.glVertexAttribPointer.argtypes = [c_uint32, c_int32, c_uint, c_ubyte, c_size_t, c_void_p]
        gl.glVertexAttribPointer.restype = None
        gl.glVertexBindingDivisor.argtypes = [c_uint32, c_uint32]
        gl.glVertexBindingDivisor.restype = None
        gl.glViewport.argtypes = [c_int, c_int, c_size_t, c_size_t]
        gl.glViewport.restype = None
'''





class PageAnalyzer(object):
    """ Analyzer for kernel page """

    # page flags from kernel/include/uapi/linux/kernel-page-flags.h #
    flagList = [
        'KPF_LOCKED', #0#
        'KPF_ERROR', #1#
        'KPF_REFERENCED', #2#
        'KPF_UPTODATE', #3#
        'KPF_DIRTY', #4#
        'KPF_LRU', #5#
        'KPF_ACTIVE', #6#
        'KPF_SLAB', #7#
        'KPF_WRITEBACK', #8#
        'KPF_RECLAIM', #9#
        'KPF_BUDDY', #10#
        'KPF_MMAP', #11#
        'KPF_ANON', #12#
        'KPF_SWAPCACHE', #13#
        'KPF_SWAPBACKED', #14#
        'KPF_COMPOUND_HEAD', #15#
        'KPF_COMPOUND_TAIL', #16#
        'KPF_HUGE', #17#
        'KPF_UNEVICTABLE', #18#
        'KPF_HWPOISON', #19#
        'KPF_NOPAGE', #20#
        'KPF_KSM', #21#
        'KPF_THP', #22#
        'KPF_BALLOON', #23#
        'KPF_ZERO_PAGE', #24#
        'KPF_IDLE' #25#
        ]



    @staticmethod
    def getPageInfo(pid, vaddr):
        try:
            if not pid:
                raise Exception('no pid')
            elif type(pid) is not list or len(pid) != 1:
                raise Exception('wrong pid')

            pids = SysMgr.getPids(pid[0], isThread=False)
            if not pid:
                raise Exception('no task')
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printErr(
                "fail to recognize target", reason=True)
            sys.exit(0)

        for pid in sorted(pids):
            comm = SysMgr.getComm(pid)

            if not vaddr:
                PageAnalyzer.printMemoryArea(
                    pid, comm=comm, showall=SysMgr.showAll)
                SysMgr.printPipe(oneLine)
                continue

            SysMgr.checkRootPerm()

            vrange = vaddr.split('-')
            rangeCnt = len(vrange)

            if rangeCnt > 2:
                SysMgr.printErr(
                    "fail to recognize address, "
                    "input address such as 102400 or 0x1234a-0x123ff")
                sys.exit(0)
            else:
                try:
                    if vrange[0].startswith("0x"):
                        addrs = long(vrange[0], base=16)
                        addre = addrs
                    else:
                        addrs = long(vrange[0])
                        addre = addrs
                except SystemExit:
                    sys.exit(0)
                except:
                    SysMgr.printErr(
                        "fail to recognize address, "
                        "input address such as 0xabcd or 78901234")
                    sys.exit(0)

                try:
                    if rangeCnt == 2:
                        if vrange[1].startswith("0x"):
                            addre = long(vrange[1], base=16)
                        else:
                            addre = long(vrange[1])

                        offset = long(0)
                    else:
                        offset = SysMgr.pageSize

                    if addrs > addre:
                        SysMgr.printErr(
                            "fail to recognize address, "
                            "input bigger second address than first address")
                        sys.exit(0)
                except SystemExit:
                    sys.exit(0)
                except:
                    SysMgr.printErr(
                        "fail to recognize address, "
                        "input address such as 0x1234-0x4444")
                    sys.exit(0)

            SysMgr.printPipe(
                "\n[ TASK: %s(%s) ] [ AREA: %s ] [ HELP: %s ]" % \
                    (comm, pid, vaddr, "kernel/Documentation/vm/pagemap.txt"))

            PageAnalyzer.printMemoryArea(pid, addrs, addre)
            SysMgr.printPipe(twoLine)

            SysMgr.printPipe((
                "{0:^18}|{1:^16}|{2:^9}|{3:^6}|{4:^6}|{5:^5}|"
                "{6:^8}|{7:^7}| {8}({9})\n{10}").\
                format("VADDR", "PFN", "PRESENT", "SWAP", "FILE", "REF",
                "SDRT", "EXMAP", "FLAG", "FLAGS", oneLine))

            for addr in range(addrs, addre + offset, SysMgr.pageSize):
                entry = PageAnalyzer.getPagemapEntry(pid, addr)

                pfn = PageAnalyzer.getPfn(entry)

                isPresent = PageAnalyzer.isPresent(entry)

                isSwapped = PageAnalyzer.isSwapped(entry)

                isSoftdirty = PageAnalyzer.isSoftdirty(entry)

                isExmapped = PageAnalyzer.isExmapped(entry)

                isFile = PageAnalyzer.isFilePage(entry)

                bflags = hex(PageAnalyzer.getPageFlags(pfn)).rstrip('L')

                sflags = PageAnalyzer.getFlagTypes(bflags)

                SysMgr.printPipe((
                    "{0:^18}|{1:^16}|{2:^9}|{3:^6}|{4:^6}|{5:^5}|"\
                    "{6:^8}|{7:^7}| {8}({9} )").format(
                    hex(addr).rstrip('L'), hex(pfn).rstrip('L'), isPresent,
                    isSwapped, isFile,PageAnalyzer.getPagecount(pfn),
                    isSoftdirty, isExmapped, bflags, sflags))

            SysMgr.printPipe("%s\n" % oneLine)



    @staticmethod
    def printMemoryArea(
        pid, start=-1, end=-1, comm=None, lastLine=False, showall=True):

        count = long(0)
        switch = long(0)
        fpath = '%s/%s/maps' % (SysMgr.procPath, pid)

        if start == end == -1 and not showall:
            printSummary = True
        else:
            printSummary = False

        # read all map info #
        try:
            # summary #
            if printSummary:
                buf = FileAnalyzer.getProcMapInfo(pid, saveAll=True)
            else:
                with open(fpath, 'r') as fd:
                    buf = fd.readlines()
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printOpenErr(fpath)
            sys.exit(0)

        if start == end == -1:
            if not comm:
                comm = SysMgr.getComm(pid)

            # get mem stat #
            convert = UtilMgr.convSize2Unit
            mlist = SysMgr.getMemStat(pid)
            vssIdx = ConfigMgr.STATM_TYPE.index("TOTAL")
            vss = convert(long(mlist[vssIdx]) << 12)
            rssIdx = ConfigMgr.STATM_TYPE.index("RSS")
            rss = convert(long(mlist[rssIdx]) << 12)
            SysMgr.printPipe(
                "\n[ TASK: %s(%s) ] [ VSS: %s ] [ RSS: %s ]" % \
                    (comm, pid, vss, rss))

        start = hex(start)
        end = hex(end)
        all = hex(-1)

        # print menu #
        menuStr = ''
        if printSummary:
            menuList = \
                ['AREA', 'PERM', '%8s' % 'OFFSET', '%6s' % 'DEV', '%7s' % 'INODE']
            menuBuf = menuList
        else:
            menuList = ['AREA', 'PERM', 'OFFSET', 'DEV', '%12s' % 'INODE']
            menuBuf = str(buf[-1]).split()

        for idx, value in enumerate(menuBuf):
            if idx < 5:
                if idx == 0:
                    text = '{0:^38}'.format(menuList[idx])
                else:
                    text = menuList[idx]
            else:
                break

            value = ' ' * (len(value) - len(text) + 1)
            menuStr = '%s%s%s' % (menuStr, text, value)

        menuStr = '%s %s' % (menuStr, 'TARGET')
        SysMgr.printPipe('%s\n%s\n%s' % (twoLine, menuStr, oneLine))

        # set text position #
        tstr = menuStr.split()
        pstr = tstr[1]

        # print summarized map info #
        if printSummary:
            for fname, info in sorted(buf.items(),
                key=lambda e: e[1]['vstart']):
                try:
                    soffset = hex(info['vstart']).rstrip('L')
                    eoffset = hex(info['vend']).rstrip('L')
                    if not fname.startswith('/'):
                        fname = '[%s]' % fname
                    SysMgr.printPipe('%18s %18s %4s %8s %6s %7s %s' % \
                        (soffset, eoffset, info['perm'], info['offset'],\
                        info['devid'], info['inode'], fname))
                except SystemExit:
                    sys.exit(0)
                except:
                    pass
            return

        # print all map info #
        for line in buf:
            tmplist = line.split()
            soffset, eoffset = tmplist[0].split('-')

            if start == end == all:
                switch = long(0)
            elif '-' in line:
                soffset = hex(long(soffset, base=16))
                eoffset = hex(long(eoffset, base=16))

                if (start >= soffset and start < eoffset):
                    switch = 1
                elif switch == 0:
                    continue
                elif end < eoffset:
                    break

            try:
                target = line[:-1].split()

                target[4] = '%12s' % target[4]

                if not soffset.startswith('0x'):
                    soffset = '0x%s' % soffset

                if not eoffset.startswith('0x'):
                    eoffset = '0x%s' % eoffset

                SysMgr.printPipe('%18s %18s %s' % \
                    (soffset, eoffset, ' '.join(target[1:])))
            except SystemExit:
                sys.exit(0)
            except:
                pass

            count += 1

            if switch == 1 and end <= eoffset:
                break

        if count == 0:
            SysMgr.printPipe('no involved memory area')
        elif lastLine:
            SysMgr.printPipe(oneLine)



    @staticmethod
    def getFlagTypes(flags):
        sflags = ' '

        for idx, val in enumerate(PageAnalyzer.flagList):
            if ((long(flags, 16) & (1 << long(idx))) != 0):
                sflags = "%s%s|" % (sflags, val[4:])

        return sflags[:-1]



    @staticmethod
    def readEntry(path, offset, size=8):
        with open(path, 'rb') as f:
            f.seek(offset, 0)
            try:
                return struct.unpack('Q', f.read(size))[0]
            except:
                SysMgr.printErr(
                    "fail to read %s byte from %s of %s" % \
                    (size, offset, path))
                sys.exit(0)



    @staticmethod
    def getPagemapEntry(pid, addr):
        maps_path = "{0}/{1}/pagemap".format(SysMgr.procPath, pid)
        if not os.path.isfile(maps_path):
            SysMgr.printErr("fail to find %s process" % pid)
            sys.exit(0)

        pageSize = os.sysconf("SC_PAGE_SIZE")
        pagemap_entry_size = 8
        offset = long(addr / pageSize) * pagemap_entry_size

        return PageAnalyzer.readEntry(maps_path, offset)



    @staticmethod
    def getPfn(entry):
        return entry & 0x7FFFFFFFFFFFFF



    @staticmethod
    def isPresent(entry):
        return ((entry & (1 << 63)) != 0)



    @staticmethod
    def isSoftdirty(entry):
        return ((entry & (1 << 55)) != 0)



    @staticmethod
    def isExmapped(entry):
        return ((entry & (1 << 56)) != 0)



    @staticmethod
    def isSwapped(entry):
        return ((entry & (1 << 62)) != 0)



    @staticmethod
    def isFilePage(entry):
        return ((entry & (1 << 61)) != 0)



    @staticmethod
    def getPagecount(pfn):
        file_path = "%s/kpagecount" % SysMgr.procPath
        offset = pfn * 8
        return PageAnalyzer.readEntry(file_path, offset)



    @staticmethod
    def getPageFlags(pfn):
        file_path = "%s/kpageflags" % SysMgr.procPath
        offset = pfn * 8
        return PageAnalyzer.readEntry(file_path, offset)





class FunctionAnalyzer(object):
    """ Analyzer for function profiling """

    symStackIdxTable = [
        'CPU_TICK', 'STACK', 'PAGE_ALLOC', 'PAGE_FREE', 'BLK_READ',
        'ARGUMENT', 'HEAP_EXPAND', 'HEAP_REDUCE', 'IGNORE', 'BLK_WRITE',
        'LOCK_TRY', 'UNLOCK', 'SYSCALL', 'CUSTOM'
        ]



    def __init__(self, logFile):
        self.cpuEnabled = False
        self.memEnabled = False
        self.heapEnabled = False
        self.breadEnabled = False
        self.bwriteEnabled = False
        self.sigEnabled = False
        self.lockEnabled = False
        self.sysEnabled = False

        self.sort = 'sym'
        self.connObj = None

        self.finishTime = '0'
        self.lastTime = '0'
        self.totalTime = long(0)
        self.totalTick = long(0)
        self.prevTime = '0'
        self.prevTid = '0'

        self.lastCore = None
        self.coreCtx = {}
        self.nowCtx = None
        self.nowEvent = None
        self.savedEvent = None
        self.nestedEvent = None
        self.nowCnt = long(0)
        self.savedCnt = long(0)
        self.nestedCnt = long(0)
        self.nowArg = long(0)
        self.savedArg = long(0)
        self.nestedArg = long(0)

        self.duplicatedPos = long(0)
        self.periodicEventCnt = long(0)
        self.periodicContEventCnt = long(0)
        self.periodicEventInterval = long(0)
        self.heapExpEventCnt = long(0)
        self.heapExpSize = long(0)
        self.heapRedEventCnt = long(0)
        self.heapRedSize = long(0)
        self.pageAllocEventCnt = long(0)
        self.pageAllocCnt = long(0)
        self.pageFreeEventCnt = long(0)
        self.pageFreeCnt = long(0)
        self.pageUnknownFreeCnt = long(0)
        self.pageUsageCnt = long(0)
        self.blockRdEventCnt = long(0)
        self.blockRdUsageCnt = long(0)
        self.blockWrEventCnt = long(0)
        self.blockWrUsageCnt = long(0)
        self.lockTryEventCnt = long(0)
        self.unlockEventCnt = long(0)
        self.customCnt = long(0)
        self.customTotal = long(0)
        self.syscallCnt = long(0)

        self.customEventTable = {}
        self.ignoreTable = {}
        self.mapData = []
        self.pageTable = {}
        self.oldPageTable = {}
        self.heapTable = {}
        self.oldHeapTable = {}
        self.posData = {}
        self.userSymData = {}
        self.userFileData = {}
        self.kerSymData = {}
        self.threadData = {}
        self.syscallTable = {}
        self.customCallData = []
        self.lockCallData = []
        self.sysCallData = []
        self.userCallData = []
        self.kernelCallData = []
        '''
        userCallData = kernelCallData = \
            [pos, stack, event, eventCnt, eventArg]
        '''

        self.init_threadData = \
            {'comm': '?', 'tgid': '-'*5, 'target': False, 'cpuTick': long(0),
            'die': False, 'new': False, 'nrPages': long(0), 'userPages': long(0),
            'cachePages': long(0), 'kernelPages': long(0), 'heapSize': long(0),
            'eventCnt': long(0), 'nrWrBlocks': long(0), 'customCnt': long(0),
            'nrUnknownFreePages': long(0), 'nrKnownFreePages': long(0),
            'nrRdBlocks': long(0), 'nrLockTry': long(0), 'nrUnlock': long(0),
            'customTotal': long(0), 'nrSyscall': long(0), 'syscallTable': None,
            'lastNrSyscall': long(-1)}

        self.init_posData = \
            {'symbol': '', 'binary': '', 'origBin': '', 'offset': hex(0),
            'posCnt': long(0), 'userPageCnt': long(0), 'cachePageCnt': long(0),
            'kernelPageCnt': long(0), 'totalCnt': long(0), 'blockRdCnt': long(0),
            'blockWrCnt': long(0), 'pageCnt': long(0), 'heapSize': long(0),
            'unknownPageFreeCnt': long(0), 'src': '', 'customCnt': long(0),
            'customTotal': long(0), 'lockTryCnt': long(0), 'unlockCnt': long(0),
            'syscallCnt': long(0)}

        self.init_symData = \
            {'pos': '', 'origBin': '', 'tickCnt': long(0), 'blockRdCnt': long(0),
            'pageCnt': long(0), 'unknownPageFreeCnt': long(0), 'stack': None,
            'symStack': None, 'userPageCnt': long(0), 'cachePageCnt': long(0),
            'kernelPageCnt': long(0), 'heapSize': long(0), 'blockWrCnt': long(0),
            'customCnt': long(0), 'customTotal': long(0), 'pagePair': None,
            'pagePairCnt': long(0), 'pagePairTotal': float(0),
            'pagePairMin': float(0), 'pagePairMax': float(0),
            'pagePairAvr': float(0), 'pageRemainMin': float(0),
            'pageRemainMax': float(0), 'pageRemainAvr': float(0),
            'pageRemainTotal': float(0), 'lockTryCnt': long(0),
            'unlockCnt': long(0), 'syscallCnt': long(0), 'totalTickCnt': long(0)}

        self.init_ctxData = \
            {'nestedEvent': None, 'savedEvent': None, 'nowEvent': None,
            'nested': long(0), 'recStat': False, 'nestedCnt': long(0),
            'savedCnt': long(0), 'nowCnt': long(0), 'nestedArg': None,
            'savedArg': None, 'prevMode': None, 'curMode': None,
            'userLastPos': '', 'userStack': None, 'kerLastPos': '',
            'kerStack': None, 'prevKerLastPos': '', 'prevKerStack': None,
            'nowArg': None, 'prevTid': None, 'prevTime': None}

        self.init_pageLinkData = \
            {'sym': '0', 'subStackAddr': long(0), 'ksym': '0',
            'ksubStackAddr': long(0), 'type': '0', 'time': '0'}

        self.init_heapSegData = \
            {'tid': '0', 'size': long(0), 'sym': '0',
            'subStackAddr': long(0), 'ksym': '0', 'ksubStackAddr': long(0),
            'time': float(0), 'core': '0'}

        self.init_pageData = \
            {'tid': '0', 'page': '0', 'flags': '0', 'type': '0', 'time': '0'}

        self.init_glueData = \
            {'count': long(0), 'size': long(0),
            'timeList': None, 'valueList': None}

        self.init_subStackPageInfo = [0, 0, 0]
        # subStackPageInfo = [userPageCnt, cachePageCnt, kernelPageCnt]

        # read trace data #
        lines = TaskAnalyzer.readTraceData(logFile)

        # save trace data and stop analysis #
        if SysMgr.outputFile:
            SysMgr.saveTraceData(lines)
            sys.exit(0)

        # Check target thread setting #
        if not SysMgr.filterGroup:
            SysMgr.filterGroup.insert(0, '')
            self.target = []
        else:
            self.target = SysMgr.filterGroup

        # Check root path #
        if SysMgr.userEnable:
            if SysMgr.rootPath == '':
                rootPath = '/'
            else:
                rootPath = SysMgr.rootPath
            SysMgr.printInfo(
                "use %s as sysroot path" % rootPath)

        # Register None pos #
        self.posData['0'] = dict(self.init_posData)

        # get process tree #
        SysMgr.getProcTreeInfo()

        # start parsing logs #
        SysMgr.totalLine = len(lines)
        SysMgr.printStat(
            'start analyzing data... [ STOP(Ctrl+c) ]')

        self.parseLogs(lines, SysMgr.filterGroup)

        # Check whether data of target thread is collected or nothing #
        if not self.userCallData and \
            not self.kernelCallData and \
            len(self.target) > 0:
            if not self.target:
                SysMgr.printErr("no collected stack data")
            else:
                targetStr = ', '.join(self.target)
                SysMgr.printErr(
                    "no collected stack related to '%s'" % targetStr)
            sys.exit(0)
        elif SysMgr.userEnable and \
            len(self.userCallData) == 1 and \
            self.userCallData[0][0] == '0':
            SysMgr.userEnable = False
            if self.target == []:
                SysMgr.printWarn(
                    "no collected user stack data", True)
            else:
                targetStr = ', '.join(self.target)
                SysMgr.printWarn(
                    "no collected user stack related to '%s'" % \
                    targetStr, True)

        # Get symbols from call address #
        SysMgr.printStat(
            'start resolving symbols... [ STOP(Ctrl+c) ]')
        self.getSymbols()

        # Merge callstacks by symbol and address #
        SysMgr.printStat(
            'start summarizing functions... [ STOP(Ctrl+c) ]')
        self.mergeStacks()



    def __del__(self):
        pass



    def handleHeapExpand(self, sym, ksym, stackAddr, kstackAddr, size, arg):
        addr = arg[0]
        time = arg[1]
        core = arg[2]
        tid = arg[3]

        self.userSymData[sym]['heapSize'] += size
        self.kerSymData[ksym]['heapSize'] += size

        self.heapTable.setdefault(addr, dict(self.init_heapSegData))
        self.heapTable[addr]['size'] = size
        self.heapTable[addr]['sym'] = sym
        self.heapTable[addr]['ksym'] = ksym
        self.heapTable[addr]['subStackAddr'] = stackAddr
        self.heapTable[addr]['ksubStackAddr'] = kstackAddr
        self.heapTable[addr]['time'] = time
        self.heapTable[addr]['core'] = core
        self.heapTable[addr]['tid'] = tid



    def handleHeapReduce(self, size, arg):
        addr = arg[0]

        subStackIndex = FunctionAnalyzer.symStackIdxTable.index('STACK')
        heapExpIndex = FunctionAnalyzer.symStackIdxTable.index('HEAP_EXPAND')

        try:
            sym = self.heapTable[addr]['sym']
            ksym = self.heapTable[addr]['ksym']
            stackAddr = self.heapTable[addr]['subStackAddr']
            kstackAddr = self.heapTable[addr]['ksubStackAddr']

            self.userSymData[sym]['heapSize'] -= size
            self.kerSymData[ksym]['heapSize'] -= size
        except:
            SysMgr.printWarn(
                "fail to find heap segment to be freed")
            return

        # Set user stack list #
        if self.sort == 'sym':
            targetStack = self.userSymData[sym]['symStack']
        elif self.sort == 'pos':
            targetStack = self.userSymData[sym]['stack']

        # Find user stack of symbol allocated this segment #
        for val in targetStack:
            if id(val[subStackIndex]) == stackAddr:
                # Increase heap count of subStack #
                val[heapExpIndex] -= size
                break

        # Set kernel stack list #
        kernelTargetStack = self.kerSymData[ksym]['stack']

        # Find kernel stack of symbol allocated this segment #
        for val in kernelTargetStack:
            if id(val[subStackIndex]) == kstackAddr:
                # Increase heap count of subStack #
                val[heapExpIndex] -= size
                break

        self.heapTable.pop(addr)



    def handlePageFree(
        self, sym, ksym, stackAddr, kstackAddr,
        pageFreeCnt, pageType, pfn, atime):

        subStackIndex = FunctionAnalyzer.symStackIdxTable.index('STACK')
        pageAllocIndex = FunctionAnalyzer.symStackIdxTable.index('PAGE_ALLOC')
        pageFreeIndex = FunctionAnalyzer.symStackIdxTable.index('PAGE_FREE')
        argIndex = FunctionAnalyzer.symStackIdxTable.index('ARGUMENT')

        for cnt in range(0, pageFreeCnt):
            pfnv = pfn + cnt
            subStackPageInfoIdx = long(0)

            try:
                # Decrease page count of symbol allocated page  #
                # toDo: fix bug about wrong count of pos #
                allocSym = self.pageTable[pfnv]['sym']
                allocStackAddr = self.pageTable[pfnv]['subStackAddr']
                allocKernelSym = self.pageTable[pfnv]['ksym']
                allocKernelStackAddr = self.pageTable[pfnv]['ksubStackAddr']
                allocTime = self.pageTable[pfnv]['time']

                self.pageUsageCnt -= 1
                self.userSymData[allocSym]['pageCnt'] -= 1
                self.kerSymData[allocKernelSym]['pageCnt'] -= 1

                if pageType == 'USER':
                    self.userSymData[allocSym]['userPageCnt'] -= 1
                    self.kerSymData[allocKernelSym]['userPageCnt'] -= 1
                    subStackPageInfoIdx = long(0)
                elif pageType == 'CACHE':
                    self.userSymData[allocSym]['cachePageCnt'] -= 1
                    self.kerSymData[allocKernelSym]['cachePageCnt'] -= 1
                    subStackPageInfoIdx = 1
                elif pageType == 'KERNEL':
                    self.userSymData[allocSym]['kernelPageCnt'] -= 1
                    self.kerSymData[allocKernelSym]['kernelPageCnt'] -= 1
                    subStackPageInfoIdx = 2

                # get page lifetime #
                lifeTime = float(atime) - float(allocTime)

                # Set user page lifetime #
                if lifeTime > self.userSymData[allocSym]['pagePairMax']:
                    self.userSymData[allocSym]['pagePairMax'] = lifeTime
                if self.userSymData[allocSym]['pagePairMin'] == 0 or \
                    lifeTime < self.userSymData[allocSym]['pagePairMin']:
                    self.userSymData[allocSym]['pagePairMin'] = lifeTime
                self.userSymData[allocSym]['pagePairTotal'] += lifeTime

                # Set kernel page lifetime #
                if lifeTime > self.kerSymData[allocKernelSym]['pagePairMax']:
                    self.kerSymData[allocKernelSym]['pagePairMax'] = lifeTime
                if self.kerSymData[allocKernelSym]['pagePairMin'] == 0 or \
                    lifeTime < self.kerSymData[allocKernelSym]['pagePairMin']:
                    self.kerSymData[allocKernelSym]['pagePairMin'] = lifeTime
                self.kerSymData[allocKernelSym]['pagePairTotal'] += lifeTime

                # Set user stack list #
                if self.sort == 'sym':
                    targetStack = self.userSymData[allocSym]['symStack']
                elif self.sort == 'pos':
                    targetStack = self.userSymData[allocSym]['stack']

                # Find user stack allocated this page #
                for val in targetStack:
                    if id(val[subStackIndex]) != allocStackAddr:
                        continue

                    val[pageAllocIndex] -= 1
                    val[argIndex][subStackPageInfoIdx] -= 1

                    # Set user stack list to free this page #
                    if self.sort == 'sym':
                        subTargetStack = self.userSymData[sym]['symStack']
                    elif self.sort == 'pos':
                        subTargetStack = self.userSymData[sym]['stack']

                    # Find user stack to free this page #
                    for sval in subTargetStack:
                        if id(sval[subStackIndex]) != stackAddr:
                            continue

                        if not self.userSymData[allocSym]['pagePair']:
                            self.userSymData[allocSym]['pagePair'] = {}

                        allocCall = ''
                        freeCall = ''

                        try:
                            tsym = val[subStackIndex][0]
                            allocCall = '%s [%s]' % \
                                (val[subStackIndex][0],
                                self.userSymData[tsym]['origBin'])
                            for usym in val[subStackIndex][1:]:
                                allocCall = '%s <- %s [%s]' % \
                                    (allocCall, usym,
                                    self.userSymData[sym]['origBin'])
                        except:
                            if allocCall == '':
                                allocCall = 'None'

                        try:
                            freeCall = '%s [%s]' % \
                                (sym, self.userSymData[sym]['origBin'])
                            for usym in sval[subStackIndex][1:]:
                                freeCall = '%s <- %s[%s]' % \
                                    (freeCall, usym,
                                    self.userSymData[sym]['origBin'])
                        except:
                            if freeCall == '':
                                freeCall = 'None'

                        pairId = '%s#%s' % (allocCall, freeCall)

                        try:
                            self.userSymData[allocSym]['pagePair'][pairId]
                        except:
                            self.userSymData[allocSym]['pagePair'][pairId] = \
                                dict(self.init_glueData)

                        self.userSymData[allocSym]['pagePairCnt'] += 1
                        allocator = \
                            self.userSymData[allocSym]['pagePair'][pairId]
                        allocator['size'] += 1

                        if not allocator['valueList']:
                            allocator['valueList'] = {}
                        try:
                            allocator['valueList'][pageType] += 1
                        except:
                            allocator['valueList'][pageType] = 1

                        break
                    break

                # Set kernel stack list #
                kernelTargetStack = self.kerSymData[allocKernelSym]['stack']

                # Find kernel stack allocated this page #
                for val in kernelTargetStack:
                    if id(val[subStackIndex]) != allocKernelStackAddr:
                        continue

                    val[pageAllocIndex] -= 1
                    val[argIndex][subStackPageInfoIdx] -= 1

                    # Set kernel stack list to free this page #
                    subTargetStack = self.kerSymData[ksym]['stack']

                    # Find kernel stack to free this page #
                    for sval in subTargetStack:
                        if id(sval[subStackIndex]) != kstackAddr:
                            continue

                        kernelData = self.kerSymData[allocKernelSym]

                        if not kernelData['pagePair']:
                            kernelData['pagePair'] = {}

                        allocCall = ''
                        freeCall = ''

                        try:
                            allocCall = '%s' % \
                                self.posData[val[subStackIndex][0]]['symbol']
                            for addr in val[subStackIndex][1:]:
                                allocCall = '%s <- %s' % \
                                    (allocCall, self.posData[addr]['symbol'])
                        except:
                            if allocCall == '':
                                allocCall = 'None'

                        try:
                            freeCall = '%s' % ksym
                            for addr in sval[subStackIndex]:
                                freeCall = '%s <- %s' % \
                                    (freeCall, self.posData[addr]['symbol'])
                        except:
                            if freeCall == '':
                                freeCall = 'None'

                        pairId = '%s#%s' % (allocCall, freeCall)

                        try:
                            kernelData['pagePair'][pairId]
                        except:
                            kernelData['pagePair'][pairId] = \
                                dict(self.init_glueData)

                        self.kerSymData[allocKernelSym]['pagePairCnt'] += 1
                        allocator = kernelData['pagePair'][pairId]
                        allocator['size'] += 1

                        if not allocator['valueList']:
                            allocator['valueList'] = {}
                        try:
                            allocator['valueList'][pageType] += 1
                        except:
                            allocator['valueList'][pageType] = 1

                        break

                    break

                self.pageTable.pop(pfnv, None)
            except SystemExit:
                sys.exit(0)
            except:
                # this page is allocated before starting profile #

                self.pageUnknownFreeCnt += 1
                self.userSymData[sym]['unknownPageFreeCnt'] += 1
                self.kerSymData[ksym]['unknownPageFreeCnt'] += 1

                # Set user stack list #
                if self.sort == 'sym':
                    targetStack = self.userSymData[sym]['symStack']
                elif self.sort == 'pos':
                    targetStack = self.userSymData[sym]['stack']

                # Find subStack allocated this page #
                for val in targetStack:
                    if id(val[subStackIndex]) == stackAddr:
                        val[pageFreeIndex] += 1
                        break

                # Set kernel stack list #
                kernelTargetStack = self.kerSymData[ksym]['stack']

                # Find subStack allocated this page #
                for val in kernelTargetStack:
                    if id(val[subStackIndex]) == kstackAddr:
                        val[pageFreeIndex] += 1
                        break

                continue



    def handlePageAlloc(
        self, sym, ksym, stackAddr, kstackAddr, pageAllocCnt,
        pageType, pfn, atime):

        subStackPageInfoIdx = long(0)

        subStackIndex = FunctionAnalyzer.symStackIdxTable.index('STACK')
        pageAllocIndex = FunctionAnalyzer.symStackIdxTable.index('PAGE_ALLOC')
        argIndex = FunctionAnalyzer.symStackIdxTable.index('ARGUMENT')

        # Increase counts of page to be allocated #
        self.userSymData[sym]['pageCnt'] += pageAllocCnt
        self.kerSymData[ksym]['pageCnt'] += pageAllocCnt

        if pageType == 'USER':
            self.userSymData[sym]['userPageCnt'] += pageAllocCnt
            self.kerSymData[ksym]['userPageCnt'] += pageAllocCnt
            subStackPageInfoIdx = long(0)
        elif pageType == 'CACHE':
            self.userSymData[sym]['cachePageCnt'] += pageAllocCnt
            self.kerSymData[ksym]['cachePageCnt'] += pageAllocCnt
            subStackPageInfoIdx = 1
        elif pageType == 'KERNEL':
            self.userSymData[sym]['kernelPageCnt'] += pageAllocCnt
            self.kerSymData[ksym]['kernelPageCnt'] += pageAllocCnt
            subStackPageInfoIdx = 2

        # Set user stack list #
        if self.sort == 'sym':
            targetStack = self.userSymData[sym]['symStack']
        elif self.sort == 'pos':
            targetStack = self.userSymData[sym]['stack']

        # Find user stack of symbol allocated this page #
        for val in targetStack:
            if id(val[subStackIndex]) == stackAddr:
                # Increase page count of subStack #
                val[argIndex][subStackPageInfoIdx] += pageAllocCnt
                break

        # Set kernel stack list #
        kernelTargetStack = self.kerSymData[ksym]['stack']

        # Find kernel stack of symbol allocated this page #
        for val in kernelTargetStack:
            if id(val[subStackIndex]) == kstackAddr:
                # Increase page count of subStack #
                val[argIndex][subStackPageInfoIdx] += pageAllocCnt
                break

        # Make PTE in page table #
        for cnt in range(0, pageAllocCnt):
            pfnv = pfn + cnt
            subStackPageInfoIdx = long(0)

            try:
                # Check whether this page is already allocated #
                allocSym = self.pageTable[pfnv]['sym']

                allocStackAddr = self.pageTable[pfnv]['subStackAddr']
                allocKernelSym = self.pageTable[pfnv]['ksym']
                allocKernelStackAddr = self.pageTable[pfnv]['ksubStackAddr']

                # Decrease counts of page already allocated but no free log #
                self.pageUsageCnt -= 1
                self.userSymData[allocSym]['pageCnt'] -= 1
                self.kerSymData[allocKernelSym]['pageCnt'] -= 1

                origPageType = self.pageTable[pfnv]['type']
                if origPageType == 'USER':
                    self.userSymData[allocSym]['userPageCnt'] -= 1
                    self.kerSymData[allocKernelSym]['userPageCnt'] -= 1
                    subStackPageInfoIdx = long(0)
                elif origPageType == 'CACHE':
                    self.userSymData[allocSym]['cachePageCnt'] -= 1
                    self.kerSymData[allocKernelSym]['cachePageCnt'] -= 1
                    subStackPageInfoIdx = 1
                elif origPageType == 'KERNEL':
                    self.userSymData[allocSym]['kernelPageCnt'] -= 1
                    self.kerSymData[allocKernelSym]['kernelPageCnt'] -= 1
                    subStackPageInfoIdx = 2

                # Set user stack list #
                if self.sort == 'sym':
                    targetStack = self.userSymData[allocSym]['symStack']
                elif self.sort == 'pos':
                    targetStack = self.userSymData[allocSym]['stack']

                # Find user stack of symbol allocated this page #
                for val in targetStack:
                    if id(val[subStackIndex]) == allocStackAddr:
                        # Decrease allocated page count of substack #
                        val[pageAllocIndex] -= 1
                        val[argIndex][subStackPageInfoIdx] -= 1
                        break

                # Set kernel stack list #
                kernelTargetStack = self.kerSymData[allocKernelSym]['stack']

                # Find kernel stack of symbol allocated this page #
                for val in kernelTargetStack:
                    if id(val[subStackIndex]) == allocKernelStackAddr:
                        # Decrease allocated page count of substack #
                        val[pageAllocIndex] -= 1
                        val[argIndex][subStackPageInfoIdx] -= 1
                        break
            except SystemExit:
                sys.exit(0)
            except:
                self.pageTable[pfnv] = dict(self.init_pageLinkData)

            self.pageTable[pfnv]['sym'] = sym
            self.pageTable[pfnv]['ksym'] = ksym
            self.pageTable[pfnv]['type'] = pageType
            self.pageTable[pfnv]['subStackAddr'] = stackAddr
            self.pageTable[pfnv]['ksubStackAddr'] = kstackAddr
            self.pageTable[pfnv]['time'] = atime



    def mergeStacks(self):
        sym = ''
        ksym = ''
        stackAddr = long(0)
        kstackAddr = long(0)
        lineCnt = -1
        lastIdx = len(self.userCallData)

        # Backup page table used previously and Initialize it #
        self.oldPageTable = self.pageTable
        self.pageTable = {}

        # Backup heap table used previously and Initialize it #
        self.oldHeapTable = self.heapTable
        self.heapTable = {}

        subStackIndex = FunctionAnalyzer.symStackIdxTable.index('STACK')
        argIndex = FunctionAnalyzer.symStackIdxTable.index('ARGUMENT')

        # Merge call data by symbol or address #
        for val in self.userCallData:
            lineCnt += 1
            UtilMgr.printProgress(lineCnt, lastIdx - 1)

            pos = val[0]
            stack = val[1]
            event = val[2]
            eventCnt = val[3]
            arg = val[4]

            '''
            Do not merge PAGE_FREE count
            because it will be merged with unknownPageFreeCnt
            '''
            if event == 'PAGE_FREE':
                savedEventCnt = eventCnt
                eventCnt = long(0)

            try:
                eventIndex = FunctionAnalyzer.symStackIdxTable.index(event)
            except:
                eventIndex = FunctionAnalyzer.symStackIdxTable.index('IGNORE')

            kernelPos = self.kernelCallData[lineCnt][0]
            kernelStack = self.kernelCallData[lineCnt][1]
            subStackPageInfo = list(self.init_subStackPageInfo)

            targetStack = []
            kernelTargetStack = []

            # Resolve user symbol #
            try:
                # No symbol related to last pos #
                if self.posData[pos]['symbol'] == '':
                    self.posData[pos]['symbol'] = pos
                    sym = pos
                else:
                    sym = self.posData[pos]['symbol']
            except:
                continue

            # Resolve kernel symbol #
            try:
                # No symbol related to last pos #
                if self.posData[kernelPos]['symbol'] == '':
                    self.posData[kernelPos]['symbol'] = kernelPos
                    ksym = kernelPos
                else:
                    ksym = self.posData[kernelPos]['symbol']
            except:
                continue

            # Make user file table of last pos in stack #
            try:
                path = self.posData[pos]['binary']
                self.userFileData[path]
            except:
                self.userFileData[path] = dict(self.init_symData)

            # Make user symbol table of last pos in stack #
            try:
                self.userSymData[sym]
            except:
                self.userSymData[sym] = dict(self.init_symData)
                self.userSymData[sym]['stack'] = []
                self.userSymData[sym]['symStack'] = []
                self.userSymData[sym]['pos'] = pos
                self.userSymData[sym]['origBin'] = self.posData[pos]['origBin']

            # Make kenel symbol table of last pos in stack #
            try:
                self.kerSymData[ksym]
            except:
                self.kerSymData[ksym] = dict(self.init_symData)
                self.kerSymData[ksym]['stack'] = []
                self.kerSymData[ksym]['pos'] = kernelPos

            # Set target user stack #
            if self.sort == 'sym':
                tempSymStack = []
                # Make temporary symbol stack to merge stacks by symbol #
                for addr in stack:
                    tempSym = self.posData[addr]['symbol']

                    # Ignore this function if there is no symbol #
                    if not SysMgr.showAll and \
                        self.posData[addr]['origBin'] == '??' and \
                        (tempSym == addr or \
                            tempSym == self.posData[addr]['offset'] or \
                            addr == '00c0ffee'):
                        continue

                    # No symbol data #
                    if tempSym == '':
                        if self.posData[addr]['origBin'] == '??':
                            tempSym = '%x' % \
                                long(self.posData[addr]['pos'], 16)
                        else:
                            tempSym = '%x' % \
                                long(self.posData[addr]['offset'], 16)

                    try:
                        self.userSymData[tempSym]
                    except:
                        self.userSymData[tempSym] = dict(self.init_symData)
                        self.userSymData[tempSym]['stack'] = []
                        self.userSymData[tempSym]['symStack'] = []
                        self.userSymData[tempSym]['pos'] = addr
                        self.userSymData[tempSym]['origBin'] = \
                            self.posData[addr]['origBin']

                    tempSymStack.append(tempSym)

                # Switch input stack to symbol stack #
                stack = tempSymStack
                targetStack = self.userSymData[sym]['symStack']
            elif self.sort == 'pos':
                targetStack = self.userSymData[sym]['stack']

            # First user stack related to this symbol #
            if not targetStack:
                tempList = [0] * len(FunctionAnalyzer.symStackIdxTable)
                tempList[eventIndex] = eventCnt
                tempList[subStackIndex] = stack
                tempList[argIndex] = list(subStackPageInfo)
                targetStack.append(tempList)

                stackAddr = id(stack)
            else:
                found = False

                # Find same stack by pos in stack list #
                for stackInfo in targetStack:
                    stackSet = set(stack)
                    subStackSet = set(stackInfo[subStackIndex])

                    # Found same stack #
                    if not list(stackSet - subStackSet) and \
                        not list(subStackSet - stackSet):
                        found = True

                        stackInfo[eventIndex] += eventCnt
                        stackAddr = id(stackInfo[subStackIndex])

                        break

                # New stack related to this symbol #
                if found == False:
                    tempList = [0] * len(FunctionAnalyzer.symStackIdxTable)
                    tempList[eventIndex] = eventCnt
                    tempList[subStackIndex] = stack
                    tempList[argIndex] = list(subStackPageInfo)
                    targetStack.append(tempList)

                    stackAddr = id(stack)

            # Set target kernel stack #
            kernelTargetStack = self.kerSymData[ksym]['stack']

            # First stack related to this symbol #
            if not kernelTargetStack:
                tempList = [0] * len(FunctionAnalyzer.symStackIdxTable)
                tempList[eventIndex] = eventCnt
                tempList[subStackIndex] = kernelStack
                tempList[argIndex] = list(subStackPageInfo)
                kernelTargetStack.append(tempList)

                kstackAddr = id(kernelStack)
            else:
                found = False
                for stackInfo in kernelTargetStack:
                    kerStackSet = set(kernelStack)
                    kerSubStackSet = set(stackInfo[subStackIndex])

                    # Found same stack  in stack list #
                    if not list(kerStackSet - kerSubStackSet) and \
                        not list(kerSubStackSet - kerStackSet):
                        found = True
                        stackInfo[eventIndex] += eventCnt
                        kstackAddr = id(stackInfo[subStackIndex])
                        break

                # New stack related to this symbol #
                if found == False:
                    tempList = [0] * len(FunctionAnalyzer.symStackIdxTable)
                    tempList[eventIndex] = eventCnt
                    tempList[subStackIndex] = kernelStack
                    tempList[argIndex] = list(subStackPageInfo)
                    kernelTargetStack.append(tempList)

                    kstackAddr = id(kernelStack)

            # Recover PAGE_FREE count to merge with unknownPageFreeCnt #
            if event == 'PAGE_FREE':
                eventCnt = savedEventCnt

            # memory allocation event #
            if event == 'PAGE_ALLOC':
                pageType = arg[0]
                pfn = arg[1]
                atime = arg[2]

                self.handlePageAlloc(
                    sym, ksym, stackAddr, kstackAddr,
                    eventCnt, pageType, pfn, atime)

            # memory free event #
            elif event == 'PAGE_FREE':
                pageType = arg[0]
                pfn = arg[1]
                atime = arg[2]

                self.handlePageFree(
                    sym, ksym, stackAddr, kstackAddr,
                    eventCnt, pageType, pfn, atime)

            # heap expand event #
            elif event == 'HEAP_EXPAND':
                self.handleHeapExpand(
                    sym, ksym, stackAddr, kstackAddr, eventCnt, arg)

            # heap expand event #
            elif event == 'HEAP_REDUCE':
                self.handleHeapReduce(eventCnt, arg)

            # block read event #
            elif event == 'BLK_READ':
                self.userSymData[sym]['blockRdCnt'] += eventCnt
                self.kerSymData[ksym]['blockRdCnt'] += eventCnt

            # block write event #
            elif event == 'BLK_WRITE':
                self.userSymData[sym]['blockWrCnt'] += eventCnt
                self.kerSymData[ksym]['blockWrCnt'] += eventCnt

            # lock try event #
            elif event == 'LOCK_TRY':
                self.userSymData[sym]['lockTryCnt'] += eventCnt
                self.kerSymData[ksym]['lockTryCnt'] += eventCnt
                self.userFileData[path]['lockTryCnt'] += eventCnt

            # unlock event #
            elif event == 'UNLOCK':
                self.userSymData[sym]['unlockCnt'] += eventCnt
                self.kerSymData[ksym]['unlockCnt'] += eventCnt
                self.userFileData[path]['unlockCnt'] += eventCnt

            # periodic event such as CPU tick #
            elif event == 'CPU_TICK':
                self.userSymData[sym]['tickCnt'] += 1
                self.kerSymData[ksym]['tickCnt'] += 1
                self.userFileData[path]['tickCnt'] += 1

            # syscall event #
            elif event == 'SYSCALL':
                self.userSymData[sym]['syscallCnt'] += 1
                self.kerSymData[ksym]['syscallCnt'] += 1
                self.userFileData[path]['syscallCnt'] += 1

            # periodic event such as CPU tick #
            elif event == 'CUSTOM':
                if eventCnt > 0:
                    self.userSymData[sym]['customTotal'] += 1
                    self.kerSymData[ksym]['customTotal'] += 1
                    self.userFileData[path]['customTotal'] += 1

                self.userSymData[sym]['customCnt'] += eventCnt
                self.kerSymData[ksym]['customCnt'] += eventCnt
                self.userFileData[path]['customCnt'] += eventCnt

            # etc event #
            elif event == 'IGNORE':
                try:
                    self.ignoreTable[arg]['ignCnt'] += 1
                except:
                    self.ignoreTable[arg] = {'ignCnt': long(1)}

            else:
                SysMgr.printWarn("fail to recognize event %s" % event)

        UtilMgr.deleteProgress()

        # Print summary about ignored events #
        self.printIgnoreEvents()



    def printIgnoreEvents(self):
        for idx, value in self.ignoreTable.items():
            SysMgr.printWarn(
                "ignore %s event %d times" % (idx, value['ignCnt']))



    def getBinFromServer(self, remoteObj, src, des):
        if not remoteObj or remoteObj == 'NONE':
            SysMgr.printErr(
                "wrong remote address, "
                "input in the format {IP:PORT}")
            sys.exit(0)

        # set download command #
        req = 'DOWNLOAD:%s@%s' % (src, des)

        # get connection with server #
        self.connObj = NetworkMgr.getServerConn()
        if not self.connObj:
            return None

        # request download command #
        NetworkMgr.requestCmd(self.connObj, req)



    def getSymbols(self):
        binPath = ''
        offsetList = []
        curIdx = long(0)
        nrNoFile = long(0)
        lastIdx = len(self.posData)

        # Set alarm handler to handle hanged addr2line #
        signal.signal(signal.SIGALRM, SysMgr.timerHandler)

        # Get symbols and source pos #
        for idx, value in sorted(self.posData.items(),
            key=lambda e: e[1]['binary'], reverse=True):
            curIdx += 1

            UtilMgr.printProgress(curIdx, lastIdx)

            # Handle thumbcode #
            if idx == '00c0ffee':
                value['binary'] = '??'
                value['origBin'] = '??'
                value['symbol'] = 'ThumbCode'
                continue

            # Handle address #
            if value['binary'] == '':
                # user pos without offset #
                if value['symbol'] == '' or value['symbol'] == '??':
                    # toDo: find binary path and symbol of pos #
                    value['binary'] = '??'
                    value['origBin'] = '??'
                    value['symbol'] = idx
                continue

            # Get symbols from address list of previous binary #
            if binPath != value['binary']:
                if binPath != '':
                    # Get symbols #
                    if self.getFileSymbolInfo(binPath, offsetList) == -1:
                        nrNoFile += 1
                    offsetList = []

                if value['offset'] == hex(0):
                    offsetList.append(idx)
                else:
                    offsetList.append(value['offset'])

                # Set new binPath to find symbol from address #
                binPath = value['binary']

                # Get binary from server #
                if not os.path.isfile(binPath) and \
                    SysMgr.remoteServObj:
                    self.getBinFromServer(
                        SysMgr.remoteServObj,
                        value['origBin'], binPath)
            # add address to offsetList #
            else:
                # not relocatable binary #
                if value['offset'] == hex(0):
                    offsetList.append(idx)
                # relocatable binary #
                else:
                    offsetList.append(value['offset'])

        # Get symbols and source path from last binary #
        if binPath != '':
            if self.getFileSymbolInfo(binPath, offsetList) == -1:
                nrNoFile += 1

        UtilMgr.deleteProgress()

        if nrNoFile > 0:
            SysMgr.printWarn(
                "fail to find total %s binaries to analyze functions" % \
                    nrNoFile, True)



    def getFileSymbolInfo(self, binPath, offsetList, onlyFunc=True):
        def _updateSymbol(addr, symbol, src, relocated):
            if not addr:
                return -1
            elif symbol == '??':
                symbol = addr

            # Check whether the file is relocatable or not #
            if not relocated:
                try:
                    savedSymbol = self.posData[addr]['symbol']
                except:
                    return -1

                '''
                Check whether saved symbol found by
                previous addr2line is right #
                '''
                if not savedSymbol or savedSymbol == '' or \
                    savedSymbol == addr or savedSymbol[0] == '$':
                    self.posData[addr]['symbol'] = symbol

                    if SysMgr.showAll:
                        self.posData[addr]['src'] = src
                    else:
                        fileIdx = src.rfind('/')
                        if fileIdx >= 0:
                            self.posData[addr]['src'] = src[fileIdx + 1:]

                return

            inBinArea = False
            for idx, value in sorted(self.posData.items(),
                key=lambda e: e[1]['binary'], reverse=True):
                if value['binary'] == binPath:
                    inBinArea = True

                    if value['offset'] == addr:
                        savedSymbol = self.posData[idx]['symbol']

                        if not savedSymbol or \
                            savedSymbol == '' or \
                            savedSymbol == addr or \
                            savedSymbol[0] == '$':
                            self.posData[idx]['symbol'] = symbol

                            if SysMgr.showAll:
                                self.posData[idx]['src'] = src
                            else:
                                fileIdx = src.rfind('/')
                                if fileIdx >= 0:
                                    self.posData[idx]['src'] = \
                                        src[fileIdx + 1:]

                            break
                elif inBinArea:
                    break

        # Recognize binary type #
        relocated = ElfAnalyzer.isRelocFile(binPath)

        # No file exist #
        if not os.path.isfile(binPath):
            for addr in offsetList:
                try:
                    if not relocated:
                        self.posData[addr]['symbol'] = 'NoFile'
                        self.posData[addr]['src'] = 'NoFile'
                    else:
                        for idx, value in sorted(self.posData.items(),
                            key=lambda e: e[1]['binary'], reverse=True):
                            if value['binary'] == binPath and \
                                value['offset'] == hex(long(addr, 16)):
                                self.posData[idx]['symbol'] = 'NoFile'
                                self.posData[idx]['src'] = 'NoFile'
                                break
                except SystemExit:
                    sys.exit(0)
                except:
                    SysMgr.printWarn(
                        "fail to find address %s" % addr)
            return -1

        # check user-mode enabled #
        if not SysMgr.userEnable:
            return None

        # check addr2line path #
        if not 'ADDR2LINE' in SysMgr.environList:
            try:
                symbolList = list()
                binObj = ElfAnalyzer.getObject(binPath)
                if not binObj:
                    return None

                for offset in offsetList:
                    symbol, size = binObj.getSymbolByOffset(
                        offset, onlyFunc=onlyFunc)

                    symbolList.append('??')

                    _updateSymbol(offset, symbol, '??', relocated)
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printErr(
                    "fail to get symbol from %s" % binPath, True)

            return None

            # get system addr2line path #
            addr2linePath = UtilMgr.which('addr2line')

            if not addr2linePath:
                SysMgr.printErr((
                    "fail to find addr2line to analyze user-level functions, "
                    "use -q option with ADDR2LINE to set binary path"))
                sys.exit(0)

            SysMgr.printInfo(
                "use %s as addr2line path" % ', '.join(addr2linePath))
        else:
            for path in SysMgr.environList['ADDR2LINE']:
                if not os.path.isfile(path):
                    SysMgr.printErr(
                        "fail to find %s to use addr2line" % path)
                    sys.exit(0)

        # get subprocess object #
        subprocess = SysMgr.getPkg('subprocess')
        if not subprocess:
            sys.exit(0)

        for path in SysMgr.environList['ADDR2LINE']:
            # Set addr2line command #
            args = [path, "-C", "-f", "-a", "-e", binPath]

            # Limit the number of arguments to be passed because of ARG_MAX #
            # ARG_MAX = $(getconf PAGE_SIZE)*32 = 131072 #
            listLen = len(offsetList)
            maxArgLine = 256
            offset = long(0)
            timeout = 10

            # Get symbol by address of every maxArgLine elements in list #
            while offset < listLen:
                # Launch addr2line #
                try:
                    workload = offsetList[offset:offset+maxArgLine-1]
                    proc = subprocess.Popen(args + workload,
                        stdout=subprocess.PIPE, stderr=subprocess.PIPE)
                except SystemExit:
                    sys.exit(0)
                except:
                    SysMgr.printErr(
                        "fail to execute %s to pick symbols from binary" % \
                            path)
                    sys.exit(0)

                # Increase offset count in address list #
                offset += maxArgLine

                try:
                    # Set alarm to handle hanged addr2line #
                    signal.alarm(timeout)

                    # Wait for addr2line to finish its job #
                    proc.wait()

                    # Cancel alarm after addr2line respond #
                    signal.alarm(0)
                except SystemExit:
                    sys.exit(0)
                except:
                    SysMgr.printWarn(
                        'no response of addr2line for %s' % binPath)
                    continue

                while 1:
                    # Get return of addr2line #
                    addr = proc.stdout.readline().decode().replace('\n', '')[2:]
                    try:
                        addr = hex(long(addr, 16)).rstrip('L')
                    except SystemExit:
                        sys.exit(0)
                    except:
                        pass

                    symbol = proc.stdout.readline().decode().replace('\n', '')
                    src = proc.stdout.readline().decode().replace('\n', '')

                    err = proc.stderr.readline().decode().replace('\n', '')
                    if len(err) > 0:
                        SysMgr.printWarn(err[err.find(':') + 2:])

                    if _updateSymbol(addr, symbol, src, relocated):
                        break



    def initStacks(self):
        self.nowCtx['userLastPos'] = '0'
        self.nowCtx['userStack'] = []
        self.nowCtx['kerLastPos'] = '0'
        self.nowCtx['kerStack'] = []



    def swapEvents(self):
        tempEvent = self.nowCtx['nowEvent']
        self.nowCtx['nowEvent'] = self.nowCtx['savedEvent']
        self.nowCtx['savedEvent'] = tempEvent

        tempCnt = self.nowCtx['nowCnt']
        self.nowCtx['nowCnt'] = self.nowCtx['savedCnt']
        self.nowCtx['savedCnt'] = tempCnt

        tempArg = self.nowCtx['nowArg']
        self.nowCtx['nowArg'] = self.nowCtx['savedArg']
        self.nowCtx['savedArg'] = tempArg



    def saveFullStack(
        self, kernelPos, kernelStack, userPos, userStack,
        targetEvent, targetCnt, targetArg):

        # Save userstack #
        self.userCallData.append(
            [userPos, userStack, targetEvent, targetCnt, targetArg])

        # Save kernelstack #
        self.kernelCallData.append(
            [kernelPos, kernelStack, targetEvent, targetCnt, targetArg])

        # Save custom event stacks #
        if SysMgr.showAll and targetEvent == 'CUSTOM':
            self.customCallData.append(
                [targetArg[0], targetArg[1],
                self.userCallData[-1], self.kernelCallData[-1]])

        # Save lock event stacks #
        if SysMgr.showAll and \
            (targetEvent == 'LOCK_TRY' or targetEvent == 'UNLOCK'):
            self.lockCallData.append(
                [targetArg[0], targetArg[1:],
                self.userCallData[-1], self.kernelCallData[-1]])

        # Save syscall event stacks #
        if SysMgr.showAll and targetEvent == 'SYSCALL':
            self.sysCallData.append(
                [targetArg[0], targetArg[1:],
                self.userCallData[-1], self.kernelCallData[-1]])



    def saveEventStack(self, targetEvent, targetCnt, targetArg):
        kpos = self.nowCtx['kerLastPos']
        upos = self.nowCtx['userLastPos']

        # save count data #
        if targetEvent == 'CPU_TICK':
            self.periodicEventCnt += 1

        elif targetEvent == 'PAGE_ALLOC':
            self.pageAllocEventCnt += 1
            self.pageAllocCnt += targetCnt
            self.pageUsageCnt += targetCnt
            self.posData[kpos]['pageCnt'] += targetCnt
            self.posData[upos]['pageCnt'] += targetCnt

            pageType = targetArg[0]
            pfn = targetArg[1]
            time = targetArg[2]
            targetArg = [pageType, pfn, time]

        elif targetEvent == 'PAGE_FREE':
            self.pageFreeEventCnt += 1
            self.pageFreeCnt += targetCnt

            pageType = targetArg[0]
            pfn = targetArg[1]
            time = targetArg[2]
            targetArg = [pageType, pfn, time]

        elif targetEvent == 'BLK_READ':
            self.blockRdEventCnt += 1
            self.blockRdUsageCnt += targetCnt
            self.posData[kpos]['blockRdCnt'] += targetCnt
            self.posData[upos]['blockRdCnt'] += targetCnt

        elif targetEvent == 'BLK_WRITE':
            self.blockWrEventCnt += 1
            self.blockWrUsageCnt += targetCnt
            self.posData[kpos]['blockWrCnt'] += targetCnt
            self.posData[upos]['blockWrCnt'] += targetCnt

        elif targetEvent == 'LOCK_TRY':
            self.lockTryEventCnt += 1
            self.posData[kpos]['lockTryCnt'] += targetCnt
            self.posData[upos]['lockTryCnt'] += targetCnt

        elif targetEvent == 'UNLOCK':
            self.unlockEventCnt += 1
            self.posData[kpos]['unlockCnt'] += targetCnt
            self.posData[upos]['unlockCnt'] += targetCnt

        elif targetEvent == 'HEAP_EXPAND':
            self.heapExpEventCnt += 1
            self.heapExpSize += targetCnt
            self.posData[kpos]['heapSize'] += targetCnt
            self.posData[upos]['heapSize'] += targetCnt

        elif targetEvent == 'HEAP_REDUCE':
            self.posData[kpos]['heapSize'] += targetCnt
            self.posData[upos]['heapSize'] += targetCnt

        elif targetEvent == 'SYSCALL':
            nrSyscall = targetArg[0]
            self.syscallCnt += 1

            try:
                self.syscallTable[nrSyscall] += 0
            except:
                self.syscallTable[nrSyscall] = 1

            self.posData[kpos]['syscallCnt'] += targetCnt
            self.posData[upos]['syscallCnt'] += targetCnt

        elif targetEvent == 'CUSTOM':
            if targetCnt > 0:
                self.customTotal += 1
                self.customCnt += targetCnt

                self.posData[kpos]['customTotal'] += 1
                self.posData[upos]['customTotal'] += 1

                self.posData[kpos]['customCnt'] += targetCnt
                self.posData[upos]['customCnt'] += targetCnt

        else:
            pass

        # cut stacks by depth #
        if SysMgr.funcDepth > 0:
            ksize = len(self.nowCtx['kerStack'])
            if ksize >= SysMgr.funcDepth:
                self.nowCtx['kerLastPos'] = \
                    self.nowCtx['kerStack'][-SysMgr.funcDepth]
                self.nowCtx['kerStack'] = \
                    self.nowCtx['kerStack'][-SysMgr.funcDepth + 1:]

            usize = len(self.nowCtx['userStack'])
            if usize >= SysMgr.funcDepth:
                self.nowCtx['userLastPos'] = \
                    self.nowCtx['userStack'][-SysMgr.funcDepth]
                self.nowCtx['userStack'] = \
                    self.nowCtx['userStack'][-SysMgr.funcDepth + 1:]

            if SysMgr.funcDepth == 1:
                self.nowCtx['kerStack'] = []
                self.nowCtx['userStack'] = []

        try:
            # save both stacks #
            self.saveFullStack(
                self.nowCtx['kerLastPos'], self.nowCtx['kerStack'],
                self.nowCtx['userLastPos'], self.nowCtx['userStack'],
                targetEvent, targetCnt, targetArg)
        except:
            SysMgr.printErr(
                "fail to save full stacks", True)
            sys.exit(0)



    def saveCallStack(self):
        nowCtx = self.nowCtx

        # stack of kernel thread #
        if not SysMgr.userRecordEnable or \
            nowCtx['prevMode'] != nowCtx['curMode'] == 'kernel':
            if not nowCtx['userStack'] and \
                len(nowCtx['kerStack']) > 0:
                    # Set userLastPos to None #
                self.nowCtx['userLastPos'] = '0'
                self.nowCtx['userStack'].append('0')
            if not nowCtx['kerStack'] and \
                len(nowCtx['userStack']) > 0:
                # Set kerLastPos to None #
                self.nowCtx['kerLastPos'] = '0'
                self.nowCtx['kerStack'].append('0')

        # complicated situation ;( #
        elif nowCtx['prevMode'] == nowCtx['curMode']:
            # previous user stack loss or nested interval #
            if nowCtx['curMode'] == 'kernel':
                # nested interval #
                if nowCtx['nowEvent'] == 'CPU_TICK':
                    # Backup kernel stack #
                    self.nowCtx['prevKerLastPos'] = nowCtx['kerLastPos']
                    self.nowCtx['prevKerStack'] = nowCtx['kerStack']

                    # Initialize both stacks #
                    self.initStacks()
                # previous user stack loss #
                else:
                    # Set userLastPos to None #
                    self.nowCtx['userLastPos'] = '0'
                    self.nowCtx['userStack'].append('0')
            # nested interval #
            elif nowCtx['curMode'] == 'user':
                '''
                CORE/0 EVENT0
                CORE/0 <kernel>
                CORE/0 <user>

                CORE/0 EVENT1
                CORE/0 <kernel>
                    CORE/0 EVENT2
                    CORE/0 <kernel>
                    CORE/0 <user>
                CORE/0 <user>
                '''
                # Swap nowEvent and savedEvent #
                self.swapEvents()

        '''
        Save both stacks of previous event before
        starting to record new kernel stack #
        '''
        if (len(nowCtx['userStack']) > 0 and \
            nowCtx['userLastPos'] != '') and \
            (len(nowCtx['kerStack']) > 0 and \
            nowCtx['kerLastPos'] != ''):
                # Remove pc in each stacks #
            del self.nowCtx['kerStack'][0], self.nowCtx['userStack'][0]

            # Check whether there is nested event or not #
            if nowCtx['nested'] > 0:
                '''
                CORE/0 EVENT0
                CORE/0 <kernel>
                CORE/0 <user>

                CORE/0 EVENT1
                    CORE/0 EVENT2
                    CORE/0 <kernel>
                    CORE/0 <user>
                CORE/0 <kernel>
                CORE/0 <user>
                '''
                targetEvent = nowCtx['nestedEvent']
                targetCnt = nowCtx['nestedCnt']
                targetArg = nowCtx['nestedArg']

                # Swap nowEvent and savedEvent #
                self.swapEvents()
            else:
                targetEvent = nowCtx['savedEvent']
                targetCnt = nowCtx['savedCnt']
                targetArg = nowCtx['savedArg']

            # Save full stack of previous event #
            self.saveEventStack(
                targetEvent, targetCnt, targetArg)

            # Recover previous kernel stack after handling nested event #
            if nowCtx['prevMode'] == nowCtx['curMode'] == 'user' and \
                nowCtx['prevKerLastPos'] != '0':
                self.nowCtx['kerLastPos'] = nowCtx['prevKerLastPos']
                self.nowCtx['kerStack'] = nowCtx['prevKerStack']
                self.nowCtx['prevKerLastPos'] = '0'
                self.nowCtx['prevKerStack'] = []
            else:
                self.nowCtx['kerLastPos'] = ''
                self.nowCtx['kerStack'] = []

            # Initialize user stack #
            self.nowCtx['userLastPos'] = ''
            self.nowCtx['userStack'] = []
            self.nowCtx['nestedEvent'] = ''
            self.nowCtx['nestedCnt'] = long(0)

        # On stack recording switch #
        self.nowCtx['recStat'] = True



    def savePosData(self, pos, path, offset):
        if self.nowCtx['nested'] > 0:
            targetEvent = self.nowCtx['savedEvent']
        else:
            targetEvent = self.nowCtx['nowEvent']

        # Register pos #
        try:
            self.posData[pos]
            if path and path[0] == '/' and \
                path != self.posData[pos]['origBin']:
                self.duplicatedPos += 1
                '''
                SysMgr.printWarn(
                    "duplicated address %s in both '%s' and '%s'" % \
                    (pos, path, self.posData[pos]['origBin']))
                '''
        except:
            self.posData[pos] = dict(self.init_posData)

        # user mode #
        if self.nowCtx['curMode'] == 'user':
            # Set path #
            if path:
                self.posData[pos]['origBin'] = path
                self.posData[pos]['binary'] = \
                    SysMgr.rootPath + path
                self.posData[pos]['binary'] = \
                    os.path.normpath(self.posData[pos]['binary'])

                # Set offset #
                if offset:
                    if ElfAnalyzer.isRelocFile(path):
                        self.posData[pos]['offset'] = offset

            # Save pos #
            if not self.nowCtx['userStack']:
                self.nowCtx['userLastPos'] = pos

                if targetEvent == 'CPU_TICK':
                    self.posData[pos]['posCnt'] += 1
                elif targetEvent == 'LOCK_TRY':
                    self.posData[pos]['lockTryCnt'] += 1
                elif targetEvent == 'UNLOCK':
                    self.posData[pos]['unlockCnt'] += 1

            self.nowCtx['userStack'].append(pos)
        # kernel mode #
        elif self.nowCtx['curMode'] == 'kernel':
            # Save pos #
            if not self.nowCtx['kerStack']:
                self.nowCtx['kerLastPos'] = pos

                if targetEvent == 'CPU_TICK':
                    self.posData[pos]['posCnt'] += 1
                elif targetEvent == 'LOCK_TRY':
                    self.posData[pos]['lockTryCnt'] += 1
                elif targetEvent == 'UNLOCK':
                    self.posData[pos]['unlockCnt'] += 1

            # Skip pos because it is usercall or no symbol #
            elif not SysMgr.showAll and not path:
                return

            self.posData[pos]['symbol'] = path

            self.nowCtx['kerStack'].append(pos)

        # wrong mode #
        else:
            SysMgr.printWarn(
                'wrong current mode %s' % self.nowCtx['curMode'])

        # Increase total call count #
        if self.nowEvent == 'CPU_TICK':
            self.posData[pos]['totalCnt'] += 1



    def allocHeapSeg(self, tid, size):
        try:
            self.heapTable[tid + '-ready']['size'] = size
            self.heapTable[tid + '-ready']['tid'] = tid
            self.threadData[tid]['heapSize'] -= size
            SysMgr.printWarn(
                'overwrite heap segment of %s(%s) at %s' % \
                    (self.threadData[tid]['comm'], tid,
                    SysMgr.dbgEventLine))
        except:
            self.heapTable[tid + '-ready'] = dict(self.init_heapSegData)
            self.heapTable[tid + '-ready']['size'] = size
            self.heapTable[tid + '-ready']['tid'] = tid



    def freeHeapSeg(self, addr):
        try:
            self.heapRedEventCnt += 1
            self.heapRedSize += self.heapTable[addr]['size']

            # get tid #
            try:
                tid = self.heapTable[addr]['tid']
            except:
                return

            self.threadData[tid]['heapSize'] -= \
                self.heapTable[addr]['size']

            self.heapTable.pop(addr, None)
        except:
            SysMgr.printWarn(
                'fail to free heap segment %s of %s(%s) at %s' % \
                    (addr, self.threadData[tid]['comm'], tid,
                    SysMgr.dbgEventLine))



    def setHeapSegAddr(self, tid, addr):
        try:
            self.heapTable[addr] = dict(self.heapTable['%s-ready' % tid])
            del self.heapTable['%s-ready' % tid]
        except:
            SysMgr.printWarn(
                'fail to set address of heap segment %s of %s(%s) at %s' % \
                    (addr, self.threadData[tid]['comm'], tid,
                    SysMgr.dbgEventLine))



    def parseLogs(self, lines, desc):
        curIdx = long(0)
        lastIdx = len(lines)

        # make custom event table #
        if SysMgr.customCmd:
            for cmd in SysMgr.customCmd:
                cmd = cmd.split(':')

                if len(cmd) > 1:
                    self.customEventTable[cmd[0]] = cmd[1]
                else:
                    self.customEventTable[cmd[0]] = None

        # make kernel event table #
        if SysMgr.kernelCmd:
            for cmd in SysMgr.kernelCmd:
                cmd = cmd.split(':')
                self.customEventTable[cmd[0]+'_enter'] = None
                self.customEventTable[cmd[0]+'_exit'] = None

        # make user event table #
        if SysMgr.userCmd:
            for cmd in SysMgr.userCmd:
                cmd = cmd.split(':')
                self.customEventTable[cmd[0]+'_enter'] = None
                self.customEventTable[cmd[0]+'_exit'] = None

        # get pid filter by comm in advance #
        plist = {}
        if SysMgr.groupProcEnable:
            for key, value in self.getTargetList(lines).items():
                for item in desc:
                    if item in value['comm']:
                        plist[value['tgid']] = long(0)

        # start parsing logs #
        for liter in lines:
            curIdx += 1
            SysMgr.logSize += len(liter)
            SysMgr.curLine += 1
            SysMgr.dbgEventLine += 1

            ret = self.parseEventLog(liter, desc, plist)
            UtilMgr.printProgress(curIdx, lastIdx)

            # Skip lines before first meaningful event #
            if not self.lastCore:
                continue

            # Set context of current core #
            self.nowCtx = self.coreCtx[self.lastCore]

            # Save full stack to callData table #
            if ret is True:
                self.saveCallStack()
            elif ret is False:
                '''
                Ignore this log because its not event or
                stack info related to target thread #
                '''
                self.nowCtx['recStat'] = False
                continue
            # Save pos into target stack #
            elif self.nowCtx['recStat']:
                # decode return value #
                (pos, path, offset) = ret

                self.savePosData(pos, path, offset)

        # update finish time #
        if self.finishTime == '0':
            self.finishTime = self.lastTime

        UtilMgr.deleteProgress()

        # Save stack of last events per core #
        for idx in list(self.coreCtx.keys()):
            self.lastCore = idx
            self.nowCtx = self.coreCtx[idx]

            # Recover previous mode #
            if SysMgr.userEnable:
                self.nowCtx['prevMode'] = 'user'
            self.nowCtx['curMode'] = 'kernel'

            self.saveEventParam('IGNORE', 0, 0)
            self.nowCtx['nested'] -= 1
            self.saveCallStack()

        if self.duplicatedPos > 0:
            SysMgr.printWarn(
                "found %d addresses duplicated" % self.duplicatedPos)



    def getCustomEventValue(self, func, args, cond):
        if not cond:
            return 1

        # set condition #
        if '>' in cond:
            condVal = cond[cond.find('>') + 1:]
            condOp = '>'
            condStr = cond[:cond.find('>')]
        elif '<' in cond:
            condVal = cond[cond.find('<') + 1:]
            condOp = '<'
            condStr = cond[:cond.find('<')]
        elif '==' in cond:
            condVal = cond[cond.find('==') + 2:]
            condOp = '=='
            condStr = cond[:cond.find('==')]
        else:
            condStr = cond
            condOp = None
            condVal = None

        m = re.match(r'^.+%s=(?P<value>\S+)' % condStr, args)
        if not m:
            return 0

        d = m.groupdict()

        value = d['value']

        if not condOp and value:
            try:
                return long(value)
            except:
                return 0
        elif condOp == '>':
            try:
                if long(value) > long(condVal):
                    return long(value)
            except:
                pass

            return 0
        elif condOp == '<':
            try:
                if long(value) < long(condVal):
                    return long(value)
            except:
                pass

            return 0
        elif condOp == '==':
            if value == condVal:
                return 1
            else:
                return 0
        else:
            return 0



    def saveEventParam(self, event, count, arg):
        # save context #
        self.nowCtx['nestedEvent'] = self.nowCtx['savedEvent']
        self.nowCtx['savedEvent'] = self.nowCtx['nowEvent']
        self.nowCtx['nowEvent'] = event

        self.nowCtx['nestedCnt'] = self.nowCtx['savedCnt']
        self.nowCtx['savedCnt'] = self.nowCtx['nowCnt']
        self.nowCtx['nowCnt'] = count

        self.nowCtx['nestedArg'] = self.nowCtx['savedArg']
        self.nowCtx['savedArg'] = self.nowCtx['nowArg']
        self.nowCtx['nowArg'] = arg

        self.nowCtx['nested'] += 1

        if self.nowCtx['nested'] > 2:
            #self.printDbgInfo()
            SysMgr.printWarn((
                "fail to analyze stack data "\
                "because of corruption (overflow) at %s line\n"\
                "\tso report results may differ from actual") % \
                SysMgr.dbgEventLine, True)



    def printDbgInfo(self):
        data = self.nowCtx

        print('[%s]' % self.lastCore,
            '(now) %s/%s/%s' % \
                (data['nowEvent'], data['nowCnt'], data['nowArg']),
            '(saved) %s/%s/%s' % \
                (data['savedEvent'], data['savedCnt'], data['savedArg']),
            '(nested) %s/%s/%s' % \
                (data['nestedEvent'], data['nestedCnt'], data['nestedArg']),
            '(user) %s/%s' % \
                (data['userLastPos'], len(data['userStack'])),
            '(kernel) %s/%s' % \
                (data['kerLastPos'], len(data['kerStack'])),
            '(backup) %s/%s' % \
                (data['prevKerLastPos'], len(data['prevKerStack'])),
            'at %s' % SysMgr.dbgEventLine)



    def parseEventInfo(self, tid, func, args, time, core):
        # check core filter #
        if SysMgr.perCoreList and \
            long(core) not in SysMgr.perCoreList and \
            func[0] != '<':
            self.saveEventParam('IGNORE', 0, func[:-1])
            return False

        # check fixed event list #
        if len(self.customEventTable) > 0 and \
            (func[:-1] in self.customEventTable or \
            len([event for event in self.customEventTable \
                if event.endswith(func[:-1])]) > 0):
            isFixedEvent = False
        else:
            isFixedEvent = True

        # CPU tick event #
        # toDo: find shorter periodic event for sampling #
        if isFixedEvent and func == "hrtimer_start:":
            if 'tick_sched_timer' in args:
                self.cpuEnabled = True

                self.saveEventParam('CPU_TICK', 1, 0)
            else:
                self.saveEventParam('IGNORE', 0, func[:-1])

            return False

        # memory allocation event #
        elif isFixedEvent and func == "mm_page_alloc:":
            m = re.match((
                r'^\s*page=\s*(?P<page>\S+)\s+pfn=(?P<pfn>[0-9]+)\s+'
                r'order=(?P<order>[0-9]+)\s+migratetype=(?P<mt>[0-9]+)\s+'
                r'gfp_flags=(?P<flags>\S+)'), args)
            if m:
                d = m.groupdict()

                # check whether it is huge page #
                if d['page'] == '(null)':
                    page = 'huge'
                else:
                    page = d['page']

                pfn = long(d['pfn'])
                flags = d['flags']
                pageCnt = pow(2, long(d['order']))

                # Increase page count of thread #
                self.threadData[tid]['nrPages'] += pageCnt

                # Increase page counts of thread #
                pageType = None
                if 'NOFS' in flags or \
                    'GFP_WRITE' in flags or \
                    '0x1000000' in flags:
                    pageType = 'CACHE'
                    self.threadData[tid]['cachePages'] += pageCnt
                elif 'USER' in flags:
                    pageType = 'USER'
                    self.threadData[tid]['userPages'] += pageCnt
                else:
                    pageType = 'KERNEL'
                    self.threadData[tid]['kernelPages'] += pageCnt

                # Make PTE in page table #
                for cnt in range(0, pageCnt):
                    pfnv = pfn + cnt

                    try:
                        '''
                        Decrease page count of it's owner \
                        because this page was already allocated but no free log
                        '''

                        ownerTid = self.pageTable[pfnv]['tid']
                        self.threadData[ownerTid]['nrPages'] -= 1

                        origPageType = self.pageTable[pfnv]['type']
                        if origPageType == 'USER':
                            self.threadData[ownerTid]['userPages'] -= 1
                        elif origPageType == 'CACHE':
                            self.threadData[ownerTid]['cachePages'] -= 1
                        elif origPageType == 'KERNEL':
                            self.threadData[ownerTid]['kernelPages'] -= 1
                    except:
                        self.pageTable[pfnv] = dict(self.init_pageData)

                    self.pageTable[pfnv]['tid'] = tid
                    self.pageTable[pfnv]['page'] = page
                    self.pageTable[pfnv]['flags'] = flags
                    self.pageTable[pfnv]['type'] = pageType
                    self.pageTable[pfnv]['time'] = time

                self.memEnabled = True

                self.saveEventParam(
                    'PAGE_ALLOC', pageCnt, [pageType, pfn, time])
            else:
                self.saveEventParam('IGNORE', 0, func[:-1])

                SysMgr.printWarn(
                    "fail to recognize event %s at %d" % \
                    (func[:-1], SysMgr.dbgEventLine))

            return False

        # memory free event #
        elif isFixedEvent and \
            (func == "mm_page_free:" or func == "mm_page_free_direct:"):
            m = re.match((r'^\s*page=(?P<page>\S+)\s+pfn=(?P<pfn>[0-9]+)\s+'
                          r'order=(?P<order>[0-9]+)'), args)
            if m:
                d = m.groupdict()

                page = d['page']
                pfn = long(d['pfn'])
                pageCnt = pow(2, long(d['order']))

                # Update page table #
                origPageType = None
                for cnt in range(0, pageCnt):
                    pfnv = pfn + cnt

                    try:
                        owner = self.pageTable[pfnv]['tid']
                        origPageType = self.pageTable[pfnv]['type']

                        self.threadData[owner]['nrPages'] -= 1

                        if origPageType == 'CACHE':
                            self.threadData[owner]['cachePages'] -= 1
                        elif origPageType == 'USER':
                            self.threadData[owner]['userPages'] -= 1
                        elif origPageType == 'KERNEL':
                            self.threadData[owner]['kernelPages'] -= 1

                        self.threadData[tid]['nrKnownFreePages'] += 1

                        self.pageTable.pop(pfnv)
                    except:
                        # this page was allocated before starting profile #

                        self.threadData[tid]['nrUnknownFreePages'] += 1
                        continue

                self.memEnabled = True

                self.saveEventParam(
                    'PAGE_FREE', pageCnt, [origPageType, pfn, time])

                return False

            SysMgr.printWarn("fail to recognize event %s at %d" % \
                (func[:-1], SysMgr.dbgEventLine))

            self.saveEventParam('IGNORE', 0, func[:-1])

            return False

        # syscall / heap / lock events #
        elif isFixedEvent and func == "sys_enter:":
            m = re.match(r'^\s*NR (?P<nr>[0-9]+) (?P<args>.+)', args)
            if m:
                b = m.groupdict()

                nr = b['nr']

                self.threadData[tid]['lastNrSyscall'] = long(nr)

                # syscall event #
                if SysMgr.sysEnable:
                    self.sysEnabled = True

                    nrSyscall = long(b['nr'])
                    syscallList = SysMgr.syscallList

                    if not syscallList or nrSyscall in syscallList:
                        args = b['args'][1:-1]

                        self.threadData[tid]['nrSyscall'] += 1

                        # set syscall table #
                        if not self.threadData[tid]['syscallTable']:
                            self.threadData[tid]['syscallTable'] = {}

                        try:
                            self.threadData[tid]['syscallTable'][nrSyscall] += 1
                        except:
                            self.threadData[tid]['syscallTable'][nrSyscall] = 1

                        self.saveEventParam(
                            'SYSCALL', 1, [nrSyscall, args, time, core, tid])

                        return False

                # heap increasement event #
                elif long(b['nr']) == ConfigMgr.getMmapId():
                    self.heapEnabled = True

                    try:
                        size = long(b['args'].split(',')[1], 16)

                        # just brk call to check data segment address #
                        if size == 0:
                            pass

                        self.threadData[tid]['heapSize'] += size
                    except:
                        self.saveEventParam('IGNORE', 0, func[:-1])

                        return False

                    # make heap segment tid-ready #
                    self.allocHeapSeg(tid, size)

                    self.saveEventParam('IGNORE', 0, func[:-1])

                    return False

                # heap decreasement event #
                elif long(b['nr']) == ConfigMgr.sysList.index('sys_munmap'):
                    self.heapEnabled = True

                    try:
                        addr = long(b['args'][1:].split(',')[0], 16)
                        size = self.heapTable[addr]['size']

                        # remove heap segment #
                        self.freeHeapSeg(addr)

                        self.saveEventParam(
                            'HEAP_REDUCE', size, [addr, time, core, tid])

                        return False
                    except:
                        pass

                # lock event #
                elif long(b['nr']) == ConfigMgr.sysList.index('sys_futex'):
                    n = re.match((
                        r'^\s*(?P<uaddr>\S+), (?P<op>\S+), '
                        r'(?P<val>\S+), (?P<timer>\S+),'), b['args'])
                    if n:
                        l = n.groupdict()

                        FUTEX_CMD_MASK = ~(128|256)
                        # FUTEX_PRIVATE_FLAG: 128, FUTEX_CLOCK_REALTIME: 256 #
                        maskedOp = long(l['op'], base=16) & FUTEX_CMD_MASK

                        addr = l['uaddr'][1:]
                        flist = ConfigMgr.FUTEX_TYPE
                        try:
                            event = flist[maskedOp]
                        except:
                            event = 'LOCK'

                        # try to lock #
                        if maskedOp == flist.index("FUTEX_LOCK_PI") or \
                            maskedOp == flist.index("FUTEX_TRYLOCK_PI"):
                            self.lockEnabled = True

                            self.threadData[tid]['nrLockTry'] += 1

                            self.saveEventParam(
                                'LOCK_TRY', 1, [event, addr, time, core, tid])

                            return False
                        # wait #
                        elif maskedOp == flist.index("FUTEX_WAIT") or \
                            maskedOp == flist.index("FUTEX_WAIT_REQUEUE_PI") or \
                            maskedOp == flist.index("FUTEX_WAIT_BITSET"):
                            self.lockEnabled = True

                            self.threadData[tid]['nrLockTry'] += 1

                            self.saveEventParam(
                                'LOCK_TRY', 1, [event, addr, time, core, tid])

                            return False
                        # try to unlock #
                        elif maskedOp == flist.index("FUTEX_UNLOCK_PI"):
                            self.lockEnabled = True

                            self.threadData[tid]['nrUnlock'] += 1

                            self.saveEventParam(
                                'UNLOCK', 1, [event, addr, time, core, tid])

                            return False

            else:
                SysMgr.printWarn(
                    "fail to recognize event %s at %d" % \
                    (func[:-1], SysMgr.dbgEventLine))

            self.saveEventParam('IGNORE', 0, func[:-1])

            return False

        # syscall / heap events #
        elif isFixedEvent and func == "sys_exit:":
            m = re.match(r'^\s*NR (?P<nr>\S+) = (?P<ret>.+)', args)
            if m:
                b = m.groupdict()

                nr = long(b['nr'])

                # handle wrong syscall number #
                if nr < 0:
                    if self.threadData[tid]['lastNrSyscall'] >= 0:
                        nr = self.threadData[tid]['lastNrSyscall']

                # heap increasement event #
                if nr == ConfigMgr.getMmapId():
                    self.heapEnabled = True

                    addr = long(b['ret'])

                    # rename heap segment from tid-ready to addr #
                    self.setHeapSegAddr(tid, addr)

                    try:
                        size = self.heapTable[addr]['size']

                        self.saveEventParam(
                            'HEAP_EXPAND', size, [addr, time, core, tid])

                        return False
                    except:
                        pass

                # heap decreasement event #
                elif nr == ConfigMgr.sysList.index('sys_brk'):
                    self.heapEnabled = True

                    addr = long(b['ret'])

                    try:
                        pid = self.threadData[tid]['tgid']
                        if pid.startswith('-'):
                            pid = SysMgr.savedProcTree[tid]
                        self.threadData[pid]
                    except:
                        pid = tid

                    try:
                        self.threadData[pid]['lastBrk']

                        if addr > self.threadData[pid]['lastBrk']:
                            size = addr - self.threadData[pid]['lastBrk']

                            self.threadData[pid]['heapSize'] += size

                            self.saveEventParam(
                                'HEAP_EXPAND', size, [addr, time, core, tid])

                            return False
                    except:
                        self.threadData[pid]['lastBrk'] = addr
            else:
                SysMgr.printWarn(
                    "fail to recognize event %s at %d" % \
                    (func[:-1], SysMgr.dbgEventLine))

            self.saveEventParam('IGNORE', 0, func[:-1])

            return False

        # block request event #
        elif isFixedEvent and func == "block_bio_queue:":
            m = re.match((
                r'^\s*(?P<major>[0-9]+),(?P<minor>[0-9]+)\s*(?P<operation>\S+)\s*'
                r'(?P<address>\S+)\s+\+\s+(?P<size>[0-9]+)'), args)
            if m:
                b = m.groupdict()

                opt = b['operation']

                if opt[0] == 'R':
                    self.breadEnabled = True

                    blockRdCnt = long(b['size'])
                    self.threadData[tid]['nrRdBlocks'] += blockRdCnt

                    self.saveEventParam('BLK_READ', blockRdCnt, 0)

                    return False
                elif opt == 'WS':
                    self.bwriteEnabled = True

                    blockWrCnt = long(b['size'])
                    self.threadData[tid]['nrWrBlocks'] += blockWrCnt

                    self.saveEventParam('BLK_WRITE', blockWrCnt, 0)

                    return False

            SysMgr.printWarn("fail to recognize event %s at %d" % \
                    (func[:-1], SysMgr.dbgEventLine))

            self.saveEventParam('IGNORE', 0, func[:-1])

            return False

        # block write request event #
        elif isFixedEvent and func == "writeback_dirty_page:":
            m = re.match((r'^\s*bdi\s+(?P<major>[0-9]+):(?P<minor>[0-9]+):\s*'
                r'ino=(?P<ino>\S+)\s+index=(?P<index>\S+)'), args)
            if m:
                b = m.groupdict()
                self.bwriteEnabled = True

                self.threadData[tid]['nrWrBlocks'] += 8

                self.saveEventParam('BLK_WRITE', 8, 0)

                return False

            self.saveEventParam('IGNORE', 0, func[:-1])

            return False

        # block write request event #
        elif isFixedEvent and func == "wbc_writepage:":
            m = re.match((r'^\s*bdi\s+(?P<major>[0-9]+):(?P<minor>[0-9]+):\s*'
                          r'towrt=(?P<towrt>\S+)\s+skip=(?P<skip>\S+)'), args)
            if m:
                d = m.groupdict()

                if d['skip'] == '0':
                    self.bwriteEnabled = True

                    self.threadData[tid]['nrWrBlocks'] += 8

                    self.saveEventParam('BLK_WRITE', 8, 0)

                    return False

            self.saveEventParam('IGNORE', 0, func[:-1])

            return False

        # segmentation fault generation event #
        elif isFixedEvent and func == "signal_generate:":
            m = re.match((r'^\s*sig=(?P<sig>[0-9]+) errno=(?P<err>[0-9]+) '
                          r'code=(?P<code>.*) comm=(?P<comm>.*) '
                          r'pid=(?P<pid>[0-9]+)'), args)
            if m:
                b = m.groupdict()

                if b['sig'] == str(signal.SIGSEGV):
                    self.sigEnabled = True

                    self.saveEventParam('SIGSEGV_GEN', 0, 0)

                    return False

            SysMgr.printWarn("fail to recognize event %s at %d" % \
                    (func[:-1], SysMgr.dbgEventLine))

            self.saveEventParam('IGNORE', 0, func[:-1])

            return False

        elif isFixedEvent and func == "signal_deliver:":
            m = re.match((
                r'^\s*sig=(?P<sig>[0-9]+) errno=(?P<err>[0-9]+) code=(?P<code>.*) '
                r'sa_handler=(?P<handler>.*) sa_flags=(?P<flags>.*)'), args)
            if m:
                b = m.groupdict()

                if b['sig'] == str(signal.SIGSEGV):
                    self.sigEnabled = True

                    self.saveEventParam('SIGSEGV_DLV', 0, 0)
                else:
                    self.saveEventParam('IGNORE', 0, func[:-1])
            else:
                self.saveEventParam('IGNORE', 0, func[:-1])

            return False

        elif isFixedEvent and func == "locks_get_lock_context:":
            m = re.match((
                r'^\s*dev=(?P<dev>.+)\s+ino=(?P<ino>.+)'\
                r'\s+type=(?P<type>.+)\s+ctx=(?P<ctx>.+)'), args)
            if m:
                d = m.groupdict()
                if d['type'] == 'F_UNLCK':
                    self.saveEventParam('IGNORE', 0, func[:-1])
                else:
                    self.lockEnabled = True

                    self.threadData[tid]['nrLockTry'] += 1

                    self.saveEventParam(
                        'LOCK_TRY', 1, ['FLOCK', d['ino'], time, core, tid])
            else:
                self.saveEventParam('IGNORE', 0, func[:-1])

            return False

        # Start to record user stack #
        elif func == "<user":
            self.nowCtx['prevMode'] = self.nowCtx['curMode']
            self.nowCtx['curMode'] = 'user'

            return True

        # Start to record kernel stack #
        elif func == "<stack":
            self.nowCtx['prevMode'] = self.nowCtx['curMode']
            self.nowCtx['curMode'] = 'kernel'
            self.nowCtx['nested'] -= 1

            if self.nowCtx['nested'] < 0:
                #self.printDbgInfo()
                SysMgr.printWarn((
                    "fail to analyze stack data "
                    "because of corruption (underflow) at %s line\n"\
                    "\tso report results may differ from actual") % \
                    SysMgr.dbgEventLine, True)

            return True

        # custom event #
        elif not isFixedEvent:
            try:
                if len([event for event in self.customEventTable \
                    if event.endswith(func[:-1])]) == 0:
                    cond = self.customEventTable[func[:-1]] = None
                else:
                    cond = self.customEventTable[func[:-1]]

                # set event filter #
                customCnt = self.getCustomEventValue(func, args, cond)

                if customCnt > 0:
                    self.threadData[tid]['customTotal'] += customCnt

                self.saveEventParam(
                    'CUSTOM', customCnt, [func[:-1], [args, time, core, tid]])
            except:
                self.saveEventParam('IGNORE', 0, func[:-1])

            return False

        # Ignore event #
        else:
            self.saveEventParam('IGNORE', 0, func[:-1])

            return False



    def getTargetList(self, tlist):
        threadData = {}

        for liter in tlist:
            m = SysMgr.getTraceItem(liter)
            if m:
                d = m.groupdict()

                # Make thread entity #
                thread = d['thread']
                try:
                    threadData[thread]['comm'] = d['comm']
                except:
                    threadData[thread] = dict()
                    threadData[thread]['comm'] = d['comm']

                # set tgid #
                try:
                    threadData[thread]['tgid'] = d['tgid']
                except:
                    try:
                        threadData[thread]['tgid'] = \
                            SysMgr.savedProcTree[thread]
                    except:
                        pass

        return threadData



    def parseEventLog(self, string, desc, plist=[]):
        m = SysMgr.getTraceItem(string)
        if m:
            d = m.groupdict()

            self.lastTime = d['time']

            if SysMgr.countEnable and \
                SysMgr.repeatCount * SysMgr.intervalEnable <= \
                float(d['time']) - float(SysMgr.startTime):
                self.lastCore = None
                return False

            # Make thread entity #
            thread = d['thread']
            try:
                self.threadData[thread]['comm'] = d['comm']
            except:
                self.threadData[thread] = dict(self.init_threadData)
                self.threadData[thread]['comm'] = d['comm']

            # set tgid #
            try:
                if d['tgid'].startswith('-'):
                    raise Exception('no tgid')
                self.threadData[thread]['tgid'] = d['tgid']
            except:
                try:
                    self.threadData[thread]['tgid'] = \
                        SysMgr.savedProcTree[thread]
                except:
                    pass

            # increase event count #
            self.threadData[thread]['eventCnt'] += 1

            # set current core #
            self.lastCore = d['core']

            # Make core entity #
            try:
                self.coreCtx[self.lastCore]
            except:
                self.coreCtx[self.lastCore] = dict(self.init_ctxData)
                self.coreCtx[self.lastCore]['userStack'] = []
                self.coreCtx[self.lastCore]['kerStack'] = []
                self.coreCtx[self.lastCore]['prevKerStack'] = []

            # set context of current core #
            self.nowCtx = self.coreCtx[self.lastCore]

            # Check core filter #
            if SysMgr.perCoreList and \
                long(d['core']) not in SysMgr.perCoreList and \
                not d['func'].startswith("tracing_mark_write") and \
                d['func'] != '0:':
                pass

            # Calculate a total of CPU usage #
            elif d['func'] == "hrtimer_start:" and \
                'tick_sched_timer' in d['etc']:
                self.totalTick += 1
                self.threadData[thread]['cpuTick'] += 1

                # Set global interval #
                if self.nowCtx['prevTid']:
                    diff = float(d['time']) - float(self.nowCtx['prevTime'])
                    self.periodicEventInterval += diff
                    self.periodicContEventCnt += 1

                self.nowCtx['prevTid'] = thread
                self.nowCtx['prevTime'] = d['time']

                # Set max core to calculate CPU usage of thread #
                if SysMgr.maxCore < long(d['core']):
                    SysMgr.maxCore = long(d['core'])

            # Mark die flag of thread that is not able to be profiled #
            elif d['func'] == "sched_process_exit:":
                m = re.match(
                    r'^\s*comm=(?P<comm>.*)\s+pid=(?P<pid>[0-9]+)', d['etc'])
                if m:
                    p = m.groupdict()

                    pid = p['pid']

                    try:
                        self.threadData[pid]
                    except:
                        self.threadData[pid] = dict(self.init_threadData)
                        self.threadData[pid]['comm'] = p['comm']

                    self.threadData[pid]['die'] = True

            # Make thread name #
            elif d['func'] == "sched_process_fork:":
                m = re.match((
                    r'^\s*comm=(?P<comm>.*)\s+pid=(?P<pid>[0-9]+)\s+'\
                    r'child_comm=(?P<child_comm>.*)\s+'\
                    r'child_pid=(?P<child_pid>[0-9]+)'), d['etc'])
                if m:
                    p = m.groupdict()

                    cpid = p['child_pid']
                    ccomm = p['child_comm']

                    try:
                        self.threadData[cpid]
                    except:
                        self.threadData[cpid] = dict(self.init_threadData)
                        self.threadData[cpid]['comm'] = ccomm
                        self.threadData[cpid]['new'] = True

            # Make thread name #
            elif d['func'] == "task_newtask:":
                m = re.match(
                    r'^\s*pid=(?P<pid>[0-9]+)\s+comm=(?P<comm>\S+)', d['etc'])
                if m:
                    p = m.groupdict()

                    pid = p['pid']

                    try:
                        self.threadData[pid]
                    except:
                        self.threadData[pid] = dict(self.init_threadData)
                        self.threadData[pid]['comm'] = p['comm']
                        self.threadData[pid]['new'] = True

            # Save user event #
            elif d['func'].startswith("tracing_mark_write") or \
                d['func'] == '0:':
                m = re.match(r'^.+EVENT_(?P<event>\S+)', d['etc'])
                if m:
                    gd = m.groupdict()

                    EventAnalyzer.addEvent(d['time'], gd['event'])

                    if gd['event'] == 'STOP':
                        self.finishTime = float(d['time'])

                # Return False because no stack data with this event #
                return False

            # apply filter #
            if SysMgr.isExceptTarget(
                thread, self.threadData, plist=plist):
                return False
            else:
                self.threadData[thread]['target'] = True

            return self.parseEventInfo(
                thread, d['func'], d['etc'], d['time'], d['core'])

        # Parse call stack #
        else:
            # exist path, offset, pos #
            m = re.match((
                r' => (?P<path>.+)\[\+0x(?P<offset>.\S*)\] '\
                r'\<(?P<pos>.\S+)\>'), string)
            if m:
                d = m.groupdict()
                return (d['pos'], d['path'], hex(long(d['offset'], 16)))

            # exist only pos #
            pos = string.find('=>  <')
            if pos > -1:
                return (string[pos+5:len(string)-2], None, None)

            # no user stack tracing supported #
            if '??' in string:
                if SysMgr.userEnable and SysMgr.userEnableWarn:
                    SysMgr.printWarn((
                        "enable CONFIG_USER_STACKTRACE_SUPPORT kernel option "
                        "if it is not enabled"), True)
                    SysMgr.userEnableWarn = False
                return ('0', None, None)

            # exist symbol, pos #
            m = re.match(r' => (?P<symbol>.+) \<(?P<pos>.\S+)\>', string)
            if m:
                d = m.groupdict()
                return (d['pos'], d['symbol'], None)

            # garbage log #
            return False



    def getBinInfo(self, addr):
        for data in self.mapData:
            if long(data['startAddr'], 16) <= long(addr, 16) and \
                long(data['endAddr'], 16) >= long(addr, 16):
                if ElfAnalyzer.isRelocFile(data['binName']):
                    # Return full path and offset in mapping table #
                    return SysMgr.rootPath + data['binName'],\
                        hex(long(addr, 16) - long(data['startAddr'], 16))
                else:
                    return SysMgr.rootPath + data['binName'],\
                        hex(long(addr, 16))
        SysMgr.printWarn(
            "fail to get the binary info of %s in mapping table" % addr)



    def printSyscallSummary(self):
        # no effective syscall event #
        if self.syscallCnt == 0:
            return

        convertNum = UtilMgr.convNum

        SysMgr.clearPrint()
        SysMgr.printPipe(
            '[Function Syscall Info] [Cnt: %s]' % \
            convertNum(self.syscallCnt))
        SysMgr.printPipe(twoLine)
        SysMgr.printPipe(
            '{0:>16}({1:>7}/{2:>7}) {3:>30}({4:>3}) {5:>12}'.format(
            "Name", "TID", "PID", "Syscall", "SID", "Count"))
        SysMgr.printPipe(twoLine)

        outputCnt = long(0)
        for key, value in sorted(self.threadData.items(),
            key=lambda e: e[1]['nrSyscall'], reverse=True):
            threadInfo = ''
            syscallInfo = ''

            if key[0:2] == '0[':
                continue

            try:
                if len(value['syscallTable']) > 0:
                    threadInfo = "%16s(%7s/%7s)" % \
                        (value['comm'], key, value['tgid'])
                else:
                    continue
            except:
                continue

            for sysId, val in sorted(value['syscallTable'].items(),
                key=lambda e: e[1], reverse=True):
                if val == 0:
                    continue

                try:
                    syscall = ConfigMgr.sysList[sysId][4:]
                except:
                    SysMgr.printErr(
                        "fail to get syscall name by number %s" % sysId)
                    syscall = sysId

                syscallInfo = \
                    ('{0:1} {1:>30}({2:>3}) {3:>12}\n').format(
                    '%s%s' % (syscallInfo, ' ' * len(threadInfo)),
                    syscall, sysId, convertNum(val))

            if syscallInfo != '':
                outputCnt += 1
                SysMgr.printPipe(threadInfo)
                SysMgr.printPipe('%s%s' % (syscallInfo, oneLine))

        if outputCnt == 0:
            SysMgr.printPipe('\tNone\n%s' % oneLine)

        SysMgr.printPipe('\n\n')



    def printUsage(self):
        targetCnt = long(0)
        self.totalTime = \
            float(self.finishTime) - float(SysMgr.startTime)

        convertFunc = UtilMgr.convSize2Unit
        convertNum = UtilMgr.convNum

        SysMgr.printLogo(big=True)

        # print system information #
        SysMgr.printInfoBuffer()

        # choose syscall / heap menu in table #
        if self.sysEnabled:
            cmenu = 'SYSTEM'
            cmenu2 = 'CALLS'
        else:
            cmenu = 'HEAP'
            cmenu2 = 'EVENTS'

        # Print thread list #
        SysMgr.printPipe(
            "[%s] [ %s: %0.3f ] [ %s: %0.3f ] [ Threads: %d ] [ LogSize: %s ]" % \
            ('Function Thread Info', 'Elapsed', round(self.totalTime, 7),
            'Start', round(float(SysMgr.startTime), 7),
             len(self.threadData), convertFunc(SysMgr.logSize)))
        SysMgr.printPipe(twoLine)
        SysMgr.printPipe(
            "{0:_^46}|{1:_^7}|{2:_^54}|{3:_^8}|{4:_^18}|{5:_^6}|{6:_^8}|".\
            format("Thread", "CPU", "PAGE", cmenu, "BLOCK", "LOCK", "CUSTOM"))
        SysMgr.printPipe(
            (("{0:^16}|{1:^7}|{2:^7}|{3:^6}|{4:^6}|{5:^7}|"
            "{6:^9}{7:^8}{8:^8}{9:^12}|{10:^8}|{11:^7}|{12:^8}|"
            "{13:^8}|{14:^9}|{15:^6}|{16:^8}|")).\
            format(" ", " ", " ", " ", " ", " ", " ", " ", " ", " ",
            " ", " ", " ", " ", " ", " ", " "))
        SysMgr.printPipe(
            (("{0:_^16}|{1:_^7}|{2:_^7}|{3:_^6}|{4:_^6}|"
            "{5:_^7}|{6:_^9}({7:_^8}/{8:_^8}/{9:_^8})|{10:_^8}|"
            "{11:_^7}|{12:_^8}|{13:_^8}|{14:_^9}|{15:_^6}|{16:_^8}|")).\
            format("Name", "TID", "PID", "PICK", "LIFE",
            "PER", "ALLOC", "USER", "BUF", "KERN", "FREE", "UFREE", cmenu2,
            "READ", "WRITE", "TRY", "EVENTS"))
        SysMgr.printPipe(twoLine)

        # set sort value #
        if SysMgr.sort == 'm':
            sortedThreadData = sorted(self.threadData.items(),
                key=lambda e: e[1]['nrPages'], reverse=True)
        elif SysMgr.sort == 'b':
            sortedThreadData = sorted(self.threadData.items(),
                key=lambda e: e[1]['nrRdBlocks'], reverse=True)
        elif SysMgr.sort == 'L':
            sortedThreadData = sorted(self.threadData.items(),
                key=lambda e: e[1]['nrLockTry'], reverse=True)
        elif SysMgr.sort == 'h':
            sortedThreadData = sorted(self.threadData.items(),
                key=lambda e: e[1]['heapSize'], reverse=True)
        elif SysMgr.sort == 's':
            sortedThreadData = sorted(self.threadData.items(),
                key=lambda e: e[1]['nrSyscall'], reverse=True)
        else:
            # set CPU usage as default #
            sortedThreadData = sorted(self.threadData.items(),
                key=lambda e: e[1]['cpuTick'], reverse=True)

        for idx, value in sortedThreadData:
            targetMark = ''

            # skip no event count thread #
            if value['eventCnt'] == 0:
                continue

            # check target thread #
            if value['target']:
                targetCnt += 1
                if targetCnt == 2:
                    SysMgr.printWarn(
                        "multiple target threads are selected")
                targetMark = '*'

            # get CPU usage #
            if self.totalTick > 0:
                cpuPer = \
                    '%.1f%%' % \
                    (float(value['cpuTick']) / float(self.totalTick) * 100)
            else:
                cpuPer = '0.0%%'

            # set break condition #
            if SysMgr.sort == 'm':
                breakCond = value['nrPages']
            elif SysMgr.sort == 'b':
                breakCond = value['nrRdBlocks']
            else:
                breakCond = long(cpuPer[:cpuPer.rfind('.')])

            # check condition for stop #
            if breakCond < 1 and not SysMgr.showAll:
                pass

            # set lifecycle flags #
            if value['new']:
                life = 'N'
            else:
                life = ' '
            if value['die']:
                life = '%sD' % life

            if self.cpuEnabled:
                # remove percentage if no tick #
                if float(value['cpuTick']) == 0:
                    cpuPer = '-'
                else:
                    cpuPer = cpuPer
            else:
                cpuPer = '-'

            if self.sysEnabled:
                cval = '%s' % convertNum(value['nrSyscall'])
            elif self.heapEnabled:
                cval = '%s' % convertFunc(value['heapSize'])
            else:
                cval = '-'

            if self.memEnabled:
                allocMem = '%s' % convertFunc(value['nrPages'] << 12)
                userMem = '%s' % convertFunc(value['userPages'] << 12)
                cacheMem = '%s' % convertFunc(value['cachePages'] << 12)
                kernelMem = '%s' % convertFunc(value['kernelPages'] << 12)
                knownFreeMem = '%s' % \
                    convertFunc(value['nrKnownFreePages'] << 12)
                unknownFreeMem = '%s' % \
                    convertFunc(value['nrUnknownFreePages'] << 12)
            else:
                allocMem = '-'
                userMem = '-'
                cacheMem = '-'
                kernelMem = '-'
                knownFreeMem = '-'
                unknownFreeMem = '-'

            if self.breadEnabled:
                readBlock = '%s' % convertFunc(value['nrRdBlocks'] << 9)
            else:
                readBlock = '-'

            if self.bwriteEnabled:
                writeBlock = '%s' % convertFunc(value['nrWrBlocks'] << 9)
            else:
                writeBlock = '-'

            if self.lockEnabled:
                nrLock = convertNum(value['nrLockTry'])
            else:
                nrLock = '-'

            if self.customTotal > 0:
                nrCustom = convertNum(value['customTotal'])
            else:
                nrCustom = '-'

            # update comm #
            if value['comm'] == '<...>' and idx in SysMgr.commCache:
                comm = SysMgr.commCache[idx]
            else:
                comm = value['comm']

            SysMgr.printPipe(
                (("{0:>16}|{1:>7}|{2:>7}|{3:^6}|{4:^6}|"
                "{5:>7}|{6:>9}({7:>8}/{8:>8}/{9:>8})|{10:>7}|{11:>8}|"
                "{12:>8}|{13:>8}|{14:>9}|{15:>6}|{16:>8}|")).\
                format(comm[:16], idx, value['tgid'], targetMark, life,
                cpuPer, allocMem, userMem, cacheMem,  kernelMem,
                knownFreeMem, unknownFreeMem, cval,
                readBlock, writeBlock, nrLock, nrCustom))

        if targetCnt == 0:
            SysMgr.printPipe('\tNone')

        SysMgr.printPipe("%s\n\n\n" % oneLine)

        # Exit because of no target #
        if not self.target:
            SysMgr.printWarn(
                "no specific thread targeted, input value for TID")

        # Print syscall usage of threads #
        self.printSyscallSummary()

        # Print resource usage of functions #
        self.printCpuUsage()
        self.printMemUsage()
        self.printHeapUsage()
        self.printBlockRdUsage()
        self.printBlockWrUsage()
        self.printLockUsage()
        self.printSyscallUsage()
        self.printCustomUsage()



    def makeKernelSymList(self, subStack, indentLen):
        symbolStack = ''
        stackIdx = long(0)
        appliedIndentLen = indentLen

        if not subStack:
            return ' None'

        try:
            for pos in subStack:
                if self.posData[pos]['symbol'] == '':
                    symbolSet = ' <- %s' % hex(long(pos, 16))
                elif not self.posData[pos]['symbol'] and \
                    SysMgr.showAll:
                    symbolSet = ' <- %s' % hex(long(pos, 16))
                else:
                    symbolSet = ' <- %s' % str(self.posData[pos]['symbol'])

                lpos = appliedIndentLen + \
                    len(symbolStack[stackIdx:]) + len(symbolSet)
                if symbolStack != '' and lpos > SysMgr.lineLength:
                    stackIdx = len(symbolStack)
                    symbolStack = '%s\n%s' % (symbolStack, ' ' * indentLen)
                    appliedIndentLen = long(0)

                symbolStack = '%s%s' % (symbolStack, symbolSet)
        except SystemExit:
            sys.exit(0)
        except:
            pass

        return symbolStack



    def makeUserSymList(self, subStack, indentLen):
        symbolStack = ''
        stackIdx = long(0)
        appliedIndentLen = indentLen

        if self.sort == 'sym':
            for sym in subStack:
                if not sym or sym == '0':
                    symbolSet = ''
                elif self.userSymData[sym]['origBin'] == '??':
                    symbolSet = ' <- %s' % sym
                else:
                    symbolSet = \
                        ' <- %s [%s]' % (sym, self.userSymData[sym]['origBin'])

                lpos = appliedIndentLen + \
                    len(symbolStack[stackIdx:]) + len(symbolSet)
                if symbolStack != '' and lpos > SysMgr.lineLength:
                    stackIdx = len(symbolStack)
                    symbolStack = \
                        '%s\n%s' % (symbolStack, ' ' * indentLen)
                    appliedIndentLen = long(0)

                symbolStack = '%s%s' % (symbolStack, symbolSet)
        elif self.sort == 'pos':
            for pos in subStack:
                if not pos:
                    symbolStack += ' <- None'
                # No symbol so that just print pos #
                elif self.posData[pos]['symbol'] == '':
                    symbolStack = '%s <- %s [%s]' % \
                        (symbolStack, hex(long(pos, 16)),
                        self.posData[pos]['origBin'])
                # Print symbol #
                else:
                    symbolStack = '%s <- %s [%s]' % \
                        (symbolStack, self.posData[pos]['symbol'],
                        self.posData[pos]['origBin'])

        if not symbolStack:
            return '\tNone'
        else:
            return symbolStack



    def printSyscallUsage(self):
        # no effective syscall event #
        if self.syscallCnt == 0 or \
            not SysMgr.userEnable:
            return

        subStackIndex = FunctionAnalyzer.symStackIdxTable.index('STACK')
        eventIndex = FunctionAnalyzer.symStackIdxTable.index('SYSCALL')
        convertNum = UtilMgr.convNum

        # Print syscall event #
        SysMgr.clearPrint()
        SysMgr.printPipe(
            '[Function Syscall Info] [Cnt: %s] (USER)' % \
            convertNum(self.syscallCnt))

        SysMgr.printPipe(twoLine)
        SysMgr.printPipe("{0:_^9}|{1:_^47}|{2:_^49}|{3:_^46}".\
            format("Usage", "Function", "Binary", "Source"))
        SysMgr.printPipe(twoLine)

        for idx, value in sorted(self.userSymData.items(),
            key=lambda e: e[1]['syscallCnt'], reverse=True):

            if value['syscallCnt'] == 0:
                break

            SysMgr.printPipe(
                "{0:>7}  |{1:^47}| {2:48}| {3:37}".format(
                convertNum(value['syscallCnt']), idx,
                self.posData[value['pos']]['origBin'],
                self.posData[value['pos']]['src']))

            # Set target stack #
            targetStack = self.getTargetStack(value, eventIndex)

            # Merge and Print symbols in stack #
            for stack in targetStack:
                eventCnt = stack[eventIndex]
                subStack = list(stack[subStackIndex])

                if eventCnt == 0:
                    break

                if not subStack:
                    continue
                else:
                    indentLen = len("\t" * 4 * 4) + 3
                    symbolStack = self.makeUserSymList(subStack, indentLen)

                SysMgr.printPipe(
                    "\t\t +{0:>7} |{1:32}".format(
                    convertNum(eventCnt), symbolStack))

            SysMgr.printPipe(oneLine)

        SysMgr.printPipe()

        # Print syscall file #
        SysMgr.printPipe(
            '[Function Syscall File Info] [Cnt: %s] (USER)' % \
            convertNum(self.syscallCnt))

        SysMgr.printPipe(twoLine)
        SysMgr.printPipe("{0:_^9}|{1:_^144}".\
            format("Usage", "Binary"))
        SysMgr.printPipe(twoLine)

        for idx, value in sorted(self.userFileData.items(),
            key=lambda e: e[1]['syscallCnt'], reverse=True):

            if value['syscallCnt'] == 0:
                break

            SysMgr.printPipe(
                "{0:>8} | {1:<142}".format(
                convertNum(value['syscallCnt']), idx))

            SysMgr.printPipe(oneLine)

        if self.periodicEventCnt == 0:
            SysMgr.printPipe('\tNone\n%s' % oneLine)

        SysMgr.printPipe()

        # Print syscall history #
        if not SysMgr.showAll or not self.sysCallData:
            SysMgr.printPipe('\n\n')
            return

        SysMgr.clearPrint()
        SysMgr.printPipe(
            '[Function Syscall History] [Cnt: %s]' % \
            convertNum(self.syscallCnt))

        SysMgr.printPipe(twoLine)
        SysMgr.printPipe(
            "{0:_^32}|{1:_^17}({2:_^7})|{3:_^8}|{4:_^17}|".\
            format("Event", "COMM", "TID", "CORE", "TIME"))
        SysMgr.printPipe(twoLine)

        # sort by time #
        for call in self.sysCallData:
            event = ConfigMgr.sysList[call[0]][4:]
            args = call[1][0]
            time = call[1][1]
            core = call[1][2]
            tid = call[1][3]

            title = "{0:^32}| {1:>16}({2:>7})| {3:>6} | {4:>15} |".\
                format(event, self.threadData[tid]['comm'], tid, core, time)
            SysMgr.printPipe('%s\n%s' % (title, len(title) * '-'))

            # Make argument info #
            argsInfo = ' %s' % args

            # Make user call info #
            indentLen = 32
            nowLen = indentLen
            try:
                last = call[2][0]
                stack = call[2][1]
                userCall = ' %s[%s]' % \
                    (self.posData[last]['symbol'],
                    self.posData[last]['binary'])
                nowLen += len(userCall)
                for subcall in stack:
                    try:
                        symbol = self.posData[subcall]['symbol']
                        binary = self.posData[subcall]['binary']
                        nextCall = ' <- %s[%s]' % (symbol, binary)
                        if SysMgr.lineLength > nowLen + len(nextCall):
                            userCall = '%s%s' % (userCall, nextCall)
                            nowLen += len(nextCall)
                        else:
                            userCall = '%s\n%s %s' % \
                                (userCall, ' ' * indentLen, nextCall)
                            nowLen = indentLen + len(nextCall)
                    except:
                        pass
            except SystemExit:
                sys.exit(0)
            except:
                pass

            SysMgr.printPipe(
                "{0:>32}| {1:<121}".format('[Args] ', argsInfo.strip()))
            SysMgr.printPipe(
                "{0:>32}|{1:<121}".format('[User] ', userCall))
            SysMgr.printPipe(oneLine)

        SysMgr.printPipe('\n\n')



    def printCustomUsage(self):
        # no effective custom event #
        if self.customTotal == 0:
            return

        subStackIndex = FunctionAnalyzer.symStackIdxTable.index('STACK')
        eventIndex = FunctionAnalyzer.symStackIdxTable.index('CUSTOM')
        convertNum = UtilMgr.convNum

        # Make custom event list #
        customList = ', '.join(list(self.customEventTable.keys()))

        # Print custom event in user space #
        if SysMgr.userEnable:
            SysMgr.clearPrint()
            SysMgr.printPipe(
                '[Function %s Info] [Cnt: %s] [Total: %s] (USER)' % \
                (customList, convertNum(self.customTotal),
                convertNum(self.customCnt)))

            SysMgr.printPipe(twoLine)
            SysMgr.printPipe("{0:_^9}|{1:_^47}|{2:_^49}|{3:_^46}".\
                format("Usage", "Function", "Binary", "Source"))
            SysMgr.printPipe(twoLine)

            for idx, value in sorted(self.userSymData.items(),
                key=lambda e: e[1]['customCnt'], reverse=True):

                if value['customCnt'] == 0:
                    break

                SysMgr.printPipe(
                    "{0:>7}  |{1:^47}| {2:48}| {3:37}".format(
                    convertNum(value['customCnt']), idx,
                    self.posData[value['pos']]['origBin'],
                    self.posData[value['pos']]['src']))

                # Set target stack #
                targetStack = self.getTargetStack(value, eventIndex)

                # Merge and Print symbols in stack #
                for stack in targetStack:
                    eventCnt = stack[eventIndex]
                    subStack = list(stack[subStackIndex])

                    if eventCnt == 0:
                        break

                    if not subStack:
                        continue
                    else:
                        indentLen = len("\t" * 4 * 4) + 3
                        symbolStack = self.makeUserSymList(subStack, indentLen)

                    SysMgr.printPipe(
                        "\t\t +{0:>7} |{1:32}".format(
                        convertNum(eventCnt), symbolStack))

                SysMgr.printPipe(oneLine)

            SysMgr.printPipe()

            # Print custom event file in user space #
            SysMgr.printPipe(
                '[Function %s File Info] [Cnt: %s] [Total: %s] (USER)' % \
                (customList, convertNum(self.customTotal),
                convertNum(self.customCnt)))

            SysMgr.printPipe(twoLine)
            SysMgr.printPipe("{0:_^9}|{1:_^144}".\
                format("Usage", "Binary"))
            SysMgr.printPipe(twoLine)

            for idx, value in sorted(self.userFileData.items(),
                key=lambda e: e[1]['customCnt'], reverse=True):

                if value['customCnt'] == 0:
                    break

                SysMgr.printPipe(
                    "{0:>8} | {1:<142}".format(
                    convertNum(value['customCnt']), idx))

                SysMgr.printPipe(oneLine)

            if self.periodicEventCnt == 0:
                SysMgr.printPipe('\tNone\n%s' % oneLine)

            SysMgr.printPipe()

        # Print custom event in kernel space #
        SysMgr.clearPrint()
        SysMgr.printPipe(
            '[Function %s Info] [Cnt: %s] [Total: %s] (KERNEL)' % \
            (customList, convertNum(self.customTotal),
            convertNum(self.customCnt)))

        SysMgr.printPipe(twoLine)
        SysMgr.printPipe(
            "{0:_^9}|{1:_^144}".format("Usage", "Function"))
        SysMgr.printPipe(twoLine)

        # Print custom usage of stacks #
        for idx, value in sorted(self.kerSymData.items(),
            key=lambda e: e[1]['customCnt'], reverse=True):

            if value['customCnt'] == 0:
                break

            SysMgr.printPipe(
                "{0:>7}  |{1:^134}".format(
                convertNum(value['customCnt']), idx))

            # Sort stacks by usage #
            value['stack'] = \
                sorted(value['stack'],
                key=lambda x: x[eventIndex], reverse=True)

            # Print stacks by symbol #
            for stack in value['stack']:
                eventCnt = stack[eventIndex]
                subStack = list(stack[subStackIndex])

                if eventCnt == 0:
                    break

                if not subStack:
                    continue
                elif len(subStack) == 1 and not SysMgr.showAll and \
                    (not self.posData[subStack[0]]['symbol'] or \
                    self.posData[subStack[0]]['symbol'] == 'NoFile'):
                    # Pass unmeaningful part #
                    continue
                else:
                    indentLen = len("\t" * 4 * 4) + 3
                    symbolStack = self.makeKernelSymList(subStack, indentLen)

                SysMgr.printPipe(
                    "\t\t +{0:>7} |{1:32}".format(
                    convertNum(eventCnt), symbolStack))

            SysMgr.printPipe(oneLine)

            SysMgr.printPipe()

        # Print custom call history #
        if not SysMgr.showAll or not self.customCallData:
            SysMgr.printPipe('\n\n')
            return

        SysMgr.clearPrint()
        SysMgr.printPipe(
            '[Function %s History] [Cnt: %s] [Total: %s]' % \
            (customList, convertNum(self.customTotal),
            convertNum(self.customCnt)))

        SysMgr.printPipe(twoLine)
        SysMgr.printPipe(
            "{0:_^32}|{1:_^17}({2:_^7})|{3:_^8}|{4:_^17}|".\
            format("Event", "COMM", "TID", "CORE", "TIME"))
        SysMgr.printPipe(twoLine)

        # sort by time #
        for call in sorted(self.customCallData, key=lambda e: e[1][1]):
            event = call[0]
            args = call[1][0]
            time = call[1][1]
            core = call[1][2]
            tid = call[1][3]

            title = "{0:^32}| {1:>16}({2:>7})| {3:>6} | {4:>15} |".\
                format(event, self.threadData[tid]['comm'], tid, core, time)
            SysMgr.printPipe('%s\n%s' % (title, len(title) * '-'))

            # Make argument info #
            argsInfo = ' %s' % args

            # Make user call info #
            indentLen = 32
            nowLen = indentLen
            try:
                last = call[2][0]
                stack = call[2][1]
                userCall = ' %s[%s]' % \
                    (self.posData[last]['symbol'],
                    self.posData[last]['binary'])
                nowLen += len(userCall)
                for subcall in stack:
                    try:
                        symbol = self.posData[subcall]['symbol']
                        binary = self.posData[subcall]['binary']
                        nextCall = ' <- %s[%s]' % (symbol, binary)
                        if SysMgr.lineLength > nowLen + len(nextCall):
                            userCall = '%s%s' % (userCall, nextCall)
                            nowLen += len(nextCall)
                        else:
                            userCall = '%s\n%s %s' % \
                                (userCall, ' ' * indentLen, nextCall)
                            nowLen = indentLen + len(nextCall)
                    except:
                        pass
            except SystemExit:
                sys.exit(0)
            except:
                pass

            # Make kernel call info #
            indentLen = 32
            nowLen = indentLen
            try:
                last = call[3][0]
                stack = call[3][1]
                kernelCall = ' %s' % (self.posData[last]['symbol'])
                nowLen += len(kernelCall)
                for subcall in stack:
                    try:
                        nextCall = \
                            ' <- %s' % (self.posData[subcall]['symbol'])
                        if SysMgr.lineLength > nowLen + len(nextCall):
                            kernelCall = '%s%s' % (kernelCall, nextCall)
                            nowLen += len(nextCall)
                        else:
                            kernelCall = \
                                '%s\n%s %s' % \
                                (kernelCall, ' ' * indentLen, nextCall)
                            nowLen = indentLen + len(nextCall)
                    except:
                        pass
            except SystemExit:
                sys.exit(0)
            except:
                pass

            SysMgr.printPipe(
                "{0:>32}| {1:<121}".format('[Args] ', argsInfo.strip()))
            SysMgr.printPipe(
                "{0:>32}|{1:<121}".format('[User] ', userCall))
            SysMgr.printPipe(
                "{0:>32}|{1:<121}".format('[Kernel] ', kernelCall))
            SysMgr.printPipe(oneLine)

        SysMgr.printPipe('\n\n')



    def printCpuUsage(self):
        # no CPU event #
        if not self.cpuEnabled or self.periodicEventCnt == 0:
            return

        subStackIndex = FunctionAnalyzer.symStackIdxTable.index('STACK')
        cpuTickIndex = FunctionAnalyzer.symStackIdxTable.index('CPU_TICK')
        tCnt = UtilMgr.convNum(self.periodicEventCnt)

        # average tick interval #
        if self.periodicContEventCnt > 0:
            self.periodicEventInterval /= self.periodicContEventCnt

        # Print CPU usage in user space #
        if SysMgr.userEnable:
            SysMgr.clearPrint()
            title = 'Function CPU-Tick Info'
            SysMgr.printPipe(
                '[%s] [Cnt: %s] [Interval: %dms] (USER)' % \
                (title, tCnt, self.periodicEventInterval * 1000))

            # Print call stack #
            SysMgr.printPipe(twoLine)
            SysMgr.printPipe("{0:_^9}|{1:_^47}|{2:_^96}".\
                format("Usage", "Function", "Binary"))
            SysMgr.printPipe(twoLine)

            for idx, value in sorted(self.userSymData.items(),
                key=lambda e: e[1]['tickCnt'], reverse=True):

                if value['tickCnt'] == 0:
                    break

                cpuPer = \
                    round(float(value['tickCnt']) / \
                    float(self.periodicEventCnt) * 100, 1)
                if cpuPer < 1 and not SysMgr.showAll:
                    break

                SysMgr.printPipe(
                    "{0:7.1f}% |{1:^47}| {2:48}".format(cpuPer, idx,
                    self.posData[value['pos']]['origBin']))

                # Increase total CPU usage per symbol #
                value['totalTickCnt'] += value['tickCnt']

                # Set target stack #
                targetStack = self.getTargetStack(value)

                # Merge and Print symbols in stack #
                for stack in targetStack:
                    cpuCnt = stack[cpuTickIndex]
                    subStack = list(stack[subStackIndex])

                    if cpuCnt == 0:
                        break

                    if not subStack:
                        continue
                    else:
                        # Increase total tick count of symbols in stack #
                        for sym in subStack:
                            self.userSymData[sym]['totalTickCnt'] += 1

                        cpuPer = \
                            round(float(cpuCnt) / float(value['tickCnt']) * 100, 1)
                        if cpuPer < 1 and not SysMgr.showAll:
                            break

                        indentLen = len("\t" * 4 * 4)
                        symbolStack = self.makeUserSymList(subStack, indentLen)

                    SysMgr.printPipe(
                        "\t +{0:7.1f}% |{1:32}".format(cpuPer, symbolStack))

                SysMgr.printPipe(oneLine)

            if self.periodicEventCnt == 0:
                SysMgr.printPipe('\tNone\n%s' % oneLine)

            SysMgr.printPipe('\n')

            # Print per-symbol #
            title = 'Function CPU-Tick Symbol Info'
            SysMgr.printPipe(
                '[%s] [Cnt: %s] [Interval: %dms] (USER)' % \
                (title, tCnt, self.periodicEventInterval * 1000))

            SysMgr.printPipe(twoLine)
            SysMgr.printPipe("{0:_^9}|{1:_^47}|{2:_^96}".\
                format("Usage", "Function", "Binary"))
            SysMgr.printPipe(twoLine)

            for idx, value in sorted(self.userSymData.items(),
                key=lambda e: e[1]['totalTickCnt'], reverse=True):

                if value['totalTickCnt'] == 0:
                    break

                cpuPer = \
                    round(float(value['totalTickCnt']) / \
                    float(self.periodicEventCnt) * 100, 1)
                if cpuPer < 1 and not SysMgr.showAll:
                    break

                SysMgr.printPipe(
                    "{0:7.1f}% |{1:^47}| {2:48}".format(cpuPer, idx,
                    self.posData[value['pos']]['origBin']))

                SysMgr.printPipe(oneLine)

            if self.periodicEventCnt == 0:
                SysMgr.printPipe('\tNone\n%s' % oneLine)

            SysMgr.printPipe('\n')

            # Print tick per-file #
            title = 'Function CPU-Tick File Info'
            SysMgr.printPipe(
                '[%s] [Cnt: %s] [Interval: %dms] (USER)' % \
                (title, tCnt, self.periodicEventInterval * 1000))

            SysMgr.printPipe(twoLine)
            SysMgr.printPipe("{0:_^9}|{1:_^144}".\
                format("Usage", "Binary"))
            SysMgr.printPipe(twoLine)

            for idx, value in sorted(self.userFileData.items(),
                key=lambda e: e[1]['tickCnt'], reverse=True):

                if value['tickCnt'] == 0:
                    break

                cpuPer = \
                    round(float(value['tickCnt']) / \
                    float(self.periodicEventCnt) * 100, 1)
                if cpuPer < 1 and not SysMgr.showAll:
                    break

                SysMgr.printPipe(
                    "{0:7.1f}% | {1:<142}".format(cpuPer, idx))

                SysMgr.printPipe(oneLine)

            if self.periodicEventCnt == 0:
                SysMgr.printPipe('\tNone\n%s' % oneLine)

            SysMgr.printPipe('\n')

        # Print CPU usage in kernel space #
        title = 'Function CPU-Tick Info'
        SysMgr.clearPrint()
        SysMgr.printPipe(
            '[%s] [Cnt: %s] [Interval: %dms] (KERNEL)' % \
            (title, tCnt, self.periodicEventInterval * 1000))

        SysMgr.printPipe(twoLine)
        SysMgr.printPipe(
            "{0:_^9}|{1:_^144}".format("Usage", "Function"))
        SysMgr.printPipe(twoLine)

        # Make exception list to remove a redundant part of stack #
        exceptList = {}
        for pos, value in self.posData.items():
            if value['symbol'] == '__irq_usr' or \
                value['symbol'] == '__irq_svc' or \
                value['symbol'] == 'el1_irq' or \
                value['symbol'] == 'gic_handle_irq' or \
                value['symbol'] == 'apic_timer_interrupt':
                exceptList.setdefault(pos, dict())

        # Print CPU usage of stacks #
        for idx, value in sorted(self.kerSymData.items(),
            key=lambda e: e[1]['tickCnt'], reverse=True):

            if value['tickCnt'] == 0:
                break

            '''
            disable to print last symbol because it is only one

            tickCnt = float(value['tickCnt'])
            eventCnt = float(self.periodicEventCnt)
            cpuPer = round(tickCnt / eventCnt * 100, 1)

            if cpuPer < 1 and not SysMgr.showAll:
                break

            SysMgr.printPipe("{0:7}% |{1:^134}".format(cpuPer, idx))
            '''

            # Sort stacks by usage #
            value['stack'].sort(reverse=True)

            # Define merge list #
            mergedSymbolChain = {}

            # Merge by symbol chain #
            for stack in value['stack']:
                cpuCnt = stack[cpuTickIndex]
                subStack = list(stack[subStackIndex])

                if cpuCnt == 0:
                    break
                else:
                    # Find index of the backmost exception value #
                    maxIdx = -1
                    for pos in list(exceptList.keys()):
                        try:
                            ridx = subStack.index(pos)
                            if ridx >= 0 and ridx > maxIdx:
                                maxIdx = ridx
                        except:
                            pass

                    # Remove a redundant part #
                    if maxIdx >= 0:
                        maxIdx += 1
                        if maxIdx == len(subStack):
                            subStack = []
                        else:
                            subStack = subStack[maxIdx:]

                if not subStack:
                    symbolStack = ' <- USER'
                elif len(subStack) == 1 and not SysMgr.showAll and \
                    (not self.posData[subStack[0]]['symbol'] or \
                    self.posData[subStack[0]]['symbol'] == 'NoFile'):
                    # Pass unmeaningful part #
                    continue
                else:
                    indentLen = 10
                    symbolStack = self.makeKernelSymList(subStack, indentLen)

                try:
                    mergedSymbolChain[symbolStack] += cpuCnt
                except:
                    mergedSymbolChain[symbolStack] = cpuCnt

            # Print stacks by symbol #
            for chain, tick in sorted(
                mergedSymbolChain.items(), key=lambda e:e[1], reverse=True):
                cpuPer = \
                    round(tick / float(value['tickCnt']) * 100, 1)
                if cpuPer < 1 and not SysMgr.showAll:
                    break

                SysMgr.printPipe(
                    "{0:7.1f}% |{1:32}".format(cpuPer, chain))

            SysMgr.printPipe(oneLine)

            if self.periodicEventCnt == 0:
                SysMgr.printPipe('\tNone\n%s' % oneLine)

        SysMgr.printPipe('\n\n')



    def printUnknownMemFreeInfo(self):
        # check memory event #
        if not self.memEnabled:
            return

        SysMgr.printPipe('\n')

        title = 'Function Free-Only-Page Info'
        subStackIndex = FunctionAnalyzer.symStackIdxTable.index('STACK')
        pageFreeIndex = FunctionAnalyzer.symStackIdxTable.index('PAGE_FREE')
        convertFunc = UtilMgr.convSize2Unit
        size = convertFunc(self.pageUnknownFreeCnt << 12)

        if SysMgr.userEnable:
            # Print memory reduce by page free in user space #
            SysMgr.clearPrint()
            SysMgr.printPipe('[%s] [Size: %s] (USER)' % (title, size))

            SysMgr.printPipe(twoLine)
            SysMgr.printPipe("{0:_^9}|{1:_^47}|{2:_^49}|{3:_^46}".\
                format("Free", "Function", "Binary", "Source"))
            SysMgr.printPipe(twoLine)

            for idx, value in sorted(self.userSymData.items(),
                key=lambda e: e[1]['unknownPageFreeCnt'], reverse=True):
                if value['unknownPageFreeCnt'] == 0:
                    break

                SysMgr.printPipe("{0:>8} |{1:^47}| {2:48}| {3:37}".\
                    format(convertFunc(value['unknownPageFreeCnt'] << 12),
                    idx, self.posData[value['pos']]['origBin'],
                    self.posData[value['pos']]['src']))

                # Set target stack #
                targetStack = self.getTargetStack(value, pageFreeIndex)

                # Merge and Print symbols in stack #
                for stack in targetStack:
                    pageFreeCnt = stack[pageFreeIndex]
                    subStack = list(stack[subStackIndex])

                    if pageFreeCnt == 0:
                        break

                    if not subStack:
                        continue
                    else:
                        indentLen = len("\t" * 4 * 4)
                        symbolStack = self.makeUserSymList(subStack, indentLen)

                    SysMgr.printPipe("\t+ {0:>8} |{1:32}".\
                        format(convertFunc(pageFreeCnt << 12), symbolStack))

                SysMgr.printPipe(oneLine)

            if self.pageUnknownFreeCnt == 0:
                SysMgr.printPipe('\tNone\n%s' % oneLine)

            SysMgr.printPipe('\n')

        # Print memory reduce by page free in kernel space #
        SysMgr.clearPrint()
        SysMgr.printPipe('[%s] [Size: %s] (KERNEL)' % (title, size))

        SysMgr.printPipe(twoLine)
        SysMgr.printPipe("{0:_^9}|{1:_^144}".format("FREE", "Function"))
        SysMgr.printPipe(twoLine)

        for idx, value in sorted(self.kerSymData.items(),
            key=lambda e: e[1]['unknownPageFreeCnt'], reverse=True):

            if value['unknownPageFreeCnt'] == 0:
                break

            SysMgr.printPipe("{0:>8} |{1:^144}".\
                format(convertFunc(value['unknownPageFreeCnt'] << 12), idx))

            # Sort stacks by usage #
            value['stack'] = \
                sorted(value['stack'],
                key=lambda x: x[pageFreeIndex], reverse=True)

            # Print stacks by symbol #
            for stack in value['stack']:
                pageFreeCnt = stack[pageFreeIndex]
                subStack = list(stack[subStackIndex])

                if pageFreeCnt == 0:
                    continue

                if not subStack:
                    symbolStack = '\tNone'
                else:
                    indentLen = len("\t" * 4 * 4)
                    symbolStack = self.makeKernelSymList(subStack, indentLen)

                SysMgr.printPipe("\t+ {0:>8} |{1:32}".\
                    format(convertFunc(pageFreeCnt << 12), symbolStack))

            SysMgr.printPipe(oneLine)

        if self.pageUnknownFreeCnt == 0:
            SysMgr.printPipe('\tNone\n%s' % oneLine)



    def printKnownMemFreeInfo(self):
        title = 'Function Alloc-Free-Page Info'
        lineLength = SysMgr.lineLength
        diff = self.pageAllocCnt - self.pageUsageCnt
        convertFunc = UtilMgr.convSize2Unit
        size = convertFunc(diff << 12)

        # Print page alloc-free pair in user space #
        if SysMgr.userEnable:
            SysMgr.clearPrint()
            SysMgr.printPipe('[%s] [Total: %s] (USER)' % (title, size))

            SysMgr.printPipe(twoLine)
            SysMgr.printPipe(
                "{0:^7}({1:^6}/{2:^6}/{3:^6})|{4:_^47}|{5:_^40}|{6:_^35}".\
                format("Usage", "Usr", "Buf", "Ker", "Function",
                "LifeTime", "Binary"))
            SysMgr.printPipe(twoLine)

            for idx, value in sorted(self.userSymData.items(),
                key=lambda e: e[1]['pagePairCnt'], reverse=True):

                if value['pagePairCnt'] == 0:
                    break

                typeList = \
                    {'USER': long(0), 'KERNEL': long(0), 'CACHE': long(0)}

                for pairId, item in value['pagePair'].items():
                    for ptype, cnt in item['valueList'].items():
                        try:
                            typeList[ptype] += cnt
                        except:
                            pass

                try:
                    avrTime = \
                        float(value['pagePairTotal'] / value['pagePairCnt'])
                except:
                    avrTime = long(0)

                lifeTime = ' AVR: %.3f / MIN: %.3f / MAX: %.3f' % \
                    (avrTime, value['pagePairMin'], value['pagePairMax'])

                SysMgr.printPipe(
                    "{0:>7}({1:>6}/{2:>6}/{3:>6})|{4:^47}|{5:40}| {6:1}".\
                    format(convertFunc(value['pagePairCnt'] << 12),
                    convertFunc(typeList['USER'] << 12),
                    convertFunc(typeList['CACHE'] << 12),
                    convertFunc(typeList['KERNEL'] << 12), idx,
                    lifeTime, self.posData[value['pos']]['origBin']))

                for pairId, item in sorted(value['pagePair'].items(),
                    key=lambda e: e[1]['size'], reverse=True):
                    try:
                        userPages = item['valueList']['USER']
                    except:
                        userPages = long(0)
                    try:
                        cachePages = item['valueList']['CACHE']
                    except:
                        cachePages = long(0)
                    try:
                        kernelPages = item['valueList']['KERNEL']
                    except:
                        kernelPages = long(0)

                    # get user alloc and free call #
                    allocCall, freeCall = pairId.split('#')

                    printBuf = "{0:4}+ {1:>7}({2:>6}/{3:>6}/{4:>6})| ".\
                        format(' ', convertFunc(item['size'] << 12),
                        convertFunc(userPages << 12),
                        convertFunc(cachePages << 12),
                        convertFunc(kernelPages <<12))

                    indentLen = len(printBuf)
                    appliedIndentLen = indentLen

                    for seq, call in enumerate(allocCall.split(' <- ')):
                        if seq > 0 and \
                            appliedIndentLen + len(call) > lineLength:
                            printBuf = "%s\n%s" % (printBuf, ' ' * indentLen)
                            appliedIndentLen = indentLen
                        printBuf = "%s<- %s " % (printBuf, call)
                        appliedIndentLen += (len(call) + 4)

                    SysMgr.printPipe(printBuf)

                    printBuf = "{0:5}{1:>30}|".format(' ', '[FREE]')
                    indentLen = len(printBuf)
                    appliedIndentLen = indentLen

                    for index, call in enumerate(freeCall.split(' <- ')):
                        clen = len(call) + 4

                        if index == 0:
                            clen -= 4

                        if index > 0 and appliedIndentLen + clen > lineLength:
                            printBuf = "%s\n%s" % (printBuf, ' ' * indentLen)
                            appliedIndentLen = indentLen

                        if index == 0:
                            printBuf = "%s %s" % (printBuf, call)
                        else:
                            printBuf = "%s <- %s" % (printBuf, call)

                        appliedIndentLen += clen

                    SysMgr.printPipe(printBuf)

                SysMgr.printPipe(oneLine)

            if self.pageAllocCnt - self.pageUsageCnt <= 0:
                SysMgr.printPipe('\tNone\n%s' % oneLine)

            SysMgr.printPipe('\n')

        # Print page alloc-free pair in kernel space #
        SysMgr.clearPrint()
        SysMgr.printPipe('[%s] [Total: %s] (KERNEL)' % (title, size))

        SysMgr.printPipe(twoLine)
        SysMgr.printPipe(
            "{0:^7}({1:^6}/{2:^6}/{3:^6})|{4:_^47}|{5:_^76}".\
            format("Usage", "Usr", "Buf", "Ker", "Function", "LifeTime"))
        SysMgr.printPipe(twoLine)

        # Print mem usage of stacks #
        for idx, value in sorted(self.kerSymData.items(),
            key=lambda e: e[1]['pagePairCnt'], reverse=True):

            if value['pagePairCnt'] == 0:
                break

            typeList = {'USER': long(0), 'KERNEL': long(0), 'CACHE': long(0)}

            for pairId, item in value['pagePair'].items():
                for ptype, cnt in item['valueList'].items():
                    try:
                        typeList[ptype] += cnt
                    except:
                        pass

            try:
                avrTime = float(value['pagePairTotal'] / value['pagePairCnt'])
            except:
                avrTime = long(0)

            lifeTime = ' AVR: %.3f / MIN: %.3f / MAX: %.3f' % \
                (avrTime, value['pagePairMin'], value['pagePairMax'])

            SysMgr.printPipe(
                "{0:>7}({1:>6}/{2:>6}/{3:>6})|{4:^47}|{5:^75}".\
                format(convertFunc(value['pagePairCnt'] << 12),
                convertFunc(typeList['USER'] << 12),
                convertFunc(typeList['CACHE'] << 12),
                convertFunc(typeList['KERNEL'] << 12), idx, lifeTime))

            for pairId, item in sorted(value['pagePair'].items(),
                key=lambda e: e[1]['size'], reverse=True):
                try:
                    userPages = item['valueList']['USER']
                except:
                    userPages = long(0)
                try:
                    cachePages = item['valueList']['CACHE']
                except:
                    cachePages = long(0)
                try:
                    kernelPages = item['valueList']['KERNEL']
                except:
                    kernelPages = long(0)

                # get kernel alloc and free call #
                allocCall, freeCall = pairId.split('#')

                printBuf = "{0:4}+ {1:>7}({2:>6}/{3:>6}/{4:>6})| ".\
                    format(' ', convertFunc(item['size'] << 12),
                    convertFunc(userPages << 12),
                    convertFunc(cachePages << 12),
                    convertFunc(kernelPages << 12))

                indentLen = len(printBuf)
                appliedIndentLen = indentLen

                for seq, call in enumerate(allocCall.split(' <- ')):
                    if seq > 0 and appliedIndentLen + len(call) > lineLength:
                        printBuf = "%s\n%s" % (printBuf, ' ' * indentLen)
                        appliedIndentLen = indentLen
                    printBuf = "%s<- %s " % (printBuf, call)
                    appliedIndentLen += (len(call) + 4)

                SysMgr.printPipe(printBuf)

                printBuf = "{0:5}{1:>30}|".format(' ', '[FREE]')
                indentLen = len(printBuf)
                appliedIndentLen = indentLen

                for index, call in enumerate(freeCall.split(' <- ')):
                    clen = len(call) + 4

                    if index == 0:
                        clen -= 4

                    if index > 0 and appliedIndentLen + clen > lineLength:
                        printBuf = "%s\n%s" % (printBuf, ' ' * indentLen)
                        appliedIndentLen = indentLen

                    if index == 0:
                        printBuf = "%s %s" % (printBuf, call)
                    else:
                        printBuf = "%s <- %s" % (printBuf, call)

                    appliedIndentLen += clen

                SysMgr.printPipe(printBuf)

            SysMgr.printPipe(oneLine)

        if self.pageAllocCnt - self.pageUsageCnt <= 0:
            SysMgr.printPipe('\tNone\n%s' % oneLine)

        SysMgr.printPipe()



    def printMemUsage(self):
        # check memory event #
        if not self.memEnabled:
            return

        title = 'Function Alloc-Only-Page Info'
        subStackIndex = FunctionAnalyzer.symStackIdxTable.index('STACK')
        pageAllocIndex = FunctionAnalyzer.symStackIdxTable.index('PAGE_ALLOC')
        argIndex = FunctionAnalyzer.symStackIdxTable.index('ARGUMENT')

        convertFunc = UtilMgr.convSize2Unit
        userSize = convertFunc(self.pageUsageCnt << 12)
        allocSize = convertFunc(self.pageAllocCnt << 12)
        freeSize = convertFunc(self.pageFreeCnt << 12)
        allocCnt = UtilMgr.convNum(self.pageAllocEventCnt)
        freeCnt = UtilMgr.convNum(self.pageFreeEventCnt)

        # Calculate page lifetime #
        for pfn, item in self.pageTable.items():
            if not item:
                continue

            # calculate time #
            time = float(item['time'])
            if time > 0:
                lifeTime = float(self.finishTime) - time
            else:
                lifeTime = long(0)

            # Set user page lifetime #
            self.userSymData[item['sym']]['pageRemainTotal'] += lifeTime
            if self.userSymData[item['sym']]['pageRemainMin'] == 0 or \
                self.userSymData[item['sym']]['pageRemainMin'] > lifeTime:
                self.userSymData[item['sym']]['pageRemainMin'] = lifeTime
            if self.userSymData[item['sym']]['pageRemainMax'] < lifeTime:
                self.userSymData[item['sym']]['pageRemainMax'] = lifeTime

            # Set kernel page lifetime #
            self.kerSymData[item['ksym']]['pageRemainTotal'] += lifeTime
            if self.kerSymData[item['ksym']]['pageRemainMin'] == 0 or \
                self.kerSymData[item['ksym']]['pageRemainMin'] > lifeTime:
                self.kerSymData[item['ksym']]['pageRemainMin'] = lifeTime
            if self.kerSymData[item['ksym']]['pageRemainMax'] < lifeTime:
                self.kerSymData[item['ksym']]['pageRemainMax'] = lifeTime

        # Print memory usage by page allocation in user space #
        if SysMgr.userEnable:
            SysMgr.clearPrint()
            SysMgr.printPipe(
                '[%s] [Total: %s] [Alloc: %s(%s)] [Free: %s(%s)] (USER)' % \
                (title, userSize, allocSize, allocCnt, freeSize, freeCnt))

            SysMgr.printPipe(twoLine)
            SysMgr.printPipe(
                "{0:^7}({1:^6}/{2:^6}/{3:^6})|{4:_^47}|{5:_^40}|{6:_^35}".\
                format("Usage", "Usr", "Buf", "Ker",
                    "Function", "LifeTime", "Binary"))
            SysMgr.printPipe(twoLine)

            for idx, value in sorted(self.userSymData.items(),
                key=lambda e: e[1]['pageCnt'], reverse=True):

                if value['pageCnt'] == 0:
                    break

                try:
                    avrTime = \
                        float(value['pageRemainTotal'] / value['pageCnt'])
                except:
                    avrTime = long(0)

                lifeTime = ' AVR: %.3f / MIN: %.3f / MAX: %.3f' % \
                    (avrTime, value['pageRemainMin'], value['pageRemainMax'])

                SysMgr.printPipe(
                    "{0:>7}({1:>6}/{2:>6}/{3:>6})|{4:^47}|{5:40}| {6:1}".\
                    format(convertFunc(value['pageCnt'] << 12),
                    convertFunc(value['userPageCnt'] << 12),
                    convertFunc(value['cachePageCnt'] << 12),
                    convertFunc(value['kernelPageCnt'] << 12), idx,
                    lifeTime, self.posData[value['pos']]['origBin']))

                # Set target stack #
                targetStack = self.getTargetStack(value, pageAllocIndex)

                # Merge and Print symbols in stack #
                for stack in targetStack:
                    subStack = list(stack[subStackIndex])
                    pageCnt = stack[pageAllocIndex]
                    userPageCnt = stack[argIndex][0]
                    cachePageCnt = stack[argIndex][1]
                    kernelPageCnt = stack[argIndex][2]

                    if pageCnt == 0:
                        break

                    if not subStack:
                        continue
                    else:
                        indentLen = len("\t" * 4 * 9)
                        symbolStack = self.makeUserSymList(subStack, indentLen)

                    SysMgr.printPipe(
                        "\t+ {0:>7}({1:>6}/{2:>6}/{3:>6})|{4:32}".\
                        format(convertFunc(pageCnt << 12),
                        convertFunc(userPageCnt << 12),
                        convertFunc(cachePageCnt << 12),
                        convertFunc(kernelPageCnt << 12),
                        symbolStack))

                SysMgr.printPipe(oneLine)

            if self.pageUsageCnt == 0:
                SysMgr.printPipe('\tNone\n%s' % oneLine)

            SysMgr.printPipe('\n')

        # Print memory usage by page allocation in kernel space #
        SysMgr.clearPrint()
        SysMgr.printPipe(
            '[%s] [Total: %s] [Alloc: %s(%s)] [Free: %s(%s)] (KERNEL)' % \
            (title, userSize, allocSize, allocCnt, freeSize, freeCnt))

        SysMgr.printPipe(twoLine)
        SysMgr.printPipe(
            "{0:^7}({1:^6}/{2:^6}/{3:^6})|{4:_^47}|{5:_^76}".\
            format("Usage", "Usr", "Buf", "Ker", "Function", "LifeTime"))
        SysMgr.printPipe(twoLine)

        # Print mem usage of stacks #
        for idx, value in sorted(self.kerSymData.items(),
            key=lambda e: e[1]['pageCnt'], reverse=True):

            if value['pageCnt'] == 0:
                break

            try:
                avrTime = float(value['pageRemainTotal'] / value['pageCnt'])
            except:
                avrTime = long(0)

            lifeTime = ' AVR: %.3f / MIN: %.3f / MAX: %.3f' % \
                (avrTime, value['pageRemainMin'], value['pageRemainMax'])

            SysMgr.printPipe(
                "{0:>7}({1:>6}/{2:>6}/{3:>6})|{4:^47}|{5:^76}".\
                format(convertFunc(value['pageCnt'] << 12),
                convertFunc(value['userPageCnt'] << 12),
                convertFunc(value['cachePageCnt'] << 12),
                convertFunc(value['kernelPageCnt'] << 12),
                idx, lifeTime))

            # Sort stacks by usage #
            value['stack'] = sorted(value['stack'],
                key=lambda x: x[pageAllocIndex], reverse=True)

            # Print stacks by symbol #
            for stack in value['stack']:
                subStack = list(stack[subStackIndex])
                pageCnt = stack[pageAllocIndex]
                userPageCnt = stack[argIndex][0]
                cachePageCnt = stack[argIndex][1]
                kernelPageCnt = stack[argIndex][2]

                if pageCnt == 0:
                    continue

                if not subStack:
                    continue
                else:
                    indentLen = len("\t" * 4 * 9)
                    symbolStack = self.makeKernelSymList(subStack, indentLen)

                SysMgr.printPipe(
                    "\t+ {0:>7}({1:>6}/{2:>6}/{3:>6})|{4:32}".format(
                    convertFunc(pageCnt << 12),
                    convertFunc(userPageCnt << 12),
                    convertFunc(cachePageCnt << 12),
                    convertFunc(kernelPageCnt << 12), symbolStack))

            SysMgr.printPipe(oneLine)

        if self.pageUsageCnt == 0:
            SysMgr.printPipe('\tNone\n%s' % oneLine)

        SysMgr.printPipe('\n')

        self.printKnownMemFreeInfo()

        self.printUnknownMemFreeInfo()

        SysMgr.printPipe('\n\n')



    def printHeapUsage(self):
        # check heap memory event #
        if not self.heapEnabled or \
            not SysMgr.userEnable:
            return

        title = 'Function Expand-Heap'
        subStackIndex = FunctionAnalyzer.symStackIdxTable.index('STACK')
        heapExpIndex = FunctionAnalyzer.symStackIdxTable.index('HEAP_EXPAND')
        convertFunc = UtilMgr.convSize2Unit

        # Print heap usage in user space #
        SysMgr.clearPrint()
        SysMgr.printPipe(
            '[%s Info] [Total: %s] [Alloc: %s(%s)] [Free: %s(%s)] (USER)' % \
            (title,
            convertFunc(self.heapExpSize - self.heapRedSize),
            convertFunc(self.heapExpSize),
            UtilMgr.convNum(self.heapExpEventCnt),
            convertFunc(self.heapRedSize),
            UtilMgr.convNum(self.heapRedEventCnt)))

        SysMgr.printPipe(twoLine)
        SysMgr.printPipe("{0:_^9}|{1:_^47}|{2:_^49}|{3:_^46}".\
            format("Usage", "Function", "Binary", "Source"))
        SysMgr.printPipe(twoLine)

        for idx, value in sorted(self.userSymData.items(),
            key=lambda e: e[1]['heapSize'], reverse=True):

            if value['heapSize'] == 0:
                break

            binary = self.posData[value['pos']]['origBin']
            source = self.posData[value['pos']]['src']
            SysMgr.printPipe("{0:>8} |{1:^47}| {2:48}| {3:37}".\
                format(convertFunc(value['heapSize']), idx, binary, source))

            if idx == value['pos']:
                SysMgr.printPipe(oneLine)
                continue

            # Set target stack #
            targetStack = self.getTargetStack(value, heapExpIndex)

            # Merge and Print symbols in stack #
            for stack in targetStack:
                heapSize = stack[heapExpIndex]
                subStack = list(stack[subStackIndex])

                if heapSize == 0:
                    break

                if not subStack:
                    continue
                else:
                    indentLen = len("\t" * 4 * 4)
                    symbolStack = self.makeUserSymList(subStack, indentLen)

                SysMgr.printPipe("\t+ {0:>8} |{1:32}".\
                    format(convertFunc(heapSize), symbolStack))

            SysMgr.printPipe(oneLine)

        if not self.heapTable:
            SysMgr.printPipe('\tNone\n%s' % oneLine)

        SysMgr.printPipe('\n')

        # Print remaining heap history #
        if not SysMgr.showAll or not self.heapTable:
            SysMgr.printPipe('\n\n')
            return

        SysMgr.clearPrint()
        SysMgr.printPipe(
            '[%s History] [Cnt: %s]' % \
            (title, UtilMgr.convNum(len(self.heapTable))))

        SysMgr.printPipe(twoLine)
        SysMgr.printPipe(
            "{0:_^32}|{1:_^12}|{2:_^17}({3:_^7})|{4:_^8}|{5:_^17}|".\
            format("VAddr", "Size", "COMM", "TID", "CORE", "TIME"))
        SysMgr.printPipe(twoLine)

        # sort by time #
        for segment in sorted(self.heapTable.items(),
            key=lambda e: e[1]['time']):
            addr = segment[0]

            size = segment[1]['size']
            time = segment[1]['time']
            core = segment[1]['core']
            tid = segment[1]['tid']

            usersym = segment[1]['sym']
            kernelsym = segment[1]['ksym']
            userstack = segment[1]['subStackAddr']
            kernelstack = segment[1]['ksubStackAddr']

            title = \
                "{0:^32}| {1:>10} | {2:>16}({3:>7})| {4:>6} | {5:>15} |".\
                format(addr, convertFunc(size),
                self.threadData[tid]['comm'], tid, long(core), time)
            SysMgr.printPipe('%s\n%s' % (title, len(title) * '-'))

            # Make user call info #
            indentLen = 32
            nowLen = indentLen
            try:
                userCall = ' %s[%s]' % \
                    (usersym, self.userSymData[usersym]['origBin'])
                nowLen += len(userCall)

                # Set user stack list #
                if self.sort == 'sym':
                    targetStack = self.userSymData[usersym]['symStack']
                elif self.sort == 'pos':
                    targetStack = self.userSymData[usersym]['stack']

                # Find user stack by addr #
                stack = []
                for val in targetStack:
                    if id(val[subStackIndex]) == userstack:
                        stack = val[subStackIndex]
                        break

                for subcall in stack:
                    try:
                        nextCall = ' <- %s[%s]' % \
                            (subcall, self.userSymData[subcall]['origBin'])
                        if SysMgr.lineLength > nowLen + len(nextCall):
                            userCall = '%s%s' % (userCall, nextCall)
                            nowLen += len(nextCall)
                        else:
                            userCall = '%s\n%s %s' % \
                                (userCall, ' ' * indentLen, nextCall)
                            nowLen = indentLen + len(nextCall)
                    except:
                        pass
            except:
                pass

            # Make kernel call info #
            indentLen = 32
            nowLen = indentLen
            try:
                kernelCall = ' %s' % (kernelsym)
                nowLen += len(kernelCall)

                # Set kernel stack list #
                if self.sort == 'sym':
                    targetStack = self.kerSymData[kernelsym]['symStack']
                elif self.sort == 'pos':
                    targetStack = self.kerSymData[kernelsym]['stack']

                # Find kernel stack by addr #
                stack = []
                for val in targetStack:
                    if id(val[subStackIndex]) == kernelstack:
                        stack = val[subStackIndex]
                        break

                for subcall in stack:
                    try:
                        nextCall = ' <- %s' % (subcall)
                        if SysMgr.lineLength > nowLen + len(nextCall):
                            kernelCall = '%s%s' % (kernelCall, nextCall)
                            nowLen += len(nextCall)
                        else:
                            kernelCall = '%s\n%s %s' % \
                                (kernelCall, ' ' * indentLen, nextCall)
                            nowLen = indentLen + len(nextCall)
                    except:
                        pass
            except:
                pass

            if userCall != ' 0':
                SysMgr.printPipe(
                    "{0:>32}|{1:<121}".format('[User] ', userCall))
            if kernelCall != ' 0':
                SysMgr.printPipe(
                    "{0:>32}|{1:<121}".format('[Kernel] ', kernelCall))
            SysMgr.printPipe(oneLine)

        SysMgr.printPipe('\n\n')



    def printLockUsage(self):
        # no lock event #
        if not self.lockEnabled or \
            not SysMgr.userEnable:
            return

        subStackIndex = FunctionAnalyzer.symStackIdxTable.index('STACK')
        lockIndex = FunctionAnalyzer.symStackIdxTable.index('LOCK_TRY')
        unlockIndex = FunctionAnalyzer.symStackIdxTable.index('UNLOCK')

        # Print lock try #
        title = 'Function Lock-Try Info'
        SysMgr.clearPrint()
        SysMgr.printPipe(
            '[%s] [Cnt: %d] (USER)' % (title, self.lockTryEventCnt))

        SysMgr.printPipe(twoLine)
        SysMgr.printPipe("{0:_^9}|{1:_^47}|{2:_^49}|{3:_^46}".\
            format("Usage", "Function", "Binary", "Source"))
        SysMgr.printPipe(twoLine)

        for idx, value in sorted(self.userSymData.items(),
            key=lambda e: e[1]['lockTryCnt'], reverse=True):

            if value['lockTryCnt'] == 0:
                break

            binary = self.posData[value['pos']]['origBin']
            source = self.posData[value['pos']]['src']
            SysMgr.printPipe("{0:8} |{1:^47}| {2:48}| {3:37}".\
                format(value['lockTryCnt'], idx, binary, source))

            # Set target stack #
            targetStack = self.getTargetStack(value, lockIndex)

            # Merge and Print symbols in stack #
            for stack in targetStack:
                lockTryCnt = stack[lockIndex]
                subStack = list(stack[subStackIndex])

                if lockTryCnt == 0:
                    break

                if not subStack:
                    continue
                else:
                    indentLen = len("\t" * 4 * 4)
                    symbolStack = self.makeUserSymList(subStack, indentLen)

                SysMgr.printPipe("\t+ {0:8} |{1:32}".\
                    format(lockTryCnt, symbolStack))

            SysMgr.printPipe(oneLine)

        if self.lockTryEventCnt == 0:
            SysMgr.printPipe('\tNone\n%s' % oneLine)

        SysMgr.printPipe('\n')

        # Print lock per-file #
        title = 'Function Lock-Try File Info'
        SysMgr.printPipe(
            '[%s] [Cnt: %d] (USER)' % (title, self.lockTryEventCnt))

        SysMgr.printPipe(twoLine)
        SysMgr.printPipe("{0:_^9}|{1:_^144}".format("Usage", "Binary"))
        SysMgr.printPipe(twoLine)

        for idx, value in sorted(self.userFileData.items(),
            key=lambda e: e[1]['lockTryCnt'], reverse=True):

            if value['lockTryCnt'] == 0:
                break

            SysMgr.printPipe(
                "{0:8} | {1:<142}".format(value['lockTryCnt'], idx))

            SysMgr.printPipe(oneLine)

        if self.periodicEventCnt == 0:
            SysMgr.printPipe('\tNone\n%s' % oneLine)

        SysMgr.printPipe('\n')

        # Print unlock #
        title = 'Function Unlock Info'
        SysMgr.clearPrint()
        SysMgr.printPipe(
            '[%s] [Cnt: %d] (USER)' % (title, self.unlockEventCnt))

        SysMgr.printPipe(twoLine)
        SysMgr.printPipe("{0:_^9}|{1:_^47}|{2:_^49}|{3:_^46}".\
            format("Usage", "Function", "Binary", "Source"))
        SysMgr.printPipe(twoLine)

        for idx, value in sorted(self.userSymData.items(),
            key=lambda e: e[1]['unlockCnt'], reverse=True):

            if value['unlockCnt'] == 0:
                break

            binary = self.posData[value['pos']]['origBin']
            source = self.posData[value['pos']]['src']
            SysMgr.printPipe("{0:8} |{1:^47}| {2:48}| {3:37}".\
                format(value['unlockCnt'], idx, binary, source))

            # Set target stack #
            targetStack = self.getTargetStack(value, unlockIndex)

            # Merge and Print symbols in stack #
            for stack in targetStack:
                unlockCnt = stack[unlockIndex]
                subStack = list(stack[subStackIndex])

                if unlockCnt == 0:
                    break

                if not subStack:
                    continue
                else:
                    indentLen = len("\t" * 4 * 4)
                    symbolStack = self.makeUserSymList(subStack, indentLen)

                SysMgr.printPipe("\t+ {0:8} |{1:32}".\
                    format(unlockCnt, symbolStack))

            SysMgr.printPipe(oneLine)

        if self.unlockEventCnt == 0:
            SysMgr.printPipe('\tNone\n%s' % oneLine)

        SysMgr.printPipe('\n')

        # Print unlock per-file #
        title = 'Function Unlock File Info'
        SysMgr.printPipe(
            '[%s] [Cnt: %d] (USER)' % (title, self.lockTryEventCnt))

        SysMgr.printPipe(twoLine)
        SysMgr.printPipe("{0:_^9}|{1:_^144}".\
            format("Usage", "Binary"))
        SysMgr.printPipe(twoLine)

        for idx, value in sorted(self.userFileData.items(),
            key=lambda e: e[1]['unlockCnt'], reverse=True):

            if value['unlockCnt'] == 0:
                break

            SysMgr.printPipe(
                "{0:8} | {1:<142}".format(value['unlockCnt'], idx))

            SysMgr.printPipe(oneLine)

        if self.periodicEventCnt == 0:
            SysMgr.printPipe('\tNone\n%s' % oneLine)

        SysMgr.printPipe('\n')

        # Print lock history #
        if not SysMgr.showAll or not self.lockCallData:
            SysMgr.printPipe('\n\n')
            return

        title = 'Function Lock History'
        SysMgr.clearPrint()
        SysMgr.printPipe(
            '[%s] [Lock: %d] [Unlock: %d]' % \
            (title, self.lockTryEventCnt, self.unlockEventCnt))

        SysMgr.printPipe(twoLine)
        SysMgr.printPipe(
            "{0:_^32}|{1:_^16}|{2:_^17}({3:_^7})|{4:_^8}|{5:_^17}|".\
            format("Event", "TARGET", "COMM", "TID", "CORE", "TIME"))
        SysMgr.printPipe(twoLine)

        # sort by time #
        for call in self.lockCallData:
            event = call[0]
            target = call[1][0]
            time = call[1][1]
            core = call[1][2]
            tid = call[1][3]
            userstack = call[2]

            comm = self.threadData[tid]['comm']
            title = "{0:^32}|{1:^16}|{2:>16}({3:>7})| {4:>6} | {5:>15} |".\
                format(event, target, comm, tid, core, time)
            SysMgr.printPipe('%s\n%s' % (title, len(title) * '-'))

            # Make user call info #
            indentLen = 32
            nowLen = indentLen
            try:
                last = userstack[0]
                stack = userstack[1]
                symbol = self.posData[last]['symbol']
                binary = self.posData[last]['binary']
                userCall = ' %s[%s]' % (symbol, binary)
                nowLen += len(userCall)
                for subcall in stack:
                    try:
                        symbol = self.posData[subcall]['symbol']
                        binary = self.posData[subcall]['binary']
                        nextCall = ' <- %s[%s]' % (symbol, binary)
                        if SysMgr.lineLength > nowLen + len(nextCall):
                            userCall = '%s%s' % (userCall, nextCall)
                            nowLen += len(nextCall)
                        else:
                            userCall = '%s\n%s %s' % \
                                (userCall, ' ' * indentLen, nextCall)
                            nowLen = indentLen + len(nextCall)
                    except:
                        pass
            except SystemExit:
                sys.exit(0)
            except:
                pass

            SysMgr.printPipe(
                "{0:>32}|{1:<121}".format('[User] ', userCall))
            SysMgr.printPipe(oneLine)

        SysMgr.printPipe('\n\n')



    def printBlockWrUsage(self):
        # no block write event #
        if not self.bwriteEnabled:
            return

        title = 'Function Write-Block Info'
        subStackIndex = FunctionAnalyzer.symStackIdxTable.index('STACK')
        blkWrIndex = FunctionAnalyzer.symStackIdxTable.index('BLK_WRITE')
        convertFunc = UtilMgr.convSize2Unit
        convertNum = UtilMgr.convNum
        size = convertFunc(self.blockWrUsageCnt << 9)

        # Print block write in user space #
        if SysMgr.userEnable:
            SysMgr.clearPrint()
            SysMgr.printPipe(
                '[%s] [Size: %s] [Cnt: %s] (USER)' % \
                (title, size, convertNum(self.blockWrEventCnt)))

            SysMgr.printPipe(twoLine)
            SysMgr.printPipe("{0:_^9}|{1:_^47}|{2:_^49}|{3:_^46}".\
                format("Usage", "Function", "Binary", "Source"))
            SysMgr.printPipe(twoLine)

            for idx, value in sorted(self.userSymData.items(),
                key=lambda e: e[1]['blockWrCnt'], reverse=True):

                if value['blockWrCnt'] == 0:
                    break

                binary = self.posData[value['pos']]['origBin']
                source = self.posData[value['pos']]['src']
                SysMgr.printPipe("{0:>8} |{1:^47}| {2:48}| {3:37}".\
                    format(convertFunc(value['blockWrCnt'] << 9),
                    idx, binary, source))

                # Set target stack #
                targetStack = self.getTargetStack(value, blkWrIndex)

                # Merge and Print symbols in stack #
                for stack in targetStack:
                    blockWrCnt = stack[blkWrIndex]
                    subStack = list(stack[subStackIndex])

                    if blockWrCnt == 0:
                        break

                    if not subStack:
                        continue
                    else:
                        indentLen = len("\t" * 4 * 4)
                        symbolStack = self.makeUserSymList(subStack, indentLen)

                    SysMgr.printPipe("\t+ {0:>8} |{1:32}".\
                        format(convertFunc(blockWrCnt << 9), symbolStack))

                SysMgr.printPipe(oneLine)

            if self.blockWrUsageCnt == 0:
                SysMgr.printPipe('\tNone\n%s' % oneLine)

            SysMgr.printPipe('\n')

        # Print block write in kernel space #
        SysMgr.clearPrint()
        SysMgr.printPipe(
            '[%s] [Size: %s] [Cnt: %s] (KERNEL)' % \
            (title, size, convertNum(self.blockWrEventCnt)))

        SysMgr.printPipe(twoLine)
        SysMgr.printPipe("{0:_^9}|{1:_^144}".format("Usage", "Function"))
        SysMgr.printPipe(twoLine)

        # Print block write usage of stacks #
        for idx, value in sorted(self.kerSymData.items(),
            key=lambda e: e[1]['blockWrCnt'], reverse=True):

            if value['blockWrCnt'] == 0:
                break

            SysMgr.printPipe("{0:>8} |{1:^134}".\
                format(convertFunc(value['blockWrCnt'] << 9), idx))

            # Sort stacks by usage #
            value['stack'] = \
                sorted(value['stack'],
                key=lambda x: x[blkWrIndex], reverse=True)

            # Print stacks by symbol #
            for stack in value['stack']:
                blockWrCnt = stack[blkWrIndex]
                subStack = list(stack[subStackIndex])

                if blockWrCnt == 0:
                    continue

                if not subStack:
                    symbolStack = '\tNone'
                else:
                    indentLen = len("\t" * 4 * 4)
                    symbolStack = self.makeKernelSymList(subStack, indentLen)

                SysMgr.printPipe("\t+ {0:>8} |{1:32}".\
                    format(convertFunc(blockWrCnt << 9), symbolStack))

            SysMgr.printPipe(oneLine)

        if self.blockWrUsageCnt == 0:
            SysMgr.printPipe('\tNone\n%s' % oneLine)

        SysMgr.printPipe('\n\n')



    def getExceptionList(self):
        exceptList = {}

        # do not use this function now #
        return exceptList

        for pos, value in self.posData.items():
            if value['symbol'] == 'None':
                try:
                    exceptList[pos]
                except:
                    exceptList[pos] = dict()

        return exceptList



    def getTargetStack(self, value, index=None):
        targetStack = []
        if self.sort == 'sym':
            targetStack = value['symStack']
        elif self.sort == 'pos':
            targetStack = value['stack']

        # Sort by usage #
        if index:
            targetStack = \
                sorted(targetStack, key=lambda x: x[index], reverse=True)
        else:
            targetStack.sort(reverse=True)

        return targetStack



    def printBlockRdUsage(self):
        # no block read event #
        if not self.breadEnabled:
            return

        title = 'Function Read-Block Info'
        subStackIndex = FunctionAnalyzer.symStackIdxTable.index('STACK')
        blkRdIndex = FunctionAnalyzer.symStackIdxTable.index('BLK_READ')
        convertFunc = UtilMgr.convSize2Unit
        convertNum = UtilMgr.convNum
        size = convertFunc(self.blockRdUsageCnt << 9)

        # Print block read in user space #
        if SysMgr.userEnable:
            SysMgr.clearPrint()
            SysMgr.printPipe(
                '[%s] [Size: %s] [Cnt: %s] (USER)' % \
                (title, size, convertNum(self.blockRdEventCnt)))

            SysMgr.printPipe(twoLine)
            SysMgr.printPipe("{0:_^9}|{1:_^47}|{2:_^49}|{3:_^46}".\
                format("Usage", "Function", "Binary", "Source"))
            SysMgr.printPipe(twoLine)

            for idx, value in sorted(self.userSymData.items(),
                key=lambda e: e[1]['blockRdCnt'], reverse=True):

                if value['blockRdCnt'] == 0:
                    break

                binary = self.posData[value['pos']]['origBin']
                source = self.posData[value['pos']]['src']
                SysMgr.printPipe("{0:>8} |{1:^47}| {2:48}| {3:37}".\
                    format(convertFunc(value['blockRdCnt'] << 9),
                    idx, binary, source))

                # Set target stack #
                targetStack = self.getTargetStack(value, blkRdIndex)

                # Merge and Print symbols in stack #
                for stack in targetStack:
                    blockRdCnt = stack[blkRdIndex]
                    subStack = list(stack[subStackIndex])

                    if blockRdCnt == 0:
                        break

                    if not subStack:
                        continue
                    else:
                        indentLen = len("\t" * 4 * 4)
                        symbolStack = self.makeUserSymList(subStack, indentLen)

                    SysMgr.printPipe("\t+ {0:8} |{1:32}".\
                        format(convertFunc(blockRdCnt << 9), symbolStack))

                SysMgr.printPipe(oneLine)

            SysMgr.printPipe('\n')

        # Print block read in kernel space #
        SysMgr.clearPrint()
        SysMgr.printPipe(
            '[%s] [Size: %s] [Cnt: %s] (KERNEL)' % \
            (title, size, convertNum(self.blockRdEventCnt)))

        SysMgr.printPipe(twoLine)
        SysMgr.printPipe("{0:_^9}|{1:_^144}".format("Usage", "Function"))
        SysMgr.printPipe(twoLine)

        # Print block read usage of stacks #
        for idx, value in sorted(self.kerSymData.items(),
            key=lambda e: e[1]['blockRdCnt'], reverse=True):

            if value['blockRdCnt'] == 0:
                break

            SysMgr.printPipe("{0:>8} |{1:^144}".\
                format(convertFunc(value['blockRdCnt'] << 9), idx))

            # Sort stacks by usage #
            value['stack'] = \
                sorted(value['stack'],
                key=lambda x: x[blkRdIndex], reverse=True)

            # Print stacks by symbol #
            for stack in value['stack']:
                blockRdCnt = stack[blkRdIndex]
                subStack = list(stack[subStackIndex])

                if blockRdCnt == 0:
                    continue

                if not subStack:
                    symbolStack = '\tNone'
                else:
                    indentLen = len("\t" * 4 * 4)
                    symbolStack = self.makeKernelSymList(subStack, indentLen)

                SysMgr.printPipe("\t+ {0:>8} |{1:32}".\
                    format(convertFunc(blockRdCnt << 9), symbolStack))

            SysMgr.printPipe(oneLine)

        SysMgr.printPipe('\n\n')





class LeakAnalyzer(object):
    """ Analyzer for leaktracing """

    # use SIGRT1 and SIGRT2 as default signals #
    startSig = 35
    stopSig = 36



    def __init__(self, file=None, pid=None):

        self.pid = pid
        self.posData = {}
        self.symData = {}
        self.fileData = {}
        self.callData = []
        self.totalLeakSize = long(0)

        self.init_posData = \
            {'offset': long(0), 'path': None, 'lastPosCnt': long(0),
                'callList': None, 'count': long(0), 'size': long(0),
                'lastPosSize': long(0), 'sym': '??'}

        self.init_symData = \
            {'offset': long(0), 'path': None, 'lastPosCnt': long(0),
                'substack': None, 'count': long(0), 'size': long(0),
                'lastPosSize': long(0)}

        self.init_fileData = \
            {'lastPosCnt': long(0), 'count': long(0),
                'size': long(0), 'lastPosSize': long(0)}

        # Get file size #
        try:
            stat = os.stat(file)
            size = UtilMgr.convSize2Unit(stat.st_size)
        except SystemExit:
            sys.exit(0)
        except:
            size = '??'

        # Open log file #
        try:
            SysMgr.printInfo(
                "start loading '%s' [%s]" % (file, size))

            fd = open(file, 'r')
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printOpenErr(file)
            sys.exit(0)

        SysMgr.printInfo("start processing data...")

        self.callData = self.parseLines(fd)

        # Get process object #
        try:
            proc = Debugger(pid=int(pid), attach=False)
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printErr(
                "fail to analyze leakage", True)

        SysMgr.printInfo("start resolving symbols...")

        # Resolve symbols #
        self.resolveSymbols(proc)

        SysMgr.printInfo("start merging symbols...")

        # Merge symbols #
        self.mergeSymbols()



    def printLeakage(self, runtime, profiletime):
        convert = UtilMgr.convSize2Unit

        try:
            mlist = SysMgr.getMemStat(self.pid)
            vssIdx = ConfigMgr.STATM_TYPE.index("TOTAL")
            vss = convert(long(mlist[vssIdx]) << 12)
            rssIdx = ConfigMgr.STATM_TYPE.index("RSS")
            rss = convert(long(mlist[rssIdx]) << 12)
        except:
            vss = rss = '?'

        proc = '%s(%s)' % (SysMgr.getComm(self.pid), self.pid)
        # function leakage info #
        title = 'Function Leakage Info'
        SysMgr.printPipe((
            '\n[%s] [Process: %s] [Runtime: %s] [ProfileTime: %s] '
            '[VSS: %s] [RSS: %s] [LeakSize: %s] [NrCall: %s]') % \
                (title, proc, runtime, profiletime, vss, rss,
                convert(self.totalLeakSize),
                convert(len(self.callData))))

        SysMgr.printPipe(twoLine)
        SysMgr.printPipe(
                "{0:^7} | {1:^7} | {2:^7} | {3:^122} |".\
                format("Size", "Count", "Avg", "Function"))
        SysMgr.printPipe(oneLine)

        count = long(0)
        for sym, val in sorted(self.symData.items(),
            key=lambda e: long(e[1]['lastPosSize']), reverse=True):
            if val['lastPosSize'] == 0:
                break

            SysMgr.printPipe(
                "{0:>7} | {1:>7} | {2:>7} | {3:<122} ".\
                    format(convert(val['lastPosSize']), convert(val['count']),
                    convert(long(val['lastPosSize'] / val['count'])),
                    '%s[%s]' % (sym, val['path'])))

            for substack, size in sorted(val['substack'].items(),
                key=lambda e: e[1], reverse=True):
                SysMgr.printPipe(
                    "{0:>7} | {1:>7} | {2:<132} ".\
                        format('', convert(size), substack))

            count += 1

            SysMgr.printPipe(oneLine)

        if count == 0:
            SysMgr.printPipe('\tNone\n%s' % oneLine)

        # file leakage info #
        title = 'File Leakage Info'
        SysMgr.printPipe((
            '\n[%s] [Process: %s] [Runtime: %s]  [ProfileTime: %s] '
            '[VSS: %s] [RSS: %s] [LeakSize: %s] [NrCall: %s]') % \
                (title, proc, runtime, profiletime, vss, rss,
                convert(self.totalLeakSize),
                convert(len(self.callData))))

        SysMgr.printPipe(twoLine)
        SysMgr.printPipe(
            "{0:^7} | {1:^7} | {2:^7} | {3:^122} |".format(
            "Size", "Count", "Avg", "Path"))
        SysMgr.printPipe(oneLine)

        count = long(0)
        for file, val in sorted(self.fileData.items(),
            key=lambda e: long(e[1]['lastPosSize']), reverse=True):
            if val['lastPosSize'] == 0:
                break

            SysMgr.printPipe(
                "{0:>7} | {1:>7} | {2:>7} | {3:<122} |".format(
                    convert(val['lastPosSize']), convert(val['count']),
                    convert(long(val['lastPosSize'] / val['count'])), file))

            count += 1

        if count == 0:
            SysMgr.printPipe('\tNone')
        SysMgr.printPipe(oneLine)

        if not SysMgr.showAll or not self.callData:
            return

        # leakage history #
        title = 'Leakage History'
        SysMgr.printPipe(
            '\n[%s] [Total: %s] [CallCount: %s]' % \
                (title, convert(self.totalLeakSize, True),
                    convert(len(self.callData), True)))

        SysMgr.printPipe(twoLine)
        SysMgr.printPipe(
            "{0:^16} | {1:^6} |{2:^50}| {3:^73} |".\
            format("Time", "Size", "Data", "Stack"))
        SysMgr.printPipe(oneLine)

        for time, items in sorted(self.callData.items(),
            key=lambda e: e[0], reverse=False):

            stack = list(items['symstack'])

            SysMgr.printPipe(
                "{0:>16} | {1:>6} |{2:50}| {3:<73} |".\
                    format(time,
                    convert(long(items['size'])),
                    items['data'][:-1], ' <- '.join(stack)))
            count += 1
        SysMgr.printPipe(oneLine)



    def mergeSymbols(self):
        cnt = long(0)
        total = len(self.posData)
        dobj = Debugger()
        for pos, val in self.posData.items():
            UtilMgr.printProgress(cnt, total)
            cnt += 1

            # merge by symbol #
            sym = val['sym']
            try:
                self.symData[sym]['count'] += val['count']
                self.symData[sym]['size'] += val['size']
                self.symData[sym]['lastPosCnt'] += val['lastPosCnt']
                self.symData[sym]['lastPosSize'] += val['lastPosSize']
            except SystemExit:
                sys.exit(0)
            except:
                self.symData[sym] = dict(self.init_symData)
                self.symData[sym]['offset'] = val['offset']
                self.symData[sym]['path'] = val['path']
                self.symData[sym]['count'] = val['count']
                self.symData[sym]['size'] = val['size']
                self.symData[sym]['lastPosCnt'] = val['lastPosCnt']
                self.symData[sym]['lastPosSize'] = val['lastPosSize']
                self.symData[sym]['substack'] = dict()

            if val['callList']:
                for time in list(val['callList'].keys()):
                    callinfo = self.callData[time]
                    substack = dobj.getBacktraceStr(callinfo['symstack'][1:])
                    dobj.btStr = None

                    try:
                        self.symData[sym]['substack'][substack] += \
                            long(callinfo['size'])
                    except:
                        self.symData[sym]['substack'][substack] = \
                            long(callinfo['size'])

            # merge by file #
            path = val['path']
            try:
                self.fileData[path]['count'] += val['count']
                self.fileData[path]['size'] += val['size']
                self.fileData[path]['lastPosCnt'] += val['lastPosCnt']
                self.fileData[path]['lastPosSize'] += val['lastPosSize']
            except SystemExit:
                sys.exit(0)
            except:
                self.fileData[path] = dict(self.init_fileData)
                self.fileData[path]['count'] = val['count']
                self.fileData[path]['size'] = val['size']
                self.fileData[path]['lastPosCnt'] = val['lastPosCnt']
                self.fileData[path]['lastPosSize'] = val['lastPosSize']

            self.totalLeakSize += val['lastPosSize']

        UtilMgr.deleteProgress()



    def resolveSymbols(self, proc):
        cnt = long(0)
        total = len(self.posData) + len(self.callData)

        # resolve all symbols #
        for pos, val in self.posData.items():
            UtilMgr.printProgress(cnt, total)
            cnt += 1

            try:
                ret = proc.getSymbolInfo(long(pos, 16))
            except:
                SysMgr.printWarn(
                    "fail to get symbol for %s" % pos, reason=True)
                continue

            if ret and len(ret) > 3:
                val['sym'] = ret[0]
                val['path'] = ret[1]
                val['offset'] = ret[2]

        # resolve symbols in stacks #
        for pos, val in self.callData.items():
            UtilMgr.printProgress(cnt, total)
            cnt += 1

            if not 'stack' in val:
                continue

            symstack = list(val['stack'])

            for idx, offset in enumerate(val['stack']):
                data = self.posData[offset]
                symstack[idx] = [data['offset'], data['sym'], data['path']]

            val['symstack'] = symstack

            try:
                posid = val['stack'][0]
                self.posData[posid]['callList'][pos] = None
            except:
                self.posData[posid]['callList'] = dict()
                self.posData[posid]['callList'][pos] = None

        UtilMgr.deleteProgress()



    def parseLines(self, fd):
        callinfo = {}

        while 1:
            try:
                line = fd.readline()
            except SystemExit:
                sys.exit(0)
            except:
                continue

            if not line:
                break

            # print progress #
            cur = fd.tell()
            total = os.fstat(fd.fileno()).st_size
            UtilMgr.printProgress(cur, total)

            items = line.split(', ')

            if items[0] != 'leak':
                continue

            time = None
            item = dict()

            for content in items[1:]:
                try:
                    name, body = content.split('=', 1)
                except SystemExit:
                    sys.exit(0)
                except:
                    continue

                if name == 'time':
                    time = body
                elif name == 'stack':
                    # split callstack #
                    item[name] = body.split()
                else:
                    item[name] = body

            if not item or \
                not 'size' in item or \
                not item['size'].isdigit():
                continue

            # save pos in common area #
            for pos in item['stack']:
                try:
                    self.posData[pos]['count'] += 1
                    self.posData[pos]['size'] += long(item['size'])
                except SystemExit:
                    sys.exit(0)
                except:
                    self.posData[pos] = dict(self.init_posData)
                    self.posData[pos]['count'] = 1
                    self.posData[pos]['size'] = long(item['size'])
                    self.posData[pos]['callList'] = dict()

            try:
                lastPos = item['stack'][0]
            except:
                continue

            self.posData[lastPos]['lastPosSize'] += long(item['size'])

            callinfo[time] = item

        UtilMgr.deleteProgress()

        return callinfo





class FileAnalyzer(object):
    """ Analyzer for file profiling """

    init_mapData = \
        {'offset': long(0), 'size': long(0), 'pageCnt': long(0),
        'fd': None, 'totalSize': long(0), 'fileMap': None, 'pids': None,
        'linkCnt': long(0), 'inode': None, 'accessTime': None,
        'devid': None, 'isRep': True, 'perm': None,
        'repFile': None, 'hardLink': long(1), 'linkList': None,
        'vstart': long(0), 'vend': long(0), 'elfInfo': None}



    def __init__(self):
        self.profSuccessCnt = long(0)
        self.profFailedCnt = long(0)
        self.profPageCnt = long(0)
        self.procData = {}
        self.fileData = {}
        self.inodeData = {}
        self.target = ['']

        self.procList = {}
        self.fileList = {}

        self.intervalProcData = []
        self.intervalFileData = []

        self.init_procData = \
            {'tids': None, 'pageCnt': long(0), 'procMap': None, 'comm': ''}
        self.init_threadData = {'comm': ''}
        self.init_inodeData = {}

        # handle no target case #
        if SysMgr.filterGroup:
            self.target = SysMgr.filterGroup

        if not SysMgr.guiderObj:
            # load libc #
            SysMgr.loadLibcObj(exit=True)

            # define mmap types #
            SysMgr.libcObj.mmap.argtypes = \
                [POINTER(None), c_size_t, c_int, c_int, c_int, c_long]
            SysMgr.libcObj.mmap.restype = POINTER(None)

            # define munmap types #
            SysMgr.libcObj.munmap.argtypes = \
                [POINTER(None), c_size_t]
            SysMgr.libcObj.munmap.restype = c_int

            # define mincore types #
            SysMgr.libcObj.mincore.argtypes = \
                [POINTER(None), c_size_t, POINTER(c_ubyte)]
            SysMgr.libcObj.mincore.restype = c_int

        # set system maximum fd number #
        SysMgr.setMaxFd()

        while 1:
            # scan proc directory and save map information of processes #
            self.scanProcs()

            # merge maps of processes into a integrated file map #
            self.mergeFileMapInfo()

            # get file map info on memory #
            self.getFilePageMaps()

            # fill file map of each processes #
            self.fillFileMaps()

            if SysMgr.intervalEnable > 0:
                # save previous file usage and initialize all variables #
                self.intervalProcData.append(self.procData)
                self.intervalFileData.append(self.fileData)
                self.procData = {}
                self.fileData = {}
                self.inodeData = {}
                self.profSuccessCnt = long(0)
                self.profFailedCnt = long(0)

                # check exit condition for interval profile #
                if not SysMgr.condExit:
                    SysMgr.waitEvent()
                else:
                    break
            else:
                break



    def __del__(self):
        pass



    def printIntervalInfo(self):
        # Merge process info into a global list #
        for procData in self.intervalProcData:
            for pid, procInfo in procData.items():
                try:
                    if self.procList[pid]['pageCnt'] < procInfo['pageCnt']:
                        self.procList[pid]['pageCnt'] = procInfo['pageCnt']
                except:
                    self.procList[pid] = dict(self.init_procData)
                    self.procList[pid]['tids'] = {}
                    self.procList[pid]['pageCnt'] = procInfo['pageCnt']
                    self.procList[pid]['comm'] = procInfo['comm']

                for tid, val in procInfo['tids'].items():
                    try:
                        self.procList[pid]['tids'][tid]
                    except:
                        self.procList[pid]['tids'][tid] = \
                            dict(self.init_threadData)
                        self.procList[pid]['tids'][tid]['comm'] = val['comm']

        if not self.procList:
            SysMgr.printErr('no process profiled')
            sys.exit(0)

        # Merge file info into a global list #
        for fileData in self.intervalFileData:
            for fileName, fileStat in fileData.items():
                try:
                    fl = self.fileList[fileName]
                    if fl['pageCnt'] < fileStat['pageCnt']:
                        fl['pageCnt'] = fileStat['pageCnt']
                except:
                    self.fileList[fileName] = dict(FileAnalyzer.init_mapData)
                    self.fileList[fileName]['pageCnt'] = fileStat['pageCnt']
                    self.fileList[fileName]['totalSize'] = fileStat['totalSize']

        if not self.fileList:
            SysMgr.printErr('no file profiled')
            sys.exit(0)

        SysMgr.printLogo(big=True)

        # Print system information #
        SysMgr.printInfoBuffer()

        # define alias #
        pageSize = SysMgr.pageSize
        convert = UtilMgr.convSize2Unit
        convColor = UtilMgr.convColor

        # Print process list #
        SysMgr.printPipe((
            "[%s] [ Process : %d ] [ LastRAM: %s ]"
            " [ Keys: Foward/Back/Save/Quit ] [ Capture: Ctrl+\\ ]") % \
                ('File Process Info', len(self.procList),
                convert(self.profPageCnt * 4 << 10)))
        SysMgr.printPipe(twoLine)
        SysMgr.printPipe(
            "{0:_^16}({1:_^6})|{2:_^12}|{3:_^16}({4:_^5}) |".\
            format("Process", "PID", "MaxRAM", "ThreadName", "TID"))
        SysMgr.printPipe(twoLine)

        procInfo = "{0:_^16}({1:^6})|{2:11} |".format('', '', '')
        threadInfo = " {0:^16}({1:^6}) |".format('', '')
        procLength = len(procInfo)
        threadLength = len(threadInfo)
        lineLength = SysMgr.lineLength

        for pid, val in sorted(self.procList.items(),
            key=lambda e: long(e[1]['pageCnt']), reverse=True):
            try:
                rsize = val['pageCnt'] * pageSize
            except:
                SysMgr.printWarn(
                    'fail to get total mapped size for %s' % val['comm'],
                    reason=True)
                continue

            if rsize > 0:
                rsize = convColor(convert(rsize), 'YELLOW', 11)

            printMsg = "{0:>16}({1:>6})|{2:>11} |".\
                format(val['comm'][:SysMgr.commLen], pid, rsize)
            linePos = len(printMsg)

            for tid, threadVal in sorted(val['tids'].items(), reverse=True):
                threadInfo = \
                    "{0:>16}({1:>6}) |".format(
                        threadVal['comm'][:SysMgr.commLen], tid)

                linePos += threadLength

                if linePos > lineLength:
                    linePos = procLength + threadLength
                    printMsg += "\n" + (' ' * (procLength - 1)) + '|'

                printMsg += threadInfo

            SysMgr.printPipe(printMsg)

        SysMgr.printPipe("%s\n\n" % oneLine)

        # Print file list #
        SysMgr.printPipe((
            "[%s] [ File: %d ] [ LastRAM: %s ] "
            "[ Keys: Foward/Back/Save/Quit ]") % \
                ('File Usage Info', len(self.fileList),
                convert(self.profPageCnt * 4 << 10)))
        SysMgr.printPipe(twoLine)

        printMsg = "{0:_^11}|{1:_^8}|{2:_^3}|".format(
            "InitRAM", "File", "%")

        if len(self.intervalFileData) > 1:
            for idx in range(1, len(self.intervalFileData)):
                printMsg += "{0:_^15}|".format(str(idx))

        printMsg += "{0:_^11}|{1:_^3}|".format("LastRAM", "%")

        lineLength = SysMgr.lineLength

        printMsg += '_' * (long((lineLength - len(printMsg)) / 2) - 2)
        printMsg += 'Library'
        printMsg += '_' * (lineLength - len(printMsg))

        SysMgr.printPipe(printMsg)

        SysMgr.printPipe(twoLine)

        # print interval usage #
        for fileName, val in sorted(self.fileList.items(),
            key=lambda e: long(e[1]['pageCnt']), reverse=True):
            try:
                memSize = \
                    self.intervalFileData[0][fileName]['pageCnt'] * pageSize
            except:
                memSize = long(0)

            try:
                idx = val['totalSize'] + pageSize - 1
                fileSize = long(idx / pageSize) * pageSize
            except:
                fileSize = long(0)

            # set percentage #
            if fileSize != 0:
                per = long(long(memSize) / float(fileSize) * 100)
                if per >= SysMgr.cpuPerHighThreshold:
                    per = UtilMgr.convColor(per, 'RED', 3)
                else:
                    per = UtilMgr.convColor(per, 'YELLOW', 3)
            else:
                per = long(0)

            if memSize > 0:
                memSize = convColor(convert(memSize), 'YELLOW', 10)

            # check whether this file was profiled or not #
            isRep = False
            for fileData in reversed(self.intervalFileData):
                if fileName in fileData and fileData[fileName]['isRep']:
                    printMsg = \
                        "{0:>10} |{1:>7} |{2:>3}|".format(
                            memSize, convert(fileSize), per)
                    isRep = True
                    break

            if not isRep:
                continue

            # calculate diff of on-memory file size #
            if len(self.intervalFileData) > 1:
                for idx in range(1, len(self.intervalFileData)):
                    diffNew = long(0)
                    diffDel = long(0)

                    try:
                        nowFileMap = \
                            self.intervalFileData[idx][fileName]['fileMap']
                    except:
                        nowFileMap = None
                    try:
                        prevFileMap = \
                            self.intervalFileData[idx - 1][fileName]['fileMap']
                    except:
                        prevFileMap = None

                    fileData = self.intervalFileData

                    if not nowFileMap:
                        if prevFileMap:
                            diffDel = fileData[idx - 1][fileName]['pageCnt']
                    else:
                        if not prevFileMap:
                            diffNew = fileData[idx][fileName]['pageCnt']
                        else:
                            if len(nowFileMap) == len(prevFileMap):
                                for i in range(len(nowFileMap)):
                                    if nowFileMap[i] > prevFileMap[i]:
                                        diffNew += 1
                                    elif nowFileMap[i] < prevFileMap[i]:
                                        diffDel += 1

                    if diffNew > 0:
                        diffNew = convColor(
                            convert(diffNew * pageSize), 'RED', 6)
                    else:
                        diffNew = ' '

                    if diffDel > 0:
                        diffDel = convColor(
                            convert(diffDel * pageSize), 'RED', 6)
                    else:
                        diffDel = ' '

                    printMsg += "+%6s/-%6s|" % (diffNew, diffDel)

            finalData = self.intervalFileData[-1][fileName]

            totalMemSize = finalData['pageCnt'] * pageSize

            if fileSize != 0:
                per = long(long(totalMemSize) / float(fileSize) * 100)
                if per >= SysMgr.cpuPerHighThreshold:
                    per = UtilMgr.convColor(per, 'RED', 3)
                else:
                    per = UtilMgr.convColor(per, 'YELLOW', 3)
            else:
                per = long(0)

            if totalMemSize > 0:
                totalMemSize = convColor(
                    convert(totalMemSize), 'YELLOW', 11)

            printMsg += \
                "{0:11}|{1:3}| {2:1}".format(totalMemSize, per, fileName)

            SysMgr.printPipe(printMsg)

        SysMgr.printPipe("%s\n\n\n" % oneLine)



    def makeReadaheadList(self):
        pass



    @staticmethod
    def getMapAddr(pid, fname, fd=None):
        if not fname:
            SysMgr.printWarn(
                "no memory-mapped file name to be searched")
            return

        if not fd:
            fd = FileAnalyzer.getMapFd(pid)
            if not fd:
                return None

        # read maps #
        fd.seek(0, 0)
        mapBuf = fd.readlines()
        for item in mapBuf:
            mdict = FileAnalyzer.parseMapLine(item)
            if mdict and mdict['binName']:
                if mdict['binName'].endswith(fname):
                    return str(mdict['startAddr']), str(mdict['endAddr'])
        return None



    @staticmethod
    def getMapFilePath(pid, fname, fd=None):
        if not fname:
            SysMgr.printWarn(
                "no file name to be searched on memory-map")
            return

        if not fd:
            fd = FileAnalyzer.getMapFd(pid)
            if not fd:
                return None

        # read maps #
        fd.seek(0, 0)
        mapBuf = fd.readlines()
        for item in mapBuf:
            mdict = FileAnalyzer.parseMapLine(item)
            if mdict and mdict['binName']:
                if os.path.basename(mdict['binName']).startswith(fname):
                    return str(mdict['binName'])
        return None



    @staticmethod
    def getEmptyMapAddr(pid, fd=None, size=0, onlyExec=False):
        if not fd:
            fd = FileAnalyzer.getMapFd(pid)
            if not fd:
                return None

        # search empty space #
        mapBuf = fd.readlines()
        for item in mapBuf:
            mdict = FileAnalyzer.parseMapLine(item)
            if not mdict:
                mapLine = item.split()
                addrs = \
                    list(map(lambda x: long(x, 16), mapLine[0].split('-')))
                perm = mapLine[1]
                if onlyExec and not 'x' in perm:
                    continue

                return addrs[0]



    @staticmethod
    def getMapFd(pid, verb=False):
        # open maps #
        try:
            path = '%s/%s/maps' % (SysMgr.procPath, pid)
            return open(path, 'r')
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printOpenWarn(path, verb)
            return None



    @staticmethod
    def getProcMapInfo(pid, fd=None, onlyExec=False, saveAll=False):
        if not fd:
            fd = FileAnalyzer.getMapFd(pid, True)
            if not fd:
                comm = SysMgr.getComm(pid)
                SysMgr.printErr(
                    'fail to get memory map for %s(%s)' % (comm, pid))
                sys.exit(0)

        # read maps #
        fd.seek(0, 0)
        mapBuf = fd.readlines()

        # parse and merge lines in maps #
        fileMap = dict()
        for val in mapBuf:
            FileAnalyzer.mergeMapLine(val, fileMap, saveAll=saveAll)

        # remove non-executable files #
        if onlyExec:
            for fname in list(fileMap.keys()):
                if fname != 'stack' and not fileMap[fname]['exec']:
                    fileMap.pop(fname, None)

        return fileMap



    @staticmethod
    def addMapLine(dataObj, fileName, newOffset, newSize):
        newEnd = newOffset + newSize

        try:
            savedOffset = dataObj[fileName]['offset']
            savedSize = dataObj[fileName]['size']
            savedEnd = savedOffset + savedSize

            # start address bigger than saved one #
            if savedOffset <= newOffset:
                # merge bigger end address than saved one #
                if savedEnd < newEnd:
                    dataObj[fileName]['size'] += \
                        (newEnd - savedOffset - savedSize)
                # ignore lesser end address than saved one #
                else:
                    pass
            # start address lesser than saved one #
            else:
                if savedEnd >= newEnd:
                    dataObj[fileName]['size'] += (savedOffset - newOffset)
                else:
                    dataObj[fileName]['size'] = newSize

                dataObj[fileName]['offset'] = newOffset
        except SystemExit:
            sys.exit(0)
        except:
            dataObj[fileName] = dict(FileAnalyzer.init_mapData)
            dataObj[fileName]['offset'] = newOffset
            dataObj[fileName]['size'] = newSize



    @staticmethod
    def parseMapLine(string):
        m = re.match((
            r'^(?P<startAddr>.\S+)-(?P<endAddr>.\S+) (?P<perm>.\S+) '
            r'(?P<offset>.\S+) (?P<devid>.\S+) (?P<inode>0|.\S+).\s*'
            r'(?P<binName>.+)'), string)
        if not m:
            return None

        return m.groupdict()



    @staticmethod
    def mergeMapLine(string, procMap, onlyExec=False, saveAll=False):
        d = FileAnalyzer.parseMapLine(string)
        if not d:
            return

        # get execution permission #
        if d['perm'][-2] == '-':
            isExec = False
        else:
            isExec = True

        # check execution permission #
        if onlyExec and not isExec:
            return

        fileName = d['binName']
        if fileName.startswith('['):
            fileName = fileName[1:-1]
        startAddr = long(d['startAddr'], 16)
        endAddr = long(d['endAddr'], 16)

        newOffset = long(d['offset'], 16)
        newSize = endAddr - startAddr

        # handle discontiguous segments #
        if fileName in procMap and \
            procMap[fileName]['vend'] != startAddr:
            cnt = 0
            while 1:
                newFileName = \
                    '%s%s%s' % (fileName, SysMgr.magicStr, cnt)

                # check next segment is contiguous with this line #
                if newFileName in procMap and \
                    procMap[newFileName]['vend'] != startAddr:
                    cnt += 1
                    continue
                else:
                    break

            fileName = newFileName

        # merge map line #
        FileAnalyzer.addMapLine(procMap, fileName, newOffset, newSize)

        # apply attributes #
        if saveAll:
            procMap[fileName]['perm'] = d['perm']
            procMap[fileName]['devid'] = d['devid']
            procMap[fileName]['inode'] = d['inode']
            procMap[fileName]['offset'] = d['offset']

        # set mapped addr #
        if procMap[fileName]['vstart'] == 0:
            procMap[fileName]['vstart'] = startAddr

        # set executable flag #
        if 'exec' not in procMap[fileName] or \
            not procMap[fileName]['exec']:
            procMap[fileName]['exec'] = isExec

        procMap[fileName]['vend'] = endAddr



    def printUsage(self):
        if not self.procData:
            SysMgr.printErr('no process profiled')
            sys.exit(0)
        if not self.fileData:
            SysMgr.printErr('no file profiled')
            sys.exit(0)

        SysMgr.printLogo(big=True)

        # print system information #
        SysMgr.printInfoBuffer()

        # define alias #
        convert = UtilMgr.convSize2Unit
        convColor = UtilMgr.convColor
        pageSize = SysMgr.pageSize

        # Print process list #
        SysMgr.printPipe((
            "[%s] [ Process : %d ] [ RAM: %s ]"
            "[ Keys: Foward/Back/Save/Quit ] [ Capture: Ctrl+\\ ]") % \
                ('File Process Info', len(self.procData),
                convert(self.profPageCnt * 4 << 10)))
        SysMgr.printPipe(twoLine)
        SysMgr.printPipe(
            "{0:_^16}({1:_^6})|{2:_^13}|{3:_^16}({4:_^6}) |".\
            format("Process", "PID", "RAM", "Thread", "TID"))
        SysMgr.printPipe(twoLine)

        procInfo = "{0:^16}({0:^6})|{0:12} |".format('')
        threadInfo = " {0:^16}({0:^6}) |".format('')
        procLength = len(procInfo)
        threadLength = len(threadInfo)
        lineLength = SysMgr.lineLength

        for pid, val in sorted(self.procData.items(),
            key=lambda e: long(e[1]['pageCnt']), reverse=True):
            try:
                rsize = val['pageCnt'] * pageSize
            except:
                SysMgr.printWarn(
                    'fail to get total mapped size for %s' % val['comm'],
                    reason=True)
                continue

            if rsize > 0:
                rsize = convColor(convert(rsize), 'YELLOW', 12)

            printMsg = "{0:>16}({1:>6})|{2:>12} |".\
                format(val['comm'][:SysMgr.commLen], pid, rsize)
            linePos = len(printMsg)

            for tid, threadVal in sorted(val['tids'].items(), reverse=True):
                threadInfo = \
                    "{0:^16}({1:>6}) |".format(
                        threadVal['comm'][:SysMgr.commLen], tid)

                linePos += threadLength

                if linePos > lineLength:
                    linePos = procLength + threadLength
                    printMsg += "\n" + (' ' * (procLength - 1)) + '|'

                printMsg += threadInfo

            SysMgr.printPipe(printMsg)

        SysMgr.printPipe("%s\n\n" % oneLine)

        # Print file list #
        SysMgr.printPipe(
            "[%s] [ File: %d ] [ RAM: %s ] [ Keys: Foward/Back/Save/Quit ]" % \
            ('File Usage Info', len(self.fileData),
            convert(self.profPageCnt * 4 << 10)))
        SysMgr.printPipe(twoLine)
        SysMgr.printPipe("{0:_^12}|{1:_^10}|{2:_^6}|{3:_^123}".\
            format("RAM", "File", "%", "Library & Process"))
        SysMgr.printPipe(twoLine)

        for fileName, val in sorted(self.fileData.items(),
            key=lambda e: long(e[1]['pageCnt']), reverse=True):
            memSize = val['pageCnt'] * pageSize

            idx = val['totalSize'] + pageSize - 1

            fileSize = long(idx / pageSize) * pageSize

            if fileSize != 0:
                per = long(long(memSize) / float(fileSize) * 100)
                if per >= SysMgr.cpuPerHighThreshold:
                    per = UtilMgr.convColor(per, 'RED', 5)
                else:
                    per = UtilMgr.convColor(per, 'YELLOW', 5)
            else:
                per = long(0)

            if memSize > 0:
                memSize = convColor(convert(memSize), 'YELLOW', 11)

            if not val['isRep']:
                continue
            else:
                SysMgr.printPipe((
                    "{0:>11} |{1:>9} |{2:>5} | {3:1} "
                    "[Proc: {4:1}] [Link: {5:1}]").\
                    format(memSize, convert(fileSize), per, fileName,
                    len(val['pids']), val['hardLink']))

            # prepare for printing process list #
            pidInfo = ''
            lineLength = SysMgr.lineLength
            pidLength = len(" %16s (%6s) |" % ('', ''))
            indentLength = len("{0:>11} |{1:>9} |{2:>5} ".format('','',''))
            linePos = indentLength + pidLength

            # print hard-linked list #
            if val['hardLink'] > 1:
                for fileLink, tmpVal in val['linkList'].items():
                    if fileName != fileLink:
                        SysMgr.printPipe(
                            (' ' * indentLength) + '| -> ' + fileLink)

            # print process list #
            for pid, comm in val['pids'].items():
                if linePos > lineLength:
                    linePos = indentLength + pidLength
                    pidInfo += '\n' + (' ' * indentLength) + '|'

                pidInfo += " %16s (%6s) |" % \
                    (comm[:SysMgr.commLen], pid)

                linePos += pidLength

            SysMgr.printPipe((' ' * indentLength) + '|' + pidInfo)
            SysMgr.printPipe(oneLine)

        SysMgr.printPipe('\n\n\n')



    def scanProcs(self):
        # get process list in proc filesystem #
        try:
            pids = os.listdir(SysMgr.procPath)
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printOpenErr(SysMgr.procPath)
            sys.exit(0)

        # scan comms include words in target list #
        for pid in pids:
            try:
                long(pid)
            except:
                continue

            # make path of comm #
            procPath = "%s/%s" % (SysMgr.procPath, pid)
            commPath = "%s/%s" % (procPath, 'comm')
            pidComm = ''

            # make comm path of process #
            try:
                self.procData[pid]['comm']
            except:
                try:
                    fd = open(commPath, 'r')
                    pidComm = fd.readline()
                    pidComm = pidComm[0:len(pidComm) - 1]
                    fd.close()
                except SystemExit:
                    sys.exit(0)
                except:
                    SysMgr.printOpenWarn(commPath)
                    continue

            # make path of tid #
            taskPath = "%s/%s" % (procPath, 'task')

            try:
                tids = os.listdir(taskPath)
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printOpenWarn(taskPath)
                continue

            # make thread list in process object #
            for tid in tids:
                try:
                    long(tid)
                except:
                    continue

                # make comm path of thread #
                threadPath = "%s/%s" % (taskPath, tid)
                commPath = "%s/%s" % (threadPath, 'comm')

                try:
                    fd = open(commPath, 'r')
                    comm = fd.readline()
                    comm = comm[0:len(comm) - 1]
                    fd.close()
                except SystemExit:
                    sys.exit(0)
                except:
                    SysMgr.printOpenWarn(commPath)
                    continue

                # save process info #
                for val in self.target:
                    if val in comm or tid == val:
                        # access procData #
                        try:
                            self.procData[pid]
                        except:
                            self.procData[pid] = dict(self.init_procData)
                            self.procData[pid]['tids'] = {}
                            self.procData[pid]['procMap'] = {}
                            self.procData[pid]['comm'] = pidComm

                            # make or update mapInfo per process #
                            self.procData[pid]['procMap'] = \
                                FileAnalyzer.getProcMapInfo(pid)

                        # access threadData #
                        try:
                            self.procData[pid]['tids'][tid]
                        except:
                            self.procData[pid]['tids'][tid] = \
                                dict(self.init_threadData)
                            self.procData[pid]['tids'][tid]['comm'] = comm



    def fillFileMaps(self):
        self.profPageCnt = long(0)

        for fileName, val in self.fileData.items():
            if val['fileMap'] and val['isRep']:
                val['pageCnt'] = val['fileMap'].count(1)
                self.profPageCnt += val['pageCnt']

        pageSize = SysMgr.pageSize
        for pid, val in self.procData.items():
            for fileName, mapInfo in val['procMap'].items():
                if not self.fileData[fileName]['fileMap'] or not mapInfo:
                    continue

                # convert address and size to index in mapping table #
                offset = mapInfo['offset'] - self.fileData[fileName]['offset']
                offset = \
                    long((offset + pageSize - 1) / pageSize)
                size = \
                    long((mapInfo['size'] + pageSize - 1) / pageSize)

                mapInfo['fileMap'] = \
                    list(self.fileData[fileName]['fileMap'][offset:size])
                mapInfo['pageCnt'] = mapInfo['fileMap'].count(1)
                val['pageCnt'] += mapInfo['pageCnt']



    def mergeFileMapInfo(self):
        for pid, val in self.procData.items():
            for fileName, scope in val['procMap'].items():
                newOffset = scope['offset']
                newSize = scope['size']

                # merge map line #
                FileAnalyzer.addMapLine(
                    self.fileData, fileName, newOffset, newSize)

                # add pid into file info #
                if not self.fileData[fileName]['pids']:
                    self.fileData[fileName]['pids'] = dict()
                if not pid in self.fileData[fileName]['pids']:
                    self.fileData[fileName]['pids'][pid] = val['comm']



    def getFilePageMaps(self):
        pageSize = SysMgr.pageSize
        self.profSuccessCnt = long(0)
        self.profFailedCnt = long(0)

        for fileName, val in self.fileData.items():
            if not fileName.startswith('/'):
                continue
            elif fileName.startswith('/dev'):
                SysMgr.printWarn(
                    "skip analyzing %s because it is device node" % fileName)
                continue

            if len(self.intervalFileData) > 0:
                # use file descriptor already saved as possible #
                try:
                    fileData = self.intervalFileData
                    fileInfo = \
                        fileData[len(self.intervalFileData) - 1][fileName]

                    val['fd'] = fileInfo['fd']

                    val['totalSize'] = fileInfo['totalSize']

                    val['isRep'] = fileInfo['isRep']
                except SystemExit:
                    sys.exit(0)
                except:
                    pass

                if not val['isRep']:
                    continue

            if not val['fd']:
                '''
                no fd related to this file
                case 1) no opened
                case 2) closed by mincore error
                case 3) closed because of rlimit
                '''

                try:
                    # check whether pages are on memory or not #
                    stat = os.stat(fileName)

                    devid = stat.st_dev
                    inode = stat.st_ino

                    # check whether this file was profiled or not #
                    if inode in self.inodeData:
                        found = False
                        repFile = ''
                        fileList = {}
                        procList = dict(val['pids'].items())

                        for fileIdx, fileDevid in self.inodeData[inode].items():
                            # this hard-lined file was already profiled #
                            if devid == fileDevid:
                                found = True

                                # add file into same file list #
                                fileList[fileName] = True
                                fileList[fileIdx] = True

                                # merge process list related to this file #
                                procList = \
                                    dict(procList.items() + \
                                    self.fileData[fileIdx]['pids'].items())

                                if self.fileData[fileIdx]['isRep']:
                                    repFile = fileIdx

                        if found:
                            self.inodeData[inode][fileName] = devid
                            self.fileData[fileName]['isRep'] = False
                            hardLinkCnt = len(fileList)

                            # set representative file #
                            for fileIdx, value in fileList.items():
                                self.fileData[fileIdx]['repFile'] = repFile
                                self.fileData[fileIdx]['hardLink'] = hardLinkCnt

                            # assign merged process list to representative file #
                            self.fileData[repFile]['pids'] = procList
                            self.fileData[repFile]['hardLink'] = hardLinkCnt

                            if self.fileData[repFile]['linkList']:
                                linkList = self.fileData[repFile]['linkList']
                                self.fileData[repFile]['linkList'] = \
                                    dict(linkList.items() + fileList.items())
                            else:
                                self.fileData[repFile]['linkList'] = fileList

                            continue
                        else:
                            self.inodeData[inode][fileName] = devid
                    else:
                        self.inodeData[inode] = dict(self.init_inodeData)
                        self.inodeData[inode][fileName] = devid

                    size = stat.st_size
                    linkCnt = stat.st_nlink
                    time = stat.st_atime

                    val['inode'] = inode
                    val['totalSize'] = size
                    val['linkCnt'] = linkCnt
                    val['accessTime'] = time

                    fd = open(fileName, "r")
                    val['fd'] = fd
                except SystemExit:
                    sys.exit(0)
                except:
                    self.profFailedCnt += 1
                    if SysMgr.warnEnable:
                        SysMgr.printOpenWarn(fileName)
                    continue

            # check file size whether it is readable or not #
            if val['totalSize'] <= 0:
                self.profFailedCnt += 1
                if SysMgr.warnEnable:
                    SysMgr.printWarn('fail to mmap %s' % fileName)
                continue

            # prepare variables for mincore syscall #
            fd = val['fd'].fileno()
            offset = val['offset']
            size = val['size']

            if SysMgr.guiderObj:
                # map a file to ram with PROT_NONE(0), MAP_SHARED(0x10) flags #
                mm = SysMgr.guiderObj.mmap(0, size, 0, 2, fd, offset) # pylint: disable=no-member

                # call mincore syscall by standard libc library #
                pagemap = SysMgr.guiderObj.mincore(mm, size) # pylint: disable=no-member

                # unmap #
                SysMgr.guiderObj.munmap(mm, size) # pylint: disable=no-member
            else:
                # get ctypes object #
                SysMgr.importPkgItems('ctypes')

                # map a file to ram with PROT_NONE(0), MAP_SHARED(0x10) flags #
                mm = SysMgr.libcObj.mmap(
                    POINTER(c_char)(), size, 0, 2, fd, offset)

                # get the size of the table to map file segment #
                tsize = long((size + pageSize - 1) / pageSize);

                # make a pagemap table #
                pagemap = (tsize * c_ubyte)()

                # call mincore syscall by standard libc library #
                ret = SysMgr.libcObj.mincore(
                    mm, size, cast(pagemap, POINTER(c_ubyte)))
                if ret < 0:
                    pagemap = None

                # unmap #
                SysMgr.libcObj.munmap(mm, size)

            # save the on-memory file page table #
            if pagemap:
                try:
                    if SysMgr.guiderObj:
                        val['fileMap'] = \
                            [ord(pagemap[i]) for i in \
                            range(long(size / pageSize))]
                    else:
                        val['fileMap'] = \
                            [pagemap[i] for i in range(long(size / pageSize))]

                    self.profSuccessCnt += 1

                    # fd resource is about to run out #
                    if SysMgr.maxKeepFd < fd:
                        val['fd'].close()
                        val['fd'] = None
                except SystemExit:
                    sys.exit(0)
                except:
                    SysMgr.printWarn('fail to access %s' % fileName)
                    val['fileMap'] = None
                    self.profFailedCnt += 1
            else:
                val['fd'].close()
                val['fd'] = None

        if len(self.fileData) > 0:
            SysMgr.printGood(
                'profiled a total of %d files' % self.profSuccessCnt)
        else:
            SysMgr.printErr('fail to profile files')
            sys.exit(0)

        if self.profFailedCnt > 0:
            SysMgr.printWarn(
                'fail to open a total of %d files' % self.profFailedCnt)





class LogMgr(object):
    """ Manager for error log """

    # define log level #
    LOG_EMERG     = 0
    LOG_ALERT     = 1
    LOG_CRIT      = 2
    LOG_ERR       = 3
    LOG_WARNING   = 4
    LOG_NOTICE    = 5
    LOG_INFO      = 6
    LOG_DEBUG     = 7

    # define syslog type #
    SYSLOG_ACTION_CLOSE = 0
    SYSLOG_ACTION_OPEN = 1
    SYSLOG_ACTION_READ = 2
    SYSLOG_ACTION_READ_ALL = 3
    SYSLOG_ACTION_READ_CLEAR = 4
    SYSLOG_ACTION_CLEAR = 5
    SYSLOG_ACTION_CONSOLE_OFF = 6
    SYSLOG_ACTION_CONSOLE_ON = 7
    SYSLOG_ACTION_CONSOLE_LEVEL = 8
    SYSLOG_ACTION_SIZE_UNREAD = 9
    SYSLOG_ACTION_SIZE_BUFFER = 10

    # define journal type #
    SD_JOURNAL_LOCAL_ONLY   = 1 << 0
    SD_JOURNAL_RUNTIME_ONLY = 1 << 1
    SD_JOURNAL_SYSTEM       = 1 << 2
    SD_JOURNAL_CURRENT_USER = 1 << 3
    SD_JOURNAL_OS_ROOT      = 1 << 4
    SD_JOURNAL_SYSTEM_ONLY = SD_JOURNAL_SYSTEM



    def __init__(self, target='error'):
        if target == 'error':
            self.terminal = sys.stderr
            self.notified = False
            self.error = False
        else:
            # backup #
            SysMgr.backupFile(target)

            # open #
            try:
                self.terminal = open(target, 'w')
                self.error = True
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printErr(
                    "fail to open %s" % target, True)



    def write(self, message):
        try:
            self.terminal.write(message)
            self.terminal.flush()
        except SystemExit:
            sys.exit(0)
        except:
            return

        if self.error:
            return

        # check cache dir #
        if not os.path.exists(SysMgr.cacheDirPath):
            try:
                os.makedirs(SysMgr.cacheDirPath)
            except SystemExit:
                sys.exit(0)
            except:
                err = SysMgr.getErrMsg()
                SysMgr.printWarn((
                    'fail to make %s directory because %s '
                    'so that use /tmp dir') % \
                        (SysMgr.cacheDirPath, err), True)
                SysMgr.cacheDirPath = '/tmp'

        # set file path for error log #
        errorFile = '%s/guider.err' % SysMgr.cacheDirPath
        if not SysMgr.isWritable(errorFile):
            SysMgr.printWarn((
                'fail to get write permission for %s '
                'so that use /tmp/guider.err') % errorFile, True)
            SysMgr.cacheDirPath = '/tmp'
            errorFile = '%s/guider.err' % SysMgr.cacheDirPath

        try:
            if not self.notified:
                SysMgr.printErr((
                    'please report %s file to '
                    'https://github.com/iipeace/guider/issues') % \
                        errorFile)
                self.notified = True

            with open(errorFile, 'a') as fd:
                SysMgr.writeErr(fd, message)
        except SystemExit:
            sys.exit(0)
        except:
            self.error = True
            SysMgr.printOpenErr(errorFile)



    def flush(self):
        pass



    def __getattr__(self, attr):
        return getattr(self.terminal, attr)



    @staticmethod
    def lock(fd):
        if not SysMgr.isLinux:
            return

        try:
            SysMgr.importPkgItems('fcntl')
            lockf(fd, LOCK_EX, 1, 0, 0)
        except SystemExit:
            sys.exit(0)
        except:
            name = fd.name if fd else 'logger'
            reason = SysMgr.getErrMsg()
            print('\n[ERROR] fail to get lock for %s because %s' % \
                (name, reason))



    @staticmethod
    def unlock(fd):
        if not SysMgr.isLinux:
            return

        try:
            SysMgr.importPkgItems('fcntl')
            lockf(fd, LOCK_UN, 1, 0, 0)
        except SystemExit:
            sys.exit(0)
        except:
            name = fd.name if fd else 'logger'
            reason = SysMgr.getErrMsg()
            print('\n[ERROR] fail to free lock for %s because %s' % \
                (name, reason))



    @staticmethod
    def printSyslog(console=False):
        # open syslog file #
        try:
            if not SysMgr.syslogFd:
                SysMgr.syslogFd = open(SysMgr.syslogPath, 'r')
        except:
            SysMgr.printOpenErr(SysMgr.syslogPath)
            sys.exit(0)

        SysMgr.printInfo(
            "start printing syslog... [ STOP(Ctrl+c) ]")

        # set file posiion #
        SysMgr.syslogFd.seek(0)

        while 1:
            log = SysMgr.syslogFd.readline()

            if not UtilMgr.isValidStr(log):
                continue

            if SysMgr.outPath and console:
                print(log)

            SysMgr.printPipe(log, newline=False)


    @staticmethod
    def printJournal(console=False):
       # get ctypes object #
        SysMgr.importPkgItems('ctypes')

        '''
        struct sd_journal {
                int toplevel_fd;

                char *path;
                char *prefix;
                char *namespace;

                OrderedHashmap *files;
                IteratedCache *files_cache;
                MMapCache *mmap;

                Location current_location;

                JournalFile *current_file;
                uint64_t current_field;

                Match *level0, *level1, *level2;

                pid_t original_pid;

                int inotify_fd;
                unsigned current_invalidate_counter, last_invalidate_counter;
                usec_t last_process_usec;
                unsigned generation;

                /* Iterating through unique fields and their data values */
                char *unique_field;
                JournalFile *unique_file;
                uint64_t unique_offset;

                /* Iterating through known fields */
                JournalFile *fields_file;
                uint64_t fields_offset;
                uint64_t fields_hash_table_index;
                char *fields_buffer;
                size_t fields_buffer_allocated;

                int flags;

                bool on_network:1;
                bool no_new_files:1;
                bool no_inotify:1;
                bool unique_file_lost:1; /* File we were iterating over got
                                            removed, and there were no more
                                            files, so sd_j_enumerate_unique
                                            will return a value equal to 0. */
                bool fields_file_lost:1;
                bool has_runtime_files:1;
                bool has_persistent_files:1;

                size_t data_threshold;

                Hashmap *directories_by_path;
                Hashmap *directories_by_wd;

                Hashmap *errors;
        };
        '''

        # load libsystemd library #
        try:
            if not SysMgr.systemdObj:
                SysMgr.systemdObj = SysMgr.loadLib(SysMgr.libsystemdPath)
                if not SysMgr.systemdObj:
                    raise Exception("no %s" % SysMgr.libsystemdPath)

            func = 'sd_journal_open'
            if not hasattr(SysMgr.systemdObj, func):
                raise Exception(
                    'no %s in %s' % (func, SysMgr.libsystemdPath))
        except:
            SysMgr.printErr(
                "fail to print journal", True)
            sys.exit(0)

        # define shortcut for object #
        systemdObj = SysMgr.systemdObj

        # open journal #
        jrl = c_void_p(0)
        flag = LogMgr.SD_JOURNAL_LOCAL_ONLY
        res = systemdObj.sd_journal_open(byref(jrl), c_int(flag))
        if res < 0:
            SysMgr.printErr(
                "fail to print journal because no journal")
            return

        SysMgr.printInfo(
            "start printing journal... [ STOP(Ctrl+c) ]")

        # set head #
        res = systemdObj.sd_journal_seek_head(jrl)
        if res < 0:
            SysMgr.printErr(
                "fail to print journal because no journal head")
            return

        # initialize variables #
        data = c_void_p(0)
        size = c_size_t(0)
        usec = c_uint64(0)
        timeout = c_uint64(10000)

        # set fields #
        if SysMgr.inputParam:
            fieldList = SysMgr.inputParam.split(',')
        else:
            fieldList = \
                [b"_TIME", b"_HOSTNAME", b"_TRANSPORT",
                    b"_COMM", b"_PID", b"MESSAGE"]

        # move to the end of journal #
        if not SysMgr.showAll:
            systemdObj.sd_journal_seek_tail(jrl)

        # define summary table #
        table = {}

        SysMgr.printPipe('\n')

        # start reading journal in loop #
        try:
            while 1:
                res = systemdObj.sd_journal_next(jrl)
                if res == 0:
                    ret = systemdObj.sd_journal_wait(jrl, timeout)
                    # SD_JOURNAL_NOP / SD_JOURNAL_APPEND / SD_JOURNAL_INVALID #
                    if ret == 0 or ret == 1 or ret == 2:
                        continue
                    elif ret < 0:
                        break
                elif res < 1:
                    break

                # traverse specific fields #
                if SysMgr.inputParam:
                    res = systemdObj.sd_journal_restart_data(jrl)
                    while 1:
                        res = systemdObj.sd_journal_enumerate_data(
                            jrl, byref(data), byref(size))
                        if res < 1:
                            break

                        SysMgr.printPipe(
                            cast(data, c_char_p).value.decode('latin-1'),
                            flush=True)
                    SysMgr.printPipe(flush=True)
                    continue

                # traverse all fields #
                jrlStr = b''
                for field in fieldList:
                    if field == b'_TIME':
                        # get time #
                        ret = systemdObj.sd_journal_get_realtime_usec(
                            jrl, byref(usec))
                        if ret < 0:
                            realtime = 0
                        else:
                            realtime = usec.value

                        wtime = time.strftime(
                            '%m %d %H:%M:%S ',
                                time.localtime(realtime / float(1000000)))
                        '''
                        ret = systemdObj.sd_journal_get_monotonic_usec(
                            jrl, byref(usec), boottime)
                        '''

                        # set time #
                        jrlStr += wtime.encode()

                        continue

                    res = systemdObj.sd_journal_get_data(
                        jrl, field, byref(data), byref(size))
                    if res < 0:
                        continue

                    val = cast(data, c_char_p).value[len(field)+1:]
                    if field == b"_COMM":
                        if SysMgr.outPath:
                            comm = val.decode('latin-1').rstrip('\x01')
                            table.setdefault(comm, 0)
                            table[comm] += 1
                    elif field == b"_PID":
                        val = b'[%s]: ' % val
                    elif field == b"_TRANSPORT" and val == b"kernel":
                        val += b': '
                    else:
                        val += b' '

                    jrlStr += val

                # print journal #
                if jrlStr:
                    try:
                        decstr = jrlStr.decode('latin-1')

                        if not UtilMgr.isValidStr(decstr):
                            raise Exception()

                        if SysMgr.outPath and console:
                            print(decstr)

                        SysMgr.printPipe(decstr, flush=True)
                    except SystemExit:
                        sys.exit(0)
                    except:
                        SysMgr.printPipe(jrlStr, flush=True)

            # close journal #
            systemdObj.sd_journal_close(jrl)
        except SystemExit:
            if not table:
                return

            SysMgr.printPipe(
                '\n[Journal Summary]\n%s\n' % twoLine)

            SysMgr.printPipe(
                '{0:>32} {1:>16}\n{2:1}'.format(
                    'COMM', 'COUNT', oneLine))

            total = 0
            for comm, count in sorted(table.items(),
                key=lambda x:x[1], reverse=True):
                SysMgr.printPipe(
                    '{0:>32} {1:>16}'.format(comm, UtilMgr.convNum(count)))
                total += count

            SysMgr.printPipe(
                '\n{0:>32} {1:>16}\n{2:1}'.format(
                    'TOTAL', UtilMgr.convNum(total), oneLine))



    @staticmethod
    def getKmsg(line=0):
        try:
            fd = os.open(SysMgr.kmsgPath, os.O_RDONLY | os.O_NONBLOCK)
        except:
            return None

        logs = list()
        while 1:
            try:
                data = os.read(fd, SysMgr.pageSize).decode()
                logs.append(data)
            except SystemExit:
                sys.exit(0)
            except:
                break

        # convert logs #
        retList = list()
        for log in logs[-line:]:
            # parse log #
            pos = log.find(';')

            meta = log[:pos].split(',')
            if len(meta) > 2:
                nrLevel = long(meta[0])
                try:
                    level = ConfigMgr.LOG_LEVEL[nrLevel]
                except:
                    level = nrLevel

                # time #
                ltime = str(meta[2])
                if len(ltime) < 7:
                    ltime = '0.%s' % ltime
                else:
                    ltime = '%s.%s' % (ltime[:-6], ltime[-6:])

                # name & log #
                log = log[pos + 1:]
                npos = log.find(':')
                name = log[:npos]
                if log[-1] == '\n':
                    log = log[npos + 1:-1]
                else:
                    log = log[npos + 1:]

                retList.append('[%s] (%s) %s: %s' % (ltime, level, name, log))

        return retList[-line:]



    @staticmethod
    def printKmsg(console=False):
        # open kmsg device node #
        try:
            if not SysMgr.kmsgFd:
                SysMgr.kmsgFd = open(SysMgr.kmsgPath, 'r')
        except:
            SysMgr.printOpenErr(SysMgr.kmsgPath)
            sys.exit(0)

        SysMgr.printInfo(
            "start printing kernel log... [ STOP(Ctrl+c) ]")

        # check device node #
        try:
            SysMgr.kmsgFd.readline()
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.kmsgFd = None

        # syslog #
        if not SysMgr.kmsgFd:
            # get ctypes object #
            SysMgr.importPkgItems('ctypes')

            # get kernel ring-buffer size #
            size = SysMgr.syscall(
                'syslog', LogMgr.SYSLOG_ACTION_SIZE_BUFFER, 0, 0)

            # allocate buffer #
            buf = (c_char*size)()

            ret = SysMgr.syscall(
                'syslog', LogMgr.SYSLOG_ACTION_READ_ALL, buf, size)
            if ret > 0:
                logBuf = memoryview(buf).tobytes().decode()
                for line in logBuf.split('\n'):
                    if not UtilMgr.isValidStr(line):
                        continue
                    SysMgr.printPipe(line)

            while 1:
                memset(buf, 0, size)
                ret = SysMgr.syscall(
                    'syslog', LogMgr.SYSLOG_ACTION_READ, buf, size)
                if ret < 1:
                    continue

                logBuf = memoryview(buf).tobytes().decode()
                if not UtilMgr.isValidStr(line):
                    continue

                if SysMgr.outPath and console:
                    print(logBuf)

                SysMgr.printPipe(logBuf)

            return

        # change file position #
        try:
            SysMgr.kmsgFd.seek(0)
        except:
            pass

        # kmsg node #
        while 1:
            jsonResult = dict()
            log = SysMgr.kmsgFd.readline()

            if not UtilMgr.isValidStr(log):
                continue

            # parse log #
            pos = log.find(';')

            meta = log[:pos].split(',')
            if len(meta) > 2:
                nrLevel = long(meta[0])
                try:
                    level = ConfigMgr.LOG_LEVEL[nrLevel]
                except:
                    level = nrLevel

                # time #
                ltime = str(meta[2])
                if len(ltime) < 7:
                    ltime = '0.%s' % ltime
                else:
                    ltime = '%s.%s' % (ltime[:-6], ltime[-6:])

                # name & log #
                log = log[pos + 1:]
                npos = log.find(':')
                name = log[:npos]
                if log[-1] == '\n':
                    log = log[npos + 1:-1]
                else:
                    log = log[npos + 1:]

                if SysMgr.jsonEnable:
                    jsonResult = \
                        dict(time=ltime, level=level, name=name, log=log)
                else:
                    if not SysMgr.outPath:
                        level = UtilMgr.convColor(level, 'BOLD')
                        name = UtilMgr.convColor(name, 'SPECIAL')
                        ltime = UtilMgr.convColor(ltime, 'GREEN')
                    log = '[%s] (%s) %s: %s' % (ltime, level, name, log)

            # apply filter #
            if SysMgr.filterGroup:
                found = False
                for string in SysMgr.filterGroup:
                    if string in log:
                        found = True
                        break

                if not found:
                    continue

            if SysMgr.jsonEnable:
                jsonResult = UtilMgr.convDict2Str(jsonResult)
                SysMgr.printPipe(jsonResult)
            else:
                if SysMgr.outPath and console:
                    print(log[:-1])

                SysMgr.printPipe(log[:-1])



    @staticmethod
    def doLogKmsg(msg=None, level=None):
        # open kmsg device node #
        try:
            if not SysMgr.kmsgFd:
                SysMgr.kmsgFd = open(SysMgr.kmsgPath, 'w')
        except:
            SysMgr.printOpenErr(SysMgr.kmsgPath)
            sys.exit(0)

        try:
            SysMgr.kmsgFd.write(msg)
            SysMgr.kmsgFd.flush()
        except:
            SysMgr.printWarn(
                "fail to write kmsg", reason=True)

        return 0



    @staticmethod
    def doLogSyslog(msg=None, level=None):
        if not msg:
            return

        # load libc #
        SysMgr.loadLibcObj(exit=True)

        if level is None:
            level = LogMgr.LOG_NOTICE

        SysMgr.libcObj.syslog(level, msg.encode())

        return 0



    @staticmethod
    def doLogJournal(msg=None, level=None):
        # get ctypes object #
        SysMgr.importPkgItems('ctypes')

        if not msg:
            return

        if level is None:
            level = LogMgr.LOG_NOTICE

        # load libsystemd library #
        try:
            if not SysMgr.systemdObj:
                SysMgr.systemdObj = SysMgr.loadLib(SysMgr.libsystemdPath)
                if not SysMgr.systemdObj:
                    raise Exception("no %s" % SysMgr.libsystemdPath)

            func = 'sd_journal_print'
            if not hasattr(SysMgr.systemdObj, func):
                raise Exception(
                    'no %s in %s' % (func, SysMgr.libsystemdPath))
        except:
            SysMgr.printErr(
                "fail to log journal", True)
            sys.exit(0)

        return SysMgr.systemdObj.sd_journal_print(level, msg.encode())





class SysMgr(object):
    """ Manager for system """

    arch = None
    origArgs = []
    kernelVersion = None
    isLinux = True
    isAndroid = False
    drawMode = False
    archOption = None

    # page size #
    try:
        pageSize = os.sysconf("SC_PAGE_SIZE")
    except:
        pageSize = 4096

    HZ = 250 # 4ms tick #
    try:
        if isLinux:
            TICK = os.sysconf(os.sysconf_names['SC_CLK_TCK'])
        else:
            TICK = long((1 / float(HZ)) * 1000)
    except:
        TICK = long((1 / float(HZ)) * 1000)

    startTime = long(0)
    startRunTime = long(0)
    blockSize = 512
    bufferSize = -1
    termGetId = None
    termSetId = None
    ttyRows = 43
    ttyRowsMargin = 2
    ttyCols = 156
    encoding = None
    encodeEnable = True
    encodeB64Enable = False
    remoteRun = False
    magicStr = '@@@@@'
    launchBuffer = ''
    lineLength = 154
    pid = long(0)
    comm = __module__
    commLen = 16
    masterPid = long(0)
    parentPid = long(0)
    prio = None
    funcDepth = long(0)
    maxPid = 32768
    maxRdCnt = 1024
    pidDigit = 5
    stdlog = None
    stderr = sys.stderr
    packetSize = 32767
    defaultPort = 5555
    bgProcList = None
    waitDelay = 0.5
    repeatInterval = long(0)
    repeatCount = long(0)
    progressCnt = long(0)
    wordSize = 4
    maxInterval = 0

    # threshold #
    cpuPerHighThreshold = 80
    cpuPerLowThreshold = 10
    memAvailPerThreshold = 10
    memHighThreshold = 1024
    memLowThreshold = 100
    swapPerThreshold = 90
    diskPerHighThreshold = 90

    # path #
    procPath = '/proc'
    imagePath = None
    mountPath = None
    mountCmd = None
    cgroupPath = None
    drawFormat = 'svg'
    debugfsPath = '/sys/kernel/debug'
    cacheDirPath = '/var/log/guider'
    outFilePath = 'guider.out'
    confFileName = 'guider.conf'
    cmdFileName = 'guider.cmd'
    tmpPath = '/tmp'
    kmsgPath = '/dev/kmsg'
    nullPath = '/dev/null'
    syslogPath = '/var/log/syslog'
    lmkPath = '/sys/module/lowmemorykiller/parameters/minfree'
    pythonPath = sys.executable
    pyLibPath = None
    objdumpPath = []
    rootPath = ''
    fontPath = None
    libdltPath = 'libdlt'
    libcPath = 'libc'
    libgobjPath = 'libgobject-2.0'
    libgioPath = 'libgio-2.0'
    libdbusPath = 'libdbus-1'
    libcppPath = 'libstdc++'
    libsystemdPath = 'libsystemd'
    libglesPath = 'libGLESv2'
    ldCachePath = '/etc/ld.so.cache'
    libdemanglePath = libcppPath
    environList = {}
    environ = {}
    eventLogPath = None
    inputFile = None
    outputFile = None
    inputParam = None
    outPath = None

    signalCmd = "trap 'kill $$' INT\nsleep 1d\n"
    saveCmd = None
    boundaryLine = None
    demangleEnable = True
    compressEnable = False
    generalInfoEnable = True
    nrTop = None
    pipeForPager = None
    printFd = None
    fileSuffix = None
    parsedAnalOption = False
    optionList = []
    customCmd = []
    userCmd = []
    kernelCmd = []
    udpListCache = None
    tcpListCache = None
    customEventList = []
    userEventList = []
    kernelEventList = []
    perfEventChannel = {}
    perfTargetEvent = []
    ignoreItemList = []
    idList = []
    perfEventData = {}
    commCache = {}
    commFdCache = {}
    fdCache = {}
    libCache = {}
    netAddrCache = {}
    cmdFileCache = {}
    cmdAttachCache = {}
    thresholdData = {}
    thresholdEventList = {}
    thresholdEventHistory = {}

    impPkg = {}
    impGlbPkg = {}
    skipImpPkg = {}
    exitFuncList = []
    dltObj = None
    dltCtx = None
    shmObj = None
    systemdObj = None
    libcObj = None
    libgioObj = None
    libdbusObj = None
    libgObj = None
    libglesObj = None
    statvfsObj = None
    guiderObj = None
    libcppObj = None
    libdemangleObj = None
    matplotlibVersion = long(0)
    matplotlibDpi = 500
    sigsetObj = None
    sigsetOldObj = None

    localServObj = None
    remoteServObj = None
    netlinkObj = None
    geAttr = [0] * 9
    addrListForPrint = {}
    addrListForReport = {}

    maxCore = long(0)
    nrCore = long(0)
    utilProc = long(0)
    logSize = long(0)
    kmsgLine = long(100)
    curLine = long(0)
    totalLine = long(0)
    dbgEventLine = long(0)
    uptime = long(0)
    prevUptime = long(0)
    uptimeDiff = long(0)
    diskStats = []
    prevDiskStats = []
    netstat = ''
    prevNetstat = ''
    loadavg = ''
    netInIndex = -1

    # log #
    printStreamEnable = False
    loggingEnable = False
    dltEnable = False
    kmsgEnable = False
    syslogEnable = False
    journalEnable = False
    terminalOver = False
    logoEnable = True
    colorEnable = True

    cpuAvgEnable = True
    reportEnable = False
    truncEnable = True
    countEnable = False
    reportObject = None
    reportFileEnable = False
    graphEnable = False
    procBuffer = []
    fixedProcList = {}
    topInstance = None
    procInstance = {}
    fileInstance = {}
    sysInstance = None
    procBufferSize = long(0)
    bufferOverflowed = False
    bufferString = ''
    bufferList = []
    bufferRows = long(0)
    systemInfoBuffer = ''
    kerSymTable = {}
    jsonData = {}
    nrTopRank = 10
    layout = None
    avgEnable = False

    showAll = False
    optStrace = False
    disableAll = False
    intervalNow = long(0)
    recordStatus = False
    bgStatus = False
    condExit = False
    sort = None
    sortCond = None

    # file descriptor #
    maxFd = 512
    maxKeepFd = maxFd - 16
    statFd = None
    memFd = None
    zoneFd = None
    lmkFd = None
    irqFd = None
    softirqFd = None
    vmstatFd = None
    swapFd = None
    uptimeFd = None
    netstatFd = None
    netdevFd = None
    shmFd = None
    msgqFd = None
    semFd = None
    loadavgFd = None
    cmdFd = None
    diskStatsFd = None
    mountFd = None
    nullFd = None
    eventLogFd = None
    kmsgFd = None
    syslogFd = None

    # flags #
    fixTargetEnable = False
    irqEnable = False
    cpuEnable = True
    cloneEnable = True
    execEnable = None
    latEnable = cpuEnable
    gpuEnable = True
    memEnable = False
    rssEnable = False
    pssEnable = False
    ussEnable = False
    vssEnable = False
    oomEnable = False
    leakEnable = False
    wssEnable = False
    diskEnable = False
    heapEnable = False
    floatEnable = False
    fileTopEnable = False
    dltTopEnable = False
    dbusTopEnable = False
    ueventEnable = False
    keventEnable = False
    networkEnable = False
    schedEnable = False
    delayEnable = False
    stackEnable = False
    wchanEnable = False
    sigHandlerEnable = False
    wfcEnable = False
    affinityEnable = False
    freeMemEnable = False
    blockEnable = False
    lockEnable = False
    userEnable = True
    userRecordEnable = True
    userEnableWarn = True
    printEnable = True
    bufferLossEnable = False
    jsonEnable = False
    powerEnable = False
    binderEnable = False
    wqEnable = False
    i2cEnable = False
    pipeEnable = False
    depEnable = False
    sysEnable = False
    waitEnable = False
    inWaitStatus = False
    cmdEnable = False
    perfEnable = False
    perfGroupEnable = False
    resetEnable = False
    warnEnable = False
    logEnable = True
    ttyEnable = False
    selectEnable = True
    cgroupEnable = False
    cgTopEnable = False
    cmdlineEnable = False
    schedstatEnable = True
    intervalEnable = long(0)
    forceEnable = False
    functionEnable = False
    systemEnable = False
    fileEnable = False
    threadEnable = False
    nsEnable = False
    termFlag = True
    exitFlag = False
    tgidEnable = True
    taskEnable = True
    exceptCommFilter = False
    processEnable = True
    totalEnable = False
    groupProcEnable = False
    rankProcEnable = True
    inotifyEnable = False
    dwarfEnable = False
    barGraphEnable = False

    # Elastic Stack #
    elasticEnable = False

    cmdList = {}
    rcmdList = {}
    savedProcTree = {}
    savedProcComm = {}
    savedMountTree = {}
    preemptGroup = []
    filterGroup = []
    schedFilter = []
    affinityFilter = []
    killFilter = []
    syscallList = []
    perCoreList = []
    perCoreDrawList = []
    childList = {}
    pidFilter = None



    def __init__(self):
        if not SysMgr.isLinux:
            return

        SysMgr.sysInstance = self

        self.cpuInfo = {}
        self.cpuCacheInfo = {}
        self.memInfo = {}
        self.devInfo = {}
        self.diskInfo = {}
        self.mountInfo = {}
        self.networkInfo = {}
        self.systemInfo = {}
        self.partitionInfo = {}

        self.cpuData = None
        self.gpuData = {}
        self.memData = {}
        self.diskData = {}
        self.storageData = {}
        self.prevStorageData = {}
        self.ipcData = {}
        self.prevIpcData = {}
        self.userData = {}
        self.mountData = None
        self.loadData = None
        self.nrMaxThread = 0
        self.cmdlineData = None
        self.osData = None
        self.devData = None
        self.procData = None
        self.macAddr = None
        self.uname = []
        self.openFileData = {}
        self.limitData = []

        # update starttime #
        SysMgr.updateUptime()
        if SysMgr.startTime == 0:
            SysMgr.startTime = \
                SysMgr.startRunTime = \
                    SysMgr.uptime

        # resource update time #
        self.netUpdate = None
        self.storageUpdate = None
        self.ipcUpdate = None

        # save system info first #
        self.saveSysStat(False)



    def __del__(self):
        pass



    @staticmethod
    def writeErr(fd, log):
        LogMgr.lock(fd)
        try:
            fd.write(log)
        except SystemExit:
            sys.exit(0)
        except:
            return
        LogMgr.unlock(fd)



    @staticmethod
    def setErrorLogger():
        if SysMgr.isLinux:
            sys.stderr = LogMgr()



    @staticmethod
    def getMaxPid():
        path = '%s/sys/kernel/pid_max' % SysMgr.procPath
        try:
            with open(path, 'r') as fd:
                maxPid = fd.readline()[:-1]

                # update pid length #
                if len(maxPid) > SysMgr.pidDigit:
                    SysMgr.pidDigit = len(maxPid)

                SysMgr.maxPid = long(maxPid)
        except SystemExit:
            sys.exit(0)
        except:
            pass



    @staticmethod
    def loadLibcObj(exit=False):
        if SysMgr.libcObj:
            return True

        try:
            ret = SysMgr.loadLib(SysMgr.libcPath)
            if ret:
                SysMgr.libcObj = ret
                return True
            else:
                SysMgr.printErr('fail to load libc')
                if exit:
                    sys.exit(0)
                else:
                    return False
        except SystemExit:
            sys.exit(0)
        except:
            return False



    @staticmethod
    def shrinkHeap():
        if not SysMgr.isLinux:
            return

        # load libc #
        if not SysMgr.loadLibcObj():
            return

        if not hasattr(SysMgr.libcObj, 'malloc_trim'):
            SysMgr.printWarn(
                'no malloc_trim in %s' % SysMgr.libcPath)
            return

        # int malloc_trim (size_t pad) #
        SysMgr.libcObj.malloc_trim(0)



    @staticmethod
    def doLogMode(mode):
        if mode.upper() == 'KMSG':
            func = LogMgr.doLogKmsg
            mtype = 'kernel'
        elif mode.upper() == 'DLT':
            func = DltAnalyzer.doLogDlt
            mtype = 'DLT'
        elif mode.upper() == 'JOURNAL':
            func = LogMgr.doLogJournal
            mtype = 'journal'
        elif mode.upper() == 'SYSLOG':
            func = LogMgr.doLogSyslog
            mtype = 'syslog'

        SysMgr.printLogo(big=True, onlyFile=True)

        # get message #
        if SysMgr.hasMainArg():
            msg = SysMgr.getMainArg()
        elif SysMgr.inputParam:
            msg = SysMgr.inputParam
        else:
            SysMgr.printErr("no input message for %s" % mtype)
            sys.exit(0)

        # set alarm #
        if SysMgr.intervalEnable:
            signal.signal(signal.SIGALRM, SysMgr.onAlarm)
            signal.alarm(SysMgr.intervalEnable)

        while 1:
            ret = func(msg=msg)
            if ret == 0:
                SysMgr.printInfo(
                    "logged a %s message '%s' successfully" % (mtype, msg))
            else:
                SysMgr.printErr(
                    "fail to log a %s message" % mtype)
                break

            if SysMgr.intervalEnable:
                SysMgr.waitEvent(forceExit=True)
            else:
                os._exit(0)



    @staticmethod
    def setMaxFd():
        if not SysMgr.isLinux:
            return

        '''
        maxFdPath = '%s/sys/fs/file-max' % SysMgr.procPath
        try:
            with open(maxFdPath, 'r') as fd:
                availMaxFd = long(fd.read())
        except:
            availMaxFd = SysMgr.maxFd

        if availMaxFd == SysMgr.maxFd:
            return
        '''

        # try to set maxFd with hard limit #
        try:
            resource = SysMgr.getPkg('resource', False, True)
            if resource:
                resource.setrlimit(resource.RLIMIT_NOFILE, (1048576, 1048576))
                soft, hard = resource.getrlimit(resource.RLIMIT_NOFILE)
                SysMgr.maxFd = hard
                SysMgr.maxKeepFd = SysMgr.maxFd - 16
                return
        except SystemExit:
            sys.exit(0)
        except:
            pass

        # try to get maxFd by native call #
        try:
            func = SysMgr.guiderObj.getrlimit # pylint: disable=no-member
            SysMgr.maxFd = \
                func(ConfigMgr.RLIMIT_TYPE.index('RLIMIT_NOFILE'))
            SysMgr.maxKeepFd = SysMgr.maxFd - 16
            return
        except SystemExit:
            sys.exit(0)
        except:
            pass

        # get ctypes object #
        if not SysMgr.importPkgItems('ctypes', False):
            return

        class rlimit(Structure):
            _fields_ = (
                ("rlim_cur", c_ulong),
                ("rlim_max", c_ulong),
            )

        # try to get maxFd by standard library call #
        try:
            # load libc #
            SysMgr.loadLibcObj()

            SysMgr.libcObj.getrlimit.argtypes = (c_int, POINTER(rlimit))
            SysMgr.libcObj.getrlimit.restype = c_int

            rlim = rlimit()
            rlim.rlim_cur = c_ulong(1048576)
            rlim.rlim_max = c_ulong(1048576)

            ret = SysMgr.libcObj.setrlimit(
                ConfigMgr.RLIMIT_TYPE.index('RLIMIT_NOFILE'), byref(rlim))

            ret = SysMgr.libcObj.getrlimit(
                ConfigMgr.RLIMIT_TYPE.index('RLIMIT_NOFILE'), byref(rlim))

            SysMgr.maxFd = rlim.rlim_cur
            SysMgr.maxKeepFd = SysMgr.maxFd - 16
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printWarn(
                "fail to get the maximum file descriptor", reason=True)



    @staticmethod
    def setReportAttr():
        # get argument #
        if SysMgr.hasMainArg():
            SysMgr.inputFile = SysMgr.getMainArg()
        elif SysMgr.inputParam:
            SysMgr.inputFile = SysMgr.inputParam
        else:
            SysMgr.inputFile = 'guider.dat'

        if not SysMgr.outPath:
            SysMgr.outPath = \
                '%s.out' % os.path.splitext(SysMgr.inputFile)[0]



    @staticmethod
    def execSystemView():
        # parse all options and make output file path #
        SysMgr.parseAnalOption()

        SysMgr.printStat(
            r'start recording... [ STOP(Ctrl+c), MARK(Ctrl+\) ]')

        # wait for user input #
        SysMgr.waitEvent()

        # save system info #
        SysMgr.sysInstance.saveSysStat()

        # get and remove process tree from data file #
        SysMgr.getProcTreeInfo()

        SysMgr.printLogo(big=True)

        # print system information #
        SysMgr.printPipe(SysMgr.systemInfoBuffer)



    @staticmethod
    def setRecordAttr():
        # function #
        if SysMgr.checkMode('funcrec'):
            SysMgr.functionEnable = True

        # file #
        elif SysMgr.checkMode('filerec'):
            SysMgr.fileEnable = True

        # syscall #
        elif SysMgr.checkMode('sysrec'):
            SysMgr.sysEnable = True
            SysMgr.cpuEnable = False

        # general #
        elif SysMgr.checkMode('genrec'):
            SysMgr.systemEnable = True

        # update record status #
        SysMgr.recordStatus = True
        SysMgr.inputFile = '/sys/kernel/debug/tracing/trace'

        # change priority for process #
        if not SysMgr.prio:
            SysMgr.setPriority(SysMgr.pid, 'C', -20)

        SysMgr.parseRecordOption()
        SysMgr.printProfileOption()
        SysMgr.printProfileCmd()



    @staticmethod
    def getFd(fname, perm='rb'):
        if fname in SysMgr.fdCache and \
            SysMgr.fdCache[fname]['perm'] == perm:
            return SysMgr.fdCache[fname]['fd']

        try:
            SysMgr.fdCache[fname] = {
                'fd': open(fname, perm),
                'perm': perm,
            }
            return SysMgr.fdCache[fname]['fd']
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printOpenErr(fname)
            return None



    @staticmethod
    def setVisualAttr():
        # set default input path #
        if len(sys.argv) <= 2:
            sys.argv.insert(2, SysMgr.outFilePath)

        SysMgr.graphEnable = True

        # ignore user warning #
        SysMgr.ignoreWarn()

        # apply regular expression for first path #
        flist = UtilMgr.convPath(sys.argv[2])
        if type(flist) is list and len(flist) > 0:
            sys.argv = sys.argv[:2] + flist + sys.argv[3:]

        # thread draw mode #
        if TaskAnalyzer.getInitTime(sys.argv[2]) > 0:
            # apply launch option #
            SysMgr.applyLaunchOption()

            # check data type #
            if SysMgr.isThreadMode():
                pass
            elif SysMgr.isFuncMode():
                SysMgr.printErr(
                    "fail to draw because this data is for function")
                sys.exit(0)
            else:
                SysMgr.printErr(
                    "fail to draw because this data is not supported")
                sys.exit(0)

            SysMgr.inputFile = sys.argv[1] = sys.argv[2]
            SysMgr.intervalEnable = 1
            if not SysMgr.outPath:
                SysMgr.outPath = \
                    '%s.out' % os.path.splitext(SysMgr.inputFile)[0]
            del sys.argv[2]
        # top draw mode #
        else:
            # CPU #
            if SysMgr.checkMode('drawcpu') or \
                SysMgr.checkMode('drawcpuavg'):
                SysMgr.layout = 'CPU'
            # delay #
            elif SysMgr.checkMode('drawdelay'):
                SysMgr.layout = 'DELAY'
            # memory #
            elif SysMgr.checkMode('drawmem') or \
                SysMgr.checkMode('drawmemavg'):
                SysMgr.layout = 'MEM'
            # VSS #
            elif SysMgr.checkMode('drawvss') or \
                SysMgr.checkMode('drawvssavg'):
                SysMgr.layout = 'MEM'
                SysMgr.vssEnable = True
            # RSS #
            elif SysMgr.checkMode('drawrss') or \
                SysMgr.checkMode('drawrssavg'):
                SysMgr.layout = 'MEM'
                SysMgr.rssEnable = True
            # leak #
            elif SysMgr.checkMode('drawleak'):
                SysMgr.layout = 'MEM'
                SysMgr.leakEnable = True
            # I/O #
            elif SysMgr.checkMode('drawio'):
                SysMgr.layout = 'IO'

            # average #
            if SysMgr.isDrawAvgMode():
                SysMgr.avgEnable = True

            # modify args for drawing multiple input files #
            sys.argv[1] = 'top'
            args = sys.argv[2:]
            SysMgr.inputParam = UtilMgr.getFileList(args)



    @staticmethod
    def execFileAnalysis():
        SysMgr.checkRootPerm()

        # parse analysis option #
        SysMgr.parseAnalOption()

        SysMgr.printStat(
            r'start analyzing... [ STOP(Ctrl+c), MARK(Ctrl+\) ]')

        # start analyzing files #
        try:
            pi = FileAnalyzer()
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printErr(
                "fail to analyze memory-mapped files", reason=True)
            sys.exit(0)

        # save system info #
        SysMgr.sysInstance.saveSysStat()

        # get and remove process tree from data file #
        SysMgr.getProcTreeInfo()

        if SysMgr.intervalEnable == 0:
            # print total file usage per process #
            pi.printUsage()
        else:
            # print file usage per process on timeline #
            pi.printIntervalInfo()



    @staticmethod
    def execRecordLoop():
        while SysMgr.repeatInterval > 0:
            # set alarm #
            signal.alarm(SysMgr.repeatInterval)

            # get init time in buffer for verification #
            initTime = TaskAnalyzer.getInitTime(SysMgr.inputFile)

            # wait for timer #
            try:
                for cnt in range(0, SysMgr.repeatInterval):
                    UtilMgr.printProgress(cnt, SysMgr.repeatInterval)
                    time.sleep(1)
            except SystemExit:
                sys.exit(0)
            except:
                pass

            # real-time copy from pipe to file #
            if SysMgr.pipeEnable:
                if SysMgr.outputFile:
                    SysMgr.copyPipeToFile(
                        '%s%s' % (SysMgr.inputFile, '_pipe'),
                        SysMgr.outputFile)
                else:
                    SysMgr.printErr(
                        "wrong option used, "
                        "use also -s option to save data")

                sys.exit(0)

            # check counter #
            if SysMgr.repeatCount <= SysMgr.progressCnt and \
                SysMgr.termFlag:
                sys.exit(0)

            # compare init time with now time for buffer verification #
            if initTime < TaskAnalyzer.getInitTime(SysMgr.inputFile):
                SysMgr.printErr(
                    "buffer size is not enough (%sKB)" % \
                    SysMgr.getBufferSize())
                sys.exit(0)
            else:
                SysMgr.clearTraceBuffer()

        # start writing logs to file through pipe #
        if SysMgr.pipeEnable:
            if SysMgr.outputFile:
                pipePath = '%s%s' % (SysMgr.inputFile, '_pipe')
                SysMgr.copyPipeToFile(pipePath, SysMgr.outputFile)
            else:
                SysMgr.printErr(
                    "wrong option used, use also -s option to save data")

            sys.exit(0)

        if not SysMgr.graphEnable:
            # get init time from buffer for verification #
            initTime = TaskAnalyzer.getInitTime(SysMgr.inputFile)

        # wait for user input #
        while 1:
            if SysMgr.recordStatus:
                SysMgr.condExit = True

                SysMgr.waitEvent()
                if SysMgr.condExit:
                    break
            else:
                break

        if not SysMgr.graphEnable:
            # compare init time with now time for buffer verification #
            if initTime < TaskAnalyzer.getInitTime(SysMgr.inputFile):
                SysMgr.printErr("buffer size %sKB is not enough" % \
                    SysMgr.getBufferSize())
                sys.exit(0)

            # save system info #
            SysMgr.sysInstance.saveSysStat()



    @staticmethod
    def execTopCmd():
        # check background processes #
        SysMgr.checkBgProcs()

        # set tty setting automatically #
        if not SysMgr.ttyEnable:
            SysMgr.setTTYAuto(True, False)

        # write user command #
        SysMgr.writeTraceCmd('BEFORE')

        # thread #
        if SysMgr.checkMode('ttop'):
            SysMgr.processEnable = False

        # file #
        elif SysMgr.checkMode('ftop'):
            SysMgr.fileTopEnable = True

        # cgroup #
        elif SysMgr.checkMode('cgtop'):
            SysMgr.cgTopEnable = True

        # stack #
        elif SysMgr.checkMode('stacktop'):
            if SysMgr.checkStackTopCond():
                SysMgr.processEnable = False
                SysMgr.stackEnable = True
            else:
                sys.exit(0)

        # perf #
        elif SysMgr.checkMode('ptop'):
            if SysMgr.checkPerfTopCond():
                SysMgr.perfEnable = True
                if SysMgr.findOption('g'):
                    SysMgr.processEnable = False
                    SysMgr.perfGroupEnable = True
            else:
                sys.exit(0)

        # mem #
        elif SysMgr.checkMode('mtop'):
            if SysMgr.checkMemTopCond():
                SysMgr.memEnable = True
                SysMgr.sort = 'm'
            else:
                sys.exit(0)

        # WSS (working set size) #
        elif SysMgr.checkMode('wtop'):
            if SysMgr.checkWssTopCond():
                SysMgr.memEnable = True
                SysMgr.wssEnable = True
                SysMgr.sort = 'm'
            else:
                sys.exit(0)

        # disk #
        elif SysMgr.checkMode('disktop'):
            if SysMgr.checkDiskTopCond():
                SysMgr.diskEnable = True
                SysMgr.blockEnable = True
                SysMgr.sort = 'b'
            else:
                sys.exit(0)

        # all #
        elif SysMgr.checkMode('atop'):
            SysMgr.cpuEnable = True
            SysMgr.memEnable = True
            SysMgr.irqEnable = True
            SysMgr.diskEnable = True
            SysMgr.networkEnable = True

            if SysMgr.isRoot():
                SysMgr.blockEnable = True
                SysMgr.perfEnable = True
            else:
                SysMgr.printWarn(
                    'block stat is disabled because of no root permission')

        # condition #
        elif SysMgr.checkMode('ctop'):
            # check path for config file #
            if not SysMgr.getOption('C'):
                if not SysMgr.loadConfig(SysMgr.confFileName):
                    SysMgr.printErr(
                        'input effective file path for config')
                    sys.exit(0)

            # ignore output #
            if not SysMgr.outPath:
                SysMgr.outPath = SysMgr.nullPath
                SysMgr.bufferSize = -1

        # DLT #
        elif SysMgr.checkMode('dlttop'):
            SysMgr.dltTopEnable = True

        # D-Bus #
        elif SysMgr.checkMode('dbustop'):
            SysMgr.dbusTopEnable = True
            SysMgr.floatEnable = True

            # set default interval to 3 for performance #
            if not SysMgr.findOption('i') and \
                not SysMgr.findOption('R'):
                SysMgr.intervalEnable = 3

        # usercall #
        elif SysMgr.checkMode('utop'):
            SysMgr.doTrace('usercall')

        # pycall #
        elif SysMgr.checkMode('pytop'):
            SysMgr.doTrace('pycall')

        # breakcall #
        elif SysMgr.checkMode('btop'):
            SysMgr.doTrace('breakcall')

        # syscall #
        elif SysMgr.checkMode('systop'):
            SysMgr.doTrace('syscall')

        # network #
        elif SysMgr.checkMode('ntop'):
            SysMgr.networkEnable = True

        # background #
        elif SysMgr.checkMode('bgtop'):
            if not SysMgr.checkBgTopCond():
                sys.exit(0)

            if SysMgr.isRoot():
                SysMgr.blockEnable = True
            else:
                SysMgr.printWarn(
                    'block stat is disabled because of no root permission')

            SysMgr.diskEnable = True
            SysMgr.networkEnable = True

            SysMgr.runBackgroundMode()

        # report #
        elif SysMgr.checkMode('rtop'):
            SysMgr.jsonEnable = True

            if SysMgr.isRoot():
                SysMgr.diskEnable = True
                SysMgr.networkEnable = True

                disableList = SysMgr.getOption('d')
                if disableList:
                    if 'd' in disableList:
                        SysMgr.diskEnable = False
                    if 'n' in disableList:
                        SysMgr.networkEnable = False
            else:
                SysMgr.printWarn(
                    "fail to get stats for disk and network "
                    "because of no root permission")

            if not SysMgr.checkRepTopCond():
                sys.exit(0)

        # print profile option #
        if not SysMgr.isDrawMode():
            SysMgr.printProfileOption()
            SysMgr.printProfileCmd()

        # set handler for exit #
        SysMgr.setNormalSignal()

        # run process / file monitoring #
        TaskAnalyzer()



    @staticmethod
    def loadLibCache():
        try:
            if not os.path.exists(SysMgr.ldCachePath):
                raise Exception("no %s" % SysMgr.ldCachePath)

            libDict = {}
            libList = UtilMgr.convBin2Str(SysMgr.ldCachePath)
            for idx, item in enumerate(libList):
                try:
                    if libList[idx+1].startswith('/'):
                        value = libList[idx+1]
                        libDict.setdefault(item, list())
                        libDict[item].append(value)
                except SystemExit:
                    sys.exit(0)
                except:
                    pass

            SysMgr.libCache = libDict
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printWarn('fail to load library cache', reason=True)
            return False



    @staticmethod
    def findLib(lib, inc=False):
        if not SysMgr.libCache:
            SysMgr.loadLibCache()

        for key, val in SysMgr.libCache.items():
            if not key.startswith(lib):
                continue

            if inc and key.startswith(lib):
                return val

            if (key[len(lib)] == '.' or key[len(lib)] == '-'):
                if len(val) > 1:
                    SysMgr.printWarn(
                        'multiple libraries [ %s ] exist for %s' % \
                            (', '.join(val), key))

                return val

        return None



    @staticmethod
    def getPrintFlag():
        if 'QUIET' in SysMgr.environList:
            return False
        else:
            return True



    @staticmethod
    def loadLib(lib, path=False):
        if not SysMgr.importPkgItems('ctypes', False):
            return

        # absolute path #
        if path:
            return CDLL(lib)

        target = SysMgr.findLib(lib)
        if not target:
            target = ['%s.so' % lib]
            ret = FileAnalyzer.getMapFilePath(SysMgr.pid, lib)
            if ret:
                target.append(ret)

        for item in target:
            try:
                res = cdll.LoadLibrary(item)
                if res:
                    return res
            except SystemExit:
                sys.exit(0)
            except:
                pass



    @staticmethod
    def importNative():
        try:
            # do not use native library to improve initialization time #
            raise Exception

            import guider
            guider.check() # pylint: disable=no-member
            SysMgr.guiderObj = guider
        except:
            pass



    @staticmethod
    def applyKillVal(value):
        if not value:
            SysMgr.printErr("no value to send signal")
            sys.exit(0)

        SysMgr.checkRootPerm()

        jobs = value.split(',')
        for job in jobs:
            try:
                value = job.split(':')

                if len(value) > 3:
                    raise Exception("wrong input")

                # set task #
                tid = value[0]

                # set signal #
                if len(value) == 1:
                    sig = signal.SIGKILL
                else:
                    sig = SysMgr.getSigNum(value[1])
                    if not sig:
                        raise Exception("wrong signal %s" % value[1])

                if len(value) > 2 and value[2].upper() == 'CONT':
                    flag = 'CONT'
                else:
                    flag = 'ONCE'

                SysMgr.killFilter.append([tid, sig, flag])
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printErr(
                    "fail to set signal", True)
                sys.exit(0)



    @staticmethod
    def parseAffinityOption(jobs, launch=False):
        if not jobs:
            SysMgr.printErr("wrong option value")
            sys.exit(0)

        for origVal in jobs:
            try:
                value = origVal.split(':')

                if len(value) < 2 or len(value) > 3:
                    raise Exception("wrong input")

                # set task #
                tid = value[0]
                if tid == '':
                    tid = str(SysMgr.pid)

                # set mask #
                mask = value[1]
                if not mask:
                    raise Exception('wrong input')

                if launch:
                    sibling = SysMgr.groupProcEnable
                    targetList = SysMgr.getPids(tid, sibling=sibling)
                    targetList = list(map(long, targetList))
                    if targetList:
                        SysMgr.setAffinity(mask, targetList)
                    else:
                        SysMgr.printWarn(
                            "no thread related to '%s'" % tid)

                if len(value) == 3 and value[2].upper() == 'CONT':
                    flag = 'CONT'
                else:
                    flag = 'ONCE'

                SysMgr.affinityFilter.append([tid, mask, flag])
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printErr(
                    "wrong option value '%s'" % origVal, True)
                sys.exit(0)



    @staticmethod
    def doDump():
        # get argument #
        if SysMgr.hasMainArg():
            inputParam = SysMgr.getMainArg()
        elif SysMgr.inputParam:
            inputParam = SysMgr.inputParam
        else:
            SysMgr.printErr("no input for COMM or PID")
            sys.exit(0)

        if not inputParam:
            SysMgr.printErr("no input for memory info")
            sys.exit(0)
        elif not SysMgr.outPath:
            SysMgr.printErr("no input for path")
            sys.exit(0)

        # convert comm to pid #
        targetList = []
        for item in inputParam:
            targetList += SysMgr.getPids(item, isThread=False)
        targetList = list(set(targetList))

        # check target #
        if not targetList:
            SysMgr.printErr("no target process")
            sys.exit(0)
        elif len(targetList) > 1:
            SysMgr.printErr(
                "found multiple tasks [%s]" % \
                    SysMgr.getCommList(targetList))
            sys.exit(0)

        pid = targetList[0]
        meminfo = SysMgr.inputParam
        output = SysMgr.outPath

        # dump memory #
        Debugger.dumpTaskMemory(pid, meminfo, output)



    @staticmethod
    def doStrings():
        # get argument #
        if SysMgr.hasMainArg():
            inputParam = SysMgr.getMainArg()
        elif SysMgr.inputParam:
            inputParam = SysMgr.inputParam
            SysMgr.printErr("no input for path")
            sys.exit(0)

        SysMgr.setStream()

        SysMgr.printStat('start reading %s...' % inputParam)

        # convert binary file to string #
        clist = UtilMgr.convBin2Str(inputParam, pos=True)
        if not clist:
            SysMgr.printErr("no available string")
            return

        lastPos = sorted(clist.values())[-1]
        maxDigit = len(hex(lastPos))

        # print strings #
        for string, pos in sorted(clist.items(), key=lambda e:e[1]):
            SysMgr.printPipe(
                '{0:>{digit}} {1}'.format(hex(pos), string, digit=maxDigit))



    @staticmethod
    def doSetAffinity():
        SysMgr.warnEnable = True

        # get argument #
        if SysMgr.hasMainArg():
            value = SysMgr.getMainArg().split(',')
        elif SysMgr.filterGroup:
            value = SysMgr.filterGroup
        else:
            SysMgr.printErr(
                "fail to set CPU affinity of task because of no target")
            sys.exit(0)

        while 1:
            SysMgr.parseAffinityOption(value, launch=True)
            if SysMgr.intervalEnable:
                time.sleep(SysMgr.intervalEnable)
            else:
                break

        sys.exit(0)



    @staticmethod
    def importPkgItems(pkg, isExit=True):
        if pkg in SysMgr.impGlbPkg:
            return True

        module = SysMgr.getPkg(pkg, isExit)
        if not module:
            return False

        moduleDict = module.__dict__

        try:
            importList = module.__all__
        except SystemExit:
            sys.exit(0)
        except AttributeError:
            importList = \
                [name for name in moduleDict if not name.startswith('_')]

        newDict = {}
        for name in importList:
            newDict[name] = moduleDict[name]
        globals().update(newDict)

        SysMgr.impGlbPkg[pkg] = True

        return True



    @staticmethod
    def applyThreshold():
        def _getMaxInterval(node, maxVal=0):
            for key, item in node.items():
                if type(item) is list:
                    for subitem in item:
                        if type(subitem) is not dict:
                            continue
                        val = _getMaxInterval(subitem, maxVal)
                        if maxVal < val:
                            maxVal = val
                elif type(item) is dict:
                    val = _getMaxInterval(item, maxVal)
                    if maxVal < val:
                        maxVal = val
                elif key == 'interval' and UtilMgr.isNumber(item):
                    item = long(item)
                    if maxVal < item:
                        maxVal = item
            return maxVal

        def _checkResource(item):
            try:
                if item['apply'] == 'true':
                    return True
            except:
                pass

            if type(item) is list:
                for value in item:
                    if _checkResource(value):
                        return True
            elif type(item) is dict:
                for key, value in item.items():
                    if _checkResource(value):
                        return True

            return False

        def _checkPerm(item):
            try:
                if item['apply'] == 'true' and \
                    item['perm'] == 'root':
                    SysMgr.checkRootPerm(msg=item)
            except SystemExit:
                sys.exit(0)
            except:
                pass

            if type(item) is list:
                for value in item:
                    _checkPerm(value)
            elif type(item) is dict:
                for key, value in item.items():
                    _checkPerm(value)

        if not 'threshold' in ConfigMgr.confData:
            return

        confData = SysMgr.getConfigDict('threshold')
        if not confData:
            return

        if type(confData) is not dict:
            return

        SysMgr.reportEnable = True
        SysMgr.rankProcEnable = False
        SysMgr.thresholdData = confData

        # check permission #
        _checkPerm(SysMgr.thresholdData)

        # check storage option #
        try:
            if _checkResource(SysMgr.thresholdData['storage']):
                SysMgr.diskEnable = True
        except SystemExit:
            sys.exit(0)
        except:
            pass

        # check network option #
        try:
            if _checkResource(SysMgr.thresholdData['net']):
                SysMgr.networkEnable = True
        except SystemExit:
            sys.exit(0)
        except:
            pass

        # update maximum interval #
        maxInterval = _getMaxInterval(confData)
        if maxInterval > SysMgr.maxInterval:
            SysMgr.maxInterval = maxInterval

        SysMgr.printInfo(
            "applied for thresholds from %s" % SysMgr.confFileName)

        SysMgr.printWarn(UtilMgr.convDict2Str(confData))



    @staticmethod
    def doGetAffinity():
        SysMgr.warnEnable = True

        # get argument #
        if SysMgr.hasMainArg():
            value = SysMgr.getMainArg().split(',')
        elif SysMgr.filterGroup:
            value = SysMgr.filterGroup
        else:
            SysMgr.printErr(
                "fail to get CPU affinity of task because of no target")
            sys.exit(0)

        SysMgr.checkRootPerm()

        sibling = SysMgr.groupProcEnable
        targetList = []

        try:
            for item in value:
                targetList += SysMgr.getPids(item, sibling=sibling)

            if not targetList:
                SysMgr.printErr(
                    "no thread related to '%s'" % item)
                sys.exit(0)

            targetList = list(set(targetList))
            targetList = list(map(long, targetList))

            for tid in targetList:
                mask = SysMgr.getAffinity(tid)
                if not mask:
                    SysMgr.printErr(
                        "fail to get CPU affinity of %s(%s)" % \
                            (SysMgr.getComm(tid), tid))
                else:
                    SysMgr.printInfo(
                        'affinity of %s(%s) is %s' % \
                            (SysMgr.getComm(tid), tid, mask))
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printErr(
                "fail to get CPU affinity of task", True)
            sys.exit(0)



    @staticmethod
    def setStream(cut=True):
        if not cut:
            SysMgr.ttyCols = long(0)

        SysMgr.printStreamEnable = True
        SysMgr.encodeEnable = False



    @staticmethod
    def setAffinity(mask, pids, isProcess=False):
        # check root permission #
        if len(pids) == 1 and \
            str(pids[0]).isdigit() and \
            SysMgr.pid == long(pids[0]):
            pass
        elif not SysMgr.isRoot():
            SysMgr.printWarn(
                "no root permission to set affinity")

        # check pid list #
        if UtilMgr.isNumber(pids):
            pids = [long(pids)]
        elif type(pids) is list:
            for pid in pids:
                if not str(pid).isdigit():
                    SysMgr.printErr('fail to recognize pid %s' % pid)
                    return
        else:
            SysMgr.printErr('fail to recognize pid type')
            return

        # check mask type #
        try:
            mask = long(mask, 16)
            if mask == 0:
                SysMgr.printErr(
                    'fail to set mask to 0, use bit mask bigger than 0')
                return
        except:
            SysMgr.printErr('fail to recognize mask type')
            return

        # load libc #
        SysMgr.loadLibcObj(exit=True)

        # get the number of core #
        nrCore = SysMgr.getNrCore()

        for pid in pids:
            if isProcess:
                threadList = SysMgr.getThreadList(pid)
            else:
                threadList = [pid]

            for pid in threadList:
                try:
                    if SysMgr.guiderObj:
                        guiderObj = SysMgr.guiderObj
                        ret = guiderObj.sched_setaffinity(long(pid), mask) # pylint: disable=no-member
                except SystemExit:
                    sys.exit(0)
                except:
                    pass

                try:
                    SysMgr.libcObj.sched_setaffinity.argtypes = \
                        [c_int, c_ulong, POINTER(c_ulong)]

                    ret = SysMgr.libcObj.sched_setaffinity(
                        long(pid), nrCore,
                        byref(c_ulong(((0x1 << nrCore) - 1) & mask)))
                except SystemExit:
                    sys.exit(0)
                except:
                    ret = -1
                    SysMgr.printWarn(
                        "fail to set CPU affinity of tasks "
                        "because of sched_setaffinity fail")

                if ret >= 0:
                    SysMgr.printInfo(
                        'affinity of %s(%s) is changed to 0x%X' % \
                            (SysMgr.getComm(pid), pid, mask))
                else:
                    SysMgr.printErr(
                        'fail to set affinity of %s(%s) as 0x%X' % \
                            (SysMgr.getComm(pid), pid, mask))



    @staticmethod
    def getAffinity(pid):
        try:
            return '0x%X' % \
                SysMgr.guiderObj.sched_getaffinity(pid) # pylint: disable=no-member
        except SystemExit:
            sys.exit(0)
        except:
            pass

        # get ctypes object #
        if not SysMgr.importPkgItems('ctypes', False):
            return

        try:
            # load libc #
            if not SysMgr.loadLibcObj():
                raise Exception('no libc')

            SysMgr.libcObj.sched_getaffinity.argtypes = \
                [c_int, c_ulong, POINTER(c_ulong)]

            cpuset = c_ulong(0)

            size = long(1024 / (sizeof(c_ulong) * 8))
            ret = SysMgr.libcObj.sched_getaffinity(
                long(pid), size, pointer(cpuset))

            if ret >= 0:
                return hex(cpuset.value).rstrip('L')
            else:
                raise Exception('wrong affinity')
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printWarn((
                "fail to get CPU affinity of tasks "
                "because of sched_getaffinity fail"))



    @staticmethod
    def getMaxThread():
        maxThdPath = '/proc/sys/kernel/threads-max'
        try:
            with open(maxThdPath, 'r') as fd:
                return long(fd.readline()[:-1])
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printErr(
                "fail to read %s" % maxThdPath, reason=True)
            return None



    @staticmethod
    def setOOMAdj(pid='self', pri='-17'):
        if not SysMgr.isLinux:
            return

        if not SysMgr.isRoot():
            return

        # set path #
        oomPath = '%s/%s/oom_score_adj' % (SysMgr.procPath, pid)
        if not os.path.isfile(oomPath):
            # use deprecated path #
            oomPath = '%s/%s/oom_adj' % (SysMgr.procPath, pid)

        try:
            with open(oomPath, 'w') as fd:
                fd.write(pri)
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printWarn(
                "fail to write %s" % oomPath, reason=True)



    @staticmethod
    def ping(url=[], timeout=None, count=None):
        ICMP_ECHO_REQUEST = 8

        def _checksum(source):
            sum = 0
            countTo = (len(source)/2)*2
            count = 0
            while count < countTo:
                if type(source[count+1]) is long:
                    data1 = source[count+1]
                else:
                    data1 = ord(source[count+1])

                if type(source[count]) is long:
                    data2 = source[count]
                else:
                    data2 = ord(source[count])

                thisVal = data1*256 + data2
                sum = sum + thisVal
                sum = sum & 0xffffffff # Necessary?
                count = count + 2

            if countTo < len(source):
                sum = sum + ord(source[len(source) - 1])
                sum = sum & 0xffffffff # Necessary?

            sum = (sum >> 16)  +  (sum & 0xffff)
            sum = sum + (sum >> 16)
            answer = ~sum
            answer = answer & 0xffff

            # Swap bytes. Bugger me if I know why #
            answer = answer >> 8 | (answer << 8 & 0xff00)

            return answer

        def _receivePing(sockList, timeout, sockInfo):
            select = SysMgr.getPkg('select')

            timeLeft = timeout
            while True:
                startedSelect = time.time()

                # wait for event #
                whatReady = select.select(sockList, [], [], timeLeft)

                # check timeout #
                if not whatReady[0]:
                    return

                # get current time #
                timeReceived = time.time()

                howLongInSelect = (timeReceived - startedSelect)

                # check received packets #
                for sock in whatReady[0]:
                    recPacket, addr = sock.recvfrom(1024)
                    icmpHeader = recPacket[20:28]
                    ptype, code, checksum, packetID, sequence = \
                        struct.unpack("bbHHh", icmpHeader)

                    # get sent ID #
                    ID = sockInfo[sock.fileno()][2]

                    # check sent ID #
                    if packetID != ID:
                        continue

                    # decode packet #
                    bytesInDouble = struct.calcsize("d")
                    timeSent = struct.unpack(
                        "d", recPacket[28:28 + bytesInDouble])[0]

                    # save times #
                    delay = timeReceived - timeSent
                    sockInfo[sock.fileno()].append(delay)
                    sockList.pop(sockList.index(sock))

                # finished #
                if not sockList:
                    return

                # timeout #
                timeLeft = timeLeft - howLongInSelect
                if timeLeft <= 0:
                    return

        def _sendPing(sock, destAddr, ID):
            socket = SysMgr.getPkg('socket')

            # Header: type(8), code(8), checksum(16), id(16), sequence(16) #
            checksumData = 0

            # Make a dummy heder with a 0 checksum #
            header = struct.pack(
                "bbHHh", ICMP_ECHO_REQUEST, 0, checksumData, ID, 1)
            bytesInDouble = struct.calcsize("d")
            data = (192 - bytesInDouble) * "Q".encode()
            data = struct.pack("d", time.time()) + data

            # Calculate the checksum on the data and the dummy header. #
            checksumData = _checksum(header + data)

            '''
            Now that we have the right checksum,
            we put that in. It's just easier
            to make up a new header than to stuff it into the dummy.
            '''
            header = struct.pack(
                "bbHHh", ICMP_ECHO_REQUEST, 0,
                socket.htons(checksumData), ID, 1)
            packet = header + data
            sock.sendto(packet, (destAddr, 0))

        def _convAddrs(addrList):
            def __expandAddrs(addrs, item):
                newAddrs = []
                if item.isdigit():
                    if not addrs:
                        newAddrs.append(item)
                    else:
                        for word in addrs:
                            newAddrs.append('%s.%s' % (word, item))
                elif item.count('-') == 1:
                    start, end = item.split('-')
                    if start.strip().isdigit() and end.strip().isdigit():
                        for idx in range(long(start), long(end)+1):
                            if not addrs:
                                newAddrs.append(idx)
                                continue

                            for word in addrs:
                                newAddrs.append('%s.%s' % (word, idx))
                    else:
                        if not addrs:
                            newAddrs.append(item)
                        else:
                            for word in addrs:
                                newAddrs.append('%s.%s' % (word, idx))
                elif item == '*':
                    for idx in range(1, 255):
                        if not addrs:
                            newAddrs.append(idx)
                        else:
                            for word in addrs:
                                newAddrs.append('%s.%s' % (word, idx))
                else:
                    if not addrs:
                        newAddrs.append(item)
                    else:
                        for word in addrs:
                            newAddrs.append('%s.%s' % (word, item))

                return newAddrs

            if not addrList:
                return addrList

            newAddrList = []
            for addr in addrList:
                # digit address #
                checkAddr = addr.replace('.', '')
                if checkAddr.isdigit():
                    newAddrList.append(addr)
                    continue

                # name address #
                checkAddr = checkAddr.replace('-', '').replace('*', '')
                if not checkAddr.isdigit():
                    newAddrList.append(addr)
                    continue

                # convert addresses #
                addrs = []
                fields = addr.split('.')
                for item in fields:
                    addrs = __expandAddrs(addrs, item)

                # add addresses #
                newAddrList += addrs

            return newAddrList

        def _doPing(addrList, timeout, seq=None, verb=True):
            socket = SysMgr.getPkg('socket')

            # set attributes #
            try:
                ttl = 64
                icmp = socket.getprotobyname("icmp")
            except:
                SysMgr.printErr('fail to ping', True)
                return 0

            # define socket list #
            sockList = list()
            sockInfo = dict()

            # send packets #
            for idx, destAddr in enumerate(addrList):
                destIPAddr = socket.gethostbyname(destAddr)

                # create a socket #
                try:
                    sock = socket.socket(
                        socket.AF_INET, socket.SOCK_RAW, icmp)
                    sock.setsockopt(socket.IPPROTO_IP, socket.IP_TTL, ttl)
                except:
                    SysMgr.printErr('fail to ping', True)
                    return 0

                # create an unique ID #
                ICMP_ID = (os.getpid()+idx) & 0xFFFF

                # send packet #
                _sendPing(sock, destIPAddr, ICMP_ID)

                # get address details #
                if destAddr == destIPAddr:
                    addrInfo = destAddr
                else:
                    addrInfo = '%s(%s)' % (destAddr, destIPAddr)

                # save sock info #
                sockList.append(sock)
                sockInfo[sock.fileno()] = [sock, addrInfo, ICMP_ID]

            # receive packet #
            _receivePing(sockList, timeout, sockInfo)

            # add timed out info and close all sockets #
            for name, attr in sockInfo.items():
                if len(attr) <= 3:
                    sockInfo[name].append(timeout)
                try:
                    attr[0].close()
                except:
                    pass

            # check return condition #
            if not verb:
                return

            # set sequence string #
            if seq is not None:
                seqstr = '[%s] ' % seq
            else:
                seqstr = ''

            # define json variable #
            if SysMgr.jsonEnable:
                jsonData = {'seq': seq, 'success': dict(), 'fail': dict()}

            timeoutstr = ''
            timeoutlinestr = ''

            # print results #
            for attr in sorted(sockInfo.values(), key=lambda x:x[3]):
                name = attr[1]
                elapsed = attr[3]

                # success #
                if elapsed < timeout:
                    delay = attr[3] * 1000

                    if SysMgr.jsonEnable:
                        jsonData['success'].setdefault(name, dict())
                        jsonData['success'][name]['time'] = delay
                        continue

                    name = UtilMgr.convColor(name, 'GREEN', 15, 'left')
                    delaystr = UtilMgr.convColor('%.3f' % delay, 'YELLOW')

                    SysMgr.printPipe(
                        '%s%s: %s ms' % (seqstr, name, delaystr))
                # timeout #
                else:
                    if SysMgr.jsonEnable:
                        jsonData['fail'].setdefault(name, dict())
                        jsonData['fail'][name]['time'] = timeout
                        continue

                    name = UtilMgr.convColor(name, 'RED', 15, 'left')

                    if len(timeoutlinestr) + len(name) >= SysMgr.ttyCols:
                        timeoutstr = '%s %s\n' % \
                            (timeoutstr, timeoutlinestr.lstrip())
                        timeoutlinestr = name
                    else:
                        timeoutlinestr = '%s %s' % (timeoutlinestr, name)

            # print results in JSON format #
            if SysMgr.jsonEnable:
                SysMgr.printPipe(UtilMgr.convDict2Str(jsonData))
            elif timeoutlinestr:
                timeoutstr = '%s %s\n' % \
                    (timeoutstr, timeoutlinestr.lstrip())

            # print timeout info #
            if timeoutstr:
                SysMgr.printPipe(
                    '%stimeout:\n%s' % (seqstr, timeoutstr))



        # check root permission for Linux #
        if SysMgr.isLinux and not SysMgr.isRoot():
            SysMgr.printErr(
                'fail to ping because of no root permission')
            return

        # get address list #
        urlList = []
        if url:
            urlList = url
        elif SysMgr.hasMainArg():
            urlList = SysMgr.getMainArg().split(',')
            urlList = UtilMgr.cleanItem(urlList)
        elif SysMgr.inputParam:
            try:
                files = SysMgr.inputParam.split(',')
                files = UtilMgr.cleanItem(files)
                for fname in files:
                    with open(fname, 'r') as fd:
                        urlList += fd.readlines()
                urlList = UtilMgr.cleanItem(urlList)
            except:
                SysMgr.printErr(
                    "fail to read addresses from '%s'" % \
                        ','.join(files), True)
                sys.exit(0)

        # check input #
        if not urlList:
            SysMgr.printErr('no input for address')
            sys.exit(0)

        # convert addresses #
        urlList = _convAddrs(urlList)

        # set repeat count #
        if not count:
            if SysMgr.repeatInterval == 0:
                count = 1
            else:
                count = SysMgr.repeatInterval
        SysMgr.printInfo(
            'set repeat count to %s' % UtilMgr.convNum(count))

        # set timeout #
        if not timeout:
            timeout = SysMgr.getOption('T')
            if timeout:
                try:
                    timeout = float(timeout)
                except:
                    SysMgr.printErr(
                        "fail to set timeout '%s'" % timeout, True)
                    sys.exit(0)
            else:
                timeout = 3

        # set interval #
        interval = SysMgr.getOption('i')
        try:
            interval = float(interval)
        except:
            interval = 1

        # print timeout info #
        timeoutstr = '%f' % timeout
        timeoutstr = timeoutstr.rstrip('0')
        if timeoutstr.endswith('.'):
            timeoutstr = timeoutstr[:-1]
        SysMgr.printInfo(
            'set timeout to %s sec\n' % timeoutstr)

        # ping #
        for seq in xrange(0, count):
            try:
                _doPing(urlList, timeout, seq=seq)
                time.sleep(interval)
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printErr(
                    'fail to send ping to %s', True)



    @staticmethod
    def getExeCmd(pid):
        cmd = SysMgr.getCmdline(pid, retList=True)[:2]
        if cmd[1][0] != '/':
            pwd = SysMgr.getCwd(pid)
            cmd[1] = '%s/%s' % (pwd, cmd[1])
        return cmd



    @staticmethod
    def getConfigDict(name):
        confData = ConfigMgr.confData[name]
        if type(confData) is list:
            confData = UtilMgr.convStr2Dict('\n'.join(confData), True)

        if type(confData) is dict:
            return confData
        else:
            return None



    @staticmethod
    def getConfigList(name):
        confData = ConfigMgr.confData[name]
        if type(confData) is list:
            return confData
        else:
            return None



    @staticmethod
    def loadConfig(fname, verb=True):
        try:
            targetList = []
            fd = None
            skip = False
            fd = open(fname, 'r')
            for line in fd.readlines():
                if not line:
                    continue

                line = line.strip()
                if not line or line == '\n':
                    continue
                elif line.startswith('#') or line.startswith('//'):
                    continue
                elif skip:
                    if line.startswith("'''") or line.startswith('*/'):
                        skip = False
                    continue
                elif line.startswith("'''") or line.startswith('/*'):
                    skip = True
                    continue
                elif line.startswith('<') and line.endswith('>'):
                    entry = line[1:-1]
                    ConfigMgr.confData.setdefault(entry, list())
                    targetList = ConfigMgr.confData[entry]
                    continue
                else:
                    targetList.append(line)

            return ConfigMgr.confData
        except SystemExit:
            sys.exit(0)
        except:
            if verb:
                SysMgr.printErr(
                    "fail to load config from '%s'" % fname, reason=True)
            return None
        finally:
            if fd:
                fd.close()



    @staticmethod
    def getCwd(pid):
        cwdPath = '%s/%s/cwd' % (SysMgr.procPath, pid)
        return os.readlink(cwdPath)



    @staticmethod
    def getPyLibPath(load=True):
        if SysMgr.pyLibPath:
            return SysMgr.pyLibPath

        try:
            # set library name #
            exePath = SysMgr.getExeName(SysMgr.pid)
            exeName = os.path.basename(exePath)
            libName = 'lib%s' % exeName
            if not load:
                return libName

            # search ld.so.cache #
            if not SysMgr.pyLibPath:
                SysMgr.pyLibPath = SysMgr.findLib(libName, inc=True)[0]
            # search standard path #
            else:
                libName = SysMgr.loadLib(libName)._name
                if libName:
                    SysMgr.pyLibPath = \
                        FileAnalyzer.getMapFilePath(SysMgr.pid, libName)

            return SysMgr.pyLibPath
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printWarn(
                "fail to get path for python library", reason=True)



    @staticmethod
    def getExeName(pid):
        exePath = '%s/%s/exe' % (SysMgr.procPath, pid)
        try:
            return os.readlink(exePath)
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printWarn(
                "fail to get binary path for %s process" % pid, reason=True)
            return None



    @staticmethod
    def getCmdline(pid, retList=False):
        cmdlinePath = \
            '%s/%s/cmdline' % (SysMgr.procPath, pid)

        try:
            with open(cmdlinePath, 'r') as fd:
                res = fd.readline()
                if retList:
                    return res.split("\x00")
                else:
                    return res.replace("\x00", " ").strip()
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printOpenWarn(cmdlinePath)
            if retList:
                return []
            else:
                return ''



    @staticmethod
    def getTracerId(pid):
        statusPath = \
            '%s/%s/status' % (SysMgr.procPath, pid)
        try:
            with open(statusPath, 'r') as fd:
                for line in fd.readlines():
                    if line.startswith('TracerPid'):
                        return long(line.split(':')[1].split()[0])
        except SystemExit:
            sys.exit(0)
        except:
            return 0



    @staticmethod
    def getUid(pid, itype='real'):
        try:
            path = '%s/status' % pid
            data = SysMgr.procReadlines(path)

            for line in data:
                if line.startswith('Uid'):
                    if itype == 'real':
                        idx = 0
                    elif itype == 'effective':
                        idx = 1
                    elif itype == 'saved':
                        idx = 2
                    elif itype == 'filesystem':
                        idx = 3

                    return long(line.split(':')[1].split()[idx])
        except SystemExit:
            sys.exit(0)
        except:
            comm = SysMgr.getComm(pid)
            SysMgr.printErr(
                'fail to get UID for %s(%s)' % (comm, pid), reason=True)

        return 0



    @staticmethod
    def getTgid(pid):
        statusPath = \
            '%s/%s/status' % (SysMgr.procPath, pid)
        try:
            with open(statusPath, 'r') as fd:
                for line in fd.readlines():
                    if line.startswith('Tgid'):
                        return line.split(':')[1].split()[0]
        except SystemExit:
            sys.exit(0)
        except:
            return None



    @staticmethod
    def resizeShm(shm, size):
        mmap = SysMgr.getPkg('mmap', False)
        if not mmap:
            return

        mmap.resize(size)



    @staticmethod
    def createShm(path=None, size=pageSize):
        if not SysMgr.isLinux:
            return

        mmap = SysMgr.getPkg('mmap', False)
        if not mmap:
            return

        return mmap.mmap(-1, size)



    @staticmethod
    def getCommList(pidList):
        try:
            commList = ['%s(%s)' % \
                (SysMgr.getComm(pid), pid) for pid in pidList]
            return ', '.join(commList)
        except:
            return ', '.join(pidList)



    @staticmethod
    def getPwd(pid):
        pwdPath = \
            '%s/%s/cwd' % (SysMgr.procPath, pid)
        pwd = None

        try:
            pwd = os.readlink(pwdPath)
        except SystemExit:
            sys.exit(0)
        except:
            return None

        return pwd



    @staticmethod
    def getComm(pid, cache=False, save=False):
        if pid in SysMgr.commCache:
            return SysMgr.commCache[pid]

        try:
            if pid in SysMgr.commFdCache:
                fd = SysMgr.commFdCache[pid]
                fd.seek(0)
                comm = fd.readline()[:-1]
                if save:
                    SysMgr.commCache[pid] = comm
                return comm
        except SystemExit:
            sys.exit(0)
        except:
            pass

        # use psutil #
        if not SysMgr.isLinux:
            try:
                psutil = SysMgr.getPkg('psutil')
                return psutil.Process(pid).name()
            except:
                pass

        comm = None
        commPath = \
            '%s/%s/comm' % (SysMgr.procPath, pid)

        try:
            fd = open(commPath, 'r')

            comm = fd.readline()[:-1]

            # cache comm #
            if save:
                SysMgr.commCache[pid] = comm

            # flush fd cache #
            if SysMgr.maxKeepFd < fd.fileno():
                SysMgr.commFdCache = {}
            # cache  fd #
            elif cache:
                SysMgr.commFdCache[pid] = fd
            else:
                fd.close()
        except SystemExit:
            sys.exit(0)
        except:
            return None

        return comm



    @staticmethod
    def getPyConfig(item='all', var=None):
        try:
            SysMgr.importPkgItems('sysconfig')

            if item == 'path':
                varDict = get_paths()
            else:
                varDict = get_config_vars()

            if var:
                return varDict[var]
            else:
                return varDict
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printWarn(
                "fail to get python config", True, True)
            return None



    @staticmethod
    def getMyBacktrace():
        # load libc #
        SysMgr.loadLibcObj(exit=True)

        # define functions #
        libcObj = SysMgr.libcObj

        libcObj.backtrace.argtypes = [c_void_p, c_int]
        libcObj.backtrace.restype = c_int

        libcObj.backtrace_symbols.argtypes = [c_void_p, c_int]
        libcObj.backtrace_symbols.restype = POINTER(c_char_p)

        # define buffers #
        buf = (c_void_p*1024)()

        # call backtrace #
        ret = libcObj.backtrace(byref(buf), c_int(1024))
        syms = libcObj.backtrace_symbols(byref(buf), c_int(ret))

        sys.exit(0)



    @staticmethod
    def isBlkDev(path):
        stat = SysMgr.getPkg('stat')

        try:
            return stat.S_ISBLK(os.stat(path).st_mode)
        except:
            return False



    @staticmethod
    def dlopen(path):
        # load libc #
        if not SysMgr.loadLibcObj():
            return

        try:
            path = path.encode()
        except:
            pass

        try:
            func = '__libc_dlopen_mode'
            funcp = getattr(SysMgr.libcObj, func)
            funcp.argtypes = [c_void_p, c_int]
            funcp.restype = c_ulong
            return funcp(path, 1)
        except:
            SysMgr.printErr("fail to call dlopen", reason=True)
            return None



    @staticmethod
    def setComm(comm):
        if not SysMgr.isLinux:
            return

        # try to set comm using native lib #
        try:
            SysMgr.guiderObj.prctl(15, comm, 0, 0, 0) # pylint: disable=no-member
            return
        except SystemExit:
            sys.exit(0)
        except:
            pass

        # load libc #
        if not SysMgr.loadLibcObj():
            return

        try:
            SysMgr.libcObj.prctl(
                15, c_char_p(comm.encode('utf-8')), 0, 0, 0)
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printWarn(
                'fail to set comm', True, reason=True)



    @staticmethod
    def getPicklePkg(isExit=True):
        pickle = SysMgr.getPkg('cPickle', isExit)
        if not pickle:
            pickle = SysMgr.getPkg('pickle', isExit)
            if not pickle:
                return None
        return pickle



    @staticmethod
    def isAlive(tid):
        try:
            statPath = "%s/%s/stat" % (SysMgr.procPath, tid)
            with open(statPath, 'r') as fd:
                stat = fd.read()

            # convert string to list #
            statList = stat.split(')')[1].split()

            if statList[0] == 'Z':
                return False
            else:
                return True
        except SystemExit:
            sys.exit(0)
        except:
            return False



    @staticmethod
    def getPkg(name, isExit=True, isTemp=False, isRoot=True):
        # check cache #
        try:
            return SysMgr.impPkg[name]
        except SystemExit:
            sys.exit(0)
        except:
            pass

        # check blacklist #
        if not isExit and name in SysMgr.skipImpPkg:
            return None

        # import package #
        try:
            obj =  __import__(name, fromlist = [name] if isRoot else [None])
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printWarn(
                "fail to import python package: %s " % name, isExit)

            # register to blacklist #
            SysMgr.skipImpPkg[name] = True

            # check return condition #
            if isExit:
                sys.exit(0)
            return None

        # save package object #
        if not isTemp:
            SysMgr.impPkg[name] = obj

        return obj



    @staticmethod
    def getIowaitTime(dev=None):
        if not SysMgr.diskStats or \
            not SysMgr.prevDiskStats:
            return '0/0'

        flist = {}
        dlist = {}
        curReadMsTotal = prevReadMsTotal = long(0)
        curWriteMsTotal = prevWriteMsTotal = long(0)
        curNrReadTotal = prevNrReadTotal = long(0)
        curNrWriteTotal = prevNrWriteTotal = long(0)
        curIoMsTotal = prevIoMsTotal = long(0)
        curWIoMsTotal = prevWIoMsTotal = long(0)

        # get total iowait time for read #
        for line in SysMgr.diskStats:
            items = line.split()
            dev = items[2]

            if not dev[-1].isdigit():
                flist[dev] = None
            else:
                skip = False
                for item in flist:
                    if item != dev and \
                        dev.startswith(item):
                        skip = True

                if skip:
                    continue

            dlist[dev] = dict()
            dlist[dev]['curNrRead'] = long(items[3])
            dlist[dev]['curNrWrite'] = long(items[7])
            dlist[dev]['curReadMs'] = long(items[6])
            dlist[dev]['curWriteMs'] = long(items[10])
            dlist[dev]['curIoMs'] = long(items[12])
            dlist[dev]['curWIoMs'] = long(items[13])

            curNrReadTotal += long(items[3])
            curNrWriteTotal += long(items[7])
            curReadMsTotal += long(items[6])
            curWriteMsTotal += long(items[10])
            curIoMsTotal += long(items[12])
            curWIoMsTotal += long(items[13])

        # get total iowait time for write #
        for line in SysMgr.prevDiskStats:
            items = line.split()
            dev = items[2]

            skip = False
            for item in flist:
                if item != dev and \
                    dev.startswith(item):
                    skip = True

            if skip:
                continue

            dlist[dev]['prevNrRead'] = long(items[3])
            dlist[dev]['prevNrWrite'] = long(items[7])
            dlist[dev]['prevReadMs'] = long(items[6])
            dlist[dev]['prevWriteMs'] = long(items[10])
            dlist[dev]['prevIoMs'] = long(items[12])
            dlist[dev]['prevWIoMs'] = long(items[13])

            prevNrReadTotal += long(items[3])
            prevNrWriteTotal += long(items[7])
            prevReadMsTotal += long(items[6])
            prevWriteMsTotal += long(items[10])
            prevIoMsTotal += long(items[12])
            prevWIoMsTotal += long(items[13])

        for dev, stat in dlist.items():
            read = stat['curNrRead'] - stat['prevNrRead']
            write = stat['curNrWrite'] - stat['prevNrWrite']
            io = read + write

        readMsTotal = curReadMsTotal - prevReadMsTotal
        writeMsTotal = curWriteMsTotal - prevWriteMsTotal

        '''
        nrReadTotal = curNrReadTotal - prevNrReadTotal
        nrWriteTotal = curNrWriteTotal - prevNrWriteTotal
        ioMsTotal = curIoMsTotal - prevIoMsTotal
        wIoMsTotal = curWIoMsTotal - prevWIoMsTotal
        '''

        retstr = '%s/%s' % (
            UtilMgr.convSize2Unit(readMsTotal),
            UtilMgr.convSize2Unit(writeMsTotal))

        return retstr



    @staticmethod
    def updateDiskStats():
        try:
            SysMgr.diskStatsFd.seek(0)
            SysMgr.prevDiskStats = SysMgr.diskStats
            SysMgr.diskStats = SysMgr.diskStatsFd.readlines()
        except SystemExit:
            sys.exit(0)
        except:
            try:
                diskstatPath = '%s/diskstats' % SysMgr.procPath
                SysMgr.diskStatsFd = open(diskstatPath, 'r')
                SysMgr.diskStats = SysMgr.diskStatsFd.readlines()
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printOpenWarn(diskstatPath)



    @staticmethod
    def getMountData(pid='self'):
        try:
            if pid != 'self':
                raise Exception()

            SysMgr.mountFd.seek(0)
            return SysMgr.mountFd.readlines()
        except SystemExit:
            sys.exit(0)
        except:
            try:
                mountPath = '%s/%s/mountinfo' % (SysMgr.procPath, pid)
                mountFd = open(mountPath, 'r')
                if pid == 'self':
                    SysMgr.mountFd = mountFd
                return mountFd.readlines()
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printOpenWarn(mountPath)



    @staticmethod
    def getMemStat(pid):
        try:
            statmPath = "%s/%s/statm" % (SysMgr.procPath, pid)
            with open(statmPath, 'r') as fd:
                return fd.readlines()[0].split()
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printOpenWarn(statmPath)
            return



    @staticmethod
    def getPidFilter():
        if not SysMgr.pidFilter:
            cmd = ""
            for cond in list(SysMgr.filterGroup):
                try:
                    cmd += "common_pid == %s || " % long(cond)
                except:
                    try:
                        ldir = cond.find('>')
                        if ldir == 0:
                            cmd += "common_pid >= %s || " % long(cond[1:])
                        elif ldir == len(cond) - 1:
                            cmd += "common_pid <= %s || " % long(cond[:-1])

                        rdir = cond.find('<')
                        if rdir == 0:
                            cmd += "common_pid <= %s || " % long(cond[1:])
                        elif rdir == len(cond) - 1:
                            cmd += "common_pid >= %s || " % long(cond[:-1])
                    except SystemExit:
                        sys.exit(0)
                    except:
                        pass

            if cmd != "":
                cmd = "(" + cmd[:cmd.rfind('||')] + ")"

            SysMgr.pidFilter = cmd

        return SysMgr.pidFilter



    @staticmethod
    def isExceptTarget(tid, tdata, comm=None, plist=[]):
        tlist = SysMgr.filterGroup

        # check filter #
        if tlist == []:
            return False

        # get comm #
        if not comm:
            comm = tdata[tid]['comm']

        # check a thread #
        for item in tlist:
            if item == tid or \
                item in comm or \
                item == '' or \
                SysMgr.isValidTid(tid, item):
                return False

        # check all threads in a same process #
        if SysMgr.groupProcEnable:
            tgid = tdata[tid]['tgid']

            # check tgid in process list by tid #
            if str(tgid) in plist:
                return False

            # check tgid in filter list by tid #
            for item in tlist:
                try:
                    if item == tgid or \
                        SysMgr.isValidTid(tgid, item):
                        return False
                    elif tgid == tdata[item]['tgid'] or \
                        tgid == SysMgr.savedProcTree[item]:
                        return False
                except SystemExit:
                    sys.exit(0)
                except:
                    pass

        return True



    @staticmethod
    def getTraceItem(string):
        if SysMgr.tgidEnable:
            # record-tgid option #
            m = re.match((
                r'^\s*(?P<comm>\S+)-(?P<thread>[0-9]+)\s+'
                r'\[(?P<core>[0-9]+)\]\s+\(\s*(?P<tgid>.+)\)\s+'
                r'(?P<time>\S+):\s+(?P<func>\S+)(?P<etc>.+)'), string)
            if not m:
                # print-tgid option #
                m = re.match((
                    r'^\s*(?P<comm>.+)-(?P<thread>[0-9]+)\s+'
                    r'\(\s*(?P<tgid>\S+)\)\s+\[(?P<core>[0-9]+)\]\s+'
                    r'(?P<time>\S+):\s+(?P<func>\S+)(?P<etc>.+)'), string)

            return m

        m = re.match((
            r'^\s*(?P<comm>.+)-(?P<thread>[0-9]+)\s+\[(?P<core>[0-9]+)\]\s+'
            r'(?P<time>\S+):\s+(?P<func>\S+)(?P<etc>.+)'), string)

        return m



    @staticmethod
    def isValidEnableOption(options):
        if not options:
            return False

        optionList = 'BCDEFGHILNPRSTWYabcdefghijklmnopqrrstuvwxy'
        for opt in options:
            if not opt in optionList:
                return False

        return True



    @staticmethod
    def isValidOption(option):
        optionList = 'ABCDEFGHIJKLMNOPQRSTUWXYZabcdefgijklmnopqrstuvwxy'
        if option in optionList:
            return True
        elif option.isdigit():
            return True
        else:
            return False



    @staticmethod
    def isValidTid(tid, cond):
        try:
            tid = long(tid)

            ldir = cond.find('>')
            if ldir == 0 and tid >= long(cond[1:]):
                return True
            elif ldir == len(cond) - 1 and tid <= long(cond[:-1]):
                return True

            rdir = cond.find('<')
            if rdir == 0 and tid <= long(cond[1:]):
                return True
            elif rdir == len(cond) - 1 and tid >= long(cond[:-1]):
                return True

            if tid == cond or tid == long(cond):
                return True

            return False
        except SystemExit:
            sys.exit(0)
        except:
            return False



    @staticmethod
    def printBacktrace():
        traceback = SysMgr.getPkg('traceback')
        traceback.print_stack(file=SysMgr.stderr)



    @staticmethod
    def waitEvent(ignChldSig=True, exit=False, forceExit=False, block=True):
        # ignore SIGCHLD #
        if ignChldSig:
            signal.signal(signal.SIGCHLD, signal.SIG_IGN)

        # backup SIGINT handler and set new handler #
        if SysMgr.waitEnable and block:
            handle = signal.getsignal(signal.SIGINT)
            signal.signal(signal.SIGINT, SysMgr.defaultHandler)

        # pause task #
        try:
            signal.pause()
        except SystemExit:
            if exit:
                sys.exit(0)
            elif forceExit:
                os._exit(0)
            else:
                pass
        except:
            pass

        # restore SIGINT handler #
        if SysMgr.waitEnable and block:
            signal.signal(signal.SIGINT, handle)



    @staticmethod
    def backupFile(origFile):
        if not os.path.isfile(origFile):
            return

        try:
            newFile = '%s.old' % origFile

            os.rename(origFile, newFile)

            SysMgr.printInfo(
                "renamed '%s' to '%s' for backup" % \
                    (origFile, newFile))
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printErr(
                "fail to backup '%s' to '%s'" % \
                    (origFile, newFile), True)



    @staticmethod
    def convRealPath(flist):
        if UtilMgr.isString(flist):
            flist = [flist]

        nlist = []
        for path in flist:
            path = path.strip()

            if path.startswith('^'):
                path = path[1:]
                exflag = True
            else:
                exflag = False

            try:
                rpath = os.readlink(path)
                if not rpath.startswith('/'):
                    dirname = os.path.dirname(path)
                    rpath = os.path.join(dirname, rpath)

                if exflag:
                    rpath = '^' + rpath

                nlist.append(rpath)
            except SystemExit:
                sys.exit(0)
            except:
                if os.path.exists(path):
                    if exflag:
                        path = '^' + path

                    nlist.append(path)
                else:
                    SysMgr.printWarn(
                        "fail to convert '%s' to real path" % path,
                            reason=True, always=True)

        return nlist



    @staticmethod
    def getErrReason():
        if not SysMgr.importPkgItems('ctypes', False):
            return

        err = get_errno()
        if err in errno.errorcode:
            return errno.errorcode[err]
        else:
            return None



    @staticmethod
    def getProcTree():
        procTree = {}

        # get process list in proc filesystem #
        try:
            pids = os.listdir(SysMgr.procPath)
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printOpenErr(SysMgr.procPath)
            return None

        for pid in pids:
            try:
                long(pid)
            except SystemExit:
                sys.exit(0)
            except:
                continue

            # make path of tid #
            procPath = "%s/%s" % (SysMgr.procPath, pid)
            taskPath = "%s/%s" % (procPath, 'task')

            # update comm of main thread #
            comm = SysMgr.getComm(pid, save=True)

            try:
                tids = os.listdir(taskPath)
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printOpenWarn(taskPath)
                continue

            for tid in tids:
                try:
                    long(tid)

                    # update comm of thread #
                    SysMgr.getComm(tid, save=True)

                    if tid == pid:
                        procTree[tid] = '%s(%s)' % (pid, comm)
                    else:
                        procTree[tid] = pid
                except SystemExit:
                    sys.exit(0)
                except:
                    continue

        return procTree



    @staticmethod
    def setSortValue(values):
        if not values:
            value = cond = None
        else:
            values = values.split(':')
            if len(values) == 1:
                value = values[0]
                cond = None
            elif len(values) > 1:
                value, cond = values[:2]

        if value == 'c':
            SysMgr.printInfo("sorted by CPU")
        elif value == 'N':
            SysMgr.printInfo("sorted by NAME")
        elif value == 'm':
            SysMgr.printInfo("sorted by MEMORY")
        elif value == 'b':
            SysMgr.printInfo("sorted by BLOCK")
        elif value == 'w':
            SysMgr.printInfo("sorted by CHILD")
            SysMgr.wfcEnable = True
        elif value == 'p':
            SysMgr.printInfo("sorted by PID")
        elif value == 'n':
            SysMgr.printInfo("sorted by NEW")
        elif value == 'e':
            SysMgr.printInfo("sorted by EXECTIME")
            SysMgr.schedEnable = True
        elif value == 'd':
            SysMgr.printInfo("sorted by DELAY")
            SysMgr.schedEnable = True
        elif value == 'r':
            SysMgr.printInfo("sorted by RUNTIME")
        elif value == 'o':
            SysMgr.printInfo("sorted by OOMSCORE")
            TaskAnalyzer.setLastField('oom')
        elif value == 'P':
            SysMgr.printInfo("sorted by PRIORITY")
        elif value == 'f':
            SysMgr.printInfo("sorted by FILE")
            SysMgr.fileTopEnable = True
        elif value == 'C':
            if not SysMgr.checkMode('ttop'):
                SysMgr.printErr(
                   "fail to sort by CONTEXTSWITCH because "
                    "it is supported on thread mode")
                sys.exit(0)
            SysMgr.printInfo("sorted by CONTEXTSWITCH")
        elif not value:
            value = None
        else:
            SysMgr.printErr(
                "wrong option value '%s' for sort" % value)
            return False

        # set values #
        SysMgr.sort = value
        SysMgr.sortCond = cond

        return True



    @staticmethod
    def readProcData(tid, path, num=-1):
        path = '%s/%s/%s' % (SysMgr.procPath, tid, path)

        try:
            f = open(path, 'r')
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printOpenErr(path)
            return None

        if num == -1:
            return f.readlines()
        elif num == 0:
            return f.readline().replace('\n', '')
        else:
            return f.readline().replace('\n', '').split()[num - 1]



    @staticmethod
    def hasMainArg(dash=False):
        if len(sys.argv) <= 2 or \
            (not dash and sys.argv[2].startswith('-')):
            return False
        else:
            return True



    @staticmethod
    def getMainArg(path=False):
        if len(sys.argv) <= 2:
            return None
        else:
            if not path:
                return sys.argv[2]
            return UtilMgr.convPath(sys.argv[2], retStr=True, separator=',')



    @staticmethod
    def checkEnv():
        # check os #
        if sys.platform.startswith('linux'):
            SysMgr.isLinux = True

            # environment variables #
            try:
                # set default terminal to xterm #
                os.environ['TERM'] = 'xterm'

                # set run type #
                if "REMOTERUN" in os.environ:
                    SysMgr.encodeEnable = False
                    SysMgr.remoteRun = True
                    SysMgr.colorEnable = False

                # check encode condition #
                if not "LANG" in os.environ or \
                    'tty' in os.ttyname(sys.stdout.fileno()):
                    SysMgr.encodeEnable = False
            except SystemExit:
                sys.exit(0)
            except:
                pass

            # android #
            if 'ANDROID_ROOT' in os.environ:
                SysMgr.isAndroid = True
                SysMgr.libcPath = 'libc'
                SysMgr.libcppPath = 'libstdc++'
                SysMgr.libdemanglePath = 'libgccdemangle'
                SysMgr.cacheDirPath = '/data/log/guider'
                SysMgr.colorEnable = False
        elif sys.platform.startswith('win') or \
            sys.platform.startswith('darwin'):
            SysMgr.isLinux = False
            if len(sys.argv) > 1 and \
                not SysMgr.checkMode('cli') and \
                not SysMgr.isDrawMode() and \
                not SysMgr.checkMode('convert') and \
                not SysMgr.checkMode('drawreq') and \
                not SysMgr.checkMode('readelf') and \
                not SysMgr.checkMode('addr2sym') and \
                not SysMgr.checkMode('mkcache') and \
                not SysMgr.checkMode('sym2addr') and \
                not SysMgr.checkMode('topdiff') and \
                not SysMgr.checkMode('topsum') and \
                not SysMgr.checkMode('printdir') and \
                not SysMgr.checkMode('report') and \
                not SysMgr.checkMode('exec') and \
                not SysMgr.checkMode('comp') and \
                not SysMgr.checkMode('decomp') and \
                not SysMgr.checkMode('req') and \
                not SysMgr.checkMode('ping') and \
                not SysMgr.isHelpMode():
                if len(sys.argv) == 1:
                    arg = sys.argv[0]
                else:
                    arg = sys.argv[1]

                SysMgr.printErr(
                    '%s command is not supported on %s platform now' % \
                        (arg, sys.platform))
                sys.exit(0)
        else:
            SysMgr.printErr(
                '%s platform is not supported now' % sys.platform)
            sys.exit(0)

        # check locale #
        try:
            if SysMgr.encodeEnable:
                if 'NOENCODE' in os.environ:
                    SysMgr.encodeEnable = False
                else:
                    lang = os.getenv('LANG')
                    if not lang or not 'UTF' in lang:
                        SysMgr.encodeEnable = False
        except:
            pass

        # check python #
        if sys.version_info < (2, 6):
            SysMgr.printWarn(
                'python version is %d.%d so that some features may not work'
                % (sys.version_info[0], sys.version_info[1]))



    @staticmethod
    def onAlarmExit(signum, frame):
        SysMgr.updateTimer()

        sys.exit(0)



    @staticmethod
    def onAlarm(signum, frame):
        SysMgr.progressCnt += 1
        if SysMgr.repeatCount <= SysMgr.progressCnt:
            sys.exit(0)

        SysMgr.updateTimer()



    @staticmethod
    def checkProgress():
        if not SysMgr.countEnable:
            return

        if SysMgr.progressCnt >= SysMgr.repeatCount:
            # remove progress #
            UtilMgr.deleteProgress()

            try:
                os.kill(SysMgr.pid, signal.SIGINT)
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printSigError(SysMgr.pid, 'SIGINT')

        if SysMgr.repeatCount > 1:
            UtilMgr.printProgress(
                SysMgr.progressCnt, SysMgr.repeatCount)

        SysMgr.progressCnt += 1



    @staticmethod
    def getCmdString():
        cmdList = SysMgr.getCmdList()

        cmdbuf = ''
        for ctype, tvalue in sorted(cmdList.items()):
            prefix = ctype
            for cmd, cvalue in sorted(tvalue.items()):
                if len(prefix) > 0:
                    types = '[%s]' % prefix.upper()
                else:
                    types = ' '

                cmdbuf = '%s%4s%-12s%4s%-12s%4s<%-s>\n' % \
                    (cmdbuf, ' ', types, ' ', cmd, ' ', cvalue)
                prefix = ''
            cmdbuf = '%s\n' % cmdbuf

        return cmdbuf[:-1]



    @staticmethod
    def getCmdList():
        return {
            'monitor': {
                'atop': 'System',
                'bgtop': 'Background',
                'btop': 'Function',
                'ctop': 'Threshold',
                'cgtop': 'Cgroup',
                'dbustop': 'D-Bus',
                'disktop': 'Storage',
                'dlttop': 'DLT',
                'ftop': 'File',
                'mtop': 'Memory',
                'ntop': 'Network',
                'ptop': 'PMU',
                'rtop': 'JSON',
                'stacktop': 'Stack',
                'systop': 'Syscall',
                'top': 'Process',
                'ttop': 'Thread',
                'utop': 'Function',
                'pytop': 'Python',
                'wtop': 'WSS',
                },
            'trace': {
                'btrace': 'Breakpoint',
                'sigtrace': 'Signal',
                'strace': 'Syscall',
                'utrace': 'Function',
                },
            'profile': {
                'filerec': 'File',
                'funcrec': 'Function',
                'genrec': 'System',
                'mem': 'Page',
                'rec': 'Thread',
                'report': 'Report',
                'sysrec': 'Syscall',
                },
            'visual': {
                'convert': 'Text',
                'draw': 'System',
                'drawavg': 'Average',
                'drawcpu': 'CPU',
                'drawcpuavg': 'CPU',
                'drawdelay': 'Delay',
                'drawflame': 'Function',
                'drawio': 'I/O',
                'drawleak': 'Leak',
                'drawmem': 'Memory',
                'drawmemavg': 'Memory',
                'drawreq': 'URL',
                'drawrss': 'RSS',
                'drawrssavg': 'RSS',
                'drawtime': 'Timeline',
                'drawvss': 'VSS',
                'drawvssavg': 'VSS',
                },
            'util': {
                'addr2sym': 'Symbol',
                'dump': 'Memory',
                'exec': 'Command',
                'getafnt': 'Affinity',
                'comp': "Compress",
                'hook': 'Function',
                'kill/tkill': 'Signal',
                'leaktrace': 'Leak',
                'limitcpu': 'CPU',
                'mkcache': 'Cache',
                'pause': 'Thread',
                'ping': 'PING',
                'printbind': 'Funcion',
                'printcg': 'Cgroup',
                'printdbus': 'D-Bus',
                'printdbusinfo': 'D-Bus',
                'printdir': 'Dir',
                'printenv': 'Env',
                'printinfo': 'System',
                'printns': 'Namespace',
                'printsig': 'Signal',
                'printsub': 'D-Bus',
                'printsvc': 'systemd',
                'pstree': 'Process',
                'readelf': 'File',
                'remote': 'Command',
                'req': 'URL',
                'setafnt': 'Affinity',
                'setcpu': 'Clock',
                'setsched': 'Priority',
                'strings': 'Text',
                'sym2addr': 'Address',
                'systat': 'Status',
                'topdiff': 'Diff',
                'topsum': 'Summary',
                'decomp': 'Decompress',
                'watch': "File",
                },
            'log': {
                'logdlt': 'DLT',
                'logjrl': 'Journal',
                'logkmsg': 'Kernel',
                'logsys': 'Syslog',
                'printdlt': 'DLT',
                'printkmsg': 'Kernel',
                'printsys': 'Syslog',
                'printjrl': 'Journal',
                },
            'control': {
                'cli': 'Client',
                'event': 'Event',
                'list': 'List',
                'send': 'Signal',
                'server': 'Server',
                'start': 'Signal',
                },
            'test': {
                'cputest': 'CPU',
                'iotest ': 'Storage',
                'memtest': 'Memory',
                'nettest ': 'Network',
                },
            }



    @staticmethod
    def printHelp(force=False):
        printPipe = SysMgr.printPipe

        # help #
        if force or len(sys.argv) <= 1 or SysMgr.isHelpMode():
            # get environment variable from launcher #
            if 'CMDLINE' in os.environ:
                cmd = os.environ['CMDLINE']
            else:
                cmd = sys.argv[0]

            # remove pyc file extention #
            if '.pyc' in cmd:
                cmd = cmd[:cmd.find('.pyc')]

            # disable extended ascii code support #
            SysMgr.encodeEnable = False

            defStr = '''
Usage:
    $ {0:1} COMMAND|FILE [OPTIONS] [--help]
                '''.format(cmd)

            # command help #
            if force or \
                (len(sys.argv) > 1 and SysMgr.isHelpMode()):
                # get command #
                mode = sys.argv[1]

                topCommonStr = '''
    -o  <DIR|FILE>              set output path
    -u                          run in the background
    -W                          wait for input
    -b  <SIZE:KB>               set buffer size
    -T  <PROC>                  set process number
    -j  <DIR|FILE>              set report path
    -w  <TIME:FILE{:VALUE}>     set additional command
    -x  <IP:PORT>               set local address
    -X  <REQ@IP:PORT>           set request address
    -N  <REQ@IP:PORT>           set report address
    -S  <CHARACTER{:VALUE}>     sort by key
          [ c:cpu / m:mem / p:pid / N:name / b:block / w:wfc
            n:new / f:file / r:runtime:TIME / e:exectime:TIME
            P:prio / C:contextswitch / o:oomscore ]
    -P                          group threads in a same process
    -I  <DIR|FILE>              set input file
    -m  <ROWS:COLS:SYSTEM>      set terminal size
    -a                          show all stats and events
    -g  <COMM|TID{:FILE}>       set task filter
    -i  <SEC>                   set interval
    -R  <INTERVAL:TIME:TERM>    set repeat count
    -C  <PATH>                  set config file
    -c  <CMD>                   set hot command
    -Q                          print all rows in a stream
    -q  <NAME{:VALUE}>          set environment variables
    -J                          print in JSON format
    -L  <PATH>                  set log file
    -l  <TYPE>                  set log type
          [ dlt / kmsg / journal / syslog ]
    -E  <DIR>                   set cache dir
    -H  <LEVEL>                 set function depth level
    -G  <KEYWORD>               set ignore list
    -k  <COMM|TID:SIG{:CONT}>   set signal
    -z  <COMM|TID:MASK{:CONT}>  set CPU affinity
    -Y  <POLICY:PRIO|TIME       set sched
         {:TID|COMM:CONT}>
    -v                          verbose
                '''

                topSubStr = '''
Options:
    -e  <CHARACTER>             enable options
          [ a:affinity | b:block | c:cpu | C:compress
            d:disk | D:DWARF | e:encode | E:exec
            f:float | F:wfc | G:cgroup | h:sigHandler
            H:sched | i:irq | I:elastic | L:cmdline
            m:mem | n:net | N:namespace | o:oomScore
            O:color | p:pipe | P:perf | q:quit | r:report
            R:fileReport | s:stack | S:pss | t:thread
            T:total | u:uss | w:wss | W:wchan
            x:fixTarget | Y:delay ]
    -d  <CHARACTER>             disable options
          [ a:memAvailable | A:Average | b:buffer
            c:cpu | C:clone | D:DWARF | e:encode
            E:exec | g:generalInfo | G:gpu | L:log
            p:print | t:truncate | T:task ]
                '''

                drawSubStr = '''
Options:
    -e  <CHARACTER>             enable options
          [ d:disk | n:network ]
    -d  <CHARACTER>             disable options
          [ A:average ]
    -g  <COMM|TID{:FILE}>       set task filter
    -o  <DIR>                   set output path
    -a                          show all stats and events
    -T  <NUM>                   set top number
    -L  <RES:PER>               set graph layout (TOTAL PER: 6)
          [ C:CPU | D:delay | M:memory | I:io ]
    -l  <BOUNDARY>              set boundary lines
    -F  [svg/png/pdf/ps/eps]    set image format
    -E  <DIR>                   set cache dir path
    -C  <PATH>                  set config file
    -O  <CORE>                  set core filter
    -q  <NAME{:VALUE}>          set environment variables
    -v                          verbose
                    '''

                if SysMgr.checkMode('ttop'):
                    target = 'threads'
                else:
                    target = 'processes'

                topExamStr = '''
Examples:
    - Monitor status of {2:2} used CPU resource more than 1%% every interval
        # {0:1} {1:1}

    - Monitor status of {2:2} used CPU resource totally
        # {0:1} {1:1} -e T

    - Monitor status of all {2:2} with bar graphs for cores
        # {0:1} {1:1} -a -e B

    - Monitor status of all {2:2} sorted by memory(RSS)
        # {0:1} {1:1} -S m
        # {0:1} {1:1} -S m:500

    - Monitor status of all {2:2} sorted by execution time
        # {0:1} {1:1} -S e
        # {0:1} {1:1} -S e:2h

    - Monitor status of threads context-switched more than 5000 after sorting by Context Switch
        # {0:1} {1:1} -S C:5000

    - Report analysis results of {2:2} to ./guider.out when SIGINT signal arrives
        # {0:1} {1:1} -o .

    - Report analysis results of {2:2} with the fixed task list to save CPU resource for monitoring
        # {0:1} {1:1} -g a.out -e x

    - Monitor status and change priority for all {2:2} every second
        # {0:1} {1:1} -Y "c:-20::CONT" -a

    - Monitor status and change priority for specific {2:2} having name including a.out every second
        # {0:1} {1:1} -g a.out -Y "c:-20:a.out:CONT"

    - Report analysis results of {2:2} to ./guider.out with unlimited memory buffer
        # {0:1} {1:1} -o . -b 0

    - Report analysis results of {2:2} to ./guider.out with limited memory buffer 50MB
        # {0:1} {1:1} -o . -b 50m

    - Report analysis results of {2:2} to ./guider.out with limited memory buffer 50MB loss possible
        # {0:1} {1:1} -o . -d b

    - Report analysis results of {2:2} to ./guider.out in real-time until SIGINT signal arrives
        # {0:1} {1:1} -o . -e p

    - Report analysis results of {2:2} collected every 3 seconds for total 5 minutes to ./guider.out
        # {0:1} {1:1} -R 3s:5m -o .

    - Report analysis results of {2:2} collected every 3 seconds for 5 times to ./guider.out
        # {0:1} {1:1} -R 3s:5 -o .

    - Report analysis results of {2:2} collected every 10 seconds for 60 minutes to ./guider.out
        # {0:1} {1:1} -i 10 -R 60m -o .

    - Report analysis results of {2:2} collected every 3 seconds for 5 minutes to ./guider.out continuously
        # {0:1} {1:1} -R 3s:5m: -o .

    - Monitor status of {2:2} with memory(USS)
        # {0:1} {1:1} -e u

    - Monitor status of {2:2} with memory(PSS)
        # {0:1} {1:1} -e S

    - Monitor status of all {2:2} including block usage every 2 seconds
        # {0:1} {1:1} -e b -i 2 -a

    - Monitor status of {2:2} involved in a same process group with specific {2:2} having name including system
        # {0:1} {1:1} -g system -P

    - Monitor status of {2:2} on the minimum terminal
        # {0:1} {1:1} -m

    - Monitor status of {2:2} on the optimized terminal
        # {0:1} {1:1} -m :

    - Monitor status of {2:2} after optimizing system terminal
        # {0:1} {1:1} -m ::system

    - Monitor status of {2:2} and report to elastic search
        # {0:1} {1:1} -e I

    - Report analysis results of {2:2} to ./guider.out and console
        # {0:1} {1:1} -o . -Q

    - Monitor status of {2:2} and execute special commands
        # {0:1} {1:1} -w AFTER:/tmp/touched:1, AFTER:ls

    - Monitor status of {2:2} and report to 192.168.0.5:5555 in real-time
        # {0:1} {1:1} -e r -N REPORT_ALWAYS@192.168.0.5:5555

    - Monitor status of {2:2} after setting hot commands in advance
        # {0:1} {1:1} -c "{0:1} utop -g PID"
        # {0:1} {1:1} -c "{0:1} btrace -g PID *write*|getret\, __write_nocancel|getret"

    - Monitor status of {2:2} and execute specific commands for all tasks shown automatically
        # {0:1} {1:1} -c "{0:1} utop -g PID" -e E
        # {0:1} {1:1} -c "{0:1} btrace -g PID *write*|getret\, __write_nocancel|getret" -e E

    - Monitor status of {2:2} after setting config from guider.conf
        # {0:1} {1:1} -C guider.conf

    - Monitor status of {2:2} with no encoding lines
        # {0:1} {1:1} -d e
        # NOENCODE=1 {0:1} {1:1} -d e
                '''.format(cmd, mode, target)

                drawExamStr = '''
Examples:
    - Draw resource graph and memory chart
        # {0:1} {1:1} guider.out

    - Draw resource graph and timeline chart
        # {0:1} {1:1} guider.dat

    - Draw resource graph and timeline chart in ns timeunit
        # {0:1} {1:1} guider.dat -q TIMEUNIT:ns

    - Draw resource graph and event markers on specific points
        # {0:1} {1:1} guider.dat -q EVENT:14:90:EVENT_1:cpu, EVENT:30:100:EVENT_2:cpu

    - Draw resource graph and timeline chart for all events and tasks
        # {0:1} {1:1} guider.dat -a

    - Draw resource graph and timeline chart for specific cores
        # {0:1} {1:1} guider.dat -O 1, 4, 10

    - Draw resource graph and memory chart to specific image format
        # {0:1} {1:1} guider.out -F png
        # {0:1} {1:1} guider.out -F pdf
        # {0:1} {1:1} guider.out -F svg

    - Draw resource graph and timeline chart with config file
        # {0:1} {1:1} guider.dat -C config.json

    - Draw resource graph excluding chrome process and memory chart
        # {0:1} {1:1} guider.out -g ^chrome

    - Draw resource graph with some boundary lines
        # {0:1} {1:1} guider.out worstcase.out -l 80, 100, 120

    - Draw resource graph within specific interval range in second unit
        # {0:1} {1:1} guider.out -q TRIM:9:15
        # {0:1} {1:1} guider.out -q TRIM:0.9:1.5

    - Draw resource graph with y range 1-100
        # {0:1} {1:1} guider.out worstcase.out -q YRANGE:1:100

    - Draw resource graph with specific font size
        # {0:1} {1:1} guider.out worstcase.out -q FONTSIZE:15

    - Draw resource graph of top 5 processes
        # {0:1} {1:1} guider.out worstcase.out -T 5

    - Draw graphs of total CPU usage by applying the multiplication of the number of CPUs
        # {0:1} {1:1} guider.out worstcase.out -d A

    - Draw resource graph on customized layout
        # {0:1} {1:1} guider.out -L c:3, d:3
        # {0:1} {1:1} guider.out -L c:2, m:2, i:2
        # {0:1} {1:1} guider.out -L c:4, r:1, v:1

    - Draw resource graph on devices for block and network
        # {0:1} {1:1} guider.out -e d n

    - Draw resource graph with multiple files for comparison
        # {0:1} {1:1} "guider*.out" worstcase.out

    - Draw graphs of total resource usage with multiple files for comparison
        # {0:1} {1:1} "guider*.out" worstcase.out -a -g TOTAL
                '''.format(cmd, mode)

                brkExamStr = '''
Commands:
    acc      print accumulation stat [NAME:VAR|REG|VAL]
    check    check values [VAR|ADDR|REG:OP(EQ/DF/INC/BT/LT):VAR|VAL:SIZE:EVENT]
    condexit exit if tracing was started
    dist     print distribution stat [NAME:VAR|REG|VAL]
    dump     dump specific memory range to a file [NAME|ADDR:FILE]
    exec     execute command [CMD]
    exit     exit
    filter   print only filtered context [VAR|ADDR|REG:OP(EQ/DF/INC/BT/LT):VAR|VAL:SIZE]
    getarg   print specific registers [REGS]
    getenv   print specific environment variable [VAR]
    getret   print return value [CMD]
    jump     jump to specific function with specific arguments [FUNC#ARGS]
    kill     terminate target
    load     load specific library [PATH]
    log      print specific message [MESSAGE]
    map      print memory map
    print    print context [VAR]
    pyfile   execute specific python file [PATH:SYNC]
    pystr    execute python code [CODE:SYNC]
    rdmem    print specific memory or register [VAR|ADDR|REG:SIZE]
    repeat   call again repeatedly [CNT]
    ret      return specific value immediately [VAL]
    save     save previous value [VAR]
    setarg   change value for specific register [REG#VAR|VAL]
    setenv   change specific environment variable [VAR:VAR|VAL]
    setret   change return value [VAL:CMD]
    sleep    sleep for seconds [SEC]
    start    start printing all functions
    stop     pause tracing
    syscall  call a syscall [FUNC#ARGS]
    thread   create a new thread
    usercall call a specific function [FUNC#ARGS]
    wrmem    change specific memory or register [VAR|ADDR|REG:VAL:SIZE]

Examples:
    - Print all call contexts for a specific thread
        # {0:1} {1:1} -g 1234

    - Print all call contexts from a specific binary
        # {0:1} {1:1} "ls"
        # {0:1} {1:1} -I "ls"

    - Print all call contexts and standard output from a specific binary
        # {0:1} {1:1} "ls" -q NOMUTE

    - Print all call contexts except for wait status for a specific thread
        # {0:1} {1:1} a.out -g a.out -q EXCEPTWAIT

    - Print all call contexts except for register info for a specific thread
        # {0:1} {1:1} a.out -g a.out -q NOCONTEXT

    - Print all call contexts for a specific thread after loading all symbols in stop status
        # {0:1} {1:1} a.out -g a.out -q STOPTARGET

    - Print all call contexts except for no symbol functions for a specific thread
        # {0:1} {1:1} a.out -g a.out -q EXCEPTNOSYM

    - Print all call contexts except for ld for a specific thread
        # {0:1} {1:1} a.out -g a.out -q EXCEPTLD

    - Print all call contexts and injection info for a specific thread
        # {0:1} {1:1} a.out -g a.out -q TRACEINJECTION

    - Print all call contexts for 4th new threads in each new processes from a specific binary
        # {0:1} {1:1} a.out -g a.out -q TARGETNUM:4
        # {0:1} {1:1} -I a.out -g a.out -q TARGETNUM:4

    - Print all call contexts from a specific binary with DWARF info
        # {0:1} {1:1} -I "ls" -eD

    - Print all call contexts from a specific binary with environment variables
        # {0:1} {1:1} a.out -q ENV:TEST=1, ENV:PATH=/data
        # {0:1} {1:1} a.out -q ENVFILE:/data/env.sh

    - Print all call contexts with backtrace for a specific thread
        # {0:1} {1:1} -g a.out -H

    - Print printPeace call contexts for a specific thread
        # {0:1} {1:1} -g 1234 -c printPeace

    - Print all call contexts except for printPeace for a specific thread
        # {0:1} {1:1} -g 1234 -c ^printPeace

    - Print a specific call contexts from a specific binary
        # {0:1} {1:1} ~/test/mutex -c "std::_Vector_base<unsigned long\, std::allocator<unsigned long> >::~_Vector_base()"

    - Print printPeace call contexts only for 2 seconds
        # {0:1} {1:1} -g a.out -c printPeace -R 2s

    - Print printPeace call contexts and save them to ./guider.out
        # {0:1} {1:1} -g a.out -c printPeace -o . -a

    - Print specific call contexts including specific word
        # {0:1} {1:1} -g 1234 -c "*printPeace"
        # {0:1} {1:1} -g 1234 -c "printPeace*"
        # {0:1} {1:1} -g 1234 -c "*printPeace*"

    - Print all call contexts related to specific files
        # {0:1} {1:1} -g a.out -c -T /usr/bin/yes

    - Print all call contexts except for specific files
        # {0:1} {1:1} -g a.out -c -T ^/usr/bin/yes

    - Print specific call contexts including specific word and stop tracing
        # {0:1} {1:1} -g a.out -c "*printPeace|stop"
        # {0:1} {1:1} -g a.out -c "printPeace*|stop"
        # {0:1} {1:1} -g a.out -c "*printPeace*|stop"

    - Print all call contexts with 0.1 second sleep
        # {0:1} {1:1} -g a.out -c "*|sleep:0.1"

    - Print write call contexts with 0.1 second sleep only one time
        # {0:1} {1:1} -g a.out -c "write|oneshot:sleep:0.1"

    - Print write call contexts and kill the target thread
        # {0:1} {1:1} -g a.out -c "write|kill"

    - Print write call contexts and modify memory
        # {0:1} {1:1} -g a.out -c "write|wrmem:0x1234:aaaa:4"

    - Print write call contexts and modify memory pointed by 1st argument
        # {0:1} {1:1} -g a.out -c "write|wrmem:0:aaaa:4"

    - Print printf call contexts with 10-length string that 1st argument point to
        # {0:1} {1:1} -g a.out -c "printf|rdmem:0:10"

    - Print printf call contexts with 10-length string from the specific address
        # {0:1} {1:1} -g a.out -c "printf|rdmem:0x1234:10"

    - Print write call contexts and return a specific value immediately
        # {0:1} {1:1} -g a.out -c "write|ret:3"

    - Print write call contexts and dump stack to a file
        # {0:1} {1:1} -g a.out -c "write|dump:stack:stack.out"

    - Print write call contexts and dump specific memory range to a file
        # {0:1} {1:1} -g a.out -c "write|dump:0x1234-0x4567:dump.out"

    - Print write call contexts and return value
        # {0:1} {1:1} -g a.out -c "write|getret"

    - Print write call contexts and stop tracing and save return value to specific variable
        # {0:1} {1:1} -g a.out -c "write|getret:stop$print"

    - Print write call contexts and start tracing all calls
        # {0:1} {1:1} -g a.out -c "write|getret:start, *"

    - Print write call contexts with colorful elapsed time when the elapsed time exceed 0.1 second
        # {0:1} {1:1} -g a.out -c "write|getret" -q ELAPSED:0.1

    - Print write call contexts and call again repeatedly
        # {0:1} {1:1} -g a.out -c "write|repeat"
        # {0:1} {1:1} -g a.out -c "write|repeat:5"

    - Print write call contexts and change return value
        # {0:1} {1:1} -g a.out -c "write|setret:3"
        # {0:1} {1:1} -g a.out -c "write|setret:3:print"

    - Print write call contexts and modify 1st and 2nd arguments
        # {0:1} {1:1} -g a.out -c "write|setarg:0#2:1#5"

    - Print write call contexts and details
        # {0:1} {1:1} -g a.out -c "write|print"

    - Print write call contexts and save specific values to specific variables
        # {0:1} {1:1} -g a.out -c "write|save:VAR1|print:VAR1|save:VAR2:123"
        # {0:1} {1:1} -g a.out -c "write|save:ARG1:1:arg|print:VAR1"

    - Print write call contexts if call meets specific conditions
        # {0:1} {1:1} -g a.out -c "write|filter:2:EQ:4096"
        # {0:1} {1:1} -g a.out -c "write|filter:2:BT:0x1000"
        # {0:1} {1:1} -g a.out -c "write|filter:*1:EQ:HELLO"
        # {0:1} {1:1} -g a.out -c "write|filter:*1:INC:HE"

    - Print contexts for write call and return if only the elapsed time exceed 0.0005 second
        # {0:1} {1:1} -g a.out -c "write|filter:RET:BT:0.0005"
        # {0:1} {1:1} -g a.out -c "write|filter:RET:BT:0.0005" -H -a

    - Print write call contexts with specific check results
        # {0:1} {1:1} -g a.out -c "write|check:2:EQ:4096"
        # {0:1} {1:1} -g a.out -c "write|check:2:BT:0x1000"
        # {0:1} {1:1} -g a.out -c "write|check:*1:EQ:HELLO"
        # {0:1} {1:1} -g a.out -c "write|check:*1:INC:HE"
        # {0:1} {1:1} -g a.out -c "write|check:@RET1:EQ:@RET2:EVENT_CONT"

    - Print write call contexts and 1st and 2nd arguments
        # {0:1} {1:1} -g a.out -c "write|getarg:0:1"

    - Print write call contexts and 1st and 2nd arguments and save its return value to specific variable
        # {0:1} {1:1} -g a.out -c "write|getarg:0:1|save:writeRet"

    - Print a write call contexsts and start tracing all functions
        # {0:1} {1:1} -g a.out -c "write|start, *"

    - Print write call context and terminate target thread
        # {0:1} {1:1} -g a.out -c "write|exit"

    - Print specific call contexts and all call contexts within a specific range
        # {0:1} {1:1} -g a.out -c "open|start|getret:stop, *"
        # {0:1} {1:1} -g a.out -c "open|start|getret:exit, *"
        # {0:1} {1:1} -g a.out -c "open|start, *, close|getret:condexit"

    - Print write call contexts and call specific functions
        # {0:1} {1:1} -g a.out -c "write|usercall:sleep#3"
        # {0:1} {1:1} -g a.out -c "write|usercall:printf#PEACE"
        # {0:1} {1:1} -g a.out -c "write|usercall:printf#12345"
        # {0:1} {1:1} -g a.out -c "write|usercall:getenv#PATH, usercall:write#1#@getenv#1024"

    - Print write call contexts and call specific syscalls
        # {0:1} {1:1} -g a.out -c "write|syscall:getpid"
        # {0:1} {1:1} -g a.out -c "write|syscall:open#test.out#1"

    - Print write call contexts and load specific library
        # {0:1} {1:1} -g a.out -c "write|load:/usr/lib/preload.so"

    - Print write call contexts and create a thread
        # {0:1} {1:1} -g a.out -c "write|thread"

    - Print write call contexts and execute python code
        # {0:1} {1:1} -g a.out -c "write|pystr:print('OK')" -q LIBPYTHON:/usr/lib/x86_64-linux-gnu/libpython3.8.so.1.0
        # {0:1} {1:1} -g a.out -c "write|pyfile:test.py:false" -q LIBPYTHON:/usr/lib/x86_64-linux-gnu/libpython3.8.so.1.0

    - Print malloc call contexts and accumulated stats for specific argument
        # {0:1} {1:1} -g a.out -c "malloc|acc:CHUNK:0:arg"

    - Print malloc call contexts and distribution stats for specific argument
        # {0:1} {1:1} -g a.out -c "malloc|dist:CHUNK:0:arg"

    - Print write call contexts and jump to specific function with specific arguments
        # {0:1} {1:1} -g a.out -c "write|jump:sleep#5"

    - Print all call contexts and execute specific commands
        # {0:1} {1:1} -g a.out -c "*|exec:ls -lha:sleep 1"
        # {0:1} {1:1} -g a.out -c "*|exec:ls -lha &"
                '''.format(cmd, mode)

                reportStr = '''
    - report all analysis results for a specific thread having TID 1234 to ./guider.out
        # {0:1} guider.dat -o . -g 1234 -a

    - report all analysis results including interval information for all threads to ./guider.out
        # {0:1} guider.dat -o . -a -i

    - report analysis results including preemption info for specific threads to ./guider.out
        # {0:1} guider.dat -o . -p 1234, 4567

    - report all analysis results for specific threads including other threads involved in the same process to ./guider.out
        # {0:1} guider.dat -o . -P -g 1234, 4567 -a

    - report all function analysis result with maximum 3-depth for a specific thread having TID 1234 to ./guider.out
        # {0:1} guider.dat -o . -g 1234 -H 3
                '''.format(cmd)

                logCommonStr = '''
Usage:
    # {0:1} {1:1} -I <MESSAGE>

Description:
    Log a message

Options:
    -v                          verbose
    -R  <INTERVAL:TIME>         set repeat count
    -I  <LOG>                   set log message

Examples:
    - Log a message
        # {0:1} {1:1} "Hello World!"
        # {0:1} {1:1} -I "Hello World!"
                    '''.format(cmd, mode)

                printCommonStr = '''
Usage:
    # {0:1} {1:1}

Description:
    Print logs in real-time

Options:
    -v                          verbose
    -g  <WORD|TID>              set filter
    -c  <LEVEL>                 set log level
    -I  <FILE|FIELD>            set path / field
    -J                          print in JSON format
    -o  <DIR|FILE>              set output path
    -X  <REQ@IP:PORT>           set request address

Examples:
    - Print logs in real-time
        # {0:1} {1:1}

    - Print logs to the sepcific file
        # {0:1} {1:1} -o log.out
                    '''.format(cmd, mode)

                # function record #
                if SysMgr.checkMode('funcrec'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Record function events
                        '''.format(cmd, mode)

                    helpStr += '''
Options:
  [collect]
    -e  <CHARACTER>             enable options
          [ b:block | c:cgroup | e:encode | g:graph
            h:heap | L:lock | m:mem | p:pipe ]
    -d  <CHARACTER>             disable options
          [ a:all | c:cpu | C:compress | e:encode
            g:generalInfo | l:latency | L:log | u:user ]
    -s  <DIR|FILE>              save trace data
    -f                          force execution
    -u                          run in the background
    -b  <SIZE:KB>               set buffer size
    -t  <SYSCALL>               trace syscall
    -B  <DIR|FILE>              set command script path
    -W                          wait for input
    -w  <TIME:FILE{:VALUE}>     set additional command
    -U  <NAME:FUNC|ADDR:FILE>   set user event
    -K  <NAME:FUNC|ADDR:ARGS>   set kernel event

  [report]
    -o  <DIR|FILE>              set output path
    -S  <CHARACTER>             sort by key
          [ c:cpu / m:memory / p:pid / b:block / w:wfc
            n:new / r:runtime /file ]
    -P                          group threads in a same process
    -O  <CORE>                  set core filter
    -r  <DIR>                   set root path
    -m  <ROWS:COLS:SYSTEM>      set terminal size

  [common]
    -a                          show all stats and events
    -C  <PATH>                  set config path
    -g  <COMM|TID{:FILE}>       set task filter
    -R  <INTERVAL:TIME:TERM>    set repeat count
    -Q                          print all rows in a stream
    -q  <NAME{:VALUE}>          set environment variables
    -A  <ARCH>                  set CPU type
    -c  <EVENT:COND>            set custom event
    -E  <DIR>                   set cache dir path
    -H  <LEVEL>                 set function depth level
    -k  <COMM|TID:SIG{:CONT}>   set signal
    -z  <COMM|TID:MASK{:CONT}>  set CPU affinity
    -Y  <POLICY:PRIO|TIME       set sched
         {:TID|COMM:CONT}>
    -v                          verbose
                    '''

                    helpStr += '''
Examples:
    - record default function events for all threads to ./guider.dat
        # {0:1} {1:1} -s .

    - record default function events for all threads to ./guider.dat for only 3 minutes
        # {0:1} {1:1} -s . -R 3m

    - record default function events for all threads to ./guider.dat every 3 minutes continuously
        # {0:1} {1:1} -s . -R 3m:1:

    - record default function events for specific threads having TID bigger than 1024 to ./guider.dat in the background
        # {0:1} {1:1} -s . -g 1024\< -u

    - record specific function events including memory, block, heap for all threads to ./guider.dat
        # {0:1} {1:1} -s . -e m, b, h

    - record specific function events including all syscalls for all threads to ./guider.dat
        # {0:1} {1:1} -s . -t

    - record specific function events including softirq_entry event for all threads to ./guider.dat
        # {0:1} {1:1} -s . -c softirq_entry:vec==1

    - record specific function events including segmentation fault for all threads to ./guider.dat in real-time
        # {0:1} {1:1} -s . -d c -K segflt:bad_area -e p

    - record specific function events including blocking for all threads to ./guider.dat
        # {0:1} {1:1} -s . -d c -K block:schedule

    - record default function events for all threads to ./guider.dat and execute user commands
        # {0:1} {1:1} -s . -w BEFORE:/tmp/started:1, BEFORE:ls

    - record all kernel function calls for all threads to ./guider.dat
        # {0:1} {1:1} -s . -e g
                    '''.format(cmd, mode)

                    helpStr += reportStr

                # file record #
                elif SysMgr.checkMode('filerec'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Record on-memory file status
                        '''.format(cmd, mode)

                    helpStr += '''
Options:
    -e  <CHARACTER>             enable options
          [ p:pipe | e:encode ]
    -d  <CHARACTER>             disable options
          [ e:encode | g:genearlInfo ]
    -s  <DIR|FILE>              save trace data
    -u                          run in the background
    -W                          wait for input
    -w  <TIME:FILE{:VALUE}>     set additional command
    -o  <DIR|FILE>              set output path
    -m  <ROWS:COLS:SYSTEM>      set terminal size
    -a                          show all stats and events
    -g  <COMM|TID{:FILE}>       set task filter
    -Q                          print all rows in a stream
    -q  <NAME{:VALUE}>          set environment variables
    -E  <DIR>                   set cache dir path
    -v                          verbose
                    '''

                    helpStr += '''
Examples:
    - report all analysis results of files mapped to all processes to ./guider.out
        # {0:1} {1:1} -o . -a

    - report all analysis results of files mapped to specific processes
        # {0:1} {1:1} -g a.out

    - report analysis result on each intervals of files mapped to all processes to ./guider.out
        # {0:1} {1:1} -o . -i
                    '''.format(cmd, mode)

                # syscall record #
                elif SysMgr.checkMode('sysrec'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Record syscall events
                        '''.format(cmd, mode)

                    helpStr += '''
Options:
    -e  <CHARACTER>             enable options
          [ p:pipe | e:encode ]
    -d  <CHARACTER>             disable options
          [ e:encode | g:genearlInfo ]
    -s  <DIR|FILE>              save trace data
    -u                          run in the background
    -b  <SIZE:KB>               set buffer size
    -t  <SYSCALL>               trace syscall
    -W                          wait for input
    -w  <TIME:FILE{:VALUE}>     set additional command
    -o  <DIR|FILE>              set output path
    -m  <ROWS:COLS:SYSTEM>      set terminal size
    -a                          show all stats and events
    -g  <COMM|TID{:FILE}>       set task filter
    -E  <DIR>                   set cache dir path
    -v                          verbose
                    '''

                    helpStr += '''
Examples:
    - record all syscall events of all threads to ./guider.dat
        # {0:1} {1:1} -s .

    - report analysis result of specific syscalls to ./guider.out
        # {0:1} guider.dat -o . -t read, write
                    '''.format(cmd, mode)

                # report #
                elif SysMgr.checkMode('report'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Report analysis result based on guider.dat
                        '''.format(cmd, mode)

                    helpStr += '''
Options:
    -e  <CHARACTER>             enable options
          [ p:pipe | e:encode ]
    -d  <CHARACTER>             disable options
          [ e:encode | g:genearlInfo ]
    -o  <DIR|FILE>              set output path
    -m  <ROWS:COLS:SYSTEM>      set terminal size
    -a                          show all stats and events
    -g  <COMM|TID{:FILE}>       set task filter
    -I  <DIR|FILE>              set input path
    -q  <NAME{:VALUE}>          set environment variables
    -E  <DIR>                   set cache dir path
    -v                          verbose
                    '''

                    helpStr += '''
Examples:
    - report analysis result based on guider.dat to ./guider.out
        # {0:1} {1:1}

    - report all analysis result based on guider.dat for a specific thread to ./guider.out
        # {0:1} {1:1} -g 1234 -a

    - report analysis result based on guider.dat to ./guider.out with high time resolution
        # {0:1} {1:1} -q PRECISE
                    '''.format(cmd, mode)

                    helpStr += reportStr

                # general record #
                elif SysMgr.checkMode('genrec'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Record system status
                        '''.format(cmd, mode)

                    helpStr += '''
Options:
    -e  <CHARACTER>             enable options
          [ p:pipe | e:encode ]
    -d  <CHARACTER>             disable options
          [ e:encode | g:genearlInfo ]
    -s  <DIR|FILE>              save trace data
    -u                          run in the background
    -W                          wait for input
    -o  <DIR|FILE>              set output path
    -m  <ROWS:COLS:SYSTEM>      set terminal size
    -Q                          print all rows in a stream
    -q  <NAME{:VALUE}>          set environment variables
    -E  <DIR>                   set cache dir path
    -v                          verbose
                    '''

                    helpStr += '''
Examples:
    - report analysis results of system to ./guider.out
        # {0:1} {1:1} -o .
                    '''.format(cmd, mode)

                # thread record #
                elif SysMgr.checkMode('rec'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Record thread events
                        '''.format(cmd, mode)

                    helpStr += '''
Options:
  [collect]
    -e  <CHARACTER>             enable options
          [ b:block | B:binder | c:cgroup | d:disk
            e:encode | g:graph | i:irq | I:i2c
            L:lock | m:mem | n:net | p:pipe
            r:reset | P:power | w:workqueue ]
    -d  <CHARACTER>             disable options
          [ a:all | c:cpu | C:compress | e:encode
            g:generalInfo ]
    -s  <DIR|FILE>              save trace data
    -f                          force execution
    -u                          run in the background
    -W                          wait for input
    -b  <SIZE:KB>               set buffer size
    -D                          trace thread dependency
    -t  <SYSCALL>               trace syscall
    -B  <DIR|FILE>              set command script path
    -w  <TIME:FILE{:VALUE}>     set additional command
    -U  <NAME:FUNC|ADDR:FILE>   set user event
    -K  <NAME:FUNC|ADDR:ARGS>   set kernel event
    -R  <INTERVAL:TIME:TERM>    set repeat count

  [report]
    -a                          show all stats and events
    -o  <DIR|FILE>              set output path
    -S  <CHARACTER>             sort by key
          [ c:cpu / m:memory / p:pid / b:block
            w:wfc / n:new / r:runtime / f:file ]
    -P                          group threads in a same process
    -p  <TID>                   show preemption info
    -O  <CORE>                  set core filter
    -L  <RES:PER>               set graph layout (TOTAL PER: 6)
    -m  <ROWS:COLS:SYSTEM>      set terminal size
    -i  <SEC>                   set interval
    -Q                          print all rows in a stream
    -q  <NAME{:VALUE}>          set environment variables

  [common]
    -g  <COMM|TID{:FILE}>       set task filter
    -C  <PATH>                  set config path
    -A  <ARCH>                  set CPU type
    -c  <EVENT:COND>            set custom event
    -E  <DIR>                   set cache dir path
    -k  <COMM|TID:SIG{:CONT}>   set signal
    -z  <COMM|TID:MASK{:CONT}>  set CPU affinity
    -Y  <POLICY:PRIO|TIME       set sched
         {:TID|COMM:CONT}>
    -v                          verbose
                    '''

                    helpStr += '''
Examples:
    - record default events of all threads to ./guider.dat
        # {0:1} {1:1} -s .

    - record default events of specific threads that having TID bigger than 1234 to ./guider.dat
        # {0:1} {1:1} -s . -g ">1234"

    - record default events of all threads and their commands
        # {0:1} {1:1} -s . -B

    - record default events of all threads to ./guider.dat for only 3 seconds
        # {0:1} {1:1} -s . -R 3

    - record default events of all threads to ./guider.dat every 3 seconds continuously
        # {0:1} {1:1} -s . -R 3:1:

    - record specific events including memory, block, irq of all threads to ./guider.dat in the background
        # {0:1} {1:1} -s . -e m, b, i -u

    - record default events including specific syscalls of all threads to ./guider.dat
        # {0:1} {1:1} -s . -t sys_read, write

    - record default events including lock of all threads to ./guider.dat
        # {0:1} {1:1} -s . -e L

    - record default events including specific user function of all threads to ./guider.dat
        # {0:1} {1:1} -s . -U evt1:func1:/tmp/a.out, evt2:0x1234:/tmp/b.out -q OBJDUMP:/usr/bin/objdump

    - record default events including specific kernel function of all threads to ./guider.dat
        # {0:1} {1:1} -s . -d c -K evt1:func1:u32, evt2:0x1234:s16, evt3:func2:x16

    - record default events including specific kernel function with args of all threads on x86 to ./guider.dat
        # {0:1} {1:1} -s . -d c -K open:do_sys_open:dfd=%ax\ filename=%bx\;u64\ flags=%cx\;s32\ mode=+4\($stack\):NONE

    - record default events including specific kernel function with register values of all threads on x86 to ./guider.dat
        # {0:1} {1:1} -s . -d c -K strace32:func1:%bp/u32.%sp/s64, strace:0x1234:$stack:NONE

    - record default events including specific kernel function with the return value of all threads to ./guider.dat
        # {0:1} {1:1} -s . -d c -K openfile:getname::*string, access:0x1234:NONE:*string
        # {0:1} {1:1} -s . -d c -K openfile:getname::**string, access:0x1234:NONE:*string

    - record default events of all threads to ./guider.dat and execute user commands
        # {0:1} {1:1} -s . -w BEFORE:/tmp/started:1, BEFORE:ls

    - report analysis result for all threads to ./guider.out
        # {0:1} guider.dat -o .

    - convert event data compressed to original one
        # {0:1} guider.dat -s .
                    '''.format(cmd, mode)

                    helpStr += reportStr

                # file top #
                elif SysMgr.checkMode('ftop'):
                    fileTopStr = topCommonStr

                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Monitor the status of open files, sockets, pipes
                        '''.format(cmd, mode)

                    examStr = '''
Examples:
    - Monitor open files including null of all processes
        # {0:1} {1:1} -g :null

    - Monitor open files of specific processes including system
        # {0:1} {1:1} -g system

    - Monitor all processes sorted by the number of file descriptors
        # {0:1} {1:1} -S f

    - Report analysis result of open files to ./guider.out
        # {0:1} {1:1} -o .

    See the top COMMAND help for more examples.
                    '''.format(cmd, mode)

                    helpStr += fileTopStr + examStr

                # thread top #
                elif SysMgr.checkMode('ttop'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Monitor the status of threads
                        '''.format(cmd, mode)

                    helpStr += topSubStr + topCommonStr + topExamStr

                # cgroup top #
                elif SysMgr.checkMode('cgtop'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Monitor the status of cgroup
                        '''.format(cmd, mode)

                    helpStr += topSubStr + topCommonStr + topExamStr

                # syscall top #
                elif SysMgr.checkMode('systop'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} -g <TARGET> [OPTIONS] [--help]

Description:
    Monitor syscalls for a specific thread
                        '''.format(cmd, mode)

                    examStr = '''
Examples:
    - Monitor syscalls
        # {0:1} {1:1} -g a.out

    - Monitor syscalls with backtrace for a specific thread
        # {0:1} {1:1} -g a.out -H

    - Monitor syscalls for child tasks created by a specific thread
        # {0:1} {1:1} -g a.out -W

    - Monitor syscalls for a specific thread every 2 second
        # {0:1} {1:1} -g 1234 -R 2:

    - Monitor CPU usage on whole system of syscalls for a specific thread
        # {0:1} {1:1} -g a.out -e c

    - Monitor syscalls with breakpoint for read including register info for a specific thread
        # {0:1} {1:1} -g 1234 -c read -a

    See the top COMMAND help for more examples.
                    '''.format(cmd, mode)

                    helpStr += topSubStr + topCommonStr + examStr

                # python top #
                elif SysMgr.checkMode('pytop'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} -g <TARGET> [OPTIONS] [--help]

Description:
    Monitor python methods consuming CPU
                        '''.format(cmd, mode)

                    examStr = '''
Examples:
    - Monitor python methods for a specific thread
        # {0:1} {1:1} -g a.out

    - Monitor python methods for child tasks created by a specific thread
        # {0:1} {1:1} -g a.out -W

    - Monitor python methods with backtrace for a specific thread
        # {0:1} {1:1} -g a.out -H

    - Monitor python methods for a specific thread every 2 second for 1 minute with 1 ms sampling
        # {0:1} {1:1} -g 1234 -T 1000 -i 2 -R 1m

    - Monitor CPU usage on whole system of python methods for a specific thread
        # {0:1} {1:1} -g a.out -e c

    - Monitor python methods with breakpoint for peace including register info for a specific thread
        # {0:1} {1:1} -g 1234 -c peace -a

    See the top COMMAND help for more examples.
                    '''.format(cmd, mode)

                    helpStr += topSubStr + topCommonStr + examStr

                # usercall top #
                elif SysMgr.checkMode('utop'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} -g <TARGET> [OPTIONS] [--help]

Description:
    Monitor function calls consuming CPU
                        '''.format(cmd, mode)

                    examStr = '''
Examples:
    - Monitor function calls for a specific thread
        # {0:1} {1:1} -g a.out

    - Monitor function calls from a specific binary
        # {0:1} {1:1} a.out
        # {0:1} {1:1} -I a.out

    - Monitor function calls and standard output from a specific binary
        # {0:1} {1:1} a.out -q NOMUTE

    - Monitor function calls for specific threads from a specific binary
        # {0:1} {1:1} a.out -g a.out
        # {0:1} {1:1} -I a.out -g a.out

    - Monitor function calls except for wait status for a specific thread
        # {0:1} {1:1} a.out -g a.out -q EXCEPTWAIT

    - Monitor function calls except for register info for a specific thread
        # {0:1} {1:1} a.out -g a.out -q NOCONTEXT

    - Monitor function calls except for no symbol functions for a specific thread
        # {0:1} {1:1} a.out -g a.out -q EXCEPTNOSYM

    - Monitor function calls for a specific thread after loading all symbols in stop status
        # {0:1} {1:1} a.out -g a.out -q STOPTARGET

    - Monitor function calls for 4th new threads in each new processes from a specific binary
        # {0:1} {1:1} a.out -g a.out -q TARGETNUM:4
        # {0:1} {1:1} -I a.out -g a.out -q TARGETNUM:4

    - Monitor function calls for a specific binary execution with enviornment variables
        # {0:1} {1:1} a.out -q ENV:TEST=1, ENV:PATH=/data
        # {0:1} {1:1} a.out -q ENVFILE:/data/env.sh

    - Monitor function calls for a specific thread with DWARF info
        # {0:1} {1:1} -g a.out -eD

    - Monitor function calls for child tasks created by a specific thread
        # {0:1} {1:1} -g a.out -W

    - Monitor function calls with backtrace for a specific thread
        # {0:1} {1:1} -g a.out -H

    - Monitor function calls for a specific thread every 2 second for 1 minute with 1 ms sampling
        # {0:1} {1:1} -g 1234 -T 1000 -i 2 -R 1m

    - Monitor CPU usage on whole system of function calls for a specific thread
        # {0:1} {1:1} -g a.out -e c

    - Monitor function calls with breakpoint for peace including register info for a specific thread
        # {0:1} {1:1} -g 1234 -c peace -a

    See the top COMMAND help for more examples.
                    '''.format(cmd, mode)

                    helpStr += topSubStr + topCommonStr + examStr

                # break top #
                elif SysMgr.checkMode('btop'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} -g <TARGET> [OPTIONS] [--help]

Description:
    Monitor function calls
                        '''.format(cmd, mode)

                    examStr = '''
    {0:1}

    See the top COMMAND help for more examples.
                    '''.format(brkExamStr)

                    helpStr += topSubStr + topCommonStr + examStr

                # all top #
                elif SysMgr.checkMode('atop'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Monitor all system resources
                        '''.format(cmd, mode)

                    examStr = '''
Examples:
    - Monitor system resource
        # {0:1} {1:1}

    See the top COMMAND help for more examples.
                    '''.format(cmd, mode)

                    helpStr += topCommonStr + examStr

                # condition top #
                elif SysMgr.checkMode('ctop'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Monitor resources by threshold
                        '''.format(cmd, mode)

                    examStr = '''
Examples:
    - Monitor resources by condition
        # {0:1} {1:1}
        # {0:1} {1:1} -C /tmp/guider.conf

    See the top COMMAND help for more examples.
                    '''.format(cmd, mode)

                    helpStr += topCommonStr + examStr

                # stack top #
                elif SysMgr.checkMode('stacktop'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} -g <TARGET> [OPTIONS] [--help]

Description:
    Monitor kernel stacks for threads
                        '''.format(cmd, mode)

                    examStr = '''
Examples:
    - Monitor kernel stacks for specific threads
        # {0:1} {1:1} -g chrome

    See the top COMMAND help for more examples.
                    '''.format(cmd, mode)

                    helpStr += topSubStr + topCommonStr + examStr

                # perf top #
                elif SysMgr.checkMode('ptop'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Monitor performance stats by PMU(Performance Monitoring Unit)
                        '''.format(cmd, mode)

                    examStr = '''
Examples:
    - Monitor performance stats of specific threads
        # {0:1} {1:1} -g chrome

    See the top COMMAND help for more examples.
                    '''.format(cmd, mode)

                    helpStr += topSubStr + topCommonStr + examStr

                # mem top #
                elif SysMgr.checkMode('mtop'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Monitor memory details
                        '''.format(cmd, mode)

                    examStr = '''
Examples:
    - Monitor memory details of specific processes
        # {0:1} {1:1} -g chrome

    See the top COMMAND help for more examples.
                    '''.format(cmd, mode)

                    helpStr += topSubStr + topCommonStr + examStr

                # wss top #
                elif SysMgr.checkMode('wtop'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} -g <TARGET> [OPTIONS] [--help]

Description:
    Monitor WSS(Working Set Size) of processes after clearing page reference bits
                        '''.format(cmd, mode)

                    examStr = '''
Examples:
    - Monitor WSS(Working Set Size) change of specific processes
        # {0:1} {1:1} -g chrome

    See the top COMMAND help for more examples.
                    '''.format(cmd, mode)

                    helpStr += topSubStr + topCommonStr + examStr

                # report top #
                elif SysMgr.checkMode('rtop'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Report system status in JSON format
                        '''.format(cmd, mode)

                    examStr = '''
Examples:
    - Report system status in JSON format to /tmp/guider.report
        # {0:1} {1:1}

    - Report system status in JSON format to console standard output
        # {0:1} {1:1} -Q

    - Report system status in JSON format to ./guider.report in the background every second
        # {0:1} {1:1} -j . -u

    - Stop reporting processes in the background
        # {0:1} stop

    See the top COMMAND help for more examples.
                    '''.format(cmd, mode)

                    helpStr += topSubStr + topCommonStr + examStr

                # background top #
                elif SysMgr.checkMode('bgtop'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Collect system status in the background until get a stop signal
                        '''.format(cmd, mode)

                    examStr = '''
Examples:
    - Collect system status to ./guider.out in the background
        # {0:1} {1:1} -o .

    - Stop collecting processes in the background and let them report system analysis result
        # {0:1} stop

    See the top COMMAND help for more examples.
                    '''.format(cmd, mode)

                    helpStr += topSubStr + topCommonStr + examStr

                # disk top #
                elif SysMgr.checkMode('disktop'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Monitor storage status
                        '''.format(cmd, mode)

                    examStr = '''
Examples:
    - Monitor status of all storages
        # {0:1} {1:1}

    See the top COMMAND help for more examples.
                    '''.format(cmd, mode)

                    helpStr += topSubStr + topCommonStr + examStr

                # DLT top #
                elif SysMgr.checkMode('dlttop'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Monitor DLT logs
                        '''.format(cmd, mode)

                    examStr = '''
Examples:
    - Monitor DLT logs
        # {0:1} {1:1}

    - Monitor DLT logs using libdlt.so from specific path
        # {0:1} {1:1} -q LIBDLT:/home/iipeace/test/libdlt.so

    - Change default log level to be printed
        # {0:1} {1:1} -c INFO

    - Monitor DLT logs including specific string
        # {0:1} {1:1} -g test

    - Monitor DLT logs from specific address for dlt-daemon
        # {0:1} {1:1} -X 127.0.0.1:12345

    See the top COMMAND help for more examples.
                    '''.format(cmd, mode)

                    helpStr += topSubStr + topCommonStr + examStr

                # dbus top #
                elif SysMgr.checkMode('dbustop'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Monitor D-Bus messages
                        '''.format(cmd, mode)

                    examStr = '''
Examples:
    - Monitor D-Bus messages
        # {0:1} {1:1}

    - Monitor D-Bus messages including DBus interfaces
        # {0:1} {1:1} -g dbus-daemon

    - Monitor D-Bus messages for dbus-client process
        # {0:1} {1:1} -g dbus-client

    - Monitor D-Bus messages including specific word
        # {0:1} {1:1} -c test

    - Monitor D-Bus messages except for specific messages
        # {0:1} {1:1} -G sendData

    - Monitor D-Bus messages for a specific session bus
        # DBUS_SESSION_BUS_ADDRESS=$(cat addr) {0:1} {1:1}

    See the top COMMAND help for more examples.
                    '''.format(cmd, mode)

                    helpStr += topSubStr + topCommonStr + examStr

                # network top #
                elif SysMgr.checkMode('ntop'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Monitor network status
                        '''.format(cmd, mode)

                    examStr = '''
Examples:
    - Monitor status of all network devices
        # {0:1} {1:1}

    See the top COMMAND help for more examples.
                    '''.format(cmd, mode)

                    helpStr += topSubStr + topCommonStr + examStr

                # process top #
                elif SysMgr.isTopMode():
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Monitor process status
                        '''.format(cmd, mode)

                    helpStr += topSubStr + topCommonStr + topExamStr

                # strings #
                elif SysMgr.checkMode('strings'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} -g <TARGET> [OPTIONS] [--help]

Description:
    Print the sequences of printable characters in files
                        '''.format(cmd, mode)

                    helpStr += '''
Options:
    -I  <FILE>                  set file path
    -o  <DIR|FILE>              set output path
    -m  <ROWS:COLS:SYSTEM>      set terminal size
    -v                          verbose
                    '''

                    helpStr += '''
Examples:
    - Print the sequences of printable characters in files
        # {0:1} {1:1} -I a.out
                    '''.format(cmd, mode)

                # dump #
                elif SysMgr.checkMode('dump'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} -g <TARGET> [OPTIONS] [--help]

Description:
    Dump target memory
                        '''.format(cmd, mode)

                    helpStr += '''
Options:
    -u                          run in the background
    -a                          show all stats including registers
    -g  <COMM|TID>              set task filter
    -I  <RANGE>                 set memory address
    -R  <TIME>                  set timer
    -o  <DIR|FILE>              set output path
    -m  <ROWS:COLS:SYSTEM>      set terminal size
    -v                          verbose
                    '''

                    helpStr += '''
Examples:
    - Dump target memory to the sepcific file
        # {0:1} {1:1} -g a.out -I 0x1234-0x4567 -o dump.out

    - Dump target memory mapped to a specific file to the sepcific file
        # {0:1} {1:1} -g a.out -I a.out -o dump.out

    - Dump target stack to the sepcific file
        # {0:1} {1:1} -g a.out -I stack -o dump.out

    - Dump target heap to the sepcific file
        # {0:1} {1:1} -g a.out -I heap -o dump.out
                    '''.format(cmd, mode)

                # strace #
                elif SysMgr.checkMode('strace'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} -g <TARGET> [OPTIONS] [--help]

Description:
    Trace syscalls
                        '''.format(cmd, mode)

                    helpStr += '''
Options:
    -e  <CHARACTER>             enable options
          [ p:pipe | e:encode ]
    -d  <CHARACTER>             disable options
          [ C:clone | e:encode | E:exec | g:generalInfo | O:color ]
    -u                          run in the background
    -a                          show all stats including registers
    -g  <COMM|TID{:FILE}>       set task filter
    -I  <COMMAND>               set command
    -R  <TIME>                  set timer
    -c  <EVENT>                 set breakpoint
    -l                          print syscall list
    -o  <DIR|FILE>              set output path
    -m  <ROWS:COLS:SYSTEM>      set terminal size
    -E  <DIR>                   set cache dir path
    -q  <NAME{:VALUE}>          set environment variables
    -v                          verbose
                    '''

                    helpStr += '''
Examples:
    - Trace all read syscalls for a specific thread
        # {0:1} {1:1} -g a.out -t read

    - Trace all read syscalls for child tasks created by a specific thread
        # {0:1} {1:1} -g 1234 -t read -W

    - Trace all write syscalls with specific command
        # {0:1} {1:1} -I "ls -al" -t write

    - Trace all write syscalls with specific command and print standard output
        # {0:1} {1:1} -I "ls -al" -t write -q NOMUTE

    - Trace all write syscalls with colorful elapsed time when the elapsed time exceed 0.1 second
        # {0:1} {1:1} -g a.out -c write -q ELAPSED:0.1

    - Trace all read syscalls for a specific thread and save summary tables, call history to ./guider.out
        # {0:1} {1:1} -g a.out -t read -o . -a

    - Trace all syscalls with breakpoint for read including register info for a specific thread
        # {0:1} {1:1} -g a.out -c read -a

    - Trace all syscalls for a specific thread only for 1 minute
        # {0:1} {1:1} -g a.out -R 1m

    - Trace all syscalls and pause when catching open syscall
        # {0:1} {1:1} -I "ls -al" -c open

    - Trace all syscalls and sleep for 1.5 second when catching open syscall
        # {0:1} {1:1} -I "ls -al" -c "open|sleep:1.5"

    - Trace all syscalls and sleep for 1.5 second whenever catching syscall
        # {0:1} {1:1} -I "ls -al" -c "*|sleep:1.5"

    - Trace all syscalls and print memory that 2nd argument point to
        # {0:1} {1:1} -I "ls -al" -c "write|rdmem:1"
                    '''.format(cmd, mode)

                # utrace #
                elif SysMgr.checkMode('utrace'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} -g <TARGET> [OPTIONS] [--help]

Description:
    Trace function calls
                        '''.format(cmd, mode)

                    helpStr += '''
Options:
    -e  <CHARACTER>             enable options
          [ p:pipe | D:DWARF | e:encode ]
    -d  <CHARACTER>             disable options
          [ C:clone | e:encode | D:DWARF | E:exec | g:generalInfo ]
    -u                          run in the background
    -a                          show all stats including registers
    -g  <COMM|TID{:FILE}>       set task filter
    -I  <COMMAND>               set command
    -R  <TIME>                  set timer
    -c  <EVENT>                 set breakpoint
    -H  <SKIP>                  set instrunction sampling rate
    -o  <DIR|FILE>              set output path
    -m  <ROWS:COLS:SYSTEM>      set terminal size
    -E  <DIR>                   set cache dir path
    -v                          verbose
                    '''

                    helpStr += '''
Examples:
    - Trace usercalls for a specific thread in 100us cycles
        # {0:1} {1:1} -g a.out

    - Trace usercalls for child tasks created by a specific thread
        # {0:1} {1:1} -g a.out -W

    - Trace usercalls from a specific binary
        # {0:1} {1:1} "ls -al"
        # {0:1} {1:1} -I "ls -al"

    - Trace usercalls for specific threads from a specific binary
        # {0:1} {1:1} "ls -al" -g a.out
        # {0:1} {1:1} -I "ls -al" -g a.out

    - Trace usercalls for a specific thread in 10ms cycles
        # {0:1} {1:1} -g a.out -i 10000

    - Trace usercalls for a specific thread and print standard output
        # {0:1} {1:1} -g a.out -i 10000 -q NOMUTE

    - Trace usercalls with 1/10 instructions for a specific thread
        # {0:1} {1:1} -g a.out -H 10

    - Trace usercalls for a specific thread and save summary tables, call history to ./guider.out
        # {0:1} {1:1} -g a.out -o . -a

    - Trace usercalls with breakpoint for peace including register info for a specific thread
        # {0:1} {1:1} -g a.out -c peace -a

    - Trace usercalls for a specific thread only for 2 seconds
        # {0:1} {1:1} -g a.out -R 2s

    - Trace usercalls from a specific binary and pause when catching PLT function call
        # {0:1} {1:1} "ls -al" -c PLT
        # {0:1} {1:1} -I "ls -al" -c PLT
                    '''.format(cmd, mode)

                # btrace #
                elif SysMgr.checkMode('btrace'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} -g <TARGET> [OPTIONS] [--help]

Description:
    Trace function calls
                        '''.format(cmd, mode)

                    helpStr += '''
Options:
    -e  <CHARACTER>             enable options
          [ p:pipe | D:DWARF | e:encode ]
    -d  <CHARACTER>             disable options
          [ C:clone | D:DWARF | e:encode | E:exec | g:generalInfo ]
    -u                          run in the background
    -a                          show all stats including registers
    -T  <FILE>                  set target file
    -g  <COMM|TID{:FILE}>       set task filter
    -I  <COMMAND>               set command
    -R  <TIME>                  set timer
    -c  <SYM|ADDR{:CMD}>        set breakpoint
    -H  <LEVEL>                 set function depth level
    -o  <DIR|FILE>              set output path
    -m  <ROWS:COLS:SYSTEM>      set terminal size
    -E  <DIR>                   set cache dir path
    -q  <NAME{:VALUE}>          set environment variables
    -v                          verbose
                    '''

                    helpStr += brkExamStr

                # remote #
                elif SysMgr.checkMode('remote'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} -g <TARGET> -c <COMMAND> [OPTIONS] [--help]

Description:
    Execute commands remotely
                        '''.format(cmd, mode)

                    helpStr += '''
Options:
    -u                          run in the background
    -a                          show all stats including registers
    -g  <COMM|TID{:FILE}>       set task filter
    -R  <TIME>                  set timer
    -i  <REPEAT>                set repeat count
    -c  <SYM|ADDR{:CMD}>        set command
    -H  <LEVEL>                 set function depth level
    -o  <DIR|FILE>              set output path
    -m  <ROWS:COLS:SYSTEM>      set terminal size
    -E  <DIR>                   set cache dir path
    -q  <NAME{:VALUE}>          set environment variables
    -v                          verbose
                    '''

                    remoteExamStr = '''
    - print context repeatedly 5 times
        # {0:1} {1:1} -g a.out -c print -i 5
                    '''

                    helpStr += brkExamStr + remoteExamStr

                # hook #
                elif SysMgr.checkMode('hook'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} -g <TARGET> -c <COMMAND> [OPTIONS] [--help]

Description:
    Replace specific functions with a custom function

Options:
    -u                          run in the background
    -g  <COMM|TID>              set task filter
    -c  <TARGET#BIN#HOOK>       set command
    -H  <LEVEL>                 set function depth level
    -o  <DIR|FILE>              set output path
    -m  <ROWS:COLS:SYSTEM>      set terminal size
    -E  <DIR>                   set cache dir path
    -q  <NAME{{:VALUE}}>          set environment variables
    -v                          verbose

Examples:
    - Replace standard malloc function calls with customized malloc function calls in libhook.so for a.out process
        # {0:1} {1:1} -g a.out -c malloc#./libhook.so#malloc
                    '''.format(cmd, mode)

                # printbind #
                elif SysMgr.checkMode('printbind'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} -g <TARGET> -c <COMMAND> [OPTIONS] [--help]

Description:
    Print bind status of functions

Options:
    -u                          run in the background
    -g  <COMM|TID>              set task filter
    -c  <FUNC|FILE>             set function filter
    -o  <DIR|FILE>              set output path
    -m  <ROWS:COLS:SYSTEM>      set terminal size
    -E  <DIR>                   set cache dir path
    -q  <NAME{{:VALUE}}>          set environment variables
    -v                          verbose

Examples:
    - Print bind status of all functions for a specific process
        # {0:1} {1:1} -g a.out

    - Print bind status of specific functions for a specific process
        # {0:1} {1:1} -g a.out -c write
                    '''.format(cmd, mode)

                # sigtrace #
                elif SysMgr.checkMode('sigtrace'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} -g <TARGET> [OPTIONS] [--help]

Description:
    Trace signals
                        '''.format(cmd, mode)

                    helpStr += '''
Options:
    -e  <CHARACTER>             enable options
          [ p:pipe | e:encode ]
    -d  <CHARACTER>             disable options
          [ C:clone | e:encode | E:exec | g:generalInfo ]
    -u                          run in the background
    -g  <COMM|TID{:FILE}>       set task filter
    -I  <COMMAND>               set command
    -R  <TIME>                  set timer
    -H  <LEVEL>                 set function depth level
    -o  <DIR|FILE>              set output path
    -m  <ROWS:COLS:SYSTEM>      set terminal size
    -E  <DIR>                   set cache dir path
    -v                          verbose
                    '''

                    helpStr += '''
Examples:
    - Trace all signals for a specific thread
        # {0:1} {1:1} -g a.out

    - Trace all signals for a specific command
        # {0:1} {1:1} -I "ls"

    - Trace the SIGINT signal for a specific thread
        # {0:1} {1:1} -g 1234 -c SIGINT

    - Trace the SIGINT signal for a specific thread and print standard output
        # {0:1} {1:1} -g 1234 -c SIGINT -q NOMUTE
                    '''.format(cmd, mode)

                # mem #
                elif SysMgr.checkMode('mem'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} -g <TARGET> [OPTIONS] [--help]

Description:
    Print page attributes for tasks
                        '''.format(cmd, mode)

                    helpStr += '''
Options:
    -g  <COMM|TID{:FILE}>       set task filter
    -o  <DIR|FILE>              set output path
    -I  <ADDR>                  set address area
    -a                          show all memory info
    -m  <ROWS:COLS:SYSTEM>      set terminal size
    -v                          verbose
                    '''

                    helpStr += '''
Examples:
    - Print memory map summary for specific processes
        # {0:1} {1:1} a.out

    - Print memory map details for specific processes
        # {0:1} {1:1} a.out -a

    - Print page attributes in specific area for specific processes
        # {0:1} {1:1} a.out -I 0x0-0x4000
                    '''.format(cmd, mode)

                # CPU average draw #
                elif SysMgr.checkMode('drawcpuavg'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} <FILE> [OPTIONS] [--help]

Description:
    Draw CPU average graphs
                        '''.format(cmd, mode)

                    helpStr += drawSubStr + drawExamStr

                # memory average draw #
                elif SysMgr.checkMode('drawmemavg'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} <FILE> [OPTIONS] [--help]

Description:
    Draw memory average graphs for system
                        '''.format(cmd, mode)

                    helpStr += drawSubStr + drawExamStr

                # VSS average draw #
                elif SysMgr.checkMode('drawvssavg'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} <FILE> [OPTIONS] [--help]

Description:
    Draw VSS average graphs for processes
                        '''.format(cmd, mode)

                    helpStr += drawSubStr + drawExamStr

                # RSS average draw #
                elif SysMgr.checkMode('drawrssavg'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} <FILE> [OPTIONS] [--help]

Description:
    Draw RSS average graphs for processes
                        '''.format(cmd, mode)

                    helpStr += drawSubStr + drawExamStr

                # CPU draw #
                elif SysMgr.checkMode('drawcpu'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} <FILE> [OPTIONS] [--help]

Description:
    Draw CPU graphs
                        '''.format(cmd, mode)

                    helpStr += drawSubStr + drawExamStr

                # CPU Delay draw #
                elif SysMgr.checkMode('drawdelay'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} <FILE> [OPTIONS] [--help]

Description:
    Draw CPU delay graphs
                        '''.format(cmd, mode)

                    helpStr += drawSubStr + drawExamStr

                # flamegraph draw #
                elif SysMgr.checkMode('drawflame'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} <FILE> [OPTIONS] [--help]

Description:
    Draw flame graph
                        '''.format(cmd, mode)

                    helpStr += drawSubStr + drawExamStr

                # timeline draw #
                elif SysMgr.checkMode('drawtime'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} <FILE> [OPTIONS] [--help]

Description:
    Draw timeline chart from JSON format data
                        '''.format(cmd, mode)

                    drawTimelineStr = '''
Format:
    DATA: {{
      "title": "example",   // optional for title
      "font_size": 3,            // optional for font size
      "time_unit": "ms",    // [sec | ms | ns]
      "segments": [
        {{
          "group": 0,
          "text": "task0",
          "time_start": 10,
          "time_end": 40
          "id": 12,         // optional for class
          "color": "red",   // optional for color
          "state": 'OFF',   // optional for event
        }},
        {{
          "group": 1,
          "text": "task1",
          "time_start": 10,
          "time_end": 40
          "id": 13,
          "color": "rgb(128,0,128)",
          "state": 'OFF',
        }}
      ]
    }}

    CONFIG: {{
        "width": 400,
        "height": 100,
        "font_size": 4,
        "time_ticks": 20,
        "time_axis_height": 10,
        "label_size_min": 30,
        "palette": [
            "(244, 67, 54)",
            "(233,30,99)",
            "(156, 39, 176)"
        ]
    }}
                        '''

                    helpStr += drawSubStr + drawTimelineStr + drawExamStr

                # memory draw #
                elif SysMgr.checkMode('drawmem'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} <FILE> [OPTIONS] [--help]

Description:
    Draw system memory graphs and memory chart
                        '''.format(cmd, mode)

                    helpStr += drawSubStr + drawExamStr

                # vss draw #
                elif SysMgr.checkMode('drawvss'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} <FILE> [OPTIONS] [--help]

Description:
    Draw process memory(VSS) graphs and memory chart
                        '''.format(cmd, mode)

                    helpStr += drawSubStr + drawExamStr

                # rss draw #
                elif SysMgr.checkMode('drawrss'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} <FILE> [OPTIONS] [--help]

Description:
    Draw process memory(RSS) graphs and memory chart
                        '''.format(cmd, mode)

                    helpStr += drawSubStr + drawExamStr

                # leak draw #
                elif SysMgr.checkMode('drawleak'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} <FILE> [OPTIONS] [--help]

Description:
    Draw memory(VSS) graphs of processes suspected memory leak and memory chart
                        '''.format(cmd, mode)

                    helpStr += drawSubStr + drawExamStr

                # I/O draw #
                elif SysMgr.checkMode('drawio'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} <FILE> [OPTIONS] [--help]

Description:
    Draw system I/O graphs
                        '''.format(cmd, mode)

                    helpStr += drawSubStr + drawExamStr

                # draw #
                elif SysMgr.isDrawMode():
                    helpStr = '''
Usage:
    # {0:1} {1:1} <FILE> [OPTIONS] [--help]

Description:
    Draw system resource graph, event timeline, memory chart
                        '''.format(cmd, mode)

                    helpStr += drawSubStr + drawExamStr

                # topdiff #
                elif SysMgr.checkMode('topdiff'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} <FILE> [OPTIONS] [--help]

Description:
    Diff top report files
                        '''.format(cmd, mode)

                    helpStr += '''
Options:
    -d  <CHARACTER>             disable options
          [ A:Average | e:encode ]
                    '''

                    helpStr += '''
Examples:
    - Diff top report files
        # {0:1} {1:1} "tc1.out, tc2.out"

    - Diff top report files
        # {0:1} {1:1} "tc*.out"

    - Diff top report files by total usage
        # {0:1} {1:1} "tc*.out" -dA

    - Diff top report files within specific interval range in second unit
        # {0:1} {1:1} "tc*.out" -q TRIM:9:15
                    '''

                # topsum #
                elif SysMgr.checkMode('topsum'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} <FILE> [OPTIONS] [--help]

Description:
    Summary a top output file
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Summary a top output file
        # {0:1} {1:1} output

    - Summary a top output file into summary.out
        # {0:1} {1:1} output -o guider.out
                    '''.format(cmd, mode)

                # kill / send #
                elif SysMgr.isKillMode():
                    helpStr = '''
Usage:
    # {0:1} {1:1} -<SIGNUM|SIGNAME> <PID|COMM> [OPTIONS] [--help]

Description:
    Send specific signal to specific tasks or all running Guiders

Options:
    -g  <TID|COMM>              set task filter
    -i  <SEC>                   set interval
    -l                          print signal list
    -W                          wait for task
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Send the notification signal to all running Guiders
        # {0:1} {1:1}

    - Send SIGSTOP signal to specific tasks
        # {0:1} {1:1} -stop 1234
        # {0:1} {1:1} -stop a.out
        # {0:1} {1:1} -stop a.out*

    - Send SIGSTOP signal to specific tasks until one gets the signal
        # {0:1} {1:1} -stop 1234 -W

    - Send 9th signal SIGKILL to specific tasks
        # {0:1} {1:1} -9 1234
        # {0:1} {1:1} -kill 1234

    - Send 9th signal SIGKILL to specific tasks every 2 seconds
        # {0:1} {1:1} -9 1234 -i 2
        # {0:1} {1:1} -kill 1234 -i 2
                    '''.format(cmd, mode)

                # pause #
                elif SysMgr.checkMode('pause'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} -g <TARGET> [OPTIONS] [--help]

Description:
    Pause specific running threads

Options:
    -g  <TID|COMM>              set task filter
    -R  <TIME>                  set timer
    -u                          run in the background
    -P                          group threads in a same process
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Pause specific running threads for 3 seconds
        # {0:1} {1:1} -g 1234 -R 3

    - Pause specific running threads including a same process group
        # {0:1} {1:1} -g 1234 -P
                    '''.format(cmd, mode)

                # readelf #
                elif SysMgr.checkMode('readelf'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} -I <FILE> [OPTIONS] [--help]

Description:
    Show information about ELF file

Options:
        -e  <CHARACTER>             enable options
              [ p:pipe | D:DWARF | e:encode ]
        -I  <FILE>                  set input path
        -g  <ADDR|SYMBOL>           set function filter
        -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Print ELF infomation of specific file
        # {0:1} {1:1} -I /usr/bin/yes

    - Print vDSO infomation
        # {0:1} {1:1} -I vdso
                    '''.format(cmd, mode)

                # log #
                elif SysMgr.checkMode('logdlt') or \
                    SysMgr.checkMode('logkmsg') or \
                    SysMgr.checkMode('logsys') or \
                    SysMgr.checkMode('logjrl'):
                    helpStr = logCommonStr

                # printlog #
                elif SysMgr.checkMode('printdlt') or \
                    SysMgr.checkMode('printdbus') or \
                    SysMgr.checkMode('printkmsg') or \
                    SysMgr.checkMode('printjrl') or \
                    SysMgr.checkMode('printsys'):
                    helpStr = printCommonStr

                    # printdbus #
                    if SysMgr.checkMode('printdbus'):
                        helpStr += '''
    - Print D-Bus messages with detailed information in real-time
        # {0:1} {1:1} -a

    - Print D-Bus messages including specific word in real-time
        # {0:1} {1:1} -c test

    - Print D-Bus messages with backtrace for a.out process in real-time
        # {0:1} {1:1} -g a.out -H

    - Print D-Bus messages for a specific session bus
        # DBUS_SESSION_BUS_ADDRESS=$(cat addr) {0:1} {1:1}

    - Print D-Bus messages except for specific messages
        # {0:1} {1:1} -G sendData

                    '''.format(cmd, mode)

                    # printkmsg / printsys #
                    if SysMgr.checkMode('printkmsg') or \
                        SysMgr.checkMode('printsys'):
                        helpStr += '''
    - Print logs including specific words
        # {0:1} {1:1} -g test
                    '''.format(cmd, mode)

                    # printjrl #
                    if SysMgr.checkMode('printjrl'):
                        helpStr += '''
    - Print all journals
        # {0:1} {1:1} -a

    - Print journals including specific words in real-time
        # {0:1} {1:1} -g test

    - Print journals with all fields in real-time
        # {0:1} {1:1} -I

    - Print journals with specific fields in real-time
        # {0:1} {1:1} -I _TIME, _COMM, _PID
                    '''.format(cmd, mode)

                    # printdlt #
                    if SysMgr.checkMode('printdlt'):
                        helpStr += '''
    - Print DLT messages from specific files
        # {0:1} {1:1} "./*.dlt"
        # {0:1} {1:1} -I "./*.dlt"

    - Print DLT messages including specific words
        # {0:1} {1:1} -g test

    - Change default log level to be printed
        # {0:1} {1:1} -c INFO

    - Print DLT messages using libdlt.so from specific path
        # {0:1} {1:1} -q LIBDLT:/home/iipeace/test/libdlt.so

    - Print DLT messages sorted by line from specific files
        # {0:1} {1:1} "./*.dlt" -S
        # {0:1} {1:1} -I "./*.dlt" -S

    - Print DLT messages from specific address for dlt-daemon
        # {0:1} {1:1} -X 127.0.0.1:12345
                    '''.format(cmd, mode)

                # printsig #
                elif SysMgr.checkMode('printsig'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Show signal status

Options:
    -o  <DIR|FILE>              set output path
    -g  <TID|COMM>              set task filter
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Print signal status info for a specific process
        # {0:1} {1:1} -g a.out
                    '''.format(cmd, mode)

                # printsub #
                elif SysMgr.checkMode('printsub'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Show D-Bus signal subscription info

Options:
    -o  <DIR|FILE>              set output path
    -a                          show all stats
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Print D-Bus signal subscription info
        # {0:1} {1:1}

    - Print D-Bus signal subscription info with specific values
        # {0:1} {1:1} -a

    - Print D-Bus signal subscription info to a specific file
        # {0:1} {1:1} -o sig.out
                    '''.format(cmd, mode)

                # watch #
                elif SysMgr.checkMode('watch'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} <PATH> [OPTIONS] [--help]

Description:
    Watch specific files or directories

Options:
    -g  <PATH:EVENT:FILE:CMD>   set condition
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Watch the current directory
        # {0:1} {1:1}

    - Watch multiple directories
        # {0:1} {1:1} "/home/iipeace/test","/home/iipeace/test/sub"

    - Watch specific events for a.out in the current directory
        # {0:1} {1:1} ".:IN_CREATE|IN_CLOSE:a.out"

    - Watch specific events in the current directory and terminate if the events occur
        # {0:1} {1:1} ".:IN_CREATE|IN_CLOSE:a.out:exit"

    - Watch specific events in the current directory and execute specific commands if the events occur
        # {0:1} {1:1} ".:IN_CREATE|IN_CLOSE:a.out:ls -lha"
                    '''.format(cmd, mode)

                # addr2sym #
                elif SysMgr.checkMode('addr2sym'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} <FILE|PID|COMM> -g <OFFSET> [OPTIONS] [--help]

Description:
    Show symbols of specific addresses in a file or a process memory map

Options:
    -I  <FILE|COMM|PID>         set input path or process
    -g  <OFFSET>                set offset
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Print symbol infomation of specific addresses in a file
        # {0:1} {1:1} -I /usr/bin/yes -g ab1cf

    - Print symbol infomation of specific addresses in a process memory map
        # {0:1} {1:1} -I yes -g ab1cf
                    '''.format(cmd, mode)

                # mkcache #
                elif SysMgr.checkMode('mkcache'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} <FILE|COMM|PID> -g <OFFSET> [OPTIONS] [--help]

Description:
    Make ELF caches

Options:
    -I  <FILE|COMM|PID>         set input path or process
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Make ELF caches for a.out and yes processes
        # {0:1} {1:1} a.out, yes

    - Make ELF caches for /usr/bin/yes
        # {0:1} {1:1} /usr/bin/yes
                    '''.format(cmd, mode)

                # sym2addr#
                elif SysMgr.checkMode('sym2addr'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} <FILE|COMM|PID> -g <SYMBOL> [OPTIONS] [--help]

Description:
    Show files and offset of specific symbols in a file or a process memory map

Options:
    -I  <FILE|COMM|PID>         set input path or process
    -g  <SYMBOL>                set offset
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Print infomation of specific symbols in a file
        # {0:1} {1:1} -I /usr/bin/yes -g testFunc

    - Print infomation of all symbols in a file
        # {0:1} {1:1} -I /usr/bin/yes -g

    - Print infomation of specific symbols including specific word in a file
        # {0:1} {1:1} -I /usr/bin/yes -g "*testFunc"
        # {0:1} {1:1} -I /usr/bin/yes -g "testFunc*"
        # {0:1} {1:1} -I /usr/bin/yes -g "*testFunc*"

    - Print infomation of specific symbols including specific word in a file
        # {0:1} {1:1} -I ~/test/mutex -g "std::_Vector_base<unsigned long\, std::allocator<unsigned long> >::~_Vector_base()"

    - Print infomation of specific symbols in a process memory map
        # {0:1} {1:1} -I yes -g testFunc
                    '''.format(cmd, mode)

                # printdbusinfo #
                elif SysMgr.checkMode('printdbusinfo'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Print D-Bus stats

Options:
    -v                          verbose
    -g  <COMM>                  set task filter
    -o  <DIR|FILE>              set output path
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Print D-Bus stats
        # {0:1} {1:1}
                    '''.format(cmd, mode)

                # printcgroup #
                elif SysMgr.checkMode('printcg'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Show system cgroup tree

Options:
    -v                          verbose
    -a                          show all processes
    -g  <COMM>                  set task filter
    -H  <LEVEL>                 set depth level
    -o  <DIR|FILE>              set output path
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Print system cgroup tree
        # {0:1} {1:1}

    - Print system cgroup tree for specific subsystem
        # {0:1} {1:1} cpu
        # {0:1} {1:1} blkio

    - Print system cgroup tree with processes
        # {0:1} {1:1} -a

    - Print system cgroup tree with processes having specific name
        # {0:1} {1:1} -a -g kworker

    - Print system cgroup tree with depth 3
        # {0:1} {1:1} -H 3
                    '''.format(cmd, mode)

                # exec #
                elif SysMgr.checkMode('exec'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Execute commands repeatedly with various conditions

Options:
    -v                          verbose
    -I  <COMMAND>               set commands
    -c  <VARIABLE>              set variables
    -q  <NAME{{:VALUE}}>          set environment variables
    -u                          run in the background
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Execute a command
        # {0:1} {1:1} -I "ls -lha"

    - Execute a command in background
        # {0:1} {1:1} -I "ls -lha" -u

    - Execute commands with range variables
        # {0:1} {1:1} -I "touch FILE" -c FILE:1:100:0.1

    - Execute commands with file variables for a directory
        # {0:1} {1:1} -I "ls -lha FILE" -c FILE:/data

    - Execute commands with enviornment variables
        # {0:1} {1:1} -I "ls -lha FILE" -q ENV:TEST=1, ENV:PATH=/data
        # {0:1} {1:1} -I "ls -lha FILE" -q ENVFILE:/data/env.sh
                    '''.format(cmd, mode)

                # printdir #
                elif SysMgr.checkMode('printdir'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Show directory structure

Options:
    -v                          verbose
    -I  <DIR>                   set input path
    -a                          show all attributes
    -g  <WORD>                  set filter
    -c  <COMMAND>               set command
    -H  <LEVEL>                 set function depth level
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Print directory structure from current working directory
        # {0:1} {1:1}

    - Print directory structure from / dir
        # {0:1} {1:1} /
        # {0:1} {1:1} -I /

    - Print directory structure in 2-depth from / dir
        # {0:1} {1:1} -I / -H 2

    - Print directory structure with files from / dir
        # {0:1} {1:1} -I / -a

    - Print specific directories and files from / dir
        # {0:1} {1:1} -I / -a -g
        # {0:1} {1:1} -I / -a -g test
        # {0:1} {1:1} -I / -a -g "test*"
        # {0:1} {1:1} -I / -a -g "*test"

    - Print specific directories and files from / dir and apply command
        # {0:1} {1:1} -I / -a -g test -c "rm -rf TARGET"
                    '''.format(cmd, mode)

                # leaktracer #
                elif SysMgr.checkMode('leaktrace'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} -g <TARGET> [OPTIONS] [--help]

Description:
    Show functions caused memory leakage with leaktracer output

    Get libleaktracer.so for various CPU architectures from https://github.com/iipeace/portable/tree/master/leaktracer

    Run the target process with below specific environment variables if you can't inject the hook binary
    $ LD_PRELOAD=./libleaktracer.so \\
        LEAKTRACER_AUTO_REPORTFILENAME=leaks.out \\
        LEAKTRACER_ONSIG_REPORT=36 EXEC
    $ LD_PRELOAD=./libleaktracer.so \\
        LEAKTRACER_ONSIG_REPORTFILENAME=leaks.out \\
        LEAKTRACER_ONSIG_STARTALLTHREAD=35 \\
        LEAKTRACER_ONSIG_REPORT=36 EXEC

    If the target process is on secure-execution mode,
    libleaktracer.so should be in standard search directoriesspecified in /etc/ld.so.conf,
    And all slashes in it's preload path will be ignored
    Otherwise add the library path to /etc/ld.so.preload

Options:
    -I  <DIR|FILE>              set input path
    -o  <DIR|FILE>              set output path
    -c  <{{STARTSIZE:}}ENDSIZE>   set condition for RSS
    -T  <FILE>                  set hook file
    -g  <PID|COMM>              set target process
    -k  <{{START,}}STOP>          set signal
    -C  <PATH>                  set config path
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Create an output file for memory leakage hints of a specific process when user input Ctrl + c key after setting environment variables
        # {0:1} {1:1} -g a.out

    - Create an output file for memory leakage hints of a specific process when user input Ctrl + c key with binary injection
        # {0:1} {1:1} -g a.out -T /home/root/libleaktracer.so

    - Create an output file for memory leakage hints of a specific process when user input Ctrl + c key with binary injection and a temporary writable path
        # {0:1} {1:1} -g a.out -I /var/log/guider -T /home/root/libleaktracer.so

    - Create an output file for memory leakage hints of a specific process after sending signal 36 to stop profiling
        # {0:1} {1:1} -g a.out -k 36

    - Create an output file for memory leakage hints of a specific process when it's RSS reached the specific size
        # {0:1} {1:1} -g a.out -c 20m
        # {0:1} {1:1} -g a.out -c 15m,20m

    - Print funtions caused memory leakage of a specific process
        # {0:1} {1:1} -I ./leaks.out -g a.out
                    '''.format(cmd, mode)

                # printenv #
                elif SysMgr.checkMode('printenv'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} -g <TARGET> [OPTIONS] [--help]

Description:
    Show environment variables for a specific process

Options:
    -g  <PID|COMM>              set target process
    -J                          print in JSON format
    -I  <WORD>                  set filter
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Print environment variables for a specific process
        # {0:1} {1:1} a.out
        # {0:1} {1:1} -g 1234

    - Print environment variables for all processes
        # {0:1} {1:1} "*"

    - Print environment variables including PWD for all processes
        # {0:1} {1:1} "*" -I PWD
                    '''.format(cmd, mode)

                # printns #
                elif SysMgr.checkMode('printns'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Show namespace list

Options:
    -a                          show all attributes
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Print namespace list
        # {0:1} {1:1}

    - Print namespace list with tasks
        # {0:1} {1:1} -a
                    '''.format(cmd, mode)

                # printsvc #
                elif SysMgr.checkMode('printsvc'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Show systemd services

Options:
    -a                          show all attributes
    -g  <NAME>                  set target file
    -c  <ATTR>                  set target attribute
    -I  <DIR>                   set input path
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Print systemd services
        # {0:1} {1:1}

    - Print systemd services about only specific files
        # {0:1} {1:1} -g test

    - Print systemd services including specific attributes
        # {0:1} {1:1} -c Restart

    - Print systemd services including specific value of attributes
        # {0:1} {1:1} -c :pid

    - Print systemd services in specific directories
        # {0:1} {1:1} -I /home/iipeace/services
                    '''.format(cmd, mode)

                # printinfo #
                elif SysMgr.checkMode('printinfo'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Show system general info

Options:
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Print system info
        # {0:1} {1:1}
                    '''.format(cmd, mode)

                # pstree #
                elif SysMgr.checkMode('pstree'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Show the tree of tasks

Options:
    -e  <CHARACTER>             enable options
          [ t:thread ]
    -g  <COMM>                  set filter
    -H  <LEVEL>                 set depth level
    -o  <DIR|FILE>              set output path
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Print the tree of processes
        # {0:1} {1:1}

    - Print the tree of threads
        # {0:1} {1:1} -e t

    - Print the highlighted processes having specific name
        # {0:1} {1:1} -g kworker

    - Print the tree of processes with depth 3
        # {0:1} {1:1} -H 3
                    '''.format(cmd, mode)

                # comp #
                elif SysMgr.checkMode('comp'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} <FILE> [OPTIONS] [--help]

Description:
    Compress a file

Options:
    -o  <FILE>                  set output path
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Compress a file
        # {0:1} {1:1} guider.out
        # {0:1} {1:1} guider.out -o guider.out.gz
                    '''.format(cmd, mode)

                # decomp #
                elif SysMgr.checkMode('decomp'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} <FILE> [OPTIONS] [--help]

Description:
    Decompress a file

Options:
    -o  <DIR>                   set output path
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Decompress a file
        # {0:1} {1:1} guider.gz
        # {0:1} {1:1} guider.gz -o guider.out
                    '''.format(cmd, mode)

                # systat #
                elif SysMgr.checkMode('systat'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Print system status

Options:
    -e  <CHARACTER>             enable options
          [ t:thread ]
    -J                          print in JSON format
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Print system status
        # {0:1} {1:1}
                    '''.format(cmd, mode)

                # request #
                elif SysMgr.checkMode('req'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Request URLs

Options:
    -I  <METHOD#OPT#ADDR>       input requests
    -o  <DIR|FILE>              set output path
    -R  <DELAY:COUNT>           set repeat count
    -T  <PROC>                  set process number
    -q  <NAME{{:VALUE}}>          set environment variables
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Run client with interaction menu
        # {0:1} {1:1}

    - Request GET / URL to specific server
        # {0:1} {1:1} http://127.0.0.1:5000
        # {0:1} {1:1} GET#http://127.0.0.1:5000
        # {0:1} {1:1} "GET#http://127.0.0.1:5000|GET#http://10.25.123.123:5000"

    - Request GET / URL to specific server and print contents for the request
        # {0:1} {1:1} http://127.0.0.1:5000 -q PRINTREQ

    - Request GET / URL to specific server and print only summary for requests
        # {0:1} {1:1} http://127.0.0.1:5000 -q MUTE

    - Request POST / URL to specific server
        # {0:1} {1:1} POST#DATA:"data"#http://127.0.0.1:5000
        # {0:1} {1:1} POST#JSONDATA:"{{'key':'value'}}"#http://127.0.0.1:5000

    - Request POST / URL to specific server after base64 encoding specific file data from specific path string "@@@FILE:PATH@@@"
        # {0:1} {1:1} POST#DATA:"@@@FILE:a.out@@@"#http://127.0.0.1:5000
        # {0:1} {1:1} POST#JSONDATA:"{{'date':'123', 'image': {{'name': 'good', 'data':'@@@FILE:a.out@@@'}}}}"#http://127.0.0.1:5000
        # {0:1} {1:1} POST#JSONFILE:input.json#http://127.0.0.1:5000

    - Request POST / URL to specific server with files
        # {0:1} {1:1} POST#FILE:image:test.png:img/png#http://127.0.0.1:5000
        # {0:1} {1:1} POST#FILE:doc:test.txt:doc/txt#http://127.0.0.1:5000

    - Request POST / URL to specific server with data from data.json file
        # {0:1} {1:1} POST#JSONFILE:data.json#http://127.0.0.1:5000

    - Request POST / URL to specific server with data from data file
        # {0:1} {1:1} POST#DATAFILE:data#http://127.0.0.1:5000

    - Request GET / URL to specific server infinitely
        # {0:1} {1:1} GET#http://127.0.0.1:5000 -R

    - Request GET / URL to specific server 10 times with 500ms delay
        # {0:1} {1:1} GET#http://127.0.0.1:5000 -R 500:10

    - Request GET / URL to specific server 10 times by 10 processes
        # {0:1} {1:1} GET#http://127.0.0.1:5000 -R 10 -T 10

    - Request GET / URL to specific server with 5 second timeout
        # {0:1} {1:1} GET#TIMEOUT:5#http://127.0.0.1:5000

    - Request GET / URL to specific server with no verification for SSL
        # {0:1} {1:1} GET#VERIFY:false#https://127.0.0.1:5000

    - Request GET / URL to specific server with auth
        # {0:1} {1:1} GET#AUTH:id,passwd#https://127.0.0.1:5000

    - Request GET / URL to specific server with cookies
        # {0:1} {1:1} GET#COOKIES:sessionKey:sessionValue#https://127.0.0.1:5000

    - Request GET / URL to specific server with headers
        # {0:1} {1:1} GET#HEADERS:Content-Type:application/json;charset=utf-8#https://127.0.0.1:5000
                    '''.format(cmd, mode)

                # limitcpu #
                elif SysMgr.checkMode('limitcpu'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} -g <TID|PID:PER> [OPTIONS] [--help]

Description:
    Limit CPU usage of threads / processes

Options:
    -g  <TID|COMM>              set task filter
    -R  <TIME>                  set timer
    -P                          group threads in a same process
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Limit CPU usage of specific threads for 3 seconds
        # {0:1} {1:1} -g 1234:10, yes:20 -R 3
                    '''.format(cmd, mode)

                # setcpu #
                elif SysMgr.checkMode('setcpu'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} -g <CORE:CLOCK:GOVERNOR> [OPTIONS] [--help]

Description:
    Set CPU clock and governor

Options:
    -g  <CORE:CLOCK:GOVERNOR>   set filter
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Set the clock speed to 10000000HZ and the governor to userspace for CPU1
        # {0:1} {1:1} 1:10000000:userspace

    - Set the clock speed to 10000000HZ and the governor to userspace for All CPUs
        # {0:1} {1:1} :10000000:userspace

    - Set the clock speed to 10000000HZ for CPU0
        # {0:1} {1:1} 0:10000000

    - Set the governor to performance for CPU2
        # {0:1} {1:1} 2:0:performance

    - Set the governor to performance for CPU2
        # {0:1} {1:1} 2:0:performance
                    '''.format(cmd, mode)

                # convert #
                elif SysMgr.checkMode('convert'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} <FILE> [OPTIONS] [--help]

Description:
    Convert a text file to a image file

Options:
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Convert a text file to a image file
        # {0:1} {1:1} guider.out
                    '''.format(cmd, mode)

                # drawreq #
                elif SysMgr.checkMode('drawreq'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} <FILE> [OPTIONS] [--help]

Description:
    Draw graphs for response time

Options:
    -v                          verbose
    -I  <DIR|FILE>              set input path
    -o  <DIR|FILE>              set output path
    -g  <WORD>                  set filter
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Draw graphs for response time
        # {0:1} {1:1} guider.out
        # {0:1} {1:1} "guider*.out"

    - Draw graphs for response time for specific requests
        # {0:1} {1:1} guider.out -g www.google.com
                    '''.format(cmd, mode)

                # setsched #
                elif SysMgr.checkMode('setsched'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} -g <POLICY:PRIORITY|TIME:TID|COMM> [OPTIONS] [--help]

Description:
    Set CPU scheduler policy and priority for threads / processes

Policy:
    c: CFS [default]
    f: FIFO(RT)
    r: RR(RT)
    B: BATCH
    I: IDLE
    d: DEADLINE

Options:
    -g <POLICY:PRIORITY|TIME:TID|COMM> set value
    -P                                 group threads in a same process
    -i  <SEC>                          set interval
    -v                                 verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Set CPU scheduler policy(CFS), priority(-20) for a specific thread
        # {0:1} {1:1} "-20:a.out"
        # {0:1} {1:1} "c:-20:1234"

    - Set CPU scheduler policy(CFS), priority(-20) for a specific thread every 2 seconds
        # {0:1} {1:1} "-20:a.out" -i 2

    - Set CPU scheduler policy(CFS), priority(-20) for all threads in a specific process
        # {0:1} {1:1} "-20:a.out -P"

    - Set CPU scheduler policy(FIFO), priority(90) for a specific thread
        # {0:1} {1:1} "f:90:a.out"

    - Set CPU scheduler policy(DEADLINE), runtime(1ms), deadline(10ms), period(10ms) for a specific thread
        # {0:1} {1:1} "d:1000000/10000000/10000000:a.out"
                    '''.format(cmd, mode)

                # getaffinity #
                elif SysMgr.checkMode('getafnt'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} -g <TID|COMM> [OPTIONS] [--help]

Description:
    Get CPU affinity of threads

Options:
    -g  <TID|COMM>              set values
    -P                          group threads in a same process
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Get CPU affinity of specific threads
        # {0:1} {1:1} -g a.out, 1234
                    '''.format(cmd, mode)

                # setaffinity #
                elif SysMgr.checkMode('setafnt'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} -g <TARGET:MASK> [OPTIONS] [--help]

Description:
    Set CPU affinity of threads

Options:
    -g  <TID|COMM:MASK>         set values
    -P                          group threads in a same process
    -i  <SEC>                   set interval
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Set CPU affinity of a specific thread to use only CPU 1 and CPU 2
        # {0:1} {1:1} a.out:3
        # {0:1} {1:1} -g a.out:3

    - Set CPU affinity of a specific thread to use only CPU 1 every 2 seconds
        # {0:1} {1:1} a.out:1 -i 2
                    '''.format(cmd, mode)

                # ping #
                elif SysMgr.checkMode('ping'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} <IP|URL> [OPTIONS] [--help]

Description:
    Send ICMP ECHO_REQUEST to network hosts

Options:
    -R  <COUNT>                 set repeat count
    -T  <TIMEOUT>               set timeout
    -I  <FILE>                  set input path
    -i  <SEC>                   set interval
    -J                          print in JSON format
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Send ICMP ECHO_REQUEST to network hosts
        # {0:1} {1:1} www.google.com
        # {0:1} {1:1} "www.google.com, www.naver.com"
        # {0:1} {1:1} "192.168.100.*"
        # {0:1} {1:1} "192.168.100.10-250"

    - Send ICMP ECHO_REQUEST to network hosts in a specific file
        # {0:1} {1:1} -I ip.txt

    - Send ICMP ECHO_REQUEST to network hosts infinitely
        # {0:1} {1:1} www.google.com -R

    - Send ICMP ECHO_REQUEST to network hosts with 3 second interval infinitely
        # {0:1} {1:1} www.google.com -R -i 3

    - Send ICMP ECHO_REQUEST to network hosts 3 times
        # {0:1} {1:1} www.google.com -R 3

    - Send ICMP ECHO_REQUEST to network hosts with 2.5 second timeout
        # {0:1} {1:1} www.google.com -T 2.5
                    '''.format(cmd, mode)

                # cputest #
                elif SysMgr.checkMode('cputest'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} <LOAD:NRTASK> [OPTIONS] [--help]

Description:
    Create tasks using cpu

Options:
    -R  <TIME>                  set timer
    -Y  <POLICY:PRIO|TIME       set sched
         {{:TID|COMM:CONT}}>
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Create 10 processes using 5% of a core each other
        # {0:1} {1:1} 50:10

    - Create processes using 250% CPU totally
        # {0:1} {1:1} 250

    - Create threads in a process using 250% CPU totally
        # {0:1} {1:1} 250 -et

    - Create processes using 250% CPU totally with RR 1 priority
        # {0:1} {1:1} 250 -Y r:1

    - Create processes using 250% CPU totally and run them only on CPU 1
        # {0:1} {1:1} 250 -z :1

    - Create processes using 250% CPU totally and terminate them after 3 seconds
        # {0:1} {1:1} 250 -R 3
                    '''.format(cmd, mode)

                # memtest #
                elif SysMgr.checkMode('memtest'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} <SIZE:INTERVAL:COUNT> [OPTIONS] [--help]

Description:
    Allocate physical memory

Options:
    -R  <TIME>                  set timer
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Allocate physical memory 1G
        # {0:1} {1:1} 1G

    - Allocate physical memory 200MB using a new process every 3 seconds
        # {0:1} {1:1} 200M:3

    - Allocate physical memory 100MB twice using 2 processes
        # {0:1} {1:1} 100M:0:2

    - Allocate physical memory 100MB twice using 2 processes and terminate them after 3 seconds
        # {0:1} {1:1} 100M:0:2 -R 3
                    '''.format(cmd, mode)

                # iotest #
                elif SysMgr.checkMode('iotest'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} -g <OP:PATH> [OPTIONS] [--help]

Description:
    Run storage I/O operations

Options:
    -g  <OP:PATH>               set path
    -R  <TIME>                  set timer
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Read all files from current mount point
        # {0:1} {1:1}

    - Read all files from current directory recursively
        # {0:1} {1:1} .
        # {0:1} {1:1} -g .

    - Read all device nodes mounted
        # {0:1} {1:1} -a

    - Write dummy data to a specific file infinitely
        # {0:1} {1:1} -g write:TEST
                    '''.format(cmd, mode)

                # nettest #
                elif SysMgr.checkMode('nettest'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Run network I/O operations

Options:
    -x  <IP:PORT>               set local address
    -I  <PROTOCOL{{:IP:PORT}}>    set job
    -R  <TIME>                  set timer
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Send UDP packets
        # {0:1} {1:1}

    - Send UDP packets with 3 processes
        # {0:1} {1:1} udp, udp, udp
        # {0:1} {1:1} -I udp, udp, udp
                    '''.format(cmd, mode)

                # list #
                elif SysMgr.checkMode('list'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Show running {2:1} processes

Options:
    -v                          verbose
                        '''.format(cmd, mode, __module__)

                # start #
                elif SysMgr.checkMode('start'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Send signal to all running Guider processes to run

Options:
    -v                          verbose
                        '''.format(cmd, mode)

                # event #
                elif SysMgr.checkMode('event'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [<EVENT>] [OPTIONS] [--help]

Description:
    Send the event signal to all running Guider processes

Options:
    -I  <EVENT>                 set event name
    -g  <PID>                   set target
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Send scene1 event to running Guider processes
        # {0:1} {1:1} scene1
        # {0:1} {1:1} -I scene1

    - Send scene1 event to specific Guider processes
        # {0:1} {1:1} scene1 -g 1234, 1237
                    '''.format(cmd, mode)

                # server #
                elif SysMgr.checkMode('server'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Run server

Options:
    -x  <IP:PORT>               set local address
    -X  <IP:PORT>               set agent address
    -u                          run in the background
    -C  <PATH>                  set config path
    -E  <DIR>                   set cache dir path
    -q  <NAME{{:VALUE}}>          set environment variables
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Run server in background
        # {0:1} {1:1} -u

    - Run server with specific local address
        # {0:1} {1:1} -x 127.0.0.1:5556

    - Run server and register to agent node as a service node
        # {0:1} {1:1} -X 127.0.0.1:3456

    - Run server with no timeout
        # {0:1} {1:1} -q NOTIMEOUT

    - Run server with specific timeout
        # {0:1} {1:1} -q TIMEOUT:1.5

    - Run server with specific read chunk size for command process
        # {0:1} {1:1} -q READCHUNK:4096

    - Run server with no output for remote reqeust
        # {0:1} {1:1} -q QUIET
                    '''.format(cmd, mode)

                # client #
                elif SysMgr.checkMode('cli'):
                    helpStr = '''
Usage:
    # {0:1} {1:1} [OPTIONS] [--help]

Description:
    Execute remote command

Options:
    -x  <IP:PORT>               set local address
    -X  <IP:PORT>               set request address
    -E  <DIR>                   set cache dir path
    -c  <COMMAND>               set command
    -q  <NAME{{:VALUE}}>          set environment variables
    -v                          verbose
                        '''.format(cmd, mode)

                    helpStr += '''
Examples:
    - Run client with interaction menu
        # {0:1} {1:1}

    - Download a.out from server to ./a.out
        # {0:1} {1:1} -c d:a.out@./a.out
        # {0:1} {1:1} -c download:a.out@./a.out
        # {0:1} {1:1} -c download:a.out

    - Upload ./a.out to a.out in server
        # {0:1} {1:1} -c u:./a.out@a.out
        # {0:1} {1:1} -c upload:./a.out@a.out
        # {0:1} {1:1} -c upload:./a.out

    - Ping to the server
        # {0:1} {1:1} -c "p"
        # {0:1} {1:1} -c "ping"

    - Print node list registered in server
        # {0:1} {1:1} -c "l"
        # {0:1} {1:1} -c "list"

    - Execute remote commands in parallel
        # {0:1} {1:1} -c "ls -lha", "date"
        # {0:1} {1:1} -c 192.168.0.100:5050\|"vmstat 1", 192.168.0.101:1234\|"find /"

    - Execute remote command by service nodes
        # {0:1} {1:1} -c "b:ls -lha"
        # {0:1} {1:1} -c "broadcast:ls -lha"

    - Execute a remote command with no timeout
        # {0:1} {1:1} -c "ls -lha" -q NOTIMEOUT

    - Execute a remote command with specific timeout
        # {0:1} {1:1} -c "ls -lha" -q TIMEOUT:1.5

    - Execute a remote command with no output
        # {0:1} {1:1} -q QUIET

    - Execute remote Guider commands in fixed-line-output
        # {0:1} {1:1} -c 192.168.0.100:5050\|"GUIDER top -m 15:", 192.168.0.101:1234\|"GUIDER ttop -m 15:"
                    '''.format(cmd, mode)

                # default #
                elif mode.startswith('-') or \
                    mode == 'help':
                    helpStr = defStr + \
                        '''
COMMAND:
{0:1}
FILE:
    Profile file (e.g. guider.dat)
    Report  file (e.g. guider.out)

Options:
    Check COMMAND with --help (e.g. {1:1} top --help)
                    '''.format(SysMgr.getCmdString(), cmd)

                # wrong command #
                else:
                    SysMgr.printErr(
                        'wrong command %s' % mode)
                    sys.exit(0)

                # no pager #
                if SysMgr.findOption('Q'):
                    SysMgr.setStream()

                # print small logo #
                SysMgr.printLogo()

                # print help #
                printPipe(helpStr)

            else:
                helpStr = defStr + \
                    '''
Author:
    {0:1} ({1:1})

Bugs:
    {1:1} | {2:1}/issues

Copyright:
    {3:1}
    License {4:1}.
    This is free software
                    '''.format(__author__, __email__,
                        __repository__, __copyright__, __license__)

                # no pager #
                SysMgr.setStream()

                # print help #
                printPipe(helpStr)

                # reset terminal #
                SysMgr.resetTTY()

            sys.exit(0)



    @staticmethod
    def getKernelVersion():
        if SysMgr.kernelVersion:
            return SysMgr.kernelVersion

        try:
            kernel = os.uname()[2]
            kernelList = kernel.split('.')

            # get kernel major version #
            kernelVersion = '.'.join(kernelList[0:2])

            # get kernel minor version #
            if len(kernel) > 2:
                kernelVersion = \
                    '%s.%s' % (kernelVersion, kernelList[2].split('-')[0])

            # update system info #
            SysMgr.kernelVersion = kernelVersion

            return kernelVersion
        except SystemExit:
            sys.exit(0)
        except:
            return None



    @staticmethod
    def getArch():
        if SysMgr.arch:
            return SysMgr.arch

        try:
            arch = os.uname()[4]

            if arch.startswith('arm'):
                SysMgr.arch = 'arm'
            elif arch.startswith('aarch64'):
                SysMgr.arch = 'aarch64'
            elif arch.startswith('x86_64') or arch.startswith('ia64'):
                SysMgr.arch = 'x64'
            elif arch.startswith('i386') or arch.startswith('i686'):
                SysMgr.arch = 'x86'
            else:
                SysMgr.arch = arch
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.arch = 'arm'

        return SysMgr.arch



    @staticmethod
    def setArch(arch):
        if not arch or not arch:
            return

        arch = UtilMgr.cleanItem(arch)

        # set syscall table #
        if arch == 'arm':
            ConfigMgr.sysList = ConfigMgr.SYSCALL_ARM
            ConfigMgr.regList = ConfigMgr.REGS_ARM
            ConfigMgr.wordSize = 4
        elif arch == 'aarch64':
            ConfigMgr.sysList = ConfigMgr.SYSCALL_AARCH64
            ConfigMgr.regList = ConfigMgr.REGS_AARCH64
            ConfigMgr.wordSize = 8
        elif arch == 'x86':
            ConfigMgr.sysList = ConfigMgr.SYSCALL_X86
            ConfigMgr.regList = ConfigMgr.REGS_X86
            ConfigMgr.wordSize = 4
        elif arch == 'x64':
            ConfigMgr.sysList = ConfigMgr.SYSCALL_X64
            ConfigMgr.regList = ConfigMgr.REGS_X64
            ConfigMgr.wordSize = 8
        else:
            support = ' / '.join(ConfigMgr.supportArch)
            SysMgr.printErr(
                'fail to set architecture to %s, only %s supported' % \
                (arch, support))
            sys.exit(0)

        SysMgr.arch = arch



    @staticmethod
    def waitForFile(dirname, filename):
        while 1:
            try:
                events = SysMgr.inotify(dirname)
                if not events:
                    break

                finished = False
                for item in events:
                    if item[2] == filename:
                        finished = True
                        break
                if finished:
                    break
            except SystemExit:
                sys.exit(0)
            except:
                break



    @staticmethod
    def inotify(path, flags=[], verb=False):
        if not path:
            return False

        # load libc #
        SysMgr.loadLibcObj(exit=True)

        # convert path type to list #
        if type(path) is str:
            path = [path]

        # check path #
        for item in path:
            if not os.path.exists(item):
                SysMgr.printWarn(
                    "fail to access to %s" % item, verb)
                return False

        # check flags type #
        if type(flags) is not list:
            SysMgr.printErr(
                "fail to get flags as a list")
            return False

        if not SysMgr.inotifyEnable :
            inotifyFuncs = [
                "inotify_init",
                "inotify_add_watch",
                "read",
                "inotify_rm_watch",
                "close"
            ]

            # check functions #
            for func in inotifyFuncs:
                if not hasattr(SysMgr.libcObj, func):
                    SysMgr.printWarn(
                        "no %s in %s" % (func, SysMgr.libcPath), verb)
                    return False

            SysMgr.inotifyEnable = True

        class inotify_event(Structure):
            _fields_ = (
                ("wd", c_int),
                ("mask", c_uint32),
                ("cookie", c_uint32),
                ("len", c_uint32),
                ("name", c_char_p),
            )

        # create an object #
        ie = inotify_event()
        EVENT_SIZE = sizeof(ie)
        BUF_LEN = 1024 * (EVENT_SIZE + 16)
        buf = (c_char*BUF_LEN)()

        # create a file descriptor #
        fd = SysMgr.libcObj.inotify_init()
        if fd < 0:
            SysMgr.printWarn("fail to inotify_init", verb)
            return False

        # get flag bits #
        fbits = UtilMgr.getFlagBit(ConfigMgr.INOTIFY_TYPE, flags)
        if fbits == 0:
            # IN_ALL #
            fbits = 0xfff

        # create reverse list #
        flist = {}
        for flag in flags:
            flist[ConfigMgr.INOTIFY_TYPE[flag]] = flag

        # add watch #
        wlist = {}
        for item in path:
            wd = SysMgr.libcObj.inotify_add_watch(fd, item.encode(), fbits)
            if wd < 0:
                SysMgr.printWarn("fail to inotify_add_watch", verb)
                return False
            wlist[wd] = item

        # read events #
        length = SysMgr.libcObj.read(fd, byref(buf), BUF_LEN)
        if length < 0:
            SysMgr.printWarn("fail to read inotify event", verb)
            return False

        # check events #
        i = 0
        fmt = 'iIII'
        revents = []
        size = struct.calcsize(fmt)
        while i < length:
            wd, mask, cookie, flen = struct.unpack(fmt, buf[i:i+size])

            # get file name #
            if flen > 0:
                (fname,) = struct.unpack('%ds' % flen, buf[i+size:i+size+flen])
                fname = fname.decode().rstrip('\0')
            else:
                fname = None

            # get events #
            try:
                rtypes = UtilMgr.getFlagList(mask, ConfigMgr.INOTIFY_TYPE)
                revents.append([wlist[wd], rtypes, fname])
            except SystemExit:
                sys.exit(0)
            except:
                pass

            i += (size + flen)

        # clean up #
        for wd in list(wlist.keys()):
            SysMgr.libcObj.inotify_rm_watch(fd, wd)
        SysMgr.libcObj.close(fd)

        return revents



    @staticmethod
    def syscall(syscall, *args):
        if not SysMgr.isLinux:
            return None

        try:
            # load libc #
            if not SysMgr.loadLibcObj():
                raise Exception('no libc')

            if UtilMgr.isNumber(syscall):
                nrSyscall = long(syscall)
                nmSyscall = ConfigMgr.sysList[nrSyscall]
            elif UtilMgr.isString(syscall):
                val = syscall.lower()
                if val[0:4] == 'sys_':
                    nmSyscall = val
                else:
                    nmSyscall = 'sys_%s' % val

                nrSyscall = ConfigMgr.sysList.index(nmSyscall)
            else:
                raise Exception('wrong syscall')

            try:
                nrParams = \
                    len(ConfigMgr.SYSCALL_PROTOTYPES[nmSyscall[4:]][1])
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printErr(
                    "fail to get the number of arguments for %s" % nmSyscall)
                raise Exception('wrong syscall')

            # check arguments #
            if len(args) != nrParams:
                SysMgr.printErr((
                    "fail to get arguments for %s "
                    "because of wrong parameters") % nmSyscall)
                raise Exception('wrong params')

            if nrParams == 0:
                ret = SysMgr.libcObj.syscall(nrSyscall)
            elif nrParams == 1:
                ret = SysMgr.libcObj.syscall(
                    nrSyscall, args[0])
            elif nrParams == 2:
                ret = SysMgr.libcObj.syscall(
                    nrSyscall, args[0], args[1])
            elif nrParams == 3:
                ret = SysMgr.libcObj.syscall(
                    nrSyscall, args[0], args[1], args[2])
            elif nrParams == 4:
                ret = SysMgr.libcObj.syscall(
                    nrSyscall, args[0], args[1], args[2], args[3])
            elif nrParams == 5:
                ret = SysMgr.libcObj.syscall(
                    nrSyscall, args[0], args[1], args[2], args[3],
                        args[4])
            elif nrParams == 6:
                ret = SysMgr.libcObj.syscall(
                    nrSyscall, args[0], args[1], args[2], args[3],
                        args[4], args[5])

            return ret
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printWarn(
                'fail to call %s syscall' % syscall, True, reason=True)



    @staticmethod
    def checkRootPerm(exit=True, verb=True, attr='error', msg=''):
        if not SysMgr.isRoot():
            if verb:
                if msg:
                    msg = ' to %s' % msg

                if attr == 'error':
                    logger = SysMgr.printErr
                else:
                    logger = SysMgr.printWarn

                logger("fail to get root permission%s" % msg)

            if exit:
                sys.exit(0)
            return False
        else:
            return True



    @staticmethod
    def isRoot():
        if SysMgr.isLinux and os.geteuid() == 0:
            return True
        else:
            return False



    @staticmethod
    def openPerfEvent(econfig, cpu=-1, pid=-1):
        try:
            perfEventList = ConfigMgr.PERF_EVENT_TYPE
            if econfig in ConfigMgr.PERF_HW_EVENT_TYPE:
                nrType = perfEventList.index('PERF_TYPE_HARDWARE')
                nrConfig = ConfigMgr.PERF_HW_EVENT_TYPE.index(econfig)
            elif econfig in ConfigMgr.PERF_SW_EVENT_TYPE:
                nrType = perfEventList.index('PERF_TYPE_SOFTWARE')
                nrConfig = ConfigMgr.PERF_SW_EVENT_TYPE.index(econfig)
            else:
                raise Exception('wrong perf event')
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printErr(
                'fail to recognize %s as perf event type' % econfig)
            return

        if SysMgr.guiderObj:
            # reference to http://man7.org/linux/man-pages/man2/perf_event_open.2.html #
            func = SysMgr.guiderObj.perf_event_open # pylint: disable=no-member
            fd = func(nrType, nrConfig, pid, cpu, -1, 0)
            if fd < 0:
                # check root permission #
                if not SysMgr.isRoot():
                    SysMgr.printWarn(
                        'fail to get root permission to open perf event')
                    return
                else:
                    return -1
            else:
                return fd

        # load libc #
        if not SysMgr.loadLibcObj():
            SysMgr.perfEnable = False
            SysMgr.perfGroupEnable = False
            return

        # define struct perf_event_attr #
        class union_anon_5(Union):
            pass
        union_anon_5.__slots__ = [
            'sample_period',
            'sample_freq',
        ]
        union_anon_5._fields_ = [
            ('sample_period', c_uint64),
            ('sample_freq', c_uint64),
        ]

        class union_anon_6(Union):
            pass
        union_anon_6.__slots__ = [
            'wakeup_events',
            'wakeup_watermark',
        ]
        union_anon_6._fields_ = [
            ('wakeup_events', c_uint32),
            ('wakeup_watermark', c_uint32),
        ]

        class union_anon_7(Union):
            pass
        union_anon_7.__slots__ = [
            'bp_addr',
            'config1',
        ]
        union_anon_7._fields_ = [
            ('bp_addr', c_uint64),
            ('config1', c_uint64),
        ]

        class union_anon_8(Union):
            pass
        union_anon_8.__slots__ = [
            'bp_len',
            'config2',
        ]
        union_anon_8._fields_ = [
            ('bp_len', c_uint64),
            ('config2', c_uint64),
        ]

        class struct_perf_event_attr(Structure):
            pass
        '''
        struct perf_event_attr
        {

            uint32_t type;

            uint32_t size;

            uint64_t config;

            union
            {
                uint64_t sample_period;
                uint64_t sample_freq;
            };

            uint64_t sample_type;

            uint64_t read_format;

            uint64_t disabled:1,                /* off by default        */
                     inherit:1,                 /* children inherit it   */
                     pinned:1,                  /* must always be on PMU */
                     exclusive:1,               /* only group on PMU     */
                     exclude_user:1,            /* don't count user      */
                     exclude_kernel:1,          /* ditto kernel          */
                     exclude_hv:1,              /* ditto hypervisor      */
                     exclude_idle:1,            /* don't count when idle */
                     mmap:1,                    /* include mmap data     */
                     comm:1,                    /* include comm data     */
                     freq:1,                    /* use freq, not period  */
                     inherit_stat:1,            /* per task counts       */
                     enable_on_exec:1,          /* next exec enables     */
                     task:1,                    /* trace fork/exit       */
                     watermark:1,               /* wakeup_watermark      */
                     /*
                      * precise_ip:
                      *
                      *  0 - SAMPLE_IP can have arbitrary skid
                      *  1 - SAMPLE_IP must have constant skid
                      *  2 - SAMPLE_IP requested to have 0 skid
                      *  3 - SAMPLE_IP must have 0 skid
                      *
                      *  See also PERF_RECORD_MISC_EXACT_IP
                      */
                     precise_ip:2,              /* skid constraint       */
                     mmap_data:1,               /* non-exec mmap data    */
                     sample_id_all:1,           /* sample_type all events */
                     exclude_host:1,            /* don't count in host   */
                     exclude_guest:1,           /* don't count in guest  */
                     exclude_callchain_kernel:1,        /* exclude kernel callchains */
                     exclude_callchain_user:1,  /* exclude user callchains */
                     mmap2:1,                   /* include mmap with inode data     */
                     comm_exec:1,               /* flag comm events that are due to an exec */
                     use_clockid:1,             /* use @clockid for time fields */
                     context_switch:1,          /* context switch data */
                     write_backward:1,          /* Write ring buffer from end to beginning */
                     namespaces:1,              /* include namespaces data */
                     __reserved_1:35;

            union
            {
                uint32_t wakeup_events; /* wakeup every n events */
                uint32_t wakeup_watermark;      /* bytes before wakeup   */
            };

            uint32_t bp_type;

            union
            {
                uint64_t bp_addr;
                uint64_t config1;               /* extension of config */
            };

            union
            {
                uint64_t bp_len;
                uint64_t config2;               /* extension of config1 */
            };

            uint64_t branch_sample_type;        /* enum perf_branch_sample_type */

            uint64_t sample_regs_user;

            uint32_t sample_stack_user;

            int32_t clockid;

            uint64_t sample_regs_intr;

            uint32_t aux_watermark;

            uint16_t sample_max_stack;

            uint16_t __reserved_2;              /* align to uint64_t */
        };
        '''
        struct_perf_event_attr.__slots__ = [
            'type',
            'size',
            'config',
            'unnamed_1',
            'sample_type',
            'read_format',
            'disabled',
            'inherit',
            'pinned',
            'exclusive',
            'exclude_user',
            'exclude_kernel',
            'exclude_hv',
            'exclude_idle',
            'mmap',
            'comm',
            'freq',
            'inherit_stat',
            'enable_on_exec',
            'task',
            'watermark',
            'precise_ip',
            'mmap_data',
            'sample_id_all',
            'exclude_host',
            'exclude_guest',
            'exclude_callchain_kernel',
            'exclude_callchain_user',
            'mmap2',
            'comm_exec',
            'use_clockid',
            'context_switch',
            'write_backward',
            'namespaces',
            '__reserved_1',
            'unnamed_2',
            'bp_type',
            'unnamed_3',
            'unnamed_4',
            'branch_sample_type',
            'sample_regs_user',
            'sample_stack_user',
            'clockid',
            'sample_regs_intr',
            'aux_watermark',
            'sample_max_stack',
            '__reserved_2',
        ]
        struct_perf_event_attr._anonymous_ = [
            'unnamed_1',
            'unnamed_2',
            'unnamed_3',
            'unnamed_4',
        ]
        struct_perf_event_attr._fields_ = [
            ('type', c_uint32),
            ('size', c_uint32),
            ('config', c_uint64),
            ('unnamed_1', union_anon_5),
            ('sample_type', c_uint64),
            ('read_format', c_uint64),
            ('disabled', c_uint64, 1),
            ('inherit', c_uint64, 1),
            ('pinned', c_uint64, 1),
            ('exclusive', c_uint64, 1),
            ('exclude_user', c_uint64, 1),
            ('exclude_kernel', c_uint64, 1),
            ('exclude_hv', c_uint64, 1),
            ('exclude_idle', c_uint64, 1),
            ('mmap', c_uint64, 1),
            ('comm', c_uint64, 1),
            ('freq', c_uint64, 1),
            ('inherit_stat', c_uint64, 1),
            ('enable_on_exec', c_uint64, 1),
            ('task', c_uint64, 1),
            ('watermark', c_uint64, 1),
            ('precise_ip', c_uint64, 2),
            ('mmap_data', c_uint64, 1),
            ('sample_id_all', c_uint64, 1),
            ('exclude_host', c_uint64, 1),
            ('exclude_guest', c_uint64, 1),
            ('exclude_callchain_kernel', c_uint64, 1),
            ('exclude_callchain_user', c_uint64, 1),
            ('mmap2', c_uint64, 1),
            ('comm_exec', c_uint64, 1),
            ('use_clockid', c_uint64, 1),
            ('context_switch', c_uint64, 1),
            ('write_backward', c_uint64, 1),
            ('namespaces', c_uint64, 1),
            ('__reserved_1', c_uint64, 35),
            ('unnamed_2', union_anon_6),
            ('bp_type', c_uint32),
            ('unnamed_3', union_anon_7),
            ('unnamed_4', union_anon_8),
            ('branch_sample_type', c_uint64),
            ('sample_regs_user', c_uint64),
            ('sample_stack_user', c_uint32),
            ('clockid', c_int32),
            ('sample_regs_intr', c_uint64),
            ('aux_watermark', c_uint32),
            ('sample_max_stack', c_uint16),
            ('__reserved_2', c_uint16),
        ]

        # define constants for ioctl #
        _IOC_NRBITS = 8
        _IOC_TYPEBITS = 8
        _IOC_SIZEBITS = 14 # architecture specific
        _IOC_DIRBITS = 2
        _IOC_NRMASK = (1 << _IOC_NRBITS) - 1
        _IOC_TYPEMASK = (1 << _IOC_TYPEBITS) - 1
        _IOC_SIZEMASK = (1 << _IOC_SIZEBITS) - 1
        _IOC_DIRMASK = (1 << _IOC_DIRBITS) - 1
        _IOC_NRSHIFT = long(0)
        _IOC_TYPESHIFT = _IOC_NRSHIFT + _IOC_NRBITS
        _IOC_SIZESHIFT = _IOC_TYPESHIFT + _IOC_TYPEBITS
        _IOC_DIRSHIFT = _IOC_SIZESHIFT + _IOC_SIZEBITS
        _IOC_NONE = long(0)
        _IOC_WRITE = 1
        _IOC_READ = 2

        def _IOC(dir, type, nr, size):
            return  dir  << _IOC_DIRSHIFT  | \
                    ord(type) << _IOC_TYPESHIFT | \
                    nr   << _IOC_NRSHIFT   | \
                    size << _IOC_SIZESHIFT

        def _IO(type, nr): return _IOC(_IOC_NONE, type, nr, 0)
        def _IOR(type, nr, size): return _IOC(_IOC_READ, type, nr, size)
        def _IOW(type, nr, size): return _IOC(_IOC_WRITE, type, nr, size)
        def _IOWR(type, nr, size): return _IOC(_IOC_READ | _IOC_WRITE, type, nr, size)

        # define CMD #
        PERF_EVENT_IOC_ENABLE = _IO('$', 0)
        PERF_EVENT_IOC_DISABLE = _IO('$', 1)
        PERF_EVENT_IOC_REFRESH = _IO('$', 2)
        PERF_EVENT_IOC_RESET = _IO('$', 3)
        PERF_EVENT_IOC_PERIOD = _IOW('$', 4, sizeof(c_uint64))
        PERF_EVENT_IOC_SET_OUTPUT = _IO('$', 5)
        PERF_EVENT_IOC_SET_FILTER = _IOW('$', 6, sizeof(c_uint))
        PERF_EVENT_IOC_ID = _IOR('$', 7, sizeof(c_uint64))
        PERF_EVENT_IOC_SET_BPF = _IOW('$', 8, sizeof(c_uint32))
        PERF_EVENT_IOC_PAUSE_OUTPUT = _IOW('$', 9, sizeof(c_uint32))

        # declare syscalls #
        SysMgr.libcObj.syscall.argtypes = \
            [c_int, POINTER(struct_perf_event_attr),
                c_int, c_int, c_int, c_ulong]
        SysMgr.libcObj.syscall.restype = c_int
        SysMgr.libcObj.ioctl.restype = c_int
        SysMgr.libcObj.ioctl.argtypes = [c_int, c_ulong, c_int]

        # set struct perf_event_attr #
        perf_attr = struct_perf_event_attr()
        perf_attr.type = nrType
        perf_attr.config = nrConfig
        perf_attr.size = sizeof(perf_attr)
        perf_attr.disabled = 1
        #perf_attr.exclude_user = 1
        #perf_attr.exclude_kernel = 1
        #perf_attr.exclude_hv = 1
        #perf_attr.exclude_idle = 1

        # call a perf_event_open syscall #
        '''
        int perf_event_open(struct perf_event_attr *attr,
            pid_t pid, int cpu, int group_fd, unsigned long flags);
        '''
        # reference to http://man7.org/linux/man-pages/man2/perf_event_open.2.html #
        fd = SysMgr.libcObj.syscall(
            ConfigMgr.sysList.index('sys_perf_event_open'),
            pointer(perf_attr), pid, cpu, -1, 0)

        if fd < 0:
            # check root permission #
            if not SysMgr.isRoot():
                SysMgr.printWarn(
                    'fail to get root permission to open perf event')
                return
            else:
                return -1

        # control perf event #
        SysMgr.libcObj.ioctl(fd, PERF_EVENT_IOC_RESET, 0)
        SysMgr.libcObj.ioctl(fd, PERF_EVENT_IOC_ENABLE, 0)

        # free perf_attr object, but memory leak exists now #
        del perf_attr

        return fd



    @staticmethod
    def readPerfEvents(fdList):
        if SysMgr.guiderObj:
            retList = []

            for fd in fdList:
                try:
                    # read PMU data #
                    value = SysMgr.guiderObj.perf_event_read(fd) # pylint: disable=no-member

                    # add value to list #
                    retList.append(value)
                except SystemExit:
                    sys.exit(0)
                except:
                    retList.append(None)

            return retList

        # load libc #
        if not SysMgr.loadLibcObj():
            return

        # define struct read_group_format #
        class struct_anon_5(Structure):
            __slots__ = [
                'value',
                'id',
            ]

            _fields_ = [
                ('value', c_uint64),
                ('id', c_uint64),
            ]

        '''
        struct read_group_format {
            uint64_t nr;            /* The number of events */
            uint64_t time_enabled;  /* if PERF_FORMAT_TOTAL_TIME_ENABLED */
            uint64_t time_running;  /* if PERF_FORMAT_TOTAL_TIME_RUNNING */
            struct {
                uint64_t value;     /* The value of the event */
                uint64_t id;        /* if PERF_FORMAT_ID */
            } values[];
        };
        '''
        '''
        class struct_read_group_format(Structure):
            __slots__ = [
                'nr',
                #'time_enabled',
                #'time_running',
                'values',
            ]

            _fields_ = [
                ('nr', c_uint64),
                #('time_enabled', c_uint64),
                #('time_running', c_uint64),
                ('values', POINTER(struct_anon_5)),
            ]
        '''

        # define struct read_format #
        '''
        struct read_format {
            uint64_t value;         /* The value of the event */
            uint64_t time_enabled;  /* if PERF_FORMAT_TOTAL_TIME_ENABLED */
            uint64_t time_running;  /* if PERF_FORMAT_TOTAL_TIME_RUNNING */
            uint64_t id;            /* if PERF_FORMAT_ID */
        };
        '''
        class struct_read_format(Structure):
            __slots__ = [
                'value',
                #'time_enabled',
                #'time_running',
                'id',
            ]

            _fields_ = [
                ('value', c_uint64),
                #('time_enabled', c_uint64),
                #('time_running', c_uint64),
                ('id', c_uint64),
            ]

        # define IOC for ioctl call #
        _IOC_NRBITS = 8
        _IOC_TYPEBITS = 8
        _IOC_SIZEBITS = 14 # architecture specific
        _IOC_DIRBITS = 2
        _IOC_NRMASK = (1 << _IOC_NRBITS) - 1
        _IOC_TYPEMASK = (1 << _IOC_TYPEBITS) - 1
        _IOC_SIZEMASK = (1 << _IOC_SIZEBITS) - 1
        _IOC_DIRMASK = (1 << _IOC_DIRBITS) - 1
        _IOC_NRSHIFT = long(0)
        _IOC_TYPESHIFT = _IOC_NRSHIFT + _IOC_NRBITS
        _IOC_SIZESHIFT = _IOC_TYPESHIFT + _IOC_TYPEBITS
        _IOC_DIRSHIFT = _IOC_SIZESHIFT + _IOC_SIZEBITS
        _IOC_NONE = long(0)
        _IOC_WRITE = 1
        _IOC_READ = 2

        def _IOC(dir, type, nr, size):
            return  dir  << _IOC_DIRSHIFT  | \
                    ord(type) << _IOC_TYPESHIFT | \
                    nr   << _IOC_NRSHIFT   | \
                    size << _IOC_SIZESHIFT

        def _IO(type, nr):
            return _IOC(_IOC_NONE, type, nr, 0)
        def _IOR(type, nr, size):
            return _IOC(_IOC_READ, type, nr, size)
        def _IOW(type, nr, size):
            return _IOC(_IOC_WRITE, type, nr, size)
        def _IOWR(type, nr, size):
            return _IOC(_IOC_READ | _IOC_WRITE, type, nr, size)

        # define CMD #
        PERF_EVENT_IOC_ENABLE = _IO ('$', 0)
        PERF_EVENT_IOC_DISABLE = _IO ('$', 1)
        PERF_EVENT_IOC_REFRESH = _IO ('$', 2)
        PERF_EVENT_IOC_RESET = _IO ('$', 3)
        PERF_EVENT_IOC_PERIOD = _IOW('$', 4, sizeof(c_uint64))
        PERF_EVENT_IOC_SET_OUTPUT = _IO ('$', 5)
        PERF_EVENT_IOC_SET_FILTER = _IOW('$', 6, sizeof(c_uint))
        PERF_EVENT_IOC_ID = _IOR('$', 7, sizeof(c_uint64))
        PERF_EVENT_IOC_SET_BPF = _IOW('$', 8, sizeof(c_uint32))
        PERF_EVENT_IOC_PAUSE_OUTPUT = _IOW('$', 9, sizeof(c_uint32))

        # declare syscalls #
        SysMgr.libcObj.ioctl.restype = c_int
        SysMgr.libcObj.ioctl.argtypes = [c_int, c_ulong]
        SysMgr.libcObj.read.argtypes = [c_int, POINTER(None), c_uint]
        SysMgr.libcObj.read.restype = c_int

        # declare buffer and retList #
        pbuf = (8 * c_ubyte)()
        retList = []

        for fd in fdList:
            try:
                # read PMU data #
                SysMgr.libcObj.read(fd, pointer(pbuf), sizeof(pbuf))

                # control perf event #
                SysMgr.libcObj.ioctl(fd, PERF_EVENT_IOC_RESET, 0)

                # cast buffer to data #
                retList.append(
                    cast(pbuf, POINTER(c_ulong)).contents.value)
            except SystemExit:
                sys.exit(0)
            except:
                retList.append(None)

        return retList



    @staticmethod
    def initSystemPerfEvents():
        # check perf option #
        if not SysMgr.perfEnable:
            return

        # check root permission #
        if not SysMgr.isRoot():
            SysMgr.perfEnable = False
            return

        # check config #
        try:
            PMUs = '/sys/bus/event_source/devices'
            attrPath = '%s/sys/kernel/perf_event_paranoid' % \
                SysMgr.procPath
            with open(attrPath, 'w+') as fd:
                '''
                -1 - not paranoid at all
                 0 - disallow raw tracepoint access for unpriv
                 1 - disallow CPU events for unpriv
                 2 - disallow kernel profiling for unpriv
                 3 - disallow user profiling for unpriv
                '''
                paranoid = long(fd.readline()[:-1])
                if paranoid > -1:
                    fd.seek(0)
                    # write all privilege to read perf events #
                    fd.write('-1')
                    SysMgr.printWarn((
                        'change value of %s from %s to -1 '
                        'to read all perf events') % \
                        (attrPath, paranoid))
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printWarn(
                "enable CONFIG_PERF_EVENTS kernel option")
            return

        hwTargetList = [
            'PERF_COUNT_HW_CPU_CYCLES',
            'PERF_COUNT_HW_INSTRUCTIONS',
            'PERF_COUNT_HW_CACHE_REFERENCES',
            'PERF_COUNT_HW_CACHE_MISSES',
            'PERF_COUNT_HW_BRANCH_INSTRUCTIONS',
            'PERF_COUNT_HW_BRANCH_MISSES',
            ]

        swTargetList = [
            'PERF_COUNT_SW_CPU_CLOCK',
            'PERF_COUNT_SW_PAGE_FAULTS_MIN',
            'PERF_COUNT_SW_PAGE_FAULTS_MAJ',
            ]

        successCnt = long(0)
        cpuPath = '/sys/devices/system/cpu'
        cpuList = \
            [ coreId.strip('cpu') for coreId in os.listdir(cpuPath) \
            if coreId.startswith('cpu') ]

        for item in cpuList:
            try:
                coreId = long(item)
            except:
                continue

            SysMgr.perfEventChannel[coreId] = {}

            # HW Events #
            for evt in hwTargetList:
                # initialize hw event channels #
                SysMgr.perfEventChannel[coreId][evt] = \
                    SysMgr.openPerfEvent(evt, coreId)

                # handle unavailable hw events #
                if SysMgr.perfEventChannel[coreId][evt] == -1:
                    del SysMgr.perfEventChannel[coreId][evt]
                elif not SysMgr.perfEventChannel[coreId][evt]:
                    return
                else:
                    successCnt += 1

            # SW Events #
            for evt in swTargetList:
                # initialize sw event channels #
                SysMgr.perfEventChannel[coreId][evt] = \
                    SysMgr.openPerfEvent(evt, coreId)

                # handle unavailable sw events #
                if SysMgr.perfEventChannel[coreId][evt] == -1:
                    del SysMgr.perfEventChannel[coreId][evt]
                elif not SysMgr.perfEventChannel[coreId][evt]:
                    return
                else:
                    successCnt += 1

            if not SysMgr.perfTargetEvent and \
                len(SysMgr.perfEventChannel[coreId]) > 0:
                SysMgr.perfTargetEvent = \
                    list(SysMgr.perfEventChannel[coreId].keys())

        if successCnt == 0:
            SysMgr.printWarn('fail to find available perf event')
            SysMgr.perfEnable = False
            SysMgr.perfGroupEnable = False



    @staticmethod
    def initProcPerfEvents(pid):
        eventChannel = {}

        for evt in SysMgr.perfTargetEvent:
            eventChannel[evt] = \
                SysMgr.openPerfEvent(evt, -1, pid)

        return eventChannel



    @staticmethod
    def collectSystemPerfData():
        SysMgr.perfEventData = {}

        # check perf event option #
        if SysMgr.perfGroupEnable and \
            not SysMgr.perfEventChannel:
            return

        # check perf event channel #
        for coreId in list(SysMgr.perfEventChannel.keys()):
            # make event list #
            events = list(SysMgr.perfEventChannel[coreId].keys())

            # remove all core events if specific target process exist #
            if SysMgr.perfGroupEnable:
                for fd in SysMgr.perfEventChannel[coreId].values():
                    os.close(fd)
                del SysMgr.perfEventChannel[coreId]
                continue

            # get event data #
            values = SysMgr.readPerfEvents(
                SysMgr.perfEventChannel[coreId].values())

            if not values:
                continue

            # summarize perf data of each cores #
            for idx, evt in enumerate(events):
                try:
                    SysMgr.perfEventData[evt] += values[idx]
                except:
                    SysMgr.perfEventData[evt] = values[idx]



    @staticmethod
    def collectProcPerfData(fdList):
        perfData = {}

        # make event list #
        events = list(fdList.keys())

        # get event data #
        values = SysMgr.readPerfEvents(fdList.values())

        # summarize perf data of each cores #
        for idx, evt in enumerate(events):
            perfData[evt] = values[idx]

        return perfData



    @staticmethod
    def getPerfString(value):
        perfbuf = ''

        if not value:
            return perfbuf

        convColor= UtilMgr.convColor
        convSize = UtilMgr.convSize2Unit

        inst = cpucycle = -1
        cacheref = cachemiss = cachemissrate = -1
        branch = branchmiss = branchmissrate = -1

        # IPC stats #
        try:
            cpucycle = value['PERF_COUNT_HW_CPU_CYCLES']
            perfbuf = '%sCycle: %s / ' % \
                (perfbuf, convColor(convSize(cpucycle), 'YELLOW'))
            inst = value['PERF_COUNT_HW_INSTRUCTIONS']
            perfbuf = '%sInst: %s / ' % \
                (perfbuf, convSize(inst))
            ipc = inst / float(cpucycle)
            perfbuf = '%sIPC: %.2f / ' % (perfbuf, ipc)
        except SystemExit:
            sys.exit(0)
        except:
            pass

        # CACHE stats #
        try:
            cacheref = value['PERF_COUNT_HW_CACHE_REFERENCES']
            cachemiss = value['PERF_COUNT_HW_CACHE_MISSES']
            cachemissrate = cachemiss / float(cacheref) * 100
            perfbuf = '%sCacheMiss : %s(%s%%) / ' % \
                (perfbuf, convSize(cachemiss),
                    convColor(long(cachemissrate), 'YELLOW'))
        except SystemExit:
            sys.exit(0)
        except:
            pass

        # BRANCH stats #
        try:
            branch = value['PERF_COUNT_HW_BRANCH_INSTRUCTIONS']
            branchmiss = value['PERF_COUNT_HW_BRANCH_MISSES']
            branchmissrate = branchmiss / float(branch) * 100
            perfbuf = '%sBrcMiss: %s(%s%%) / ' % \
                (perfbuf, convSize(branchmiss),
                    convColor(long(branchmissrate), 'YELLOW'))
        except SystemExit:
            sys.exit(0)
        except:
            pass

        # CPU stats #
        try:
            perfbuf = '%sClk: %s / ' % \
                (perfbuf, convSize(
                    value['PERF_COUNT_SW_CPU_CLOCK']))
        except SystemExit:
            sys.exit(0)
        except:
            pass

        # FAULT stats #
        try:
            faultmin = value['PERF_COUNT_SW_PAGE_FAULTS_MIN']
            faultmaj = value['PERF_COUNT_SW_PAGE_FAULTS_MAJ']
            perfbuf = '%sMinFlt: %s / MajFlt: %s / ' % \
                (perfbuf, format(faultmin, ','), format(faultmaj, ','))
        except SystemExit:
            sys.exit(0)
        except:
            pass

        try:
            if len(perfbuf) > 0:
                perfbuf = '[%s]' % perfbuf[:perfbuf.rfind(' /')]
        except SystemExit:
            sys.exit(0)
        except:
            pass

        return perfbuf



    @staticmethod
    def writeKernelCmd():
        effectiveCmd = []

        if not SysMgr.keventEnable:
            return
        elif not SysMgr.kernelCmd:
            SysMgr.printErr(
                "wrong format for kernel command [NAME:FUNC|ADDR{:ARGS:RET}]")
            sys.exit(0)
        elif not os.path.isfile(
            SysMgr.mountPath + '../kprobe_events'):
            SysMgr.printErr(
                "enable CONFIG_KPROBES & CONFIG_KPROBE_EVENTS kernel option")
            sys.exit(0)

        for cmd in SysMgr.kernelCmd:
            cmdFormat = cmd.split(':')

            # check command format #
            cmdCnt = len(cmdFormat)
            if not (2 <= cmdCnt <= 4):
                SysMgr.printErr(
                    "wrong format for kernel command "
                    "[NAME:FUNC|ADDR{:ARGS:RET}]")
                sys.exit(0)

            for item in effectiveCmd:
                if cmdFormat[0] == item[0]:
                    SysMgr.printErr(
                        "redundant kernel event name '%s'" % item[0])
                    sys.exit(0)

            effectiveCmd.append(cmdFormat)

        # print kprobe event list #
        SysMgr.printInfo("enabled kernel events [ %s ]" % \
            ', '.join([ ':'.join(cmd) for cmd in effectiveCmd ]))

        # apply kprobe events #
        for cmd in effectiveCmd:
            # check redundant event name #
            if SysMgr.userCmd and \
                cmd[0] in [ucmd.split(':')[0] for ucmd in SysMgr.userCmd]:
                SysMgr.printErr(
                    "redundant name '%s' for user event and kernel event" % \
                    cmd[0])
                sys.exit(0)

            # make entry commands #
            pCmd = 'p:%s_enter %s' % (cmd[0], cmd[1])
            sCmd = ''
            try:
                # parse argument option #
                for rCmd in cmd[2].split('.'):
                    # convert ; to : for type definition #
                    rCmd = rCmd.replace(';', ':')

                    # check absolute argument #
                    if not rCmd:
                        pass
                    elif rCmd[0] == '#':
                        sCmd = '%s %s' % (sCmd, rCmd[1:])
                        continue
                    elif len(rCmd.split('/')) == 1:
                        sCmd = '%s %s' % (sCmd, rCmd)
                        continue

                    rVal = rCmd.split('/')
                    if len(rVal) < 2:
                        continue
                    elif len(rVal) > 2:
                        SysMgr.printErr(
                            "wrong command '%s'" % rCmd)
                        sys.exit(0)
                    tVal = rVal[1]

                    # count the number of prefix * #
                    wCnt = long(0)
                    for idx, ch in enumerate(tVal):
                        if ch != '*':
                            wCnt = idx
                            break

                    # make entry command #
                    tVal = '%s%s%s:%s' % \
                        ('+0(' * wCnt, rVal[0], ')' * wCnt, tVal[wCnt:])

                    # add argument command to entry command #
                    sCmd = '%s %s' % (sCmd, tVal)
            except SystemExit:
                sys.exit(0)
            except:
                pass

            # apply entry command #
            if sCmd != ' NONE':
                pCmd = '%s %s' % (pCmd, sCmd)
                if SysMgr.writeCmd(
                        '../kprobe_events', pCmd, append=True) < 0:
                    SysMgr.printErr("wrong command '%s'" % pCmd)
                    sys.exit(0)

            # make return commands #
            rCmd = 'r:%s_exit %s' % (cmd[0], cmd[1])
            sCmd = ''

            try:
                tCmd = cmd[3]

                # check absolute argument #
                if tCmd[0] == '#':
                    sCmd = '%s' % (tCmd[1:])
                else:
                    rVal = tCmd.split('/')
                    if len(rVal) > 2:
                        SysMgr.printErr("wrong command '%s'" % tCmd)
                        sys.exit(0)
                    tVal = rVal[0]

                    # count the number of prefix * #
                    wCnt = long(0)
                    for idx, ch in enumerate(tVal):
                        if ch != '*':
                            wCnt = idx
                            break

                    if tCmd != 'NONE':
                        # make return command #
                        sCmd = '%s%s%s:%s' % \
                            ('+0(' * wCnt, '$retval', ')' * wCnt, tVal[wCnt:])
                    else:
                        sCmd = 'NONE'
            except SystemExit:
                sys.exit(0)
            except:
                pass

            # apply return command #
            if sCmd != 'NONE':
                rCmd = '%s %s' % (rCmd, sCmd)
                if SysMgr.writeCmd(
                    '../kprobe_events', rCmd, append=True) < 0:
                    SysMgr.printErr("wrong command '%s'" % rCmd)
                    sys.exit(0)

        # apply filter #
        if SysMgr.filterGroup:
            cmd = SysMgr.getPidFilter()
            if cmd != '':
                SysMgr.writeCmd("kprobes/filter", cmd)
            else:
                SysMgr.printErr("fail to apply '%s' to kprobe filter" % cmd)
                sys.exit(0)

        # enable kprobe events #
        if SysMgr.writeCmd("kprobes/enable", '1') < 0:
            SysMgr.printErr("fail to apply '%s' to kprobe events" % cmd)
            sys.exit(0)



    @staticmethod
    def writeUserCmd():
        effectiveCmd = []

        if not SysMgr.ueventEnable:
            return
        elif not SysMgr.userCmd:
            SysMgr.printErr(
                "wrong format for user command [NAME:FUNC|ADDR:FILE]")
            sys.exit(0)
        elif not os.path.isfile(
            SysMgr.mountPath + '../uprobe_events'):
            SysMgr.printErr(
                "enable CONFIG_UPROBES & CONFIG_UPROBE_EVENT kernel option")
            sys.exit(0)

        kernelCmd = SysMgr.kernelCmd

        for cmd in SysMgr.userCmd:
            addr = None
            cvtCmd = cmd.replace("::", "#")
            cmdFormat = cvtCmd.split(':')
            cmdFormat = [ cmd.replace("#", "::") for cmd in cmdFormat ]

            if len(cmdFormat) != 3:
                SysMgr.printErr(
                    "wrong format for user command [NAME:FUNC|ADDR:FILE]")
                sys.exit(0)

            # check redundant event name #
            if kernelCmd and \
                cmd[0] in [kcmd.split(':')[0] for kcmd in kernelCmd]:
                SysMgr.printErr((
                    "redundant event name '%s' "
                    "as user event and kernel event") % cmd[0])
                sys.exit(0)

            # check binary file #
            if not os.path.isfile(cmdFormat[2]):
                SysMgr.printErr(
                    "fail to find '%s' binary" % cmdFormat[2])
                sys.exit(0)

            # symbol input #
            objdumpPath = None
            if not cmdFormat[1].startswith('0x'):
                # symbol input with no objdump path #
                if not 'OBJDUMP' in SysMgr.environList:
                    # get address of symbol in binary #
                    addr = ElfAnalyzer.getSymOffset(
                        cmdFormat[1], cmdFormat[2], loadAddr=False)
                # symbol input with objdump #
                else:
                    objdumpPath = SysMgr.environList['OBJDUMP'][0]

                    SysMgr.printInfo(
                        "use '%s' as objdump path" % objdumpPath)

                    if not os.path.isfile(objdumpPath):
                        SysMgr.printErr(
                            "fail to find %s to use objdump" % objdumpPath)
                        sys.exit(0)

                    # get address of symbol in binary #
                    addr = ElfAnalyzer.getSymOffset(
                        cmdFormat[1], cmdFormat[2], objdumpPath, loadAddr=True)

                if not addr:
                    SysMgr.printErr("fail to find '%s' in %s" % \
                        (cmdFormat[1], cmdFormat[2]))
                    sys.exit(0)
            # address input #
            else:
                addr = cmdFormat[1]
                try:
                    hex(long(addr, base=16))
                except:
                    SysMgr.printErr(
                        "fail to recognize address %s" % addr)
                    sys.exit(0)

            for item in effectiveCmd:
                if cmdFormat[0] == item[0]:
                    SysMgr.printErr(
                        "redundant user event name '%s'" % item[0])
                    sys.exit(0)

            # convert address #
            if type(addr) is list:
                try:
                    addr = str(hex(addr[0][0])).rstrip('L')
                except:
                    addr = str(addr[0][1])

            effectiveCmd.append([cmdFormat[0], addr, cmdFormat[2]])

        # print uprobe event list #
        SysMgr.printInfo(
            "enabled user events [ %s ]" % \
                ', '.join([ ':'.join(cmd) for cmd in effectiveCmd ]))

        # apply uprobe events #
        for cmd in effectiveCmd:
            # apply entry events #
            pCmd = 'p:%s_enter %s:%s' % (cmd[0], cmd[2], cmd[1])
            if SysMgr.writeCmd('../uprobe_events', pCmd, append=True) < 0:
                SysMgr.printErr(
                    "wrong command '%s'" % pCmd)
                sys.exit(0)

            # apply return events #
            rCmd = 'r:%s_exit %s:%s' % (cmd[0], cmd[2], cmd[1])
            if SysMgr.writeCmd('../uprobe_events', rCmd, append=True) < 0:
                SysMgr.printErr(
                    "wrong command '%s'" % rCmd)
                sys.exit(0)

        # apply filter #
        if SysMgr.filterGroup:
            cmd = SysMgr.getPidFilter()
            if cmd != '':
                SysMgr.writeCmd("uprobes/filter", cmd)
            else:
                SysMgr.printErr("fail to apply '%s' to uprobe filter" % cmd)
                sys.exit(0)

        # enable uprobe events #
        if SysMgr.writeCmd("uprobes/enable", '1') < 0:
            SysMgr.printErr("fail to apply '%s' to uprobe events" % cmd)
            sys.exit(0)



    @staticmethod
    def writeSyscallCmd(enable):
        scmd = ""
        defaultList = [
            'sys_execve',
            'sys_execveat',
            'sys_nice',
            'sys_setpriority',
            'sys_sched_setparam',
            'sys_sched_setscheduler',
            'sys_sched_setattr',
            'sys_bpf',
            'sys_ioprio_set',
            ]

        if SysMgr.isFuncMode() and \
            not SysMgr.heapEnable:
            cmd = 'raw_syscalls/sys_enter/enable'
        else:
            cmd = 'raw_syscalls/enable'

        # specific syscalls #
        if enable:
            sfilter = ""
            pfilter = SysMgr.getPidFilter()
            if SysMgr.syscallList:
                sfilter = "("
                for val in SysMgr.syscallList:
                    sfilter += " id == %s ||" % val
                sfilter = "%s )" % sfilter[:sfilter.rfind(" ||")]

            if len(sfilter) > 0 and len(pfilter) > 0:
                scmd = "(%s && %s)" % (sfilter, pfilter)
            elif len(sfilter) > 0:
                scmd = sfilter
                for item in defaultList:
                    try:
                        scmd = "%s || ( id == %s )" % \
                            (scmd, ConfigMgr.sysList.index(item))
                    except:
                        continue
            elif len(pfilter) > 0:
                scmd = "(%s)" % pfilter
            else:
                pass
        # default syscalls #
        else:
            for item in defaultList:
                try:
                    scmd = "%s || ( id == %s )" % \
                        (scmd, ConfigMgr.sysList.index(item))
                except:
                    continue
            scmd = scmd[scmd.find("("):]

        SysMgr.writeCmd('raw_syscalls/filter', scmd)
        ret = SysMgr.writeCmd(cmd, '1')
        if ret < 0:
            SysMgr.printWarn("fail to enable syscall events", True)



    @staticmethod
    def printSigError(tid, signal, warn=True):
        if warn:
            printFunc = SysMgr.printWarn
        else:
            printFunc = SysMgr.printErr

        printFunc(
            "fail to send %s to thread %s" % (signal, tid), reason=True)



    @staticmethod
    def getLine(start=1):
        try:
            inspect = SysMgr.getPkg('inspect')
            lines = ''
            for stack in inspect.stack()[start:-1]:
                lines += '%s<' % inspect.getframeinfo(stack[0]).lineno
            return lines.rstrip('<')
        except:
            return None



    @staticmethod
    def getErrMsg(start=2):
        et, err, to = sys.exc_info()
        lineno = SysMgr.getLine(start=start)

        try:
            if not err.args or err.args[0] == 0:
                return '%s at %s line' % \
                    (sys.exc_info()[0].__name__, lineno)
        except:
            if to:
                return 'N/A at %s line' % lineno
            else:
                return 'N/A'

        try:
            code = '%s-' % errno.errorcode[err.args[0]]
        except:
            code = ''

        errstr = ' '.join(list(map(str, err.args)))
        return '%s%s at %s line' % (code, errstr, lineno)



    def disableAllEvents(self):
        for event in list(self.cmdList.keys()):
            self.cmdList[event] = False



    @staticmethod
    def writeCustomCmd():
        effectiveCmd = []

        if not SysMgr.customCmd:
            return

        if SysMgr.filterGroup == []:
            pidFilter = 'common_pid != 0'
        else:
            pidFilter = SysMgr.getPidFilter()

        for cmd in SysMgr.customCmd:
            cmdFormat = cmd.split(':')

            if cmdFormat[0] == '':
                SysMgr.printErr("wrong event '%s'" % cmdFormat[0])
                sys.exit(0)

            # check filter #
            if len(cmdFormat) == 1:
                origFilter = ''
                cmdFormat.append(pidFilter)
            else:
                origFilter = cmdFormat[1]
                cmdFormat[1] = pidFilter + " && " + cmdFormat[1]

            # check effective event #
            if SysMgr.writeCmd(cmdFormat[0] + '/enable', '0') < 0:
                SysMgr.printErr("wrong event '%s'" % cmdFormat[0])
                sys.exit(0)

            # check and enable effective filter #
            if len(cmdFormat) > 1 and \
                SysMgr.writeCmd(cmdFormat[0] + '/filter', cmdFormat[1]) < 0:
                SysMgr.printErr("wrong filter '%s' for '%s' event" % \
                    (origFilter, cmdFormat[0]))
                sys.exit(0)

            # check and enable effective event #
            if SysMgr.writeCmd(cmdFormat[0] + '/enable', '1') < 0:
                SysMgr.printErr("wrong event '%s'" % cmdFormat[0])
                sys.exit(0)
            else:
                effectiveCmd.append(cmdFormat[0])

        if len(effectiveCmd) > 0:
            SysMgr.printInfo(
                "enabled custom events [ %s ]" % ', '.join(effectiveCmd))



    @staticmethod
    def printAnalOption():
        enableStat = ''
        disableStat = ''

        if SysMgr.outputFile:
            return

        if not SysMgr.isRecordMode() and \
            not SysMgr.isTopMode():
            # common options #
            enableStat += SysMgr.arch.upper() + ' '
            if SysMgr.warnEnable:
                enableStat += 'WARN '

        # function mode #
        if SysMgr.isFuncMode():
            if not SysMgr.heapEnable:
                disableStat += 'HEAP '
            else:
                enableStat += 'HEAP '

            if not SysMgr.userEnable:
                disableStat += 'USER '
            else:
                enableStat += 'USER '

            if SysMgr.customCmd:
                SysMgr.printInfo(
                    "selected custom events [ %s ]" % \
                    ', '.join(SysMgr.customCmd))
        # thread mode #
        else:
            if SysMgr.intervalEnable > 0:
                enableStat += 'INTERVAL '
            else:
                disableStat += 'INTERVAL '

            if SysMgr.latEnable:
                enableStat += 'LATENCY '
            else:
                disableStat += 'LATENCY '

            if SysMgr.depEnable:
                enableStat += 'DEP '
            else:
                disableStat += 'DEP '

            if SysMgr.ueventEnable:
                enableStat += 'UEVT '
            else:
                disableStat += 'UEVT '

            if SysMgr.keventEnable:
                enableStat += 'KEVT '
            else:
                disableStat += 'KEVT '

            if SysMgr.irqEnable:
                enableStat += 'IRQ '
            else:
                disableStat += 'IRQ '

            if SysMgr.networkEnable:
                enableStat += 'NET '
            else:
                disableStat += 'NET '

            if SysMgr.powerEnable:
                enableStat += 'POWER '
            else:
                disableStat += 'POWER '

            if SysMgr.wqEnable:
                enableStat += 'WQ '
            else:
                disableStat += 'WQ '

            if SysMgr.preemptGroup:
                enableStat += 'PREEMPT '
            else:
                disableStat += 'PREEMPT '

            if SysMgr.perCoreList:
                enableStat += 'PERCORE '
            else:
                disableStat += 'PERCORE '

            if SysMgr.customCmd:
                SysMgr.printInfo(
                    "selected custom events [ %s ]" % \
                    ', '.join(SysMgr.customCmd))

        # common options #
        if SysMgr.showAll:
            enableStat += 'ALL '
        else:
            disableStat += 'ALL '

        if SysMgr.groupProcEnable:
            enableStat += 'PGRP '
        else:
            disableStat += 'PGRP '

        if SysMgr.cpuEnable:
            enableStat += 'CPU '
        else:
            disableStat += 'CPU '

        if SysMgr.memEnable:
            enableStat += 'MEM '
        else:
            disableStat += 'MEM '

        if SysMgr.blockEnable:
            enableStat += 'BLOCK '
        else:
            disableStat += 'BLOCK '

        if SysMgr.printEnable:
            enableStat += 'PRINT '
        else:
            disableStat += 'PRINT '

        if SysMgr.sysEnable:
            enableStat += 'SYSCALL '
        else:
            disableStat += 'SYSCALL '

        if SysMgr.lockEnable:
            enableStat += 'LOCK '
        else:
            disableStat += 'LOCK '

        if SysMgr.compressEnable:
            enableStat += 'COMP '
        else:
            disableStat += 'COMP '

        if SysMgr.countEnable:
            enableStat += 'CUT '
        else:
            disableStat += 'CUT '

        # check current mode #
        if SysMgr.disableAll:
            enableStat += 'DISABLE '

        # print options #
        if enableStat != '':
            SysMgr.printInfo(
                "enabled analysis options [ %s]" % enableStat)

        if disableStat != '':
            SysMgr.printWarn(
                "disabled analysis options [ %s]" % disableStat)



    @staticmethod
    def getUdsList():
        udsBuf = []
        udsPath = '%s/net/unix' % SysMgr.procPath

        try:
            with open(udsPath, 'r') as fd:
                udsBuf = fd.readlines()
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printOpenErr(udsPath)
            return udsBuf

        UDS_ATTR = []
        for line in udsBuf:
            UDS_ATTR.append(line.split())

        # remove title #
        UDS_ATTR.pop(0)

        return UDS_ATTR



    @staticmethod
    def getUdpList():
        if SysMgr.udpListCache:
            return SysMgr.udpListCache

        udpBuf = []
        udpPath = '%s/net/udp' % SysMgr.procPath

        try:
            with open(udpPath, 'r') as fd:
                udpBuf = fd.readlines()
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printOpenErr(udpPath)
            return udpBuf

        udpList = []
        for line in udpBuf:
            udpList.append(line.split())

        # remove title #
        udpList.pop(0)

        SysMgr.udpListCache = udpList

        return udpList



    @staticmethod
    def getTcpList():
        if SysMgr.tcpListCache:
            return SysMgr.tcpListCache

        tcpBuf = []
        tcpPath = '%s/net/tcp' % SysMgr.procPath

        try:
            with open(tcpPath, 'r') as fd:
                tcpBuf = fd.readlines()
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printOpenErr(tcpPath)
            return tcpBuf

        tcpList = []
        for line in tcpBuf:
            tcpList.append(line.split())

        # remove title #
        tcpList.pop(0)

        SysMgr.tcpListCache = tcpList

        return tcpList



    @staticmethod
    def printProfileCmd():
        for idx, val in SysMgr.rcmdList.items():
            if not val:
                continue

            cmds = []
            for item in val:
                cmds.append(':'.join(item))
            SysMgr.printInfo(
                "user custom commands on %s [ %s ]" % (idx, ', '.join(cmds)))



    @staticmethod
    def getVDSO(elf=True, debug=False):
        # get address of vdso object #
        addr = SysMgr.getauxval("AT_SYSINFO_EHDR")
        if not addr:
            return None

        # create a memory file #
        fd = MemoryFile(addr, name='vdso')
        if not fd:
            SysMgr.printErr("fail to create memory file for vdso object")
            return None
        elif not elf:
            return fd

        # return vDSO #
        obj = ElfAnalyzer(path='vdso', fd=fd, debug=debug)
        if obj:
            ElfAnalyzer.cachedFiles['vdso'] = obj

        return obj



    @staticmethod
    def getauxval(attype):
        if not SysMgr.isLinux:
            return None

        try:
            nrType = ConfigMgr.AT_TYPE[attype]
        except:
            SysMgr.printErr(
                "fail to get entry type %s" % attype, True)
            return

        # load libc #
        if not SysMgr.loadLibcObj():
            return

        # declare syscalls #
        try:
            SysMgr.libcObj.getauxval.restype = c_ulong
            SysMgr.libcObj.getauxval.argtypes = [c_ulong]
        except:
            SysMgr.printErr("fail to find getauxval in libc")
            return None

        return SysMgr.libcObj.getauxval(c_ulong(nrType))



    @staticmethod
    def printProfileOption():
        enableStat = ''
        disableStat = ''

        # common options #
        enableStat += SysMgr.arch.upper() + ' '

        if SysMgr.warnEnable:
            enableStat += 'WARN '
        else:
            disableStat += 'WARN '

        if SysMgr.pipeEnable:
            enableStat += 'PIPE '
        else:
            disableStat += 'PIPE '

        if SysMgr.printEnable:
            enableStat += 'PRINT '
        else:
            disableStat += 'PRINT '

        if SysMgr.cgroupEnable:
            enableStat += 'CGROUP '
        else:
            disableStat += 'CGROUP '

        if SysMgr.encodeEnable:
            enableStat += 'ENCODE '
        else:
            disableStat += 'ENCODE '

        if SysMgr.compressEnable:
            enableStat += 'COMP '
        else:
            disableStat += 'COMP '

        # check current mode #
        if SysMgr.isTopMode():
            SysMgr.printInfo("<TOP MODE>")

            if SysMgr.fileTopEnable:
                enableStat += 'FILE '
            else:
                if SysMgr.processEnable:
                    enableStat += 'PROCESS '
                else:
                    enableStat += 'THREAD '

                if SysMgr.cpuEnable:
                    enableStat += 'CORE '
                else:
                    disableStat += 'CORE '

                if SysMgr.gpuEnable:
                    enableStat += 'GPU '
                else:
                    disableStat += 'GPU '

                if SysMgr.memEnable:
                    enableStat += 'MEM '
                else:
                    disableStat += 'MEM '

                if SysMgr.blockEnable:
                    enableStat += 'BLOCK '
                else:
                    disableStat += 'BLOCK '

                if SysMgr.irqEnable:
                    enableStat += 'IRQ '
                else:
                    disableStat += 'IRQ '

                if SysMgr.diskEnable:
                    enableStat += 'DISK '
                else:
                    disableStat += 'DISK '

                if SysMgr.perfEnable or \
                    SysMgr.perfGroupEnable:
                    enableStat += 'PERF '
                else:
                    disableStat += 'PERF '

                if SysMgr.nsEnable:
                    enableStat += 'NS '
                else:
                    disableStat += 'NS '

                if SysMgr.wchanEnable:
                    enableStat += 'WCHAN '
                else:
                    disableStat += 'WCHAN '

                if SysMgr.oomEnable:
                    enableStat += 'OOM '
                else:
                    disableStat += 'OOM '

                if SysMgr.floatEnable:
                    enableStat += 'FLOAT '
                else:
                    disableStat += 'FLOAT '

                if SysMgr.sigHandlerEnable:
                    enableStat += 'SIG '
                else:
                    disableStat += 'SIG '

                if SysMgr.wfcEnable:
                    enableStat += 'WFC '
                else:
                    disableStat += 'WFC '

                if SysMgr.cmdlineEnable:
                    enableStat += 'CMD '
                else:
                    disableStat += 'CMD '

                if SysMgr.stackEnable:
                    enableStat += 'STACK '

                if SysMgr.networkEnable:
                    enableStat += 'NET '

                if SysMgr.affinityEnable:
                    enableStat += 'AFNT '
                else:
                    disableStat += 'AFNT '

                if SysMgr.reportFileEnable:
                    enableStat += 'RFILE '
                else:
                    disableStat += 'RFILE '

                if SysMgr.pssEnable:
                    enableStat += 'PSS '
                else:
                    disableStat += 'PSS '

                if SysMgr.ussEnable:
                    enableStat += 'USS '
                else:
                    disableStat += 'USS '

                if SysMgr.wssEnable:
                    enableStat += 'WSS '
                else:
                    disableStat += 'WSS '

                if SysMgr.dltEnable:
                    enableStat += 'DLT '
                else:
                    disableStat += 'DLT '

                if SysMgr.syslogEnable:
                    enableStat += 'SYSLOG '
                else:
                    disableStat += 'SYSLOG '

                if SysMgr.dwarfEnable:
                    enableStat += 'DWARF '
                else:
                    disableStat += 'DWARF '

                if SysMgr.kmsgEnable:
                    enableStat += 'KMSG '
                else:
                    disableStat += 'KMSG '

                if SysMgr.journalEnable:
                    enableStat += 'JRL '
                else:
                    disableStat += 'JRL '

                if SysMgr.schedEnable:
                    enableStat += 'SCHED '
                else:
                    disableStat += 'SCHED '

                if SysMgr.delayEnable:
                    enableStat += 'DELAY '
                else:
                    disableStat += 'DELAY '

                if SysMgr.groupProcEnable:
                    enableStat += 'PGRP '
                else:
                    disableStat += 'PGRP '

                if SysMgr.reportEnable:
                    enableStat += 'REPORT '
                else:
                    disableStat += 'REPORT '

                if SysMgr.totalEnable:
                    enableStat += 'TOTAL '
                else:
                    disableStat += 'TOTAL '

                if SysMgr.barGraphEnable:
                    enableStat += 'BAR '
                else:
                    disableStat += 'BAR '

        elif SysMgr.isFuncMode():
            SysMgr.printInfo("<FUNCTION MODE>")

            if SysMgr.graphEnable:
                enableStat += 'GRAPH '
            else:
                disableStat += 'GRAPH '

                if not SysMgr.cpuEnable:
                    disableStat += 'CPU '
                else:
                    enableStat += 'CPU '

                if not SysMgr.memEnable:
                    disableStat += 'MEM '
                else:
                    enableStat += 'MEM '

                if not SysMgr.heapEnable:
                    disableStat += 'HEAP '
                else:
                    enableStat += 'HEAP '

                if not SysMgr.blockEnable:
                    disableStat += 'BLOCK '
                else:
                    enableStat += 'BLOCK '

                if not SysMgr.userEnable:
                    disableStat += 'USER '
                else:
                    enableStat += 'USER '

                if SysMgr.sysEnable:
                    enableStat += 'SYSCALL '
                else:
                    disableStat += 'SYSCALL '

                if SysMgr.lockEnable:
                    enableStat += 'LOCK '
                else:
                    disableStat += 'LOCK '

                if SysMgr.disableAll:
                    enableStat += 'DISABLE '
                else:
                    disableStat += 'DISABLE '

        elif SysMgr.isFileMode():
            SysMgr.printInfo("<FILE MODE>")

        elif SysMgr.isSystemMode():
            SysMgr.printInfo("<SYSTEM MODE>")

        else:
            SysMgr.printInfo("<THREAD MODE>")
            SysMgr.threadEnable = True

            if not SysMgr.cpuEnable:
                disableStat += 'CPU '
            else:
                enableStat += 'CPU '

            if SysMgr.memEnable:
                enableStat += 'MEM '
            else:
                disableStat += 'MEM '

            if SysMgr.blockEnable:
                enableStat += 'BLOCK '
            else:
                disableStat += 'BLOCK '

            if SysMgr.irqEnable:
                enableStat += 'IRQ '
            else:
                disableStat += 'IRQ '

            if SysMgr.ueventEnable:
                enableStat += 'UEVT '
            else:
                disableStat += 'UEVT '

            if SysMgr.keventEnable:
                enableStat += 'KEVT '
            else:
                disableStat += 'KEVT '

            if SysMgr.bufferLossEnable:
                enableStat += 'BLOSS '
            else:
                disableStat += 'BLOSS '

            if SysMgr.networkEnable:
                enableStat += 'NET '
            else:
                disableStat += 'NET '

            if SysMgr.depEnable:
                enableStat += 'DEP '
            else:
                disableStat += 'DEP '

            if SysMgr.latEnable:
                enableStat += 'LATENCY '
            else:
                disableStat += 'LATENCY '

            if SysMgr.sysEnable:
                enableStat += 'SYSCALL '
            else:
                disableStat += 'SYSCALL '

            if SysMgr.lockEnable:
                enableStat += 'LOCK '
            else:
                disableStat += 'LOCK '

            if SysMgr.powerEnable:
                enableStat += 'POWER '
            else:
                disableStat += 'POWER '

            if SysMgr.wqEnable:
                enableStat += 'WQ '
            else:
                disableStat += 'WQ '

            if SysMgr.resetEnable:
                enableStat += 'RESET '

            if SysMgr.disableAll:
                enableStat += 'DISABLE '

        # print options #
        if enableStat != '':
            SysMgr.printInfo(
                "enabled runtime options [ %s]" % enableStat)

        if disableStat != '':
            SysMgr.printWarn(
                "disabled runtime options [ %s]" % disableStat)



    @staticmethod
    def isThreadMode():
        return SysMgr.threadEnable



    @staticmethod
    def isFuncMode():
        return SysMgr.functionEnable



    @staticmethod
    def isFileMode():
        return SysMgr.fileEnable



    @staticmethod
    def isSystemMode():
        return SysMgr.systemEnable



    @staticmethod
    def defaultHandler(signum, frame):
        return



    @staticmethod
    def chldHandler(signum, frame):
        try:
            os.waitpid(-1, os.WNOHANG)
        except:
            pass



    @staticmethod
    def fgHandler(signum, frame):
        SysMgr.bgStatus = False



    @staticmethod
    def bgHandler(signum, frame):
        SysMgr.bgStatus = True

        if signum == signal.SIGTSTP:
            os.kill(SysMgr.pid, signal.SIGSTOP)
        elif signum == signal.SIGTTIN:
            sys.stdin.close()
            sys.stdin = None



    @staticmethod
    def winchHandler(signum, frame):
        SysMgr.getTty(update=True)



    @staticmethod
    def stopHandler(signum=None, frame=None):
        if SysMgr.exitFlag:
            os._exit(0)

        # masking signal #
        if signum:
            signal.signal(signum, signal.SIG_IGN)

        # write user command #
        SysMgr.writeTraceCmd('STOP')

        if SysMgr.isFileMode() or \
            SysMgr.isSystemMode():
            SysMgr.condExit = True

        elif SysMgr.isTopMode() or SysMgr.isTraceMode():
            if SysMgr.outPath:
                # reload data written to file #
                if SysMgr.pipeEnable:
                    SysMgr.reloadFileBuffer()

                SysMgr.printLogo(absolute=True, big=True)

                # save system info #
                SysMgr.sysInstance.saveSysStat()
                SysMgr.printInfoBuffer()

                # submit summarized report and details #
                TaskAnalyzer.printIntervalUsage()

                if os.path.exists(SysMgr.inputFile):
                    # get output size #
                    fsize = UtilMgr.getFileSize(SysMgr.inputFile)
                    if fsize and fsize != '0':
                        fsize = ' [%s]' % fsize
                    else:
                        fsize = ''

                    SysMgr.printInfo(
                        "saved results based monitoring into "
                        "'%s'%s successfully" % \
                        (SysMgr.inputFile, fsize))

            SysMgr.releaseResource()

            # re-enable signal again #
            if signum:
                signal.signal(signum, SysMgr.stopHandler)

            # quit to avoid termination #
            if not SysMgr.termFlag:
                SysMgr.progressCnt = long(0)
                return

            '''
            # enable for cProfile #
            sys.settrace
            sys.exit(0)
            '''

            # do terminate #
            os._exit(0)

        else:
            SysMgr.writeEvent("EVENT_STOP", False)
            if signum:
                signal.signal(signal.SIGINT, signal.SIG_DFL)
            SysMgr.stopRecording()

        # update record status #
        SysMgr.recordStatus = False

        SysMgr.repeatCount = long(0)

        SysMgr.printStat(
            'ready to save and analyze... [ STOP(Ctrl+c) ]')

        # enable signal again #
        if signum:
            signal.signal(signum, SysMgr.stopHandler)

        if not "ISMAIN" in os.environ:
            sys.exit(0)

        raise Exception('stop signal')



    @staticmethod
    def newHandler(signum=None, frame=None):
        SysMgr.condExit = False

        if SysMgr.isFileMode():
            SysMgr.printStat("saved file usage successfully")
        elif SysMgr.isSystemMode():
            pass
        elif SysMgr.isTopMode():
            # check silent mode #
            if not SysMgr.outPath:
                return

            # masking signal #
            if signum:
                signal.signal(signum, signal.SIG_IGN)

            # reload data written to file #
            if SysMgr.pipeEnable:
                SysMgr.reloadFileBuffer()

            SysMgr.printLogo(absolute=True, big=True)

            # save system info #
            SysMgr.sysInstance.saveSysStat()
            SysMgr.printInfoBuffer()

            # submit summarized report and details #
            TaskAnalyzer.printIntervalUsage()

            # close an output file to sync #
            try:
                SysMgr.printFd.close()
            except:
                pass
            finally:
                SysMgr.printFd = None

            # print output info #
            fsize = UtilMgr.getFileSize(SysMgr.inputFile)
            if fsize and fsize != '0':
                fsize = ' [%s]' % fsize
            else:
                fsize = ''

            SysMgr.printInfo(
                "saved results based monitoring into "
                "'%s'%s successfully" % \
                    (SysMgr.inputFile, fsize))

            # enable signal again #
            if signum:
                signal.signal(signum, SysMgr.newHandler)
        elif SysMgr.resetEnable:
            SysMgr.writeEvent("EVENT_START")
        else:
            SysMgr.writeEvent("EVENT_MARK")



    @staticmethod
    def exitHandler(signum, frame):
        if SysMgr.exitFlag:
            os._exit(0)

        # block signals and disable alarm for stable termination #
        SysMgr.setIgnoreSignal()
        signal.alarm(0)
        SysMgr.condExit = True

        # reset terminal #
        SysMgr.resetTTY()

        SysMgr.printWarn('terminated by user\n')

        sys.exit(0)



    @staticmethod
    def faultHandler(signum, frame):
        '''
        SysMgr.releaseResource()
        sys.stdout.write('terminated by SEGFAULT signal\n')
        '''
        os._exit(0)



    @staticmethod
    def timerHandler(signum, frame):
        raise Exception('timer expired')



    @staticmethod
    def alarmHandler(signum, frame):
        if SysMgr.repeatCount <= SysMgr.progressCnt and \
            SysMgr.termFlag:
            UtilMgr.deleteProgress()
            sys.exit(0)

        if SysMgr.repeatCount > 0:
            UtilMgr.printProgress(
                SysMgr.progressCnt, SysMgr.repeatCount)

        # update count #
        SysMgr.progressCnt += 1
        progressCnt = SysMgr.progressCnt
        repeatInterval = SysMgr.repeatInterval
        repeatCount = SysMgr.repeatCount

        # disable alarm handler #
        signal.signal(signal.SIGALRM, SysMgr.defaultHandler)

        if SysMgr.pipeEnable:
            if repeatCount == progressCnt:
                SysMgr.stopRecording()
                SysMgr.recordStatus = False
            signal.alarm(repeatInterval)
        elif SysMgr.outputFile:
            if repeatCount == 1 and SysMgr.termFlag:
                output = SysMgr.outputFile
            else:
                output = '%s_%s' % \
                    (SysMgr.outputFile, SysMgr.getRuntime())

            # save system info #
            SysMgr.sysInstance.saveSysStat()

            # read trace data #
            try:
                rpath = os.path.join(SysMgr.mountPath, '../trace')
                with open(rpath, 'r') as fr:
                    lines = fr.readlines()
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printOpenErr(rpath)
                sys.exit(0)

            # write trace data #
            try:
                SysMgr.saveTraceData(lines, output)
                SysMgr.clearInfoBuffer()
            except SystemExit:
                sys.exit(0)
            except:
                sys.exit(0)
        else:
            SysMgr.printErr(
                'fail to save data because file path is not set')
            sys.exit(0)

        # set alarm again #
        signal.signal(signal.SIGALRM, SysMgr.alarmHandler)



    @staticmethod
    def isTermSignal(sig):
        if sig == signal.SIGKILL or \
            sig == signal.SIGSEGV or \
            sig == signal.SIGABRT:
            return True
        else:
            return False



    @staticmethod
    def saveTraceData(lines, outputFile=None):
        if not outputFile:
            outputFile = SysMgr.outputFile

        # backup file already exists #
        SysMgr.backupFile(outputFile)

        disabledOptions = SysMgr.getOption('d')

        # compress data by default #
        if disabledOptions and 'C' in disabledOptions:
            compressEnable = False
        else:
            compressEnable = True

        # compress by gzip #
        if SysMgr.isRecordMode() and compressEnable:
            compressor = SysMgr.getPkg('gzip', False)
        else:
            compressor = None

        size = long(0)
        for line in lines:
            size += len(line)

        SysMgr.printInfo(
            "wait for writing data to '%s' [%s]" % \
                (outputFile, UtilMgr.convSize2Unit(size)))

        try:
            if compressor:
                fd = open(outputFile, 'wb')
                f = compressor.GzipFile(fileobj=fd)
            else:
                f = open(outputFile, 'w')

            # write system info #
            if SysMgr.systemInfoBuffer:
                magicStr = '%s\n' % SysMgr.magicStr

                if compressor:
                    magicStr = magicStr.encode('utf-8')

                f.write(magicStr)

                if compressor:
                    f.write(SysMgr.systemInfoBuffer.encode('utf-8'))
                else:
                    f.write(SysMgr.systemInfoBuffer)

                f.write(magicStr)

            # write trace info #
            if compressor:
                f.write('\n'.join(lines).encode('utf-8'))
            else:
                f.writelines(lines)

            f.close()

            # get output size #
            fsize = UtilMgr.getFileSize(outputFile)
            if fsize and fsize != '0':
                fsize = ' [%s]' % fsize
            else:
                fsize = ''

            SysMgr.printInfo(
                "finish saving trace data into '%s'%s successfully" % \
                (outputFile, fsize))
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printErr(
                "fail to write trace data to '%s'" % outputFile, True)



    @staticmethod
    def writeTraceCmd(time):
        if SysMgr.rcmdList == {}:
            return

        for cmd in SysMgr.rcmdList[time]:
            if len(cmd) == 2:
                path = cmd[0]
                val = cmd[1]

                try:
                    with open(path, 'w') as fd:
                        fd.write(val)
                        SysMgr.printInfo(
                            "applied command '%s' to %s successfully" % \
                            (val, path))
                except:
                    SysMgr.printWarn(
                        "fail to apply command '%s' to %s" % (val, path))
            elif len(cmd) == 1:
                os.system(cmd[0])



    @staticmethod
    def readCmdVal(path):
        # open for applying command #
        try:
            target = '%s%s' % (SysMgr.mountPath, path)
            with open(target, 'r') as fd:
                return fd.read()[:-1]
        except:
            SysMgr.printErr(
                "fail to read data from %s\n" % target)
            return None



    @staticmethod
    def procReadline(path):
        target = '%s/%s' % (SysMgr.procPath, path)
        with open(target, 'r') as fd:
            return fd.readline()



    @staticmethod
    def procReadlines(path):
        target = '%s/%s' % (SysMgr.procPath, path)
        with open(target, 'r') as fd:
            return fd.readlines()



    @staticmethod
    def writeCmd(path, val, append=False):
        # set file open permission #
        if append:
            perm = 'a+'
        else:
            perm = 'w'

        # record command to file #
        if SysMgr.cmdEnable:
            if not SysMgr.cmdFd:
                try:
                    SysMgr.cmdFd = open(SysMgr.cmdEnable, perm)
                    SysMgr.cmdFd.write(
                        'mount -t debugfs nodev %s 2>%s\n' % \
                        (SysMgr.debugfsPath, SysMgr.nullPath))
                    SysMgr.cmdFd.write(
                        'echo "\nstart recording... [ STOP(Ctrl+c) ]\n"\n')
                except SystemExit:
                    sys.exit(0)
                except:
                    SysMgr.printOpenErr(SysMgr.cmdEnable)
                    return -1

            if SysMgr.cmdFd:
                try:
                    cmd = 'echo "%s" > %s%s 2>%s\n' % \
                        (str(val), SysMgr.mountPath, path, SysMgr.nullPath)
                    SysMgr.cmdFd.write(cmd)
                except SystemExit:
                    sys.exit(0)
                except:
                    SysMgr.printErr("fail to write command")
                    return -1

        # open for applying command #
        try:
            fd = None
            target = '%s%s' % (SysMgr.mountPath, path)

            if append:
                if target in SysMgr.cmdAttachCache:
                    fd = SysMgr.cmdAttachCache[target]
                    os.lseek(fd, 0, 0)
                else:
                    fd = os.open(target, os.O_RDWR|os.O_CREAT|os.O_APPEND)
                    SysMgr.cmdAttachCache[target] = fd
            else:
                try:
                    fd = SysMgr.cmdFileCache[target]
                    fd.seek(0)
                except:
                    pass

                if not fd:
                    fd = open(target, perm)
                    SysMgr.cmdFileCache[target] = fd
        except SystemExit:
            sys.exit(0)
        except:
            fpos = path.rfind('/')
            try:
                if path[fpos+1:] == 'enable':
                    epath = path[:fpos]
                else:
                    epath = path[fpos+1:]
            except:
                epath = path

            try:
                SysMgr.sysInstance.cmdList[epath] = False
            except:
                pass

            SysMgr.printWarn(
                "fail to use %s event" % epath, reason=True)
            return -1

        # apply command #
        try:
            if append:
                os.write(fd, bytes(UtilMgr.encodeStr(val)))
                os.fsync(fd)
            else:
                fd.write(val)
                fd.flush()

            # modify flags in command list #
            if path.endswith('/enable'):
                if val == '1':
                    SysMgr.sysInstance.\
                        cmdList[path[:path.rfind('/enable')]] = True
                elif val == '0':
                    SysMgr.sysInstance.\
                        cmdList[path[:path.rfind('/enable')]] = False
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.cmdFileCache.pop(target, None)
            SysMgr.printWarn(
                "fail to apply command '%s' to %s" % \
                    (val, path), reason=True)
            return -2

        return 0



    @staticmethod
    def doPrint(newline=True, clear=False, flush=True, addLine=False):
        if not SysMgr.bufferString:
            return

        if addLine:
            output = '%s\n' % SysMgr.bufferString
        else:
            output = SysMgr.bufferString

        SysMgr.printPipe(output, newline=newline, flush=flush)

        if clear:
            SysMgr.clearPrint()



    @staticmethod
    def printConsole(string):
        # split and cut lines by cols #
        string = '\n'.join(
            [nline[:SysMgr.ttyCols-1] for nline in string.split('\n')])

        # print on console #
        print(string.rstrip())



    @staticmethod
    def addPrint(string, newline=1, force=False, listBuf=False):
        if not force and SysMgr.checkCutCond(newline):
            return False

        # add string to buffer #
        if listBuf:
            SysMgr.bufferList.append(string)
        else:
            SysMgr.bufferString = \
                "%s%s" % (SysMgr.bufferString, string)

        SysMgr.bufferRows += newline

        if SysMgr.terminalOver or \
            not SysMgr.outPath or \
            not SysMgr.printStreamEnable:
            return True

        SysMgr.printConsole(string)

        return True



    @staticmethod
    def getPrintList(retStr=False, sort=False):
        if sort:
            SysMgr.bufferList.sort()

        if retStr:
            return '\n'.join(SysMgr.bufferList)
        else:
            return SysMgr.bufferList



    @staticmethod
    def delPrint(newline=1):
        try:
            target = SysMgr.bufferString
            start = target.rfind('\n')
            pos = newline

            while start >= 0 and pos > 1:
                start = target.rfind('\n', start - 1)
                pos -= 1

            SysMgr.bufferString = target[:start + 1]
            SysMgr.bufferRows -= newline
        except:
            pass



    @staticmethod
    def clearPrint():
        del SysMgr.bufferString
        SysMgr.bufferString = ''
        SysMgr.bufferRows = long(0)
        SysMgr.terminalOver = False



    @staticmethod
    def clearScreen():
        # check stdout status #
        if not SysMgr.printEnable or \
            SysMgr.pipeForPager:
            return

        if SysMgr.isLinux and \
            not 'REMOTERUN' in os.environ:
            sys.stdout.write("\x1b[2J\x1b[H")
        elif sys.platform.startswith('win'):
            os.system('cls')
        else:
            pass



    @staticmethod
    def printLogo(absolute=False, big=False, onlyFile=False, pager=True):
        if not SysMgr.logoEnable:
            return

        # check package #
        if not "ISMAIN" in os.environ:
            print("\nPowered by %s" % ConfigMgr.logo)
            return

        # check print option and remote runner #
        if not SysMgr.printEnable or SysMgr.remoteRun:
            return

        # check extended ascii support #
        SysMgr.convertExtAscii(ConfigMgr.logo)

        if not SysMgr.outPath:
            if SysMgr.printStreamEnable:
                if not absolute:
                    return
            elif onlyFile:
                return

        # print logo #
        if big:
            if pager:
                SysMgr.printPipe(ConfigMgr.logo)
            else:
                print(ConfigMgr.logo)
        else:
            title = "/ G.u.i.d.e.r \tver.%s /" % __version__
            underline = '_' * (len(title))
            overline = '-' * (len(title))
            SysMgr.printPipe(
                ' %s\n%s\n%s' % (underline, title, overline))



    @staticmethod
    def printInfoBuffer():
        SysMgr.printPipe(SysMgr.systemInfoBuffer+'\n')
        SysMgr.clearInfoBuffer()



    @staticmethod
    def parseCustomRecordCmd(cmdList):
        tempList = {'BEFORE': [], 'AFTER': [], 'STOP': []}

        if not cmdList:
            return {}

        cmdList = cmdList.split(',')

        for item in cmdList:
            sitem = item.split(':')
            ltime = sitem[0]

            if len(sitem) < 2 or len(sitem) > 3 or \
                (ltime != 'BEFORE' and ltime != 'AFTER' and ltime != 'STOP'):
                SysMgr.printErr(
                    "wrong format used, BEFORE|AFTER|STOP:file:value")
                sys.exit(0)
            elif len(sitem) == 2:
                tempList[ltime].append([sitem[1]])
            elif len(sitem) == 3:
                tempList[ltime].append([sitem[1], sitem[2]])

        return tempList



    @staticmethod
    def getOverlayfsInfo(pid):
        data = SysMgr.getMountData(pid)
        mountList = SysMgr.convMountList(data)
        if not mountList:
            return {}

        overlayList = {}
        for point, info in mountList.items():
            try:
                if info['fs'] != 'overlay':
                    continue

                overlayList[point] = {}
                items = info['subopt'].split(',')
                for line in items:
                    if line.startswith('lowerdir'):
                        attr = 'lowerdir'
                    elif line.startswith('upperdir'):
                        attr = 'upperdir'
                    elif line.startswith('mergedir'):
                        continue
                    else:
                        continue

                    dirs = line.lstrip(attr)[1:].split(':')
                    overlayList[point][attr] = dirs
            except SystemExit:
                sys.exit(0)
            except:
                continue

        return overlayList



    @staticmethod
    def convMountList(mountInfo):
        if not mountInfo:
            return {}

        mountList = {}
        for l in mountInfo:
            # split mount info #
            values = l.split(' - ')
            if len(values) != 2:
                continue
            left = values[0]
            right = values[1]

            # split left-side part #
            left = left.split()
            mountid, parentid, devid, root, path = left[:5]
            major, minor = devid.split(':')
            option = ' '.join(left[5:-1])

            # split right-side part #
            right = right.split()
            fs, dev = right[0:2]
            soption = ' '.join(right[2:])

            if ':' in dev:
                major, minor = dev.split(':')
            else:
                major = minor = -1

            # save mount info #
            mountList[path] = {
                'major': major,
                'minor': minor,
                'mountid': mountid,
                'fs': fs,
                'opt': option,
                'subopt': soption,
            }

        return mountList



    @staticmethod
    def getMountInfo():
        # check whether there is mount info in saved buffer #
        infoBuf = SysMgr.systemInfoBuffer

        if infoBuf == '':
            return

        mountPosStart = infoBuf.find('Storage Info')
        if mountPosStart == -1:
            return

        mountPosStart = infoBuf.find(twoLine, mountPosStart+1)
        if mountPosStart == -1:
            return

        mountPosStart = infoBuf.find(twoLine, mountPosStart+1)
        if mountPosStart == -1:
            return

        mountPosStart = infoBuf.find('\n', mountPosStart)
        if mountPosStart == -1:
            return

        mountPosEnd = infoBuf.find(oneLine, mountPosStart)
        if mountPosEnd == -1:
            return

        try:
            mountTable = []
            tempTable = infoBuf[mountPosStart:mountPosEnd].split('\n')
            for idx, line in enumerate(tempTable):
                nrItem = len(line.split())
                if 1 < nrItem < 4:
                    mountTable.append('%s %s' % (line, tempTable[idx+1]))
        except:
            pass

        init_mountData = {'dev': ' ', 'filesystem': ' ', 'mount': ' '}

        for item in mountTable:
            m = re.match((
                r'(?P<dev>\S+)\s+\((?P<devt>\S+)\)\s+\[(?P<range>\S+)\]\s+'
                r'(?P<maj>[0-9]+):(?P<min>[0-9]+)\s+(?P<readSize>\S+)\s+'
                r'(?P<writeSize>\S+)\s+(?P<totalSize>\S+)\s+'
                r'(?P<freeSize>\S+)\s+(?P<Usage>\S+)\s+(?P<nrFile>\S+)\s+'
                r'(?P<filesystem>\S+)\s+(?P<mount>.+)'), item)
            if not m:
                continue

            d = m.groupdict()
            mid = '%s:%s' % (d['maj'], d['min'])
            SysMgr.savedMountTree[mid] = dict(init_mountData)
            SysMgr.savedMountTree[mid]['dev'] = d['dev']
            SysMgr.savedMountTree[mid]['filesystem'] = d['filesystem']
            SysMgr.savedMountTree[mid]['mount'] = d['mount']

            # add block range info #
            try:
                start, end = d['range'].split('-')
                SysMgr.savedMountTree[mid]['start'] = long(start)
                SysMgr.savedMountTree[mid]['end'] = long(end)
            except:
                pass



    @staticmethod
    def getProcTreeInfo():
        # check whether there is procTreeInfo in saved buffer #
        infoBuf = SysMgr.systemInfoBuffer

        if infoBuf == '':
            return

        magic = '!!!!!'

        # get tree pos #
        treePos = infoBuf.find(magic)
        if treePos == -1:
            return

        newPos = treePos + len(magic)

        # get comm pos #
        commPos = infoBuf[newPos:].find(magic)

        # check whether there is procTreeInfo in saved buffer #
        if commPos < 0:
            procTree = infoBuf[newPos:]
            procTree = procTree[:procTree.find('\n')].split(',')
        else:
            procTree = infoBuf[newPos:newPos+commPos].split(',')

        # parse task tree #
        for pair in procTree:
            try:
                ids = pair.split(':')
                tid = ids[0]
                pid = ids[1]

                # get pid and comm #
                if not pid.isdigit():
                    group = pid
                    pidPos = group.find('(')
                    pid = group[:pidPos]
                    comm = group[pidPos+1:-1]
                    SysMgr.savedProcComm[pid] = comm

                SysMgr.savedProcTree[tid] = pid
            except:
                continue

        # remove task tree info #
        if commPos < 0:
            SysMgr.systemInfoBuffer = infoBuf[:treePos]
        else:
            commData = infoBuf[newPos+commPos+len(magic):]
            commData = commData[:commData.find('\n')]
            SysMgr.commCache = UtilMgr.convStr2Dict(commData)
            SysMgr.systemInfoBuffer = infoBuf[:newPos-len(magic)]



    @staticmethod
    def applyLaunchOption():
        # check whether there is launch option in saved buffer #
        infoBuf = SysMgr.systemInfoBuffer

        # get position of launch option #
        if infoBuf == '':
            return

        launchPosStart = infoBuf.find('Launch')
        if launchPosStart == -1:
            return

        launchPosEnd = infoBuf.find('\n', launchPosStart)
        if launchPosEnd == -1:
            return

        SysMgr.launchBuffer = infoBuf[launchPosStart:launchPosEnd]

        # check version #
        try:
            verPosStart = infoBuf.find('Version')
            verPosEnd = infoBuf.find('\n', verPosStart)
            recVer = infoBuf[verPosStart:verPosEnd].split()[1]
            if recVer != __version__:
                SysMgr.printWarn(
                    "data version %s is different from current software %s" % \
                    (__version__, recVer), True)
        except:
            pass

        # apply arch type #
        if not SysMgr.archOption:
            try:
                archPosStart = infoBuf.find('Arch')
                archPosEnd = infoBuf.find('\n', archPosStart)
                arch = infoBuf[archPosStart:archPosEnd].split()[1]
                SysMgr.setArch(arch)
            except:
                pass

        # add anlaysis option #
        archPosStart = infoBuf.find('Arch')
        archPosEnd = infoBuf.find('\n', archPosStart)
        if archPosStart >= 0 and archPosEnd >= 0:
            analOption = "{0:20} {1:<100}".format(
                'Analysis', '# %s' % (' '.join(sys.argv)))
            SysMgr.systemInfoBuffer = '%s\n%s\n%s' % \
                (infoBuf[:archPosEnd], analOption, infoBuf[archPosEnd+1:])

        # apply mode option #
        if SysMgr.isDrawMode():
            SysMgr.printInfo("<DRAW MODE>")

        if ' funcrec ' in SysMgr.launchBuffer or \
            ' funcrecord ' in SysMgr.launchBuffer:
            SysMgr.threadEnable = False
            SysMgr.functionEnable = True
            if not SysMgr.isDrawMode():
                SysMgr.printInfo("<FUNCTION MODE>")
        else:
            SysMgr.threadEnable = True
            if not SysMgr.isDrawMode():
                SysMgr.printInfo("<THREAD MODE>")

        # apply filter option #
        filterList = None
        launchPosStart = SysMgr.launchBuffer.find(' -g')
        if SysMgr.isThreadMode() and launchPosStart > -1:
            filterList = SysMgr.launchBuffer[launchPosStart + 3:]
            filterList = filterList[:filterList.find(' -')].strip()
            SysMgr.filterGroup = filterList.split(',')
            SysMgr.filterGroup = \
                UtilMgr.cleanItem(SysMgr.filterGroup)
            SysMgr.printInfo(
                "only specific threads [ %s ] were recorded" % \
                ', '.join(SysMgr.filterGroup))

        # check filter list #
        if SysMgr.filterGroup:
            if not SysMgr.groupProcEnable:
                SysMgr.printInfo(
                    "only specific threads [ %s ] are shown" % \
                    ', '.join(SysMgr.filterGroup))
            else:
                SysMgr.printInfo((
                    "only specific threads that involved "
                    "in the process group [ %s ] are shown") % \
                    ', '.join(SysMgr.filterGroup))

        # apply dependency option #
        if ' -D' in SysMgr.launchBuffer:
            SysMgr.depEnable = True

        # apply syscall option #
        if ' -t' in SysMgr.launchBuffer:
            SysMgr.sysEnable = True

        # apply disable option #
        launchPosStart = SysMgr.launchBuffer.find(' -d')
        if launchPosStart > -1:
            filterList = SysMgr.launchBuffer[launchPosStart + 3:]
            filterList = filterList[:filterList.find(' -')]
            if 'u' in filterList:
                SysMgr.userEnable = False
                SysMgr.userRecordEnable = False
            if 'a' in filterList:
                SysMgr.disableAll = True
            if 'c' in filterList:
                SysMgr.cpuEnable = False
                SysMgr.latEnable = False
            if 'l' in filterList:
                SysMgr.latEnable = False

        # apply enable option #
        launchPosStart = SysMgr.launchBuffer.find(' -e')
        if launchPosStart > -1:
            filterList = SysMgr.launchBuffer[launchPosStart + 3:]
            filterList = filterList[:filterList.find(' -')]
            if 'm' in filterList:
                SysMgr.memEnable = True
            if 'b' in filterList:
                SysMgr.blockEnable = True
            if 'P' in filterList:
                SysMgr.powerEnable = True
            if 'w' in filterList:
                SysMgr.wqEnable = True
            if 'B' in filterList:
                SysMgr.binderEnable = True
            if 'I' in filterList:
                SysMgr.i2cEnable = True
            if 'h' in filterList:
                SysMgr.heapEnable = True
            if 'L' in filterList:
                SysMgr.lockEnable = True
            if 'i' in filterList:
                SysMgr.irqEnable = True
            if 'n' in filterList:
                SysMgr.networkEnable = True

            # memory type #
            if 'S' in filterList:
                SysMgr.pssEnable = True
            elif 'u' in filterList:
                SysMgr.ussEnable = True
            elif not SysMgr.isDrawMode():
                SysMgr.rssEnable = True
        elif not SysMgr.isDrawMode():
            SysMgr.rssEnable = True

        # apply custom option #
        launchPosStart = SysMgr.launchBuffer.find(' -c')
        if launchPosStart > -1:
            filterList = SysMgr.launchBuffer[launchPosStart + 3:]
            endIdx = filterList.find(' -')
            if endIdx >= 0:
                filterList = filterList[:endIdx]
            filterList = filterList.strip().split(',')
            for idx, item in enumerate(filterList):
                tempItem = filterList[idx].split('/')
                if len(tempItem) == 2:
                    filterList[idx] = tempItem[1]
                    SysMgr.customEventList.append(tempItem[1])
                elif len(tempItem) == 1:
                    filterList[idx] = tempItem[0]
                    SysMgr.customEventList.append(tempItem[0])
                else:
                    filterList.pop(idx)
            if len(filterList) > 0:
                SysMgr.printInfo(
                    "profiled custom events [ %s ]" % ', '.join(filterList))
                if not SysMgr.customCmd:
                    SysMgr.customCmd = filterList

        # apply user event option #
        launchPosStart = SysMgr.launchBuffer.find(' -U')
        if launchPosStart > -1:
            SysMgr.ueventEnable = True
            filterList = SysMgr.launchBuffer[launchPosStart + 3:]
            filterList = filterList[:filterList.find(' -')].strip()
            SysMgr.userCmd = str(filterList).split(',')
            SysMgr.userCmd = \
                UtilMgr.cleanItem(SysMgr.userCmd)
            SysMgr.printInfo("profiled user events [ %s ]" % \
                ', '.join([ cmd.strip() for cmd in SysMgr.userCmd]))
            SysMgr.userEventList = \
                [ cmd.split(':')[0].strip() for cmd in SysMgr.userCmd]

        # apply kernel event option #
        launchPosStart = SysMgr.launchBuffer.find(' -K')
        if launchPosStart > -1:
            SysMgr.keventEnable = True
            filterList = SysMgr.launchBuffer[launchPosStart + 3:]
            filterList = filterList[:filterList.find(' -')].strip()
            SysMgr.kernelCmd = str(filterList).split(',')
            SysMgr.kernelCmd = \
                UtilMgr.cleanItem(SysMgr.kernelCmd)
            SysMgr.printInfo("profiled kernel events [ %s ]" % \
                ', '.join([ cmd.strip() for cmd in SysMgr.kernelCmd]))
            SysMgr.kernelEventList = \
                [ cmd.split(':')[0].strip() for cmd in SysMgr.kernelCmd]

        # apply arch option #
        launchPosStart = SysMgr.launchBuffer.find(' -A')
        if launchPosStart > -1:
            filterList = SysMgr.launchBuffer[launchPosStart + 3:]
            filterList = filterList[:filterList.find(' -')].strip()

            if SysMgr.arch != filterList:
                SysMgr.printErr((
                    "arch(%s) of recorded target is different with "
                    "current arch(%s), use -A option with %s") % \
                    (filterList, SysMgr.arch, filterList))
                sys.exit(0)



    @staticmethod
    def writeEvent(message, show=True):
        if not SysMgr.eventLogFd:
            if not SysMgr.eventLogPath:
                SysMgr.eventLogPath = \
                    '%s%s' % (SysMgr.mountPath, '../trace_marker')

            try:
                SysMgr.eventLogFd = \
                    open(SysMgr.eventLogPath, 'w')
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printOpenWarn(
                    "fail to open %s" % SysMgr.eventLogPath)
                return

        if SysMgr.eventLogFd:
            try:
                SysMgr.eventLogFd.write(message)
                event = message[message.find('_')+1:]
                if show:
                    SysMgr.printInfo('wrote %s event' % event)

                try:
                    SysMgr.eventLogFd.flush()
                except:
                    pass

                return True
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printWarn(
                    "fail to write %s event" % (message), reason=True)
                return
        else:
            SysMgr.printErr(
                "fail to write %s event because of no file\n" % message)



    @staticmethod
    def infoBufferPrint(line):
        SysMgr.systemInfoBuffer = \
            '%s%s\n' % (SysMgr.systemInfoBuffer, line)



    @staticmethod
    def clearInfoBuffer():
        SysMgr.systemInfoBuffer = ''



    @staticmethod
    def printPipWarn(name, pkg):
        SysMgr.printWarn((
            "fail to import python package: %s, "
            "try to enter 'pip%s install %s'") % \
                (name, sys.version_info[0], pkg), True)



    @staticmethod
    def drawTimeline(
        inputPath=None, inputData=None, outputPath=None,
        configPath=None, configData=None, taskList=None):

        def _addUserEvent(inputData):
            if not inputData or \
                not 'EVENT' in SysMgr.environList:
                return

            for item in SysMgr.environList['EVENT']:
                try:
                    values = item.split(':')
                    if not (3 <= len(values) <= 5):
                        SysMgr.printErr((
                            'fail to recognize %s in '
                            'X:Y:NAME:[CPU|MEM|IO]:[BOX|CIRCLE|LARROW|RARROW]'
                            'format') % item)
                        sys.exit(0)

                    x, y, name = values[:3]

                    # add timeline data #
                    inputData['segments'].append({
                        'group': long(y),
                        'text': name,
                        'id': None,
                        'state': 'EVENT_USER',
                        'time_start': float(x),
                        'time_end': float(x)+0.000001,
                    })

                except SystemExit:
                    sys.exit(0)
                except:
                    SysMgr.printErr(
                        'fail to recognize event for timeline', reason=True)
                    sys.exit(0)



        # get svgwrite object #
        svgwrite = SysMgr.getPkg('svgwrite')

        if inputPath:
            inputStr = ' from "%s"' % inputPath
        else:
            inputStr = ''

        SysMgr.printInfo(
            "start drawing timeline%s..." % inputStr)

        try:
            dwg = svgwrite.Drawing(outputPath, profile='tiny', debug=True)

            config = Timeline.Config()
            if configPath or configData:
                config = Timeline.Config._load(configPath, configData)

            # check timeunit #
            if 'TIMEUNIT' in SysMgr.environList:
                config.TIMEUNIT = SysMgr.environList['TIMEUNIT'][0].lower()
            else:
                config.TIMEUNIT = 'ms'

            # apply user event #
            _addUserEvent(inputData)

            # load data #
            timeline = Timeline.load(inputPath, inputData, config, taskList)

            # draw timeslices #
            timeline.draw(dwg)

            dwg.save()
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printErr(
                'fail to draw timeline', reason=True)
            return

        # get output size #
        fsize = UtilMgr.getFileSize(outputPath)
        if fsize and fsize != '0':
            fsize = ' [%s]' % fsize
        else:
            fsize = ''

        SysMgr.printStat(
            "wrote timeline chart into '%s'%s" %
                (outputPath, fsize))



    @staticmethod
    def drawText(lines):
        imageType = None

        # get textwrap object #
        textwrap = SysMgr.getPkg('textwrap', False)
        if not textwrap:
            SysMgr.printPipWarn('textwrap', 'textwrap3')
            sys.exit(0)

        # get PIL object #
        PIL = SysMgr.getPkg('PIL', False)
        if not PIL:
            SysMgr.printPipWarn('PIL', 'pillow')
            sys.exit(0)

        from PIL import Image, ImageFont, ImageDraw

        # load jpeg plugin #
        try:
            if not imageType:
                from PIL import JpegImagePlugin
                imageType = 'jpg'
        except ImportError:
            err = sys.exc_info()[1]
            SysMgr.printWarn(
                "fail to import python package: %s" % err.args[0])

        # load bmp plugin instead of jpeg #
        try:
            if not imageType:
                from PIL import BmpImagePlugin
                imageType = 'bmp'
        except ImportError:
            err = sys.exc_info()[1]
            SysMgr.printErr(
                "fail to import python package: %s" % err.args[0])
            return

        if not SysMgr.imagePath:
            SysMgr.printErr("fail to load image path")
            return

        # set image file extension #
        SysMgr.imagePath += '.%s' % imageType

        if SysMgr.fontPath:
            try:
                # load specific font #
                imageFont = ImageFont.truetype(SysMgr.fontPath, 10)
            except:
                SysMgr.printErr(
                    "fail to load font from %s" % SysMgr.fontPath)
                return
        else:
            try:
                # load default font #
                imageFont = ImageFont.load_default().font
            except:
                SysMgr.printErr((
                    "fail to load default font because %s, "
                    "try to use -T option") % SysMgr.getErrMsg())
                return

        # get default font size and image length #
        text = textwrap.fill('A', width=150)
        fontSizeX, fontSizeY = imageFont.getsize(text)

        # check input parameter #
        if type(lines) is list:
            lines = ''.join(lines)

        # convert string to list #
        lines = lines.split('\n')

        # calculate image size #
        imageSizeX = fontSizeX * SysMgr.lineLength
        imageSizeY = fontSizeY * len(lines) + (fontSizeY * 2)
        imagePosY = 1

        # make new blink image #
        if imageType == 'jpg':
            imageObject = \
                Image.new("RGB", (imageSizeX, imageSizeY), (255, 255, 255))
        elif imageType == 'bmp':
            imageObject = \
                Image.new("RGB", (900, imageSizeY), (255, 255, 255))
        else:
            SysMgr.printErr("no output image type")
            return

        # make palette #
        drawnImage = ImageDraw.Draw(imageObject)

        for line in lines:
            text = textwrap.fill(line, width=170)

            imagePosY += fontSizeY

            # write text on image #
            drawnImage.text((1, imagePosY), text, (0,0,0), font=imageFont)

        try:
            # save image as file #
            imageObject.save(SysMgr.imagePath)
        except:
            SysMgr.printErr(
                "fail to save image as %s\n" % SysMgr.imagePath)
            return

        # get output size #
        fsize = UtilMgr.getFileSize(SysMgr.imagePath)
        if fsize and fsize != '0':
            fsize = ' [%s]' % fsize
        else:
            fsize = ''

        SysMgr.printStat(
            "saved image into %s%s successfully" % \
                (SysMgr.imagePath, fsize))



    @staticmethod
    def addProcBuffer(data):
        SysMgr.procBuffer.insert(0, data)
        SysMgr.procBufferSize += len(data)

        bufferSize = SysMgr.bufferSize

        while SysMgr.procBufferSize > bufferSize > 0:
            # flush all data in buffer to the file #
            if not SysMgr.bufferLossEnable:
                SysMgr.printInfo((
                    "start writing interval statistics because "
                    "buffer (%s) exceed %s") %
                        (UtilMgr.convSize2Unit(SysMgr.procBufferSize),
                        UtilMgr.convSize2Unit(SysMgr.bufferSize)))

                # create a new process #
                pid = SysMgr.createProcess(isDaemon=True, chPgid=True)
                # save output to file as child #
                if pid == 0:
                    try:
                        SysMgr.printFd.close()
                    except:
                        pass
                    finally:
                        SysMgr.printFd = None

                    # append uptime to the output file #
                    SysMgr.fileSuffix = long(SysMgr.getUptime())

                    # flush all data to the file #
                    SysMgr.newHandler()

                    sys.exit(0)
                # clear buffer as parent #
                elif pid > 0:
                    SysMgr.procBufferSize = 0
                    SysMgr.procBuffer = []
                    break
                # pop old data in buffer because of fork failure #
                else:
                    pass

            # pop old data in buffer #
            if not SysMgr.bufferOverflowed:
                SysMgr.printWarn((
                    "new data is going to be overwritten to the buffer"
                    " because of buffer overflow\n"
                    "\tincrease buffer size (%s) "
                    "if you want to prevent data loss") % \
                        UtilMgr.convSize2Unit(SysMgr.bufferSize), True)
                SysMgr.bufferOverflowed = True

            if not SysMgr.procBuffer:
                break

            SysMgr.procBufferSize -= len(SysMgr.procBuffer[-1])
            SysMgr.procBuffer.pop(-1)



    @staticmethod
    def updateSession():
        if not SysMgr.addrListForPrint:
            return

        addrListForPrint = dict(SysMgr.addrListForPrint)
        for addr, cli in addrListForPrint.items():
            if cli.status == 'SENT' and cli.ignore > 1:
                SysMgr.printInfo(
                    "unregistered %s:%d for PRINT" % (cli.ip, cli.port))
                del SysMgr.addrListForPrint[addr]



    @staticmethod
    def printTopStats():
        # JSON mode #
        if SysMgr.jsonEnable:
            # convert dict data to JSON-type string #
            jsonObj = UtilMgr.convDict2Str(SysMgr.jsonData, pretty=False)
            if not jsonObj:
                SysMgr.printWarn(
                    "fail to convert report data to JSON type")
            else:
                SysMgr.printPipe(jsonObj)
        # realtime mode #
        elif not SysMgr.outPath:
            if not SysMgr.printStreamEnable:
                SysMgr.clearScreen()
            SysMgr.doPrint()
        # pipe mode #
        elif SysMgr.pipeEnable:
            SysMgr.doPrint(addLine=True)
        # buffered mode #
        else:
            SysMgr.addProcBuffer(SysMgr.bufferString+'\n')

        # flush buffer #
        SysMgr.clearPrint()



    @staticmethod
    def checkCutCond(newline=0):
        if SysMgr.terminalOver:
            return True
        elif not SysMgr.outPath and \
            not SysMgr.jsonEnable and \
            not SysMgr.printStreamEnable and \
            SysMgr.bufferRows + newline >= \
                SysMgr.ttyRows - SysMgr.ttyRowsMargin:
            SysMgr.terminalOver = True
            SysMgr.addPrint('---more---', force=True)
            return True
        else:
            return False



    @staticmethod
    def updateTimer(interval=None):
        if not SysMgr.isLinux:
            return

        if interval:
            signal.alarm(long(interval))
        else:
            signal.alarm(SysMgr.intervalEnable)



    @staticmethod
    def updateOutPath():
        # dir #
        if os.path.isdir(SysMgr.outPath):
            SysMgr.inputFile = \
                os.path.join(SysMgr.outPath, SysMgr.outFilePath)
        # file #
        else:
            SysMgr.inputFile = SysMgr.outPath

        # append suffix to output file #
        if SysMgr.fileSuffix:
            dirname = os.path.dirname(SysMgr.inputFile)
            filename = os.path.basename(SysMgr.inputFile)
            name, ext = os.path.splitext(filename)
            filepath = os.path.join(dirname, name)
            SysMgr.inputFile = '%s_%s%s' % \
                (filepath, SysMgr.fileSuffix, ext)

        # append uptime to the output file #
        if not SysMgr.termFlag:
            SysMgr.inputFile = '%s_%s' % \
                (SysMgr.inputFile, SysMgr.getRuntime())



    @staticmethod
    def printPipe(line='', newline=True, flush=False, pager=True):
        # check logging option #
        if SysMgr.loggingEnable:
            if SysMgr.dltEnable:
                DltAnalyzer.doLogDlt(msg=line)
            if SysMgr.kmsgEnable:
                LogMgr.doLogKmsg(msg=line)
            if SysMgr.syslogEnable:
                LogMgr.doLogSyslog(msg=line)
            if SysMgr.journalEnable:
                LogMgr.doLogJournal(msg=line)

        # socket output #
        if SysMgr.addrListForPrint and line:
            addrListForPrint = dict(SysMgr.addrListForPrint)
            for addr, cli in addrListForPrint.items():
                udpSeg = 65507 # maxium UDP diagram size
                start = 0
                end = udpSeg
                while 1:
                    # split by newline #
                    if len(line) >= end:
                        pos = line[start:end].rfind('\n')
                        if pos > 0:
                            end = pos + start

                    # send data #
                    ret = cli.send(line[start:end])
                    if not ret:
                        del SysMgr.addrListForPrint[addr]
                        break
                    else:
                        cli.ignore += 1

                    if end >= len(line):
                        break

                    # update sending part #
                    start = end
                    end += udpSeg

        # check print flag #
        if not SysMgr.printEnable:
            return

        # convert list to string #
        if type(line) is list:
            if not line:
                line = ''
            elif line[0][-1] == '\n':
                line = ''.join(line)
            else:
                line = '\n'.join(line)

        # pager initialization #
        if not pager or SysMgr.pipeForPager or \
            SysMgr.outPath or SysMgr.printStreamEnable:
            pass
        elif not SysMgr.isTopMode() or SysMgr.isHelpMode():
            try:
                if SysMgr.isLinux:
                    if UtilMgr.which('less'):
                        #defopt = '-FRSXMQi'
                        defopt = '-FRXMQi'

                        # verify pager option support #
                        ret = os.popen(
                            'echo | less %s 2>&1' % defopt, 'r').read()
                        if len(ret) <= 1:
                            poption = 'less %s' % defopt
                        else:
                            poption = 'less'

                        # run less as pager #
                        SysMgr.pipeForPager = os.popen(poption, 'w')
                    elif UtilMgr.which('more'):
                        SysMgr.pipeForPager = os.popen('more', 'w')
                elif sys.platform.startswith('win'):
                    if UtilMgr.which('more'):
                        SysMgr.pipeForPager = os.popen('more', 'w')
                else:
                    # no supported OS #
                    SysMgr.pipeForPager = None

                SysMgr.encodeEnable = False

                SysMgr.setPipeHandler()
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printWarn(
                    "fail to use pager", True, reason=True)

        # pager output #
        if SysMgr.pipeForPager:
            try:
                if line:
                    SysMgr.pipeForPager.write(line)

                    if newline and line[-1] != '\n':
                        SysMgr.pipeForPager.write('\n')

                return
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printErr(
                    "fail to print to pager\n", True)
                SysMgr.pipeForPager = None

        # file initialization #
        if SysMgr.outPath and not SysMgr.printFd:
            # profile #
            if SysMgr.isRuntimeMode():
                SysMgr.updateOutPath()
            # analysis #
            else:
                # dir #
                if os.path.isdir(SysMgr.outPath):
                    name, ext = os.path.splitext(
                        os.path.basename(SysMgr.inputFile))
                    if ext == '' or ext == '.dat':
                        name = '%s.out' % name
                    if name.endswith('.dat'):
                        name = name.replace('.dat', '.out')
                    SysMgr.inputFile = \
                        os.path.join(SysMgr.outPath, name)
                # file #
                else:
                    SysMgr.inputFile = SysMgr.outPath

            # convert abnormal characters from full path #
            SysMgr.inputFile = \
                os.path.normpath(SysMgr.inputFile)

            # apply filename extension for compression #
            if SysMgr.compressEnable:
                SysMgr.inputFile += '.gz'
                if SysMgr.outPath:
                    SysMgr.outPath += '.gz'

            # backup an exist file #
            SysMgr.backupFile(SysMgr.inputFile)

            # open file #
            try:
                # open output file #
                SysMgr.printFd = open(SysMgr.inputFile, 'wb')

                # apply compression to the file #
                if SysMgr.compressEnable:
                    compressor = SysMgr.getPkg('gzip', False)
                    if compressor:
                        SysMgr.printFd = compressor.GzipFile(
                            fileobj=SysMgr.printFd)

                # print file name #
                if SysMgr.outPath:
                    SysMgr.printInfo(
                        "start writing statistics to '%s'" % \
                            SysMgr.inputFile)
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printOpenErr(SysMgr.inputFile)
                sys.exit(0)

        # file output #
        if SysMgr.printFd:
            try:
                if line:
                    SysMgr.printFd.write(line.encode('utf-8'))

                    if newline and line[-1] != '\n':
                        SysMgr.printFd.write('\n'.encode('utf-8'))

                if flush:
                    SysMgr.printFd.flush()
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printErr(
                    "fail to write to %s" % SysMgr.printFd.name, True)
        # console output #
        else:
            cols = SysMgr.ttyCols

            # rstrip by terminal size #
            try:
                # no limit #
                if cols == 0 or SysMgr.jsonEnable:
                    line = '\n'.join([nline for nline in line.split('\n')])
                # rstrip for colorful lines #
                elif SysMgr.colorEnable and ConfigMgr.ENDC in line:
                    ansi = r'(?:\x1B[@-_]|[\x80-\x9F])[0-?]*[ -/]*[@-~]'
                    ansiObj = re.compile(ansi)
                    line = '\n'.join(
                        [ansiObj.sub('', n)[:cols] \
                            if len(ansiObj.sub('', n)) > cols else n \
                            for n in line.split('\n')])
                # rstrip for normal lines #
                else:
                    line = '\n'.join(
                        [nline[:cols-1] for nline in line.split('\n')])
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printWarn("fail to print to console", reason=True)
                return

            # convert to extended ascii #
            nline = SysMgr.convertExtAscii(line)

            # print string to console #
            try:
                sys.stdout.write(nline)
            except SystemExit:
                sys.exit(0)
            except:
                if SysMgr.encodeEnable:
                    SysMgr.encodeEnable = False

                    sys.stdout.write(line)

            if newline:
                sys.stdout.write('\n')

            # flush buffer #
            if flush or SysMgr.remoteRun:
                sys.stdout.flush()



    @staticmethod
    def convertExtAscii(line):
        # pylint: disable=no-member
        # pylint: disable=undefined-variable
        if not SysMgr.encodeEnable:
            return line

        try:
            newline = line.replace('-------', '───────')
            newline = newline.replace('=', '═')
            newline = newline.replace('|-', '├─')
            newline = newline.replace('|', '│')

            if sys.version_info < (3, 0) and not SysMgr.encoding:
                if not sys.getdefaultencoding().lower().startswith('utf'):
                    try:
                        reload(sys)
                        sys.setdefaultencoding('utf-8')
                        SysMgr.encoding = sys.getdefaultencoding()
                    except:
                        pass

            return newline
        except:
            SysMgr.encodeEnable = False
            return line



    @staticmethod
    def printWarn(line, always=False, reason=False):
        # print backtrace #
        #SysMgr.printBacktrace()

        if not SysMgr.logEnable or \
            (not SysMgr.warnEnable and not always):
            return

        if reason:
            rstring = ' because %s' % SysMgr.getErrMsg()
        else:
            rstring = ''

        # apply color #
        if SysMgr.colorEnable:
            color = ConfigMgr.WARNING
            colorl = ConfigMgr.ENDC
        else:
            color = colorl = ''

        proc = SysMgr.getProcInfo()

        log = ('\n%s%s%s%s%s%s\n' % \
            (color, '[WARN] ', proc, line, rstring, colorl))

        # write log #
        if SysMgr.stdlog:
            SysMgr.stdlog.write(log)

        # write log #
        if 'REMOTERUN' in os.environ:
            print(log.replace('\n', ''))
        else:
            SysMgr.writeErr(SysMgr.stderr, log)



    @staticmethod
    def printErr(line, reason=False):
        # print backtrace #
        #SysMgr.printBacktrace()

        if not SysMgr.logEnable and SysMgr.forceEnable:
            return

        SysMgr.flushAllForPrint()

        if reason:
            rstring = ' because %s' % SysMgr.getErrMsg(start=3)
        else:
            rstring = ''

        try:
            line = line.rstrip('\n')
        except:
            pass

        # apply color #
        if SysMgr.colorEnable:
            color = ConfigMgr.FAIL
            colorl = ConfigMgr.ENDC
        else:
            color = colorl = ''

        proc = SysMgr.getProcInfo()

        log = ('\n%s%s%s%s%s%s\n' % \
            (color, '[ERROR] ', proc, line, rstring, colorl))

        # write log #
        if SysMgr.stdlog:
            SysMgr.stdlog.write(log)

        # write log #
        if 'REMOTERUN' in os.environ:
            print(log.replace('\n', ''))
        else:
            SysMgr.writeErr(SysMgr.stderr, log)



    @staticmethod
    def getProcInfo():
        if SysMgr.parentPid > 0:
            return '<%s(%s)> ' % (SysMgr.comm, SysMgr.pid)
        else:
            return ''



    @staticmethod
    def printInfo(line, prefix=True, suffix=True, notitle=False):
        if not SysMgr.logEnable:
            return

        if notitle:
            title = ''
        else:
            title = '[INFO] '

        if prefix:
            prefix = '\n'
        else:
            prefix = ''

        # apply color #
        if SysMgr.colorEnable:
            color = ConfigMgr.BOLD
            colorl = ConfigMgr.ENDC
        else:
            color = colorl = ''

        proc = SysMgr.getProcInfo()
        log = '%s%s%s%s%s%s' % \
            (prefix, color, title, proc, line, colorl)

        if SysMgr.stdlog:
            SysMgr.stdlog.write(log)

        if suffix:
            try:
                print(log)
            except:
                return
        else:
            try:
                sys.stdout.write(log)
                sys.stdout.flush()
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printErr(
                    'fail to flush stdout', reason=True)



    @staticmethod
    def printGood(line):
        if not SysMgr.logEnable:
            return

        # apply color #
        if SysMgr.colorEnable:
            color = ConfigMgr.OKGREEN
            colorl = ConfigMgr.ENDC
        else:
            color = colorl = ''

        proc = SysMgr.getProcInfo()

        log = '\n%s%s%s%s%s' % \
            (color, '[INFO] ', proc, line, colorl)

        if SysMgr.stdlog:
            SysMgr.stdlog.write(log)

        print(log)



    @staticmethod
    def printLine(line):
        if not SysMgr.logEnable:
            return

        # apply color #
        if SysMgr.colorEnable:
            color = ConfigMgr.UNDERLINE
            colorl = ConfigMgr.ENDC
        else:
            color = colorl = ''

        proc = SysMgr.getProcInfo()

        log = '\n%s%s%s%s' % \
            (color, proc, line, colorl)

        if SysMgr.stdlog:
            SysMgr.stdlog.write(log)

        print(log)



    @staticmethod
    def printStat(line):
        if not SysMgr.logEnable:
            return

        # apply color #
        if SysMgr.colorEnable:
            color = ConfigMgr.SPECIAL
            colorl = ConfigMgr.ENDC
        else:
            color = colorl = ''

        proc = SysMgr.getProcInfo()

        log = '\n%s%s%s%s%s' % \
            (color, '[STEP] ', proc, line, colorl)

        if SysMgr.stdlog:
            SysMgr.stdlog.write(log)

        print(log)



    @staticmethod
    def isValidRequest(request):
        try:
            if request.startswith('EVENT_') or \
                TaskAnalyzer.requestType.index(request):
                pass
            else:
                raise Exception('wrong request')

            return True
        except SystemExit:
            sys.exit(0)
        except:
            return False



    @staticmethod
    def printOpenErr(path):
        SysMgr.printErr(
            'fail to open %s' % path, True)



    @staticmethod
    def printOpenWarn(path, always=False):
        SysMgr.printWarn(
            'fail to open %s' % path, always, reason=True)



    @staticmethod
    def splitOptionString(option):
        stringList = {}

        # process strings in "" #
        strings = re.findall("\"(.*?)\"", option)
        if strings:
            # create an dictionary for strings #
            for idx, item in enumerate(strings):
                if not item:
                    continue

                val = '#%s#' % idx
                stringList.setdefault(item.strip('"'), val)

            # replace strings #
            for string, value in stringList.items():
                option = option.replace('"%s"' % string, value)

        # split the option string #
        option = option.split(' ')
        for string, value in stringList.items():
            for idx, item in enumerate(deepcopy(option)):
                if value in item:
                    option[idx] = item.replace(value, string)

        return option



    @staticmethod
    def parseOption(option=None):
        if not "ISMAIN" in os.environ:
            return

        if not option and SysMgr.optionList:
            return

        # parse options #
        parsedOpt = []
        prevIdx = long(0)

        # choose option #
        if option:
            optList = [sys.argv[1]] + option
        else:
            optList = sys.argv[1:]

        # parse option string #
        for idx, opt in enumerate(optList):
            if opt.startswith('-'):
                parsedOpt.append(' '.join(optList[prevIdx:idx])[1:])
                prevIdx = idx
        parsedOpt.append(' '.join(optList[prevIdx:])[1:])

        # save parsed option #
        SysMgr.optionList = parsedOpt[1:]

        # check redundant option #
        usedOpt = {}
        for opt in SysMgr.optionList:
            try:
                if not opt[0] in usedOpt or opt[0] == '-':
                    usedOpt[opt[0]] = True
                    continue
            except:
                continue

            SysMgr.printErr(
                "wrong -%s option because of redundant use" % opt[0])
            sys.exit(0)



    @staticmethod
    def findOption(option):
        if not "ISMAIN" in os.environ:
            return

        if len(sys.argv) <= 2 and not SysMgr.optionList:
            return False

        SysMgr.parseOption()

        for item in SysMgr.optionList:
            if item == '':
                pass
            elif item[0] == option:
                return True

        return False



    @staticmethod
    def getOption(option):
        if not "ISMAIN" in os.environ:
            return

        if len(sys.argv) <= 2 and not SysMgr.optionList:
            return None

        SysMgr.parseOption()

        for item in SysMgr.optionList:
            if item == '':
                pass
            elif item[0] == option and len(item[1:]) > 0:
                return item[1:].strip()

        return None



    @staticmethod
    def parseRuntimeOption(value):
        SysMgr.countEnable = True
        convertNum = UtilMgr.convNum
        convTime = UtilMgr.convUnit2Time

        # split params #
        if value:
            repeatParams = UtilMgr.cleanItem(value.split(':'))

        if not value:
            SysMgr.intervalEnable = 1
            SysMgr.repeatCount = 1
            repeatParams = None
        elif len(repeatParams) == 2 or len(repeatParams) == 3:
            try:
                # get interval #
                interval = SysMgr.getOption('i')
                if interval:
                    interval = long(interval)
                else:
                    interval = convTime(repeatParams[0])

                SysMgr.intervalEnable = interval
                SysMgr.repeatInterval = interval

                # get count #
                cnt = repeatParams[1]
                if not cnt:
                    SysMgr.repeatCount = sys.maxsize
                elif cnt.isdigit():
                    SysMgr.repeatCount = long(cnt)
                else:
                    SysMgr.repeatCount = \
                        long(convTime(cnt) / interval)
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printErr((
                    "wrong value for runtime option because %s, "
                    "input integer values") % SysMgr.getErrMsg())
                sys.exit(0)
        elif len(repeatParams) == 1:
            try:
                interval = long(convTime(repeatParams[0]))

                # top mode #
                if SysMgr.isTopMode():
                    ival = SysMgr.getOption('i')
                    if ival:
                        ival = long(ival)
                        interval = long(interval / ival)
                        SysMgr.repeatCount = interval
                        SysMgr.repeatInterval = interval
                        SysMgr.intervalEnable = ival
                    else:
                        SysMgr.repeatCount = interval
                        SysMgr.repeatInterval = interval
                        SysMgr.intervalEnable = 1
                # record mode #
                else:
                    SysMgr.repeatCount = 1
                    SysMgr.repeatInterval = interval
                    SysMgr.intervalEnable = interval
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printErr((
                    "wrong value for runtime option because %s, "
                    "input integer values") % SysMgr.getErrMsg())
                sys.exit(0)
        else:
            SysMgr.printErr((
                "wrong value for runtime option because %s, "
                "input in the format INTERVAL:REPEAT") % \
                    SysMgr.getErrMsg())
            sys.exit(0)

        # check variables #
        if not SysMgr.intervalEnable or \
            SysMgr.intervalEnable < 1 or \
            SysMgr.repeatCount < 1:
            SysMgr.printErr(
                "wrong value for runtime option, input values bigger than 0")
            sys.exit(0)

        # get termination flag #
        if SysMgr.checkMode('req'):
            pass
        elif repeatParams and len(repeatParams) == 3:
            SysMgr.termFlag = False
            SysMgr.printInfo(
                "run every %s sec %s time" % \
                (convertNum(SysMgr.intervalEnable),
                convertNum(SysMgr.repeatCount)))
        else:
            interval = SysMgr.intervalEnable
            repeat = SysMgr.repeatCount
            totalSec = convertNum(interval)
            totalCnt = convertNum(repeat)
            totalTime = convertNum(long(interval * repeat))
            SysMgr.printInfo(
                "run only %s times in %s sec for a total of %s sec" %
                    (totalCnt, totalSec, totalTime))



    @staticmethod
    def reloadFileBuffer(path=None):
        if path:
            try:
                fd = open(path, 'r')
            except:
                SysMgr.printOpenErr(path)
                sys.exit(0)
        else:
            fd = SysMgr.printFd

        try:
            fd.seek(0, 0)
            SysMgr.procBuffer = \
                fd.read().replace('\n\n', 'NEWSTAT\n\n')
            SysMgr.procBuffer = \
                SysMgr.procBuffer.split('NEWSTAT')
            fd.seek(0, 0)
            fd.truncate()
        except:
            return



    @staticmethod
    def checkOptVal(option, value):
        if not value:
            SysMgr.printErr(
                'no input value with -%s option' % option)
            sys.exit(0)



    @staticmethod
    def applySaveOption(value=None):
        # apply default path #
        if value == '':
            value = '.'

        # change output path #
        try:
            if SysMgr.isWritable(value):
                if os.path.isdir(value):
                    SysMgr.outputFile = \
                        '%s/guider.dat' % value
                else:
                    SysMgr.outputFile = value
            else:
                raise Exception('not writable')
        except:
            SysMgr.printErr(
                "wrong path '%s' because of permission" % value)
            sys.exit(0)

        # remove double slashs #
        SysMgr.outputFile = \
            os.path.normpath(SysMgr.outputFile)

        # support no-report record mode #
        if SysMgr.checkMode('filerec') or \
            SysMgr.checkMode('genrec'):
            if SysMgr.outputFile.endswith('.dat'):
                SysMgr.outPath = '%s.out' % \
                    os.path.splitext(SysMgr.outputFile)[0]
            else:
                SysMgr.outPath = SysMgr.outputFile



    @staticmethod
    def removeOptionArgs():
        if len(sys.argv) < 3:
            return

        # find first option args #
        firstOptIdx = None
        for idx, item in enumerate(sys.argv):
            if item.startswith('-'):
                firstOptIdx = idx
                break

        # update args #
        if firstOptIdx:
            sys.argv = sys.argv[:firstOptIdx]



    @staticmethod
    def parseAnalOption(option=None):
        if not "ISMAIN" in os.environ:
            return

        # check call history #
        if not option and SysMgr.parsedAnalOption:
            return
        else:
            SysMgr.parsedAnalOption = True

        # set default processor option #
        if SysMgr.isTopMode():
            if SysMgr.findOption('a') or \
                SysMgr.isDrawMode():
                SysMgr.cpuEnable = True
                SysMgr.gpuEnable = True
            else:
                SysMgr.cpuEnable = False

        # check argument count #
        if option:
            optionList = option.split()
            SysMgr.parseOption(optionList)
        elif len(sys.argv) <= 2:
            return
        else:
            optionList = None

        for item in SysMgr.optionList:
            if not item:
                continue

            option = item[0]
            value = item[1:].strip()

            if option == 'i':
                # set default interval #
                if not value:
                    SysMgr.intervalEnable = 1
                    continue

                try:
                    SysMgr.intervalEnable = long(value)

                    if SysMgr.intervalEnable <= 0:
                        SysMgr.printErr((
                            "wrong value for interval, "
                            "input number bigger than 0") % option)
                        sys.exit(0)
                except SystemExit:
                    sys.exit(0)
                except:
                    SysMgr.printErr((
                        "wrong value for interval, "
                        "input number in integer format") % option)
                    sys.exit(0)

            elif SysMgr.isCommonOption(option):
                SysMgr.parseCommonOption(option, value)

            elif option == 'I':
                SysMgr.inputParam = value.strip()

            elif option == 'w':
                SysMgr.checkOptVal(option, value)
                SysMgr.rcmdList = \
                    SysMgr.parseCustomRecordCmd(value)

            elif option == 'a':
                SysMgr.showAll = True

            elif option == 'D':
                SysMgr.depEnable = True

            elif option == 'P':
                SysMgr.groupProcEnable = True

            elif option == 'p':
                SysMgr.checkOptVal(option, value)

                SysMgr.preemptGroup = \
                    UtilMgr.cleanItem(value.split(','))

            elif option == 'Y':
                SysMgr.checkOptVal(option, value)
                if not SysMgr.prio:
                    SysMgr.applyPriority(value)

            elif option == 'J':
                SysMgr.jsonEnable = True

            elif option == 'k':
                SysMgr.checkOptVal(option, value)
                if not SysMgr.isKillMode():
                    SysMgr.applyKillVal(value)

            elif option == 'd':
                SysMgr.checkOptVal(option, value)
                options = value

                if 'b' in options:
                    SysMgr.bufferLossEnable = True

                if 'p' in options:
                    SysMgr.printEnable = False

                if 'u' in options:
                    SysMgr.userEnable = False

                if 'c' in options:
                    SysMgr.cpuEnable = False

                if 'C' in options:
                    SysMgr.cloneEnable = False

                if 'O' in options:
                    SysMgr.colorEnable = False

                if 'E' in options:
                    SysMgr.execEnable = False

                if 't' in options:
                    SysMgr.truncEnable = False

                if 'T' in options:
                    SysMgr.taskEnable = False

                if 'e' in options:
                    SysMgr.encodeEnable = False

                if 'a' in options:
                    SysMgr.freeMemEnable = True

                if 'G' in options:
                    SysMgr.gpuEnable = False

                if 'A' in options:
                    SysMgr.cpuAvgEnable = False

                if 'L' in options:
                    SysMgr.logEnable = False

                if 'g' in options:
                    SysMgr.generalInfoEnable = False

                if 'D' in options:
                    SysMgr.dwarfEnable = False

            elif option == 'c':
                itemList = UtilMgr.splitString(value)

                # set union option #
                if SysMgr.isTraceMode() or SysMgr.checkMode('cli'):
                    union = False
                else:
                    union = True

                SysMgr.customCmd = UtilMgr.cleanItem(itemList, union=union)

            elif option == 'g':
                itemList = UtilMgr.splitString(value)
                SysMgr.filterGroup = UtilMgr.cleanItem(itemList)

            elif option == 'W':
                SysMgr.waitEnable = True

            elif 'F' in option:
                SysMgr.checkOptVal(option, value)

                SysMgr.drawFormat = value.strip()

            elif option == 'e':
                options = value

                if 'g' in options:
                    SysMgr.graphEnable = True

                if 'D' in options:
                    SysMgr.dwarfEnable = True

                if 't' in options:
                    SysMgr.processEnable = False

                if 'H' in options:
                    if not SysMgr.checkMode('ttop'):
                        SysMgr.printErr(
                            "sched option is supported only in thread mode")
                        sys.exit(0)
                    SysMgr.schedEnable = True

                if 'Y' in options:
                    SysMgr.checkRootPerm()
                    SysMgr.delayEnable = True

                # no more options except for top mode #
                if not SysMgr.isTopMode():
                    continue

                if 'T' in options:
                    SysMgr.totalEnable = True

                if 'c' in options:
                    SysMgr.cpuEnable = True

                if 'p' in options:
                    SysMgr.pipeEnable = True

                if 'P' in options:
                    SysMgr.perfEnable = True
                    if SysMgr.findOption('g'):
                        SysMgr.perfGroupEnable = True

                if 'i' in options:
                    SysMgr.irqEnable = True

                if 'b' in options:
                    if SysMgr.checkDiskTopCond():
                        SysMgr.blockEnable = True
                    else:
                        sys.exit(0)

                if 'B' in options:
                    SysMgr.barGraphEnable = True

                if 's' in options:
                    if SysMgr.checkStackTopCond():
                        SysMgr.stackEnable = True
                    else:
                        sys.exit(0)

                if 'S' in options:
                    SysMgr.checkRootPerm()
                    SysMgr.pssEnable = True
                    SysMgr.sort = 'm'

                if 'u' in options:
                    SysMgr.checkRootPerm()
                    SysMgr.ussEnable = True
                    SysMgr.sort = 'm'

                if 'L' in options:
                    SysMgr.cmdlineEnable = True

                # check last field #
                if 'a' in options:
                    TaskAnalyzer.setLastField('affinity')
                elif 'o' in options:
                    TaskAnalyzer.setLastField('oom')
                elif 'W' in options:
                    TaskAnalyzer.setLastField('wchan')
                elif 'h' in options:
                    TaskAnalyzer.setLastField('signal')

                if 'f' in options:
                    SysMgr.floatEnable = True

                    # set default interval to 3 for accuracy #
                    if not SysMgr.findOption('i') and \
                        not SysMgr.findOption('R'):
                        SysMgr.intervalEnable = 3

                if 'F' in options:
                    SysMgr.wfcEnable = True

                if 'R' in options:
                    SysMgr.reportEnable = True
                    SysMgr.reportFileEnable = True

                if 'e' in options:
                    SysMgr.encodeEnable = True

                if 'm' in options:
                    if SysMgr.checkMemTopCond():
                        SysMgr.memEnable = True
                    else:
                        sys.exit(0)

                if 'w' in options:
                    if SysMgr.checkWssTopCond():
                        SysMgr.memEnable = True
                        SysMgr.wssEnable = True
                        SysMgr.sort = 'm'
                    else:
                        sys.exit(0)

                if 'n' in options:
                    SysMgr.networkEnable = True

                if 'N' in options:
                    SysMgr.nsEnable = True

                if 'P' in options:
                    if SysMgr.checkPerfTopCond():
                        SysMgr.perfEnable = True
                        if SysMgr.findOption('g'):
                            SysMgr.perfGroupEnable = True
                    else:
                        sys.exit(0)

                if 'r' in options:
                    SysMgr.reportEnable = True

                if 'I' in options:
                    SysMgr.reportEnable = True
                    SysMgr.elasticEnable = True

                if 'd' in options:
                    SysMgr.diskEnable = True

                if 'E' in options:
                    SysMgr.execEnable = True

                if 'G' in options:
                    SysMgr.cgroupEnable = True

                if 'C' in options:
                    SysMgr.compressEnable = True

                if 'q' in options:
                    SysMgr.exitFlag = True

                if 'x' in options:
                    SysMgr.fixTargetEnable = True

                if not SysMgr.isValidEnableOption(options):
                    SysMgr.printErr(
                        "unrecognized option -%s to enable" % options)
                    sys.exit(0)

            # ignore below options for function mode #
            elif SysMgr.isFuncMode():
                SysMgr.functionEnable = True

            elif option == 'l':
                if SysMgr.isDrawMode():
                    SysMgr.boundaryLine = \
                        UtilMgr.cleanItem(value.split(','))

                    try:
                        cval = sorted(list(map(long, SysMgr.boundaryLine)))

                        SysMgr.printInfo(
                            "set boundary line [%s]" % \
                            ', '.join(SysMgr.boundaryLine))

                        SysMgr.boundaryLine = cval
                    except:
                        SysMgr.printErr(
                            'fail to convert [%s] to number' % \
                                ', '.join(SysMgr.boundaryLine), True)
                        sys.exit(0)
                else:
                    options = value

                    if 'd' in options:
                        SysMgr.loggingEnable = True
                        SysMgr.dltEnable = True

                    if 'k' in options:
                        SysMgr.loggingEnable = True
                        SysMgr.kmsgEnable = True

                    if 'j' in options:
                        SysMgr.loggingEnable = True
                        SysMgr.journalEnable = True

                    if 's' in options:
                        SysMgr.loggingEnable = True
                        SysMgr.syslogEnable = True

            elif option == 'r':
                SysMgr.checkOptVal(option, value)

                SysMgr.rootPath = value

            elif option == 'T':
                SysMgr.checkOptVal(option, value)

                if SysMgr.checkMode('convert'):
                    SysMgr.fontPath = value
                elif SysMgr.isDrawMode():
                    try:
                        SysMgr.nrTop = long(value)
                    except:
                        SysMgr.printErr((
                            "wrong value for the number of task, "
                            "input number in integer format") % option)
                        sys.exit(0)
                # this value will be used in various mode #
                else:
                    try:
                        SysMgr.utilProc = long(value)
                    except:
                        pass

            elif option == 'O':
                SysMgr.checkOptVal(option, value)

                SysMgr.perCoreList = \
                    UtilMgr.cleanItem(value.split(','))
                if not SysMgr.perCoreList:
                    SysMgr.printErr(
                        "no input value for filter" % option)
                    sys.exit(0)

                for item in SysMgr.perCoreList:
                    if not item.isdigit():
                        SysMgr.printErr((
                            "wrong value for core list, "
                            "input number in integer format") % option)
                        sys.exit(0)

                SysMgr.printInfo(
                    "only specific cores [ %s ] are shown" % \
                    ', '.join(SysMgr.perCoreList))

                SysMgr.perCoreList = \
                    list(map(long, SysMgr.perCoreList))

                if SysMgr.isDrawMode():
                    SysMgr.perCoreDrawList = SysMgr.perCoreList
                    SysMgr.perCoreList = []

            elif option == 't' and \
                not SysMgr.isRecordMode():
                SysMgr.syscallList = \
                    UtilMgr.cleanItem(value.split(','))
                enabledSyscall = []

                for val in SysMgr.syscallList:
                    try:
                        if val[0:4] == 'sys_':
                            nrSyscall = ConfigMgr.sysList.index(val)
                        else:
                            nrSyscall = \
                                ConfigMgr.sysList.index('sys_%s' % val)

                        enabledSyscall.append(ConfigMgr.sysList[nrSyscall])
                        sidx = SysMgr.syscallList.index(val)
                        SysMgr.syscallList[sidx] = nrSyscall
                    except SystemExit:
                        sys.exit(0)
                    except:
                        SysMgr.printErr(
                            "no %s syscall in %s ABI" % \
                            (val, SysMgr.arch))
                        sys.exit(0)

                if not enabledSyscall:
                    SysMgr.printInfo("enabled syscall list [ ALL ]")
                else:
                    SysMgr.printInfo(
                        "enabled syscall list [ %s ]" % \
                        ', '.join(enabledSyscall))

            elif option == 'm':
                try:
                    SysMgr.ttyEnable = True

                    if not value:
                        SysMgr.setTTYAuto()
                    else:
                        rows = cols = long(0)
                        term = value.split(':')

                        # get size #
                        term[0] = term[0].strip()
                        if term[0].isdigit():
                            rows = long(term[0])

                        if len(term) > 1:
                            term[1] = term[1].strip()
                            if term[1].isdigit():
                                cols = long(term[1])

                        # update system terminal #
                        if len(term) > 2 and term[2].upper() == 'SYSTEM':
                            SysMgr.setTTY(rows, cols)
                        # update local terminal #
                        else:
                            if rows > 0:
                                SysMgr.ttyRows = rows
                            if cols > 0:
                                SysMgr.ttyCols = cols
                except SystemExit:
                    sys.exit(0)
                except:
                    SysMgr.printErr((
                        "wrong value for screen size, "
                        "input number in COLS:ROWS format") % option,
                        reason=True)
                    sys.exit(0)

            elif option == 'b' and \
                not SysMgr.isRecordMode():
                SysMgr.checkOptVal(option, value)
                try:
                    if value.isdigit():
                        osize = bsize = long(value) << 10
                    else:
                        osize = UtilMgr.convUnit2Size(value)
                        bsize = osize >> 10

                    if bsize >= 0:
                        SysMgr.bufferSize = str(bsize)

                        if bsize == 0:
                            SysMgr.printInfo(
                                "set buffer size to unlimited")
                        else:
                            SysMgr.printInfo(
                                "set buffer size to %s" %
                                    UtilMgr.convSize2Unit(osize))
                    else:
                        SysMgr.printErr((
                            "wrong value for buffer size, "
                            "input number bigger than 0") % option)
                        sys.exit(0)
                except SystemExit:
                    sys.exit(0)
                except:
                    SysMgr.printErr((
                            "wrong value for buffer size, "
                            "input number in integer format") % option)
                    sys.exit(0)

            elif option == 'N':
                SysMgr.checkOptVal(option, value)
                networkList = UtilMgr.cleanItem(value.split(','))
                for item in networkList:
                    service, ip, port = NetworkMgr.parseAddr(item)
                    NetworkMgr.setRemoteNetwork(service, ip, port)

            elif option == 'j':
                if not SysMgr.checkRepTopCond(value):
                    sys.exit(0)

            elif option == 'x':
                SysMgr.checkOptVal(option, value)
                service, ip, port = NetworkMgr.parseAddr(value)
                NetworkMgr.setServerNetwork(ip, port)

            elif option == 'X':
                if not SysMgr.findOption('x'):
                    service, ip, port = NetworkMgr.parseAddr(value)
                    NetworkMgr.setServerNetwork(None, None)

                NetworkMgr.setRemoteServer(value)

            elif option == 'S':
                if not SysMgr.setSortValue(value):
                    sys.exit(0)

            # Ignore options #
            elif SysMgr.isValidOption(option):
                continue

            else:
                SysMgr.printErr(
                    "unrecognized option -%s for analysis" % option)
                sys.exit(0)



    @staticmethod
    def parseCommonOption(option, value):
        if value:
            value = value.strip()

        if option == 'f':
            SysMgr.forceEnable = True

        elif option == 'L':
            if not value:
                SysMgr.printErr(
                    "no input value with -%s option" % option)
                sys.exit(0)
            elif SysMgr.isDrawMode():
                SysMgr.layout = value
            elif not SysMgr.stdlog:
                if os.path.isdir(value):
                    value = os.path.join(value, 'guider.log')
                SysMgr.printInfo("use '%s' for log" % value)
                SysMgr.stdlog = LogMgr(value)

        elif option == 'o':
            # apply default path #
            if value == '':
                value = '.'

            # check writable access #
            if not SysMgr.isWritable(value):
                SysMgr.printErr((
                    "wrong path '%s' for output "
                    "because of permission") % value)
                sys.exit(0)

            SysMgr.outPath = os.path.normpath(value)

        elif option == 's':
            SysMgr.applySaveOption(value)

        elif option == 'H':
            try:
                if not value:
                    SysMgr.funcDepth = 32
                else:
                    SysMgr.funcDepth = long(value)

                if SysMgr.funcDepth < 0:
                    raise Exception('wrong depth')
            except:
                SysMgr.printErr(
                    "wrong input value for depth, "
                    "input an unsigned integer value")
                sys.exit(0)

        elif option == 'Q':
            SysMgr.setStream()

        elif option == 'q':
            SysMgr.checkOptVal(option, value)
            if not SysMgr.environList:
                itemList = UtilMgr.splitString(value)
                SysMgr.environList = UtilMgr.convList2Dict(itemList)

        elif option == 'R':
            # set maximum count #
            if not value:
                value = str(sys.maxsize)
            SysMgr.parseRuntimeOption(value)

        elif option == 'z':
            SysMgr.checkOptVal(option, value)
            SysMgr.parseAffinityOption(
                UtilMgr.cleanItem(value.split(',')))

        elif option == 'A':
            SysMgr.checkOptVal(option, value)
            SysMgr.archOption = value
            SysMgr.setArch(value)

        elif option == 'W':
            SysMgr.waitEnable = True

        elif option == 'C':
            if not ConfigMgr.confData:
                if value:
                    SysMgr.confFileName = os.path.abspath(value)
                else:
                    SysMgr.confFileName = \
                        os.path.abspath(SysMgr.confFileName)

                # load configuration #
                ret = SysMgr.loadConfig(SysMgr.confFileName)
                if SysMgr.isDrawMode():
                    pass
                elif not ret:
                    sys.exit(0)

        elif option == 'E':
            SysMgr.cacheDirPath = value
            SysMgr.printInfo(
                "use %s as cache directory" % value)

        elif option == 'G':
            SysMgr.checkOptVal(option, value)
            itemList = UtilMgr.splitString(value)
            SysMgr.ignoreItemList = UtilMgr.cleanItem(itemList, union=True)
            SysMgr.printInfo(
                "applied ignore keyword [ %s ]" % \
                    ', '.join(SysMgr.ignoreItemList))

        elif option == 'u':
            SysMgr.runBackgroundMode()



    @staticmethod
    def isCommonOption(option):
        optionList = 'ACEGHLQRWfoqsuz'
        if option in optionList:
            return True
        else:
            return False



    @staticmethod
    def parseRecordOption():
        if not "ISMAIN" in os.environ:
            return

        if len(sys.argv) <= 2:
            return

        SysMgr.parseOption()

        for item in SysMgr.optionList:
            try:
                option = item[0]
                value = item[1:].strip()
            except:
                continue

            if option == 'b':
                try:
                    if value.isdigit():
                        osize = bsize = long(value) << 10
                    else:
                        osize = UtilMgr.convUnit2Size(value)
                        bsize = osize >> 10

                    if bsize > 0:
                        SysMgr.bufferSize = str(bsize)

                        SysMgr.printInfo(
                            "set buffer size to %s" %
                                UtilMgr.convSize2Unit(osize))
                    else:
                        SysMgr.printErr(
                            "wrong value for buffer size, "
                            "input number bigger than 0")
                        sys.exit(0)
                except SystemExit:
                    sys.exit(0)
                except:
                    SysMgr.printErr(
                        "wrong value for buffer size, "
                        "input number in integer format")
                    sys.exit(0)

            elif option == 'Y':
                SysMgr.applyPriority(value)

            elif option == 'e':
                options = value
                if 'i' in options:
                    SysMgr.irqEnable = True
                if 'm' in options:
                    SysMgr.memEnable = True
                if 'n' in options:
                    SysMgr.networkEnable = True
                if 'h' in options:
                    SysMgr.heapEnable = True
                if 'b' in options:
                    SysMgr.blockEnable = True
                if 'p' in options:
                    SysMgr.pipeEnable = True
                if 'P' in options:
                    SysMgr.powerEnable = True
                if 'w' in options:
                    SysMgr.wqEnable = True
                if 'B' in options:
                    SysMgr.binderEnable = True
                if 'I' in options:
                    SysMgr.i2cEnable = True
                if 'r' in options:
                    SysMgr.resetEnable = True
                if 'g' in options:
                    SysMgr.graphEnable = True
                if 'L' in options:
                    SysMgr.lockEnable = True
                if 'c' in options:
                    SysMgr.cgroupEnable = True

                if not SysMgr.isValidEnableOption(options):
                    SysMgr.printErr(
                        "unrecognized option '%s' to enable" % options)
                    sys.exit(0)

            elif option == 'g':
                itemList = UtilMgr.splitString(value)
                SysMgr.filterGroup = UtilMgr.cleanItem(itemList)
                if not SysMgr.filterGroup:
                    SysMgr.printErr(
                        "no input value for filter")
                    sys.exit(0)

                SysMgr.printInfo(
                    "only specific threads [ %s ] are recorded" % \
                    ', '.join(SysMgr.filterGroup))

            elif option == 'D':
                SysMgr.depEnable = True

            elif option == 'w':
                SysMgr.rcmdList = \
                    SysMgr.parseCustomRecordCmd(value)

            elif option == 'U':
                SysMgr.ueventEnable = True
                itemList = UtilMgr.splitString(value)
                SysMgr.userCmd = UtilMgr.cleanItem(itemList)

            elif option == 'K':
                SysMgr.keventEnable = True
                itemList = UtilMgr.splitString(value)
                SysMgr.kernelCmd = UtilMgr.cleanItem(itemList)

            elif option == 'M':
                SysMgr.objdumpPath = value

                SysMgr.printInfo(
                    "use %s as objdump path" % SysMgr.objdumpPath)

            elif option == 'F':
                SysMgr.fileEnable = True

            elif option == 'B':
                # get output path #
                if not value:
                    value = SysMgr.cmdFileName

                # change output path #
                try:
                    if SysMgr.isWritable(value):
                        if os.path.isdir(value):
                            SysMgr.cmdEnable = \
                                '%s/%s' % (value, SysMgr.cmdFileName)
                        else:
                            SysMgr.cmdEnable = value
                    else:
                        raise Exception('not writable')
                except:
                    SysMgr.printErr(
                        "wrong value for command script path" % value)
                    sys.exit(0)

                # remove double slashs #
                SysMgr.cmdEnable = \
                    os.path.normpath(SysMgr.cmdEnable)

            elif option == 't':
                SysMgr.sysEnable = True
                SysMgr.syscallList = \
                    UtilMgr.cleanItem(value.split(','))
                enabledSyscall = []

                for val in SysMgr.syscallList:
                    try:
                        if val[0:4] == 'sys_':
                            nrSyscall = ConfigMgr.sysList.index(val)
                        else:
                            nrSyscall = \
                                ConfigMgr.sysList.index('sys_%s' % val)

                        enabledSyscall.append(
                            ConfigMgr.sysList[nrSyscall])
                        sidx = SysMgr.syscallList.index(val)
                        SysMgr.syscallList[sidx] = nrSyscall
                    except SystemExit:
                        sys.exit(0)
                    except:
                        SysMgr.printErr(
                            "no %s syscall in %s ABI" % \
                            (val, SysMgr.arch))
                        sys.exit(0)

                if not enabledSyscall:
                    SysMgr.printInfo("enabled syscall list [ ALL ]")
                else:
                    SysMgr.printInfo(
                        "enabled syscall list [ %s ]" % \
                        ', '.join(enabledSyscall))

            elif SysMgr.isCommonOption(option):
                SysMgr.parseCommonOption(option, value)

            elif option == 'c':
                itemList = UtilMgr.splitString(value)
                SysMgr.customCmd = UtilMgr.cleanItem(itemList)
                if not SysMgr.customCmd:
                    SysMgr.printErr(
                        "fail to recognize custom events")
                    sys.exit(0)

            elif option == 'd':
                options = value

                if 'c' in options:
                    SysMgr.cpuEnable = False
                    SysMgr.latEnable = False

                if 'm' in options:
                    SysMgr.memEnable = False

                if 'h' in options:
                    SysMgr.heapEnable = False

                if 'b' in options:
                    SysMgr.blockEnable = False

                if 'u' in options:
                    SysMgr.userEnable = False

                if 'p' in options:
                    SysMgr.printEnable = False

                if 'l' in options:
                    SysMgr.latEnable = False

                if 'L' in options:
                    SysMgr.logEnable = False

                if 'a' in options:
                    SysMgr.disableAll = True

                if 'C' in options:
                    SysMgr.compressEnable = False

                if 'g' in options:
                    SysMgr.generalInfoEnable = False

            # Ignore options #
            elif SysMgr.isValidOption(option):
                continue

            else:
                SysMgr.printErr(
                    "unrecognized option -%s for recording" % option)
                sys.exit(0)



    @staticmethod
    def makeKerSymTable(symbol):
        try:
            restPath = '%s/sys/kernel/kptr_restrict' % SysMgr.procPath
            with open(restPath, 'w+') as fd:
                fd.write('0')
        except SystemExit:
            sys.exit(0)
        except:
            pass

        try:
            symPath = '%s/kallsyms' % SysMgr.procPath
            f = open(symPath, 'r')
        except IOError:
            SysMgr.printOpenWarn(symPath)
        except SystemExit:
            sys.exit(0)

        ret = None
        startPos = len(SysMgr.kerSymTable)
        curPos = long(0)

        while 1:
            line = f.readline()
            curPos += 1

            if startPos > curPos:
                continue

            # Cache address and symbol #
            line = line.split()
            SysMgr.kerSymTable[line[2]] = line[0]

            if line[2] == symbol:
                ret = line[0]
                break

        f.close()
        return ret



    @staticmethod
    def getKerAddr(symbol):
        try:
            return SysMgr.kerSymTable[symbol]
        except:
            return SysMgr.makeKerSymTable(symbol)



    @staticmethod
    def isRecordMode():
        if SysMgr.checkMode('rec') or \
            SysMgr.checkMode('funcrec') or \
            SysMgr.checkMode('filerec') or \
            SysMgr.checkMode('sysrec') or \
            SysMgr.checkMode('genrec'):
            return True
        else:
            return False



    @staticmethod
    def isHelpMode():
        if len(sys.argv) > 1 and sys.argv[1] == 'help':
            return True
        elif '-help' in sys.argv or \
            '--help' in sys.argv or \
            '-h' in sys.argv:
            return True
        else:
            return False



    @staticmethod
    def checkMode(mode, orig=False):
        # set target list #
        if orig:
            target = SysMgr.origArgs
        else:
            target = sys.argv

        # check value #
        if len(target) > 1 and target[1] == mode:
            return True
        else:
            return False



    @staticmethod
    def isKillMode():
        if len(sys.argv) < 2:
            return False
        elif sys.argv[1] == 'kill' or \
            sys.argv[1] == 'send' or \
            sys.argv[1] == 'tkill':
            return True
        else:
            return False



    @staticmethod
    def isWritable(value):
        # file exist #
        if os.access(value, os.F_OK):
            if not os.access(value, os.W_OK):
                return False
        # no file exist #
        else:
            dirPath = os.path.dirname(value)
            if not dirPath:
                dirPath = '.'

            # no dir exist #
            if not os.path.isdir(dirPath):
                return False
            # dir is not writable #
            elif not os.access(dirPath, os.W_OK):
                return False

        return True



    @staticmethod
    def isTopMode():
        if SysMgr.checkMode('top') or \
            SysMgr.checkMode('ttop') or \
            SysMgr.checkMode('utop') or \
            SysMgr.checkMode('btop') or \
            SysMgr.checkMode('systop') or \
            SysMgr.checkMode('pytop') or \
            SysMgr.checkMode('ftop') or \
            SysMgr.checkMode('stacktop') or \
            SysMgr.checkMode('ptop') or \
            SysMgr.checkMode('mtop') or \
            SysMgr.checkMode('wtop') or \
            SysMgr.checkMode('rtop') or \
            SysMgr.checkMode('bgtop') or \
            SysMgr.checkMode('atop') or \
            SysMgr.checkMode('ctop') or \
            SysMgr.checkMode('ntop') or \
            SysMgr.checkMode('dlttop') or \
            SysMgr.checkMode('cgtop') or \
            SysMgr.checkMode('dbustop') or \
            SysMgr.checkMode('disktop'):
            return True
        else:
            return False



    @staticmethod
    def isTraceMode():
        if SysMgr.checkMode('strace') or \
            SysMgr.checkMode('utrace') or \
            SysMgr.checkMode('btrace') or \
            SysMgr.checkMode('remote') or \
            SysMgr.checkMode('leaktrace') or \
            SysMgr.checkMode('sigtrace'):
            return True
        else:
            return False



    @staticmethod
    def isRuntimeMode():
        if SysMgr.isRecordMode() or \
            SysMgr.isTopMode() or \
            SysMgr.isTraceMode() or \
            SysMgr.checkMode('req'):
            return True

        return False



    @staticmethod
    def checkCmdMode():
        # parse options #
        SysMgr.parseAnalOption()

        # LIST MODE #
        if SysMgr.checkMode('list'):
            SysMgr.printBgProcs()

        # SERVER MODE #
        elif SysMgr.checkMode('server'):
            SysMgr.runServerMode()

        # CLIENT MODE #
        elif SysMgr.checkMode('cli'):
            SysMgr.runClientMode()

        # START / STOP MODE #
        elif SysMgr.checkMode('start') or SysMgr.checkMode('stop'):
            # make list of arguments #
            if len(sys.argv) > 2:
                argList = sys.argv[2:]
            else:
                argList = None

            SysMgr.sendSignalProcs(signal.SIGINT, argList)

        # KILL MODE #
        elif SysMgr.isKillMode():
            # make list of arguments #
            if len(sys.argv) > 2:
                argList = sys.argv[2:]
            else:
                argList = [' ']

            # remove additional options #
            if len(argList) > 1:
                idx = 0
                for idx, item in enumerate(argList[1:]):
                    if item.strip().startswith('-'):
                        break

                if argList[-1].strip().startswith('-'):
                    argList = argList[:idx+1]
                else:
                    argList = argList[:idx+2]

            # print signal list #
            if SysMgr.findOption('l'):
                for idx, sig in enumerate(ConfigMgr.SIG_LIST):
                    if idx == 0:
                        continue
                    elif idx % 5 == 0:
                        newline = True
                    else:
                        newline = False

                    SysMgr.printPipe(
                        "{0:>2}) {1:<12}".format(idx, sig), newline=newline)

                sys.exit(0)

            waitFlag = SysMgr.waitEnable

            while 1:
                # send signal #
                if SysMgr.checkMode('tkill'):
                    SysMgr.sendSignalArgs(
                        argList, isThread=True, wait=waitFlag)
                else:
                    SysMgr.sendSignalArgs(argList, wait=waitFlag)

                if SysMgr.intervalEnable:
                    time.sleep(SysMgr.intervalEnable)
                else:
                    break

        # TOPDIFF MODE #
        elif SysMgr.checkMode('topdiff'):
            # remove option args #
            SysMgr.removeOptionArgs()

            # get file list #
            if SysMgr.hasMainArg():
                argList = SysMgr.getMainArg().split(',')
                argList = UtilMgr.cleanItem(argList)
            else:
                argList = None

            SysMgr.printLogo(big=True, onlyFile=True)

            TaskAnalyzer.doDiffReports(argList)

        # TOPSUM MODE #
        elif SysMgr.checkMode('topsum'):
            # remove option args #
            SysMgr.removeOptionArgs()

            # get file path #
            if SysMgr.hasMainArg():
                fname = SysMgr.getMainArg()
            else:
                fname = SysMgr.outFilePath

            SysMgr.printLogo(big=True, onlyFile=True)

            TaskAnalyzer.doSumReport(fname)

        # PAUSE MODE #
        elif SysMgr.checkMode('pause'):
            # get target list #
            if SysMgr.hasMainArg():
                targets = SysMgr.getMainArg().split(',')
                targets = UtilMgr.cleanItem(targets)
            else:
                targets = SysMgr.filterGroup

            if not targets:
                SysMgr.printErr(
                    "no input value for COMM or TID")
                sys.exit(0)

            # convert comm to pid #
            targetList = []
            sibling = SysMgr.groupProcEnable
            for item in targets:
                targetList += SysMgr.getPids(item, sibling=sibling)
            targetList = list(set(targetList))

            if not targetList:
                SysMgr.printErr(
                    "no task related to '%s'" % ', '.join(targets))
                sys.exit(0)

            Debugger.pauseThreads(targetList)

        # READELF MODE #
        elif SysMgr.checkMode('readelf'):
            SysMgr.printLogo(big=True, onlyFile=True)

            # get path #
            if SysMgr.hasMainArg():
                path = SysMgr.getMainArg()
            elif SysMgr.inputParam:
                path = SysMgr.inputParam
            else:
                SysMgr.printErr("no input value for path")
                sys.exit(0)

            # set debug flag #
            if SysMgr.jsonEnable:
                debug = False
            else:
                debug = True

            # run ELF analyzer #
            try:
                if path == 'vdso':
                    obj = SysMgr.getVDSO(debug=debug)
                else:
                    obj = ElfAnalyzer(path, debug, incArg=True)

                if SysMgr.jsonEnable:
                    jsonStr = UtilMgr.convDict2Str(obj.attr)
                    SysMgr.printPipe(jsonStr)
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printErr(
                    "fail to analyze '%s'" % path, True)

        # LEAKTRACE MODE #
        elif SysMgr.checkMode('leaktrace'):
            SysMgr.doLeaktrace()

        # ADDR2SYM MODE #
        elif SysMgr.checkMode('addr2sym'):
            SysMgr.doAddr2sym()

        # SYM2ADDR MODE #
        elif SysMgr.checkMode('sym2addr'):
            SysMgr.doSym2addr()

        # MKCACHE MODE #
        elif SysMgr.checkMode('mkcache'):
            SysMgr.doMkCache()

        # PRINTDIR MODE #
        elif SysMgr.checkMode('printdir'):
            SysMgr.printLogo(big=True, onlyFile=True)

            # get start dir #
            if SysMgr.hasMainArg():
                root = SysMgr.getMainArg()
            elif SysMgr.inputParam:
                root = SysMgr.inputParam
            else:
                root = '.'

            # get depth #
            if not SysMgr.funcDepth:
                maxLevel = -1
            else:
                maxLevel = SysMgr.funcDepth

            SysMgr.printDirs(root, maxLevel)

        # PRINTCGROUP MODE #
        elif SysMgr.checkMode('printcg'):
            SysMgr.cgroupEnable = True
            SysMgr().printCgroupInfo(printTitle=False)
            SysMgr.printInfoBuffer()

        # LOGJRL MODE #
        elif SysMgr.checkMode('logjrl'):
            SysMgr.doLogMode('journal')

        # LOGDLT MODE #
        elif SysMgr.checkMode('logdlt'):
            SysMgr.doLogMode('dlt')

        # LOGKMSG MODE #
        elif SysMgr.checkMode('logkmsg'):
            SysMgr.doLogMode('kmsg')

        # LOGSYS MODE #
        elif SysMgr.checkMode('logsys'):
            SysMgr.doLogMode('syslog')

        # PRINTDBUS MODE #
        elif SysMgr.checkMode('printdbus'):
            # set console info #
            SysMgr.setStream()

            SysMgr.printLogo(big=True, onlyFile=True)

            DbusMgr.runDbusSnooper(mode='print')

        # PRINTDBUSINFO MODE #
        elif SysMgr.checkMode('printdbusinfo'):
            SysMgr.printLogo(big=True, onlyFile=True)

            DbusMgr.runDbusSnooper(mode='printstat')

        # PRINTSUB MODE #
        elif SysMgr.checkMode('printsub'):
            SysMgr.printLogo(big=True, onlyFile=True)

            DbusMgr.runDbusSnooper(mode='signal')

        elif SysMgr.isPrintLogMode():
            # set console info #
            SysMgr.setStream()

            console = SysMgr.findOption('Q')

            SysMgr.printLogo(big=True, onlyFile=True)

            # PRINTSYSLOG MODE #
            if SysMgr.checkMode('printsys'):
                LogMgr.printSyslog(console)

            # PRINTKMSG MODE #
            elif SysMgr.checkMode('printkmsg'):
                LogMgr.printKmsg(console)

            # PRINTJRL MODE #
            elif SysMgr.checkMode('printjrl'):
                LogMgr.printJournal(console)

            # PRINTDLT MODE #
            elif SysMgr.checkMode('printdlt'):
                # to prevent segmentation fault from python3.8 #
                TaskAnalyzer(onlyInstance=True)

                DltAnalyzer.runDltReceiver(mode='print')

        # PRINTSIG MODE #
        elif SysMgr.checkMode('printsig'):
            SysMgr.printLogo(big=True, onlyFile=True)

            SysMgr.doPrintSig()

        # PAGE MODE #
        elif SysMgr.checkMode('mem'):
            SysMgr.printLogo(big=True, onlyFile=True)

            # check input #
            if SysMgr.hasMainArg():
                target = [SysMgr.getMainArg()]
            else:
                target = SysMgr.filterGroup

            PageAnalyzer.getPageInfo(
                target, SysMgr.inputParam)

        # LIMIT MODE #
        elif SysMgr.isLimitMode():
            # change priority for process #
            if not SysMgr.prio:
                SysMgr.setPriority(SysMgr.pid, 'C', -20)

            # get argument #
            if SysMgr.hasMainArg():
                filterGroup = SysMgr.getMainArg().split(',')
            else:
                filterGroup = SysMgr.filterGroup

            if SysMgr.checkMode('limitcpu'):
                limitInfo = SysMgr.getLimitCpuInfo(filterGroup)

                SysMgr.doLimitCpu(
                    limitInfo, SysMgr.processEnable)

        # PSTREE MODE #
        elif SysMgr.checkMode('pstree'):
            SysMgr.doPstree()

        # COMP MODE #
        elif SysMgr.checkMode('comp'):
            try:
                SysMgr.doCompress()
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printErr(
                    'fail to compress', True)

        # DECOMP MODE #
        elif SysMgr.checkMode('decomp'):
            try:
                SysMgr.doDecompress()
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printErr(
                    'fail to decompress', True)

        # PS MODE #
        elif SysMgr.checkMode('systat'):
            SysMgr.doSystat()

        # DRAWTIMELINE MODE #
        elif SysMgr.checkMode('drawtime'):
            SysMgr.doDrawTimeline()

        # CPUTEST MODE #
        elif SysMgr.checkMode('cputest'):
            SysMgr.setStream()

            SysMgr.doCpuTest()

        # IOTEST MODE #
        elif SysMgr.checkMode('iotest'):
            SysMgr.doIoTest()

        # NETTEST MODE #
        elif SysMgr.checkMode('nettest'):
            SysMgr.doNetTest()

        # MEMTEST MODE #
        elif SysMgr.checkMode('memtest'):
            # remove option args #
            SysMgr.removeOptionArgs()

            SysMgr.setStream(cut=False)

            SysMgr.doMemTest()

        # EXEC MODE #
        elif SysMgr.checkMode('exec'):
            SysMgr.doExec()

        # REQUEST MODE #
        elif SysMgr.checkMode('req'):
            SysMgr.setStream()

            SysMgr.doRequest()

        # SETCPU MODE #
        elif SysMgr.checkMode('setcpu'):
            # remove option args #
            SysMgr.removeOptionArgs()

            SysMgr.doSetCpu()

        # SETSCHED MODE #
        elif SysMgr.checkMode('setsched'):
            SysMgr.doSetSched()

        # CONVERT MODE #
        elif SysMgr.checkMode('convert'):
            SysMgr.doConvert()

        # DRAWREQ MODE #
        elif SysMgr.checkMode('drawreq'):
            SysMgr.doDrawReq()

        # STRINGS MODE #
        elif SysMgr.checkMode('strings'):
            SysMgr.setStream(cut=False)

            SysMgr.doStrings()

        # DUMP MODE #
        elif SysMgr.checkMode('dump'):
            SysMgr.doDump()

        # STRACE MODE #
        elif SysMgr.checkMode('strace'):
            if SysMgr.findOption('l'):
                SysMgr.setStream()
                for idx, item in enumerate(ConfigMgr.sysList):
                    if item == 'sys_null':
                        continue
                    elif idx > 0 and idx % 3 == 0:
                        newline = True
                    else:
                        newline = False

                    SysMgr.printPipe(
                        "%3s) %s  " % (idx, item), newline=newline)
                SysMgr.printPipe()
                sys.exit(0)

            SysMgr.doTrace('syscall')

        # UTRACE MODE #
        elif SysMgr.checkMode('utrace'):
            SysMgr.doTrace('usercall')

        # REMOTE MODE #
        elif SysMgr.checkMode('remote'):
            SysMgr.doTrace('remote')

        # HOOK MODE #
        elif SysMgr.checkMode('hook'):
            SysMgr.doTrace('hook')

        # HOOK MODE #
        elif SysMgr.checkMode('printbind'):
            SysMgr.doTrace('bind')

        # BTRACE MODE #
        elif SysMgr.checkMode('btrace'):
            SysMgr.doTrace('breakcall')

        # WATCH MODE #
        elif SysMgr.checkMode('watch'):
            SysMgr.doWatch()

        # SIGTRACE MODE #
        elif SysMgr.checkMode('sigtrace'):
            SysMgr.doTrace('signal')

        # PRINTENV MODE #
        elif SysMgr.checkMode('printenv'):
            SysMgr.doPrintEnv()

        # PRINTNS MODE #
        elif SysMgr.checkMode('printns'):
            SysMgr.doPrintNs()

        # PRINTSVC MODE #
        elif SysMgr.checkMode('printsvc'):
            SysMgr.doPrintSvc()

        # PRINTINFO MODE #
        elif SysMgr.checkMode('printinfo'):
            SysMgr.doPrintInfo()

        # AFFINITY MODE #
        elif SysMgr.checkMode('setafnt'):
            SysMgr.doSetAffinity()

        # AFFINITY MODE #
        elif SysMgr.checkMode('getafnt'):
            SysMgr.doGetAffinity()

        # PING MODE #
        elif SysMgr.checkMode('ping'):
            SysMgr.setStream()
            SysMgr.ping()

        # EVENT MODE #
        elif SysMgr.checkMode('event'):
            SysMgr.handleEventInput()

        else:
            return

        sys.exit(0)



    @staticmethod
    def isLimitMode():
        if SysMgr.checkMode('limitcpu'):
            return True
        else:
            return False



    @staticmethod
    def isDrawAvgMode():
        if SysMgr.checkMode('drawavg', True) or \
            SysMgr.checkMode('drawcpuavg', True) or \
            SysMgr.checkMode('drawmemavg', True) or \
            SysMgr.checkMode('drawvssavg', True) or \
            SysMgr.checkMode('drawrssavg', True):
            return True
        else:
            return False



    @staticmethod
    def isDrawMode():
        orig = SysMgr.drawMode
        SysMgr.drawMode = True

        if len(sys.argv) == 1:
            return False
        elif sys.argv[1] == 'draw' or orig:
            return True
        elif SysMgr.checkMode('drawcpu', True):
            return True
        elif SysMgr.checkMode('drawdelay', True):
            return True
        elif SysMgr.checkMode('drawflame', True):
            return True
        elif SysMgr.checkMode('drawmem', True):
            return True
        elif SysMgr.checkMode('drawvss', True):
            return True
        elif SysMgr.checkMode('drawrss', True):
            return True
        elif SysMgr.checkMode('drawleak', True):
            return True
        elif SysMgr.checkMode('drawio', True):
            return True
        elif SysMgr.checkMode('drawtime', True):
            return True
        elif SysMgr.isDrawAvgMode():
            return True
        else:
            SysMgr.drawMode = orig
            return False



    @staticmethod
    def isPrintLogMode():
        if SysMgr.checkMode('printsys') or \
            SysMgr.checkMode('printkmsg') or \
            SysMgr.checkMode('printjrl') or \
            SysMgr.checkMode('printdlt'):
            return True
        else:
            return False



    @staticmethod
    def checkPerfTopCond():
        if not SysMgr.isRoot():
            SysMgr.printErr(
                "fail to get root permission to use PMU")
            return False
        elif not os.path.isfile('%s/sys/kernel/perf_event_paranoid' % \
            SysMgr.procPath):
            SysMgr.printErr(
                "fail to use PMU, please check kernel config")
            return False
        else:
            return True



    @staticmethod
    def checkMemTopCond():
        if not SysMgr.isRoot():
            SysMgr.printErr(
                "fail to get root permission to analyze memory details")
            return False
        else:
            return True



    @staticmethod
    def checkBgTopCond():
        if SysMgr.outPath:
            return True

        logPath = '/var/log'
        tmpPath = '/tmp'

        if os.path.isdir(logPath) and os.access(logPath, os.W_OK):
            SysMgr.outPath = logPath
            return True
        elif os.path.isdir(tmpPath) and os.access(tmpPath, os.W_OK):
            SysMgr.outPath = tmpPath
            return True
        else:
            SysMgr.printErr(
                "fail to get path to save output, use -o option")
            return False



    @staticmethod
    def checkRepTopCond(val=None):
        # check whether report option is already enabled #
        if SysMgr.reportEnable:
            return True

        if SysMgr.printStreamEnable:
            return True
        else:
            SysMgr.printEnable = False

        if not val:
            reportPath = SysMgr.getOption('j')
        else:
            reportPath = val

        # check report path #
        if not reportPath or not reportPath:
            tmpPath = '/tmp'
            reportPath = tmpPath

        # directory path #
        if os.path.isdir(reportPath) == False:
            upDirPos = reportPath.rfind('/')
            if upDirPos > 0 and \
                not os.path.isdir(reportPath[:upDirPos]):
                SysMgr.printErr(
                    "wrong path '%s' to report stats" % \
                    reportPath)
                return False
        # file path #
        else:
            reportPath = '%s/guider.report' % reportPath

        # remove redundant slashes and save it as the global report path #
        reportPath = os.path.normpath(reportPath)

        # backup a exist output file #
        SysMgr.backupFile(reportPath)

        # open report file #
        try:
            if SysMgr.truncEnable:
                perm = 'w'
            else:
                perm = 'a'

            SysMgr.reportObject = open(reportPath, perm)
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printOpenErr(reportPath)
            sys.exit(0)

        SysMgr.reportEnable = True

        SysMgr.printInfo(
            "start writing JSON format report to %s" % reportPath)

        return True



    @staticmethod
    def checkWssTopCond():
        if not SysMgr.getOption('g'):
            SysMgr.printErr(
                "wrong option for wss monitoring, "
                "use also -g option to track memory working set")
            return False
        elif not SysMgr.isRoot():
            SysMgr.printErr(
                "fail to get root permission to clear refcnts")
            return False
        else:
            return True



    @staticmethod
    def checkDiskTopCond():
        procPath = SysMgr.procPath
        if not SysMgr.isRoot():
            SysMgr.printErr(
                "fail to get root permission to analyze block I/O")
            return False
        elif not os.path.isfile('%s/self/io' % procPath):
            SysMgr.printErr(
                "fail to use bio event, please check kernel config")
            return False
        else:
            return True



    @staticmethod
    def checkStackTopCond():
        if not SysMgr.isRoot():
            SysMgr.printErr(
                "fail to get root permission to sample stack")
            return False
        elif not os.path.isfile('%s/self/stack' % SysMgr.procPath):
            SysMgr.printErr(
                "fail to sample stack, please check kernel config")
            return False
        else:
            return True



    @staticmethod
    def convertCIDR(addr):
        addrList = []
        splitAddr = [addr[i:i+2] for i in range(0, len(addr), 2)]
        for num in reversed(splitAddr):
            addrList.append(str(long(num, base=16)))
        return '.'.join(addrList)



    @staticmethod
    def getSocketPathList(addrList):
        pathList = {}
        inodeIdx = ConfigMgr.UDS_ATTR.index('Inode')
        pathIdx = ConfigMgr.UDS_ATTR.index('Path')

        UDS_ATTR = SysMgr.getUdsList()
        for uds in UDS_ATTR:
            try:
                if uds[inodeIdx] in addrList:
                    pathList[uds[pathIdx]] = None
            except:
                pass

        return list(pathList.keys())



    @staticmethod
    def mountDebugfs(mp=None):
        if not mp:
            mp = SysMgr.debugfsPath

        # check root permission #
        if not SysMgr.isRoot():
            SysMgr.printErr(
                "fail to get root permission to mount debugfs")
            sys.exit(0)

        # mount debugfs #
        SysMgr.mountCmd =\
            "mount -t debugfs nodev %s" % mp
        os.system(SysMgr.mountCmd)

        SysMgr.mountPath = SysMgr.getDebugfsPath()
        if not SysMgr.mountPath:
            SysMgr.printErr(
                "fail to mount debugfs to trace events")
            sys.exit(0)



    @staticmethod
    def handleEventInput():
        # mount debug fs #
        SysMgr.mountPath = SysMgr.getDebugfsPath()
        if not SysMgr.mountPath:
            SysMgr.printWarn(
                "fail to get debugfs mount point", True)

        # get event #
        if SysMgr.hasMainArg():
            event = SysMgr.getMainArg()
        elif SysMgr.inputParam:
            event = SysMgr.inputParam
        else:
            event = None

        # convert pid #
        try:
            target = list(set(list(map(long, SysMgr.filterGroup))))
        except:
            SysMgr.printErr(
                "fail to get pid '%s'" % \
                    ', '.join(SysMgr.filterGroup), True)
            sys.exit(0)

        # oneshot #
        if event:
            SysMgr.writeEvent("EVENT_%s" % event)
            SysMgr.broadcastEvent(event, target)
            return

        while 1:
            SysMgr.printStat(
                "input event name... [ STOP(Ctrl+c) ]")

            try:
                event = sys.stdin.readline()
            except SystemExit:
                sys.exit(0)
            except:
                continue

            if not event.strip():
                SysMgr.writeEvent("EVENT_USER")
                SysMgr.broadcastEvent('EVENT', target)
            else:
                SysMgr.writeEvent("EVENT_%s" % event[:-1])
                SysMgr.broadcastEvent(event[:-1], target)



    @staticmethod
    def getSocketAddrList(addrList):
        portList = {}
        stIdx = ConfigMgr.UDP_ATTR.index('st')
        inodeIdx = ConfigMgr.UDP_ATTR.index('inode')
        addrIdx = ConfigMgr.UDP_ATTR.index('local_address')

        # get udp list #
        udpList = SysMgr.getUdpList()
        for udp in udpList:
            try:
                if udp[inodeIdx] in addrList:
                    ip, port = udp[addrIdx].split(':')

                    # convert ip address and port #
                    ip = SysMgr.convertCIDR(ip)

                    portList["UDP:%s:%s" % (ip, long(port, base=16))] = None
            except:
                pass

        # get tcp list #
        tcpList = SysMgr.getTcpList()
        for tcp in tcpList:
            try:
                if tcp[inodeIdx] in addrList:
                    ip, port = tcp[addrIdx].split(':')

                    # convert ip address and port #
                    ip = SysMgr.convertCIDR(ip)

                    try:
                        stat = '/%s' % \
                            ConfigMgr.TCP_STAT[long(tcp[stIdx], 16)]
                    except:
                        stat = ''

                    item = "TCP:%s:%s%s" % (ip, long(port, base=16), stat)
                    portList[item] = None
            except:
                pass

        return list(portList.keys())



    @staticmethod
    def getProcSocketObjs(pid):
        socketAddrList = []
        fdlistPath = "%s/%s/fd" % (SysMgr.procPath, pid)

        # save file info per process #
        try:
            fdlist = os.listdir(fdlistPath)
        except:
            SysMgr.printOpenWarn(fdlistPath)
            return socketAddrList

        # save fd info of process #
        for fd in fdlist:
            try:
                long(fd)
            except:
                continue

            try:
                # add file info into fdList #
                fdPath = "%s/%s" % (fdlistPath, fd)
                filename = os.readlink(fdPath)

                if filename.startswith('socket'):
                    socketAddrList.append(filename.split('[')[1][:-1])
            except:
                SysMgr.printOpenWarn(fdPath)

        return socketAddrList



    @staticmethod
    def getProcNetAddrs(name):
        if not SysMgr.isLinux or not name:
            return None

        # get pids #
        pids = SysMgr.getProcPids(name)

        # get only Guider server processes #
        if len(pids) > 1 and name == __module__:
            servers = []
            for pid in pids:
                try:
                    cmdline = SysMgr.getCmdline(pid).split()
                    if len(cmdline) > 2 and cmdline[2] == 'server':
                        servers.append(pid)
                except:
                    SysMgr.printWarn(
                        'fail to get cmdline for %s(%s)' % \
                            (pid, SysMgr.getComm(pid, cache=True)), True)
            pids = servers

        # get target network info #
        if len(pids) == 1:
            # get socket objects #
            objs = SysMgr.getProcSocketObjs(pids[0])

            # get bind address #
            addrs = SysMgr.getSocketAddrList(objs)
            if not addrs:
                SysMgr.printWarn(
                    "fail to get socket attribute of server", True)
                return None

            # get server address #
            addr = addrs[0]

            return addr[addr.find(':')+1:]
        elif len(pids) > 1:
            SysMgr.printWarn(
                "Found multiple running %s processes" % name, True)
            SysMgr.printBgProcs(cache=True)
        else:
            SysMgr.printWarn(
                "fail to find %s process" % name, True)

        return None



    @staticmethod
    def getProcPids(name):
        pidList = []
        myPid = str(SysMgr.pid)

        pids = os.listdir(SysMgr.procPath)
        for pid in pids:
            if myPid == pid:
                continue

            try:
                long(pid)
            except:
                continue

            # check comm #
            comm = SysMgr.getComm(pid)
            if comm and comm.startswith(name):
                pidList.append(long(pid))

        return pidList



    @staticmethod
    def getRuntime(isSec=False):
        uptime = long(SysMgr.getUptime())
        runtime = uptime - long(SysMgr.startRunTime)
        if isSec:
            return runtime
        return UtilMgr.convTime(runtime)



    @staticmethod
    def getUptime():
        try:
            SysMgr.uptimeFd.seek(0)
            return float(SysMgr.uptimeFd.readlines()[0].split()[0])
        except:
            try:
                uptimePath = "%s/%s" % (SysMgr.procPath, 'uptime')
                SysMgr.uptimeFd = open(uptimePath, 'r')
                return float(SysMgr.uptimeFd.readlines()[0].split()[0])
            except:
                SysMgr.printOpenWarn(uptimePath)
                return -1



    @staticmethod
    def updateUptime():
        SysMgr.prevUptime = SysMgr.uptime
        SysMgr.uptime = SysMgr.getUptime()
        SysMgr.uptimeDiff = \
            SysMgr.uptime - SysMgr.prevUptime
        return SysMgr.uptime



    @staticmethod
    def broadcastEvent(event, pids=[]):
        if type(event) is not list:
            event = [event]

        # convert event name #
        for idx, item in enumerate(list(event)):
            if not item.startswith('EVENT_'):
                event[idx] = 'EVENT_%s' % item

        if not pids:
            # get pid list of Guider processes #
            pids = SysMgr.getProcPids(__module__)
            if not pids:
                if SysMgr.checkMode('event'):
                    print("\nno running process in the background\n")
                else:
                    SysMgr.printWarn(
                        "failed to find running %s process to send event" % \
                        __module__)
                return []

        # update uptime #
        SysMgr.updateUptime()

        # get socket inode address list of Guider processes #
        for pid in pids:
            # get UDP port list of Guider processes #
            if pid in SysMgr.netAddrCache:
                addrs = SysMgr.netAddrCache[pid]
            else:
                objs = SysMgr.getProcSocketObjs(pid)
                addrs = SysMgr.getSocketAddrList(objs)
                SysMgr.netAddrCache[pid] = addrs

            for addr in addrs:
                try:
                    attr, ip, port = addr.split(':')
                except:
                    SysMgr.printWarn(
                        "failed to use %s as remote address" % (addr))
                    continue

                networkObject = NetworkMgr('client', ip, long(port))
                ip = networkObject.ip
                port = networkObject.port

                if not networkObject.ip or not networkObject.port:
                    SysMgr.printWarn(
                        "failed to use %s:%s as remote address" % (ip, port))
                    continue

                for item in event:
                    try:
                        networkObject.request = item
                        networkObject.send('%s@%s' % (item, SysMgr.uptime))
                        SysMgr.printInfo(
                            "sent event '%s' to %s:%s address of %s process" % \
                                (item, ip, port, pid))
                    except:
                        SysMgr.printWarn((
                            "failed to send event '%s' "
                            "to %s:%s address of %s process") % \
                                (item, ip, port, pid))

        return pids



    @staticmethod
    def updateBgProcs(cache=False):
        if SysMgr.bgProcList and cache:
            return

        SysMgr.bgProcList = SysMgr.getBgProcList()



    @staticmethod
    def checkBgProcs():
        if not SysMgr.isLinux:
            return

        SysMgr.updateBgProcs()

        if SysMgr.bgProcList:
            ppid = os.getppid()
            myComm = SysMgr.getComm(SysMgr.pid)
            parentComm = SysMgr.getComm(ppid)
            if myComm == parentComm:
                bgList = SysMgr.bgProcList.split('\n')
                tempBgList = list(bgList)
                for idx, line in enumerate(tempBgList):
                    if not line:
                        continue
                    pid = long(line.split()[0])
                    if pid == ppid:
                        bgList.pop(idx)
                SysMgr.bgProcList = '\n'.join(bgList)

        if SysMgr.bgProcList:
            SysMgr.printWarn(
                SysMgr.getBgProcString(), True)



    @staticmethod
    def getBgProcCount(cache=False):
        SysMgr.updateBgProcs(cache)

        return SysMgr.bgProcList.count('\n')



    @staticmethod
    def getBgProcString():
        if not SysMgr.bgProcList or \
            not SysMgr.bgProcList:
            return ''

        procList = SysMgr.bgProcList

        bgStr = '\n[Running Process] [TOTAL: %s]\n' % procList.count('\n')
        bgStr = '%s%s\n%7s %7s %7s %8s %5s %12s %s\n%s\n' % \
            (bgStr, twoLine, "PID", "PPID", "COMM",
                "STATE", "RSS", "RUNTIME", "COMMAND", oneLine)
        bgStr = '%s%s%s' % (bgStr, procList, oneLine)

        return bgStr



    @staticmethod
    def printBgProcs(cache=False, pager=False):
        if SysMgr.jsonEnable:
            result = (SysMgr.getBgProcList(isJson=True))
            jsonResult = UtilMgr.convDict2Str(result)
            SysMgr.printPipe(jsonResult)
            return

        SysMgr.updateBgProcs(cache)

        procList = SysMgr.bgProcList

        if procList == '':
            SysMgr.printPipe(
                "\nno running process in the background\n", pager=False)
        else:
            SysMgr.printPipe(SysMgr.getBgProcString(), pager=False)



    @staticmethod
    def getPids(
        name, isThread=True, sibling=False,
        main=False, inc=False, cache=False):

        pidList = []

        # tid #
        if UtilMgr.isNumber(name) and \
            os.path.isdir('%s/%s' % (SysMgr.procPath, name)):
            if sibling:
                path = '%s/%s/task' % (SysMgr.procPath, name)
                pids = os.listdir(path)
                for pid in pids:
                    if pid.isdigit():
                        pidList.append(pid)
                return pidList
            elif main:
                return list(set([name, SysMgr.getTgid(name)]))
            else:
                return [name]

        # comm #
        pids = os.listdir(SysMgr.procPath)
        for pid in pids:
            if not pid.isdigit():
                continue

            # process #
            if not isThread:
                # get comm #
                comm = SysMgr.getComm(pid, cache)
                if (not inc and comm == name) or \
                    (inc and name in comm):
                    pidList.append(pid)
                continue

            # thread #
            try:
                threadPath = "%s/%s/task" % (SysMgr.procPath, pid)
                tids = os.listdir(threadPath)
            except:
                continue

            for tid in tids:
                if not tid.isdigit():
                    continue

                # get comm #
                comm = SysMgr.getComm(tid)
                if (not inc and comm != name) or \
                    (inc and not name in comm):
                    continue

                # include all siblings #
                if sibling:
                    pidList += tids
                    break

                # include the main thread #
                if main:
                    pidList.append(pid)

                # include a thread #
                pidList.append(tid)

        return list(set(pidList))



    @staticmethod
    def getBgProcList(checkCmdline=False, isJson=False):
        printBuf = ''
        printDict = {}
        myPid = str(SysMgr.pid)
        gstatList = ConfigMgr.STAT_ATTR
        commIdx = ConfigMgr.STAT_ATTR.index("COMM")

        # update uptime #
        SysMgr.updateUptime()

        # get my comm #
        myComm = SysMgr.getComm(SysMgr.pid)

        # get my cmdline #
        myCmdline = SysMgr.getCmdline(SysMgr.pid, True)

        pids = os.listdir(SysMgr.procPath)
        for pid in pids:
            if myPid == pid or not pid.isdigit():
                continue

            # check comm #
            comm = SysMgr.getComm(pid)
            if not comm or not comm.startswith(myComm):
                continue

            # check cmdline again #
            if myComm != __module__ and checkCmdline:
                cmdlineList = SysMgr.getCmdline(pid, True)
                if len(cmdlineList) > 2 and myCmdline[:2] != cmdlineList[:2]:
                    continue

            runtime = '?'

            # comm #
            try:
                statPath = "%s/%s/stat" % (SysMgr.procPath, pid)
                with open(statPath, 'r') as fd:
                    statList = fd.read().split()

                statList = SysMgr.mergeCommStat(statList, commIdx)

                # runtime #
                procStart = \
                    float(statList[gstatList.index("STARTTIME")]) / 100
                runtime = long(SysMgr.uptime - procStart)

                # ppid #
                ppid = statList[gstatList.index("PPID")]

                # state #
                try:
                    state = ConfigMgr.PROC_STAT_TYPE[\
                        statList[gstatList.index("STATE")]]
                except:
                    state = 'N/A'

                # rss #
                rss = long(statList[gstatList.index("RSS")])
                rss = UtilMgr.convSize2Unit(rss << 12, True)
            except:
                pass

            # runtime #
            if runtime != '?':
                runtime = UtilMgr.convTime(runtime)

            # socket #
            try:
                objs = SysMgr.getProcSocketObjs(pid)
                addrs = SysMgr.getSocketAddrList(objs)

                # merge address #
                netDict = {}
                for item in addrs:
                    ret = item.split('/')
                    if len(ret) == 2:
                        addr, stat = ret
                    else:
                        addr = ret[0]
                        stat = None

                    if not addr in netDict:
                        netDict[addr] = list()

                    if stat:
                        netDict[addr].append(stat)

                # build string #
                netList = ''
                for addr, stat in netDict.items():
                    if stat:
                        netList = '%s%s/%s,' % (netList, addr, '/'.join(stat))
                    else:
                        netList = '%s%s,' % (netList, addr)
                if len(netList) > 0:
                    network = '(%s)' % netList[:-1]
                else:
                    network = ''
            except:
                network = ''

            # cmdline #
            try:
                cmdline = SysMgr.getCmdline(pid)
            except:
                cmdline = '?'

            # build #
            if isJson:
                printDict[pid] = {
                    'comm': comm,
                    'ppid': ppid,
                    'state': state,
                    'rss': rss,
                    'runtime': runtime,
                    'cmdline': cmdline,
                    'network': network
                }
            else:
                printBuf = '%s%7s %7s %7s %8s %5s %12s %s %s\n' % \
                    (printBuf, pid, ppid, comm,
                        state, rss, runtime, cmdline, network)

        if isJson:
            return printDict
        else:
            return printBuf



    @staticmethod
    def waitUserInput(wait=0, msg=None, newline=True, force=False):
        # check condition #
        if force:
            pass
        elif SysMgr.outPath or \
            SysMgr.bgStatus or \
            not sys.stdin or \
            SysMgr.checkMode('rtop') or \
            SysMgr.checkMode('btop') or \
            not SysMgr.selectEnable or \
            'REMOTERUN' in os.environ:
            return

        # get select object #
        selectObj = SysMgr.getPkg('select', False)
        if not selectObj:
            SysMgr.selectEnable = False
            return

        # set default message #
        if not msg:
            if SysMgr.idList:
                msg = "input a task index... ( Help / Quit)"
            else:
                msg = "input a command... ( Help / Quit )"

        # wait for user input #
        try:
            SysMgr.inWaitStatus = True

            if newline:
                suffix = '\n'
            else:
                suffix = ''

            # there was user input #
            if selectObj.select(
                [sys.stdin], [], [], wait) == ([sys.stdin], [], []):
                sys.stdout.write('\b' * SysMgr.ttyCols)
                sys.stdout.write(msg + suffix)
                sys.stdout.flush()

                # flush buffered enter key #
                sys.stdin.readline()

                sys.stdout.write('=> ')
                sys.stdout.flush()

                # process user input #
                SysMgr.procUserInput(sys.stdin.readline())
            elif wait == 0:
                sys.stdout.write(msg + suffix)
                sys.stdout.flush()
                if force:
                    SysMgr.waitEvent()
                else:
                    sys.stdin.readline()
                    sys.stdout.write("\033[F")
        except SystemExit:
            sys.exit(0)
        except IOError:
            SysMgr.printWarn("fail to read user input", reason=True)
            sys.stdin = None
        except:
            SysMgr.printWarn("fail to read user input", reason=True)
        finally:
            SysMgr.inWaitStatus = False

        return True



    @staticmethod
    def procUserInput(uinput):
        def _printHelp():
            SysMgr.printPipe(
'''
[Filter]   {COMM|PID}
  exam) f init, 1234

[Sched]    {SCHED:PRIO:COMM|PID}
  exam) s r:1:123, c:-1:1234

[Kill]     {-SIGNAL} {COMM|PID}
  exam) k -stop 123, a.out

[Affinity] {MASK} {COMM|PID}
  exam) a 1f 123, a.out

[Sort]     {VAL}
  exam) S p

[Option]   {VAL}
  exam) o -e bs -g task

[Run]      {COMMAND}
  exam) r utop a.out
  exam) r btrace a.out
            ''')

            # wait for enter #
            SysMgr.printPipe("input ENTER to continue...")
            sys.stdin.readline()

        ulist = uinput.split()
        if not ulist:
            return

        # hotkey #
        if SysMgr.idList and ulist[0].isdigit():
            try:
                pid = SysMgr.idList[long(ulist[0])]
            except:
                return

            SysMgr.executeCommand(pid=pid)
            return

        # help #
        if ulist[0].upper() == 'HELP' or \
            ulist[0].upper() == 'H':
            _printHelp()
        # kill #
        elif ulist[0].upper() == 'KILL' or \
            ulist[0] == 'k':
            if len(ulist) > 1:
                SysMgr.sendSignalArgs(ulist[1:])
            else:
                _printHelp()
        # sched #
        elif ulist[0].upper() == 'SCHED' or \
            ulist[0] == 's':
            if len(ulist) > 1:
                SysMgr.applyPriority((' '.join(ulist[1:])))
            else:
                _printHelp()
        # sort #
        elif ulist[0].upper() == 'SORT' or \
            ulist[0] == 'S':
            if len(ulist) > 1:
                SysMgr.setSortValue(ulist[1])
            else:
                _printHelp()
        # affinity #
        elif ulist[0].upper() == 'AFFINITY' or \
            ulist[0] == 'a':
            if len(ulist) > 2:
                pids = (' '.join(ulist[2:])).split(',')
                pids = SysMgr.convPidList(pids, isThread=True)
                SysMgr.setAffinity(ulist[1], pids)
            else:
                _printHelp()
        # filter #
        elif ulist[0].upper() == 'FILTER' or ulist[0] == 'f':
            if len(ulist) == 1:
                SysMgr.filterGroup = []
            else:
                SysMgr.filterGroup = (' '.join(ulist[1:])).split(',')

            SysMgr.filterGroup = \
                UtilMgr.cleanItem(SysMgr.filterGroup)

            if SysMgr.isThreadMode():
                mode = 'threads'
            else:
                mode = 'processes'

            SysMgr.printInfo(
                "only specific %s [ %s ] are shown" % \
                (mode, ', '.join(SysMgr.filterGroup)))
        # option #
        elif ulist[0].upper() == 'OPTION' or \
            ulist[0] == 'o':
            if len(ulist) > 1:
                SysMgr.parseAnalOption(uinput[1:].strip())
            else:
                _printHelp()
        # run #
        elif ulist[0].upper() == 'RUN' or \
            ulist[0] == 'r':
            if len(ulist) > 1:
                cmd = SysMgr.getExeCmd(SysMgr.pid)
                cmd.extend(ulist[1:])

                # launch new command #
                pid = SysMgr.createProcess(cmd)
                if pid < 0:
                    sys.exit(0)

                # ignore signals and wait for child #
                SysMgr.setIgnoreSignal()
                os.wait()
                SysMgr.setNormalSignal()
            else:
                _printHelp()
        # quit #
        elif ulist[0].upper() == 'QUIT' or \
            ulist[0].upper() == 'Q':
            sys.exit(0)

        '''
        SysMgr.printPipe("input ENTER to continue...")
        sys.stdin.readline()
        '''



    @staticmethod
    def getLimitCpuInfo(limitInfo):
        SysMgr.checkRootPerm()

        if not limitInfo:
            SysMgr.printErr("no input value for task limit info")
            sys.exit(0)

        limitList = {}
        try:
            for item in limitInfo:
                (tid,per) = item.split(':')

                # get id for tasks #
                if tid.isdigit():
                    limitList[tid] = long(per)
                else:
                    tidList = SysMgr.getPids(tid)
                    for tid in tidList:
                        limitList[tid] = long(per)
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printErr("wrong input value for task limit info", True)
            sys.exit(0)

        return limitList



    @staticmethod
    def ignoreWarn():
        try:
            import warnings
            warnings.simplefilter("ignore", UserWarning)
        except:
            pass



    @staticmethod
    def executeCommand(cmds=None, pid=None, comm=None):
        if not cmds:
            cmds = SysMgr.customCmd

        # execute command #
        for cmd in cmds:
            # convert PID #
            if pid:
                cmd = cmd.replace('PID', pid)

            # convert COMM #
            if comm:
                cmd = cmd.replace('COMM', comm)

            # convert TIME #
            cmd = cmd.replace('TIME', str(SysMgr.uptime))

            SysMgr.printInfo("executed '%s'" % cmd)

            # launch Guider #
            if cmd.startswith('GUIDER '):
                # build command list #
                cmdList = SysMgr.splitOptionString(cmd.lstrip('GUIDER '))

                # launch command #
                try:
                    ret = SysMgr.launchGuider(
                        cmdList, pipe=False, stderr=True,
                        stream=False, logo=False, log=True)
                except SystemExit:
                    sys.exit(0)
                except:
                    ret = False
                    SysMgr.printErr(
                        "fail to launch %s" % __module__, reason=True)
            # launch command #
            else:
                ret = SysMgr.createProcess(cmd.split())

            # check return #
            if ret < 0:
                continue

            # ignore signals and wait for child #
            SysMgr.setIgnoreSignal()
            os.wait()
            SysMgr.setNormalSignal()



    @staticmethod
    def getEnvList():
        def applyList(myEnv, envList):
            for env in envList:
                var = env.split('=', 1)
                if len(var) > 1:
                    myEnv[var[0]] = var[1].rstrip()

        try:
            # copy original variables #
            myEnv = deepcopy(os.environ)
            if not 'ENV' in SysMgr.environList and \
                not 'ENVFILE' in SysMgr.environList:
                return myEnv

            # parse new variables #
            if 'ENV' in SysMgr.environList:
                envList = SysMgr.environList['ENV']
            else:
                envList = []
            applyList(myEnv, envList)

            # parse new variables from file #
            if 'ENVFILE' in SysMgr.environList:
                envFileList = SysMgr.environList['ENVFILE']
            else:
                envFileList = []

            # read variables from files #
            for fname in envFileList:
                try:
                    with open(fname, 'r') as fd:
                        envList = fd.readlines()
                        applyList(myEnv, envList)
                except:
                    SysMgr.printErr(
                        'fail to parse environment variable from %s' % \
                            fname, True)
                    sys.exit(0)

            return myEnv
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printErr(
                'fail to parse enviroment variable', reason=True)
            return None



    @staticmethod
    def executeProcess(cmd=None, mute=False, closeFd=True, resetPri=False):
        # get new environ variables #
        env = SysMgr.getEnvList()

        # reset priority #
        if resetPri:
            SysMgr.setPriority(SysMgr.pid, 'C', 0)

        # exec #
        try:
            SysMgr.resetFileTable(mute, closeFd)

            os.execvpe(cmd[0], cmd, env)
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printErr(
                "fail to execute '%s'" % ' '.join(cmd), True)
            return -1



    @staticmethod
    def initEnvironment():
        # save original args #
        SysMgr.origArgs = deepcopy(sys.argv)

        # register exit handler #
        atexit.register(SysMgr.doExit)

        # print logo #
        SysMgr.printLogo(big=True, pager=False)

        # increase stack depth #
        sys.setrecursionlimit(2000)

        # check environment #
        SysMgr.checkEnv()

        # print help #
        SysMgr.printHelp()

        # set default io #
        SysMgr.inputFile = sys.argv[1]
        SysMgr.outputFile = None

        # check log level #
        SysMgr.warnEnable = SysMgr.findOption('v')

        # set error logger #
        SysMgr.setErrorLogger()

        # import Guider native module #
        SysMgr.importNative()

        # create shared memory #
        SysMgr.shmObj = SysMgr.createShm()

        # set oom_adj #
        SysMgr.setOOMAdj()

        # set pid #
        SysMgr.getMaxPid()
        SysMgr.pid = os.getpid()

        # set comm #
        SysMgr.setComm(__module__)
        SysMgr.comm = SysMgr.getComm(SysMgr.pid)

        # set arch #
        SysMgr.setArch(SysMgr.getArch())

        # set default signal #
        SysMgr.setSimpleSignal()

        # reset terminal #
        SysMgr.resetTTY()

        # shrink heap #
        SysMgr.shrinkHeap()



    @staticmethod
    def getOutput(fd, retLine=False, progress=False):
        # get select object #
        selectObj = SysMgr.getPkg('select')

        output = ''

        while 1:
            # wait for event #
            [read, write, error] = \
                selectObj.select([fd], [], [])

            if progress:
                UtilMgr.printProgress()

            if read:
                line = read[0].readline()
                if retLine:
                    return line
                elif line == '':
                    return output

                output = '%s%s' % (output, line)



    @staticmethod
    def launchGuider(
        cmd, log=False, mute=False, pipe=True, stderr=False,
        wait=False, stream=True, logo=True):
        '''
        - desc: launch a new Guider process as a child
        - pros: save memory such as ELF caches
        - pros: control Guider functions such as logo, stdio
        '''

        # check mute #
        if mute:
            pipe = False

        # create pipe #
        if pipe:
            rd, wr = os.pipe()

            # set SIGPIPE handler #
            SysMgr.setPipeHandler()
        else:
            rd = wr = None

        # create a new process #
        pid = SysMgr.createProcess(mute=mute)

        # parent #
        if pid > 0:
            if pipe:
                os.close(wr)
                rdFd = os.fdopen(rd, 'r')
            else:
                rdFd = None

            # wait for child temrination #
            if wait:
                SysMgr.waitChild(pid)
                return pid

            if pipe:
                return (pid, rdFd)
            else:
                return pid

        # child #
        elif pid == 0:
            # set main environment #
            os.environ["ISMAIN"] = "True"

            # reinitialize static variables #
            #globals().update(vars(SysMgr))

            # disable pager, print output both to file and to stdout #
            if stream:
                SysMgr.setStream()
            SysMgr.inputFile = None
            SysMgr.outPath = None
            SysMgr.printFd = None
            SysMgr.printEnable = True
            SysMgr.encodeEnable = False
            SysMgr.reportEnable = SysMgr.jsonEnable = False

            # inherit enable and disable option value #
            disOptVal = SysMgr.getOption('d')
            enOptVal = SysMgr.getOption('e')
            if disOptVal or enOptVal:
                applyDisable = False
                applyEnable = False

                # append option values #
                for idx, val in enumerate(cmd):
                    if val.startswith('-d'):
                        cmd[idx] = val + disOptVal
                        applyDisable = True
                    elif val.startswith('-e'):
                        cmd[idx] = val + enOptVal
                        applyEnable = True

                # append option #
                if disOptVal and not applyDisable:
                    cmd.append('-d %s' % disOptVal)
                if enOptVal and not applyEnable:
                    cmd.append('-e %s' % enOptVal)

            # disable logo #
            if not logo:
                SysMgr.logoEnable = False

            # disable logs #
            if not log:
                SysMgr.logEnable = False

            # change standard I/O #
            if pipe:
                os.dup2(wr,1)
                os.close(wr)
                os.close(rd)

            # close stderr #
            if not stderr:
                sys.stderr.close()

            # initialize variables #
            SysMgr.parsedAnalOption = False
            SysMgr.optionList = []
            ConfigMgr.confData = {}
            SysMgr.thresholdData = {}
            SysMgr.procBuffer = []
            SysMgr.clearPrint()
            SysMgr.groupProcEnable = False

            # launch Guider command #
            main(cmd)

            sys.exit(0)

        # error #
        else:
            SysMgr.printErr(
                "fail to launch Guider because of fork fail")
            return -1



    @staticmethod
    def executeCommandRes(cmd, stdout=1, stderr=True):
        # create pipe #
        rd, wr = os.pipe()

        # set SIGPIPE handler #
        SysMgr.setPipeHandler()

        # create a new process #
        pid = SysMgr.createProcess()

        # parent #
        if pid > 0:
            os.close(wr)
            rdFd = os.fdopen(rd, 'r')
            output = []

            while 1:
                ret = rdFd.readline().rstrip('\n')
                if not ret:
                    break
                output.append(ret)

            return output

        # child #
        elif pid == 0:
            # change standard I/O #
            os.dup2(wr, stdout)
            os.close(wr)
            os.close(rd)

            # close stderr #
            if not stderr:
                sys.stderr.close()

            if type(cmd) is str:
                cmd = cmd.split()

            # execute #
            SysMgr.executeProcess(cmd=cmd)

            sys.exit(0)

        # error #
        else:
            SysMgr.printErr(
                "fail to execute %s because of fork failure" % cmd)
            return -1



    @staticmethod
    def waitChild(pid=None, hang=True):
        # wait for all childs #
        if not pid:
            while 1:
                try:
                    os.waitpid(-1, 0)
                except:
                    pass

                if SysMgr.condExit:
                    break

                # check childs #
                SysMgr.updateChildList()
                if SysMgr.isNoChild():
                    break
            return

        # set blocking flag #
        if hang:
            flag = 0
        else:
            flag = os.WNOHANG

        # wait for a specific child #
        try:
            return os.waitpid(pid, flag)
        except SystemExit:
            sys.exit(0)
        except:
            SysMgr.printWarn(
                "fail to wait %s task" % pid, reason=True)



    @staticmethod
    def spawnProcess(func, args, cnt=1, wait=True):
        multiprocessing = SysMgr.getPkg('multiprocessing')
        plist = []
        for seq in range(0, cnt):
            try:
                p = multiprocessing.Process(target=func, args=args)
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printErr(
                    'fail to create a new process', reason=True)
                continue
            p.start()
            plist.append(p)

        if wait:
            for p in plist:
                p.join()



    @staticmethod
    def createProcess(
        cmd=None, isDaemon=False, mute=False, chPgid=False, chMid=False):
        # flush print buffer before fork #
        SysMgr.flushAllForPrint()

        # create a new process #
        pid = os.fork()

        # parent #
        if pid > 0:
            if not isDaemon:
                SysMgr.childList[pid] = True

            return pid
        # child #
        elif pid == 0:
            # update parent PID #
            SysMgr.parentPid = SysMgr.pid

            # initialize child list #
            SysMgr.clearChildList()

            if chPgid:
                os.setpgid(0, 0)

            # close fd for output #
            try:
                SysMgr.printFd.close()
            except SystemExit:
                sys.exit(0)
            except:
                pass
            finally:
                SysMgr.printFd = None

            # Guider #
            if not cmd:
                # update master pid #
                if chMid:
                    SysMgr.masterPid = SysMgr.pid

                # update pid #
                SysMgr.fileSuffix = SysMgr.pid = os.getpid()

                if mute:
                    SysMgr.closeStdFd(stderr=False)

                return 0

            # split command #
            if UtilMgr.isString(cmd):
                cmd = cmd.split()

            # convert ~ to realpath #
            cmd[0] = os.path.expanduser(cmd[0])

            # execute #
            SysMgr.executeProcess(cmd, mute)

            # execute fail #
            os._exit(0)
        # fail #
        else:
            SysMgr.printErr(
                "fail to create process")
            return -1



    @staticmethod
    def closeStdFd(stdin=False, stdout=True, stderr=True):
        if not SysMgr.nullFd:
            SysMgr.nullFd = open(SysMgr.nullPath, 'w')

        # get null fd #
        nullFd = SysMgr.nullFd.fileno()

        # redirect stds to null #
        if stdin:
            os.dup2(nullFd, sys.stdin.fileno())
        if stdout:
            os.dup2(nullFd, sys.stdout.fileno())
        if stderr:
            os.dup2(nullFd, sys.stderr.fileno())



    @staticmethod
    def resetFileTable(mute=True, closeFd=True):
        # redirect stdout and stderr to null #
        if mute:
            try:
                SysMgr.closeStdFd(stderr=False)
            except SystemExit:
                sys.exit(0)
            except:
                pass

        # close all fds without standard #
        if closeFd:
            try:
                path = '%s/self/fd' % SysMgr.procPath
                fdList = os.listdir(path)
            except SystemExit:
                sys.exit(0)
            except:
                SysMgr.printErr(
                    "fail to read file descriptors in %s" % path, reason=True)
                return

            for fd in fdList:
                try:
                    fd = long(fd)
                    if fd > 2:
                        os.close(fd)
                except SystemExit:
                    sys.exit(0)
                except:
                    pass



    @staticmethod
    def runBackgroundMode():
        pid = SysMgr.createProcess(isDaemon=True)

        if pid > 0:
            # wait a minute for child message #
            time.sleep(0.1)

            # terminate parent process #
            sys.exit(0)
        else:
            SysMgr.bgStatus = True

            # continue child process #
            SysMgr.printStat(
                "run %s(%s) in background" % \
                    (SysMgr.getComm(SysMgr.pid), SysMgr.pid))



    @staticmethod
    def setDefaultSignal():
        if not SysMgr.isLinux:
            return

        signal.signal(signal.SIGINT, signal.SIG_DFL)
        signal.signal(signal.SIGQUIT, signal.SIG_DFL)
        signal.signal(signal.SIGCHLD, signal.SIG_DFL)
        signal.signal(signal.SIGPIPE, signal.SIG_DFL)



    @staticmethod
    def setSimpleSignal():
        if not SysMgr.isLinux:
            return

        SysMgr.setCommonSignal()

        signal.signal(signal.SIGINT, SysMgr.exitHandler)
        signal.signal(signal.SIGQUIT, SysMgr.exitHandler)
        signal.signal(signal.SIGPIPE, signal.SIG_IGN)
        signal.signal(signal.SIGHUP, signal.SIG_IGN)



    @staticmethod
    def setPipeHandler():
        if not SysMgr.isLinux:
            return

        signal.signal(signal.SIGPIPE, SysMgr.exitHandler)



    @staticmethod
    def setCommonSignal():
        if not SysMgr.isLinux:
            return

        signal.signal(signal.SIGCHLD, SysMgr.chldHandler)
        signal.signal(signal.SIGWINCH, SysMgr.winchHandler)
        signal.signal(signal.SIGCONT, SysMgr.fgHandler)
        signal.signal(signal.SIGTSTP, SysMgr.bgHandler)
        signal.signal(signal.SIGTTIN, SysMgr.bgHandler)
        signal.signal(signal.SIGTTOU, signal.SIG_IGN)
        signal.signal(signal.SIGUSR1, SysMgr.defaultHandler)
        signal.signal(signal.SIGUSR2, SysMgr.defaultHandler)



    @staticmethod
    def setIgnoreSignal():
        if not SysMgr.isLinux:
            return

        signal.signal(signal.SIGALRM, signal.SIG_IGN)
        signal.signal(signal.SIGINT, signal.SIG_IGN)
        signal.signal(signal.SIGQUIT, signal.SIG_IGN)
        signal.signal(signal.SIGPIPE, signal.SIG_IGN)



    @staticmethod
    def blockSignal(sig=None, act='block', wait=False):
        # load libc #
        if not SysMgr.libcObj:
            if not SysMgr.loadLibcObj():
                return False

        # set default signal #
        if not sig:
            sig = signal.SIGINT

        if not SysMgr.sigsetObj:
            NWORDS = long(1024 / (8 * sizeof(c_uint)))

            class sigset_t(Structure):
                _fields_ = [
                    ('__sigbits', c_uint * NWORDS),
                ]

            SysMgr.sigsetObj = sigset_t()
            SysMgr.sigsetOldObj = sigset_t()

        sigset = SysMgr.sigsetObj
        sigsetold = SysMgr.sigsetOldObj

        # check act #
        if act == 'block':
            atype = SIG_BLOCK = 0
        elif act == 'unblock':
            atype = SIG_UNBLOCK = 1
        else:
            SysMgr.printErr(
                "no supported '%s' for blocking signal" % act)
            return

        SysMgr.libcObj.memset(
            byref(sigset), 0, sizeof(sigset))

        if type(sig) is not list:
            sig = [sig]

        for sigbit in sig:
            if hasattr(SysMgr.libcObj, 'sigaddset'):
                SysMgr.libcObj.sigaddset(byref(sigset), sigbit)

        SysMgr.libcObj.sigprocmask(atype, byref(sigset), byref(sigsetold))

        if wait:
            if hasattr(SysMgr.libcObj, 'sigsuspend'):
                SysMgr.libcObj.sigsuspend(byref(sigsetold))

        return True



    @staticmethod
    def pendingSignal(sig):
        # load libc #
        if not SysMgr.libcObj and not SysMgr.loadLibcObj():
            return False
        elif not SysMgr.sigsetObj:
            return False

        sigset = SysMgr.sigsetObj

        # get pending list #
        SysMgr.libcObj.sigpending(byref(sigset))

        if type(sig) is not list:
            sig = [sig]

        pendList = []
        for item in sig:
            if SysMgr.libcObj.sigismember(byref(sigset), item):
                pendList.append(item)

        return set(list(pendList))



    @staticmethod
    def setNormalSignal():
        if not SysMgr.isLinux:
            return

        SysMgr.setCommonSignal()

        signal.signal(signal.SIGALRM, SysMgr.alarmHandler)
        signal.signal(signal.SIGINT, SysMgr.stopHandler)
        signal.signal(signal.SIGQUIT, SysMgr.newHandler)
        signal.signal(signal.SIGPIPE, signal.SIG_IGN)



    @staticmethod
    def runServerMode():
        nodeList = {}

        def _sendErrMsg(netObj, message):
            message = 'ERROR|%s:%s:%s' % \
                (message, netObj.ip, netObj.port)
            netObj.send(message)

        def _onDownload(netObj, value, response):
            # pick path #
            try:
                files = UtilMgr.cleanItem(value.split('@', 1), False)
                if len(files) == 2:
                    src, des = files
                    if src and not des:
                        des = src
                    elif not src:
                        raise Exception()
                else:
                    src = des = files[0]
            except:
                SysMgr.printWarn(
                    'failed to recognize %s' % value, True)
                _sendErrMsg(netObj,
                    "wrong format for path, input in the format {SRC@DES}")
                return

            # verify path #
            targetPath = src
            if not os.path.isfile(targetPath):
                SysMgr.printWarn(
                    'failed to find %s to transfer' % targetPath, True)
                _sendErrMsg(netObj, "wrong path '%s'" % targetPath)
                return

            # response from command request #
            netObj.send(response)

            remotePath = des
            addr = '%s:%s' % (netObj.ip, netObj.port)

            # transfer file #
            try:
                # send file size #
                stat = os.stat(targetPath)
                st_size = '%s' % stat.st_size
                netObj.send(UtilMgr.encodeStr(st_size))

                # read for ACK #
                while 1:
                    ret = netObj.recv(3)
                    if ret is None:
                        continue
                    elif ret is False:
                        sys.exit(0)
                    else:
                        break

                # send file #
                with open(targetPath, 'rb') as fd:
                    buf = fd.read(netObj.sendSize)
                    while (buf):
                        netObj.send(buf)
                        buf = fd.read(netObj.sendSize)

                SysMgr.printInfo(
                    "uploaded %s [%s] to %s:%s successfully" % \
                        (targetPath, UtilMgr.getFileSize(targetPath),
                            addr, remotePath))
            except:
                SysMgr.printErr(
                    "fail to upload %s to %s in %s" % \
                    (targetPath, remotePath, addr), True)
            finally:
                netObj.close()

        def _onUpload(netObj, value, response):
            try:
                files = UtilMgr.cleanItem(value.split('@', 1), False)
                if len(files) == 2:
                    src, des = files
                    if src and not des:
                        des = src
                    elif not src:
                        raise Exception()
                else:
                    src = des = files[0]
            except:
                SysMgr.printWarn(
                    'failed to recognize %s' % value, True)
                _sendErrMsg(netObj,
                    "wrong format for path, input in the format {SRC@DES}")
                return

            # response from command request #
            netObj.send(response)

            # get select object #
            selectObj = SysMgr.getPkg('select')

            # get connection info #
            addr = '%s:%s' % (netObj.ip, netObj.port)

            # receive file #
            try:
                curSize = long(0)
                totalSize = None
                origPath = src
                targetPath = des

                # receive file size #
                while 1:
                    size = netObj.recv(netObj.recvSize)
                    if not size:
                        continue
                    else:
                        totalSize = long(size.decode())
                        netObj.send('ACK')
                        break

                # receive file #
                with open(targetPath, 'wb') as fd:
                    while 1:
                        [read, write, error] = \
                            selectObj.select([netObj.socket], [], [], 3)

                        buf = netObj.recv(netObj.recvSize)
                        if buf:
                            fd.write(buf)
                            curSize += len(buf)
                        else:
                            break

                        #UtilMgr.printProgress(curSize, totalSize)

                SysMgr.printInfo(
                    "downloaded %s [%s] from %s:%s successfully" % \
                    (targetPath, UtilMgr.getFileSize(targetPath),
                        addr, origPath))
            except:
                SysMgr.printErr(
                    'fail to download %s from %s in %s' % \
                        (origPath, targetPath, addr), True)
            finally:
                netObj.close()

        def _updateNodeList(ret=False):
            for addr in list(nodeList.keys()):
                ret = NetworkMgr.requestPing(addr, verb=False)
                if not ret:
                    try:
                        nodeList[addr]['sock'].close()
                    except:
                        pass
                    finally:
                        nodeList.pop(addr, None)

            # print node list #
            idx = 0
            current = time.time()
            listStr = '[Service Node List]\n%s\n' % twoLine
            listStr += '{0:^5} {1:^25} {2:^10}\n{3:1}\n'.format(
                'Idx', 'Addr', 'Time', oneLine)
            for addr, value in sorted(
                nodeList.items(), key=lambda e:e[1]['time']):
                diff = current - value['time']
                listStr += '[{0:>3}] {1:>25} {2:>10}\n'.format(
                    idx, addr, UtilMgr.convTime(diff))
                idx += 1
            if nodeList:
                listStr += '%s\n' % oneLine
            else:
                listStr += '\tNone\n%s\n' % oneLine
            SysMgr.printWarn(listStr, True)

            if ret:
                return listStr

        def _onNew(connObj, value, response):
            try:
                # reply message #
                connObj.send('PONG')

                # register node info #
                if not value in nodeList or \
                    nodeList[value]['sock'] != connObj:
                    nodeList[value] = \
                        {'sock': connObj, 'time': time.time()}

                SysMgr.printInfo(
                    "registered the service node(%s) successfully" %  value)

                # update service node list #
                _updateNodeList()
            except:
                SysMgr.printWarn(
                    'fail to register the service node(%s)' % value,
                    reason=True)

        def _onList(connObj, value, response):
            try:
                # update service node list #
                ret = _updateNodeList(ret=True)
                connObj.send('LIST:' + ret.strip())
            except:
                pass

        def _onPing(connObj, value, response):
            try:
                connObj.send('PONG')
            except:
                pass

        def _onRun(connObj, value, response):
            def _enableSigPipe():
                signal.signal(signal.SIGPIPE, signal.SIG_DFL)

            # response from command request #
            connObj.send(response)

            # get subprocess object #
            subprocess = SysMgr.getPkg('subprocess')

            # get connection info #
            addr = '%s:%s' % (connObj.ip, connObj.port)

            # convert Guider path #
            if value.startswith('GUIDER '):
                cmd = ' '.join(value.split()[1:])
                path = ' '.join(SysMgr.getExeCmd(SysMgr.pid))
                value = '%s %s' % (path, cmd)

            # run command #
            try:
                # copy environment variables #
                myEnv = deepcopy(os.environ)
                myEnv["REMOTERUN"] = "True"

                # set SIGCHLD #
                signal.signal(signal.SIGCHLD, signal.SIG_DFL)

                # set print flag #
                printFlag = SysMgr.getPrintFlag()
                if printFlag:
                    procOut = subprocess.PIPE
                else:
                    procOut = open(SysMgr.nullPath, 'wb')

                # create process to communicate #
                procObj = subprocess.Popen(
                    value, shell=True, stdout=procOut,
                    stderr=procOut, env=myEnv, bufsize=0,
                    preexec_fn=os.setsid)

                SysMgr.printInfo(
                    "executed '%s' for %s" % (value, addr))

                # get select object #
                selectObj = SysMgr.getPkg('select')

                # set fds #
                listenFds = []
                if procObj.stdout:
                    listenFds.append(procObj.stdout)
                if procObj.stderr:
                    listenFds.append(procObj.stderr)
                if connObj.socket:
                    listenFds.append(connObj.socket)

                # get io buffer size #
                if 'READCHUNK' in SysMgr.environList:
                    try:
                        readChunkSize = \
                            long(SysMgr.environList['READCHUNK'][0])
                    except:
                        pass
                else:
                    readChunkSize = None

                # run mainloop #
                while 1:
                    try:
                        # wait for event #
                        [read, write, error] = \
                            selectObj.select(listenFds, [], [], 1)

                        # read output from pipe #
                        for robj in read:
                            # check connection close #
                            assert robj != connObj.socket

                            # handle data arrived #
                            while 1:
                                # read output from pipe #
                                if readChunkSize:
                                    output = robj.read(readChunkSize)
                                else:
                                    output = robj.readline()

                                # check and transfer output #
                                if output == '\n':
                                    continue
                                elif output and len(output) > 0:
                                    assert connObj.write(output)
                                else:
                                    break
                    except:
                        break

                    # check process status #
                    if procObj.poll() != None:
                        break

                SysMgr.printInfo(
                    "terminated '%s' for %s" % (value, addr))
            except:
                SysMgr.printErr(
                    "fail to execute '%s' from %s" % (value, addr), True)
            finally:
                try:
                    connObj.socket.shutdown(socket.SHUT_RDWR)
                    connObj.close()

                    # send TERM signal first #
                    os.killpg(procObj.pid, signal.SIGINT)

                    time.sleep(SysMgr.waitDelay)

                    # send KILL signal #
                    os.killpg(procObj.pid, signal.SIGKILL)
                except:
                    pass

        def _onBroadcast(connObj, value, response):
            cmd = 'run:' + value

            # reply message #
            if nodeList:
                # send message packet #
                connObj.send(
                    'MSG:"%s" is executed by %s node' % \
                        (cmd, len(nodeList)))

                '''
                receive an ACK packet
                to prevent receiving two packets at once
                '''
                connObj.recv()

                # send reply  packet for command #
                connObj.send('run|%s' % value)
            else:
                connObj.send('NO_SERV_NODE')
                return

            # execute remote commands #
            for addr in list(nodeList.keys()):
                # create worker process #
                pid = SysMgr.createProcess()
                if pid > 0:
                    continue

                # execute a command from a remote node #
                try:
                    SysMgr.printInfo(
                        "execute '%s' at %s for %s:%s" % \
                            (cmd, addr, connObj.ip, connObj.port))

                    # disable log #
                    SysMgr.logEnable = False

                    rcmd = '%s|%s' % (addr, cmd)
                    SysMgr.runClientMode(rcmd, connObj)
                except SystemExit:
                    pass
                except:
                    SysMgr.logEnable = True
                    SysMgr.printErr(
                        "fail to execute '%s' at %s for %s:%s" % \
                            (cmd, addr, connObj.ip, connObj.port))

                sys.exit(0)

            # wait for termination for remote commands #
            if pid > 0:
                SysMgr.waitChild()

        def _register(connObj):
            # create a new socket for TCP #
            rip = SysMgr.remoteServObj.ip
            rport = SysMgr.remoteServObj.port
            raddr = '%s:%s' % (rip, rport)
            caddr = '%s:%s' % (connObj.ip, connObj.port)
            cliObj = NetworkMgr.setRemoteServer(raddr, tcp=True)
            errMsg = None

            while 1:
                try:
                    # create a new socket for TCP #
                    if not cliObj.socket:
                        cliObj = NetworkMgr.setRemoteServer(raddr, tcp=True)

                    SysMgr.printWarn(
                        'try to connect to the agent node(%s)' % raddr)

                    # connect to an agent node #
                    cliObj.connect()
                    cliObj.connected = True
                    errMsg = None
                    SysMgr.printInfo(
                        'connected to the agent node(%s)' % raddr)

                    # register to another server #
                    pipe = NetworkMgr.getCmdPipe(cliObj, 'new:%s' % caddr)

                    # monitor connection #
                    cliObj.recv()
                except SystemExit:
                    sys.exit(0)
                except:
                    # print error message #
                    curErrMsg = SysMgr.getErrMsg()
                    if errMsg != curErrMsg:
                        SysMgr.printErr((
                            'fail to keep connection with the agent node '
                            'to %s') % raddr, True)
                        SysMgr.printInfo(
        