// Generated by gmmproc 2.42.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gstreamermm/allocator.h>
#include <gstreamermm/private/allocator_p.h>


/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2014 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/allocator.h>


namespace Gst
{
AllocationParams::AllocationParams()
{
  GstAllocationParams params;
  gst_allocation_params_init(&params);
  gobject_ = gst_allocation_params_copy(&params);
}

Glib::RefPtr<Allocator> Allocator::find(const Glib::ustring& name)
{
  return Glib::wrap(gst_allocator_find(name.c_str()), false);
}

void Allocator::register_allocator(const Glib::ustring& name)
{
  reference();
  gst_allocator_register(name.c_str(), gobj());
}

Glib::RefPtr<Gst::Allocator> Allocator::get_default_allocator()
{
  return Glib::wrap(gst_allocator_find(NULL), false);
}

void Allocator::set_default()
{
  reference();
  gst_allocator_set_default(gobj());
}

void Allocator::free(Glib::RefPtr<Gst::Memory>& memory)
{
  GstMemory* memory_gobj = memory->gobj();
  memory->reference();
  memory.reset();

  gst_allocator_free(gobj(), memory_gobj);
}

void Allocator_Class::free_vfunc_callback(GstAllocator* self, GstMemory* memory)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
    	Glib::RefPtr<Gst::Memory> mem = Glib::wrap(memory);
        obj->free_vfunc(mem);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->free)
  {
    (*base->free)(self, memory);
  }

}

void Gst::Allocator::free_vfunc(Glib::RefPtr<Gst::Memory>& memory)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_))
  );

  if(base && base->free)
  {
    GstMemory* mem_gobj = memory->gobj();
    memory->reference();
    memory.reset();
    (*base->free)(gobj(), mem_gobj);
  }
}

}

namespace
{
} // anonymous namespace


namespace Glib
{

Gst::AllocationParams wrap(GstAllocationParams* object, bool take_copy)
{
  return Gst::AllocationParams(object, take_copy);
}

} // namespace Glib


namespace Gst
{


// static
GType AllocationParams::get_type()
{
  return gst_allocation_params_get_type();
}


AllocationParams::AllocationParams(const AllocationParams& other)
:
  gobject_ ((other.gobject_) ? gst_allocation_params_copy(other.gobject_) : 0)
{}

AllocationParams::AllocationParams(GstAllocationParams* gobject, bool make_a_copy)
:
  // For BoxedType wrappers, make_a_copy is true by default.  The static
  // BoxedType wrappers must always take a copy, thus make_a_copy = true
  // ensures identical behaviour if the default argument is used.
  gobject_ ((make_a_copy && gobject) ? gst_allocation_params_copy(gobject) : gobject)
{}

AllocationParams& AllocationParams::operator=(const AllocationParams& other)
{
  AllocationParams temp (other);
  swap(temp);
  return *this;
}

AllocationParams::~AllocationParams()
{
  if(gobject_)
    gst_allocation_params_free(gobject_);
}

void AllocationParams::swap(AllocationParams& other)
{
  GstAllocationParams *const temp = gobject_;
  gobject_ = other.gobject_;
  other.gobject_ = temp;
}

GstAllocationParams* AllocationParams::gobj_copy() const
{
  return gst_allocation_params_copy(gobject_);
}


void AllocationParams::init()
{
  gst_allocation_params_init(gobj());
}

 MemoryFlags AllocationParams::get_flags() const
{
  return ((MemoryFlags)(gobj()->flags));
}
 
 void AllocationParams::set_flags(const MemoryFlags& value)
{
  gobj()->flags = ((GstMemoryFlags)(value));
}
 
 gsize AllocationParams::get_align() const
{
  return gobj()->align;
}
 
 void AllocationParams::set_align(const gsize& value)
{
  gobj()->align = value;
}
 
 gsize AllocationParams::get_prefix() const
{
  return gobj()->prefix;
}
 
 void AllocationParams::set_prefix(const gsize& value)
{
  gobj()->prefix = value;
}
 
 gsize AllocationParams::get_padding() const
{
  return gobj()->padding;
}
 
 void AllocationParams::set_padding(const gsize& value)
{
  gobj()->padding = value;
}
 

} // namespace Gst


namespace Glib
{

Glib::RefPtr<Gst::Allocator> wrap(GstAllocator* object, bool take_copy)
{
  return Glib::RefPtr<Gst::Allocator>( dynamic_cast<Gst::Allocator*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gst
{


/* The *_Class implementation: */

const Glib::Class& Allocator_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Allocator_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gst_allocator_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Allocator_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

  klass->alloc = &alloc_vfunc_callback;
  klass->free = &free_vfunc_callback;
  
}

GstMemory* Allocator_Class::alloc_vfunc_callback(GstAllocator* self, gsize size, GstAllocationParams* params)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return Glib::unwrap(obj->alloc_vfunc(size, AllocationParams(params, true)
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->alloc)
  {
    GstMemory* retval = (*base->alloc)(self, size, params);
    return retval;
  }

  typedef GstMemory* RType;
  return RType();
}


Glib::ObjectBase* Allocator_Class::wrap_new(GObject* object)
{
  return new Allocator((GstAllocator*)object);
}


/* The implementation: */

GstAllocator* Allocator::gobj_copy()
{
  reference();
  return gobj();
}

Allocator::Allocator(const Glib::ConstructParams& construct_params)
:
  Gst::Object(construct_params)
{

}

Allocator::Allocator(GstAllocator* castitem)
:
  Gst::Object((GstObject*)(castitem))
{}


Allocator::~Allocator()
{}


Allocator::CppClassType Allocator::allocator_class_; // initialize static member

GType Allocator::get_type()
{
  return allocator_class_.init().get_type();
}


GType Allocator::get_base_type()
{
  return gst_allocator_get_type();
}

Glib::RefPtr<Gst::Memory> Allocator::alloc(gsize size, AllocationParams params)
{
  return Glib::wrap(gst_allocator_alloc(gobj(), size, params.gobj()));
}


Glib::RefPtr<Gst::Memory> Gst::Allocator::alloc_vfunc(gsize size, AllocationParams params) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->alloc)
  {
    Glib::RefPtr<Gst::Memory> retval(Glib::wrap((*base->alloc)(gobj(),size,params.gobj())));
    return retval;
  }

  typedef Glib::RefPtr<Gst::Memory> RType;
  return RType();
}


} // namespace Gst


