/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
/************ Begin %include sections from the grammar ************************/
#line 4 "grn_ecmascript.lemon"

#define assert GRN_ASSERT
#line 31 "grn_ecmascript.c"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    grn_expr_parserTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is grn_expr_parserTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    grn_expr_parserARG_SDECL     A static variable declaration for the %extra_argument
**    grn_expr_parserARG_PDECL     A parameter declaration for the %extra_argument
**    grn_expr_parserARG_STORE     Code to store %extra_argument into yypParser
**    grn_expr_parserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_MIN_REDUCE      Maximum value for reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned char
#define YYNOCODE 114
#define YYACTIONTYPE unsigned short int
#define grn_expr_parserTOKENTYPE  int 
typedef union {
  int yyinit;
  grn_expr_parserTOKENTYPE yy0;
  void * yy165;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define grn_expr_parserARG_SDECL  efs_info *efsi ;
#define grn_expr_parserARG_PDECL , efs_info *efsi 
#define grn_expr_parserARG_FETCH  efs_info *efsi  = yypParser->efsi 
#define grn_expr_parserARG_STORE yypParser->efsi  = efsi 
#define YYNSTATE             142
#define YYNRULE              133
#define YY_MAX_SHIFT         141
#define YY_MIN_SHIFTREDUCE   227
#define YY_MAX_SHIFTREDUCE   359
#define YY_MIN_REDUCE        360
#define YY_MAX_REDUCE        492
#define YY_ERROR_ACTION      493
#define YY_ACCEPT_ACTION     494
#define YY_NO_ACTION         495
/************* End control #defines *******************************************/

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
static const YYMINORTYPE yyzerominor = { 0 };

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE

**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1759)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */     3,   71,  112,  338,  133,  236,    2,   77,   81,  126,
 /*    10 */     1,  231,   70,  494,   78,  109,  128,  241,  231,  317,
 /*    20 */   242,  244,   88,  123,  122,  136,  135,  134,  117,   85,
 /*    30 */   100,  113,  101,  295,  299,  314,   74,  319,  322,  319,
 /*    40 */   322,  236,   73,  341,   81,  141,    9,  232,   70,  235,
 /*    50 */    65,   64,   53,   52,   51,   68,   67,   66,   63,   62,
 /*    60 */    61,   60,   59,   58,  323,  324,  325,  326,  327,    4,
 /*    70 */   124,   69,   57,   56,  317,  242,  244,   88,  123,  122,
 /*    80 */   136,  135,  134,  117,   85,  100,  113,  101,  295,  299,
 /*    90 */   314,   74,  356,  130,  319,  322,  316,  318,  112,  338,
 /*   100 */   133,  236,    2,  239,   81,  126,    1,  107,   70,   77,
 /*   110 */   115,   31,   30,  231,  317,  242,  244,   88,  123,  122,
 /*   120 */   136,  135,  134,  117,   85,  100,  113,  101,  295,  299,
 /*   130 */   314,   74,  238,    7,  319,  322,  321,   72,  355,  130,
 /*   140 */   339,  133,  344,  336,  234,   76,   65,   64,   23,   55,
 /*   150 */    54,   68,   67,   66,   63,   62,   61,   60,   59,   58,
 /*   160 */   323,  324,  325,  326,  327,    4,   83,   82,   79,  236,
 /*   170 */    73,  237,   81,  141,    9,  320,   70,   65,   64,  351,
 /*   180 */   233,   28,   68,   67,   66,   63,   62,   61,   60,   59,
 /*   190 */    58,  323,  324,  325,  326,  327,    4,  108,  331,  352,
 /*   200 */   317,  353,  244,   88,  123,  122,  136,  135,  134,  117,
 /*   210 */    85,  100,  113,  101,  295,  299,  314,   74,   10,    7,
 /*   220 */   319,  322,  321,   72,   36,   35,  332,    6,  349,  317,
 /*   230 */   333,  244,   88,  123,  122,  136,  135,  134,  117,   85,
 /*   240 */   100,  113,  101,  295,  299,  314,   74,  362,  361,  319,
 /*   250 */   322,   11,   84,    7,  474,  330,  321,   72,  312,  313,
 /*   260 */   332,    5,   28,   65,   64,   28,   80,   29,   68,   67,
 /*   270 */    66,   63,   62,   61,   60,   59,   58,  323,  324,  325,
 /*   280 */   326,  327,    4,  329,    7,  359,  358,  321,   72,   26,
 /*   290 */     8,  331,  132,  240,  127,   28,  129,   65,   64,  363,
 /*   300 */    32,  343,   68,   67,   66,   63,   62,   61,   60,   59,
 /*   310 */    58,  323,  324,  325,  326,  327,    4,  328,   24,   34,
 /*   320 */    25,  362,  342,   33,  362,  362,  362,  362,   65,   64,
 /*   330 */   362,  362,  362,   68,   67,   66,   63,   62,   61,   60,
 /*   340 */    59,   58,  323,  324,  325,  326,  327,    4,  362,  362,
 /*   350 */    75,  317,  353,  244,   88,  123,  122,  136,  135,  134,
 /*   360 */   117,   85,  100,  113,  101,  295,  299,  314,   74,  362,
 /*   370 */   362,  319,  322,  362,  362,  362,  362,  362,  362,  350,
 /*   380 */   317,  346,  244,   88,  123,  122,  136,  135,  134,  117,
 /*   390 */    85,  100,  113,  101,  295,  299,  314,   74,  362,  362,
 /*   400 */   319,  322,  362,  362,  362,  362,  362,  111,  115,  362,
 /*   410 */   362,  362,  317,  242,  244,   88,  123,  122,  136,  135,
 /*   420 */   134,  117,   85,  100,  113,  101,  295,  299,  314,   74,
 /*   430 */   118,  362,  319,  322,  317,  242,  244,   88,  123,  122,
 /*   440 */   136,  135,  134,  117,   85,  100,  113,  101,  295,  299,
 /*   450 */   314,   74,  362,    7,  319,  322,  321,   72,  124,  362,
 /*   460 */   362,  362,  317,  242,  244,   88,  123,  122,  136,  135,
 /*   470 */   134,  117,   85,  100,  113,  101,  295,  299,  314,   74,
 /*   480 */   362,    7,  319,  322,  321,   72,  362,  362,  362,  362,
 /*   490 */   362,  362,  362,  362,  362,  362,  362,   65,   64,  362,
 /*   500 */   362,  362,   68,   67,   66,   63,   62,   61,   60,   59,
 /*   510 */    58,  323,  324,  125,  326,  327,    4,  362,  362,  362,
 /*   520 */   362,  362,  362,  362,  362,   65,   64,  362,  362,  362,
 /*   530 */    68,   67,   66,   63,   62,   61,   60,   59,   58,  323,
 /*   540 */   324,  325,  326,  327,    4,  317,  335,  244,   88,  123,
 /*   550 */   122,  136,  135,  134,  117,   85,  100,  113,  101,  295,
 /*   560 */   299,  314,   74,  362,  362,  319,  322,  317,  334,  244,
 /*   570 */    88,  123,  122,  136,  135,  134,  117,   85,  100,  113,
 /*   580 */   101,  295,  299,  314,   74,  362,  362,  319,  322,  317,
 /*   590 */   256,  244,   88,  123,  122,  136,  135,  134,  117,   85,
 /*   600 */   100,  113,  101,  295,  299,  314,   74,  362,  362,  319,
 /*   610 */   322,  362,  362,  317,  255,  244,   88,  123,  122,  136,
 /*   620 */   135,  134,  117,   85,  100,  113,  101,  295,  299,  314,
 /*   630 */    74,  362,  362,  319,  322,  317,  254,  244,   88,  123,
 /*   640 */   122,  136,  135,  134,  117,   85,  100,  113,  101,  295,
 /*   650 */   299,  314,   74,  362,  362,  319,  322,  317,  253,  244,
 /*   660 */    88,  123,  122,  136,  135,  134,  117,   85,  100,  113,
 /*   670 */   101,  295,  299,  314,   74,  362,  362,  319,  322,  317,
 /*   680 */   252,  244,   88,  123,  122,  136,  135,  134,  117,   85,
 /*   690 */   100,  113,  101,  295,  299,  314,   74,  362,  362,  319,
 /*   700 */   322,  317,  251,  244,   88,  123,  122,  136,  135,  134,
 /*   710 */   117,   85,  100,  113,  101,  295,  299,  314,   74,  362,
 /*   720 */   362,  319,  322,  317,  250,  244,   88,  123,  122,  136,
 /*   730 */   135,  134,  117,   85,  100,  113,  101,  295,  299,  314,
 /*   740 */    74,  362,  362,  319,  322,  317,  249,  244,   88,  123,
 /*   750 */   122,  136,  135,  134,  117,   85,  100,  113,  101,  295,
 /*   760 */   299,  314,   74,  362,  362,  319,  322,  317,  248,  244,
 /*   770 */    88,  123,  122,  136,  135,  134,  117,   85,  100,  113,
 /*   780 */   101,  295,  299,  314,   74,  362,  362,  319,  322,  317,
 /*   790 */   247,  244,   88,  123,  122,  136,  135,  134,  117,   85,
 /*   800 */   100,  113,  101,  295,  299,  314,   74,  362,  362,  319,
 /*   810 */   322,  317,  246,  244,   88,  123,  122,  136,  135,  134,
 /*   820 */   117,   85,  100,  113,  101,  295,  299,  314,   74,  362,
 /*   830 */   362,  319,  322,  317,  347,  244,   88,  123,  122,  136,
 /*   840 */   135,  134,  117,   85,  100,  113,  101,  295,  299,  314,
 /*   850 */    74,  362,  362,  319,  322,  317,  340,  244,   88,  123,
 /*   860 */   122,  136,  135,  134,  117,   85,  100,  113,  101,  295,
 /*   870 */   299,  314,   74,  362,  362,  319,  322,  317,  258,  244,
 /*   880 */    88,  123,  122,  136,  135,  134,  117,   85,  100,  113,
 /*   890 */   101,  295,  299,  314,   74,  362,  362,  319,  322,  317,
 /*   900 */   140,  244,   88,  123,  122,  136,  135,  134,  117,   85,
 /*   910 */   100,  113,  101,  295,  299,  314,   74,  362,  362,  319,
 /*   920 */   322,  317,  245,  244,   88,  123,  122,  136,  135,  134,
 /*   930 */   117,   85,  100,  113,  101,  295,  299,  314,   74,  362,
 /*   940 */   362,  319,  322,  317,  243,  244,   88,  123,  122,  136,
 /*   950 */   135,  134,  117,   85,  100,  113,  101,  295,  299,  314,
 /*   960 */    74,  362,  317,  319,  322,  119,  362,  110,  136,  135,
 /*   970 */   134,  117,   85,  100,  113,  101,  295,  299,  314,   74,
 /*   980 */   362,  317,  319,  322,  119,  362,  362,  131,  135,  134,
 /*   990 */   117,   85,  100,  113,  101,  295,  299,  314,   74,  362,
 /*  1000 */   362,  319,  322,  317,  362,  362,  119,  362,  362,  139,
 /*  1010 */   135,  134,  117,   85,  100,  113,  101,  295,  299,  314,
 /*  1020 */    74,  362,  362,  319,  322,  317,  362,  362,  119,  362,
 /*  1030 */   362,  362,  138,  134,  117,   85,  100,  113,  101,  295,
 /*  1040 */   299,  314,   74,  362,  362,  319,  322,  317,  362,  362,
 /*  1050 */   119,  362,  362,  362,  362,  137,  117,   85,  100,  113,
 /*  1060 */   101,  295,  299,  314,   74,  362,  362,  319,  322,   50,
 /*  1070 */    49,   48,   47,   46,   45,   44,   43,   42,   41,   40,
 /*  1080 */    39,   38,   37,   27,   22,   21,   20,   19,   18,   17,
 /*  1090 */    16,   15,   14,   13,   12,  317,  362,  362,  119,  362,
 /*  1100 */   362,  362,  362,  362,  121,   85,  100,  113,  101,  295,
 /*  1110 */   299,  314,   74,  362,  362,  319,  322,  362,  317,  362,
 /*  1120 */   362,  119,  362,  362,  362,  312,  313,  362,   86,  100,
 /*  1130 */   113,  101,  295,  299,  314,   74,  362,  362,  319,  322,
 /*  1140 */   317,  362,  362,  119,  362,  362,  362,  362,  362,  362,
 /*  1150 */    87,  100,  113,  101,  295,  299,  314,   74,  362,  317,
 /*  1160 */   319,  322,  119,  362,  362,  362,  362,  362,  362,  362,
 /*  1170 */    89,  113,  101,  295,  299,  314,   74,  362,  317,  319,
 /*  1180 */   322,  119,  362,  362,  362,  362,  362,  362,  362,   90,
 /*  1190 */   113,  101,  295,  299,  314,   74,  362,  362,  319,  322,
 /*  1200 */   362,  317,  362,  362,  119,  362,  362,    7,  362,  362,
 /*  1210 */   321,   72,   91,  113,  101,  295,  299,  314,   74,  362,
 /*  1220 */   362,  319,  322,  317,  362,  362,  119,  362,  362,  362,
 /*  1230 */   362,  362,  362,  362,   92,  113,  101,  295,  299,  314,
 /*  1240 */    74,  362,  317,  319,  322,  119,  362,  362,  362,  362,
 /*  1250 */   362,  362,  362,   93,  113,  101,  295,  299,  314,   74,
 /*  1260 */   362,  317,  319,  322,  119,  323,  324,  325,  326,  327,
 /*  1270 */     4,  362,   94,  113,  101,  295,  299,  314,   74,  362,
 /*  1280 */   362,  319,  322,  362,  317,  362,  362,  119,  362,  362,
 /*  1290 */   362,  362,  362,  362,  362,   95,  113,  101,  295,  299,
 /*  1300 */   314,   74,  362,  362,  319,  322,  317,  362,  362,  119,
 /*  1310 */   362,  362,  362,  362,  362,  362,  362,   96,  113,  101,
 /*  1320 */   295,  299,  314,   74,  362,  317,  319,  322,  119,  362,
 /*  1330 */   362,  362,  362,  362,  362,  362,   97,  113,  101,  295,
 /*  1340 */   299,  314,   74,  362,  317,  319,  322,  119,  362,  362,
 /*  1350 */   362,  362,  362,  362,  362,   98,  113,  101,  295,  299,
 /*  1360 */   314,   74,  362,  362,  319,  322,  362,  317,  362,  362,
 /*  1370 */   119,  362,  362,  362,  362,  362,  362,  362,   99,  113,
 /*  1380 */   101,  295,  299,  314,   74,  362,  362,  319,  322,  317,
 /*  1390 */   362,  362,  119,  362,  362,  362,  362,  362,  362,  362,
 /*  1400 */   102,  113,  101,  295,  299,  314,   74,  362,  317,  319,
 /*  1410 */   322,  119,  362,  362,  362,  362,  362,  362,  362,  104,
 /*  1420 */   113,  101,  295,  299,  314,   74,  362,  317,  319,  322,
 /*  1430 */   119,  362,  362,  362,  362,  362,  362,  362,  106,  113,
 /*  1440 */   101,  295,  299,  314,   74,  362,  362,  319,  322,  362,
 /*  1450 */   317,  362,  362,  119,  362,  362,  362,  362,  362,  362,
 /*  1460 */   362,  362,  114,  101,  295,  299,  314,   74,  362,  362,
 /*  1470 */   319,  322,  317,  362,  362,  119,  362,  362,  362,  362,
 /*  1480 */   362,  362,  362,  362,  116,  101,  295,  299,  314,   74,
 /*  1490 */   362,  317,  319,  322,  119,  362,  362,  362,  362,  362,
 /*  1500 */   362,  362,  362,  120,  101,  295,  299,  314,   74,  362,
 /*  1510 */   362,  319,  322,  360,  362,  362,   83,   82,   79,  236,
 /*  1520 */    73,  362,   81,  141,    9,  317,   70,  362,  119,  362,
 /*  1530 */   362,  362,  362,  362,  362,  362,  362,  362,  103,  295,
 /*  1540 */   299,  314,   74,  362,  362,  319,  322,  317,  362,  362,
 /*  1550 */   119,  362,  362,  362,  362,  317,  362,  362,  119,  362,
 /*  1560 */   105,  295,  299,  314,   74,  362,  362,  319,  322,  298,
 /*  1570 */   299,  314,   74,  362,  317,  319,  322,  119,  362,  362,
 /*  1580 */   362,  362,  362,  362,  362,  362,  362,  362,  297,  299,
 /*  1590 */   314,   74,  362,  362,  319,  322,  317,  362,  362,  119,
 /*  1600 */   362,  362,  362,  362,  362,  317,  362,  362,  119,  362,
 /*  1610 */   310,  299,  314,   74,  362,  362,  319,  322,  362,  309,
 /*  1620 */   299,  314,   74,  362,  317,  319,  322,  119,  362,  362,
 /*  1630 */   362,  362,  362,  317,  362,  362,  119,  362,  308,  299,
 /*  1640 */   314,   74,  362,  317,  319,  322,  119,  307,  299,  314,
 /*  1650 */    74,  362,  317,  319,  322,  119,  362,  306,  299,  314,
 /*  1660 */    74,  362,  362,  319,  322,  362,  305,  299,  314,   74,
 /*  1670 */   362,  317,  319,  322,  119,  362,  362,  362,  362,  317,
 /*  1680 */   362,  362,  119,  362,  362,  304,  299,  314,   74,  362,
 /*  1690 */   362,  319,  322,  303,  299,  314,   74,  362,  362,  319,
 /*  1700 */   322,  362,  317,  362,  362,  119,  362,  362,  362,  362,
 /*  1710 */   317,  362,  362,  119,  362,  362,  302,  299,  314,   74,
 /*  1720 */   362,  362,  319,  322,  301,  299,  314,   74,  362,  317,
 /*  1730 */   319,  322,  119,  362,  362,  362,  362,  317,  362,  362,
 /*  1740 */   119,  362,  362,  300,  299,  314,   74,  362,  362,  319,
 /*  1750 */   322,  296,  299,  314,   74,  362,  362,  319,  322,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */     1,    2,  106,  107,  108,    6,    7,   77,    9,   10,
 /*    10 */    11,   81,   13,   76,   77,   78,   10,   82,   81,   82,
 /*    20 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*    30 */    93,   94,   95,   96,   97,   98,   99,  102,  103,  102,
 /*    40 */   103,    6,    7,   67,    9,   10,   11,   81,   13,   81,
 /*    50 */    51,   52,   48,   49,   50,   56,   57,   58,   59,   60,
 /*    60 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*    70 */    78,   53,   54,   55,   82,   83,   84,   85,   86,   87,
 /*    80 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*    90 */    98,   99,  111,  112,  102,  103,  100,  101,  106,  107,
 /*   100 */   108,    6,    7,   81,    9,   10,   11,   80,   13,   77,
 /*   110 */    78,    3,    4,   81,   82,   83,   84,   85,   86,   87,
 /*   120 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   130 */    98,   99,   81,    7,  102,  103,   10,   11,  111,  112,
 /*   140 */   107,  108,    8,   12,   81,   14,   51,   52,   14,   51,
 /*   150 */    52,   56,   57,   58,   59,   60,   61,   62,   63,   64,
 /*   160 */    65,   66,   67,   68,   69,   70,    3,    4,    5,    6,
 /*   170 */     7,    8,    9,   10,   11,    8,   13,   51,   52,   53,
 /*   180 */    81,   14,   56,   57,   58,   59,   60,   61,   62,   63,
 /*   190 */    64,   65,   66,   67,   68,   69,   70,   79,   14,   73,
 /*   200 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   210 */    92,   93,   94,   95,   96,   97,   98,   99,  104,    7,
 /*   220 */   102,  103,   10,   11,   32,   33,   14,    7,  110,   82,
 /*   230 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   240 */    93,   94,   95,   96,   97,   98,   99,    0,    0,  102,
 /*   250 */   103,  104,  105,    7,   28,   71,   10,   11,   57,   58,
 /*   260 */    14,   14,   14,   51,   52,   14,    9,    5,   56,   57,
 /*   270 */    58,   59,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   280 */    68,   69,   70,   71,    7,   67,   65,   10,   11,   27,
 /*   290 */    70,   14,   72,   12,   39,   14,   53,   51,   52,    0,
 /*   300 */    29,   10,   56,   57,   58,   59,   60,   61,   62,   63,
 /*   310 */    64,   65,   66,   67,   68,   69,   70,   71,   28,   31,
 /*   320 */    28,  113,   71,   30,  113,  113,  113,  113,   51,   52,
 /*   330 */   113,  113,  113,   56,   57,   58,   59,   60,   61,   62,
 /*   340 */    63,   64,   65,   66,   67,   68,   69,   70,  113,  113,
 /*   350 */    51,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   360 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  113,
 /*   370 */   113,  102,  103,  113,  113,  113,  113,  113,  113,  110,
 /*   380 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   390 */    92,   93,   94,   95,   96,   97,   98,   99,  113,  113,
 /*   400 */   102,  103,  113,  113,  113,  113,  113,  109,   78,  113,
 /*   410 */   113,  113,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   420 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   430 */    78,  113,  102,  103,   82,   83,   84,   85,   86,   87,
 /*   440 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   450 */    98,   99,  113,    7,  102,  103,   10,   11,   78,  113,
 /*   460 */   113,  113,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   470 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   480 */   113,    7,  102,  103,   10,   11,  113,  113,  113,  113,
 /*   490 */   113,  113,  113,  113,  113,  113,  113,   51,   52,  113,
 /*   500 */   113,  113,   56,   57,   58,   59,   60,   61,   62,   63,
 /*   510 */    64,   65,   66,   67,   68,   69,   70,  113,  113,  113,
 /*   520 */   113,  113,  113,  113,  113,   51,   52,  113,  113,  113,
 /*   530 */    56,   57,   58,   59,   60,   61,   62,   63,   64,   65,
 /*   540 */    66,   67,   68,   69,   70,   82,   83,   84,   85,   86,
 /*   550 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   560 */    97,   98,   99,  113,  113,  102,  103,   82,   83,   84,
 /*   570 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   580 */    95,   96,   97,   98,   99,  113,  113,  102,  103,   82,
 /*   590 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   600 */    93,   94,   95,   96,   97,   98,   99,  113,  113,  102,
 /*   610 */   103,  113,  113,   82,   83,   84,   85,   86,   87,   88,
 /*   620 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   630 */    99,  113,  113,  102,  103,   82,   83,   84,   85,   86,
 /*   640 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   650 */    97,   98,   99,  113,  113,  102,  103,   82,   83,   84,
 /*   660 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   670 */    95,   96,   97,   98,   99,  113,  113,  102,  103,   82,
 /*   680 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   690 */    93,   94,   95,   96,   97,   98,   99,  113,  113,  102,
 /*   700 */   103,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   710 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  113,
 /*   720 */   113,  102,  103,   82,   83,   84,   85,   86,   87,   88,
 /*   730 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   740 */    99,  113,  113,  102,  103,   82,   83,   84,   85,   86,
 /*   750 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   760 */    97,   98,   99,  113,  113,  102,  103,   82,   83,   84,
 /*   770 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   780 */    95,   96,   97,   98,   99,  113,  113,  102,  103,   82,
 /*   790 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   800 */    93,   94,   95,   96,   97,   98,   99,  113,  113,  102,
 /*   810 */   103,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   820 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  113,
 /*   830 */   113,  102,  103,   82,   83,   84,   85,   86,   87,   88,
 /*   840 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   850 */    99,  113,  113,  102,  103,   82,   83,   84,   85,   86,
 /*   860 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   870 */    97,   98,   99,  113,  113,  102,  103,   82,   83,   84,
 /*   880 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   890 */    95,   96,   97,   98,   99,  113,  113,  102,  103,   82,
 /*   900 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   910 */    93,   94,   95,   96,   97,   98,   99,  113,  113,  102,
 /*   920 */   103,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   930 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  113,
 /*   940 */   113,  102,  103,   82,   83,   84,   85,   86,   87,   88,
 /*   950 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   960 */    99,  113,   82,  102,  103,   85,  113,   87,   88,   89,
 /*   970 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   980 */   113,   82,  102,  103,   85,  113,  113,   88,   89,   90,
 /*   990 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  113,
 /*  1000 */   113,  102,  103,   82,  113,  113,   85,  113,  113,   88,
 /*  1010 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*  1020 */    99,  113,  113,  102,  103,   82,  113,  113,   85,  113,
 /*  1030 */   113,  113,   89,   90,   91,   92,   93,   94,   95,   96,
 /*  1040 */    97,   98,   99,  113,  113,  102,  103,   82,  113,  113,
 /*  1050 */    85,  113,  113,  113,  113,   90,   91,   92,   93,   94,
 /*  1060 */    95,   96,   97,   98,   99,  113,  113,  102,  103,   34,
 /*  1070 */    35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*  1080 */    45,   46,   47,   15,   16,   17,   18,   19,   20,   21,
 /*  1090 */    22,   23,   24,   25,   26,   82,  113,  113,   85,  113,
 /*  1100 */   113,  113,  113,  113,   91,   92,   93,   94,   95,   96,
 /*  1110 */    97,   98,   99,  113,  113,  102,  103,  113,   82,  113,
 /*  1120 */   113,   85,  113,  113,  113,   57,   58,  113,   92,   93,
 /*  1130 */    94,   95,   96,   97,   98,   99,  113,  113,  102,  103,
 /*  1140 */    82,  113,  113,   85,  113,  113,  113,  113,  113,  113,
 /*  1150 */    92,   93,   94,   95,   96,   97,   98,   99,  113,   82,
 /*  1160 */   102,  103,   85,  113,  113,  113,  113,  113,  113,  113,
 /*  1170 */    93,   94,   95,   96,   97,   98,   99,  113,   82,  102,
 /*  1180 */   103,   85,  113,  113,  113,  113,  113,  113,  113,   93,
 /*  1190 */    94,   95,   96,   97,   98,   99,  113,  113,  102,  103,
 /*  1200 */   113,   82,  113,  113,   85,  113,  113,    7,  113,  113,
 /*  1210 */    10,   11,   93,   94,   95,   96,   97,   98,   99,  113,
 /*  1220 */   113,  102,  103,   82,  113,  113,   85,  113,  113,  113,
 /*  1230 */   113,  113,  113,  113,   93,   94,   95,   96,   97,   98,
 /*  1240 */    99,  113,   82,  102,  103,   85,  113,  113,  113,  113,
 /*  1250 */   113,  113,  113,   93,   94,   95,   96,   97,   98,   99,
 /*  1260 */   113,   82,  102,  103,   85,   65,   66,   67,   68,   69,
 /*  1270 */    70,  113,   93,   94,   95,   96,   97,   98,   99,  113,
 /*  1280 */   113,  102,  103,  113,   82,  113,  113,   85,  113,  113,
 /*  1290 */   113,  113,  113,  113,  113,   93,   94,   95,   96,   97,
 /*  1300 */    98,   99,  113,  113,  102,  103,   82,  113,  113,   85,
 /*  1310 */   113,  113,  113,  113,  113,  113,  113,   93,   94,   95,
 /*  1320 */    96,   97,   98,   99,  113,   82,  102,  103,   85,  113,
 /*  1330 */   113,  113,  113,  113,  113,  113,   93,   94,   95,   96,
 /*  1340 */    97,   98,   99,  113,   82,  102,  103,   85,  113,  113,
 /*  1350 */   113,  113,  113,  113,  113,   93,   94,   95,   96,   97,
 /*  1360 */    98,   99,  113,  113,  102,  103,  113,   82,  113,  113,
 /*  1370 */    85,  113,  113,  113,  113,  113,  113,  113,   93,   94,
 /*  1380 */    95,   96,   97,   98,   99,  113,  113,  102,  103,   82,
 /*  1390 */   113,  113,   85,  113,  113,  113,  113,  113,  113,  113,
 /*  1400 */    93,   94,   95,   96,   97,   98,   99,  113,   82,  102,
 /*  1410 */   103,   85,  113,  113,  113,  113,  113,  113,  113,   93,
 /*  1420 */    94,   95,   96,   97,   98,   99,  113,   82,  102,  103,
 /*  1430 */    85,  113,  113,  113,  113,  113,  113,  113,   93,   94,
 /*  1440 */    95,   96,   97,   98,   99,  113,  113,  102,  103,  113,
 /*  1450 */    82,  113,  113,   85,  113,  113,  113,  113,  113,  113,
 /*  1460 */   113,  113,   94,   95,   96,   97,   98,   99,  113,  113,
 /*  1470 */   102,  103,   82,  113,  113,   85,  113,  113,  113,  113,
 /*  1480 */   113,  113,  113,  113,   94,   95,   96,   97,   98,   99,
 /*  1490 */   113,   82,  102,  103,   85,  113,  113,  113,  113,  113,
 /*  1500 */   113,  113,  113,   94,   95,   96,   97,   98,   99,  113,
 /*  1510 */   113,  102,  103,    0,  113,  113,    3,    4,    5,    6,
 /*  1520 */     7,  113,    9,   10,   11,   82,   13,  113,   85,  113,
 /*  1530 */   113,  113,  113,  113,  113,  113,  113,  113,   95,   96,
 /*  1540 */    97,   98,   99,  113,  113,  102,  103,   82,  113,  113,
 /*  1550 */    85,  113,  113,  113,  113,   82,  113,  113,   85,  113,
 /*  1560 */    95,   96,   97,   98,   99,  113,  113,  102,  103,   96,
 /*  1570 */    97,   98,   99,  113,   82,  102,  103,   85,  113,  113,
 /*  1580 */   113,  113,  113,  113,  113,  113,  113,  113,   96,   97,
 /*  1590 */    98,   99,  113,  113,  102,  103,   82,  113,  113,   85,
 /*  1600 */   113,  113,  113,  113,  113,   82,  113,  113,   85,  113,
 /*  1610 */    96,   97,   98,   99,  113,  113,  102,  103,  113,   96,
 /*  1620 */    97,   98,   99,  113,   82,  102,  103,   85,  113,  113,
 /*  1630 */   113,  113,  113,   82,  113,  113,   85,  113,   96,   97,
 /*  1640 */    98,   99,  113,   82,  102,  103,   85,   96,   97,   98,
 /*  1650 */    99,  113,   82,  102,  103,   85,  113,   96,   97,   98,
 /*  1660 */    99,  113,  113,  102,  103,  113,   96,   97,   98,   99,
 /*  1670 */   113,   82,  102,  103,   85,  113,  113,  113,  113,   82,
 /*  1680 */   113,  113,   85,  113,  113,   96,   97,   98,   99,  113,
 /*  1690 */   113,  102,  103,   96,   97,   98,   99,  113,  113,  102,
 /*  1700 */   103,  113,   82,  113,  113,   85,  113,  113,  113,  113,
 /*  1710 */    82,  113,  113,   85,  113,  113,   96,   97,   98,   99,
 /*  1720 */   113,  113,  102,  103,   96,   97,   98,   99,  113,   82,
 /*  1730 */   102,  103,   85,  113,  113,  113,  113,   82,  113,  113,
 /*  1740 */    85,  113,  113,   96,   97,   98,   99,  113,  113,  102,
 /*  1750 */   103,   96,   97,   98,   99,  113,  113,  102,  103,
};
#define YY_SHIFT_USE_DFLT (-25)
#define YY_SHIFT_COUNT (141)
#define YY_SHIFT_MIN   (-24)
#define YY_SHIFT_MAX   (1513)
static const short yy_shift_ofst[] = {
 /*     0 */    -1,  446,   95,  126,  277,  126,  474,  474,  474,  474,
 /*    10 */   212,  246,  474,  474,  474,  474,  474,  474,  474,  474,
 /*    20 */   474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
 /*    30 */   474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
 /*    40 */   474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
 /*    50 */   474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
 /*    60 */   474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
 /*    70 */  1200,    6,  -24,   35,  220,    6,  -24,  163, 1513,   35,
 /*    80 */    35,   35,   35,   35,  184, 1035, 1035, 1035, 1068,    4,
 /*    90 */     4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
 /*   100 */     4,   18,    4,   18,    4,   18,    4,  299,  247,  248,
 /*   110 */   108,  134,  131,   98,   98,  167,   98,  192,  251,  201,
 /*   120 */    98,  192,  108,  262,  281,  226,  257,  218,  255,  221,
 /*   130 */   243,  271,  291,  290,  288,  293,  271,  288,  293,  271,
 /*   140 */   292,  257,
};
#define YY_REDUCE_USE_DFLT (-105)
#define YY_REDUCE_COUNT (84)
#define YY_REDUCE_MIN   (-104)
#define YY_REDUCE_MAX   (1655)
static const short yy_reduce_ofst[] = {
 /*     0 */   -63,   -8,   32,  118,  147,  269,  298,  330,  352,  380,
 /*    10 */   463,  485,  507,  531,  553,  575,  597,  619,  641,  663,
 /*    20 */   685,  707,  729,  751,  773,  795,  817,  839,  861,  880,
 /*    30 */   899,  921,  943,  965, 1013, 1036, 1058, 1077, 1096, 1119,
 /*    40 */  1141, 1160, 1179, 1202, 1224, 1243, 1262, 1285, 1307, 1326,
 /*    50 */  1345, 1368, 1390, 1409, 1443, 1465, 1473, 1492, 1514, 1523,
 /*    60 */  1542, 1551, 1561, 1570, 1589, 1597, 1620, 1628, 1647, 1655,
 /*    70 */   -65,   27, -104,  -70,   -4,  -19,   33,  -34,  -34,  -32,
 /*    80 */    22,   51,   63,   99,  114,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   493,  470,  493,  481,  493,  493,  478,  493,  493,  493,
 /*    10 */   493,  493,  493,  493,  493,  493,  493,  493,  493,  493,
 /*    20 */   493,  493,  493,  493,  493,  493,  493,  493,  493,  493,
 /*    30 */   493,  493,  493,  493,  493,  493,  493,  493,  493,  493,
 /*    40 */   493,  493,  493,  493,  493,  493,  493,  493,  493,  493,
 /*    50 */   493,  493,  493,  493,  493,  493,  493,  493,  493,  493,
 /*    60 */   493,  493,  493,  493,  493,  493,  493,  493,  493,  493,
 /*    70 */   493,  487,  470,  493,  448,  493,  493,  493,  493,  493,
 /*    80 */   493,  493,  493,  493,  493,  403,  405,  404,  444,  420,
 /*    90 */   419,  418,  417,  416,  415,  414,  413,  412,  411,  410,
 /*   100 */   406,  425,  409,  427,  408,  426,  407,  493,  493,  493,
 /*   110 */   393,  493,  493,  421,  424,  493,  423,  401,  493,  444,
 /*   120 */   422,  402,  392,  390,  493,  458,  454,  493,  493,  493,
 /*   130 */   490,  396,  493,  493,  399,  397,  394,  400,  398,  395,
 /*   140 */   493,  493,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  grn_expr_parserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void grn_expr_parserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "START_OUTPUT_COLUMNS",  "START_ADJUSTER",  "LOGICAL_AND", 
  "LOGICAL_AND_NOT",  "LOGICAL_OR",    "QSTRING",       "PARENL",      
  "PARENR",        "RELATIVE_OP",   "IDENTIFIER",    "BRACEL",      
  "BRACER",        "EVAL",          "COMMA",         "ASSIGN",      
  "STAR_ASSIGN",   "SLASH_ASSIGN",  "MOD_ASSIGN",    "PLUS_ASSIGN", 
  "MINUS_ASSIGN",  "SHIFTL_ASSIGN",  "SHIFTR_ASSIGN",  "SHIFTRR_ASSIGN",
  "AND_ASSIGN",    "XOR_ASSIGN",    "OR_ASSIGN",     "QUESTION",    
  "COLON",         "BITWISE_OR",    "BITWISE_XOR",   "BITWISE_AND", 
  "EQUAL",         "NOT_EQUAL",     "LESS",          "GREATER",     
  "LESS_EQUAL",    "GREATER_EQUAL",  "IN",            "MATCH",       
  "NEAR",          "NEAR2",         "SIMILAR",       "TERM_EXTRACT",
  "LCP",           "PREFIX",        "SUFFIX",        "REGEXP",      
  "SHIFTL",        "SHIFTR",        "SHIFTRR",       "PLUS",        
  "MINUS",         "STAR",          "SLASH",         "MOD",         
  "DELETE",        "INCR",          "DECR",          "NOT",         
  "BITWISE_NOT",   "ADJUST",        "EXACT",         "PARTIAL",     
  "UNSPLIT",       "DECIMAL",       "HEX_INTEGER",   "STRING",      
  "BOOLEAN",       "NULL",          "BRACKETL",      "BRACKETR",    
  "DOT",           "NONEXISTENT_COLUMN",  "error",         "suppress_unused_variable_warning",
  "input",         "query",         "expression",    "output_columns",
  "adjuster",      "query_element",  "primary_expression",  "assignment_expression",
  "conditional_expression",  "lefthand_side_expression",  "logical_or_expression",  "logical_and_expression",
  "bitwise_or_expression",  "bitwise_xor_expression",  "bitwise_and_expression",  "equality_expression",
  "relational_expression",  "shift_expression",  "additive_expression",  "multiplicative_expression",
  "unary_expression",  "postfix_expression",  "call_expression",  "member_expression",
  "arguments",     "member_expression_part",  "object_literal",  "array_literal",
  "elision",       "element_list",  "property_name_and_value_list",  "property_name_and_value",
  "property_name",  "argument_list",  "output_column",  "adjust_expression",
  "adjust_match_expression",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= query",
 /*   1 */ "input ::= expression",
 /*   2 */ "input ::= START_OUTPUT_COLUMNS output_columns",
 /*   3 */ "input ::= START_ADJUSTER adjuster",
 /*   4 */ "query ::= query_element",
 /*   5 */ "query ::= query query_element",
 /*   6 */ "query ::= query LOGICAL_AND query_element",
 /*   7 */ "query ::= query LOGICAL_AND_NOT query_element",
 /*   8 */ "query ::= query LOGICAL_OR query_element",
 /*   9 */ "query_element ::= QSTRING",
 /*  10 */ "query_element ::= PARENL query PARENR",
 /*  11 */ "query_element ::= RELATIVE_OP query_element",
 /*  12 */ "query_element ::= IDENTIFIER RELATIVE_OP query_element",
 /*  13 */ "query_element ::= BRACEL expression BRACER",
 /*  14 */ "query_element ::= EVAL primary_expression",
 /*  15 */ "expression ::= assignment_expression",
 /*  16 */ "expression ::= expression COMMA assignment_expression",
 /*  17 */ "assignment_expression ::= conditional_expression",
 /*  18 */ "assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression",
 /*  19 */ "assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression",
 /*  20 */ "assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression",
 /*  21 */ "assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression",
 /*  22 */ "assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression",
 /*  23 */ "assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression",
 /*  24 */ "assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression",
 /*  25 */ "assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression",
 /*  26 */ "assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression",
 /*  27 */ "assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression",
 /*  28 */ "assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression",
 /*  29 */ "assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression",
 /*  30 */ "conditional_expression ::= logical_or_expression",
 /*  31 */ "conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression",
 /*  32 */ "logical_or_expression ::= logical_and_expression",
 /*  33 */ "logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression",
 /*  34 */ "logical_and_expression ::= bitwise_or_expression",
 /*  35 */ "logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression",
 /*  36 */ "logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression",
 /*  37 */ "bitwise_or_expression ::= bitwise_xor_expression",
 /*  38 */ "bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression",
 /*  39 */ "bitwise_xor_expression ::= bitwise_and_expression",
 /*  40 */ "bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression",
 /*  41 */ "bitwise_and_expression ::= equality_expression",
 /*  42 */ "bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression",
 /*  43 */ "equality_expression ::= relational_expression",
 /*  44 */ "equality_expression ::= equality_expression EQUAL relational_expression",
 /*  45 */ "equality_expression ::= equality_expression NOT_EQUAL relational_expression",
 /*  46 */ "relational_expression ::= shift_expression",
 /*  47 */ "relational_expression ::= relational_expression LESS shift_expression",
 /*  48 */ "relational_expression ::= relational_expression GREATER shift_expression",
 /*  49 */ "relational_expression ::= relational_expression LESS_EQUAL shift_expression",
 /*  50 */ "relational_expression ::= relational_expression GREATER_EQUAL shift_expression",
 /*  51 */ "relational_expression ::= relational_expression IN shift_expression",
 /*  52 */ "relational_expression ::= relational_expression MATCH shift_expression",
 /*  53 */ "relational_expression ::= relational_expression NEAR shift_expression",
 /*  54 */ "relational_expression ::= relational_expression NEAR2 shift_expression",
 /*  55 */ "relational_expression ::= relational_expression SIMILAR shift_expression",
 /*  56 */ "relational_expression ::= relational_expression TERM_EXTRACT shift_expression",
 /*  57 */ "relational_expression ::= relational_expression LCP shift_expression",
 /*  58 */ "relational_expression ::= relational_expression PREFIX shift_expression",
 /*  59 */ "relational_expression ::= relational_expression SUFFIX shift_expression",
 /*  60 */ "relational_expression ::= relational_expression REGEXP shift_expression",
 /*  61 */ "shift_expression ::= additive_expression",
 /*  62 */ "shift_expression ::= shift_expression SHIFTL additive_expression",
 /*  63 */ "shift_expression ::= shift_expression SHIFTR additive_expression",
 /*  64 */ "shift_expression ::= shift_expression SHIFTRR additive_expression",
 /*  65 */ "additive_expression ::= multiplicative_expression",
 /*  66 */ "additive_expression ::= additive_expression PLUS multiplicative_expression",
 /*  67 */ "additive_expression ::= additive_expression MINUS multiplicative_expression",
 /*  68 */ "multiplicative_expression ::= unary_expression",
 /*  69 */ "multiplicative_expression ::= multiplicative_expression STAR unary_expression",
 /*  70 */ "multiplicative_expression ::= multiplicative_expression SLASH unary_expression",
 /*  71 */ "multiplicative_expression ::= multiplicative_expression MOD unary_expression",
 /*  72 */ "unary_expression ::= postfix_expression",
 /*  73 */ "unary_expression ::= DELETE unary_expression",
 /*  74 */ "unary_expression ::= INCR unary_expression",
 /*  75 */ "unary_expression ::= DECR unary_expression",
 /*  76 */ "unary_expression ::= PLUS unary_expression",
 /*  77 */ "unary_expression ::= MINUS unary_expression",
 /*  78 */ "unary_expression ::= NOT unary_expression",
 /*  79 */ "unary_expression ::= BITWISE_NOT unary_expression",
 /*  80 */ "unary_expression ::= ADJUST unary_expression",
 /*  81 */ "unary_expression ::= EXACT unary_expression",
 /*  82 */ "unary_expression ::= PARTIAL unary_expression",
 /*  83 */ "unary_expression ::= UNSPLIT unary_expression",
 /*  84 */ "postfix_expression ::= lefthand_side_expression",
 /*  85 */ "postfix_expression ::= lefthand_side_expression INCR",
 /*  86 */ "postfix_expression ::= lefthand_side_expression DECR",
 /*  87 */ "lefthand_side_expression ::= call_expression",
 /*  88 */ "lefthand_side_expression ::= member_expression",
 /*  89 */ "call_expression ::= member_expression arguments",
 /*  90 */ "member_expression ::= primary_expression",
 /*  91 */ "member_expression ::= member_expression member_expression_part",
 /*  92 */ "primary_expression ::= object_literal",
 /*  93 */ "primary_expression ::= PARENL expression PARENR",
 /*  94 */ "primary_expression ::= IDENTIFIER",
 /*  95 */ "primary_expression ::= array_literal",
 /*  96 */ "primary_expression ::= DECIMAL",
 /*  97 */ "primary_expression ::= HEX_INTEGER",
 /*  98 */ "primary_expression ::= STRING",
 /*  99 */ "primary_expression ::= BOOLEAN",
 /* 100 */ "primary_expression ::= NULL",
 /* 101 */ "array_literal ::= BRACKETL elision BRACKETR",
 /* 102 */ "array_literal ::= BRACKETL element_list elision BRACKETR",
 /* 103 */ "array_literal ::= BRACKETL element_list BRACKETR",
 /* 104 */ "elision ::= COMMA",
 /* 105 */ "elision ::= elision COMMA",
 /* 106 */ "element_list ::= assignment_expression",
 /* 107 */ "element_list ::= elision assignment_expression",
 /* 108 */ "element_list ::= element_list elision assignment_expression",
 /* 109 */ "object_literal ::= BRACEL property_name_and_value_list BRACER",
 /* 110 */ "property_name_and_value_list ::=",
 /* 111 */ "property_name_and_value_list ::= property_name_and_value",
 /* 112 */ "property_name_and_value_list ::= property_name_and_value_list COMMA property_name_and_value",
 /* 113 */ "property_name_and_value ::= property_name COLON assignment_expression",
 /* 114 */ "property_name ::= STRING",
 /* 115 */ "member_expression_part ::= BRACKETL expression BRACKETR",
 /* 116 */ "member_expression_part ::= DOT IDENTIFIER",
 /* 117 */ "arguments ::= PARENL argument_list PARENR",
 /* 118 */ "argument_list ::=",
 /* 119 */ "argument_list ::= assignment_expression",
 /* 120 */ "argument_list ::= argument_list COMMA assignment_expression",
 /* 121 */ "output_columns ::=",
 /* 122 */ "output_columns ::= output_column",
 /* 123 */ "output_columns ::= output_columns COMMA output_column",
 /* 124 */ "output_column ::= STAR",
 /* 125 */ "output_column ::= NONEXISTENT_COLUMN",
 /* 126 */ "output_column ::= assignment_expression",
 /* 127 */ "adjuster ::=",
 /* 128 */ "adjuster ::= adjust_expression",
 /* 129 */ "adjuster ::= adjuster PLUS adjust_expression",
 /* 130 */ "adjust_expression ::= adjust_match_expression",
 /* 131 */ "adjust_expression ::= adjust_match_expression STAR DECIMAL",
 /* 132 */ "adjust_match_expression ::= IDENTIFIER MATCH STRING",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to grn_expr_parserAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to grn_expr_parser and grn_expr_parserFree.
*/
void *grn_expr_parserAlloc(void *(*mallocProc)(YYMALLOCARGTYPE)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    pParser->yystack = NULL;
    pParser->yystksz = 0;
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  grn_expr_parserARG_FETCH;
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
    case 75: /* suppress_unused_variable_warning */
{
#line 11 "grn_ecmascript.lemon"

  (void)efsi;

#line 962 "grn_ecmascript.c"
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yyidx>=0 );
  yytos = &pParser->yystack[pParser->yyidx--];
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void grn_expr_parserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
#ifndef YYPARSEFREENEVERNULL
  if( pParser==0 ) return;
#endif
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int grn_expr_parserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>=YY_MIN_REDUCE ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
  do{
    i = yy_shift_ofst[stateno];
    if( i==YY_SHIFT_USE_DFLT ) return yy_default[stateno];
    assert( iLookAhead!=YYNOCODE );
    i += iLookAhead;
    if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
      if( iLookAhead>0 ){
#ifdef YYFALLBACK
        YYCODETYPE iFallback;            /* Fallback token */
        if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
               && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
          }
#endif
          assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
          iLookAhead = iFallback;
          continue;
        }
#endif
#ifdef YYWILDCARD
        {
          int j = i - iLookAhead + YYWILDCARD;
          if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
            j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
            j<YY_ACTTAB_COUNT &&
#endif
            yy_lookahead[j]==YYWILDCARD
          ){
#ifndef NDEBUG
            if( yyTraceFILE ){
              fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
                 yyTracePrompt, yyTokenName[iLookAhead],
                 yyTokenName[YYWILDCARD]);
            }
#endif /* NDEBUG */
            return yy_action[j];
          }
        }
#endif /* YYWILDCARD */
      }
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   grn_expr_parserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   grn_expr_parserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%sShift '%s', go to state %d\n",
         yyTracePrompt,yyTokenName[yypParser->yystack[yypParser->yyidx].major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%sShift '%s'\n",
         yyTracePrompt,yyTokenName[yypParser->yystack[yypParser->yyidx].major]);
    }
  }
}
#else
# define yyTraceShift(X,Y)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor = *yypMinor;
  yyTraceShift(yypParser, yyNewState);
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 76, 1 },
  { 76, 1 },
  { 76, 2 },
  { 76, 2 },
  { 77, 1 },
  { 77, 2 },
  { 77, 3 },
  { 77, 3 },
  { 77, 3 },
  { 81, 1 },
  { 81, 3 },
  { 81, 2 },
  { 81, 3 },
  { 81, 3 },
  { 81, 2 },
  { 78, 1 },
  { 78, 3 },
  { 83, 1 },
  { 83, 3 },
  { 83, 3 },
  { 83, 3 },
  { 83, 3 },
  { 83, 3 },
  { 83, 3 },
  { 83, 3 },
  { 83, 3 },
  { 83, 3 },
  { 83, 3 },
  { 83, 3 },
  { 83, 3 },
  { 84, 1 },
  { 84, 5 },
  { 86, 1 },
  { 86, 3 },
  { 87, 1 },
  { 87, 3 },
  { 87, 3 },
  { 88, 1 },
  { 88, 3 },
  { 89, 1 },
  { 89, 3 },
  { 90, 1 },
  { 90, 3 },
  { 91, 1 },
  { 91, 3 },
  { 91, 3 },
  { 92, 1 },
  { 92, 3 },
  { 92, 3 },
  { 92, 3 },
  { 92, 3 },
  { 92, 3 },
  { 92, 3 },
  { 92, 3 },
  { 92, 3 },
  { 92, 3 },
  { 92, 3 },
  { 92, 3 },
  { 92, 3 },
  { 92, 3 },
  { 92, 3 },
  { 93, 1 },
  { 93, 3 },
  { 93, 3 },
  { 93, 3 },
  { 94, 1 },
  { 94, 3 },
  { 94, 3 },
  { 95, 1 },
  { 95, 3 },
  { 95, 3 },
  { 95, 3 },
  { 96, 1 },
  { 96, 2 },
  { 96, 2 },
  { 96, 2 },
  { 96, 2 },
  { 96, 2 },
  { 96, 2 },
  { 96, 2 },
  { 96, 2 },
  { 96, 2 },
  { 96, 2 },
  { 96, 2 },
  { 97, 1 },
  { 97, 2 },
  { 97, 2 },
  { 85, 1 },
  { 85, 1 },
  { 98, 2 },
  { 99, 1 },
  { 99, 2 },
  { 82, 1 },
  { 82, 3 },
  { 82, 1 },
  { 82, 1 },
  { 82, 1 },
  { 82, 1 },
  { 82, 1 },
  { 82, 1 },
  { 82, 1 },
  { 103, 3 },
  { 103, 4 },
  { 103, 3 },
  { 104, 1 },
  { 104, 2 },
  { 105, 1 },
  { 105, 2 },
  { 105, 3 },
  { 102, 3 },
  { 106, 0 },
  { 106, 1 },
  { 106, 3 },
  { 107, 3 },
  { 108, 1 },
  { 101, 3 },
  { 101, 2 },
  { 100, 3 },
  { 109, 0 },
  { 109, 1 },
  { 109, 3 },
  { 79, 0 },
  { 79, 1 },
  { 79, 3 },
  { 110, 1 },
  { 110, 1 },
  { 110, 1 },
  { 80, 0 },
  { 80, 1 },
  { 80, 3 },
  { 111, 1 },
  { 111, 3 },
  { 112, 3 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  grn_expr_parserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    fprintf(yyTraceFILE, "%sReduce [%s], go to state %d.\n", yyTracePrompt,
      yyRuleName[yyruleno], yymsp[-yysize].stateno);
  }
#endif /* NDEBUG */
  yygotominor = yyzerominor;

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
      case 5: /* query ::= query query_element */
#line 46 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, grn_int32_value_at(&efsi->op_stack, -1), 2);
}
#line 1380 "grn_ecmascript.c"
        break;
      case 6: /* query ::= query LOGICAL_AND query_element */
      case 35: /* logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression */ yytestcase(yyruleno==35);
#line 49 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND, 2);
}
#line 1388 "grn_ecmascript.c"
        break;
      case 7: /* query ::= query LOGICAL_AND_NOT query_element */
      case 36: /* logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression */ yytestcase(yyruleno==36);
#line 52 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND_NOT, 2);
}
#line 1396 "grn_ecmascript.c"
        break;
      case 8: /* query ::= query LOGICAL_OR query_element */
      case 33: /* logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression */ yytestcase(yyruleno==33);
#line 55 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_OR, 2);
}
#line 1404 "grn_ecmascript.c"
        break;
      case 11: /* query_element ::= RELATIVE_OP query_element */
#line 62 "grn_ecmascript.lemon"
{
  int mode;
  GRN_INT32_POP(&efsi->mode_stack, mode);
}
#line 1412 "grn_ecmascript.c"
        break;
      case 12: /* query_element ::= IDENTIFIER RELATIVE_OP query_element */
#line 66 "grn_ecmascript.lemon"
{
  int mode;
  grn_obj *c;
  GRN_PTR_POP(&efsi->column_stack, c);
  GRN_INT32_POP(&efsi->mode_stack, mode);
  switch (mode) {
  case GRN_OP_NEAR :
  case GRN_OP_NEAR2 :
    {
      int max_interval;
      GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    }
    break;
  case GRN_OP_SIMILAR :
    {
      int similarity_threshold;
      GRN_INT32_POP(&efsi->similarity_threshold_stack, similarity_threshold);
    }
    break;
  default :
    break;
  }
}
#line 1439 "grn_ecmascript.c"
        break;
      case 13: /* query_element ::= BRACEL expression BRACER */
      case 14: /* query_element ::= EVAL primary_expression */ yytestcase(yyruleno==14);
#line 89 "grn_ecmascript.lemon"
{
  efsi->flags = efsi->default_flags;
}
#line 1447 "grn_ecmascript.c"
        break;
      case 16: /* expression ::= expression COMMA assignment_expression */
#line 97 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_COMMA, 2);
}
#line 1454 "grn_ecmascript.c"
        break;
      case 18: /* assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression */
#line 102 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ASSIGN, 2);
}
#line 1461 "grn_ecmascript.c"
        break;
      case 19: /* assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression */
#line 105 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_STAR_ASSIGN, 2);
}
#line 1468 "grn_ecmascript.c"
        break;
      case 20: /* assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression */
#line 108 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SLASH_ASSIGN, 2);
}
#line 1475 "grn_ecmascript.c"
        break;
      case 21: /* assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression */
#line 111 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MOD_ASSIGN, 2);
}
#line 1482 "grn_ecmascript.c"
        break;
      case 22: /* assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression */
#line 114 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS_ASSIGN, 2);
}
#line 1489 "grn_ecmascript.c"
        break;
      case 23: /* assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression */
#line 117 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS_ASSIGN, 2);
}
#line 1496 "grn_ecmascript.c"
        break;
      case 24: /* assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression */
#line 120 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTL_ASSIGN, 2);
}
#line 1503 "grn_ecmascript.c"
        break;
      case 25: /* assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression */
#line 123 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTR_ASSIGN, 2);
}
#line 1510 "grn_ecmascript.c"
        break;
      case 26: /* assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression */
#line 126 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTRR_ASSIGN, 2);
}
#line 1517 "grn_ecmascript.c"
        break;
      case 27: /* assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression */
#line 129 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND_ASSIGN, 2);
}
#line 1524 "grn_ecmascript.c"
        break;
      case 28: /* assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression */
#line 132 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_XOR_ASSIGN, 2);
}
#line 1531 "grn_ecmascript.c"
        break;
      case 29: /* assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression */
#line 135 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_OR_ASSIGN, 2);
}
#line 1538 "grn_ecmascript.c"
        break;
      case 31: /* conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression */
#line 140 "grn_ecmascript.lemon"
{
  grn_expr *e = (grn_expr *)efsi->e;
  e->codes[yymsp[-3].minor.yy0].nargs = yymsp[-1].minor.yy0 - yymsp[-3].minor.yy0;
  e->codes[yymsp[-1].minor.yy0].nargs = e->codes_curr - yymsp[-1].minor.yy0 - 1;
}
#line 1547 "grn_ecmascript.c"
        break;
      case 38: /* bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression */
#line 160 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_OR, 2);
}
#line 1554 "grn_ecmascript.c"
        break;
      case 40: /* bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression */
#line 165 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_XOR, 2);
}
#line 1561 "grn_ecmascript.c"
        break;
      case 42: /* bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression */
#line 170 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_AND, 2);
}
#line 1568 "grn_ecmascript.c"
        break;
      case 44: /* equality_expression ::= equality_expression EQUAL relational_expression */
#line 175 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_EQUAL, 2);
}
#line 1575 "grn_ecmascript.c"
        break;
      case 45: /* equality_expression ::= equality_expression NOT_EQUAL relational_expression */
#line 178 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NOT_EQUAL, 2);
}
#line 1582 "grn_ecmascript.c"
        break;
      case 47: /* relational_expression ::= relational_expression LESS shift_expression */
#line 183 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LESS, 2);
}
#line 1589 "grn_ecmascript.c"
        break;
      case 48: /* relational_expression ::= relational_expression GREATER shift_expression */
#line 186 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GREATER, 2);
}
#line 1596 "grn_ecmascript.c"
        break;
      case 49: /* relational_expression ::= relational_expression LESS_EQUAL shift_expression */
#line 189 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LESS_EQUAL, 2);
}
#line 1603 "grn_ecmascript.c"
        break;
      case 50: /* relational_expression ::= relational_expression GREATER_EQUAL shift_expression */
#line 192 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GREATER_EQUAL, 2);
}
#line 1610 "grn_ecmascript.c"
        break;
      case 51: /* relational_expression ::= relational_expression IN shift_expression */
#line 195 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_IN, 2);
}
#line 1617 "grn_ecmascript.c"
        break;
      case 52: /* relational_expression ::= relational_expression MATCH shift_expression */
      case 132: /* adjust_match_expression ::= IDENTIFIER MATCH STRING */ yytestcase(yyruleno==132);
#line 198 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MATCH, 2);
}
#line 1625 "grn_ecmascript.c"
        break;
      case 53: /* relational_expression ::= relational_expression NEAR shift_expression */
#line 201 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR, 2);
}
#line 1632 "grn_ecmascript.c"
        break;
      case 54: /* relational_expression ::= relational_expression NEAR2 shift_expression */
#line 204 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR2, 2);
}
#line 1639 "grn_ecmascript.c"
        break;
      case 55: /* relational_expression ::= relational_expression SIMILAR shift_expression */
#line 207 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SIMILAR, 2);
}
#line 1646 "grn_ecmascript.c"
        break;
      case 56: /* relational_expression ::= relational_expression TERM_EXTRACT shift_expression */
#line 210 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_TERM_EXTRACT, 2);
}
#line 1653 "grn_ecmascript.c"
        break;
      case 57: /* relational_expression ::= relational_expression LCP shift_expression */
#line 213 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LCP, 2);
}
#line 1660 "grn_ecmascript.c"
        break;
      case 58: /* relational_expression ::= relational_expression PREFIX shift_expression */
#line 216 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PREFIX, 2);
}
#line 1667 "grn_ecmascript.c"
        break;
      case 59: /* relational_expression ::= relational_expression SUFFIX shift_expression */
#line 219 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SUFFIX, 2);
}
#line 1674 "grn_ecmascript.c"
        break;
      case 60: /* relational_expression ::= relational_expression REGEXP shift_expression */
#line 222 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_REGEXP, 2);
}
#line 1681 "grn_ecmascript.c"
        break;
      case 62: /* shift_expression ::= shift_expression SHIFTL additive_expression */
#line 227 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTL, 2);
}
#line 1688 "grn_ecmascript.c"
        break;
      case 63: /* shift_expression ::= shift_expression SHIFTR additive_expression */
#line 230 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTR, 2);
}
#line 1695 "grn_ecmascript.c"
        break;
      case 64: /* shift_expression ::= shift_expression SHIFTRR additive_expression */
#line 233 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTRR, 2);
}
#line 1702 "grn_ecmascript.c"
        break;
      case 66: /* additive_expression ::= additive_expression PLUS multiplicative_expression */
      case 129: /* adjuster ::= adjuster PLUS adjust_expression */ yytestcase(yyruleno==129);
#line 238 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS, 2);
}
#line 1710 "grn_ecmascript.c"
        break;
      case 67: /* additive_expression ::= additive_expression MINUS multiplicative_expression */
#line 241 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS, 2);
}
#line 1717 "grn_ecmascript.c"
        break;
      case 69: /* multiplicative_expression ::= multiplicative_expression STAR unary_expression */
      case 131: /* adjust_expression ::= adjust_match_expression STAR DECIMAL */ yytestcase(yyruleno==131);
#line 246 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_STAR, 2);
}
#line 1725 "grn_ecmascript.c"
        break;
      case 70: /* multiplicative_expression ::= multiplicative_expression SLASH unary_expression */
#line 249 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SLASH, 2);
}
#line 1732 "grn_ecmascript.c"
        break;
      case 71: /* multiplicative_expression ::= multiplicative_expression MOD unary_expression */
#line 252 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MOD, 2);
}
#line 1739 "grn_ecmascript.c"
        break;
      case 73: /* unary_expression ::= DELETE unary_expression */
#line 257 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DELETE, 1);
}
#line 1746 "grn_ecmascript.c"
        break;
      case 74: /* unary_expression ::= INCR unary_expression */
#line 260 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be incremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_INCR, 1);
  }
}
#line 1767 "grn_ecmascript.c"
        break;
      case 75: /* unary_expression ::= DECR unary_expression */
#line 277 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be decremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DECR, 1);
  }
}
#line 1788 "grn_ecmascript.c"
        break;
      case 76: /* unary_expression ::= PLUS unary_expression */
#line 294 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS, 1);
}
#line 1795 "grn_ecmascript.c"
        break;
      case 77: /* unary_expression ::= MINUS unary_expression */
#line 297 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS, 1);
}
#line 1802 "grn_ecmascript.c"
        break;
      case 78: /* unary_expression ::= NOT unary_expression */
#line 300 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NOT, 1);
}
#line 1809 "grn_ecmascript.c"
        break;
      case 79: /* unary_expression ::= BITWISE_NOT unary_expression */
#line 303 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_NOT, 1);
}
#line 1816 "grn_ecmascript.c"
        break;
      case 80: /* unary_expression ::= ADJUST unary_expression */
#line 306 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ADJUST, 1);
}
#line 1823 "grn_ecmascript.c"
        break;
      case 81: /* unary_expression ::= EXACT unary_expression */
#line 309 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_EXACT, 1);
}
#line 1830 "grn_ecmascript.c"
        break;
      case 82: /* unary_expression ::= PARTIAL unary_expression */
#line 312 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PARTIAL, 1);
}
#line 1837 "grn_ecmascript.c"
        break;
      case 83: /* unary_expression ::= UNSPLIT unary_expression */
#line 315 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_UNSPLIT, 1);
}
#line 1844 "grn_ecmascript.c"
        break;
      case 85: /* postfix_expression ::= lefthand_side_expression INCR */
#line 320 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be incremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_INCR_POST, 1);
  }
}
#line 1865 "grn_ecmascript.c"
        break;
      case 86: /* postfix_expression ::= lefthand_side_expression DECR */
#line 337 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be decremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DECR_POST, 1);
  }
}
#line 1886 "grn_ecmascript.c"
        break;
      case 89: /* call_expression ::= member_expression arguments */
#line 358 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_CALL, yymsp[0].minor.yy0);
}
#line 1893 "grn_ecmascript.c"
        break;
      case 109: /* object_literal ::= BRACEL property_name_and_value_list BRACER */
#line 386 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr_take_obj(ctx, efsi->e, (grn_obj *)(efsi->object_literal));
  grn_expr_append_obj(ctx, efsi->e, (grn_obj *)(efsi->object_literal),
                      GRN_OP_PUSH, 1);
  efsi->object_literal = NULL;
}
#line 1904 "grn_ecmascript.c"
        break;
      case 110: /* property_name_and_value_list ::= */
#line 394 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;

  efsi->object_literal =
    grn_hash_create(ctx, NULL, GRN_TABLE_MAX_KEY_SIZE, sizeof(grn_obj),
                    GRN_OBJ_KEY_VAR_SIZE|GRN_OBJ_TEMPORARY|GRN_HASH_TINY);
  if (!efsi->object_literal) {
    ERR(GRN_NO_MEMORY_AVAILABLE,
        "couldn't create hash table for parsing object literal: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  }
}
#line 1920 "grn_ecmascript.c"
        break;
      case 113: /* property_name_and_value ::= property_name COLON assignment_expression */
#line 409 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_obj *property = e->codes[e->codes_curr - 3].value;
  grn_obj *value = e->codes[e->codes_curr - 1].value;

  if (!efsi->object_literal) {
     efsi->object_literal =
       grn_hash_create(ctx, NULL, GRN_TABLE_MAX_KEY_SIZE, sizeof(grn_obj),
                       GRN_OBJ_KEY_VAR_SIZE|GRN_OBJ_TEMPORARY|GRN_HASH_TINY);
  }

  if (!efsi->object_literal) {
    ERR(GRN_NO_MEMORY_AVAILABLE,
        "couldn't create hash table for parsing object literal: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_obj *buf;
    int added;
    if (grn_hash_add(ctx, (grn_hash *)efsi->object_literal,
                     GRN_TEXT_VALUE(property), GRN_TEXT_LEN(property),
                     (void **)&buf, &added)) {
      if (added) {
        GRN_OBJ_INIT(buf, value->header.type, 0, value->header.domain);
        GRN_TEXT_PUT(ctx, buf, GRN_TEXT_VALUE(value), GRN_TEXT_LEN(value));
        e->codes_curr -= 3;
      } else {
        ERR(GRN_INVALID_ARGUMENT,
            "duplicated property name: <%.*s>",
            (int)GRN_TEXT_LEN(property),
            GRN_TEXT_VALUE(property));
      }
    } else {
      ERR(GRN_NO_MEMORY_AVAILABLE,
          "failed to add a property to object literal: <%.*s>",
          (int)GRN_TEXT_LEN(property),
          GRN_TEXT_VALUE(property));
    }
  }
}
#line 1964 "grn_ecmascript.c"
        break;
      case 115: /* member_expression_part ::= BRACKETL expression BRACKETR */
#line 452 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GET_MEMBER, 2);
}
#line 1971 "grn_ecmascript.c"
        break;
      case 117: /* arguments ::= PARENL argument_list PARENR */
#line 457 "grn_ecmascript.lemon"
{ yygotominor.yy0 = yymsp[-1].minor.yy0; }
#line 1976 "grn_ecmascript.c"
        break;
      case 118: /* argument_list ::= */
#line 458 "grn_ecmascript.lemon"
{ yygotominor.yy0 = 0; }
#line 1981 "grn_ecmascript.c"
        break;
      case 119: /* argument_list ::= assignment_expression */
#line 459 "grn_ecmascript.lemon"
{ yygotominor.yy0 = 1; }
#line 1986 "grn_ecmascript.c"
        break;
      case 120: /* argument_list ::= argument_list COMMA assignment_expression */
#line 460 "grn_ecmascript.lemon"
{ yygotominor.yy0 = yymsp[-2].minor.yy0 + 1; }
#line 1991 "grn_ecmascript.c"
        break;
      case 121: /* output_columns ::= */
#line 462 "grn_ecmascript.lemon"
{
  yygotominor.yy0 = 0;
}
#line 1998 "grn_ecmascript.c"
        break;
      case 122: /* output_columns ::= output_column */
#line 465 "grn_ecmascript.lemon"
{
  if (yymsp[0].minor.yy0) {
    yygotominor.yy0 = 0;
  } else {
    yygotominor.yy0 = 1;
  }
}
#line 2009 "grn_ecmascript.c"
        break;
      case 123: /* output_columns ::= output_columns COMMA output_column */
#line 473 "grn_ecmascript.lemon"
{
  if (yymsp[0].minor.yy0) {
    yygotominor.yy0 = yymsp[-2].minor.yy0;
  } else {
    if (yymsp[-2].minor.yy0 == 1) {
      grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_COMMA, 2);
    }
    yygotominor.yy0 = 1;
  }
}
#line 2023 "grn_ecmascript.c"
        break;
      case 124: /* output_column ::= STAR */
#line 484 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_obj *expr = efsi->e;
  grn_expr *e = (grn_expr *)expr;
  grn_obj *variable = grn_expr_get_var_by_offset(ctx, expr, 0);
  if (variable) {
    grn_id table_id = GRN_OBJ_GET_DOMAIN(variable);
    grn_obj *table = grn_ctx_at(ctx, table_id);
    grn_obj columns_buffer;
    grn_obj **columns;
    int i, n_columns;

    GRN_PTR_INIT(&columns_buffer, GRN_OBJ_VECTOR, GRN_ID_NIL);
    grn_obj_columns(ctx, table, "*", strlen("*"), &columns_buffer);
    n_columns = GRN_BULK_VSIZE(&columns_buffer) / sizeof(grn_obj *);
    columns = (grn_obj **)GRN_BULK_HEAD(&columns_buffer);

    for (i = 0; i < n_columns; i++) {
      if (i > 0) {
        grn_expr_append_op(ctx, expr, GRN_OP_COMMA, 2);
      }
      grn_expr_append_const(ctx, expr, columns[i], GRN_OP_GET_VALUE, 1);
      GRN_PTR_PUT(ctx, &e->objs, columns[i]);
    }

    GRN_OBJ_FIN(ctx, &columns_buffer);

    if (n_columns > 0) {
      yygotominor.yy0 = GRN_FALSE;
    } else {
      yygotominor.yy0 = GRN_TRUE;
    }
  } else {
    /* TODO: report error */
    yygotominor.yy0 = GRN_TRUE;
  }
}
#line 2064 "grn_ecmascript.c"
        break;
      case 125: /* output_column ::= NONEXISTENT_COLUMN */
#line 521 "grn_ecmascript.lemon"
{
  yygotominor.yy0 = GRN_TRUE;
}
#line 2071 "grn_ecmascript.c"
        break;
      case 126: /* output_column ::= assignment_expression */
#line 524 "grn_ecmascript.lemon"
{
  yygotominor.yy0 = GRN_FALSE;
}
#line 2078 "grn_ecmascript.c"
        break;
      default:
      /* (0) input ::= query */ yytestcase(yyruleno==0);
      /* (1) input ::= expression */ yytestcase(yyruleno==1);
      /* (2) input ::= START_OUTPUT_COLUMNS output_columns */ yytestcase(yyruleno==2);
      /* (3) input ::= START_ADJUSTER adjuster */ yytestcase(yyruleno==3);
      /* (4) query ::= query_element */ yytestcase(yyruleno==4);
      /* (9) query_element ::= QSTRING */ yytestcase(yyruleno==9);
      /* (10) query_element ::= PARENL query PARENR */ yytestcase(yyruleno==10);
      /* (15) expression ::= assignment_expression */ yytestcase(yyruleno==15);
      /* (17) assignment_expression ::= conditional_expression */ yytestcase(yyruleno==17);
      /* (30) conditional_expression ::= logical_or_expression */ yytestcase(yyruleno==30);
      /* (32) logical_or_expression ::= logical_and_expression */ yytestcase(yyruleno==32);
      /* (34) logical_and_expression ::= bitwise_or_expression */ yytestcase(yyruleno==34);
      /* (37) bitwise_or_expression ::= bitwise_xor_expression */ yytestcase(yyruleno==37);
      /* (39) bitwise_xor_expression ::= bitwise_and_expression */ yytestcase(yyruleno==39);
      /* (41) bitwise_and_expression ::= equality_expression */ yytestcase(yyruleno==41);
      /* (43) equality_expression ::= relational_expression */ yytestcase(yyruleno==43);
      /* (46) relational_expression ::= shift_expression */ yytestcase(yyruleno==46);
      /* (61) shift_expression ::= additive_expression */ yytestcase(yyruleno==61);
      /* (65) additive_expression ::= multiplicative_expression */ yytestcase(yyruleno==65);
      /* (68) multiplicative_expression ::= unary_expression */ yytestcase(yyruleno==68);
      /* (72) unary_expression ::= postfix_expression */ yytestcase(yyruleno==72);
      /* (84) postfix_expression ::= lefthand_side_expression */ yytestcase(yyruleno==84);
      /* (87) lefthand_side_expression ::= call_expression */ yytestcase(yyruleno==87);
      /* (88) lefthand_side_expression ::= member_expression */ yytestcase(yyruleno==88);
      /* (90) member_expression ::= primary_expression */ yytestcase(yyruleno==90);
      /* (91) member_expression ::= member_expression member_expression_part */ yytestcase(yyruleno==91);
      /* (92) primary_expression ::= object_literal */ yytestcase(yyruleno==92);
      /* (93) primary_expression ::= PARENL expression PARENR */ yytestcase(yyruleno==93);
      /* (94) primary_expression ::= IDENTIFIER */ yytestcase(yyruleno==94);
      /* (95) primary_expression ::= array_literal */ yytestcase(yyruleno==95);
      /* (96) primary_expression ::= DECIMAL */ yytestcase(yyruleno==96);
      /* (97) primary_expression ::= HEX_INTEGER */ yytestcase(yyruleno==97);
      /* (98) primary_expression ::= STRING */ yytestcase(yyruleno==98);
      /* (99) primary_expression ::= BOOLEAN */ yytestcase(yyruleno==99);
      /* (100) primary_expression ::= NULL */ yytestcase(yyruleno==100);
      /* (101) array_literal ::= BRACKETL elision BRACKETR */ yytestcase(yyruleno==101);
      /* (102) array_literal ::= BRACKETL element_list elision BRACKETR */ yytestcase(yyruleno==102);
      /* (103) array_literal ::= BRACKETL element_list BRACKETR */ yytestcase(yyruleno==103);
      /* (104) elision ::= COMMA */ yytestcase(yyruleno==104);
      /* (105) elision ::= elision COMMA */ yytestcase(yyruleno==105);
      /* (106) element_list ::= assignment_expression */ yytestcase(yyruleno==106);
      /* (107) element_list ::= elision assignment_expression */ yytestcase(yyruleno==107);
      /* (108) element_list ::= element_list elision assignment_expression */ yytestcase(yyruleno==108);
      /* (111) property_name_and_value_list ::= property_name_and_value */ yytestcase(yyruleno==111);
      /* (112) property_name_and_value_list ::= property_name_and_value_list COMMA property_name_and_value */ yytestcase(yyruleno==112);
      /* (114) property_name ::= STRING */ yytestcase(yyruleno==114);
      /* (116) member_expression_part ::= DOT IDENTIFIER */ yytestcase(yyruleno==116);
      /* (127) adjuster ::= */ yytestcase(yyruleno==127);
      /* (128) adjuster ::= adjust_expression */ yytestcase(yyruleno==128);
      /* (130) adjust_expression ::= adjust_match_expression */ yytestcase(yyruleno==130);
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno>=0 && yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact <= YY_MAX_SHIFTREDUCE ){
    if( yyact>YY_MAX_SHIFT ) yyact += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
    /* If the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = (YYACTIONTYPE)yyact;
      yymsp->major = (YYCODETYPE)yygoto;
      yymsp->minor = yygotominor;
      yyTraceShift(yypParser, yyact);
    }else{
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else{
    assert( yyact == YY_ACCEPT_ACTION );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  grn_expr_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  grn_expr_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  grn_expr_parserARG_FETCH;
#define TOKEN (yyminor.yy0)
/************ Begin %syntax_error code ****************************************/
#line 17 "grn_ecmascript.lemon"

  {
    grn_ctx *ctx = efsi->ctx;
    if (ctx->rc == GRN_SUCCESS) {
      grn_obj message;
      GRN_TEXT_INIT(&message, 0);
      GRN_TEXT_PUT(ctx, &message, efsi->str, efsi->cur - efsi->str);
      GRN_TEXT_PUTC(ctx, &message, '|');
      if (efsi->cur < efsi->str_end) {
        GRN_TEXT_PUTC(ctx, &message, efsi->cur[0]);
        GRN_TEXT_PUTC(ctx, &message, '|');
        GRN_TEXT_PUT(ctx, &message,
                     efsi->cur + 1, efsi->str_end - (efsi->cur + 1));
      } else {
        GRN_TEXT_PUTC(ctx, &message, '|');
      }
      ERR(GRN_SYNTAX_ERROR, "Syntax error: <%.*s>",
          (int)GRN_TEXT_LEN(&message), GRN_TEXT_VALUE(&message));
      GRN_OBJ_FIN(ctx, &message);
    }
  }
#line 2216 "grn_ecmascript.c"
/************ End %syntax_error code ******************************************/
  grn_expr_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  grn_expr_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  grn_expr_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "grn_expr_parserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void grn_expr_parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  grn_expr_parserTOKENTYPE yyminor       /* The value for the token */
  grn_expr_parserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sInitialize. Empty stack. State 0\n",
              yyTracePrompt);
    }
#endif
  }
  yyminorunion.yy0 = yyminor;
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif
  grn_expr_parserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput '%s'\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact <= YY_MAX_SHIFTREDUCE ){
      if( yyact > YY_MAX_SHIFT ) yyact += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact <= YY_MAX_REDUCE ){
      yy_reduce(yypParser,yyact-YY_MIN_REDUCE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YY_MIN_REDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor,yyminorunion);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      yymajor = YYNOCODE;
      
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
#ifndef NDEBUG
  if( yyTraceFILE ){
    int i;
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE,"%c%s", i==1 ? '[' : ' ', 
              yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}
