/*

    Data automatically generated from recode output:

        'recode -lf "CP1255" 2>/dev/null'


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

*/

#ifndef cp1255_h
#define cp1255_h

#define cet_cs_name_cp1255 "CP1255"

const char *cet_cs_alias_cp1255[] = 
{
	"CP1255", "1255", "ms-hebr", "windows-1255", "WIN-CP1255",
	NULL
};

#define cet_ucs4_ofs_cp1255 128
#define cet_ucs4_cnt_cp1255 127

const int cet_ucs4_map_cp1255[cet_ucs4_cnt_cp1255] =
{
	0x20ac,     -1, 0x201a, 0x0192, 0x201e, 0x2026, 0x2020, 0x2021, 
	    -1, 0x2030,     -1, 0x2039,     -1,     -1,     -1,     -1, 
	    -1, 0x2018, 0x2019, 0x201c, 0x201d, 0x2022, 0x2013, 0x2014, 
	    -1, 0x2122,     -1, 0x203a,     -1,     -1,     -1,     -1, 
	0x00a0,     -1, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7, 
	0x00a8, 0x00a9, 0x00d7, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x203e, 
	0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7, 
	0x00b8, 0x00b9, 0x00f7, 0x00bb, 0x00bc, 0x00bd, 0x00be,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1, 0x2017, 
	0x05d0, 0x05d1, 0x05d2, 0x05d3, 0x05d4, 0x05d5, 0x05d6, 0x05d7, 
	0x05d8, 0x05d9, 0x05da, 0x05db, 0x05dc, 0x05dd, 0x05de, 0x05df, 
	0x05e0, 0x05e1, 0x05e2, 0x05e3, 0x05e4, 0x05e5, 0x05e6, 0x05e7, 
	0x05e8, 0x05e9, 0x05ea,     -1,     -1, 0x200e, 0x200f
};

#define cet_ucs4_to_cp1255_ct 51

const cet_ucs4_link_t cet_ucs4_to_cp1255_links[cet_ucs4_to_cp1255_ct] =
{
	 {0x00d7, 0xaa} /* sign */,
	 {0x00f7, 0xba} /* sign */,
	 {0x0192, 0x83} /* minuscule latine f hameon */,
	 {0x05d0, 0xe0} /* letter alef */,
	 {0x05d1, 0xe1} /* letter bet */,
	 {0x05d2, 0xe2} /* letter gimel */,
	 {0x05d3, 0xe3} /* letter dalet */,
	 {0x05d4, 0xe4} /* letter he */,
	 {0x05d5, 0xe5} /* letter vav */,
	 {0x05d6, 0xe6} /* letter zayin */,
	 {0x05d7, 0xe7} /* letter het */,
	 {0x05d8, 0xe8} /* letter tet */,
	 {0x05d9, 0xe9} /* letter yod */,
	 {0x05da, 0xea} /* letter final kaf */,
	 {0x05db, 0xeb} /* letter kaf */,
	 {0x05dc, 0xec} /* letter lamed */,
	 {0x05dd, 0xed} /* letter final mem */,
	 {0x05de, 0xee} /* letter mem */,
	 {0x05df, 0xef} /* letter final nun */,
	 {0x05e0, 0xf0} /* letter nun */,
	 {0x05e1, 0xf1} /* letter samekh */,
	 {0x05e2, 0xf2} /* letter ayin */,
	 {0x05e3, 0xf3} /* letter final pe */,
	 {0x05e4, 0xf4} /* letter pe */,
	 {0x05e5, 0xf5} /* letter final tsadi */,
	 {0x05e6, 0xf6} /* letter tsadi */,
	 {0x05e7, 0xf7} /* letter qof */,
	 {0x05e8, 0xf8} /* letter resh */,
	 {0x05e9, 0xf9} /* letter shin */,
	 {0x05ea, 0xfa} /* letter tav */,
	 {0x200e, 0xfd} /* gauche--droite */,
	 {0x200f, 0xfe} /* droite--gauche */,
	 {0x2013, 0x96} /* dash */,
	 {0x2014, 0x97} /* dash */,
	 {0x2017, 0xdf} /* low line */,
	 {0x2018, 0x91} /* single quotation mark */,
	 {0x2019, 0x92} /* single quotation mark */,
	 {0x201a, 0x82} /* low-9 quotation mark */,
	 {0x201c, 0x93} /* double quotation mark */,
	 {0x201d, 0x94} /* double quotation mark */,
	 {0x201e, 0x84} /* low-9 quotation mark */,
	 {0x2020, 0x86} /* dagger */,
	 {0x2021, 0x87} /* dagger */,
	 {0x2022, 0x95} /* puce */,
	 {0x2026, 0x85} /* horizontal ellipsis */,
	 {0x2030, 0x89} /* mille sign */,
	 {0x2039, 0x8b} /* left-pointing angle quotation mark */,
	 {0x203a, 0x9b} /* right-pointing angle quotation mark */,
	 {0x203e, 0xaf} /* overline */,
	 {0x20ac, 0x80} /* euro */,
	 {0x2122, 0x99} /* mark sign */
};

/* Extra table was generated from bestfit1255.txt located at
   ftp.unicode.org:/Public/MAPPINGS/VENDORS/MICSFT/WindowsBestFit/ */
  
const cet_ucs4_link_t cet_ucs4_to_cp1255_extra[] = 
{
	{0x02c6, 0x88} /* modifier letter circumflex */,
	{0x02dc, 0x98} /* spacing tilde */,
	{0x05b0, 0xc0} /* hebrew point sheva */,
	{0x05b1, 0xc1} /* hebrew point hataf segol */,
	{0x05b2, 0xc2} /* hebrew point hataf patah */,
	{0x05b3, 0xc3} /* hebrew point hataf qamats */,
	{0x05b4, 0xc4} /* hebrew point hiriq */,
	{0x05b5, 0xc5} /* hebrew point tsere */,
	{0x05b6, 0xc6} /* hebrew point segol */,
	{0x05b7, 0xc7} /* hebrew point patah */,
	{0x05b8, 0xc8} /* hebrew point qamats */,
	{0x05b9, 0xc9} /* hebrew point holam */,
	{0x05ba, 0xca} /* hebrew point ???? */,
	{0x05bb, 0xcb} /* hebrew point qubuts */,
	{0x05bc, 0xcc} /* hebrew point dagesh */,
	{0x05bd, 0xcd} /* hebrew point meteg */,
	{0x05be, 0xce} /* hebrew punctuation maqaf */,
	{0x05bf, 0xcf} /* hebrew point rafe */,
	{0x05c0, 0xd0} /* hebrew point paseq */,
	{0x05c1, 0xd1} /* hebrew point shin dot */,
	{0x05c2, 0xd2} /* hebrew point sin dot */,
	{0x05c3, 0xd3} /* hebrew punctuation sof pasuq */,
	{0x05f0, 0xd4} /* hebrew ligature yiddish double vav */,
	{0x05f1, 0xd5} /* hebrew ligature yiddish vav yod */,
	{0x05f2, 0xd6} /* hebrew ligature yiddish double yod */,
	{0x05f3, 0xd7} /* hebrew punctuation geresh */,
	{0x05f4, 0xd8} /* hebrew punctuation gershayim */,
	{0x20aa, 0xa4} /* new sheqel sign */
};

#define cet_ucs4_to_cp1255_extra_ct sizeof(cet_ucs4_to_cp1255_extra) / sizeof(cet_ucs4_to_cp1255_extra[0])

cet_cs_vec_t cet_cs_vec_cp1255 =	/* defined in cet.h */
{	
	cet_cs_name_cp1255,		/* name of character set	*/
	cet_cs_alias_cp1255,		/* alias table			*/

	NULL,				/* ... to UCS-4 converter (multi-byte) */
	NULL,				/* UCS-4 to ... converter (multi-byte) */

	cet_ucs4_map_cp1255,		/* char to UCS-4 value table	*/
	cet_ucs4_ofs_cp1255,		/* first non standard character	*/
	cet_ucs4_cnt_cp1255,		/* number of values in table	*/

	cet_ucs4_to_cp1255_links,	/* UCS-4 to char links		*/
	cet_ucs4_to_cp1255_ct,		/* number of links		*/

	cet_ucs4_to_cp1255_extra,	/* hand made UCS-4 links	*/
	cet_ucs4_to_cp1255_extra_ct,	/* number of extra links	*/

	NULL	/* for internal use */
};


/*
const int cp1255_ucs4_full_map[] =
{
	0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 
	0x0008, 0x0009, 0x000a, 0x000b, 0x000c, 0x000d, 0x000e, 0x000f, 
	0x0010, 0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017, 
	0x0018, 0x0019, 0x001a, 0x001b, 0x001c, 0x001d, 0x001e, 0x001f, 
	0x0020, 0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 
	0x0028, 0x0029, 0x002a, 0x002b, 0x002c, 0x002d, 0x002e, 0x002f, 
	0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 
	0x0038, 0x0039, 0x003a, 0x003b, 0x003c, 0x003d, 0x003e, 0x003f, 
	0x0040, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 
	0x0048, 0x0049, 0x004a, 0x004b, 0x004c, 0x004d, 0x004e, 0x004f, 
	0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 
	0x0058, 0x0059, 0x005a, 0x005b, 0x005c, 0x005d, 0x005e, 0x005f, 
	0x0060, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 
	0x0068, 0x0069, 0x006a, 0x006b, 0x006c, 0x006d, 0x006e, 0x006f, 
	0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 
	0x0078, 0x0079, 0x007a, 0x007b, 0x007c, 0x007d, 0x007e, 0x007f, 
	0x20ac,     -1, 0x201a, 0x0192, 0x201e, 0x2026, 0x2020, 0x2021, 
	    -1, 0x2030,     -1, 0x2039,     -1,     -1,     -1,     -1, 
	    -1, 0x2018, 0x2019, 0x201c, 0x201d, 0x2022, 0x2013, 0x2014, 
	    -1, 0x2122,     -1, 0x203a,     -1,     -1,     -1,     -1, 
	0x00a0,     -1, 0x00a2, 0x00a3, 0x00a4, 0x00a5, 0x00a6, 0x00a7, 
	0x00a8, 0x00a9, 0x00d7, 0x00ab, 0x00ac, 0x00ad, 0x00ae, 0x203e, 
	0x00b0, 0x00b1, 0x00b2, 0x00b3, 0x00b4, 0x00b5, 0x00b6, 0x00b7, 
	0x00b8, 0x00b9, 0x00f7, 0x00bb, 0x00bc, 0x00bd, 0x00be,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1,     -1, 
	    -1,     -1,     -1,     -1,     -1,     -1,     -1, 0x2017, 
	0x05d0, 0x05d1, 0x05d2, 0x05d3, 0x05d4, 0x05d5, 0x05d6, 0x05d7, 
	0x05d8, 0x05d9, 0x05da, 0x05db, 0x05dc, 0x05dd, 0x05de, 0x05df, 
	0x05e0, 0x05e1, 0x05e2, 0x05e3, 0x05e4, 0x05e5, 0x05e6, 0x05e7, 
	0x05e8, 0x05e9, 0x05ea,     -1,     -1, 0x200e, 0x200f,     -1
};
*/

#endif
