/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.CRC;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgDefinitionListener;
import com.garmin.fit.MesgListener;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.List;

public class BufferEncoder
implements MesgListener,
MesgDefinitionListener {
    private ByteArrayOutputStream byteOutStream;
    private DataOutputStream dataOutStream;
    private MesgDefinition[] lastMesgDefinition = new MesgDefinition[16];

    public BufferEncoder() {
        this.byteOutStream = new ByteArrayOutputStream();
        this.dataOutStream = new DataOutputStream(this.byteOutStream);
        this.open();
    }

    public void open() {
        this.byteOutStream.reset();
        this.writeFileHeader();
    }

    private void writeFileHeader() {
        this.byteOutStream.write(14);
        this.byteOutStream.write(16);
        this.byteOutStream.write(176);
        this.byteOutStream.write(4);
        this.byteOutStream.write(0);
        this.byteOutStream.write(0);
        this.byteOutStream.write(0);
        this.byteOutStream.write(0);
        this.byteOutStream.write(46);
        this.byteOutStream.write(70);
        this.byteOutStream.write(73);
        this.byteOutStream.write(84);
        this.byteOutStream.write(0);
        this.byteOutStream.write(0);
    }

    @Override
    public void onMesg(Mesg mesg) {
        this.write(mesg);
    }

    @Override
    public void onMesgDefinition(MesgDefinition mesgDefinition) {
        this.write(mesgDefinition);
    }

    public void write(MesgDefinition mesgDefinition) {
        mesgDefinition.write(this.dataOutStream);
        this.lastMesgDefinition[mesgDefinition.localNum] = mesgDefinition;
    }

    public void write(Mesg mesg) {
        if (this.lastMesgDefinition[mesg.localNum] == null || !this.lastMesgDefinition[mesg.localNum].supports(mesg)) {
            this.write(new MesgDefinition(mesg));
        }
        mesg.write(this.dataOutStream, this.lastMesgDefinition[mesg.localNum]);
    }

    public void write(List<Mesg> list) {
        for (Mesg mesg : list) {
            this.write(mesg);
        }
    }

    public byte[] close() {
        int n;
        this.byteOutStream.write(0);
        this.byteOutStream.write(0);
        byte[] byArray = this.byteOutStream.toByteArray();
        long l = byArray.length - 14 - 2;
        byArray[4] = (byte)(l & 0xFFL);
        byArray[5] = (byte)(l >> 8 & 0xFFL);
        byArray[6] = (byte)(l >> 16 & 0xFFL);
        byArray[7] = (byte)(l >> 24 & 0xFFL);
        int n2 = 0;
        for (n = 0; n < 12; ++n) {
            n2 = CRC.get16(n2, byArray[n]);
        }
        byArray[12] = (byte)(n2 & 0xFF);
        byArray[13] = (byte)(n2 >> 8 & 0xFF);
        n2 = 0;
        for (n = 0; n < byArray.length - 2; ++n) {
            n2 = CRC.get16(n2, byArray[n]);
        }
        byArray[byArray.length - 2] = (byte)(n2 & 0xFF);
        byArray[byArray.length - 1] = (byte)(n2 >> 8 & 0xFF);
        this.open();
        return byArray;
    }
}

