/**
 * Go SDK for OpenFGA
 *
 * API version: 0.1
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://discord.gg/8naAwJfWN6
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"bytes"
	_context "context"
	_ioutil "io/ioutil"
	_nethttp "net/http"
	_neturl "net/url"
	"strings"
	"time"

	"github.com/openfga/go-sdk/internal/utils"
)

// Linger please
var (
	_ _context.Context
)

type OpenFgaApi interface {

	/*
		 * Check Check whether a user is authorized to access an object
		 * The Check API queries to check if the user has a certain relationship with an object in a certain store.
	A `contextual_tuples` object may also be included in the body of the request. This object contains one field `tuple_keys`, which is an array of tuple keys. Each of these tuples may have an associated `condition`.
	You may also provide an `authorization_model_id` in the body. This will be used to assert that the input `tuple_key` is valid for the model specified. If not specified, the assertion will be made against the latest authorization model ID. It is strongly recommended to specify authorization model id for better performance.
	You may also provide a `context` object that will be used to evaluate the conditioned tuples in the system. It is strongly recommended to provide a value for all the input parameters of all the conditions, to ensure that all tuples be evaluated correctly.
	The response will return whether the relationship exists in the field `allowed`.

	## Example
	In order to check if user `user:anne` of type `user` has a `reader` relationship with object `document:2021-budget` given the following contextual tuple
	```json
	{
	  "user": "user:anne",
	  "relation": "member",
	  "object": "time_slot:office_hours"
	}
	```
	the Check API can be used with the following request body:
	```json
	{
	  "tuple_key": {
	    "user": "user:anne",
	    "relation": "reader",
	    "object": "document:2021-budget"
	  },
	  "contextual_tuples": {
	    "tuple_keys": [
	      {
	        "user": "user:anne",
	        "relation": "member",
	        "object": "time_slot:office_hours"
	      }
	    ]
	  },
	  "authorization_model_id": "01G50QVV17PECNVAHX1GG4Y5NC"
	}
	```
	OpenFGA's response will include `{ "allowed": true }` if there is a relationship and `{ "allowed": false }` if there isn't.
		 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
		 * @return ApiCheckRequest
	*/
	Check(ctx _context.Context) ApiCheckRequest

	/*
	 * CheckExecute executes the request
	 * @return CheckResponse
	 */
	CheckExecute(r ApiCheckRequest) (CheckResponse, *_nethttp.Response, error)

	/*
	 * CreateStore Create a store
	 * Create a unique OpenFGA store which will be used to store authorization models and relationship tuples.
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return ApiCreateStoreRequest
	 */
	CreateStore(ctx _context.Context) ApiCreateStoreRequest

	/*
	 * CreateStoreExecute executes the request
	 * @return CreateStoreResponse
	 */
	CreateStoreExecute(r ApiCreateStoreRequest) (CreateStoreResponse, *_nethttp.Response, error)

	/*
	 * DeleteStore Delete a store
	 * Delete an OpenFGA store. This does not delete the data associated with the store, like tuples or authorization models.
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return ApiDeleteStoreRequest
	 */
	DeleteStore(ctx _context.Context) ApiDeleteStoreRequest

	/*
	 * DeleteStoreExecute executes the request
	 */
	DeleteStoreExecute(r ApiDeleteStoreRequest) (*_nethttp.Response, error)

	/*
		 * Expand Expand all relationships in userset tree format, and following userset rewrite rules.  Useful to reason about and debug a certain relationship
		 * The Expand API will return all users and usersets that have certain relationship with an object in a certain store.
	This is different from the `/stores/{store_id}/read` API in that both users and computed usersets are returned.
	Body parameters `tuple_key.object` and `tuple_key.relation` are all required.
	The response will return a tree whose leaves are the specific users and usersets. Union, intersection and difference operator are located in the intermediate nodes.

	## Example
	To expand all users that have the `reader` relationship with object `document:2021-budget`, use the Expand API with the following request body
	```json
	{
	  "tuple_key": {
	    "object": "document:2021-budget",
	    "relation": "reader"
	  },
	  "authorization_model_id": "01G50QVV17PECNVAHX1GG4Y5NC"
	}
	```
	OpenFGA's response will be a userset tree of the users and usersets that have read access to the document.
	```json
	{
	  "tree":{
	    "root":{
	      "type":"document:2021-budget#reader",
	      "union":{
	        "nodes":[
	          {
	            "type":"document:2021-budget#reader",
	            "leaf":{
	              "users":{
	                "users":[
	                  "user:bob"
	                ]
	              }
	            }
	          },
	          {
	            "type":"document:2021-budget#reader",
	            "leaf":{
	              "computed":{
	                "userset":"document:2021-budget#writer"
	              }
	            }
	          }
	        ]
	      }
	    }
	  }
	}
	```
	The caller can then call expand API for the `writer` relationship for the `document:2021-budget`.
		 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
		 * @return ApiExpandRequest
	*/
	Expand(ctx _context.Context) ApiExpandRequest

	/*
	 * ExpandExecute executes the request
	 * @return ExpandResponse
	 */
	ExpandExecute(r ApiExpandRequest) (ExpandResponse, *_nethttp.Response, error)

	/*
	 * GetStore Get a store
	 * Returns an OpenFGA store by its identifier
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return ApiGetStoreRequest
	 */
	GetStore(ctx _context.Context) ApiGetStoreRequest

	/*
	 * GetStoreExecute executes the request
	 * @return GetStoreResponse
	 */
	GetStoreExecute(r ApiGetStoreRequest) (GetStoreResponse, *_nethttp.Response, error)

	/*
		 * ListObjects List all objects of the given type that the user has a relation with
		 * The ListObjects API returns a list of all the objects of the given type that the user has a relation with. To achieve this, both the store tuples and the authorization model are used.
	An `authorization_model_id` may be specified in the body. If it is not specified, the latest authorization model ID will be used. It is strongly recommended to specify authorization model id for better performance.
	You may also specify `contextual_tuples` that will be treated as regular tuples. Each of these tuples may have an associated `condition`.
	You may also provide a `context` object that will be used to evaluate the conditioned tuples in the system. It is strongly recommended to provide a value for all the input parameters of all the conditions, to ensure that all tuples be evaluated correctly.
	The response will contain the related objects in an array in the "objects" field of the response and they will be strings in the object format `<type>:<id>` (e.g. "document:roadmap").
	The number of objects in the response array will be limited by the execution timeout specified in the flag OPENFGA_LIST_OBJECTS_DEADLINE and by the upper bound specified in the flag OPENFGA_LIST_OBJECTS_MAX_RESULTS, whichever is hit first.
	The objects given will not be sorted, and therefore two identical calls can give a given different set of objects.
		 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
		 * @return ApiListObjectsRequest
	*/
	ListObjects(ctx _context.Context) ApiListObjectsRequest

	/*
	 * ListObjectsExecute executes the request
	 * @return ListObjectsResponse
	 */
	ListObjectsExecute(r ApiListObjectsRequest) (ListObjectsResponse, *_nethttp.Response, error)

	/*
		 * ListStores List all stores
		 * Returns a paginated list of OpenFGA stores and a continuation token to get additional stores.
	The continuation token will be empty if there are no more stores.

		 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
		 * @return ApiListStoresRequest
	*/
	ListStores(ctx _context.Context) ApiListStoresRequest

	/*
	 * ListStoresExecute executes the request
	 * @return ListStoresResponse
	 */
	ListStoresExecute(r ApiListStoresRequest) (ListStoresResponse, *_nethttp.Response, error)

	/*
		 * Read Get tuples from the store that matches a query, without following userset rewrite rules
		 * The Read API will return the tuples for a certain store that match a query filter specified in the body of the request. It is different from the `/stores/{store_id}/expand` API in that it only returns relationship tuples that are stored in the system and satisfy the query.
	In the body:
	1. `tuple_key` is optional. If not specified, it will return all tuples in the store.
	2. `tuple_key.object` is mandatory if `tuple_key` is specified. It can be a full object (e.g., `type:object_id`) or type only (e.g., `type:`).
	3. `tuple_key.user` is mandatory if tuple_key is specified in the case the `tuple_key.object` is a type only.
	## Examples
	### Query for all objects in a type definition
	To query for all objects that `user:bob` has `reader` relationship in the `document` type definition, call read API with body of
	```json
	{
	 "tuple_key": {
	     "user": "user:bob",
	     "relation": "reader",
	     "object": "document:"
	  }
	}
	```
	The API will return tuples and a continuation token, something like
	```json
	{
	  "tuples": [
	    {
	      "key": {
	        "user": "user:bob",
	        "relation": "reader",
	        "object": "document:2021-budget"
	      },
	      "timestamp": "2021-10-06T15:32:11.128Z"
	    }
	  ],
	  "continuation_token": "eyJwayI6IkxBVEVTVF9OU0NPTkZJR19hdXRoMHN0b3JlIiwic2siOiIxem1qbXF3MWZLZExTcUoyN01MdTdqTjh0cWgifQ=="
	}
	```
	This means that `user:bob` has a `reader` relationship with 1 document `document:2021-budget`. Note that this API, unlike the List Objects API, does not evaluate the tuples in the store.
	The continuation token will be empty if there are no more tuples to query.
	### Query for all stored relationship tuples that have a particular relation and object
	To query for all users that have `reader` relationship with `document:2021-budget`, call read API with body of
	```json
	{
	  "tuple_key": {
	     "object": "document:2021-budget",
	     "relation": "reader"
	   }
	}
	```
	The API will return something like
	```json
	{
	  "tuples": [
	    {
	      "key": {
	        "user": "user:bob",
	        "relation": "reader",
	        "object": "document:2021-budget"
	      },
	      "timestamp": "2021-10-06T15:32:11.128Z"
	    }
	  ],
	  "continuation_token": "eyJwayI6IkxBVEVTVF9OU0NPTkZJR19hdXRoMHN0b3JlIiwic2siOiIxem1qbXF3MWZLZExTcUoyN01MdTdqTjh0cWgifQ=="
	}
	```
	This means that `document:2021-budget` has 1 `reader` (`user:bob`).  Note that, even if the model said that all `writers` are also `readers`, the API will not return writers such as `user:anne` because it only returns tuples and does not evaluate them.
	### Query for all users with all relationships for a particular document
	To query for all users that have any relationship with `document:2021-budget`, call read API with body of
	```json
	{
	  "tuple_key": {
	      "object": "document:2021-budget"
	   }
	}
	```
	The API will return something like
	```json
	{
	  "tuples": [
	    {
	      "key": {
	        "user": "user:anne",
	        "relation": "writer",
	        "object": "document:2021-budget"
	      },
	      "timestamp": "2021-10-05T13:42:12.356Z"
	    },
	    {
	      "key": {
	        "user": "user:bob",
	        "relation": "reader",
	        "object": "document:2021-budget"
	      },
	      "timestamp": "2021-10-06T15:32:11.128Z"
	    }
	  ],
	  "continuation_token": "eyJwayI6IkxBVEVTVF9OU0NPTkZJR19hdXRoMHN0b3JlIiwic2siOiIxem1qbXF3MWZLZExTcUoyN01MdTdqTjh0cWgifQ=="
	}
	```
	This means that `document:2021-budget` has 1 `reader` (`user:bob`) and 1 `writer` (`user:anne`).

		 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
		 * @return ApiReadRequest
	*/
	Read(ctx _context.Context) ApiReadRequest

	/*
	 * ReadExecute executes the request
	 * @return ReadResponse
	 */
	ReadExecute(r ApiReadRequest) (ReadResponse, *_nethttp.Response, error)

	/*
	 * ReadAssertions Read assertions for an authorization model ID
	 * The ReadAssertions API will return, for a given authorization model id, all the assertions stored for it. An assertion is an object that contains a tuple key, and the expectation of whether a call to the Check API of that tuple key will return true or false.
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param authorizationModelId
	 * @return ApiReadAssertionsRequest
	 */
	ReadAssertions(ctx _context.Context, authorizationModelId string) ApiReadAssertionsRequest

	/*
	 * ReadAssertionsExecute executes the request
	 * @return ReadAssertionsResponse
	 */
	ReadAssertionsExecute(r ApiReadAssertionsRequest) (ReadAssertionsResponse, *_nethttp.Response, error)

	/*
		 * ReadAuthorizationModel Return a particular version of an authorization model
		 * The ReadAuthorizationModel API returns an authorization model by its identifier.
	The response will return the authorization model for the particular version.

	## Example
	To retrieve the authorization model with ID `01G5JAVJ41T49E9TT3SKVS7X1J` for the store, call the GET authorization-models by ID API with `01G5JAVJ41T49E9TT3SKVS7X1J` as the `id` path parameter.  The API will return:
	```json
	{
	  "authorization_model":{
	    "id":"01G5JAVJ41T49E9TT3SKVS7X1J",
	    "type_definitions":[
	      {
	        "type":"user"
	      },
	      {
	        "type":"document",
	        "relations":{
	          "reader":{
	            "union":{
	              "child":[
	                {
	                  "this":{}
	                },
	                {
	                  "computedUserset":{
	                    "object":"",
	                    "relation":"writer"
	                  }
	                }
	              ]
	            }
	          },
	          "writer":{
	            "this":{}
	          }
	        }
	      }
	    ]
	  }
	}
	```
	In the above example, there are 2 types (`user` and `document`). The `document` type has 2 relations (`writer` and `reader`).
		 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
		 * @param id
		 * @return ApiReadAuthorizationModelRequest
	*/
	ReadAuthorizationModel(ctx _context.Context, id string) ApiReadAuthorizationModelRequest

	/*
	 * ReadAuthorizationModelExecute executes the request
	 * @return ReadAuthorizationModelResponse
	 */
	ReadAuthorizationModelExecute(r ApiReadAuthorizationModelRequest) (ReadAuthorizationModelResponse, *_nethttp.Response, error)

	/*
		 * ReadAuthorizationModels Return all the authorization models for a particular store
		 * The ReadAuthorizationModels API will return all the authorization models for a certain store.
	OpenFGA's response will contain an array of all authorization models, sorted in descending order of creation.

	## Example
	Assume that a store's authorization model has been configured twice. To get all the authorization models that have been created in this store, call GET authorization-models. The API will return a response that looks like:
	```json
	{
	  "authorization_models": [
	    {
	      "id": "01G50QVV17PECNVAHX1GG4Y5NC",
	      "type_definitions": [...]
	    },
	    {
	      "id": "01G4ZW8F4A07AKQ8RHSVG9RW04",
	      "type_definitions": [...]
	    },
	  ],
	  "continuation_token": "eyJwayI6IkxBVEVTVF9OU0NPTkZJR19hdXRoMHN0b3JlIiwic2siOiIxem1qbXF3MWZLZExTcUoyN01MdTdqTjh0cWgifQ=="
	}
	```
	If there are no more authorization models available, the `continuation_token` field will be empty
	```json
	{
	  "authorization_models": [
	    {
	      "id": "01G50QVV17PECNVAHX1GG4Y5NC",
	      "type_definitions": [...]
	    },
	    {
	      "id": "01G4ZW8F4A07AKQ8RHSVG9RW04",
	      "type_definitions": [...]
	    },
	  ],
	  "continuation_token": ""
	}
	```

		 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
		 * @return ApiReadAuthorizationModelsRequest
	*/
	ReadAuthorizationModels(ctx _context.Context) ApiReadAuthorizationModelsRequest

	/*
	 * ReadAuthorizationModelsExecute executes the request
	 * @return ReadAuthorizationModelsResponse
	 */
	ReadAuthorizationModelsExecute(r ApiReadAuthorizationModelsRequest) (ReadAuthorizationModelsResponse, *_nethttp.Response, error)

	/*
		 * ReadChanges Return a list of all the tuple changes
		 * The ReadChanges API will return a paginated list of tuple changes (additions and deletions) that occurred in a given store, sorted by ascending time. The response will include a continuation token that is used to get the next set of changes. If there are no changes after the provided continuation token, the same token will be returned in order for it to be used when new changes are recorded. If the store never had any tuples added or removed, this token will be empty.
	You can use the `type` parameter to only get the list of tuple changes that affect objects of that type.
	When reading a write tuple change, if it was conditioned, the condition will be returned.
	When reading a delete tuple change, the condition will NOT be returned regardless of whether it was originally conditioned or not.

		 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
		 * @return ApiReadChangesRequest
	*/
	ReadChanges(ctx _context.Context) ApiReadChangesRequest

	/*
	 * ReadChangesExecute executes the request
	 * @return ReadChangesResponse
	 */
	ReadChangesExecute(r ApiReadChangesRequest) (ReadChangesResponse, *_nethttp.Response, error)

	/*
		 * Write Add or delete tuples from the store
		 * The Write API will update the tuples for a certain store. Tuples and type definitions allow OpenFGA to determine whether a relationship exists between an object and an user.
	In the body, `writes` adds new tuples and `deletes` removes existing tuples. When deleting a tuple, any `condition` specified with it is ignored.
	The API is not idempotent: if, later on, you try to add the same tuple key (even if the `condition` is different), or if you try to delete a non-existing tuple, it will throw an error.
	An `authorization_model_id` may be specified in the body. If it is, it will be used to assert that each written tuple (not deleted) is valid for the model specified. If it is not specified, the latest authorization model ID will be used.
	## Example
	### Adding relationships
	To add `user:anne` as a `writer` for `document:2021-budget`, call write API with the following
	```json
	{
	  "writes": {
	    "tuple_keys": [
	      {
	        "user": "user:anne",
	        "relation": "writer",
	        "object": "document:2021-budget"
	      }
	    ]
	  },
	  "authorization_model_id": "01G50QVV17PECNVAHX1GG4Y5NC"
	}
	```
	### Removing relationships
	To remove `user:bob` as a `reader` for `document:2021-budget`, call write API with the following
	```json
	{
	  "deletes": {
	    "tuple_keys": [
	      {
	        "user": "user:bob",
	        "relation": "reader",
	        "object": "document:2021-budget"
	      }
	    ]
	  }
	}
	```

		 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
		 * @return ApiWriteRequest
	*/
	Write(ctx _context.Context) ApiWriteRequest

	/*
	 * WriteExecute executes the request
	 * @return map[string]interface{}
	 */
	WriteExecute(r ApiWriteRequest) (map[string]interface{}, *_nethttp.Response, error)

	/*
	 * WriteAssertions Upsert assertions for an authorization model ID
	 * The WriteAssertions API will upsert new assertions for an authorization model id, or overwrite the existing ones. An assertion is an object that contains a tuple key, and the expectation of whether a call to the Check API of that tuple key will return true or false.
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @param authorizationModelId
	 * @return ApiWriteAssertionsRequest
	 */
	WriteAssertions(ctx _context.Context, authorizationModelId string) ApiWriteAssertionsRequest

	/*
	 * WriteAssertionsExecute executes the request
	 */
	WriteAssertionsExecute(r ApiWriteAssertionsRequest) (*_nethttp.Response, error)

	/*
		 * WriteAuthorizationModel Create a new authorization model
		 * The WriteAuthorizationModel API will add a new authorization model to a store.
	Each item in the `type_definitions` array is a type definition as specified in the field `type_definition`.
	The response will return the authorization model's ID in the `id` field.

	## Example
	To add an authorization model with `user` and `document` type definitions, call POST authorization-models API with the body:
	```json
	{
	  "type_definitions":[
	    {
	      "type":"user"
	    },
	    {
	      "type":"document",
	      "relations":{
	        "reader":{
	          "union":{
	            "child":[
	              {
	                "this":{}
	              },
	              {
	                "computedUserset":{
	                  "object":"",
	                  "relation":"writer"
	                }
	              }
	            ]
	          }
	        },
	        "writer":{
	          "this":{}
	        }
	      }
	    }
	  ]
	}
	```
	OpenFGA's response will include the version id for this authorization model, which will look like
	```
	{"authorization_model_id": "01G50QVV17PECNVAHX1GG4Y5NC"}
	```

		 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
		 * @return ApiWriteAuthorizationModelRequest
	*/
	WriteAuthorizationModel(ctx _context.Context) ApiWriteAuthorizationModelRequest

	/*
	 * WriteAuthorizationModelExecute executes the request
	 * @return WriteAuthorizationModelResponse
	 */
	WriteAuthorizationModelExecute(r ApiWriteAuthorizationModelRequest) (WriteAuthorizationModelResponse, *_nethttp.Response, error)
}

// OpenFgaApiService OpenFgaApi service
type OpenFgaApiService service

type ApiCheckRequest struct {
	ctx        _context.Context
	ApiService OpenFgaApi

	body *CheckRequest
}

func (r ApiCheckRequest) Body(body CheckRequest) ApiCheckRequest {
	r.body = &body
	return r
}

func (r ApiCheckRequest) Execute() (CheckResponse, *_nethttp.Response, error) {
	return r.ApiService.CheckExecute(r)
}

/*
  - Check Check whether a user is authorized to access an object
  - The Check API queries to check if the user has a certain relationship with an object in a certain store.

A `contextual_tuples` object may also be included in the body of the request. This object contains one field `tuple_keys`, which is an array of tuple keys. Each of these tuples may have an associated `condition`.
You may also provide an `authorization_model_id` in the body. This will be used to assert that the input `tuple_key` is valid for the model specified. If not specified, the assertion will be made against the latest authorization model ID. It is strongly recommended to specify authorization model id for better performance.
You may also provide a `context` object that will be used to evaluate the conditioned tuples in the system. It is strongly recommended to provide a value for all the input parameters of all the conditions, to ensure that all tuples be evaluated correctly.
The response will return whether the relationship exists in the field `allowed`.

## Example
In order to check if user `user:anne` of type `user` has a `reader` relationship with object `document:2021-budget` given the following contextual tuple
```json

	{
	  "user": "user:anne",
	  "relation": "member",
	  "object": "time_slot:office_hours"
	}

```
the Check API can be used with the following request body:
```json

	{
	  "tuple_key": {
	    "user": "user:anne",
	    "relation": "reader",
	    "object": "document:2021-budget"
	  },
	  "contextual_tuples": {
	    "tuple_keys": [
	      {
	        "user": "user:anne",
	        "relation": "member",
	        "object": "time_slot:office_hours"
	      }
	    ]
	  },
	  "authorization_model_id": "01G50QVV17PECNVAHX1GG4Y5NC"
	}

```
OpenFGA's response will include `{ "allowed": true }` if there is a relationship and `{ "allowed": false }` if there isn't.
  - @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return ApiCheckRequest
*/
func (a *OpenFgaApiService) Check(ctx _context.Context) ApiCheckRequest {
	return ApiCheckRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return CheckResponse
 */
func (a *OpenFgaApiService) CheckExecute(r ApiCheckRequest) (CheckResponse, *_nethttp.Response, error) {
	var maxRetry int
	var minWaitInMs int

	if a.RetryParams != nil {
		maxRetry = a.RetryParams.MinWaitInMs
		minWaitInMs = a.RetryParams.MinWaitInMs
	} else {
		maxRetry = 0
		minWaitInMs = 0
	}

	for i := 0; i < maxRetry+1; i++ {
		var (
			localVarHTTPMethod  = _nethttp.MethodPost
			localVarPostBody    interface{}
			localVarReturnValue CheckResponse
		)

		if a.client.cfg.StoreId == "" {
			return localVarReturnValue, nil, reportError("Configuration.StoreId is required and must be specified to call this method")
		}
		if a.client.cfg.StoreId != "" && !internalutils.IsWellFormedUlidString(a.client.cfg.StoreId) {
			return localVarReturnValue, nil, reportError("Configuration.StoreId is invalid")
		}
		localVarPath := "/stores/{store_id}/check"
		localVarPath = strings.Replace(localVarPath, "{"+"store_id"+"}", _neturl.PathEscape(a.client.cfg.StoreId), -1)

		localVarHeaderParams := make(map[string]string)
		localVarQueryParams := _neturl.Values{}
		if r.body == nil {
			return localVarReturnValue, nil, reportError("body is required and must be specified")
		}

		// to determine the Content-Type header
		localVarHTTPContentTypes := []string{"application/json"}

		// set Content-Type header
		localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
		if localVarHTTPContentType != "" {
			localVarHeaderParams["Content-Type"] = localVarHTTPContentType
		}

		// to determine the Accept header
		localVarHTTPHeaderAccepts := []string{"application/json"}

		// set Accept header
		localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
		if localVarHTTPHeaderAccept != "" {
			localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
		}
		// body params
		localVarPostBody = r.body
		req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams)
		if err != nil {
			return localVarReturnValue, nil, err
		}

		localVarHTTPResponse, err := a.client.callAPI(req)
		if err != nil || localVarHTTPResponse == nil {
			return localVarReturnValue, localVarHTTPResponse, err
		}

		localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
		localVarHTTPResponse.Body.Close()
		localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
		if err != nil {
			return localVarReturnValue, localVarHTTPResponse, err
		}

		if localVarHTTPResponse.StatusCode >= _nethttp.StatusMultipleChoices {

			if localVarHTTPResponse.StatusCode == _nethttp.StatusBadRequest || localVarHTTPResponse.StatusCode == _nethttp.StatusUnprocessableEntity {
				newErr := FgaApiValidationError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "Check",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "Check validation error for " + localVarHTTPMethod + " Check with body " + string(localVarBody)
				var v ValidationErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusUnauthorized || localVarHTTPResponse.StatusCode == _nethttp.StatusForbidden {
				newErr := FgaApiAuthenticationError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "Check",
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "Check auth error for " + localVarHTTPMethod + " Check with body " + string(localVarBody)

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusNotFound {
				newErr := FgaApiNotFoundError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "Check",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "Check validation error for " + localVarHTTPMethod + " Check with body " + string(localVarBody)
				var v PathUnknownErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusTooManyRequests {
				if i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				// maximum number of retry reached
				newErr := FgaApiRateLimitExceededError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "Check",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "Check rate limit error for " + localVarHTTPMethod + " Check with body " + string(localVarBody)

				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode >= _nethttp.StatusInternalServerError {
				if localVarHTTPResponse.StatusCode != _nethttp.StatusNotImplemented && i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				newErr := FgaApiInternalError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "Check",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "Check internal error for " + localVarHTTPMethod + " Check with body " + string(localVarBody)
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

				var v InternalErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr := FgaApiError{
				body: localVarBody,

				storeId:            a.client.cfg.StoreId,
				endpointCategory:   "Check",
				requestBody:        localVarPostBody,
				requestMethod:      localVarHTTPMethod,
				responseStatusCode: localVarHTTPResponse.StatusCode,
				responseHeader:     localVarHTTPResponse.Header,
			}
			newErr.error = "Check error for " + localVarHTTPMethod + " Check with body " + string(localVarBody)
			newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.modelDecodeError = err
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			newErr.responseCode = v.Code
			newErr.error += " with error code " + v.Code + " error message: " + v.Message

			return localVarReturnValue, localVarHTTPResponse, newErr
		}

		err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr := GenericOpenAPIError{
				body:  localVarBody,
				error: err.Error(),
			}
			return localVarReturnValue, localVarHTTPResponse, newErr
		}

		return localVarReturnValue, localVarHTTPResponse, nil
	}
	// should never have reached this
	var localVarReturnValue CheckResponse
	return localVarReturnValue, nil, reportError("Error not handled properly")
}

type ApiCreateStoreRequest struct {
	ctx        _context.Context
	ApiService OpenFgaApi

	body *CreateStoreRequest
}

func (r ApiCreateStoreRequest) Body(body CreateStoreRequest) ApiCreateStoreRequest {
	r.body = &body
	return r
}

func (r ApiCreateStoreRequest) Execute() (CreateStoreResponse, *_nethttp.Response, error) {
	return r.ApiService.CreateStoreExecute(r)
}

/*
 * CreateStore Create a store
 * Create a unique OpenFGA store which will be used to store authorization models and relationship tuples.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @return ApiCreateStoreRequest
 */
func (a *OpenFgaApiService) CreateStore(ctx _context.Context) ApiCreateStoreRequest {
	return ApiCreateStoreRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return CreateStoreResponse
 */
func (a *OpenFgaApiService) CreateStoreExecute(r ApiCreateStoreRequest) (CreateStoreResponse, *_nethttp.Response, error) {
	var maxRetry int
	var minWaitInMs int

	if a.RetryParams != nil {
		maxRetry = a.RetryParams.MinWaitInMs
		minWaitInMs = a.RetryParams.MinWaitInMs
	} else {
		maxRetry = 0
		minWaitInMs = 0
	}

	for i := 0; i < maxRetry+1; i++ {
		var (
			localVarHTTPMethod  = _nethttp.MethodPost
			localVarPostBody    interface{}
			localVarReturnValue CreateStoreResponse
		)

		localVarPath := "/stores"

		localVarHeaderParams := make(map[string]string)
		localVarQueryParams := _neturl.Values{}
		if r.body == nil {
			return localVarReturnValue, nil, reportError("body is required and must be specified")
		}

		// to determine the Content-Type header
		localVarHTTPContentTypes := []string{"application/json"}

		// set Content-Type header
		localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
		if localVarHTTPContentType != "" {
			localVarHeaderParams["Content-Type"] = localVarHTTPContentType
		}

		// to determine the Accept header
		localVarHTTPHeaderAccepts := []string{"application/json"}

		// set Accept header
		localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
		if localVarHTTPHeaderAccept != "" {
			localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
		}
		// body params
		localVarPostBody = r.body
		req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams)
		if err != nil {
			return localVarReturnValue, nil, err
		}

		localVarHTTPResponse, err := a.client.callAPI(req)
		if err != nil || localVarHTTPResponse == nil {
			return localVarReturnValue, localVarHTTPResponse, err
		}

		localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
		localVarHTTPResponse.Body.Close()
		localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
		if err != nil {
			return localVarReturnValue, localVarHTTPResponse, err
		}

		if localVarHTTPResponse.StatusCode >= _nethttp.StatusMultipleChoices {

			if localVarHTTPResponse.StatusCode == _nethttp.StatusBadRequest || localVarHTTPResponse.StatusCode == _nethttp.StatusUnprocessableEntity {
				newErr := FgaApiValidationError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "CreateStore",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "CreateStore validation error for " + localVarHTTPMethod + " CreateStore with body " + string(localVarBody)
				var v ValidationErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusUnauthorized || localVarHTTPResponse.StatusCode == _nethttp.StatusForbidden {
				newErr := FgaApiAuthenticationError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "CreateStore",
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "CreateStore auth error for " + localVarHTTPMethod + " CreateStore with body " + string(localVarBody)

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusNotFound {
				newErr := FgaApiNotFoundError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "CreateStore",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "CreateStore validation error for " + localVarHTTPMethod + " CreateStore with body " + string(localVarBody)
				var v PathUnknownErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusTooManyRequests {
				if i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				// maximum number of retry reached
				newErr := FgaApiRateLimitExceededError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "CreateStore",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "CreateStore rate limit error for " + localVarHTTPMethod + " CreateStore with body " + string(localVarBody)

				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode >= _nethttp.StatusInternalServerError {
				if localVarHTTPResponse.StatusCode != _nethttp.StatusNotImplemented && i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				newErr := FgaApiInternalError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "CreateStore",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "CreateStore internal error for " + localVarHTTPMethod + " CreateStore with body " + string(localVarBody)
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

				var v InternalErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr := FgaApiError{
				body: localVarBody,

				storeId:            a.client.cfg.StoreId,
				endpointCategory:   "CreateStore",
				requestBody:        localVarPostBody,
				requestMethod:      localVarHTTPMethod,
				responseStatusCode: localVarHTTPResponse.StatusCode,
				responseHeader:     localVarHTTPResponse.Header,
			}
			newErr.error = "CreateStore error for " + localVarHTTPMethod + " CreateStore with body " + string(localVarBody)
			newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.modelDecodeError = err
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			newErr.responseCode = v.Code
			newErr.error += " with error code " + v.Code + " error message: " + v.Message

			return localVarReturnValue, localVarHTTPResponse, newErr
		}

		err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr := GenericOpenAPIError{
				body:  localVarBody,
				error: err.Error(),
			}
			return localVarReturnValue, localVarHTTPResponse, newErr
		}

		return localVarReturnValue, localVarHTTPResponse, nil
	}
	// should never have reached this
	var localVarReturnValue CreateStoreResponse
	return localVarReturnValue, nil, reportError("Error not handled properly")
}

type ApiDeleteStoreRequest struct {
	ctx        _context.Context
	ApiService OpenFgaApi
}

func (r ApiDeleteStoreRequest) Execute() (*_nethttp.Response, error) {
	return r.ApiService.DeleteStoreExecute(r)
}

/*
 * DeleteStore Delete a store
 * Delete an OpenFGA store. This does not delete the data associated with the store, like tuples or authorization models.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @return ApiDeleteStoreRequest
 */
func (a *OpenFgaApiService) DeleteStore(ctx _context.Context) ApiDeleteStoreRequest {
	return ApiDeleteStoreRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 */
func (a *OpenFgaApiService) DeleteStoreExecute(r ApiDeleteStoreRequest) (*_nethttp.Response, error) {
	var maxRetry int
	var minWaitInMs int

	if a.RetryParams != nil {
		maxRetry = a.RetryParams.MinWaitInMs
		minWaitInMs = a.RetryParams.MinWaitInMs
	} else {
		maxRetry = 0
		minWaitInMs = 0
	}

	for i := 0; i < maxRetry+1; i++ {
		var (
			localVarHTTPMethod = _nethttp.MethodDelete
			localVarPostBody   interface{}
		)

		if a.client.cfg.StoreId == "" {
			return nil, reportError("Configuration.StoreId is required and must be specified to call this method")
		}
		if a.client.cfg.StoreId != "" && !internalutils.IsWellFormedUlidString(a.client.cfg.StoreId) {
			return nil, reportError("Configuration.StoreId is invalid")
		}
		localVarPath := "/stores/{store_id}"
		localVarPath = strings.Replace(localVarPath, "{"+"store_id"+"}", _neturl.PathEscape(a.client.cfg.StoreId), -1)

		localVarHeaderParams := make(map[string]string)
		localVarQueryParams := _neturl.Values{}

		// to determine the Content-Type header
		localVarHTTPContentTypes := []string{}

		// set Content-Type header
		localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
		if localVarHTTPContentType != "" {
			localVarHeaderParams["Content-Type"] = localVarHTTPContentType
		}

		// to determine the Accept header
		localVarHTTPHeaderAccepts := []string{"application/json"}

		// set Accept header
		localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
		if localVarHTTPHeaderAccept != "" {
			localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
		}
		req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams)
		if err != nil {
			return nil, err
		}

		localVarHTTPResponse, err := a.client.callAPI(req)
		if err != nil || localVarHTTPResponse == nil {
			return localVarHTTPResponse, err
		}

		localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
		localVarHTTPResponse.Body.Close()
		localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
		if err != nil {
			return localVarHTTPResponse, err
		}

		if localVarHTTPResponse.StatusCode >= _nethttp.StatusMultipleChoices {

			if localVarHTTPResponse.StatusCode == _nethttp.StatusBadRequest || localVarHTTPResponse.StatusCode == _nethttp.StatusUnprocessableEntity {
				newErr := FgaApiValidationError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "DeleteStore",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "DeleteStore validation error for " + localVarHTTPMethod + " DeleteStore with body " + string(localVarBody)
				var v ValidationErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusUnauthorized || localVarHTTPResponse.StatusCode == _nethttp.StatusForbidden {
				newErr := FgaApiAuthenticationError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "DeleteStore",
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "DeleteStore auth error for " + localVarHTTPMethod + " DeleteStore with body " + string(localVarBody)

				return localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusNotFound {
				newErr := FgaApiNotFoundError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "DeleteStore",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "DeleteStore validation error for " + localVarHTTPMethod + " DeleteStore with body " + string(localVarBody)
				var v PathUnknownErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusTooManyRequests {
				if i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				// maximum number of retry reached
				newErr := FgaApiRateLimitExceededError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "DeleteStore",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "DeleteStore rate limit error for " + localVarHTTPMethod + " DeleteStore with body " + string(localVarBody)

				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				return localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode >= _nethttp.StatusInternalServerError {
				if localVarHTTPResponse.StatusCode != _nethttp.StatusNotImplemented && i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				newErr := FgaApiInternalError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "DeleteStore",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "DeleteStore internal error for " + localVarHTTPMethod + " DeleteStore with body " + string(localVarBody)
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

				var v InternalErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarHTTPResponse, newErr
			}
			newErr := FgaApiError{
				body: localVarBody,

				storeId:            a.client.cfg.StoreId,
				endpointCategory:   "DeleteStore",
				requestBody:        localVarPostBody,
				requestMethod:      localVarHTTPMethod,
				responseStatusCode: localVarHTTPResponse.StatusCode,
				responseHeader:     localVarHTTPResponse.Header,
			}
			newErr.error = "DeleteStore error for " + localVarHTTPMethod + " DeleteStore with body " + string(localVarBody)
			newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.modelDecodeError = err
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
			newErr.responseCode = v.Code
			newErr.error += " with error code " + v.Code + " error message: " + v.Message

			return localVarHTTPResponse, newErr
		}

		return localVarHTTPResponse, nil
	}
	// should never have reached this
	return nil, reportError("Error not handled properly")
}

type ApiExpandRequest struct {
	ctx        _context.Context
	ApiService OpenFgaApi

	body *ExpandRequest
}

func (r ApiExpandRequest) Body(body ExpandRequest) ApiExpandRequest {
	r.body = &body
	return r
}

func (r ApiExpandRequest) Execute() (ExpandResponse, *_nethttp.Response, error) {
	return r.ApiService.ExpandExecute(r)
}

/*
  - Expand Expand all relationships in userset tree format, and following userset rewrite rules.  Useful to reason about and debug a certain relationship
  - The Expand API will return all users and usersets that have certain relationship with an object in a certain store.

This is different from the `/stores/{store_id}/read` API in that both users and computed usersets are returned.
Body parameters `tuple_key.object` and `tuple_key.relation` are all required.
The response will return a tree whose leaves are the specific users and usersets. Union, intersection and difference operator are located in the intermediate nodes.

## Example
To expand all users that have the `reader` relationship with object `document:2021-budget`, use the Expand API with the following request body
```json

	{
	  "tuple_key": {
	    "object": "document:2021-budget",
	    "relation": "reader"
	  },
	  "authorization_model_id": "01G50QVV17PECNVAHX1GG4Y5NC"
	}

```
OpenFGA's response will be a userset tree of the users and usersets that have read access to the document.
```json

	{
	  "tree":{
	    "root":{
	      "type":"document:2021-budget#reader",
	      "union":{
	        "nodes":[
	          {
	            "type":"document:2021-budget#reader",
	            "leaf":{
	              "users":{
	                "users":[
	                  "user:bob"
	                ]
	              }
	            }
	          },
	          {
	            "type":"document:2021-budget#reader",
	            "leaf":{
	              "computed":{
	                "userset":"document:2021-budget#writer"
	              }
	            }
	          }
	        ]
	      }
	    }
	  }
	}

```
The caller can then call expand API for the `writer` relationship for the `document:2021-budget`.
  - @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return ApiExpandRequest
*/
func (a *OpenFgaApiService) Expand(ctx _context.Context) ApiExpandRequest {
	return ApiExpandRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return ExpandResponse
 */
func (a *OpenFgaApiService) ExpandExecute(r ApiExpandRequest) (ExpandResponse, *_nethttp.Response, error) {
	var maxRetry int
	var minWaitInMs int

	if a.RetryParams != nil {
		maxRetry = a.RetryParams.MinWaitInMs
		minWaitInMs = a.RetryParams.MinWaitInMs
	} else {
		maxRetry = 0
		minWaitInMs = 0
	}

	for i := 0; i < maxRetry+1; i++ {
		var (
			localVarHTTPMethod  = _nethttp.MethodPost
			localVarPostBody    interface{}
			localVarReturnValue ExpandResponse
		)

		if a.client.cfg.StoreId == "" {
			return localVarReturnValue, nil, reportError("Configuration.StoreId is required and must be specified to call this method")
		}
		if a.client.cfg.StoreId != "" && !internalutils.IsWellFormedUlidString(a.client.cfg.StoreId) {
			return localVarReturnValue, nil, reportError("Configuration.StoreId is invalid")
		}
		localVarPath := "/stores/{store_id}/expand"
		localVarPath = strings.Replace(localVarPath, "{"+"store_id"+"}", _neturl.PathEscape(a.client.cfg.StoreId), -1)

		localVarHeaderParams := make(map[string]string)
		localVarQueryParams := _neturl.Values{}
		if r.body == nil {
			return localVarReturnValue, nil, reportError("body is required and must be specified")
		}

		// to determine the Content-Type header
		localVarHTTPContentTypes := []string{"application/json"}

		// set Content-Type header
		localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
		if localVarHTTPContentType != "" {
			localVarHeaderParams["Content-Type"] = localVarHTTPContentType
		}

		// to determine the Accept header
		localVarHTTPHeaderAccepts := []string{"application/json"}

		// set Accept header
		localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
		if localVarHTTPHeaderAccept != "" {
			localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
		}
		// body params
		localVarPostBody = r.body
		req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams)
		if err != nil {
			return localVarReturnValue, nil, err
		}

		localVarHTTPResponse, err := a.client.callAPI(req)
		if err != nil || localVarHTTPResponse == nil {
			return localVarReturnValue, localVarHTTPResponse, err
		}

		localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
		localVarHTTPResponse.Body.Close()
		localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
		if err != nil {
			return localVarReturnValue, localVarHTTPResponse, err
		}

		if localVarHTTPResponse.StatusCode >= _nethttp.StatusMultipleChoices {

			if localVarHTTPResponse.StatusCode == _nethttp.StatusBadRequest || localVarHTTPResponse.StatusCode == _nethttp.StatusUnprocessableEntity {
				newErr := FgaApiValidationError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "Expand",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "Expand validation error for " + localVarHTTPMethod + " Expand with body " + string(localVarBody)
				var v ValidationErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusUnauthorized || localVarHTTPResponse.StatusCode == _nethttp.StatusForbidden {
				newErr := FgaApiAuthenticationError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "Expand",
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "Expand auth error for " + localVarHTTPMethod + " Expand with body " + string(localVarBody)

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusNotFound {
				newErr := FgaApiNotFoundError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "Expand",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "Expand validation error for " + localVarHTTPMethod + " Expand with body " + string(localVarBody)
				var v PathUnknownErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusTooManyRequests {
				if i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				// maximum number of retry reached
				newErr := FgaApiRateLimitExceededError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "Expand",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "Expand rate limit error for " + localVarHTTPMethod + " Expand with body " + string(localVarBody)

				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode >= _nethttp.StatusInternalServerError {
				if localVarHTTPResponse.StatusCode != _nethttp.StatusNotImplemented && i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				newErr := FgaApiInternalError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "Expand",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "Expand internal error for " + localVarHTTPMethod + " Expand with body " + string(localVarBody)
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

				var v InternalErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr := FgaApiError{
				body: localVarBody,

				storeId:            a.client.cfg.StoreId,
				endpointCategory:   "Expand",
				requestBody:        localVarPostBody,
				requestMethod:      localVarHTTPMethod,
				responseStatusCode: localVarHTTPResponse.StatusCode,
				responseHeader:     localVarHTTPResponse.Header,
			}
			newErr.error = "Expand error for " + localVarHTTPMethod + " Expand with body " + string(localVarBody)
			newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.modelDecodeError = err
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			newErr.responseCode = v.Code
			newErr.error += " with error code " + v.Code + " error message: " + v.Message

			return localVarReturnValue, localVarHTTPResponse, newErr
		}

		err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr := GenericOpenAPIError{
				body:  localVarBody,
				error: err.Error(),
			}
			return localVarReturnValue, localVarHTTPResponse, newErr
		}

		return localVarReturnValue, localVarHTTPResponse, nil
	}
	// should never have reached this
	var localVarReturnValue ExpandResponse
	return localVarReturnValue, nil, reportError("Error not handled properly")
}

type ApiGetStoreRequest struct {
	ctx        _context.Context
	ApiService OpenFgaApi
}

func (r ApiGetStoreRequest) Execute() (GetStoreResponse, *_nethttp.Response, error) {
	return r.ApiService.GetStoreExecute(r)
}

/*
 * GetStore Get a store
 * Returns an OpenFGA store by its identifier
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @return ApiGetStoreRequest
 */
func (a *OpenFgaApiService) GetStore(ctx _context.Context) ApiGetStoreRequest {
	return ApiGetStoreRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return GetStoreResponse
 */
func (a *OpenFgaApiService) GetStoreExecute(r ApiGetStoreRequest) (GetStoreResponse, *_nethttp.Response, error) {
	var maxRetry int
	var minWaitInMs int

	if a.RetryParams != nil {
		maxRetry = a.RetryParams.MinWaitInMs
		minWaitInMs = a.RetryParams.MinWaitInMs
	} else {
		maxRetry = 0
		minWaitInMs = 0
	}

	for i := 0; i < maxRetry+1; i++ {
		var (
			localVarHTTPMethod  = _nethttp.MethodGet
			localVarPostBody    interface{}
			localVarReturnValue GetStoreResponse
		)

		if a.client.cfg.StoreId == "" {
			return localVarReturnValue, nil, reportError("Configuration.StoreId is required and must be specified to call this method")
		}
		if a.client.cfg.StoreId != "" && !internalutils.IsWellFormedUlidString(a.client.cfg.StoreId) {
			return localVarReturnValue, nil, reportError("Configuration.StoreId is invalid")
		}
		localVarPath := "/stores/{store_id}"
		localVarPath = strings.Replace(localVarPath, "{"+"store_id"+"}", _neturl.PathEscape(a.client.cfg.StoreId), -1)

		localVarHeaderParams := make(map[string]string)
		localVarQueryParams := _neturl.Values{}

		// to determine the Content-Type header
		localVarHTTPContentTypes := []string{}

		// set Content-Type header
		localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
		if localVarHTTPContentType != "" {
			localVarHeaderParams["Content-Type"] = localVarHTTPContentType
		}

		// to determine the Accept header
		localVarHTTPHeaderAccepts := []string{"application/json"}

		// set Accept header
		localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
		if localVarHTTPHeaderAccept != "" {
			localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
		}
		req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams)
		if err != nil {
			return localVarReturnValue, nil, err
		}

		localVarHTTPResponse, err := a.client.callAPI(req)
		if err != nil || localVarHTTPResponse == nil {
			return localVarReturnValue, localVarHTTPResponse, err
		}

		localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
		localVarHTTPResponse.Body.Close()
		localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
		if err != nil {
			return localVarReturnValue, localVarHTTPResponse, err
		}

		if localVarHTTPResponse.StatusCode >= _nethttp.StatusMultipleChoices {

			if localVarHTTPResponse.StatusCode == _nethttp.StatusBadRequest || localVarHTTPResponse.StatusCode == _nethttp.StatusUnprocessableEntity {
				newErr := FgaApiValidationError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "GetStore",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "GetStore validation error for " + localVarHTTPMethod + " GetStore with body " + string(localVarBody)
				var v ValidationErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusUnauthorized || localVarHTTPResponse.StatusCode == _nethttp.StatusForbidden {
				newErr := FgaApiAuthenticationError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "GetStore",
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "GetStore auth error for " + localVarHTTPMethod + " GetStore with body " + string(localVarBody)

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusNotFound {
				newErr := FgaApiNotFoundError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "GetStore",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "GetStore validation error for " + localVarHTTPMethod + " GetStore with body " + string(localVarBody)
				var v PathUnknownErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusTooManyRequests {
				if i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				// maximum number of retry reached
				newErr := FgaApiRateLimitExceededError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "GetStore",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "GetStore rate limit error for " + localVarHTTPMethod + " GetStore with body " + string(localVarBody)

				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode >= _nethttp.StatusInternalServerError {
				if localVarHTTPResponse.StatusCode != _nethttp.StatusNotImplemented && i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				newErr := FgaApiInternalError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "GetStore",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "GetStore internal error for " + localVarHTTPMethod + " GetStore with body " + string(localVarBody)
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

				var v InternalErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr := FgaApiError{
				body: localVarBody,

				storeId:            a.client.cfg.StoreId,
				endpointCategory:   "GetStore",
				requestBody:        localVarPostBody,
				requestMethod:      localVarHTTPMethod,
				responseStatusCode: localVarHTTPResponse.StatusCode,
				responseHeader:     localVarHTTPResponse.Header,
			}
			newErr.error = "GetStore error for " + localVarHTTPMethod + " GetStore with body " + string(localVarBody)
			newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.modelDecodeError = err
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			newErr.responseCode = v.Code
			newErr.error += " with error code " + v.Code + " error message: " + v.Message

			return localVarReturnValue, localVarHTTPResponse, newErr
		}

		err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr := GenericOpenAPIError{
				body:  localVarBody,
				error: err.Error(),
			}
			return localVarReturnValue, localVarHTTPResponse, newErr
		}

		return localVarReturnValue, localVarHTTPResponse, nil
	}
	// should never have reached this
	var localVarReturnValue GetStoreResponse
	return localVarReturnValue, nil, reportError("Error not handled properly")
}

type ApiListObjectsRequest struct {
	ctx        _context.Context
	ApiService OpenFgaApi

	body *ListObjectsRequest
}

func (r ApiListObjectsRequest) Body(body ListObjectsRequest) ApiListObjectsRequest {
	r.body = &body
	return r
}

func (r ApiListObjectsRequest) Execute() (ListObjectsResponse, *_nethttp.Response, error) {
	return r.ApiService.ListObjectsExecute(r)
}

/*
  - ListObjects List all objects of the given type that the user has a relation with
  - The ListObjects API returns a list of all the objects of the given type that the user has a relation with. To achieve this, both the store tuples and the authorization model are used.

An `authorization_model_id` may be specified in the body. If it is not specified, the latest authorization model ID will be used. It is strongly recommended to specify authorization model id for better performance.
You may also specify `contextual_tuples` that will be treated as regular tuples. Each of these tuples may have an associated `condition`.
You may also provide a `context` object that will be used to evaluate the conditioned tuples in the system. It is strongly recommended to provide a value for all the input parameters of all the conditions, to ensure that all tuples be evaluated correctly.
The response will contain the related objects in an array in the "objects" field of the response and they will be strings in the object format `<type>:<id>` (e.g. "document:roadmap").
The number of objects in the response array will be limited by the execution timeout specified in the flag OPENFGA_LIST_OBJECTS_DEADLINE and by the upper bound specified in the flag OPENFGA_LIST_OBJECTS_MAX_RESULTS, whichever is hit first.
The objects given will not be sorted, and therefore two identical calls can give a given different set of objects.
  - @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return ApiListObjectsRequest
*/
func (a *OpenFgaApiService) ListObjects(ctx _context.Context) ApiListObjectsRequest {
	return ApiListObjectsRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return ListObjectsResponse
 */
func (a *OpenFgaApiService) ListObjectsExecute(r ApiListObjectsRequest) (ListObjectsResponse, *_nethttp.Response, error) {
	var maxRetry int
	var minWaitInMs int

	if a.RetryParams != nil {
		maxRetry = a.RetryParams.MinWaitInMs
		minWaitInMs = a.RetryParams.MinWaitInMs
	} else {
		maxRetry = 0
		minWaitInMs = 0
	}

	for i := 0; i < maxRetry+1; i++ {
		var (
			localVarHTTPMethod  = _nethttp.MethodPost
			localVarPostBody    interface{}
			localVarReturnValue ListObjectsResponse
		)

		if a.client.cfg.StoreId == "" {
			return localVarReturnValue, nil, reportError("Configuration.StoreId is required and must be specified to call this method")
		}
		if a.client.cfg.StoreId != "" && !internalutils.IsWellFormedUlidString(a.client.cfg.StoreId) {
			return localVarReturnValue, nil, reportError("Configuration.StoreId is invalid")
		}
		localVarPath := "/stores/{store_id}/list-objects"
		localVarPath = strings.Replace(localVarPath, "{"+"store_id"+"}", _neturl.PathEscape(a.client.cfg.StoreId), -1)

		localVarHeaderParams := make(map[string]string)
		localVarQueryParams := _neturl.Values{}
		if r.body == nil {
			return localVarReturnValue, nil, reportError("body is required and must be specified")
		}

		// to determine the Content-Type header
		localVarHTTPContentTypes := []string{"application/json"}

		// set Content-Type header
		localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
		if localVarHTTPContentType != "" {
			localVarHeaderParams["Content-Type"] = localVarHTTPContentType
		}

		// to determine the Accept header
		localVarHTTPHeaderAccepts := []string{"application/json"}

		// set Accept header
		localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
		if localVarHTTPHeaderAccept != "" {
			localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
		}
		// body params
		localVarPostBody = r.body
		req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams)
		if err != nil {
			return localVarReturnValue, nil, err
		}

		localVarHTTPResponse, err := a.client.callAPI(req)
		if err != nil || localVarHTTPResponse == nil {
			return localVarReturnValue, localVarHTTPResponse, err
		}

		localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
		localVarHTTPResponse.Body.Close()
		localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
		if err != nil {
			return localVarReturnValue, localVarHTTPResponse, err
		}

		if localVarHTTPResponse.StatusCode >= _nethttp.StatusMultipleChoices {

			if localVarHTTPResponse.StatusCode == _nethttp.StatusBadRequest || localVarHTTPResponse.StatusCode == _nethttp.StatusUnprocessableEntity {
				newErr := FgaApiValidationError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ListObjects",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "ListObjects validation error for " + localVarHTTPMethod + " ListObjects with body " + string(localVarBody)
				var v ValidationErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusUnauthorized || localVarHTTPResponse.StatusCode == _nethttp.StatusForbidden {
				newErr := FgaApiAuthenticationError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ListObjects",
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "ListObjects auth error for " + localVarHTTPMethod + " ListObjects with body " + string(localVarBody)

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusNotFound {
				newErr := FgaApiNotFoundError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ListObjects",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "ListObjects validation error for " + localVarHTTPMethod + " ListObjects with body " + string(localVarBody)
				var v PathUnknownErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusTooManyRequests {
				if i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				// maximum number of retry reached
				newErr := FgaApiRateLimitExceededError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ListObjects",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "ListObjects rate limit error for " + localVarHTTPMethod + " ListObjects with body " + string(localVarBody)

				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode >= _nethttp.StatusInternalServerError {
				if localVarHTTPResponse.StatusCode != _nethttp.StatusNotImplemented && i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				newErr := FgaApiInternalError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ListObjects",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "ListObjects internal error for " + localVarHTTPMethod + " ListObjects with body " + string(localVarBody)
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

				var v InternalErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr := FgaApiError{
				body: localVarBody,

				storeId:            a.client.cfg.StoreId,
				endpointCategory:   "ListObjects",
				requestBody:        localVarPostBody,
				requestMethod:      localVarHTTPMethod,
				responseStatusCode: localVarHTTPResponse.StatusCode,
				responseHeader:     localVarHTTPResponse.Header,
			}
			newErr.error = "ListObjects error for " + localVarHTTPMethod + " ListObjects with body " + string(localVarBody)
			newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.modelDecodeError = err
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			newErr.responseCode = v.Code
			newErr.error += " with error code " + v.Code + " error message: " + v.Message

			return localVarReturnValue, localVarHTTPResponse, newErr
		}

		err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr := GenericOpenAPIError{
				body:  localVarBody,
				error: err.Error(),
			}
			return localVarReturnValue, localVarHTTPResponse, newErr
		}

		return localVarReturnValue, localVarHTTPResponse, nil
	}
	// should never have reached this
	var localVarReturnValue ListObjectsResponse
	return localVarReturnValue, nil, reportError("Error not handled properly")
}

type ApiListStoresRequest struct {
	ctx        _context.Context
	ApiService OpenFgaApi

	pageSize          *int32
	continuationToken *string
}

func (r ApiListStoresRequest) PageSize(pageSize int32) ApiListStoresRequest {
	r.pageSize = &pageSize
	return r
}
func (r ApiListStoresRequest) ContinuationToken(continuationToken string) ApiListStoresRequest {
	r.continuationToken = &continuationToken
	return r
}

func (r ApiListStoresRequest) Execute() (ListStoresResponse, *_nethttp.Response, error) {
	return r.ApiService.ListStoresExecute(r)
}

/*
  - ListStores List all stores
  - Returns a paginated list of OpenFGA stores and a continuation token to get additional stores.

The continuation token will be empty if there are no more stores.

  - @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return ApiListStoresRequest
*/
func (a *OpenFgaApiService) ListStores(ctx _context.Context) ApiListStoresRequest {
	return ApiListStoresRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return ListStoresResponse
 */
func (a *OpenFgaApiService) ListStoresExecute(r ApiListStoresRequest) (ListStoresResponse, *_nethttp.Response, error) {
	var maxRetry int
	var minWaitInMs int

	if a.RetryParams != nil {
		maxRetry = a.RetryParams.MinWaitInMs
		minWaitInMs = a.RetryParams.MinWaitInMs
	} else {
		maxRetry = 0
		minWaitInMs = 0
	}

	for i := 0; i < maxRetry+1; i++ {
		var (
			localVarHTTPMethod  = _nethttp.MethodGet
			localVarPostBody    interface{}
			localVarReturnValue ListStoresResponse
		)

		localVarPath := "/stores"

		localVarHeaderParams := make(map[string]string)
		localVarQueryParams := _neturl.Values{}

		if r.pageSize != nil {
			localVarQueryParams.Add("page_size", parameterToString(*r.pageSize, ""))
		}
		if r.continuationToken != nil {
			localVarQueryParams.Add("continuation_token", parameterToString(*r.continuationToken, ""))
		}
		// to determine the Content-Type header
		localVarHTTPContentTypes := []string{}

		// set Content-Type header
		localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
		if localVarHTTPContentType != "" {
			localVarHeaderParams["Content-Type"] = localVarHTTPContentType
		}

		// to determine the Accept header
		localVarHTTPHeaderAccepts := []string{"application/json"}

		// set Accept header
		localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
		if localVarHTTPHeaderAccept != "" {
			localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
		}
		req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams)
		if err != nil {
			return localVarReturnValue, nil, err
		}

		localVarHTTPResponse, err := a.client.callAPI(req)
		if err != nil || localVarHTTPResponse == nil {
			return localVarReturnValue, localVarHTTPResponse, err
		}

		localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
		localVarHTTPResponse.Body.Close()
		localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
		if err != nil {
			return localVarReturnValue, localVarHTTPResponse, err
		}

		if localVarHTTPResponse.StatusCode >= _nethttp.StatusMultipleChoices {

			if localVarHTTPResponse.StatusCode == _nethttp.StatusBadRequest || localVarHTTPResponse.StatusCode == _nethttp.StatusUnprocessableEntity {
				newErr := FgaApiValidationError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ListStores",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "ListStores validation error for " + localVarHTTPMethod + " ListStores with body " + string(localVarBody)
				var v ValidationErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusUnauthorized || localVarHTTPResponse.StatusCode == _nethttp.StatusForbidden {
				newErr := FgaApiAuthenticationError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ListStores",
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "ListStores auth error for " + localVarHTTPMethod + " ListStores with body " + string(localVarBody)

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusNotFound {
				newErr := FgaApiNotFoundError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ListStores",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "ListStores validation error for " + localVarHTTPMethod + " ListStores with body " + string(localVarBody)
				var v PathUnknownErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusTooManyRequests {
				if i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				// maximum number of retry reached
				newErr := FgaApiRateLimitExceededError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ListStores",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "ListStores rate limit error for " + localVarHTTPMethod + " ListStores with body " + string(localVarBody)

				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode >= _nethttp.StatusInternalServerError {
				if localVarHTTPResponse.StatusCode != _nethttp.StatusNotImplemented && i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				newErr := FgaApiInternalError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ListStores",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "ListStores internal error for " + localVarHTTPMethod + " ListStores with body " + string(localVarBody)
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

				var v InternalErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr := FgaApiError{
				body: localVarBody,

				storeId:            a.client.cfg.StoreId,
				endpointCategory:   "ListStores",
				requestBody:        localVarPostBody,
				requestMethod:      localVarHTTPMethod,
				responseStatusCode: localVarHTTPResponse.StatusCode,
				responseHeader:     localVarHTTPResponse.Header,
			}
			newErr.error = "ListStores error for " + localVarHTTPMethod + " ListStores with body " + string(localVarBody)
			newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.modelDecodeError = err
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			newErr.responseCode = v.Code
			newErr.error += " with error code " + v.Code + " error message: " + v.Message

			return localVarReturnValue, localVarHTTPResponse, newErr
		}

		err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr := GenericOpenAPIError{
				body:  localVarBody,
				error: err.Error(),
			}
			return localVarReturnValue, localVarHTTPResponse, newErr
		}

		return localVarReturnValue, localVarHTTPResponse, nil
	}
	// should never have reached this
	var localVarReturnValue ListStoresResponse
	return localVarReturnValue, nil, reportError("Error not handled properly")
}

type ApiReadRequest struct {
	ctx        _context.Context
	ApiService OpenFgaApi

	body *ReadRequest
}

func (r ApiReadRequest) Body(body ReadRequest) ApiReadRequest {
	r.body = &body
	return r
}

func (r ApiReadRequest) Execute() (ReadResponse, *_nethttp.Response, error) {
	return r.ApiService.ReadExecute(r)
}

/*
  - Read Get tuples from the store that matches a query, without following userset rewrite rules
  - The Read API will return the tuples for a certain store that match a query filter specified in the body of the request. It is different from the `/stores/{store_id}/expand` API in that it only returns relationship tuples that are stored in the system and satisfy the query.

In the body:
1. `tuple_key` is optional. If not specified, it will return all tuples in the store.
2. `tuple_key.object` is mandatory if `tuple_key` is specified. It can be a full object (e.g., `type:object_id`) or type only (e.g., `type:`).
3. `tuple_key.user` is mandatory if tuple_key is specified in the case the `tuple_key.object` is a type only.
## Examples
### Query for all objects in a type definition
To query for all objects that `user:bob` has `reader` relationship in the `document` type definition, call read API with body of
```json

	{
	 "tuple_key": {
	     "user": "user:bob",
	     "relation": "reader",
	     "object": "document:"
	  }
	}

```
The API will return tuples and a continuation token, something like
```json

	{
	  "tuples": [
	    {
	      "key": {
	        "user": "user:bob",
	        "relation": "reader",
	        "object": "document:2021-budget"
	      },
	      "timestamp": "2021-10-06T15:32:11.128Z"
	    }
	  ],
	  "continuation_token": "eyJwayI6IkxBVEVTVF9OU0NPTkZJR19hdXRoMHN0b3JlIiwic2siOiIxem1qbXF3MWZLZExTcUoyN01MdTdqTjh0cWgifQ=="
	}

```
This means that `user:bob` has a `reader` relationship with 1 document `document:2021-budget`. Note that this API, unlike the List Objects API, does not evaluate the tuples in the store.
The continuation token will be empty if there are no more tuples to query.
### Query for all stored relationship tuples that have a particular relation and object
To query for all users that have `reader` relationship with `document:2021-budget`, call read API with body of
```json

	{
	  "tuple_key": {
	     "object": "document:2021-budget",
	     "relation": "reader"
	   }
	}

```
The API will return something like
```json

	{
	  "tuples": [
	    {
	      "key": {
	        "user": "user:bob",
	        "relation": "reader",
	        "object": "document:2021-budget"
	      },
	      "timestamp": "2021-10-06T15:32:11.128Z"
	    }
	  ],
	  "continuation_token": "eyJwayI6IkxBVEVTVF9OU0NPTkZJR19hdXRoMHN0b3JlIiwic2siOiIxem1qbXF3MWZLZExTcUoyN01MdTdqTjh0cWgifQ=="
	}

```
This means that `document:2021-budget` has 1 `reader` (`user:bob`).  Note that, even if the model said that all `writers` are also `readers`, the API will not return writers such as `user:anne` because it only returns tuples and does not evaluate them.
### Query for all users with all relationships for a particular document
To query for all users that have any relationship with `document:2021-budget`, call read API with body of
```json

	{
	  "tuple_key": {
	      "object": "document:2021-budget"
	   }
	}

```
The API will return something like
```json

	{
	  "tuples": [
	    {
	      "key": {
	        "user": "user:anne",
	        "relation": "writer",
	        "object": "document:2021-budget"
	      },
	      "timestamp": "2021-10-05T13:42:12.356Z"
	    },
	    {
	      "key": {
	        "user": "user:bob",
	        "relation": "reader",
	        "object": "document:2021-budget"
	      },
	      "timestamp": "2021-10-06T15:32:11.128Z"
	    }
	  ],
	  "continuation_token": "eyJwayI6IkxBVEVTVF9OU0NPTkZJR19hdXRoMHN0b3JlIiwic2siOiIxem1qbXF3MWZLZExTcUoyN01MdTdqTjh0cWgifQ=="
	}

```
This means that `document:2021-budget` has 1 `reader` (`user:bob`) and 1 `writer` (`user:anne`).

  - @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return ApiReadRequest
*/
func (a *OpenFgaApiService) Read(ctx _context.Context) ApiReadRequest {
	return ApiReadRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return ReadResponse
 */
func (a *OpenFgaApiService) ReadExecute(r ApiReadRequest) (ReadResponse, *_nethttp.Response, error) {
	var maxRetry int
	var minWaitInMs int

	if a.RetryParams != nil {
		maxRetry = a.RetryParams.MinWaitInMs
		minWaitInMs = a.RetryParams.MinWaitInMs
	} else {
		maxRetry = 0
		minWaitInMs = 0
	}

	for i := 0; i < maxRetry+1; i++ {
		var (
			localVarHTTPMethod  = _nethttp.MethodPost
			localVarPostBody    interface{}
			localVarReturnValue ReadResponse
		)

		if a.client.cfg.StoreId == "" {
			return localVarReturnValue, nil, reportError("Configuration.StoreId is required and must be specified to call this method")
		}
		if a.client.cfg.StoreId != "" && !internalutils.IsWellFormedUlidString(a.client.cfg.StoreId) {
			return localVarReturnValue, nil, reportError("Configuration.StoreId is invalid")
		}
		localVarPath := "/stores/{store_id}/read"
		localVarPath = strings.Replace(localVarPath, "{"+"store_id"+"}", _neturl.PathEscape(a.client.cfg.StoreId), -1)

		localVarHeaderParams := make(map[string]string)
		localVarQueryParams := _neturl.Values{}
		if r.body == nil {
			return localVarReturnValue, nil, reportError("body is required and must be specified")
		}

		// to determine the Content-Type header
		localVarHTTPContentTypes := []string{"application/json"}

		// set Content-Type header
		localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
		if localVarHTTPContentType != "" {
			localVarHeaderParams["Content-Type"] = localVarHTTPContentType
		}

		// to determine the Accept header
		localVarHTTPHeaderAccepts := []string{"application/json"}

		// set Accept header
		localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
		if localVarHTTPHeaderAccept != "" {
			localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
		}
		// body params
		localVarPostBody = r.body
		req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams)
		if err != nil {
			return localVarReturnValue, nil, err
		}

		localVarHTTPResponse, err := a.client.callAPI(req)
		if err != nil || localVarHTTPResponse == nil {
			return localVarReturnValue, localVarHTTPResponse, err
		}

		localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
		localVarHTTPResponse.Body.Close()
		localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
		if err != nil {
			return localVarReturnValue, localVarHTTPResponse, err
		}

		if localVarHTTPResponse.StatusCode >= _nethttp.StatusMultipleChoices {

			if localVarHTTPResponse.StatusCode == _nethttp.StatusBadRequest || localVarHTTPResponse.StatusCode == _nethttp.StatusUnprocessableEntity {
				newErr := FgaApiValidationError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "Read",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "Read validation error for " + localVarHTTPMethod + " Read with body " + string(localVarBody)
				var v ValidationErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusUnauthorized || localVarHTTPResponse.StatusCode == _nethttp.StatusForbidden {
				newErr := FgaApiAuthenticationError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "Read",
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "Read auth error for " + localVarHTTPMethod + " Read with body " + string(localVarBody)

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusNotFound {
				newErr := FgaApiNotFoundError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "Read",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "Read validation error for " + localVarHTTPMethod + " Read with body " + string(localVarBody)
				var v PathUnknownErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusTooManyRequests {
				if i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				// maximum number of retry reached
				newErr := FgaApiRateLimitExceededError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "Read",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "Read rate limit error for " + localVarHTTPMethod + " Read with body " + string(localVarBody)

				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode >= _nethttp.StatusInternalServerError {
				if localVarHTTPResponse.StatusCode != _nethttp.StatusNotImplemented && i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				newErr := FgaApiInternalError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "Read",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "Read internal error for " + localVarHTTPMethod + " Read with body " + string(localVarBody)
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

				var v InternalErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr := FgaApiError{
				body: localVarBody,

				storeId:            a.client.cfg.StoreId,
				endpointCategory:   "Read",
				requestBody:        localVarPostBody,
				requestMethod:      localVarHTTPMethod,
				responseStatusCode: localVarHTTPResponse.StatusCode,
				responseHeader:     localVarHTTPResponse.Header,
			}
			newErr.error = "Read error for " + localVarHTTPMethod + " Read with body " + string(localVarBody)
			newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.modelDecodeError = err
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			newErr.responseCode = v.Code
			newErr.error += " with error code " + v.Code + " error message: " + v.Message

			return localVarReturnValue, localVarHTTPResponse, newErr
		}

		err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr := GenericOpenAPIError{
				body:  localVarBody,
				error: err.Error(),
			}
			return localVarReturnValue, localVarHTTPResponse, newErr
		}

		return localVarReturnValue, localVarHTTPResponse, nil
	}
	// should never have reached this
	var localVarReturnValue ReadResponse
	return localVarReturnValue, nil, reportError("Error not handled properly")
}

type ApiReadAssertionsRequest struct {
	ctx        _context.Context
	ApiService OpenFgaApi

	authorizationModelId string
}

func (r ApiReadAssertionsRequest) Execute() (ReadAssertionsResponse, *_nethttp.Response, error) {
	return r.ApiService.ReadAssertionsExecute(r)
}

/*
 * ReadAssertions Read assertions for an authorization model ID
 * The ReadAssertions API will return, for a given authorization model id, all the assertions stored for it. An assertion is an object that contains a tuple key, and the expectation of whether a call to the Check API of that tuple key will return true or false.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param authorizationModelId
 * @return ApiReadAssertionsRequest
 */
func (a *OpenFgaApiService) ReadAssertions(ctx _context.Context, authorizationModelId string) ApiReadAssertionsRequest {
	return ApiReadAssertionsRequest{
		ApiService:           a,
		ctx:                  ctx,
		authorizationModelId: authorizationModelId,
	}
}

/*
 * Execute executes the request
 * @return ReadAssertionsResponse
 */
func (a *OpenFgaApiService) ReadAssertionsExecute(r ApiReadAssertionsRequest) (ReadAssertionsResponse, *_nethttp.Response, error) {
	var maxRetry int
	var minWaitInMs int

	if a.RetryParams != nil {
		maxRetry = a.RetryParams.MinWaitInMs
		minWaitInMs = a.RetryParams.MinWaitInMs
	} else {
		maxRetry = 0
		minWaitInMs = 0
	}

	for i := 0; i < maxRetry+1; i++ {
		var (
			localVarHTTPMethod  = _nethttp.MethodGet
			localVarPostBody    interface{}
			localVarReturnValue ReadAssertionsResponse
		)

		if a.client.cfg.StoreId == "" {
			return localVarReturnValue, nil, reportError("Configuration.StoreId is required and must be specified to call this method")
		}
		if a.client.cfg.StoreId != "" && !internalutils.IsWellFormedUlidString(a.client.cfg.StoreId) {
			return localVarReturnValue, nil, reportError("Configuration.StoreId is invalid")
		}
		localVarPath := "/stores/{store_id}/assertions/{authorization_model_id}"
		localVarPath = strings.Replace(localVarPath, "{"+"store_id"+"}", _neturl.PathEscape(a.client.cfg.StoreId), -1)
		localVarPath = strings.Replace(localVarPath, "{"+"authorization_model_id"+"}", _neturl.PathEscape(parameterToString(r.authorizationModelId, "")), -1)

		localVarHeaderParams := make(map[string]string)
		localVarQueryParams := _neturl.Values{}

		// to determine the Content-Type header
		localVarHTTPContentTypes := []string{}

		// set Content-Type header
		localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
		if localVarHTTPContentType != "" {
			localVarHeaderParams["Content-Type"] = localVarHTTPContentType
		}

		// to determine the Accept header
		localVarHTTPHeaderAccepts := []string{"application/json"}

		// set Accept header
		localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
		if localVarHTTPHeaderAccept != "" {
			localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
		}
		req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams)
		if err != nil {
			return localVarReturnValue, nil, err
		}

		localVarHTTPResponse, err := a.client.callAPI(req)
		if err != nil || localVarHTTPResponse == nil {
			return localVarReturnValue, localVarHTTPResponse, err
		}

		localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
		localVarHTTPResponse.Body.Close()
		localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
		if err != nil {
			return localVarReturnValue, localVarHTTPResponse, err
		}

		if localVarHTTPResponse.StatusCode >= _nethttp.StatusMultipleChoices {

			if localVarHTTPResponse.StatusCode == _nethttp.StatusBadRequest || localVarHTTPResponse.StatusCode == _nethttp.StatusUnprocessableEntity {
				newErr := FgaApiValidationError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ReadAssertions",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "ReadAssertions validation error for " + localVarHTTPMethod + " ReadAssertions with body " + string(localVarBody)
				var v ValidationErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusUnauthorized || localVarHTTPResponse.StatusCode == _nethttp.StatusForbidden {
				newErr := FgaApiAuthenticationError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ReadAssertions",
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "ReadAssertions auth error for " + localVarHTTPMethod + " ReadAssertions with body " + string(localVarBody)

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusNotFound {
				newErr := FgaApiNotFoundError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ReadAssertions",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "ReadAssertions validation error for " + localVarHTTPMethod + " ReadAssertions with body " + string(localVarBody)
				var v PathUnknownErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusTooManyRequests {
				if i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				// maximum number of retry reached
				newErr := FgaApiRateLimitExceededError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ReadAssertions",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "ReadAssertions rate limit error for " + localVarHTTPMethod + " ReadAssertions with body " + string(localVarBody)

				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode >= _nethttp.StatusInternalServerError {
				if localVarHTTPResponse.StatusCode != _nethttp.StatusNotImplemented && i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				newErr := FgaApiInternalError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ReadAssertions",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "ReadAssertions internal error for " + localVarHTTPMethod + " ReadAssertions with body " + string(localVarBody)
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

				var v InternalErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr := FgaApiError{
				body: localVarBody,

				storeId:            a.client.cfg.StoreId,
				endpointCategory:   "ReadAssertions",
				requestBody:        localVarPostBody,
				requestMethod:      localVarHTTPMethod,
				responseStatusCode: localVarHTTPResponse.StatusCode,
				responseHeader:     localVarHTTPResponse.Header,
			}
			newErr.error = "ReadAssertions error for " + localVarHTTPMethod + " ReadAssertions with body " + string(localVarBody)
			newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.modelDecodeError = err
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			newErr.responseCode = v.Code
			newErr.error += " with error code " + v.Code + " error message: " + v.Message

			return localVarReturnValue, localVarHTTPResponse, newErr
		}

		err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr := GenericOpenAPIError{
				body:  localVarBody,
				error: err.Error(),
			}
			return localVarReturnValue, localVarHTTPResponse, newErr
		}

		return localVarReturnValue, localVarHTTPResponse, nil
	}
	// should never have reached this
	var localVarReturnValue ReadAssertionsResponse
	return localVarReturnValue, nil, reportError("Error not handled properly")
}

type ApiReadAuthorizationModelRequest struct {
	ctx        _context.Context
	ApiService OpenFgaApi

	id string
}

func (r ApiReadAuthorizationModelRequest) Execute() (ReadAuthorizationModelResponse, *_nethttp.Response, error) {
	return r.ApiService.ReadAuthorizationModelExecute(r)
}

/*
  - ReadAuthorizationModel Return a particular version of an authorization model
  - The ReadAuthorizationModel API returns an authorization model by its identifier.

The response will return the authorization model for the particular version.

## Example
To retrieve the authorization model with ID `01G5JAVJ41T49E9TT3SKVS7X1J` for the store, call the GET authorization-models by ID API with `01G5JAVJ41T49E9TT3SKVS7X1J` as the `id` path parameter.  The API will return:
```json

	{
	  "authorization_model":{
	    "id":"01G5JAVJ41T49E9TT3SKVS7X1J",
	    "type_definitions":[
	      {
	        "type":"user"
	      },
	      {
	        "type":"document",
	        "relations":{
	          "reader":{
	            "union":{
	              "child":[
	                {
	                  "this":{}
	                },
	                {
	                  "computedUserset":{
	                    "object":"",
	                    "relation":"writer"
	                  }
	                }
	              ]
	            }
	          },
	          "writer":{
	            "this":{}
	          }
	        }
	      }
	    ]
	  }
	}

```
In the above example, there are 2 types (`user` and `document`). The `document` type has 2 relations (`writer` and `reader`).
  - @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @param id
  - @return ApiReadAuthorizationModelRequest
*/
func (a *OpenFgaApiService) ReadAuthorizationModel(ctx _context.Context, id string) ApiReadAuthorizationModelRequest {
	return ApiReadAuthorizationModelRequest{
		ApiService: a,
		ctx:        ctx,
		id:         id,
	}
}

/*
 * Execute executes the request
 * @return ReadAuthorizationModelResponse
 */
func (a *OpenFgaApiService) ReadAuthorizationModelExecute(r ApiReadAuthorizationModelRequest) (ReadAuthorizationModelResponse, *_nethttp.Response, error) {
	var maxRetry int
	var minWaitInMs int

	if a.RetryParams != nil {
		maxRetry = a.RetryParams.MinWaitInMs
		minWaitInMs = a.RetryParams.MinWaitInMs
	} else {
		maxRetry = 0
		minWaitInMs = 0
	}

	for i := 0; i < maxRetry+1; i++ {
		var (
			localVarHTTPMethod  = _nethttp.MethodGet
			localVarPostBody    interface{}
			localVarReturnValue ReadAuthorizationModelResponse
		)

		if a.client.cfg.StoreId == "" {
			return localVarReturnValue, nil, reportError("Configuration.StoreId is required and must be specified to call this method")
		}
		if a.client.cfg.StoreId != "" && !internalutils.IsWellFormedUlidString(a.client.cfg.StoreId) {
			return localVarReturnValue, nil, reportError("Configuration.StoreId is invalid")
		}
		localVarPath := "/stores/{store_id}/authorization-models/{id}"
		localVarPath = strings.Replace(localVarPath, "{"+"store_id"+"}", _neturl.PathEscape(a.client.cfg.StoreId), -1)
		localVarPath = strings.Replace(localVarPath, "{"+"id"+"}", _neturl.PathEscape(parameterToString(r.id, "")), -1)

		localVarHeaderParams := make(map[string]string)
		localVarQueryParams := _neturl.Values{}

		// to determine the Content-Type header
		localVarHTTPContentTypes := []string{}

		// set Content-Type header
		localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
		if localVarHTTPContentType != "" {
			localVarHeaderParams["Content-Type"] = localVarHTTPContentType
		}

		// to determine the Accept header
		localVarHTTPHeaderAccepts := []string{"application/json"}

		// set Accept header
		localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
		if localVarHTTPHeaderAccept != "" {
			localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
		}
		req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams)
		if err != nil {
			return localVarReturnValue, nil, err
		}

		localVarHTTPResponse, err := a.client.callAPI(req)
		if err != nil || localVarHTTPResponse == nil {
			return localVarReturnValue, localVarHTTPResponse, err
		}

		localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
		localVarHTTPResponse.Body.Close()
		localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
		if err != nil {
			return localVarReturnValue, localVarHTTPResponse, err
		}

		if localVarHTTPResponse.StatusCode >= _nethttp.StatusMultipleChoices {

			if localVarHTTPResponse.StatusCode == _nethttp.StatusBadRequest || localVarHTTPResponse.StatusCode == _nethttp.StatusUnprocessableEntity {
				newErr := FgaApiValidationError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ReadAuthorizationModel",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "ReadAuthorizationModel validation error for " + localVarHTTPMethod + " ReadAuthorizationModel with body " + string(localVarBody)
				var v ValidationErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusUnauthorized || localVarHTTPResponse.StatusCode == _nethttp.StatusForbidden {
				newErr := FgaApiAuthenticationError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ReadAuthorizationModel",
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "ReadAuthorizationModel auth error for " + localVarHTTPMethod + " ReadAuthorizationModel with body " + string(localVarBody)

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusNotFound {
				newErr := FgaApiNotFoundError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ReadAuthorizationModel",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "ReadAuthorizationModel validation error for " + localVarHTTPMethod + " ReadAuthorizationModel with body " + string(localVarBody)
				var v PathUnknownErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusTooManyRequests {
				if i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				// maximum number of retry reached
				newErr := FgaApiRateLimitExceededError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ReadAuthorizationModel",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "ReadAuthorizationModel rate limit error for " + localVarHTTPMethod + " ReadAuthorizationModel with body " + string(localVarBody)

				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode >= _nethttp.StatusInternalServerError {
				if localVarHTTPResponse.StatusCode != _nethttp.StatusNotImplemented && i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				newErr := FgaApiInternalError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ReadAuthorizationModel",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "ReadAuthorizationModel internal error for " + localVarHTTPMethod + " ReadAuthorizationModel with body " + string(localVarBody)
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

				var v InternalErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr := FgaApiError{
				body: localVarBody,

				storeId:            a.client.cfg.StoreId,
				endpointCategory:   "ReadAuthorizationModel",
				requestBody:        localVarPostBody,
				requestMethod:      localVarHTTPMethod,
				responseStatusCode: localVarHTTPResponse.StatusCode,
				responseHeader:     localVarHTTPResponse.Header,
			}
			newErr.error = "ReadAuthorizationModel error for " + localVarHTTPMethod + " ReadAuthorizationModel with body " + string(localVarBody)
			newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.modelDecodeError = err
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			newErr.responseCode = v.Code
			newErr.error += " with error code " + v.Code + " error message: " + v.Message

			return localVarReturnValue, localVarHTTPResponse, newErr
		}

		err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr := GenericOpenAPIError{
				body:  localVarBody,
				error: err.Error(),
			}
			return localVarReturnValue, localVarHTTPResponse, newErr
		}

		return localVarReturnValue, localVarHTTPResponse, nil
	}
	// should never have reached this
	var localVarReturnValue ReadAuthorizationModelResponse
	return localVarReturnValue, nil, reportError("Error not handled properly")
}

type ApiReadAuthorizationModelsRequest struct {
	ctx        _context.Context
	ApiService OpenFgaApi

	pageSize          *int32
	continuationToken *string
}

func (r ApiReadAuthorizationModelsRequest) PageSize(pageSize int32) ApiReadAuthorizationModelsRequest {
	r.pageSize = &pageSize
	return r
}
func (r ApiReadAuthorizationModelsRequest) ContinuationToken(continuationToken string) ApiReadAuthorizationModelsRequest {
	r.continuationToken = &continuationToken
	return r
}

func (r ApiReadAuthorizationModelsRequest) Execute() (ReadAuthorizationModelsResponse, *_nethttp.Response, error) {
	return r.ApiService.ReadAuthorizationModelsExecute(r)
}

/*
  - ReadAuthorizationModels Return all the authorization models for a particular store
  - The ReadAuthorizationModels API will return all the authorization models for a certain store.

OpenFGA's response will contain an array of all authorization models, sorted in descending order of creation.

## Example
Assume that a store's authorization model has been configured twice. To get all the authorization models that have been created in this store, call GET authorization-models. The API will return a response that looks like:
```json

	{
	  "authorization_models": [
	    {
	      "id": "01G50QVV17PECNVAHX1GG4Y5NC",
	      "type_definitions": [...]
	    },
	    {
	      "id": "01G4ZW8F4A07AKQ8RHSVG9RW04",
	      "type_definitions": [...]
	    },
	  ],
	  "continuation_token": "eyJwayI6IkxBVEVTVF9OU0NPTkZJR19hdXRoMHN0b3JlIiwic2siOiIxem1qbXF3MWZLZExTcUoyN01MdTdqTjh0cWgifQ=="
	}

```
If there are no more authorization models available, the `continuation_token` field will be empty
```json

	{
	  "authorization_models": [
	    {
	      "id": "01G50QVV17PECNVAHX1GG4Y5NC",
	      "type_definitions": [...]
	    },
	    {
	      "id": "01G4ZW8F4A07AKQ8RHSVG9RW04",
	      "type_definitions": [...]
	    },
	  ],
	  "continuation_token": ""
	}

```

  - @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return ApiReadAuthorizationModelsRequest
*/
func (a *OpenFgaApiService) ReadAuthorizationModels(ctx _context.Context) ApiReadAuthorizationModelsRequest {
	return ApiReadAuthorizationModelsRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return ReadAuthorizationModelsResponse
 */
func (a *OpenFgaApiService) ReadAuthorizationModelsExecute(r ApiReadAuthorizationModelsRequest) (ReadAuthorizationModelsResponse, *_nethttp.Response, error) {
	var maxRetry int
	var minWaitInMs int

	if a.RetryParams != nil {
		maxRetry = a.RetryParams.MinWaitInMs
		minWaitInMs = a.RetryParams.MinWaitInMs
	} else {
		maxRetry = 0
		minWaitInMs = 0
	}

	for i := 0; i < maxRetry+1; i++ {
		var (
			localVarHTTPMethod  = _nethttp.MethodGet
			localVarPostBody    interface{}
			localVarReturnValue ReadAuthorizationModelsResponse
		)

		if a.client.cfg.StoreId == "" {
			return localVarReturnValue, nil, reportError("Configuration.StoreId is required and must be specified to call this method")
		}
		if a.client.cfg.StoreId != "" && !internalutils.IsWellFormedUlidString(a.client.cfg.StoreId) {
			return localVarReturnValue, nil, reportError("Configuration.StoreId is invalid")
		}
		localVarPath := "/stores/{store_id}/authorization-models"
		localVarPath = strings.Replace(localVarPath, "{"+"store_id"+"}", _neturl.PathEscape(a.client.cfg.StoreId), -1)

		localVarHeaderParams := make(map[string]string)
		localVarQueryParams := _neturl.Values{}

		if r.pageSize != nil {
			localVarQueryParams.Add("page_size", parameterToString(*r.pageSize, ""))
		}
		if r.continuationToken != nil {
			localVarQueryParams.Add("continuation_token", parameterToString(*r.continuationToken, ""))
		}
		// to determine the Content-Type header
		localVarHTTPContentTypes := []string{}

		// set Content-Type header
		localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
		if localVarHTTPContentType != "" {
			localVarHeaderParams["Content-Type"] = localVarHTTPContentType
		}

		// to determine the Accept header
		localVarHTTPHeaderAccepts := []string{"application/json"}

		// set Accept header
		localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
		if localVarHTTPHeaderAccept != "" {
			localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
		}
		req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams)
		if err != nil {
			return localVarReturnValue, nil, err
		}

		localVarHTTPResponse, err := a.client.callAPI(req)
		if err != nil || localVarHTTPResponse == nil {
			return localVarReturnValue, localVarHTTPResponse, err
		}

		localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
		localVarHTTPResponse.Body.Close()
		localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
		if err != nil {
			return localVarReturnValue, localVarHTTPResponse, err
		}

		if localVarHTTPResponse.StatusCode >= _nethttp.StatusMultipleChoices {

			if localVarHTTPResponse.StatusCode == _nethttp.StatusBadRequest || localVarHTTPResponse.StatusCode == _nethttp.StatusUnprocessableEntity {
				newErr := FgaApiValidationError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ReadAuthorizationModels",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "ReadAuthorizationModels validation error for " + localVarHTTPMethod + " ReadAuthorizationModels with body " + string(localVarBody)
				var v ValidationErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusUnauthorized || localVarHTTPResponse.StatusCode == _nethttp.StatusForbidden {
				newErr := FgaApiAuthenticationError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ReadAuthorizationModels",
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "ReadAuthorizationModels auth error for " + localVarHTTPMethod + " ReadAuthorizationModels with body " + string(localVarBody)

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusNotFound {
				newErr := FgaApiNotFoundError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ReadAuthorizationModels",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "ReadAuthorizationModels validation error for " + localVarHTTPMethod + " ReadAuthorizationModels with body " + string(localVarBody)
				var v PathUnknownErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusTooManyRequests {
				if i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				// maximum number of retry reached
				newErr := FgaApiRateLimitExceededError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ReadAuthorizationModels",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "ReadAuthorizationModels rate limit error for " + localVarHTTPMethod + " ReadAuthorizationModels with body " + string(localVarBody)

				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode >= _nethttp.StatusInternalServerError {
				if localVarHTTPResponse.StatusCode != _nethttp.StatusNotImplemented && i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				newErr := FgaApiInternalError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ReadAuthorizationModels",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "ReadAuthorizationModels internal error for " + localVarHTTPMethod + " ReadAuthorizationModels with body " + string(localVarBody)
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

				var v InternalErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr := FgaApiError{
				body: localVarBody,

				storeId:            a.client.cfg.StoreId,
				endpointCategory:   "ReadAuthorizationModels",
				requestBody:        localVarPostBody,
				requestMethod:      localVarHTTPMethod,
				responseStatusCode: localVarHTTPResponse.StatusCode,
				responseHeader:     localVarHTTPResponse.Header,
			}
			newErr.error = "ReadAuthorizationModels error for " + localVarHTTPMethod + " ReadAuthorizationModels with body " + string(localVarBody)
			newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.modelDecodeError = err
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			newErr.responseCode = v.Code
			newErr.error += " with error code " + v.Code + " error message: " + v.Message

			return localVarReturnValue, localVarHTTPResponse, newErr
		}

		err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr := GenericOpenAPIError{
				body:  localVarBody,
				error: err.Error(),
			}
			return localVarReturnValue, localVarHTTPResponse, newErr
		}

		return localVarReturnValue, localVarHTTPResponse, nil
	}
	// should never have reached this
	var localVarReturnValue ReadAuthorizationModelsResponse
	return localVarReturnValue, nil, reportError("Error not handled properly")
}

type ApiReadChangesRequest struct {
	ctx        _context.Context
	ApiService OpenFgaApi

	type_             *string
	pageSize          *int32
	continuationToken *string
}

func (r ApiReadChangesRequest) Type_(type_ string) ApiReadChangesRequest {
	r.type_ = &type_
	return r
}
func (r ApiReadChangesRequest) PageSize(pageSize int32) ApiReadChangesRequest {
	r.pageSize = &pageSize
	return r
}
func (r ApiReadChangesRequest) ContinuationToken(continuationToken string) ApiReadChangesRequest {
	r.continuationToken = &continuationToken
	return r
}

func (r ApiReadChangesRequest) Execute() (ReadChangesResponse, *_nethttp.Response, error) {
	return r.ApiService.ReadChangesExecute(r)
}

/*
  - ReadChanges Return a list of all the tuple changes
  - The ReadChanges API will return a paginated list of tuple changes (additions and deletions) that occurred in a given store, sorted by ascending time. The response will include a continuation token that is used to get the next set of changes. If there are no changes after the provided continuation token, the same token will be returned in order for it to be used when new changes are recorded. If the store never had any tuples added or removed, this token will be empty.

You can use the `type` parameter to only get the list of tuple changes that affect objects of that type.
When reading a write tuple change, if it was conditioned, the condition will be returned.
When reading a delete tuple change, the condition will NOT be returned regardless of whether it was originally conditioned or not.

  - @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return ApiReadChangesRequest
*/
func (a *OpenFgaApiService) ReadChanges(ctx _context.Context) ApiReadChangesRequest {
	return ApiReadChangesRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return ReadChangesResponse
 */
func (a *OpenFgaApiService) ReadChangesExecute(r ApiReadChangesRequest) (ReadChangesResponse, *_nethttp.Response, error) {
	var maxRetry int
	var minWaitInMs int

	if a.RetryParams != nil {
		maxRetry = a.RetryParams.MinWaitInMs
		minWaitInMs = a.RetryParams.MinWaitInMs
	} else {
		maxRetry = 0
		minWaitInMs = 0
	}

	for i := 0; i < maxRetry+1; i++ {
		var (
			localVarHTTPMethod  = _nethttp.MethodGet
			localVarPostBody    interface{}
			localVarReturnValue ReadChangesResponse
		)

		if a.client.cfg.StoreId == "" {
			return localVarReturnValue, nil, reportError("Configuration.StoreId is required and must be specified to call this method")
		}
		if a.client.cfg.StoreId != "" && !internalutils.IsWellFormedUlidString(a.client.cfg.StoreId) {
			return localVarReturnValue, nil, reportError("Configuration.StoreId is invalid")
		}
		localVarPath := "/stores/{store_id}/changes"
		localVarPath = strings.Replace(localVarPath, "{"+"store_id"+"}", _neturl.PathEscape(a.client.cfg.StoreId), -1)

		localVarHeaderParams := make(map[string]string)
		localVarQueryParams := _neturl.Values{}

		if r.type_ != nil {
			localVarQueryParams.Add("type", parameterToString(*r.type_, ""))
		}
		if r.pageSize != nil {
			localVarQueryParams.Add("page_size", parameterToString(*r.pageSize, ""))
		}
		if r.continuationToken != nil {
			localVarQueryParams.Add("continuation_token", parameterToString(*r.continuationToken, ""))
		}
		// to determine the Content-Type header
		localVarHTTPContentTypes := []string{}

		// set Content-Type header
		localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
		if localVarHTTPContentType != "" {
			localVarHeaderParams["Content-Type"] = localVarHTTPContentType
		}

		// to determine the Accept header
		localVarHTTPHeaderAccepts := []string{"application/json"}

		// set Accept header
		localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
		if localVarHTTPHeaderAccept != "" {
			localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
		}
		req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams)
		if err != nil {
			return localVarReturnValue, nil, err
		}

		localVarHTTPResponse, err := a.client.callAPI(req)
		if err != nil || localVarHTTPResponse == nil {
			return localVarReturnValue, localVarHTTPResponse, err
		}

		localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
		localVarHTTPResponse.Body.Close()
		localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
		if err != nil {
			return localVarReturnValue, localVarHTTPResponse, err
		}

		if localVarHTTPResponse.StatusCode >= _nethttp.StatusMultipleChoices {

			if localVarHTTPResponse.StatusCode == _nethttp.StatusBadRequest || localVarHTTPResponse.StatusCode == _nethttp.StatusUnprocessableEntity {
				newErr := FgaApiValidationError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ReadChanges",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "ReadChanges validation error for " + localVarHTTPMethod + " ReadChanges with body " + string(localVarBody)
				var v ValidationErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusUnauthorized || localVarHTTPResponse.StatusCode == _nethttp.StatusForbidden {
				newErr := FgaApiAuthenticationError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ReadChanges",
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "ReadChanges auth error for " + localVarHTTPMethod + " ReadChanges with body " + string(localVarBody)

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusNotFound {
				newErr := FgaApiNotFoundError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ReadChanges",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "ReadChanges validation error for " + localVarHTTPMethod + " ReadChanges with body " + string(localVarBody)
				var v PathUnknownErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusTooManyRequests {
				if i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				// maximum number of retry reached
				newErr := FgaApiRateLimitExceededError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ReadChanges",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "ReadChanges rate limit error for " + localVarHTTPMethod + " ReadChanges with body " + string(localVarBody)

				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode >= _nethttp.StatusInternalServerError {
				if localVarHTTPResponse.StatusCode != _nethttp.StatusNotImplemented && i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				newErr := FgaApiInternalError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "ReadChanges",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "ReadChanges internal error for " + localVarHTTPMethod + " ReadChanges with body " + string(localVarBody)
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

				var v InternalErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr := FgaApiError{
				body: localVarBody,

				storeId:            a.client.cfg.StoreId,
				endpointCategory:   "ReadChanges",
				requestBody:        localVarPostBody,
				requestMethod:      localVarHTTPMethod,
				responseStatusCode: localVarHTTPResponse.StatusCode,
				responseHeader:     localVarHTTPResponse.Header,
			}
			newErr.error = "ReadChanges error for " + localVarHTTPMethod + " ReadChanges with body " + string(localVarBody)
			newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.modelDecodeError = err
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			newErr.responseCode = v.Code
			newErr.error += " with error code " + v.Code + " error message: " + v.Message

			return localVarReturnValue, localVarHTTPResponse, newErr
		}

		err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr := GenericOpenAPIError{
				body:  localVarBody,
				error: err.Error(),
			}
			return localVarReturnValue, localVarHTTPResponse, newErr
		}

		return localVarReturnValue, localVarHTTPResponse, nil
	}
	// should never have reached this
	var localVarReturnValue ReadChangesResponse
	return localVarReturnValue, nil, reportError("Error not handled properly")
}

type ApiWriteRequest struct {
	ctx        _context.Context
	ApiService OpenFgaApi

	body *WriteRequest
}

func (r ApiWriteRequest) Body(body WriteRequest) ApiWriteRequest {
	r.body = &body
	return r
}

func (r ApiWriteRequest) Execute() (map[string]interface{}, *_nethttp.Response, error) {
	return r.ApiService.WriteExecute(r)
}

/*
  - Write Add or delete tuples from the store
  - The Write API will update the tuples for a certain store. Tuples and type definitions allow OpenFGA to determine whether a relationship exists between an object and an user.

In the body, `writes` adds new tuples and `deletes` removes existing tuples. When deleting a tuple, any `condition` specified with it is ignored.
The API is not idempotent: if, later on, you try to add the same tuple key (even if the `condition` is different), or if you try to delete a non-existing tuple, it will throw an error.
An `authorization_model_id` may be specified in the body. If it is, it will be used to assert that each written tuple (not deleted) is valid for the model specified. If it is not specified, the latest authorization model ID will be used.
## Example
### Adding relationships
To add `user:anne` as a `writer` for `document:2021-budget`, call write API with the following
```json

	{
	  "writes": {
	    "tuple_keys": [
	      {
	        "user": "user:anne",
	        "relation": "writer",
	        "object": "document:2021-budget"
	      }
	    ]
	  },
	  "authorization_model_id": "01G50QVV17PECNVAHX1GG4Y5NC"
	}

```
### Removing relationships
To remove `user:bob` as a `reader` for `document:2021-budget`, call write API with the following
```json

	{
	  "deletes": {
	    "tuple_keys": [
	      {
	        "user": "user:bob",
	        "relation": "reader",
	        "object": "document:2021-budget"
	      }
	    ]
	  }
	}

```

  - @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return ApiWriteRequest
*/
func (a *OpenFgaApiService) Write(ctx _context.Context) ApiWriteRequest {
	return ApiWriteRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return map[string]interface{}
 */
func (a *OpenFgaApiService) WriteExecute(r ApiWriteRequest) (map[string]interface{}, *_nethttp.Response, error) {
	var maxRetry int
	var minWaitInMs int

	if a.RetryParams != nil {
		maxRetry = a.RetryParams.MinWaitInMs
		minWaitInMs = a.RetryParams.MinWaitInMs
	} else {
		maxRetry = 0
		minWaitInMs = 0
	}

	for i := 0; i < maxRetry+1; i++ {
		var (
			localVarHTTPMethod  = _nethttp.MethodPost
			localVarPostBody    interface{}
			localVarReturnValue map[string]interface{}
		)

		if a.client.cfg.StoreId == "" {
			return localVarReturnValue, nil, reportError("Configuration.StoreId is required and must be specified to call this method")
		}
		if a.client.cfg.StoreId != "" && !internalutils.IsWellFormedUlidString(a.client.cfg.StoreId) {
			return localVarReturnValue, nil, reportError("Configuration.StoreId is invalid")
		}
		localVarPath := "/stores/{store_id}/write"
		localVarPath = strings.Replace(localVarPath, "{"+"store_id"+"}", _neturl.PathEscape(a.client.cfg.StoreId), -1)

		localVarHeaderParams := make(map[string]string)
		localVarQueryParams := _neturl.Values{}
		if r.body == nil {
			return localVarReturnValue, nil, reportError("body is required and must be specified")
		}

		// to determine the Content-Type header
		localVarHTTPContentTypes := []string{"application/json"}

		// set Content-Type header
		localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
		if localVarHTTPContentType != "" {
			localVarHeaderParams["Content-Type"] = localVarHTTPContentType
		}

		// to determine the Accept header
		localVarHTTPHeaderAccepts := []string{"application/json"}

		// set Accept header
		localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
		if localVarHTTPHeaderAccept != "" {
			localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
		}
		// body params
		localVarPostBody = r.body
		req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams)
		if err != nil {
			return localVarReturnValue, nil, err
		}

		localVarHTTPResponse, err := a.client.callAPI(req)
		if err != nil || localVarHTTPResponse == nil {
			return localVarReturnValue, localVarHTTPResponse, err
		}

		localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
		localVarHTTPResponse.Body.Close()
		localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
		if err != nil {
			return localVarReturnValue, localVarHTTPResponse, err
		}

		if localVarHTTPResponse.StatusCode >= _nethttp.StatusMultipleChoices {

			if localVarHTTPResponse.StatusCode == _nethttp.StatusBadRequest || localVarHTTPResponse.StatusCode == _nethttp.StatusUnprocessableEntity {
				newErr := FgaApiValidationError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "Write",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "Write validation error for " + localVarHTTPMethod + " Write with body " + string(localVarBody)
				var v ValidationErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusUnauthorized || localVarHTTPResponse.StatusCode == _nethttp.StatusForbidden {
				newErr := FgaApiAuthenticationError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "Write",
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "Write auth error for " + localVarHTTPMethod + " Write with body " + string(localVarBody)

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusNotFound {
				newErr := FgaApiNotFoundError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "Write",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "Write validation error for " + localVarHTTPMethod + " Write with body " + string(localVarBody)
				var v PathUnknownErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusTooManyRequests {
				if i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				// maximum number of retry reached
				newErr := FgaApiRateLimitExceededError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "Write",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "Write rate limit error for " + localVarHTTPMethod + " Write with body " + string(localVarBody)

				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode >= _nethttp.StatusInternalServerError {
				if localVarHTTPResponse.StatusCode != _nethttp.StatusNotImplemented && i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				newErr := FgaApiInternalError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "Write",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "Write internal error for " + localVarHTTPMethod + " Write with body " + string(localVarBody)
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

				var v InternalErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr := FgaApiError{
				body: localVarBody,

				storeId:            a.client.cfg.StoreId,
				endpointCategory:   "Write",
				requestBody:        localVarPostBody,
				requestMethod:      localVarHTTPMethod,
				responseStatusCode: localVarHTTPResponse.StatusCode,
				responseHeader:     localVarHTTPResponse.Header,
			}
			newErr.error = "Write error for " + localVarHTTPMethod + " Write with body " + string(localVarBody)
			newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.modelDecodeError = err
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			newErr.responseCode = v.Code
			newErr.error += " with error code " + v.Code + " error message: " + v.Message

			return localVarReturnValue, localVarHTTPResponse, newErr
		}

		err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr := GenericOpenAPIError{
				body:  localVarBody,
				error: err.Error(),
			}
			return localVarReturnValue, localVarHTTPResponse, newErr
		}

		return localVarReturnValue, localVarHTTPResponse, nil
	}
	// should never have reached this
	var localVarReturnValue map[string]interface{}
	return localVarReturnValue, nil, reportError("Error not handled properly")
}

type ApiWriteAssertionsRequest struct {
	ctx        _context.Context
	ApiService OpenFgaApi

	authorizationModelId string
	body                 *WriteAssertionsRequest
}

func (r ApiWriteAssertionsRequest) Body(body WriteAssertionsRequest) ApiWriteAssertionsRequest {
	r.body = &body
	return r
}

func (r ApiWriteAssertionsRequest) Execute() (*_nethttp.Response, error) {
	return r.ApiService.WriteAssertionsExecute(r)
}

/*
 * WriteAssertions Upsert assertions for an authorization model ID
 * The WriteAssertions API will upsert new assertions for an authorization model id, or overwrite the existing ones. An assertion is an object that contains a tuple key, and the expectation of whether a call to the Check API of that tuple key will return true or false.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param authorizationModelId
 * @return ApiWriteAssertionsRequest
 */
func (a *OpenFgaApiService) WriteAssertions(ctx _context.Context, authorizationModelId string) ApiWriteAssertionsRequest {
	return ApiWriteAssertionsRequest{
		ApiService:           a,
		ctx:                  ctx,
		authorizationModelId: authorizationModelId,
	}
}

/*
 * Execute executes the request
 */
func (a *OpenFgaApiService) WriteAssertionsExecute(r ApiWriteAssertionsRequest) (*_nethttp.Response, error) {
	var maxRetry int
	var minWaitInMs int

	if a.RetryParams != nil {
		maxRetry = a.RetryParams.MinWaitInMs
		minWaitInMs = a.RetryParams.MinWaitInMs
	} else {
		maxRetry = 0
		minWaitInMs = 0
	}

	for i := 0; i < maxRetry+1; i++ {
		var (
			localVarHTTPMethod = _nethttp.MethodPut
			localVarPostBody   interface{}
		)

		if a.client.cfg.StoreId == "" {
			return nil, reportError("Configuration.StoreId is required and must be specified to call this method")
		}
		if a.client.cfg.StoreId != "" && !internalutils.IsWellFormedUlidString(a.client.cfg.StoreId) {
			return nil, reportError("Configuration.StoreId is invalid")
		}
		localVarPath := "/stores/{store_id}/assertions/{authorization_model_id}"
		localVarPath = strings.Replace(localVarPath, "{"+"store_id"+"}", _neturl.PathEscape(a.client.cfg.StoreId), -1)
		localVarPath = strings.Replace(localVarPath, "{"+"authorization_model_id"+"}", _neturl.PathEscape(parameterToString(r.authorizationModelId, "")), -1)

		localVarHeaderParams := make(map[string]string)
		localVarQueryParams := _neturl.Values{}
		if r.body == nil {
			return nil, reportError("body is required and must be specified")
		}

		// to determine the Content-Type header
		localVarHTTPContentTypes := []string{"application/json"}

		// set Content-Type header
		localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
		if localVarHTTPContentType != "" {
			localVarHeaderParams["Content-Type"] = localVarHTTPContentType
		}

		// to determine the Accept header
		localVarHTTPHeaderAccepts := []string{"application/json"}

		// set Accept header
		localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
		if localVarHTTPHeaderAccept != "" {
			localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
		}
		// body params
		localVarPostBody = r.body
		req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams)
		if err != nil {
			return nil, err
		}

		localVarHTTPResponse, err := a.client.callAPI(req)
		if err != nil || localVarHTTPResponse == nil {
			return localVarHTTPResponse, err
		}

		localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
		localVarHTTPResponse.Body.Close()
		localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
		if err != nil {
			return localVarHTTPResponse, err
		}

		if localVarHTTPResponse.StatusCode >= _nethttp.StatusMultipleChoices {

			if localVarHTTPResponse.StatusCode == _nethttp.StatusBadRequest || localVarHTTPResponse.StatusCode == _nethttp.StatusUnprocessableEntity {
				newErr := FgaApiValidationError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "WriteAssertions",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "WriteAssertions validation error for " + localVarHTTPMethod + " WriteAssertions with body " + string(localVarBody)
				var v ValidationErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusUnauthorized || localVarHTTPResponse.StatusCode == _nethttp.StatusForbidden {
				newErr := FgaApiAuthenticationError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "WriteAssertions",
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "WriteAssertions auth error for " + localVarHTTPMethod + " WriteAssertions with body " + string(localVarBody)

				return localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusNotFound {
				newErr := FgaApiNotFoundError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "WriteAssertions",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "WriteAssertions validation error for " + localVarHTTPMethod + " WriteAssertions with body " + string(localVarBody)
				var v PathUnknownErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusTooManyRequests {
				if i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				// maximum number of retry reached
				newErr := FgaApiRateLimitExceededError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "WriteAssertions",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "WriteAssertions rate limit error for " + localVarHTTPMethod + " WriteAssertions with body " + string(localVarBody)

				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				return localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode >= _nethttp.StatusInternalServerError {
				if localVarHTTPResponse.StatusCode != _nethttp.StatusNotImplemented && i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				newErr := FgaApiInternalError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "WriteAssertions",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "WriteAssertions internal error for " + localVarHTTPMethod + " WriteAssertions with body " + string(localVarBody)
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

				var v InternalErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarHTTPResponse, newErr
			}
			newErr := FgaApiError{
				body: localVarBody,

				storeId:            a.client.cfg.StoreId,
				endpointCategory:   "WriteAssertions",
				requestBody:        localVarPostBody,
				requestMethod:      localVarHTTPMethod,
				responseStatusCode: localVarHTTPResponse.StatusCode,
				responseHeader:     localVarHTTPResponse.Header,
			}
			newErr.error = "WriteAssertions error for " + localVarHTTPMethod + " WriteAssertions with body " + string(localVarBody)
			newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.modelDecodeError = err
				return localVarHTTPResponse, newErr
			}
			newErr.model = v
			newErr.responseCode = v.Code
			newErr.error += " with error code " + v.Code + " error message: " + v.Message

			return localVarHTTPResponse, newErr
		}

		return localVarHTTPResponse, nil
	}
	// should never have reached this
	return nil, reportError("Error not handled properly")
}

type ApiWriteAuthorizationModelRequest struct {
	ctx        _context.Context
	ApiService OpenFgaApi

	body *WriteAuthorizationModelRequest
}

func (r ApiWriteAuthorizationModelRequest) Body(body WriteAuthorizationModelRequest) ApiWriteAuthorizationModelRequest {
	r.body = &body
	return r
}

func (r ApiWriteAuthorizationModelRequest) Execute() (WriteAuthorizationModelResponse, *_nethttp.Response, error) {
	return r.ApiService.WriteAuthorizationModelExecute(r)
}

/*
  - WriteAuthorizationModel Create a new authorization model
  - The WriteAuthorizationModel API will add a new authorization model to a store.

Each item in the `type_definitions` array is a type definition as specified in the field `type_definition`.
The response will return the authorization model's ID in the `id` field.

## Example
To add an authorization model with `user` and `document` type definitions, call POST authorization-models API with the body:
```json

	{
	  "type_definitions":[
	    {
	      "type":"user"
	    },
	    {
	      "type":"document",
	      "relations":{
	        "reader":{
	          "union":{
	            "child":[
	              {
	                "this":{}
	              },
	              {
	                "computedUserset":{
	                  "object":"",
	                  "relation":"writer"
	                }
	              }
	            ]
	          }
	        },
	        "writer":{
	          "this":{}
	        }
	      }
	    }
	  ]
	}

```
OpenFGA's response will include the version id for this authorization model, which will look like
```
{"authorization_model_id": "01G50QVV17PECNVAHX1GG4Y5NC"}
```

  - @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
  - @return ApiWriteAuthorizationModelRequest
*/
func (a *OpenFgaApiService) WriteAuthorizationModel(ctx _context.Context) ApiWriteAuthorizationModelRequest {
	return ApiWriteAuthorizationModelRequest{
		ApiService: a,
		ctx:        ctx,
	}
}

/*
 * Execute executes the request
 * @return WriteAuthorizationModelResponse
 */
func (a *OpenFgaApiService) WriteAuthorizationModelExecute(r ApiWriteAuthorizationModelRequest) (WriteAuthorizationModelResponse, *_nethttp.Response, error) {
	var maxRetry int
	var minWaitInMs int

	if a.RetryParams != nil {
		maxRetry = a.RetryParams.MinWaitInMs
		minWaitInMs = a.RetryParams.MinWaitInMs
	} else {
		maxRetry = 0
		minWaitInMs = 0
	}

	for i := 0; i < maxRetry+1; i++ {
		var (
			localVarHTTPMethod  = _nethttp.MethodPost
			localVarPostBody    interface{}
			localVarReturnValue WriteAuthorizationModelResponse
		)

		if a.client.cfg.StoreId == "" {
			return localVarReturnValue, nil, reportError("Configuration.StoreId is required and must be specified to call this method")
		}
		if a.client.cfg.StoreId != "" && !internalutils.IsWellFormedUlidString(a.client.cfg.StoreId) {
			return localVarReturnValue, nil, reportError("Configuration.StoreId is invalid")
		}
		localVarPath := "/stores/{store_id}/authorization-models"
		localVarPath = strings.Replace(localVarPath, "{"+"store_id"+"}", _neturl.PathEscape(a.client.cfg.StoreId), -1)

		localVarHeaderParams := make(map[string]string)
		localVarQueryParams := _neturl.Values{}
		if r.body == nil {
			return localVarReturnValue, nil, reportError("body is required and must be specified")
		}

		// to determine the Content-Type header
		localVarHTTPContentTypes := []string{"application/json"}

		// set Content-Type header
		localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
		if localVarHTTPContentType != "" {
			localVarHeaderParams["Content-Type"] = localVarHTTPContentType
		}

		// to determine the Accept header
		localVarHTTPHeaderAccepts := []string{"application/json"}

		// set Accept header
		localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
		if localVarHTTPHeaderAccept != "" {
			localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
		}
		// body params
		localVarPostBody = r.body
		req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams)
		if err != nil {
			return localVarReturnValue, nil, err
		}

		localVarHTTPResponse, err := a.client.callAPI(req)
		if err != nil || localVarHTTPResponse == nil {
			return localVarReturnValue, localVarHTTPResponse, err
		}

		localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
		localVarHTTPResponse.Body.Close()
		localVarHTTPResponse.Body = _ioutil.NopCloser(bytes.NewBuffer(localVarBody))
		if err != nil {
			return localVarReturnValue, localVarHTTPResponse, err
		}

		if localVarHTTPResponse.StatusCode >= _nethttp.StatusMultipleChoices {

			if localVarHTTPResponse.StatusCode == _nethttp.StatusBadRequest || localVarHTTPResponse.StatusCode == _nethttp.StatusUnprocessableEntity {
				newErr := FgaApiValidationError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "WriteAuthorizationModel",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "WriteAuthorizationModel validation error for " + localVarHTTPMethod + " WriteAuthorizationModel with body " + string(localVarBody)
				var v ValidationErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusUnauthorized || localVarHTTPResponse.StatusCode == _nethttp.StatusForbidden {
				newErr := FgaApiAuthenticationError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "WriteAuthorizationModel",
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "WriteAuthorizationModel auth error for " + localVarHTTPMethod + " WriteAuthorizationModel with body " + string(localVarBody)

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusNotFound {
				newErr := FgaApiNotFoundError{
					body:               localVarBody,
					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "WriteAuthorizationModel",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				newErr.error = "WriteAuthorizationModel validation error for " + localVarHTTPMethod + " WriteAuthorizationModel with body " + string(localVarBody)
				var v PathUnknownErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode == _nethttp.StatusTooManyRequests {
				if i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				// maximum number of retry reached
				newErr := FgaApiRateLimitExceededError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "WriteAuthorizationModel",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "WriteAuthorizationModel rate limit error for " + localVarHTTPMethod + " WriteAuthorizationModel with body " + string(localVarBody)

				// Due to CanonicalHeaderKey, header name is case-insensitive.
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")
				return localVarReturnValue, localVarHTTPResponse, newErr
			}

			if localVarHTTPResponse.StatusCode >= _nethttp.StatusInternalServerError {
				if localVarHTTPResponse.StatusCode != _nethttp.StatusNotImplemented && i < maxRetry {
					time.Sleep(time.Duration(internalutils.RandomTime(i, minWaitInMs)) * time.Millisecond)
					continue
				}
				newErr := FgaApiInternalError{
					body: localVarBody,

					storeId:            a.client.cfg.StoreId,
					endpointCategory:   "WriteAuthorizationModel",
					requestBody:        localVarPostBody,
					requestMethod:      localVarHTTPMethod,
					responseStatusCode: localVarHTTPResponse.StatusCode,
					responseHeader:     localVarHTTPResponse.Header,
				}
				newErr.error = "WriteAuthorizationModel internal error for " + localVarHTTPMethod + " WriteAuthorizationModel with body " + string(localVarBody)
				newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

				var v InternalErrorMessageResponse
				err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
				if err != nil {
					newErr.modelDecodeError = err
					return localVarReturnValue, localVarHTTPResponse, newErr
				}
				newErr.model = v
				newErr.responseCode = v.GetCode()
				newErr.error += " with error code " + string(v.GetCode()) + " error message: " + v.GetMessage()

				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr := FgaApiError{
				body: localVarBody,

				storeId:            a.client.cfg.StoreId,
				endpointCategory:   "WriteAuthorizationModel",
				requestBody:        localVarPostBody,
				requestMethod:      localVarHTTPMethod,
				responseStatusCode: localVarHTTPResponse.StatusCode,
				responseHeader:     localVarHTTPResponse.Header,
			}
			newErr.error = "WriteAuthorizationModel error for " + localVarHTTPMethod + " WriteAuthorizationModel with body " + string(localVarBody)
			newErr.requestId = localVarHTTPResponse.Header.Get("Fga-Request-Id")

			var v ErrorResponse
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.modelDecodeError = err
				return localVarReturnValue, localVarHTTPResponse, newErr
			}
			newErr.model = v
			newErr.responseCode = v.Code
			newErr.error += " with error code " + v.Code + " error message: " + v.Message

			return localVarReturnValue, localVarHTTPResponse, newErr
		}

		err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr := GenericOpenAPIError{
				body:  localVarBody,
				error: err.Error(),
			}
			return localVarReturnValue, localVarHTTPResponse, newErr
		}

		return localVarReturnValue, localVarHTTPResponse, nil
	}
	// should never have reached this
	var localVarReturnValue WriteAuthorizationModelResponse
	return localVarReturnValue, nil, reportError("Error not handled properly")
}
