package managedapplications

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/solutions/mgmt/2019-07-01/managedapplications"

// AllowedUpgradePlansResult the array of plan.
type AllowedUpgradePlansResult struct {
	autorest.Response `json:"-"`
	// Value - The array of plans.
	Value *[]Plan `json:"value,omitempty"`
}

// Application information about managed application.
type Application struct {
	autorest.Response `json:"-"`
	// ApplicationProperties - The managed application properties.
	*ApplicationProperties `json:"properties,omitempty"`
	// Plan - The plan information.
	Plan *Plan `json:"plan,omitempty"`
	// Kind - The kind of the managed application. Allowed values are MarketPlace and ServiceCatalog.
	Kind *string `json:"kind,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// ManagedBy - ID of the resource that manages this resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// Sku - The SKU of the resource.
	Sku *Sku `json:"sku,omitempty"`
	// ID - READ-ONLY; Resource ID
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Application.
func (a Application) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.ApplicationProperties != nil {
		objectMap["properties"] = a.ApplicationProperties
	}
	if a.Plan != nil {
		objectMap["plan"] = a.Plan
	}
	if a.Kind != nil {
		objectMap["kind"] = a.Kind
	}
	if a.Identity != nil {
		objectMap["identity"] = a.Identity
	}
	if a.ManagedBy != nil {
		objectMap["managedBy"] = a.ManagedBy
	}
	if a.Sku != nil {
		objectMap["sku"] = a.Sku
	}
	if a.Location != nil {
		objectMap["location"] = a.Location
	}
	if a.Tags != nil {
		objectMap["tags"] = a.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Application struct.
func (a *Application) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationProperties ApplicationProperties
				err = json.Unmarshal(*v, &applicationProperties)
				if err != nil {
					return err
				}
				a.ApplicationProperties = &applicationProperties
			}
		case "plan":
			if v != nil {
				var plan Plan
				err = json.Unmarshal(*v, &plan)
				if err != nil {
					return err
				}
				a.Plan = &plan
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				a.Kind = &kind
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				a.Identity = &identity
			}
		case "managedBy":
			if v != nil {
				var managedBy string
				err = json.Unmarshal(*v, &managedBy)
				if err != nil {
					return err
				}
				a.ManagedBy = &managedBy
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				a.Sku = &sku
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				a.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				a.Tags = tags
			}
		}
	}

	return nil
}

// ApplicationArtifact managed application artifact.
type ApplicationArtifact struct {
	// Name - The managed application artifact name. Possible values include: 'NotSpecified', 'ViewDefinition', 'Authorizations', 'CustomRoleDefinition'
	Name ApplicationArtifactName `json:"name,omitempty"`
	// URI - The managed application artifact blob uri.
	URI *string `json:"uri,omitempty"`
	// Type - The managed application artifact type. Possible values include: 'ApplicationArtifactTypeNotSpecified', 'ApplicationArtifactTypeTemplate', 'ApplicationArtifactTypeCustom'
	Type ApplicationArtifactType `json:"type,omitempty"`
}

// ApplicationAuthorization the managed application provider authorization.
type ApplicationAuthorization struct {
	// PrincipalID - The provider's principal identifier. This is the identity that the provider will use to call ARM to manage the managed application resources.
	PrincipalID *string `json:"principalId,omitempty"`
	// RoleDefinitionID - The provider's role definition identifier. This role will define all the permissions that the provider must have on the managed application's container resource group. This role definition cannot have permission to delete the resource group.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
}

// ApplicationBillingDetailsDefinition managed application billing details definition.
type ApplicationBillingDetailsDefinition struct {
	// ResourceUsageID - The managed application resource usage Id.
	ResourceUsageID *string `json:"resourceUsageId,omitempty"`
}

// ApplicationClientDetails the application client details to track the entity creating/updating the
// managed app resource.
type ApplicationClientDetails struct {
	// Oid - The client Oid.
	Oid *string `json:"oid,omitempty"`
	// Puid - The client Puid
	Puid *string `json:"puid,omitempty"`
	// ApplicationID - The client application Id.
	ApplicationID *string `json:"applicationId,omitempty"`
}

// ApplicationDefinition information about managed application definition.
type ApplicationDefinition struct {
	autorest.Response `json:"-"`
	// ApplicationDefinitionProperties - The managed application definition properties.
	*ApplicationDefinitionProperties `json:"properties,omitempty"`
	// ManagedBy - ID of the resource that manages this resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// Sku - The SKU of the resource.
	Sku *Sku `json:"sku,omitempty"`
	// ID - READ-ONLY; Resource ID
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ApplicationDefinition.
func (ad ApplicationDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ad.ApplicationDefinitionProperties != nil {
		objectMap["properties"] = ad.ApplicationDefinitionProperties
	}
	if ad.ManagedBy != nil {
		objectMap["managedBy"] = ad.ManagedBy
	}
	if ad.Sku != nil {
		objectMap["sku"] = ad.Sku
	}
	if ad.Location != nil {
		objectMap["location"] = ad.Location
	}
	if ad.Tags != nil {
		objectMap["tags"] = ad.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationDefinition struct.
func (ad *ApplicationDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationDefinitionProperties ApplicationDefinitionProperties
				err = json.Unmarshal(*v, &applicationDefinitionProperties)
				if err != nil {
					return err
				}
				ad.ApplicationDefinitionProperties = &applicationDefinitionProperties
			}
		case "managedBy":
			if v != nil {
				var managedBy string
				err = json.Unmarshal(*v, &managedBy)
				if err != nil {
					return err
				}
				ad.ManagedBy = &managedBy
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				ad.Sku = &sku
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ad.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ad.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ad.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ad.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ad.Tags = tags
			}
		}
	}

	return nil
}

// ApplicationDefinitionArtifact application definition artifact.
type ApplicationDefinitionArtifact struct {
	// Name - The managed application definition artifact name. Possible values include: 'ApplicationDefinitionArtifactNameNotSpecified', 'ApplicationDefinitionArtifactNameApplicationResourceTemplate', 'ApplicationDefinitionArtifactNameCreateUIDefinition', 'ApplicationDefinitionArtifactNameMainTemplateParameters'
	Name ApplicationDefinitionArtifactName `json:"name,omitempty"`
	// URI - The managed application definition artifact blob uri.
	URI *string `json:"uri,omitempty"`
	// Type - The managed application definition artifact type. Possible values include: 'ApplicationArtifactTypeNotSpecified', 'ApplicationArtifactTypeTemplate', 'ApplicationArtifactTypeCustom'
	Type ApplicationArtifactType `json:"type,omitempty"`
}

// ApplicationDefinitionListResult list of managed application definitions.
type ApplicationDefinitionListResult struct {
	autorest.Response `json:"-"`
	// Value - The array of managed application definitions.
	Value *[]ApplicationDefinition `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ApplicationDefinitionListResultIterator provides access to a complete listing of ApplicationDefinition
// values.
type ApplicationDefinitionListResultIterator struct {
	i    int
	page ApplicationDefinitionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationDefinitionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationDefinitionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationDefinitionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationDefinitionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationDefinitionListResultIterator) Response() ApplicationDefinitionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationDefinitionListResultIterator) Value() ApplicationDefinition {
	if !iter.page.NotDone() {
		return ApplicationDefinition{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationDefinitionListResultIterator type.
func NewApplicationDefinitionListResultIterator(page ApplicationDefinitionListResultPage) ApplicationDefinitionListResultIterator {
	return ApplicationDefinitionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (adlr ApplicationDefinitionListResult) IsEmpty() bool {
	return adlr.Value == nil || len(*adlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (adlr ApplicationDefinitionListResult) hasNextLink() bool {
	return adlr.NextLink != nil && len(*adlr.NextLink) != 0
}

// applicationDefinitionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (adlr ApplicationDefinitionListResult) applicationDefinitionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !adlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(adlr.NextLink)))
}

// ApplicationDefinitionListResultPage contains a page of ApplicationDefinition values.
type ApplicationDefinitionListResultPage struct {
	fn   func(context.Context, ApplicationDefinitionListResult) (ApplicationDefinitionListResult, error)
	adlr ApplicationDefinitionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationDefinitionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationDefinitionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.adlr)
		if err != nil {
			return err
		}
		page.adlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationDefinitionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationDefinitionListResultPage) NotDone() bool {
	return !page.adlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationDefinitionListResultPage) Response() ApplicationDefinitionListResult {
	return page.adlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationDefinitionListResultPage) Values() []ApplicationDefinition {
	if page.adlr.IsEmpty() {
		return nil
	}
	return *page.adlr.Value
}

// Creates a new instance of the ApplicationDefinitionListResultPage type.
func NewApplicationDefinitionListResultPage(cur ApplicationDefinitionListResult, getNextPage func(context.Context, ApplicationDefinitionListResult) (ApplicationDefinitionListResult, error)) ApplicationDefinitionListResultPage {
	return ApplicationDefinitionListResultPage{
		fn:   getNextPage,
		adlr: cur,
	}
}

// ApplicationDefinitionPatchable information about an application definition request.
type ApplicationDefinitionPatchable struct {
	// Tags - Application definition tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ApplicationDefinitionPatchable.
func (adp ApplicationDefinitionPatchable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if adp.Tags != nil {
		objectMap["tags"] = adp.Tags
	}
	return json.Marshal(objectMap)
}

// ApplicationDefinitionProperties the managed application definition properties.
type ApplicationDefinitionProperties struct {
	// LockLevel - The managed application lock level. Possible values include: 'CanNotDelete', 'ReadOnly', 'None'
	LockLevel ApplicationLockLevel `json:"lockLevel,omitempty"`
	// DisplayName - The managed application definition display name.
	DisplayName *string `json:"displayName,omitempty"`
	// IsEnabled - A value indicating whether the package is enabled or not.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// Authorizations - The managed application provider authorizations.
	Authorizations *[]ApplicationAuthorization `json:"authorizations,omitempty"`
	// Artifacts - The collection of managed application artifacts. The portal will use the files specified as artifacts to construct the user experience of creating a managed application from a managed application definition.
	Artifacts *[]ApplicationDefinitionArtifact `json:"artifacts,omitempty"`
	// Description - The managed application definition description.
	Description *string `json:"description,omitempty"`
	// PackageFileURI - The managed application definition package file Uri. Use this element
	PackageFileURI *string `json:"packageFileUri,omitempty"`
	// StorageAccountID - The storage account id for bring your own storage scenario.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
	// MainTemplate - The inline main template json which has resources to be provisioned. It can be a JObject or well-formed JSON string.
	MainTemplate interface{} `json:"mainTemplate,omitempty"`
	// CreateUIDefinition - The createUiDefinition json for the backing template with Microsoft.Solutions/applications resource. It can be a JObject or well-formed JSON string.
	CreateUIDefinition interface{} `json:"createUiDefinition,omitempty"`
	// NotificationPolicy - The managed application notification policy.
	NotificationPolicy *ApplicationNotificationPolicy `json:"notificationPolicy,omitempty"`
	// LockingPolicy - The managed application locking policy.
	LockingPolicy *ApplicationPackageLockingPolicyDefinition `json:"lockingPolicy,omitempty"`
	// DeploymentPolicy - The managed application deployment policy.
	DeploymentPolicy *ApplicationDeploymentPolicy `json:"deploymentPolicy,omitempty"`
	// ManagementPolicy - The managed application management policy that determines publisher's access to the managed resource group.
	ManagementPolicy *ApplicationManagementPolicy `json:"managementPolicy,omitempty"`
	// Policies - The managed application provider policies.
	Policies *[]ApplicationPolicy `json:"policies,omitempty"`
}

// ApplicationDeploymentPolicy managed application deployment policy.
type ApplicationDeploymentPolicy struct {
	// DeploymentMode - The managed application deployment mode. Possible values include: 'DeploymentModeNotSpecified', 'DeploymentModeIncremental', 'DeploymentModeComplete'
	DeploymentMode DeploymentMode `json:"deploymentMode,omitempty"`
}

// ApplicationJitAccessPolicy managed application Jit access policy.
type ApplicationJitAccessPolicy struct {
	// JitAccessEnabled - Whether the JIT access is enabled.
	JitAccessEnabled *bool `json:"jitAccessEnabled,omitempty"`
	// JitApprovalMode - JIT approval mode. Possible values include: 'JitApprovalModeNotSpecified', 'JitApprovalModeAutoApprove', 'JitApprovalModeManualApprove'
	JitApprovalMode JitApprovalMode `json:"jitApprovalMode,omitempty"`
	// JitApprovers - The JIT approvers
	JitApprovers *[]JitApproverDefinition `json:"jitApprovers,omitempty"`
	// MaximumJitAccessDuration - The maximum duration JIT access is granted. This is an ISO8601 time period value.
	MaximumJitAccessDuration *string `json:"maximumJitAccessDuration,omitempty"`
}

// ApplicationListResult list of managed applications.
type ApplicationListResult struct {
	autorest.Response `json:"-"`
	// Value - The array of managed applications.
	Value *[]Application `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ApplicationListResultIterator provides access to a complete listing of Application values.
type ApplicationListResultIterator struct {
	i    int
	page ApplicationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationListResultIterator) Response() ApplicationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationListResultIterator) Value() Application {
	if !iter.page.NotDone() {
		return Application{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationListResultIterator type.
func NewApplicationListResultIterator(page ApplicationListResultPage) ApplicationListResultIterator {
	return ApplicationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alr ApplicationListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (alr ApplicationListResult) hasNextLink() bool {
	return alr.NextLink != nil && len(*alr.NextLink) != 0
}

// applicationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr ApplicationListResult) applicationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !alr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// ApplicationListResultPage contains a page of Application values.
type ApplicationListResultPage struct {
	fn  func(context.Context, ApplicationListResult) (ApplicationListResult, error)
	alr ApplicationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.alr)
		if err != nil {
			return err
		}
		page.alr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationListResultPage) Response() ApplicationListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationListResultPage) Values() []Application {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Creates a new instance of the ApplicationListResultPage type.
func NewApplicationListResultPage(cur ApplicationListResult, getNextPage func(context.Context, ApplicationListResult) (ApplicationListResult, error)) ApplicationListResultPage {
	return ApplicationListResultPage{
		fn:  getNextPage,
		alr: cur,
	}
}

// ApplicationManagementPolicy managed application management policy.
type ApplicationManagementPolicy struct {
	// Mode - The managed application management mode. Possible values include: 'ApplicationManagementModeNotSpecified', 'ApplicationManagementModeUnmanaged', 'ApplicationManagementModeManaged'
	Mode ApplicationManagementMode `json:"mode,omitempty"`
}

// ApplicationNotificationEndpoint managed application notification endpoint.
type ApplicationNotificationEndpoint struct {
	// URI - The managed application notification endpoint uri.
	URI *string `json:"uri,omitempty"`
}

// ApplicationNotificationPolicy managed application notification policy.
type ApplicationNotificationPolicy struct {
	// NotificationEndpoints - The managed application notification endpoint.
	NotificationEndpoints *[]ApplicationNotificationEndpoint `json:"notificationEndpoints,omitempty"`
}

// ApplicationPackageContact the application package contact information.
type ApplicationPackageContact struct {
	// ContactName - The contact name.
	ContactName *string `json:"contactName,omitempty"`
	// Email - The contact email.
	Email *string `json:"email,omitempty"`
	// Phone - The contact phone number.
	Phone *string `json:"phone,omitempty"`
}

// ApplicationPackageLockingPolicyDefinition managed application locking policy.
type ApplicationPackageLockingPolicyDefinition struct {
	// AllowedActions - The deny assignment excluded actions.
	AllowedActions *[]string `json:"allowedActions,omitempty"`
	// AllowedDataActions - The deny assignment excluded data actions.
	AllowedDataActions *[]string `json:"allowedDataActions,omitempty"`
}

// ApplicationPackageSupportUrls the appliance package support URLs.
type ApplicationPackageSupportUrls struct {
	// PublicAzure - The public azure support URL.
	PublicAzure *string `json:"publicAzure,omitempty"`
	// GovernmentCloud - The government cloud support URL.
	GovernmentCloud *string `json:"governmentCloud,omitempty"`
}

// ApplicationPatchable information about managed application.
type ApplicationPatchable struct {
	autorest.Response `json:"-"`
	// ApplicationProperties - The managed application properties.
	*ApplicationProperties `json:"properties,omitempty"`
	// Plan - The plan information.
	Plan *PlanPatchable `json:"plan,omitempty"`
	// Kind - The kind of the managed application. Allowed values are MarketPlace and ServiceCatalog.
	Kind *string `json:"kind,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// ManagedBy - ID of the resource that manages this resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// Sku - The SKU of the resource.
	Sku *Sku `json:"sku,omitempty"`
	// ID - READ-ONLY; Resource ID
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ApplicationPatchable.
func (ap ApplicationPatchable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.ApplicationProperties != nil {
		objectMap["properties"] = ap.ApplicationProperties
	}
	if ap.Plan != nil {
		objectMap["plan"] = ap.Plan
	}
	if ap.Kind != nil {
		objectMap["kind"] = ap.Kind
	}
	if ap.Identity != nil {
		objectMap["identity"] = ap.Identity
	}
	if ap.ManagedBy != nil {
		objectMap["managedBy"] = ap.ManagedBy
	}
	if ap.Sku != nil {
		objectMap["sku"] = ap.Sku
	}
	if ap.Location != nil {
		objectMap["location"] = ap.Location
	}
	if ap.Tags != nil {
		objectMap["tags"] = ap.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationPatchable struct.
func (ap *ApplicationPatchable) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationProperties ApplicationProperties
				err = json.Unmarshal(*v, &applicationProperties)
				if err != nil {
					return err
				}
				ap.ApplicationProperties = &applicationProperties
			}
		case "plan":
			if v != nil {
				var plan PlanPatchable
				err = json.Unmarshal(*v, &plan)
				if err != nil {
					return err
				}
				ap.Plan = &plan
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ap.Kind = &kind
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				ap.Identity = &identity
			}
		case "managedBy":
			if v != nil {
				var managedBy string
				err = json.Unmarshal(*v, &managedBy)
				if err != nil {
					return err
				}
				ap.ManagedBy = &managedBy
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				ap.Sku = &sku
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ap.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ap.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ap.Tags = tags
			}
		}
	}

	return nil
}

// ApplicationPolicy managed application policy.
type ApplicationPolicy struct {
	// Name - The policy name
	Name *string `json:"name,omitempty"`
	// PolicyDefinitionID - The policy definition Id.
	PolicyDefinitionID *string `json:"policyDefinitionId,omitempty"`
	// Parameters - The policy parameters.
	Parameters *string `json:"parameters,omitempty"`
}

// ApplicationProperties the managed application properties.
type ApplicationProperties struct {
	// ManagedResourceGroupID - The managed resource group Id.
	ManagedResourceGroupID *string `json:"managedResourceGroupId,omitempty"`
	// ApplicationDefinitionID - The fully qualified path of managed application definition Id.
	ApplicationDefinitionID *string `json:"applicationDefinitionId,omitempty"`
	// Parameters - Name and value pairs that define the managed application parameters. It can be a JObject or a well formed JSON string.
	Parameters interface{} `json:"parameters,omitempty"`
	// Outputs - READ-ONLY; Name and value pairs that define the managed application outputs.
	Outputs interface{} `json:"outputs,omitempty"`
	// ProvisioningState - READ-ONLY; The managed application provisioning state. Possible values include: 'ProvisioningStateNotSpecified', 'ProvisioningStateAccepted', 'ProvisioningStateRunning', 'ProvisioningStateReady', 'ProvisioningStateCreating', 'ProvisioningStateCreated', 'ProvisioningStateDeleting', 'ProvisioningStateDeleted', 'ProvisioningStateCanceled', 'ProvisioningStateFailed', 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// BillingDetails - READ-ONLY; The managed application billing details.
	BillingDetails *ApplicationBillingDetailsDefinition `json:"billingDetails,omitempty"`
	// JitAccessPolicy - The managed application Jit access policy.
	JitAccessPolicy *ApplicationJitAccessPolicy `json:"jitAccessPolicy,omitempty"`
	// PublisherTenantID - READ-ONLY; The publisher tenant Id.
	PublisherTenantID *string `json:"publisherTenantId,omitempty"`
	// Authorizations - READ-ONLY; The  read-only authorizations property that is retrieved from the application package.
	Authorizations *[]ApplicationAuthorization `json:"authorizations,omitempty"`
	// ManagementMode - READ-ONLY; The managed application management mode. Possible values include: 'ApplicationManagementModeNotSpecified', 'ApplicationManagementModeUnmanaged', 'ApplicationManagementModeManaged'
	ManagementMode ApplicationManagementMode `json:"managementMode,omitempty"`
	// CustomerSupport - READ-ONLY; The read-only customer support property that is retrieved from the application package.
	CustomerSupport *ApplicationPackageContact `json:"customerSupport,omitempty"`
	// SupportUrls - READ-ONLY; The read-only support URLs property that is retrieved from the application package.
	SupportUrls *ApplicationPackageSupportUrls `json:"supportUrls,omitempty"`
	// Artifacts - READ-ONLY; The collection of managed application artifacts.
	Artifacts *[]ApplicationArtifact `json:"artifacts,omitempty"`
	// CreatedBy - READ-ONLY; The client entity that created the JIT request.
	CreatedBy *ApplicationClientDetails `json:"createdBy,omitempty"`
	// UpdatedBy - READ-ONLY; The client entity that last updated the JIT request.
	UpdatedBy *ApplicationClientDetails `json:"updatedBy,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationProperties.
func (ap ApplicationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.ManagedResourceGroupID != nil {
		objectMap["managedResourceGroupId"] = ap.ManagedResourceGroupID
	}
	if ap.ApplicationDefinitionID != nil {
		objectMap["applicationDefinitionId"] = ap.ApplicationDefinitionID
	}
	if ap.Parameters != nil {
		objectMap["parameters"] = ap.Parameters
	}
	if ap.JitAccessPolicy != nil {
		objectMap["jitAccessPolicy"] = ap.JitAccessPolicy
	}
	return json.Marshal(objectMap)
}

// ApplicationPropertiesPatchable the managed application properties.
type ApplicationPropertiesPatchable struct {
	// ManagedResourceGroupID - The managed resource group Id.
	ManagedResourceGroupID *string `json:"managedResourceGroupId,omitempty"`
	// ApplicationDefinitionID - The fully qualified path of managed application definition Id.
	ApplicationDefinitionID *string `json:"applicationDefinitionId,omitempty"`
	// Parameters - Name and value pairs that define the managed application parameters. It can be a JObject or a well formed JSON string.
	Parameters interface{} `json:"parameters,omitempty"`
	// Outputs - READ-ONLY; Name and value pairs that define the managed application outputs.
	Outputs interface{} `json:"outputs,omitempty"`
	// ProvisioningState - READ-ONLY; The managed application provisioning state. Possible values include: 'ProvisioningStateNotSpecified', 'ProvisioningStateAccepted', 'ProvisioningStateRunning', 'ProvisioningStateReady', 'ProvisioningStateCreating', 'ProvisioningStateCreated', 'ProvisioningStateDeleting', 'ProvisioningStateDeleted', 'ProvisioningStateCanceled', 'ProvisioningStateFailed', 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationPropertiesPatchable.
func (app ApplicationPropertiesPatchable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if app.ManagedResourceGroupID != nil {
		objectMap["managedResourceGroupId"] = app.ManagedResourceGroupID
	}
	if app.ApplicationDefinitionID != nil {
		objectMap["applicationDefinitionId"] = app.ApplicationDefinitionID
	}
	if app.Parameters != nil {
		objectMap["parameters"] = app.Parameters
	}
	return json.Marshal(objectMap)
}

// ApplicationsCreateOrUpdateByIDFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationsCreateOrUpdateByIDFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationsClient) (Application, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ApplicationsCreateOrUpdateByIDFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ApplicationsCreateOrUpdateByIDFuture.Result.
func (future *ApplicationsCreateOrUpdateByIDFuture) result(client ApplicationsClient) (a Application, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "managedapplications.ApplicationsCreateOrUpdateByIDFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		a.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("managedapplications.ApplicationsCreateOrUpdateByIDFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if a.Response.Response, err = future.GetResult(sender); err == nil && a.Response.Response.StatusCode != http.StatusNoContent {
		a, err = client.CreateOrUpdateByIDResponder(a.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "managedapplications.ApplicationsCreateOrUpdateByIDFuture", "Result", a.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ApplicationsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationsClient) (Application, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ApplicationsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ApplicationsCreateOrUpdateFuture.Result.
func (future *ApplicationsCreateOrUpdateFuture) result(client ApplicationsClient) (a Application, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "managedapplications.ApplicationsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		a.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("managedapplications.ApplicationsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if a.Response.Response, err = future.GetResult(sender); err == nil && a.Response.Response.StatusCode != http.StatusNoContent {
		a, err = client.CreateOrUpdateResponder(a.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "managedapplications.ApplicationsCreateOrUpdateFuture", "Result", a.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ApplicationsDeleteByIDFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ApplicationsDeleteByIDFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ApplicationsDeleteByIDFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ApplicationsDeleteByIDFuture.Result.
func (future *ApplicationsDeleteByIDFuture) result(client ApplicationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "managedapplications.ApplicationsDeleteByIDFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("managedapplications.ApplicationsDeleteByIDFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ApplicationsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ApplicationsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ApplicationsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ApplicationsDeleteFuture.Result.
func (future *ApplicationsDeleteFuture) result(client ApplicationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "managedapplications.ApplicationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("managedapplications.ApplicationsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ApplicationsRefreshPermissionsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationsRefreshPermissionsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ApplicationsRefreshPermissionsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ApplicationsRefreshPermissionsFuture.Result.
func (future *ApplicationsRefreshPermissionsFuture) result(client ApplicationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "managedapplications.ApplicationsRefreshPermissionsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("managedapplications.ApplicationsRefreshPermissionsFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ApplicationsUpdateAccessFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplicationsUpdateAccessFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationsClient) (UpdateAccessDefinition, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ApplicationsUpdateAccessFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ApplicationsUpdateAccessFuture.Result.
func (future *ApplicationsUpdateAccessFuture) result(client ApplicationsClient) (uad UpdateAccessDefinition, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "managedapplications.ApplicationsUpdateAccessFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		uad.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("managedapplications.ApplicationsUpdateAccessFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if uad.Response.Response, err = future.GetResult(sender); err == nil && uad.Response.Response.StatusCode != http.StatusNoContent {
		uad, err = client.UpdateAccessResponder(uad.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "managedapplications.ApplicationsUpdateAccessFuture", "Result", uad.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ApplicationsUpdateByIDFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ApplicationsUpdateByIDFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationsClient) (ApplicationPatchable, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ApplicationsUpdateByIDFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ApplicationsUpdateByIDFuture.Result.
func (future *ApplicationsUpdateByIDFuture) result(client ApplicationsClient) (ap ApplicationPatchable, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "managedapplications.ApplicationsUpdateByIDFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ap.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("managedapplications.ApplicationsUpdateByIDFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ap.Response.Response, err = future.GetResult(sender); err == nil && ap.Response.Response.StatusCode != http.StatusNoContent {
		ap, err = client.UpdateByIDResponder(ap.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "managedapplications.ApplicationsUpdateByIDFuture", "Result", ap.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ApplicationsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ApplicationsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplicationsClient) (ApplicationPatchable, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ApplicationsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ApplicationsUpdateFuture.Result.
func (future *ApplicationsUpdateFuture) result(client ApplicationsClient) (ap ApplicationPatchable, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "managedapplications.ApplicationsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ap.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("managedapplications.ApplicationsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ap.Response.Response, err = future.GetResult(sender); err == nil && ap.Response.Response.StatusCode != http.StatusNoContent {
		ap, err = client.UpdateResponder(ap.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "managedapplications.ApplicationsUpdateFuture", "Result", ap.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetail.
func (ed ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.).
type ErrorResponse struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// GenericResource resource information.
type GenericResource struct {
	// ManagedBy - ID of the resource that manages this resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// Sku - The SKU of the resource.
	Sku *Sku `json:"sku,omitempty"`
	// ID - READ-ONLY; Resource ID
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GenericResource.
func (gr GenericResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gr.ManagedBy != nil {
		objectMap["managedBy"] = gr.ManagedBy
	}
	if gr.Sku != nil {
		objectMap["sku"] = gr.Sku
	}
	if gr.Location != nil {
		objectMap["location"] = gr.Location
	}
	if gr.Tags != nil {
		objectMap["tags"] = gr.Tags
	}
	return json.Marshal(objectMap)
}

// Identity identity for the resource.
type Identity struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'ResourceIdentityTypeSystemAssigned', 'ResourceIdentityTypeUserAssigned', 'ResourceIdentityTypeSystemAssignedUserAssigned', 'ResourceIdentityTypeNone'
	Type ResourceIdentityType `json:"type,omitempty"`
	// UserAssignedIdentities - The list of user identities associated with the resource. The user identity dictionary key references will be resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*UserAssignedResourceIdentity `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.Type != "" {
		objectMap["type"] = i.Type
	}
	if i.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = i.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// JitApproverDefinition JIT approver definition.
type JitApproverDefinition struct {
	// ID - The approver service principal Id.
	ID *string `json:"id,omitempty"`
	// Type - The approver type. Possible values include: 'User', 'Group'
	Type JitApproverType `json:"type,omitempty"`
	// DisplayName - The approver display name.
	DisplayName *string `json:"displayName,omitempty"`
}

// JitAuthorizationPolicies the JIT authorization policies.
type JitAuthorizationPolicies struct {
	// PrincipalID - The the principal id that will be granted JIT access.
	PrincipalID *string `json:"principalId,omitempty"`
	// RoleDefinitionID - The role definition id that will be granted to the Principal.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
}

// JitRequestDefinition information about JIT request definition.
type JitRequestDefinition struct {
	autorest.Response `json:"-"`
	// JitRequestProperties - The JIT request properties.
	*JitRequestProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for JitRequestDefinition.
func (jrd JitRequestDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jrd.JitRequestProperties != nil {
		objectMap["properties"] = jrd.JitRequestProperties
	}
	if jrd.Location != nil {
		objectMap["location"] = jrd.Location
	}
	if jrd.Tags != nil {
		objectMap["tags"] = jrd.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JitRequestDefinition struct.
func (jrd *JitRequestDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jitRequestProperties JitRequestProperties
				err = json.Unmarshal(*v, &jitRequestProperties)
				if err != nil {
					return err
				}
				jrd.JitRequestProperties = &jitRequestProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				jrd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				jrd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				jrd.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				jrd.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				jrd.Tags = tags
			}
		}
	}

	return nil
}

// JitRequestDefinitionListResult list of JIT requests.
type JitRequestDefinitionListResult struct {
	autorest.Response `json:"-"`
	// Value - The array of Jit request definition.
	Value *[]JitRequestDefinition `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// JitRequestMetadata the JIT request metadata.
type JitRequestMetadata struct {
	// OriginRequestID - The origin request id.
	OriginRequestID *string `json:"originRequestId,omitempty"`
	// RequestorID - The requestor id.
	RequestorID *string `json:"requestorId,omitempty"`
	// TenantDisplayName - The publisher's tenant name.
	TenantDisplayName *string `json:"tenantDisplayName,omitempty"`
	// SubjectDisplayName - The subject display name.
	SubjectDisplayName *string `json:"subjectDisplayName,omitempty"`
}

// JitRequestPatchable information about JIT request.
type JitRequestPatchable struct {
	// Tags - Jit request tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for JitRequestPatchable.
func (jrp JitRequestPatchable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jrp.Tags != nil {
		objectMap["tags"] = jrp.Tags
	}
	return json.Marshal(objectMap)
}

// JitRequestProperties information about JIT request properties
type JitRequestProperties struct {
	// ApplicationResourceID - The parent application id.
	ApplicationResourceID *string `json:"applicationResourceId,omitempty"`
	// PublisherTenantID - READ-ONLY; The publisher tenant id.
	PublisherTenantID *string `json:"publisherTenantId,omitempty"`
	// JitAuthorizationPolicies - The JIT authorization policies.
	JitAuthorizationPolicies *[]JitAuthorizationPolicies `json:"jitAuthorizationPolicies,omitempty"`
	// JitSchedulingPolicy - The JIT request properties.
	JitSchedulingPolicy *JitSchedulingPolicy `json:"jitSchedulingPolicy,omitempty"`
	// ProvisioningState - READ-ONLY; The JIT request provisioning state. Possible values include: 'ProvisioningStateNotSpecified', 'ProvisioningStateAccepted', 'ProvisioningStateRunning', 'ProvisioningStateReady', 'ProvisioningStateCreating', 'ProvisioningStateCreated', 'ProvisioningStateDeleting', 'ProvisioningStateDeleted', 'ProvisioningStateCanceled', 'ProvisioningStateFailed', 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// JitRequestState - READ-ONLY; The JIT request state. Possible values include: 'JitRequestStateNotSpecified', 'JitRequestStatePending', 'JitRequestStateApproved', 'JitRequestStateDenied', 'JitRequestStateFailed', 'JitRequestStateCanceled', 'JitRequestStateExpired', 'JitRequestStateTimeout'
	JitRequestState JitRequestState `json:"jitRequestState,omitempty"`
	// CreatedBy - READ-ONLY; The client entity that created the JIT request.
	CreatedBy *ApplicationClientDetails `json:"createdBy,omitempty"`
	// UpdatedBy - READ-ONLY; The client entity that last updated the JIT request.
	UpdatedBy *ApplicationClientDetails `json:"updatedBy,omitempty"`
}

// MarshalJSON is the custom marshaler for JitRequestProperties.
func (jrp JitRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jrp.ApplicationResourceID != nil {
		objectMap["applicationResourceId"] = jrp.ApplicationResourceID
	}
	if jrp.JitAuthorizationPolicies != nil {
		objectMap["jitAuthorizationPolicies"] = jrp.JitAuthorizationPolicies
	}
	if jrp.JitSchedulingPolicy != nil {
		objectMap["jitSchedulingPolicy"] = jrp.JitSchedulingPolicy
	}
	return json.Marshal(objectMap)
}

// JitRequestsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type JitRequestsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(JitRequestsClient) (JitRequestDefinition, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *JitRequestsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for JitRequestsCreateOrUpdateFuture.Result.
func (future *JitRequestsCreateOrUpdateFuture) result(client JitRequestsClient) (jrd JitRequestDefinition, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "managedapplications.JitRequestsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		jrd.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("managedapplications.JitRequestsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if jrd.Response.Response, err = future.GetResult(sender); err == nil && jrd.Response.Response.StatusCode != http.StatusNoContent {
		jrd, err = client.CreateOrUpdateResponder(jrd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "managedapplications.JitRequestsCreateOrUpdateFuture", "Result", jrd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// JitSchedulingPolicy the JIT scheduling policies.
type JitSchedulingPolicy struct {
	// Type - The type of JIT schedule. Possible values include: 'JitSchedulingTypeNotSpecified', 'JitSchedulingTypeOnce', 'JitSchedulingTypeRecurring'
	Type     JitSchedulingType `json:"type,omitempty"`
	Duration *string           `json:"duration,omitempty"`
	// StartTime - The start time of the request.
	StartTime *date.Time `json:"startTime,omitempty"`
}

// ListTokenRequest list token request body.
type ListTokenRequest struct {
	// AuthorizationAudience - The authorization audience.
	AuthorizationAudience *string `json:"authorizationAudience,omitempty"`
	// UserAssignedIdentities - The user assigned identities.
	UserAssignedIdentities *[]string `json:"userAssignedIdentities,omitempty"`
}

// ManagedIdentityToken the managed identity token for the managed app resource.
type ManagedIdentityToken struct {
	// AccessToken - The requested access token.
	AccessToken *string `json:"accessToken,omitempty"`
	// ExpiresIn - The number of seconds the access token will be valid.
	ExpiresIn *string `json:"expiresIn,omitempty"`
	// ExpiresOn - The timespan when the access token expires. This is represented as the number of seconds from epoch.
	ExpiresOn *string `json:"expiresOn,omitempty"`
	// NotBefore - The timespan when the access token takes effect. This is represented as the number of seconds from epoch.
	NotBefore *string `json:"notBefore,omitempty"`
	// AuthorizationAudience - The aud (audience) the access token was request for. This is the same as what was provided in the listTokens request.
	AuthorizationAudience *string `json:"authorizationAudience,omitempty"`
	// ResourceID - The Azure resource ID for the issued token. This is either the managed application ID or the user-assigned identity ID.
	ResourceID *string `json:"resourceId,omitempty"`
	// TokenType - The type of the token.
	TokenType *string `json:"tokenType,omitempty"`
}

// ManagedIdentityTokenResult the array of managed identity tokens.
type ManagedIdentityTokenResult struct {
	autorest.Response `json:"-"`
	// Value - The array of managed identity tokens.
	Value *[]ManagedIdentityToken `json:"value,omitempty"`
}

// Operation microsoft.Solutions operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.Solutions
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed: Application, JitRequest, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult a list of REST API operations supported by an Azure Resource Provider. It contains
// an URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of operations supported by the resource provider
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationListResult.
func (olr OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// Plan plan for the managed application.
type Plan struct {
	// Name - The plan name.
	Name *string `json:"name,omitempty"`
	// Publisher - The publisher ID.
	Publisher *string `json:"publisher,omitempty"`
	// Product - The product code.
	Product *string `json:"product,omitempty"`
	// PromotionCode - The promotion code.
	PromotionCode *string `json:"promotionCode,omitempty"`
	// Version - The plan's version.
	Version *string `json:"version,omitempty"`
}

// PlanPatchable plan for the managed application.
type PlanPatchable struct {
	// Name - The plan name.
	Name *string `json:"name,omitempty"`
	// Publisher - The publisher ID.
	Publisher *string `json:"publisher,omitempty"`
	// Product - The product code.
	Product *string `json:"product,omitempty"`
	// PromotionCode - The promotion code.
	PromotionCode *string `json:"promotionCode,omitempty"`
	// Version - The plan's version.
	Version *string `json:"version,omitempty"`
}

// Resource resource information.
type Resource struct {
	// ID - READ-ONLY; Resource ID
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// Sku SKU for the resource.
type Sku struct {
	// Name - The SKU name.
	Name *string `json:"name,omitempty"`
	// Tier - The SKU tier.
	Tier *string `json:"tier,omitempty"`
	// Size - The SKU size.
	Size *string `json:"size,omitempty"`
	// Family - The SKU family.
	Family *string `json:"family,omitempty"`
	// Model - The SKU model.
	Model *string `json:"model,omitempty"`
	// Capacity - The SKU capacity.
	Capacity *int32 `json:"capacity,omitempty"`
}

// UpdateAccessDefinition update access request definition.
type UpdateAccessDefinition struct {
	autorest.Response `json:"-"`
	// Approver - The approver name.
	Approver *string `json:"approver,omitempty"`
	// Metadata - The JIT request metadata.
	Metadata *JitRequestMetadata `json:"metadata,omitempty"`
	// Status - The JIT status. Possible values include: 'StatusNotSpecified', 'StatusElevate', 'StatusRemove'
	Status Status `json:"status,omitempty"`
	// SubStatus - The JIT status. Possible values include: 'SubstatusNotSpecified', 'SubstatusApproved', 'SubstatusDenied', 'SubstatusFailed', 'SubstatusExpired', 'SubstatusTimeout'
	SubStatus Substatus `json:"subStatus,omitempty"`
}

// UserAssignedResourceIdentity represents the user assigned identity that is contained within the
// UserAssignedIdentities dictionary on ResourceIdentity
type UserAssignedResourceIdentity struct {
	// PrincipalID - READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant id of user assigned identity.
	TenantID *string `json:"tenantId,omitempty"`
}

// MarshalJSON is the custom marshaler for UserAssignedResourceIdentity.
func (uari UserAssignedResourceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}
