package authorization

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// RoleAssignmentSchedulesClient is the client for the RoleAssignmentSchedules methods of the Authorization service.
type RoleAssignmentSchedulesClient struct {
	BaseClient
}

// NewRoleAssignmentSchedulesClient creates an instance of the RoleAssignmentSchedulesClient client.
func NewRoleAssignmentSchedulesClient(subscriptionID string) RoleAssignmentSchedulesClient {
	return NewRoleAssignmentSchedulesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewRoleAssignmentSchedulesClientWithBaseURI creates an instance of the RoleAssignmentSchedulesClient client using a
// custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds,
// Azure stack).
func NewRoleAssignmentSchedulesClientWithBaseURI(baseURI string, subscriptionID string) RoleAssignmentSchedulesClient {
	return RoleAssignmentSchedulesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get get the specified role assignment schedule for a resource scope
// Parameters:
// scope - the scope of the role assignment schedule.
// roleAssignmentScheduleName - the name (guid) of the role assignment schedule to get.
func (client RoleAssignmentSchedulesClient) Get(ctx context.Context, scope string, roleAssignmentScheduleName string) (result RoleAssignmentSchedule, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentSchedulesClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, scope, roleAssignmentScheduleName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentSchedulesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentSchedulesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentSchedulesClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client RoleAssignmentSchedulesClient) GetPreparer(ctx context.Context, scope string, roleAssignmentScheduleName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"roleAssignmentScheduleName": autorest.Encode("path", roleAssignmentScheduleName),
		"scope":                      scope,
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Authorization/roleAssignmentSchedules/{roleAssignmentScheduleName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client RoleAssignmentSchedulesClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client RoleAssignmentSchedulesClient) GetResponder(resp *http.Response) (result RoleAssignmentSchedule, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListForScope gets role assignment schedules for a resource scope.
// Parameters:
// scope - the scope of the role assignments schedules.
// filter - the filter to apply on the operation. Use $filter=atScope() to return all role assignment schedules
// at or above the scope. Use $filter=principalId eq {id} to return all role assignment schedules at, above or
// below the scope for the specified principal. Use $filter=assignedTo('{userId}') to return all role
// assignment schedules for the current user. Use $filter=asTarget() to return all role assignment schedules
// created for the current user.
func (client RoleAssignmentSchedulesClient) ListForScope(ctx context.Context, scope string, filter string) (result RoleAssignmentScheduleListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentSchedulesClient.ListForScope")
		defer func() {
			sc := -1
			if result.raslr.Response.Response != nil {
				sc = result.raslr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listForScopeNextResults
	req, err := client.ListForScopePreparer(ctx, scope, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentSchedulesClient", "ListForScope", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListForScopeSender(req)
	if err != nil {
		result.raslr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentSchedulesClient", "ListForScope", resp, "Failure sending request")
		return
	}

	result.raslr, err = client.ListForScopeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentSchedulesClient", "ListForScope", resp, "Failure responding to request")
		return
	}
	if result.raslr.hasNextLink() && result.raslr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListForScopePreparer prepares the ListForScope request.
func (client RoleAssignmentSchedulesClient) ListForScopePreparer(ctx context.Context, scope string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"scope": scope,
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Authorization/roleAssignmentSchedules", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListForScopeSender sends the ListForScope request. The method will close the
// http.Response Body if it receives an error.
func (client RoleAssignmentSchedulesClient) ListForScopeSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListForScopeResponder handles the response to the ListForScope request. The method always
// closes the http.Response Body.
func (client RoleAssignmentSchedulesClient) ListForScopeResponder(resp *http.Response) (result RoleAssignmentScheduleListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listForScopeNextResults retrieves the next set of results, if any.
func (client RoleAssignmentSchedulesClient) listForScopeNextResults(ctx context.Context, lastResults RoleAssignmentScheduleListResult) (result RoleAssignmentScheduleListResult, err error) {
	req, err := lastResults.roleAssignmentScheduleListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "authorization.RoleAssignmentSchedulesClient", "listForScopeNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListForScopeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "authorization.RoleAssignmentSchedulesClient", "listForScopeNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListForScopeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentSchedulesClient", "listForScopeNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListForScopeComplete enumerates all values, automatically crossing page boundaries as required.
func (client RoleAssignmentSchedulesClient) ListForScopeComplete(ctx context.Context, scope string, filter string) (result RoleAssignmentScheduleListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentSchedulesClient.ListForScope")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListForScope(ctx, scope, filter)
	return
}
