// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package amplifybackend

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opCloneBackend = "CloneBackend"

// CloneBackendRequest generates a "aws/request.Request" representing the
// client's request for the CloneBackend operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CloneBackend for more information on using the CloneBackend
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CloneBackendRequest method.
//    req, resp := client.CloneBackendRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CloneBackend
func (c *AmplifyBackend) CloneBackendRequest(input *CloneBackendInput) (req *request.Request, output *CloneBackendOutput) {
	op := &request.Operation{
		Name:       opCloneBackend,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/environments/{backendEnvironmentName}/clone",
	}

	if input == nil {
		input = &CloneBackendInput{}
	}

	output = &CloneBackendOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CloneBackend API operation for AmplifyBackend.
//
// This operation clones an existing backend.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation CloneBackend for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CloneBackend
func (c *AmplifyBackend) CloneBackend(input *CloneBackendInput) (*CloneBackendOutput, error) {
	req, out := c.CloneBackendRequest(input)
	return out, req.Send()
}

// CloneBackendWithContext is the same as CloneBackend with the addition of
// the ability to pass a context and additional request options.
//
// See CloneBackend for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) CloneBackendWithContext(ctx aws.Context, input *CloneBackendInput, opts ...request.Option) (*CloneBackendOutput, error) {
	req, out := c.CloneBackendRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBackend = "CreateBackend"

// CreateBackendRequest generates a "aws/request.Request" representing the
// client's request for the CreateBackend operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBackend for more information on using the CreateBackend
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBackendRequest method.
//    req, resp := client.CreateBackendRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackend
func (c *AmplifyBackend) CreateBackendRequest(input *CreateBackendInput) (req *request.Request, output *CreateBackendOutput) {
	op := &request.Operation{
		Name:       opCreateBackend,
		HTTPMethod: "POST",
		HTTPPath:   "/backend",
	}

	if input == nil {
		input = &CreateBackendInput{}
	}

	output = &CreateBackendOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBackend API operation for AmplifyBackend.
//
// This operation creates a backend for an Amplify app. Backends are automatically
// created at the time of app creation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation CreateBackend for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackend
func (c *AmplifyBackend) CreateBackend(input *CreateBackendInput) (*CreateBackendOutput, error) {
	req, out := c.CreateBackendRequest(input)
	return out, req.Send()
}

// CreateBackendWithContext is the same as CreateBackend with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBackend for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) CreateBackendWithContext(ctx aws.Context, input *CreateBackendInput, opts ...request.Option) (*CreateBackendOutput, error) {
	req, out := c.CreateBackendRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBackendAPI = "CreateBackendAPI"

// CreateBackendAPIRequest generates a "aws/request.Request" representing the
// client's request for the CreateBackendAPI operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBackendAPI for more information on using the CreateBackendAPI
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBackendAPIRequest method.
//    req, resp := client.CreateBackendAPIRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackendAPI
func (c *AmplifyBackend) CreateBackendAPIRequest(input *CreateBackendAPIInput) (req *request.Request, output *CreateBackendAPIOutput) {
	op := &request.Operation{
		Name:       opCreateBackendAPI,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/api",
	}

	if input == nil {
		input = &CreateBackendAPIInput{}
	}

	output = &CreateBackendAPIOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBackendAPI API operation for AmplifyBackend.
//
// Creates a new backend API resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation CreateBackendAPI for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackendAPI
func (c *AmplifyBackend) CreateBackendAPI(input *CreateBackendAPIInput) (*CreateBackendAPIOutput, error) {
	req, out := c.CreateBackendAPIRequest(input)
	return out, req.Send()
}

// CreateBackendAPIWithContext is the same as CreateBackendAPI with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBackendAPI for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) CreateBackendAPIWithContext(ctx aws.Context, input *CreateBackendAPIInput, opts ...request.Option) (*CreateBackendAPIOutput, error) {
	req, out := c.CreateBackendAPIRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBackendAuth = "CreateBackendAuth"

// CreateBackendAuthRequest generates a "aws/request.Request" representing the
// client's request for the CreateBackendAuth operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBackendAuth for more information on using the CreateBackendAuth
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBackendAuthRequest method.
//    req, resp := client.CreateBackendAuthRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackendAuth
func (c *AmplifyBackend) CreateBackendAuthRequest(input *CreateBackendAuthInput) (req *request.Request, output *CreateBackendAuthOutput) {
	op := &request.Operation{
		Name:       opCreateBackendAuth,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/auth",
	}

	if input == nil {
		input = &CreateBackendAuthInput{}
	}

	output = &CreateBackendAuthOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBackendAuth API operation for AmplifyBackend.
//
// Creates a new backend authentication resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation CreateBackendAuth for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackendAuth
func (c *AmplifyBackend) CreateBackendAuth(input *CreateBackendAuthInput) (*CreateBackendAuthOutput, error) {
	req, out := c.CreateBackendAuthRequest(input)
	return out, req.Send()
}

// CreateBackendAuthWithContext is the same as CreateBackendAuth with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBackendAuth for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) CreateBackendAuthWithContext(ctx aws.Context, input *CreateBackendAuthInput, opts ...request.Option) (*CreateBackendAuthOutput, error) {
	req, out := c.CreateBackendAuthRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBackendConfig = "CreateBackendConfig"

// CreateBackendConfigRequest generates a "aws/request.Request" representing the
// client's request for the CreateBackendConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBackendConfig for more information on using the CreateBackendConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBackendConfigRequest method.
//    req, resp := client.CreateBackendConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackendConfig
func (c *AmplifyBackend) CreateBackendConfigRequest(input *CreateBackendConfigInput) (req *request.Request, output *CreateBackendConfigOutput) {
	op := &request.Operation{
		Name:       opCreateBackendConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/config",
	}

	if input == nil {
		input = &CreateBackendConfigInput{}
	}

	output = &CreateBackendConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBackendConfig API operation for AmplifyBackend.
//
// Creates a config object for a backend.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation CreateBackendConfig for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackendConfig
func (c *AmplifyBackend) CreateBackendConfig(input *CreateBackendConfigInput) (*CreateBackendConfigOutput, error) {
	req, out := c.CreateBackendConfigRequest(input)
	return out, req.Send()
}

// CreateBackendConfigWithContext is the same as CreateBackendConfig with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBackendConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) CreateBackendConfigWithContext(ctx aws.Context, input *CreateBackendConfigInput, opts ...request.Option) (*CreateBackendConfigOutput, error) {
	req, out := c.CreateBackendConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBackendStorage = "CreateBackendStorage"

// CreateBackendStorageRequest generates a "aws/request.Request" representing the
// client's request for the CreateBackendStorage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBackendStorage for more information on using the CreateBackendStorage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBackendStorageRequest method.
//    req, resp := client.CreateBackendStorageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackendStorage
func (c *AmplifyBackend) CreateBackendStorageRequest(input *CreateBackendStorageInput) (req *request.Request, output *CreateBackendStorageOutput) {
	op := &request.Operation{
		Name:       opCreateBackendStorage,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/storage",
	}

	if input == nil {
		input = &CreateBackendStorageInput{}
	}

	output = &CreateBackendStorageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBackendStorage API operation for AmplifyBackend.
//
// Creates a backend storage resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation CreateBackendStorage for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackendStorage
func (c *AmplifyBackend) CreateBackendStorage(input *CreateBackendStorageInput) (*CreateBackendStorageOutput, error) {
	req, out := c.CreateBackendStorageRequest(input)
	return out, req.Send()
}

// CreateBackendStorageWithContext is the same as CreateBackendStorage with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBackendStorage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) CreateBackendStorageWithContext(ctx aws.Context, input *CreateBackendStorageInput, opts ...request.Option) (*CreateBackendStorageOutput, error) {
	req, out := c.CreateBackendStorageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateToken = "CreateToken"

// CreateTokenRequest generates a "aws/request.Request" representing the
// client's request for the CreateToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateToken for more information on using the CreateToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTokenRequest method.
//    req, resp := client.CreateTokenRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateToken
func (c *AmplifyBackend) CreateTokenRequest(input *CreateTokenInput) (req *request.Request, output *CreateTokenOutput) {
	op := &request.Operation{
		Name:       opCreateToken,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/challenge",
	}

	if input == nil {
		input = &CreateTokenInput{}
	}

	output = &CreateTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateToken API operation for AmplifyBackend.
//
// Generates a one-time challenge code to authenticate a user into your Amplify
// Admin UI.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation CreateToken for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateToken
func (c *AmplifyBackend) CreateToken(input *CreateTokenInput) (*CreateTokenOutput, error) {
	req, out := c.CreateTokenRequest(input)
	return out, req.Send()
}

// CreateTokenWithContext is the same as CreateToken with the addition of
// the ability to pass a context and additional request options.
//
// See CreateToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) CreateTokenWithContext(ctx aws.Context, input *CreateTokenInput, opts ...request.Option) (*CreateTokenOutput, error) {
	req, out := c.CreateTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBackend = "DeleteBackend"

// DeleteBackendRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBackend operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBackend for more information on using the DeleteBackend
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBackendRequest method.
//    req, resp := client.DeleteBackendRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteBackend
func (c *AmplifyBackend) DeleteBackendRequest(input *DeleteBackendInput) (req *request.Request, output *DeleteBackendOutput) {
	op := &request.Operation{
		Name:       opDeleteBackend,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/environments/{backendEnvironmentName}/remove",
	}

	if input == nil {
		input = &DeleteBackendInput{}
	}

	output = &DeleteBackendOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBackend API operation for AmplifyBackend.
//
// Removes an existing environment from your Amplify project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation DeleteBackend for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteBackend
func (c *AmplifyBackend) DeleteBackend(input *DeleteBackendInput) (*DeleteBackendOutput, error) {
	req, out := c.DeleteBackendRequest(input)
	return out, req.Send()
}

// DeleteBackendWithContext is the same as DeleteBackend with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBackend for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) DeleteBackendWithContext(ctx aws.Context, input *DeleteBackendInput, opts ...request.Option) (*DeleteBackendOutput, error) {
	req, out := c.DeleteBackendRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBackendAPI = "DeleteBackendAPI"

// DeleteBackendAPIRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBackendAPI operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBackendAPI for more information on using the DeleteBackendAPI
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBackendAPIRequest method.
//    req, resp := client.DeleteBackendAPIRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteBackendAPI
func (c *AmplifyBackend) DeleteBackendAPIRequest(input *DeleteBackendAPIInput) (req *request.Request, output *DeleteBackendAPIOutput) {
	op := &request.Operation{
		Name:       opDeleteBackendAPI,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/api/{backendEnvironmentName}/remove",
	}

	if input == nil {
		input = &DeleteBackendAPIInput{}
	}

	output = &DeleteBackendAPIOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBackendAPI API operation for AmplifyBackend.
//
// Deletes an existing backend API resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation DeleteBackendAPI for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteBackendAPI
func (c *AmplifyBackend) DeleteBackendAPI(input *DeleteBackendAPIInput) (*DeleteBackendAPIOutput, error) {
	req, out := c.DeleteBackendAPIRequest(input)
	return out, req.Send()
}

// DeleteBackendAPIWithContext is the same as DeleteBackendAPI with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBackendAPI for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) DeleteBackendAPIWithContext(ctx aws.Context, input *DeleteBackendAPIInput, opts ...request.Option) (*DeleteBackendAPIOutput, error) {
	req, out := c.DeleteBackendAPIRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBackendAuth = "DeleteBackendAuth"

// DeleteBackendAuthRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBackendAuth operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBackendAuth for more information on using the DeleteBackendAuth
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBackendAuthRequest method.
//    req, resp := client.DeleteBackendAuthRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteBackendAuth
func (c *AmplifyBackend) DeleteBackendAuthRequest(input *DeleteBackendAuthInput) (req *request.Request, output *DeleteBackendAuthOutput) {
	op := &request.Operation{
		Name:       opDeleteBackendAuth,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/auth/{backendEnvironmentName}/remove",
	}

	if input == nil {
		input = &DeleteBackendAuthInput{}
	}

	output = &DeleteBackendAuthOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBackendAuth API operation for AmplifyBackend.
//
// Deletes an existing backend authentication resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation DeleteBackendAuth for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteBackendAuth
func (c *AmplifyBackend) DeleteBackendAuth(input *DeleteBackendAuthInput) (*DeleteBackendAuthOutput, error) {
	req, out := c.DeleteBackendAuthRequest(input)
	return out, req.Send()
}

// DeleteBackendAuthWithContext is the same as DeleteBackendAuth with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBackendAuth for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) DeleteBackendAuthWithContext(ctx aws.Context, input *DeleteBackendAuthInput, opts ...request.Option) (*DeleteBackendAuthOutput, error) {
	req, out := c.DeleteBackendAuthRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBackendStorage = "DeleteBackendStorage"

// DeleteBackendStorageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBackendStorage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBackendStorage for more information on using the DeleteBackendStorage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBackendStorageRequest method.
//    req, resp := client.DeleteBackendStorageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteBackendStorage
func (c *AmplifyBackend) DeleteBackendStorageRequest(input *DeleteBackendStorageInput) (req *request.Request, output *DeleteBackendStorageOutput) {
	op := &request.Operation{
		Name:       opDeleteBackendStorage,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/storage/{backendEnvironmentName}/remove",
	}

	if input == nil {
		input = &DeleteBackendStorageInput{}
	}

	output = &DeleteBackendStorageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBackendStorage API operation for AmplifyBackend.
//
// Removes the specified backend storage resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation DeleteBackendStorage for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteBackendStorage
func (c *AmplifyBackend) DeleteBackendStorage(input *DeleteBackendStorageInput) (*DeleteBackendStorageOutput, error) {
	req, out := c.DeleteBackendStorageRequest(input)
	return out, req.Send()
}

// DeleteBackendStorageWithContext is the same as DeleteBackendStorage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBackendStorage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) DeleteBackendStorageWithContext(ctx aws.Context, input *DeleteBackendStorageInput, opts ...request.Option) (*DeleteBackendStorageOutput, error) {
	req, out := c.DeleteBackendStorageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteToken = "DeleteToken"

// DeleteTokenRequest generates a "aws/request.Request" representing the
// client's request for the DeleteToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteToken for more information on using the DeleteToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTokenRequest method.
//    req, resp := client.DeleteTokenRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteToken
func (c *AmplifyBackend) DeleteTokenRequest(input *DeleteTokenInput) (req *request.Request, output *DeleteTokenOutput) {
	op := &request.Operation{
		Name:       opDeleteToken,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/challenge/{sessionId}/remove",
	}

	if input == nil {
		input = &DeleteTokenInput{}
	}

	output = &DeleteTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteToken API operation for AmplifyBackend.
//
// Deletes the challenge token based on the given appId and sessionId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation DeleteToken for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteToken
func (c *AmplifyBackend) DeleteToken(input *DeleteTokenInput) (*DeleteTokenOutput, error) {
	req, out := c.DeleteTokenRequest(input)
	return out, req.Send()
}

// DeleteTokenWithContext is the same as DeleteToken with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) DeleteTokenWithContext(ctx aws.Context, input *DeleteTokenInput, opts ...request.Option) (*DeleteTokenOutput, error) {
	req, out := c.DeleteTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGenerateBackendAPIModels = "GenerateBackendAPIModels"

// GenerateBackendAPIModelsRequest generates a "aws/request.Request" representing the
// client's request for the GenerateBackendAPIModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GenerateBackendAPIModels for more information on using the GenerateBackendAPIModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GenerateBackendAPIModelsRequest method.
//    req, resp := client.GenerateBackendAPIModelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GenerateBackendAPIModels
func (c *AmplifyBackend) GenerateBackendAPIModelsRequest(input *GenerateBackendAPIModelsInput) (req *request.Request, output *GenerateBackendAPIModelsOutput) {
	op := &request.Operation{
		Name:       opGenerateBackendAPIModels,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/api/{backendEnvironmentName}/generateModels",
	}

	if input == nil {
		input = &GenerateBackendAPIModelsInput{}
	}

	output = &GenerateBackendAPIModelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GenerateBackendAPIModels API operation for AmplifyBackend.
//
// Generates a model schema for an existing backend API resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation GenerateBackendAPIModels for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GenerateBackendAPIModels
func (c *AmplifyBackend) GenerateBackendAPIModels(input *GenerateBackendAPIModelsInput) (*GenerateBackendAPIModelsOutput, error) {
	req, out := c.GenerateBackendAPIModelsRequest(input)
	return out, req.Send()
}

// GenerateBackendAPIModelsWithContext is the same as GenerateBackendAPIModels with the addition of
// the ability to pass a context and additional request options.
//
// See GenerateBackendAPIModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) GenerateBackendAPIModelsWithContext(ctx aws.Context, input *GenerateBackendAPIModelsInput, opts ...request.Option) (*GenerateBackendAPIModelsOutput, error) {
	req, out := c.GenerateBackendAPIModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBackend = "GetBackend"

// GetBackendRequest generates a "aws/request.Request" representing the
// client's request for the GetBackend operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBackend for more information on using the GetBackend
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBackendRequest method.
//    req, resp := client.GetBackendRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackend
func (c *AmplifyBackend) GetBackendRequest(input *GetBackendInput) (req *request.Request, output *GetBackendOutput) {
	op := &request.Operation{
		Name:       opGetBackend,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/details",
	}

	if input == nil {
		input = &GetBackendInput{}
	}

	output = &GetBackendOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBackend API operation for AmplifyBackend.
//
// Provides project-level details for your Amplify UI project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation GetBackend for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackend
func (c *AmplifyBackend) GetBackend(input *GetBackendInput) (*GetBackendOutput, error) {
	req, out := c.GetBackendRequest(input)
	return out, req.Send()
}

// GetBackendWithContext is the same as GetBackend with the addition of
// the ability to pass a context and additional request options.
//
// See GetBackend for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) GetBackendWithContext(ctx aws.Context, input *GetBackendInput, opts ...request.Option) (*GetBackendOutput, error) {
	req, out := c.GetBackendRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBackendAPI = "GetBackendAPI"

// GetBackendAPIRequest generates a "aws/request.Request" representing the
// client's request for the GetBackendAPI operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBackendAPI for more information on using the GetBackendAPI
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBackendAPIRequest method.
//    req, resp := client.GetBackendAPIRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendAPI
func (c *AmplifyBackend) GetBackendAPIRequest(input *GetBackendAPIInput) (req *request.Request, output *GetBackendAPIOutput) {
	op := &request.Operation{
		Name:       opGetBackendAPI,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/api/{backendEnvironmentName}/details",
	}

	if input == nil {
		input = &GetBackendAPIInput{}
	}

	output = &GetBackendAPIOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBackendAPI API operation for AmplifyBackend.
//
// Gets the details for a backend API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation GetBackendAPI for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendAPI
func (c *AmplifyBackend) GetBackendAPI(input *GetBackendAPIInput) (*GetBackendAPIOutput, error) {
	req, out := c.GetBackendAPIRequest(input)
	return out, req.Send()
}

// GetBackendAPIWithContext is the same as GetBackendAPI with the addition of
// the ability to pass a context and additional request options.
//
// See GetBackendAPI for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) GetBackendAPIWithContext(ctx aws.Context, input *GetBackendAPIInput, opts ...request.Option) (*GetBackendAPIOutput, error) {
	req, out := c.GetBackendAPIRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBackendAPIModels = "GetBackendAPIModels"

// GetBackendAPIModelsRequest generates a "aws/request.Request" representing the
// client's request for the GetBackendAPIModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBackendAPIModels for more information on using the GetBackendAPIModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBackendAPIModelsRequest method.
//    req, resp := client.GetBackendAPIModelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendAPIModels
func (c *AmplifyBackend) GetBackendAPIModelsRequest(input *GetBackendAPIModelsInput) (req *request.Request, output *GetBackendAPIModelsOutput) {
	op := &request.Operation{
		Name:       opGetBackendAPIModels,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/api/{backendEnvironmentName}/getModels",
	}

	if input == nil {
		input = &GetBackendAPIModelsInput{}
	}

	output = &GetBackendAPIModelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBackendAPIModels API operation for AmplifyBackend.
//
// Generates a model schema for existing backend API resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation GetBackendAPIModels for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendAPIModels
func (c *AmplifyBackend) GetBackendAPIModels(input *GetBackendAPIModelsInput) (*GetBackendAPIModelsOutput, error) {
	req, out := c.GetBackendAPIModelsRequest(input)
	return out, req.Send()
}

// GetBackendAPIModelsWithContext is the same as GetBackendAPIModels with the addition of
// the ability to pass a context and additional request options.
//
// See GetBackendAPIModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) GetBackendAPIModelsWithContext(ctx aws.Context, input *GetBackendAPIModelsInput, opts ...request.Option) (*GetBackendAPIModelsOutput, error) {
	req, out := c.GetBackendAPIModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBackendAuth = "GetBackendAuth"

// GetBackendAuthRequest generates a "aws/request.Request" representing the
// client's request for the GetBackendAuth operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBackendAuth for more information on using the GetBackendAuth
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBackendAuthRequest method.
//    req, resp := client.GetBackendAuthRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendAuth
func (c *AmplifyBackend) GetBackendAuthRequest(input *GetBackendAuthInput) (req *request.Request, output *GetBackendAuthOutput) {
	op := &request.Operation{
		Name:       opGetBackendAuth,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/auth/{backendEnvironmentName}/details",
	}

	if input == nil {
		input = &GetBackendAuthInput{}
	}

	output = &GetBackendAuthOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBackendAuth API operation for AmplifyBackend.
//
// Gets a backend auth details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation GetBackendAuth for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendAuth
func (c *AmplifyBackend) GetBackendAuth(input *GetBackendAuthInput) (*GetBackendAuthOutput, error) {
	req, out := c.GetBackendAuthRequest(input)
	return out, req.Send()
}

// GetBackendAuthWithContext is the same as GetBackendAuth with the addition of
// the ability to pass a context and additional request options.
//
// See GetBackendAuth for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) GetBackendAuthWithContext(ctx aws.Context, input *GetBackendAuthInput, opts ...request.Option) (*GetBackendAuthOutput, error) {
	req, out := c.GetBackendAuthRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBackendJob = "GetBackendJob"

// GetBackendJobRequest generates a "aws/request.Request" representing the
// client's request for the GetBackendJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBackendJob for more information on using the GetBackendJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBackendJobRequest method.
//    req, resp := client.GetBackendJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendJob
func (c *AmplifyBackend) GetBackendJobRequest(input *GetBackendJobInput) (req *request.Request, output *GetBackendJobOutput) {
	op := &request.Operation{
		Name:       opGetBackendJob,
		HTTPMethod: "GET",
		HTTPPath:   "/backend/{appId}/job/{backendEnvironmentName}/{jobId}",
	}

	if input == nil {
		input = &GetBackendJobInput{}
	}

	output = &GetBackendJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBackendJob API operation for AmplifyBackend.
//
// Returns information about a specific job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation GetBackendJob for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendJob
func (c *AmplifyBackend) GetBackendJob(input *GetBackendJobInput) (*GetBackendJobOutput, error) {
	req, out := c.GetBackendJobRequest(input)
	return out, req.Send()
}

// GetBackendJobWithContext is the same as GetBackendJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetBackendJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) GetBackendJobWithContext(ctx aws.Context, input *GetBackendJobInput, opts ...request.Option) (*GetBackendJobOutput, error) {
	req, out := c.GetBackendJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBackendStorage = "GetBackendStorage"

// GetBackendStorageRequest generates a "aws/request.Request" representing the
// client's request for the GetBackendStorage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBackendStorage for more information on using the GetBackendStorage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBackendStorageRequest method.
//    req, resp := client.GetBackendStorageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendStorage
func (c *AmplifyBackend) GetBackendStorageRequest(input *GetBackendStorageInput) (req *request.Request, output *GetBackendStorageOutput) {
	op := &request.Operation{
		Name:       opGetBackendStorage,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/storage/{backendEnvironmentName}/details",
	}

	if input == nil {
		input = &GetBackendStorageInput{}
	}

	output = &GetBackendStorageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBackendStorage API operation for AmplifyBackend.
//
// Gets details for a backend storage resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation GetBackendStorage for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendStorage
func (c *AmplifyBackend) GetBackendStorage(input *GetBackendStorageInput) (*GetBackendStorageOutput, error) {
	req, out := c.GetBackendStorageRequest(input)
	return out, req.Send()
}

// GetBackendStorageWithContext is the same as GetBackendStorage with the addition of
// the ability to pass a context and additional request options.
//
// See GetBackendStorage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) GetBackendStorageWithContext(ctx aws.Context, input *GetBackendStorageInput, opts ...request.Option) (*GetBackendStorageOutput, error) {
	req, out := c.GetBackendStorageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetToken = "GetToken"

// GetTokenRequest generates a "aws/request.Request" representing the
// client's request for the GetToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetToken for more information on using the GetToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTokenRequest method.
//    req, resp := client.GetTokenRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetToken
func (c *AmplifyBackend) GetTokenRequest(input *GetTokenInput) (req *request.Request, output *GetTokenOutput) {
	op := &request.Operation{
		Name:       opGetToken,
		HTTPMethod: "GET",
		HTTPPath:   "/backend/{appId}/challenge/{sessionId}",
	}

	if input == nil {
		input = &GetTokenInput{}
	}

	output = &GetTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetToken API operation for AmplifyBackend.
//
// Gets the challenge token based on the given appId and sessionId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation GetToken for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetToken
func (c *AmplifyBackend) GetToken(input *GetTokenInput) (*GetTokenOutput, error) {
	req, out := c.GetTokenRequest(input)
	return out, req.Send()
}

// GetTokenWithContext is the same as GetToken with the addition of
// the ability to pass a context and additional request options.
//
// See GetToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) GetTokenWithContext(ctx aws.Context, input *GetTokenInput, opts ...request.Option) (*GetTokenOutput, error) {
	req, out := c.GetTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportBackendAuth = "ImportBackendAuth"

// ImportBackendAuthRequest generates a "aws/request.Request" representing the
// client's request for the ImportBackendAuth operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportBackendAuth for more information on using the ImportBackendAuth
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportBackendAuthRequest method.
//    req, resp := client.ImportBackendAuthRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/ImportBackendAuth
func (c *AmplifyBackend) ImportBackendAuthRequest(input *ImportBackendAuthInput) (req *request.Request, output *ImportBackendAuthOutput) {
	op := &request.Operation{
		Name:       opImportBackendAuth,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/auth/{backendEnvironmentName}/import",
	}

	if input == nil {
		input = &ImportBackendAuthInput{}
	}

	output = &ImportBackendAuthOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportBackendAuth API operation for AmplifyBackend.
//
// Imports an existing backend authentication resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation ImportBackendAuth for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/ImportBackendAuth
func (c *AmplifyBackend) ImportBackendAuth(input *ImportBackendAuthInput) (*ImportBackendAuthOutput, error) {
	req, out := c.ImportBackendAuthRequest(input)
	return out, req.Send()
}

// ImportBackendAuthWithContext is the same as ImportBackendAuth with the addition of
// the ability to pass a context and additional request options.
//
// See ImportBackendAuth for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) ImportBackendAuthWithContext(ctx aws.Context, input *ImportBackendAuthInput, opts ...request.Option) (*ImportBackendAuthOutput, error) {
	req, out := c.ImportBackendAuthRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportBackendStorage = "ImportBackendStorage"

// ImportBackendStorageRequest generates a "aws/request.Request" representing the
// client's request for the ImportBackendStorage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportBackendStorage for more information on using the ImportBackendStorage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportBackendStorageRequest method.
//    req, resp := client.ImportBackendStorageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/ImportBackendStorage
func (c *AmplifyBackend) ImportBackendStorageRequest(input *ImportBackendStorageInput) (req *request.Request, output *ImportBackendStorageOutput) {
	op := &request.Operation{
		Name:       opImportBackendStorage,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/storage/{backendEnvironmentName}/import",
	}

	if input == nil {
		input = &ImportBackendStorageInput{}
	}

	output = &ImportBackendStorageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportBackendStorage API operation for AmplifyBackend.
//
// Imports an existing backend storage resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation ImportBackendStorage for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/ImportBackendStorage
func (c *AmplifyBackend) ImportBackendStorage(input *ImportBackendStorageInput) (*ImportBackendStorageOutput, error) {
	req, out := c.ImportBackendStorageRequest(input)
	return out, req.Send()
}

// ImportBackendStorageWithContext is the same as ImportBackendStorage with the addition of
// the ability to pass a context and additional request options.
//
// See ImportBackendStorage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) ImportBackendStorageWithContext(ctx aws.Context, input *ImportBackendStorageInput, opts ...request.Option) (*ImportBackendStorageOutput, error) {
	req, out := c.ImportBackendStorageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBackendJobs = "ListBackendJobs"

// ListBackendJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListBackendJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBackendJobs for more information on using the ListBackendJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListBackendJobsRequest method.
//    req, resp := client.ListBackendJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/ListBackendJobs
func (c *AmplifyBackend) ListBackendJobsRequest(input *ListBackendJobsInput) (req *request.Request, output *ListBackendJobsOutput) {
	op := &request.Operation{
		Name:       opListBackendJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/job/{backendEnvironmentName}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBackendJobsInput{}
	}

	output = &ListBackendJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBackendJobs API operation for AmplifyBackend.
//
// Lists the jobs for the backend of an Amplify app.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation ListBackendJobs for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/ListBackendJobs
func (c *AmplifyBackend) ListBackendJobs(input *ListBackendJobsInput) (*ListBackendJobsOutput, error) {
	req, out := c.ListBackendJobsRequest(input)
	return out, req.Send()
}

// ListBackendJobsWithContext is the same as ListBackendJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListBackendJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) ListBackendJobsWithContext(ctx aws.Context, input *ListBackendJobsInput, opts ...request.Option) (*ListBackendJobsOutput, error) {
	req, out := c.ListBackendJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBackendJobsPages iterates over the pages of a ListBackendJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBackendJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListBackendJobs operation.
//    pageNum := 0
//    err := client.ListBackendJobsPages(params,
//        func(page *amplifybackend.ListBackendJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AmplifyBackend) ListBackendJobsPages(input *ListBackendJobsInput, fn func(*ListBackendJobsOutput, bool) bool) error {
	return c.ListBackendJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBackendJobsPagesWithContext same as ListBackendJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) ListBackendJobsPagesWithContext(ctx aws.Context, input *ListBackendJobsInput, fn func(*ListBackendJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBackendJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBackendJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBackendJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListS3Buckets = "ListS3Buckets"

// ListS3BucketsRequest generates a "aws/request.Request" representing the
// client's request for the ListS3Buckets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListS3Buckets for more information on using the ListS3Buckets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListS3BucketsRequest method.
//    req, resp := client.ListS3BucketsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/ListS3Buckets
func (c *AmplifyBackend) ListS3BucketsRequest(input *ListS3BucketsInput) (req *request.Request, output *ListS3BucketsOutput) {
	op := &request.Operation{
		Name:       opListS3Buckets,
		HTTPMethod: "POST",
		HTTPPath:   "/s3Buckets",
	}

	if input == nil {
		input = &ListS3BucketsInput{}
	}

	output = &ListS3BucketsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListS3Buckets API operation for AmplifyBackend.
//
// The list of S3 buckets in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation ListS3Buckets for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/ListS3Buckets
func (c *AmplifyBackend) ListS3Buckets(input *ListS3BucketsInput) (*ListS3BucketsOutput, error) {
	req, out := c.ListS3BucketsRequest(input)
	return out, req.Send()
}

// ListS3BucketsWithContext is the same as ListS3Buckets with the addition of
// the ability to pass a context and additional request options.
//
// See ListS3Buckets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) ListS3BucketsWithContext(ctx aws.Context, input *ListS3BucketsInput, opts ...request.Option) (*ListS3BucketsOutput, error) {
	req, out := c.ListS3BucketsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveAllBackends = "RemoveAllBackends"

// RemoveAllBackendsRequest generates a "aws/request.Request" representing the
// client's request for the RemoveAllBackends operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveAllBackends for more information on using the RemoveAllBackends
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveAllBackendsRequest method.
//    req, resp := client.RemoveAllBackendsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/RemoveAllBackends
func (c *AmplifyBackend) RemoveAllBackendsRequest(input *RemoveAllBackendsInput) (req *request.Request, output *RemoveAllBackendsOutput) {
	op := &request.Operation{
		Name:       opRemoveAllBackends,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/remove",
	}

	if input == nil {
		input = &RemoveAllBackendsInput{}
	}

	output = &RemoveAllBackendsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveAllBackends API operation for AmplifyBackend.
//
// Removes all backend environments from your Amplify project.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation RemoveAllBackends for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/RemoveAllBackends
func (c *AmplifyBackend) RemoveAllBackends(input *RemoveAllBackendsInput) (*RemoveAllBackendsOutput, error) {
	req, out := c.RemoveAllBackendsRequest(input)
	return out, req.Send()
}

// RemoveAllBackendsWithContext is the same as RemoveAllBackends with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveAllBackends for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) RemoveAllBackendsWithContext(ctx aws.Context, input *RemoveAllBackendsInput, opts ...request.Option) (*RemoveAllBackendsOutput, error) {
	req, out := c.RemoveAllBackendsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveBackendConfig = "RemoveBackendConfig"

// RemoveBackendConfigRequest generates a "aws/request.Request" representing the
// client's request for the RemoveBackendConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveBackendConfig for more information on using the RemoveBackendConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveBackendConfigRequest method.
//    req, resp := client.RemoveBackendConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/RemoveBackendConfig
func (c *AmplifyBackend) RemoveBackendConfigRequest(input *RemoveBackendConfigInput) (req *request.Request, output *RemoveBackendConfigOutput) {
	op := &request.Operation{
		Name:       opRemoveBackendConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/config/remove",
	}

	if input == nil {
		input = &RemoveBackendConfigInput{}
	}

	output = &RemoveBackendConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveBackendConfig API operation for AmplifyBackend.
//
// Removes the AWS resources required to access the Amplify Admin UI.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation RemoveBackendConfig for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/RemoveBackendConfig
func (c *AmplifyBackend) RemoveBackendConfig(input *RemoveBackendConfigInput) (*RemoveBackendConfigOutput, error) {
	req, out := c.RemoveBackendConfigRequest(input)
	return out, req.Send()
}

// RemoveBackendConfigWithContext is the same as RemoveBackendConfig with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveBackendConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) RemoveBackendConfigWithContext(ctx aws.Context, input *RemoveBackendConfigInput, opts ...request.Option) (*RemoveBackendConfigOutput, error) {
	req, out := c.RemoveBackendConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBackendAPI = "UpdateBackendAPI"

// UpdateBackendAPIRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBackendAPI operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBackendAPI for more information on using the UpdateBackendAPI
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateBackendAPIRequest method.
//    req, resp := client.UpdateBackendAPIRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendAPI
func (c *AmplifyBackend) UpdateBackendAPIRequest(input *UpdateBackendAPIInput) (req *request.Request, output *UpdateBackendAPIOutput) {
	op := &request.Operation{
		Name:       opUpdateBackendAPI,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/api/{backendEnvironmentName}",
	}

	if input == nil {
		input = &UpdateBackendAPIInput{}
	}

	output = &UpdateBackendAPIOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBackendAPI API operation for AmplifyBackend.
//
// Updates an existing backend API resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation UpdateBackendAPI for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendAPI
func (c *AmplifyBackend) UpdateBackendAPI(input *UpdateBackendAPIInput) (*UpdateBackendAPIOutput, error) {
	req, out := c.UpdateBackendAPIRequest(input)
	return out, req.Send()
}

// UpdateBackendAPIWithContext is the same as UpdateBackendAPI with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBackendAPI for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) UpdateBackendAPIWithContext(ctx aws.Context, input *UpdateBackendAPIInput, opts ...request.Option) (*UpdateBackendAPIOutput, error) {
	req, out := c.UpdateBackendAPIRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBackendAuth = "UpdateBackendAuth"

// UpdateBackendAuthRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBackendAuth operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBackendAuth for more information on using the UpdateBackendAuth
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateBackendAuthRequest method.
//    req, resp := client.UpdateBackendAuthRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendAuth
func (c *AmplifyBackend) UpdateBackendAuthRequest(input *UpdateBackendAuthInput) (req *request.Request, output *UpdateBackendAuthOutput) {
	op := &request.Operation{
		Name:       opUpdateBackendAuth,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/auth/{backendEnvironmentName}",
	}

	if input == nil {
		input = &UpdateBackendAuthInput{}
	}

	output = &UpdateBackendAuthOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBackendAuth API operation for AmplifyBackend.
//
// Updates an existing backend authentication resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation UpdateBackendAuth for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendAuth
func (c *AmplifyBackend) UpdateBackendAuth(input *UpdateBackendAuthInput) (*UpdateBackendAuthOutput, error) {
	req, out := c.UpdateBackendAuthRequest(input)
	return out, req.Send()
}

// UpdateBackendAuthWithContext is the same as UpdateBackendAuth with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBackendAuth for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) UpdateBackendAuthWithContext(ctx aws.Context, input *UpdateBackendAuthInput, opts ...request.Option) (*UpdateBackendAuthOutput, error) {
	req, out := c.UpdateBackendAuthRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBackendConfig = "UpdateBackendConfig"

// UpdateBackendConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBackendConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBackendConfig for more information on using the UpdateBackendConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateBackendConfigRequest method.
//    req, resp := client.UpdateBackendConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendConfig
func (c *AmplifyBackend) UpdateBackendConfigRequest(input *UpdateBackendConfigInput) (req *request.Request, output *UpdateBackendConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateBackendConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/config/update",
	}

	if input == nil {
		input = &UpdateBackendConfigInput{}
	}

	output = &UpdateBackendConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBackendConfig API operation for AmplifyBackend.
//
// Updates the AWS resources required to access the Amplify Admin UI.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation UpdateBackendConfig for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendConfig
func (c *AmplifyBackend) UpdateBackendConfig(input *UpdateBackendConfigInput) (*UpdateBackendConfigOutput, error) {
	req, out := c.UpdateBackendConfigRequest(input)
	return out, req.Send()
}

// UpdateBackendConfigWithContext is the same as UpdateBackendConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBackendConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) UpdateBackendConfigWithContext(ctx aws.Context, input *UpdateBackendConfigInput, opts ...request.Option) (*UpdateBackendConfigOutput, error) {
	req, out := c.UpdateBackendConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBackendJob = "UpdateBackendJob"

// UpdateBackendJobRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBackendJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBackendJob for more information on using the UpdateBackendJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateBackendJobRequest method.
//    req, resp := client.UpdateBackendJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendJob
func (c *AmplifyBackend) UpdateBackendJobRequest(input *UpdateBackendJobInput) (req *request.Request, output *UpdateBackendJobOutput) {
	op := &request.Operation{
		Name:       opUpdateBackendJob,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/job/{backendEnvironmentName}/{jobId}",
	}

	if input == nil {
		input = &UpdateBackendJobInput{}
	}

	output = &UpdateBackendJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBackendJob API operation for AmplifyBackend.
//
// Updates a specific job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation UpdateBackendJob for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendJob
func (c *AmplifyBackend) UpdateBackendJob(input *UpdateBackendJobInput) (*UpdateBackendJobOutput, error) {
	req, out := c.UpdateBackendJobRequest(input)
	return out, req.Send()
}

// UpdateBackendJobWithContext is the same as UpdateBackendJob with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBackendJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) UpdateBackendJobWithContext(ctx aws.Context, input *UpdateBackendJobInput, opts ...request.Option) (*UpdateBackendJobOutput, error) {
	req, out := c.UpdateBackendJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBackendStorage = "UpdateBackendStorage"

// UpdateBackendStorageRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBackendStorage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBackendStorage for more information on using the UpdateBackendStorage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateBackendStorageRequest method.
//    req, resp := client.UpdateBackendStorageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendStorage
func (c *AmplifyBackend) UpdateBackendStorageRequest(input *UpdateBackendStorageInput) (req *request.Request, output *UpdateBackendStorageOutput) {
	op := &request.Operation{
		Name:       opUpdateBackendStorage,
		HTTPMethod: "POST",
		HTTPPath:   "/backend/{appId}/storage/{backendEnvironmentName}",
	}

	if input == nil {
		input = &UpdateBackendStorageInput{}
	}

	output = &UpdateBackendStorageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBackendStorage API operation for AmplifyBackend.
//
// Updates an existing backend storage resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AmplifyBackend's
// API operation UpdateBackendStorage for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   An error returned when a specific resource type is not found.
//
//   * GatewayTimeoutException
//   An error returned if there's a temporary issue with the service.
//
//   * TooManyRequestsException
//   An error that is returned when a limit of a specific type has been exceeded.
//
//   * BadRequestException
//   An error returned if a request is not formed properly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendStorage
func (c *AmplifyBackend) UpdateBackendStorage(input *UpdateBackendStorageInput) (*UpdateBackendStorageOutput, error) {
	req, out := c.UpdateBackendStorageRequest(input)
	return out, req.Send()
}

// UpdateBackendStorageWithContext is the same as UpdateBackendStorage with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBackendStorage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AmplifyBackend) UpdateBackendStorageWithContext(ctx aws.Context, input *UpdateBackendStorageInput, opts ...request.Option) (*UpdateBackendStorageOutput, error) {
	req, out := c.UpdateBackendStorageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The authentication settings for accessing provisioned data models in your
// Amplify project.
type BackendAPIAppSyncAuthSettings struct {
	_ struct{} `type:"structure"`

	// The Amazon Cognito user pool ID, if Amazon Cognito was used as an authentication
	// setting to access your data models.
	CognitoUserPoolId *string `locationName:"cognitoUserPoolId" type:"string"`

	// The API key description for API_KEY, if it was used as an authentication
	// mechanism to access your data models.
	Description *string `locationName:"description" type:"string"`

	// The API key expiration time for API_KEY, if it was used as an authentication
	// mechanism to access your data models.
	ExpirationTime *float64 `locationName:"expirationTime" type:"double"`

	// The expiry time for the OpenID authentication mechanism.
	OpenIDAuthTTL *string `locationName:"openIDAuthTTL" type:"string"`

	// The clientID for openID, if openID was used as an authentication setting
	// to access your data models.
	OpenIDClientId *string `locationName:"openIDClientId" type:"string"`

	// The expiry time for the OpenID authentication mechanism.
	OpenIDIatTTL *string `locationName:"openIDIatTTL" type:"string"`

	// The openID issuer URL, if openID was used as an authentication setting to
	// access your data models.
	OpenIDIssueURL *string `locationName:"openIDIssueURL" type:"string"`

	// The OpenID provider name, if OpenID was used as an authentication mechanism
	// to access your data models.
	OpenIDProviderName *string `locationName:"openIDProviderName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackendAPIAppSyncAuthSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackendAPIAppSyncAuthSettings) GoString() string {
	return s.String()
}

// SetCognitoUserPoolId sets the CognitoUserPoolId field's value.
func (s *BackendAPIAppSyncAuthSettings) SetCognitoUserPoolId(v string) *BackendAPIAppSyncAuthSettings {
	s.CognitoUserPoolId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *BackendAPIAppSyncAuthSettings) SetDescription(v string) *BackendAPIAppSyncAuthSettings {
	s.Description = &v
	return s
}

// SetExpirationTime sets the ExpirationTime field's value.
func (s *BackendAPIAppSyncAuthSettings) SetExpirationTime(v float64) *BackendAPIAppSyncAuthSettings {
	s.ExpirationTime = &v
	return s
}

// SetOpenIDAuthTTL sets the OpenIDAuthTTL field's value.
func (s *BackendAPIAppSyncAuthSettings) SetOpenIDAuthTTL(v string) *BackendAPIAppSyncAuthSettings {
	s.OpenIDAuthTTL = &v
	return s
}

// SetOpenIDClientId sets the OpenIDClientId field's value.
func (s *BackendAPIAppSyncAuthSettings) SetOpenIDClientId(v string) *BackendAPIAppSyncAuthSettings {
	s.OpenIDClientId = &v
	return s
}

// SetOpenIDIatTTL sets the OpenIDIatTTL field's value.
func (s *BackendAPIAppSyncAuthSettings) SetOpenIDIatTTL(v string) *BackendAPIAppSyncAuthSettings {
	s.OpenIDIatTTL = &v
	return s
}

// SetOpenIDIssueURL sets the OpenIDIssueURL field's value.
func (s *BackendAPIAppSyncAuthSettings) SetOpenIDIssueURL(v string) *BackendAPIAppSyncAuthSettings {
	s.OpenIDIssueURL = &v
	return s
}

// SetOpenIDProviderName sets the OpenIDProviderName field's value.
func (s *BackendAPIAppSyncAuthSettings) SetOpenIDProviderName(v string) *BackendAPIAppSyncAuthSettings {
	s.OpenIDProviderName = &v
	return s
}

// Describes the auth types for your configured data models.
type BackendAPIAuthType struct {
	_ struct{} `type:"structure"`

	// Describes the authentication mode.
	Mode *string `locationName:"mode" type:"string" enum:"Mode"`

	// Describes settings for the authentication mode.
	Settings *BackendAPIAppSyncAuthSettings `locationName:"settings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackendAPIAuthType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackendAPIAuthType) GoString() string {
	return s.String()
}

// SetMode sets the Mode field's value.
func (s *BackendAPIAuthType) SetMode(v string) *BackendAPIAuthType {
	s.Mode = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *BackendAPIAuthType) SetSettings(v *BackendAPIAppSyncAuthSettings) *BackendAPIAuthType {
	s.Settings = v
	return s
}

// Describes the conflict resolution configuration for your data model configured
// in your Amplify project.
type BackendAPIConflictResolution struct {
	_ struct{} `type:"structure"`

	// The strategy for conflict resolution.
	ResolutionStrategy *string `locationName:"resolutionStrategy" type:"string" enum:"ResolutionStrategy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackendAPIConflictResolution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackendAPIConflictResolution) GoString() string {
	return s.String()
}

// SetResolutionStrategy sets the ResolutionStrategy field's value.
func (s *BackendAPIConflictResolution) SetResolutionStrategy(v string) *BackendAPIConflictResolution {
	s.ResolutionStrategy = &v
	return s
}

// The resource config for the data model, configured as a part of the Amplify
// project.
type BackendAPIResourceConfig struct {
	_ struct{} `type:"structure"`

	// Additional authentication methods used to interact with your data models.
	AdditionalAuthTypes []*BackendAPIAuthType `locationName:"additionalAuthTypes" type:"list"`

	// The API name used to interact with the data model, configured as a part of
	// your Amplify project.
	ApiName *string `locationName:"apiName" type:"string"`

	// The conflict resolution strategy for your data stored in the data models.
	ConflictResolution *BackendAPIConflictResolution `locationName:"conflictResolution" type:"structure"`

	// The default authentication type for interacting with the configured data
	// models in your Amplify project.
	DefaultAuthType *BackendAPIAuthType `locationName:"defaultAuthType" type:"structure"`

	// The service used to provision and interact with the data model.
	Service *string `locationName:"service" type:"string"`

	// The definition of the data model in the annotated transform of the GraphQL
	// schema.
	TransformSchema *string `locationName:"transformSchema" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackendAPIResourceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackendAPIResourceConfig) GoString() string {
	return s.String()
}

// SetAdditionalAuthTypes sets the AdditionalAuthTypes field's value.
func (s *BackendAPIResourceConfig) SetAdditionalAuthTypes(v []*BackendAPIAuthType) *BackendAPIResourceConfig {
	s.AdditionalAuthTypes = v
	return s
}

// SetApiName sets the ApiName field's value.
func (s *BackendAPIResourceConfig) SetApiName(v string) *BackendAPIResourceConfig {
	s.ApiName = &v
	return s
}

// SetConflictResolution sets the ConflictResolution field's value.
func (s *BackendAPIResourceConfig) SetConflictResolution(v *BackendAPIConflictResolution) *BackendAPIResourceConfig {
	s.ConflictResolution = v
	return s
}

// SetDefaultAuthType sets the DefaultAuthType field's value.
func (s *BackendAPIResourceConfig) SetDefaultAuthType(v *BackendAPIAuthType) *BackendAPIResourceConfig {
	s.DefaultAuthType = v
	return s
}

// SetService sets the Service field's value.
func (s *BackendAPIResourceConfig) SetService(v string) *BackendAPIResourceConfig {
	s.Service = &v
	return s
}

// SetTransformSchema sets the TransformSchema field's value.
func (s *BackendAPIResourceConfig) SetTransformSchema(v string) *BackendAPIResourceConfig {
	s.TransformSchema = &v
	return s
}

// Describes Apple social federation configurations for allowing your app users
// to sign in using OAuth.
type BackendAuthAppleProviderConfig struct {
	_ struct{} `type:"structure"`

	// Describes the client_id (also called Services ID) that comes from Apple.
	ClientId *string `locationName:"client_id" type:"string"`

	// Describes the key_id that comes from Apple.
	KeyId *string `locationName:"key_id" type:"string"`

	// Describes the private_key that comes from Apple.
	PrivateKey *string `locationName:"private_key" type:"string"`

	// Describes the team_id that comes from Apple.
	TeamId *string `locationName:"team_id" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackendAuthAppleProviderConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackendAuthAppleProviderConfig) GoString() string {
	return s.String()
}

// SetClientId sets the ClientId field's value.
func (s *BackendAuthAppleProviderConfig) SetClientId(v string) *BackendAuthAppleProviderConfig {
	s.ClientId = &v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *BackendAuthAppleProviderConfig) SetKeyId(v string) *BackendAuthAppleProviderConfig {
	s.KeyId = &v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *BackendAuthAppleProviderConfig) SetPrivateKey(v string) *BackendAuthAppleProviderConfig {
	s.PrivateKey = &v
	return s
}

// SetTeamId sets the TeamId field's value.
func (s *BackendAuthAppleProviderConfig) SetTeamId(v string) *BackendAuthAppleProviderConfig {
	s.TeamId = &v
	return s
}

// Describes third-party social federation configurations for allowing your
// app users to sign in using OAuth.
type BackendAuthSocialProviderConfig struct {
	_ struct{} `type:"structure"`

	// Describes the client_id, which can be obtained from the third-party social
	// federation provider.
	ClientId *string `locationName:"client_id" type:"string"`

	// Describes the client_secret, which can be obtained from third-party social
	// federation providers.
	ClientSecret *string `locationName:"client_secret" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackendAuthSocialProviderConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackendAuthSocialProviderConfig) GoString() string {
	return s.String()
}

// SetClientId sets the ClientId field's value.
func (s *BackendAuthSocialProviderConfig) SetClientId(v string) *BackendAuthSocialProviderConfig {
	s.ClientId = &v
	return s
}

// SetClientSecret sets the ClientSecret field's value.
func (s *BackendAuthSocialProviderConfig) SetClientSecret(v string) *BackendAuthSocialProviderConfig {
	s.ClientSecret = &v
	return s
}

// The response object for this operation.
type BackendJobRespObj struct {
	_ struct{} `type:"structure"`

	// The app ID.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`

	// The name of the backend environment.
	//
	// BackendEnvironmentName is a required field
	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string" required:"true"`

	// The time when the job was created.
	CreateTime *string `locationName:"createTime" type:"string"`

	// If the request fails, this error is returned.
	Error *string `locationName:"error" type:"string"`

	// The ID for the job.
	JobId *string `locationName:"jobId" type:"string"`

	// The name of the operation.
	Operation *string `locationName:"operation" type:"string"`

	// The current status of the request.
	Status *string `locationName:"status" type:"string"`

	// The time when the job was last updated.
	UpdateTime *string `locationName:"updateTime" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackendJobRespObj) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackendJobRespObj) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *BackendJobRespObj) SetAppId(v string) *BackendJobRespObj {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *BackendJobRespObj) SetBackendEnvironmentName(v string) *BackendJobRespObj {
	s.BackendEnvironmentName = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *BackendJobRespObj) SetCreateTime(v string) *BackendJobRespObj {
	s.CreateTime = &v
	return s
}

// SetError sets the Error field's value.
func (s *BackendJobRespObj) SetError(v string) *BackendJobRespObj {
	s.Error = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *BackendJobRespObj) SetJobId(v string) *BackendJobRespObj {
	s.JobId = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *BackendJobRespObj) SetOperation(v string) *BackendJobRespObj {
	s.Operation = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *BackendJobRespObj) SetStatus(v string) *BackendJobRespObj {
	s.Status = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *BackendJobRespObj) SetUpdateTime(v string) *BackendJobRespObj {
	s.UpdateTime = &v
	return s
}

// Describes the read, write, and delete permissions users have against your
// storage S3 bucket.
type BackendStoragePermissions struct {
	_ struct{} `type:"structure"`

	// Lists all authenticated user read, write, and delete permissions for your
	// S3 bucket.
	//
	// Authenticated is a required field
	Authenticated []*string `locationName:"authenticated" type:"list" required:"true" enum:"AuthenticatedElement"`

	// Lists all unauthenticated user read, write, and delete permissions for your
	// S3 bucket.
	UnAuthenticated []*string `locationName:"unAuthenticated" type:"list" enum:"UnAuthenticatedElement"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackendStoragePermissions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackendStoragePermissions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BackendStoragePermissions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BackendStoragePermissions"}
	if s.Authenticated == nil {
		invalidParams.Add(request.NewErrParamRequired("Authenticated"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticated sets the Authenticated field's value.
func (s *BackendStoragePermissions) SetAuthenticated(v []*string) *BackendStoragePermissions {
	s.Authenticated = v
	return s
}

// SetUnAuthenticated sets the UnAuthenticated field's value.
func (s *BackendStoragePermissions) SetUnAuthenticated(v []*string) *BackendStoragePermissions {
	s.UnAuthenticated = v
	return s
}

// An error returned if a request is not formed properly.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// An error message to inform that the request failed.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CloneBackendInput struct {
	_ struct{} `type:"structure"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// BackendEnvironmentName is a required field
	BackendEnvironmentName *string `location:"uri" locationName:"backendEnvironmentName" type:"string" required:"true"`

	// TargetEnvironmentName is a required field
	TargetEnvironmentName *string `locationName:"targetEnvironmentName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloneBackendInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloneBackendInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloneBackendInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloneBackendInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BackendEnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackendEnvironmentName"))
	}
	if s.BackendEnvironmentName != nil && len(*s.BackendEnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackendEnvironmentName", 1))
	}
	if s.TargetEnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetEnvironmentName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *CloneBackendInput) SetAppId(v string) *CloneBackendInput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *CloneBackendInput) SetBackendEnvironmentName(v string) *CloneBackendInput {
	s.BackendEnvironmentName = &v
	return s
}

// SetTargetEnvironmentName sets the TargetEnvironmentName field's value.
func (s *CloneBackendInput) SetTargetEnvironmentName(v string) *CloneBackendInput {
	s.TargetEnvironmentName = &v
	return s
}

type CloneBackendOutput struct {
	_ struct{} `type:"structure"`

	AppId *string `locationName:"appId" type:"string"`

	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string"`

	Error *string `locationName:"error" type:"string"`

	JobId *string `locationName:"jobId" type:"string"`

	Operation *string `locationName:"operation" type:"string"`

	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloneBackendOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloneBackendOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *CloneBackendOutput) SetAppId(v string) *CloneBackendOutput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *CloneBackendOutput) SetBackendEnvironmentName(v string) *CloneBackendOutput {
	s.BackendEnvironmentName = &v
	return s
}

// SetError sets the Error field's value.
func (s *CloneBackendOutput) SetError(v string) *CloneBackendOutput {
	s.Error = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *CloneBackendOutput) SetJobId(v string) *CloneBackendOutput {
	s.JobId = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *CloneBackendOutput) SetOperation(v string) *CloneBackendOutput {
	s.Operation = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CloneBackendOutput) SetStatus(v string) *CloneBackendOutput {
	s.Status = &v
	return s
}

type CreateBackendAPIInput struct {
	_ struct{} `type:"structure"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// BackendEnvironmentName is a required field
	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string" required:"true"`

	// The resource config for the data model, configured as a part of the Amplify
	// project.
	//
	// ResourceConfig is a required field
	ResourceConfig *BackendAPIResourceConfig `locationName:"resourceConfig" type:"structure" required:"true"`

	// ResourceName is a required field
	ResourceName *string `locationName:"resourceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendAPIInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendAPIInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBackendAPIInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBackendAPIInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BackendEnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackendEnvironmentName"))
	}
	if s.ResourceConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceConfig"))
	}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *CreateBackendAPIInput) SetAppId(v string) *CreateBackendAPIInput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *CreateBackendAPIInput) SetBackendEnvironmentName(v string) *CreateBackendAPIInput {
	s.BackendEnvironmentName = &v
	return s
}

// SetResourceConfig sets the ResourceConfig field's value.
func (s *CreateBackendAPIInput) SetResourceConfig(v *BackendAPIResourceConfig) *CreateBackendAPIInput {
	s.ResourceConfig = v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *CreateBackendAPIInput) SetResourceName(v string) *CreateBackendAPIInput {
	s.ResourceName = &v
	return s
}

type CreateBackendAPIOutput struct {
	_ struct{} `type:"structure"`

	AppId *string `locationName:"appId" type:"string"`

	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string"`

	Error *string `locationName:"error" type:"string"`

	JobId *string `locationName:"jobId" type:"string"`

	Operation *string `locationName:"operation" type:"string"`

	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendAPIOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendAPIOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *CreateBackendAPIOutput) SetAppId(v string) *CreateBackendAPIOutput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *CreateBackendAPIOutput) SetBackendEnvironmentName(v string) *CreateBackendAPIOutput {
	s.BackendEnvironmentName = &v
	return s
}

// SetError sets the Error field's value.
func (s *CreateBackendAPIOutput) SetError(v string) *CreateBackendAPIOutput {
	s.Error = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *CreateBackendAPIOutput) SetJobId(v string) *CreateBackendAPIOutput {
	s.JobId = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *CreateBackendAPIOutput) SetOperation(v string) *CreateBackendAPIOutput {
	s.Operation = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateBackendAPIOutput) SetStatus(v string) *CreateBackendAPIOutput {
	s.Status = &v
	return s
}

// (DEPRECATED) Describes the forgot password policy for authenticating into
// the Amplify app.
type CreateBackendAuthForgotPasswordConfig struct {
	_ struct{} `type:"structure"`

	// (DEPRECATED) Describes which mode to use (either SMS or email) to deliver
	// messages to app users who want to recover their password.
	//
	// DeliveryMethod is a required field
	DeliveryMethod *string `locationName:"deliveryMethod" type:"string" required:"true" enum:"DeliveryMethod"`

	// (DEPRECATED) The configuration for the email sent when an app user forgets
	// their password.
	EmailSettings *EmailSettings `locationName:"emailSettings" type:"structure"`

	// (DEPRECATED) The configuration for the SMS message sent when an app user
	// forgets their password.
	SmsSettings *SmsSettings `locationName:"smsSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendAuthForgotPasswordConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendAuthForgotPasswordConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBackendAuthForgotPasswordConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBackendAuthForgotPasswordConfig"}
	if s.DeliveryMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryMethod"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryMethod sets the DeliveryMethod field's value.
func (s *CreateBackendAuthForgotPasswordConfig) SetDeliveryMethod(v string) *CreateBackendAuthForgotPasswordConfig {
	s.DeliveryMethod = &v
	return s
}

// SetEmailSettings sets the EmailSettings field's value.
func (s *CreateBackendAuthForgotPasswordConfig) SetEmailSettings(v *EmailSettings) *CreateBackendAuthForgotPasswordConfig {
	s.EmailSettings = v
	return s
}

// SetSmsSettings sets the SmsSettings field's value.
func (s *CreateBackendAuthForgotPasswordConfig) SetSmsSettings(v *SmsSettings) *CreateBackendAuthForgotPasswordConfig {
	s.SmsSettings = v
	return s
}

// Describes authorization configurations for the auth resources, configured
// as a part of your Amplify project.
type CreateBackendAuthIdentityPoolConfig struct {
	_ struct{} `type:"structure"`

	// Name of the Amazon Cognito identity pool used for authorization.
	//
	// IdentityPoolName is a required field
	IdentityPoolName *string `locationName:"identityPoolName" type:"string" required:"true"`

	// Set to true or false based on whether you want to enable guest authorization
	// to your Amplify app.
	//
	// UnauthenticatedLogin is a required field
	UnauthenticatedLogin *bool `locationName:"unauthenticatedLogin" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendAuthIdentityPoolConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendAuthIdentityPoolConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBackendAuthIdentityPoolConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBackendAuthIdentityPoolConfig"}
	if s.IdentityPoolName == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolName"))
	}
	if s.UnauthenticatedLogin == nil {
		invalidParams.Add(request.NewErrParamRequired("UnauthenticatedLogin"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentityPoolName sets the IdentityPoolName field's value.
func (s *CreateBackendAuthIdentityPoolConfig) SetIdentityPoolName(v string) *CreateBackendAuthIdentityPoolConfig {
	s.IdentityPoolName = &v
	return s
}

// SetUnauthenticatedLogin sets the UnauthenticatedLogin field's value.
func (s *CreateBackendAuthIdentityPoolConfig) SetUnauthenticatedLogin(v bool) *CreateBackendAuthIdentityPoolConfig {
	s.UnauthenticatedLogin = &v
	return s
}

type CreateBackendAuthInput struct {
	_ struct{} `type:"structure"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// BackendEnvironmentName is a required field
	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string" required:"true"`

	// Defines the resource configuration when creating an auth resource in your
	// Amplify project.
	//
	// ResourceConfig is a required field
	ResourceConfig *CreateBackendAuthResourceConfig `locationName:"resourceConfig" type:"structure" required:"true"`

	// ResourceName is a required field
	ResourceName *string `locationName:"resourceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendAuthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendAuthInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBackendAuthInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBackendAuthInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BackendEnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackendEnvironmentName"))
	}
	if s.ResourceConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceConfig"))
	}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.ResourceConfig != nil {
		if err := s.ResourceConfig.Validate(); err != nil {
			invalidParams.AddNested("ResourceConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *CreateBackendAuthInput) SetAppId(v string) *CreateBackendAuthInput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *CreateBackendAuthInput) SetBackendEnvironmentName(v string) *CreateBackendAuthInput {
	s.BackendEnvironmentName = &v
	return s
}

// SetResourceConfig sets the ResourceConfig field's value.
func (s *CreateBackendAuthInput) SetResourceConfig(v *CreateBackendAuthResourceConfig) *CreateBackendAuthInput {
	s.ResourceConfig = v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *CreateBackendAuthInput) SetResourceName(v string) *CreateBackendAuthInput {
	s.ResourceName = &v
	return s
}

// Describes whether to apply multi-factor authentication policies for your
// Amazon Cognito user pool configured as a part of your Amplify project.
type CreateBackendAuthMFAConfig struct {
	_ struct{} `type:"structure"`

	// Describes whether MFA should be [ON, OFF, or OPTIONAL] for authentication
	// in your Amplify project.
	//
	// MFAMode is a required field
	MFAMode *string `type:"string" required:"true" enum:"MFAMode"`

	// Describes the configuration settings and methods for your Amplify app users
	// to use MFA.
	Settings *Settings `locationName:"settings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendAuthMFAConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendAuthMFAConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBackendAuthMFAConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBackendAuthMFAConfig"}
	if s.MFAMode == nil {
		invalidParams.Add(request.NewErrParamRequired("MFAMode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMFAMode sets the MFAMode field's value.
func (s *CreateBackendAuthMFAConfig) SetMFAMode(v string) *CreateBackendAuthMFAConfig {
	s.MFAMode = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *CreateBackendAuthMFAConfig) SetSettings(v *Settings) *CreateBackendAuthMFAConfig {
	s.Settings = v
	return s
}

// Creates the OAuth configuration for your Amplify project.
type CreateBackendAuthOAuthConfig struct {
	_ struct{} `type:"structure"`

	// The domain prefix for your Amplify app.
	DomainPrefix *string `locationName:"domainPrefix" type:"string"`

	// The OAuth grant type that you use to allow app users to authenticate from
	// your Amplify app.
	//
	// OAuthGrantType is a required field
	OAuthGrantType *string `locationName:"oAuthGrantType" type:"string" required:"true" enum:"OAuthGrantType"`

	// List of OAuth-related flows used to allow your app users to authenticate
	// from your Amplify app.
	//
	// OAuthScopes is a required field
	OAuthScopes []*string `locationName:"oAuthScopes" type:"list" required:"true" enum:"OAuthScopesElement"`

	// The redirected URI for signing in to your Amplify app.
	//
	// RedirectSignInURIs is a required field
	RedirectSignInURIs []*string `locationName:"redirectSignInURIs" type:"list" required:"true"`

	// Redirect URLs that OAuth uses when a user signs out of an Amplify app.
	//
	// RedirectSignOutURIs is a required field
	RedirectSignOutURIs []*string `locationName:"redirectSignOutURIs" type:"list" required:"true"`

	// The settings for using social providers to access your Amplify app.
	SocialProviderSettings *SocialProviderSettings `locationName:"socialProviderSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendAuthOAuthConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendAuthOAuthConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBackendAuthOAuthConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBackendAuthOAuthConfig"}
	if s.OAuthGrantType == nil {
		invalidParams.Add(request.NewErrParamRequired("OAuthGrantType"))
	}
	if s.OAuthScopes == nil {
		invalidParams.Add(request.NewErrParamRequired("OAuthScopes"))
	}
	if s.RedirectSignInURIs == nil {
		invalidParams.Add(request.NewErrParamRequired("RedirectSignInURIs"))
	}
	if s.RedirectSignOutURIs == nil {
		invalidParams.Add(request.NewErrParamRequired("RedirectSignOutURIs"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainPrefix sets the DomainPrefix field's value.
func (s *CreateBackendAuthOAuthConfig) SetDomainPrefix(v string) *CreateBackendAuthOAuthConfig {
	s.DomainPrefix = &v
	return s
}

// SetOAuthGrantType sets the OAuthGrantType field's value.
func (s *CreateBackendAuthOAuthConfig) SetOAuthGrantType(v string) *CreateBackendAuthOAuthConfig {
	s.OAuthGrantType = &v
	return s
}

// SetOAuthScopes sets the OAuthScopes field's value.
func (s *CreateBackendAuthOAuthConfig) SetOAuthScopes(v []*string) *CreateBackendAuthOAuthConfig {
	s.OAuthScopes = v
	return s
}

// SetRedirectSignInURIs sets the RedirectSignInURIs field's value.
func (s *CreateBackendAuthOAuthConfig) SetRedirectSignInURIs(v []*string) *CreateBackendAuthOAuthConfig {
	s.RedirectSignInURIs = v
	return s
}

// SetRedirectSignOutURIs sets the RedirectSignOutURIs field's value.
func (s *CreateBackendAuthOAuthConfig) SetRedirectSignOutURIs(v []*string) *CreateBackendAuthOAuthConfig {
	s.RedirectSignOutURIs = v
	return s
}

// SetSocialProviderSettings sets the SocialProviderSettings field's value.
func (s *CreateBackendAuthOAuthConfig) SetSocialProviderSettings(v *SocialProviderSettings) *CreateBackendAuthOAuthConfig {
	s.SocialProviderSettings = v
	return s
}

type CreateBackendAuthOutput struct {
	_ struct{} `type:"structure"`

	AppId *string `locationName:"appId" type:"string"`

	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string"`

	Error *string `locationName:"error" type:"string"`

	JobId *string `locationName:"jobId" type:"string"`

	Operation *string `locationName:"operation" type:"string"`

	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendAuthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendAuthOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *CreateBackendAuthOutput) SetAppId(v string) *CreateBackendAuthOutput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *CreateBackendAuthOutput) SetBackendEnvironmentName(v string) *CreateBackendAuthOutput {
	s.BackendEnvironmentName = &v
	return s
}

// SetError sets the Error field's value.
func (s *CreateBackendAuthOutput) SetError(v string) *CreateBackendAuthOutput {
	s.Error = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *CreateBackendAuthOutput) SetJobId(v string) *CreateBackendAuthOutput {
	s.JobId = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *CreateBackendAuthOutput) SetOperation(v string) *CreateBackendAuthOutput {
	s.Operation = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateBackendAuthOutput) SetStatus(v string) *CreateBackendAuthOutput {
	s.Status = &v
	return s
}

// The password policy configuration for the backend to your Amplify project.
type CreateBackendAuthPasswordPolicyConfig struct {
	_ struct{} `type:"structure"`

	// Additional constraints for the password used to access the backend of your
	// Amplify project.
	AdditionalConstraints []*string `locationName:"additionalConstraints" type:"list" enum:"AdditionalConstraintsElement"`

	// The minimum length of the password used to access the backend of your Amplify
	// project.
	//
	// MinimumLength is a required field
	MinimumLength *float64 `locationName:"minimumLength" type:"double" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendAuthPasswordPolicyConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendAuthPasswordPolicyConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBackendAuthPasswordPolicyConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBackendAuthPasswordPolicyConfig"}
	if s.MinimumLength == nil {
		invalidParams.Add(request.NewErrParamRequired("MinimumLength"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalConstraints sets the AdditionalConstraints field's value.
func (s *CreateBackendAuthPasswordPolicyConfig) SetAdditionalConstraints(v []*string) *CreateBackendAuthPasswordPolicyConfig {
	s.AdditionalConstraints = v
	return s
}

// SetMinimumLength sets the MinimumLength field's value.
func (s *CreateBackendAuthPasswordPolicyConfig) SetMinimumLength(v float64) *CreateBackendAuthPasswordPolicyConfig {
	s.MinimumLength = &v
	return s
}

// Defines the resource configuration when creating an auth resource in your
// Amplify project.
type CreateBackendAuthResourceConfig struct {
	_ struct{} `type:"structure"`

	// Defines whether you want to configure only authentication or both authentication
	// and authorization settings.
	//
	// AuthResources is a required field
	AuthResources *string `locationName:"authResources" type:"string" required:"true" enum:"AuthResources"`

	// Describes the authorization configuration for the Amazon Cognito identity
	// pool, provisioned as a part of your auth resource in the Amplify project.
	IdentityPoolConfigs *CreateBackendAuthIdentityPoolConfig `locationName:"identityPoolConfigs" type:"structure"`

	// Defines the service name to use when configuring an authentication resource
	// in your Amplify project.
	//
	// Service is a required field
	Service *string `locationName:"service" type:"string" required:"true" enum:"Service"`

	// Describes authentication configuration for the Amazon Cognito user pool,
	// provisioned as a part of your auth resource in the Amplify project.
	//
	// UserPoolConfigs is a required field
	UserPoolConfigs *CreateBackendAuthUserPoolConfig `locationName:"userPoolConfigs" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendAuthResourceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendAuthResourceConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBackendAuthResourceConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBackendAuthResourceConfig"}
	if s.AuthResources == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthResources"))
	}
	if s.Service == nil {
		invalidParams.Add(request.NewErrParamRequired("Service"))
	}
	if s.UserPoolConfigs == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolConfigs"))
	}
	if s.IdentityPoolConfigs != nil {
		if err := s.IdentityPoolConfigs.Validate(); err != nil {
			invalidParams.AddNested("IdentityPoolConfigs", err.(request.ErrInvalidParams))
		}
	}
	if s.UserPoolConfigs != nil {
		if err := s.UserPoolConfigs.Validate(); err != nil {
			invalidParams.AddNested("UserPoolConfigs", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthResources sets the AuthResources field's value.
func (s *CreateBackendAuthResourceConfig) SetAuthResources(v string) *CreateBackendAuthResourceConfig {
	s.AuthResources = &v
	return s
}

// SetIdentityPoolConfigs sets the IdentityPoolConfigs field's value.
func (s *CreateBackendAuthResourceConfig) SetIdentityPoolConfigs(v *CreateBackendAuthIdentityPoolConfig) *CreateBackendAuthResourceConfig {
	s.IdentityPoolConfigs = v
	return s
}

// SetService sets the Service field's value.
func (s *CreateBackendAuthResourceConfig) SetService(v string) *CreateBackendAuthResourceConfig {
	s.Service = &v
	return s
}

// SetUserPoolConfigs sets the UserPoolConfigs field's value.
func (s *CreateBackendAuthResourceConfig) SetUserPoolConfigs(v *CreateBackendAuthUserPoolConfig) *CreateBackendAuthResourceConfig {
	s.UserPoolConfigs = v
	return s
}

// Describes the Amazon Cognito user pool configuration for the auth resource
// to be configured for your Amplify project.
type CreateBackendAuthUserPoolConfig struct {
	_ struct{} `type:"structure"`

	// (DEPRECATED) Describes the forgotten password policy for your Amazon Cognito
	// user pool, configured as a part of your Amplify project.
	ForgotPassword *CreateBackendAuthForgotPasswordConfig `locationName:"forgotPassword" type:"structure"`

	// Describes whether to apply multi-factor authentication policies for your
	// Amazon Cognito user pool configured as a part of your Amplify project.
	Mfa *CreateBackendAuthMFAConfig `locationName:"mfa" type:"structure"`

	// Describes the OAuth policy and rules for your Amazon Cognito user pool, configured
	// as a part of your Amplify project.
	OAuth *CreateBackendAuthOAuthConfig `locationName:"oAuth" type:"structure"`

	// Describes the password policy for your Amazon Cognito user pool, configured
	// as a part of your Amplify project.
	PasswordPolicy *CreateBackendAuthPasswordPolicyConfig `locationName:"passwordPolicy" type:"structure"`

	// The required attributes to sign up new users in the user pool.
	//
	// RequiredSignUpAttributes is a required field
	RequiredSignUpAttributes []*string `locationName:"requiredSignUpAttributes" type:"list" required:"true" enum:"RequiredSignUpAttributesElement"`

	// Describes the sign-in methods that your Amplify app users use to log in using
	// the Amazon Cognito user pool, configured as a part of your Amplify project.
	//
	// SignInMethod is a required field
	SignInMethod *string `locationName:"signInMethod" type:"string" required:"true" enum:"SignInMethod"`

	// The Amazon Cognito user pool name.
	//
	// UserPoolName is a required field
	UserPoolName *string `locationName:"userPoolName" type:"string" required:"true"`

	// Describes the email or SMS verification message for your Amazon Cognito user
	// pool, configured as a part of your Amplify project.
	VerificationMessage *CreateBackendAuthVerificationMessageConfig `locationName:"verificationMessage" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendAuthUserPoolConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendAuthUserPoolConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBackendAuthUserPoolConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBackendAuthUserPoolConfig"}
	if s.RequiredSignUpAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("RequiredSignUpAttributes"))
	}
	if s.SignInMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("SignInMethod"))
	}
	if s.UserPoolName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolName"))
	}
	if s.ForgotPassword != nil {
		if err := s.ForgotPassword.Validate(); err != nil {
			invalidParams.AddNested("ForgotPassword", err.(request.ErrInvalidParams))
		}
	}
	if s.Mfa != nil {
		if err := s.Mfa.Validate(); err != nil {
			invalidParams.AddNested("Mfa", err.(request.ErrInvalidParams))
		}
	}
	if s.OAuth != nil {
		if err := s.OAuth.Validate(); err != nil {
			invalidParams.AddNested("OAuth", err.(request.ErrInvalidParams))
		}
	}
	if s.PasswordPolicy != nil {
		if err := s.PasswordPolicy.Validate(); err != nil {
			invalidParams.AddNested("PasswordPolicy", err.(request.ErrInvalidParams))
		}
	}
	if s.VerificationMessage != nil {
		if err := s.VerificationMessage.Validate(); err != nil {
			invalidParams.AddNested("VerificationMessage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForgotPassword sets the ForgotPassword field's value.
func (s *CreateBackendAuthUserPoolConfig) SetForgotPassword(v *CreateBackendAuthForgotPasswordConfig) *CreateBackendAuthUserPoolConfig {
	s.ForgotPassword = v
	return s
}

// SetMfa sets the Mfa field's value.
func (s *CreateBackendAuthUserPoolConfig) SetMfa(v *CreateBackendAuthMFAConfig) *CreateBackendAuthUserPoolConfig {
	s.Mfa = v
	return s
}

// SetOAuth sets the OAuth field's value.
func (s *CreateBackendAuthUserPoolConfig) SetOAuth(v *CreateBackendAuthOAuthConfig) *CreateBackendAuthUserPoolConfig {
	s.OAuth = v
	return s
}

// SetPasswordPolicy sets the PasswordPolicy field's value.
func (s *CreateBackendAuthUserPoolConfig) SetPasswordPolicy(v *CreateBackendAuthPasswordPolicyConfig) *CreateBackendAuthUserPoolConfig {
	s.PasswordPolicy = v
	return s
}

// SetRequiredSignUpAttributes sets the RequiredSignUpAttributes field's value.
func (s *CreateBackendAuthUserPoolConfig) SetRequiredSignUpAttributes(v []*string) *CreateBackendAuthUserPoolConfig {
	s.RequiredSignUpAttributes = v
	return s
}

// SetSignInMethod sets the SignInMethod field's value.
func (s *CreateBackendAuthUserPoolConfig) SetSignInMethod(v string) *CreateBackendAuthUserPoolConfig {
	s.SignInMethod = &v
	return s
}

// SetUserPoolName sets the UserPoolName field's value.
func (s *CreateBackendAuthUserPoolConfig) SetUserPoolName(v string) *CreateBackendAuthUserPoolConfig {
	s.UserPoolName = &v
	return s
}

// SetVerificationMessage sets the VerificationMessage field's value.
func (s *CreateBackendAuthUserPoolConfig) SetVerificationMessage(v *CreateBackendAuthVerificationMessageConfig) *CreateBackendAuthUserPoolConfig {
	s.VerificationMessage = v
	return s
}

// Creates an email or SMS verification message for the auth resource configured
// for your Amplify project.
type CreateBackendAuthVerificationMessageConfig struct {
	_ struct{} `type:"structure"`

	// The type of verification message to send.
	//
	// DeliveryMethod is a required field
	DeliveryMethod *string `locationName:"deliveryMethod" type:"string" required:"true" enum:"DeliveryMethod"`

	// The settings for the email message.
	EmailSettings *EmailSettings `locationName:"emailSettings" type:"structure"`

	// The settings for the SMS message.
	SmsSettings *SmsSettings `locationName:"smsSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendAuthVerificationMessageConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendAuthVerificationMessageConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBackendAuthVerificationMessageConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBackendAuthVerificationMessageConfig"}
	if s.DeliveryMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryMethod"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryMethod sets the DeliveryMethod field's value.
func (s *CreateBackendAuthVerificationMessageConfig) SetDeliveryMethod(v string) *CreateBackendAuthVerificationMessageConfig {
	s.DeliveryMethod = &v
	return s
}

// SetEmailSettings sets the EmailSettings field's value.
func (s *CreateBackendAuthVerificationMessageConfig) SetEmailSettings(v *EmailSettings) *CreateBackendAuthVerificationMessageConfig {
	s.EmailSettings = v
	return s
}

// SetSmsSettings sets the SmsSettings field's value.
func (s *CreateBackendAuthVerificationMessageConfig) SetSmsSettings(v *SmsSettings) *CreateBackendAuthVerificationMessageConfig {
	s.SmsSettings = v
	return s
}

type CreateBackendConfigInput struct {
	_ struct{} `type:"structure"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	BackendManagerAppId *string `locationName:"backendManagerAppId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBackendConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBackendConfigInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *CreateBackendConfigInput) SetAppId(v string) *CreateBackendConfigInput {
	s.AppId = &v
	return s
}

// SetBackendManagerAppId sets the BackendManagerAppId field's value.
func (s *CreateBackendConfigInput) SetBackendManagerAppId(v string) *CreateBackendConfigInput {
	s.BackendManagerAppId = &v
	return s
}

type CreateBackendConfigOutput struct {
	_ struct{} `type:"structure"`

	AppId *string `locationName:"appId" type:"string"`

	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string"`

	JobId *string `locationName:"jobId" type:"string"`

	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendConfigOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *CreateBackendConfigOutput) SetAppId(v string) *CreateBackendConfigOutput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *CreateBackendConfigOutput) SetBackendEnvironmentName(v string) *CreateBackendConfigOutput {
	s.BackendEnvironmentName = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *CreateBackendConfigOutput) SetJobId(v string) *CreateBackendConfigOutput {
	s.JobId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateBackendConfigOutput) SetStatus(v string) *CreateBackendConfigOutput {
	s.Status = &v
	return s
}

type CreateBackendInput struct {
	_ struct{} `type:"structure"`

	// AppId is a required field
	AppId *string `locationName:"appId" type:"string" required:"true"`

	// AppName is a required field
	AppName *string `locationName:"appName" type:"string" required:"true"`

	// BackendEnvironmentName is a required field
	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string" required:"true"`

	ResourceConfig *ResourceConfig `locationName:"resourceConfig" type:"structure"`

	ResourceName *string `locationName:"resourceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBackendInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBackendInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppName == nil {
		invalidParams.Add(request.NewErrParamRequired("AppName"))
	}
	if s.BackendEnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackendEnvironmentName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *CreateBackendInput) SetAppId(v string) *CreateBackendInput {
	s.AppId = &v
	return s
}

// SetAppName sets the AppName field's value.
func (s *CreateBackendInput) SetAppName(v string) *CreateBackendInput {
	s.AppName = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *CreateBackendInput) SetBackendEnvironmentName(v string) *CreateBackendInput {
	s.BackendEnvironmentName = &v
	return s
}

// SetResourceConfig sets the ResourceConfig field's value.
func (s *CreateBackendInput) SetResourceConfig(v *ResourceConfig) *CreateBackendInput {
	s.ResourceConfig = v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *CreateBackendInput) SetResourceName(v string) *CreateBackendInput {
	s.ResourceName = &v
	return s
}

type CreateBackendOutput struct {
	_ struct{} `type:"structure"`

	AppId *string `locationName:"appId" type:"string"`

	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string"`

	Error *string `locationName:"error" type:"string"`

	JobId *string `locationName:"jobId" type:"string"`

	Operation *string `locationName:"operation" type:"string"`

	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *CreateBackendOutput) SetAppId(v string) *CreateBackendOutput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *CreateBackendOutput) SetBackendEnvironmentName(v string) *CreateBackendOutput {
	s.BackendEnvironmentName = &v
	return s
}

// SetError sets the Error field's value.
func (s *CreateBackendOutput) SetError(v string) *CreateBackendOutput {
	s.Error = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *CreateBackendOutput) SetJobId(v string) *CreateBackendOutput {
	s.JobId = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *CreateBackendOutput) SetOperation(v string) *CreateBackendOutput {
	s.Operation = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateBackendOutput) SetStatus(v string) *CreateBackendOutput {
	s.Status = &v
	return s
}

type CreateBackendStorageInput struct {
	_ struct{} `type:"structure"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// BackendEnvironmentName is a required field
	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string" required:"true"`

	// The resource configuration for creating backend storage.
	//
	// ResourceConfig is a required field
	ResourceConfig *CreateBackendStorageResourceConfig `locationName:"resourceConfig" type:"structure" required:"true"`

	// ResourceName is a required field
	ResourceName *string `locationName:"resourceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendStorageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendStorageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBackendStorageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBackendStorageInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BackendEnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackendEnvironmentName"))
	}
	if s.ResourceConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceConfig"))
	}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.ResourceConfig != nil {
		if err := s.ResourceConfig.Validate(); err != nil {
			invalidParams.AddNested("ResourceConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *CreateBackendStorageInput) SetAppId(v string) *CreateBackendStorageInput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *CreateBackendStorageInput) SetBackendEnvironmentName(v string) *CreateBackendStorageInput {
	s.BackendEnvironmentName = &v
	return s
}

// SetResourceConfig sets the ResourceConfig field's value.
func (s *CreateBackendStorageInput) SetResourceConfig(v *CreateBackendStorageResourceConfig) *CreateBackendStorageInput {
	s.ResourceConfig = v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *CreateBackendStorageInput) SetResourceName(v string) *CreateBackendStorageInput {
	s.ResourceName = &v
	return s
}

type CreateBackendStorageOutput struct {
	_ struct{} `type:"structure"`

	AppId *string `locationName:"appId" type:"string"`

	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string"`

	JobId *string `locationName:"jobId" type:"string"`

	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendStorageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendStorageOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *CreateBackendStorageOutput) SetAppId(v string) *CreateBackendStorageOutput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *CreateBackendStorageOutput) SetBackendEnvironmentName(v string) *CreateBackendStorageOutput {
	s.BackendEnvironmentName = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *CreateBackendStorageOutput) SetJobId(v string) *CreateBackendStorageOutput {
	s.JobId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateBackendStorageOutput) SetStatus(v string) *CreateBackendStorageOutput {
	s.Status = &v
	return s
}

// The resource configuration for creating backend storage.
type CreateBackendStorageResourceConfig struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket.
	BucketName *string `locationName:"bucketName" type:"string"`

	// The authorization configuration for the storage S3 bucket.
	//
	// Permissions is a required field
	Permissions *BackendStoragePermissions `locationName:"permissions" type:"structure" required:"true"`

	// The name of the storage service.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" type:"string" required:"true" enum:"ServiceName"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendStorageResourceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackendStorageResourceConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBackendStorageResourceConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBackendStorageResourceConfig"}
	if s.Permissions == nil {
		invalidParams.Add(request.NewErrParamRequired("Permissions"))
	}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.Permissions != nil {
		if err := s.Permissions.Validate(); err != nil {
			invalidParams.AddNested("Permissions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *CreateBackendStorageResourceConfig) SetBucketName(v string) *CreateBackendStorageResourceConfig {
	s.BucketName = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *CreateBackendStorageResourceConfig) SetPermissions(v *BackendStoragePermissions) *CreateBackendStorageResourceConfig {
	s.Permissions = v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *CreateBackendStorageResourceConfig) SetServiceName(v string) *CreateBackendStorageResourceConfig {
	s.ServiceName = &v
	return s
}

type CreateTokenInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTokenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTokenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTokenInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *CreateTokenInput) SetAppId(v string) *CreateTokenInput {
	s.AppId = &v
	return s
}

type CreateTokenOutput struct {
	_ struct{} `type:"structure"`

	AppId *string `locationName:"appId" type:"string"`

	ChallengeCode *string `locationName:"challengeCode" type:"string"`

	SessionId *string `locationName:"sessionId" type:"string"`

	Ttl *string `locationName:"ttl" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTokenOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *CreateTokenOutput) SetAppId(v string) *CreateTokenOutput {
	s.AppId = &v
	return s
}

// SetChallengeCode sets the ChallengeCode field's value.
func (s *CreateTokenOutput) SetChallengeCode(v string) *CreateTokenOutput {
	s.ChallengeCode = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *CreateTokenOutput) SetSessionId(v string) *CreateTokenOutput {
	s.SessionId = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *CreateTokenOutput) SetTtl(v string) *CreateTokenOutput {
	s.Ttl = &v
	return s
}

type DeleteBackendAPIInput struct {
	_ struct{} `type:"structure"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// BackendEnvironmentName is a required field
	BackendEnvironmentName *string `location:"uri" locationName:"backendEnvironmentName" type:"string" required:"true"`

	// The resource config for the data model, configured as a part of the Amplify
	// project.
	ResourceConfig *BackendAPIResourceConfig `locationName:"resourceConfig" type:"structure"`

	// ResourceName is a required field
	ResourceName *string `locationName:"resourceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackendAPIInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackendAPIInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBackendAPIInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBackendAPIInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BackendEnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackendEnvironmentName"))
	}
	if s.BackendEnvironmentName != nil && len(*s.BackendEnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackendEnvironmentName", 1))
	}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *DeleteBackendAPIInput) SetAppId(v string) *DeleteBackendAPIInput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *DeleteBackendAPIInput) SetBackendEnvironmentName(v string) *DeleteBackendAPIInput {
	s.BackendEnvironmentName = &v
	return s
}

// SetResourceConfig sets the ResourceConfig field's value.
func (s *DeleteBackendAPIInput) SetResourceConfig(v *BackendAPIResourceConfig) *DeleteBackendAPIInput {
	s.ResourceConfig = v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *DeleteBackendAPIInput) SetResourceName(v string) *DeleteBackendAPIInput {
	s.ResourceName = &v
	return s
}

type DeleteBackendAPIOutput struct {
	_ struct{} `type:"structure"`

	AppId *string `locationName:"appId" type:"string"`

	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string"`

	Error *string `locationName:"error" type:"string"`

	JobId *string `locationName:"jobId" type:"string"`

	Operation *string `locationName:"operation" type:"string"`

	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackendAPIOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackendAPIOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *DeleteBackendAPIOutput) SetAppId(v string) *DeleteBackendAPIOutput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *DeleteBackendAPIOutput) SetBackendEnvironmentName(v string) *DeleteBackendAPIOutput {
	s.BackendEnvironmentName = &v
	return s
}

// SetError sets the Error field's value.
func (s *DeleteBackendAPIOutput) SetError(v string) *DeleteBackendAPIOutput {
	s.Error = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DeleteBackendAPIOutput) SetJobId(v string) *DeleteBackendAPIOutput {
	s.JobId = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *DeleteBackendAPIOutput) SetOperation(v string) *DeleteBackendAPIOutput {
	s.Operation = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteBackendAPIOutput) SetStatus(v string) *DeleteBackendAPIOutput {
	s.Status = &v
	return s
}

type DeleteBackendAuthInput struct {
	_ struct{} `type:"structure"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// BackendEnvironmentName is a required field
	BackendEnvironmentName *string `location:"uri" locationName:"backendEnvironmentName" type:"string" required:"true"`

	// ResourceName is a required field
	ResourceName *string `locationName:"resourceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackendAuthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackendAuthInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBackendAuthInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBackendAuthInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BackendEnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackendEnvironmentName"))
	}
	if s.BackendEnvironmentName != nil && len(*s.BackendEnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackendEnvironmentName", 1))
	}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *DeleteBackendAuthInput) SetAppId(v string) *DeleteBackendAuthInput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *DeleteBackendAuthInput) SetBackendEnvironmentName(v string) *DeleteBackendAuthInput {
	s.BackendEnvironmentName = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *DeleteBackendAuthInput) SetResourceName(v string) *DeleteBackendAuthInput {
	s.ResourceName = &v
	return s
}

type DeleteBackendAuthOutput struct {
	_ struct{} `type:"structure"`

	AppId *string `locationName:"appId" type:"string"`

	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string"`

	Error *string `locationName:"error" type:"string"`

	JobId *string `locationName:"jobId" type:"string"`

	Operation *string `locationName:"operation" type:"string"`

	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackendAuthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackendAuthOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *DeleteBackendAuthOutput) SetAppId(v string) *DeleteBackendAuthOutput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *DeleteBackendAuthOutput) SetBackendEnvironmentName(v string) *DeleteBackendAuthOutput {
	s.BackendEnvironmentName = &v
	return s
}

// SetError sets the Error field's value.
func (s *DeleteBackendAuthOutput) SetError(v string) *DeleteBackendAuthOutput {
	s.Error = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DeleteBackendAuthOutput) SetJobId(v string) *DeleteBackendAuthOutput {
	s.JobId = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *DeleteBackendAuthOutput) SetOperation(v string) *DeleteBackendAuthOutput {
	s.Operation = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteBackendAuthOutput) SetStatus(v string) *DeleteBackendAuthOutput {
	s.Status = &v
	return s
}

type DeleteBackendInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// BackendEnvironmentName is a required field
	BackendEnvironmentName *string `location:"uri" locationName:"backendEnvironmentName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackendInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackendInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBackendInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBackendInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BackendEnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackendEnvironmentName"))
	}
	if s.BackendEnvironmentName != nil && len(*s.BackendEnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackendEnvironmentName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *DeleteBackendInput) SetAppId(v string) *DeleteBackendInput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *DeleteBackendInput) SetBackendEnvironmentName(v string) *DeleteBackendInput {
	s.BackendEnvironmentName = &v
	return s
}

type DeleteBackendOutput struct {
	_ struct{} `type:"structure"`

	AppId *string `locationName:"appId" type:"string"`

	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string"`

	Error *string `locationName:"error" type:"string"`

	JobId *string `locationName:"jobId" type:"string"`

	Operation *string `locationName:"operation" type:"string"`

	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackendOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackendOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *DeleteBackendOutput) SetAppId(v string) *DeleteBackendOutput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *DeleteBackendOutput) SetBackendEnvironmentName(v string) *DeleteBackendOutput {
	s.BackendEnvironmentName = &v
	return s
}

// SetError sets the Error field's value.
func (s *DeleteBackendOutput) SetError(v string) *DeleteBackendOutput {
	s.Error = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DeleteBackendOutput) SetJobId(v string) *DeleteBackendOutput {
	s.JobId = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *DeleteBackendOutput) SetOperation(v string) *DeleteBackendOutput {
	s.Operation = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteBackendOutput) SetStatus(v string) *DeleteBackendOutput {
	s.Status = &v
	return s
}

type DeleteBackendStorageInput struct {
	_ struct{} `type:"structure"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// BackendEnvironmentName is a required field
	BackendEnvironmentName *string `location:"uri" locationName:"backendEnvironmentName" type:"string" required:"true"`

	// ResourceName is a required field
	ResourceName *string `locationName:"resourceName" type:"string" required:"true"`

	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" type:"string" required:"true" enum:"ServiceName"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackendStorageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackendStorageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBackendStorageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBackendStorageInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BackendEnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackendEnvironmentName"))
	}
	if s.BackendEnvironmentName != nil && len(*s.BackendEnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackendEnvironmentName", 1))
	}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *DeleteBackendStorageInput) SetAppId(v string) *DeleteBackendStorageInput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *DeleteBackendStorageInput) SetBackendEnvironmentName(v string) *DeleteBackendStorageInput {
	s.BackendEnvironmentName = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *DeleteBackendStorageInput) SetResourceName(v string) *DeleteBackendStorageInput {
	s.ResourceName = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *DeleteBackendStorageInput) SetServiceName(v string) *DeleteBackendStorageInput {
	s.ServiceName = &v
	return s
}

type DeleteBackendStorageOutput struct {
	_ struct{} `type:"structure"`

	AppId *string `locationName:"appId" type:"string"`

	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string"`

	JobId *string `locationName:"jobId" type:"string"`

	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackendStorageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackendStorageOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *DeleteBackendStorageOutput) SetAppId(v string) *DeleteBackendStorageOutput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *DeleteBackendStorageOutput) SetBackendEnvironmentName(v string) *DeleteBackendStorageOutput {
	s.BackendEnvironmentName = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DeleteBackendStorageOutput) SetJobId(v string) *DeleteBackendStorageOutput {
	s.JobId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteBackendStorageOutput) SetStatus(v string) *DeleteBackendStorageOutput {
	s.Status = &v
	return s
}

type DeleteTokenInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// SessionId is a required field
	SessionId *string `location:"uri" locationName:"sessionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTokenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTokenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTokenInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *DeleteTokenInput) SetAppId(v string) *DeleteTokenInput {
	s.AppId = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *DeleteTokenInput) SetSessionId(v string) *DeleteTokenInput {
	s.SessionId = &v
	return s
}

type DeleteTokenOutput struct {
	_ struct{} `type:"structure"`

	IsSuccess *bool `locationName:"isSuccess" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTokenOutput) GoString() string {
	return s.String()
}

// SetIsSuccess sets the IsSuccess field's value.
func (s *DeleteTokenOutput) SetIsSuccess(v bool) *DeleteTokenOutput {
	s.IsSuccess = &v
	return s
}

// The settings for the email message.
type EmailSettings struct {
	_ struct{} `type:"structure"`

	// The contents of the email message.
	EmailMessage *string `locationName:"emailMessage" type:"string"`

	// The contents of the subject line of the email message.
	EmailSubject *string `locationName:"emailSubject" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EmailSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EmailSettings) GoString() string {
	return s.String()
}

// SetEmailMessage sets the EmailMessage field's value.
func (s *EmailSettings) SetEmailMessage(v string) *EmailSettings {
	s.EmailMessage = &v
	return s
}

// SetEmailSubject sets the EmailSubject field's value.
func (s *EmailSettings) SetEmailSubject(v string) *EmailSettings {
	s.EmailSubject = &v
	return s
}

// An error returned if there's a temporary issue with the service.
type GatewayTimeoutException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayTimeoutException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GatewayTimeoutException) GoString() string {
	return s.String()
}

func newErrorGatewayTimeoutException(v protocol.ResponseMetadata) error {
	return &GatewayTimeoutException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *GatewayTimeoutException) Code() string {
	return "GatewayTimeoutException"
}

// Message returns the exception's message.
func (s *GatewayTimeoutException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *GatewayTimeoutException) OrigErr() error {
	return nil
}

func (s *GatewayTimeoutException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *GatewayTimeoutException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *GatewayTimeoutException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GenerateBackendAPIModelsInput struct {
	_ struct{} `type:"structure"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// BackendEnvironmentName is a required field
	BackendEnvironmentName *string `location:"uri" locationName:"backendEnvironmentName" type:"string" required:"true"`

	// ResourceName is a required field
	ResourceName *string `locationName:"resourceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateBackendAPIModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateBackendAPIModelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GenerateBackendAPIModelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GenerateBackendAPIModelsInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BackendEnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackendEnvironmentName"))
	}
	if s.BackendEnvironmentName != nil && len(*s.BackendEnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackendEnvironmentName", 1))
	}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *GenerateBackendAPIModelsInput) SetAppId(v string) *GenerateBackendAPIModelsInput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *GenerateBackendAPIModelsInput) SetBackendEnvironmentName(v string) *GenerateBackendAPIModelsInput {
	s.BackendEnvironmentName = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *GenerateBackendAPIModelsInput) SetResourceName(v string) *GenerateBackendAPIModelsInput {
	s.ResourceName = &v
	return s
}

type GenerateBackendAPIModelsOutput struct {
	_ struct{} `type:"structure"`

	AppId *string `locationName:"appId" type:"string"`

	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string"`

	Error *string `locationName:"error" type:"string"`

	JobId *string `locationName:"jobId" type:"string"`

	Operation *string `locationName:"operation" type:"string"`

	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateBackendAPIModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateBackendAPIModelsOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *GenerateBackendAPIModelsOutput) SetAppId(v string) *GenerateBackendAPIModelsOutput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *GenerateBackendAPIModelsOutput) SetBackendEnvironmentName(v string) *GenerateBackendAPIModelsOutput {
	s.BackendEnvironmentName = &v
	return s
}

// SetError sets the Error field's value.
func (s *GenerateBackendAPIModelsOutput) SetError(v string) *GenerateBackendAPIModelsOutput {
	s.Error = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GenerateBackendAPIModelsOutput) SetJobId(v string) *GenerateBackendAPIModelsOutput {
	s.JobId = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *GenerateBackendAPIModelsOutput) SetOperation(v string) *GenerateBackendAPIModelsOutput {
	s.Operation = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GenerateBackendAPIModelsOutput) SetStatus(v string) *GenerateBackendAPIModelsOutput {
	s.Status = &v
	return s
}

type GetBackendAPIInput struct {
	_ struct{} `type:"structure"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// BackendEnvironmentName is a required field
	BackendEnvironmentName *string `location:"uri" locationName:"backendEnvironmentName" type:"string" required:"true"`

	// The resource config for the data model, configured as a part of the Amplify
	// project.
	ResourceConfig *BackendAPIResourceConfig `locationName:"resourceConfig" type:"structure"`

	// ResourceName is a required field
	ResourceName *string `locationName:"resourceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackendAPIInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackendAPIInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBackendAPIInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBackendAPIInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BackendEnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackendEnvironmentName"))
	}
	if s.BackendEnvironmentName != nil && len(*s.BackendEnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackendEnvironmentName", 1))
	}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *GetBackendAPIInput) SetAppId(v string) *GetBackendAPIInput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *GetBackendAPIInput) SetBackendEnvironmentName(v string) *GetBackendAPIInput {
	s.BackendEnvironmentName = &v
	return s
}

// SetResourceConfig sets the ResourceConfig field's value.
func (s *GetBackendAPIInput) SetResourceConfig(v *BackendAPIResourceConfig) *GetBackendAPIInput {
	s.ResourceConfig = v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *GetBackendAPIInput) SetResourceName(v string) *GetBackendAPIInput {
	s.ResourceName = &v
	return s
}

type GetBackendAPIModelsInput struct {
	_ struct{} `type:"structure"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// BackendEnvironmentName is a required field
	BackendEnvironmentName *string `location:"uri" locationName:"backendEnvironmentName" type:"string" required:"true"`

	// ResourceName is a required field
	ResourceName *string `locationName:"resourceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackendAPIModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackendAPIModelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBackendAPIModelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBackendAPIModelsInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BackendEnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackendEnvironmentName"))
	}
	if s.BackendEnvironmentName != nil && len(*s.BackendEnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackendEnvironmentName", 1))
	}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *GetBackendAPIModelsInput) SetAppId(v string) *GetBackendAPIModelsInput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *GetBackendAPIModelsInput) SetBackendEnvironmentName(v string) *GetBackendAPIModelsInput {
	s.BackendEnvironmentName = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *GetBackendAPIModelsInput) SetResourceName(v string) *GetBackendAPIModelsInput {
	s.ResourceName = &v
	return s
}

type GetBackendAPIModelsOutput struct {
	_ struct{} `type:"structure"`

	Models *string `locationName:"models" type:"string"`

	Status *string `locationName:"status" type:"string" enum:"Status"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackendAPIModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackendAPIModelsOutput) GoString() string {
	return s.String()
}

// SetModels sets the Models field's value.
func (s *GetBackendAPIModelsOutput) SetModels(v string) *GetBackendAPIModelsOutput {
	s.Models = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetBackendAPIModelsOutput) SetStatus(v string) *GetBackendAPIModelsOutput {
	s.Status = &v
	return s
}

type GetBackendAPIOutput struct {
	_ struct{} `type:"structure"`

	AppId *string `locationName:"appId" type:"string"`

	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string"`

	Error *string `locationName:"error" type:"string"`

	// The resource config for the data model, configured as a part of the Amplify
	// project.
	ResourceConfig *BackendAPIResourceConfig `locationName:"resourceConfig" type:"structure"`

	ResourceName *string `locationName:"resourceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackendAPIOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackendAPIOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *GetBackendAPIOutput) SetAppId(v string) *GetBackendAPIOutput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *GetBackendAPIOutput) SetBackendEnvironmentName(v string) *GetBackendAPIOutput {
	s.BackendEnvironmentName = &v
	return s
}

// SetError sets the Error field's value.
func (s *GetBackendAPIOutput) SetError(v string) *GetBackendAPIOutput {
	s.Error = &v
	return s
}

// SetResourceConfig sets the ResourceConfig field's value.
func (s *GetBackendAPIOutput) SetResourceConfig(v *BackendAPIResourceConfig) *GetBackendAPIOutput {
	s.ResourceConfig = v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *GetBackendAPIOutput) SetResourceName(v string) *GetBackendAPIOutput {
	s.ResourceName = &v
	return s
}

type GetBackendAuthInput struct {
	_ struct{} `type:"structure"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// BackendEnvironmentName is a required field
	BackendEnvironmentName *string `location:"uri" locationName:"backendEnvironmentName" type:"string" required:"true"`

	// ResourceName is a required field
	ResourceName *string `locationName:"resourceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackendAuthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackendAuthInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBackendAuthInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBackendAuthInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BackendEnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackendEnvironmentName"))
	}
	if s.BackendEnvironmentName != nil && len(*s.BackendEnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackendEnvironmentName", 1))
	}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *GetBackendAuthInput) SetAppId(v string) *GetBackendAuthInput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *GetBackendAuthInput) SetBackendEnvironmentName(v string) *GetBackendAuthInput {
	s.BackendEnvironmentName = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *GetBackendAuthInput) SetResourceName(v string) *GetBackendAuthInput {
	s.ResourceName = &v
	return s
}

type GetBackendAuthOutput struct {
	_ struct{} `type:"structure"`

	AppId *string `locationName:"appId" type:"string"`

	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string"`

	Error *string `locationName:"error" type:"string"`

	// Defines the resource configuration when creating an auth resource in your
	// Amplify project.
	ResourceConfig *CreateBackendAuthResourceConfig `locationName:"resourceConfig" type:"structure"`

	ResourceName *string `locationName:"resourceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackendAuthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackendAuthOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *GetBackendAuthOutput) SetAppId(v string) *GetBackendAuthOutput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *GetBackendAuthOutput) SetBackendEnvironmentName(v string) *GetBackendAuthOutput {
	s.BackendEnvironmentName = &v
	return s
}

// SetError sets the Error field's value.
func (s *GetBackendAuthOutput) SetError(v string) *GetBackendAuthOutput {
	s.Error = &v
	return s
}

// SetResourceConfig sets the ResourceConfig field's value.
func (s *GetBackendAuthOutput) SetResourceConfig(v *CreateBackendAuthResourceConfig) *GetBackendAuthOutput {
	s.ResourceConfig = v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *GetBackendAuthOutput) SetResourceName(v string) *GetBackendAuthOutput {
	s.ResourceName = &v
	return s
}

type GetBackendInput struct {
	_ struct{} `type:"structure"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackendInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackendInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBackendInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBackendInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *GetBackendInput) SetAppId(v string) *GetBackendInput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *GetBackendInput) SetBackendEnvironmentName(v string) *GetBackendInput {
	s.BackendEnvironmentName = &v
	return s
}

type GetBackendJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// BackendEnvironmentName is a required field
	BackendEnvironmentName *string `location:"uri" locationName:"backendEnvironmentName" type:"string" required:"true"`

	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackendJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackendJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBackendJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBackendJobInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BackendEnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackendEnvironmentName"))
	}
	if s.BackendEnvironmentName != nil && len(*s.BackendEnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackendEnvironmentName", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *GetBackendJobInput) SetAppId(v string) *GetBackendJobInput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *GetBackendJobInput) SetBackendEnvironmentName(v string) *GetBackendJobInput {
	s.BackendEnvironmentName = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetBackendJobInput) SetJobId(v string) *GetBackendJobInput {
	s.JobId = &v
	return s
}

type GetBackendJobOutput struct {
	_ struct{} `type:"structure"`

	AppId *string `locationName:"appId" type:"string"`

	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string"`

	CreateTime *string `locationName:"createTime" type:"string"`

	Error *string `locationName:"error" type:"string"`

	JobId *string `locationName:"jobId" type:"string"`

	Operation *string `locationName:"operation" type:"string"`

	Status *string `locationName:"status" type:"string"`

	UpdateTime *string `locationName:"updateTime" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackendJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackendJobOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *GetBackendJobOutput) SetAppId(v string) *GetBackendJobOutput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *GetBackendJobOutput) SetBackendEnvironmentName(v string) *GetBackendJobOutput {
	s.BackendEnvironmentName = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *GetBackendJobOutput) SetCreateTime(v string) *GetBackendJobOutput {
	s.CreateTime = &v
	return s
}

// SetError sets the Error field's value.
func (s *GetBackendJobOutput) SetError(v string) *GetBackendJobOutput {
	s.Error = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetBackendJobOutput) SetJobId(v string) *GetBackendJobOutput {
	s.JobId = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *GetBackendJobOutput) SetOperation(v string) *GetBackendJobOutput {
	s.Operation = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetBackendJobOutput) SetStatus(v string) *GetBackendJobOutput {
	s.Status = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *GetBackendJobOutput) SetUpdateTime(v string) *GetBackendJobOutput {
	s.UpdateTime = &v
	return s
}

type GetBackendOutput struct {
	_ struct{} `type:"structure"`

	AmplifyFeatureFlags *string `locationName:"amplifyFeatureFlags" type:"string"`

	AmplifyMetaConfig *string `locationName:"amplifyMetaConfig" type:"string"`

	AppId *string `locationName:"appId" type:"string"`

	AppName *string `locationName:"appName" type:"string"`

	BackendEnvironmentList []*string `locationName:"backendEnvironmentList" type:"list"`

	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string"`

	Error *string `locationName:"error" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackendOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackendOutput) GoString() string {
	return s.String()
}

// SetAmplifyFeatureFlags sets the AmplifyFeatureFlags field's value.
func (s *GetBackendOutput) SetAmplifyFeatureFlags(v string) *GetBackendOutput {
	s.AmplifyFeatureFlags = &v
	return s
}

// SetAmplifyMetaConfig sets the AmplifyMetaConfig field's value.
func (s *GetBackendOutput) SetAmplifyMetaConfig(v string) *GetBackendOutput {
	s.AmplifyMetaConfig = &v
	return s
}

// SetAppId sets the AppId field's value.
func (s *GetBackendOutput) SetAppId(v string) *GetBackendOutput {
	s.AppId = &v
	return s
}

// SetAppName sets the AppName field's value.
func (s *GetBackendOutput) SetAppName(v string) *GetBackendOutput {
	s.AppName = &v
	return s
}

// SetBackendEnvironmentList sets the BackendEnvironmentList field's value.
func (s *GetBackendOutput) SetBackendEnvironmentList(v []*string) *GetBackendOutput {
	s.BackendEnvironmentList = v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *GetBackendOutput) SetBackendEnvironmentName(v string) *GetBackendOutput {
	s.BackendEnvironmentName = &v
	return s
}

// SetError sets the Error field's value.
func (s *GetBackendOutput) SetError(v string) *GetBackendOutput {
	s.Error = &v
	return s
}

type GetBackendStorageInput struct {
	_ struct{} `type:"structure"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// BackendEnvironmentName is a required field
	BackendEnvironmentName *string `location:"uri" locationName:"backendEnvironmentName" type:"string" required:"true"`

	// ResourceName is a required field
	ResourceName *string `locationName:"resourceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackendStorageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackendStorageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBackendStorageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBackendStorageInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BackendEnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackendEnvironmentName"))
	}
	if s.BackendEnvironmentName != nil && len(*s.BackendEnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackendEnvironmentName", 1))
	}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *GetBackendStorageInput) SetAppId(v string) *GetBackendStorageInput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *GetBackendStorageInput) SetBackendEnvironmentName(v string) *GetBackendStorageInput {
	s.BackendEnvironmentName = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *GetBackendStorageInput) SetResourceName(v string) *GetBackendStorageInput {
	s.ResourceName = &v
	return s
}

type GetBackendStorageOutput struct {
	_ struct{} `type:"structure"`

	AppId *string `locationName:"appId" type:"string"`

	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string"`

	// The details for a backend storage resource.
	ResourceConfig *GetBackendStorageResourceConfig `locationName:"resourceConfig" type:"structure"`

	ResourceName *string `locationName:"resourceName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackendStorageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackendStorageOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *GetBackendStorageOutput) SetAppId(v string) *GetBackendStorageOutput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *GetBackendStorageOutput) SetBackendEnvironmentName(v string) *GetBackendStorageOutput {
	s.BackendEnvironmentName = &v
	return s
}

// SetResourceConfig sets the ResourceConfig field's value.
func (s *GetBackendStorageOutput) SetResourceConfig(v *GetBackendStorageResourceConfig) *GetBackendStorageOutput {
	s.ResourceConfig = v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *GetBackendStorageOutput) SetResourceName(v string) *GetBackendStorageOutput {
	s.ResourceName = &v
	return s
}

// The details for a backend storage resource.
type GetBackendStorageResourceConfig struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket.
	BucketName *string `locationName:"bucketName" type:"string"`

	// Returns True if the storage resource has been imported.
	//
	// Imported is a required field
	Imported *bool `locationName:"imported" type:"boolean" required:"true"`

	// The authorization configuration for the storage S3 bucket.
	Permissions *BackendStoragePermissions `locationName:"permissions" type:"structure"`

	// The name of the storage service.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" type:"string" required:"true" enum:"ServiceName"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackendStorageResourceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackendStorageResourceConfig) GoString() string {
	return s.String()
}

// SetBucketName sets the BucketName field's value.
func (s *GetBackendStorageResourceConfig) SetBucketName(v string) *GetBackendStorageResourceConfig {
	s.BucketName = &v
	return s
}

// SetImported sets the Imported field's value.
func (s *GetBackendStorageResourceConfig) SetImported(v bool) *GetBackendStorageResourceConfig {
	s.Imported = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *GetBackendStorageResourceConfig) SetPermissions(v *BackendStoragePermissions) *GetBackendStorageResourceConfig {
	s.Permissions = v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *GetBackendStorageResourceConfig) SetServiceName(v string) *GetBackendStorageResourceConfig {
	s.ServiceName = &v
	return s
}

type GetTokenInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// SessionId is a required field
	SessionId *string `location:"uri" locationName:"sessionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTokenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTokenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTokenInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *GetTokenInput) SetAppId(v string) *GetTokenInput {
	s.AppId = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *GetTokenInput) SetSessionId(v string) *GetTokenInput {
	s.SessionId = &v
	return s
}

type GetTokenOutput struct {
	_ struct{} `type:"structure"`

	AppId *string `locationName:"appId" type:"string"`

	ChallengeCode *string `locationName:"challengeCode" type:"string"`

	SessionId *string `locationName:"sessionId" type:"string"`

	Ttl *string `locationName:"ttl" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTokenOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *GetTokenOutput) SetAppId(v string) *GetTokenOutput {
	s.AppId = &v
	return s
}

// SetChallengeCode sets the ChallengeCode field's value.
func (s *GetTokenOutput) SetChallengeCode(v string) *GetTokenOutput {
	s.ChallengeCode = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *GetTokenOutput) SetSessionId(v string) *GetTokenOutput {
	s.SessionId = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *GetTokenOutput) SetTtl(v string) *GetTokenOutput {
	s.Ttl = &v
	return s
}

type ImportBackendAuthInput struct {
	_ struct{} `type:"structure"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// BackendEnvironmentName is a required field
	BackendEnvironmentName *string `location:"uri" locationName:"backendEnvironmentName" type:"string" required:"true"`

	IdentityPoolId *string `locationName:"identityPoolId" type:"string"`

	// NativeClientId is a required field
	NativeClientId *string `locationName:"nativeClientId" type:"string" required:"true"`

	// UserPoolId is a required field
	UserPoolId *string `locationName:"userPoolId" type:"string" required:"true"`

	// WebClientId is a required field
	WebClientId *string `locationName:"webClientId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportBackendAuthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportBackendAuthInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportBackendAuthInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportBackendAuthInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BackendEnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackendEnvironmentName"))
	}
	if s.BackendEnvironmentName != nil && len(*s.BackendEnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackendEnvironmentName", 1))
	}
	if s.NativeClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("NativeClientId"))
	}
	if s.UserPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolId"))
	}
	if s.WebClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("WebClientId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *ImportBackendAuthInput) SetAppId(v string) *ImportBackendAuthInput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *ImportBackendAuthInput) SetBackendEnvironmentName(v string) *ImportBackendAuthInput {
	s.BackendEnvironmentName = &v
	return s
}

// SetIdentityPoolId sets the IdentityPoolId field's value.
func (s *ImportBackendAuthInput) SetIdentityPoolId(v string) *ImportBackendAuthInput {
	s.IdentityPoolId = &v
	return s
}

// SetNativeClientId sets the NativeClientId field's value.
func (s *ImportBackendAuthInput) SetNativeClientId(v string) *ImportBackendAuthInput {
	s.NativeClientId = &v
	return s
}

// SetUserPoolId sets the UserPoolId field's value.
func (s *ImportBackendAuthInput) SetUserPoolId(v string) *ImportBackendAuthInput {
	s.UserPoolId = &v
	return s
}

// SetWebClientId sets the WebClientId field's value.
func (s *ImportBackendAuthInput) SetWebClientId(v string) *ImportBackendAuthInput {
	s.WebClientId = &v
	return s
}

type ImportBackendAuthOutput struct {
	_ struct{} `type:"structure"`

	AppId *string `locationName:"appId" type:"string"`

	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string"`

	Error *string `locationName:"error" type:"string"`

	JobId *string `locationName:"jobId" type:"string"`

	Operation *string `locationName:"operation" type:"string"`

	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportBackendAuthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportBackendAuthOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *ImportBackendAuthOutput) SetAppId(v string) *ImportBackendAuthOutput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *ImportBackendAuthOutput) SetBackendEnvironmentName(v string) *ImportBackendAuthOutput {
	s.BackendEnvironmentName = &v
	return s
}

// SetError sets the Error field's value.
func (s *ImportBackendAuthOutput) SetError(v string) *ImportBackendAuthOutput {
	s.Error = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *ImportBackendAuthOutput) SetJobId(v string) *ImportBackendAuthOutput {
	s.JobId = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *ImportBackendAuthOutput) SetOperation(v string) *ImportBackendAuthOutput {
	s.Operation = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ImportBackendAuthOutput) SetStatus(v string) *ImportBackendAuthOutput {
	s.Status = &v
	return s
}

type ImportBackendStorageInput struct {
	_ struct{} `type:"structure"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// BackendEnvironmentName is a required field
	BackendEnvironmentName *string `location:"uri" locationName:"backendEnvironmentName" type:"string" required:"true"`

	BucketName *string `locationName:"bucketName" type:"string"`

	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" type:"string" required:"true" enum:"ServiceName"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportBackendStorageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportBackendStorageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportBackendStorageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportBackendStorageInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BackendEnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackendEnvironmentName"))
	}
	if s.BackendEnvironmentName != nil && len(*s.BackendEnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackendEnvironmentName", 1))
	}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *ImportBackendStorageInput) SetAppId(v string) *ImportBackendStorageInput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *ImportBackendStorageInput) SetBackendEnvironmentName(v string) *ImportBackendStorageInput {
	s.BackendEnvironmentName = &v
	return s
}

// SetBucketName sets the BucketName field's value.
func (s *ImportBackendStorageInput) SetBucketName(v string) *ImportBackendStorageInput {
	s.BucketName = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ImportBackendStorageInput) SetServiceName(v string) *ImportBackendStorageInput {
	s.ServiceName = &v
	return s
}

type ImportBackendStorageOutput struct {
	_ struct{} `type:"structure"`

	AppId *string `locationName:"appId" type:"string"`

	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string"`

	JobId *string `locationName:"jobId" type:"string"`

	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportBackendStorageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportBackendStorageOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *ImportBackendStorageOutput) SetAppId(v string) *ImportBackendStorageOutput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *ImportBackendStorageOutput) SetBackendEnvironmentName(v string) *ImportBackendStorageOutput {
	s.BackendEnvironmentName = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *ImportBackendStorageOutput) SetJobId(v string) *ImportBackendStorageOutput {
	s.JobId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ImportBackendStorageOutput) SetStatus(v string) *ImportBackendStorageOutput {
	s.Status = &v
	return s
}

type ListBackendJobsInput struct {
	_ struct{} `type:"structure"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// BackendEnvironmentName is a required field
	BackendEnvironmentName *string `location:"uri" locationName:"backendEnvironmentName" type:"string" required:"true"`

	JobId *string `locationName:"jobId" type:"string"`

	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `locationName:"nextToken" type:"string"`

	Operation *string `locationName:"operation" type:"string"`

	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackendJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackendJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBackendJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBackendJobsInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BackendEnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackendEnvironmentName"))
	}
	if s.BackendEnvironmentName != nil && len(*s.BackendEnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackendEnvironmentName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *ListBackendJobsInput) SetAppId(v string) *ListBackendJobsInput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *ListBackendJobsInput) SetBackendEnvironmentName(v string) *ListBackendJobsInput {
	s.BackendEnvironmentName = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *ListBackendJobsInput) SetJobId(v string) *ListBackendJobsInput {
	s.JobId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBackendJobsInput) SetMaxResults(v int64) *ListBackendJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBackendJobsInput) SetNextToken(v string) *ListBackendJobsInput {
	s.NextToken = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *ListBackendJobsInput) SetOperation(v string) *ListBackendJobsInput {
	s.Operation = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListBackendJobsInput) SetStatus(v string) *ListBackendJobsInput {
	s.Status = &v
	return s
}

type ListBackendJobsOutput struct {
	_ struct{} `type:"structure"`

	Jobs []*BackendJobRespObj `locationName:"jobs" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackendJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackendJobsOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *ListBackendJobsOutput) SetJobs(v []*BackendJobRespObj) *ListBackendJobsOutput {
	s.Jobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBackendJobsOutput) SetNextToken(v string) *ListBackendJobsOutput {
	s.NextToken = &v
	return s
}

type ListS3BucketsInput struct {
	_ struct{} `type:"structure"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListS3BucketsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListS3BucketsInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListS3BucketsInput) SetNextToken(v string) *ListS3BucketsInput {
	s.NextToken = &v
	return s
}

type ListS3BucketsOutput struct {
	_ struct{} `type:"structure"`

	Buckets []*S3BucketInfo `locationName:"buckets" type:"list"`

	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListS3BucketsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListS3BucketsOutput) GoString() string {
	return s.String()
}

// SetBuckets sets the Buckets field's value.
func (s *ListS3BucketsOutput) SetBuckets(v []*S3BucketInfo) *ListS3BucketsOutput {
	s.Buckets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListS3BucketsOutput) SetNextToken(v string) *ListS3BucketsOutput {
	s.NextToken = &v
	return s
}

// The request object for this operation.
type LoginAuthConfigReqObj struct {
	_ struct{} `type:"structure"`

	// The Amazon Cognito identity pool ID used for the Amplify Admin UI login authorization.
	AwsCognitoIdentityPoolId *string `locationName:"aws_cognito_identity_pool_id" type:"string"`

	// The AWS Region for the Amplify Admin UI login.
	AwsCognitoRegion *string `locationName:"aws_cognito_region" type:"string"`

	// The Amazon Cognito user pool ID used for Amplify Admin UI login authentication.
	AwsUserPoolsId *string `locationName:"aws_user_pools_id" type:"string"`

	// The web client ID for the Amazon Cognito user pools.
	AwsUserPoolsWebClientId *string `locationName:"aws_user_pools_web_client_id" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoginAuthConfigReqObj) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LoginAuthConfigReqObj) GoString() string {
	return s.String()
}

// SetAwsCognitoIdentityPoolId sets the AwsCognitoIdentityPoolId field's value.
func (s *LoginAuthConfigReqObj) SetAwsCognitoIdentityPoolId(v string) *LoginAuthConfigReqObj {
	s.AwsCognitoIdentityPoolId = &v
	return s
}

// SetAwsCognitoRegion sets the AwsCognitoRegion field's value.
func (s *LoginAuthConfigReqObj) SetAwsCognitoRegion(v string) *LoginAuthConfigReqObj {
	s.AwsCognitoRegion = &v
	return s
}

// SetAwsUserPoolsId sets the AwsUserPoolsId field's value.
func (s *LoginAuthConfigReqObj) SetAwsUserPoolsId(v string) *LoginAuthConfigReqObj {
	s.AwsUserPoolsId = &v
	return s
}

// SetAwsUserPoolsWebClientId sets the AwsUserPoolsWebClientId field's value.
func (s *LoginAuthConfigReqObj) SetAwsUserPoolsWebClientId(v string) *LoginAuthConfigReqObj {
	s.AwsUserPoolsWebClientId = &v
	return s
}

// An error returned when a specific resource type is not found.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// An error message to inform that the request has failed.
	Message_ *string `locationName:"message" type:"string"`

	// The type of resource that is not found.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type RemoveAllBackendsInput struct {
	_ struct{} `type:"structure"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	CleanAmplifyApp *bool `locationName:"cleanAmplifyApp" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveAllBackendsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveAllBackendsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveAllBackendsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveAllBackendsInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *RemoveAllBackendsInput) SetAppId(v string) *RemoveAllBackendsInput {
	s.AppId = &v
	return s
}

// SetCleanAmplifyApp sets the CleanAmplifyApp field's value.
func (s *RemoveAllBackendsInput) SetCleanAmplifyApp(v bool) *RemoveAllBackendsInput {
	s.CleanAmplifyApp = &v
	return s
}

type RemoveAllBackendsOutput struct {
	_ struct{} `type:"structure"`

	AppId *string `locationName:"appId" type:"string"`

	Error *string `locationName:"error" type:"string"`

	JobId *string `locationName:"jobId" type:"string"`

	Operation *string `locationName:"operation" type:"string"`

	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveAllBackendsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveAllBackendsOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *RemoveAllBackendsOutput) SetAppId(v string) *RemoveAllBackendsOutput {
	s.AppId = &v
	return s
}

// SetError sets the Error field's value.
func (s *RemoveAllBackendsOutput) SetError(v string) *RemoveAllBackendsOutput {
	s.Error = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *RemoveAllBackendsOutput) SetJobId(v string) *RemoveAllBackendsOutput {
	s.JobId = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *RemoveAllBackendsOutput) SetOperation(v string) *RemoveAllBackendsOutput {
	s.Operation = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RemoveAllBackendsOutput) SetStatus(v string) *RemoveAllBackendsOutput {
	s.Status = &v
	return s
}

type RemoveBackendConfigInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveBackendConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveBackendConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveBackendConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveBackendConfigInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *RemoveBackendConfigInput) SetAppId(v string) *RemoveBackendConfigInput {
	s.AppId = &v
	return s
}

type RemoveBackendConfigOutput struct {
	_ struct{} `type:"structure"`

	Error *string `locationName:"error" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveBackendConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoveBackendConfigOutput) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *RemoveBackendConfigOutput) SetError(v string) *RemoveBackendConfigOutput {
	s.Error = &v
	return s
}

type ResourceConfig struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceConfig) GoString() string {
	return s.String()
}

// Describes the metadata of the S3 bucket.
type S3BucketInfo struct {
	_ struct{} `type:"structure"`

	// The creation date of the S3 bucket.
	CreationDate *string `locationName:"creationDate" type:"string"`

	// The name of the S3 bucket.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3BucketInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3BucketInfo) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *S3BucketInfo) SetCreationDate(v string) *S3BucketInfo {
	s.CreationDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *S3BucketInfo) SetName(v string) *S3BucketInfo {
	s.Name = &v
	return s
}

type Settings struct {
	_ struct{} `type:"structure"`

	MfaTypes []*string `locationName:"mfaTypes" type:"list" enum:"MfaTypesElement"`

	// The body of the SMS message.
	SmsMessage *string `locationName:"smsMessage" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Settings) GoString() string {
	return s.String()
}

// SetMfaTypes sets the MfaTypes field's value.
func (s *Settings) SetMfaTypes(v []*string) *Settings {
	s.MfaTypes = v
	return s
}

// SetSmsMessage sets the SmsMessage field's value.
func (s *Settings) SetSmsMessage(v string) *Settings {
	s.SmsMessage = &v
	return s
}

// The settings for the SMS message.
type SmsSettings struct {
	_ struct{} `type:"structure"`

	// The contents of the SMS message.
	SmsMessage *string `locationName:"smsMessage" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SmsSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SmsSettings) GoString() string {
	return s.String()
}

// SetSmsMessage sets the SmsMessage field's value.
func (s *SmsSettings) SetSmsMessage(v string) *SmsSettings {
	s.SmsMessage = &v
	return s
}

type SocialProviderSettings struct {
	_ struct{} `type:"structure"`

	// Describes third-party social federation configurations for allowing your
	// app users to sign in using OAuth.
	Facebook *BackendAuthSocialProviderConfig `type:"structure"`

	// Describes third-party social federation configurations for allowing your
	// app users to sign in using OAuth.
	Google *BackendAuthSocialProviderConfig `type:"structure"`

	// Describes third-party social federation configurations for allowing your
	// app users to sign in using OAuth.
	LoginWithAmazon *BackendAuthSocialProviderConfig `type:"structure"`

	// Describes Apple social federation configurations for allowing your app users
	// to sign in using OAuth.
	SignInWithApple *BackendAuthAppleProviderConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SocialProviderSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SocialProviderSettings) GoString() string {
	return s.String()
}

// SetFacebook sets the Facebook field's value.
func (s *SocialProviderSettings) SetFacebook(v *BackendAuthSocialProviderConfig) *SocialProviderSettings {
	s.Facebook = v
	return s
}

// SetGoogle sets the Google field's value.
func (s *SocialProviderSettings) SetGoogle(v *BackendAuthSocialProviderConfig) *SocialProviderSettings {
	s.Google = v
	return s
}

// SetLoginWithAmazon sets the LoginWithAmazon field's value.
func (s *SocialProviderSettings) SetLoginWithAmazon(v *BackendAuthSocialProviderConfig) *SocialProviderSettings {
	s.LoginWithAmazon = v
	return s
}

// SetSignInWithApple sets the SignInWithApple field's value.
func (s *SocialProviderSettings) SetSignInWithApple(v *BackendAuthAppleProviderConfig) *SocialProviderSettings {
	s.SignInWithApple = v
	return s
}

// An error that is returned when a limit of a specific type has been exceeded.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	LimitType *string `locationName:"limitType" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateBackendAPIInput struct {
	_ struct{} `type:"structure"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// BackendEnvironmentName is a required field
	BackendEnvironmentName *string `location:"uri" locationName:"backendEnvironmentName" type:"string" required:"true"`

	// The resource config for the data model, configured as a part of the Amplify
	// project.
	ResourceConfig *BackendAPIResourceConfig `locationName:"resourceConfig" type:"structure"`

	// ResourceName is a required field
	ResourceName *string `locationName:"resourceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendAPIInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendAPIInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBackendAPIInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBackendAPIInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BackendEnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackendEnvironmentName"))
	}
	if s.BackendEnvironmentName != nil && len(*s.BackendEnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackendEnvironmentName", 1))
	}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *UpdateBackendAPIInput) SetAppId(v string) *UpdateBackendAPIInput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *UpdateBackendAPIInput) SetBackendEnvironmentName(v string) *UpdateBackendAPIInput {
	s.BackendEnvironmentName = &v
	return s
}

// SetResourceConfig sets the ResourceConfig field's value.
func (s *UpdateBackendAPIInput) SetResourceConfig(v *BackendAPIResourceConfig) *UpdateBackendAPIInput {
	s.ResourceConfig = v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *UpdateBackendAPIInput) SetResourceName(v string) *UpdateBackendAPIInput {
	s.ResourceName = &v
	return s
}

type UpdateBackendAPIOutput struct {
	_ struct{} `type:"structure"`

	AppId *string `locationName:"appId" type:"string"`

	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string"`

	Error *string `locationName:"error" type:"string"`

	JobId *string `locationName:"jobId" type:"string"`

	Operation *string `locationName:"operation" type:"string"`

	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendAPIOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendAPIOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *UpdateBackendAPIOutput) SetAppId(v string) *UpdateBackendAPIOutput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *UpdateBackendAPIOutput) SetBackendEnvironmentName(v string) *UpdateBackendAPIOutput {
	s.BackendEnvironmentName = &v
	return s
}

// SetError sets the Error field's value.
func (s *UpdateBackendAPIOutput) SetError(v string) *UpdateBackendAPIOutput {
	s.Error = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *UpdateBackendAPIOutput) SetJobId(v string) *UpdateBackendAPIOutput {
	s.JobId = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *UpdateBackendAPIOutput) SetOperation(v string) *UpdateBackendAPIOutput {
	s.Operation = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateBackendAPIOutput) SetStatus(v string) *UpdateBackendAPIOutput {
	s.Status = &v
	return s
}

// (DEPRECATED) Describes the forgot password policy for authenticating into
// the Amplify app.
type UpdateBackendAuthForgotPasswordConfig struct {
	_ struct{} `type:"structure"`

	// (DEPRECATED) Describes which mode to use (either SMS or email) to deliver
	// messages to app users that want to recover their password.
	DeliveryMethod *string `locationName:"deliveryMethod" type:"string" enum:"DeliveryMethod"`

	// (DEPRECATED) The configuration for the email sent when an app user forgets
	// their password.
	EmailSettings *EmailSettings `locationName:"emailSettings" type:"structure"`

	// (DEPRECATED) The configuration for the SMS message sent when an Amplify app
	// user forgets their password.
	SmsSettings *SmsSettings `locationName:"smsSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendAuthForgotPasswordConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendAuthForgotPasswordConfig) GoString() string {
	return s.String()
}

// SetDeliveryMethod sets the DeliveryMethod field's value.
func (s *UpdateBackendAuthForgotPasswordConfig) SetDeliveryMethod(v string) *UpdateBackendAuthForgotPasswordConfig {
	s.DeliveryMethod = &v
	return s
}

// SetEmailSettings sets the EmailSettings field's value.
func (s *UpdateBackendAuthForgotPasswordConfig) SetEmailSettings(v *EmailSettings) *UpdateBackendAuthForgotPasswordConfig {
	s.EmailSettings = v
	return s
}

// SetSmsSettings sets the SmsSettings field's value.
func (s *UpdateBackendAuthForgotPasswordConfig) SetSmsSettings(v *SmsSettings) *UpdateBackendAuthForgotPasswordConfig {
	s.SmsSettings = v
	return s
}

// Describes the authorization configuration for the Amazon Cognito identity
// pool, provisioned as a part of your auth resource in the Amplify project.
type UpdateBackendAuthIdentityPoolConfig struct {
	_ struct{} `type:"structure"`

	// A boolean value that can be set to allow or disallow guest-level authorization
	// into your Amplify app.
	UnauthenticatedLogin *bool `locationName:"unauthenticatedLogin" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendAuthIdentityPoolConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendAuthIdentityPoolConfig) GoString() string {
	return s.String()
}

// SetUnauthenticatedLogin sets the UnauthenticatedLogin field's value.
func (s *UpdateBackendAuthIdentityPoolConfig) SetUnauthenticatedLogin(v bool) *UpdateBackendAuthIdentityPoolConfig {
	s.UnauthenticatedLogin = &v
	return s
}

type UpdateBackendAuthInput struct {
	_ struct{} `type:"structure"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// BackendEnvironmentName is a required field
	BackendEnvironmentName *string `location:"uri" locationName:"backendEnvironmentName" type:"string" required:"true"`

	// Defines the resource configuration when updating an authentication resource
	// in your Amplify project.
	//
	// ResourceConfig is a required field
	ResourceConfig *UpdateBackendAuthResourceConfig `locationName:"resourceConfig" type:"structure" required:"true"`

	// ResourceName is a required field
	ResourceName *string `locationName:"resourceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendAuthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendAuthInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBackendAuthInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBackendAuthInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BackendEnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackendEnvironmentName"))
	}
	if s.BackendEnvironmentName != nil && len(*s.BackendEnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackendEnvironmentName", 1))
	}
	if s.ResourceConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceConfig"))
	}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.ResourceConfig != nil {
		if err := s.ResourceConfig.Validate(); err != nil {
			invalidParams.AddNested("ResourceConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *UpdateBackendAuthInput) SetAppId(v string) *UpdateBackendAuthInput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *UpdateBackendAuthInput) SetBackendEnvironmentName(v string) *UpdateBackendAuthInput {
	s.BackendEnvironmentName = &v
	return s
}

// SetResourceConfig sets the ResourceConfig field's value.
func (s *UpdateBackendAuthInput) SetResourceConfig(v *UpdateBackendAuthResourceConfig) *UpdateBackendAuthInput {
	s.ResourceConfig = v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *UpdateBackendAuthInput) SetResourceName(v string) *UpdateBackendAuthInput {
	s.ResourceName = &v
	return s
}

// Updates the multi-factor authentication (MFA) configuration for the backend
// of your Amplify project.
type UpdateBackendAuthMFAConfig struct {
	_ struct{} `type:"structure"`

	// The MFA mode for the backend of your Amplify project.
	MFAMode *string `type:"string" enum:"MFAMode"`

	// The settings of your MFA configuration for the backend of your Amplify project.
	Settings *Settings `locationName:"settings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendAuthMFAConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendAuthMFAConfig) GoString() string {
	return s.String()
}

// SetMFAMode sets the MFAMode field's value.
func (s *UpdateBackendAuthMFAConfig) SetMFAMode(v string) *UpdateBackendAuthMFAConfig {
	s.MFAMode = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *UpdateBackendAuthMFAConfig) SetSettings(v *Settings) *UpdateBackendAuthMFAConfig {
	s.Settings = v
	return s
}

// The OAuth configurations for authenticating users into your Amplify app.
type UpdateBackendAuthOAuthConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Cognito domain prefix used to create a hosted UI for authentication.
	DomainPrefix *string `locationName:"domainPrefix" type:"string"`

	// The OAuth grant type to allow app users to authenticate from your Amplify
	// app.
	OAuthGrantType *string `locationName:"oAuthGrantType" type:"string" enum:"OAuthGrantType"`

	// The list of OAuth-related flows that can allow users to authenticate from
	// your Amplify app.
	OAuthScopes []*string `locationName:"oAuthScopes" type:"list" enum:"OAuthScopesElement"`

	// Redirect URLs that OAuth uses when a user signs in to an Amplify app.
	RedirectSignInURIs []*string `locationName:"redirectSignInURIs" type:"list"`

	// Redirect URLs that OAuth uses when a user signs out of an Amplify app.
	RedirectSignOutURIs []*string `locationName:"redirectSignOutURIs" type:"list"`

	// Describes third-party social federation configurations for allowing your
	// users to sign in with OAuth.
	SocialProviderSettings *SocialProviderSettings `locationName:"socialProviderSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendAuthOAuthConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendAuthOAuthConfig) GoString() string {
	return s.String()
}

// SetDomainPrefix sets the DomainPrefix field's value.
func (s *UpdateBackendAuthOAuthConfig) SetDomainPrefix(v string) *UpdateBackendAuthOAuthConfig {
	s.DomainPrefix = &v
	return s
}

// SetOAuthGrantType sets the OAuthGrantType field's value.
func (s *UpdateBackendAuthOAuthConfig) SetOAuthGrantType(v string) *UpdateBackendAuthOAuthConfig {
	s.OAuthGrantType = &v
	return s
}

// SetOAuthScopes sets the OAuthScopes field's value.
func (s *UpdateBackendAuthOAuthConfig) SetOAuthScopes(v []*string) *UpdateBackendAuthOAuthConfig {
	s.OAuthScopes = v
	return s
}

// SetRedirectSignInURIs sets the RedirectSignInURIs field's value.
func (s *UpdateBackendAuthOAuthConfig) SetRedirectSignInURIs(v []*string) *UpdateBackendAuthOAuthConfig {
	s.RedirectSignInURIs = v
	return s
}

// SetRedirectSignOutURIs sets the RedirectSignOutURIs field's value.
func (s *UpdateBackendAuthOAuthConfig) SetRedirectSignOutURIs(v []*string) *UpdateBackendAuthOAuthConfig {
	s.RedirectSignOutURIs = v
	return s
}

// SetSocialProviderSettings sets the SocialProviderSettings field's value.
func (s *UpdateBackendAuthOAuthConfig) SetSocialProviderSettings(v *SocialProviderSettings) *UpdateBackendAuthOAuthConfig {
	s.SocialProviderSettings = v
	return s
}

type UpdateBackendAuthOutput struct {
	_ struct{} `type:"structure"`

	AppId *string `locationName:"appId" type:"string"`

	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string"`

	Error *string `locationName:"error" type:"string"`

	JobId *string `locationName:"jobId" type:"string"`

	Operation *string `locationName:"operation" type:"string"`

	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendAuthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendAuthOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *UpdateBackendAuthOutput) SetAppId(v string) *UpdateBackendAuthOutput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *UpdateBackendAuthOutput) SetBackendEnvironmentName(v string) *UpdateBackendAuthOutput {
	s.BackendEnvironmentName = &v
	return s
}

// SetError sets the Error field's value.
func (s *UpdateBackendAuthOutput) SetError(v string) *UpdateBackendAuthOutput {
	s.Error = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *UpdateBackendAuthOutput) SetJobId(v string) *UpdateBackendAuthOutput {
	s.JobId = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *UpdateBackendAuthOutput) SetOperation(v string) *UpdateBackendAuthOutput {
	s.Operation = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateBackendAuthOutput) SetStatus(v string) *UpdateBackendAuthOutput {
	s.Status = &v
	return s
}

// Describes the password policy for your Amazon Cognito user pool configured
// as a part of your Amplify project.
type UpdateBackendAuthPasswordPolicyConfig struct {
	_ struct{} `type:"structure"`

	// Describes additional constraints on password requirements to sign in to the
	// auth resource, configured as a part of your Amplify project.
	AdditionalConstraints []*string `locationName:"additionalConstraints" type:"list" enum:"AdditionalConstraintsElement"`

	// Describes the minimum length of the password required to sign in to the auth
	// resource, configured as a part of your Amplify project.
	MinimumLength *float64 `locationName:"minimumLength" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendAuthPasswordPolicyConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendAuthPasswordPolicyConfig) GoString() string {
	return s.String()
}

// SetAdditionalConstraints sets the AdditionalConstraints field's value.
func (s *UpdateBackendAuthPasswordPolicyConfig) SetAdditionalConstraints(v []*string) *UpdateBackendAuthPasswordPolicyConfig {
	s.AdditionalConstraints = v
	return s
}

// SetMinimumLength sets the MinimumLength field's value.
func (s *UpdateBackendAuthPasswordPolicyConfig) SetMinimumLength(v float64) *UpdateBackendAuthPasswordPolicyConfig {
	s.MinimumLength = &v
	return s
}

// Defines the resource configuration when updating an authentication resource
// in your Amplify project.
type UpdateBackendAuthResourceConfig struct {
	_ struct{} `type:"structure"`

	// Defines the service name to use when configuring an authentication resource
	// in your Amplify project.
	//
	// AuthResources is a required field
	AuthResources *string `locationName:"authResources" type:"string" required:"true" enum:"AuthResources"`

	// Describes the authorization configuration for the Amazon Cognito identity
	// pool, provisioned as a part of your auth resource in the Amplify project.
	IdentityPoolConfigs *UpdateBackendAuthIdentityPoolConfig `locationName:"identityPoolConfigs" type:"structure"`

	// Defines the service name to use when configuring an authentication resource
	// in your Amplify project.
	//
	// Service is a required field
	Service *string `locationName:"service" type:"string" required:"true" enum:"Service"`

	// Describes the authentication configuration for the Amazon Cognito user pool,
	// provisioned as a part of your auth resource in the Amplify project.
	//
	// UserPoolConfigs is a required field
	UserPoolConfigs *UpdateBackendAuthUserPoolConfig `locationName:"userPoolConfigs" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendAuthResourceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendAuthResourceConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBackendAuthResourceConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBackendAuthResourceConfig"}
	if s.AuthResources == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthResources"))
	}
	if s.Service == nil {
		invalidParams.Add(request.NewErrParamRequired("Service"))
	}
	if s.UserPoolConfigs == nil {
		invalidParams.Add(request.NewErrParamRequired("UserPoolConfigs"))
	}
	if s.UserPoolConfigs != nil {
		if err := s.UserPoolConfigs.Validate(); err != nil {
			invalidParams.AddNested("UserPoolConfigs", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthResources sets the AuthResources field's value.
func (s *UpdateBackendAuthResourceConfig) SetAuthResources(v string) *UpdateBackendAuthResourceConfig {
	s.AuthResources = &v
	return s
}

// SetIdentityPoolConfigs sets the IdentityPoolConfigs field's value.
func (s *UpdateBackendAuthResourceConfig) SetIdentityPoolConfigs(v *UpdateBackendAuthIdentityPoolConfig) *UpdateBackendAuthResourceConfig {
	s.IdentityPoolConfigs = v
	return s
}

// SetService sets the Service field's value.
func (s *UpdateBackendAuthResourceConfig) SetService(v string) *UpdateBackendAuthResourceConfig {
	s.Service = &v
	return s
}

// SetUserPoolConfigs sets the UserPoolConfigs field's value.
func (s *UpdateBackendAuthResourceConfig) SetUserPoolConfigs(v *UpdateBackendAuthUserPoolConfig) *UpdateBackendAuthResourceConfig {
	s.UserPoolConfigs = v
	return s
}

// Describes the Amazon Cognito user pool configuration for the authorization
// resource to be configured for your Amplify project on an update.
type UpdateBackendAuthUserPoolConfig struct {
	_ struct{} `type:"structure"`

	// (DEPRECATED) Describes the forgot password policy for your Amazon Cognito
	// user pool, configured as a part of your Amplify project.
	ForgotPassword *UpdateBackendAuthForgotPasswordConfig `locationName:"forgotPassword" type:"structure"`

	// Describes whether to apply multi-factor authentication policies for your
	// Amazon Cognito user pool configured as a part of your Amplify project.
	Mfa *UpdateBackendAuthMFAConfig `locationName:"mfa" type:"structure"`

	// Describes the OAuth policy and rules for your Amazon Cognito user pool, configured
	// as a part of your Amplify project.
	OAuth *UpdateBackendAuthOAuthConfig `locationName:"oAuth" type:"structure"`

	// Describes the password policy for your Amazon Cognito user pool, configured
	// as a part of your Amplify project.
	PasswordPolicy *UpdateBackendAuthPasswordPolicyConfig `locationName:"passwordPolicy" type:"structure"`

	// Describes the email or SMS verification message for your Amazon Cognito user
	// pool, configured as a part of your Amplify project.
	VerificationMessage *UpdateBackendAuthVerificationMessageConfig `locationName:"verificationMessage" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendAuthUserPoolConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendAuthUserPoolConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBackendAuthUserPoolConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBackendAuthUserPoolConfig"}
	if s.VerificationMessage != nil {
		if err := s.VerificationMessage.Validate(); err != nil {
			invalidParams.AddNested("VerificationMessage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForgotPassword sets the ForgotPassword field's value.
func (s *UpdateBackendAuthUserPoolConfig) SetForgotPassword(v *UpdateBackendAuthForgotPasswordConfig) *UpdateBackendAuthUserPoolConfig {
	s.ForgotPassword = v
	return s
}

// SetMfa sets the Mfa field's value.
func (s *UpdateBackendAuthUserPoolConfig) SetMfa(v *UpdateBackendAuthMFAConfig) *UpdateBackendAuthUserPoolConfig {
	s.Mfa = v
	return s
}

// SetOAuth sets the OAuth field's value.
func (s *UpdateBackendAuthUserPoolConfig) SetOAuth(v *UpdateBackendAuthOAuthConfig) *UpdateBackendAuthUserPoolConfig {
	s.OAuth = v
	return s
}

// SetPasswordPolicy sets the PasswordPolicy field's value.
func (s *UpdateBackendAuthUserPoolConfig) SetPasswordPolicy(v *UpdateBackendAuthPasswordPolicyConfig) *UpdateBackendAuthUserPoolConfig {
	s.PasswordPolicy = v
	return s
}

// SetVerificationMessage sets the VerificationMessage field's value.
func (s *UpdateBackendAuthUserPoolConfig) SetVerificationMessage(v *UpdateBackendAuthVerificationMessageConfig) *UpdateBackendAuthUserPoolConfig {
	s.VerificationMessage = v
	return s
}

// Updates the configuration of the email or SMS message for the auth resource
// configured for your Amplify project.
type UpdateBackendAuthVerificationMessageConfig struct {
	_ struct{} `type:"structure"`

	// The type of verification message to send.
	//
	// DeliveryMethod is a required field
	DeliveryMethod *string `locationName:"deliveryMethod" type:"string" required:"true" enum:"DeliveryMethod"`

	// The settings for the email message.
	EmailSettings *EmailSettings `locationName:"emailSettings" type:"structure"`

	// The settings for the SMS message.
	SmsSettings *SmsSettings `locationName:"smsSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendAuthVerificationMessageConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendAuthVerificationMessageConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBackendAuthVerificationMessageConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBackendAuthVerificationMessageConfig"}
	if s.DeliveryMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryMethod"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryMethod sets the DeliveryMethod field's value.
func (s *UpdateBackendAuthVerificationMessageConfig) SetDeliveryMethod(v string) *UpdateBackendAuthVerificationMessageConfig {
	s.DeliveryMethod = &v
	return s
}

// SetEmailSettings sets the EmailSettings field's value.
func (s *UpdateBackendAuthVerificationMessageConfig) SetEmailSettings(v *EmailSettings) *UpdateBackendAuthVerificationMessageConfig {
	s.EmailSettings = v
	return s
}

// SetSmsSettings sets the SmsSettings field's value.
func (s *UpdateBackendAuthVerificationMessageConfig) SetSmsSettings(v *SmsSettings) *UpdateBackendAuthVerificationMessageConfig {
	s.SmsSettings = v
	return s
}

type UpdateBackendConfigInput struct {
	_ struct{} `type:"structure"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// The request object for this operation.
	LoginAuthConfig *LoginAuthConfigReqObj `locationName:"loginAuthConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBackendConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBackendConfigInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *UpdateBackendConfigInput) SetAppId(v string) *UpdateBackendConfigInput {
	s.AppId = &v
	return s
}

// SetLoginAuthConfig sets the LoginAuthConfig field's value.
func (s *UpdateBackendConfigInput) SetLoginAuthConfig(v *LoginAuthConfigReqObj) *UpdateBackendConfigInput {
	s.LoginAuthConfig = v
	return s
}

type UpdateBackendConfigOutput struct {
	_ struct{} `type:"structure"`

	AppId *string `locationName:"appId" type:"string"`

	BackendManagerAppId *string `locationName:"backendManagerAppId" type:"string"`

	Error *string `locationName:"error" type:"string"`

	// The request object for this operation.
	LoginAuthConfig *LoginAuthConfigReqObj `locationName:"loginAuthConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendConfigOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *UpdateBackendConfigOutput) SetAppId(v string) *UpdateBackendConfigOutput {
	s.AppId = &v
	return s
}

// SetBackendManagerAppId sets the BackendManagerAppId field's value.
func (s *UpdateBackendConfigOutput) SetBackendManagerAppId(v string) *UpdateBackendConfigOutput {
	s.BackendManagerAppId = &v
	return s
}

// SetError sets the Error field's value.
func (s *UpdateBackendConfigOutput) SetError(v string) *UpdateBackendConfigOutput {
	s.Error = &v
	return s
}

// SetLoginAuthConfig sets the LoginAuthConfig field's value.
func (s *UpdateBackendConfigOutput) SetLoginAuthConfig(v *LoginAuthConfigReqObj) *UpdateBackendConfigOutput {
	s.LoginAuthConfig = v
	return s
}

type UpdateBackendJobInput struct {
	_ struct{} `type:"structure"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// BackendEnvironmentName is a required field
	BackendEnvironmentName *string `location:"uri" locationName:"backendEnvironmentName" type:"string" required:"true"`

	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	Operation *string `locationName:"operation" type:"string"`

	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBackendJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBackendJobInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BackendEnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackendEnvironmentName"))
	}
	if s.BackendEnvironmentName != nil && len(*s.BackendEnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackendEnvironmentName", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *UpdateBackendJobInput) SetAppId(v string) *UpdateBackendJobInput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *UpdateBackendJobInput) SetBackendEnvironmentName(v string) *UpdateBackendJobInput {
	s.BackendEnvironmentName = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *UpdateBackendJobInput) SetJobId(v string) *UpdateBackendJobInput {
	s.JobId = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *UpdateBackendJobInput) SetOperation(v string) *UpdateBackendJobInput {
	s.Operation = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateBackendJobInput) SetStatus(v string) *UpdateBackendJobInput {
	s.Status = &v
	return s
}

type UpdateBackendJobOutput struct {
	_ struct{} `type:"structure"`

	AppId *string `locationName:"appId" type:"string"`

	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string"`

	CreateTime *string `locationName:"createTime" type:"string"`

	Error *string `locationName:"error" type:"string"`

	JobId *string `locationName:"jobId" type:"string"`

	Operation *string `locationName:"operation" type:"string"`

	Status *string `locationName:"status" type:"string"`

	UpdateTime *string `locationName:"updateTime" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendJobOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *UpdateBackendJobOutput) SetAppId(v string) *UpdateBackendJobOutput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *UpdateBackendJobOutput) SetBackendEnvironmentName(v string) *UpdateBackendJobOutput {
	s.BackendEnvironmentName = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *UpdateBackendJobOutput) SetCreateTime(v string) *UpdateBackendJobOutput {
	s.CreateTime = &v
	return s
}

// SetError sets the Error field's value.
func (s *UpdateBackendJobOutput) SetError(v string) *UpdateBackendJobOutput {
	s.Error = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *UpdateBackendJobOutput) SetJobId(v string) *UpdateBackendJobOutput {
	s.JobId = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *UpdateBackendJobOutput) SetOperation(v string) *UpdateBackendJobOutput {
	s.Operation = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateBackendJobOutput) SetStatus(v string) *UpdateBackendJobOutput {
	s.Status = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *UpdateBackendJobOutput) SetUpdateTime(v string) *UpdateBackendJobOutput {
	s.UpdateTime = &v
	return s
}

type UpdateBackendStorageInput struct {
	_ struct{} `type:"structure"`

	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" type:"string" required:"true"`

	// BackendEnvironmentName is a required field
	BackendEnvironmentName *string `location:"uri" locationName:"backendEnvironmentName" type:"string" required:"true"`

	// The resource configuration for updating backend storage.
	//
	// ResourceConfig is a required field
	ResourceConfig *UpdateBackendStorageResourceConfig `locationName:"resourceConfig" type:"structure" required:"true"`

	// ResourceName is a required field
	ResourceName *string `locationName:"resourceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendStorageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendStorageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBackendStorageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBackendStorageInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AppId", 1))
	}
	if s.BackendEnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackendEnvironmentName"))
	}
	if s.BackendEnvironmentName != nil && len(*s.BackendEnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackendEnvironmentName", 1))
	}
	if s.ResourceConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceConfig"))
	}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.ResourceConfig != nil {
		if err := s.ResourceConfig.Validate(); err != nil {
			invalidParams.AddNested("ResourceConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *UpdateBackendStorageInput) SetAppId(v string) *UpdateBackendStorageInput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *UpdateBackendStorageInput) SetBackendEnvironmentName(v string) *UpdateBackendStorageInput {
	s.BackendEnvironmentName = &v
	return s
}

// SetResourceConfig sets the ResourceConfig field's value.
func (s *UpdateBackendStorageInput) SetResourceConfig(v *UpdateBackendStorageResourceConfig) *UpdateBackendStorageInput {
	s.ResourceConfig = v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *UpdateBackendStorageInput) SetResourceName(v string) *UpdateBackendStorageInput {
	s.ResourceName = &v
	return s
}

type UpdateBackendStorageOutput struct {
	_ struct{} `type:"structure"`

	AppId *string `locationName:"appId" type:"string"`

	BackendEnvironmentName *string `locationName:"backendEnvironmentName" type:"string"`

	JobId *string `locationName:"jobId" type:"string"`

	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendStorageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendStorageOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *UpdateBackendStorageOutput) SetAppId(v string) *UpdateBackendStorageOutput {
	s.AppId = &v
	return s
}

// SetBackendEnvironmentName sets the BackendEnvironmentName field's value.
func (s *UpdateBackendStorageOutput) SetBackendEnvironmentName(v string) *UpdateBackendStorageOutput {
	s.BackendEnvironmentName = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *UpdateBackendStorageOutput) SetJobId(v string) *UpdateBackendStorageOutput {
	s.JobId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateBackendStorageOutput) SetStatus(v string) *UpdateBackendStorageOutput {
	s.Status = &v
	return s
}

// The resource configuration for updating backend storage.
type UpdateBackendStorageResourceConfig struct {
	_ struct{} `type:"structure"`

	// The authorization configuration for the storage S3 bucket.
	//
	// Permissions is a required field
	Permissions *BackendStoragePermissions `locationName:"permissions" type:"structure" required:"true"`

	// The name of the storage service.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" type:"string" required:"true" enum:"ServiceName"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendStorageResourceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackendStorageResourceConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBackendStorageResourceConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBackendStorageResourceConfig"}
	if s.Permissions == nil {
		invalidParams.Add(request.NewErrParamRequired("Permissions"))
	}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.Permissions != nil {
		if err := s.Permissions.Validate(); err != nil {
			invalidParams.AddNested("Permissions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPermissions sets the Permissions field's value.
func (s *UpdateBackendStorageResourceConfig) SetPermissions(v *BackendStoragePermissions) *UpdateBackendStorageResourceConfig {
	s.Permissions = v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *UpdateBackendStorageResourceConfig) SetServiceName(v string) *UpdateBackendStorageResourceConfig {
	s.ServiceName = &v
	return s
}

const (
	// AdditionalConstraintsElementRequireDigit is a AdditionalConstraintsElement enum value
	AdditionalConstraintsElementRequireDigit = "REQUIRE_DIGIT"

	// AdditionalConstraintsElementRequireLowercase is a AdditionalConstraintsElement enum value
	AdditionalConstraintsElementRequireLowercase = "REQUIRE_LOWERCASE"

	// AdditionalConstraintsElementRequireSymbol is a AdditionalConstraintsElement enum value
	AdditionalConstraintsElementRequireSymbol = "REQUIRE_SYMBOL"

	// AdditionalConstraintsElementRequireUppercase is a AdditionalConstraintsElement enum value
	AdditionalConstraintsElementRequireUppercase = "REQUIRE_UPPERCASE"
)

// AdditionalConstraintsElement_Values returns all elements of the AdditionalConstraintsElement enum
func AdditionalConstraintsElement_Values() []string {
	return []string{
		AdditionalConstraintsElementRequireDigit,
		AdditionalConstraintsElementRequireLowercase,
		AdditionalConstraintsElementRequireSymbol,
		AdditionalConstraintsElementRequireUppercase,
	}
}

const (
	// AuthResourcesUserPoolOnly is a AuthResources enum value
	AuthResourcesUserPoolOnly = "USER_POOL_ONLY"

	// AuthResourcesIdentityPoolAndUserPool is a AuthResources enum value
	AuthResourcesIdentityPoolAndUserPool = "IDENTITY_POOL_AND_USER_POOL"
)

// AuthResources_Values returns all elements of the AuthResources enum
func AuthResources_Values() []string {
	return []string{
		AuthResourcesUserPoolOnly,
		AuthResourcesIdentityPoolAndUserPool,
	}
}

const (
	// AuthenticatedElementRead is a AuthenticatedElement enum value
	AuthenticatedElementRead = "READ"

	// AuthenticatedElementCreateAndUpdate is a AuthenticatedElement enum value
	AuthenticatedElementCreateAndUpdate = "CREATE_AND_UPDATE"

	// AuthenticatedElementDelete is a AuthenticatedElement enum value
	AuthenticatedElementDelete = "DELETE"
)

// AuthenticatedElement_Values returns all elements of the AuthenticatedElement enum
func AuthenticatedElement_Values() []string {
	return []string{
		AuthenticatedElementRead,
		AuthenticatedElementCreateAndUpdate,
		AuthenticatedElementDelete,
	}
}

// The type of verification message to send.
const (
	// DeliveryMethodEmail is a DeliveryMethod enum value
	DeliveryMethodEmail = "EMAIL"

	// DeliveryMethodSms is a DeliveryMethod enum value
	DeliveryMethodSms = "SMS"
)

// DeliveryMethod_Values returns all elements of the DeliveryMethod enum
func DeliveryMethod_Values() []string {
	return []string{
		DeliveryMethodEmail,
		DeliveryMethodSms,
	}
}

const (
	// MFAModeOn is a MFAMode enum value
	MFAModeOn = "ON"

	// MFAModeOff is a MFAMode enum value
	MFAModeOff = "OFF"

	// MFAModeOptional is a MFAMode enum value
	MFAModeOptional = "OPTIONAL"
)

// MFAMode_Values returns all elements of the MFAMode enum
func MFAMode_Values() []string {
	return []string{
		MFAModeOn,
		MFAModeOff,
		MFAModeOptional,
	}
}

const (
	// MfaTypesElementSms is a MfaTypesElement enum value
	MfaTypesElementSms = "SMS"

	// MfaTypesElementTotp is a MfaTypesElement enum value
	MfaTypesElementTotp = "TOTP"
)

// MfaTypesElement_Values returns all elements of the MfaTypesElement enum
func MfaTypesElement_Values() []string {
	return []string{
		MfaTypesElementSms,
		MfaTypesElementTotp,
	}
}

const (
	// ModeApiKey is a Mode enum value
	ModeApiKey = "API_KEY"

	// ModeAwsIam is a Mode enum value
	ModeAwsIam = "AWS_IAM"

	// ModeAmazonCognitoUserPools is a Mode enum value
	ModeAmazonCognitoUserPools = "AMAZON_COGNITO_USER_POOLS"

	// ModeOpenidConnect is a Mode enum value
	ModeOpenidConnect = "OPENID_CONNECT"
)

// Mode_Values returns all elements of the Mode enum
func Mode_Values() []string {
	return []string{
		ModeApiKey,
		ModeAwsIam,
		ModeAmazonCognitoUserPools,
		ModeOpenidConnect,
	}
}

const (
	// OAuthGrantTypeCode is a OAuthGrantType enum value
	OAuthGrantTypeCode = "CODE"

	// OAuthGrantTypeImplicit is a OAuthGrantType enum value
	OAuthGrantTypeImplicit = "IMPLICIT"
)

// OAuthGrantType_Values returns all elements of the OAuthGrantType enum
func OAuthGrantType_Values() []string {
	return []string{
		OAuthGrantTypeCode,
		OAuthGrantTypeImplicit,
	}
}

const (
	// OAuthScopesElementPhone is a OAuthScopesElement enum value
	OAuthScopesElementPhone = "PHONE"

	// OAuthScopesElementEmail is a OAuthScopesElement enum value
	OAuthScopesElementEmail = "EMAIL"

	// OAuthScopesElementOpenid is a OAuthScopesElement enum value
	OAuthScopesElementOpenid = "OPENID"

	// OAuthScopesElementProfile is a OAuthScopesElement enum value
	OAuthScopesElementProfile = "PROFILE"

	// OAuthScopesElementAwsCognitoSigninUserAdmin is a OAuthScopesElement enum value
	OAuthScopesElementAwsCognitoSigninUserAdmin = "AWS_COGNITO_SIGNIN_USER_ADMIN"
)

// OAuthScopesElement_Values returns all elements of the OAuthScopesElement enum
func OAuthScopesElement_Values() []string {
	return []string{
		OAuthScopesElementPhone,
		OAuthScopesElementEmail,
		OAuthScopesElementOpenid,
		OAuthScopesElementProfile,
		OAuthScopesElementAwsCognitoSigninUserAdmin,
	}
}

const (
	// RequiredSignUpAttributesElementAddress is a RequiredSignUpAttributesElement enum value
	RequiredSignUpAttributesElementAddress = "ADDRESS"

	// RequiredSignUpAttributesElementBirthdate is a RequiredSignUpAttributesElement enum value
	RequiredSignUpAttributesElementBirthdate = "BIRTHDATE"

	// RequiredSignUpAttributesElementEmail is a RequiredSignUpAttributesElement enum value
	RequiredSignUpAttributesElementEmail = "EMAIL"

	// RequiredSignUpAttributesElementFamilyName is a RequiredSignUpAttributesElement enum value
	RequiredSignUpAttributesElementFamilyName = "FAMILY_NAME"

	// RequiredSignUpAttributesElementGender is a RequiredSignUpAttributesElement enum value
	RequiredSignUpAttributesElementGender = "GENDER"

	// RequiredSignUpAttributesElementGivenName is a RequiredSignUpAttributesElement enum value
	RequiredSignUpAttributesElementGivenName = "GIVEN_NAME"

	// RequiredSignUpAttributesElementLocale is a RequiredSignUpAttributesElement enum value
	RequiredSignUpAttributesElementLocale = "LOCALE"

	// RequiredSignUpAttributesElementMiddleName is a RequiredSignUpAttributesElement enum value
	RequiredSignUpAttributesElementMiddleName = "MIDDLE_NAME"

	// RequiredSignUpAttributesElementName is a RequiredSignUpAttributesElement enum value
	RequiredSignUpAttributesElementName = "NAME"

	// RequiredSignUpAttributesElementNickname is a RequiredSignUpAttributesElement enum value
	RequiredSignUpAttributesElementNickname = "NICKNAME"

	// RequiredSignUpAttributesElementPhoneNumber is a RequiredSignUpAttributesElement enum value
	RequiredSignUpAttributesElementPhoneNumber = "PHONE_NUMBER"

	// RequiredSignUpAttributesElementPicture is a RequiredSignUpAttributesElement enum value
	RequiredSignUpAttributesElementPicture = "PICTURE"

	// RequiredSignUpAttributesElementPreferredUsername is a RequiredSignUpAttributesElement enum value
	RequiredSignUpAttributesElementPreferredUsername = "PREFERRED_USERNAME"

	// RequiredSignUpAttributesElementProfile is a RequiredSignUpAttributesElement enum value
	RequiredSignUpAttributesElementProfile = "PROFILE"

	// RequiredSignUpAttributesElementUpdatedAt is a RequiredSignUpAttributesElement enum value
	RequiredSignUpAttributesElementUpdatedAt = "UPDATED_AT"

	// RequiredSignUpAttributesElementWebsite is a RequiredSignUpAttributesElement enum value
	RequiredSignUpAttributesElementWebsite = "WEBSITE"

	// RequiredSignUpAttributesElementZoneInfo is a RequiredSignUpAttributesElement enum value
	RequiredSignUpAttributesElementZoneInfo = "ZONE_INFO"
)

// RequiredSignUpAttributesElement_Values returns all elements of the RequiredSignUpAttributesElement enum
func RequiredSignUpAttributesElement_Values() []string {
	return []string{
		RequiredSignUpAttributesElementAddress,
		RequiredSignUpAttributesElementBirthdate,
		RequiredSignUpAttributesElementEmail,
		RequiredSignUpAttributesElementFamilyName,
		RequiredSignUpAttributesElementGender,
		RequiredSignUpAttributesElementGivenName,
		RequiredSignUpAttributesElementLocale,
		RequiredSignUpAttributesElementMiddleName,
		RequiredSignUpAttributesElementName,
		RequiredSignUpAttributesElementNickname,
		RequiredSignUpAttributesElementPhoneNumber,
		RequiredSignUpAttributesElementPicture,
		RequiredSignUpAttributesElementPreferredUsername,
		RequiredSignUpAttributesElementProfile,
		RequiredSignUpAttributesElementUpdatedAt,
		RequiredSignUpAttributesElementWebsite,
		RequiredSignUpAttributesElementZoneInfo,
	}
}

const (
	// ResolutionStrategyOptimisticConcurrency is a ResolutionStrategy enum value
	ResolutionStrategyOptimisticConcurrency = "OPTIMISTIC_CONCURRENCY"

	// ResolutionStrategyLambda is a ResolutionStrategy enum value
	ResolutionStrategyLambda = "LAMBDA"

	// ResolutionStrategyAutomerge is a ResolutionStrategy enum value
	ResolutionStrategyAutomerge = "AUTOMERGE"

	// ResolutionStrategyNone is a ResolutionStrategy enum value
	ResolutionStrategyNone = "NONE"
)

// ResolutionStrategy_Values returns all elements of the ResolutionStrategy enum
func ResolutionStrategy_Values() []string {
	return []string{
		ResolutionStrategyOptimisticConcurrency,
		ResolutionStrategyLambda,
		ResolutionStrategyAutomerge,
		ResolutionStrategyNone,
	}
}

const (
	// ServiceCognito is a Service enum value
	ServiceCognito = "COGNITO"
)

// Service_Values returns all elements of the Service enum
func Service_Values() []string {
	return []string{
		ServiceCognito,
	}
}

const (
	// ServiceNameS3 is a ServiceName enum value
	ServiceNameS3 = "S3"
)

// ServiceName_Values returns all elements of the ServiceName enum
func ServiceName_Values() []string {
	return []string{
		ServiceNameS3,
	}
}

const (
	// SignInMethodEmail is a SignInMethod enum value
	SignInMethodEmail = "EMAIL"

	// SignInMethodEmailAndPhoneNumber is a SignInMethod enum value
	SignInMethodEmailAndPhoneNumber = "EMAIL_AND_PHONE_NUMBER"

	// SignInMethodPhoneNumber is a SignInMethod enum value
	SignInMethodPhoneNumber = "PHONE_NUMBER"

	// SignInMethodUsername is a SignInMethod enum value
	SignInMethodUsername = "USERNAME"
)

// SignInMethod_Values returns all elements of the SignInMethod enum
func SignInMethod_Values() []string {
	return []string{
		SignInMethodEmail,
		SignInMethodEmailAndPhoneNumber,
		SignInMethodPhoneNumber,
		SignInMethodUsername,
	}
}

const (
	// StatusLatest is a Status enum value
	StatusLatest = "LATEST"

	// StatusStale is a Status enum value
	StatusStale = "STALE"
)

// Status_Values returns all elements of the Status enum
func Status_Values() []string {
	return []string{
		StatusLatest,
		StatusStale,
	}
}

const (
	// UnAuthenticatedElementRead is a UnAuthenticatedElement enum value
	UnAuthenticatedElementRead = "READ"

	// UnAuthenticatedElementCreateAndUpdate is a UnAuthenticatedElement enum value
	UnAuthenticatedElementCreateAndUpdate = "CREATE_AND_UPDATE"

	// UnAuthenticatedElementDelete is a UnAuthenticatedElement enum value
	UnAuthenticatedElementDelete = "DELETE"
)

// UnAuthenticatedElement_Values returns all elements of the UnAuthenticatedElement enum
func UnAuthenticatedElement_Values() []string {
	return []string{
		UnAuthenticatedElementRead,
		UnAuthenticatedElementCreateAndUpdate,
		UnAuthenticatedElementDelete,
	}
}
