// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package cognitosync provides a client for Amazon Cognito Sync.
package cognitosync

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBulkPublish = "BulkPublish"

// BulkPublishRequest generates a "aws/request.Request" representing the
// client's request for the BulkPublish operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See BulkPublish for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the BulkPublish method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the BulkPublishRequest method.
//    req, resp := client.BulkPublishRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoSync) BulkPublishRequest(input *BulkPublishInput) (req *request.Request, output *BulkPublishOutput) {
	op := &request.Operation{
		Name:       opBulkPublish,
		HTTPMethod: "POST",
		HTTPPath:   "/identitypools/{IdentityPoolId}/bulkpublish",
	}

	if input == nil {
		input = &BulkPublishInput{}
	}

	req = c.newRequest(op, input, output)
	output = &BulkPublishOutput{}
	req.Data = output
	return
}

// BulkPublish API operation for Amazon Cognito Sync.
//
// Initiates a bulk publish of all existing datasets for an Identity Pool to
// the configured stream. Customers are limited to one successful bulk publish
// per 24 hours. Bulk publish is an asynchronous request, customers can see
// the status of the request via the GetBulkPublishDetails operation.
//
// This API can only be called with developer credentials. You cannot call this
// API with the temporary user credentials provided by Cognito Identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation BulkPublish for usage and error information.
//
// Returned Error Codes:
//   * NotAuthorizedException
//   Thrown when a user is not authorized to access the requested resource.
//
//   * InvalidParameterException
//   Thrown when a request parameter does not comply with the associated constraints.
//
//   * ResourceNotFoundException
//   Thrown if the resource doesn't exist.
//
//   * InternalErrorException
//   Indicates an internal service error.
//
//   * DuplicateRequestException
//   An exception thrown when there is an IN_PROGRESS bulk publish operation for
//   the given identity pool.
//
//   * AlreadyStreamedException
//   An exception thrown when a bulk publish operation is requested less than
//   24 hours after a previous bulk publish operation completed successfully.
//
func (c *CognitoSync) BulkPublish(input *BulkPublishInput) (*BulkPublishOutput, error) {
	req, out := c.BulkPublishRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDataset = "DeleteDataset"

// DeleteDatasetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataset operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteDataset for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteDataset method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteDatasetRequest method.
//    req, resp := client.DeleteDatasetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoSync) DeleteDatasetRequest(input *DeleteDatasetInput) (req *request.Request, output *DeleteDatasetOutput) {
	op := &request.Operation{
		Name:       opDeleteDataset,
		HTTPMethod: "DELETE",
		HTTPPath:   "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}",
	}

	if input == nil {
		input = &DeleteDatasetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteDatasetOutput{}
	req.Data = output
	return
}

// DeleteDataset API operation for Amazon Cognito Sync.
//
// Deletes the specific dataset. The dataset will be deleted permanently, and
// the action can't be undone. Datasets that this dataset was merged with will
// no longer report the merge. Any subsequent operation on this dataset will
// result in a ResourceNotFoundException.
//
// This API can be called with temporary user credentials provided by Cognito
// Identity or with developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation DeleteDataset for usage and error information.
//
// Returned Error Codes:
//   * NotAuthorizedException
//   Thrown when a user is not authorized to access the requested resource.
//
//   * InvalidParameterException
//   Thrown when a request parameter does not comply with the associated constraints.
//
//   * ResourceNotFoundException
//   Thrown if the resource doesn't exist.
//
//   * InternalErrorException
//   Indicates an internal service error.
//
//   * TooManyRequestsException
//   Thrown if the request is throttled.
//
//   * ResourceConflictException
//   Thrown if an update can't be applied because the resource was changed by
//   another call and this would result in a conflict.
//
func (c *CognitoSync) DeleteDataset(input *DeleteDatasetInput) (*DeleteDatasetOutput, error) {
	req, out := c.DeleteDatasetRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeDataset = "DescribeDataset"

// DescribeDatasetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataset operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeDataset for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeDataset method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeDatasetRequest method.
//    req, resp := client.DescribeDatasetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoSync) DescribeDatasetRequest(input *DescribeDatasetInput) (req *request.Request, output *DescribeDatasetOutput) {
	op := &request.Operation{
		Name:       opDescribeDataset,
		HTTPMethod: "GET",
		HTTPPath:   "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}",
	}

	if input == nil {
		input = &DescribeDatasetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDatasetOutput{}
	req.Data = output
	return
}

// DescribeDataset API operation for Amazon Cognito Sync.
//
// Gets meta data about a dataset by identity and dataset name. With Amazon
// Cognito Sync, each identity has access only to its own data. Thus, the credentials
// used to make this API call need to have access to the identity data.
//
// This API can be called with temporary user credentials provided by Cognito
// Identity or with developer credentials. You should use Cognito Identity credentials
// to make this API call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation DescribeDataset for usage and error information.
//
// Returned Error Codes:
//   * NotAuthorizedException
//   Thrown when a user is not authorized to access the requested resource.
//
//   * InvalidParameterException
//   Thrown when a request parameter does not comply with the associated constraints.
//
//   * ResourceNotFoundException
//   Thrown if the resource doesn't exist.
//
//   * InternalErrorException
//   Indicates an internal service error.
//
//   * TooManyRequestsException
//   Thrown if the request is throttled.
//
func (c *CognitoSync) DescribeDataset(input *DescribeDatasetInput) (*DescribeDatasetOutput, error) {
	req, out := c.DescribeDatasetRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeIdentityPoolUsage = "DescribeIdentityPoolUsage"

// DescribeIdentityPoolUsageRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIdentityPoolUsage operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeIdentityPoolUsage for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeIdentityPoolUsage method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeIdentityPoolUsageRequest method.
//    req, resp := client.DescribeIdentityPoolUsageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoSync) DescribeIdentityPoolUsageRequest(input *DescribeIdentityPoolUsageInput) (req *request.Request, output *DescribeIdentityPoolUsageOutput) {
	op := &request.Operation{
		Name:       opDescribeIdentityPoolUsage,
		HTTPMethod: "GET",
		HTTPPath:   "/identitypools/{IdentityPoolId}",
	}

	if input == nil {
		input = &DescribeIdentityPoolUsageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeIdentityPoolUsageOutput{}
	req.Data = output
	return
}

// DescribeIdentityPoolUsage API operation for Amazon Cognito Sync.
//
// Gets usage details (for example, data storage) about a particular identity
// pool.
//
// This API can only be called with developer credentials. You cannot call this
// API with the temporary user credentials provided by Cognito Identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation DescribeIdentityPoolUsage for usage and error information.
//
// Returned Error Codes:
//   * NotAuthorizedException
//   Thrown when a user is not authorized to access the requested resource.
//
//   * InvalidParameterException
//   Thrown when a request parameter does not comply with the associated constraints.
//
//   * ResourceNotFoundException
//   Thrown if the resource doesn't exist.
//
//   * InternalErrorException
//   Indicates an internal service error.
//
//   * TooManyRequestsException
//   Thrown if the request is throttled.
//
func (c *CognitoSync) DescribeIdentityPoolUsage(input *DescribeIdentityPoolUsageInput) (*DescribeIdentityPoolUsageOutput, error) {
	req, out := c.DescribeIdentityPoolUsageRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeIdentityUsage = "DescribeIdentityUsage"

// DescribeIdentityUsageRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIdentityUsage operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeIdentityUsage for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeIdentityUsage method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeIdentityUsageRequest method.
//    req, resp := client.DescribeIdentityUsageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoSync) DescribeIdentityUsageRequest(input *DescribeIdentityUsageInput) (req *request.Request, output *DescribeIdentityUsageOutput) {
	op := &request.Operation{
		Name:       opDescribeIdentityUsage,
		HTTPMethod: "GET",
		HTTPPath:   "/identitypools/{IdentityPoolId}/identities/{IdentityId}",
	}

	if input == nil {
		input = &DescribeIdentityUsageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeIdentityUsageOutput{}
	req.Data = output
	return
}

// DescribeIdentityUsage API operation for Amazon Cognito Sync.
//
// Gets usage information for an identity, including number of datasets and
// data usage.
//
// This API can be called with temporary user credentials provided by Cognito
// Identity or with developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation DescribeIdentityUsage for usage and error information.
//
// Returned Error Codes:
//   * NotAuthorizedException
//   Thrown when a user is not authorized to access the requested resource.
//
//   * InvalidParameterException
//   Thrown when a request parameter does not comply with the associated constraints.
//
//   * ResourceNotFoundException
//   Thrown if the resource doesn't exist.
//
//   * InternalErrorException
//   Indicates an internal service error.
//
//   * TooManyRequestsException
//   Thrown if the request is throttled.
//
func (c *CognitoSync) DescribeIdentityUsage(input *DescribeIdentityUsageInput) (*DescribeIdentityUsageOutput, error) {
	req, out := c.DescribeIdentityUsageRequest(input)
	err := req.Send()
	return out, err
}

const opGetBulkPublishDetails = "GetBulkPublishDetails"

// GetBulkPublishDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetBulkPublishDetails operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetBulkPublishDetails for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetBulkPublishDetails method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetBulkPublishDetailsRequest method.
//    req, resp := client.GetBulkPublishDetailsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoSync) GetBulkPublishDetailsRequest(input *GetBulkPublishDetailsInput) (req *request.Request, output *GetBulkPublishDetailsOutput) {
	op := &request.Operation{
		Name:       opGetBulkPublishDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/identitypools/{IdentityPoolId}/getBulkPublishDetails",
	}

	if input == nil {
		input = &GetBulkPublishDetailsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBulkPublishDetailsOutput{}
	req.Data = output
	return
}

// GetBulkPublishDetails API operation for Amazon Cognito Sync.
//
// Get the status of the last BulkPublish operation for an identity pool.
//
// This API can only be called with developer credentials. You cannot call this
// API with the temporary user credentials provided by Cognito Identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation GetBulkPublishDetails for usage and error information.
//
// Returned Error Codes:
//   * NotAuthorizedException
//   Thrown when a user is not authorized to access the requested resource.
//
//   * InvalidParameterException
//   Thrown when a request parameter does not comply with the associated constraints.
//
//   * ResourceNotFoundException
//   Thrown if the resource doesn't exist.
//
//   * InternalErrorException
//   Indicates an internal service error.
//
func (c *CognitoSync) GetBulkPublishDetails(input *GetBulkPublishDetailsInput) (*GetBulkPublishDetailsOutput, error) {
	req, out := c.GetBulkPublishDetailsRequest(input)
	err := req.Send()
	return out, err
}

const opGetCognitoEvents = "GetCognitoEvents"

// GetCognitoEventsRequest generates a "aws/request.Request" representing the
// client's request for the GetCognitoEvents operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetCognitoEvents for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetCognitoEvents method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetCognitoEventsRequest method.
//    req, resp := client.GetCognitoEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoSync) GetCognitoEventsRequest(input *GetCognitoEventsInput) (req *request.Request, output *GetCognitoEventsOutput) {
	op := &request.Operation{
		Name:       opGetCognitoEvents,
		HTTPMethod: "GET",
		HTTPPath:   "/identitypools/{IdentityPoolId}/events",
	}

	if input == nil {
		input = &GetCognitoEventsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetCognitoEventsOutput{}
	req.Data = output
	return
}

// GetCognitoEvents API operation for Amazon Cognito Sync.
//
// Gets the events and the corresponding Lambda functions associated with an
// identity pool.
//
// This API can only be called with developer credentials. You cannot call this
// API with the temporary user credentials provided by Cognito Identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation GetCognitoEvents for usage and error information.
//
// Returned Error Codes:
//   * InvalidParameterException
//   Thrown when a request parameter does not comply with the associated constraints.
//
//   * ResourceNotFoundException
//   Thrown if the resource doesn't exist.
//
//   * NotAuthorizedException
//   Thrown when a user is not authorized to access the requested resource.
//
//   * InternalErrorException
//   Indicates an internal service error.
//
//   * TooManyRequestsException
//   Thrown if the request is throttled.
//
func (c *CognitoSync) GetCognitoEvents(input *GetCognitoEventsInput) (*GetCognitoEventsOutput, error) {
	req, out := c.GetCognitoEventsRequest(input)
	err := req.Send()
	return out, err
}

const opGetIdentityPoolConfiguration = "GetIdentityPoolConfiguration"

// GetIdentityPoolConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetIdentityPoolConfiguration operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetIdentityPoolConfiguration for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetIdentityPoolConfiguration method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetIdentityPoolConfigurationRequest method.
//    req, resp := client.GetIdentityPoolConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoSync) GetIdentityPoolConfigurationRequest(input *GetIdentityPoolConfigurationInput) (req *request.Request, output *GetIdentityPoolConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetIdentityPoolConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/identitypools/{IdentityPoolId}/configuration",
	}

	if input == nil {
		input = &GetIdentityPoolConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetIdentityPoolConfigurationOutput{}
	req.Data = output
	return
}

// GetIdentityPoolConfiguration API operation for Amazon Cognito Sync.
//
// Gets the configuration settings of an identity pool.
//
// This API can only be called with developer credentials. You cannot call this
// API with the temporary user credentials provided by Cognito Identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation GetIdentityPoolConfiguration for usage and error information.
//
// Returned Error Codes:
//   * NotAuthorizedException
//   Thrown when a user is not authorized to access the requested resource.
//
//   * InvalidParameterException
//   Thrown when a request parameter does not comply with the associated constraints.
//
//   * ResourceNotFoundException
//   Thrown if the resource doesn't exist.
//
//   * InternalErrorException
//   Indicates an internal service error.
//
//   * TooManyRequestsException
//   Thrown if the request is throttled.
//
func (c *CognitoSync) GetIdentityPoolConfiguration(input *GetIdentityPoolConfigurationInput) (*GetIdentityPoolConfigurationOutput, error) {
	req, out := c.GetIdentityPoolConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opListDatasets = "ListDatasets"

// ListDatasetsRequest generates a "aws/request.Request" representing the
// client's request for the ListDatasets operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListDatasets for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListDatasets method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListDatasetsRequest method.
//    req, resp := client.ListDatasetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoSync) ListDatasetsRequest(input *ListDatasetsInput) (req *request.Request, output *ListDatasetsOutput) {
	op := &request.Operation{
		Name:       opListDatasets,
		HTTPMethod: "GET",
		HTTPPath:   "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets",
	}

	if input == nil {
		input = &ListDatasetsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListDatasetsOutput{}
	req.Data = output
	return
}

// ListDatasets API operation for Amazon Cognito Sync.
//
// Lists datasets for an identity. With Amazon Cognito Sync, each identity has
// access only to its own data. Thus, the credentials used to make this API
// call need to have access to the identity data.
//
// ListDatasets can be called with temporary user credentials provided by Cognito
// Identity or with developer credentials. You should use the Cognito Identity
// credentials to make this API call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation ListDatasets for usage and error information.
//
// Returned Error Codes:
//   * NotAuthorizedException
//   Thrown when a user is not authorized to access the requested resource.
//
//   * InvalidParameterException
//   Thrown when a request parameter does not comply with the associated constraints.
//
//   * InternalErrorException
//   Indicates an internal service error.
//
//   * TooManyRequestsException
//   Thrown if the request is throttled.
//
func (c *CognitoSync) ListDatasets(input *ListDatasetsInput) (*ListDatasetsOutput, error) {
	req, out := c.ListDatasetsRequest(input)
	err := req.Send()
	return out, err
}

const opListIdentityPoolUsage = "ListIdentityPoolUsage"

// ListIdentityPoolUsageRequest generates a "aws/request.Request" representing the
// client's request for the ListIdentityPoolUsage operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListIdentityPoolUsage for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListIdentityPoolUsage method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListIdentityPoolUsageRequest method.
//    req, resp := client.ListIdentityPoolUsageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoSync) ListIdentityPoolUsageRequest(input *ListIdentityPoolUsageInput) (req *request.Request, output *ListIdentityPoolUsageOutput) {
	op := &request.Operation{
		Name:       opListIdentityPoolUsage,
		HTTPMethod: "GET",
		HTTPPath:   "/identitypools",
	}

	if input == nil {
		input = &ListIdentityPoolUsageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListIdentityPoolUsageOutput{}
	req.Data = output
	return
}

// ListIdentityPoolUsage API operation for Amazon Cognito Sync.
//
// Gets a list of identity pools registered with Cognito.
//
// ListIdentityPoolUsage can only be called with developer credentials. You
// cannot make this API call with the temporary user credentials provided by
// Cognito Identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation ListIdentityPoolUsage for usage and error information.
//
// Returned Error Codes:
//   * NotAuthorizedException
//   Thrown when a user is not authorized to access the requested resource.
//
//   * InvalidParameterException
//   Thrown when a request parameter does not comply with the associated constraints.
//
//   * InternalErrorException
//   Indicates an internal service error.
//
//   * TooManyRequestsException
//   Thrown if the request is throttled.
//
func (c *CognitoSync) ListIdentityPoolUsage(input *ListIdentityPoolUsageInput) (*ListIdentityPoolUsageOutput, error) {
	req, out := c.ListIdentityPoolUsageRequest(input)
	err := req.Send()
	return out, err
}

const opListRecords = "ListRecords"

// ListRecordsRequest generates a "aws/request.Request" representing the
// client's request for the ListRecords operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListRecords for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListRecords method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListRecordsRequest method.
//    req, resp := client.ListRecordsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoSync) ListRecordsRequest(input *ListRecordsInput) (req *request.Request, output *ListRecordsOutput) {
	op := &request.Operation{
		Name:       opListRecords,
		HTTPMethod: "GET",
		HTTPPath:   "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/records",
	}

	if input == nil {
		input = &ListRecordsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListRecordsOutput{}
	req.Data = output
	return
}

// ListRecords API operation for Amazon Cognito Sync.
//
// Gets paginated records, optionally changed after a particular sync count
// for a dataset and identity. With Amazon Cognito Sync, each identity has access
// only to its own data. Thus, the credentials used to make this API call need
// to have access to the identity data.
//
// ListRecords can be called with temporary user credentials provided by Cognito
// Identity or with developer credentials. You should use Cognito Identity credentials
// to make this API call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation ListRecords for usage and error information.
//
// Returned Error Codes:
//   * InvalidParameterException
//   Thrown when a request parameter does not comply with the associated constraints.
//
//   * NotAuthorizedException
//   Thrown when a user is not authorized to access the requested resource.
//
//   * TooManyRequestsException
//   Thrown if the request is throttled.
//
//   * InternalErrorException
//   Indicates an internal service error.
//
func (c *CognitoSync) ListRecords(input *ListRecordsInput) (*ListRecordsOutput, error) {
	req, out := c.ListRecordsRequest(input)
	err := req.Send()
	return out, err
}

const opRegisterDevice = "RegisterDevice"

// RegisterDeviceRequest generates a "aws/request.Request" representing the
// client's request for the RegisterDevice operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RegisterDevice for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RegisterDevice method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RegisterDeviceRequest method.
//    req, resp := client.RegisterDeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoSync) RegisterDeviceRequest(input *RegisterDeviceInput) (req *request.Request, output *RegisterDeviceOutput) {
	op := &request.Operation{
		Name:       opRegisterDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/identitypools/{IdentityPoolId}/identity/{IdentityId}/device",
	}

	if input == nil {
		input = &RegisterDeviceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RegisterDeviceOutput{}
	req.Data = output
	return
}

// RegisterDevice API operation for Amazon Cognito Sync.
//
// Registers a device to receive push sync notifications.
//
// This API can only be called with temporary credentials provided by Cognito
// Identity. You cannot call this API with developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation RegisterDevice for usage and error information.
//
// Returned Error Codes:
//   * NotAuthorizedException
//   Thrown when a user is not authorized to access the requested resource.
//
//   * InvalidParameterException
//   Thrown when a request parameter does not comply with the associated constraints.
//
//   * ResourceNotFoundException
//   Thrown if the resource doesn't exist.
//
//   * InternalErrorException
//   Indicates an internal service error.
//
//   * InvalidConfigurationException

//
//   * TooManyRequestsException
//   Thrown if the request is throttled.
//
func (c *CognitoSync) RegisterDevice(input *RegisterDeviceInput) (*RegisterDeviceOutput, error) {
	req, out := c.RegisterDeviceRequest(input)
	err := req.Send()
	return out, err
}

const opSetCognitoEvents = "SetCognitoEvents"

// SetCognitoEventsRequest generates a "aws/request.Request" representing the
// client's request for the SetCognitoEvents operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetCognitoEvents for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetCognitoEvents method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetCognitoEventsRequest method.
//    req, resp := client.SetCognitoEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoSync) SetCognitoEventsRequest(input *SetCognitoEventsInput) (req *request.Request, output *SetCognitoEventsOutput) {
	op := &request.Operation{
		Name:       opSetCognitoEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/identitypools/{IdentityPoolId}/events",
	}

	if input == nil {
		input = &SetCognitoEventsInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &SetCognitoEventsOutput{}
	req.Data = output
	return
}

// SetCognitoEvents API operation for Amazon Cognito Sync.
//
// Sets the AWS Lambda function for a given event type for an identity pool.
// This request only updates the key/value pair specified. Other key/values
// pairs are not updated. To remove a key value pair, pass a empty value for
// the particular key.
//
// This API can only be called with developer credentials. You cannot call this
// API with the temporary user credentials provided by Cognito Identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation SetCognitoEvents for usage and error information.
//
// Returned Error Codes:
//   * InvalidParameterException
//   Thrown when a request parameter does not comply with the associated constraints.
//
//   * ResourceNotFoundException
//   Thrown if the resource doesn't exist.
//
//   * NotAuthorizedException
//   Thrown when a user is not authorized to access the requested resource.
//
//   * InternalErrorException
//   Indicates an internal service error.
//
//   * TooManyRequestsException
//   Thrown if the request is throttled.
//
func (c *CognitoSync) SetCognitoEvents(input *SetCognitoEventsInput) (*SetCognitoEventsOutput, error) {
	req, out := c.SetCognitoEventsRequest(input)
	err := req.Send()
	return out, err
}

const opSetIdentityPoolConfiguration = "SetIdentityPoolConfiguration"

// SetIdentityPoolConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the SetIdentityPoolConfiguration operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetIdentityPoolConfiguration for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetIdentityPoolConfiguration method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetIdentityPoolConfigurationRequest method.
//    req, resp := client.SetIdentityPoolConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoSync) SetIdentityPoolConfigurationRequest(input *SetIdentityPoolConfigurationInput) (req *request.Request, output *SetIdentityPoolConfigurationOutput) {
	op := &request.Operation{
		Name:       opSetIdentityPoolConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/identitypools/{IdentityPoolId}/configuration",
	}

	if input == nil {
		input = &SetIdentityPoolConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetIdentityPoolConfigurationOutput{}
	req.Data = output
	return
}

// SetIdentityPoolConfiguration API operation for Amazon Cognito Sync.
//
// Sets the necessary configuration for push sync.
//
// This API can only be called with developer credentials. You cannot call this
// API with the temporary user credentials provided by Cognito Identity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation SetIdentityPoolConfiguration for usage and error information.
//
// Returned Error Codes:
//   * NotAuthorizedException
//   Thrown when a user is not authorized to access the requested resource.
//
//   * InvalidParameterException
//   Thrown when a request parameter does not comply with the associated constraints.
//
//   * ResourceNotFoundException
//   Thrown if the resource doesn't exist.
//
//   * InternalErrorException
//   Indicates an internal service error.
//
//   * TooManyRequestsException
//   Thrown if the request is throttled.
//
//   * ConcurrentModificationException
//   Thrown if there are parallel requests to modify a resource.
//
func (c *CognitoSync) SetIdentityPoolConfiguration(input *SetIdentityPoolConfigurationInput) (*SetIdentityPoolConfigurationOutput, error) {
	req, out := c.SetIdentityPoolConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opSubscribeToDataset = "SubscribeToDataset"

// SubscribeToDatasetRequest generates a "aws/request.Request" representing the
// client's request for the SubscribeToDataset operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SubscribeToDataset for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SubscribeToDataset method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SubscribeToDatasetRequest method.
//    req, resp := client.SubscribeToDatasetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoSync) SubscribeToDatasetRequest(input *SubscribeToDatasetInput) (req *request.Request, output *SubscribeToDatasetOutput) {
	op := &request.Operation{
		Name:       opSubscribeToDataset,
		HTTPMethod: "POST",
		HTTPPath:   "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/subscriptions/{DeviceId}",
	}

	if input == nil {
		input = &SubscribeToDatasetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SubscribeToDatasetOutput{}
	req.Data = output
	return
}

// SubscribeToDataset API operation for Amazon Cognito Sync.
//
// Subscribes to receive notifications when a dataset is modified by another
// device.
//
// This API can only be called with temporary credentials provided by Cognito
// Identity. You cannot call this API with developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation SubscribeToDataset for usage and error information.
//
// Returned Error Codes:
//   * NotAuthorizedException
//   Thrown when a user is not authorized to access the requested resource.
//
//   * InvalidParameterException
//   Thrown when a request parameter does not comply with the associated constraints.
//
//   * ResourceNotFoundException
//   Thrown if the resource doesn't exist.
//
//   * InternalErrorException
//   Indicates an internal service error.
//
//   * InvalidConfigurationException

//
//   * TooManyRequestsException
//   Thrown if the request is throttled.
//
func (c *CognitoSync) SubscribeToDataset(input *SubscribeToDatasetInput) (*SubscribeToDatasetOutput, error) {
	req, out := c.SubscribeToDatasetRequest(input)
	err := req.Send()
	return out, err
}

const opUnsubscribeFromDataset = "UnsubscribeFromDataset"

// UnsubscribeFromDatasetRequest generates a "aws/request.Request" representing the
// client's request for the UnsubscribeFromDataset operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UnsubscribeFromDataset for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UnsubscribeFromDataset method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UnsubscribeFromDatasetRequest method.
//    req, resp := client.UnsubscribeFromDatasetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoSync) UnsubscribeFromDatasetRequest(input *UnsubscribeFromDatasetInput) (req *request.Request, output *UnsubscribeFromDatasetOutput) {
	op := &request.Operation{
		Name:       opUnsubscribeFromDataset,
		HTTPMethod: "DELETE",
		HTTPPath:   "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/subscriptions/{DeviceId}",
	}

	if input == nil {
		input = &UnsubscribeFromDatasetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UnsubscribeFromDatasetOutput{}
	req.Data = output
	return
}

// UnsubscribeFromDataset API operation for Amazon Cognito Sync.
//
// Unsubscribes from receiving notifications when a dataset is modified by another
// device.
//
// This API can only be called with temporary credentials provided by Cognito
// Identity. You cannot call this API with developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation UnsubscribeFromDataset for usage and error information.
//
// Returned Error Codes:
//   * NotAuthorizedException
//   Thrown when a user is not authorized to access the requested resource.
//
//   * InvalidParameterException
//   Thrown when a request parameter does not comply with the associated constraints.
//
//   * ResourceNotFoundException
//   Thrown if the resource doesn't exist.
//
//   * InternalErrorException
//   Indicates an internal service error.
//
//   * InvalidConfigurationException

//
//   * TooManyRequestsException
//   Thrown if the request is throttled.
//
func (c *CognitoSync) UnsubscribeFromDataset(input *UnsubscribeFromDatasetInput) (*UnsubscribeFromDatasetOutput, error) {
	req, out := c.UnsubscribeFromDatasetRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateRecords = "UpdateRecords"

// UpdateRecordsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRecords operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateRecords for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateRecords method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateRecordsRequest method.
//    req, resp := client.UpdateRecordsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *CognitoSync) UpdateRecordsRequest(input *UpdateRecordsInput) (req *request.Request, output *UpdateRecordsOutput) {
	op := &request.Operation{
		Name:       opUpdateRecords,
		HTTPMethod: "POST",
		HTTPPath:   "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}",
	}

	if input == nil {
		input = &UpdateRecordsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateRecordsOutput{}
	req.Data = output
	return
}

// UpdateRecords API operation for Amazon Cognito Sync.
//
// Posts updates to records and adds and deletes records for a dataset and user.
//
// The sync count in the record patch is your last known sync count for that
// record. The server will reject an UpdateRecords request with a ResourceConflictException
// if you try to patch a record with a new value but a stale sync count.
//
// For example, if the sync count on the server is 5 for a key called highScore
// and you try and submit a new highScore with sync count of 4, the request
// will be rejected. To obtain the current sync count for a record, call ListRecords.
// On a successful update of the record, the response returns the new sync count
// for that record. You should present that sync count the next time you try
// to update that same record. When the record does not exist, specify the sync
// count as 0.
//
// This API can be called with temporary user credentials provided by Cognito
// Identity or with developer credentials.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Cognito Sync's
// API operation UpdateRecords for usage and error information.
//
// Returned Error Codes:
//   * InvalidParameterException
//   Thrown when a request parameter does not comply with the associated constraints.
//
//   * LimitExceededException
//   Thrown when the limit on the number of objects or operations has been exceeded.
//
//   * NotAuthorizedException
//   Thrown when a user is not authorized to access the requested resource.
//
//   * ResourceNotFoundException
//   Thrown if the resource doesn't exist.
//
//   * ResourceConflictException
//   Thrown if an update can't be applied because the resource was changed by
//   another call and this would result in a conflict.
//
//   * InvalidLambdaFunctionOutputException
//   The AWS Lambda function returned invalid output or an exception.
//
//   * LambdaThrottledException
//   AWS Lambda throttled your account, please contact AWS Support
//
//   * TooManyRequestsException
//   Thrown if the request is throttled.
//
//   * InternalErrorException
//   Indicates an internal service error.
//
func (c *CognitoSync) UpdateRecords(input *UpdateRecordsInput) (*UpdateRecordsOutput, error) {
	req, out := c.UpdateRecordsRequest(input)
	err := req.Send()
	return out, err
}

// The input for the BulkPublish operation.
type BulkPublishInput struct {
	_ struct{} `type:"structure"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s BulkPublishInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BulkPublishInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BulkPublishInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BulkPublishInput"}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for the BulkPublish operation.
type BulkPublishOutput struct {
	_ struct{} `type:"structure"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	IdentityPoolId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s BulkPublishOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BulkPublishOutput) GoString() string {
	return s.String()
}

// Configuration options for configure Cognito streams.
type CognitoStreams struct {
	_ struct{} `type:"structure"`

	// The ARN of the role Amazon Cognito can assume in order to publish to the
	// stream. This role must grant access to Amazon Cognito (cognito-sync) to invoke
	// PutRecord on your Cognito stream.
	RoleArn *string `min:"20" type:"string"`

	// The name of the Cognito stream to receive updates. This stream must be in
	// the developers account and in the same region as the identity pool.
	StreamName *string `min:"1" type:"string"`

	// Status of the Cognito streams. Valid values are: ENABLED - Streaming of updates
	// to identity pool is enabled.
	//
	// DISABLED - Streaming of updates to identity pool is disabled. Bulk publish
	// will also fail if StreamingStatus is DISABLED.
	StreamingStatus *string `type:"string" enum:"StreamingStatus"`
}

// String returns the string representation
func (s CognitoStreams) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CognitoStreams) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CognitoStreams) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CognitoStreams"}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A collection of data for an identity pool. An identity pool can have multiple
// datasets. A dataset is per identity and can be general or associated with
// a particular entity in an application (like a saved game). Datasets are automatically
// created if they don't exist. Data is synced by dataset, and a dataset can
// hold up to 1MB of key-value pairs.
type Dataset struct {
	_ struct{} `type:"structure"`

	// Date on which the dataset was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Total size in bytes of the records in this dataset.
	DataStorage *int64 `type:"long"`

	// A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_'
	// (underscore), '-' (dash), and '.' (dot).
	DatasetName *string `min:"1" type:"string"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	IdentityId *string `min:"1" type:"string"`

	// The device that made the last change to this dataset.
	LastModifiedBy *string `type:"string"`

	// Date when the dataset was last modified.
	LastModifiedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Number of records in this dataset.
	NumRecords *int64 `type:"long"`
}

// String returns the string representation
func (s Dataset) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Dataset) GoString() string {
	return s.String()
}

// A request to delete the specific dataset.
type DeleteDatasetInput struct {
	_ struct{} `type:"structure"`

	// A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_'
	// (underscore), '-' (dash), and '.' (dot).
	//
	// DatasetName is a required field
	DatasetName *string `location:"uri" locationName:"DatasetName" min:"1" type:"string" required:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityId is a required field
	IdentityId *string `location:"uri" locationName:"IdentityId" min:"1" type:"string" required:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDatasetInput"}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.IdentityId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Response to a successful DeleteDataset request.
type DeleteDatasetOutput struct {
	_ struct{} `type:"structure"`

	// A collection of data for an identity pool. An identity pool can have multiple
	// datasets. A dataset is per identity and can be general or associated with
	// a particular entity in an application (like a saved game). Datasets are automatically
	// created if they don't exist. Data is synced by dataset, and a dataset can
	// hold up to 1MB of key-value pairs.
	Dataset *Dataset `type:"structure"`
}

// String returns the string representation
func (s DeleteDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDatasetOutput) GoString() string {
	return s.String()
}

// A request for meta data about a dataset (creation date, number of records,
// size) by owner and dataset name.
type DescribeDatasetInput struct {
	_ struct{} `type:"structure"`

	// A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_'
	// (underscore), '-' (dash), and '.' (dot).
	//
	// DatasetName is a required field
	DatasetName *string `location:"uri" locationName:"DatasetName" min:"1" type:"string" required:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityId is a required field
	IdentityId *string `location:"uri" locationName:"IdentityId" min:"1" type:"string" required:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDatasetInput"}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.IdentityId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Response to a successful DescribeDataset request.
type DescribeDatasetOutput struct {
	_ struct{} `type:"structure"`

	// Meta data for a collection of data for an identity. An identity can have
	// multiple datasets. A dataset can be general or associated with a particular
	// entity in an application (like a saved game). Datasets are automatically
	// created if they don't exist. Data is synced by dataset, and a dataset can
	// hold up to 1MB of key-value pairs.
	Dataset *Dataset `type:"structure"`
}

// String returns the string representation
func (s DescribeDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDatasetOutput) GoString() string {
	return s.String()
}

// A request for usage information about the identity pool.
type DescribeIdentityPoolUsageInput struct {
	_ struct{} `type:"structure"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeIdentityPoolUsageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIdentityPoolUsageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIdentityPoolUsageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIdentityPoolUsageInput"}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Response to a successful DescribeIdentityPoolUsage request.
type DescribeIdentityPoolUsageOutput struct {
	_ struct{} `type:"structure"`

	// Information about the usage of the identity pool.
	IdentityPoolUsage *IdentityPoolUsage `type:"structure"`
}

// String returns the string representation
func (s DescribeIdentityPoolUsageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIdentityPoolUsageOutput) GoString() string {
	return s.String()
}

// A request for information about the usage of an identity pool.
type DescribeIdentityUsageInput struct {
	_ struct{} `type:"structure"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityId is a required field
	IdentityId *string `location:"uri" locationName:"IdentityId" min:"1" type:"string" required:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeIdentityUsageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIdentityUsageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIdentityUsageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIdentityUsageInput"}
	if s.IdentityId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response to a successful DescribeIdentityUsage request.
type DescribeIdentityUsageOutput struct {
	_ struct{} `type:"structure"`

	// Usage information for the identity.
	IdentityUsage *IdentityUsage `type:"structure"`
}

// String returns the string representation
func (s DescribeIdentityUsageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIdentityUsageOutput) GoString() string {
	return s.String()
}

// The input for the GetBulkPublishDetails operation.
type GetBulkPublishDetailsInput struct {
	_ struct{} `type:"structure"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBulkPublishDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBulkPublishDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBulkPublishDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBulkPublishDetailsInput"}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for the GetBulkPublishDetails operation.
type GetBulkPublishDetailsOutput struct {
	_ struct{} `type:"structure"`

	// If BulkPublishStatus is SUCCEEDED, the time the last bulk publish operation
	// completed.
	BulkPublishCompleteTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date/time at which the last bulk publish was initiated.
	BulkPublishStartTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Status of the last bulk publish operation, valid values are: NOT_STARTED
	// - No bulk publish has been requested for this identity pool
	//
	// IN_PROGRESS - Data is being published to the configured stream
	//
	// SUCCEEDED - All data for the identity pool has been published to the configured
	// stream
	//
	// FAILED - Some portion of the data has failed to publish, check FailureMessage
	// for the cause.
	BulkPublishStatus *string `type:"string" enum:"BulkPublishStatus"`

	// If BulkPublishStatus is FAILED this field will contain the error message
	// that caused the bulk publish to fail.
	FailureMessage *string `type:"string"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	IdentityPoolId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetBulkPublishDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBulkPublishDetailsOutput) GoString() string {
	return s.String()
}

// A request for a list of the configured Cognito Events
type GetCognitoEventsInput struct {
	_ struct{} `type:"structure"`

	// The Cognito Identity Pool ID for the request
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCognitoEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCognitoEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCognitoEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCognitoEventsInput"}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response from the GetCognitoEvents request
type GetCognitoEventsOutput struct {
	_ struct{} `type:"structure"`

	// The Cognito Events returned from the GetCognitoEvents request
	Events map[string]*string `type:"map"`
}

// String returns the string representation
func (s GetCognitoEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCognitoEventsOutput) GoString() string {
	return s.String()
}

// The input for the GetIdentityPoolConfiguration operation.
type GetIdentityPoolConfigurationInput struct {
	_ struct{} `type:"structure"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. This is the ID of the pool for which to return
	// a configuration.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetIdentityPoolConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityPoolConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdentityPoolConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIdentityPoolConfigurationInput"}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for the GetIdentityPoolConfiguration operation.
type GetIdentityPoolConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Options to apply to this identity pool for Amazon Cognito streams.
	CognitoStreams *CognitoStreams `type:"structure"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito.
	IdentityPoolId *string `min:"1" type:"string"`

	// Options to apply to this identity pool for push synchronization.
	PushSync *PushSync `type:"structure"`
}

// String returns the string representation
func (s GetIdentityPoolConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityPoolConfigurationOutput) GoString() string {
	return s.String()
}

// Usage information for the identity pool.
type IdentityPoolUsage struct {
	_ struct{} `type:"structure"`

	// Data storage information for the identity pool.
	DataStorage *int64 `type:"long"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	IdentityPoolId *string `min:"1" type:"string"`

	// Date on which the identity pool was last modified.
	LastModifiedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Number of sync sessions for the identity pool.
	SyncSessionsCount *int64 `type:"long"`
}

// String returns the string representation
func (s IdentityPoolUsage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IdentityPoolUsage) GoString() string {
	return s.String()
}

// Usage information for the identity.
type IdentityUsage struct {
	_ struct{} `type:"structure"`

	// Total data storage for this identity.
	DataStorage *int64 `type:"long"`

	// Number of datasets for the identity.
	DatasetCount *int64 `type:"integer"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	IdentityId *string `min:"1" type:"string"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	IdentityPoolId *string `min:"1" type:"string"`

	// Date on which the identity was last modified.
	LastModifiedDate *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s IdentityUsage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IdentityUsage) GoString() string {
	return s.String()
}

// Request for a list of datasets for an identity.
type ListDatasetsInput struct {
	_ struct{} `type:"structure"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityId is a required field
	IdentityId *string `location:"uri" locationName:"IdentityId" min:"1" type:"string" required:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`

	// The maximum number of results to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A pagination token for obtaining the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDatasetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDatasetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatasetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatasetsInput"}
	if s.IdentityId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Returned for a successful ListDatasets request.
type ListDatasetsOutput struct {
	_ struct{} `type:"structure"`

	// Number of datasets returned.
	Count *int64 `type:"integer"`

	// A set of datasets.
	Datasets []*Dataset `type:"list"`

	// A pagination token for obtaining the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDatasetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDatasetsOutput) GoString() string {
	return s.String()
}

// A request for usage information on an identity pool.
type ListIdentityPoolUsageInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A pagination token for obtaining the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListIdentityPoolUsageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIdentityPoolUsageInput) GoString() string {
	return s.String()
}

// Returned for a successful ListIdentityPoolUsage request.
type ListIdentityPoolUsageOutput struct {
	_ struct{} `type:"structure"`

	// Total number of identities for the identity pool.
	Count *int64 `type:"integer"`

	// Usage information for the identity pools.
	IdentityPoolUsages []*IdentityPoolUsage `type:"list"`

	// The maximum number of results to be returned.
	MaxResults *int64 `type:"integer"`

	// A pagination token for obtaining the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListIdentityPoolUsageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIdentityPoolUsageOutput) GoString() string {
	return s.String()
}

// A request for a list of records.
type ListRecordsInput struct {
	_ struct{} `type:"structure"`

	// A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_'
	// (underscore), '-' (dash), and '.' (dot).
	//
	// DatasetName is a required field
	DatasetName *string `location:"uri" locationName:"DatasetName" min:"1" type:"string" required:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityId is a required field
	IdentityId *string `location:"uri" locationName:"IdentityId" min:"1" type:"string" required:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`

	// The last server sync count for this record.
	LastSyncCount *int64 `location:"querystring" locationName:"lastSyncCount" type:"long"`

	// The maximum number of results to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A pagination token for obtaining the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// A token containing a session ID, identity ID, and expiration.
	SyncSessionToken *string `location:"querystring" locationName:"syncSessionToken" type:"string"`
}

// String returns the string representation
func (s ListRecordsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRecordsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecordsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRecordsInput"}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.IdentityId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Returned for a successful ListRecordsRequest.
type ListRecordsOutput struct {
	_ struct{} `type:"structure"`

	// Total number of records.
	Count *int64 `type:"integer"`

	// A boolean value specifying whether to delete the dataset locally.
	DatasetDeletedAfterRequestedSyncCount *bool `type:"boolean"`

	// Indicates whether the dataset exists.
	DatasetExists *bool `type:"boolean"`

	// Server sync count for this dataset.
	DatasetSyncCount *int64 `type:"long"`

	// The user/device that made the last change to this record.
	LastModifiedBy *string `type:"string"`

	// Names of merged datasets.
	MergedDatasetNames []*string `type:"list"`

	// A pagination token for obtaining the next page of results.
	NextToken *string `type:"string"`

	// A list of all records.
	Records []*Record `type:"list"`

	// A token containing a session ID, identity ID, and expiration.
	SyncSessionToken *string `type:"string"`
}

// String returns the string representation
func (s ListRecordsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRecordsOutput) GoString() string {
	return s.String()
}

// Configuration options to be applied to the identity pool.
type PushSync struct {
	_ struct{} `type:"structure"`

	// List of SNS platform application ARNs that could be used by clients.
	ApplicationArns []*string `type:"list"`

	// A role configured to allow Cognito to call SNS on behalf of the developer.
	RoleArn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s PushSync) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PushSync) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PushSync) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PushSync"}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The basic data structure of a dataset.
type Record struct {
	_ struct{} `type:"structure"`

	// The last modified date of the client device.
	DeviceLastModifiedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The key for the record.
	Key *string `min:"1" type:"string"`

	// The user/device that made the last change to this record.
	LastModifiedBy *string `type:"string"`

	// The date on which the record was last modified.
	LastModifiedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The server sync count for this record.
	SyncCount *int64 `type:"long"`

	// The value for the record.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Record) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Record) GoString() string {
	return s.String()
}

// An update operation for a record.
type RecordPatch struct {
	_ struct{} `type:"structure"`

	// The last modified date of the client device.
	DeviceLastModifiedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The key associated with the record patch.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// An operation, either replace or remove.
	//
	// Op is a required field
	Op *string `type:"string" required:"true" enum:"Operation"`

	// Last known server sync count for this record. Set to 0 if unknown.
	//
	// SyncCount is a required field
	SyncCount *int64 `type:"long" required:"true"`

	// The value associated with the record patch.
	Value *string `type:"string"`
}

// String returns the string representation
func (s RecordPatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordPatch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecordPatch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecordPatch"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Op == nil {
		invalidParams.Add(request.NewErrParamRequired("Op"))
	}
	if s.SyncCount == nil {
		invalidParams.Add(request.NewErrParamRequired("SyncCount"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A request to RegisterDevice.
type RegisterDeviceInput struct {
	_ struct{} `type:"structure"`

	// The unique ID for this identity.
	//
	// IdentityId is a required field
	IdentityId *string `location:"uri" locationName:"IdentityId" min:"1" type:"string" required:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. Here, the ID of the pool that the identity belongs
	// to.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`

	// The SNS platform type (e.g. GCM, SDM, APNS, APNS_SANDBOX).
	//
	// Platform is a required field
	Platform *string `type:"string" required:"true" enum:"Platform"`

	// The push token.
	//
	// Token is a required field
	Token *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterDeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterDeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterDeviceInput"}
	if s.IdentityId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}
	if s.Platform == nil {
		invalidParams.Add(request.NewErrParamRequired("Platform"))
	}
	if s.Token == nil {
		invalidParams.Add(request.NewErrParamRequired("Token"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Response to a RegisterDevice request.
type RegisterDeviceOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID generated for this device by Cognito.
	DeviceId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RegisterDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterDeviceOutput) GoString() string {
	return s.String()
}

// A request to configure Cognito Events"
type SetCognitoEventsInput struct {
	_ struct{} `type:"structure"`

	// The events to configure
	//
	// Events is a required field
	Events map[string]*string `type:"map" required:"true"`

	// The Cognito Identity Pool to use when configuring Cognito Events
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SetCognitoEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetCognitoEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetCognitoEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetCognitoEventsInput"}
	if s.Events == nil {
		invalidParams.Add(request.NewErrParamRequired("Events"))
	}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SetCognitoEventsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetCognitoEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetCognitoEventsOutput) GoString() string {
	return s.String()
}

// The input for the SetIdentityPoolConfiguration operation.
type SetIdentityPoolConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Options to apply to this identity pool for Amazon Cognito streams.
	CognitoStreams *CognitoStreams `type:"structure"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. This is the ID of the pool to modify.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`

	// Options to apply to this identity pool for push synchronization.
	PushSync *PushSync `type:"structure"`
}

// String returns the string representation
func (s SetIdentityPoolConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityPoolConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetIdentityPoolConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetIdentityPoolConfigurationInput"}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}
	if s.CognitoStreams != nil {
		if err := s.CognitoStreams.Validate(); err != nil {
			invalidParams.AddNested("CognitoStreams", err.(request.ErrInvalidParams))
		}
	}
	if s.PushSync != nil {
		if err := s.PushSync.Validate(); err != nil {
			invalidParams.AddNested("PushSync", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The output for the SetIdentityPoolConfiguration operation
type SetIdentityPoolConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Options to apply to this identity pool for Amazon Cognito streams.
	CognitoStreams *CognitoStreams `type:"structure"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito.
	IdentityPoolId *string `min:"1" type:"string"`

	// Options to apply to this identity pool for push synchronization.
	PushSync *PushSync `type:"structure"`
}

// String returns the string representation
func (s SetIdentityPoolConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityPoolConfigurationOutput) GoString() string {
	return s.String()
}

// A request to SubscribeToDatasetRequest.
type SubscribeToDatasetInput struct {
	_ struct{} `type:"structure"`

	// The name of the dataset to subcribe to.
	//
	// DatasetName is a required field
	DatasetName *string `location:"uri" locationName:"DatasetName" min:"1" type:"string" required:"true"`

	// The unique ID generated for this device by Cognito.
	//
	// DeviceId is a required field
	DeviceId *string `location:"uri" locationName:"DeviceId" min:"1" type:"string" required:"true"`

	// Unique ID for this identity.
	//
	// IdentityId is a required field
	IdentityId *string `location:"uri" locationName:"IdentityId" min:"1" type:"string" required:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. The ID of the pool to which the identity belongs.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SubscribeToDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SubscribeToDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SubscribeToDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SubscribeToDatasetInput"}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.DeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceId"))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}
	if s.IdentityId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Response to a SubscribeToDataset request.
type SubscribeToDatasetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SubscribeToDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SubscribeToDatasetOutput) GoString() string {
	return s.String()
}

// A request to UnsubscribeFromDataset.
type UnsubscribeFromDatasetInput struct {
	_ struct{} `type:"structure"`

	// The name of the dataset from which to unsubcribe.
	//
	// DatasetName is a required field
	DatasetName *string `location:"uri" locationName:"DatasetName" min:"1" type:"string" required:"true"`

	// The unique ID generated for this device by Cognito.
	//
	// DeviceId is a required field
	DeviceId *string `location:"uri" locationName:"DeviceId" min:"1" type:"string" required:"true"`

	// Unique ID for this identity.
	//
	// IdentityId is a required field
	IdentityId *string `location:"uri" locationName:"IdentityId" min:"1" type:"string" required:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. The ID of the pool to which this identity belongs.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UnsubscribeFromDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnsubscribeFromDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnsubscribeFromDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UnsubscribeFromDatasetInput"}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.DeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceId"))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}
	if s.IdentityId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Response to an UnsubscribeFromDataset request.
type UnsubscribeFromDatasetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UnsubscribeFromDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnsubscribeFromDatasetOutput) GoString() string {
	return s.String()
}

// A request to post updates to records or add and delete records for a dataset
// and user.
type UpdateRecordsInput struct {
	_ struct{} `type:"structure"`

	// Intended to supply a device ID that will populate the lastModifiedBy field
	// referenced in other methods. The ClientContext field is not yet implemented.
	ClientContext *string `location:"header" locationName:"x-amz-Client-Context" type:"string"`

	// A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_'
	// (underscore), '-' (dash), and '.' (dot).
	//
	// DatasetName is a required field
	DatasetName *string `location:"uri" locationName:"DatasetName" min:"1" type:"string" required:"true"`

	// The unique ID generated for this device by Cognito.
	DeviceId *string `min:"1" type:"string"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityId is a required field
	IdentityId *string `location:"uri" locationName:"IdentityId" min:"1" type:"string" required:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. GUID generation is unique within a region.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`

	// A list of patch operations.
	RecordPatches []*RecordPatch `type:"list"`

	// The SyncSessionToken returned by a previous call to ListRecords for this
	// dataset and identity.
	//
	// SyncSessionToken is a required field
	SyncSessionToken *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateRecordsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRecordsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRecordsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRecordsInput"}
	if s.DatasetName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetName", 1))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}
	if s.IdentityId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityId", 1))
	}
	if s.IdentityPoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityPoolId", 1))
	}
	if s.SyncSessionToken == nil {
		invalidParams.Add(request.NewErrParamRequired("SyncSessionToken"))
	}
	if s.RecordPatches != nil {
		for i, v := range s.RecordPatches {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RecordPatches", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Returned for a successful UpdateRecordsRequest.
type UpdateRecordsOutput struct {
	_ struct{} `type:"structure"`

	// A list of records that have been updated.
	Records []*Record `type:"list"`
}

// String returns the string representation
func (s UpdateRecordsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRecordsOutput) GoString() string {
	return s.String()
}

const (
	// BulkPublishStatusNotStarted is a BulkPublishStatus enum value
	BulkPublishStatusNotStarted = "NOT_STARTED"

	// BulkPublishStatusInProgress is a BulkPublishStatus enum value
	BulkPublishStatusInProgress = "IN_PROGRESS"

	// BulkPublishStatusFailed is a BulkPublishStatus enum value
	BulkPublishStatusFailed = "FAILED"

	// BulkPublishStatusSucceeded is a BulkPublishStatus enum value
	BulkPublishStatusSucceeded = "SUCCEEDED"
)

const (
	// OperationReplace is a Operation enum value
	OperationReplace = "replace"

	// OperationRemove is a Operation enum value
	OperationRemove = "remove"
)

const (
	// PlatformApns is a Platform enum value
	PlatformApns = "APNS"

	// PlatformApnsSandbox is a Platform enum value
	PlatformApnsSandbox = "APNS_SANDBOX"

	// PlatformGcm is a Platform enum value
	PlatformGcm = "GCM"

	// PlatformAdm is a Platform enum value
	PlatformAdm = "ADM"
)

const (
	// StreamingStatusEnabled is a StreamingStatus enum value
	StreamingStatusEnabled = "ENABLED"

	// StreamingStatusDisabled is a StreamingStatus enum value
	StreamingStatusDisabled = "DISABLED"
)
