// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// The specified CIDR IP range or Amazon EC2 security group is already authorized
// for the specified DB security group.
type AuthorizationAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AuthorizationAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AuthorizationAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AuthorizationAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AuthorizationAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *AuthorizationAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified CIDR IP range or Amazon EC2 security group might not be authorized
// for the specified DB security group. Or, RDS might not be authorized to perform
// necessary actions using IAM on your behalf.
type AuthorizationNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AuthorizationNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AuthorizationNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AuthorizationNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AuthorizationNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *AuthorizationNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The DB security group authorization quota has been reached.
type AuthorizationQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AuthorizationQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AuthorizationQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AuthorizationQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AuthorizationQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *AuthorizationQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

type BackupPolicyNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *BackupPolicyNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *BackupPolicyNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *BackupPolicyNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "BackupPolicyNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *BackupPolicyNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A blue/green deployment with the specified name already exists.
type BlueGreenDeploymentAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *BlueGreenDeploymentAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *BlueGreenDeploymentAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *BlueGreenDeploymentAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "BlueGreenDeploymentAlreadyExistsFault"
	}
	return *e.ErrorCodeOverride
}
func (e *BlueGreenDeploymentAlreadyExistsFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// BlueGreenDeploymentIdentifier doesn't refer to an existing blue/green
// deployment.
type BlueGreenDeploymentNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *BlueGreenDeploymentNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *BlueGreenDeploymentNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *BlueGreenDeploymentNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "BlueGreenDeploymentNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *BlueGreenDeploymentNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// CertificateIdentifier doesn't refer to an existing certificate.
type CertificateNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CertificateNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CertificateNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CertificateNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CertificateNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *CertificateNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An error occurred while trying to create the CEV.
type CreateCustomDBEngineVersionFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CreateCustomDBEngineVersionFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CreateCustomDBEngineVersionFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CreateCustomDBEngineVersionFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CreateCustomDBEngineVersionFault"
	}
	return *e.ErrorCodeOverride
}
func (e *CreateCustomDBEngineVersionFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// CustomAvailabilityZoneId doesn't refer to an existing custom Availability Zone
// identifier.
type CustomAvailabilityZoneNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CustomAvailabilityZoneNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CustomAvailabilityZoneNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CustomAvailabilityZoneNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CustomAvailabilityZoneNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *CustomAvailabilityZoneNotFoundFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// A CEV with the specified name already exists.
type CustomDBEngineVersionAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CustomDBEngineVersionAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CustomDBEngineVersionAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CustomDBEngineVersionAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CustomDBEngineVersionAlreadyExistsFault"
	}
	return *e.ErrorCodeOverride
}
func (e *CustomDBEngineVersionAlreadyExistsFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified CEV was not found.
type CustomDBEngineVersionNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CustomDBEngineVersionNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CustomDBEngineVersionNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CustomDBEngineVersionNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CustomDBEngineVersionNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *CustomDBEngineVersionNotFoundFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have exceeded your CEV quota.
type CustomDBEngineVersionQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CustomDBEngineVersionQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CustomDBEngineVersionQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CustomDBEngineVersionQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CustomDBEngineVersionQuotaExceededFault"
	}
	return *e.ErrorCodeOverride
}
func (e *CustomDBEngineVersionQuotaExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The user already has a DB cluster with the given identifier.
type DBClusterAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBClusterAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBClusterAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBClusterAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBClusterAlreadyExistsFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DBClusterAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// BacktrackIdentifier doesn't refer to an existing backtrack.
type DBClusterBacktrackNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBClusterBacktrackNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBClusterBacktrackNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBClusterBacktrackNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBClusterBacktrackNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DBClusterBacktrackNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified custom endpoint can't be created because it already exists.
type DBClusterEndpointAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBClusterEndpointAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBClusterEndpointAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBClusterEndpointAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBClusterEndpointAlreadyExistsFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DBClusterEndpointAlreadyExistsFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified custom endpoint doesn't exist.
type DBClusterEndpointNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBClusterEndpointNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBClusterEndpointNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBClusterEndpointNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBClusterEndpointNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DBClusterEndpointNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The cluster already has the maximum number of custom endpoints.
type DBClusterEndpointQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBClusterEndpointQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBClusterEndpointQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBClusterEndpointQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBClusterEndpointQuotaExceededFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DBClusterEndpointQuotaExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// DBClusterIdentifier doesn't refer to an existing DB cluster.
type DBClusterNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBClusterNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBClusterNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBClusterNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBClusterNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DBClusterNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// DBClusterParameterGroupName doesn't refer to an existing DB cluster parameter
// group.
type DBClusterParameterGroupNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBClusterParameterGroupNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBClusterParameterGroupNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBClusterParameterGroupNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBClusterParameterGroupNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *DBClusterParameterGroupNotFoundFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The user attempted to create a new DB cluster and the user has already reached
// the maximum allowed DB cluster quota.
type DBClusterQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBClusterQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBClusterQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBClusterQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBClusterQuotaExceededFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DBClusterQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified IAM role Amazon Resource Name (ARN) is already associated with the
// specified DB cluster.
type DBClusterRoleAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBClusterRoleAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBClusterRoleAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBClusterRoleAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBClusterRoleAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *DBClusterRoleAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified IAM role Amazon Resource Name (ARN) isn't associated with the
// specified DB cluster.
type DBClusterRoleNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBClusterRoleNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBClusterRoleNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBClusterRoleNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBClusterRoleNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *DBClusterRoleNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have exceeded the maximum number of IAM roles that can be associated with
// the specified DB cluster.
type DBClusterRoleQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBClusterRoleQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBClusterRoleQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBClusterRoleQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBClusterRoleQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *DBClusterRoleQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The user already has a DB cluster snapshot with the given identifier.
type DBClusterSnapshotAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBClusterSnapshotAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBClusterSnapshotAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBClusterSnapshotAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBClusterSnapshotAlreadyExistsFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DBClusterSnapshotAlreadyExistsFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// DBClusterSnapshotIdentifier doesn't refer to an existing DB cluster snapshot.
type DBClusterSnapshotNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBClusterSnapshotNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBClusterSnapshotNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBClusterSnapshotNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBClusterSnapshotNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DBClusterSnapshotNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The user already has a DB instance with the given identifier.
type DBInstanceAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBInstanceAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBInstanceAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBInstanceAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBInstanceAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *DBInstanceAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// No automated backup for this DB instance was found.
type DBInstanceAutomatedBackupNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBInstanceAutomatedBackupNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBInstanceAutomatedBackupNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBInstanceAutomatedBackupNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBInstanceAutomatedBackupNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *DBInstanceAutomatedBackupNotFoundFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The quota for retained automated backups was exceeded. This prevents you from
// retaining any additional automated backups. The retained automated backups quota
// is the same as your DB Instance quota.
type DBInstanceAutomatedBackupQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBInstanceAutomatedBackupQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBInstanceAutomatedBackupQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBInstanceAutomatedBackupQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBInstanceAutomatedBackupQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *DBInstanceAutomatedBackupQuotaExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// DBInstanceIdentifier doesn't refer to an existing DB instance.
type DBInstanceNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBInstanceNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBInstanceNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBInstanceNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBInstanceNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *DBInstanceNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified RoleArn or FeatureName value is already associated with the DB
// instance.
type DBInstanceRoleAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBInstanceRoleAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBInstanceRoleAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBInstanceRoleAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBInstanceRoleAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *DBInstanceRoleAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified RoleArn value doesn't match the specified feature for the DB
// instance.
type DBInstanceRoleNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBInstanceRoleNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBInstanceRoleNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBInstanceRoleNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBInstanceRoleNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *DBInstanceRoleNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You can't associate any more Amazon Web Services Identity and Access Management
// (IAM) roles with the DB instance because the quota has been reached.
type DBInstanceRoleQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBInstanceRoleQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBInstanceRoleQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBInstanceRoleQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBInstanceRoleQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *DBInstanceRoleQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// LogFileName doesn't refer to an existing DB log file.
type DBLogFileNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBLogFileNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBLogFileNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBLogFileNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBLogFileNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DBLogFileNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A DB parameter group with the same name exists.
type DBParameterGroupAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBParameterGroupAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBParameterGroupAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBParameterGroupAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBParameterGroupAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *DBParameterGroupAlreadyExistsFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// DBParameterGroupName doesn't refer to an existing DB parameter group.
type DBParameterGroupNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBParameterGroupNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBParameterGroupNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBParameterGroupNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBParameterGroupNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *DBParameterGroupNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request would result in the user exceeding the allowed number of DB
// parameter groups.
type DBParameterGroupQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBParameterGroupQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBParameterGroupQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBParameterGroupQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBParameterGroupQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *DBParameterGroupQuotaExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified proxy name must be unique for all proxies owned by your Amazon Web
// Services account in the specified Amazon Web Services Region.
type DBProxyAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBProxyAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBProxyAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBProxyAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBProxyAlreadyExistsFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DBProxyAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified DB proxy endpoint name must be unique for all DB proxy endpoints
// owned by your Amazon Web Services account in the specified Amazon Web Services
// Region.
type DBProxyEndpointAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBProxyEndpointAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBProxyEndpointAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBProxyEndpointAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBProxyEndpointAlreadyExistsFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DBProxyEndpointAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The DB proxy endpoint doesn't exist.
type DBProxyEndpointNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBProxyEndpointNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBProxyEndpointNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBProxyEndpointNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBProxyEndpointNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DBProxyEndpointNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The DB proxy already has the maximum number of endpoints.
type DBProxyEndpointQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBProxyEndpointQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBProxyEndpointQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBProxyEndpointQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBProxyEndpointQuotaExceededFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DBProxyEndpointQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified proxy name doesn't correspond to a proxy owned by your Amazon Web
// Services account in the specified Amazon Web Services Region.
type DBProxyNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBProxyNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBProxyNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBProxyNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBProxyNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DBProxyNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Your Amazon Web Services account already has the maximum number of proxies in
// the specified Amazon Web Services Region.
type DBProxyQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBProxyQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBProxyQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBProxyQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBProxyQuotaExceededFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DBProxyQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The proxy is already associated with the specified RDS DB instance or Aurora DB
// cluster.
type DBProxyTargetAlreadyRegisteredFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBProxyTargetAlreadyRegisteredFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBProxyTargetAlreadyRegisteredFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBProxyTargetAlreadyRegisteredFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBProxyTargetAlreadyRegisteredFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DBProxyTargetAlreadyRegisteredFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified target group isn't available for a proxy owned by your Amazon Web
// Services account in the specified Amazon Web Services Region.
type DBProxyTargetGroupNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBProxyTargetGroupNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBProxyTargetGroupNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBProxyTargetGroupNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBProxyTargetGroupNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DBProxyTargetGroupNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified RDS DB instance or Aurora DB cluster isn't available for a proxy
// owned by your Amazon Web Services account in the specified Amazon Web Services
// Region.
type DBProxyTargetNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBProxyTargetNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBProxyTargetNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBProxyTargetNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBProxyTargetNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DBProxyTargetNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A DB security group with the name specified in DBSecurityGroupName already
// exists.
type DBSecurityGroupAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBSecurityGroupAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBSecurityGroupAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBSecurityGroupAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBSecurityGroupAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *DBSecurityGroupAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// DBSecurityGroupName doesn't refer to an existing DB security group.
type DBSecurityGroupNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBSecurityGroupNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBSecurityGroupNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBSecurityGroupNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBSecurityGroupNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *DBSecurityGroupNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A DB security group isn't allowed for this action.
type DBSecurityGroupNotSupportedFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBSecurityGroupNotSupportedFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBSecurityGroupNotSupportedFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBSecurityGroupNotSupportedFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBSecurityGroupNotSupported"
	}
	return *e.ErrorCodeOverride
}
func (e *DBSecurityGroupNotSupportedFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request would result in the user exceeding the allowed number of DB security
// groups.
type DBSecurityGroupQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBSecurityGroupQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBSecurityGroupQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBSecurityGroupQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "QuotaExceeded.DBSecurityGroup"
	}
	return *e.ErrorCodeOverride
}
func (e *DBSecurityGroupQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// DBSnapshotIdentifier is already used by an existing snapshot.
type DBSnapshotAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBSnapshotAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBSnapshotAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBSnapshotAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBSnapshotAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *DBSnapshotAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// DBSnapshotIdentifier doesn't refer to an existing DB snapshot.
type DBSnapshotNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBSnapshotNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBSnapshotNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBSnapshotNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBSnapshotNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *DBSnapshotNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// DBSubnetGroupName is already used by an existing DB subnet group.
type DBSubnetGroupAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBSubnetGroupAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBSubnetGroupAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBSubnetGroupAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBSubnetGroupAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *DBSubnetGroupAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Subnets in the DB subnet group should cover at least two Availability Zones
// unless there is only one Availability Zone.
type DBSubnetGroupDoesNotCoverEnoughAZs struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBSubnetGroupDoesNotCoverEnoughAZs) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBSubnetGroupDoesNotCoverEnoughAZs) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBSubnetGroupDoesNotCoverEnoughAZs) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBSubnetGroupDoesNotCoverEnoughAZs"
	}
	return *e.ErrorCodeOverride
}
func (e *DBSubnetGroupDoesNotCoverEnoughAZs) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The DBSubnetGroup shouldn't be specified while creating read replicas that lie
// in the same region as the source instance.
type DBSubnetGroupNotAllowedFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBSubnetGroupNotAllowedFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBSubnetGroupNotAllowedFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBSubnetGroupNotAllowedFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBSubnetGroupNotAllowedFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DBSubnetGroupNotAllowedFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// DBSubnetGroupName doesn't refer to an existing DB subnet group.
type DBSubnetGroupNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBSubnetGroupNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBSubnetGroupNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBSubnetGroupNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBSubnetGroupNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DBSubnetGroupNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request would result in the user exceeding the allowed number of DB subnet
// groups.
type DBSubnetGroupQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBSubnetGroupQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBSubnetGroupQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBSubnetGroupQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBSubnetGroupQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *DBSubnetGroupQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request would result in the user exceeding the allowed number of subnets in
// a DB subnet groups.
type DBSubnetQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBSubnetQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBSubnetQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBSubnetQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBSubnetQuotaExceededFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DBSubnetQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The DB upgrade failed because a resource the DB depends on can't be modified.
type DBUpgradeDependencyFailureFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DBUpgradeDependencyFailureFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DBUpgradeDependencyFailureFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DBUpgradeDependencyFailureFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DBUpgradeDependencyFailure"
	}
	return *e.ErrorCodeOverride
}
func (e *DBUpgradeDependencyFailureFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Domain doesn't refer to an existing Active Directory domain.
type DomainNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DomainNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DomainNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DomainNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DomainNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *DomainNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The AMI configuration prerequisite has not been met.
type Ec2ImagePropertiesNotSupportedFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *Ec2ImagePropertiesNotSupportedFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *Ec2ImagePropertiesNotSupportedFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *Ec2ImagePropertiesNotSupportedFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "Ec2ImagePropertiesNotSupportedFault"
	}
	return *e.ErrorCodeOverride
}
func (e *Ec2ImagePropertiesNotSupportedFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You have reached the maximum number of event subscriptions.
type EventSubscriptionQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EventSubscriptionQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EventSubscriptionQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EventSubscriptionQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "EventSubscriptionQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *EventSubscriptionQuotaExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You can't start an export task that's already running.
type ExportTaskAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ExportTaskAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ExportTaskAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ExportTaskAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ExportTaskAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *ExportTaskAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The export task doesn't exist.
type ExportTaskNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ExportTaskNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ExportTaskNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ExportTaskNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ExportTaskNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *ExportTaskNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The GlobalClusterIdentifier already exists. Choose a new global database
// identifier (unique name) to create a new global database cluster.
type GlobalClusterAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *GlobalClusterAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *GlobalClusterAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *GlobalClusterAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "GlobalClusterAlreadyExistsFault"
	}
	return *e.ErrorCodeOverride
}
func (e *GlobalClusterAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The GlobalClusterIdentifier doesn't refer to an existing global database
// cluster.
type GlobalClusterNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *GlobalClusterNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *GlobalClusterNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *GlobalClusterNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "GlobalClusterNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *GlobalClusterNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of global database clusters for this account is already at the
// maximum allowed.
type GlobalClusterQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *GlobalClusterQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *GlobalClusterQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *GlobalClusterQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "GlobalClusterQuotaExceededFault"
	}
	return *e.ErrorCodeOverride
}
func (e *GlobalClusterQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The IAM role requires additional permissions to export to an Amazon S3 bucket.
type IamRoleMissingPermissionsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *IamRoleMissingPermissionsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IamRoleMissingPermissionsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IamRoleMissingPermissionsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "IamRoleMissingPermissions"
	}
	return *e.ErrorCodeOverride
}
func (e *IamRoleMissingPermissionsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The IAM role is missing for exporting to an Amazon S3 bucket.
type IamRoleNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *IamRoleNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IamRoleNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IamRoleNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "IamRoleNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *IamRoleNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request would result in the user exceeding the allowed number of DB
// instances.
type InstanceQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InstanceQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InstanceQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InstanceQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InstanceQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *InstanceQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The requested operation can't be performed because there aren't enough available
// IP addresses in the proxy's subnets. Add more CIDR blocks to the VPC or remove
// IP address that aren't required from the subnets.
type InsufficientAvailableIPsInSubnetFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InsufficientAvailableIPsInSubnetFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InsufficientAvailableIPsInSubnetFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InsufficientAvailableIPsInSubnetFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InsufficientAvailableIPsInSubnetFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InsufficientAvailableIPsInSubnetFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The DB cluster doesn't have enough capacity for the current operation.
type InsufficientDBClusterCapacityFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InsufficientDBClusterCapacityFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InsufficientDBClusterCapacityFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InsufficientDBClusterCapacityFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InsufficientDBClusterCapacityFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InsufficientDBClusterCapacityFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified DB instance class isn't available in the specified Availability
// Zone.
type InsufficientDBInstanceCapacityFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InsufficientDBInstanceCapacityFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InsufficientDBInstanceCapacityFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InsufficientDBInstanceCapacityFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InsufficientDBInstanceCapacity"
	}
	return *e.ErrorCodeOverride
}
func (e *InsufficientDBInstanceCapacityFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// There is insufficient storage available for the current action. You might be
// able to resolve this error by updating your subnet group to use different
// Availability Zones that have more storage available.
type InsufficientStorageClusterCapacityFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InsufficientStorageClusterCapacityFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InsufficientStorageClusterCapacityFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InsufficientStorageClusterCapacityFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InsufficientStorageClusterCapacity"
	}
	return *e.ErrorCodeOverride
}
func (e *InsufficientStorageClusterCapacityFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The blue/green deployment can't be switched over or deleted because there is an
// invalid configuration in the green environment.
type InvalidBlueGreenDeploymentStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidBlueGreenDeploymentStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidBlueGreenDeploymentStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidBlueGreenDeploymentStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidBlueGreenDeploymentStateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidBlueGreenDeploymentStateFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// You can't delete the CEV.
type InvalidCustomDBEngineVersionStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidCustomDBEngineVersionStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidCustomDBEngineVersionStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidCustomDBEngineVersionStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidCustomDBEngineVersionStateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidCustomDBEngineVersionStateFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Capacity isn't a valid Aurora Serverless DB cluster capacity. Valid capacity
// values are 2, 4, 8, 16, 32, 64, 128, and 256.
type InvalidDBClusterCapacityFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDBClusterCapacityFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDBClusterCapacityFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDBClusterCapacityFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidDBClusterCapacityFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDBClusterCapacityFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The requested operation can't be performed on the endpoint while the endpoint is
// in this state.
type InvalidDBClusterEndpointStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDBClusterEndpointStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDBClusterEndpointStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDBClusterEndpointStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidDBClusterEndpointStateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDBClusterEndpointStateFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The supplied value isn't a valid DB cluster snapshot state.
type InvalidDBClusterSnapshotStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDBClusterSnapshotStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDBClusterSnapshotStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDBClusterSnapshotStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidDBClusterSnapshotStateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDBClusterSnapshotStateFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The requested operation can't be performed while the cluster is in this state.
type InvalidDBClusterStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDBClusterStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDBClusterStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDBClusterStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidDBClusterStateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDBClusterStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The automated backup is in an invalid state. For example, this automated backup
// is associated with an active instance.
type InvalidDBInstanceAutomatedBackupStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDBInstanceAutomatedBackupStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDBInstanceAutomatedBackupStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDBInstanceAutomatedBackupStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidDBInstanceAutomatedBackupState"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDBInstanceAutomatedBackupStateFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The DB instance isn't in a valid state.
type InvalidDBInstanceStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDBInstanceStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDBInstanceStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDBInstanceStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidDBInstanceState"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDBInstanceStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The DB parameter group is in use or is in an invalid state. If you are
// attempting to delete the parameter group, you can't delete it when the parameter
// group is in this state.
type InvalidDBParameterGroupStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDBParameterGroupStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDBParameterGroupStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDBParameterGroupStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidDBParameterGroupState"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDBParameterGroupStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You can't perform this operation while the DB proxy endpoint is in a particular
// state.
type InvalidDBProxyEndpointStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDBProxyEndpointStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDBProxyEndpointStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDBProxyEndpointStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidDBProxyEndpointStateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDBProxyEndpointStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The requested operation can't be performed while the proxy is in this state.
type InvalidDBProxyStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDBProxyStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDBProxyStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDBProxyStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidDBProxyStateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDBProxyStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The state of the DB security group doesn't allow deletion.
type InvalidDBSecurityGroupStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDBSecurityGroupStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDBSecurityGroupStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDBSecurityGroupStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidDBSecurityGroupState"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDBSecurityGroupStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The state of the DB snapshot doesn't allow deletion.
type InvalidDBSnapshotStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDBSnapshotStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDBSnapshotStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDBSnapshotStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidDBSnapshotState"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDBSnapshotStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The DBSubnetGroup doesn't belong to the same VPC as that of an existing
// cross-region read replica of the same source instance.
type InvalidDBSubnetGroupFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDBSubnetGroupFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDBSubnetGroupFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDBSubnetGroupFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidDBSubnetGroupFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDBSubnetGroupFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The DB subnet group cannot be deleted because it's in use.
type InvalidDBSubnetGroupStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDBSubnetGroupStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDBSubnetGroupStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDBSubnetGroupStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidDBSubnetGroupStateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDBSubnetGroupStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The DB subnet isn't in the available state.
type InvalidDBSubnetStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidDBSubnetStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidDBSubnetStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidDBSubnetStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidDBSubnetStateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidDBSubnetStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This error can occur if someone else is modifying a subscription. You should
// retry the action.
type InvalidEventSubscriptionStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidEventSubscriptionStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidEventSubscriptionStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidEventSubscriptionStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidEventSubscriptionState"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidEventSubscriptionStateFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The export is invalid for exporting to an Amazon S3 bucket.
type InvalidExportOnlyFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidExportOnlyFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidExportOnlyFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidExportOnlyFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidExportOnly"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidExportOnlyFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The state of the export snapshot is invalid for exporting to an Amazon S3
// bucket.
type InvalidExportSourceStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidExportSourceStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidExportSourceStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidExportSourceStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidExportSourceState"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidExportSourceStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You can't cancel an export task that has completed.
type InvalidExportTaskStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidExportTaskStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidExportTaskStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidExportTaskStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidExportTaskStateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidExportTaskStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The global cluster is in an invalid state and can't perform the requested
// operation.
type InvalidGlobalClusterStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidGlobalClusterStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidGlobalClusterStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidGlobalClusterStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidGlobalClusterStateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidGlobalClusterStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The option group isn't in the available state.
type InvalidOptionGroupStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidOptionGroupStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidOptionGroupStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidOptionGroupStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidOptionGroupStateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidOptionGroupStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Cannot restore from VPC backup to non-VPC DB instance.
type InvalidRestoreFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidRestoreFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidRestoreFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidRestoreFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidRestoreFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidRestoreFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified Amazon S3 bucket name can't be found or Amazon RDS isn't
// authorized to access the specified Amazon S3 bucket. Verify the
// SourceS3BucketName and S3IngestionRoleArn values and try again.
type InvalidS3BucketFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidS3BucketFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidS3BucketFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidS3BucketFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidS3BucketFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidS3BucketFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The requested subnet is invalid, or multiple subnets were requested that are not
// all in a common VPC.
type InvalidSubnet struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidSubnet) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidSubnet) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidSubnet) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidSubnet"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidSubnet) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The DB subnet group doesn't cover all Availability Zones after it's created
// because of users' change.
type InvalidVPCNetworkStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidVPCNetworkStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidVPCNetworkStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidVPCNetworkStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidVPCNetworkStateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidVPCNetworkStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An error occurred accessing an Amazon Web Services KMS key.
type KMSKeyNotAccessibleFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *KMSKeyNotAccessibleFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *KMSKeyNotAccessibleFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *KMSKeyNotAccessibleFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "KMSKeyNotAccessibleFault"
	}
	return *e.ErrorCodeOverride
}
func (e *KMSKeyNotAccessibleFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The network type is invalid for the DB instance. Valid nework type values are
// IPV4 and DUAL.
type NetworkTypeNotSupported struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NetworkTypeNotSupported) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NetworkTypeNotSupported) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NetworkTypeNotSupported) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NetworkTypeNotSupported"
	}
	return *e.ErrorCodeOverride
}
func (e *NetworkTypeNotSupported) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The option group you are trying to create already exists.
type OptionGroupAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OptionGroupAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OptionGroupAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OptionGroupAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OptionGroupAlreadyExistsFault"
	}
	return *e.ErrorCodeOverride
}
func (e *OptionGroupAlreadyExistsFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified option group could not be found.
type OptionGroupNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OptionGroupNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OptionGroupNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OptionGroupNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OptionGroupNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *OptionGroupNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The quota of 20 option groups was exceeded for this Amazon Web Services account.
type OptionGroupQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OptionGroupQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OptionGroupQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OptionGroupQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OptionGroupQuotaExceededFault"
	}
	return *e.ErrorCodeOverride
}
func (e *OptionGroupQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// SourceDBInstanceIdentifier refers to a DB instance with BackupRetentionPeriod
// equal to 0.
type PointInTimeRestoreNotEnabledFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PointInTimeRestoreNotEnabledFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PointInTimeRestoreNotEnabledFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PointInTimeRestoreNotEnabledFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "PointInTimeRestoreNotEnabled"
	}
	return *e.ErrorCodeOverride
}
func (e *PointInTimeRestoreNotEnabledFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Provisioned IOPS not available in the specified Availability Zone.
type ProvisionedIopsNotAvailableInAZFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ProvisionedIopsNotAvailableInAZFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ProvisionedIopsNotAvailableInAZFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ProvisionedIopsNotAvailableInAZFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ProvisionedIopsNotAvailableInAZFault"
	}
	return *e.ErrorCodeOverride
}
func (e *ProvisionedIopsNotAvailableInAZFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// User already has a reservation with the given identifier.
type ReservedDBInstanceAlreadyExistsFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReservedDBInstanceAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReservedDBInstanceAlreadyExistsFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReservedDBInstanceAlreadyExistsFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ReservedDBInstanceAlreadyExists"
	}
	return *e.ErrorCodeOverride
}
func (e *ReservedDBInstanceAlreadyExistsFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified reserved DB Instance not found.
type ReservedDBInstanceNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReservedDBInstanceNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReservedDBInstanceNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReservedDBInstanceNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ReservedDBInstanceNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *ReservedDBInstanceNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Request would exceed the user's DB Instance quota.
type ReservedDBInstanceQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReservedDBInstanceQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReservedDBInstanceQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReservedDBInstanceQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ReservedDBInstanceQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *ReservedDBInstanceQuotaExceededFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Specified offering does not exist.
type ReservedDBInstancesOfferingNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ReservedDBInstancesOfferingNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ReservedDBInstancesOfferingNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ReservedDBInstancesOfferingNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ReservedDBInstancesOfferingNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *ReservedDBInstancesOfferingNotFoundFault) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified resource ID was not found.
type ResourceNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You have exceeded the maximum number of accounts that you can share a manual DB
// snapshot with.
type SharedSnapshotQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SharedSnapshotQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SharedSnapshotQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SharedSnapshotQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SharedSnapshotQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *SharedSnapshotQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request would result in the user exceeding the allowed number of DB
// snapshots.
type SnapshotQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SnapshotQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SnapshotQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SnapshotQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SnapshotQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *SnapshotQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// SNS has responded that there is a problem with the SNS topic specified.
type SNSInvalidTopicFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SNSInvalidTopicFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SNSInvalidTopicFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SNSInvalidTopicFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SNSInvalidTopic"
	}
	return *e.ErrorCodeOverride
}
func (e *SNSInvalidTopicFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You do not have permission to publish to the SNS topic ARN.
type SNSNoAuthorizationFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SNSNoAuthorizationFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SNSNoAuthorizationFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SNSNoAuthorizationFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SNSNoAuthorization"
	}
	return *e.ErrorCodeOverride
}
func (e *SNSNoAuthorizationFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The SNS topic ARN does not exist.
type SNSTopicArnNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SNSTopicArnNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SNSTopicArnNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SNSTopicArnNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SNSTopicArnNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *SNSTopicArnNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The source DB cluster isn't supported for a blue/green deployment.
type SourceClusterNotSupportedFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SourceClusterNotSupportedFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SourceClusterNotSupportedFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SourceClusterNotSupportedFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SourceClusterNotSupportedFault"
	}
	return *e.ErrorCodeOverride
}
func (e *SourceClusterNotSupportedFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The source DB instance isn't supported for a blue/green deployment.
type SourceDatabaseNotSupportedFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SourceDatabaseNotSupportedFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SourceDatabaseNotSupportedFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SourceDatabaseNotSupportedFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SourceDatabaseNotSupportedFault"
	}
	return *e.ErrorCodeOverride
}
func (e *SourceDatabaseNotSupportedFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The requested source could not be found.
type SourceNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SourceNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SourceNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SourceNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SourceNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *SourceNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The request would result in the user exceeding the allowed amount of storage
// available across all DB instances.
type StorageQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *StorageQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *StorageQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *StorageQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "StorageQuotaExceeded"
	}
	return *e.ErrorCodeOverride
}
func (e *StorageQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Storage of the StorageType specified can't be associated with the DB instance.
type StorageTypeNotSupportedFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *StorageTypeNotSupportedFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *StorageTypeNotSupportedFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *StorageTypeNotSupportedFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "StorageTypeNotSupported"
	}
	return *e.ErrorCodeOverride
}
func (e *StorageTypeNotSupportedFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The DB subnet is already in use in the Availability Zone.
type SubnetAlreadyInUse struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SubnetAlreadyInUse) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SubnetAlreadyInUse) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SubnetAlreadyInUse) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SubnetAlreadyInUse"
	}
	return *e.ErrorCodeOverride
}
func (e *SubnetAlreadyInUse) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The supplied subscription name already exists.
type SubscriptionAlreadyExistFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SubscriptionAlreadyExistFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SubscriptionAlreadyExistFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SubscriptionAlreadyExistFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SubscriptionAlreadyExist"
	}
	return *e.ErrorCodeOverride
}
func (e *SubscriptionAlreadyExistFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The supplied category does not exist.
type SubscriptionCategoryNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SubscriptionCategoryNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SubscriptionCategoryNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SubscriptionCategoryNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SubscriptionCategoryNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *SubscriptionCategoryNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The subscription name does not exist.
type SubscriptionNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SubscriptionNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SubscriptionNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SubscriptionNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SubscriptionNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *SubscriptionNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
