// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// Either the Amazon Lex bot is still building, or one of the dependent services
// (Amazon Polly, AWS Lambda) failed with an internal service error.
type BadGatewayException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *BadGatewayException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *BadGatewayException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *BadGatewayException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "BadGatewayException"
	}
	return *e.ErrorCodeOverride
}
func (e *BadGatewayException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// Request validation failed, there is no usable message in the context, or the bot
// build failed, is still in progress, or contains unbuilt changes.
type BadRequestException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *BadRequestException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *BadRequestException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "BadRequestException"
	}
	return *e.ErrorCodeOverride
}
func (e *BadRequestException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Two clients are using the same AWS account, Amazon Lex bot, and user ID.
type ConflictException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ConflictException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ConflictException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ConflictException"
	}
	return *e.ErrorCodeOverride
}
func (e *ConflictException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// One of the dependencies, such as AWS Lambda or Amazon Polly, threw an exception.
// For example,
//
// * If Amazon Lex does not have sufficient permissions to call a
// Lambda function.
//
// * If a Lambda function takes longer than 30 seconds to
// execute.
//
// * If a fulfillment Lambda function returns a Delegate dialog action
// without removing any slot values.
type DependencyFailedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DependencyFailedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DependencyFailedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DependencyFailedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DependencyFailedException"
	}
	return *e.ErrorCodeOverride
}
func (e *DependencyFailedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Internal service error. Retry the call.
type InternalFailureException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InternalFailureException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InternalFailureException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InternalFailureException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InternalFailureException"
	}
	return *e.ErrorCodeOverride
}
func (e *InternalFailureException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// Exceeded a limit.
type LimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	RetryAfterSeconds *string

	noSmithyDocumentSerde
}

func (e *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *LimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *LimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "LimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *LimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// This exception is not used.
type LoopDetectedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *LoopDetectedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *LoopDetectedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *LoopDetectedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "LoopDetectedException"
	}
	return *e.ErrorCodeOverride
}
func (e *LoopDetectedException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// The accept header in the request does not have a valid value.
type NotAcceptableException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NotAcceptableException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NotAcceptableException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NotAcceptableException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NotAcceptableException"
	}
	return *e.ErrorCodeOverride
}
func (e *NotAcceptableException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The resource (such as the Amazon Lex bot or an alias) that is referred to is not
// found.
type NotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *NotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The input speech is too long.
type RequestTimeoutException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *RequestTimeoutException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RequestTimeoutException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RequestTimeoutException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "RequestTimeoutException"
	}
	return *e.ErrorCodeOverride
}
func (e *RequestTimeoutException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The Content-Type header (PostContent API) has an invalid value.
type UnsupportedMediaTypeException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnsupportedMediaTypeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnsupportedMediaTypeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnsupportedMediaTypeException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnsupportedMediaTypeException"
	}
	return *e.ErrorCodeOverride
}
func (e *UnsupportedMediaTypeException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
