// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// Access to a resource was denied.
type AccessDeniedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccessDeniedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccessDeniedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AccessDeniedException"
	}
	return *e.ErrorCodeOverride
}
func (e *AccessDeniedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A resource to be created or added already exists.
type AlreadyExistsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AlreadyExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AlreadyExistsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AlreadyExistsException"
	}
	return *e.ErrorCodeOverride
}
func (e *AlreadyExistsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Two processes are trying to modify a resource simultaneously.
type ConcurrentModificationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ConcurrentModificationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ConcurrentModificationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ConcurrentModificationException"
	}
	return *e.ErrorCodeOverride
}
func (e *ConcurrentModificationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A specified entity does not exist.
type EntityNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EntityNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EntityNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EntityNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "EntityNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *EntityNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Contains details about an error where the query request expired.
type ExpiredException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ExpiredException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ExpiredException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ExpiredException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ExpiredException"
	}
	return *e.ErrorCodeOverride
}
func (e *ExpiredException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An encryption operation failed.
type GlueEncryptionException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *GlueEncryptionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *GlueEncryptionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *GlueEncryptionException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "GlueEncryptionException"
	}
	return *e.ErrorCodeOverride
}
func (e *GlueEncryptionException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An internal service error occurred.
type InternalServiceException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InternalServiceException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InternalServiceException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InternalServiceException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InternalServiceException"
	}
	return *e.ErrorCodeOverride
}
func (e *InternalServiceException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// The input provided was not valid.
type InvalidInputException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidInputException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidInputException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidInputException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidInputException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidInputException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation timed out.
type OperationTimeoutException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OperationTimeoutException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OperationTimeoutException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OperationTimeoutException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OperationTimeoutException"
	}
	return *e.ErrorCodeOverride
}
func (e *OperationTimeoutException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The engine does not support filtering data based on the enforced permissions.
// For example, if you call the GetTemporaryGlueTableCredentials operation with
// SupportedPermissionType equal to ColumnPermission, but cell-level permissions
// exist on the table, this exception is thrown.
type PermissionTypeMismatchException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PermissionTypeMismatchException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PermissionTypeMismatchException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PermissionTypeMismatchException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "PermissionTypeMismatchException"
	}
	return *e.ErrorCodeOverride
}
func (e *PermissionTypeMismatchException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Contains details about an error related to a resource which is not ready for a
// transaction.
type ResourceNotReadyException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceNotReadyException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNotReadyException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNotReadyException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceNotReadyException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceNotReadyException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A resource numerical limit was exceeded.
type ResourceNumberLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceNumberLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNumberLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNumberLimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceNumberLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceNumberLimitExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Contains details about an error related to statistics not being ready.
type StatisticsNotReadyYetException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *StatisticsNotReadyYetException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *StatisticsNotReadyYetException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *StatisticsNotReadyYetException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "StatisticsNotReadyYetException"
	}
	return *e.ErrorCodeOverride
}
func (e *StatisticsNotReadyYetException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Contains details about an error where the query request was throttled.
type ThrottledException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ThrottledException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ThrottledException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ThrottledException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ThrottledException"
	}
	return *e.ErrorCodeOverride
}
func (e *ThrottledException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Contains details about an error related to a transaction that was cancelled.
type TransactionCanceledException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TransactionCanceledException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TransactionCanceledException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TransactionCanceledException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TransactionCanceledException"
	}
	return *e.ErrorCodeOverride
}
func (e *TransactionCanceledException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Contains details about an error related to a transaction commit that was in
// progress.
type TransactionCommitInProgressException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TransactionCommitInProgressException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TransactionCommitInProgressException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TransactionCommitInProgressException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TransactionCommitInProgressException"
	}
	return *e.ErrorCodeOverride
}
func (e *TransactionCommitInProgressException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Contains details about an error where the specified transaction has already been
// committed and cannot be used for UpdateTableObjects.
type TransactionCommittedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TransactionCommittedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TransactionCommittedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TransactionCommittedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TransactionCommittedException"
	}
	return *e.ErrorCodeOverride
}
func (e *TransactionCommittedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Contains details about an error related to work units not being ready.
type WorkUnitsNotReadyYetException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *WorkUnitsNotReadyYetException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *WorkUnitsNotReadyYetException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *WorkUnitsNotReadyYetException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "WorkUnitsNotReadyYetException"
	}
	return *e.ErrorCodeOverride
}
func (e *WorkUnitsNotReadyYetException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
