// Code generated by smithy-go-codegen DO NOT EDIT.

package datasync

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/datasync/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Configures a task, which defines where and how DataSync transfers your data. A
// task includes a source location, a destination location, and the preferences for
// how and when you want to transfer your data (such as bandwidth limits,
// scheduling, among other options).
func (c *Client) CreateTask(ctx context.Context, params *CreateTaskInput, optFns ...func(*Options)) (*CreateTaskOutput, error) {
	if params == nil {
		params = &CreateTaskInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateTask", params, optFns, c.addOperationCreateTaskMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateTaskOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// CreateTaskRequest
type CreateTaskInput struct {

	// The Amazon Resource Name (ARN) of an Amazon Web Services storage resource's
	// location.
	//
	// This member is required.
	DestinationLocationArn *string

	// The Amazon Resource Name (ARN) of the source location for the task.
	//
	// This member is required.
	SourceLocationArn *string

	// The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that is used
	// to monitor and log events in the task.
	CloudWatchLogGroupArn *string

	// Specifies a list of filter rules that exclude specific data during your
	// transfer. For more information and examples, see Filtering data transferred by
	// DataSync (https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
	Excludes []types.FilterRule

	// Specifies a list of filter rules that include specific data during your
	// transfer. For more information and examples, see Filtering data transferred by
	// DataSync (https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html).
	Includes []types.FilterRule

	// The name of a task. This value is a text reference that is used to identify the
	// task in the console.
	Name *string

	// Specifies the configuration options for a task. Some options include preserving
	// file or object metadata and verifying data integrity. You can also override
	// these options before starting an individual run of a task (also known as a task
	// execution). For more information, see StartTaskExecution
	// (https://docs.aws.amazon.com/datasync/latest/userguide/API_StartTaskExecution.html).
	Options *types.Options

	// Specifies a schedule used to periodically transfer files from a source to a
	// destination location. The schedule should be specified in UTC time. For more
	// information, see Scheduling your task
	// (https://docs.aws.amazon.com/datasync/latest/userguide/task-scheduling.html).
	Schedule *types.TaskSchedule

	// Specifies the tags that you want to apply to the Amazon Resource Name (ARN)
	// representing the task. Tags are key-value pairs that help you manage, filter,
	// and search for your DataSync resources.
	Tags []types.TagListEntry

	noSmithyDocumentSerde
}

// CreateTaskResponse
type CreateTaskOutput struct {

	// The Amazon Resource Name (ARN) of the task.
	TaskArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateTaskMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateTask{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateTask{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateTaskValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateTask(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateTask(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "datasync",
		OperationName: "CreateTask",
	}
}
