/* Gnome Scan - Scan as easy as you print
 * Copyright © 2007  Étienne Bersac <bersace03@laposte.net>
 *
 * Gnome Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <glib/gi18n.h>
#include "flegita-sink.h"
#include "flegita-pspec.h"
#include "flegita-output-filename-widget.h"
#include "flegita-action-selector.h"

/* ACTION */
GS_DEFINE_PARAM (flegita, Flegita, action, Action, FLEGITA_TYPE_ACTION);

GParamSpec*
flegita_param_spec_action	(const gchar *name,
				 const gchar *nick,
				 const gchar *blurb,
				 GQuark group,
				 FlegitaAction default_action,
				 GParamFlags flags)
{
  GParamSpec *spec = g_param_spec_internal (FLEGITA_TYPE_PARAM_ACTION,
					    name, nick, blurb, flags);
  g_param_spec_set_qdata (spec, GS_PARAM_GROUP_QUARK, (gpointer) group);
  gs_param_spec_set_widget_type (spec, FLEGITA_TYPE_ACTION_SELECTOR);
  return G_PARAM_SPEC (spec);
}


static void
flegita_param_action_value_set_default (GParamSpec *pspec, GValue *value)
{
  g_value_set_enum (value, FLEGITA_PARAM_SPEC_ACTION (pspec)->default_action);
}

static gint
flegita_param_action_values_cmp (GParamSpec *pspec, const GValue *a, const GValue *b)
{
  return g_value_get_enum (a) - g_value_get_enum (b);
}


/* FILENAME */
GS_DEFINE_PARAM (flegita, Flegita, output_filename, OutputFilename, G_TYPE_STRING);

/**
 * flegita_param_spec_output_filename:
 * @name: Param name
 * @nick: Param nick
 * @blurb: Param blurb
 * @group: The quark of the group the param belong to
 * @formats: The list of #GdkPixbufFormats
 * @flags: Param flags.
 * 
 * Create a new #GSParamSpecFilename.
 * 
 * Returns: The new #GSParamSpecFilename
 **/
GParamSpec*
flegita_param_spec_output_filename (const gchar *name,
				    const gchar *nick,
				    const gchar *blurb,
				    GQuark group,
				    GSList *formats,
				    GParamFlags flags)
{
  GParamSpec *spec = g_param_spec_internal (FLEGITA_TYPE_PARAM_OUTPUT_FILENAME,
					    name, nick, blurb, flags);
  g_param_spec_set_qdata (spec, GS_PARAM_GROUP_QUARK, (gpointer) group);
  g_param_spec_set_qdata (spec, GS_PARAM_FORMATS_QUARK, (gpointer) formats);
  gs_param_spec_set_widget_type (spec, FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET);
  return G_PARAM_SPEC (spec);
}

static void
flegita_param_output_filename_value_set_default (GParamSpec *pspec, GValue *value)
{
  g_value_set_string (value, "");
}

static gint
flegita_param_output_filename_values_cmp (GParamSpec *pspec, const GValue *a, const GValue *b)
{
  return g_ascii_strcasecmp (g_value_get_string (a),
			     g_value_get_string (b));
}

GSList*
flegita_param_output_filename_get_formats (GParamSpec *pspec)
{
  return (GSList *) g_param_spec_get_qdata (pspec, GS_PARAM_FORMATS_QUARK);
}

