/*
 * Photos - access, organize and share your photos on GNOME
 * Copyright © 2013 Red Hat, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */


#ifndef PHOTOS_PREVIEW_MODEL_H
#define PHOTOS_PREVIEW_MODEL_H

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define PHOTOS_TYPE_PREVIEW_MODEL (photos_preview_model_get_type ())

#define PHOTOS_PREVIEW_MODEL(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
   PHOTOS_TYPE_PREVIEW_MODEL, PhotosPreviewModel))

#define PHOTOS_PREVIEW_MODEL_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
   PHOTOS_TYPE_PREVIEW_MODEL, PhotosPreviewModelClass))

#define PHOTOS_IS_PREVIEW_MODEL(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
   PHOTOS_TYPE_PREVIEW_MODEL))

#define PHOTOS_IS_PREVIEW_MODEL_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
   PHOTOS_TYPE_PREVIEW_MODEL))

#define PHOTOS_PREVIEW_MODEL_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
   PHOTOS_TYPE_PREVIEW_MODEL, PhotosPreviewModelClass))

typedef struct _PhotosPreviewModel        PhotosPreviewModel;
typedef struct _PhotosPreviewModelClass   PhotosPreviewModelClass;
typedef struct _PhotosPreviewModelPrivate PhotosPreviewModelPrivate;

struct _PhotosPreviewModel
{
  GtkTreeModelFilter parent_instance;
  PhotosPreviewModelPrivate *priv;
};

struct _PhotosPreviewModelClass
{
  GtkTreeModelFilterClass parent_class;
};

GType             photos_preview_model_get_type               (void) G_GNUC_CONST;

GtkTreeModel     *photos_preview_model_new                    (GtkTreeModel *child_model);

G_END_DECLS

#endif /* PHOTOS_PREVIEW_MODEL_H */
