-- ------------------------------------------------------------------------- --
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/objects/group.adb,v $
--  Description     : Groups                                                 --
--  Author          : Michael Erdmann <Michael.Erdmann@snafu.de>             --
--  Created On      : 30-Dec-2006                                            --
--  Last Modified By: $Author: merdmann $                                    --
--  Last Modified On: $Date: 2007/02/03 14:59:52 $                           --
--  Status          : $State: Exp $                                          --
--                                                                           --
--  Copyright (C) 2006-2007 Michael Erdmann                                  --
--                                                                           --
--  GNADE is copyrighted by the persons and institutions enumerated in the   --
--  AUTHORS file. This file is located in the root directory of the          --
--  GNADE distribution.                                                      --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNADE; see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from      --
--  GNADE Ada units, or you link GNADE Ada units or libraries with other     --
--  files  to produce an executable, these  units or libraries do not by     --
--  itself cause the resulting  executable  to  be covered  by the  GNU      --
--  General  Public  License.  This exception does not however invalidate    --
--  any other reasons why  the executable file  might be covered by the      --
--  GNU Public License.                                                      --
--                                                                           --
-- ------------------------------------------------------------------------- --

with Ada.Text_IO;			use Ada.Text_IO;

with Account;				use Account;
with Person;				use Person;
with Objects;				use Objects;

with TAM.Persistent;			use TAM.Persistent;

package body Group is

   Version : constant String :=
               "$Id: group.adb,v 1.5 2007/02/03 14:59:52 merdmann Exp $";

   Membership_Rel : constant String := "Is_Member";

   ------------
   -- Create --
   ------------
   procedure Create(
      This  : in out Object;
      Owner : in Persistent.Object'Class;
      Name  : in Unbounded_String ) is
   begin
      This.Name := Name;
      Put_Object( This );

      Account.Create( This, To_String( Name ) & " Account" );

      Relate( Owner, This, "Group_Owner" );
   end Create;

   ---------
   -- Add --
   ---------
   procedure Add(
      This : in out Object;
      Item : in out Persistent.Object'Class) is
   begin
      Relate( Item, This, Membership_Rel );
   end Add;

   -------------
   -- Display --
   -------------
   procedure Display(
      This     : in out Object ) is
      Persons  : OID_Array_Type( 1..100 ) := (others=>0);
      Length   : Integer := 0;
   begin
      Put_Line("Displaying group " & To_String( This.Name ) );

      Get_References( OID(This), Membership_Rel , Persons, Length );

      for i in 1..Length loop
         declare
            A : Person.Object;
         begin
            Get_Object(A, ID => Persons(i));
            Person.Display( A );
         end ;
      end loop;
   end Display;

   -----------
   -- Query --
   -----------
   procedure Query(
      This   : in out Object;
      Owner  : in Persistent.Object'Class;
      Name   : in Unbounded_String) is
      Groups : OID_Array_Type( 1..100 );
      Length : Integer := 0;
      Found  : Boolean := False;
   begin
      Get_Related( OID(Owner), "Group_Owner", Groups, Length );

      for i in 1..Length loop
         declare
            G : Object;
         begin
            Get_Object(G, ID=>Groups(i) );
            Found := G.Name = Name;
            if Found then
               This := G;
               exit;
            end if;
         end;
      end loop;

      if not Found then
         raise Not_Existing;
      end if;

   end Query;

end Group;
