#! /bin/sh -e
### BEGIN INIT INFO
# Provides:           gmediaserver
# Required-Start:     $network $local_fs $remote_fs
# Required-Stop:      $network $local_fs $remote_fs
# Default-Start:      2 3 4 5
# Default-Stop:       0 1 6
# Short-Description:  gmediaserver UPnP media server
# Description:        gmediaserver UPnP media server
### END INIT INFO
#
# Author:    Jochen Friedrich <jochen@scram.de>
#
set -e

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/bin/gmediaserver
NAME=gmediaserver
DESC=gmediaserver

test -x $DAEMON || exit 0

# Include gmediaserver defaults if available
if [ -f /etc/default/gmediaserver ] ; then
	. /etc/default/gmediaserver
fi

case "$1" in
  start)
	echo -n "Starting $DESC: "
  	if [ "$GMEDIASERVERRUN" = "yes" ]; then
	    if [ ! -d /var/run/$NAME ]; then
		mkdir /var/run/$NAME
	    fi
	    chown nobody:nogroup /var/run/$NAME
	    start-stop-daemon --start --quiet \
	        --pidfile /var/run/$NAME/$NAME.pid \
		--chuid nobody:nogroup --exec $DAEMON \
		-- -b --pid-file=/var/run/$NAME/$NAME.pid \
		$GMEDIASERVERARGS $GMEDIASERVERDIR
	    echo "$NAME."
	fi
	;;
  stop)
	echo -n "Stopping $DESC: "
	start-stop-daemon --stop --quiet --pidfile /var/run/$NAME/$NAME.pid \
		--oknodo --exec $DAEMON
	echo "$NAME."
	;;
  #reload)
	#
	#	If the daemon can reload its config files on the fly
	#	for example by sending it SIGHUP, do it here.
	#
	#	If the daemon responds to changes in its config file
	#	directly anyway, make this a do-nothing entry.
	#
	# echo "Reloading $DESC configuration files."
	# start-stop-daemon --stop --signal 1 --quiet --pidfile \
	#	/var/run/$NAME.pid --exec $DAEMON
  #;;
  restart|force-reload)
	#
	#	If the "reload" option is implemented, move the "force-reload"
	#	option to the "reload" entry above. If not, "force-reload" is
	#	just the same as "restart".
	#
	echo -n "Restarting $DESC: "
	start-stop-daemon --stop --quiet --pidfile /var/run/$NAME/$NAME.pid \
		--exec $DAEMON
	sleep 2
  	if [ "$GMEDIASERVERRUN" = "yes" ]; then
	    if [ ! -d /var/run/$NAME ]; then
		mkdir /var/run/$NAME
	    fi
	    chown nobody:nogroup /var/run/$NAME
	    start-stop-daemon --start --quiet \
	        --pidfile /var/run/$NAME/$NAME.pid \
		--chuid nobody:nogroup --exec $DAEMON \
		-- -b --pid-file=/var/run/$NAME/$NAME.pid \
		$GMEDIASERVERARGS $GMEDIASERVERDIR
	    echo "$NAME."
	fi
	;;
  *)
	N=/etc/init.d/$NAME
	# echo "Usage: $N {start|stop|restart|reload|force-reload}" >&2
	echo "Usage: $N {start|stop|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
