
import gobject
import numpy

import glitch
import glitch.gtk
from glitch.limbo.lights import LightSwitch, DiffuseLight
from glitch.limbo.objects import Sphere
from glitch.limbo.particles import ParticleSystem
from glitch.limbo.material import Material

class Bubbles(ParticleSystem):
    def make_particles(self, n):
        a = numpy.ndarray(shape=(n, 11), dtype=numpy.float32)
        # position
        a[:,0] = numpy.random.uniform(-0.6, 0.6, n)
        a[:,1] = -1
        a[:,2] = numpy.random.uniform(-0.6, 0.6, n)
        # size
        a[:,10] = numpy.random.uniform(1, 10, n)
        # velocities
        a[:,3] = 0
        a[:,4] = 1 / a[:,10]
        a[:,5] = 0
        # accelerations
        a[:,6] = 0
        a[:,7] = 0
        a[:,8] = 0
        # time to live
        a[:,9] = numpy.random.uniform(5, 15, n)
        return a

    def draw(self, ctx):
        for (x, y, z, _dz, _dy, _dz, _ddx, _ddy, _ddz, _ttl, size) in self.particles:
            tmp = glitch.Translate(x=x, y=y, z=z, children=[
                Sphere(radius=size / 100)])
            tmp.render(ctx)

def tick():
    bubbles.step(0.2)
    camera.refresh()
    return True

if __name__ == '__main__':
    bubbles = Bubbles(100)
    camera = glitch.gtk.GtkCamera(ref=[0, 1, 0], eye=[0, 1, 1], children=[
        LightSwitch(children=[
            DiffuseLight(children=[
                Material(0.3, 0.5, 1.0, children=[bubbles])])])])

    gobject.timeout_add(1000/30,
        lambda: bubbles.step(0.2) and camera.refresh() and True)
    camera.run()


