/*
 * GkDebconf -- Help to configure packages with debconf
 * Copyleft (C) 2003 Agney Lopes Roth Ferraz <agney@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <stdio.h>
#include <gtk/gtk.h>

#include "../config.h"
#include "defines.h"
#include "debconf.h"
#include "files.h"
#include "config.h"
#include "cbs.h"


/**
 * configure_cb:
 *
 * @w: widget that contains data.
 * @data: GtkTreeSelection with the selected package.
 *
 * This is mostly a callback to run_config
 */

void
configure_cb (GtkWidget *w, gpointer data)
{
  GtkTreeSelection *selection = (GtkTreeSelection*)data;
  GtkTreeIter iter;
  GtkTreeModel *model;
  gchar *cf;

  if (gtk_tree_selection_get_selected (selection, &model, &iter))
    {
      gtk_tree_model_get (model, &iter, 0, &cf, -1);
      run_config (cf);
      g_free (cf);
    }
}
