// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// You are not authorized to perform the action.
type AccessDeniedException struct {
	Message *string

	Code   *string
	Logref *string

	noSmithyDocumentSerde
}

func (e *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccessDeniedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccessDeniedException) ErrorCode() string             { return "AccessDeniedException" }
func (e *AccessDeniedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of in-progress human reviews you have has exceeded the number
// allowed.
type HumanLoopQuotaExceededException struct {
	Message *string

	ResourceType *string
	QuotaCode    *string
	ServiceCode  *string
	Code         *string
	Logref       *string

	noSmithyDocumentSerde
}

func (e *HumanLoopQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *HumanLoopQuotaExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *HumanLoopQuotaExceededException) ErrorCode() string {
	return "HumanLoopQuotaExceededException"
}
func (e *HumanLoopQuotaExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A ClientRequestToken input parameter was reused with an operation, but at least
// one of the other input parameters is different from the previous call to the
// operation.
type IdempotentParameterMismatchException struct {
	Message *string

	Code   *string
	Logref *string

	noSmithyDocumentSerde
}

func (e *IdempotentParameterMismatchException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IdempotentParameterMismatchException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IdempotentParameterMismatchException) ErrorCode() string {
	return "IdempotentParameterMismatchException"
}
func (e *IdempotentParameterMismatchException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The input image size exceeds the allowed limit. If you are calling
// DetectProtectiveEquipment, the image size or resolution exceeds the allowed
// limit. For more information, see Guidelines and quotas in Amazon Rekognition in
// the Amazon Rekognition Developer Guide.
type ImageTooLargeException struct {
	Message *string

	Code   *string
	Logref *string

	noSmithyDocumentSerde
}

func (e *ImageTooLargeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ImageTooLargeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ImageTooLargeException) ErrorCode() string             { return "ImageTooLargeException" }
func (e *ImageTooLargeException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Amazon Rekognition experienced a service issue. Try your call again.
type InternalServerError struct {
	Message *string

	Code   *string
	Logref *string

	noSmithyDocumentSerde
}

func (e *InternalServerError) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InternalServerError) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InternalServerError) ErrorCode() string             { return "InternalServerError" }
func (e *InternalServerError) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// The provided image format is not supported.
type InvalidImageFormatException struct {
	Message *string

	Code   *string
	Logref *string

	noSmithyDocumentSerde
}

func (e *InvalidImageFormatException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidImageFormatException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidImageFormatException) ErrorCode() string             { return "InvalidImageFormatException" }
func (e *InvalidImageFormatException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Pagination token in the request is not valid.
type InvalidPaginationTokenException struct {
	Message *string

	Code   *string
	Logref *string

	noSmithyDocumentSerde
}

func (e *InvalidPaginationTokenException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidPaginationTokenException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidPaginationTokenException) ErrorCode() string {
	return "InvalidPaginationTokenException"
}
func (e *InvalidPaginationTokenException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Input parameter violated a constraint. Validate your parameter before calling
// the API operation again.
type InvalidParameterException struct {
	Message *string

	Code   *string
	Logref *string

	noSmithyDocumentSerde
}

func (e *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidParameterException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidParameterException) ErrorCode() string             { return "InvalidParameterException" }
func (e *InvalidParameterException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Amazon Rekognition is unable to access the S3 object specified in the request.
type InvalidS3ObjectException struct {
	Message *string

	Code   *string
	Logref *string

	noSmithyDocumentSerde
}

func (e *InvalidS3ObjectException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidS3ObjectException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidS3ObjectException) ErrorCode() string             { return "InvalidS3ObjectException" }
func (e *InvalidS3ObjectException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An Amazon Rekognition service limit was exceeded. For example, if you start too
// many Amazon Rekognition Video jobs concurrently, calls to start operations
// (StartLabelDetection, for example) will raise a LimitExceededException exception
// (HTTP status code: 400) until the number of concurrently running jobs is below
// the Amazon Rekognition service limit.
type LimitExceededException struct {
	Message *string

	Code   *string
	Logref *string

	noSmithyDocumentSerde
}

func (e *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *LimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *LimitExceededException) ErrorCode() string             { return "LimitExceededException" }
func (e *LimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The number of requests exceeded your throughput limit. If you want to increase
// this limit, contact Amazon Rekognition.
type ProvisionedThroughputExceededException struct {
	Message *string

	Code   *string
	Logref *string

	noSmithyDocumentSerde
}

func (e *ProvisionedThroughputExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ProvisionedThroughputExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ProvisionedThroughputExceededException) ErrorCode() string {
	return "ProvisionedThroughputExceededException"
}
func (e *ProvisionedThroughputExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// A resource with the specified ID already exists.
type ResourceAlreadyExistsException struct {
	Message *string

	Code   *string
	Logref *string

	noSmithyDocumentSerde
}

func (e *ResourceAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceAlreadyExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceAlreadyExistsException) ErrorCode() string             { return "ResourceAlreadyExistsException" }
func (e *ResourceAlreadyExistsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified resource is already being used.
type ResourceInUseException struct {
	Message *string

	Code   *string
	Logref *string

	noSmithyDocumentSerde
}

func (e *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceInUseException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceInUseException) ErrorCode() string             { return "ResourceInUseException" }
func (e *ResourceInUseException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The resource specified in the request cannot be found.
type ResourceNotFoundException struct {
	Message *string

	Code   *string
	Logref *string

	noSmithyDocumentSerde
}

func (e *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNotFoundException) ErrorCode() string             { return "ResourceNotFoundException" }
func (e *ResourceNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The requested resource isn't ready. For example, this exception occurs when you
// call DetectCustomLabels with a model version that isn't deployed.
type ResourceNotReadyException struct {
	Message *string

	Code   *string
	Logref *string

	noSmithyDocumentSerde
}

func (e *ResourceNotReadyException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNotReadyException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNotReadyException) ErrorCode() string             { return "ResourceNotReadyException" }
func (e *ResourceNotReadyException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The size of the collection exceeds the allowed limit. For more information, see
// Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition Developer
// Guide.
type ServiceQuotaExceededException struct {
	Message *string

	Code   *string
	Logref *string

	noSmithyDocumentSerde
}

func (e *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServiceQuotaExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServiceQuotaExceededException) ErrorCode() string             { return "ServiceQuotaExceededException" }
func (e *ServiceQuotaExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Amazon Rekognition is temporarily unable to process the request. Try your call
// again.
type ThrottlingException struct {
	Message *string

	Code   *string
	Logref *string

	noSmithyDocumentSerde
}

func (e *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ThrottlingException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ThrottlingException) ErrorCode() string             { return "ThrottlingException" }
func (e *ThrottlingException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// The file size or duration of the supplied media is too large. The maximum file
// size is 10GB. The maximum duration is 6 hours.
type VideoTooLargeException struct {
	Message *string

	Code   *string
	Logref *string

	noSmithyDocumentSerde
}

func (e *VideoTooLargeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *VideoTooLargeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *VideoTooLargeException) ErrorCode() string             { return "VideoTooLargeException" }
func (e *VideoTooLargeException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
